if (AjxPackage.define("Admin")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
 * <p>Contains the list of all the JavaScript files to be loaded during runtime.</p>
 *
 * <p><u>Format</u>: Similar convention to that of Java Package names relative to
 * JavaScript source location.</p>
 *
 * <p><b>NOTE</b>: Comments should be in a line of their own. NO comments are allowed
 * after the semicolon ';' as the java parser doesn't recognise the same.</p>
 *
 */
if (AjxPackage.define("zimbraAdmin.common.ZaUtil")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
 * Utility Class for the Admin Console.
 * @class ZaUtil
 *
 **/
ZaUtil = function() {};

ZaUtil.HELP_URL = "help/admin/html/";

/**
 * @param v: all the valid life time value is end with smhd
 *
 */
ZaUtil.getLifeTimeInSeconds = function (v) {
    if (AjxUtil.isLifeTime(v)) {
        var len = v.length ;
        var d = v.substr (0, len - 1);
        var p = v.substr (len - 1, len);

        if (p == "s") {
            if (v[len - 2] == 'm') {
                // millisecond support
                d = v.substr(0, len - 2);
                return d / 1000.0;
            }
            return d;
        } else if ( p == "m") {
            return d * 60 ;
        } else if (p == "h"){
            return d * 3600 ;
        } else if (p == "d") {
            return d * 216000;
        }
    } else {
        throw (new AjxException(AjxMessageFormat.format(ZaMsg.UTIL_INVALID_LIFETIME,[v])));
    }
}

ZaUtil.findValueInObjArrByPropertyName = function (arr, value, property) {
    if (!property) property = "name" ; //for ZaAccountMemberOfListView
	if (arr != null) {
        for(var i=0; i<arr.length; i++) {
            if (arr[i] && arr[i][property] == value){
                return i ;
            }
        }
    }
	return -1;
}

ZaUtil.getListItemLabel = function (arr, value)  {
   if (arr != null) {
       for(var i=0; i<arr.length; i++) {
            if (arr[i]["value"] == value){
                return arr[i]["label"] ;
            }
       }
   }
    return null ;
}

ZaUtil.findValueInArray = function (arr, value){
    if (arr != null) {
        for(var i=0; i<arr.length; i++) {
            if (arr[i] == value){
                return i ;
            }
        }	
    }
	return -1;
}

/**
 * remove the duplicate elements from an array
 */
ZaUtil.getUniqueArrayElements = function (arr) {
	var uniqueArr = [] ;
	for (var i=0; i < arr.length; i++) {
		if (ZaUtil.findValueInArray(uniqueArr, arr[i]) < 0) {
			uniqueArr.push(arr[i]);
		}
	}
	
	return uniqueArr ;
}

/**
 * return a server date time string in yyyyMMddHHmmss'Z' format
 * @param date: a Date object
 * 
 */
ZaUtil.getAdminServerDateTime = function (date, useUTC) {
	var s = AjxDateUtil.getServerDateTime(date, useUTC) ;
	//remove the T of the server string generated by AjaxTK
	return s.substring(0,8) + s.substring(9) ;
}

ZaUtil.compareObjects = function(obj1, obj2) {
	if(obj1.id==obj2.id)
		return 0;
	if (obj1.name > obj2.name)
		return 1;
	if (obj1.name < obj2.name)
		return -1;	
}

ZaUtil.deepCloneObject = function (obj, ignoredProperties) {
    var newObj = {};
    if (obj) {
        for (var key in obj) {
            if (ignoredProperties && ignoredProperties.length > 0) {
                if (ZaUtil.findValueInArray(ignoredProperties, key) >=0) {
                    continue ;
                }
            }
            var v = obj [key] ;
            if (v!= null && (v instanceof Array || typeof (v) == "object")){
                newObj [key] = ZaUtil.deepCloneObject (v) ;
            }  else {
                newObj [key] = v ;
            }
        }

    }else {
        return null ;
    }

    return newObj ;
}

/**
 * copy an array's content to another array.
 * Assume all the array elements types are primitive.
 *
 * @param srcArr
 */
ZaUtil.cloneArray = function (srcArr) {
    var resultArr = [];
    for (var i = 0; i < srcArr.length; i ++) {
        resultArr.push(srcArr[i])  ;
    }

    return resultArr ;
}

/**
 * combine the object array property values
 *
 * an example:
 * var objArr =
 * [
 *      {name: "abc"},
 *      {name:"efg}
 * ]
 *
 * ZaUtil.join(objArr, "name", ":") => "abc:efg"
 */
ZaUtil.join = function (objArray, key, delimiter) {
    if (objArray == null) return "" ;
    var strArr = [] ;
    for (var i=0; i < objArray.length; i ++) {
        strArr.push (objArray[i][key]) ;
    }
    return strArr.join(delimiter) ;
}

ZaUtil.getItemUUid = function() {
    var itemPrefix = "ZaItem";
    return Dwt.getNextId(itemPrefix);
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaEvent")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* Creates an empty event of the given type.
* @constructor
* @class
* @parameter type - the type of the source of the event
* This class represents an event that encapsulates some sort of change to a model (data).
* The event has a data type (eg conversation), an event type (eg delete), a source (the
* data object generating the event), and a hash of arbitrary information (details).
*/
ZaEvent = function(type) {

	this.type = type; //source type
	this.event = null; //event type
	this.source = null;
	this._details = null;
}

// Listener types
ZaEvent.L_MODIFY = 1;
ZaEvent.L_PICKER = 2;

// Source types (note: there are not separate types for list models)
ZaEvent.EVENT_SOURCE_INDEX = 1;
ZaEvent.S_FOLDER		= ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_TAG			= ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_CONV			= ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_MSG			= ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_ATT			= ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_CONTACT		= ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_APPT			= ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_NOTE			= ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_PICKER		= ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_SEARCH		= ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_SETTING		= ZaEvent.EVENT_SOURCE_INDEX++;

//Source types for admin
ZaEvent.S_ACCOUNT		 = ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_COS			 = ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_DOMAIN		 = ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_SERVER		 = ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_GLOBALCONFIG	 = ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_STATUS		 = ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_CLUSTER_STATUS = ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_DL 			 = ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_MTA			 = ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_ZIMLET		 = ZaEvent.EVENT_SOURCE_INDEX++;
ZaEvent.S_HOME		 = ZaEvent.EVENT_SOURCE_INDEX++;
// Event types
ZaEvent.EVENT_TYPES_INDEX = 1;
ZaEvent.E_CREATE		= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_DELETE		= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_MODIFY		= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_LOAD			= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_REMOVE		= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_REMOVE_ALL	= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_RENAME		= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_MOVE			= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_FLAGS			= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_ADD_TAG		= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_REMOVE_TAG	= ZaEvent.EVENT_TYPES_INDEX++;
ZaEvent.E_SEARCH  	    = ZaEvent.EVENT_TYPES_INDEX++;

// Public methods

ZaEvent.prototype.toString = 
function() {
	return "ZaEvent";
}

/**
* Sets the event type and source.
*
* @param event		event type
* @param source		object that generated the event (typically "this")
*/
ZaEvent.prototype.set =
function(event, source) {
	this.event = event; 
	this.source = source; 
}

/**
* Adds an arbitrary bit of info to the event.
*
* @param field		the detail's name
* @param value		the detail's value
*/
ZaEvent.prototype.setDetail =
function(field, value) {
	if(!this._details)
		this._details = new Object();
	this._details[field] = value;
}

/**
* Returns an arbitrary bit of info from the event.
*
* @param field		the detail's name
*/
ZaEvent.prototype.getDetail =
function(field) {
	if(!this._details)
		return null;
	else
		return this._details[field];
}

/**
* Sets the event details. Any existing details will be lost.
*
* @param details	a hash representing event details
*/
ZaEvent.prototype.setDetails =
function(details) {
	this._details = details ? details : new Object();
}

/**
* Returns the event details.
*/
ZaEvent.prototype.getDetails =
function() {
	return this._details;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaModel")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

ZaModel = function(init) {
 	if (arguments.length == 0) return;
	this._evtMgr = new AjxEventMgr();
}

ZaModel.getBooleanChoices = function () {
    return [
        {
            value: "TRUE",
            label: ZaMsg.Yes
        },
        {
            value: "FALSE",
            label: ZaMsg.No
        },
        {
            value: null,
            label: ZaMsg.No
        }
    ];
}

ZaModel.BOOLEAN_CHOICES= ZaModel.getBooleanChoices ;

ZaModel.getBooleanChoices1 = function () {
    return [
        {
            value: true,
            label: ZaMsg.Yes
        },
        {
            value: false,
            label: ZaMsg.No
        },
        {
            value: null,
            label: ZaMsg.No
        }
    ];
}

ZaModel.BOOLEAN_CHOICES1= ZaModel.getBooleanChoices1 ;

ZaModel.getBooleanChoices2 = function () {
    return [
        {
            value: "1",
            label: ZaMsg.Yes
        },
        {
            value: "0",
            label: ZaMsg.No
        },
        {
            value: null,
            label: ZaMsg.No
        }
    ];
}

ZaModel.BOOLEAN_CHOICES2= ZaModel.getBooleanChoices2 ;

ZaModel.getAllowChoices = function () {
	return [
        {
            value: "1",
            label: ZaMsg.Yes
        },
        {
            value: "0",
            label: ZaMsg.No
        },
        {
            value: "-1",
            label: ZaMsg.Ignored
        },
        {
            value: null,
            label: ZaMsg.No
        }
    ];
}

ZaModel.ALLOW_CHOICES = ZaModel.getAllowChoices;

ZaModel.FONT_SIZE_CHOICES = [
    {
        value: "8pt",
        label: "8pt"
    },
    {
        value: "10pt",
        label: "10pt"
    },
    {
        value: "12pt",
        label: "12pt"
    },
    {
        value: "14pt",
        label: "14pt"
    },
    {
        value: "18pt",
        label: "18pt"
    },
    {
        value: "24pt",
        label: "24pt"
    },
    {
        value: "36pt",
        label: "36pt"
    }
];

ZaModel.getFontFamilyChoices = function() {
	return [
        {
            label: ZaMsg.LBL_fontFamilySansSerif,
            value: "arial, helvetica, sans-serif"
        },
        {
            label: ZaMsg.LBL_fontFamilySerif,
            value: "times new roman, new york, times, serif"
        },
        {
            label: ZaMsg.LBL_fontFamilyWideBlock,
            value: "arial black,avant garde"
        },
        {
            label: ZaMsg.LBL_fontFamilyMonospaced,
            value: "courier new, courier, monaco, monospace, sans-serif"
        },
        {
            label: ZaMsg.LBL_fontFamilyComic,
            value: "comic sans ms, comic sans, sans-serif"
        },
        {
            label: ZaMsg.LBL_fontFamilyConsole,
            value: "lucida console, sans-serif"
        },
        {
            label: ZaMsg.LBL_fontFamilyGaramond,
            value: "garamond, new york, times, serif"
        },
        {
            label: ZaMsg.LBL_fontFamilyElegant,
            value: "georgia,serif"
        },
        {
            label: ZaMsg.LBL_fontFamilyProfessional,
            value: "tahoma, new york, times, serif"
        },
        {
            label: ZaMsg.LBL_fontFamilyTerminal,
            value: "terminal,monaco"
        },
        {
            label: ZaMsg.LBL_fontFamilyModern,
            value: "trebuchet ms,sans-serif"
        },
        {
            label: ZaMsg.LBL_fontFamilyWide,
            value: "verdana, helvetica, sans-serif"
        }
    ];
}

ZaModel.FONT_FAMILY_CHOICES = ZaModel.getFontFamilyChoices;

ZaModel.getComposeFormatChoices =   function () {
    return [
        {
            value: "text",
            label: ZaMsg.Text
        },
        {
            value: "html",
            label: ZaMsg.HTML
        }
    ];
}

ZaModel.COMPOSE_FORMAT_CHOICES = ZaModel.getComposeFormatChoices ;

ZaModel.SEND_READ_RECEIPT_ALWAYS = "always";
ZaModel.SEND_READ_RECEIPT_NEVER = "never";
ZaModel.SEND_READ_RECEIPT_PROMPT = "prompt";

ZaModel.getSendReadReceiptByChoices = function() {
    return [
        {
            value: ZaModel.SEND_READ_RECEIPT_ALWAYS,
            label: ZaMsg.SEND_READ_RECEIPT_ALWAYS
        },
        {
            value: ZaModel.SEND_READ_RECEIPT_NEVER,
            label: ZaMsg.SEND_READ_RECEIPT_NEVER
        },
        {
            value: ZaModel.SEND_READ_RECEIPT_PROMPT,
            label: ZaMsg.SEND_READ_RECEIPT_PROMPT
        }
    ];
}

ZaModel.SEND_READ_RECEPIT_CHOICES = ZaModel.getSendReadReceiptByChoices;

ZaModel.getGroupMailByChoices = function () {
    return [
        {
            value: "conversation",
            label: ZaMsg.Conversation
        },
        {
            value: "message",
            label: ZaMsg.Message
        }
    ];
}

ZaModel.GROUP_MAIL_BY_CHOICES = ZaModel.getGroupMailByChoices ;

ZaModel.getSignatureStyleChoices = function () {
    return [
        {
            value: "outlook",
            label: ZaMsg.No
        },
        {
            value: "internet",
            label: ZaMsg.Yes
        }
    ];
}

ZaModel.SIGNATURE_STYLE_CHOICES = ZaModel.getSignatureStyleChoices ;

ZaModel.getReminderChoices = function () {
    return [
        {
            value: "0",
            label: ZaMsg.never
        },
        {
            value: 1,
            label: "1"
        },
        {
            value: 5,
            label: "5"
        },
        {
            value: 10,
            label: "10"
        },
        {
            value: 15,
            label: "15"
        },
        {
            value: 20,
            label: "20"
        },
        {
            value: 25,
            label: "25"
        },
        {
            value: 30,
            label: "30"
        },
        {
            value: 45,
            label: "45"
        },
        {
            value: 50,
            label: "50"
        },
        {
            value: 55,
            label: "55"
        },
        {
            value: 60,
            label: "60"
        }
    ];
}

ZaModel.REMINDER_CHOICES = ZaModel.getReminderChoices ;

ZaModel.ErrorCode = "code";

ZaModel.ErrorMessage = "error_message";

ZaModel.currentStep = "currentStep";

ZaModel.currentTab = "currentTab";

ZaModel.getTimeChoices = function () {
    return [
        {
            value: "d",
            label: AjxMsg.days
        },
        {
            value: "h",
            label: AjxMsg.hours
        },
        {
            value: "m",
            label: AjxMsg.minutes
        },
        {
            value: "s",
            label: AjxMsg.seconds
        }
    ];
}

ZaModel.getTimeChoices1 = function () {
    return [
        {
            value: "d",
            label: AjxMsg.days
        },
        {
            value: "h",
            label: AjxMsg.hours
        }
    ];
}

ZaModel.getLongTimeChoices = function () {
    return [
        {
            value: "d",
            label: AjxMsg.days
        },
        {
            value: "w",
            label: AjxMsg.weeks
        },
        {
            value: "m",
            label: AjxMsg.months
        },
        {
            value: "y",
            label: AjxMsg.years
        }
    ];
}

/**
 * The length of one year is used to indicate manual choice
 * @returns {Array}
 */
ZaModel.getMailPollingIntervalChoices = function () {
    return [
        {
            value: "500ms",
            label: ZaMsg.LBL_asNewMailArrives
        },
        {
            value: "120s",
            label: "2 " + ZaMsg.LBL_minute
        },
        {
            value: "180s",
            label: "3 " + ZaMsg.LBL_minute
        },
        {
            value: "240s",
            label: "4 " + ZaMsg.LBL_minute
        },
        {
            value: "300s",
            label: "5 " + ZaMsg.LBL_minute
        },
        {
            value: "360s",
            label: "6 " + ZaMsg.LBL_minute
        },
        {
            value: "420s",
            label: "7 " + ZaMsg.LBL_minute
        },
        {
            value: "480s",
            label: "8 " + ZaMsg.LBL_minute
        },
        {
            value: "540s",
            label: "9 " + ZaMsg.LBL_minute
        },
        {
            value: "600s",
            label: "10 " + ZaMsg.LBL_minute
        },
        {
            value: "900s",
            label: "15 " + ZaMsg.LBL_minute
        },
        {
            value: "31536000s",
            label: ZaMsg.LBL_manual
        }
    ];
}

ZaModel.MAIL_POLLING_INTERVAL_CHOICES = ZaModel.getMailPollingIntervalChoices;

ZaModel.prototype.toString = function() {
    return "ZaModel";
}

ZaModel.prototype.addChangeListener = function(listener) {
    return this._evtMgr.addListener(ZaEvent.L_MODIFY, listener);
}

ZaModel.prototype.removeChangeListener = function(listener) {
    return this._evtMgr.removeListener(ZaEvent.L_MODIFY, listener);
}

ZaModel.setUnrecoganizedChoiceValue = function (v, choices) {
    var new_v = ZaMsg.VALUE_UNRECOGNIZED;
    var myChoices = choices ;
    if (typeof(choices) == "function") {
        myChoices = choices.call (this) ;
    }
    for (var i = 0; i < myChoices.length; i++) {
        if (v == myChoices[i].value) {
            new_v = v ;
            break ;
        }
    }
    return new_v ;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaItem
* @param app reference to the application instance
**/
ZaItem = function(iKeyName) {
	if (arguments.length == 0) return;
	this._iKeyName = iKeyName;
    this._uuid = ZaUtil.getItemUUid();
    this.rightsLoaded = false;
	ZaModel.call(this, true);

}

ZaItem.prototype = new ZaModel;
ZaItem.prototype.constructor = ZaItem;

ZaItem.loadMethods = new Object();
ZaItem.initMethods = new Object();
ZaItem.modifyMethods = new Object();
ZaItem.modifyMethodsExt = new Object();
ZaItem.createMethods = new Object();
ZaItem.removeMethods = new Object();
ZaItem.modelExtensions = new Object();
ZaItem.getRelatedMethods = new Object();

ZaItem.ACCOUNT = "account";
ZaItem.DATASOURCE = "dataSource";
ZaItem.DL = "dl";
ZaItem.GROUP = "group";
ZaItem.ALIAS = "alias";
ZaItem.RESOURCE = "calresource";
ZaItem.DOMAIN = "domain";
ZaItem.COS = "cos";
ZaItem.GLOBAL_CONFIG = "config";
ZaItem.GLOBAL_GRANT = "global";
ZaItem.SERVER = "server";
ZaItem.STATS = "stats";
ZaItem.ZIMLET = "zimlet";
ZaItem.MAILQ_ITEM = "message";
ZaItem.MAILQ = "mailque";
ZaItem.HOME = "home";
ZaItem.A_objectClass = "objectClass";
ZaItem.A_zimbraId = "zimbraId";
ZaItem.A_cn = "cn" ;
ZaItem.A_zimbraACE = "zimbraACE";
ZaItem.A_zimbraCreateTimestamp = "zimbraCreateTimestamp";

/* Translation of  the attribute names to the screen names */
ZaItem._ATTR = new Object();
ZaItem._ATTR[ZaItem.A_zimbraId] = ZaMsg.attrDesc_zimbraId;

ZaItem.ID_PATTERN = /^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$/;

ZaItem.prototype.toString = 
function() {
	if(this.name)
		return this.name;
	else if (this.id)
		return this.id;
	else
		return "ZaItem "+this.type+": name="+this.name+" id="+this.id;
}

ZaItem.compareNamesAsc = 
function(a,b) {
	var al = a.name.toLowerCase();
	var bl = b.name.toLowerCase();

	if (al < bl)
		return -1;
	if (al > bl)
		return 1;
	else
		return 0;
}

ZaItem.compareNamesDesc = 
function(a,b) {
	var al = a.name.toLowerCase();
	var bl = b.name.toLowerCase();

	if (al < bl)
		return 1;
	if (al > bl)
		return -1;
	else
		return 0;
}

ZaItem.compareDescription = 
function(a,b) {
	return ZaItem.compareAttr(a,b,"description");
}

ZaItem.compareEmailAddress = 
function(isAsc) {
	return function(object1, object2) {
		var object1Email = object1.emailAddress.toLowerCase();
		var object2Email = object2.emailAddress.toLowerCase();
	
		if (object1Email < object2Email) {
			return isAsc ? -1 : 1;
		}
	
		if (object1Email > object2Email) {
			return isAsc ? 1 : -1;
		}

		return 0;
	}
}

ZaItem.compareAttr = 
function(a, b, attr) {
    if (a.attrs[attr] == null) {
        return -1 ;
    }

    if (b.attrs[attr] == null) {
        return 1 ;    
    }

	if (a.attrs[attr] < b.attrs[attr])
		return -1;
	if (a.attrs[attr] > b.attrs[attr])
		return 1;
	else
		return 0;
}

ZaItem.compareAttrAsc = ZaItem.compareAttr

ZaItem.compareAttrDesc =
function(a, b, attr) {
	if (a.attrs[attr] == null) {
        return 1 ;
    }

    if (b.attrs[attr] == null) {
        return -1 ;    
    }

    if (a.attrs[attr] < b.attrs[attr])
		return 1;
	if (a.attrs[attr] > b.attrs[attr])
		return -1;
	else
		return 0;
}


/**
* Item Factory
**/
ZaItem.getFromType = 
function (type) {
	switch (type) {
		case ZaItem.ACCOUNT:
			return new ZaAccount();

		case ZaItem.ALIAS:
			return new ZaAlias();

		case ZaItem.DL:
            return new ZaDistributionList();

		case ZaItem.RESOURCE:
			return new ZaResource();
		
		case ZaItem.DOMAIN:
			return new ZaDomain();

		case ZaItem.COS:
			return new ZaCos();

		case ZaItem.SERVER:
			return new ZaServer();

		case ZaItem.MAILQ:
			return new ZaMTA();
		
		case ZaItem.DATASOURCE:
			return new ZaDataSource();

	}
}

ZaItem.prototype.remove = 
function () {
	//Instrumentation code start
	if(ZaItem.removeMethods[this._iKeyName]) {
		var methods = ZaItem.removeMethods[this._iKeyName];
		var cnt = methods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(methods[i]) == "function") {
				methods[i].call(this);
			}
		}
	}	
	//Instrumentation code end
}


ZaItem.prototype.refresh = 
function (skipRights,expandDefaults) {
	this.load(this.id ? "id" : null, this.id ? this.id : null,skipRights,expandDefaults);
}

ZaItem.prototype.getRelatedList =
function (parentPath) {
	//Instrumentation code start
    var ret = [];
	if(ZaItem.getRelatedMethods[this._iKeyName]) {
		var methods = ZaItem.getRelatedMethods[this._iKeyName];
		var cnt = methods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(methods[i]) == "function") {
				ret = ret.concat(methods[i].call(this, parentPath));
			}
		}
	}
    return ret;
	//Instrumentation code end
}

ZaItem.prototype.copyTo = 
function (target, fullRecursion, maxRecursion, currentRecLevel) {
	if(!currentRecLevel) {
		currentRecLevel = 1;
	} else {
		currentRecLevel++;
	}
	if(!maxRecursion) {
		maxRecursion = 4;
	}
	for(var a in this) {
		if (this[a] == null || this[a] == undefined) {
			target[a] = null;
		} else if(fullRecursion && (currentRecLevel <= maxRecursion)) {
			if(this[a] instanceof Array) {
				target[a] = [];
				ZaItem.prototype.copyTo.call(this[a],target[a],fullRecursion,maxRecursion, currentRecLevel)
			} else if(typeof(this[a]) == "object") {
				target[a] = {};
				ZaItem.prototype.copyTo.call(this[a],target[a],fullRecursion,maxRecursion, currentRecLevel)
			} else {
				target[a] = this[a];
			}
		} else {
			target[a] = this[a];
		}
	}
}

ZaItem.prototype.parseTargetsRightsFromJS = function(targetObj) {
	if(targetObj) {
		this.noAttrsAvailable = true;
		this.rights = {};
		if(targetObj.right && targetObj.right instanceof Array) {
			var rights = targetObj.right;
			for(var r in rights) {
				this.rights[rights[r].n] = true;
			}
		}
		
		if(targetObj.id)
			this.id = targetObj.id;
		
		if(targetObj.name)
			this.name = targetObj.name;

		if(!this._defaultValues)
			this._defaultValues = {attrs:{}};

		if(!this.getAttrs)
			this.getAttrs = {};

		if(!this.setAttrs)
			this.setAttrs = {};
		
		if(AjxUtil.isEmpty(targetObj.getAttrs) && AjxUtil.isEmpty(targetObj.setAttrs)) {
			this.getAttrs = null;
			return;
		}
		this.attrsToGet = [];									
		if(targetObj.getAttrs && targetObj.getAttrs instanceof Array && 
			targetObj.getAttrs[0]) {
			if(targetObj.getAttrs[0].a && targetObj.getAttrs[0].a instanceof Array) {
				var getAttrs = targetObj.getAttrs[0].a;
				this.noAttrsAvailable = false;
				for (var a in getAttrs) {
					this.getAttrs[getAttrs[a].n] = true;
					this.attrsToGet.push(getAttrs[a].n);
					if(getAttrs[a]["default"] && getAttrs[a]["default"][0] && getAttrs[a]["default"][0].v && getAttrs[a]["default"][0].v instanceof Array) {
						var cnt = getAttrs[a]["default"][0].v.length; 
						if(cnt == 1) {
							if((getAttrs[a].n == ZaDomain.A_zimbraFreebusyExchangeAuthPassword) &&
								(getAttrs[a]["default"][0].v[0]._content == "VALUE-BLOCKED")) {
								/* Value was replaced in SOAP response.  Treat as empty string so that it is clear it
								 * needs to be typed again before using "Check the settings" */
								this._defaultValues.attrs[getAttrs[a].n] = "";
							} else {
								this._defaultValues.attrs[getAttrs[a].n] = getAttrs[a]["default"][0].v[0]._content;
							}
						} else if (cnt >1) {
							this._defaultValues.attrs[getAttrs[a].n] = new Array();
							for(var i = 0; i<cnt;i++) { 
								this._defaultValues.attrs[getAttrs[a].n][i] = getAttrs[a]["default"][0].v[i]._content;
							}
						}
					}
				}
				if(!getAttrs[ZaItem.A_zimbraId] ) {
					this.attrsToGet.push(ZaItem.A_zimbraId);
				}				
			} 
			if (targetObj.getAttrs[0].all){
				this.getAttrs.all = true;
				this.noAttrsAvailable = false; 	
			}
		} 
				
		if(targetObj.setAttrs && targetObj.setAttrs instanceof Array && 
			targetObj.setAttrs[0]) {
				
			if(targetObj.setAttrs[0].a && targetObj.setAttrs[0].a instanceof Array) {
				var setAttrs = targetObj.setAttrs[0].a;
				if(!this.getAttrs)
					this.getAttrs = {};
					
				this.noAttrsAvailable = false;
				for (var a in setAttrs) {
					this.setAttrs[setAttrs[a].n] = true;
					this.getAttrs[setAttrs[a].n] = true;
					if(setAttrs[a]["default"] && setAttrs[a]["default"][0] && setAttrs[a]["default"][0].v && setAttrs[a]["default"][0].v instanceof Array) {
						var cnt = setAttrs[a]["default"][0].v.length; 
						if(cnt==1) {
							this._defaultValues.attrs[setAttrs[a].n] = setAttrs[a]["default"][0].v[0]._content;
						} else if (cnt > 1) {
							this._defaultValues.attrs[setAttrs[a].n] = new Array();
							for(var i = 0; i<cnt;i++) { 
								this._defaultValues.attrs[setAttrs[a].n][i] = setAttrs[a]["default"][0].v[i]._content;
							}
						}
					}
				}
			} 
			if(targetObj.setAttrs[0].all) {
				this.noAttrsAvailable = false;
				this.setAttrs.all = true;
				this.getAttrs.all = true; 	
			}
		} 
	}
	this.rightsLoaded = true;
}

ZaItem.prototype.initEffectiveRightsFromJS = function(resp) {
	this._defaultValues = {attrs:{}};
	if(resp && resp.target && resp.target instanceof Array) {
		this.parseTargetsRightsFromJS(resp.target[0]);
	}
}

ZaItem.prototype.loadEffectiveRights = function (by, val, expandDefaults, callback) {
	if(!this.type)
		return;

	if(AjxUtil.isUndefined(val) || AjxUtil.isNull(val))
		val = "";

	try {
		if(callback) {
			this._getEffectiveRights(by, val, expandDefaults, callback);
		} else {
			var resp = this._getEffectiveRights(by, val, expandDefaults, callback);
			this.initEffectiveRightsFromJS(resp);
		}
	} catch (ex) {
		throw (ex);
	}
}

ZaItem.RightCache = [];
ZaItem.getCacheName = function (by, val, type, expandDefaults) {
    var cacheName = by + val + " " + type;
    if (expandDefaults)
        cacheName = cacheName + "TRUE";
    else
        cacheName = cacheName + "FALSE";
    return cacheName;
}

ZaItem.inCacheProcess = function (val) {
    if (!val)
        return false;

    return ZaSettings.initializing;
}

ZaItem.prototype._getEffectiveRights = function (by, val, expandDefaults, callback) {
	var cacheName = ZaItem.getCacheName(by, val, this.type, expandDefaults);
    var inCacheProcess =  ZaItem.inCacheProcess(val);
    var resp;
    if (((!ZaItem.RightCache[cacheName])&&inCacheProcess) || !inCacheProcess) {
        var soapDoc = AjxSoapDoc.create("GetEffectiveRightsRequest", ZaZimbraAdmin.URN, null);
        if(expandDefaults) {
            soapDoc.setMethodAttribute("expandAllAttrs","getAttrs");
        }

        var elTarget = soapDoc.set("target", val);

        if(!AjxUtil.isEmpty(by))
            elTarget.setAttribute("by",by);

        elTarget.setAttribute("type",this.type);

        var elGrantee = soapDoc.set("grantee", ZaZimbraAdmin.currentUserId);
        elGrantee.setAttribute("by","id");

        var csfeParams = new Object();
        csfeParams.soapDoc = soapDoc;
        csfeParams.asyncMode = callback ? true : false;
        csfeParams.callback =  callback ? callback : null;
        
        var reqMgrParams = {} ;
        reqMgrParams.controller = (ZaApp.getInstance() && ZaApp.getInstance().getCurrentController()) ? ZaApp.getInstance().getCurrentController() : null;
        reqMgrParams.busyMsg = ZaMsg.BUSY_REQUESTING_ACCESS_RIGHTS ;
        
        try {
        	if(callback) {
        		ZaRequestMgr.invoke(csfeParams, reqMgrParams);
        	} else {
        		resp = ZaRequestMgr.invoke(csfeParams, reqMgrParams).Body.GetEffectiveRightsResponse;
                if (inCacheProcess) {
                    ZaItem.RightCache[cacheName]= resp;
                }
        	}
        } catch (ex) {
            throw (ex);
        }

    } else {
        resp = ZaItem.RightCache[cacheName];
    }
    return resp;
}

ZaItem.prototype.loadNewObjectDefaults = function (domainBy, domain, cosBy, cos) {
	if(!this.type)
		return;
		
	var soapDoc = AjxSoapDoc.create("GetCreateObjectAttrsRequest", ZaZimbraAdmin.URN, null);
	var elTarget = soapDoc.set("target", "");
	elTarget.setAttribute("type",this.type);	

	
	if(!AjxUtil.isEmpty(domain) && !AjxUtil.isEmpty(domainBy)) {
		var elDomain = soapDoc.set("domain", domain);
		elDomain.setAttribute("by",domainBy);
	}

	if(!AjxUtil.isEmpty(cos) && !AjxUtil.isEmpty(cosBy)) {
		var elCos = soapDoc.set("cos", cos);
		elCos.setAttribute("by",cosBy);
	}
	
	var csfeParams = new Object();
	csfeParams.soapDoc = soapDoc;	
	var reqMgrParams = {} ;
	reqMgrParams.controller = (ZaApp.getInstance() && ZaApp.getInstance().getCurrentController()) ? ZaApp.getInstance().getCurrentController() : null;
	reqMgrParams.busyMsg = ZaMsg.BUSY_REQUESTING_ACCESS_RIGHTS ;
	try {
		var resp = ZaRequestMgr.invoke(csfeParams, reqMgrParams ).Body.GetCreateObjectAttrsResponse;
		this.parseTargetsRightsFromJS(resp);
	} catch (ex) {
		//not implemented yet
	}	
}

ZaItem.prototype.load = function (by, val, skipRights, expandDefaults) {
	by = by ? by : "id";
	val = val ? val : this.id;
	//load rights
	if(!skipRights) {
		this.rights = {};
		this.getAttrs = {};
		this.setAttrs = {};
		this.loadEffectiveRights(by,val,expandDefaults);
	}	
	if(this.noAttrsAvailable) {
		return;
	}	
	//Instrumentation code start
	if(ZaItem.loadMethods[this._iKeyName]) {
		var methods = ZaItem.loadMethods[this._iKeyName];
		var cnt = methods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(methods[i]) == "function") {
				methods[i].call(this, by, val);
			}
		}
	}	
	//Instrumentation code end
}

/**
 * this - the current instance should be the old instance
 * @param mods: modified attributes
 * @param tmpObj: the new data object of the view
 */
ZaItem.prototype.modify = function (mods, tmpObj) {
	//Instrumentation code start
	if(ZaItem.modifyMethods[this._iKeyName]) {
		var methods = ZaItem.modifyMethods[this._iKeyName];
		var cnt = methods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(methods[i]) == "function") {
				methods[i].call(this, mods, tmpObj);

			}
		}
	}	
	//Instrumentation code end
}



/**
* Factory method
* creates a new object of class constructorFunction, then passes the new object to every method in
* ZaItem.createMethods[key] 
* @see ZaItem#createMethods
**/
ZaItem.create = function (tmpObj, constructorFunction, key) {
	var item = new constructorFunction();
	//Instrumentation code start
	if(ZaItem.createMethods[key]) {
		var methods = ZaItem.createMethods[key];
		var cnt = methods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(methods[i]) == "function") {
				methods[i].call(this, tmpObj, item);
			}
		}
	}	
	//Instrumentation code end
	return item;
}

ZaItem.prototype.initFromDom =
function(node) {
	this.name = node.getAttribute("name");
	this.id = node.getAttribute("id");
	this.attrs = new Object();
	if(!AjxUtil.isEmpty(node.nodeName))
		this.type = node.nodeName;
	
	var children = node.childNodes;
	var cnt = children.length;
	for (var i=0; i< cnt;  i++) {
		var child = children[i];
		if (child.nodeName != 'a') continue;
		var name = child.getAttribute("n");
		var pd = child.getAttribute("pd");
		if(pd && pd==1)
			continue;
			
		if (child.firstChild != null) {
			var value = child.firstChild.nodeValue;
			if (name in this.attrs) {
				var vc = this.attrs[name];
				if ((typeof vc) == "object") {
					vc.push(value);
				} else {
					this.attrs[name] = [vc, value];
				}
			} else {
				this.attrs[name] = value;
			}
		}
	}
}

ZaItem.prototype.initFromJS = 
function (obj) {
	if(!obj)
		return;

	if(obj.name)	
		this.name = obj.name;

	if(obj.id)
		this.id = obj.id;

	if (obj.isgroup == false) {
		this.isgroup = 0 ;
	}else if (obj.isgroup == true){
		this.isgroup = 1 ;
	}
	this.attrs = new Object();
	if(obj.a) {
		var len = obj.a.length;
		for(var ix = 0; ix < len; ix++) {
			if(obj.a[ix].pd)
				continue;
				
			if(!this.attrs[[obj.a[ix].n]]) {
				this.attrs[[obj.a[ix].n]] = obj.a[ix]._content;
			}else {
				if(!(this.attrs[[obj.a[ix].n]] instanceof Array)) {
					this.attrs[[obj.a[ix].n]] = [this.attrs[[obj.a[ix].n]]];
				} 
				this.attrs[[obj.a[ix].n]].push(obj.a[ix]._content);
			}
		}
	}
	if(obj._attrs) {
		for (var ix in obj._attrs) {
			if(obj._attrs[ix].pd)
				continue;
							
			if(!this.attrs[ix]) {
				this.attrs[ix] = obj._attrs[ix];
			} else {
				if(!(this.attrs[ix] instanceof Array)) {
					this.attrs[ix] = [this.attrs[ix]];
				} 
				this.attrs[ix].push(obj._attrs[ix]);
			}
		}
	}
	if(!this.attrs[ZaAccount.A_description])
		this.attrs[ZaAccount.A_description] = [];
		
	if(!(this.attrs[ZaAccount.A_description] instanceof Array)) {
		this.attrs[ZaAccount.A_description] = [this.attrs[ZaAccount.A_description]];
	}	
	
	if(!this.attrs[ZaItem.A_zimbraId] && this.id) {
		this.attrs[ZaItem.A_zimbraId] = this.id;
	}	
}

ZaItem.initAttrsFromJS =
function (obj) {
	if(!obj)
		return;

    var attrs = {} ;
	if(obj.a) {
		var len = obj.a.length;
		for(var ix = 0; ix < len; ix++) {
			if(obj.a[ix].pd)
				continue;
			
			if(!attrs[[obj.a[ix].n]]) {
				attrs[[obj.a[ix].n]] = obj.a[ix]._content;
			}else {
				if(!(attrs[[obj.a[ix].n]] instanceof Array)) {
					attrs[[obj.a[ix].n]] = [attrs[[obj.a[ix].n]]];
				}
				attrs[[obj.a[ix].n]].push(obj.a[ix]._content);
			}
		}
	}
	if(obj._attrs) {
		for (var ix in obj._attrs) {
			if(obj._attrs[ix].pd)
				continue;
							
			if(!attrs[ix]) {
				attrs[ix] = obj._attrs[ix];
			} else {
				if(!(attrs[ix] instanceof Array)) {
					attrs[ix] = [attrs[ix]];
				}
				attrs[ix].push(obj._attrs[ix]);
			}
		}
	}

    return attrs ;
}


// Adds a row to the tool tip.
ZaItem.prototype._addRow =
function(msg, value, html, idx) {
	if (value != null) {
		html[idx++] = "<tr valign='top'><td align='right' style='padding-right: 5px;'><b>";
		html[idx++] = AjxStringUtil.htmlEncode(msg);
		html[idx++] = "</b></td><td align='left'><div style='white-space:nowrap; overflow:hidden;'>";
		html[idx++] = AjxStringUtil.htmlEncode(value);
		html[idx++] = "</div></td></tr>";
	}
	return idx;
}

// Adds a row to the tool tip.
ZaItem.prototype._addAttrRow =
function(name, html, idx) {
	var value = this.attrs[name];
	if (value != null) {
		var desc = ZaItem._attrDesc(name);
		html[idx++] = "<tr valign='top'><td align='left' style='padding-right: 5px;'><b>";
		html[idx++] = AjxStringUtil.htmlEncode(desc) + ":";
		html[idx++] = "</b></td><td align='left'><div style='white-space:nowrap; overflow:hidden;'>";
		html[idx++] = AjxStringUtil.htmlEncode(value);
		html[idx++] = "</div></td></tr>";
	}
	return idx;
}

ZaItem._attrDesc = 
function(name) {
	var desc = ZaItem._ATTR[name];
	return (desc == null) ? name : desc;
}

ZaItem.prototype._init = function () {
	//Instrumentation code start
	if(ZaItem.initMethods[this._iKeyName]) {
		var methods = ZaItem.initMethods[this._iKeyName];
		var cnt = methods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(methods[i]) == "function") {
				methods[i].call(this);
			}
		}
	}	
	//Instrumentation code end
}

/**
* @param newAlias
* addAlias adds one alias to the account. Adding each alias takes separate Soap Request
**/
ZaItem.prototype.addAlias = 
function (newAlias) {
	var soapCmd  ;
	switch(this.type) {
		case ZaItem.ACCOUNT: soapCmd = "AddAccountAliasRequest" ; break ;
		case ZaItem.RESOURCE: soapCmd = "AddAccountAliasRequest" ; break ;
		case ZaItem.DL: soapCmd = "AddDistributionListAliasRequest" ; break ;
		default: throw new Error("Can't add alias for account type: " + this.type) ;				
	}
	
	var soapDoc = AjxSoapDoc.create(soapCmd, ZaZimbraAdmin.URN, null);
	soapDoc.set("id", this.id);
	soapDoc.set("alias", newAlias);	
	
	//var command = new ZmCsfeCommand();
	var params = new Object();
	params.soapDoc = soapDoc;	
	var reqMgrParams = {
		controller : ZaApp.getInstance().getCurrentController(),
		busyMsg : ZaMsg.BUSY_ADD_ALIAS
	}
	ZaRequestMgr.invoke(params, reqMgrParams);
}

/**
* @param aliasToRemove
* addAlias adds one alias to the account. Adding each alias takes separate Soap Request
**/
ZaItem.prototype.removeAlias = 
function (aliasToRemove) {
	var soapCmd  ;
	
	switch(this.type) {
		case ZaItem.ACCOUNT: soapCmd = "RemoveAccountAliasRequest" ; break ;
		case ZaItem.DL: soapCmd = "RemoveDistributionListAliasRequest" ; break ;
		default: throw new Error("Can't add alias for account type: " + account.type) ;				
	}

	var soapDoc = AjxSoapDoc.create(soapCmd, ZaZimbraAdmin.URN, null);
	soapDoc.set("id", this.id);
	soapDoc.set("alias", aliasToRemove);	
	//var command = new ZmCsfeCommand();
	var params = new Object();
	params.soapDoc = soapDoc;	
	var reqMgrParams = {
		controller : ZaApp.getInstance().getCurrentController(),
		busyMsg : ZaMsg.BUSY_REMOVE_ALIAS
	}
	ZaRequestMgr.invoke(params, reqMgrParams);	
}

ZaItem.checkInteropSettings  =
function () {

    var controller =  ZaApp.getInstance().getCurrentController() ;

    try {
        //bug 29424 - save the settings before the check
//        var oldSettingObj = controller._currentObject  ;
//        ZaItem.checkFBSettings (oldSettingObj, currentSettingObj, controller) ;
        var currentSettingObj = this.getForm().getInstance() ;
        var defaultValues = currentSettingObj._defaultValues ; //it could be the global settings for domain

       //if(window.console && window.console.log) console.log("Checking the interop settings ...") ;
       var soapCmd  = "CheckExchangeAuthRequest";
       var soapDoc = AjxSoapDoc.create(soapCmd, ZaZimbraAdmin.URN, null);
       var authEl = soapDoc.set("auth", "") ;

        var attrNames = [ZaDomain.A_zimbraFreebusyExchangeURL, ZaDomain.A_zimbraFreebusyExchangeAuthScheme,
                             ZaDomain.A_zimbraFreebusyExchangeAuthUsername, ZaDomain.A_zimbraFreebusyExchangeAuthPassword ];

        for (var i=0; i < attrNames.length; i ++ ) {
           var n = attrNames [i] ;
           var value =  currentSettingObj.attrs[n] || defaultValues.attrs[n];
           if (value == null) {
               var errorMsg ;
               if (n == ZaDomain.A_zimbraFreebusyExchangeURL) {
                   errorMsg = ZaMsg.Error_missing_exchange_url ;
               } else if (n == ZaDomain.A_zimbraFreebusyExchangeAuthScheme) {
                   errorMsg = ZaMsg.Error_missing_scheme ;
               } else if (n == ZaDomain.A_zimbraFreebusyExchangeAuthUsername) {
                   errorMsg = ZaMsg.Error_missing_exchange_username ;
               } else if (n == ZaDomain.A_zimbraFreebusyExchangeAuthPassword) {
                   errorMsg = ZaMsg.Error_missing_exchange_password ;
               }
               controller.popupErrorDialog(errorMsg);
               return ;
           } else {
               var attrName ;
               if (n == ZaDomain.A_zimbraFreebusyExchangeURL) {
                   attrName = "url" ;
               } else if (n == ZaDomain.A_zimbraFreebusyExchangeAuthScheme) {
                    attrName = "scheme" ;
               } else if (n == ZaDomain.A_zimbraFreebusyExchangeAuthUsername) {
                   attrName = "user" ;
               } else if (n == ZaDomain.A_zimbraFreebusyExchangeAuthPassword) {
                   attrName = "pass" ;
               }
               authEl.setAttribute(attrName, value ) ;
           }
        }
  
        var params = new Object();
        params.soapDoc = soapDoc;
        var reqMgrParams = {
            controller : controller ,
            busyMsg : ZaMsg.BUSY_CHECKING_INTEROP_SETTINGS
        }
        var resp = ZaRequestMgr.invoke(params, reqMgrParams).Body.CheckExchangeAuthResponse;
        
        controller.popupMsgDialog(resp.code[0]._content + "<br />" + resp.message[0]._content) ;
    }catch (e) {
        controller._handleException(e)  ;
    }
}

ZaItem.clearInteropSettings = function () {
     var currentSettingObj = this.getForm().getInstance() ;
     var attrNames = [ZaDomain.A_zimbraFreebusyExchangeURL, ZaDomain.A_zimbraFreebusyExchangeAuthScheme,
                     ZaDomain.A_zimbraFreebusyExchangeAuthUsername, ZaDomain.A_zimbraFreebusyExchangeAuthPassword,
                     ZaDomain.A_zimbraFreebusyExchangeUserOrg ] ;

    for (var i=0; i < attrNames.length; i ++ ) {
        var n = attrNames [i] ;
        this.setInstanceValue("", n) ;
    }
    var form = this.getForm();
    form.parent.setDirty(true);
    form.refresh () ;
}

//Sometimes, the admin extensions needs to modify the object value before it is set
//We can add the modifer function in the extension and it will be called by the main program
ZaItem.ObjectModifiers = {} ;
ZaItem.prototype.modifyObject =
function () {
    if(ZaItem.ObjectModifiers[this._iKeyName]) {
		var methods = ZaItem.ObjectModifiers[this._iKeyName];
		var cnt = methods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(methods[i]) == "function") {
				methods[i].call(this);
			}
		}
	}
}

/** It is used to get the object description property value.
 *  especially when it has multi-values
 *
 * @param desp
 */
ZaItem.initDescriptionItem = function () { 
    ZaItem.descriptionModelItem =  {id:"description", type: _LIST_, ref:"attrs/description",
            listItem:{type:_STRING_}
        } ;

    ZaItem.descriptionXFormItem = {
        ref:"description",  msgName:ZaMsg.NAD_Description,
        label:ZaMsg.NAD_Description, labelLocation:_LEFT_, //cssClass:"admin_xform_name_input" ,
        labelCssStyle:"vertical-align:top",
        type:_REPEAT_,
        align:_LEFT_,
        repeatInstance:"",
        showAddButton:false,
        showRemoveButton:false,
        showAddOnNextRow:false,
       //    enableDisableChecks:[ZaItem.hasWritePermission] ,
       //    visibilityChecks:[ZaItem.hasReadPermission],
        items: [
            {ref:".", type:_TEXTFIELD_,
                enableDisableChecks:[] ,
                visibilityChecks:[],
                width:"30em"}
        ]
    } ;
}

ZaItem.initDescriptionItem();

ZaItem.getDescriptionValue = function (desp) {
    if ( !desp)  desp = "";
    
    if (desp instanceof Array) {
        desp = desp.toString ();
    }

    return desp ;
}

/**
 *
 * @param entry
 * @param attrName
 * @return an new array object with the each value deep copied
 */
ZaItem.deepCloneListItem = function (sourceValue) {
   if (sourceValue == null) {
       return [];
    } else if (! (sourceValue instanceof Array)) {
       return [sourceValue] ;
    } else {
       var val = [] ;
       for (var i = 0 ; i < sourceValue.length; i ++) {
            val.push (sourceValue[i]) ;
       }
       return val ;
   }
}

/**
 * Method of XFormItem
 */
ZaItem.hasReadPermission = function (refToCheck, instance) {
	if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE')
		return true;
	
	if(!instance)
		instance = this.getInstance();
	
	if (!instance.getAttrs)
		return false;
	
	var refPath=null;
	if(refToCheck) {
		refPath=refToCheck;
	} else {
		if(!this.refPath)
			return true;
		else
			refPath=this.refPath;
	}
		
	return ((instance.getAttrs.all === true) || (instance.getAttrs[refPath] === true));
}
XFormItem.prototype.hasReadPermission = ZaItem.hasReadPermission;
OSelect1_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Checkbox_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Textfield_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Select1_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Repeat_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];

/**
 * Method of XFormItem
 */
ZaItem.hasWritePermission = function (refToCheck,instance) {
	if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE')
		return true;

	if(!instance)
		instance = this.getInstance();
	
	if (!instance.setAttrs)
		return false;
	
	var refPath=null;
	if(refToCheck) {
		refPath=refToCheck;
	} else {
		if(!this.refPath)
			return true;
		else
			refPath=this.refPath;
	}
		
	return ((instance.setAttrs.all === true) || (instance.setAttrs[refPath] === true));
}


XFormItem.prototype.hasWritePermission = ZaItem.hasWritePermission;
Textfield_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
OSelect1_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Checkbox_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Select1_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Repeat_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];

/**
 * Method of XFormItem
 */
ZaItem.hasRight = function (right, instance) {
	if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE')
		return true;
		
	if(!instance)
		instance = this.getInstance();

	if(!right)
		return true;
	
	if(!instance.rightsLoaded && instance.id && instance.loadEffectiveRights) {
		instance.loadEffectiveRights("id", instance.id, true);
	}
	
	if (!instance.rights)
		return false;
	
		
	return (instance.rights[right] === true);
}
XFormItem.prototype.hasRight = ZaItem.hasRight;

ZaItem.hasAnyRight = function (rights, instance) {
	if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE')
		return true;

	if(!instance)
		instance = this.getInstance();

	if (!instance.rights)
		return false;

    if (!rights)
        return true;

    if (!rights instanceof Array)
        rights = [rights];

    for (var i = 0; i < rights.length; i++) {
        if (instance.rights[rights[i]] === true) {
            return true;
        }
    }
    return false;
}
XFormItem.prototype.hasAnyRight = ZaItem.hasAnyRight;

ZaItem.adminHasAnyRight = function (rights) {
    if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE') {
        return true;
    }

    if (!rights) {
        return true;
    }

    if (!rights instanceof Array) {
        rights = [rights];
    }

    var adminAccount = new ZaAccount();
    adminAccount.load(null, ZaZimbraAdmin.currentAdminId, false, true);

    if (!adminAccount.rights) {
        return false;
    }

    for (var i = 0; i < rights.length; i++) {
        if (adminAccount.rights[rights[i]] === true) {
            return true;
        }
    }

    return false;
}

ZaItem.formatServerTime = function(serverStr) {
	if(serverStr) {
		var regex = /(\d{14})\.\d{3}Z/;
		serverStr = serverStr.replace(regex, '$1Z');
		var ajxTKServerStr = serverStr.substring(0,8) + "T" + serverStr.substring(8) ;
		var curDate = AjxDateUtil.parseServerDateTime(ajxTKServerStr);	
        var formatter = AjxDateFormat.getDateTimeInstance(AjxDateFormat.LONG) ;
      	return formatter.format(curDate) ;
	} else {
		return "";
	}	
}

ZaItem.getZeroIsUnlimitedItem = function () {
    var item= { type: _DWT_ALERT_,
//              containerCssStyle: "padding-top:20px;width:400px;",
              style: DwtAlert.INFORMATION,
              iconVisible: true,
              content: ZaMsg.NAD_ZERO_UNLIMETED
            } ;
    return item ;
}

/**
 * Returns the copyright information for the about screen
 *
 * @return {string} copyright string with the end year information
 */
ZaItem.getAboutScreenCopyright = function() {
    var version = ZaServerVersionInfo.version || 'N/A';
    var release = ZaServerVersionInfo.release || 'N/A';
    return AjxMessageFormat.format(ZabMsg.aboutScreenCopyright, [version, release, AjxDateUtil.getYearStr()]);
}

/**
 * Returns the copyright information for the login screen and the subsequent splash screen
 *
 * @return {string} copyright string with the end year information
 */
ZaItem.getSplashScreenCopyright = function() {
	return AjxMessageFormat.format(ZabMsg.splashScreenCopyright, [AjxDateUtil.getYearStr()]);
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaId")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
 * @overview
 * This file contains ids.
 * 
 */

/**
 * Constructor
 * 
 * @author Conrad Damon
 */
ZaId = function() {};


/* Element IDs, and functions to generate them */


// widget types (used to prefix IDs)
/**
 * Defines the "generic element" widget type prefix.
 */
ZaId.WIDGET				= "z";			// generic element
/**
 * Defines the "view within content area" widget type prefix.
 */
ZaId.WIDGET_VIEW			= "zv";			// view within content area
/**
 * Defines the "toolbar" widget type prefix.
 */
ZaId.WIDGET_TOOLBAR			= "ztb";		// toolbar
/**
 * Defines the "button" widget type prefix.
 */
ZaId.WIDGET_BUTTON			= "zb";			// button
/**
 * Defines the "text input or textarea" widget type prefix.
 */
ZaId.WIDGET_INPUT			= "zi";			// text input or textarea
/**
 * Defines the "menu" widget type prefix.
 */
ZaId.WIDGET_MENU			= "zm";			// menu
/**
 * Defines the "menu item" widget type prefix.
 */
ZaId.WIDGET_MENU_ITEM			= "zmi";		// menu item
/**
 * Defines the "dropdown select" widget type prefix.
 */
ZaId.WIDGET_SELECT			= "zs";			// dropdown select
/**
 * Defines the "collection of overview" widget type prefix.
 */
ZaId.WIDGET_OVERVIEW_CNTR		= "zovc";		// collection of overviews
/**
 * Defines the "collection of tree views" widget type prefix.
 */
ZaId.WIDGET_OVERVIEW			= "zov";		// collection of tree views
/**
 * Defines the "tree view" widget type prefix.
 */
ZaId.WIDGET_TREE			= "zt";			// tree view
/**
 * Defines the "root tree item" widget type prefix.
 */
ZaId.WIDGET_TREE_ITEM_HDR		= "ztih";		// root tree item
/**
 * Defines the "tree item (node)" widget type prefix.
 */
ZaId.WIDGET_TREE_ITEM			= "zti";		// tree item (node)
/**
 * Defines the "tab button" widget type prefix.
 */
ZaId.WIDGET_TAB				= "ztab";		// tab button
/**
 *  * Defines the "tab view" widget type prefix.
 *   */
ZaId.WIDGET_TAB_VIEW                    = "ztabv";               // tab view

/**
 *  * Defines the "dialog" widget type prefix.
 *   */
ZaId.WIDGET_DLG                         = "zdlg";               //  dialog

/**
 *  * Defines the "dialog view " widget type prefix.
 *   */
ZaId.WIDGET_DLG_VIEW                    = "zdlgv";               // dialog view

/**
 * Defines the "dialog button" widget type prefix.
 */
ZaId.WIDGET_DLG_BUTTON			= "zdlgb";		//  dialog button

/**
 * Defines the "search panel view" widget type prefix.
 */
ZaId.WIDGET_SEARCH_VIEW			= "zschv";		// view within search panel



/* Preset IDs */


/*
 * Container IDs defined by the skin.
 * 
 * These must match what's in skin.html. They are used by ZmAppViewMgr to visually
 * match components to the containers in which they should be positioned. 
 */
ZaId.SKIN_APP_BOTTOM_TOOLBAR			= "skin_container_app_bottom_toolbar";
ZaId.SKIN_APP_CHOOSER				= "skin_container_app_chooser";
ZaId.SKIN_APP_MAIN_FULL				= "skin_container_app_main_full";
ZaId.SKIN_APP_MAIN				= "skin_container_app_main";
ZaId.SKIN_APP_MAIN_ROW_FULL			= "skin_tr_main_full";
ZaId.SKIN_APP_MAIN_ROW				= "skin_tr_main";
ZaId.SKIN_APP_TOP_TOOLBAR			= "skin_container_app_top_toolbar";
ZaId.SKIN_LINKS					= "skin_container_links";
ZaId.SKIN_LOGO					= "skin_container_logo";
ZaId.SKIN_QUOTA_INFO				= "skin_container_quota";
ZaId.SKIN_SASH					= "skin_container_tree_app_sash";
ZaId.SKIN_SEARCH_BUILDER			= "skin_container_search_builder";
ZaId.SKIN_SEARCH_BUILDER_TOOLBAR		= "skin_container_search_builder_toolbar";
ZaId.SKIN_SEARCH_BUILDER_TR			= "skin_tr_search_builder";
ZaId.SKIN_SEARCH				= "skin_container_search";
ZaId.SKIN_PEOPLE_SEARCH				= "skin_container_people_search";
ZaId.SKIN_SHELL					= "skin_outer";
ZaId.SKIN_SPACING_SEARCH			= "skin_spacing_search";
ZaId.SKIN_SPLASH_SCREEN				= "skin_container_splash_screen";
ZaId.SKIN_STATUS				= "skin_container_status";
ZaId.SKIN_STATUS_ROW				= "skin_tr_status";
ZaId.SKIN_TREE_FOOTER				= "skin_container_tree_footer";
ZaId.SKIN_TREE					= "skin_container_tree";
ZaId.SKIN_USER_INFO				= "skin_container_username";
ZaId.SKIN_TASKBAR				= "skin_container_taskbar";
ZaId.SKIN_FOOTER				= "skin_footer";
ZaId.SKIN_AD					= "skin_adsrvc";


/* Literal IDs */


/*
 * Top-level components. These are elements that are placed directly into skin containers.
 */
ZaId.SHELL					= "z_shell";			// the main shell
ZaId.LOADING_VIEW				= "z_loading";			// "Loading..." view
ZaId.MAIN_SASH					= "z_sash";				// sash between overview and content
ZaId.BANNER					= "z_banner";			// logo (at upper left by default)
ZaId.SEARCH_TOOLBAR				= "ztb_search";			// search toolbar
ZaId.PEOPLE_SEARCH_TOOLBAR			= "ztb_people_search";	// people search toolbar
ZaId.USER_NAME					= "z_userName";			// account name
ZaId.USER_QUOTA					= "z_userQuota";		// quota
ZaId.PRESENCE					= "z_presence";			// presence
ZaId.TASKBAR					= "z_taskbar";			// taskbar
ZaId.NEW_FOLDER_BUTTON				= "zb_newFolder";		// New Folder button on current app toolbar
ZaId.STATUS_VIEW				= "z_status";			// status view (shows toast)
ZaId.TOAST					= "z_toast";			// toast
ZaId.APP_CHOOSER				= "ztb_appChooser";		// app chooser toolbar
/* New UI*/
ZaId.CURRENT_APP_BAR         = "zb_currentApp";

/* Functions for generating IDs */


/**
 * Generates the ID for a toolbar.
 * 
 * <p>
 * Examples: <code>ztb|CLV ztb|TV|Nav ztb|CV|Inv</code>
 * </p>
 * 
 * @param 	{String}	context	the toolbar context (ID of owning view)
 * @param	{constant}	tbType	the type of toolbar (for example, invite or nav)
 * @return	{String}	the id
 */
ZaId.getToolbarId =
function(context, tbType) {
	return DwtId._makeId(ZaId.WIDGET_TOOLBAR, context, tbType);
};

/**
 * Generates the ID for a button. Intended for use with the top toolbar, nav toolbar,
 * and invite toolbar.
 * 
 * @param 	{String}	context	the toolbar context (ID of owning view)
 * @param 	{constant}	op	the button operation
 * @param 	{constant}	tbType	the type of toolbar (eg invite or nav)
 * @return	{String}	the id
 */
ZaId.getButtonId =
function(context, op, tbType) {
	return DwtId._makeId(ZaId.WIDGET_BUTTON, context, tbType, op);
};

/**
 * Generates the ID for an action menu.
 * 
 * @param 	{String}	context		the menu context (eg ID of owning view, or app)
 * @param 	{constant}	menuType	the type of menu (eg participant)
 * @return	{String}	the id
 */
ZaId.getMenuId =
function(context, menuType) {
	return DwtId._makeId(ZaId.WIDGET_MENU, context, menuType);
};

/**
 * Generates the ID for a menu item in an action menu.
 * 
 * @param 	{String}	context		the menu context
 * @param 	{constant}	op		the menu operation
 * @param 	{constant}	menuType	the type of menu (eg participant)
 * @return	{String}	the id
 */
ZaId.getMenuItemId =
function(context, op, menuType) {
	return DwtId._makeId(ZaId.WIDGET_MENU_ITEM, context, menuType, op);
};

/**
 * Generates the ID for an overview container.
 *
 * @param 	{String}	overviewContainerId	the overview container ID
 * @return	{String}	the id
 */
ZaId.getOverviewContainerId =
function(overviewContainerId) {
	return DwtId._makeId(ZaId.WIDGET_OVERVIEW_CNTR, overviewContainerId);
};

/**
 * Generates the ID for an overview.
 * 
 * @param 	{String}	overviewId	the overview ID
 * @return	{String}	the id
 */
ZaId.getOverviewId =
function(overviewId) {
	return DwtId._makeId(ZaId.WIDGET_OVERVIEW, overviewId);
};

/**
 * Generates the ID for a tree within an overview.
 * 
 * @param 	{String}	overviewId	the overview ID
 * @param 	{String}	orgType 	the organizer type (see <code>ZaId.ORG_</code> constants)
 * @return	{String}	the id
 */
ZaId.getTreeId =
function(overviewId, orgType) {
	return DwtId._makeId(ZaId.WIDGET_TREE, overviewId, orgType);
};

/**
 * Generates a tree item ID 
 * 
 * @param 	{String}	overviewId	the unique ID for overview
 * @param 	{ZmOrganizer}	organizerId	the ID of the data object backing tree item
 * @param 	{constant}	type		the organizer type (for headers only)
 * @return	{String}	the id
 */
ZaId.getTreeItemId =
function(overviewId, organizerId, type, indexNo) {
	//if (!organizerId && !type) { return; }
	if (type) {
		return DwtId._makeId(ZaId.WIDGET_TREE_ITEM_HDR, overviewId, organizerId, indexNo);
	} else {
		return DwtId._makeId(ZaId.WIDGET_TREE_ITEM, overviewId, organizerId, indexNo);
	}
};

/**
 * Generates an ID for a view 
 * 
 * @param 	{constant}	viewId		the view identifier 
 * @param 	{constant}	component	the component identifier 
 * @param 	{constant}	context		the ID of owning view
 * @return	{String}	the id
 */
ZaId.getViewId =
function(viewId, component, context) {
	var id = DwtId._makeId(ZaId.WIDGET_VIEW, context, viewId);
	return component ? [id, component].join("") : id;
};

/**
 * Generates an ID for a dialog
 * 
 * @param       {constant}      component       the component identifier
 * @param       {constant}      context         the ID of owning view
 * @return      {String}        the id
 */
ZaId.getDialogId =
function(component, context) {
	return DwtId._makeId(ZaId.WIDGET_DLG, component, context);
};

/**
 * Generates an ID for a dialog view
 * 
 * @param       {constant}      component       the component identifier
 * @param       {constant}      context         the ID of owning view
 * @return      {String}        the id
 */
ZaId.getDialogViewId =
function(component, context) {
	return DwtId._makeId(ZaId.WIDGET_DLG_VIEW, component, context);
};


/**
 * Generates an ID for a dialog button
 * 
 * @param       {constant}      component       the component identifier
 * @param       {constant}      context         the ID of owning view
 * @return      {String}        the id
 */
ZaId.getDialogButtonId =
function(component, context) {
	return DwtId._makeId(ZaId.WIDGET_DLG_BUTTON, component, context);
};



/**
 * Generates an ID for the compose view
 * 
 * @param 	{constant}	component	component identifier 
 * @return	{String}	the id
 */
ZaId.getComposeViewId =
function(component) {
	var id = DwtId._makeId(ZaId.WIDGET, ZaId.COMPOSE_VIEW);
	return component ? [id, component].join("") : id;
};

/**
 * Generates an ID for a tab (actually the tab button in the tab bar).
 * 
 * @param 	{constant}	context		the owning view identifier 
 * @param 	{String}	tabName		[string]name of tab
 * @return	{String}	the id
 */
ZaId.getTabId =
function(context, tabName) {
	return DwtId._makeId(ZaId.WIDGET_TAB, context, tabName);
};


/**
 * Generates an ID for a tab view.
 * 
 * @param 	{constant}	context		the owning view identifier 
 * @param 	{String}	tabName		[string]name of tab
 * @return	{String}	the id
 */
ZaId.getTabViewId =
function(context, tabName) {
	return DwtId._makeId(ZaId.WIDGET_TAB_VIEW, context, tabName);
};


/**
 * Generates an ID for a pref page tab.
 *
 * @param	{String}	tabKey		the tab key
 * @return	{String}	the id
 */
ZaId.getPrefPageId = function(tabKey) {
	return "PREF_PAGE_"+tabKey;
};


/**
 * Generates an ID for a search view.
 * 
 * @param 	{constant}	context		the owning view identifier 
 * @param 	{String}	tabName		[string]name of tab
 * @return	{String}	the id
 */
ZaId.getSearchViewId =
function(context, tabName) {
	return DwtId._makeId(ZaId.WIDGET_SEARCH_VIEW, context, tabName);
};



/*
 * 
 * Gettings IDs for different areas of Admin console
 * 
 */

/*
 * -----------
 *    App 
 * -----------
 * 
 */

// context
ZaId.APP	= "App";

/*
 * ---------
 * Overviews
 * ---------
 * 
 */


/* address */
ZaId.TREEITEM_ACCOUNT		= "ACCOUNT";
ZaId.TREEITEM_ALIASES		= "ALIASES";
ZaId.TREEITEM_DL		= "DL";
ZaId.TREEITEM_RESOURCES		= "RESOURCES";
/* configuration */
ZaId.TREEITEM_COS		= "COS";
ZaId.TREEITEM_DOMAINS		= "DOMAINS";
ZaId.TREEITEM_SERVERS		= "SERVERS";
ZaId.TREEITEM_ZIMLETS		= "ZIMLETS";
ZaId.TREEITEM_ADMINEXT		= "AEMINEXT";
ZaId.TREEITEM_GSET		= "GSET";
ZaId.TREEITEM_RIGHTS		= "RIGHTS";
ZaId.TREEITEM_GACL		= "GACL";
/* monitoring */
ZaId.TREEITEM_SSTATUS		= "SSTATUS";
ZaId.TREEITEM_SSTATIS		= "SSTATIS";
/* tools */
ZaId.TREEITEM_MQUEUE		= "MQUEUE";
ZaId.TREEITEM_BACKUPS		= "BACKUPS";
ZaId.TREEITEM_DATAINPUT		= "DATAINPUT";
ZaId.TREEITEM_CERT		= "CERT";
ZaId.TREEITEM_SEARCHMAIL	= "SEARCHMAIL";
/* search */



/*
 * ----------
 *  panel 
 * ----------
 *
 */

// Overview panel
ZaId.PANEL_APP			= "AppAdmin";
ZaId.PANEL_ADDRESS		= "ADDRESS";
ZaId.PANEL_CONFIGURATION	= "CONFIGURATION";
ZaId.PANEL_MONITORING		= "MONITORING";
ZaId.PANEL_TOOLS		= "TOOLS";
ZaId.PANEL_SEARCHS		= "SEARCHOPTS";


// search panel
ZaId.PANEL_APPSEARCH		= "AppSearch";
ZaId.SEARCH_VIEW		= "SEARCHV";
ZaId.SEARCH_QUERY		= "SEARCH_QUERY";



/* 
 * ------------
 * List  View 
 * ------------
 *
 * */

ZaId.VIEW_ACCTLIST              = "ACLV";
ZaId.VIEW_ALASLIST		= "ALLV";
ZaId.VIEW_DLLIST		= "DLLV";  // redundant
ZaId.VIEW_RESLIST		= "RESLV";

ZaId.VIEW_COSLIST		= "COSLV";
ZaId.VIEW_DMLIST		= "DMLV";
ZaId.VIEW_SERLIST		= "SERLV";
ZaId.VIEW_ZIMLIST		= "ZIMLV";
ZaId.VIEW_AELIST		= "AELV";
ZaId.VIEW_GSETLIST		= "GSLV";  // redundant
ZaId.VIEW_RIGHTLIST		= "RLV";
ZaId.VIEW_GACLIST		= "ACLV";

ZaId.VIEW_STATUSLIST		= "STALV"; 
ZaId.VIEW_STATISLIST		= "STSLV";

ZaId.VIEW_MQLIST		= "MQLV";  // redundant
ZaId.VIEW_BKLIST		= "BKLV";
ZaId.VIEW_DILIST		= "DILV";
ZaId.VIEW_CRTLIST		= "CRTLV";
ZaId.VIEW_SMLIST		= "SMLV";
ZaId.VIEW_SCHLIST		= "SCHLV";

ZaId.VIEW_MTALIST		= "MTALV";

ZaId.VIEW_MEMLIST		= "MEMLV";  // memberOf list view

/* View */
ZaId.VIEW_ACCT              	= "ACCTV";
ZaId.VIEW_ALAS              	= "ALASV";
ZaId.VIEW_DL                	= "DLV";
ZaId.VIEW_RES               	= "RESV";

ZaId.VIEW_COS               	= "COSV";
ZaId.VIEW_DOMAIN                = "DMV";
ZaId.VIEW_SERVER               	= "SERV";
ZaId.VIEW_ZIMLET               	= "ZIMV";
ZaId.VIEW_ADEXT                	= "AEV";
ZaId.VIEW_GSET              	= "GSV";
ZaId.VIEW_RIGHT             	= "RTV";
ZaId.VIEW_GACL               	= "GACV";

ZaId.VIEW_STATUS            	= "STAV";
ZaId.VIEW_STATIS            	= "STSV";

ZaId.VIEW_MQ                	= "MQV";  //redundant
ZaId.VIEW_BK                	= "BKV";
ZaId.VIEW_DI                	= "DIV";
ZaId.VIEW_CRT               	= "CRTV";
ZaId.VIEW_SM                	= "SMV";
ZaId.VIEW_SCH               	= "SCHV";

ZaId.VIEW_MTA			= "MTAV";

ZaId.VIEW_HOME          = "HOMEV";
/* Operation  */
ZaId.OP_NEW_ACCT		= "NEW_ACCT";
ZaId.OP_EDIT_ACCT		= "EDIT_ACCT";
ZaId.OP_DEL_ACCT		= "DEL_ACCT";
ZaId.OP_CHD_ACCTPWD		= "CHD_ACTPWD";

/* click type */
ZaId.OP_CLICK_LEFT		= "LEFT_CLICK";
ZaId.OP_CLICK_RIGHT		= "RIGHT_CLICK";
ZaId.OP_CLICK_DBLEFT 		= "DBLEFT_CLICK";


/* Menu type */
ZaId.MENU_DROP			= "MENU_DROP";
ZaId.MENU_POP			= "MENU_POP";


/* tab */
ZaId.TAB_GROUP			= "TAB_GROUP";

ZaId.TAB_MAIN			= "MAIN_TAB";
ZaId.TAB_ACCT_MANAGE		= "ACCT_MANAGE";
ZaId.TAB_ACCT_EDIT		= "ACCT_EDIT";
ZaId.TAB_ALIAS_MANAGE           = "ALIAS_MANAGE";
ZaId.TAB_ALIAS_EDIT             = "ALIAS_EDIT";
ZaId.TAB_DL_MANAGE            	= "DL_MANAGE";
ZaId.TAB_DL_EDIT              	= "DL_EDIT";
ZaId.TAB_RES_MANAGE            	= "RES_MANAGE";
ZaId.TAB_RES_EDIT              	= "RES_EDIT";

ZaId.TAB_COS_MANAGE		= "COS_MANAGE";
ZaId.TAB_COS_EDIT		= "COS_EDIT";
ZaId.TAB_DOMAIN_MANAGE          = "DOMAIN_MANAGE";
ZaId.TAB_DOMAIN_EDIT            = "DOAMIN_EDIT";
ZaId.TAB_SERVER_MANAGE          = "SERVER_MANAGE";
ZaId.TAB_SERVER_EDIT            = "SERVER_EDIT";
ZaId.TAB_ZIM_MANAGE             = "ZIMLET_MANAGE";
ZaId.TAB_ZIM_EDIT               = "ZIMLET_EDIT";
ZaId.TAB_AE_MANAGE              = "ADMEXT_MANAGE";
ZaId.TAB_AE_EDIT                = "ADMEXT_EDIT";
ZaId.TAB_STATUS_MANAGE          = "STATUS_MANAGE";
ZaId.TAB_STATUS_EDIT            = "STATUS_EDIT";
ZaId.TAB_MTX_MANAGE             = "MTX_MANAGE";
ZaId.TAB_MTX_EDIT               = "MTX_EDIT";
ZaId.TAB_SEARCH_MANAGE          = "SEARCH_MANAGE";
ZaId.TAB_SEARCH_EDIT            = "SEARCH_EDIT";
ZaId.TAB_GSET_EDIT              = "GSET_EDIT";

ZaId.TAB_DOWNLOADS		= "DOWNLOADS";
ZaId.TAB_VIEWRIGHTS		= "VIEW_RIGHTS";

ZaId.TAB_UNDEF			= "UNDEFINE";


/* tab view */
/*
ZaId.TABV_ACCT_EDIT              = "V_ACCT_EDIT";
ZaId.TABV_DL_EDIT                = "V_DL_EDIT";
ZaId.TABV_RES_EDIT               = "V_RES_EDIT";
ZaId.TABV_COS_EDIT               = "V_COS_EDIT";
ZaId.TABV_DOMAIN_EDIT            = "V_DOAMIN_EDIT";
ZaId.TABV_SERVER_EDIT            = "V_SERVER_EDIT";
ZaId.TABV_ZIM_EDIT               = "V_ZIMLET_EDIT";
ZaId.TABV_AE_EDIT                = "V_ADMEXT_EDIT";
ZaId.TABV_STATUS_EDIT            = "V_STATUS_EDIT";
ZaId.TABV_MTX_EDIT               = "V_MTX_EDIT";
ZaId.TABV_GSET_EDIT              = "V_GSET_EDIT";
*/



/* Dialog */
ZaId.DLG_NEW_ACCT		= "NEW_ACCT";
ZaId.DLG_NEW_ALIAS              = "NEW_ALIAS";
ZaId.DLG_EDIT_ALIAS             = "EDIT_ALIAS";
ZaId.DLG_EDIT_SIGNATURE         = "EDIT_SIGNATURE";
ZaId.DLG_NEW_RES               	= "NEW_RES";
ZaId.DLG_NEW_ADMIN              = "NEW_ADMIN";
ZaId.DLG_NEW_DOMAIN             = "NEW_DOMAIN";
ZaId.DLG_ZIM_DEPLOY             = "ZIM_DEPLOY";
ZaId.DLG_AUTH_CONFIG            = "AUTH_CONFIG";
ZaId.DLG_AUTPROV_CONFIG         = "AUTOPROV_CONFIG";
ZaId.DLG_AUTPROV_MANUAL         = "AUTOPROV_MANUAL";
ZaId.DLG_AUTPROV_MANUAL_PWD     = "AUTOPROV_MANUAL_PWD";
ZaId.DLG_AUTH_SPNEGO            = "AUTH_SPNEGO";
ZaId.DLG_AUTH_SPNEGO_UA         = "AUTH_SPNEGO_UA";
ZaId.DLG_NEW_DL                 = "NEW_DL";
ZaId.DLG_NEW_COS                = "NEW_COS";
ZaId.FLUSH_SERVER_CACHE			= "FLUSH_SERVER_CACHE";

ZaId.DLG_MSG			= "MSG";
ZaId.DLG_ERR			= "ERR";


ZaId.DLG_UNDEF			= "UNDEFINE";

/* controller */

ZaId.CTR_GLOBAL			= "GLOBAL_"
ZaId.CTR_PREFIX			= "CTR_";

// ZaId.CTR_PREFIX should be used like the follows:
// e.g.
// ZaId.CTR_VIEW_ACCT = ZaId.CTR_PREFIX + ZaId.VIEW_ACCT
// ZaId.CTR_VIEW_ACCTLIST = ZaId.CTR_PREFIX + ZaId.VIEW_ACCTLIST 

ZaId.CTR_UNDEF			= "CTR_UNDEFINE";
}
if (AjxPackage.define("zimbraAdmin.common.ZaIPUtil")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Created by IntelliJ IDEA.
 * User: mingzhang
 * Date: 3/28/12
 * Time: 4:26 AM
 * To change this template use File | Settings | File Templates.
 */

ZaIPUtil = function () {

}

ZaIPUtil.MASK_RE = /^\d{1,3}$/;
ZaIPUtil.IP4_CHUNK_RE = ZaIPUtil.MASK_RE;
ZaIPUtil.IP6_CHUNK_RE = /^([A-Fa-f0-9]{1,4})$/;
ZaIPUtil.IPMIX_PREFIX_RE = /^::(f|F){4}:$/;
// The following doesn't need localization
ZaIPUtil.ERROR_CIDR_NULL = "ERROR_CIDR_NULL";
ZaIPUtil.ERROR_MASK_NULL = "ERROR_MASK_NULL";
ZaIPUtil.ERROR_MASK_FORMAT = "ERROR_MASK_FORMAT";
ZaIPUtil.ERROR_IP_NULL = "ERROR_IP_NULL";
ZaIPUtil.ERROR_IP_FORMAT = "ERROR_IP_FORMAT";
ZaIPUtil.ERROR_IP_VER_DISMATCH = "ERROR_IP_VER_DISMATCH";
ZaIPUtil.isValidCIDR = function (cidrStr) {
    if (!cidrStr)
        throw ZaIPUtil.ERROR_CIDR_NULL;

    var maskIndex = cidrStr.indexOf("/");
    if (maskIndex == -1) {
        throw ZaIPUtil.ERROR_MASK_NULL;
    }
    var ipPart = cidrStr.substring(0, maskIndex);
    var maskPart = cidrStr.substring(maskIndex + 1);
    if (!ZaIPUtil.MASK_RE.test(maskPart)) {
        throw ZaIPUtil.ERROR_MASK_FORMAT;
    }
    var maskData = parseInt (maskPart, 10);
    var ipData = ZaIPUtil.isValidIP (ipPart);
    if (!ipData)
        return "";

    if (ipData.ver == ZaIPData.v4) {
        if (maskData > 32)
            throw ZaIPUtil.ERROR_MASK_FORMAT;
    } else {
        if (maskData > 128)
            throw ZaIPUtil.ERROR_MASK_FORMAT;
    }

    return new ZaCIDRData(ipData, maskData, cidrStr);

}


// TODO  Add more check for parameter
// for nifs data we get from server and can't be modified in admin console.
// We will assume the input is valid here
ZaIPUtil.getNetworkAddr = function (ipData, maskData) {
    var totalBit;
    var bitPerChunk;
    if (ipData.ver == ZaIPData.v4) {
        totalBit = 32;
        bitPerChunk = 8;
    } else if (ipData.ver == ZaIPData.v6){
        totalBit = 128;
        bitPerChunk = 16;
    }

    var allOneLength = Math.floor(maskData / bitPerChunk);
    var highOneBitNum = maskData % bitPerChunk;
    var nonZeroChunk =  ZaIPUtil.getNonZeroNum(highOneBitNum, bitPerChunk);
    var netIPData = [];
    for (var i = 0; i < ipData.fmtArr.length; i++) {
        if (allOneLength > 0) {
            netIPData.push(ipData.fmtArr[i]);
            allOneLength --;
        } else if (nonZeroChunk != 0) {
            var tmp = ipData.fmtArr[i] & nonZeroChunk;
            netIPData.push(tmp);
            nonZeroChunk = 0;
        } else {
            netIPData.push(0);
        }
    }

    return new ZaCIDRData(new ZaIPData(netIPData, ipData.ver, undefined, ipData.src), maskData);
}

ZaIPUtil.getNonZeroNum = function (sobn, chunkSize) {
    if (sobn == 0)
        return 0;
    var ret = 0;
    var baseValue = Math.pow(2, chunkSize - sobn);
    for (var i = 0; i < sobn; i++) {
        ret = ret + baseValue;
        baseValue = baseValue * 2;
    }
    return ret;
}

ZaIPUtil.countOneBit = function (num) {
    var ret = 0;
    while (num) {
        ret ++;
        num = num & (num -1);
    }
    return ret;
}

ZaIPUtil.getNetBit = function (netMask) {
    var isDot = (netMask.indexOf(".") != -1) ? true: false;
    var isColon = (netMask.indexOf(":") != -1) ? true: false;
    if ( !isDot && !isColon) {
        var netValue = parseInt(netMask, 16);
        return ZaIPUtil.countOneBit(netValue);
    }

    var ipData = ZaIPUtil.isValidIP(netMask);
    if (!ipData) {
        return 0;
    }

    var netBit = 0;
    for(var i = 0; i < ipData.fmtArr.length; i++) {
        if (ipData.fmtArr[i] == 0)
            break;
        netBit = netBit + ZaIPUtil.countOneBit(ipData.fmtArr[i]);
    }

    return netBit;
}

ZaIPUtil.isInSubNet = function (cidrData, ipData) {
    var cidrIP = cidrData.ipData;
    var mask = cidrData.mask;
    if (cidrIP.ver != ipData.ver) {
        return false;
    }

    var leftBitNum = mask;
    var currentCmpBit, crtFirstValue, crtSecondValue;
    var chunkSize = (cidrIP.ver == ZaIPData.v4) ? 8 : 16;
    for (var i = 0 ;i < cidrIP.fmtArr.length; i++) {
        if (leftBitNum == 0) {
            break;
        }

        if (leftBitNum >= chunkSize) {
            currentCmpBit = chunkSize;
        } else {
            currentCmpBit = leftBitNum;
        }

        leftBitNum = leftBitNum - chunkSize;

        crtFirstValue = cidrIP.fmtArr[i] >> (chunkSize - currentCmpBit);
        crtSecondValue = ipData.fmtArr[i] >> (chunkSize - currentCmpBit);
        if (crtFirstValue !=  crtSecondValue)  {
            return false;
        }
    }
    return true;
}

ZaIPUtil.compareIP = function(first, second) {
    if (!first || !second) {
        throw ZaIPUtil.ERROR_IP_NULL;
    }
    if (first.ver != second.ver) {
        throw ZaIPUtil.ERROR_IP_VER_DISMATCH;
    }

    if (first.fmtArr.length != second.fmtArr.length) {
        throw ZaIPUtil.ERROR_IP_VER_DISMATCH;
    }

    for (var i = 0; i < first.fmtArr.length; i++) {
        if (first.fmtArr[i] >  second.fmtArr[i])  {
            return 1;
        } else if (first.fmtArr[i] <  second.fmtArr[i]) {
            return -1;
        }
    }
    return 0;
}

ZaIPUtil.isValidIP = function (ipStr) {
    if (!ipStr) {
        throw ZaIPUtil.ERROR_IP_NULL;
    }

    var isDot = (ipStr.indexOf (".") == -1) ? false: true;
    var isColon = (ipStr.indexOf (":") == -1) ? false: true;
    if (!isColon && isDot) {
        return ZaIPUtil.isIPV4(ipStr);
    } else if (isColon && !isDot) {
        return ZaIPUtil.isIPV6(ipStr);
    } else if (isColon && isDot) {
        return ZaIPUtil.isIPVMix(ipStr);
    } else {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }
}

ZaIPUtil.isIPV4 = function (ipV4Str) {
    if (!ipV4Str) {
        throw ZaIPUtil.ERROR_IP_NULL;
    }
    var chunks = ipV4Str.split(".");
    if (chunks.length != 4) {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }

    //Check ipV4Str has '.' at index 0 (First dot in IPv4 address)
    if (ipV4Str[0] == ".") {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }
       
    //Check ipV4Str has '.' at the end of IP address (Last dot in IPv4 address)
    if (ipV4Str[ipV4Str.length -1] == ".") {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }
        
    //Invalid IPv4 address that has two or more adjacent dot
    for(var i = 0; i < ipV4Str.length - 1; i++) {
        if (ipV4Str[i] == "." && ipV4Str[i+1] == ".") {
            throw ZaIPUtil.ERROR_IP_FORMAT;
        }
    }

    var longValue;
    for (var i = 0; i < chunks.length; i++) {
        if (!chunks[i])
            throw ZaIPUtil.ERROR_IP_FORMAT;
        if (!ZaIPUtil.IP4_CHUNK_RE.test(chunks[i]))
            throw ZaIPUtil.ERROR_IP_FORMAT;

        // Must add 10 here to avoid leading 0.
        longValue = parseInt(chunks[i], 10);
        if (longValue > 255)
            throw ZaIPUtil.ERROR_IP_FORMAT;

        chunks[i] = longValue;
    }

    return new ZaIPData(chunks, ZaIPData.v4, undefined, ipV4Str);
}

ZaIPUtil.isIPV6 = function (ipV6Str) {
    if (!ipV6Str) {
        throw ZaIPUtil.ERROR_IP_NULL;
    }

    var ipCntStr;
    if ((ipV6Str[0] == "[") &&
        (ipV6Str[ipV6Str.length -1] == "]")) {
        ipCntStr =  ipV6Str.substring (1, ipV6Str.length - 1);
    } else {
        ipCntStr = ipV6Str;
    }

    var zoneIndex = ipCntStr.indexOf("%");
    var zoneContent;
    if (zoneIndex != -1) {
        zoneContent = ipCntStr.substring(zoneIndex + 1);
        ipCntStr = ipCntStr.substring(0, zoneIndex);
    }

    if (!ipCntStr) {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }

    // Only one group zero is allowed
    var isDottedQuad = ipCntStr.indexOf("::");
    if (isDottedQuad != -1) {
        if (ipCntStr.indexOf("::", isDottedQuad + 2) != -1)
            throw ZaIPUtil.ERROR_IP_FORMAT;
    }

    //Invalid IPv6 address that has three or more adjacent colon
    if (isDottedQuad != -1) {
        if (ipCntStr[isDottedQuad + 2] == ":") {
            throw ZaIPUtil.ERROR_IP_FORMAT;
        }
    }

    //':' is at index 0 of IP address (not group zero "::"). Ex: :2001:db8:cafe::1
    if (ipCntStr[0] == ":" && ipCntStr[1] != ":") {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }
        
    // ':' is at the end of IP address (not group zero "::"). Ex: 2001:db8:cafe::1: 
    if (ipCntStr[ipCntStr.length -1] == ":" && ipCntStr[ipCntStr.length -2] != ":") {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }
        
    var chunks = ipCntStr.split(":");
    if (chunks.length > 8)
        throw ZaIPUtil.ERROR_IP_FORMAT;

    var zeroLocation;
    for (var i = 0; i < chunks.length; i++) {
        if (!chunks[i]) {
            if (zeroLocation === undefined) {
                zeroLocation = i;
            }
            chunks[i] = 0;
            continue;
        }

        if (!ZaIPUtil.IP6_CHUNK_RE.test(chunks[i])) {
            throw ZaIPUtil.ERROR_IP_FORMAT;
        }

        chunks[i] = parseInt(chunks[i], 16);
    }

    if (zeroLocation === undefined && (chunks.length != 8)) {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }

    if (chunks.length < 8 && (zeroLocation!== undefined)) {
        var addZeroNum = 8 - chunks.length;
        for(var j = 0; j < addZeroNum; j++) {
            chunks.splice(zeroLocation, 0, 0);
        }
    }

    return  new ZaIPData(chunks, ZaIPData.v6, zoneContent, ipV6Str);
}

// Convert the compatiable IP v6 to IP v4
ZaIPUtil.isIPVMix = function (ipVMixStr) {
    if (!ipVMixStr || ipVMixStr.length < 9 ) {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }

    var ipCntStr;
    if ((ipVMixStr[0] == "[") &&
        (ipVMixStr[ipVMixStr.length -1] == "]")) {
        ipCntStr =  ipVMixStr.substring (1, ipVMixStr.length - 1);
    } else {
        ipCntStr = ipVMixStr;
    }

    var ipV6Prefix = ipCntStr.substring(0, 7);
    if (!ZaIPUtil.IPMIX_PREFIX_RE.test(ipV6Prefix)) {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }

    var ipV4Str = ipCntStr.substring(7);
    var ipData = ZaIPUtil.isIPV4(ipV4Str);
    if (!ipData) {
        throw ZaIPUtil.ERROR_IP_FORMAT;
    }
    ipData.src = ipCntStr;
    return ipData;
}

ZaCIDRData = function (ipData, mask, src) {
    this.ipData = ipData;
    this.mask = mask;
    this.src = src;
}

ZaIPData = function (fmtArr, ver, zoneSection, src) {
    this.fmtArr= fmtArr;
    this.ver = ver;
    this.zoneSection = zoneSection;
    this.src = src;
}

ZaIPData.v4 = "4";
ZaIPData.v6 = "6";
ZaIPData.vMix = "Mix";
}
if (AjxPackage.define("zimbraAdmin.common.Lifetime_XFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* _MLIFETIME XModelItem
**/

MLifetime_XModelItem = function () {}
XModelItemFactory.createItemType("_MLIFETIME_", "mlifetime", MLifetime_XModelItem);
MLifetime_XModelItem.prototype.minInclusive = 0;
MLifetime_XModelItem.prototype.zeroValue = ZaMsg.Unlimited;
MLifetime_XModelItem.prototype.required = false;
MLifetime_XModelItem.prototype.validateType = function (value) {
	var val = "";
	if(value == this.zeroValue) {
		val = "0";
	} else if(value != null && value.length >0) {
		if(value.length > 1) {
			val = value.substr(0, value.length-1);				
		} else {
			val = "0";
		}
	}
	
	if(val)
		val =  XModelItem.prototype.validateNumber.call(this, val);

	if (val == 0 && this.required) {
		throw AjxMessageFormat.format(ZaMsg.exception_required_lifetime, value);
	}
	
	return value;
}
/**
* XFormItem class: "lifetime (composite item)
* this item is used in the Admin UI to display fields such as session token lifetime
* instance values are strings that contain numbers and characters (/^([0-9])+([dhms])?$/;)
* values d, h, m, and s mean 1 day, 1 hour, 1 minute and 1 second
* 1d means 1 day, 4d means 4 days, 4h means 4 hours, etc.
*
* @class Lifetime_XFormItem
* @constructor Lifetime_XFormItem
* @author Greg Solovyev
**/
Lifetime_XFormItem = function() {}
XFormItemFactory.createItemType("_LIFETIME_", "lifetime", Lifetime_XFormItem, Composite_XFormItem);
Lifetime_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Lifetime_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Lifetime_XFormItem.prototype.nowrap = false;
Lifetime_XFormItem.prototype.labelWrap = true;

Lifetime_XFormItem.prototype.initializeItems = function(){
	this.items = [
	{type:_TEXTFIELD_, ref:".", labelLocation:_NONE_, cssClass:"admin_xform_number_input", 
	 	visibilityChecks:[],
	 	enableDisableChecks:[],		
		getDisplayValue:function (itemVal) {
			var val = "";
			if(itemVal != null && itemVal.length >0) {
				if(itemVal.length > 1) {
					val = parseInt(itemVal);			
				} else {
					if(itemVal == "0") {
						val = "0";
					} else {
						val = "";
					}
				}
			}

			this.getParentItem()._numericPart = val;
			return ((!val || val=="0") ? this.getModelItem().zeroValue : val);
		},
		elementChanged:function(numericPart, instanceValue, event) {
            if (numericPart  == this.getModelItem().zeroValue) {
                numericPart = 0;
            }
			var val = null;
			if (AjxUtil.isNumeric(numericPart)) {
				val = numericPart + this.getParentItem()._stringPart;
			}
			this.getParentItem()._numericPart = numericPart;
			this.getForm().itemChanged(this.getParentItem(), val, event);
		}
	},
	{type:_OSELECT1_, ref:".", labelLocation:_NONE_, choices: ZaModel.getTimeChoices(),
		visibilityChecks:[],
	 	enableDisableChecks:[],
		getDisplayValue:function (itemVal){
			var val = "d";
			if(itemVal != null && itemVal.length >0) {
				if(itemVal.length > 1) {
					val = itemVal.substr(itemVal.length-1, 1);
				} else if (itemVal != "0") {
					val = (itemVal == "d" || itemVal == "h" || itemVal== "m" || itemVal == "s") ? itemVal : "d";
				}
			}
			this.getParentItem()._stringPart = val;
			return val;
		},
		elementChanged:function(stringPart,instanceValue, event) {
			var val = this.getParentItem()._numericPart + stringPart;
			this.getParentItem()._stringPart = stringPart;
			this.getForm().itemChanged(this.getParentItem(), val, event);
		}
	}
];
	Composite_XFormItem.prototype.initializeItems.call(this);
}

Lifetime_XFormItem.prototype.items = [];
Lifetime_XFormItem.prototype.getDisplayElement = function () {
	return this.getElement(this.getId() + "_display");
}

Lifetime1_XFormItem = function() {}
XFormItemFactory.createItemType("_LIFETIME1_", "lifetime1", Lifetime1_XFormItem, Composite_XFormItem);
Lifetime1_XFormItem.prototype.nowrap = false;
Lifetime1_XFormItem.prototype.labelWrap = true;
Lifetime1_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Lifetime1_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Lifetime1_XFormItem.prototype.initializeItems  = function() {
	this.items = [
	{type:_TEXTFIELD_, ref:".", labelLocation:_NONE_,cssClass:"admin_xform_number_input", 
		visibilityChecks:[],
	 	enableDisableChecks:[],
		getDisplayValue:function (itemVal) {
			var val = "";
			if(itemVal != null && itemVal.length >0) {
				if(itemVal.length > 1) {
					val = itemVal.substr(0, itemVal.length-1);				
				} else {
					if(itemVal == "0") {
						val = "0";
					} else {
						val = "";
					}
				}
			}
			this.getParentItem()._numericPart = val;
			return val;	
		},
		elementChanged:function(numericPart, instanceValue, event) {
			var val = numericPart + this.getParentItem()._stringPart;
			this.getForm().itemChanged(this.getParentItem(), val, event);
		}
	},
	{type:_OSELECT1_, ref:".", labelLocation:_NONE_, choices:ZaModel.getTimeChoices1(),
		visibilityChecks:[],
	 	enableDisableChecks:[],
		getDisplayValue:function (itemVal){
			var val = "d";
			if(itemVal != null && itemVal.length >0) {
				if(itemVal.length > 1) {
					val = itemVal.substr(itemVal.length-1, 1);
				} else if (itemVal != "0") {
					val = (itemVal == "d" || itemVal == "h" || itemVal== "m" || itemVal == "s") ? itemVal : "d";
				}
			}
			this.getParentItem()._stringPart = val;
			return val;
		},
		elementChanged:function(stringPart,instanceValue, event) {
			var val = this.getParentItem()._numericPart + stringPart;
			this.getForm().itemChanged(this.getParentItem(), val, event);
		}
	}
];
Composite_XFormItem.prototype.initializeItems.call(this);
}
Lifetime1_XFormItem.prototype.items = [];

Lifetime2_XFormItem = function() {}
Lifetime2_XFormItem.prototype.nowrap = false;
Lifetime2_XFormItem.prototype.labelWrap = true;
XFormItemFactory.createItemType("_LIFETIME2_", "lifetime2", Lifetime2_XFormItem, Lifetime1_XFormItem);

Lifetime2_XFormItem.prototype.initializeItems = function () {
	this.items = [
		{type:_TEXTFIELD_, ref:".", labelLocation:_NONE_,cssClass:"admin_xform_number_input", 
			visibilityChecks:[],
		 	enableDisableChecks:[],		
			getDisplayValue:function (itemVal) {
				var val = "";
				if(itemVal != null && itemVal.length >0) {
					if(itemVal.length > 1) {
						val = itemVal.substr(0, itemVal.length-1);				
					} else {
						if(itemVal == "0") {
							val = "0";
						} else {
							val = "";
						}
					}
				}
				this.getParentItem()._numericPart = val;
				this.getParentItem()._stringPart="d";
				return val;	
			},
			elementChanged:function(numericPart, instanceValue, event) {
				var val = numericPart + "d";
				this.getForm().itemChanged(this.getParentItem(), val, event);
			}
		},
		{type:_OUTPUT_, ref:null, labelLocation:_NONE_, value:"d",getDisplayValue:function (itemVal){ return AjxMsg.days;}}
	];
	Composite_XFormItem.prototype.initializeItems.call(this);
};
Lifetime2_XFormItem.prototype.items = [];

/**
* _LIFETIME_MINUTES_ XForm item type allows time interval to be expressed only in minutes
**/
LifetimeMinutes_XFormItem = function() {}
LifetimeMinutes_XFormItem.prototype.nowrap = false;
LifetimeMinutes_XFormItem.prototype.labelWrap = true;
XFormItemFactory.createItemType("_LIFETIME_MINUTES_", "lifetime_minutes", LifetimeMinutes_XFormItem, Lifetime1_XFormItem);

LifetimeMinutes_XFormItem.prototype.initializeItems = function () {
	this.items = [
		{type:_TEXTFIELD_, ref:".", labelLocation:_NONE_,cssClass:"admin_xform_number_input", 
			visibilityChecks:[],
		 	enableDisableChecks:[],		
			getDisplayValue:function (itemVal) {
				var val = "";
				if(itemVal != null && itemVal.length >0) {
					if(itemVal.length > 1) {
						val = itemVal.substr(0, itemVal.length-1);				
					} else {
						if(itemVal == "0") {
							val = "0";
						} else {
							val = "";
						}
					}
				}
				this.getParentItem()._numericPart = val;
				this.getParentItem()._stringPart="m";
				return val;	
			},
			elementChanged:function(numericPart, instanceValue, event) {
				var val = numericPart + "m";
				this.getForm().itemChanged(this.getParentItem(), val, event);
			}
		},
		{type:_OUTPUT_, ref:null, labelLocation:_NONE_, value:"m",getDisplayValue:function (itemVal){ return AjxMsg.minutes;}}
	];
	Composite_XFormItem.prototype.initializeItems.call(this);
};
LifetimeMinutes_XFormItem.prototype.items = [];

Long_Lifetime_XFormItem = function() {}
XFormItemFactory.createItemType("_LONG_LIFETIME_", "long_lifetime", Long_Lifetime_XFormItem, Composite_XFormItem);
Long_Lifetime_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Long_Lifetime_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Long_Lifetime_XFormItem.prototype.nowrap = false;
Long_Lifetime_XFormItem.prototype.labelWrap = true;
Long_Lifetime_XFormItem.prototype.initializeItems = function(){
    this.items = [
        {type:_TEXTFIELD_, ref:".", labelLocation:_NONE_, cssClass:"admin_xform_number_input",
            visibilityChecks:[],
            enableDisableChecks:[],
            getDisplayValue:function (itemVal) {
                var val = "";
                if(itemVal != null && itemVal.length >0) {
                    if(itemVal.length > 1) {
                        val = parseInt(itemVal);
                    } else {
                        if(itemVal == "0") {
                            val = "0";
                        } else {
                            val = "";
                        }
                    }
                }
                this.getParentItem()._numericPart = val;
                return ((!val || val=="0") ? "0" : val);
            },
            elementChanged:function(numericPart, instanceValue, event) {
                if (numericPart == this.getModelItem().zeroValue) {
                    numericPart = 0;
                }
                var val = numericPart + this.getParentItem()._stringPart;
                this.getParentItem()._numericPart = numericPart;
                this.getForm().itemChanged(this.getParentItem(), val, event);
            }
        },
        {type:_OSELECT1_, ref:".", labelLocation:_NONE_, choices: ZaModel.getLongTimeChoices,
            visibilityChecks:[],
            enableDisableChecks:[],
            getDisplayValue:function (itemVal){
                var val = "d";
                if(itemVal != null && itemVal.length >0) {
                    if(itemVal.length > 1) {
                        val = itemVal.substr(itemVal.length-1, 1);
                    } else if (itemVal != "0") {
                        val = (itemVal == "h" || itemVal == "d" || itemVal== "m" || itemVal == "y") ? itemVal : "d";
                    }
                }
                this.getParentItem()._stringPart = val;
                return val;
            },
            elementChanged:function(stringPart,instanceValue, event) {
                var val = this.getParentItem()._numericPart + stringPart;
                this.getParentItem()._stringPart = stringPart;
                this.getForm().itemChanged(this.getParentItem(), val, event);
            }
        }
    ];
    Composite_XFormItem.prototype.initializeItems.call(this);
}
Long_Lifetime_XFormItem.prototype.items = [];
Long_Lifetime_XFormItem.prototype.getDisplayElement = function () {
    return this.getElement(this.getId() + "_display");
}

MInterval_XModelItem = function () {}
XModelItemFactory.createItemType("_MINTERVAL_", "minterval", MInterval_XModelItem, MLifetime_XModelItem);
MInterval_XModelItem.prototype.zeroValue = ZaMsg.never.toLowerCase();
}
if (AjxPackage.define("zimbraAdmin.config.settings.ZaSettings")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

ZaSettings = function() {
}

ZaSettings.initialized = false;
ZaSettings.initializing = false
ZaSettings.initMethods = new Array();
ZaSettings.RESULTSPERPAGE = 50;
ZaSettings.MAXSEARCHRESULTS = 100;
ZaSettings.HAVE_MORE_DOMAINS = false;
/**
* Look for admin name cookies and admin type cookies
**/
ZaSettings.postInit = function() {
    //if(window.console && window.console.log) console.log("Finishing loading all the zimlets, and ready to initialize the application ...");
        
	//Instrumentation code end	
	var shell = DwtShell.getShell(window);
	var appCtxt = ZaAppCtxt.getFromShell(shell);
	var appController = appCtxt.getAppController();
	appController._createApp();
	        
    //Instrumentation code start
	if(ZaSettings.initMethods) {
		var cnt = ZaSettings.initMethods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(ZaSettings.initMethods[i]) == "function") {
				try {
					ZaSettings.initMethods[i].call(this);
				} catch (ex) {
				//	
				}
			}
		}
	}	

    appController._lauchNewApp();

    if (ZaZimbraAdmin.isWarnOnExit) {
	    ZaZimbraAdmin.setOnbeforeunload(ZaZimbraAdmin._confirmExitMethod);
    }
	ZaSettings.initialized = true;
	ZaSettings.initializing = false;
};

ZaSettings.initRights = function () {
	ZaSettings.ENABLED_UI_COMPONENTS=[];
	ZaZimbraAdmin.currentAdminAccount = new ZaAccount();
	try {
		if(ZaZimbraAdmin.currentAdminId) {
			ZaZimbraAdmin.currentAdminAccount.load("id", ZaZimbraAdmin.currentAdminId,false,true);
		} else {
			ZaZimbraAdmin.currentAdminAccount.load("name", ZaZimbraAdmin.currentUserLogin,false,true);
		}
	} catch (ex) {
		//account may fail to load due to failing admin extensions 
	}
	//if this is a system admin account - enable access to all UI elements
	if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE') {
		ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI] = true;
	}	
	if(AjxUtil.isEmpty(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraAdminConsoleUIComponents])) {
		ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraAdminConsoleUIComponents] = [];
	} else {
		if(typeof(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraAdminConsoleUIComponents])=="string") {
			ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraAdminConsoleUIComponents] = [ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraAdminConsoleUIComponents]];
		}	
		var cnt = ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraAdminConsoleUIComponents].length;
		for(var i=0;i<cnt;i++) {
			ZaSettings.ENABLED_UI_COMPONENTS[ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraAdminConsoleUIComponents][i]] = true;
		}
	}
	//load  permissions, e.g. createTopDomain, createCos, createDistributionList
	var soapDoc = AjxSoapDoc.create("GetAllEffectiveRightsRequest", ZaZimbraAdmin.URN, null);
	var elGrantee = soapDoc.set("grantee", ZaZimbraAdmin.currentUserId);
	elGrantee.setAttribute("by","id");
	
	var csfeParams = new Object();
	csfeParams.soapDoc = soapDoc;	
	var reqMgrParams = {} ;
	reqMgrParams.controller = ZaApp.getInstance().getCurrentController();
	reqMgrParams.busyMsg = ZaMsg.BUSY_REQUESTING_ACCESS_RIGHTS ;
	try {
		var resp = ZaRequestMgr.invoke(csfeParams, reqMgrParams ).Body.GetAllEffectiveRightsResponse;
		ZaSettings.initGlobalRightsFromJS(resp);
	} catch (ex) {
		//keep loading
	}	
	
	var comps = ZaSettings.getUIComponents() ;
    var cnt = comps.length;
    for(var i=0;i<cnt;i++) {
      ZaSettings.ENABLED_UI_COMPONENTS[comps[i]._content] = true;
    }
    
}
ZaSettings.initMethods.push(ZaSettings.initRights);

ZaSettings.initGlobalRightsFromJS = function(resp) {
	ZaSettings.targetRights = {};
	var cosNameList = [];
	var domainNameList = [];
	if(resp && resp.target && resp.target instanceof Array) {
		for(var i = 0; i < resp.target.length; i++) {
			ZaSettings.parseTargetsRightsFromJS(resp.target[i]);
			if(resp.target[i].type == ZaItem.COS) {
				if(resp.target[i].entries && resp.target[i].entries.length) {
					for(var j = 0; j < resp.target[i].entries.length; j++) {
						var entry = resp.target[i].entries[j].entry;
						for(var k = 0; k < entry.length; k++) {
							cosNameList.push(entry[k].name);
						}
					}
	            }
			} else if(resp.target[i].type == ZaItem.DOMAIN) {
				if(resp.target[i].entries && resp.target[i].entries.length) {
					for(var j = 0; j < resp.target[i].entries.length; j++) {
						var entry = resp.target[i].entries[j].entry;
						for(var k = 0; k < entry.length; k++) {
							domainNameList.push(entry[k].name);
						}
					}
	            }
			}
		}
	}	
	ZaApp.getInstance()._cosNameList = cosNameList;
	ZaApp.getInstance()._domainNameList = domainNameList;
}

ZaSettings.parseTargetsRightsFromJS = function(targetObj) {
	if(targetObj) {
		if(targetObj.type && AjxUtil.isEmpty(ZaSettings.targetRights[targetObj.type])) {
			ZaSettings.targetRights[targetObj.type] = {};
		}

		if(targetObj.all && targetObj.all.length && targetObj.all[0] && targetObj.all[0].right && targetObj.all[0].right.length) {
			var rights = targetObj.all[0].right;
			for (var r in rights) {
				if(!ZaSettings.targetRights[targetObj.type][rights[r].n]) {
					ZaSettings.targetRights[targetObj.type][rights[r].n] = {all:true,some:true};
				} else {
					ZaSettings.targetRights[targetObj.type][rights[r].n].all = true;
					ZaSettings.targetRights[targetObj.type][rights[r].n].some = true;
				}
			}
		}
		
		if(targetObj.entries && targetObj.entries.length) {
			for (var i = 0; i < targetObj.entries.length; i++) {
				var entry = targetObj.entries[i];
				if(entry.rights && entry.rights.length && entry.rights[0] && entry.rights[0].right && entry.rights[0].right.length) {
					var rights = entry.rights[0].right;
					for (var r in rights) {
						if(!ZaSettings.targetRights[targetObj.type][rights[r].n]) {
							ZaSettings.targetRights[targetObj.type][rights[r].n] = {all:false};
						}
					}
				}
				
				if(entry.entry && entry.entry.length) {
					for(var j = 0; j < entry.entry.length; j++) {
						if(entry.entry[j] && entry.entry[j].name) {
							for(var rightName in ZaSettings.targetRights[targetObj.type]) {
								ZaSettings.targetRights[targetObj.type][rightName][entry.entry[j].name] = true;
								ZaSettings.targetRights[targetObj.type][rightName].some = true;
							}
						}
					}
				}
			}
		}
		
		if(targetObj.inDomains && targetObj.inDomains.length) {
			for (var i = 0; i < targetObj.inDomains.length; i++) {
				var entry = targetObj.inDomains[i];
				var domainList = [];
				if(entry.domain && entry.domain.length) {
					for(var j = 0; j < entry.domain.length; j++) {
						domainList.push(entry.domain[j].name);
					}
				}
				if(entry.rights && entry.rights.length && entry.rights[0] 
						&& entry.rights[0].right && entry.rights[0].right.length) {
					for(var j = 0; j < entry.rights[0].right.length; j++) {
						if(!ZaSettings.targetRights[targetObj.type][entry.rights[0].right[j].n]) {
							ZaSettings.targetRights[targetObj.type][entry.rights[0].right[j].n] = {all:false,some:true};
						} 
						for(var k = 0; k < domainList.length; k++) {
							ZaSettings.targetRights[targetObj.type][entry.rights[0].right[j].n][domainList[k]] = true;
							ZaSettings.targetRights[targetObj.type][entry.rights[0].right[j].n].some = true;
						}
					}
				}
			}
		}
	}
}

ZaSettings.getUIComponents = function (item) {
    soapDoc = AjxSoapDoc.create("GetAdminConsoleUICompRequest", ZaZimbraAdmin.URN, null);
	if (item && item.type && item.id) {
        var el = soapDoc.set(item.type, item.id) ;
        el.setAttribute("by", "id");
    }
    csfeParams = new Object();
	csfeParams.soapDoc = soapDoc;
	reqMgrParams = {} ;
	reqMgrParams.controller = ZaApp.getInstance().getCurrentController();
	reqMgrParams.busyMsg = ZaMsg.BUSY_REQUESTING_UI_COMP ;
	try {
		var resp = ZaRequestMgr.invoke(csfeParams, reqMgrParams ).Body.GetAdminConsoleUICompResponse;
		var comps = [];
		if(!AjxUtil.isEmpty(resp.a)) {
			if (typeof(resp.a) == "string" ) {
				comps = [resp.a];
			} else if(resp.a instanceof Array) {
				comps = resp.a;
			}
		}

        return comps ;
    } catch (ex) {
		//not implemented yet
	}

    return [];
}

ZaSettings.loadStyles = function(includes) {
    var head = document.getElementsByTagName("head")[0];
    for (var i = 0; i < includes.length; i++) {
        var style = document.createElement("link");
        style.type = "text/css";
        style.rel = "stylesheet";
        style.href = includes[i];

        head.appendChild(style);
    }
};

ZaSettings.EnabledZimlet = {};
ZaSettings.init = function () {
	if(ZaSettings.initialized || ZaSettings.initializing)
		return;
		
	ZaSettings.initializing = true ;
	DBG.println(AjxDebug.DBG1,"Initializing ZaSettings");		
	

	try {
		var soapDoc = AjxSoapDoc.create("GetAdminExtensionZimletsRequest", ZaZimbraAdmin.URN, null);
                var command = new ZmCsfeCommand();
                var params = new Object();
                params.soapDoc = soapDoc;
				params.noAuthToken = true;
                var resp = command.invoke(params);
                var zimlets = null;
                try {
                       if(resp && resp.Body && resp.Body.GetAdminExtensionZimletsResponse && resp.Body.GetAdminExtensionZimletsResponse.zimlets && resp.Body.GetAdminExtensionZimletsResponse.zimlets.zimlet) {
                       		zimlets = resp.Body.GetAdminExtensionZimletsResponse.zimlets.zimlet;
                       }
               } catch (ex) {
                                //go on
                                //                    //if(window.console && window.console.log) console.log("Error Getting the Zimlets: " + ex.message);
               }
		
		if(appDevMode || (DBG.getDebugLevel() > AjxDebug.NONE) || (location.search && (location.search.indexOf("mode=mjsf") != -1))) {
			if(zimlets && zimlets.length > 0) {
				var includes = new Array();	
				var cssIncludes = new Array();	
				var cnt = zimlets.length;
				for(var ix = 0; ix < cnt; ix++) {
					if(zimlets[ix] && zimlets[ix].zimlet && zimlets[ix].zimlet[0] && zimlets[ix].zimletContext && zimlets[ix].zimletContext[0]) {
						var zimlet = zimlets[ix].zimlet[0];
						var zimletContext = zimlets[ix].zimletContext[0];
						ZaSettings.EnabledZimlet[zimlet.name] = true;
	                    //if(window.console && window.console.log) console.log("Adding zimlet: " + zimlet.name);
	                    //load message file first because consequent files may reference it
	                    			includes.push([appContextPath, "/res/", zimlet.name, ".js?v=",appVers,ZaZimbraAdmin.LOCALE_QS].join(""));
						if(zimlet.include && zimlet.include.length>0) {
							var cnt2 = zimlet.include.length;
							for (var j=0;j<cnt2;j++) {
								includes.push(zimletContext.baseUrl + zimlet.include[j]._content + "?v=" +appVers);
							}
						}
						if(zimlet.includeCSS && zimlet.includeCSS.length>0) {
							var cnt3 = zimlet.includeCSS.length;
							for (var j=0;j<cnt3;j++) {
								cssIncludes.push(zimletContext.baseUrl + zimlet.includeCSS[j]._content  + "?v=" +appVers);
							}
						}
					} else {
						continue;
					}
				}
				try {
		
					if(cssIncludes.length > 0){
					    //if(window.console && window.console.log) console.log ("Loading Zimlets CSS: " + cssIncludes.join(", ") );
	                    ZaSettings.loadStyles(cssIncludes);
	                }
	
					if(includes.length > 0)   {
	                    //if(window.console && window.console.log) console.log ("Loading Zimlets JS: " + includes.join(", ") );
	                   	AjxInclude(includes, null,new AjxCallback(ZaSettings.postInit ));
	                }
	
	            } catch (ex) {
					//go on
					throw ex;
				}
						
			} else {
				ZaSettings.postInit();
			}
		} else {
			if(zimlets && zimlets.length > 0) {
				var cnt = zimlets.length;
				for(var ix = 0; ix < cnt; ix++) {
					if(zimlets[ix] && zimlets[ix].zimlet && zimlets[ix].zimlet[0]){
						var zimlet = zimlets[ix].zimlet[0];
						ZaSettings.EnabledZimlet[zimlet.name] = true;
					}
				}
			}
			var zimletURL = ["/service/zimlet/res/Zimlets-nodev_all.js.zgz", ".js?v=",appVers,ZaZimbraAdmin.LOCALE_QS].join("");
			AjxInclude([zimletURL], null,new AjxCallback(ZaSettings.postInit ));
		}
	} catch (ex) {
		ZaSettings.initializing = false ;
//		DBG.dumpObj(ex);
		throw ex;	
	}
	
	// post-processing code
/*	DBG.println("+++ document.location.pathname: "+document.location.pathname);
	var files = [ document.location.pathname + "public/adminPost.js" ];
	AjxInclude(files);
	*/
	
};


/**
* Static method so that static code can get the default value of a setting if it needs to.
*
* @param id		the numeric ID of the setting
*/
ZaSettings.get =
function(id) {
	var args = ZaSettings.INIT[id];
	return args ? args[3] : null;
}

// setting types
ZaSettings.T_CONFIG		= 1;

// setting data types
ZaSettings.D_STRING		= 1; // default type
ZaSettings.D_INT			= 2;
ZaSettings.D_BOOLEAN		= 3;
ZaSettings.D_LDAP_TIME 	= 4;
ZaSettings.D_HASH_TABLE 	= 5;
ZaSettings.LOGO_URI = "https://www.zimbra.com";
ZaSettings.CSFE_SERVER_URI = (location.port == "80") ? "/service/admin/soap/" : ":" + location.port + "/service/admin/soap/";
ZaSettings.CSFE_MSG_FETCHER_URI = (location.port == "80") ? "/service/content/get?" : ":" + location.port + "/service/content/get?";
ZaSettings.CONFIG_PATH = location.pathname + "js/zimbraAdmin/config";
//ZaSettings.ADMIN_NAME_COOKIE = "ZA_ADMIN_NAME_COOKIE";
ZaSettings.myDomainName = null;
ZaSettings.ZIMBRA_SUPPORT_URL = "https://support.zimbra.com/help/index.php";
ZaSettings.ZIMBRA_SUPPORT_URL_QUERY = ZaSettings.ZIMBRA_SUPPORT_URL + "?query=";

//CONSTANTS FOR ROLE-BASED ACCESS
/**
 * In order for an admin to be able to access a UI component, zimbraAdminConsoleUIComponents attribute of the admin's account should contain the corresponding values listed below
 */
//carte blanche - gives access to any UI element
ZaSettings.CARTE_BLANCHE_UI = "cartBlancheUI";

ZaSettings.initConst = function() {
//*init List View *
ZaSettings.ALL_UI_COMPONENTS = [] ;
//List views
ZaSettings.ACCOUNT_LIST_VIEW = "accountListView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.ACCOUNT_LIST_VIEW, label: ZaMsg.UI_Comp_AccountListView });
ZaSettings.DL_LIST_VIEW = "DLListView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.DL_LIST_VIEW, label: ZaMsg.UI_Comp_DlListView });
ZaSettings.ALIAS_LIST_VIEW = "aliasListView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.ALIAS_LIST_VIEW, label: ZaMsg.UI_Comp_AliasListView });
ZaSettings.RESOURCE_LIST_VIEW = "resourceListView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.RESOURCE_LIST_VIEW, label: ZaMsg.UI_Comp_ResourceListView });
ZaSettings.COS_LIST_VIEW = "COSListView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.COS_LIST_VIEW, label: ZaMsg.UI_Comp_COSListView });
ZaSettings.DOMAIN_LIST_VIEW = "domainListView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.DOMAIN_LIST_VIEW, label: ZaMsg.UI_Comp_DomainListView });
ZaSettings.SERVER_LIST_VIEW = "serverListView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.SERVER_LIST_VIEW, label: ZaMsg.UI_Comp_ServerListView });
ZaSettings.ZIMLET_LIST_VIEW = "zimletListView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.ZIMLET_LIST_VIEW, label: ZaMsg.UI_Comp_ZimletListView });
ZaSettings.ADMIN_ZIMLET_LIST_VIEW = "adminZimletListView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.ADMIN_ZIMLET_LIST_VIEW, label: ZaMsg.UI_Comp_AdminZimletListView });
ZaSettings.GLOBAL_CONFIG_VIEW="globalConfigView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.GLOBAL_CONFIG_VIEW, label: ZaMsg.UI_Comp_globalConfigView });
ZaSettings.GLOBAL_STATUS_VIEW = "globalServerStatusView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.GLOBAL_STATUS_VIEW, label: ZaMsg.UI_Comp_GlobalStatusView });
//ZaSettings.GLOBAL_STATS_VIEW = "globalServerStatisticsView";
//ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.GLOBAL_STATS_VIEW, label: ZaMsg.UI_Comp_GlobalStatsView });
ZaSettings.SAVE_SEARCH = "saveSearch";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.SAVE_SEARCH, label: ZaMsg.UI_Comp_SaveSearch });
ZaSettings.HELP_SEARCH = "helpSearch";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.HELP_SEARCH, label: ZaMsg.UI_Comp_HelpSearch });
ZaSettings.MAILQ_VIEW = "mailQueue";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.MAILQ_VIEW, label: ZaMsg.UI_Comp_mailQueueView });
ZaSettings.SERVER_STATS_VIEW = "perServerStatisticsView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.SERVER_STATS_VIEW, label: ZaMsg.UI_Comp_ServerStatsView });
ZaSettings.DOWNLOADS_VIEW = "downloadsView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.DOWNLOADS_VIEW, label: ZaMsg.UI_Comp_DownloadsView });
ZaSettings.HELP_CENTER_VIEW = "helpCenterView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.HELP_CENTER_VIEW, label: ZaMsg.UI_Comp_HelpCenterView });
ZaSettings.STATUS_PANE = "statusPane";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.STATUS_PANE, label: ZaMsg.UI_Comp_StatusPane });
ZaSettings.CERTS_VIEW = "certificatesView";
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.CERTS_VIEW, label: ZaMsg.UI_Comp_CertificatesView });
}
ZaSettings.initConst();

ZaSettings.getCalendarViewChoinces = function(){
   return  [
    {value:"day",label:ZaMsg.CalViewDay},
    {value:"week",label:ZaMsg.CalViewWeek},
    {value:"workWeek",label:ZaMsg.CalViewWorkWeek},
    {value:"month",label:ZaMsg.CalViewMonth},
    {value:"schedule",label:ZaMsg.CalViewSchedule},
    {value:"list",label:ZaMsg.CalViewList}
    ];
}
ZaSettings.calendarViewChoinces = ZaSettings.getCalendarViewChoinces; 

ZaSettings.getDayOfWeekChoices = function(){
   return [
    {value:0,label:ZaMsg.Sunday},
    {value:1,label:ZaMsg.Monday},
    {value:2,label:ZaMsg.Tuesday},
    {value:3,label:ZaMsg.Wednesday},
    {value:4,label:ZaMsg.Thursday},
    {value:5,label:ZaMsg.Friday},
    {value:6,label:ZaMsg.Saturday}
    ];
}
ZaSettings.dayOfWeekChoices = ZaSettings.getDayOfWeekChoices; 

ZaSettings.getApptVisibilityChoices = function(){
  return [
    {value:"public",label:ZaMsg.AptVisibilityPublic},
    {value:"private",label:ZaMsg.AptVisibilityPrivate}
];
}
ZaSettings.apptVisibilityChoices = ZaSettings.getApptVisibilityChoices; 

ZaSettings.getClientTypeChoices = function(){
  return [
    {value:"advanced", label:ZaMsg.clientClassic},
    {value:"modern", label:ZaMsg.clientModern},
    ];
}
ZaSettings.clientTypeChoices = ZaSettings.getClientTypeChoices;

ZaSettings.getAuthorizationScheme = function(){
  return [
    {value: "basic", label: ZaMsg.choice_basic},
    {value: "form", label: ZaMsg.choice_form}
    ];
}
ZaSettings.authorizationScheme  = ZaSettings.getAuthorizationScheme;

ZaSettings.getExchangeServerType = function(){
  return [
    {value: "webdav", label: ZaMsg.choice_webdav},
    {value: "ews", label: ZaMsg.choice_ews}
    ];
}
ZaSettings.exchangeServerType = ZaSettings.getExchangeServerType;

//List view groups
ZaSettings.OVERVIEW_CONFIG_ITEMS = [ZaSettings.COS_LIST_VIEW,ZaSettings.ZIMLET_LIST_VIEW,ZaSettings.SERVER_LIST_VIEW,ZaSettings.ADMIN_ZIMLET_LIST_VIEW,
    ZaSettings.DOMAIN_LIST_VIEW,ZaSettings.GLOBAL_CONFIG_VIEW];
ZaSettings.OVERVIEW_ADDRESSES_ITEMS = [ZaSettings.ACCOUNT_LIST_VIEW,ZaSettings.ALIAS_LIST_VIEW,ZaSettings.DL_LIST_VIEW,ZaSettings.RESOURCE_LIST_VIEW];
ZaSettings.OVERVIEW_TOOLS_ITEMS = [ZaSettings.MAILQ_VIEW,ZaSettings.DOWNLOADS_VIEW];
ZaSettings.OVERVIEW_MONITORING_ITEMS = [ZaSettings.GLOBAL_STATS_VIEW,ZaSettings.GLOBAL_STATUS_VIEW,ZaSettings.SERVER_STATS_VIEW];

ZaSettings.OVERVIEW_MANAGER_ACCOUNT_ITEMS = [ZaSettings.ACCOUNT_LIST_VIEW,ZaSettings.ALIAS_LIST_VIEW,ZaSettings.DL_LIST_VIEW,ZaSettings.RESOURCE_LIST_VIEW];
ZaSettings.OVERVIEW_ADMIN_ITEMS = [ZaSettings.COS_LIST_VIEW,ZaSettings.ZIMLET_LIST_VIEW,ZaSettings.SERVER_LIST_VIEW,ZaSettings.ADMIN_ZIMLET_LIST_VIEW,
    ZaSettings.DOMAIN_LIST_VIEW,ZaSettings.GLOBAL_CONFIG_VIEW];
ZaSettings.HELP_CENTER_ITEMS = [ZaSettings.HELP_CENTER_VIEW];
ZaSettings.STATUS_PANE_ITEMS = [ZaSettings.STATUS_PANE];
ZaSettings.OVERVIEW_MONITORING_ITEMS = [ZaSettings.MAILQ_VIEW, ZaSettings.GLOBAL_STATUS_VIEW,ZaSettings.SERVER_STATS_VIEW];
//Domain operations  - it might be duplicated to domain view tabs
ZaSettings.DOMAIN_GAL_WIZ = "domainGALWizard";
ZaSettings.DOMAIN_AUTH_WIZ = "domainAuthWizard";
ZaSettings.DOMAIN_WIKI_WIZ = "domainWikiWizard";
ZaSettings.DOMAIN_CHECK_MX_WIZ = "domainCheckMXWiz";

//Global Server Statistics View
/* No need to have the statistics view since they are all system admin only rights
ZaSettings.GLOBAL_STATS_MSG_COUNT_TAB = "globalServerStatsMsgCountTab" ;
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.GLOBAL_STATS_MSG_COUNT_TAB, label: ZaMsg.UI_Comp_globalStatsMsgCountTab });

ZaSettings.GLOBAL_STATS_MSG_VOL_TAB = "globalServerStatsMsgVolTab" ;
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.GLOBAL_STATS_MSG_VOL_TAB, label: ZaMsg.UI_Comp_globalStatsMsgVolTab });

ZaSettings.GLOBAL_STATS_MSG_ASAV_TAB = "globalServerStatsASAVTab" ;
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.GLOBAL_STATS_MSG_ASAV_TAB, label: ZaMsg.UI_Comp_globalStatsMsgASAVTab });

ZaSettings.GLOBAL_ADVANCED_STATS_TAB = "globalAdvancedStatsTab" ;
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.GLOBAL_ADVANCED_STATS_TAB, label: ZaMsg.UI_Comp_globalAdvancedStatsTab });

//Individual Server Statistics View
ZaSettings.SERVER_STATS_MSG_COUNT_TAB = "perServerStatsMsgCountTab" ;
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.SERVER_STATS_MSG_COUNT_TAB, label: ZaMsg.UI_Comp_serverStatsMsgCountTab });

ZaSettings.SERVER_STATS_MSG_VOL_TAB = "perServerStatsMsgVolTab" ;
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.SERVER_STATS_MSG_VOL_TAB, label: ZaMsg.UI_Comp_serverStatsMsgVolTab });

ZaSettings.SERVER_STATS_MSG_ASAV_TAB = "perServerStatsASAVTab" ;
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.SERVER_STATS_MSG_ASAV_TAB, label: ZaMsg.UI_Comp_serverStatsMsgASAVTab });

ZaSettings.SERVER_STATS_DISK_TAB = "perServerStatsDiskTab" ;
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.SERVER_STATS_DISK_TAB, label: ZaMsg.UI_Comp_serverStatsDiskTab });

ZaSettings.SERVER_STATS_SESSION_TAB = "perServerSessionTab" ;
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.SERVER_STATS_SESSION_TAB, label: ZaMsg.UI_Comp_serverStatsSessTab });

ZaSettings.SERVER_STATS_QUOTA_TAB = "perServerStatsQuotaTab" ;
ZaSettings.ALL_UI_COMPONENTS.push({ value: ZaSettings.SERVER_STATS_QUOTA_TAB, label: ZaMsg.UI_Comp_serverStatsQuotaTab });
*/
//Distribution list operations
//ZaSettings.DL_CREATE_RIGHT = "createDL";

//Alias operations
//ZaSettings.ALIAS_CREATE_RIGHT = "createAlias";

//Resources operations
//ZaSettings.RESOURCES_CREATE_RIGHT = "createResource";
                                            
ZaSettings.VIEW_RIGHTS = {} ;
ZaSettings.VIEW_RIGHTS [ZaSettings.ACCOUNT_LIST_VIEW] = "adminConsoleAccountRights" ;
ZaSettings.VIEW_RIGHTS [ZaSettings.DL_LIST_VIEW] = "adminConsoleDLRights" ;
ZaSettings.VIEW_RIGHTS [ZaSettings.ALIAS_LIST_VIEW] = "adminConsoleAliasRights" ;
ZaSettings.VIEW_RIGHTS [ZaSettings.RESOURCE_LIST_VIEW] = "adminConsoleResourceRights" ;

ZaSettings.VIEW_RIGHTS [ZaSettings.COS_LIST_VIEW] = "adminConsoleCOSRights" ;
ZaSettings.VIEW_RIGHTS [ZaSettings.DOMAIN_LIST_VIEW] = "adminConsoleDomainRights" ;
ZaSettings.VIEW_RIGHTS [ZaSettings.SERVER_LIST_VIEW] = "adminConsoleServerRights" ;
ZaSettings.VIEW_RIGHTS [ZaSettings.ZIMLET_LIST_VIEW] = "adminConsoleZimletRights" ;

ZaSettings.VIEW_RIGHTS [ZaSettings.GLOBAL_STATUS_VIEW] = "adminConsoleServerStatusRights" ;
ZaSettings.VIEW_RIGHTS [ZaSettings.ADMIN_ZIMLET_LIST_VIEW] = "adminConsoleExtensionRights" ;
ZaSettings.VIEW_RIGHTS [ZaSettings.GLOBAL_CONFIG_VIEW] = "adminConsoleGlobalRights" ;
ZaSettings.VIEW_RIGHTS [ZaSettings.MAILQ_VIEW] = "adminConsoleMailQueueRights" ;

ZaSettings.VIEW_RIGHTS [ZaSettings.SAVE_SEARCH] = "adminConsoleSavedSearchRights" ;

ZaSettings.VIEW_RIGHTS [ZaSettings.SERVER_STATS_VIEW] = "adminConsoleServerStatisticRights";

ZaSettings.LICENSE_ENABLED = true;
ZaSettings.ADMIN_ZIMLETS_ENABLED = true;
ZaSettings.SAVE_SEARCH_ENABLED = true ;
ZaSettings.TREE_ENABLED = true;
ZaSettings.CURRENT_APP_ENABLED = true;
ZaSettings.BANNER_ENABLED = true;
ZaSettings.STATUS_ENABLED = true;
ZaSettings.SEARCH_PANEL_ENABLED = true;


ZaSettings.SKIN_IDX = 1;
// IDs FOR HTML COMPONENTS IN THE SKIN
ZaSettings.SKIN_APP_BOTTOM_TOOLBAR_ID	= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_APP_MAIN_ID				= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_APP_TOP_TOOLBAR_ID		= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_CURRENT_APP_ID			= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_LOGO_ID					= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_SASH_ID					= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_SEARCH_BUILDER_ID		= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_SEARCH_BUILDER_TOOLBAR_ID= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_SEARCH_BUILDER_SASH_ID = ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_SEARCH_ID				= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_SHELL_ID				= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_STATUS_ID				= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_TREE_ID					= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_USER_INFO_ID			= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_APP_TABS_ID				= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_HELP_ID					= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_DW_ID					= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_LOGIN_MSG_ID            = ZaSettings.SKIN_IDX++;

ZaSettings.SKIN_LOGOFF_DOM_ID = "skin_container_logoff" ;
ZaSettings.SKIN_HELP_DOM_ID = "skin_container_help" ;
ZaSettings.SKIN_DW_DOM_ID = "skin_container_dw" ;
ZaSettings.SKIN_USER_NAME_ID = "skin_container_username";
ZaSettings.SKIN_LOGO_DOM_ID = "skin_container_logo";
ZaSettings.SKIN_TREE_ID = "skin_container_tree";
ZaSettings.SKIN_SEARCH_BUILDER_ID = "skin_container_search_builder";
ZaSettings.SKIN_SEARCH_BUILDER_TB_ID = "skin_container_search_builder_toolbar";
ZaSettings.SKIN_SEARCH_BUILDER_APP_SASH_ID = "skin_container_sb_app_sash";
ZaSettings.SKIN_APP_SASH_ID = "skin_container_tree_app_sash";
ZaSettings.SKIN_CURRENT_APP_ID = "skin_container_current_app";
ZaSettings.SKIN_STATUS_ID = "skin_container_status";
ZaSettings.SKIN_SEARCH_PANEL_ID = "skin_container_search";

// initialization for settings: [name, type, data type, default value]
ZaSettings.INIT = new Object();
// IDs FOR HTML COMPONENTS IN THE SKIN
ZaSettings.INIT[ZaSettings.SKIN_APP_MAIN_ID]				= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, "skin_container_app_main"];
ZaSettings.INIT[ZaSettings.SKIN_APP_TOP_TOOLBAR_ID]		= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, "skin_container_top_toolbar"];
ZaSettings.INIT[ZaSettings.SKIN_CURRENT_APP_ID]			= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_CURRENT_APP_ID];
ZaSettings.INIT[ZaSettings.SKIN_LOGO_ID]					= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_LOGO_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_SASH_ID]					= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_APP_SASH_ID];
ZaSettings.INIT[ZaSettings.SKIN_SEARCH_BUILDER_ID]		= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_SEARCH_BUILDER_ID];
ZaSettings.INIT[ZaSettings.SKIN_SEARCH_BUILDER_TOOLBAR_ID]= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_SEARCH_BUILDER_TB_ID];
ZaSettings.INIT[ZaSettings.SKIN_SEARCH_BUILDER_SASH_ID] = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_SEARCH_BUILDER_APP_SASH_ID];
ZaSettings.INIT[ZaSettings.SKIN_SEARCH_ID]				= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_SEARCH_PANEL_ID];
ZaSettings.INIT[ZaSettings.SKIN_SHELL_ID]					= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, "skin_outer"];
ZaSettings.INIT[ZaSettings.SKIN_STATUS_ID]				= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_STATUS_ID];
ZaSettings.INIT[ZaSettings.SKIN_TREE_ID]					= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_TREE_ID];
//ZaSettings.INIT[ZaSettings.SKIN_TREE_FOOTER_ID]			= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, "skin_container_tree_footer"];
ZaSettings.INIT[ZaSettings.SKIN_LOGIN_MSG_ID]           = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, "skin_container_login_msg"];
ZaSettings.INIT[ZaSettings.SKIN_APP_TABS_ID]            = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, "skin_container_app_tabs"];

// here new skin start.....
ZaSettings.LICENSE_ENABLED = true;
ZaSettings.ADMIN_ZIMLETS_ENABLED = true;
ZaSettings.SAVE_SEARCH_ENABLED = true ;
ZaSettings.TREE_ENABLED = true;
ZaSettings.CURRENT_APP_ENABLED = false;
ZaSettings.BANNER_ENABLED = true;
ZaSettings.STATUS_ENABLED = false;
ZaSettings.SEARCH_PANEL_ENABLED = false;

ZaSettings.SKIN_IDX = 1;
ZaSettings.SKIN_SHELL_ID				= ZaSettings.SKIN_IDX++;
// IDs FOR HTML COMPONENTS IN THE SKIN
ZaSettings.SKIN_LOGO_ID             	= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_SEARCH_ID				= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_REFRESH_ID		        = ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_PREVIOUS_ID			    = ZaSettings.SKIN_IDX
ZaSettings.SKIN_NEXT_ID			    = ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_USERNAME_ID				= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_HELP_ID					= ZaSettings.SKIN_IDX++;

ZaSettings.SKIN_TREE_TOP_ID		        = ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_TREE_ID                 = ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_TREE_FOOTER_ID          = ZaSettings.SKIN_IDX++;

ZaSettings.SKIN_APP_HEADER_ID		    = ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_APP_MAIN_ID             = ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_APP_MAIN_FOOTER_ID      = ZaSettings.SKIN_IDX++;

ZaSettings.SKIN_TOOL_HEADER_ID			= ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_TOOL_ID                 = ZaSettings.SKIN_IDX++;
ZaSettings.SKIN_TOOL_FOOTER_ID          = ZaSettings.SKIN_IDX++;
// Dom Items
ZaSettings.SKIN_SHELL_DOM_ID            = "skin_outer";

ZaSettings.SKIN_LOGO_DOM_ID             = "skin_container_logo" ;
ZaSettings.SKIN_TOASTER_DOM_ID          = "skin_container_toaster";
ZaSettings.SKIN_SEARCH_DOM_ID           = "skin_container_search" ;
ZaSettings.SKIN_REFRESH_DOM_ID          = "skin_container_refresh" ;
ZaSettings.SKIN_PREVIOUS_DOM_ID         = "skin_container_previous";
ZaSettings.SKIN_NEXT_DOM_ID             = "skin_container_next";
ZaSettings.SKIN_USERNAME_DOM_ID         = "skin_container_username";
ZaSettings.SKIN_HELP_DOM_ID             = "skin_container_help";

ZaSettings.SKIN_TREE_TOP_DOM_ID         = "skin_container_tree_top";
ZaSettings.SKIN_TREE_DOM_ID             = "skin_container_tree";
ZaSettings.SKIN_TREE_FOOTER_DOM_ID      = "skin_container_tree_footer";

ZaSettings.SKIN_APP_HEADER_DOM_ID          = "skin_container_app_tabs";
ZaSettings.SKIN_APP_MAIN_DOM_ID          = "skin_container_app_main";
ZaSettings.SKIN_APP_MAIN_FOOTER_DOM_ID   = "skin_container_main_footer";

ZaSettings.SKIN_TOOL_HEADER_DOM_ID       = "skin_container_tool_header";
ZaSettings.SKIN_TOOL_DOM_ID              = "skin_container_tool";
ZaSettings.SKIN_TOOL_FOOTER_DOM_ID       = "skin_container_tool_footer";

// initialization for settings: [name, type, data type, default value]
// IDs FOR HTML COMPONENTS IN THE SKIN
ZaSettings.INIT[ZaSettings.SKIN_SHELL_ID]		    = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_SHELL_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_LOGO_ID]		    = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_LOGO_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_SEARCH_ID]		    = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_SEARCH_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_REFRESH_ID]		    = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_REFRESH_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_PREVIOUS_ID ]	    = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_PREVIOUS_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_NEXT_ID ]	        = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_NEXT_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_USERNAME_ID]	    = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_USERNAME_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_HELP_ID]            = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_HELP_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_TREE_TOP_ID	]       = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_TREE_TOP_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_TREE_ID]		    = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_TREE_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_TREE_FOOTER_ID ]    = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_TREE_FOOTER_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_APP_HEADER_ID]	    = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_APP_HEADER_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_APP_MAIN_ID ]		= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_APP_MAIN_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_APP_MAIN_FOOTER_ID]	= [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_APP_MAIN_FOOTER_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_TOOL_HEADER_ID]     = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_TOOL_HEADER_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_TOOL_ID]            = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_TOOL_DOM_ID];
ZaSettings.INIT[ZaSettings.SKIN_TOOL_FOOTER_ID]     = [null, ZaSettings.T_CONFIG, ZaSettings.D_STRING, ZaSettings.SKIN_TOOL_FOOTER_DOM_ID];
//ZaSettings.timeZoneChoices = new XFormChoices(AjxTimezoneData.TIMEZONE_RULES, XFormChoices.OBJECT_LIST, "serverId", "serverId");
//in order to add the "Not Set" label to the timezone choices, we need to normalize it to label value pair
ZaSettings.getTimeZoneChoices = function () {
    if (!ZaSettings._timeZoneChoices) {
        ZaSettings._timeZoneChoices = [{ label: ZaMsg.VALUE_NOT_SET, value: "" }]  ;
        var tz_options_values =  AjxTimezone.getZonePreferencesOptions () ;
        var tz_options_labels = AjxTimezone.getZonePreferences () ;

        for (var i=0; i < tz_options_values.length ; i ++) {
            ZaSettings._timeZoneChoices.push({label: tz_options_labels[i],  value: tz_options_values[i]});
        }
    }
    return ZaSettings._timeZoneChoices;
}

ZaSettings.timeZoneChoices = ZaSettings.getTimeZoneChoices  ;



//ZaSettings.SKIN_TABS_DOM_ID = "skin_container_app_tabs" ;
//ZaSettings.SKIN_LOGIN_MSG_ID = "skin_td_login_msg" ;

ZaSettings.mailCharsetChoices = [
	{ value: "Big5" , label: "Big5" } ,
	{ value: "Big5-HKSCS" , label: "Big5-HKSCS" } ,
	{ value: "EUC-JP" , label: "EUC-JP" } ,
	{ value: "EUC-KR" , label: "EUC-KR" } ,
	{ value: "GB18030" , label: "GB18030" } ,
	{ value: "GB2312" , label: "GB2312" } ,
	{ value: "GBK" , label: "GBK" } ,
	{ value: "IBM-Thai" , label: "IBM-Thai" } ,
	{ value: "IBM00858" , label: "IBM00858" } ,
	{ value: "IBM01140" , label: "IBM01140" } ,
	{ value: "IBM01141" , label: "IBM01141" } ,
	{ value: "IBM01142" , label: "IBM01142" } ,
	{ value: "IBM01143" , label: "IBM01143" } ,
	{ value: "IBM01144" , label: "IBM01144" } ,
	{ value: "IBM01145" , label: "IBM01145" } ,
	{ value: "IBM01146" , label: "IBM01146" } ,
	{ value: "IBM01147" , label: "IBM01147" } ,
	{ value: "IBM01148" , label: "IBM01148" } ,
	{ value: "IBM01149" , label: "IBM01149" } ,
	{ value: "IBM037" , label: "IBM037" } ,
	{ value: "IBM1026" , label: "IBM1026" } ,
	{ value: "IBM1047" , label: "IBM1047" } ,
	{ value: "IBM273" , label: "IBM273" } ,
	{ value: "IBM277" , label: "IBM277" } ,
	{ value: "IBM278" , label: "IBM278" } ,
	{ value: "IBM280" , label: "IBM280" } ,
	{ value: "IBM284" , label: "IBM284" } ,
	{ value: "IBM285" , label: "IBM285" } ,
	{ value: "IBM297" , label: "IBM297" } ,
	{ value: "IBM420" , label: "IBM420" } ,
	{ value: "IBM424" , label: "IBM424" } ,
	{ value: "IBM437" , label: "IBM437" } ,
	{ value: "IBM500" , label: "IBM500" } ,
	{ value: "IBM775" , label: "IBM775" } ,
	{ value: "IBM850" , label: "IBM850" } ,
	{ value: "IBM852" , label: "IBM852" } ,
	{ value: "IBM855" , label: "IBM855" } ,
	{ value: "IBM857" , label: "IBM857" } ,
	{ value: "IBM860" , label: "IBM860" } ,
	{ value: "IBM861" , label: "IBM861" } ,
	{ value: "IBM862" , label: "IBM862" } ,
	{ value: "IBM863" , label: "IBM863" } ,
	{ value: "IBM864" , label: "IBM864" } ,
	{ value: "IBM865" , label: "IBM865" } ,
	{ value: "IBM866" , label: "IBM866" } ,
	{ value: "IBM868" , label: "IBM868" } ,
	{ value: "IBM869" , label: "IBM869" } ,
	{ value: "IBM870" , label: "IBM870" } ,
	{ value: "IBM871" , label: "IBM871" } ,
	{ value: "IBM918" , label: "IBM918" } ,
	{ value: "imap-utf-7" , label: "imap-utf-7" } ,
	{ value: "ISO-2022-CN" , label: "ISO-2022-CN" } ,
	{ value: "ISO-2022-JP" , label: "ISO-2022-JP" } ,
	{ value: "ISO-2022-KR" , label: "ISO-2022-KR" } ,
	{ value: "ISO-8859-1" , label: "ISO-8859-1" } ,
	{ value: "ISO-8859-13" , label: "ISO-8859-13" } ,
	{ value: "ISO-8859-15" , label: "ISO-8859-15" } ,
	{ value: "ISO-8859-2" , label: "ISO-8859-2" } ,
	{ value: "ISO-8859-3" , label: "ISO-8859-3" } ,
	{ value: "ISO-8859-4" , label: "ISO-8859-4" } ,
	{ value: "ISO-8859-5" , label: "ISO-8859-5" } ,
	{ value: "ISO-8859-6" , label: "ISO-8859-6" } ,
	{ value: "ISO-8859-7" , label: "ISO-8859-7" } ,
	{ value: "ISO-8859-8" , label: "ISO-8859-8" } ,
	{ value: "ISO-8859-9" , label: "ISO-8859-9" } ,
	{ value: "JIS_X0201" , label: "JIS_X0201" } ,
	{ value: "JIS_X0212-1990" , label: "JIS_X0212-1990" } ,
	{ value: "KOI8-R" , label: "KOI8-R" } ,
	{ value: "macintosh" , label: "macintosh" } ,
	{ value: "macintosh_ce" , label: "macintosh_ce" } ,
	{ value: "Shift_JIS" , label: "Shift_JIS" } ,
	{ value: "TIS-620" , label: "TIS-620" } ,
	{ value: "US-ASCII" , label: "US-ASCII" } ,
	{ value: "UTF-16" , label: "UTF-16" } ,
	{ value: "UTF-16BE" , label: "UTF-16BE" } ,
	{ value: "UTF-16LE" , label: "UTF-16LE" } ,
	{ value: "utf-7" , label: "utf-7" } ,
	{ value: "UTF-8" , label: "UTF-8" } ,
	{ value: "windows-1250" , label: "windows-1250" } ,
	{ value: "windows-1251" , label: "windows-1251" } ,
	{ value: "windows-1252" , label: "windows-1252" } ,
	{ value: "windows-1253" , label: "windows-1253" } ,
	{ value: "windows-1254" , label: "windows-1254" } ,
	{ value: "windows-1255" , label: "windows-1255" } ,
	{ value: "windows-1256" , label: "windows-1256" } ,
	{ value: "windows-1257" , label: "windows-1257" } ,
	{ value: "windows-1258" , label: "windows-1258" } ,
	{ value: "windows-31j" , label: "windows-31j" } ,
	{ value: "x-Big5-Solaris" , label: "x-Big5-Solaris" }/* ,
	{ value: "x-euc-jp-linux" , label: "x-euc-jp-linux" } ,
	{ value: "x-EUC-TW" , label: "x-EUC-TW" } ,
	{ value: "x-eucJP-Open" , label: "x-eucJP-Open" } ,
	{ value: "x-IBM1006" , label: "x-IBM1006" } ,
	{ value: "x-IBM1025" , label: "x-IBM1025" } ,
	{ value: "x-IBM1046" , label: "x-IBM1046" } ,
	{ value: "x-IBM1097" , label: "x-IBM1097" } ,
	{ value: "x-IBM1098" , label: "x-IBM1098" } ,
	{ value: "x-IBM1112" , label: "x-IBM1112" } ,
	{ value: "x-IBM1122" , label: "x-IBM1122" } ,
	{ value: "x-IBM1123" , label: "x-IBM1123" } ,
	{ value: "x-IBM1124" , label: "x-IBM1124" } ,
	{ value: "x-IBM1381" , label: "x-IBM1381" } ,
	{ value: "x-IBM1383" , label: "x-IBM1383" } ,
	{ value: "x-IBM33722" , label: "x-IBM33722" } ,
	{ value: "x-IBM737" , label: "x-IBM737" } ,
	{ value: "x-IBM834" , label: "x-IBM834" } ,
	{ value: "x-IBM856" , label: "x-IBM856" } ,
	{ value: "x-IBM874" , label: "x-IBM874" } ,
	{ value: "x-IBM875" , label: "x-IBM875" } ,
	{ value: "x-IBM921" , label: "x-IBM921" } ,
	{ value: "x-IBM922" , label: "x-IBM922" } ,
	{ value: "x-IBM930" , label: "x-IBM930" } ,
	{ value: "x-IBM933" , label: "x-IBM933" } ,
	{ value: "x-IBM935" , label: "x-IBM935" } ,
	{ value: "x-IBM937" , label: "x-IBM937" } ,
	{ value: "x-IBM939" , label: "x-IBM939" } ,
	{ value: "x-IBM942" , label: "x-IBM942" } ,
	{ value: "x-IBM942C" , label: "x-IBM942C" } ,
	{ value: "x-IBM943" , label: "x-IBM943" } ,
	{ value: "x-IBM943C" , label: "x-IBM943C" } ,
	{ value: "x-IBM948" , label: "x-IBM948" } ,
	{ value: "x-IBM949" , label: "x-IBM949" } ,
	{ value: "x-IBM949C" , label: "x-IBM949C" } ,
	{ value: "x-IBM950" , label: "x-IBM950" } ,
	{ value: "x-IBM964" , label: "x-IBM964" } ,
	{ value: "x-IBM970" , label: "x-IBM970" } ,
	{ value: "x-ISCII91" , label: "x-ISCII91" } ,
	{ value: "x-ISO-2022-CN-CNS" , label: "x-ISO-2022-CN-CNS" } ,
	{ value: "x-ISO-2022-CN-GB" , label: "x-ISO-2022-CN-GB" } ,
	{ value: "x-iso-8859-11" , label: "x-iso-8859-11" } ,
	{ value: "x-JIS0208" , label: "x-JIS0208" } ,
	{ value: "x-JISAutoDetect" , label: "x-JISAutoDetect" } ,
	{ value: "x-Johab" , label: "x-Johab" } ,
	{ value: "x-MacArabic" , label: "x-MacArabic" } ,
	{ value: "x-MacCentralEurope" , label: "x-MacCentralEurope" } ,
	{ value: "x-MacCroatian" , label: "x-MacCroatian" } ,
	{ value: "x-MacCyrillic" , label: "x-MacCyrillic" } ,
	{ value: "x-MacDingbat" , label: "x-MacDingbat" } ,
	{ value: "x-MacGreek" , label: "x-MacGreek" } ,
	{ value: "x-MacHebrew" , label: "x-MacHebrew" } ,
	{ value: "x-MacIceland" , label: "x-MacIceland" } ,
	{ value: "x-MacRoman" , label: "x-MacRoman" } ,
	{ value: "x-MacRomania" , label: "x-MacRomania" } ,
	{ value: "x-MacSymbol" , label: "x-MacSymbol" } ,
	{ value: "x-MacThai" , label: "x-MacThai" } ,
	{ value: "x-MacTurkish" , label: "x-MacTurkish" } ,
	{ value: "x-MacUkraine" , label: "x-MacUkraine" } ,
	{ value: "x-MS950-HKSCS" , label: "x-MS950-HKSCS" } ,
	{ value: "x-mswin-936" , label: "x-mswin-936" } ,
	{ value: "x-PCK" , label: "x-PCK" } ,
	{ value: "x-windows-50220" , label: "x-windows-50220" } ,
	{ value: "x-windows-50221" , label: "x-windows-50221" } ,
	{ value: "x-windows-874" , label: "x-windows-874" } ,
	{ value: "x-windows-949" , label: "x-windows-949" } ,
	{ value: "x-windows-950" , label: "x-windows-950" } ,                                   
	{ value: "x-windows-iso2022jp" , label: "x-windows-iso2022jp" }*/
] ;

ZaSettings.getLocaleChoices = function () {

    if (!ZaSettings.localeChoices) {
        var soapDoc = AjxSoapDoc.create("GetAvailableLocalesRequest", "urn:zimbraAccount", null);
        var params = {};
        params.soapDoc = soapDoc;

        var reqMgrParams = {
            controller: (ZaApp.getInstance() ? ZaApp.getInstance().getCurrentController() : null),
            busyMsg: ZaMsg.BUSY_GET_LOCALE
        }

        var resp = ZaRequestMgr.invoke(params, reqMgrParams).Body.GetAvailableLocalesResponse;
        var locales = resp.locale;

        ZaSettings.localeChoices = [];

        for (var i = 0; i < locales.length; i++) {
            var displayLabel = locales[i].localName;

            if (locales[i].name != locales[i].localName) {
                displayLabel += " - " + locales[i].name;
            }

            // bug: 38038
            var localeId = locales[i].id.replace(/^in/,"id");

            ZaSettings.localeChoices.push({
                value: localeId,
                label: displayLabel
            });
        }
    }

    return ZaSettings.localeChoices ;
}

ZaSettings.isNetworkVersion = function () {
    return (ZaSettings.IS_ZCS_NETWORK_VERSION || false );
}

ZaSettings.isOctopus = function () {
    return (ZaSettings.IS_OCTOPUS || false);
}

ZaSettings.getSmtpDnsSupportLevel = function(){
	return [
		{value : "enabled", label : ZaMsg.NAD_MTA_SMTP_Dns_Enabled},
		{value : "disabled", label : ZaMsg.NAD_MTA_SMTP_Dns_Disabled},
		{value : "dnssec", label : ZaMsg.NAD_MTA_SMTP_Dns_Dnssec}
	];
};

ZaSettings.smtpDnsSupportLevel = ZaSettings.getSmtpDnsSupportLevel;

ZaSettings.getFeatureResetPasswordStatus = function(){
    return [
        {value: "enabled", label: ZaMsg.LBL_enabled},
        {value: "suspended", label: ZaMsg.LBL_suspended},
        {value: "disabled", label: ZaMsg.LBL_disabled}
    ];
};

ZaSettings.resetPasswordStatusChoices = ZaSettings.getFeatureResetPasswordStatus;

ZaSettings.getPasswordRecoveryAddressStatus = function(){
    return [
        {value: "", label: ZaMsg.LBL_unset},
        {value: "verified", label: ZaMsg.LBL_verified},
        {value: "pending", label: ZaMsg.LBL_pending}
    ];
};

ZaSettings.passwordRecoveryAddressStatusChoices = ZaSettings.getPasswordRecoveryAddressStatus;
}
if (AjxPackage.define("zimbraAdmin.common.ZaAppCtxt")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @constructor ZaAppCtxt
* @class ZaAppCtxt
*/
ZaAppCtxt = function() {
}

ZaAppCtxt.LABEL = "appCtxt";

ZaAppCtxt.prototype.toString = 
function() {
	return "ZaAppCtxt";
}

/**
* Gets the app context from the given shell.
*
* @param shell		the shell
* @return			the app context
*/
ZaAppCtxt.getFromShell =
function(shell) {
	return shell.getData(ZaAppCtxt.LABEL);
}



ZaAppCtxt.prototype.setAppController =
function(appController) {
	this._appController = appController;
}

ZaAppCtxt.prototype.getAppController =
function() {
	return this._appController;
}


ZaAppCtxt.prototype.getApp =
function() {
	return this._appController.getApp();
}

ZaAppCtxt.prototype.getAppViewMgr =
function() {
	return this._appController.getAppViewMgr();
}

ZaAppCtxt.prototype.setClientCmdHdlr =
function(clientCmdHdlr) {
	this._clientCmdHdlr = clientCmdHdlr;
}

ZaAppCtxt.prototype.getClientCmdHdlr =
function() {
	return this._clientCmdHdlr;
}

ZaAppCtxt.prototype.getSearchController =
function() {
	return this._appController.getSearchController();
}

ZaAppCtxt.prototype.getLoginDialog =
function() {
	if (!this._loginDialog)
		this._loginDialog = new ZaLoginDialog(this.getShell(), null, null, this);
	return this._loginDialog;
}

ZaAppCtxt.prototype.getMsgDialog =
function(refresh) {
	if (!this._msgDialog || refresh)
		this._msgDialog = new ZaMsgDialog(this.getShell());
	return this._msgDialog;
}

ZaAppCtxt.prototype.getConfirmMsgDialog = function (refresh) {
	if(!this._confirmMsgDialog || refresh) {
		this._confirmMsgDialog = new ZaMsgDialog(this.getShell(), null, [DwtDialog.YES_BUTTON, DwtDialog.NO_BUTTON, DwtDialog.CANCEL_BUTTON], null, ZaId.CTR_GLOBAL + "_confirm3btn");
	}
	return this._confirmMsgDialog;
}
 
ZaAppCtxt.prototype.getConfirmMsgDialog2 = function (refresh) {
	if(!this._confirmMessageDialog2 || refresh) {
		this._confirmMessageDialog2 = new ZaMsgDialog(this.getShell(), null, [DwtDialog.YES_BUTTON, DwtDialog.NO_BUTTON], null, ZaId.CTR_GLOBAL + "_confirm2btn");
	}
	return this._confirmMessageDialog2;
}


ZaAppCtxt.prototype.getErrorDialog = 
function(refresh) {
	if (!this._errorDialog || refresh)
		this._errorDialog = new ZaErrorDialog(this.getShell());
	return this._errorDialog;
}

ZaAppCtxt.prototype.getShell =
function() {
	return this._shell;
}

ZaAppCtxt.prototype.setShell =
function(shell) {
	this._shell = shell;
	shell.setData(ZaAppCtxt.LABEL, this);
}


ZaAppCtxt.prototype.getFolderTree =
function() {
	return this._folderTree;
}

ZaAppCtxt.prototype.setFolderTree =
function(folderTree) {
	this._folderTree = folderTree;
}

ZaAppCtxt.prototype.getUsername = 
function() { 
	return this._username;
}

ZaAppCtxt.prototype.setUsername = 
function(username) {
	this._username = username;
}

ZaAppCtxt.prototype.getCurrentSearch =
function() { 
	return this._currentSearch;
}

ZaAppCtxt.prototype.setCurrentSearch =
function(search) {
	this._currentSearch = search;
}

ZaAppCtxt.prototype.getSettings =
function() {
	if (!this._settings)
		this._settings = new ZaSettings(this);
	return this._settings;
}

// NOTE: this is only to be used by any child windows!
ZaAppCtxt.prototype.setSettings = 
function(settings) {
	this._settings = settings;
}

ZaAppCtxt.prototype.getRootTabGroup =
function() {
	if (!this._rootTabGrp)
		this._rootTabGrp = new DwtTabGroup("ROOT");
	return this._rootTabGrp;
}

ZaAppCtxt.getLogoURI =
function () {
    if (skin && skin.hints && skin.hints.banner) {
        return skin.hints.banner.url ;
    } else {
        return ZaSettings.LOGO_URI ;
    }
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaAuthenticate")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2012, 2013, 2014, 2015, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2012, 2013, 2014, 2015, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

ZaAuthenticate = function(appCtxt) {
    if (arguments.length == 0) return;
    this._appCtxt = appCtxt;
    this.uname = "";
}


ZaAuthenticate.processResponseMethods = new Array();

ZaAuthenticate.prototype.toString = 
function() {
    return "ZaAuthenticate";
}

ZaAuthenticate.prototype.changePassword = 
function (uname,oldPass,newPass,callback) {
    var soapDoc = AjxSoapDoc.create("ChangePasswordRequest", "urn:zimbraAccount");
    var el = soapDoc.set("account", uname);
    el.setAttribute("by", "name");
    soapDoc.set("oldPassword", oldPass);
    soapDoc.set("password", newPass);

    var command = new ZmCsfeCommand();
    var params = new Object();
    params.soapDoc = soapDoc;    
    params.asyncMode = true;
    params.noAuthToken=true;
    params.callback = callback;
    command.invoke(params);    
}

ZaAuthenticate.prototype.execute =
function (uname, pword, callback, twoFactorCode, trustedDevice) {
    var soapDoc = AjxSoapDoc.create("AuthRequest", ZaZimbraAdmin.URN, null);
    this.uname = uname;
    var params = new Object();
    params.noAuthToken=true;
    params.ignoreAuthToken = true;
    if(uname && pword) {
        soapDoc.set("name", uname);
        soapDoc.set("password", pword);
    } else {
        soapDoc.getMethod().setAttribute("refresh", "1");
    }
    if(twoFactorCode) {
        soapDoc.set("twoFactorCode", twoFactorCode);
    }
    if(trustedDevice) {
        soapDoc.set("trustedDevice", trustedDevice);
    }
    soapDoc.set("virtualHost", location.hostname);
    soapDoc.set("csrfTokenSecured", 1);
    var command = new ZmCsfeCommand();
    params.soapDoc = soapDoc;
    params.asyncMode = true;
    params.skipExpiredToken = true;
    params.callback = callback;
    command.invoke(params);
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaPopupMenu")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaPopupMenu
* @constructor
* @param parent
* @param className
* @param dialog
* @param opList
*
* This widget class extends DwtMenu. Similar to ZaToolBar, this class creates
* buttons form an array of ZaOperation objects
**/
ZaPopupMenu = function(parent, className, dialog, opList, contextId, menuType, btnOrder) {
	if (arguments.length == 0) return;
	className = className || "ActionMenu";
        this._contextId = contextId;
	this._menuType = menuType;
	DwtMenu.call(this, parent, DwtMenu.POPUP_STYLE, className, null, dialog, ZaId.getMenuId(this._contextId,this._menuType));
	this._menuItems = new Object();	
	if(opList) {
		//var cnt = opList.length;

        var ix = 0;
        for(ix = 0; btnOrder && ix < btnOrder.length; ix++) {
            if(opList[btnOrder[ix]] instanceof ZaOperation) {
                if(opList[btnOrder[ix]].id == ZaOperation.NONE  || opList[btnOrder[ix]].id == ZaOperation.HELP)
                    continue;

                var style = (opList[btnOrder[ix]].id == ZaOperation.SEP) ? DwtMenuItem.SEPARATOR_STYLE : DwtMenuItem.NO_STYLE;
                this.createMenuItem(opList[btnOrder[ix]].id, opList[btnOrder[ix]].imageId, opList[btnOrder[ix]].caption, null, opList[btnOrder[ix]].enabled,style,null);
                this.addSelectionListener(opList[btnOrder[ix]].id, opList[btnOrder[ix]].listener);
            }
        }
        // add the remained buttons
        for(ix in opList) {
            if(!btnOrder || AjxUtil.indexOf(btnOrder,ix) < 0) {
                if(opList[ix] instanceof ZaOperation) {
                    if(opList[ix].id == ZaOperation.NONE  || opList[ix].id == ZaOperation.HELP)
                        continue;

                    var style = (opList[ix].id == ZaOperation.SEP) ? DwtMenuItem.SEPARATOR_STYLE : DwtMenuItem.NO_STYLE;
                    this.createMenuItem(opList[ix].id, opList[ix].imageId, opList[ix].caption, null, opList[ix].enabled,style,null);
                    this.addSelectionListener(opList[ix].id, opList[ix].listener);
                }
            }
        }
	}
}

ZaPopupMenu.prototype = new DwtMenu;
ZaPopupMenu.prototype.constructor = ZaPopupMenu;

ZaPopupMenu.prototype.toString = 
function() {
	return "ZaPopupMenu";
}

ZaPopupMenu.prototype.addSelectionListener =
function(menuItemId, listener) {
	this._menuItems[menuItemId].addSelectionListener(listener);
}

ZaPopupMenu.prototype.removeSelectionListener =
function(menuItemId, listener) {
	this._menuItems[menuItemId].removeSelectionListener(listener);
}

ZaPopupMenu.prototype.popup =
function(delay, x, y, kbGenerated) {
	if (delay == null)
		delay = 0;
	if (x == null) 
		x = Dwt.DEFAULT;
	if (y == null)
		y = Dwt.DEFAULT;
	DwtMenu.prototype.popup.call(this, delay, x, y, kbGenerated);
}

ZaPopupMenu.prototype.getMenuItem = 
function (menuItemId) {
	return this._menuItems[menuItemId];
}
/**
* Enables/disables menu items.
*
* @param ids		a list of menu item IDs
* @param enabled	whether to enable the menu items
*/
ZaPopupMenu.prototype.enable =
function(ids, enabled) {
	if (!(ids instanceof Array))
		ids = [ids];
	for (var i = 0; i < ids.length; i++)
		if (this._menuItems[ids[i]])
			this._menuItems[ids[i]].setEnabled(enabled);
}

ZaPopupMenu.prototype.enableAll =
function(enabled) {
	for (var i in this._menuItems)
		this._menuItems[i].setEnabled(enabled);
}

ZaPopupMenu.prototype.addMenuItem =
function(menuItemId, menuItem) {
	this._menuItems[menuItemId] = menuItem;
}

ZaPopupMenu.prototype.createMenuItem =
function(menuItemId, imageId, text, disImageId, enabled, style, radioGroupId) {
	var mi = this._menuItems[menuItemId] = new DwtMenuItem({
		parent:		this, 
		style:		style, 
		radioGroupId: 	radioGroupId, 
		id: 		ZaId.getMenuItemId(this._contextId, ZaOperation.getStringName(menuItemId))
	});
	if (imageId)
		mi.setImage(imageId);
	if (text)
		mi.setText(text);
	mi.setEnabled(enabled !== false);
	return mi;
}

ZaPopupMenu.prototype.createSeparator =
function() {
	new DwtMenuItem(this, DwtMenuItem.SEPARATOR_STYLE);
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaAppViewMgr")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* Creates a layout manager from the given components.
* @constructor
* @class
* This class manages layout. The layout is divided into the following parts:
* <p><ul>
*  <li>banner: static; has a few account-related buttons</li>
*  <li>search bar: static; has buttons for various ways to search, including browse</li>
*  <li>overview panel: tree view of folders, tags, app links</li>
*  <li>sash: a thin moveable vertical bar for resizing the surrounding elements
*  <li>app container: the most dynamic area; displays app-specific toolbar and content</li>
* </ul></p>
* <p>
* Visibility is managed through Z indexes, which have constants in the following order:</p>
* <p>
* Z_HIDDEN, Z_CURTAIN, Z_VIEW, Z_TOOLTIP, Z_MENU, Z_VEIL, Z_DIALOG, Z_BUSY</p>
* <p>
* Since z-index matters only among peer elements, anything that we manage via z-index has to
* hang off the shell. To manage an app view, we create an app container that hangs off the shell
* and put the app view in there.</p>
* <p>
* The app container lays out the app elements in the desired style, for example, in a vertical
* layout. Different layout styles can be added here, and then specified when the app view is
* created.</p>
* <p>
* Some views are "volatile", which means they trigger browser bugs when we try to hide them. It happens
* with views that contain forms. In IE, SELECT fields don't obey z-index, and in Firefox, the cursor
* bleeds through.
*
* @author Conrad Damon
* @author Ross Dargahi
* @param shell			the outermost containing element
* @param banner			the banner
* @param controller		the app controller
*/
ZaAppViewMgr = function(shell, controller, hasSkin) {

	this._shell = shell;
	this._controller = controller;
	this._appCtxt = controller._appCtxt;
    this._shellSz = this._shell.getSize();
	this._shell.addControlListener(new AjxListener(this, this._shellControlListener));
	this._needBannerLayout = false;
	this._sashSupported = (window.skin && typeof window.skin.setTreeWidth == "function");
        this._sbSashSupported = (window.skin && typeof window.skin.setSBHeight == "function");
/*	this._sash = new DwtSash(this._shell, DwtSash.HORIZONTAL_STYLE, "AppSash-horiz", 5);
	this._sash.registerCallback(this._sashCallback, this);
*/	
	this._currentView = null;			// name of currently visible view
	this._views = new Object();			// hash that gives names to app views
	this._hidden = new Array();			// stack of views that aren't visible
	
	this._layoutStyle = new Object();	// hash matching view to layout style
	this._staleCallback = new Object(); // when topmost view is popped, allow underlying view to cleanup

	this._compList = new Array();		// list of component IDs
	this._components = new Object();	// component objects (widgets)
	this._htmlEl = new Object();		// their HTML elements
	this._containers = new Object();	// containers within the skin
	this._contBounds = new Object();	// bounds for the containers
	
	// view preemption
	this._pushCallback = new AjxCallback(this, this.pushView);
//	this._popCallback = new AjxCallback(this, this.popView);
	
/*	// hash matching layout style to their methods	
	this._layoutMethod = new Object();
	this._layoutMethod[ZaAppViewMgr.LAYOUT_VERTICAL] = this._appLayoutVertical;
*/	
}

ZaAppViewMgr.DEFAULT = -1;

// reasons the layout changes
ZaAppViewMgr.RESIZE = 1;
ZaAppViewMgr.BROWSE = 2;
ZaAppViewMgr.OVERVIEW = 3;

// visible margins (will be shell background color)
ZaAppViewMgr.TOOLBAR_SEPARATION = 0;	// below search bar
ZaAppViewMgr.COMPONENT_SEPARATION = 2;	// in app container

// layout styles
ZaAppViewMgr.LAYOUT_VERTICAL = 1;	// top to bottom, full width, last element gets remaining space

// used when coming back from pop shield callbacks
ZaAppViewMgr.PENDING_VIEW = "ZaAppViewMgr.PENDgING_VIEW";


// components
ZaAppViewMgr.C_BANNER					= "BANNER";
ZaAppViewMgr.C_SEARCH					= "SEARCH";
ZaAppViewMgr.C_SEARCH_BUILDER			= "SEARCH BUILDER";
ZaAppViewMgr.C_SEARCH_BUILDER_TOOLBAR	= "SEARCH BUILDER TOOLBAR";
ZaAppViewMgr.C_SEARCH_BUILDER_SASH     = "SEARCH BUILDER SASH";
ZaAppViewMgr.C_CURRENT_APP				= "CURRENT APP";
ZaAppViewMgr.C_APP_TABS					= "APP TABS" ;
ZaAppViewMgr.C_TREE						= "TREE";
//ZaAppViewMgr.C_TREE_FOOTER				= "TREE FOOTER";
ZaAppViewMgr.C_TOOLBAR_TOP				= "TOP TOOLBAR";
ZaAppViewMgr.C_APP_CONTENT				= "APP CONTENT";
ZaAppViewMgr.C_STATUS					= "STATUS";
ZaAppViewMgr.C_SASH						= "SASH";
ZaAppViewMgr.C_LOGIN_MESSAGE            = "LOGIN_MESSAGE" ;

// keys for getting container IDs
ZaAppViewMgr.CONT_ID_KEY = new Object();
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_BANNER]					= ZaSettings.SKIN_LOGO_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_SEARCH]					= ZaSettings.SKIN_SEARCH_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_SEARCH_BUILDER]			= ZaSettings.SKIN_SEARCH_BUILDER_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_SEARCH_BUILDER_TOOLBAR]	= ZaSettings.SKIN_SEARCH_BUILDER_TOOLBAR_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_SEARCH_BUILDER_SASH] = ZaSettings.SKIN_SEARCH_BUILDER_SASH_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_CURRENT_APP]			= ZaSettings.SKIN_CURRENT_APP_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_TREE]					= ZaSettings.SKIN_TREE_ID;
//ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_TREE_FOOTER]			= ZaSettings.SKIN_TREE_FOOTER_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_TOOLBAR_TOP]			= ZaSettings.SKIN_APP_TOP_TOOLBAR_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_APP_CONTENT]			= ZaSettings.SKIN_APP_MAIN_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_STATUS]					= ZaSettings.SKIN_STATUS_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_SASH]					= ZaSettings.SKIN_SASH_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_APP_TABS]				= ZaSettings.SKIN_APP_TABS_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_LOGIN_MESSAGE]	        = ZaSettings.SKIN_LOGIN_MSG_ID;

// components
ZaAppViewMgr.C_BANNER					= "BANNER";
ZaAppViewMgr.C_SEARCH					= "SEARCH";

ZaAppViewMgr.C_TREE_TOP				    = "TREE TOP";
ZaAppViewMgr.C_TREE						= "TREE";
ZaAppViewMgr.C_TREE_FOOTER				= "TREE FOOTER";

ZaAppViewMgr.C_APP_HEADER				= "APP HEADER";
ZaAppViewMgr.C_APP_CONTENT			    = "APP CONTENT";
ZaAppViewMgr.C_APP_FOOTER				= "APP FOOTER";

ZaAppViewMgr.C_TOOL_HEADER				= "TOOL HEADER";
ZaAppViewMgr.C_TOOL				        = "TOOL";
ZaAppViewMgr.C_TOOL_FOOTER				= "TOOL FOOTER";

// keys for getting container IDs
ZaAppViewMgr.CONT_ID_KEY = new Object();
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_BANNER]					= ZaSettings.SKIN_LOGO_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_SEARCH]					= ZaSettings.SKIN_SEARCH_ID;

ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_TREE_TOP]			    = ZaSettings.SKIN_TREE_TOP_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_TREE]					= ZaSettings.SKIN_TREE_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_TREE_FOOTER]			= ZaSettings.SKIN_TREE_FOOTER_ID;

ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_APP_HEADER]			    = ZaSettings.SKIN_APP_HEADER_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_APP_CONTENT]			= ZaSettings.SKIN_APP_MAIN_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_APP_FOOTER]			    = ZaSettings.SKIN_APP_MAIN_FOOTER_ID;

ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_TOOL_HEADER]			= ZaSettings.SKIN_TOOL_HEADER_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_TOOL]				    = ZaSettings.SKIN_TOOL_ID;
ZaAppViewMgr.CONT_ID_KEY[ZaAppViewMgr.C_TOOL_FOOTER]	        = ZaSettings.SKIN_TOOL_FOOTER_ID;

// Public methods
ZaAppViewMgr.prototype.toString = 
function() {
	return "ZaAppViewMgr";
}

ZaAppViewMgr.prototype.getShell = 
function() {
	return this._shell;
}

/**
* Returns the name of the app view currently being displayed.
*/
ZaAppViewMgr.prototype.getCurrentView =
function() {
	return this._currentView;
}

ZaAppViewMgr.prototype.getCurrentViewContent =
function() {
    var elements = this._views[this._currentView];
	var content = elements[ZaAppViewMgr.C_APP_CONTENT];
	return content;
}

ZaAppViewMgr.prototype.getViewContentById =
function(id) {
    var elements = this._views[id];
    if (!elements)
        return "";
	var content = elements[ZaAppViewMgr.C_APP_CONTENT];
	return content;
}
/**
* Creates an app view from the given components and puts it in an app container.
*
* @param viewName		the name of the view
* @param appName		the name of the owning app
* @param elements		an array of elements to display
* @return				the app view
*/
ZaAppViewMgr.prototype.createView =
function(viewId, elements) {
	this._views[viewId] = elements;
	this.addComponents(elements, false, true);
}

/**
* Makes the given view visible, pushing the previously visible one to the top of the
* hidden stack.
*
* @param viewId	the name of the app view to push
* @return			the id of the view that is displayed
*/
ZaAppViewMgr.prototype.pushView =
function(viewId) {
	// if same view, no need to go through hide/show
	if (viewId == this._currentView) {
		this._setTitle(viewId);
		return viewId;
	}

	this._setViewVisible(this._currentView, false);
	if (this._currentView && (this._currentView != viewId))
		this._hidden.push(this._currentView);

	this._removeFromHidden(viewId);
	var temp = this._lastView;
	this._lastView = this._currentView;
	this._currentView = viewId;

	this._setViewVisible(viewId, true);

	return viewId;
}

/**
* Hides the currently visible view, and makes the view on top of the hidden stack visible.
*
* @return		the id of the view that is displayed
*/
ZaAppViewMgr.prototype.popView =
function() {
	if (!this._currentView)
		throw new AjxException("no view to pop");

	this._setViewVisible(this._currentView,false);

	this._lastView = this._currentView;
	this._currentView = this._hidden.pop();

	if (!this._currentView)
		throw new AjxException("no view to show");
		
	this._removeFromHidden(this._currentView);

	this._setViewVisible(this._currentView, true);
	return this._currentView;
}

ZaAppViewMgr.prototype.removeHiddenView = 
function(viewId) {
	var cnt = this._hidden.length;
	for(var ix =0; ix< cnt;ix++) {
		if(this._hidden[ix] == viewId) {
			this._hidden.splice(ix,1);
		}
	}
}
/**
* Makes the given view visible, and clears the hidden stack.
*
* @param viewName	the name of a view
* @return			true if the view was set
*/
ZaAppViewMgr.prototype.setView =
function(viewName) {
//	DBG.println(AjxDebug.DBG1, "setView: " + viewName);
	var result = this.pushView(viewName);
    if (result)
		this._hidden = new Array();
	return result;
}

ZaAppViewMgr.prototype.addComponents =
function(components, doFit, noSetZ) {
	var list = new Array();
	for (var cid in components) {
		this._compList.push(cid);
		var comp = components[cid];
		this._components[cid] = comp;
		var htmlEl = comp.getHtmlElement();
		this._htmlEl[cid] = htmlEl;
		var contId = ZaSettings.get(ZaAppViewMgr.CONT_ID_KEY[cid]);
		var contEl = document.getElementById(contId);
		if(!contEl) {
			continue;
		}
		this._containers[cid] = contEl;
		if (Dwt.contains(contEl, htmlEl))
			throw new AjxException("element already added to container: " + cid);		
		Dwt.removeChildren(contEl);
		
		list.push(cid);
		
		if (!noSetZ)
			comp.zShow(true);

		if (cid == ZaAppViewMgr.C_SEARCH_BUILDER  || cid == ZaAppViewMgr.C_SEARCH_BUILDER_TOOLBAR ) {
			//this._components[ZaAppViewMgr.C_SEARCH_BUILDER_TOOLBAR].setLocation(Dwt.LOC_NOWHERE, Dwt.LOC_NOWHERE);
			DBG.println(AjxDebug.DBG1, "Enforce Z-index to hidden " + cid) ;
			comp.zShow(false);
		}
                
        if (cid == ZaAppViewMgr.C_SEARCH_BUILDER_SASH){
                comp.zShow(false);
                if(this._sbSashSupported){
                     comp.registerCallback(this._sbAppSashCallback, this);
                }
                comp.setCursor("default");
        }
                
		if (cid == ZaAppViewMgr.C_SASH) {
			if (this._sashSupported){
				comp.registerCallback(this._appTreeSashCallback, this);
			}
			comp.setCursor("default");
		}
	}
	if (doFit)
		this._stickToGrid(list);
}
ZaAppViewMgr.prototype.showSearchBuilder =
function(visible) {
	DBG.println(AjxDebug.DBG1, "show search builder: " + visible);
	skin.showSearchBuilder(visible);
	this._components[ZaAppViewMgr.C_SEARCH_BUILDER_TOOLBAR].zShow(visible);
	this._components[ZaAppViewMgr.C_SEARCH_BUILDER].zShow(visible);
        this._components[ZaAppViewMgr.C_SEARCH_BUILDER_SASH].zShow(visible);

    if (visible) this._isAdvancedSearchBuilderDisplayed = true ;
   /* var list = [ZaAppViewMgr.C_SEARCH_BUILDER, ZaAppViewMgr.C_SEARCH_BUILDER_TOOLBAR,
                ZaAppViewMgr.C_LOGIN_MESSAGE,
                ZaAppViewMgr.C_CURRENT_APP, ZaAppViewMgr.C_APP_CHOOSER, ZaAppViewMgr.C_APP_TABS,
				ZaAppViewMgr.C_TREE,
				ZaAppViewMgr.C_TREE_FOOTER, ZaAppViewMgr.C_TOOLBAR_TOP, ZaAppViewMgr.C_APP_CONTENT];
	this._stickToGrid(list);*/
	this.fitAll();
	// search builder contains forms, and browsers have quirks around form fields and z-index
	if (!visible) {
		this._components[ZaAppViewMgr.C_SEARCH_BUILDER].setLocation(Dwt.LOC_NOWHERE, Dwt.LOC_NOWHERE);
	}
};
ZaAppViewMgr.prototype.fitAll = function () {
    var list = [ZaAppViewMgr.C_SEARCH_BUILDER, ZaAppViewMgr.C_SEARCH_BUILDER_TOOLBAR, ZaAppViewMgr.C_SEARCH_BUILDER_SASH,
                ZaAppViewMgr.C_LOGIN_MESSAGE,
                ZaAppViewMgr.C_CURRENT_APP, /*ZaAppViewMgr.C_APP_CHOOSER,*/ ZaAppViewMgr.C_APP_TABS,
                ZaAppViewMgr.C_BANNER,
				ZaAppViewMgr.C_TREE,ZaAppViewMgr.C_SASH,
				/*ZaAppViewMgr.C_TREE_FOOTER,*/ ZaAppViewMgr.C_TOOLBAR_TOP, ZaAppViewMgr.C_APP_CONTENT];

    list = [
	        ZaAppViewMgr.C_BANNER,
	        ZaAppViewMgr.C_SEARCH,
	
	        ZaAppViewMgr.C_TREE_TOP	,
	        ZaAppViewMgr.C_TREE	,
	        ZaAppViewMgr.C_TREE_FOOTER ,
	
	        ZaAppViewMgr.C_APP_HEADER,
	        ZaAppViewMgr.C_APP_CONTENT,
	        ZaAppViewMgr.C_APP_FOOTER,
	
	        ZaAppViewMgr.C_TOOL_HEADER ,
	        ZaAppViewMgr.C_TOOL ,
	        ZaAppViewMgr.C_TOOL_FOOTER
	];
	this._stickToGrid(list);
}
ZaAppViewMgr.prototype._stickToGrid = 
function(components) {
	this._shell.relayout();
	for (var i = 0; i < components.length; i++) {
		var cid = components[i];
		// don't resize logo image (it will tile) or reposition it (centered via style)
		//if (cid == ZaAppViewMgr.C_BANNER) continue;
		//DBG.println(AjxDebug.DBG3, "fitting to container: " + cid);
		var cont = this._containers[cid];
		if (cont) {
			var contBds = ZaAppViewMgr._getBounds(cont, cid);
			var comp = this._components[cid];
			if (
				cid == ZaAppViewMgr.C_APP_CONTENT || 
				cid == ZaAppViewMgr.C_TOOLBAR_TOP  ) {
				// make sure we fit the component that's current
				var elements = this._views[this._currentView];
				comp = elements[cid];
			}
			if (comp && (comp.getZIndex() != Dwt.Z_HIDDEN)) {
                /*
                var y =  contBds.y ;
                var h =  contBds.height ;
                if (AjxEnv.isIE && (!this._isAdvancedSearchBuilderDisplayed)) {
                    //bug  22173: IE hacking. Seems that the banner image size screw the height in IE. Maybe a small banner image on IE is the final solution?
                    //Also the advanced Search Builder expand/collapse will also affect the display behavior. WEIRD! 
                    if ( cid == ZaAppViewMgr.C_TREE )  {
                        y += 8 ;
                        h -= 5 ;
                    }else if ( cid == ZaAppViewMgr.C_CURRENT_APP ) {
                        y += 5 ;
                    }
                }*/
				try {
                	comp.setBounds(contBds.x, contBds.y, contBds.width, contBds.height);
				} catch (ex) {
					ZaApp.getInstance().getCurrentController()._handleException(ex, "ZaAppViewMgr.prototype._stickToGrid", nul, false);
				}
                this._contBounds[cid] = contBds;

				//call the components resizeListener to rearrange the component layout
				if (comp._resizeListener) {
					comp._resizeListener();
				}
			}
		}
	}
	//this._debugShowMetrics(components);
}

ZaAppViewMgr._getBounds =
function (contEl, cid) {
    var bounds = Dwt.getBounds(contEl);
    if (cid == ZaAppViewMgr.C_TREE ||
        cid == ZaAppViewMgr.C_APP_CONTENT ||
        cid == ZaAppViewMgr.C_TOOL
        ) {
        // consider the border issues
        // TODO get border value by js
        bounds.x = bounds.x + 1;
        bounds.width = bounds.width > 2 ? (bounds.width - 2) : bounds.width;
    }
    return bounds;
}

// Removes a view from the hidden stack.
ZaAppViewMgr.prototype._removeFromHidden =
function(view) {
	var newHidden = new Array();
	for (var i = 0; i < this._hidden.length; i++)
		if (this._hidden[i] != view)
			newHidden.push(this._hidden[i]);
	this._hidden = newHidden;
}

// Listeners

// Handles shell resizing event.
ZaAppViewMgr.prototype._shellControlListener =
function(ev) {
	if (ev.oldWidth != ev.newWidth || ev.oldHeight != ev.newHeight) {
		this._shellSz.x = ev.newWidth;
		this._shellSz.y = ev.newHeight;
		var deltaWidth = ev.newWidth - ev.oldWidth;
		var deltaHeight = ev.newHeight - ev.oldHeight;
		DBG.println(AjxDebug.DBG1, "shell control event: dW = " + deltaWidth + ", dH = " + deltaHeight);
		if (this._isNewWindow) {
			
			//reset the tab group's tab size
			var tabs = this._views[this._currentView][ZaAppViewMgr.C_APP_TABS] ;
			if (tabs) 
				tabs.setSize(ev.newWidth, Dwt.DEFAULT);
				
			// reset width of top toolbar
			var topToolbar = this._views[this._currentView][ZaAppViewMgr.C_TOOLBAR_TOP];
			if (topToolbar)
				topToolbar.setSize(ev.newWidth, Dwt.DEFAULT);
				
				
			// make sure to remove height of top toolbar for height of app content
			var appContent = this._views[this._currentView][ZaAppViewMgr.C_APP_CONTENT];
			if (appContent)
				appContent.setSize(ev.newWidth, ev.newHeight - topToolbar.getH());
			
		} else {
			if (deltaHeight) {
				var list = [ZaAppViewMgr.C_APP_CHOOSER, ZaAppViewMgr.C_SASH, ZaAppViewMgr.C_APP_CONTENT,ZaAppViewMgr.C_TREE/*, ZaAppViewMgr.C_STATUS*/];
				list = [
		            ZaAppViewMgr.C_TREE_TOP	,
		            ZaAppViewMgr.C_TREE	,
		            ZaAppViewMgr.C_TREE_FOOTER ,
		
		            ZaAppViewMgr.C_APP_HEADER,
		            ZaAppViewMgr.C_APP_CONTENT,
		            ZaAppViewMgr.C_APP_FOOTER,
		
		            ZaAppViewMgr.C_TOOL_HEADER ,
		            ZaAppViewMgr.C_TOOL ,
		            ZaAppViewMgr.C_TOOL_FOOTER
		            ];
				this._stickToGrid(list);
			}
			if (deltaWidth) {
				var list = [ZaAppViewMgr.C_BANNER, ZaAppViewMgr.C_APP_TABS, ZaAppViewMgr.C_LOGIN_MESSAGE,
							ZaAppViewMgr.C_TOOLBAR_TOP, ZaAppViewMgr.C_APP_CONTENT, 
							ZaAppViewMgr.C_SEARCH,
							ZaAppViewMgr.C_SEARCH_BUILDER, ZaAppViewMgr.C_SEARCH_BUILDER_TOOLBAR, ZaAppViewMgr.C_SEARCH_BUILDER_SASH];
				list = [
				        ZaAppViewMgr.C_BANNER,
				        ZaAppViewMgr.C_SEARCH,
	
				        ZaAppViewMgr.C_APP_HEADER,
				        ZaAppViewMgr.C_APP_CONTENT,
				        ZaAppViewMgr.C_APP_FOOTER,
	
				        ZaAppViewMgr.C_TOOL_HEADER ,
				        ZaAppViewMgr.C_TOOL ,
				        ZaAppViewMgr.C_TOOL_FOOTER
				        ];
				this._stickToGrid(list);
			}
		}
	}
}


// Makes elements visible/hidden by locating them off- or onscreen and setting
// their z-index.
ZaAppViewMgr.prototype._setViewVisible =
function(viewId, show) {
	var elements = this._views[viewId];
	if (show) {
		var list = new Array();
		for (var cid in elements) {
			list.push(cid);
			elements[cid].zShow(true);
		}
		this._stickToGrid(list);
        this._setCurrentBar(viewId);
	} else {
		for (var cid in elements) {
			elements[cid].setLocation(Dwt.LOC_NOWHERE, Dwt.LOC_NOWHERE);
			elements[cid].zShow(false);
		}
	}
}

ZaAppViewMgr.prototype._setTitle =
function(viewId) {
	var elements = this._views[viewId];
	var content = elements[ZaAppViewMgr.C_APP_CONTENT];
	var title = "" ;
	if (content && content.getTitle) {
		title = content.getTitle();
		if(this._components[ZaAppViewMgr.C_CURRENT_APP] && this._components[ZaAppViewMgr.C_CURRENT_APP].setCurrentAppLabel ) {
			this._components[ZaAppViewMgr.C_CURRENT_APP].setCurrentAppLabel (title);		
		}
		Dwt.setTitle(title ? ZabMsg.zimbraTitle + ": " + title : ZabMsg.zimbraTitle);
	}
}

ZaAppViewMgr.prototype._setCurrentBar =
function(viewId) {
    var view = this.getViewContentById(viewId);
    var viewController = ZaApp.getInstance().getControllerById(viewId);
	var popUpOperations = "" ;

    var typeImg = "";
	if (viewController && viewController.getPopUpOperation) {
        popUpOperations = viewController.getPopUpOperation();
	}

    if (view && view.getBarImage) {
        typeImg = view.getBarImage();
    }
    if(this._components[ZaAppViewMgr.C_APP_HEADER]) {
        if (this._components[ZaAppViewMgr.C_APP_HEADER].updateMenu)
		    this._components[ZaAppViewMgr.C_APP_HEADER].updateMenu (popUpOperations, viewController._popupOrder);
        if (this._components[ZaAppViewMgr.C_APP_HEADER].setTypeImg && typeImg)
            this._components[ZaAppViewMgr.C_APP_HEADER].setTypeImg(typeImg);

        var appBarOperations = [];
        if (viewController && viewController.getAppBarAction) {
           appBarOperations = viewController.getAppBarAction();
        }

        var appBarOrder = [];

        if (viewController && viewController.getAppBarOrder)
            appBarOrder = viewController.getAppBarOrder();

        if (this._components[ZaAppViewMgr.C_APP_HEADER].setActionButton)
            this._components[ZaAppViewMgr.C_APP_HEADER].setActionButton(appBarOperations, appBarOrder);
	}
}

// Handles app/tree movement. If you move the sash beyond the max or min width,
// pins to the respective width.
ZaAppViewMgr.prototype._appTreeSashCallback =
function(delta) {
	if (!window.skin) { return; }

	// ask skin for width of tree, rather than hard-coding name of tree div here
	var currentWidth = skin.getTreeWidth();
	if (!currentWidth) { return 0; }

	//DBG.println(AjxDebug.DBG3, "************ sash callback **************");
	//DBG.println(AjxDebug.DBG3, "delta = " + delta);
	//DBG.println(AjxDebug.DBG3, "shell width = " + this._shellSz.x);
	//DBG.println(AjxDebug.DBG3, "current width = " + currentWidth);

	// MOW: get the min/max sizes from the skin.hints
	if (!this.treeMinSize) {
		this.treeMinSize = window.skin.hints.tree.minWidth || 150;
		this.treeMaxSize = window.skin.hints.tree.maxWidth || 300;
	}

	// pin the resize to the minimum and maximum allowable
	if (currentWidth + delta > this.treeMaxSize) {
		delta = Math.max(0, this.treeMaxSize - currentWidth);
	}
	if (currentWidth + delta < this.treeMinSize) {
		delta = Math.min(0, this.treeMinSize - currentWidth);
	}

	// tell skin to resize the tree to keep the separation of tree/skin clean
	var newTreeWidth = currentWidth + delta;

	skin.setTreeWidth(newTreeWidth);

	// call fitAll() on timeout, so we dont get into a problem w/ sash movement code
	var me = this;
	setTimeout(function(){me.fitAll(true)},0);
	return delta;
};


ZaAppViewMgr.prototype._sbAppSashCallback = function(delta) {
	if (!window.skin) {
           return;
        }
 
        var currentHeight = skin.getSBHeight();
        if (!currentHeight){
           return 0;
        }
        
        if (!this.sbMinSize){
           this.sbMinSize = window.skin.hints.searchBuilder.minHeight || 50;
           this.sbMoveSize = currentHeight; //record the orginal height, the search builder is not allowed to big than its original height; 
        }
        
        if (currentHeight + delta > this.sbMoveSize){
            return 0;
        }

        if (currentHeight + delta < this.sbMinSize){
            delta = Math.min (0, this.sbMinSize - currentHeight);
        }

        var newSBHeight = currentHeight + delta; 
        skin.setSBHeight(newSBHeight);
        var me = this;
        setTimeout(function(){me.fitAll(true)}, 0);
        return delta;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaTwoFactorAuth")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2024 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2024 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
 * Creates ZaTwoFactorAuth.
 * @class
 * This class is used for two-step authentication settings.
 * 
 */
ZaTwoFactorAuth = function() {
    // do nothing
};

// Consts
ZaTwoFactorAuth.DEFAULT_ORDER = ["app", "email"];
ZaTwoFactorAuth.APP = "app";
ZaTwoFactorAuth.EMAIL = "email";

ZaTwoFactorAuth.ACTION_RESET = "reset";
ZaTwoFactorAuth.ACTION_EMAIL = "email";
ZaTwoFactorAuth.ACTION_UNKNOWN = "unknown";
ZaTwoFactorAuth.RESET_FAILED = "reset failed";
ZaTwoFactorAuth.NOT_SENT = "not sent";

/**
 * non-prototype function.
 *
 * Return sorted zimbraTwoFactorAuthMethodAllowed
 */
ZaTwoFactorAuth.getTwoFactorAuthMethodAllowed =
function(authResponse) {
    var allowedMethod = [];
    if (authResponse) {
        var zimbraTwoFactorAuthMethodAllowed = authResponse.zimbraTwoFactorAuthMethodAllowed;
        if (zimbraTwoFactorAuthMethodAllowed && zimbraTwoFactorAuthMethodAllowed.method) {
            for (var i = 0; i < zimbraTwoFactorAuthMethodAllowed.method.length; i++) {
                allowedMethod.push(zimbraTwoFactorAuthMethodAllowed.method[i]._content);
            }
        }
    }
    if (allowedMethod.length === 0) {
        // for backward compatibility
        allowedMethod = [ZaTwoFactorAuth.APP];
    }

    // do not update allowedMethod directly
    var allowedMethodSorted = [];
    for (var i = 0; i < ZaTwoFactorAuth.DEFAULT_ORDER.length; i++) {
        if (allowedMethod.indexOf(ZaTwoFactorAuth.DEFAULT_ORDER[i]) !== -1) {
            allowedMethodSorted.push(ZaTwoFactorAuth.DEFAULT_ORDER[i]);
        }
    }
    return allowedMethodSorted;
};

/**
 * non-prototype function.
 *
 * Return two-factor authentication methods which are allowed and enabled
 */
ZaTwoFactorAuth.getTwoFactorAuthMethodAllowedAndEnabled =
function(authResponse) {
    var allowedMethod = ZaTwoFactorAuth.getTwoFactorAuthMethodAllowed(authResponse);
    var enabledMethod = [];
    if (authResponse) {
        var zimbraTwoFactorAuthMethodEnabled = authResponse.zimbraTwoFactorAuthMethodEnabled;
        if (zimbraTwoFactorAuthMethodEnabled && zimbraTwoFactorAuthMethodEnabled.method) {
            for (var i = 0; i < zimbraTwoFactorAuthMethodEnabled.method.length; i++) {
                var method = zimbraTwoFactorAuthMethodEnabled.method[i]._content;
                if (method === ZaTwoFactorAuth.EMAIL) {
                    var maskedEmailAddress = authResponse.zimbraPrefPasswordRecoveryAddress && authResponse.zimbraPrefPasswordRecoveryAddress._content;
                    if (!maskedEmailAddress) {
                        continue;
                    }
                }
                enabledMethod.push(zimbraTwoFactorAuthMethodEnabled.method[i]._content);
            }
        }
    }
    // for backward compatibility
    if (enabledMethod.length == 0 && authResponse.twoFactorAuthRequired && authResponse.twoFactorAuthRequired._content === "true") {
        enabledMethod = [ZaTwoFactorAuth.APP];
    }

    var allowedAndEnabledMethod = [];
    for (var i = 0; i < allowedMethod.length; i++) {
        if (enabledMethod.indexOf(allowedMethod[i]) !== -1) {
            allowedAndEnabledMethod.push(allowedMethod[i]);
        }
    }

    return allowedAndEnabledMethod;
};

/**
 * non-prototype function.
 *
 * Return zimbraPrefPrimaryTwoFactorAuthMethod considering allowed and enabled Methods
 */
ZaTwoFactorAuth.getPrefPrimaryTwoFactorAuthMethod =
function(authResponse) {
    var enabledMethod = ZaTwoFactorAuth.getTwoFactorAuthMethodAllowedAndEnabled(authResponse);
    var primaryMethod;
    if (authResponse) {
        var zimbraPrefPrimaryTwoFactorAuthMethod = authResponse.zimbraPrefPrimaryTwoFactorAuthMethod;
        primaryMethod = zimbraPrefPrimaryTwoFactorAuthMethod && zimbraPrefPrimaryTwoFactorAuthMethod._content;
    }

    if (primaryMethod && enabledMethod.indexOf(primaryMethod) !== -1) {
        return primaryMethod;
    }
    return enabledMethod ? enabledMethod[0] : null;
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaLoginDialog")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

ZaLoginDialog = function(parent, zIndex, className, appCtxt) {
    className = className || "LoginScreen";
    DwtComposite.call(this, {parent:parent, className:className, posStyle:DwtControl.ABSOLUTE_STYLE});

    this._zimbraAdminLoginURL = ZaZimbraAdmin.zimbraAdminLoginURL;

    this._origClassName = className;
    this._xparentClassName = className + "-Transparent";
    this.setBounds(0, 0, "100%", "100%");
    var htmlElement = this.getHtmlElement();
    htmlElement.style.zIndex = Dwt.Z_DIALOG + 1; //login screen covers all dialogs and error messages
    htmlElement.className = className;
    this.setVisible(false);
    
    //license expiration warning won't show before login.
	//var licenseStatus = ZaZimbraAdmin.getLicenseStatus();
	var params = ZLoginFactory.copyDefaultParams(ZaMsg);
	params.showPanelBorder = true;
	params.showForm = true;
	params.showUserField = true;
	params.showPasswordField = true;
	//params.showLicenseMsg = licenseStatus.licenseExists;
	//params.licenseMsg = licenseStatus.message;
	params.showRememberMeCheckbox = false;
	params.showLogOff = true;
	params.logOffAction = "ZaLoginDialog._loginDiffListener()";
	params.loginAction = "ZaLoginDialog._loginListener(this)";
	params.showButton = true;
    params.companyURL = ZaAppCtxt.getLogoURI () ;
    params.copyrightText = ZaItem.getSplashScreenCopyright();
    params.clientLevelNotice = ZabMsg.clientLevelNotice ? ZabMsg.clientLevelNotice :"";
    var html = ZLoginFactory.getLoginDialogHTML(params);
	this.setContent(html);
}

ZaLoginDialog.prototype = new DwtComposite;
ZaLoginDialog.prototype.constructor = ZaLoginDialog;
ZaLoginDialog.prototype.toString = 
function() {
	return "ZaLoginDialog";
}

ZaLoginDialog.prototype.getLoginURL = function () {
    var soapDoc = AjxSoapDoc.create("GetDomainInfoRequest", ZaZimbraAdmin.URN, null);
	var elBy = soapDoc.set("domain", location.hostname);
	elBy.setAttribute("by", "virtualHostname");

	var params = new Object();
	params.soapDoc = soapDoc;
    params.noAuthToken = true ;
    var reqMgrParams = {
		//controller: ZaApp.getInstance().getCurrentController()
	}
	var resp = ZaRequestMgr.invoke(params, reqMgrParams).Body.GetDomainInfoResponse;
    var obj = {};
    ZaItem.prototype.initFromJS.call(obj, resp.domain[0]);
    return obj.attrs["zimbraAdminConsoleLoginURL"] ;
}

ZaLoginDialog.prototype.registerCallback =
function(func, obj) {
	this._callback = new AjxCallback(obj, func);
}

ZaLoginDialog.prototype.clearPassword =
function() {
	ZLoginFactory.get(ZLoginFactory.PASSWORD_ID).value = "";
}

ZaLoginDialog.prototype.showNewPasswordFields = function () {
	ZLoginFactory.showNewPasswordFields();
}

ZaLoginDialog.prototype.hideNewPasswordFields = function () {
	ZLoginFactory.hideNewPasswordFields();
}

ZaLoginDialog.prototype.enableUnameField = function () {
    ZLoginFactory.get(ZLoginFactory.USER_ID).disabled = false;
}

ZaLoginDialog.prototype.disableUnameField = function () {
	ZLoginFactory.get(ZLoginFactory.USER_ID).disabled = true;
}

ZaLoginDialog.prototype.enablePasswordField = function () {
    ZLoginFactory.get(ZLoginFactory.PASSWORD_ID).disabled = false;
}

ZaLoginDialog.prototype.disablePasswordField = function () {
	ZLoginFactory.get(ZLoginFactory.PASSWORD_ID).disabled = true;
}

ZaLoginDialog.prototype.setError =
function(errorStr) {
	if(errorStr)
		ZLoginFactory.showErrorMsg(errorStr);
}

ZaLoginDialog.prototype.clearError = 
function () {
	ZLoginFactory.hideErrorMsg();
}

ZaLoginDialog.prototype.setFocus =
function(username) {
	ZLoginFactory.showUserField(username);
 }

ZaLoginDialog.prototype.setVisible = 
function(visible, transparentBg) {
	DwtComposite.prototype.setVisible.call(this, visible);
    //redirect to zimbraAdminConsoleLoginURL
    if (visible && this._zimbraAdminLoginURL != null && this._zimbraAdminLoginURL.length > 0) {
        if (window.onbeforeunload != null) {
            ZaZimbraAdmin.setOnbeforeunload(ZaZimbraAdmin._confirmAuthInvalidExitMethod);
        }
        
        location.replace(this._zimbraAdminLoginURL);
        return ;
    }

	for (var i = 0; i < ZLoginFactory.TAB_ORDER.length; i++) {
		var element = document.getElementById(ZLoginFactory.TAB_ORDER[i]);
		if (visible && element) {
			Dwt.associateElementWithObject(element, this);
		} else if(element) {
			Dwt.disassociateElementFromObject(null, this);
		}
	}

	if(visible) {
		if (AjxEnv.isIE) {
			var el = ZLoginFactory.getLoginPanel();
			/*
 			 *Bug fix 54362
			 * There are two named "loginForm" one is LoginDialog,
			 * the other one is "Splash Screen" for they shared the same 
			 * Html generation function 			
			 */
			var loginEl = this.getHtmlElement();
			for(var i = 0; i < el.length; i++){
				if(Dwt.contains(loginEl, el[i]))
					el[i]["onkeydown"] = ZLoginFactory.handleKeyPress;
			}
		} else {
			window["onkeypress"] = ZLoginFactory.handleKeyPress;
		}
		//set the focus on the user name field
		var userIdEl = ZLoginFactory.get(ZLoginFactory.USER_ID);
		if(!userIdEl.disabled)
			userIdEl.focus();		
	} else if(window["onkeypress"]) {
		window["onkeypress"] = null;
	}
}

ZaLoginDialog.prototype.addChild =
function(child, childHtmlElement) {
    this._children.add(child);
}

ZaLoginDialog.prototype._loginSelListener =
function() {
	var username = AjxStringUtil.htmlEncode(ZLoginFactory.get(ZLoginFactory.USER_ID).value);
	if (!(username && username.length)) {
		this.setError(ZaMsg.enterUsername);
		return;
	}
	if (this._callback) {
		var password = ZLoginFactory.get(ZLoginFactory.PASSWORD_ID).value;
		var newPassword = "";
		var confPassword = "";
		var twoFactorCode = "";
		var trustedDevice = false;
		if(ZLoginFactory.isShown(ZLoginFactory.NEW_PASSWORD_ID) && ZLoginFactory.isShown(ZLoginFactory.PASSWORD_CONFIRM_ID)) {
			newPassword = ZLoginFactory.get(ZLoginFactory.NEW_PASSWORD_ID).value;
			confPassword = ZLoginFactory.get(ZLoginFactory.PASSWORD_CONFIRM_ID).value; 
		}
		if(ZLoginFactory.isShown(ZLoginFactory.TWO_FACTOR_CODE_FORM)) {
			twoFactorCode = ZLoginFactory.get(ZLoginFactory.TWO_FACTOR_CODE).value;
		}
		if(ZLoginFactory.isShown(ZLoginFactory.TRUST_DEVICE)) {
			trustedDevice = ZLoginFactory.get(ZLoginFactory.TRUST_DEVICE).value;
		}
		
		this._callback.run(username, password, newPassword, confPassword, twoFactorCode, trustedDevice);		
	}
}

ZaLoginDialog._loginListener =
function(target) {
	var element = target;
	while (element) {
		var object = Dwt.getObjectFromElement(element);
		if (object instanceof ZaLoginDialog) {
			object._loginSelListener();
			break;
		}
		element = element.parentNode;
	}
};

ZaLoginDialog._loginDiffListener =
function(ev) {
	ZmZimbraMail.logOff();
};

ZaLoginDialog.prototype.showTwoFactorCode = 
function(authResponse) {
	if (!this.allowedAndEnabledMethod) {
		// Process them only once
		this.allowedAndEnabledMethod = ZaTwoFactorAuth.getTwoFactorAuthMethodAllowedAndEnabled(authResponse);
		this.tfaMethod = ZaTwoFactorAuth.getPrefPrimaryTwoFactorAuthMethod(authResponse);
		this.maskedEmailAddress = authResponse.zimbraPrefPasswordRecoveryAddress && authResponse.zimbraPrefPasswordRecoveryAddress._content;
		this._twoFactorAuthToken = authResponse.authToken[0]._content;
		this._isResent = false;
		this._controlLabelsInTFALogin();
		this._invokeSendTwoFactorAuthCode();
		Dwt.setHandler(ZLoginFactory.TWO_FACTOR_RESEND_CODE_LINK_A_ID, DwtEvent.ONCLICK, this._resendTFACode.bind(this));
		Dwt.setHandler(ZLoginFactory.TWO_FACTOR_CHOOSE_METHOD_LINK_A_ID, DwtEvent.ONCLICK, this._chooseTFAMethodLinkHandler.bind(this));
	}
	ZLoginFactory.showTwoFactorCode();
};


ZaLoginDialog.prototype._controlLabelsInTFALogin =
function() {
	document.getElementById(ZLoginFactory.TWO_FACTOR_CODE_TR_ID).style.display = "";
	document.getElementById(ZLoginFactory.TWO_FACTOR_CODE_LABEL).textContent = ZaMsg["twoFactorCodeLabel_" + this.tfaMethod];
	if (this.tfaMethod === ZaTwoFactorAuth.EMAIL) {
		document.getElementById(ZLoginFactory.TWO_FACTOR_RESEND_CODE_LINK_A_ID).style.display = this._isResent ? "none" : "";
		document.getElementById(ZLoginFactory.TWO_FACTOR_CODE_RESENT_STATUS_SPAN_ID).style.display = this._isResent ? "" : "none";
	} else {
		document.getElementById(ZLoginFactory.TWO_FACTOR_RESEND_CODE_LINK_A_ID).style.display = "none";
		document.getElementById(ZLoginFactory.TWO_FACTOR_CODE_RESENT_STATUS_SPAN_ID).style.display = "none";
	}
	if (this.allowedAndEnabledMethod.length > 1) {
		document.getElementById(ZLoginFactory.TWO_FACTOR_CHOOSE_METHOD_TR_ID).style.display = "";
	} else {
		document.getElementById(ZLoginFactory.TWO_FACTOR_CHOOSE_METHOD_TR_ID).style.display = "none";
	}
};

ZaLoginDialog.prototype._invokeSendTwoFactorAuthCode =
function() {
	var action;
	if (this.tfaMethod === ZaTwoFactorAuth.APP) {
		action = ZaTwoFactorAuth.ACTION_RESET;
	} else if (this.tfaMethod === ZaTwoFactorAuth.EMAIL) {
		action = ZaTwoFactorAuth.ACTION_EMAIL;
	} else {
		// cause an error explicitly due to incorrect configuration
		action = ZaTwoFactorAuth.ACTION_UNKNOWN;
	}
	var callback = this._sendTwoFactorAuthCodeCallback.bind(this, this.tfaMethod);
	var soapDoc = AjxSoapDoc.create("SendTwoFactorAuthCodeRequest", "urn:zimbraAdmin", null);
	soapDoc.set("authToken", this._twoFactorAuthToken);
	soapDoc.set("csrfTokenSecured", 1);
	soapDoc.set("action", action);
	var params = {
		soapDoc: soapDoc,
		asyncMode: true,
		noAuthToken: true,
		ignoreAuthToken: true,
		callback: callback
	}
	var command = new ZmCsfeCommand();
	command.invoke(params);
};

ZaLoginDialog.prototype._resendTFACode =
function() {
	this.clearError();
	document.getElementById(ZLoginFactory.TWO_FACTOR_CODE).value = "";
	this._invokeSendTwoFactorAuthCode();
	document.getElementById(ZLoginFactory.TWO_FACTOR_RESEND_CODE_LINK_A_ID).style.display = "none";
	document.getElementById(ZLoginFactory.TWO_FACTOR_CODE_RESENT_STATUS_SPAN_ID).style.display = "";
	this._isResent = true;
};

ZaLoginDialog.prototype._sendTwoFactorAuthCodeCallback =
function(method, result) {
	if (!result || result.isException()) {
		this.setError(ZaMsg["twoFactorAuthSendTFACodeFailed_" + this.tfaMethod]);
		return;
	}
	var response = result.getResponse();
	if (!response || !response.Body || !response.Body.SendTwoFactorAuthCodeResponse) {
		this.setError(ZaMsg["twoFactorAuthSendTFACodeFailed_" + this.tfaMethod]);
		return;
	}
	var status = response.Body.SendTwoFactorAuthCodeResponse.status && response.Body.SendTwoFactorAuthCodeResponse.status[0]._content;
	if (status === ZaTwoFactorAuth.RESET_FAILED || status === ZaTwoFactorAuth.NOT_SENT) {
		this.setError(ZaMsg["twoFactorAuthSendTFACodeFailed_" + this.tfaMethod]);
	}
};

ZaLoginDialog.prototype._chooseTFAMethodLinkHandler =
function() {
	this.clearError();
	ZLoginFactory.hideTwoFactorCodeForm();
	document.getElementById(ZLoginFactory.TWO_FACTOR_CODE).value = "";

	if (this._chooseMethodInitialized) {
		for (var i = 0; i < this.allowedAndEnabledMethod.length; i++) {
			var inputElem = document.getElementById("method_" + this.allowedAndEnabledMethod[i]);
			if (this.tfaMethod === this.allowedAndEnabledMethod[i]) {
				inputElem.checked = true;
				this._currentTfaMethod = this.tfaMethod;
			} else {
				inputElem.checked = false
			};
		}
	} else {
		var radioHandler = this._methodRadioChange.bind(this);
		for (var i = 0; i < this.allowedAndEnabledMethod.length; i++) {
			var pElem = document.createElement('p');
			var inputElem = document.createElement('input');
			inputElem.type = "radio";
			inputElem.id = "method_" + this.allowedAndEnabledMethod[i];
			inputElem.name = "tfaMethod";
			inputElem.className = "ZTwoFactorMethodInput"
			inputElem.value = this.allowedAndEnabledMethod[i];
			var labelElem = document.createElement('label');
			labelElem.htmlFor = "method_" + this.allowedAndEnabledMethod[i];
			labelElem.innerHTML = ZaMsg["twoFactorAuthChooseMethod_" + this.allowedAndEnabledMethod[i]];
			labelElem.className = "ZTwoFactorMethodLabel";
			if (this.allowedAndEnabledMethod[i] === ZaTwoFactorAuth.EMAIL) {
				labelElem.innerHTML += ("<br>" + this.maskedEmailAddress);
			}
			if (this.tfaMethod === this.allowedAndEnabledMethod[i]) {
				inputElem.checked = true;
				this._currentTfaMethod = this.tfaMethod;
			}
			labelElem.style.margin = 0;

			pElem.appendChild(inputElem);
			pElem.appendChild(labelElem);
			document.getElementById(ZLoginFactory.TWO_FACTOR_METHOD_OPTION_CONTAINER_TD_ID).appendChild(pElem);
			Dwt.setHandler(inputElem, DwtEvent.ONCHANGE, radioHandler);
		}
		Dwt.setHandler(ZLoginFactory.TWO_FACTOR_CHOOSE_METHOD_NEXT_BUTTON, DwtEvent.ONCLICK, this._twoFactorMethodSelectListener.bind(this));
		Dwt.setHandler(ZLoginFactory.TWO_FACTOR_CHOOSE_METHOD_BACK_BUTTON, DwtEvent.ONCLICK, this._twoFactorMethodCancelListener.bind(this));
		this._chooseMethodInitialized = true;
	}

	ZLoginFactory.showTwoFactorChooseMethod();
};

ZaLoginDialog.prototype._methodRadioChange =
function(ev) {
	var value = ev && ev.target && ev.target.value;
	this.tfaMethod = ev.target.value;
};

ZaLoginDialog.prototype._twoFactorMethodSelectListener =
function() {
	if (this.tfaMethod === this._currentTfaMethod) {
		this._twoFactorMethodCancelListener();
	} else {
		this._isResent = false;
		this._goBackToTwoFactorCodePage();
		this._invokeSendTwoFactorAuthCode();
	}
};

ZaLoginDialog.prototype._twoFactorMethodCancelListener =
function() {
	this.tfaMethod = this._currentTfaMethod;
	this._goBackToTwoFactorCodePage();
};

ZaLoginDialog.prototype._goBackToTwoFactorCodePage =
function() {
	ZLoginFactory.hideTwoFactorChooseMethod();
	this._controlLabelsInTFALogin();
	ZLoginFactory.showTwoFactorCodeForm();
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaController")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class Base class for all Controller classes in ZimbraAdmin UI
* @author Greg Solovyev
* @constructor 
* @see ZaAccountListController
* @see ZaCosListController
* @see ZaDomainListController
* @see ZaXFormViewController
*/
ZaController = function(appCtxt, container,iKeyName) {

    if (arguments.length == 0) return;
    this._evtMgr = new AjxEventMgr();
    /**
    * The name of the current controller. This name is used as a key in {@link #initToolbarMethods}, {@link #setViewMethods} and {@link #initPopupMenuMethods} maps 
    **/    
    this._iKeyName = iKeyName;
    this._appCtxt = appCtxt;
    this._container = container;
    
    this._shell = appCtxt.getShell();
    this._appViews = new Object();   
    this._currentView = null;   
    this._contentView = null; //the view object associated with the current controller instance                         
    
    this._authenticating = false;

    this.initDialogs ();
    
    this.objType = ZaEvent.S_ACCOUNT;
    this._helpURL = ZaController.helpURL;
    this._helpButtonText = ZabMsg.zimbraHomePage;
       this._popupOperations = new Array();
    this._popupOrder = new Array();
    this._appbarOperation = new Array();
    this._appbarOrder = new Array();
}
ZaController.CLICK_DELAY = 150;
ZaController.prototype.initDialogs = function (refresh) {
    if(ZaApp.getInstance()) {
        this._msgDialog = ZaApp.getInstance().dialogs["msgDialog"];
        this._errorDialog = ZaApp.getInstance().dialogs["errorDialog"];
        this._errorDialog.registerCallback(DwtDialog.OK_BUTTON, this._errorDialogCallback, this);
        this._msgDialog.registerCallback(DwtDialog.OK_BUTTON, this._msgDialogCallback, this);
    }
    this._loginDialog = this._appCtxt.getLoginDialog();
    this._loginDialog.registerCallback(this.loginCallback, this);
}

/**
* A map of funciton references. Functions in this map are called one after another from 
* {@link #_initToolbar} method.
* The functions are called on the current instance of the controller. 
* member of  ZaController
* @see #_initToolbar
**/
ZaController.initToolbarMethods = new Object();
/**
* A map of funciton references. Functions in this map are called one after another from 
* {@link #_initPopupMenu} method.
* The functions are called on the current instance of the controller. 
* member of ZaController
* @see #_initPopupMenu
**/
ZaController.initPopupMenuMethods = new Object();
/**
* A map of funciton references. Functions in this map are called one after another from 
* {@link #_setView} method.
* The functions are called on the current instance of the controller. 
* member of ZaController
* @see #_setView
**/
ZaController.setViewMethods = new Object();

ZaController.changeActionsStateMethods = new Object();

ZaController.saveChangeCheckMethods = new Object();

ZaController.postChangeMethods = new Object();

ZaController.helpURL = location.pathname + ZaUtil.HELP_URL + "administration_console_help.htm?locid="+AjxEnv.DEFAULT_LOCALE;

// Public methods
ZaController.prototype.toString =
function() {
    return "ZaController";
}


ZaController.prototype.getProgressDialog =
function() {
    if (!ZaApp.getInstance().dialogs["progressDialog"])
        ZaApp.getInstance().dialogs["progressDialog"] = new ZaXProgressDialog(this._appCtxt.getShell(),  "300px", "300px");
    return ZaApp.getInstance().dialogs["progressDialog"];
}

ZaController.prototype.setDirty = 
function (isD) {
    //overwrite this method to disable toolbar buttons, for example, Save button
}

ZaController.prototype.setCurrentView =
function(view) {
    this._currentView = view;
}

ZaController.prototype.getContentViewId =
function () {
    return this._contentView.__internalId ;
}

ZaController.prototype.setEnabled = 
function(enable) {
    //abstract
//    throw new AjxException("This method is abstract", AjxException.UNIMPLEMENTED_METHOD, "ZaController.prototype.setEnabled");    
}

ZaController.prototype.popupErrorDialog = 
function(msg, ex, style)  {
    style = style ? style : DwtMessageDialog.CRITICAL_STYLE;
    this._execFrame = {func: null, args: null, restartOnError: false};
    
    var detailStr = "";
    if(ex != null) {
        if(ex.msg) {
            detailStr += ZaMsg.ERROR_MESSAGE + "  ";
            detailStr += AjxStringUtil.htmlEncode(ex.msg);
            detailStr += "\n";
        }
        if(ex.code) {
            detailStr += ZaMsg.ERROR_CODE + "  ";
            detailStr += ex.code;
            detailStr += "\n";                
        }
        if(ex.method) {
            detailStr += "Method:  ";
            detailStr += ex.method;
            detailStr += "\n";                
        }
        if(ex.detail) {
            detailStr += ZaMsg.ERROR_DETAILS;
            detailStr += ex.detail;
            detailStr += "\n";                
        }
        
        if(!detailStr || detailStr == "") {
            for (var ix in ex) {
                detailStr += ix;
                detailStr += ": ";
                try {
                    detailStr += ex[ix].toString();
                } catch (ex) {
                    //ignore
                }
                detailStr += "\n";
            }
        }
    }
    // popup alert

    if (!this._errorDialog) {
        this._errorDialog = ZaApp.getInstance().dialogs["errorDialog"];
    }

    if (this._errorDialog) {
        this._errorDialog.setMessage(msg, detailStr, style, ZabMsg.zimbraAdminTitle);

        if (!this._errorDialog.isPoppedUp()) {
            this._errorDialog.popup();
        }
    }

}

ZaController.prototype.popupMsgDialog = 
function(msg, noExecReset)  {
    if (!noExecReset)
        this._execFrame = {func: null, args: null, restartOnError: false};
    
    // popup alert
    this._msgDialog.setMessage(msg, DwtMessageDialog.INFO_STYLE, ZabMsg.zimbraAdminTitle);
    if (!this._msgDialog.isPoppedUp()) {
        this._msgDialog.popup();
    }
}


ZaController.prototype.popupWarningDialog = 
function(msg, noExecReset)  {
    if (!noExecReset)
        this._execFrame = {func: null, args: null, restartOnError: false};
    
    // popup alert
    this._msgDialog.setMessage(msg, DwtMessageDialog.WARNING_STYLE, ZabMsg.zimbraAdminTitle);
    if (!this._msgDialog.isPoppedUp()) {
        this._msgDialog.popup();
    }
}
ZaController.prototype.getControllerForView =
function(view) {
//    DBG.println(AjxDebug.DBG1, "*** controller not found for view " + view);
    return this._appCtxt.getAppController();
}

/**
* @param nextViewCtrlr - the controller of the next view
* @param func           - the method to call on the nextViewCtrlr in order to navigate to the next view
* @param params           - arguments to pass to the method specified in func parameter
* Ovewrite this method in order to check if it is OK to leave the current view or 
* perform any actions before a user navigates away from the view.
**/
ZaController.prototype.switchToNextView = 
function (nextViewCtrlr, func, params) {
    var callback = new AjxCallback (nextViewCtrlr, func, params) ;
    callback.run ();
    //func.call(nextViewCtrlr, params);
}

//Private/protected methods

/**
* This method finds an array of function references in {@link ZaController#setViewMethods} map and calls all the functions for the array.
* {@link #_iKeyName} is used to lookup the array of function references in the map.
* @private
**/
ZaController.prototype._setView =
function(entry, openInNewTab, skipRefresh) {
    if (openInNewTab) { //check whether the tab limit exceeds
        var cSize = ZaAppTabGroup._TABS.size () ;
        if (cSize >= ZaAppTabGroup.TAB_LIMIT) {
            this.popupMsgDialog(ZaMsg.too_many_tabs);
            return ;
        }
    }
    //Instrumentation code start
    if(ZaController.setViewMethods[this._iKeyName]) {
        var methods = ZaController.setViewMethods[this._iKeyName];
        var cnt = methods.length;
        for(var i = 0; i < cnt; i++) {
            if(typeof(methods[i]) == "function") {
                try {
                    methods[i].call(this,entry,openInNewTab, skipRefresh);
                } catch (ex) {
                    this._handleException(ex, "ZaController.prototype._setView");
                    break;
                }
            }
        }
    }
    this.changeActionsState();    
    //Instrumentation code end    
}

ZaController.prototype.getMainTab =
function () {
    return ZaApp.getInstance().getTabGroup().getMainTab () ;
}

ZaController.prototype.getSearchTab =
function () {
    return ZaApp.getInstance().getTabGroup().getSearchTab () ;
}

//Listeners for default toolbar buttons (close, save, delete)
/**
* member of ZaController
* @param     ev event object
* handles the Close button click. Returns to the previous view.
**/ 
ZaController.prototype.closeButtonListener =
function(ev, noPopView, func, obj, params) {
    //prompt if the user wants to save the changes
    if (noPopView){
        func.call(obj, params) ;
    }else{
        ZaApp.getInstance().popView();
        //ZaApp.getInstance().getTabGroup().removeCurrentTab(true) ;
    }
}

ZaController.prototype._helpButtonListener =
function() {
    window.open(this._helpURL);
}
/**
* We do the whole schedule/execute thing to give the shell the opportunity to popup its "busy" 
* overlay so that user input is blocked. For example, if a search takes a while to complete, 
* we don't want the user's clicking on the search button to cause it to re-execute repeatedly 
* when the events arrive from the UI. Since the action is executed via win.setTimeout(), it
* must be a leaf action (scheduled actions are executed after the calling code returns to the
* UI loop). You can't schedule something, and then have subsequent code that depends on the 
* scheduled action. 
* @private
**/
ZaController.prototype._showLoginDialog =
function() {
    ZaZimbraAdmin._killSplash();
    this._authenticating = true;
    this._loginDialog.setVisible(true, false);
    try {
        var uname = null; // don't change current display username
        this._loginDialog.setFocus(uname);
    } catch (ex) {
        // something is out of whack... just make the user relogin
        ZaZimbraAdmin.logOff();
    }
}

ZaController.prototype._handleException =
function(ex, method, params, restartOnError, obj) {
    DBG.dumpObj(ex);
    if (ex.code && 
            (ex.code == ZmCsfeException.SVC_AUTH_EXPIRED || 
                ex.code == ZmCsfeException.SVC_AUTH_REQUIRED || 
                ex.code == ZmCsfeException.NO_AUTH_TOKEN ||
                ex.code == ZmCsfeException.AUTH_TOKEN_CHANGED
             )
        ) {
        try {
            ZmCsfeCommand.noAuth = true;
            if (ZaApp.getInstance() != null) 
            {
                var dlgs = ZaApp.getInstance().dialogs;
                for (var dlg in dlgs) {
                    dlgs[dlg].popdown();
                }
            }

            this._execFrame = {obj: obj, func: method, args: params, restartOnError: restartOnError};
            this._loginDialog.registerCallback(this.loginCallback, this);
                /*
                  * Sometimes, users will clear cookie manually, that will cause security issue. see: bug 67427
                  * But in the process of login, we use this exception to popup login dialog if user doesn't 
                  * login. We shouldn't disable the username field in the first soap request if an exception is thrown.
                  */
            if ((!ZaZimbraAdmin.isFirstRequest &&  
                  (ex.code == ZmCsfeException.NO_AUTH_TOKEN ||
                   ex.code == ZmCsfeException.SVC_AUTH_REQUIRED ||
                   ex.code == ZmCsfeException.SVC_AUTH_EXPIRED
                 ))
               ) {
                this._loginDialog.setError(ZaMsg.ERROR_SESSION_EXPIRED);
            }
            this._loginDialog.clearPassword();
            this._showLoginDialog();
        } catch (ex2) {
            if(window.console && window.console.log)
                window.console.log(ex2.code);
        }
    } 
    else 
    {
        this._execFrame = {obj: obj, func: method, args: params, restartOnError: restartOnError};
        if (!this._errorDialog) {
            this._errorDialog = ZaApp.getInstance().dialogs["errorDialog"] ; 
        }
        if (this._errorDialog)
            this._errorDialog.registerCallback(DwtDialog.OK_BUTTON, this._errorDialogCallback, this);
        if(!ex.code) {
            this.popupErrorDialog(ZaMsg.JAVASCRIPT_ERROR + " in method " + method, ex);
        
        } else if(ex.code == ZmCsfeException.EMPTY_RESPONSE) {
            this.popupErrorDialog(ZabMsg.ERROR_ZCS_NOT_RUNNING, ex);
        } else if (ex.code == ZmCsfeException.SOAP_ERROR) {
            this.popupErrorDialog(ZaMsg.SOAP_ERROR, ex);
        } else if (ex.code == ZmCsfeException.NETWORK_ERROR ||
                   ex.code == AjxException.NETWORK_ERROR) {
            this.popupErrorDialog(ZaMsg.NETWORK_ERROR, ex);
        } else if (ex.code ==  ZmCsfeException.SVC_PARSE_ERROR) {
            this.popupErrorDialog(ZaMsg.PARSE_ERROR, ex);
        } else if (ex.code ==  ZmCsfeException.SVC_PERM_DENIED) {
            this.popupErrorDialog(ZaMsg.PERMISSION_DENIED, ex);
        } else if (ex.code == ZmCsfeException.ACCT_NO_SUCH_ACCOUNT) {
            this.popupErrorDialog(ZaMsg.ERROR_NO_SUCH_ACCOUNT, ex);
        } else if (ex.code == ZmCsfeException.NO_SUCH_DISTRIBUTION_LIST) {
            this.popupErrorDialog(ZaMsg.NO_SUCH_DISTRIBUTION_LIST, ex);
        } else if(ex.code == ZmCsfeException.ACCT_EXISTS) {
            this.popupErrorDialog(ZaMsg.ERROR_ACCOUNT_EXISTS, ex);
        } else if(ex.code == ZmCsfeException.ACCT_TOO_MANY_ACCOUNTS) {
            this.popupErrorDialog(ZaMsg.ERROR_TOO_MANY_ACCOUNTS,
                    ex, true);
        } else if(ex.code == ZmCsfeException.VOLUME_NO_SUCH_PATH) {
            this.popupErrorDialog(ZaMsg.ERROR_INVALID_VOLUME_PATH, ex);
        } else if(ex.code == ZmCsfeException.NO_SUCH_VOLUME) {
            this.popupErrorDialog(ZaMsg.ERROR_NO_SUCH_VOLUME, ex);
        } else if (ex.code == ZmCsfeException.CANNOT_CHANGE_VOLUME) {
            this.popupErrorDialog(ZaMsg.ERROR_CANNOT_CHANGE_VOLUME, ex);
        } else if (ex.code == ZmCsfeException.CANNOT_DELETE_VOLUME_IN_USE) {
            this.popupErrorDialog(ZaMsg.CANNOT_DELETE_VOLUME_IN_USE, ex);
        } else if(ex.code == ZmCsfeException.ALREADY_EXISTS) {
            this.popupErrorDialog(ZaMsg.ERROR_VOLUME_ALREADY_EXISTS, ex);
        } else if(ex.code == ZmCsfeException.LICENSE_ERROR) {
            this.popupErrorDialog(ZaMsg.ERROR_LICENSE, ex);
        } else if (ex.code == ZmCsfeException.SVC_INVALID_REQUEST) {
            this.popupErrorDialog(ZaMsg.ERROR_INVALID_REQUEST, ex);
        } else if (ex.code == ZmCsfeException.TOO_MANY_SEARCH_RESULTS) {
            this.popupErrorDialog(ZaMsg.ERROR_TOO_MANY_SEARCH_RESULTS, ex);
        } else if (ex.code == ZmCsfeException.NO_SUCH_DOMAIN) {
            this.popupErrorDialog(ZaMsg.ERROR_NO_SUCH_DOMAIN, ex);
        } else if (ex.code == ZmCsfeException.CSFE_SVC_ERROR || 
                    ex.code == ZmCsfeException.SVC_FAILURE || 
                        (typeof(ex.code) == 'string' && ex.code && ex.code.match(/^(service|account|mail)\./))

                   ) {
            this.popupErrorDialog(ZaMsg.SERVER_ERROR, ex);
        } else if (ex.code == AjxException.INVALID_PARAM){
            this.popupErrorDialog(ZaMsg.ERROR_INVALID_VALUE, ex);
            this._errorDialog._showDetail();
        } else {
            //search for error code
            var gotit = false;
            for(var ix in ZmCsfeException) {
                if(ZmCsfeException[ix] == ex.code) {
                    this.popupErrorDialog(ZaMsg.SERVER_ERROR, ex);
                    gotit = true;
                    break;
                }
            }
            if(!gotit)
                this.popupErrorDialog(ZaMsg.ERROR_UNKNOWN, ex);
        }
    }
}

ZaController.prototype._doAuth =
function(username, password, twoFactorCode, trustedDevice) {
    ZmCsfeCommand.noAuth = true;
    try {
        //hide login dialog
        this._hideLoginDialog();
        //show splash screen
        ZaZimbraAdmin.showSplash(this._shell);
        var callback = new AjxCallback(this, this.authCallback);
        this.auth = new ZaAuthenticate(this._appCtxt);
        this.auth.execute(username, password, callback, twoFactorCode, trustedDevice);
    } catch (ex) {
        if(ex.code == ZmCsfeException.NO_AUTH_TOKEN) {
            throw (ex);
        } else if (ex.code == ZmCsfeException.ACCT_AUTH_FAILED || ex.code == ZmCsfeException.SVC_PERM_DENIED || ex.code == ZmCsfeException.SVC_FAILURE) {
            this._showLoginDialog(false);
            this._loginDialog.setError(ZaMsg.ERROR_AUTH_FAILED);
            return;
        } else if (ex.code == ZmCsfeException.ACCT_CHANGE_PASSWORD) {
            this._showLoginDialog(true);
            this._loginDialog.disablePasswordField(true);
            this._loginDialog.disableUnameField(true);
            this._loginDialog.showNewPasswordFields();
            this._loginDialog.registerCallback(this.changePwdCallback, this);
        } else {
            this._showLoginDialog(false);
            this.popupMsgDialog(ZaMsg.SERVER_ERROR, ex); 
        }
    }
}

ZaController.prototype._hideLoginDialog =
function(clear) {
    this._loginDialog.setVisible(false);
    if(clear) {
        this._loginDialog.setError(null);
        this._loginDialog.clearPassword();
    }
}


/**
* This method is called when we receive AuthResponse
**/
ZaController.prototype.authCallback =
function (resp) {
    //auth request came back
     ZaController.changePwdCommand = null;
    //if login failed - hide splash screen, show login dialog
    if(resp.isException && resp.isException()) {
        var ex = resp.getException();
        if (ex.code == ZmCsfeException.ACCT_AUTH_FAILED || ex.code == ZmCsfeException.SVC_PERM_DENIED || ex.code == ZmCsfeException.SVC_FAILURE)
        {
            this._showLoginDialog(false);
            this._loginDialog.setError(ZaMsg.ERROR_AUTH_FAILED);
            this._loginDialog.clearPassword();
            return;
        } else if (ex.code == ZmCsfeException.ACCT_CHANGE_PASSWORD) {
            this._showLoginDialog(true);
            this._loginDialog.setError(ZaMsg.errorPassChange);
            this._loginDialog.disablePasswordField(true);
            this._loginDialog.disableUnameField(true);
            this._loginDialog.showNewPasswordFields();
            this._loginDialog.registerCallback(this.changePwdCallback, this);
        } else if (ex.code == ZmCsfeException.PASSWORD_RECENTLY_USED ||
            ex.code == ZmCsfeException.PASSWORD_CHANGE_TOO_SOON) {
            this._showLoginDialog(true);
            var msg = ex.code == ZmCsfeException.ACCT_PASS_RECENTLY_USED ? ZaMsg.errorPassRecentlyUsed : (ZaMsg.errorPassChangeTooSoon);
            this._loginDialog.setError(msg);
            this._loginDialog.clearPassword();
            this._loginDialog.setFocus(null);
        } else if (ex.code == ZmCsfeException.PASSWORD_LOCKED) {
            this._showLoginDialog(true);
            // re-enable username and password fields
            this._loginDialog.disablePasswordField(false);
            this._loginDialog.disableUnameField(false);
            this._loginDialog.setError(ZaMsg.errorPassLocked);
        } else if(ex.code == ZmCsfeException.MAINTENANCE_MODE) {
            this._showLoginDialog(false);
            this._loginDialog.setError(ZaMsg.ERROR_ACC_IN_MAINTENANCE_MODE);
            this._loginDialog.clearPassword();
        } else if(ex.code == ZmCsfeException.SVC_AUTH_EXPIRED) {
            this._showLoginDialog(true);
            this._loginDialog.setError(ZaMsg.ERROR_SESSION_EXPIRED);
            this._loginDialog.clearPassword();
        } else {
            if(this._msgDialog) {
                this.popupMsgDialog(ZaMsg.SERVER_ERROR, ex);
            } else {
                this._showLoginDialog(true);
                //check for a more informative message
                if(ex && this._refreshing && ex.code == ZmCsfeException.SVC_AUTH_REQUIRED) {
                    //do not show error message, we are coming back to admin UI with an expired cookie
                } else if(ex && ex.msg) {
                    this._loginDialog.setError(ZaMsg.SERVER_ERROR + " (" + ex.msg + ")");
                } else {
                    this._loginDialog.setError(ZaMsg.SERVER_ERROR);
                }
            }
        }
    } else {
        //if login succesful hide splash screen, start application
        try {
            var response = resp.getResponse();
            var body = response.Body;
            if (body.AuthResponse && body.AuthResponse.twoFactorAuthRequired && body.AuthResponse.twoFactorAuthRequired._content) {
                this._showLoginDialog(true);
                this._loginDialog.registerCallback(this.loginCallback, this);
                this._loginDialog.clearError();
                this._loginDialog.showTwoFactorCode(body.AuthResponse);
            } else {
                if(body.AuthResponse && body.AuthResponse.csrfToken && 
                    body.AuthResponse.csrfToken._content) {
                    window.csrfToken = body.AuthResponse.csrfToken._content;
                }
                var isAuthTokenPresent = true;
                ZmCsfeCommand.noAuth = false;

                var soapDoc = AjxSoapDoc.create("GetInfoRequest", "urn:zimbraAccount", null);
                var command = new ZmCsfeCommand();
                var params = new Object();
                params.soapDoc = soapDoc;
                params.noSession = true;
                params.noAuthToken = true;
                ZaZimbraAdmin.isFirstRequest = true;
                var resp = command.invoke(params);
                ZaZimbraAdmin.isFirstRequest = false;

                //initialize my rights
                ZaZimbraAdmin.initInfo (resp);

                ZaServerVersionInfo.load();

                //check the user locale settings and reload the message is needed.
                ZaZimbraAdmin.LOCALE_QS = "" ;
                if (ZaZimbraAdmin.LOCALE && (ZaZimbraAdmin.LOCALE != AjxEnv.DEFAULT_LOCALE)) {
                    if (ZaZimbraAdmin.LOCALE != null) {
                        var index = ZaZimbraAdmin.LOCALE.indexOf("_");
                        if (index == -1) {
                            ZaZimbraAdmin.LOCALE_QS = "&language=" + ZaZimbraAdmin.LOCALE;
                        } else {
                            ZaZimbraAdmin.LOCALE_QS = "&language=" + ZaZimbraAdmin.LOCALE.substring(0, index) +
                                    "&country=" + ZaZimbraAdmin.LOCALE.substring(ZaZimbraAdmin.LOCALE.length - 2);
                        }
                    }

                    ZaZimbraAdmin.reload_msg ();
                    this.initDialogs(true) ;  //make sure all the precreated dialogs are also recreated.
                }

                if(ZaZimbraAdmin.isLanguage("ja")){
                    if(ZaAccountXFormView.CONTACT_TAB_ATTRS)
                            ZaAccountXFormView.CONTACT_TAB_ATTRS.push(ZaAccount.A_zimbraPhoneticCompany);

                    if(ZaAccountXFormView.ACCOUNT_NAME_GROUP_ATTRS)
                            ZaAccountXFormView.ACCOUNT_NAME_GROUP_ATTRS.push(ZaAccount.A_zimbraPhoneticFirstName,
                            ZaAccount.A_zimbraPhoneticLastName);
                }

                if(!ZaSettings.initialized) {
                    ZaSettings.init();
                } else {
                    ZaZimbraAdmin._killSplash();
                }

                //Instrumentation code start
                if(ZaAuthenticate.processResponseMethods) {
                    var cnt = ZaAuthenticate.processResponseMethods.length;
                    for(var i = 0; i < cnt; i++) {
                        if(typeof(ZaAuthenticate.processResponseMethods[i]) == "function") {
                            ZaAuthenticate.processResponseMethods[i].call(this,resp);
                        }
                    }
                }
                //Instrumentation code end
                this._hideLoginDialog(true);
                this._appCtxt.getAppController().startup(isAuthTokenPresent);
            }
            
        } catch (ex) {
            this._handleException(ex, "ZaController.prototype.authCallback");
        }
    }
    this._refreshing = false;
}
/*********** Login dialog Callbacks */

ZaController.prototype.loginCallback =
function(uname, password, newPassword, confPassword, twoFactorCode, trustedDevice) {
    //this._schedule(this._doAuth, {username: uname, password: password});
    this._doAuth(uname,password, twoFactorCode, trustedDevice);
}

ZaController.prototype.changePwdCallback =
function(uname, oldPass, newPass, conPass) {
    if (newPass == null || newPass == "" || conPass == null || conPass == "") {
        this._loginDialog.setError(ZaMsg.enterNewPassword);
        return;
    }
    
    if (newPass != conPass) {
        this._loginDialog.setError(ZaMsg.bothNewPasswordsMustMatch);
        return;
    }

    var soapDoc = AjxSoapDoc.create("ChangePasswordRequest", "urn:zimbraAccount");
    var el = soapDoc.set("account", uname);
    el.setAttribute("by", "name");
    soapDoc.set("oldPassword", oldPass);
    soapDoc.set("password", newPass);
    var resp = null;
    try {
        if(ZaController.changePwdCommand)
            return;

        ZaController.changePwdCommand = new ZmCsfeCommand();
        resp = ZaController.changePwdCommand.invoke({soapDoc: soapDoc, noAuthToken: true, ignoreAuthToken: true,  noSession: true}).Body.ChangePasswordResponse;

        if (resp) {
            this._loginDialog.clearError();
             this._loginDialog.enableUnameField();
            this._loginDialog.enablePasswordField();
            this._loginDialog.hideNewPasswordFields();
            ZaZimbraAdmin.showSplash(this._shell);
            var callback = new AjxCallback(this, this.authCallback);
            this.auth = new ZaAuthenticate(this._appCtxt);
            this.auth.execute(uname, newPass, callback);
        }
    } catch (ex) {
        ZaController.changePwdCommand = null;
        //DBG.dumpObj(ex);
        // XXX: for some reason, ZmCsfeException consts are fubar
        if (ex.code == ZmCsfeException.ACCT_PASS_RECENTLY_USED ||
            ex.code == ZmCsfeException.ACCT_PASS_CHANGE_TOO_SOON) {
            var msg = ex.code == ZmCsfeException.ACCT_PASS_RECENTLY_USED
                ? ZaMsg.errorPassRecentlyUsed
                : (ZaMsg.errorPassChangeTooSoon);
            this._loginDialog.setError(msg);
            this._loginDialog.setFocus(null);
        } else if (ex.code == ZmCsfeException.ACCT_PASS_LOCKED)    {
            // re-enable username and password fields
            this._loginDialog.disablePasswordField(false);
            this._loginDialog.disableUnameField(false);
            this._loginDialog.setError(ZaMsg.errorPassLocked);
        } else {
            this._handleException(ex, "ZaController.prototype.changePwdCallback");    
        }
    }
}

/*********** Msg dialog Callbacks */

ZaController.prototype._errorDialogCallback =
function() {
    ZaApp.getInstance().dialogs["errorDialog"].popdown();
    if (this._execFrame) {
        if (this._execFrame.restartOnError && !this._authenticating && this._execFrame.method)
            this._execFrame.method.apply(this, this._execFrame.args);
        this._execFrame = null;
    }
}

ZaController.prototype._msgDialogCallback =
function() {
    this._msgDialog.popdown();
    if (this._execFrame) {
        if (this._execFrame.restartOnError && !this._authenticating)
            this._execFrame.method.apply(this, this._execFrame.args);
        this._execFrame = null;
    }    
}

/**
* This method finds an array of function references in {@link ZaController#initToolbarMethods} map and calls all the functions for the array.
* {@link #_iKeyName} is used to lookup the array of function references in the map.
* @private
**/
ZaController.prototype._initToolbar = function () {
}

/**
* This method finds an array of function references in {@link ZaController#initPopupMenuMethods} map and calls all the functions for the array.
* {@link #_iKeyName} is used to lookup the array of function references in the map.
* @private
**/
ZaController.prototype._initPopupMenu = function () {
    //Instrumentation code start
    if(ZaController.initPopupMenuMethods[this._iKeyName]) {
        var methods = ZaController.initPopupMenuMethods[this._iKeyName];
        var cnt = methods.length;
        for(var i = 0; i < cnt; i++) {
            if(typeof(methods[i]) == "function") {
                try {
                    methods[i].call(this);
                } catch (ex) {
                    this._handleException(ex, "ZaController.prototype._initPopupMenu");
                }
            }
        }
    }    
    //Instrumentation code end
}

ZaController.prototype.closeCnfrmDlg = 
function () {
    if(ZaApp.getInstance().dialogs["confirmMessageDialog"])
        ZaApp.getInstance().dialogs["confirmMessageDialog"].popdown();    
}


ZaController.prototype.closeCnfrmDelDlg = 
function () {
    if(ZaApp.getInstance().dialogs["confirmMessageDialog2"])
        ZaApp.getInstance().dialogs["confirmMessageDialog2"].popdown();    
}
/**
* public getToolBar
* @return reference to the toolbar
**/
ZaController.prototype.getToolBar = 
function () {
    return null;
}

/**
* Adds listener to creation of an ZaAccount 
* @param listener
**/
ZaController.prototype.addCreationListener = 
function(listener) {
    this._evtMgr.addListener(ZaEvent.E_CREATE, listener);
}

/**
* Removes listener to creation of an ZaAccount 
* @param listener
**/
ZaController.prototype.removeCreationListener = 
function(listener) {
    this._evtMgr.removeListener(ZaEvent.E_CREATE, listener);        
}

/**
* Adds listener to removal of an ZaAccount 
* @param listener
**/
ZaController.prototype.addRemovalListener = 
function(listener) {
    this._evtMgr.addListener(ZaEvent.E_REMOVE, listener);
}

/**
* Removes listener to removal of an ZaAccount 
* @param listener
**/
ZaController.prototype.removeRemovalListener = 
function(listener) {
    this._evtMgr.removeListener(ZaEvent.E_REMOVE, listener);        
}

/**
* member of ZaXFormViewController
* Adds listener to modifications in the contained ZaAccount 
* @param listener
**/
ZaController.prototype.addChangeListener = 
function(listener) {
    this._evtMgr.addListener(ZaEvent.E_MODIFY, listener);
}

/**
* member of ZaXFormViewController
* Removes listener to modifications in the controlled ZaAccount 
* @param listener
**/
ZaController.prototype.removeChangeListener = 
function(listener) {
    this._evtMgr.removeListener(ZaEvent.E_MODIFY, listener);        
}

/**
 * Adds listener for search finished event.
 * @param listener
 **/
ZaController.prototype.addSearchListener =
function(listener) {
    this._evtMgr.addListener(ZaEvent.E_SEARCH, listener);
}

/**
 * Removes listeners for search finished event.
 * @param listener
 **/
ZaController.prototype.removeSearchListener =
function(listener) {
    this._evtMgr.removeListener(ZaEvent.E_SEARCH, listener);
}

/**
* member of ZaXFormViewController
*    Private method that notifies listeners that a new object is created
*     @param details
*/
ZaController.prototype.fireCreationEvent =
function(details) {
    try {
        if (this._evtMgr.isListenerRegistered(ZaEvent.E_CREATE)) {
            var evt = new ZaEvent(this.objType);
            evt.set(ZaEvent.E_CREATE, this);
            if(details)
                evt.setDetails(details);
                
            this._evtMgr.notifyListeners(ZaEvent.E_CREATE, evt);
        }
    } catch (ex) {
        this._handleException(ex, "ZaXFormViewController.prototype.fireCreationEvent", details, false);    
    }

}
/**
*    Private method that notifies listeners to that the controlled ZaAccount is (are) removed
*     @param details
*/
ZaController.prototype.fireRemovalEvent =
function(details) {
    try {
        if (this._evtMgr.isListenerRegistered(ZaEvent.E_REMOVE)) {
            var evt = new ZaEvent(this.objType);
            evt.set(ZaEvent.E_REMOVE, this);
            evt.setDetails(details);
            this._evtMgr.notifyListeners(ZaEvent.E_REMOVE, evt);
        }
    } catch (ex) {
        this._handleException(ex, "ZaController.prototype.fireRemovalEvent", details, false);    
    }
}

/**
* member of ZaXFormViewController
*    Method that notifies listeners to that the controlled object is changed
*     @param details {String}
*/
ZaController.prototype.fireChangeEvent =
function(details) {
    try {
        if (this._evtMgr.isListenerRegistered(ZaEvent.E_MODIFY)) {
            var evt = new ZaEvent(this.objType);
            evt.set(ZaEvent.E_MODIFY, this);
            if(details)
                evt.setDetails(details);            
            this._evtMgr.notifyListeners(ZaEvent.E_MODIFY, evt);
        }
    } catch (ex) {
        this._handleException(ex, "ZaXFormViewController.prototype.fireChangeEvent", null, false);    
    }
}

/**
 *    Method that notifies listeners that search is done
 *     @param details
 */
ZaController.prototype.fireSearchEvent =
function(details) {
    try {
        if (this._evtMgr.isListenerRegistered(ZaEvent.E_SEARCH)) {
            var evt = new ZaEvent(this.objType);
            evt.set(ZaEvent.E_SEARCH, this);
            evt.setDetails(details);
            this._evtMgr.notifyListeners(ZaEvent.E_SEARCH, evt);
        }
    } catch (ex) {
        this._handleException(ex, "ZaController.prototype.fireSearchEvent", details, false);
    }
}

//item should be an xform item
ZaController.showTooltip =
function (event, item) {
    var dwtEv = new DwtUiEvent(true);
    dwtEv.setFromDhtmlEvent(event)
    var shell = DwtShell.getShell(window);
    var tooltip = shell.getToolTip();
    tooltip.setContent(item.getInheritedProperty("toolTipContent"));
    tooltip.popup(dwtEv.docX, dwtEv.docY);
}

ZaController.hideTooltip =
function (event) {
    var shell = DwtShell.getShell(window);
    var tooltip = shell.getToolTip();
    tooltip.popdown();
}

ZaController.prototype.selectExistingTabByItemId =
function (itemId, tabConstructor) {
    return false;
}

ZaController.prototype.changeActionsState =
function () {

    if(this.changeAcStateAcId)
        this.changeAcStateAcId = null;
        
    if(this._popupOperations) {
        for(var i in  this._popupOperations) {
            if(this._popupOperations[i] instanceof ZaOperation) {
                this._popupOperations[i].enabled = true;
            }
        }
    }
    
    if(ZaController.changeActionsStateMethods[this._iKeyName]) {
        var methods = ZaController.changeActionsStateMethods[this._iKeyName];
        var cnt = methods.length;
        for(var i = 0; i < cnt; i++) {
            if(typeof(methods[i]) == "function") {
                try {
                    methods[i].call(this);
                } catch (ex) {
                    this._handleException(ex, "ZaController.prototype.changeActionsState");
                }
            }
        }
    }    
    
    if(this._actionMenu && this._popupOperations) {
        for(var i in this._popupOperations) {
            if(this._popupOperations[i] instanceof ZaOperation && !AjxUtil.isEmpty(this._actionMenu.getMenuItem(this._popupOperations[i].id))) {
                this._actionMenu.getMenuItem(this._popupOperations[i].id).setEnabled(this._popupOperations[i].enabled);
            }
        }                                      
    }
    //enable More Actions Buttons

    // For New UI
    var isCurrentController;
    var currentController = ZaApp.getInstance().getCurrentController();
    if ( currentController && this != currentController) {
        isCurrentController = false;
    } else {
        isCurrentController = true;
    }
    var settingMenu = ZaZimbraAdmin.getInstance().getSettingMenu();
    if (isCurrentController && this._popupOperations && settingMenu) {
        for(var i in this._popupOperations) {
            if(this._popupOperations[i] instanceof ZaOperation && !AjxUtil.isEmpty(settingMenu.getMenuItem(this._popupOperations[i].id))) {
                settingMenu.getMenuItem(this._popupOperations[i].id).setEnabled(this._popupOperations[i].enabled);
            }
        }
    }
}

ZaController.prototype.closeTabsInRemoveList =
function (){
    var tabGroup = ZaApp.getInstance().getTabGroup();
    for (var i=0; i< this._itemsInTabList.length ; i ++) {
        var item = this._itemsInTabList[i];
        tabGroup.removeTab (tabGroup.getTabByItemId(item.id)) ;
        //add the item to the _removeList
        this._removeList.push(item);
    }
    tabGroup.resetTabSizes(true);
}


ZaController.prototype._showAccountsView = function (defaultType, ev, filterQuery) {

    var viewId = null;  
    if(defaultType == ZaItem.DL) {
        viewId=ZaZimbraAdmin._DISTRIBUTION_LISTS_LIST_VIEW;
    } else if (defaultType == ZaItem.RESOURCE){
        viewId=ZaZimbraAdmin._RESOURCE_LIST_VIEW;
    } else if(defaultType == ZaItem.ALIAS) {
        viewId=ZaZimbraAdmin._ALIASES_LIST_VIEW;
    } else {
        viewId=ZaZimbraAdmin._ACCOUNTS_LIST_VIEW;
    }    
    var acctListController = ZaApp.getInstance().getAccountListController(viewId);
    
    var query = "";

    if (defaultType != ZaItem.ALIAS)  { //alias uid has no domain name, we shouldn't add a domain name filter. See bug 46626, 44799 & 4704 
        if(!ZaSettings.HAVE_MORE_DOMAINS && ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] != 'TRUE') {
        var queryChunks = [];
        var params = {
            asyncMode : true,
            callback : this._showAccountsView.bind(this, defaultType, ev, filterQuery)
        };
        var domainList = ZaApp.getInstance().getDomainList(false, params);
        if (!domainList) {
            return;
        }
        domainList = domainList.getArray();
        //var domainList = [];
        var cnt = domainList.length;
        if(cnt>0) {
            queryChunks.push("(|");
        }
        
        for(var i = 0; i < cnt; i++) {
            queryChunks.push("(zimbraMailDeliveryAddress=*@");
            queryChunks.push(domainList[i].name);
            queryChunks.push(")");
            queryChunks.push("(zimbraMailAlias=*@");
            queryChunks.push(domainList[i].name);
            queryChunks.push(")");
        }
        if(cnt>0) {
            queryChunks.push(")");
            query=queryChunks.join("");
        }
    }
    }

    if(filterQuery) {
        query = query + filterQuery;
    }

    acctListController.setPageNum(1);    
    acctListController.setQuery(query);
    acctListController.setSortOrder("1");
    acctListController.setSortField(ZaAccount.A_name);
    acctListController.setSearchTypes([ZaSearch.TYPES[defaultType]]);
    acctListController.setDefaultType(defaultType);
    if(defaultType == ZaItem.DL) {
        acctListController.setFetchAttrs(ZaDistributionList.searchAttributes);
    } else if (defaultType == ZaItem.RESOURCE){
        acctListController.setFetchAttrs(ZaResource.searchAttributes);
    } else if(defaultType == ZaItem.ALIAS) {
        acctListController.setFetchAttrs(ZaAlias.searchAttributes);
    } else {
        acctListController.setFetchAttrs(ZaSearch.standardAttributes);
    }    
    
    if(ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(acctListController, ZaAccountListController.prototype.show, [true, ev.refresh]);
    } else {                    
        acctListController.show(true);
    }
};

ZaController.prototype.cancelBusyOverlay =
function (params) {
    if (this._currentRequest) {
        this._currentRequest.cancel() ;
    }
    ZaApp.getInstance().getAppCtxt().getShell().setBusy(false, params.busyId);    
}

ZaController.prototype.getPopUpOperation =
function() {
    if (this._popupOperations && this._popupOperations.length > 0)
        return  this._popupOperations;
    else
        return "";
}

ZaController.prototype.getPopUpMenu = 
function () {
    if (this._actionMenu != null)
        return this._actionMenu;
    else
        return null;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaXFormViewController")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaXFormViewController base class for all Za***ViewControllers (for XForm views only)
* @extends ZaController
* @contructor 
* @param appCtxt
* @param container
* @param app
* @param iKeyName
* @author Greg Solovyev
* @see ZaAccountViewController
* @see ZaCosController
* @see ZaDomainController
* @see ZaGlobalConfigViewController
**/

ZaXFormViewController = function(appCtxt, container,iKeyName) {
	if (arguments.length == 0) return;
	this._currentObject = null;
	ZaController.call(this, appCtxt, container,iKeyName);
	this.deleteMsg = ZaMsg.Q_DELETE_ACCOUNT;
	this._toolbarOrder = new Array();
}

ZaXFormViewController.prototype = new ZaController();
ZaXFormViewController.prototype.constructor = ZaXFormViewController;

/**
* A stack of validation methods. These methods are called before calling @link ZaXFormViewController.prototype._saveChanges method.
**/
ZaXFormViewController.preSaveValidationMethods = new Object();

ZaXFormViewController.prototype.show = 
function(entry) {
	if (! this.selectExistingTabByItemId(entry.id)){
		this._setView(entry, true);
	}
}

ZaXFormViewController.prototype.handleXFormChange = function (ev) {
	if(ev && ev.form.hasErrors() && this._toolbar) { 
        ZaZimbraAdmin.getInstance().getCurrentAppBar().enableButton(ZaOperation.SAVE, false);
	}
}
/**
* Method that notifies listeners to that the controlled ZaAccount is removed
* @param details {String}
*/
ZaXFormViewController.prototype.fireRemovalEvent =
function(details) {
	try {
		if (this._evtMgr.isListenerRegistered(ZaEvent.E_REMOVE)) {
			var evt = new ZaEvent(this.objType);
			evt.set(ZaEvent.E_REMOVE, this);
			evt.setDetails(details);
			this._evtMgr.notifyListeners(ZaEvent.E_REMOVE, evt);
		}
	} catch (ex) {
		this._handleException(ex, "ZaXFormViewController.prototype.fireRemovalEvent", details, false);	
	}
}

//Listeners for default toolbar buttons (close, save, delete)
/**
* member of ZaXFormViewController
* @param 	ev event object
* 			noPopView - It should be set to true when close a hidden tab
* handles the Close button click. Returns to the list view.
**/ 
ZaXFormViewController.prototype.closeButtonListener =
function(ev, noPopView, func, obj, params, newPath) {
    //prompt if the user wants to save the changes
    if(this._view && this._view.isDirty && this._view.isDirty()) {
        //parameters for the confirmation dialog's callback 
        var args = new Object();
        if (noPopView) {
            args["obj"] = obj ;
            args["params"] = [params, this];
            args["func"] = function(paramList){
                var realParams = paramList[0];
                func.call(this, realParams);
                //use closure to pass 'func', and this == obj, when being called in saveAndGoAway() or discardAndGoAway()
                var xFormViewController = paramList[1];
                //paramList[1] is ZaXFormViewController or its sub class
            };

        }else{
            args["obj"] = ZaApp.getInstance();
            args["params"] = [null, this];
            args["func"] = function(paramList){
                var realParams = paramList[0];
                //TODO have a new framework to handle memory issues
                //ZaApp.prototype.popView.call(this, realParams);
                //this == ZaApp.getInstance(), when being called in saveAndGoAway() or discardAndGoAway()
                var xFormViewController = paramList[1];
                //paramList[1] is ZaXFormViewController or its sub class
                xFormViewController._setSelectionAfterCloseView(newPath);
            };

        }
        //ask if the user wants to save changes
        ZaApp.getInstance().dialogs["confirmMessageDialog"].setMessage(ZaMsg.Q_SAVE_CHANGES, DwtMessageDialog.INFO_STYLE);
        ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.YES_BUTTON, this.saveAndGoAway, this, args);        
        ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.NO_BUTTON, this.discardAndGoAway, this, args);        
        ZaApp.getInstance().dialogs["confirmMessageDialog"].popup();

    } else if (noPopView){
        func.call(obj, params) ;

    }else{
        if(this._view && this._view._localXForm && this._view.formDirtyLsnr) {
            this._view._localXForm.removeListener(DwtEvent.XFORMS_FORM_DIRTY_CHANGE,this._view.formDirtyLsnr);
            this._view._localXForm.removeListener(DwtEvent.XFORMS_VALUE_ERROR,this._view.formDirtyLsnr);
        }
        //this._app.getTabGroup().removeCurrentTab(true) ;
        //ZaApp.getInstance().popView();
        //ZaApp.getInstance().getTabGroup().removeCurrentTab(true) ;

        this._setSelectionAfterCloseView(newPath);
    }
}

ZaXFormViewController.prototype._setSelectionAfterCloseView =
function(newPath) {
    var tree = ZaZimbraAdmin.getInstance().getOverviewPanelController().getOverviewPanel().getFolderTree();
    if (!newPath) {
        var rootItem = tree.getCurrentRootItem();
        var rootPath = tree.getABPath(rootItem.getData("dataItem"));
        var topPath = "";
        var lastLoc = rootPath.lastIndexOf(ZaTree.SEPERATOR);
        if(lastLoc > 0) {
            topPath = rootPath.substring(0,lastLoc);
        }
        newPath = topPath;
    }
	tree.setSelectionByPath(newPath, undefined, undefined, undefined, undefined, undefined, true);
}

/**
* This listener is called when the Delete button is clicked. 
* member of ZaXFormViewController
* @param 	ev event object
**/
ZaXFormViewController.prototype.deleteButtonListener =
function(ev) {
	if(this._currentObject.id) {
		ZaApp.getInstance().dialogs["confirmMessageDialog"].setMessage(this.deleteMsg, DwtMessageDialog.INFO_STYLE);
		ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.YES_BUTTON, this.deleteAndGoAway, this, null);		
		ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.NO_BUTTON, this.closeCnfrmDlg, this, null);				
		ZaApp.getInstance().dialogs["confirmMessageDialog"].popup();
	} else {
		ZaApp.getInstance().popView();
	}
}

/**
* This method handles "save" button click
* member of ZaXFormViewController
* @param 	ev event object
**/
ZaXFormViewController.prototype.saveButtonListener =
function(ev) {
	try {
		this.validateChanges();
	} catch (ex) {
		this._handleException(ex, "ZaXFormViewController.prototype.saveButtonListener", null, false);
	}
	return;
}

ZaXFormViewController.prototype._saveChanges = function() {
	return true;
}
/**
* member of ZaXFormViewController
* @param params
* This method saves the object in the form and calls method specified in params["func"]
**/
ZaXFormViewController.prototype.saveAndGoAway =
function (params) {
	try {
		this.closeCnfrmDlg();		
		if(this._saveChanges()) {
			this.fireChangeEvent(this._currentObject);			
			params["func"].call(params["obj"], params["params"]);	
			//ZaApp.getInstance().getTabGroup().removeCurrentTab(true) ;
		}
	} catch (ex) {
		this._handleException(ex, ZaXFormViewController.prototype.saveAndGoAway, null, false);
	}
}

/**
* member of ZaXFormViewController
* @param params
* This method deletes the object in the form and closes the form
**/
ZaXFormViewController.prototype.deleteAndGoAway = 
function () {
	try {
		if(this._currentObject.id) {
			this._currentObject.remove();
			this.fireRemovalEvent(this._currentObject);
            var msgName = "";
            switch(this._currentObject.type){
		        case ZaItem.ACCOUNT: msgName = ZaMsg.AccountDeleted ; break ;
                case ZaItem.DOMAIN: msgName = ZaMsg.DomainDeleted ; break ;
		        case ZaItem.RESOURCE: msgName = ZaMsg.ResourceDeleted ; break ;
		        case ZaItem.DL: msgName= ZaMsg.DLDeleted ; break ;
                case ZaItem.COS: msgName = ZaMsg.CosDeleted ; break ;
		        default: msgName = ""; break ;
	        }

            if(msgName) {
                ZaApp.getInstance().getAppCtxt().getAppController().setActionStatusMsg(AjxMessageFormat.format(msgName,[this._currentObject.name]));
            }

		}
		this.closeCnfrmDlg();	
		ZaApp.getInstance().popView();		
        var tree = ZaZimbraAdmin.getInstance().getOverviewPanelController().getOverviewPanel().getFolderTree();
        var rootItem = tree.getCurrentRootItem();
        var rootPath = tree.getABPath(rootItem.getData("dataItem"));
        var topPath = "";
        var lastLoc = rootPath.lastIndexOf(ZaTree.SEPERATOR);
        if(lastLoc > 0) {
            topPath = rootPath.substring(0,lastLoc);
        }
        tree.setSelectionByPath(topPath);
	} catch (ex) {
		this.closeCnfrmDlg();	
		this._handleException(ex, "ZaXFormViewController.prototype.deleteAndGoAway", null, false);				
	}
}

/**
* member of ZaXFormViewController
* Leaves current view without saving any changes
**/
ZaXFormViewController.prototype.discardAndGoAway = 
function (params) {
	this.closeCnfrmDlg();
	params["func"].call(params["obj"], params["params"]);		
}


ZaXFormViewController.prototype.runValidationStack = 
function(params) {
	try {
		var cnt = this.validationStack.length;
		if(cnt>0) {
			var method = this.validationStack[cnt-1];
			this.validationStack.pop();
			method.call(this,params);
		} else {
			this._saveChangesCallback(params);
		}
	} catch (ex) {
		this._handleException(ex, "ZaXFormViewController.prototype.runValidationStack", null, false);
	}
}

/**
* @param params - optional, params that contain a callback function 
* that will be called if the user answers "Yes",
* an argument for the callback function,
* and an object on which this function will be called
**/
ZaXFormViewController.prototype.validateChanges =
function (params) {
	//check if we are removing volumes
	this.validationStack = [];
	if(ZaXFormViewController.preSaveValidationMethods[this._iKeyName]) {
		var cnt=ZaXFormViewController.preSaveValidationMethods[this._iKeyName].length;
		if(cnt>0) {
			for(var i=0;i<cnt;i++) {
				this.validationStack.push(ZaXFormViewController.preSaveValidationMethods[this._iKeyName][i]);
			}
		}
	}
	this.runValidationStack(params);
}

/**
* @param params - optional, contains parameters for the next call
**/
ZaXFormViewController.prototype._saveChangesCallback = 
function (params) {
	try {
		if(this._saveChanges()) {
			this._view.setDirty(false);
            ZaZimbraAdmin.getInstance().getCurrentAppBar().enableButton(ZaOperation.SAVE, false);
		
			this.closeCnfrmDlg();

            if (typeof (this.changeActionsState) == "function") { //update the toolbar buttons
                this.changeActionsState ();
            }

			this._currentObject.refresh(false,true);	
			this.fireChangeEvent(this._currentObject);		
			if(params) {
				params["func"].call(params["obj"], params["params"]);
			} else {
				this._view.setObject(this._currentObject);			
			}
		}
	} catch (ex) {
		//if exception thrown - don't go away
		this._handleException(ex, "ZaXFormViewController.prototype._saveChangesCallback", null, false);
	}	
}


/**
* member of ZaXFormViewController
* enables/disables "Save" button on this Form's toolbar
* if there is no Save button, the method just returns
* @param isD {Boolean}
**/
ZaXFormViewController.prototype.setDirty = 
function (isD) {
    var settingMenu = ZaZimbraAdmin.getInstance().getSettingMenu();
    if (!settingMenu ||
        !this._popupOperations ||
        !this._popupOperations[ZaOperation.SAVE] ||
        !this._popupOperations[ZaOperation.SAVE].id)
        return;

    if (!this._popupOperations)
        return;

    if (!this._popupOperations[ZaOperation.SAVE])
        return;

    var saveItem = settingMenu.getMenuItem(this._popupOperations[ZaOperation.SAVE].id)
    if (AjxUtil.isEmpty(saveItem))
        return;

    if(isD)
        saveItem.setEnabled(true);
    else
        saveItem.setEnabled(false);

    if(isD)
        ZaZimbraAdmin.getInstance().getCurrentAppBar().enableButton(ZaOperation.SAVE, true);
    else
        ZaZimbraAdmin.getInstance().getCurrentAppBar().enableButton(ZaOperation.SAVE, false);
}

/**
*	@method setViewMethod 
*	@param entry - data object
*/
ZaXFormViewController.setViewMethod =
function(entry) {
	if(entry.load)
		entry.load();
		
	if(!this._UICreated) {
		this._createUI();
	} 
	ZaApp.getInstance().pushView(this.getContentViewId());
	this._view.setObject(entry); 	//setObject is delayed to be called after pushView in order to avoid jumping of the view	
	this._currentObject = entry;
}

/**
* @method _createUI
**/
ZaXFormViewController.prototype._createUI =
function () {
	this._contentView = this._view = new this.tabConstructor(this._container);

	var elements = new Object();
	elements[ZaAppViewMgr.C_APP_CONTENT] = this._view;

    ZaApp.getInstance().getAppViewMgr().createView(this.getContentViewId(), elements);

	this._UICreated = true;
	ZaApp.getInstance()._controllers[this.getContentViewId ()] = this ;
}


ZaXFormViewController.prototype._findAlias = function (alias) {
    var types = [ZaSearch.ALIASES,ZaSearch.DLS,ZaSearch.ACCOUNTS, ZaSearch.RESOURCES] ; 
    var searchQuery = new ZaSearchQuery(ZaSearch.searchAliasByNameQuery(alias, types), types, null, false);
	// this search should only return one result
	var results = ZaSearch.searchByQueryHolder(searchQuery, 1, null, null);
	return results.list.getArray()[0];
};

ZaXFormViewController.prototype.getAppBarAction =
function () {
    if (AjxUtil.isEmpty(this._appbarOperation)) {
    	this._appbarOperation[ZaOperation.HELP]=new ZaOperation(ZaOperation.HELP,ZaMsg.TBB_Help, ZaMsg.TBB_Help_tt, "Help", "Help", new AjxListener(this, this._helpButtonListener));
        this._appbarOperation[ZaOperation.SAVE]= new ZaOperation(ZaOperation.SAVE, ZaMsg.TBB_Save, ZaMsg.ALTBB_Save_tt, "", "", new AjxListener(this, this.saveButtonListener));
        this._appbarOperation[ZaOperation.CLOSE] = new ZaOperation(ZaOperation.CLOSE, ZaMsg.TBB_Close, ZaMsg.ALTBB_Close_tt, "", "", new AjxListener(this, this.closeButtonListener));
    }

    return this._appbarOperation;
}

ZaXFormViewController.prototype.getAppBarOrder =
function () {
    if (AjxUtil.isEmpty(this._appbarOrder)) {
    	this._appbarOrder.push(ZaOperation.HELP);
        this._appbarOrder.push(ZaOperation.SAVE);
        this._appbarOrder.push(ZaOperation.CLOSE);
    }

    return this._appbarOrder;
}

ZaXFormViewController.prototype._helpButtonListener =
function() {
	var helpUrl = this._helpURL; 
	if(this._contentView && this._contentView.helpMap && this._contentView.getCurrentTab() && this._contentView.helpMap[this._contentView.getCurrentTab()]) {
		helpUrl = this._contentView.helpMap[this._contentView.getCurrentTab()];
	}
	window.open(helpUrl);
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaListViewController")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
 * @class ZaListViewController base class for all Za***ListControllers (for list
 *        views)
 * @extends ZaController
 * @contructor
 * @param appCtxt
 * @param container
 * @param app
 * @param iKeyName
 * @author Greg Solovyev
 * @see ZaAccountListController
 * @see ZDomainListController
 */
ZaListViewController = function(appCtxt, container, iKeyName) {
    if (arguments.length == 0)
        return;
    this._currentPageNum = 1;
    // this.pages = new Object();
    this._currentSortOrder = "1";
    ZaController.call(this, appCtxt, container, iKeyName);
    this.RESULTSPERPAGE = ZaSettings.RESULTSPERPAGE;
    this.MAXSEARCHRESULTS = ZaSettings.MAXSEARCHRESULTS;
}

ZaListViewController.prototype = new ZaController();
ZaListViewController.prototype.constructor = ZaListViewController;

ZaListViewController.prototype._nextPageListener = function(ev) {
    if (this._currentPageNum < this.numPages) {
        this._currentPageNum++;
        this.show();
    }
}

ZaListViewController.prototype._prevPageListener = function(ev) {
    if (this._currentPageNum > 1) {
        this._currentPageNum--;
        /*
         * if(this.pages[this._currentPageNum]) {
         * this.show(this.pages[this._currentPageNum]) } else {
         */
        this.show();
        // }
    }
}

/**
 * @return ZaItemList - the list currently displaid in the list view
 */
ZaListViewController.prototype.getList = function() {
    return this._list;
}

ZaListViewController.prototype._updateUI = function(list, openInNewTab, openInSearchTab, hasMore) {
    if (!this._UICreated) {
        this._createUI(openInNewTab, openInSearchTab);
    }
    if (list) {
        var tmpArr = new Array();
        var cnt = list.getArray().length;
        for (var ix = 0; ix < cnt; ix++) {
            tmpArr.push(list.getArray()[ix]);
        }
        if (cnt < 1) {
            // if the list is empty - go to the previous page
        }
        // add the default column sortable
        this._contentView._bSortAsc = (this._currentSortOrder == "1");
        this._contentView.set(AjxVector.fromArray(tmpArr), this._contentView._defaultColumnSortable);
        this._contentView.setScrollSearchParams(this.scrollSearchParams);
        this._contentView.setScrollHasMore(hasMore);
    }
    this._removeList = new Array();
    this.changeActionsState();

}

ZaListViewController.prototype.closeButtonListener = function(ev, noPopView, func, obj, params) {
    if (noPopView) {
        func.call(obj, params);
    } else {
        ZaApp.getInstance().popView();
    }
    this._UICreated = false;
    if (this._contentView) {
        this._contentView.dispose();
        this._contentView = null;
    }

    if (this._actionMenu) {
        this._actionMenu.dispose();
        this._actionMenu = null;
    }
    this._popupOperations = [];
}

ZaListViewController.prototype.multipleSearchCallback = function(preParams, paramsArr) {
    var sortBy, limit, offset, sortAscending, soapDoc, cnt;
    var paramList = null;
    if (!paramsArr)
        return;
    if (paramsArr instanceof Array && paramsArr.length > 0)
        paramList = paramsArr;
    else {
        paramList = new Array();
        paramList.push(paramsArr);
    }

    cnt = paramList.length;
    soapDoc = AjxSoapDoc.create("BatchRequest", "urn:zimbra");
    soapDoc.setMethodAttribute("onerror", "continue");

    for (var i = 0; i < cnt; i++) {
        var getSearchDirDoc = soapDoc.set("SearchDirectoryRequest", null, null, ZaZimbraAdmin.URN);
        var squery = soapDoc.set("query", paramList[i].query, getSearchDirDoc);

        sortBy = (paramList[i].sortBy != undefined) ? paramList[i].sortBy : ZaAccount.A_name;
        limit = (paramList[i].limit != undefined) ? paramList[i].limit : ZaAccount.RESULTSPERPAGE;
        offset = (paramList[i].offset != undefined) ? paramList[i].offset : "0";
        sortAscending = (paramList[i].sortAscending != null) ? paramList[i].sortAscending : "1";

        getSearchDirDoc.setAttribute("offset", offset);
        getSearchDirDoc.setAttribute("limit", limit);
        getSearchDirDoc.setAttribute("sortBy", sortBy);
        getSearchDirDoc.setAttribute("sortAscending", sortAscending);

        if (paramList[i].applyCos)
            getSearchDirDoc.setAttribute("applyCos", paramList[i].applyCos);
        else
            getSearchDirDoc.setAttribute("applyCos", false);

        if (paramList[i].applyConfig)
            getSearchDirDoc.setAttribute("applyConfig", paramList[i].applyConfig);
        else
            getSearchDirDoc.setAttribute("applyConfig", "false");

        if (paramList[i].domain) {
            getSearchDirDoc.setAttribute("domain", paramList[i].domain);

        }
        if (paramList[i].attrs && paramList[i].attrs.length > 0)
            getSearchDirDoc.setAttribute("attrs", paramList[i].attrs.toString());

        if (paramList[i].types && paramList[i].types.length > 0)
            getSearchDirDoc.setAttribute("types", paramList[i].types.toString());

        if (paramList[i].maxResults) {
            getSearchDirDoc.setAttribute("maxResults", paramList[i].maxResults.toString());
        }

    }

    var params = new Object();
    params.soapDoc = soapDoc;
    var reqMgrParams = {
        controller : this,
        busyMsg : ZaMsg.BUSY_REQUESTING_ACCESS_RIGHTS
    }

    var respObj = ZaRequestMgr.invoke(params, reqMgrParams);
    // Count statistics that will show in search tree
    var resultStats;
    if (respObj.isException && respObj.isException()) {
        ZaApp.getInstance().getCurrentController()._handleException(respObj.getException(),
                "ZaListViewController.prototype.multipleSearchCallback", null, false);
    } else if (respObj.Body.BatchResponse.Fault) {
        var fault = respObj.Body.BatchResponse.Fault;
        if (fault instanceof Array)
            fault = fault[0];

        if (fault) {
            var ex = ZmCsfeCommand.faultToEx(fault);
            ZaApp.getInstance().getCurrentController()._handleException(ex,
                    "ZaListViewController.prototype.multipleSearchCallback", null, false);
        }
    } else {
        var batchResp = respObj.Body.BatchResponse;
        if (batchResp.SearchDirectoryResponse && batchResp.SearchDirectoryResponse instanceof Array) {
            var cnt2 = batchResp.SearchDirectoryResponse.length;
            ZaSearch.TOO_MANY_RESULTS_FLAG = false;
            this._searchTotal = 0;
            this._list = null;
            var hasmore = false;
            for (var i = 0; i < cnt2; i++) {
                resp = batchResp.SearchDirectoryResponse[i];
                var subList = new ZaItemList(preParams.CONS);

                subList.loadFromJS(resp);
                // combine the search results
                if (!this._list)
                    this._list = subList;
                else {
                    if (this._list instanceof ZaItemList && subList.size() > 0) {
                        var listVec = subList.getVector();
                        for (var j = 0; j < listVec.size(); j++) {
                            var item = listVec.get(j);
                            if (!this._list.getVector().contains(item))
                                this._list.add(item);
                        }
                    }
                }
                hasmore = resp.more | hasmore;
                this._searchTotal += resp.searchTotal;
                resultStats = this.getSearchResultStats(resp, resultStats);
            }

            var limit = preParams.limit ? preParams.limit : this.RESULTSPERPAGE;
            this.numPages = Math.ceil(this._searchTotal / preParams.limit);

            if (preParams.show)
                this._show(this._list, preParams.openInNewTab, preParams.openInSearchTab, hasmore,
                        preParams.isShowBubble);
            else
                this._updateUI(this._list, preParams.openInNewTab, preParams.openInSearchTab, hasmore);

        }
    }
    ZaZimbraAdmin.getInstance().getOverviewPanelController().fireSearchEvent(resultStats);
}

ZaListViewController.prototype.getAppBarAction = function() {
    if (AjxUtil.isEmpty(this._appbarOperation)) {
        this._appbarOperation[ZaOperation.HELP] = new ZaOperation(ZaOperation.HELP, ZaMsg.TBB_Help, ZaMsg.TBB_Help_tt,
                "Help", "Help", new AjxListener(this, this._helpButtonListener));
    }

    return this._appbarOperation;
}

ZaListViewController.prototype.getAppBarOrder = function() {
    if (AjxUtil.isEmpty(this._appbarOrder)) {
        this._appbarOrder.push(ZaOperation.HELP);
    }

    return this._appbarOrder;
}

ZaListViewController.prototype.searchCallback = function(params, resp) {
    try {
        if (params.busyId)
            ZaApp.getInstance().getAppCtxt().getShell().setBusy(false, params.busyId);

        if (!resp && !this._currentRequest.cancelled) {
            throw (new AjxException(ZaMsg.ERROR_EMPTY_RESPONSE_ARG, AjxException.UNKNOWN,
                    "ZaListViewController.prototype.searchCallback"));
        }

        var resultStats;
        if (resp && resp.isException() && !this._currentRequest.cancelled) {
            ZaSearch
                    .handleTooManyResultsException(resp.getException(), "ZaListViewController.prototype.searchCallback");
            this._list = new ZaItemList(params.CONS);

            this._searchTotal = 0;
            this.numPages = 0;
            if (params.show)
                this._show(this._list);
            else
                this._updateUI(this._list);
        } else {
            ZaSearch.TOO_MANY_RESULTS_FLAG = false;
            this._list = null;
            var tempList = new ZaItemList(params.CONS);
            this._searchTotal = 0;
            if (resp && !resp.isException()) {
                var response = resp.getResponse().Body.SearchDirectoryResponse;

                this._list = new ZaItemList(params.CONS);

                tempList.loadFromJS(response);
                // filter the search result
                if (params.resultFilter && tempList.size() > 0) {
                    var listVec = tempList.getVector();
                    for (var i = 0; i < listVec.size(); i++) {
                        var item = listVec.get(i);
                        var target = null;
                        if (item.type == ZaItem.ALIAS)
                            target = item.getAliasTargetObj();
                        else
                            target = item;
                        for ( var f in params.resultFilter) {
                            if (target.attrs[f].indexOf(params.resultFilter[f]) >= 0) {
                                this._list.add(item);
                                break;
                            }
                        }

                    }
                } else
                    this._list = tempList;

                this._searchTotal = response.searchTotal;
                var limit = params.limit ? params.limit : this.RESULTSPERPAGE;
                this.numPages = Math.ceil(this._searchTotal / params.limit);
                resultStats = this.getSearchResultStats(response);
            }
            if (params.show)
                this._show(this._list, params.openInNewTab, params.openInSearchTab, response.more, params.isShowBubble);
            else
                this._updateUI(this._list, params.openInNewTab, params.openInSearchTab, response.more);
        }
        ZaZimbraAdmin.getInstance().getOverviewPanelController().fireSearchEvent(resultStats);
    } catch (ex) {
        if (ex.code != ZmCsfeException.MAIL_QUERY_PARSE_ERROR) {
            this._handleException(ex, "ZaListViewController.prototype.searchCallback");
        } else {
            this.popupErrorDialog(ZaMsg.queryParseError, ex);
            if (this._searchField)
                this._searchField.setEnabled(true);
        }
    }
}

/**
 * Get the count statistics of the search result.
 * 
 * @param resp
 *                response
 * @param orig
 *                Optional. The count statics will be added to <code>orig</code>
 *                if it is provided. It is used for batch request.
 */
ZaListViewController.prototype.getSearchResultStats = function(resp, orig) {
    var result = {};
    if (orig) {
        result = orig;
    }

    if (!resp || !resp.searchTotal) {
        return result;
    }

    if (result.searchTotal) {
        result.searchTotal += resp.searchTotal;
    } else {
        result.searchTotal = resp.searchTotal;
    }
    return result;
}

/**
 * @param ev
 *                This listener is invoked by any other controller that can
 *                change an object in this controller
 */
ZaListViewController.prototype.handleChange = function(ev) {
    if (ev && this.objType && ev.type == this.objType) {
        if (ev.getDetails() && this._UICreated) {
            this.show(false);
        }
    }
    ZaZimbraAdmin.getInstance().getOverviewPanelController().refreshRelatedTreeByEdit(ev.getDetails())
}

/**
 * @param ev
 *                This listener is invoked by any other controller that can
 *                create an object in the view controlled by this controller
 */
ZaListViewController.prototype.handleCreation = function(ev) {
    if (ev && this.objType && ev.type == this.objType) {
        if (ev.getDetails() && this._UICreated) {
            this.show(false);
        }
    }
    ZaZimbraAdmin.getInstance().getOverviewPanelController().refreshRelatedTree(ev.getDetails());
}

/**
 * @param ev
 * This listener is invoked by any other controller that can remove an object form the view controlled by this controller
 **/
ZaListViewController.prototype.handleRemoval = function(ev) {
    if (ev && this.objType && ev.type == this.objType) {
        if (ev.getDetails() && this._UICreated) {
            this._currentPageNum = 1; //due to bug 12091, always go back to the first page after the deleting of items.
            this.show(false);
        }
        ZaZimbraAdmin.getInstance().refreshHistoryTreeByDelete(ev.getDetails());
    }
}

ZaListViewController.prototype.setPageNum = function(pgnum) {
    this._currentPageNum = Number(pgnum);
}

ZaListViewController.prototype.getPageNum = function() {
    return this._currentPageNum;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaItemVector")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class This is a Vector that contains ZaItems. Unlike in AjxVector {AjxVector#contains} and
* {AjxVector#remove} methods compare object ids (@link ZaItem.id) instead of comparing the whole objects.
* {AjxVector#add} method is overwriten to accept only instances of ZaItem class.
* @constructor
**/

ZaItemVector = function() {
	AjxVector.call(this, null);
}

ZaItemVector.prototype = new AjxVector;
ZaItemVector.prototype.constructor = ZaItemVector;

ZaItemVector.prototype.contains = 
function(obj) {
	if(! (obj instanceof ZaItem) ) {
		throw new DwtException("Invalid parameter", DwtException.INTERNAL_ERROR, "ZaItemVector.prototype.add", "ZaItemVector can contain only objects of ZaItem class and classes that extend ZaItem.");
	}
	for (var i = 0; i < this._array.length; i++) {
		if (this._array[i].id == obj.id)
			return true;
	}
	return false;
}

ZaItemVector.prototype.remove = 
function(obj) {
	if(! (obj instanceof ZaItem) ) {
		throw new DwtException("Invalid parameter", DwtException.INTERNAL_ERROR, "ZaItemVector.prototype.add", "ZaItemVector can contain only objects of ZaItem class and classes that extend ZaItem.");
	}
	for (var i = 0; i < this._array.length; i++) {
		if (this._array[i].id == obj.id) {
			this._array.splice(i,1);
			return true;
		}
	}
	return false;
}

ZaItemVector.prototype.replace =
function (obj, index) {
	if(! (obj instanceof ZaItem) ) {
		throw new DwtException("Invalid parameter", DwtException.INTERNAL_ERROR, "ZaItemVector.prototype.replace", "ZaItemVector can contain only objects of ZaItem class and classes that extend ZaItem.");
	}
	
	if (index == null || index < 0 || index >= this._array.length) {
		for (var i = 0; i < this._array.length; i++) {
			if (this._array[i].id == obj.id) {
				this._array.splice(i,1, obj);
				return true;
			}
		}
	}else {
		this._array.splice(index, 1, obj);
	}
	
	//can't find the original item. Do a fresh add
	return this.add (obj);	
}

ZaItemVector.prototype.add =
function(obj, index) {
	// if index is out of bounds, 
	if(! (obj instanceof ZaItem) ) {
		throw new DwtException("Invalid parameter", DwtException.INTERNAL_ERROR, "ZaItemVector.prototype.add", "ZaItemVector can contain only objects of ZaItem class and classes that extend ZaItem.");
	}
	if (index == null || index < 0 || index >= this._array.length) {
		// append object to the end
		this._array.push(obj);
	} else {
		// otherwise, insert object
		this._array.splice(index, 0, obj);
	}
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaItemList")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
 
/**
* @class ZaItemList a list of ZaItem {@link ZaItem} objects.
* @constructor
* @param constructor {Function) a reference to a constructor function which is called to create a single instance of an object contained in the list.
* @param app {ZaApp} {@link ZaApp} a reference to an instance of ZaApp. This reference is passed to constructor when a ZaItem object is constructed.
**/
ZaItemList = function(constructor) {

	//if (arguments.length == 0) return;
	ZaModel.call(this, true);
	if(constructor)
		this._constructor = constructor;

	this.loadedRights = false;
	this._vector = new ZaItemVector();
	this._idHash = new Object();
	this._targetIdHash = new Object();
}

ZaItemList.prototype = new ZaModel;
ZaItemList.prototype.constructor = ZaItemList;

ZaItemList.prototype.toString = 
function() {
	return "ZaItemList";
}

ZaItemList.prototype.replace =
function (item, index) {
	this._vector.replace(item, index);
	if (item.id) {
		this._idHash[item.id] = item;
	}
	if(item.attrs && item.attrs[ZaAlias.A_AliasTargetId]) {
		this._targetIdHash[item.attrs[ZaAlias.A_AliasTargetId]] = item;
	}
		
}

ZaItemList.prototype.replaceItem =
function (item) {
	if (item.id) {
		this._idHash[item.id] = item;
	}
	if(item.attrs && item.attrs[ZaAlias.A_AliasTargetId]) {
		this._targetIdHash[item.attrs[ZaAlias.A_AliasTargetId]] = item;
	}
	
}


/**
* Adds an item to the list.
*
* @param item	the item to add
* @param index	the index at which to add the item (defaults to end of list)
*/
ZaItemList.prototype.add = 
function(item, index) {
	this._vector.add(item, index);
	if (item.id) {
		this._idHash[item.id] = item;
	}
	if(item.attrs && item.attrs[ZaAlias.A_AliasTargetId]) {
		this._targetIdHash[item.attrs[ZaAlias.A_AliasTargetId]] = item;
	}
}

/**
* Removes an item from the list.
*
* @param item	the item to remove
*/
ZaItemList.prototype.remove = 
function(item) {
	this._vector.remove(item);
	if (item.id)
		delete this._idHash[item.id];
		
	if(item.attrs && item.attrs[ZaAlias.A_AliasTargetId] && this._targetIdHash[item.attrs[ZaAlias.A_AliasTargetId]]) {
		 delete this._targetIdHash[item.attrs[ZaAlias.A_AliasTargetId]];
	}
		
}

/**
* Returns the number of items in the list.
*/
ZaItemList.prototype.size = 
function() {
	return this._vector.size();
}

/**
* Returns the list as an array.
*/
ZaItemList.prototype.getArray =
function() {
	return this._vector.getArray();
}

/**
* Returns the list as a ZaItemVector.
*/
ZaItemList.prototype.getVector =
function() {
	return this._vector;
}

/**
* Returns the hash matching IDs to items.
*/
ZaItemList.prototype.getIdHash =
function() {
	return this._idHash;
}

/**
* Returns the item with the given ID.
*
* @param id		an item ID
*/
ZaItemList.prototype.getItemById =
function(id) {
	return this._idHash[id] ? this._idHash[id] : 
		this._targetIdHash[id] ? this._targetIdHash[id] : null;
}

/**
* Clears the list, including its ID hash.
*/
ZaItemList.prototype.clear =
function() {
	this._vector.removeAll();
	for (var id in this._idHash)
		this._idHash[id] = null;
	this._idHash = new Object();

	for (var id in this._targetIdHash)
		this._targetIdHash[id] = null;
	
	this._targetIdHash = null;
}

/**
* Populates the list with elements created from the response to a SOAP command. Each
* node in the response should represent an item of the list's type.
*
* @param respNode	an XML node whose children are item nodes
*/
ZaItemList.prototype.loadFromDom = 
function(respNode) {
	this.clear();
	var nodes = respNode.childNodes;
	for (var i = 0; i < nodes.length; i++) {
		var item;
		if(this._constructor) {
			item = new this._constructor();
		} else {
			item = ZaItem.getFromType(nodes[i].nodeName);
		}
		item.type = nodes[i].nodeName;
		item.initFromDom(nodes[i]);
		//add the list as change listener to the item
		this.add(item);
	}
}

/**
* Populates the list with elements created from the response to a SOAP command. 
* Each property of the resp parameter should contain properties of an item of the list' type.
* @param resp {Object} 
*/
ZaItemList.prototype.loadFromJS =
function(resp) {
	if(!resp)
		return;
	for(var ix in resp) {
		if(resp[ix] instanceof Array) {
			var arr = resp[ix];
			var len = arr.length;
			for(var i = 0; i < len; i++) {
				var item;
				if(this._constructor) {
					item = new this._constructor();
				} else {
					item = ZaItem.getFromType(ix);
				}
				item.type = ix;	
				item.initFromJS(arr[i]);
				
				//special cases
                /*
				if (item instanceof ZaDomain && item.attrs[ZaDomain.A_domainType] == "alias"){
					continue ;
				} */
				if (item instanceof ZaAlias) {
					item.attrs[ZaAlias.A_targetType] = arr[i][ZaAlias.A_targetType] ;
					item.attrs[ZaAlias.A_targetAccount] = arr[i][ZaAlias.A_targetAccount] ;
				}
				
				if(this._idHash[item.id]) {
					this._idHash[item.id].initFromJS(arr[i]);
				} else {
					this.add(item);								
				}
			}
		}  
	}
}

/**
* Grab the IDs out of a list of items, and return them as both a string and a hash.
**/
ZaItemList.prototype._getIds =
function(list) {
	var idHash = new Object();
	if (!(list && list.length))
		return idHash;
	var ids = new Array();
	for (var i = 0; i < list.length; i++) {
		var id = list[i].id;
		if (id) {
			ids.push(id);
			idHash[id] = list[i];
		}
	}
	idHash.string = ids.join(",");
	return idHash;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaListView")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaListView
* @constructor ZaListView
* @param parent
* @ className
* @ posStyle
* @ headerList
* Abstract class list views. All the List views in the Admin panel extend this class.
* @author Greg Solovyev
**/

ZaListView = function(params) {
	if (arguments.length == 0) return;
	params = Dwt.getParams(arguments, ZaListView.PARAMS);
	var id = (params.view) ? DwtId.getListViewId(params.view,params.id) : DwtId.getListViewId(params.id);
	params.id = id;
	DwtListView.call(this, params);

	//bug: 18787
	//Set the ListView Div DwtControl.SCROLL(overflow: auto) And the Rows Dwt.VISIBLE
    //In this way, the view of lists can be controlled by the scroll of the li st view
    // At the same time, no list row content will be hidden
    if (params.scrollLoading) {
		Dwt.setHandler(this._getScrollDiv(), DwtEvent.ONSCROLL, ZaListView.handleScroll);
	}

    this.setScrollStyle(DwtControl.SCROLL);
	if (this._listDiv) this._listDiv.style.overflow = "visible";

    this.scrollSearchParams=null;
    this.scrollHasMore=false;
}

ZaListView.PARAMS = ["parent", "className", "posStyle", "headerList", "view", "id", "scrollLoading"];

ZaListView.prototype = new DwtListView;
ZaListView.prototype.constructor = ZaListView;

ZaListView.prototype.toString = 
function() {
	return "ZaListView";
}

ZaListView.ITEM_FLAG_CLICKED = DwtListView._LAST_REASON + 1;

// default implementation
ZaListView.prototype._createItemHtml = function(item) {
	DwtListView.prototype._createItemHtml.call(this,item);
}

ZaListView.prototype.createHeaderHtml = function (defaultColumnSort) {
    DwtListView.prototype.createHeaderHtml.call(this, defaultColumnSort, true);
}

ZaListView.prototype.getTitle =
function () {
	return	"";
}

ZaListView.prototype.getTabToolTip =
function () {
	return	this.getTitle ();
}

ZaListView.prototype.getTabIcon = 
function () {
	return "" ;
}

ZaListView.prototype.getTabTitle =
function () {
	return this.getTitle() ;
}

ZaListView.prototype._mouseOverAction =
function(ev, div) {
	var _type = this._getItemData(div,"type");
	if (_type == DwtListView.TYPE_HEADER_ITEM) {
		if(this._headerList[this._getItemData(div,"index")]._sortable) {
			div.className = "DwtListView-Column DwtListView-ColumnHover";		
			this.setToolTipContent(AjxMessageFormat.format(ZaMsg.LST_ClickToSort_tt, [this._headerList[this._getItemData(div,"index")].getLabel()]));	
		} else {
			this.setToolTipContent(null);
		}
	} else if (_type == DwtListView.TYPE_HEADER_SASH) {
		div.style.cursor = AjxEnv.isIE ? "col-resize" : "e-resize";
    } else if (_type == DwtListView.TYPE_LIST_ITEM){
		var item = this.getItemFromElement(div);
		if (item && item.getToolTip) {
			var tt_content = "" ;
			try {	
				 //if(window.console && window.console.log) console.log("Item: " + item.name) ;
				 tt_content = item.getToolTip() ;
			}catch (e) {
				 tt_content = e.msg ;
			}
			this.setToolTipContent(tt_content);
        }
    }
	return true;
}


ZaListView.prototype._mouseOutAction = 
function(mouseEv, div) {
	var _type = this._getItemData(div,"type");
	if (_type == DwtListView.TYPE_HEADER_ITEM) {
		if(this._headerList[this._getItemData(div,"index")]._sortable) {
			div.className = (div.id != this._currentColId) ? "DwtListView-Column" : "DwtListView-Column DwtListView-ColumnActive"
		}
	}else if (_type == DwtListView.TYPE_HEADER_SASH) {
		div.style.cursor = "auto";
	}
	return true;
}

// Tooltip will be based on cursor
ZaListView.prototype.getTooltipBase =
function (hoverEv) {
    return null;
}

ZaListView.prototype._setListEvent =
function (ev, listEv, clickedEl) {
	DwtListView.prototype._setListEvent.call(this, ev, listEv, clickedEl);
	var parts = ev.target.id.split(DwtId.SEP);
	listEv.field = parts && parts[2];
	return true;
}

ZaListView.prototype._sortColumn = 
function(columnItem, bSortAsc) {
	if (bSortAsc) {
		this._list.sort(ZaItem.compareNamesAsc);
	} else {
		this._list.sort(ZaItem.compareNamesDesc);
	}
	
	this.setUI();
}

ZaListView.prototype._setNoResultsHtml =
function () {
	if (ZaSearch.TOO_MANY_RESULTS_FLAG ){
		var htmlArr = new Array(3);
		var idx = 0;
	
		htmlArr[idx++] = "<table width='100%' cellspacing='0' cellpadding='1'><tr><td class='NoResults'><br>";
		htmlArr[idx++] = ZaMsg.TooManyResults;
		htmlArr[idx++] = "</td></tr></table>";
	
		var	div = document.createElement("div");
		div.innerHTML = htmlArr.join("");
		this._addRow(div);
	}else{
		DwtListView.prototype._setNoResultsHtml.call (this) ;
	}
}

ZaListView.prototype._getScrollDiv =
function() {
	return this.getHtmlElement();
};


ZaListView.prototype.setScrollSearchParams=
function(searchParams) {
    this.scrollSearchParams=searchParams;
}

ZaListView.prototype.setScrollHasMore=
function(hasMore) {
    this.scrollHasMore=hasMore;
}

ZaListView._getSearchKeyWord =
function(query) {
	var keyword = "";
	var sw = "zimbraDomainName=*";
        var domflag = "@";
	var ew = "*";
	if(!query) return keyword;
	var start = query.indexOf(sw);
	if(start < 0 || start > query.length-1)
	    return [];
	var end = query.indexOf(ew,start+sw.length);
	if(end > query.length-1)
	    return [];
	keyword = query.substr(start+sw.length,end-start-sw.length);
        // handle the case of "str@str"
        start = keyword.indexOf(domflag);
	if(start < 0 || start > query.length-1)
	    return [keyword];
	return [keyword.substr(start+1,keyword.length),keyword.substr(0,start)];
}

ZaListView.prototype.searchAliasDomain =
function (value, searchCtl,searchQueryList, offset, limit) {
        var busyId = Dwt.getNextId();
        var controller = searchCtl;

        var query = "(" + ZaDomain.A_domainName;
        if(value.length > 0) query += "=" + value[0] + "*)";
        else query = "";

        var callback = new AjxCallback(this, this.searchAliasDomainCallback,
            {busyId:busyId, searchQueryList:searchQueryList, childQueries:value, offset:offset, limit:limit});
        var searchParams = {
                        query: query,
                        types: [ZaSearch.DOMAINS],
                        sortBy: ZaDomain.A_domainName,
                        attrs: [ZaDomain.A_domainName],
                        callback:callback,
                        controller: controller,
                        showBusy:true,
                        busyId:busyId,
                        busyMsg:ZaMsg.BUSY_SEARCHING_DOMAINS,
			skipCallbackIfCancelled:false
        }
        ZaSearch.searchDirectory(searchParams);

}

ZaListView.prototype.searchAliasDomainCallback =
function(params,resp) {

        if(params.busyId)
                   ZaApp.getInstance().getAppCtxt().getShell().setBusy(false, params.busyId);
        try {
                if(!resp) {
                        throw(new AjxException(ZaMsg.ERROR_EMPTY_RESPONSE_ARG, AjxException.UNKNOWN, "ZaListView.searchAliasDomainCallback"));
                }
                if(resp.isException()) {
                        throw(resp.getException());
                } else {
                        var response = resp.getResponse().Body.SearchDirectoryResponse;
			var domainArr = new Array();
                        if (response.domain && response.domain.length > 0) {
                                for (var i =0; i < response.domain.length; i ++) {
                                       var domain = response.domain[i].name ;
						domainArr.push(domain);
                                }

                        }
			this._batchSearchforDomain(domainArr,params.searchQueryList, params.childQueries, params.offset, params.limit);
                }
        } catch (ex) {
		this._handleException(ex, "ZaListView.searchAliasDomainCallback", null, false);
	}

}

ZaListView.prototype._batchSearchforDomain =
function (domainArr, searchQueryList, childQueries, offset, limit) {
	var paramsArr;
    var searchTypes = ZaSearch.ALIASES;
    var searchQuery = "(uid=*";
    if(!childQueries) searchQuery += ")";
    else if(childQueries && !(childQueries instanceof Array)) searchQuery += childQueries + "*)";
    else if(childQueries instanceof Array && childQueries.length == 1) searchQuery += childQueries[0] + "*)";
    else if(childQueries instanceof Array && childQueries.length > 1)  searchQuery += childQueries[1] + ")";

    var controller = ZaApp.getInstance().getSearchListController();

	if(searchQueryList && searchQueryList instanceof Array)
		paramsArr = searchQueryList;
	else paramsArr = new Array();
        var busyId = Dwt.getNextId();
	var inParams = {limit:controller.RESULTSPERPAGE,show:true, openInSearchTab: true,busyId:busyId};
        var callback = new AjxCallback(this, this.searchCallback, inParams);
	for(var i =0; i < domainArr.length; i++) {
	        var searchParams = {
                            offset:offset,
                            limit :limit,
        	                query:searchQuery,
                	        types:searchTypes,
	                        showBusy:true,
        	                busyId:busyId,
	                        busyMsg:ZaMsg.BUSY_SEARCHING,
        	                skipCallbackIfCancelled:false,
	                        sortBy:controller._currentSortField,
        	                attrs:ZaSearch.standardAttributes,
                	        callback:callback,
	                        controller: controller,
        	                domain: domainArr[i]
	        }
		paramsArr.push(searchParams);
	}
	this.multipleSearchCallback(inParams, paramsArr);

}


ZaListView.prototype.multipleSearchCallback =
function(preParams, paramsArr) {
	var sortBy, limit, offset, sortAscending, soapDoc, cnt;
	var paramList = null;
	if(!paramsArr) return;
	if(paramsArr instanceof Array && paramsArr.length > 0)
		paramList = paramsArr;
	else {
		paramList = new Array();
		paramList.push(paramsArr);
	}

	cnt = paramList.length;
	soapDoc = AjxSoapDoc.create("BatchRequest", "urn:zimbra");
	soapDoc.setMethodAttribute("onerror", "continue");

	for(var i = 0; i < cnt; i++) {
		var getSearchDirDoc = soapDoc.set("SearchDirectoryRequest", null, null, ZaZimbraAdmin.URN);
		var squery = soapDoc.set("query", paramList[i].query, getSearchDirDoc);

                sortBy = (paramList[i].sortBy != undefined)? paramList[i].sortBy: ZaAccount.A_name;
                limit = (paramList[i].limit != undefined)? paramList[i].limit: ZaAccount.RESULTSPERPAGE;
                offset = (paramList[i].offset != undefined) ? paramList[i].offset : "0";
                sortAscending = (paramList[i].sortAscending != null)? paramList[i].sortAscending : "1";


                getSearchDirDoc.setAttribute("offset", offset);
                getSearchDirDoc.setAttribute("limit", limit);
                getSearchDirDoc.setAttribute("sortBy", sortBy);
                getSearchDirDoc.setAttribute("sortAscending", sortAscending);

                if(paramList[i].applyCos)
                        getSearchDirDoc.setAttribute("applyCos", paramList[i].applyCos);
                else
                        getSearchDirDoc.setAttribute("applyCos", false);


                if(paramList[i].applyConfig)
                        getSearchDirDoc.setAttribute("applyConfig", paramList[i].applyConfig);
                else
                        getSearchDirDoc.setAttribute("applyConfig", "false");

                if(paramList[i].domain)  {
                        getSearchDirDoc.setAttribute("domain", paramList[i].domain);

                }
                if(paramList[i].attrs && paramList[i].attrs.length>0)
                        getSearchDirDoc.setAttribute("attrs", paramList[i].attrs.toString());

                if(paramList[i].types && paramList[i].types.length>0)
                        getSearchDirDoc.setAttribute("types", paramList[i].types.toString());

                if(paramList[i].maxResults) {
                        getSearchDirDoc.setAttribute("maxResults", paramList[i].maxResults.toString());
                }


	}

	var params = new Object();
	params.soapDoc = soapDoc;
	var reqMgrParams ={
		//controller:this,
		busyMsg:ZaMsg.BUSY_REQUESTING_ACCESS_RIGHTS
	}

	var respObj = ZaRequestMgr.invoke(params, reqMgrParams);
	if(respObj.isException && respObj.isException()) {
		ZaApp.getInstance().getCurrentController()._handleException(respObj.getException(), "ZaListViewController.prototype.multipleSearchCallback", null, false);
	} else if(respObj.Body.BatchResponse.Fault) {
		var fault = respObj.Body.BatchResponse.Fault;
		if(fault instanceof Array)
			fault = fault[0];

		if (fault) {
			var ex = ZmCsfeCommand.faultToEx(fault);
			ZaApp.getInstance().getCurrentController()._handleException(ex,"ZaListViewController.prototype.multipleSearchCallback", null, false);
		}
	} else {
		var batchResp = respObj.Body.BatchResponse;
		if(batchResp.SearchDirectoryResponse && batchResp.SearchDirectoryResponse instanceof Array) {
			var cnt2 = batchResp.SearchDirectoryResponse.length;
			ZaSearch.TOO_MANY_RESULTS_FLAG = false;

            var tempResultList = null;
            var hasmore=false;
            var searchTotal = 0;
			for(var i = 0; i < cnt2; i++) {
				var resp = batchResp.SearchDirectoryResponse[i];
				var subList = new ZaItemList(preParams.CONS);

		        subList.loadFromJS(resp);
				//combine the search results
				if(!tempResultList) tempResultList = subList;
				else {
					if(tempResultList instanceof ZaItemList && subList.size() > 0) {
						var listVec = subList.getVector();
						for(var j = 0; j < listVec.size(); j++) {
							var item = listVec.get(j);
							if(!tempResultList.getVector().contains(item))
								tempResultList.add(item);
						}
					}
				}

				searchTotal +=  (resp.searchTotal ? resp.searchTotal : 0);
                hasmore= resp.more|hasmore;
			}

            if(tempResultList){
                var tmpArr = new Array();
		        var cnt = tempResultList.getArray().length;
		        for(var ix = 0; ix < cnt; ix++) {
                    var flag=false;
                    for (var i = 0; i < this._list.size(); i++) {
		                if (this._list.get(i).id == tempResultList.getArray()[ix].id)
                        {
                            flag=true;
                            break;
                        }
	                }
                    if(!flag)
			        tmpArr.push(tempResultList.getArray()[ix]);
		        }
            }
            this.replenish(AjxVector.fromArray(tmpArr));
            this.setScrollHasMore(hasmore);

            if (this.scrollSearchParams && this.scrollSearchParams.postCallback) {
                this.scrollSearchParams.postCallback.run(searchTotal, hasmore, this.getList());
            }

		}
	}
}



ZaListView.prototype._loadMsg =
function (params) {
		//this.show(null,params);
        var busyId = Dwt.getNextId();
	    var callback = new AjxCallback(this, this.searchCallback, {CONS:null,busyId:busyId});
        var searchParams=this.scrollSearchParams;
        searchParams.offset=params.offset;
        searchParams.limit=params.limit;
        searchParams.callback=callback;
        searchParams.busyId=busyId;

    if(searchParams&&searchParams.scrollType=="isAliasSearch"){
        var searchQueryList = new Array();
        searchQueryList.push(searchParams);
		var keyword = ZaListView._getSearchKeyWord(searchParams.query);
		this.searchAliasDomain(keyword,searchParams.controller,searchQueryList,params.offset,params.limit);
    }
    else{

	    ZaSearch.searchDirectory(searchParams);
    }
}

ZaListView.prototype.searchCallback =
function(params, resp) {
	try {
		if(params.busyId)
			ZaApp.getInstance().getAppCtxt().getShell().setBusy(false, params.busyId);

		if(!resp && !this._currentRequest.cancelled) {
			throw(new AjxException(ZaMsg.ERROR_EMPTY_RESPONSE_ARG, AjxException.UNKNOWN, "ZaListView.prototype.searchCallback"));
		}
		if(resp && resp.isException() && !this._currentRequest.cancelled) {
			ZaSearch.handleTooManyResultsException(resp.getException(), "ZaListView.prototype.searchCallback");
		} else {
			ZaSearch.TOO_MANY_RESULTS_FLAG = false;

            var tempList = new ZaItemList(params.CONS);
            var tempResultList = new ZaItemList(params.CONS);
			var hasmore=false;

			if(resp && !resp.isException()) {
				var response = resp.getResponse().Body.SearchDirectoryResponse;

                tempList.loadFromJS(response);
                // filter the search result
                if(params.resultFilter && tempList.size() > 0) {
                    var listVec = tempList.getVector();
                    for(var i = 0; i < listVec.size(); i++) {
                        var item = listVec.get(i);
                        var target = null;
                        if(item.type == ZaItem.ALIAS)
                            target = item.getAliasTargetObj();
                        else target = item;
                        for (var f in params.resultFilter) {
                            if(target.attrs[f].indexOf(params.resultFilter[f]) >= 0) {
                                tempResultList.add(item);
                                break;
                            }
                        }

                    }
                } else {
                    tempResultList = tempList;
                }
                 hasmore= response.more;

			}
             if(tempResultList){
                var tmpArr = new Array();
		        var cnt = tempResultList.getArray().length;
		        for(var ix = 0; ix < cnt; ix++) {
			        tmpArr.push(tempResultList.getArray()[ix]);
		        }
                this.replenish(AjxVector.fromArray(tmpArr));
                this.setScrollHasMore(hasmore);
                if (this.scrollSearchParams && this.scrollSearchParams.postCallback) {
                    this.scrollSearchParams.postCallback.run(response.searchTotal, response.more, this.getList());
                }
             }

		}
	} catch (ex) {
		if (ex.code != ZmCsfeException.MAIL_QUERY_PARSE_ERROR) {
			this._handleException(ex, "ZaListView.prototype.searchCallback");
		} else {
			this.popupErrorDialog(ZaMsg.queryParseError, ex);
			if(this._searchField)
				this._searchField.setEnabled(true);
		}
	}
}

ZaListView.handleScroll =
function(ev) {

	var target = DwtUiEvent.getTarget(ev);
	var lv = DwtControl.findControl(target);
	if (lv) {
		lv._checkItemCount();
	}

};


ZaListView.prototype._checkItemCount =
function() {
	var itemsNeeded =  this._getItemsNeeded();
	if (itemsNeeded) {
        this.setScrollHasMore(false);
        var params = {
                    offset:this._list.size(),
                    limit:itemsNeeded
				  };;
        this. _loadMsg(params);
	}
};


ZaListView.prototype._getItemsNeeded =
function(skipMoreCheck) {

	if (!skipMoreCheck) {
		if (!this.scrollHasMore || !this._list) { return 0; }
	}

    this._setRowHeight();
    //if (!this._rendered || !this._rowHeight) { return 0; }
     if ( !this._rowHeight) { return 0; }
	DBG.println(AjxDebug.DBG2, "List view: checking item count");

	var sbCallback = new AjxCallback(null, AjxTimedAction.scheduleAction, [new AjxTimedAction(this, this._resetColWidth), 10]);
	var params = {scrollDiv:	this._getScrollDiv(),
				  rowHeight:	this._rowHeight,
				  threshold:	this.getPagelessThreshold(),
				  limit:		this.getLimit(1),
				  listSize:		this._list.size(),
				  sbCallback:	sbCallback};
	return ZaListView.getRowsNeeded(params);
};


ZaListView.getRowsNeeded =
function(params) {
     var div = params.scrollDiv;
	var sh = div.scrollHeight, st = div.scrollTop, rh = params.rowHeight;

	// view (porthole) height - everything measured relative to its top
	// prefer clientHeight since (like scrollHeight) it doesn't include borders
	var h = div.clientHeight || Dwt.getSize(div).y;

	// where we'd like bottom of list view to be (with extra hidden items at bottom)
	var target = h + (params.threshold * rh);

	// where bottom of list view is (including hidden items)
	var bottom = sh - st;

	if (bottom == h) {
		// handle cases where there's no scrollbar, but we have more items (eg tall browser, or replenishment)
		bottom = (params.listSize * rh) - st;
		if (st == 0 && params.sbCallback) {
			// give list view a chance to fix width since it may be getting a scrollbar
			params.sbCallback.run();
		}
	}

	var rowsNeeded = 0;
	if (bottom < target) {
		// buffer below visible bottom of list view is not full
		rowsNeeded = Math.max(Math.floor((target - bottom) / rh), params.limit);
	}
	return rowsNeeded;
};

ZaListView.prototype.getLimit =
function(offset) {
	var limit = ZaSettings.RESULTSPERPAGE;
	return offset ? limit : 2 * limit;

};

ZaListView.prototype.getPagelessThreshold =
function() {
	return Math.ceil(this.getLimit() / 5);
};


ZaListView.prototype.setHeaderList = function(headerList) {
	this._headerList = headerList;
	this.headerColCreated = false;
}

ZaListHeaderItem = function(idPrefix, text, iconInfo, width, sortable, sortField, resizeable, visible) {
	DwtListHeaderItem.call(this, {field:idPrefix, text:text, icon:iconInfo, width:width, sortable:sortable,
								  resizeable:resizeable, visible:visible});
	this._sortField = sortField;	
	this._initialized = false;
}

ZaListHeaderItem.prototype = new DwtListHeaderItem;
ZaListHeaderItem.prototype.constructor = ZaListHeaderItem;


ZaListHeaderItem.prototype.getSortField = 
function() {
	return this._sortField;
}

ZaListHeaderItem.prototype.getLabel = 
function () {
	return this._label;
}


//ZaListView's subclasses can use it to override orginally DwtListView.prototype._handleColHeaderResize(),
//due to in the latter, the header sash will not work well in some cases
ZaListView._handleColHeaderResize =
function(ev) {
	if (!this._headerSash) {
		this._headerSash = document.createElement("div");

		var headerHeight = Dwt.getSize(this._listColDiv).y;
		var thislistViewHeight = this.getSize().y;
		var sashHeight = thislistViewHeight - 4; //make its height shorten a little

		Dwt.setSize(this._headerSash, Dwt.DEFAULT, sashHeight);
		Dwt.setPosition(this._headerSash, Dwt.ABSOLUTE_STYLE);
		Dwt.setZIndex(this._headerSash, Dwt.Z_DND);

		//as this._listDiv's sub node, headerSash will use 'absolute position',
		//setting this._listDiv's position style to relative
		//will make headerSash's position based on it.
		Dwt.setPosition(this._listDiv, Dwt.RELATIVE_STYLE);
		Dwt.setLocation(this._listDiv, 0, 0);
		this._headerSash.className = "DwtListView-ColumnSash";
		this._listDiv.appendChild(this._headerSash);

		//always set the y-position to -headerHeight(based on _listDiv) to align to the header(_listColDiv) not _listColDiv
		var sashY = -headerHeight;
		Dwt.setLocation(this._headerSash, Dwt.DEFAULT, sashY);

		//always remember initial mouse x-position
		this._headerSashX = ev.docX;
	}

	//always update the sash's x-position
	var thislistViewX = Dwt.getLocation(this._listDiv).x;
	var sashX = ev.docX - thislistViewX;

	Dwt.setLocation(this._headerSash, sashX);
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaToolBar")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaToolBar
* @contructor
* generic class that serves the purpose of creating any toolbar in the admin UI
* @param parent parent object
* @param opList array of ZaOperation objects
**/
ZaToolBar = function(parent, opList,btnOrder,posStyle,className, contextId) { 
	if (arguments.length == 0) return;
	className = className || "ZaToolBar";
	posStyle = posStyle || DwtControl.ABSOLUTE_STYLE;

	this._barViewId = contextId;
	DwtToolBar.call(this, {parent:parent, className:className, posStyle:posStyle, id: ZaId.getToolbarId(this._barViewId)});
	this._opList = opList ;
    	this._btnOrder = btnOrder ;
    	this._buttons = new Object(); //all the buttons on the toolbar
    	this.addMoreActions() ;
	this._btnList = new Array();
    	this.init () ;
}

ZaToolBar.VIEW_DATA = "ZaToolBar.VIEW";

ZaToolBar.prototype = new DwtToolBar;
ZaToolBar.prototype.constructor = ZaToolBar;

ZaToolBar.prototype.toString = 
function() {
	return "ZaToolBar";
}

ZaToolBar.prototype.init = function () {
    var opList = this._opList ;
    var btnOrder = this._btnOrder ;
    if(!AjxUtil.isEmpty(btnOrder) && opList) {
		var cnt = btnOrder.length;
		for(var ix = 0; ix < cnt; ix++) {
			if(opList[btnOrder[ix]] && opList[btnOrder[ix]] instanceof ZaOperation) {
				if(opList[btnOrder[ix]].id == ZaOperation.SEP) {
					this._createSeparator();
                } else if (opList[btnOrder[ix]].id == ZaOperation.LEFT_BRACKET) {
                    this._createLeftBracket();
                } else if (opList[btnOrder[ix]].id == ZaOperation.RIGHT_BRACKET) {
                    this._createRightBracket();
				} else if (opList[btnOrder[ix]].id == ZaOperation.NONE) {
					this.addFiller();
				} else if (opList[btnOrder[ix]].id == ZaOperation.LABEL) {
					this._createLabel(opList[btnOrder[ix]].labelId, opList[btnOrder[ix]].imageId, opList[btnOrder[ix]].caption, opList[btnOrder[ix]].disImageId, opList[btnOrder[ix]].tt, true, opList[btnOrder[ix]].className);
				} else {
					this._createButton(opList[btnOrder[ix]].id, opList[btnOrder[ix]].imageId, opList[btnOrder[ix]].caption, opList[btnOrder[ix]].disImageId, opList[btnOrder[ix]].tt, true, opList[btnOrder[ix]].className, opList[btnOrder[ix]].type, opList[btnOrder[ix]].menuOpList);
					
					if(opList[btnOrder[ix]].listener) {
						this.addSelectionListener(opList[btnOrder[ix]].id, opList[btnOrder[ix]].listener);
					}
				}
			}
		}
	} else if(opList) {
		for(var ix in opList) {
			if(opList[ix] instanceof ZaOperation) {
				if(opList[ix].id == ZaOperation.SEP) {
					this._createSeparator();
                } else if (opList[ix].id == ZaOperation.LEFT_BRACKET) {
                    this._createLeftBracket();
                } else if (opList[ix].id == ZaOperation.RIGHT_BRACKET) {
                    this._createRightBracket();
				} else if (opList[ix].id == ZaOperation.NONE) {
					this.addFiller();
				} else if (opList[ix].id == ZaOperation.LABEL) {
					this._createLabel(opList[ix].labelId, opList[ix].imageId, opList[ix].caption, opList[ix].disImageId, opList[ix].tt, true, opList[ix].className);
				} else {
					this._createButton(opList[ix].id, opList[ix].imageId, opList[ix].caption, opList[ix].disImageId, opList[ix].tt, true, opList[ix].className, opList[ix].type, opList[ix].menuOpList);

					this.addSelectionListener(opList[ix].id, opList[ix].listener);
				}
			}
		}
	}
}

ZaToolBar.prototype.addSelectionListener =
function(buttonId, listener) {
	this._buttons[buttonId].addSelectionListener(listener);
}

ZaToolBar.prototype.removeSelectionListener =
function(buttonId, listener) {
	this._buttons[buttonId].removeSelectionListener(listener);
}

ZaToolBar.prototype.getButton =
function(buttonId) {
	return this._buttons[buttonId];
}

ZaToolBar.prototype.setData = 
function(buttonId, key, data) {
	this._buttons[buttonId].setData(key, data);
}

/**
* Enables/disables buttons.
*
* @param ids		a list of button IDs
* @param enabled	whether to enable the buttons
*/
ZaToolBar.prototype.enable =
function(ids, enabled) {
	if (!(ids instanceof Array))
		ids = [ids];
	for (var i = 0; i < ids.length; i++)
		if (this._buttons[ids[i]])
			this._buttons[ids[i]].setEnabled(enabled);
}

ZaToolBar.prototype.enableAll =
function(enabled) {
	for (var i in this._buttons) {
		this._buttons[i].setEnabled(enabled);
	}
}

ZaToolBar.prototype.computeHeight =
function(enabled) {
	var h = 0;
	for (var i in this._buttons) {
		h = Math.max(h, this._buttons[i].getSize().y);
	}
	return h;
}

ZaToolBar.prototype.setSize =
function(width, height) {
	var sz = this.getSize();
	if (width != sz.x || height != sz.y) {
		DwtToolBar.prototype.setSize.apply(this, arguments);
		this._checkSize(width,height);
	}
};

ZaToolBar.prototype._checkSize = function(width, height, hideText, showMoreActions) {
    var hideText = hideText || false ; //default false
    var showMoreActions = showMoreActions || true ; // default true ;
    var moreActionsButton = this._buttons [ZaOperation.MORE_ACTIONS] ;
	var el = this.getHtmlElement();
	if(!el) {
		return;
	}
	
	for (var i in this._buttons) {
		var b = this._buttons[i];
		if (!b) { continue; }		
		//reset text
        if(b._toggleText) {
			b.setText(b._toggleText);
			b._toggleText = null;
		}
        //reset visibility
        if (b == moreActionsButton) {
            b.setVisible(false) ;
        }else{
            b.setVisible (true) ;
        }
	}
    
	var offset = el.firstChild.offsetWidth;
	if(offset > width) {
	        var totalVisibleButtonWidth = this.getAlwaysVisibleButtonWidths () ;
		if (showMoreActions) {
        	    moreActionsButton.setVisible(true) ;
	            totalVisibleButtonWidth += moreActionsButton.getW () ; //more actions button size
        	}

		var btnList = null;
		if(!AjxUtil.isEmpty(this._btnOrder))
			btnList = this._btnOrder;
		else btnList = this._btnList;

		var cnt = btnList.length;
		for(var ix = 0; ix < cnt; ix++) {
                        var b = this._buttons[btnList[ix]];
                        if (!b || !b.getVisible()) { continue; }
                        var text = b.getText();
                        if(text && hideText) {
                                b._toggleText = text;
                                b.setText("");
                        }

                        if (showMoreActions) {
                                var w = b.getW() ;
                                totalVisibleButtonWidth += w ;

                                if (totalVisibleButtonWidth >= width) { //width overflow
                                        if (b != moreActionsButton) {
                                                b.setVisible(false) ; // hide the overflow button
                                        } else {  //more actions button is visible now, we can break
                                                break ;
                                        }
                                }
                        }

                        offset = el.firstChild.offsetWidth;
                        if(offset <= width) {
                                break;
                        }

		}
	}

    //set visiblity and enable the more actions popup menu items
    this.enableMoreActionsMenuItems()  ;
}

ZaToolBar.prototype._createButton =
function(buttonId, imageId, text, disImageId, toolTip, enabled, className, type, menuOpList) {
	if (!className)
		className = "DwtToolbarButton"
	var b = this._buttons[buttonId] = new ZaToolBarButton({
			parent:this, 
			className:className, 
			id:ZaId.getButtonId(this._barViewId,ZaOperation.getStringName(buttonId))
	});
	if (imageId)
		b.setImage(imageId);
	if (text)
		b.setText(text);
	if (toolTip)
		b.setToolTipContent(toolTip);
	b.setEnabled((enabled) ? true : false);
	b.setData("_buttonId", buttonId);

	if (type == ZaOperation.TYPE_MENU) {
		var menu = new ZaPopupMenu(b, null,null, menuOpList, this._barViewId, ZaId.MENU_DROP);
		b.setMenu(menu,true);
	}
	this._btnList.push(buttonId);
	return b;
}


ZaToolBar.prototype._createLabel =
function(buttonId, imageId, text, disImageId, toolTip, enabled, className, style) {

	var b = this._buttons[buttonId] = new ZaToolBarLabel(this, null, className);
	if (imageId)
		b.setImage(imageId);
	if (text)
		b.setText(text);
	if (toolTip)
		b.setToolTipContent(toolTip);
	b.setEnabled((enabled) ? true : false);
	b.setData("_buttonId", buttonId);

	return b;
}
ZaToolBar.prototype._createSeparator =
function() {
	var ctrl = new DwtControl(this);
	var html = ZaToolBar.getSeparatorHtml ();
	ctrl.setContent(html);
}

ZaToolBar.getSeparatorHtml =
function () {
	//return "<table><tr><td class=\"ImgAppToolbarSectionSep\" height=20px width=3px> </td></tr></table>";
	return "<div class=\"vertSep\"/>";
}

ZaToolBar.prototype._createLeftBracket =
function() {
	var ctrl = new DwtControl(this);
	var html = ZaToolBar.getLeftBracketHtml ();
	ctrl.setContent(html);
}

ZaToolBar.getLeftBracketHtml =
function () {
	return "<div class=\"ZaLeftBracket\"/>";
}


ZaToolBar.prototype._createRightBracket =
function() {
	var ctrl = new DwtControl(this);
	var html = ZaToolBar.getRightBracketHtml ();
	ctrl.setContent(html);
}

ZaToolBar.getRightBracketHtml =
function () {
	return "<div class=\"ZaRightBracket\"/>";
}

ZaToolBar.prototype._buttonId =
function(button) {
	return button.getData("_buttonId");
}

/**
 * Insert the "More Operations" button in the toolbar due to the limited size of the toolbar
 * @param index: the position the "More Operations" button should be
 */
ZaToolBar.prototype.addMoreActions =
function () {
    if (AjxUtil.isEmpty (this._btnOrder) || AjxUtil.isEmpty (this._opList)) {
        return ; //no need to add the more actions since there is no action.
    }
    this._moreActionsMenuList = [] ; //the menu list for the More Actions button.
    var index = -1 ;    
    //insert the moreActions button before the ZaOperation.NONE
    for (var i =0; i < this._btnOrder.length; i ++)  {
        if (this._btnOrder [i] == ZaOperation.NONE ) {
            index = i ;
            break ;
        } else if (this._btnOrder[i] == ZaOperation.SEP ||
                   this._btnOrder[i] == ZaOperation.LEFT_BRACKET  ||
                   this._btnOrder[i] == ZaOperation.RIGHT_BRACKET) {//There is no need to show SEP in popup menu
		    continue;
	    } else { //duplicate the operation.
            var op =  this._opList [this._btnOrder [i]] ;
            if (op != null ) {
                this._moreActionsMenuList.push (ZaOperation.duplicate(op)) ;
            }
        }
    }
    this._opList[ZaOperation.MORE_ACTIONS] =
        new ZaOperation(ZaOperation.MORE_ACTIONS, ZaMsg.TBB_MoreActions, ZaMsg.TBB_MoreActions_tt,
                "", "",
                //null, //Need to have popup listener
                new AjxListener(this, this._moreActionsButtonListener),
                ZaOperation.TYPE_MENU,this._moreActionsMenuList );
    this._opList[ZaOperation.MORE_ACTIONS].enabled = false ;
    this._opList[ZaOperation.MORE_ACTIONS].visible = false ;

    if (index == -1) { //there is no ZaOperation.NONE, append at the end of the array
        index =  this._btnOrder.length ;
    }

    this._btnOrder.splice (index, 0, ZaOperation.MORE_ACTIONS) ;
}

/*
 The buttons after ZaOperation.NONE are always visible
 */
ZaToolBar.prototype.getAlwaysVisibleButtonWidths = function () {
    var w = 0 ;
    var isAfterNoneOp = false ;
    for (var i =0; i < this._btnOrder.length; i ++)  {
        var b = this._buttons [this._btnOrder [i]] ;
        if (this._btnOrder [i] == ZaOperation.NONE ) {
            isAfterNoneOp = true ;
        }
        
        /*
         Handle for LABEL, label uses labelid to index, but button uses id.
         */ 
        if (this._btnOrder [i] == ZaOperation.LABEL) { 
            b = this._buttons[ZaOperation.SEARCH_RESULT_COUNT]; 
        }
  
        if (isAfterNoneOp) {
            if (this._btnOrder [i] == ZaOperation.SEP){
               w += 5; // for seperator, we give it a fixed value.
            }

            if (this._btnOrder [i] == ZaOperation.LEFT_BRACKET){
               w += 7; // for seperator, we give it a fixed value.
            }

            if (this._btnOrder [i] == ZaOperation.RIGHT_BRACKET){
               w += 7; // for seperator, we give it a fixed value.
            }

            if (b && b.getVisible()) {
                w += b.getW () ;
            }
        }
     }

    return w ;
}
                    
ZaToolBar.prototype.enableMoreActionsMenuItems = function () {
    var moreActionsButton = this._buttons [ZaOperation.MORE_ACTIONS] ;
    var moreActionMenu ;
    if (moreActionsButton) {
        moreActionMenu = moreActionsButton.getMenu () ;
        moreActionMenu.popdown () ;
    }
    
    if (moreActionsButton && moreActionsButton.getVisible()) {
        for (var i =0; i < this._btnOrder.length; i ++)  {
            var opId = this._btnOrder [i] ;
            if (this._btnOrder [i] == ZaOperation.MORE_ACTIONS) {
                break ;
            }

            var toolbarButton = this._buttons[opId] ;
            if (!toolbarButton) { continue ;} ;
            var visiblity = toolbarButton.getVisible() ;
            var menuItem = moreActionMenu.getMenuItem (opId) ; //menu item operation id is the same as the toolbar button id
            if (menuItem !=null && menuItem != undefined) {
		menuItem.setVisible(!visiblity) ;
            	menuItem.setEnabled (toolbarButton.getEnabled()) ;
        	}
	}
    }
}

ZaToolBar.prototype._moreActionsButtonListener = function (ev) {
    var moreActionsButton = this._buttons [ZaOperation.MORE_ACTIONS] ;
    var moreActionMenu ;
    if (moreActionsButton) {
        moreActionMenu = moreActionsButton.getMenu () ;
        if (moreActionMenu.isPoppedUp()) {
            moreActionMenu.popdown () ;
        } else {
            moreActionsButton.popup() ;
        }
    }
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaToolBarLabel")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2007, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2007, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Used to create an application tab and its operations, such as new a  tab, 
 * close a tab, edit the tab label.
 * 
 * It will also remember the state of the tab: hidden/shown and dirty/clean.
 * @param parent - the tab group containing all the tabs.
 * 
 * @param params :
 *  	closable - whether the close icon and action should be added
 * 		selected - whether the newly created tab should be selected 
 *		id - the tabId used to identify an unique tab.
 * 		toolTip - the tooltip of the tab
*/

ZaToolBarLabel = function(parent, style, className, posStyle, id, index) {
	if (arguments.length == 0) return ;
	DwtLabel.call(this,parent, style, className, posStyle, id, index);
}

ZaToolBarLabel.prototype = new DwtLabel;
ZaToolBarLabel.prototype.constructor = ZaToolBarLabel;


ZaToolBarLabel.prototype._createHtmlFromTemplate = function(templateId, data) {
    DwtLabel.prototype._createHtmlFromTemplate.call(this, "admin.Widgets#ZaToolBarLabel", data);
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaToolBarButton")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2007, 2010, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2007, 2010, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Used to create an application tab and its operations, such as new a  tab, 
 * close a tab, edit the tab label.
 * 
 * It will also remember the state of the tab: hidden/shown and dirty/clean.
 * @param parent - the tab group containing all the tabs.
 * 
 * @param params :
 *  	closable - whether the close icon and action should be added
 * 		selected - whether the newly created tab should be selected 
 *		id - the tabId used to identify an unique tab.
 * 		toolTip - the tooltip of the tab
*/



ZaToolBarButton = function(params) {
        if (arguments.length == 0) return ;
        params = Dwt.getParams(arguments, ZaToolBarButton.PARAMS);
        params.className = params.className || "ZaToolBarButton";
        DwtButton.call(this, params);
}

ZaToolBarButton.PARAMS = ["parent", "style", "className", "posStyle", "actionTiming", "id", "index"];

ZaToolBarButton.prototype = new DwtButton;
ZaToolBarButton.prototype.constructor = DwtButton;


ZaToolBarButton.prototype._createHtml = function() {
    var templateId = "dwt.Widgets#ZToolbarButton";
    var data = { id: this._htmlElId };
    this._createHtmlFromTemplate(templateId, data);
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaOverviewPanel")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */


ZaOverviewPanel = function(params) {
        if (arguments.length == 0) { return; }
	this.overviewId = params.id;
	params.id = ZaId.getOverviewId(ZaId.PANEL_APP);	
        params = Dwt.getParams(arguments, ZaOverviewPanel.PARAMS);
        params.className = params.className || "ZaOverviewPanel";
        DwtComposite.call(this, params);

	this.addControlListener(new AjxListener(this, this._panelControlListener));
	this._createFolderTree();
	this._layout();
}

ZaOverviewPanel.PARAMS = ["parent", "className", "posStyle", "id"];

ZaOverviewPanel.prototype = new DwtComposite();
ZaOverviewPanel.constructor = ZaOverviewPanel;

ZaOverviewPanel._MIN_FOLDERTREE_SIZE = 100;

ZaOverviewPanel.prototype.toString = 
function() {
	return "ZaOverviewPanel";
}

ZaOverviewPanel.prototype.getFolderTree =
function() {
	return this._tree;
}

ZaOverviewPanel.prototype._createFolderTree =
function() {
    this._treePanel = new DwtComposite({
		parent:		this, 
		className:	"OverviewTreePanel", 
		posStyle:	DwtControl.RELATIVE_STYLE,
		id:		ZaId.getTreeId(this.overviewId, this.type)
	});

    this._treePanel.setScrollStyle(Dwt.SCROLL_Y);


    this._tree = new ZaTree({
	parent:		this._treePanel,
	style:		DwtTree.SINGLE_STYLE,
	className:	"OverviewTree" ,
	posStyle:	DwtControl.ABSOLUTE_STYLE,
	id:		ZaId.getTreeId(this.overviewId, DwtTree.SINGLE_STYLE)
    });


}
	
ZaOverviewPanel.prototype._layout =
function() {
	var opSz = this.getSize();
//	opSz.x+=100;
	var h = opSz.y;
//	h = (h > ZaOverviewPanel._MIN_FOLDERTREE_SIZE) ? h : ZaOverviewPanel._MIN_FOLDERTREE_SIZE;
	var w = opSz.x;
	this._treePanel.setBounds(0, 0, w, h);
//	var tfBds = this._treePanel.getBounds();
}

ZaOverviewPanel.prototype._panelControlListener =
function(ev) {
	this._layout();
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaClientCmdHandler")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
* @param app {ZaApp}
**/
ZaClientCmdHandler = function() {
	this._settings = new Object();
}

ZaClientCmdHandler.prototype.execute =
function(argv) {
	if (argv[0] && argv[0].toLowerCase() == "debug") {
		if (!argv[1]) return;
		if (argv[1] == "t") {
			var on = DBG._showTiming;
			var newState = on ? "off" : "on";
			alert("Turning debug timing info " + newState);
			DBG.showTiming(!on);
		} else {
			//var arg = Number(argv[1]);
			var level =argv[1];
			if (level) {
				alert("Setting Debug to level:" + level);
				DBG.setDebugLevel(level);
			} else {
				alert("Invalid debug level");
			}
		}
	} else if (argv[0] && argv[0].toLowerCase() == "domainsrch") {
		ZaDomain.MAXSEARCHRESULTS = argv[1];
		alert("Setting domain search limit to:" + argv[1]);
        ZaApp.getInstance().searchDomains();
    } else if (argv[0] && argv[0].toLowerCase() == "pagesize") {
		ZaSettings.RESULTSPERPAGE = argv[1];
		alert("Setting page size to:" + argv[1]);
    }
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaApp")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaApp
* @constructor ZaApp
* @param appCtxt instance of ZaAppCtxt
* @param container
* @author Greg Solovyev
**/
ZaApp = function(appCtxt, container) {
	if (arguments.length == 0) return;
	this._name = ZaZimbraAdmin.ADMIN_APP;
	this._appCtxt = appCtxt;
	this._appViewMgr = appCtxt.getAppViewMgr();
	this._container = container;
	this._currentController = null;
	this._currentViewId = null;
	this._cosListChoices = null;//new XFormChoices([], XFormChoices.OBJECT_LIST, "id", "name");	
	this._domainListChoices = null;//new XFormChoices([], XFormChoices.OBJECT_LIST, "name", "name");	
	this._serverChoices = null; 
	this._serverIdChoices = null;
	this._serverMap = null;
	this._controllers = new Object();
	this.dialogs = {};
	this._tabGroup = null ;

}
ZaApp.instance = null;
ZaApp.getInstance = function (appCtxt, container) {
	if(!ZaApp.instance) {
	//	console.log("Trying to get ZaApp before it is instantiated") ;
		if(!AjxUtil.isEmpty(appCtxt) && !AjxUtil.isEmpty(container)) {
		//	console.log("Instantiating ZaApp ....") ; 
			ZaApp.instance = new ZaApp(appCtxt, container);
		}
	}
	return ZaApp.instance;
}
ZaApp.prototype.constructor = ZaApp;

ZaApp.prototype.toString = 
function() {
	return "ZaApp";
}

ZaApp.checkMyRight = function(targetType,targetBy,targetVal,right,attrs) {
	var soapDoc = AjxSoapDoc.create("CheckRightRequest", ZaZimbraAdmin.URN, null);
	var elGrantee = soapDoc.set("grantee", ZaZimbraAdmin.currentUserId);
	elGrantee.setAttribute("by","id");
	var elTarget = soapDoc.set("target", targetVal);
	elTarget.setAttribute("type", targetType);
	elTarget.setAttribute("by", targetBy);
	var elRight = soapDoc.set("right", right);
	var cnt = attrs.length;
	if(cnt>0) {
		var elAttrs = soapDoc.set("attrs","")
		for(var i=0;i<cnt;i++) {
			var elA = soapDoc.set("a",attrs[i].val,elAttrs);
			elA.setAttribute("n", attrs[i].n);
		}	
	}

	var csfeParams = new Object();
	csfeParams.soapDoc = soapDoc;	
	var reqMgrParams = {} ;
	reqMgrParams.controller = ZaApp.getInstance().getCurrentController();
	reqMgrParams.busyMsg = ZaMsg.BUSY_REQUESTING_ACCESS_RIGHTS ;
	try {
		var resp = ZaRequestMgr.invoke(csfeParams, reqMgrParams ).Body.CheckRightResponse;
		return resp;
	} catch (ex) {
		//not implemented yet
	}
	
}

ZaApp.prototype.initDialogs = function () {
	this.dialogs["errorDialog"] = this._appCtxt.getErrorDialog(true);
	this.dialogs["msgDialog"] = this._appCtxt.getMsgDialog(true);
	this.dialogs["confirmMessageDialog"] = this._appCtxt.getConfirmMsgDialog(true);
	this.dialogs["confirmMessageDialog2"] = this._appCtxt.getConfirmMsgDialog2(true);
}

ZaApp.prototype.getDomainAliasWizard = function (isEdit) {
    var dialog ;
    if (isEdit) {
        dialog = this.dialogs["editDomainAliasWizard"]
            = new ZaDomainAliasEditWizard(this._container, "400px", "80px", ZaMsg.Title_Edit_domain_alias);
    }else{
        dialog = this.dialogs["newDomainAliasWizard"]
            = new ZaDomainAliasWizard(this._container, "400px", "80px", ZaMsg.Title_Create_domain_alias);
    }
    return dialog;
}

ZaApp.prototype.launch =
function(appCtxt) {
	if(ZaSettings.DASHBOARD_VIEW && ZaApp.prototype.getDashBoardController) {
		var dashBoardController = ZaApp.getInstance().getDashBoardController(ZaSettings.DASHBOARD_VIEW);
		if(ZaApp.getInstance().getCurrentController()) {
			ZaApp.getInstance().getCurrentController().switchToNextView(dashBoardController, ZaDashBoardController.prototype.show,true);
		} else {					
			dashBoardController.show(true);
		}
	} else  {
        var ctl = this._appCtxt.getAppController().getOverviewPanelController();
        var homePath = ZaTree.getPathByArray([ZaMsg.OVP_home]);
		ctl.getOverviewPanel().getFolderTree().setSelectionByPath(homePath);
        var historyObject = new ZaHistory(homePath, ZaMsg.OVP_home);
        ZaZimbraAdmin.getInstance().updateHistory(historyObject, true);
    }
	// For delegated admin accounts pre fetch all the domains.
	if (ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsDelegatedAdminAccount] === "TRUE") {
		this.getDomainList(false, {limit : 25, asyncMode : true});
	}
};

ZaApp.prototype.getAppCtxt = 
function() {
	return this._appCtxt;
}

ZaApp.prototype.getCurrentController = 
function() {
    var currentViewId = this._appViewMgr.getCurrentView();
	return this._controllers[currentViewId];
}

ZaApp.prototype.getControllerById =
function (id) {
	return this._controllers[id] ;
}

/**
* View controllers
**/
ZaApp.prototype.getStatusViewController =
function(viewId) {
	if(!viewId)
		viewId = ZaZimbraAdmin._STATUS;
			
	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c  = this._controllers[viewId] = new ZaStatusViewController(this._appCtxt, this._container, this);
		return c ;
	}
}

ZaApp.prototype.getServerStatsController =
function(viewId) {

	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c  = this._controllers[viewId] = new ZaServerStatsController(this._appCtxt, this._container, this);
		return c ;
	}
}

ZaApp.prototype.getGlobalStatsController =
function(viewId) {
	if(!viewId)
		viewId = ZaZimbraAdmin._STATISTICS;
		
	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c = this._controllers[viewId] = new ZaGlobalStatsController(this._appCtxt, this._container, this);
		return c ;
	}
}

ZaApp.prototype.getServerStatsListController =
function(viewId) {
	if(!viewId)
		viewId = ZaZimbraAdmin._SERVER_LIST_FOR_STATISTICS_VIEW;

	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c = this._controllers[viewId] = new ZaServerStatsListController(this._appCtxt, this._container, this);
		return c ;
	}
}

ZaApp.prototype.getGlobalConfigViewController =
function(viewId) {
	if(!viewId)
		viewId = ZaZimbraAdmin._GLOBAL_SETTINGS;
	
	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c  = this._controllers[viewId] = new ZaGlobalConfigViewController(this._appCtxt, this._container, this);
		//c.addSettingsChangeListener(new AjxListener(this, ZaApp.prototype.handleSettingsChange));
		return c ;
	}
}

ZaApp.prototype.getSearchListController =
function() {
	if (this._controllers[ZaZimbraAdmin._SEARCH_LIST_VIEW] == null) {
		this._controllers[ZaZimbraAdmin._SEARCH_LIST_VIEW] = new ZaSearchListController(this._appCtxt, this._container);
		this._controllers[ZaZimbraAdmin._SEARCH_LIST_VIEW].addRemovalListener(new AjxListener(this.getSearchListController(), this.getSearchListController().handleRemoval));
	}
	return this._controllers[ZaZimbraAdmin._SEARCH_LIST_VIEW] ;
}

ZaApp.prototype.getSearchBuilderController =
function() {
	if (this._controllers[ZaZimbraAdmin._SEARCH_BUILDER_VIEW] == null) {
		this._controllers[ZaZimbraAdmin._SEARCH_BUILDER_VIEW] = new ZaSearchBuilderController(this._appCtxt, this._container);
		this._controllers[ZaZimbraAdmin._SEARCH_BUILDER_VIEW].addRemovalListener(new AjxListener(this.getSearchBuilderController(), this.getSearchBuilderController().handleRemoval));							
	}
	return this._controllers[ZaZimbraAdmin._SEARCH_BUILDER_VIEW] ;
}

ZaApp.prototype.getSearchBuilderToolbarController = ZaApp.prototype.getSearchBuilderController ;


ZaApp.prototype.getAccountListController =
function(viewId, newController) {
	if(!viewId)
		viewId = ZaZimbraAdmin._ACCOUNTS_LIST_VIEW;
			
	//this is used by SearchListController to associate its view with a new 
	//account list controller
	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else if (viewId || newController) {
		var c = this._controllers[viewId] = new ZaAccountListController(this._appCtxt, this._container, this);
		c.addRemovalListener(new AjxListener(c, c.handleRemoval));							
		c.addCreationListener(new AjxListener(c, c.handleCreation));									
		return c ;
	}

}

ZaApp.prototype.getAccountViewController =
function(isAlias) {
	var c = new ZaAccountViewController(this._appCtxt, this._container, this);
	var viewId = ZaZimbraAdmin._ACCOUNTS_LIST_VIEW ;
	if (isAlias) {
		viewId = ZaZimbraAdmin._ALIASES_LIST_VIEW ;
	}
	c.addChangeListener(new AjxListener(this.getAccountListController(viewId), ZaAccountListController.prototype.handleChange));
	c.addCreationListener(new AjxListener(this.getAccountListController(viewId), ZaAccountListController.prototype.handleCreation));	
	c.addRemovalListener(new AjxListener(this.getAccountListController(viewId), ZaAccountListController.prototype.handleRemoval));			
	return c ;
}

ZaApp.prototype.getAdminExtListController = 
function() {
	if (this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW] == null) {
		this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW] = new ZaAdminExtListController(this._appCtxt, this._container, this);
		this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW].addRemovalListener(new AjxListener(this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW], this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW].handleRemoval));							
		this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW].addCreationListener(new AjxListener(this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW], this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW].handleCreation));			
		this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW].addChangeListener(new AjxListener(this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW], this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW].handleChange));
	}
	
	return this._controllers[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW] ;
}

ZaApp.prototype.getZimletListController =
function() {
	if (this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW] == null) {
		this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW] = new ZaZimletListController(this._appCtxt, this._container, this);
		this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW].addRemovalListener(new AjxListener(this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW], this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW].handleRemoval));							
		this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW].addCreationListener(new AjxListener(this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW], this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW].handleCreation));			
		this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW].addChangeListener(new AjxListener(this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW], this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW].handleChange));
	}
	
	return this._controllers[ZaZimbraAdmin._ZIMLET_LIST_VIEW] ;
}

ZaApp.prototype.getZimletController =
function(viewId) {
	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c  = new ZaZimletViewController(this._appCtxt, this._container, this);
		return c ;
	}
}

ZaApp.prototype.getDistributionListController = 
function (viewId) {
		if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c = new ZaDLController(this._appCtxt, this._container, this);
		c.addCreationListener(new AjxListener(this.getAccountListController(ZaZimbraAdmin._DISTRIBUTION_LISTS_LIST_VIEW), ZaAccountListController.prototype.handleCreation));			
		c.addRemovalListener(new AjxListener(this.getAccountListController(ZaZimbraAdmin._DISTRIBUTION_LISTS_LIST_VIEW), ZaAccountListController.prototype.handleRemoval));			
		c.addChangeListener(new AjxListener(this.getAccountListController(ZaZimbraAdmin._DISTRIBUTION_LISTS_LIST_VIEW), ZaAccountListController.prototype.handleChange));
		return c ;
	}
	
};

ZaApp.prototype.getResourceController = 
function (viewId) {
	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c = new ZaResourceController(this._appCtxt, this._container, this);
		c.addCreationListener(new AjxListener(this.getAccountListController(ZaZimbraAdmin._RESOURCE_LIST_VIEW), ZaAccountListController.prototype.handleCreation));			
		c.addRemovalListener(new AjxListener(this.getAccountListController(ZaZimbraAdmin._RESOURCE_LIST_VIEW), ZaAccountListController.prototype.handleRemoval));			
		c.addChangeListener(new AjxListener(this.getAccountListController(ZaZimbraAdmin._RESOURCE_LIST_VIEW), ZaAccountListController.prototype.handleChange));
		return c ;
	}
};

ZaApp.prototype.getDomainListController =
function(viewId, newController) {
	if(!viewId)
		viewId = ZaZimbraAdmin._DOMAINS_LIST_VIEW;
			
	//this is used by SearchListController to associate its view with a new 
	//domain list controller
	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else if (viewId || newController) {
		var c = this._controllers[viewId] = new ZaDomainListController(this._appCtxt, this._container, this);
		c.addCreationListener(new AjxListener(this, ZaApp.prototype.handleDomainCreation));					
		c.addRemovalListener(new AjxListener(this, ZaApp.prototype.handleDomainRemoval));
        c.addChangeListener(new AjxListener(this.getDomainListController(), ZaDomainListController.prototype.handleDomainChange));
		c.addRemovalListener(new AjxListener(this.getDomainListController(), c.handleRemoval));
		return c ;
	}
}

ZaApp.prototype.getDomainController =
function(viewId) {
	
	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c = this._controllers[viewId] = new ZaDomainController(this._appCtxt, this._container, this);
		//since we are creating the account controller now - register all the interested listeners with it
		c.addChangeListener(new AjxListener(this.getDomainListController(), ZaDomainListController.prototype.handleDomainChange));
		c.addChangeListener(new AjxListener(c, ZaDomainController.prototype.handleDomainChange));
		c.addCreationListener(new AjxListener(this, ZaApp.prototype.handleDomainCreation));
		c.addCreationListener(new AjxListener(this.getDomainListController(), ZaDomainListController.prototype.handleCreation));
		c.addRemovalListener(new AjxListener(this.getDomainListController(), this.getDomainListController().handleRemoval));
		c.addRemovalListener(new AjxListener(this, ZaApp.prototype.handleDomainRemoval));

		return c ;
	}
}

ZaApp.prototype.getMTAListController =
function () {
	if (this._controllers[ZaZimbraAdmin._POSTQ_VIEW] == null) {
		this._controllers[ZaZimbraAdmin._POSTQ_VIEW] = new ZaMTAListController(this._appCtxt, this._container, this);
	}
	return this._controllers[ZaZimbraAdmin._POSTQ_VIEW];
}

ZaApp.prototype.getMTAController =
function (viewId) {

	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c = this._controllers[viewId] = new ZaMTAController(this._appCtxt, this._container, this);
		c.addChangeListener(new AjxListener(this.getMTAListController(), ZaMTAListController.prototype.handleMTAChange));		
		c.addChangeListener(new AjxListener(c, ZaMTAController.prototype.handleMTAChange));				
		return c ;
	}
}

ZaApp.prototype.getServerListController =
function() {
	if (this._controllers[ZaZimbraAdmin._SERVERS_LIST_VIEW] == null) {
		this._controllers[ZaZimbraAdmin._SERVERS_LIST_VIEW] = new ZaServerListController(this._appCtxt, this._container, this);								
	}
	return this._controllers[ZaZimbraAdmin._SERVERS_LIST_VIEW];
}

ZaApp.prototype.getServerController =
function(viewId) {

	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c = this._controllers[viewId] = new ZaServerController(this._appCtxt, this._container, this);
		c.addServerChangeListener(new AjxListener(this, ZaApp.prototype.handleServerChange));		
		c.addServerChangeListener(new AjxListener(this.getServerListController(), ZaServerListController.prototype.handleServerChange));		
		if(ZaSettings.TREE_ENABLED) {
			c.addServerChangeListener(new AjxListener(this._appCtxt.getAppController().getOverviewPanelController(), ZaOverviewPanelController.prototype.handleServerChange));									
		}
		return c ;
	}
	
}

ZaApp.prototype.getCosListController =
function() {
	if (this._controllers[ZaZimbraAdmin._COS_LIST_VIEW] == null) {
		this._controllers[ZaZimbraAdmin._COS_LIST_VIEW] = new ZaCosListController(this._appCtxt, this._container, this);
		this._controllers[ZaZimbraAdmin._COS_LIST_VIEW].addRemovalListener(new AjxListener(this, ZaApp.prototype.handleCosRemoval));
		if(ZaSettings.TREE_ENABLED) {
			this._controllers[ZaZimbraAdmin._COS_LIST_VIEW].addRemovalListener(new AjxListener(this._appCtxt.getAppController().getOverviewPanelController(), ZaOverviewPanelController.prototype.handleCosRemoval));
		}
	}
	return this._controllers[ZaZimbraAdmin._COS_LIST_VIEW];
}


ZaApp.prototype.getCosController =
function() {
	var c = new ZaCosController(this._appCtxt, this._container, this);
		
	c.addChangeListener(new AjxListener(this.getCosListController(), ZaCosListController.prototype.handleChange));
	if(ZaSettings.TREE_ENABLED) {
		c.addChangeListener(new AjxListener(this._appCtxt.getAppController().getOverviewPanelController(), ZaOverviewPanelController.prototype.handleCosChange));						
	}
	c.addCreationListener(new AjxListener(this.getCosListController(), ZaCosListController.prototype.handleCreation));	
	if(ZaSettings.TREE_ENABLED) {
		c.addCreationListener(new AjxListener(this._appCtxt.getAppController().getOverviewPanelController(), ZaOverviewPanelController.prototype.handleCosCreation));				
	}
	c.addRemovalListener(new AjxListener(this, ZaApp.prototype.handleCosRemoval));			
	c.addRemovalListener(new AjxListener(this.getCosListController(), ZaCosListController.prototype.handleRemoval));			
	if(ZaSettings.TREE_ENABLED) {
		c.addRemovalListener(new AjxListener(this._appCtxt.getAppController().getOverviewPanelController(), ZaOverviewPanelController.prototype.handleCosRemoval));						
	}
	return c ;

}

ZaApp.prototype.getHelpViewController =
function(viewId) {

	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c = this._controllers[viewId] = new ZaHelpViewController(this._appCtxt, this._container, this);
		return c ;
	}
}

ZaApp.prototype.getMigrationWizController = 
function(viewId) {
	
	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c = this._controllers[viewId] = new ZaMigrationWizController(this._appCtxt, this._container, this);
		return c ;
	}
}

ZaApp.prototype.searchDomains = function(query) {
	var busyId = Dwt.getNextId () ;
	var callback = new AjxCallback(this, this.domainSearchCallback, {busyId:busyId});
	var searchParams = {
			query:query, 
			types:[ZaSearch.DOMAINS],
			sortBy:ZaDomain.A_domainName,
			offset:"0",
			sortAscending:"1",
			limit:ZaDomain.MAXSEARCHRESULTS,
			callback:callback,
			controller: this.getCurrentController(),
			showBusy:true,
			busyId:busyId,
			busyMsg:ZaMsg.BUSY_SEARCHING_DOMAINS,
			skipCallbackIfCancelled:false,
			attrs:[ZaDomain.A_description, ZaDomain.A_domainName,ZaDomain.A_zimbraDomainStatus,ZaItem.A_zimbraId, ZaDomain.A_domainType]			
	}
	ZaSearch.searchDirectory(searchParams);
}

ZaApp.prototype.scheduledSearchDomains = function(domainItem) {
	var busyId = Dwt.getNextId () ;
	var callback = new AjxCallback(this, this.domainSearchCallback, {domainItem:domainItem, busyId:busyId});
	var searchParams = {
			query: this._domainQuery, 
			types:[ZaSearch.DOMAINS],
			sortBy:ZaDomain.A_domainName,
			offset:"0",
			sortAscending:"1",
			limit:ZaDomain.MAXSEARCHRESULTS,
			callback:callback,
			controller: this.getCurrentController(),
			showBusy:true,
			busyId:busyId,
			busyMsg:ZaMsg.BUSY_SEARCHING_DOMAINS,
			skipCallbackIfCancelled:false,
			attrs:[ZaDomain.A_domainName, ZaItem.A_zimbraId]			
	}
	ZaSearch.searchDirectory(searchParams);
//	DBG.println(AjxDebug.DBG1, "Searching for domains "+ ev.keyCode +" char code " + (new Date()).getTime());
}

ZaApp.prototype.domainSearchCallback = 
function (params, resp) {
	var domainItem = params.domainItem ? params.domainItem : null; 
		
	try {
		if(params.busyId)
			this._appCtxt.getShell().setBusy(false, params.busyId);
			
		if(!resp) {
			throw(new AjxException(ZaMsg.ERROR_EMPTY_RESPONSE_ARG, AjxException.UNKNOWN, "ZaListViewController.prototype.searchCallback"));
		}
		if(resp.isException()) {
			//throw(resp.getException());
			ZaSearch.handleTooManyResultsException(resp.getException(), "ZaApp.prototype.domainSearchCallback");
		} else {
			ZaSearch.TOO_MANY_RESULTS_FLAG = false ;
			var response = resp.getResponse().Body.SearchDirectoryResponse;
			var domainList = new ZaItemList(ZaDomain);	
			domainList.loadFromJS(response);
			if(ZaSettings.TREE_ENABLED) {
				this._appCtxt.getAppController().getOverviewPanelController().updateDomainList(domainList);
			}
			if (domainItem != null && domainItem instanceof XFormItem && this._domainList.size() <= 0) {
				domainItem.setError(ZaMsg.ERROR_NO_SUCH_DOMAIN) ;
				var event = new DwtXFormsEvent(this, domainItem, domainItem.getInstanceValue());
				domainItem.getForm().notifyListeners(DwtEvent.XFORMS_VALUE_ERROR, event);
			}
		}
	} catch (ex) {
		if (ex.code != ZmCsfeException.MAIL_QUERY_PARSE_ERROR) {
			this.getCurrentController()._handleException(ex, "ZaApp.prototype.domainSearchCallback");	
		} else {
			this.getCurrentController().popupErrorDialog(ZaMsg.queryParseError, ex);
		}		
	}
}

/**
 * Get all the domains from the server.
 * @param {Boolean}		refresh				bypass the cache
 * @param {Boolean}		params.asyncMode	if <code>true</code>, request will be made asynchronously
 * @param {AjxCallback}	params.callback		the next callback in chain for async request
 */
ZaApp.prototype.getDomainList =
function(refresh, params) {
	if (refresh || this._domainList == null) {
		if (params && params.asyncMode) {
			var getDomainListCallbackArray = this._getDomainListCallbackArray;
			if (!getDomainListCallbackArray) {
				getDomainListCallbackArray = this._getDomainListCallbackArray = [];
			}
			getDomainListCallbackArray.push(params.callback);
			// Send a request to the server only once. All other callbacks will be added to _getDomainListCallbackArray and executed once the response comes back from the server.
			if (getDomainListCallbackArray.length === 1) {
				params.callback = this._getDomainListCallback.bind(this);
				ZaDomain.getAll(false, params);
			}
		}
		else {
			this._domainList = ZaDomain.getAll();
		}
	}
	return this._domainList;
};

ZaApp.prototype._getDomainListCallback =
function(list) {
	this._domainList = list;
	for (var i = 0; i < this._getDomainListCallbackArray.length; i++) {
		if (this._getDomainListCallbackArray[i]) {
			this._getDomainListCallbackArray[i](list);
		}
	}
	this._getDomainListCallbackArray = [];
};

ZaApp.prototype.getSavedSearchList =
function (refresh) {
	if (refresh || ZaSearch.SAVED_SEARCHES.length <=0) {
        if (ZaSearchField.canViewSavedSearch) {
		    ZaSearch.updateSavedSearch (ZaSearch.getSavedSearches()) ;
        }
	}
	
	return ZaSearch.SAVED_SEARCHES ;
}

ZaApp.prototype.getServerByName =
function(serverName) {
	if (this._serverList == null) {
//		DBG.println(AjxDebug.DBG1, "ZaApp.prototype.getServerByName :: this._serverList is null ");
		this._serverList = ZaServer.getAll();
	}
	var cnt = this._serverList.getArray().length;
	var myServer = new ZaServer(this);
	for(var i = 0; i < cnt; i++) {
		if(this._serverList.getArray()[i].attrs[ZaServer.A_ServiceHostname] == serverName)
			return this._serverList.getArray()[i];
	}
	if(i == cnt) {
		myServer.load("name", serverName);
	}
	return myServer;	
}

ZaApp.prototype.getServerList =
function(refresh) {
	if (refresh || this._serverList == null) {
		this._serverList = ZaServer.getAll();
		
		if(this._serverList) {
			var tmpArray = this._serverList.getArray();
			this._mbsList = ZaItemList(ZaServer);
			if(tmpArray) {
				var resArray = new Array();
				var cnt = tmpArray.length;
				for(var i=0;i>cnt;i++) {
					if(tmpArray[i].attrs[ZaServer.A_zimbraMailboxServiceInstalled]) {
						this._mbsList.add(tmpArray[i]);
					}
				}
			}
		}
	}
	return this._serverList;	
}

ZaApp.prototype.getMbsList =
function(refresh) {
	if (refresh || this._mbsList == null) {
		this._mbsList = ZaServer.getAllMBSs();
	}
	return this._mbsList;	
}

ZaApp.prototype.getPostQList = 
	function (refresh, callback) {
		if (refresh || this._postqList == null || callback) {
			this._postqList = ZaMTA.getAll(callback);
		}
		return this._postqList;	
	}

ZaApp.prototype.getMailServers =
function(refresh, callback) {
	if (refresh || this._mbsList == null || callback) {
		this._mbsList = ZaServer.getAllMBSs([ZaServer.A_ServiceHostname, ZaServer.A_description, ZaServer.A_zimbraServiceEnabled, ZaServer.A_zimbraServiceInstalled, ZaItem.A_zimbraId], callback);
	}
	if(!callback) {
		var resArray = new Array();
		var tmpArray = this._mbsList.getArray();
		var cnt = tmpArray.length;
		for(var i = 0; i < cnt; i++) {
			if(tmpArray[i].attrs[ZaServer.A_zimbraMailClientServiceEnabled]) {
				resArray.push(tmpArray[i]);
			}
		}
		return resArray;
	}
}

ZaApp.prototype.getServerListChoices =
function(refresh) {
	if (refresh || this._serverList == null) {
		this._serverList = ZaServer.getAll();
	}
	if(refresh || this._serverChoices == null) {
		var hashMap = this._serverList.getIdHash();
		var mailServerArr = [];
		for (var i in hashMap) {
			if (hashMap[i].attrs[ZaServer.A_zimbraMailClientServiceEnabled]){
				mailServerArr.push(hashMap[i]);
			}
		}
		if(this._serverChoices == null) {
			this._serverChoices = new XFormChoices(mailServerArr, XFormChoices.OBJECT_LIST, ZaServer.A_ServiceHostname, ZaServer.A_ServiceHostname);
		} else {	
			this._serverChoices.setChoices(mailServerArr);
			this._serverChoices.dirtyChoices();
		}
	}
	return this._serverChoices;	
}

ZaApp.prototype.getServerIdListChoices =
function(refresh) {
	if (refresh || this._serverList == null) {
		this._serverList = ZaServer.getAll();
	}
	if(refresh || this._serverIdChoices == null) {
		var hashMap = this._serverList.getIdHash();
		var mailServerArr = [];
		for (var i in hashMap) {
			if (hashMap[i].attrs[ZaServer.A_zimbraMailClientServiceEnabled]){
				var obj = new Object();
				obj[ZaServer.A_ServiceHostname] = hashMap[i].attrs[ZaServer.A_ServiceHostname];
				obj.id = hashMap[i].id;
				mailServerArr.push(obj);
			}
		}
		if(this._serverIdChoices == null) {
			this._serverIdChoices = new XFormChoices(mailServerArr, XFormChoices.OBJECT_LIST, "id", ZaServer.A_ServiceHostname);
		} else {	
			this._serverIdChoices.setChoices(mailServerArr);
			this._serverIdChoices.dirtyChoices();
		}
	}
	return this._serverIdChoices;	
}

ZaApp.prototype.getServerMap =
function(refresh) {
	if(refresh || this._serverList == null) {
//		DBG.println(AjxDebug.DBG1, "ZaApp.prototype.getServerMap :: this._serverList is null ");						
		this._serverList = ZaServer.getAll();
	}
	if(refresh || this._serverMap == null) {
		this._serverMap = new Object();
		var cnt = this._serverList.getArray().length;
		for (var i = 0; i < cnt; i ++) {
			this._serverMap[this._serverList.getArray()[i].id] = this._serverList.getArray()[i];
		}
	}
	return this._serverMap;
}

ZaApp.prototype.getCosList =
function(refresh, callback) {
	if (refresh || !this._cosList) {
		var query = "";
		if(!ZaZimbraAdmin.hasGlobalCOSSListAccess()) {
			var cosNameList = ZaApp.getInstance()._cosNameList;
			if(AjxUtil.isEmpty(cosNameList)) {
				ZaApp.getInstance()._cosNameList = cosNameList = ZaCos.getEffectiveCosList(ZaZimbraAdmin.currentAdminAccount.id);
			}
			if(cosNameList.length == 0) {
				this._cosList = new ZaItemList(ZaCos);
				return this._cosList;
			} 
			for(var i = 0; i < cosNameList.length; i++)
				query += "(" + ZaCos.A_name + "=" + cosNameList[i] + ")";
			if(cosNameList.length > 1)
				query = "(|" + query + ")"; 
		}

		var searchParams = {
			query: query ,
			types:[ZaSearch.COSES],
			sortBy:"id",
			offset:0,
			sortAscending:"1",
			limit:ZaDomain.RESULTSPERPAGE,
			attrs:[ZaCos.A_name,ZaCos.A_description].join(),
			controller: this.getCurrentController()
		};
		this._cosList = new ZaItemList(ZaCos);
		if (callback) {
			searchParams.callback = this._getCosListCallback.bind(this, callback);
			ZaSearch.searchDirectory(searchParams);
		}
		else {
			var response = ZaSearch.searchDirectory(searchParams).Body.SearchDirectoryResponse;
			this._cosList.loadFromJS(response);
		}
	}
	return this._cosList;	
};

ZaApp.prototype._getCosListCallback =
function(callback, result) {
	var response = result.getResponse().Body;
	if (!response) {
		return;
	}
	var searchDirectoryResponse = response.SearchDirectoryResponse;
	if (!searchDirectoryResponse) {
		return;
	}
	this._cosList.loadFromJS(searchDirectoryResponse);
	if (callback) {
		callback(this._cosList);
	}
};

ZaApp.prototype.getCosListChoices =
function(refresh) {
	if (refresh || this._cosList == null) {
		
		//this._cosList = ZaCos.getAll(this);
	}
	if(refresh || this._cosListChoices == null) {
		if(this._cosListChoices == null)
			this._cosListChoices = new XFormChoices([], XFormChoices.OBJECT_LIST, "id", "name");	

		this._cosListChoices.setChoices(this._cosList.getArray());
		this._cosListChoices.dirtyChoices();

	}
	return this._cosListChoices;	
}

ZaApp.prototype.getCosListName =
function() {
	if (!this._cosListName) {
		var cosList = this.getCosList();
		this._cosListName = AjxUtil.map(cosList ? cosList.getArray() : [], function(cos) {
			return cos.name;
		});
	}
	return this._cosListName;
};

/**
 * Returns an array of domain names for the specified domainType
 *
 * @param {domainType}  string  "local" or "alias"
 *
 * @returns {Array} array of domain names for the domainType
 */
ZaApp.prototype.getDomainNameListByType =
function(domainType) {
	this._domainNameList = this._domainNameList || {};
	if (!this._domainNameList[domainType]) {
		this._domainNameList[domainType] = [];
		var domainList = this.getDomainList();
		if (domainList) {
			var domainListArray = domainList.getArray();
			for (var i = 0; i < domainListArray.length; i++) {
				var domain = domainListArray[i];
				if (domain && domain.attrs[ZaDomain.A_domainType] === domainType) {
					this._domainNameList[domainType].push(domain.name);
				}
			}
		}
	}
	return this._domainNameList[domainType];
};

ZaApp.prototype.getGlobalConfig =
function(refresh) {
	if (refresh || this._globalConfig == null) {
		this._globalConfig = new ZaGlobalConfig();
	}
	return this._globalConfig;	
}

ZaApp.prototype.getInstalledSkins = 
function(refresh) {
    try {
        if (refresh || this._installedSkins == null) {
            var soapDoc = AjxSoapDoc.create("GetAllSkinsRequest", ZaZimbraAdmin.URN, null);

	        var csfeParams = new Object();
	        csfeParams.soapDoc = soapDoc;
	        var reqMgrParams = {} ;
	        reqMgrParams.controller = ZaApp.getInstance().getCurrentController();
            try {
                this._installedSkins = [];
                var resp = ZaRequestMgr.invoke(csfeParams, reqMgrParams ).Body.GetAllSkinsResponse;
                if (resp && resp.skin) {
                    for(var i = 0; i < resp.skin.length;i++) {
                        this._installedSkins.push(resp.skin[i].name);
                    }
                }
            } catch (ex) {
                //not implemented yet
            }
        }
    	return this._installedSkins;
    }catch (e) {
        return null ;
    }
}

ZaApp.prototype.getSkinChoices =
function (skins) {
    var skinChoices = [];
    for (var i = 0; i < skins.length; i++) {
        var skin = skins[i];
        skinChoices.push({
            label: AjxStringUtil.htmlEncode(ZaMsg['theme-' + skin] || skin.substr(0, 1).toUpperCase() + skin.substr(1)),
            value: skin
        });
    }
    return skinChoices;
}
/**
* @param ev
* This listener is invoked by any controller that can create an ZaDomain object
**/
ZaApp.prototype.handleDomainCreation = 
function (ev) {
	if(ev) {
        if (!ZaZimbraAdmin.hasGlobalDomainListAccess()) {
            ZaApp.getInstance()._domainNameList = ZaDomain.getEffectiveDomainList(ZaZimbraAdmin.currentAdminAccount.id);
        }
		//update the overpanel
        this.searchDomains();
        //update the domain list. We separate two search domains because domain list view only need the first page
        // result, but the overpanel will show more results. It could potentially be combined into one search.
        this.getDomainListController().show ();

        ZaZimbraAdmin.getInstance().getOverviewPanelController().refreshRelatedTree (ev.getDetails());
	}
}

/**
* @param ev
* This listener is invoked by ZaCosController or any other controller that can remove an ZaCos object
**/
ZaApp.prototype.handleCosRemoval = 
function (ev) {
	if(ev) {
		if(!this._cosList) {
			this._cosList=ZaCos.getAll();
		} else {
			//remove the ZaCos from the controlled list
			var detls = ev.getDetails();
			if(detls && (detls instanceof Array)) {
				for (var key in detls) {
					this._cosList.remove(detls[key]);
				}
			} else if(detls && (detls instanceof ZaCos)) {
				this._cosList.remove(ev.getDetails());
			}

            ZaZimbraAdmin.getInstance().refreshHistoryTreeByDelete(ev.getDetails());
		}
		if(this._cosListChoices == null) {
			this._cosListChoices = new XFormChoices(this._cosList.getArray(), XFormChoices.OBJECT_LIST, "id", "name");	
		} else {
			this._cosListChoices.setChoices(this._cosList.getArray());
			this._cosListChoices.dirtyChoices();			
		}
	}
}

ZaApp.prototype.handleServerChange = 
function (ev) {
	if(ev) {
		if(this._serverList) {
			this._serverList=ZaServer.getAll();
			if(this._serverChoices == null) {
				this._serverChoices = new XFormChoices(this._serverList.getArray(), XFormChoices.OBJECT_LIST, ZaServer.A_ServiceHostname, ZaServer.A_ServiceHostname);
			} else {	
				this._serverChoices.setChoices(this._serverList.getArray());
				this._serverChoices.dirtyChoices();
			}

			this._serverMap = new Object();
			var cnt = this._serverList.getArray().length;
			for (var i = 0; i < cnt; i ++) {
				this._serverMap[this._serverList.getArray()[i].id] = this._serverList.getArray()[i];
			}						
		} 
	}
}

/**
* @param ev
* This listener is invoked by ZaDomainController or any other controller that can remove an ZaDomain object
**/
ZaApp.prototype.handleDomainRemoval = 
function (ev) {
	if(ev) {
		this.searchDomains();
	}
}

/**
* @param ev
* This listener is invoked by ZaDomainController or any other controller that can remove an ZaDomain object
**/
ZaApp.prototype.handleDomainChange = 
function (ev) {
	if(ev) {
		this.searchDomains();
	}
}

ZaApp.prototype.handleSettingsChange = 
function(ev) {
	if(ev) {
		this._globalConfig = new ZaGlobalConfig(this);
	}
}

/**
* Returns the app's name.
*/
ZaApp.prototype.getName =
function() {
	return this._name;
}

/**
* Returns the app view manager.
*/
ZaApp.prototype.getAppViewMgr = 
function() {
	return this._appViewMgr;
}

ZaApp.prototype.createView =
function(viewName, elements, tabParams) {
	this._appViewMgr.createView(viewName, elements);
	
	//create new tabs or modify tab
	/* tabParams {
	 * 	openInNewTab: true/false,
	 *  tabId: The tabId which will be either set for new Tab or the updating tab
	 *  tab: the tab to be updated
	 *  view: 
	 * }
	 */
	
	if (tabParams.openInNewTab) {
		this.createTab (tabParams);
	}else{
		this.updateTab (tabParams.tab, tabParams.tabId);
	}
	
}

ZaApp.prototype.createTab =
function () {
	if (arguments.length == 0) return;
	var tabId;
	var closable = true;
	var selected = true;
	var onOpen = null;
	if (typeof arguments[0] == "object") {
		tabId = arguments[0]["tabId"];
		closable = AjxUtil.isEmpty(arguments[0]["closable"]) ? true : false;
		selected = AjxUtil.isEmpty(arguments[0]["selected"]) ? true : false;
		onOpen = AjxUtil.isEmpty(arguments[0]["onOpen"]) ? null : arguments[0]["onOpen"];
	} else {
		tabId = arguments[0]; 
	}
	var tabGroup = this.getTabGroup() ;
	var appView = this.getViewById(tabId) [ZaAppViewMgr.C_APP_CONTENT] ;
	var params = {
		id: tabId ,
		icon: appView.getTabIcon (),
		label: appView.getTabTitle () ,
		toolTip: appView.getTabToolTip () || appView.getTabTitle () ,
		closable: closable,
		selected: selected,
		onOpen:onOpen
	}
	
	var tab = new ZaAppTab (tabGroup,params );
	/*
				entry.name, entry.getTabIcon() , null, null, 
				true, true, ZaApp.getInstance()._currentViewId) ;
	tab.setToolTipContent( entry.getTabToolTip()) ; */
}

/**
 * tab: the tab to be updated
 * tabId: the new id associated with the tab
 */
ZaApp.prototype.updateTab =
function ( tab, tabId ) {
	
	var tabGroup = this.getTabGroup() ;
	if (tabGroup._searchTab && tabGroup._searchTab == tab) {
		this.updateSearchTab() ;
	}else{	
		var appView = this.getViewById(tabId)[ZaAppViewMgr.C_APP_CONTENT];
		var icon = appView.getTabIcon (); //the view class should implement the getTabIcon () function
		var titleLabel = appView.getTabTitle () ; //the view class should implement the getTabTitle () function
	
		tab.setToolTipContent (appView.getTabToolTip() || appView.getTabTitle ()) ;
		tab.resetLabel (titleLabel) ;
		tab.setImage (icon) ;
	}
	
	tab.setTabId (tabId) ; //set the new tabId to the existing tab
	
	if (! tab.isSelected()) {
		tabGroup.selectTab(tab);
	}
}

ZaApp.prototype.updateSearchTab =
function () {
	var searchTab = this.getTabGroup().getSearchTab() ;
	searchTab.setImage (ZaSearchListView.prototype.getTabIcon()) ;
	searchTab.resetLabel (ZaSearchListView.prototype.getTabTitle()) ;
	searchTab.setToolTipContent (
		ZaSearchListView.prototype.getTabToolTip.call(this._controllers[searchTab.getTabId()])) ;
}

ZaApp.prototype.pushView =
function(name, openInNewTab, openInSearchTab) {
	this._currentViewId = this._appViewMgr.pushView(name);
}

ZaApp.prototype.popView =
function() {
	var oldCurrentViewId = this._currentViewId ;
	this._currentViewId = this._appViewMgr.popView();
	//dispose the view and remove the controller
	this.disposeView (oldCurrentViewId);
	
}

ZaApp.prototype.disposeView =
function (viewId, closeHidden) {
	var view = this.getViewById (viewId) ;
	if(closeHidden) {
		this._appViewMgr.removeHiddenView(viewId);
	}
	for (var n in view) {
		if (view[n] instanceof DwtComposite) {
			view[n].dispose () ;
		}else{
			view[n] = null ;
		}
	} 
	
	//destroy the controller also
	if (this._controllers[viewId] != null) {
		this._controllers[viewId] = null ;
	} 
}

ZaApp.prototype.setView =
function(name, force) {
	return this._appViewMgr.setView(name, force);
}

ZaApp.prototype.getViewById =
function (id) {
	return	this.getAppViewMgr()._views[id] ;
}
// Abstract methods


/**
* Clears an app's state.
*/
ZaApp.prototype.reset =
function(active) {
}

ZaApp.prototype.setTabGroup =
function (tabGroup) {
	this._tabGroup = tabGroup ;	
}

ZaApp.prototype.getTabGroup =
function () {
	return this._tabGroup ;	
	
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaAboutDialog")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Created by IntelliJ IDEA.
 * User: mingzhang
 * Date: 4/1/12
 * Time: 2:11 AM
 * To change this template use File | Settings | File Templates.
 */


ZaAboutDialog = function(parent, className, w, h) {
    if (arguments.length == 0) return;
    var clsName = className || "DwtBaseDialog AboutScreen";
    DwtBaseDialog.call(this, parent, clsName,  "");
    w = w || "579px";
    h = h || "264px";
    this.setSize(w, h);
    this.addCloseListener();
    this.addFocusBlurListener();
}

ZaAboutDialog.prototype = new DwtBaseDialog;
ZaAboutDialog.prototype.constructor = ZaAboutDialog;
ZaAboutDialog.prototype.TEMPLATE = "admin.Widgets#ZaAboutDialog";
ZaAboutDialog.prototype.closeIcon = "ImgAboutClose";
ZaAboutDialog.prototype.closeHoverIcon = "ImgAboutCloseHover";

ZaAboutDialog.prototype._createHtmlFromTemplate = function (templateId, data) {
    data.dragId = this._dragHandleId;
    data.closeIcon = this.closeIcon ? this.closeIcon : "ImgAboutClose";
    var date = AjxDateFormat.getDateInstance().format(ZaServerVersionInfo.buildDate);
    data.version = AjxBuffer.concat(ZaMsg.splashScreenVersion, " ", ZaServerVersionInfo.version , " " , date);
    data.copyright = ZaItem.getAboutScreenCopyright();
    data.aboutBanner = "ImgAboutBanner";
    data.logoURL = ZaAppCtxt.getLogoURI();
    DwtComposite.prototype._createHtmlFromTemplate.call(this, templateId, data);
    this._contentEl = document.getElementById(data.id+"_content");
    this._closeIconEl = document.getElementById(data.id+"_close");
}

ZaAboutDialog.prototype.addCloseListener = function () {
    if (this._closeIconEl) {
        Dwt.setHandler(this._closeIconEl, DwtEvent.ONCLICK, AjxCallback.simpleClosure(this.popdown, this));
    }
}

ZaAboutDialog.prototype.addFocusBlurListener = function () {
    if (this._closeIconEl && this._closeIconEl.firstChild) {
        var enterEvent = AjxEnv.isIE? DwtEvent.ONMOUSEENTER: DwtEvent.ONMOUSEOVER;
        var leaveEvent = AjxEnv.isIE? DwtEvent.ONMOUSELEAVE: DwtEvent.ONMOUSEOUT;
        Dwt.setHandler(this._closeIconEl.firstChild, enterEvent, AjxCallback.simpleClosure(this.changeCloseIcon, this, true));
        Dwt.setHandler(this._closeIconEl.firstChild, leaveEvent, AjxCallback.simpleClosure(this.changeCloseIcon, this, false));
    }
}

ZaAboutDialog.prototype.changeCloseIcon = function (isHover) {
    if (this._closeIconEl && this._closeIconEl.firstChild) {
        if (isHover) {
            Dwt.delClass(this._closeIconEl.firstChild, this.closeIcon, this.closeHoverIcon);
        } else {
            Dwt.delClass(this._closeIconEl.firstChild, this.closeHoverIcon, this.closeIcon);
        }
    }
}

}
if (AjxPackage.define("zimbraAdmin.common.ZaMsgDialog")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* Creates a new message dialog.
* @constructor
* @class
* This class represents a reusable message dialog box. Messages can be informational, warning, or
* critical.
*/
ZaMsgDialog = function(parent, className, buttons, extraButtons, contextId) {
	this._app = ZaApp.getInstance();
    	var id = contextId? ZaId.getDialogId(ZaId.DLG_MSG, contextId):ZaId.getDialogId(ZaId.DLG_MSG);
 	DwtMessageDialog.call(this, parent, className, buttons, extraButtons, id);
}


ZaMsgDialog.prototype = new DwtMessageDialog;
ZaMsgDialog.prototype.constructor = ZaMsgDialog;

ZaMsgDialog.CLOSE_TAB_DELETE_BUTTON = "close tab and delete";
ZaMsgDialog.CLOSE_TAB_DELETE_BUTTON_DESC = 
	new DwtDialog_ButtonDescriptor (ZaMsgDialog.CLOSE_TAB_DELETE_BUTTON, ZaMsg.bt_close_tab_delete, DwtDialog.ALIGN_RIGHT);
ZaMsgDialog.NO_DELETE_BUTTON = "no delete" ;
ZaMsgDialog.NO_DELETE_BUTTON_DESC = 
	new DwtDialog_ButtonDescriptor (ZaMsgDialog.NO_DELETE_BUTTON, ZaMsg.bt_no_delete, DwtDialog.ALIGN_RIGHT);
}
if (AjxPackage.define("zimbraAdmin.common.ZaErrorDialog")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
* Creates an error dialog which basically means it will have a "Report" button
* @constructor
* @class
* A normal DwtMessageDialog w/ a "Report" button that will post user info to the 
* server when clicked.
*/
ZaErrorDialog = function(parent, contextId) {
	//if (arguments.length === 0) {return;}
	if(!parent) return;

	var detailButton = new DwtDialog_ButtonDescriptor(ZaErrorDialog.DETAIL_BUTTON, AjxMsg.detail, DwtDialog.ALIGN_LEFT);
	var id = contextId? ZaId.getDialogId(ZaId.DLG_ERR,contextId):ZaId.getDialogId(ZaId.DLG_ERR); 
	DwtMessageDialog.call(this, parent, null, null, [detailButton],id);

	// setup the detail button
	this._detailCell = document.getElementById(this._detailCellId);
	var detailBtn = this._button[ZaErrorDialog.DETAIL_BUTTON];
	detailBtn.setImage("SelectPullDownArrow");
	this.registerCallback(ZaErrorDialog.DETAIL_BUTTON, this._showDetail, this);
    this._setAllowSelection();
}

ZaErrorDialog.prototype = new DwtMessageDialog;
ZaErrorDialog.prototype.constructor = ZaErrorDialog;

ZaErrorDialog.prototype.toString = function() {
	return "ZaErrorDialog";
};

//
// Constants
//

ZaErrorDialog.DETAIL_BUTTON = ++DwtDialog.LAST_BUTTON;

//
// Data
//

ZaErrorDialog.prototype._detailsVisible = false;

ZaErrorDialog.prototype.CONTROLS_TEMPLATE = "zimbra.Widgets#ZmErrorDialogControls";

//
// Public methods
//

ZaErrorDialog.prototype.reset =
function() {
	this.setDetailString();
	DwtMessageDialog.prototype.reset.call(this);
};

ZaErrorDialog.prototype.setMessage =
function(msgStr, detailStr, style, title) {
	msgStr = AjxStringUtil.htmlEncode(msgStr);

	// If we have a <br> tag in string then we need to maintain decode it, so it will be considered as html tag
	msgStr = msgStr.replace(/&lt;br\s?(\/)?&gt;/gi, '<br />');

	this._msgStr = msgStr;
	this._msgStyle = style;
	this._msgTitle = title;

    // clear the 'detailsVisible' flag and reset the 'showDetails' button icon
    this._detailsVisible = false;
    this._button[ZaErrorDialog.DETAIL_BUTTON].setImage("SelectPullDownArrow");

    DwtMessageDialog.prototype.setMessage.call(this, msgStr, style, title);
	this.setDetailString(detailStr);
};

/**
* Sets the text that shows up when the Detail button is pressed.
*
* @param text	detail text
*/
ZaErrorDialog.prototype.setDetailString = 
function(text) {
	if (!(this._buttonElementId[ZaErrorDialog.DETAIL_BUTTON])) {return;}

    this._detailStr = text;

    this._button[ZaErrorDialog.DETAIL_BUTTON].setVisible(text != null);
    if (this._detailsEl) {
        this._detailsEl.value = text || "";
	}
};



//
// Protected methods
//

ZaErrorDialog.prototype._createHtmlFromTemplate = function(templateId, data) {
    DwtMessageDialog.prototype._createHtmlFromTemplate.call(this, templateId, data);
    this._detailsContainerEl = document.getElementById(data.id+"_details_container");
    this._detailsEl = document.getElementById(data.id+"_details");
};

ZaErrorDialog.prototype._getContentHtml =
function() {
	this._detailCellId = Dwt.getNextId();
	var html = new Array();
	var idx = 0;

	html[idx++] = DwtMessageDialog.prototype._getContentHtml.call(this);
	html[idx++] = "<div id='" + this._detailCellId + "'></div>";
	
	return html.join("");
};


// Displays the detail text
ZaErrorDialog.prototype._showDetail = function() {
    this._detailsVisible = !this._detailsVisible;

    var msg = this._msgStr;
    if (this._detailsVisible) {
    	msg += "<div style='overflow:auto;height:100px'>";
        msg += "<hr> " + this._detailStr;
        msg += "</div>";
    }
    DwtMessageDialog.prototype.setMessage.call(this, msg, this._msgStyle, this._msgTitle);
    this._button[ZaErrorDialog.DETAIL_BUTTON].setImage(this._detailsVisible ? "SelectPullUpArrow" : "SelectPullDownArrow");
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaTabView")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaTabView is an abstract class for creating views that present data in tabs.
* All the tabbed views in the Admin UI should extend ZaTabView.
* call initForm after calling the constructor
* @contructor
* @param parent
* @param app
* @extends DwtComposite
* @author Greg Solovyev
**/

ZaTabView = function(params) {
	if (arguments.length == 0) return;
	params = Dwt.getParams(arguments, ZaTabView.PARAMS);
	var className = params.cssClassName ? params.cssClassName : "DwtTabView";
	this._contextId = params.contextId? params.contextId:ZaId.TAB_UNDEF;
	DwtComposite.call(this, {
		parent:params.parent, 
		className:className, 
		posStyle:Dwt.ABSOLUTE_STYLE,
		id: ZaId.getTabId(this._contextId)
	});	
	this._iKeyName = params.iKeyName;
	this._drawn = false;	
	this._appCtxt = this.shell.getData(ZaAppCtxt.LABEL);
	this._containedObject = null;
	this.setScrollStyle(Dwt.SCROLL_Y);
	this._currentSubTab = [];
}

ZaTabView.PARAMS = ["parent","iKeyName", "cssClassName", "contextId"];

ZaTabView.prototype = new DwtComposite();
ZaTabView.prototype.constructor = ZaTabView;

/**
* A map of funciton references. Functions in this map are called one after another from 
* {@link #getMyXForm} method.
* The functions are called on the current instance of the dialog. 
* One parameter is passed to each function: a reference to the XForms object defenition.
* Keys in the map are names of the view classes: ZaAccountXFormView, ZaCosXFormView, ZaDomainXFormView, etc
* Values in the map are arrays of function references
* If you have defined your function for modifying a view's XForm definition, you can add it to this map like this:
* ZaTabView.XFormModifiers["ZaAccountXFormView"].push(ZaAccountXFormView.myXFormModifier);
* This example adds funciton ZaAccountXFormView.myXFormModifier to the array of functions that will be called to construct UI for ZaAccountXFormView
*
* Examples of using this map can be found in {@link ZaAccountXFormView}, {@link ZaCosXFormView}, {@link ZaServerXFormView}
* @see #getMyXForm
* @see ZaAccountXFormView#myXFormModifier
* @see ZaCosXFormView#myXFormModifier
* @see ZaCosXFormView#ZaServerXFormView
**/
ZaTabView.XFormModifiers = new Object();
ZaTabView.XFormSetObjectMethods = new Object();

ZaTabView.DEFAULT_TAB = 1;

/**
* @param xModelMetaData - XModel metadata that describes data model
* @param xFormMetaData - XForm metadata that describes the form
**/
ZaTabView.prototype.initForm = 
function (xModelMetaData, xFormMetaData, entry) {
	if(xModelMetaData == null || xFormMetaData == null)
		throw new AjxException(ZaMsg.ERROR_METADATA_NOT_DEFINED, AjxException.INVALID_PARAM, "ZaTabView.prototype._initForm");

	this._localXModel = new XModel(xModelMetaData);
	this._localXForm = new XForm(xFormMetaData, this._localXModel, entry, this, ZaId.getTabViewId(this._contextId));
	this._localXForm.setController(ZaApp.getInstance());
	this._localXForm.draw();
	this.formChangeListener = new AjxListener(this, ZaTabView.prototype.setDirty,[true]) ;
	this._localXForm.addListener(DwtEvent.XFORMS_VALUE_CHANGED,this.formChangeListener);
	this._drawn = true;
}

ZaTabView.prototype.setBounds = function (x, y, width, height) {	
	DwtControl.prototype.setBounds.call(this,x, y, width, height);

	if (this.isListenerRegistered(DwtEvent.CONTROL)) {
	 	var evt = DwtShell.controlEvent;
	 	evt.reset();
	 	this.notifyListeners(DwtEvent.CONTROL, evt);
	} 
}

/**
* @return XForm definition for this view's XForm
**/
ZaTabView.prototype.getMyXForm = function (entry) {
	var xFormObject = new Object();
	//Instrumentation code start
	if(ZaTabView.XFormModifiers[this._iKeyName]) {
		var methods = ZaTabView.XFormModifiers[this._iKeyName];
		var cnt = methods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(methods[i]) == "function") {
				methods[i].call(this,xFormObject,entry);
			}
		}
	}	
	//Instrumentation code end	
	return xFormObject;
}

/**
* @return XForm instance displayed on the view
**/
ZaTabView.prototype.getMyForm = function () {
	return this._localXForm;
}

/**
* @return XModel instance controlled by the XForm on the view
**/
ZaTabView.prototype.getMyModel = function () {
	return this._localXModel;
}


/**
* @method getObject returns the object contained in the view
* before returning the object this updates the object attributes with 
* tha values from the form fields 
**/
ZaTabView.prototype.getObject =
function() {
	return this._containedObject;
}

/**
* @method setObject sets the object contained in the view
* @param entry - ZaItem object to display
**/
ZaTabView.prototype.setObject =
function(entry) {
	this._containedObject = new Object();
	this._containedObject.attrs = new Object();
	this._containedObject.type = entry.type;
	this._containedObject.name = entry.name;
	
	if(entry.id)
		this._containedObject.id = entry.id;
	
	if(entry.rights)
		this._containedObject.rights = entry.rights;
	
	if(entry.setAttrs)
		this._containedObject.setAttrs = entry.setAttrs;
	
	if(entry.getAttrs)
		this._containedObject.getAttrs = entry.getAttrs;
		
	if(entry._defaultValues)
		this._containedObject._defaultValues = entry._defaultValues;
		
	for (var a in entry.attrs) {
		if(entry.attrs[a] instanceof Array) {
			this._containedObject.attrs[a] = [].concat(entry.attrs[a]);
		} else {
			this._containedObject.attrs[a] = entry.attrs[a];
		}
	}
	
	
	if(!entry[ZaModel.currentTab])
		this._containedObject[ZaModel.currentTab] = "1";
	else
		this._containedObject[ZaModel.currentTab] = entry[ZaModel.currentTab];
		
	this._localXForm.setInstance(this._containedObject);
	
	this.formDirtyLsnr = new AjxListener(ZaApp.getInstance().getCurrentController(), ZaXFormViewController.prototype.handleXFormChange);
	this._localXForm.addListener(DwtEvent.XFORMS_FORM_DIRTY_CHANGE, this.formDirtyLsnr);
	this._localXForm.addListener(DwtEvent.XFORMS_VALUE_ERROR, this.formDirtyLsnr);	
}

ZaTabView.ObjectModifiers = {} ;
ZaTabView.prototype.modifyContainedObject = function () {
     if(ZaTabView.ObjectModifiers[this._iKeyName]) {
		var methods = ZaTabView.ObjectModifiers[this._iKeyName];
		var cnt = methods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(methods[i]) == "function") {
				methods[i].call(this);
			}
		}
	}
}

ZaTabView.prototype.setEnabled = 
function(enable) {
	//abstract. This method may be depriicated in near future
}

/**
* @param isD Boolean - flag indicates whether data on the form ahs been modified by user
**/
ZaTabView.prototype.setDirty = 
function (isD) {
	ZaApp.getInstance().getCurrentController().setDirty(isD);
	this._isDirty = isD;
	//reset the domain lists
	EmailAddr_XFormItem.resetDomainLists.call (this);
}

ZaTabView.prototype.getCurrentTab = 
function() {
	return this._containedObject[ZaModel.currentTab];
}

ZaTabView.prototype.getCurrentSubTab = 
function() {
	var subtab = this._currentSubTab[this._containedObject[ZaModel.currentTab]];
	if (subtab == null) {
		subtab = this._currentSubTab[this._containedObject[ZaModel.currentTab]] = ZaTabView.DEFAULT_TAB;
	}
	return subtab;
}

ZaTabView.prototype.swithTab = 
function (value) {
	this._containedObject[ZaModel.currentTab] = value;
	this._localXForm.refresh();
}

ZaTabView.prototype.switchSubTab =
function(value) {
	this._currentSubTab[this._containedObject[ZaModel.currentTab]] = value;
}

ZaTabView.prototype.isDirty = 
function () {
	return this._isDirty;
}

ZaTabView.prototype.getTabToolTip =
function () {
	if (this._containedObject && this._containedObject.name && this._containedObject.type) {
		return	ZaMsg.TBB_Edit + " " +  this._containedObject.type + " " + this._containedObject.name ;
	}else{
		return "" ;
	}
}

ZaTabView.prototype.getTabIcon = 
function () {
	if (this._containedObject && this._containedObject.type) {
		return this._containedObject.type ;
	}else{
		return "" ;
	}
}

ZaTabView.prototype.getTabTitle =
function () {
	if (this._containedObject && this._containedObject.name) {
		return this._containedObject.name ;
	}else{
		return ZaMsg.TBB_New;
	}
}

//this method will be called whenever the item object of the view is updated
//it should be called in the setObject function of the view class
ZaTabView.prototype.updateTab =
function () {
	var tab = this.getAppTab ();
	if (tab) {
		tab.resetLabel (this.getTabTitle()) ;
		tab.setImage (this.getTabIcon());
		tab.setToolTipContent (this.getTabToolTip()) ;
	}
}

ZaTabView.prototype.getAppTab =
function () {
	return ZaApp.getInstance().getTabGroup().getTabById(this.__internalId) ;
}

/**
 * This method checks if a tab or a view should be enabled based on given list of attributes and rights.
 * If current admin has read permission on any of the attribues, or has any of the provided rights the method returns TRUE
 */
ZaTabView.isTAB_ENABLED = function (entry, attrsArray, rightsArray) {
	if(!entry)
		return true;
		
	if(AjxUtil.isEmpty(attrsArray) && AjxUtil.isEmpty(rightsArray))
		return true;
		
	if(!AjxUtil.isEmpty(attrsArray)) {
		var cntAttrs = attrsArray.length;
		for(var i=0; i< cntAttrs; i++) {
			if(ZaItem.hasReadPermission(attrsArray[i],entry)) {
				return true;
			}
		}
	} 
	
	if(!AjxUtil.isEmpty(rightsArray)) {
		var cntRights = rightsArray.length;
		for(var i=0; i< cntRights; i++) {
			if(ZaItem.hasRight(rightsArray[i],entry)) {
				return true;
			}
		}
	}
	
	return false; 
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaXDialog")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class 
* @contructor 
* @extends DwtDialog
* @author Greg Solovyev
* @param parent
* @param w (width)
* @param h (height)
**/

ZaXDialog = function(parent,className, title, w, h,iKeyName, contextId) {
	if (arguments.length == 0) return;
	this._iKeyName = iKeyName;	
	var clsName = className || "DwtDialog";
	if(!this._standardButtons)
		this._standardButtons = [DwtDialog.OK_BUTTON];
	if(!this._extraButtons) {
		var helpButton = new DwtDialog_ButtonDescriptor(ZaXDialog.HELP_BUTTON, ZaMsg.TBB_Help, DwtDialog.ALIGN_LEFT, new AjxCallback(this, this._helpButtonListener));
		this._extraButtons = [helpButton];
	}
	
	this._contextId = contextId || Dwt.getNextId(ZaId.DLG_UNDEF);
	if (this.supportMinimize) {
        this._supportMinimize = true;
    }
	DwtDialog.call(this, {
		parent:parent, 
		className:clsName, 
		title:title, 
		standardButtons:this._standardButtons,
		extraButtons:this._extraButtons,
		id:ZaId.getDialogId(this._contextId)
	});
    if (this._supportMinimize) {
        this.addMiniIcon();
        this.addPopdownListener(new AjxListener(this, this.popdownHookListner));
    }
	this._app = ZaApp.getInstance();
	this._localXForm = null;
	this._localXModel = null;
	this._drawn = false;
	this._containedObject = null;	

	if (!w) {
		this._contentW = "500px";
	} else {
		this._contentW = w;
	}
	
	if(!h) {
		this._contentH = "350px";
	} else {
		this._contentH = h;
	}		
	
	this._pageDiv = document.createElement("div");
	this._pageDiv.className = "ZaXWizardDialogPageDiv";
	this._pageDiv.style.width = this._contentW;
	this._pageDiv.style.height = this._contentH;
	this._pageDiv.style.overflow = "auto";
	this._pageDiv.style["overflow-y"] = "auto";
	this._pageDiv.style["overflow-x"] = "auto";	

	this._createContentHtml();
	this._helpURL = ZaXDialog.helpURL;	
}
ZaXDialog.helpURL = location.pathname + ZaUtil.HELP_URL + "administration_console_help.htm?locid="+AjxEnv.DEFAULT_LOCALE;
ZaXDialog.prototype = new DwtDialog;
ZaXDialog.prototype.constructor = ZaXDialog;

ZaXDialog.TEMPLATE = "admin.Widgets#ZaBaseDialog";
ZaXDialog.prototype.supportMinimize = false;
ZaXDialog.prototype.registerFinishMethod = false;
ZaXDialog.prototype.miniType = 1; // default is working in process
ZaXDialog.prototype.cacheDialog = true;
ZaXDialog.prototype._createHtmlFromTemplate =
function(templateId, data) {
    if (this._supportMinimize) {
        templateId = ZaXDialog.TEMPLATE;
    }
	DwtDialog.prototype._createHtmlFromTemplate.call(this, templateId, data);
    this._minEl =  document.getElementById(data.id+"_minimize");
};

ZaXDialog.prototype.addMiniIcon =
function () {
    if (this._minEl) {
        this._minEl.innerHTML = AjxImg.getImageHtml("CollapseRight");
	    this._minEl.onclick = AjxCallback.simpleClosure(ZaXDialog.prototype.__handleMinClick, this);
    }
}
ZaXDialog.prototype.setTitleWidthForIE =
function () {
    var titleWidth = (this._contentW || "500px" ).replace("px","");
    titleWidth -= (24+5*2);    //24px is width for mini icon, 5*2px for two padding

    if (titleWidth > 0) {
    //TODO: can extract this part as a function named setTitleWidth(), if we need to set FF/Chrome 's width in the future.
        titleWidth = Dwt.__checkPxVal(titleWidth);
        var titleId = this._htmlElId + "_title";
        var titleElement = document.getElementById(titleId);
        if (titleElement) {
            titleElement.style.width = titleWidth;
        }
    }
}

ZaXDialog.prototype.getTaskItem = function() {
    var cacheName = this.getCacheName? this.getCacheName() : "";
    if (!cacheName) {
        cacheName = this._iKeyName ? this._iKeyName : this.toString();
    }

    var title = this.getTitle();
    if (!title) {
        title = this.toString();
    }

    var viewForPopup;
    if (this.miniType == 1) {
        viewForPopup = this.constructor;
    } else {
        viewForPopup = this;
    }
    var taskItem = new ZaTaskItem(viewForPopup, cacheName, title, this.getObject(), this.getBounds(), this.miniType, undefined, this.getFinishBtnCallback(),this.cacheDialog);
    return taskItem;
}

ZaXDialog.prototype.getFinishBtnCallback = function (finishBtnId) {
    if (!this.registerFinishMethod)
        return;

    if (!finishBtnId)
        finishBtnId = DwtWizardDialog.FINISH_BUTTON;

    var button;
    button = this._buttonDesc[finishBtnId];
    if (!button) {
        finishBtnId = DwtDialog.OK_BUTTON;
        button = this._buttonDesc[finishBtnId];
    }

    if (!button)
        return;

    if (!button.callback)
        return;

    return {id: finishBtnId, callback: button.callback};
}
ZaXDialog.prototype.popdownHookListner =
function() {
    if (!this._inMin) {
	    var task = this.getTaskItem();
        ZaZimbraAdmin.getInstance().getTaskController().removeTask(task);
    }
}

ZaXDialog.prototype.__handleMinClick =
function () {
    var task = this.getTaskItem();
    ZaZimbraAdmin.getInstance().getTaskController().addTask(task);
    this._inMin = true;
    this.popdown();
    this._inMin = false;
}

ZaXDialog.prototype.getTitle =
function () {
    return this._title;
}


/**
* A map of funciton references. Functions in this map are called one after another from 
* {@link #getMyXForm} method.
* The functions are called on the current instance of the dialog. 
* One parameter is passed to each function: a reference to the XForms object defenition
*  ZaXDialog
* @see #getMyXForm
**/
ZaXDialog.XFormModifiers = new Object();

/**
* 
**/
ZaXDialog.HELP_BUTTON = ++DwtDialog.LAST_BUTTON;


ZaXDialog.prototype.popup = 
function (loc) {
	DwtDialog.prototype.popup.call(this, loc);

    if(AjxEnv.isIE && this._supportMinimize) {
        //reset title width in IE, when the dialog has the minimize icon
        this.setTitleWidthForIE();
    }

	if (this._localXForm) {
		var el = this._localXForm.focusFirst();
        var kbMgr = this._shell.getKeyboardMgr();
        if (kbMgr && kbMgr.isEnabled()) {
            kbMgr.grabFocus(el);
        }
	}
};

/**
* public method _initForm
* @param xModelMetaData
* @param xFormMetaData
**/
ZaXDialog.prototype.initForm = 
function (xModelMetaData, xFormMetaData, defaultInstance) {
	if(xModelMetaData == null || xFormMetaData == null)
		throw new AjxException("Metadata for XForm and/or XModel are not defined", AjxException.INVALID_PARAM, "ZaXWizardDialog.prototype.initForm");
		
	this._localXModel = new XModel(xModelMetaData);
	this._localXForm = new XForm(xFormMetaData, this._localXModel, defaultInstance, this, ZaId.getDialogViewId(this._contextId));
	this._localXForm.setController(ZaApp.getInstance());
	this._localXForm.draw(this._pageDiv);	
	this._drawn = true;
}

ZaXDialog.prototype.getObject = 
function () {
	return this._containedObject;
}

/**
* sets the object contained in the view
**/
ZaXDialog.prototype.setObject =
function(entry) {
	this._containedObject = entry;
	this._localXForm.setInstance(this._containedObject);
}

/**
* This method walks the map {@link #XFormModifiers} and calls each function in the map.
* The functions are called on the current instance of the dialog. 
* One parameter is passed to each function: a reference to the XForms object defenition
*  ZaXDialog
**/
ZaXDialog.prototype.getMyXForm = 
function(entry) {	
	var xFormObject = new Object();
	//Instrumentation code start
	if(ZaXDialog.XFormModifiers[this._iKeyName]) {
		var methods = ZaXDialog.XFormModifiers[this._iKeyName];
		var cnt = methods.length;
		for(var i = 0; i < cnt; i++) {
			if(typeof(methods[i]) == "function") {
				methods[i].call(this,xFormObject,entry);
			}
		}
	}	
	//Instrumentation code end	
	return xFormObject;
}

ZaXDialog.prototype.setDirty = function () {
	//override
}
/**
*  ZaXDialog
* @private
**/
ZaXDialog.prototype._createContentHtml =
function () {

	this._table = document.createElement("table");
	this._table.border = 0;
    if (this._contentW)
	    this._table.width=this._contentW;
	this._table.cellPadding = 0;
	this._table.cellSpacing = 0;
	Dwt.associateElementWithObject(this._table, this);
	this._table.backgroundColor = DwtCssStyle.getProperty(this.parent.getHtmlElement(), "background-color");
	
	var row2; //page
	var col2;
	row2 = this._table.insertRow(0);
	row2.align = "left";
	row2.vAlign = "middle";
	
	col2 = row2.insertCell(row2.cells.length);
	col2.align = "left";
	col2.vAlign = "middle";
    if (this._contentW)
	    col2.width = this._contentW;
	col2.appendChild(this._pageDiv);

	this._getContentDiv().appendChild(this._table);
}

/**
*  ZaXDialog
* @private
**/
ZaXDialog.prototype._helpButtonListener =
function() {
	window.open(this._helpURL);
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaXWizardDialog")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* Creates a new wizard dialog.
* @class
* @constructor
* @extends ZaXDialog
* @param parent - parent control {shell} 
* @param className {String} CSS class name
* @param title {String} dialog title
* @param w {Number} content area width
* @param h {Number} content area height
* @param contextId (String) prefix id
* This class represents a reusable wizard dialog. 
* After calling the constructor, define metadata for and call initForm to draw the contents of the dialog
*/
ZaXWizardDialog = function(parent,className, title, w, h,iKeyName, extraButtons, contextId) {
	if (arguments.length == 0) return;

	this._standardButtons = [DwtDialog.CANCEL_BUTTON];

	if(extraButtons) {
		this._extraButtons = extraButtons;
	} else {
		var helpButton = new DwtDialog_ButtonDescriptor(ZaXWizardDialog.HELP_BUTTON, ZaMsg.TBB_Help, DwtDialog.ALIGN_LEFT, new AjxCallback(this, this._helpButtonListener));
		var nextButton = new DwtDialog_ButtonDescriptor(ZaXWizardDialog.NEXT_BUTTON, AjxMsg._next, DwtDialog.ALIGN_RIGHT, new AjxCallback(this, this.goNext));
		var prevButton = new DwtDialog_ButtonDescriptor(ZaXWizardDialog.PREV_BUTTON, AjxMsg._prev, DwtDialog.ALIGN_RIGHT, new AjxCallback(this, this.goPrev));
		var finishButton = new DwtDialog_ButtonDescriptor(ZaXWizardDialog.FINISH_BUTTON, AjxMsg._finish, DwtDialog.ALIGN_RIGHT, new AjxCallback(this, this.finishWizard));
		this._extraButtons = [helpButton,prevButton,nextButton,finishButton];
	}
	this._contextId = contextId? contextId:ZaId.DLG_UNDEF;
    if (w)
        w= this._correntWidth(w);
	ZaXDialog.call(this, parent,className,title, w, h,iKeyName, this._contextId);
	this._pageIx = 1;
	this._currentPage = 1;
}

ZaXWizardDialog.prototype = new ZaXDialog;
ZaXWizardDialog.prototype.constructor = ZaXWizardDialog;

//Z-index contants for the tabbed view contents are based on Dwt z-index constants
ZaXWizardDialog.Z_ACTIVE_PAGE = Dwt.Z_VIEW+10;
ZaXWizardDialog.Z_HIDDEN_PAGE = Dwt.Z_HIDDEN;
ZaXWizardDialog.Z_TAB_PANEL = Dwt.Z_VIEW+20;
ZaXWizardDialog.Z_CURTAIN = Dwt.Z_CURTAIN;

ZaXWizardDialog.NEXT_BUTTON = DwtWizardDialog.NEXT_BUTTON;
ZaXWizardDialog.PREV_BUTTON = DwtWizardDialog.PREV_BUTTON
ZaXWizardDialog.FINISH_BUTTON = DwtWizardDialog.FINISH_BUTTON;
ZaXWizardDialog.HELP_BUTTON = ++DwtDialog.LAST_BUTTON;

//public methods
ZaXWizardDialog.prototype.toString = 
function () {
	return "ZaXWizardDialog";
}
/**
* member of  ZaXWizardDialog
* closes the wizard dialog
**/
ZaXWizardDialog.prototype.popdown = 
function () {
	DwtDialog.prototype.popdown.call(this);
	//clear the newAccountWizard._domains obj
	if (this._domains) {
		this._domains = {} ;
	}
}

ZaXWizardDialog.prototype._correntWidth = function (w) {
    if (this.supportMinimize) {
        if (typeof(w) == "number") {
            return w + 100;
        } else if (typeof(w) == "string") {
            var number = parseInt(w);
            if (!isNaN(number)) {
                number = number + 155;
                w = number + "px";
                return w;
            }
            return w;
        } else {
            return w;
        }
    } else {
        return w;
    }
}

/**
* pageKey is the value returned from {@link ZaXWizardDialog#addPage} method
* This method is called by DwtWizardPage#switchToNextPage
* and DwtWizardPage#switchToPrevPage
* @param pageKey - key to the page to be shown. 
**/
ZaXWizardDialog.prototype.goPage = 
function(pageKey) {
	//reset the domain lists
	EmailAddr_XFormItem.resetDomainLists.call (this);
	//release the focus to make the cursor visible
	this._localXForm.releaseFocus();
	this._localXModel.setInstanceValue(this._containedObject,ZaModel.currentStep, pageKey);
	if(this._localXForm.tabGroupIDs[pageKey])
		this._localXForm.focusFirst(this._localXForm.tabGroupIDs[pageKey]);
	else
		this._localXForm.focusFirst();
    this._localXForm.refresh () ; //some wizard value is not refreshed. See bug28704 comment #11
}

/**
* member of  ZaXWizardDialog
* switches to the next page in the wizard
**/
ZaXWizardDialog.prototype.goNext = 
function() {
	this.goPage(this._containedObject[ZaModel.currentStep]+1);
}

/**
* member of  ZaXWizardDialog
* switches to the previous page in the wizard
**/
ZaXWizardDialog.prototype.goPrev = 
function() {
	this.goPage(this._containedObject[ZaModel.currentStep]-1);
}

/**
* member of  ZaXWizardDialog
* called when "Finish" button is clicked. Calls @see #popdown
**/
ZaXWizardDialog.prototype.finishWizard = 
function() {
	this.popdown();	
}
/**
* member of  ZaXWizardDialog
* @return current step number
**/
ZaXWizardDialog.prototype.getCurrentStep = 
function() {
	return this._containedObject[ZaModel.currentStep];	
}

/**
* member of  ZaXWizardDialog
* @param wizPage - instance of DwtPropertyPage 
* @return the key for the added page. This key can be used to retreive the tab using @link getPage.
**/
ZaXWizardDialog.prototype.addPage =
function (stepTitle) {
	var pageKey = this._pageIx++;	
	return pageKey;
}

/**
* member of  ZaXWizardDialog
* @param xModelMetaData
* @param xFormMetaData
**/
ZaXWizardDialog.prototype.initForm = 
function (xModelMetaData, xFormMetaData,entry) {
	if(xModelMetaData == null || xFormMetaData == null)
		throw new AjxException(ZaMsg.ERROR_METADATA_NOT_DEFINED, AjxException.INVALID_PARAM, "ZaXWizardDialog.prototype.initForm");
		
	this._localXModel = new XModel(xModelMetaData);
	this._localXForm = new XForm(xFormMetaData, this._localXModel, entry, this, ZaId.getDialogViewId(this._contextId)); 
	this._localXForm.setController(ZaApp.getInstance());
	this._localXForm.draw(this._pageDiv);
	this._drawn = true;
}

ZaXWizardDialog.prototype.initForm =
function (xModelMetaData, xFormMetaData,entry) {
	if(xModelMetaData == null || xFormMetaData == null)
		throw new AjxException(ZaMsg.ERROR_METADATA_NOT_DEFINED, AjxException.INVALID_PARAM, "ZaXWizardDialog.prototype.initForm");
	// Hook here. Replace the _OUTPUT_ items
    var newXFormMetaData = {items:[]};
    var stepChoices = xFormMetaData.items[0];
    stepChoices.type = _STEPCHOICE_;
    stepChoices.containerCssClass = "step_container";
    stepChoices.colSpan = 1;
    var content = xFormMetaData.items[3];
    var contentContainerCssClass = content.containerCssClass;
    if (contentContainerCssClass)
        contentContainerCssClass += " step_body_container";
    else
        contentContainerCssClass = "step_body_container";
    content.containerCssClass = contentContainerCssClass;
    newXFormMetaData.tableCssStyle = "width:100%;height:100%";
    newXFormMetaData.numCols = 2;
    newXFormMetaData.colSizes = ["150px", "*"];
    newXFormMetaData.items =[
                stepChoices,
                content
            ];
	this._localXModel = new XModel(xModelMetaData);
	this._localXForm = new XForm(newXFormMetaData, this._localXModel, entry, this, ZaId.getDialogViewId(this._contextId));
	this._localXForm.setController(ZaApp.getInstance());
	this._localXForm.draw(this._pageDiv);
	this._drawn = true;
}
ZaXWizardDialog.prototype.supportMinimize = true;
/**
* member of  ZaXWizardDialog
* @return the object contained in the view
* before returning the object this updates the object attributes with 
* tha values from the form fields 
**/
ZaXWizardDialog.prototype.getObject =
function() {
	return this._containedObject;
}

/**
* member of  ZaXWizardDialog
* sets the object contained in the view
* @param entry - ZaDomain object to display
**/
ZaXWizardDialog.prototype.setObject =
function(entry) {
	this._containedObject = new Object();
	this._containedObject.attrs = new Object();

	for (var a in entry.attrs) {
		this._containedObject.attrs[a] = entry.attrs[a];
	}
	
	this._localXForm.setInstance(this._containedObject.attrs);
}
}
if (AjxPackage.define("zimbraAdmin.common.LDAPURL_XFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* XFormItem class: LDAP URL
* this item is used in the Admin UI to display LDAP URL fields like LDAP URL for GAL Search and LDAP URL  for Authentication
* @class LDAPURL_XFormItem
* @constructor LDAPURL_XFormItem
* @author Greg Solovyev
**/
LDAPURL_XFormItem = function() {}
XFormItemFactory.createItemType("_LDAPURL_", "ldapurl", LDAPURL_XFormItem, Composite_XFormItem);
LDAPURL_XFormItem.prototype.numCols = 5;
LDAPURL_XFormItem.prototype.nowrap = true;
LDAPURL_XFormItem.prototype._protocolPart = "ldap://";
LDAPURL_XFormItem.prototype._serverPart = "";
LDAPURL_XFormItem.prototype._portPart = "389";
LDAPURL_XFormItem.prototype.defSSLPort = "636";
LDAPURL_XFormItem.prototype.defPort = "389";
LDAPURL_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
LDAPURL_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
LDAPURL_XFormItem.prototype.initializeItems = function () {
	var ldapPort = this.getInheritedProperty("ldapPort");
	var ldapSSLPort = this.getInheritedProperty("ldapSSLPort");
	this.defSSLPort = ldapSSLPort ? ldapSSLPort : "636";
    this.defPort = ldapPort ? ldapPort : "389";


    var instance = this.getForm().getInstance () ;
    if (instance && instance [ZaDomain.A2_allowClearTextLDAPAuth] == "FALSE" )  {
        //force SSL  by default
        this._protocolPart = "ldaps://";
	    this._portPart = this.defSSLPort;
    } else {
        this._protocolPart = "ldap://";
        this._portPart = this.defPort ;
    }

	Composite_XFormItem.prototype.initializeItems.call(this);
	
    this.items[0].valueChangeEventSources = [this.getRefPath()];
    this.items[1].valueChangeEventSources = [this.getRefPath()];
    this.items[3].valueChangeEventSources = [this.getRefPath()];
}

LDAPURL_XFormItem.prototype.items = [
	{type:_OUTPUT_, width:"40px", ref:".", labelLocation:_NONE_, label:null,
		getDisplayValue:function(itemVal) {
             var val ;

            if(itemVal!=null && itemVal.length>0) {
                var URLChunks = itemVal.split(/(:\/\/)/);
                if(AjxEnv.isIE) {
                    if(URLChunks[0] == "ldap" || URLChunks[0] == "ldaps")
                        val = URLChunks[0] + "://";
                } else {
                    if(URLChunks.length==3) {
                        val = URLChunks[0] + URLChunks[1];
                    }
                }
                this.getParentItem()._protocolPart = val;
            } else if (this.getParentItem()._protocolPart != null) {
                val =  this.getParentItem()._protocolPart ;
            } else {
                val = "ldap://";
            }
            
            return val;
		}
	},
	{type:_TEXTFIELD_, width:"200px", forceUpdate:true, ref:".", labelLocation:_NONE_, label:null,
		required:true,
	 	visibilityChecks:[],
	 	enableDisableChecks:[],		
		getDisplayValue:function (itemVal) {
			var val = "";
			if(itemVal) {
				var URLChunks = itemVal.split(/[:\/]/);
				if(AjxEnv.isIE) {
				    // bug 68747, IE's split's result length is not fixed, don't use it
				    var urlPortPair = itemVal.substring(7); //trim the prefix "ldap://"
				    var chunks = urlPortPair.split(":");
				    val = chunks[0];
				} else {
					if(URLChunks.length >= 4) {
						val = URLChunks[3];
					} 
				}
				this.getParentItem()._serverPart = val;
			} 
			return val;	
		},
		elementChanged:function(serverPart, instanceValue, event) {
			this.getParentItem()._serverPart = serverPart;
			var val = this.getParentItem()._protocolPart + serverPart+ ":" + this.getParentItem()._portPart;
			this.getForm().itemChanged(this.getParentItem(), val, event);
		}
	},
	{type:_OUTPUT_, width:"5px", labelLocation:_NONE_, label:null,value:":", ref:null},
	{type:_TEXTFIELD_,width:"40px",forceUpdate:true, ref:".", labelLocation:_NONE_, label:null, 
	 	visibilityChecks:[],
	 	enableDisableChecks:[],		
		getDisplayValue:function (itemVal) {
			var val ;
           
            if(itemVal) {
				var URLChunks = itemVal.split(/[:\/]/);
				
				if(AjxEnv.isIE) {
				    // bug 68747, IE's split's result length is not fixed, don't use it
				    var urlPortPair = itemVal.substring(7); //trim the prefix "ldap://"
				    var chunks = urlPortPair.split(":");
				    val = chunks[1];
				} else {
					if(URLChunks.length >= 5) {
						val = URLChunks[4];
					}  
				}
				this.getParentItem()._portPart = val;
			} else if (this.getParentItem()._portPart) {
                val = this.getParentItem()._portPart ;
            } else {
                val = this.getParentItem().defPort;
            }
			return val;	
		},
		elementChanged:function(portPart, instanceValue, event) {
			this.getParentItem()._portPart = portPart;
			var val = this.getParentItem()._protocolPart + this.getParentItem()._serverPart+ ":" + portPart;
			this.getForm().itemChanged(this.getParentItem(), val, event);
		}
	},
	{type:_CHECKBOX_,width:"40px",containerCssStyle:"width:40px", forceUpdate:true, ref:".", labelLocation:_NONE_, label:null, 
		visibilityChecks:[], subLabel:"", align:_RIGHT_,
	 	enableDisableChecks:[],
		getDisplayValue:function (itemVal) {
            var instance = this.getForm().getInstance () ;
            if ((itemVal==null || itemVal.length<=0) //make sure it is a new URL input
                    && (instance [ZaDomain.A2_allowClearTextLDAPAuth] && instance [ZaDomain.A2_allowClearTextLDAPAuth] == "FALSE" )) {
                //check the SSL and define the default SSL URL value
                this.getParentItem()._protocolPart = "ldaps://";
				this.getParentItem()._portPart = this.getParentItem().defSSLPort;
                return true ; //force SSL
            }                                   

            var val = false;
			var protocol = "ldap://";
			if(itemVal!=null && itemVal.length>0) {
				var URLChunks = itemVal.split(/[:\/]/);
				protocol = URLChunks[0] + "://";				
			}
			this.getParentItem()._protocolPart = protocol;
			if(protocol.length==8) {
				val = true;                           
			}
			return val;			
		},
		elementChanged:function(isChecked, instanceValue, event) {
			if(isChecked) {
				this.getParentItem()._protocolPart = "ldaps://";
				this.getParentItem()._portPart = this.getParentItem().defSSLPort;
			} else {
				this.getParentItem()._protocolPart = "ldap://";
				this.getParentItem()._portPart = this.getParentItem().defPort;
			}
			var val = this.getParentItem()._protocolPart + this.getParentItem()._serverPart+ ":" + this.getParentItem()._portPart;
			this.getForm().itemChanged(this.getParentItem(), val, event);
		}
	}
];

}
if (AjxPackage.define("zimbraAdmin.common.HostPort_XFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* XFormItem class: HOST PORT
* this item is used in the Admin UI to display Host name fields like Relay MTA host
* @class HostPort_XFormItem
* @constructor HostPort_XFormItem
* @author Greg Solovyev
**/
HostPort_XFormItem = function() {}
XFormItemFactory.createItemType("_HOSTPORT_", "hostport", HostPort_XFormItem, Composite_XFormItem);
HostPort_XFormItem.prototype.numCols = 3;
HostPort_XFormItem.prototype.nowrap = true;
HostPort_XFormItem.prototype._serverPart = "";
HostPort_XFormItem.prototype._portPart = "";

HostPort_XFormItem.prototype.items = [
	{type:_TEXTFIELD_, width:"200px", forceUpdate:true, ref:".", labelLocation:_NONE_, label:null,
		visibilityChecks:[],enableDisableChecks:[],
		required:true,
		getDisplayValue:function (itemVal) {
			var val = "";
			if(itemVal) {
				var URLChunks = itemVal.split(":");
				if(URLChunks.length >= 2) {
					val = URLChunks[0];
				} else {
					val = itemVal;
				}
				this.getParentItem()._serverPart = val;
			} 
			return val;	
		},
		elementChanged:function(serverPart, instanceValue, event) {
			this.getParentItem()._serverPart = serverPart;
			var val = "";
			if(serverPart) {
				val = serverPart;
			}
			if(this.getParentItem()._portPart) {
				val += ":";
				val += this.getParentItem()._portPart;				
			}
			this.getForm().itemChanged(this.getParentItem(), val, event);
		},
		onClick: "Super_HostPort_XFormItem.handleClick",
		onMouseout: "Super_HostPort_XFormItem.handleMouseout"
	},
	{type:_OUTPUT_, width:"5px", labelLocation:_NONE_, label:null,value:":"},
	{type:_TEXTFIELD_,width:"40px",forceUpdate:true, ref:".", labelLocation:_NONE_, label:null,
		visibilityChecks:[],enableDisableChecks:[],
		getDisplayValue:function (itemVal) {
			var val = "";
			if(itemVal) {
				var URLChunks = itemVal.split(":");
				if(URLChunks.length == 2) {
					val = URLChunks[1];
				} else {
					val = "";
				}
				this.getParentItem()._portPart = val;
			} 
			return val;	
		},
		elementChanged:function(portPart, instanceValue, event) {
			this.getParentItem()._portPart = portPart;
			var val = "";
			if(this.getParentItem()._serverPart) {
				val = this.getParentItem()._serverPart;
			}
			if(portPart) {
				val +=":";
				val+=portPart;
			}
			this.getForm().itemChanged(this.getParentItem(), val, event);
		}
	}
];
}
if (AjxPackage.define("zimbraAdmin.common.MailQuota_XModelItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* XModelItem class
*
* @class MailQuota_XModelItem
* @constructor MailQuota_XModelItem
* @author Greg Solovyev
**/
MailQuota_XModelItem = function (){}
XModelItemFactory.createItemType("_MAILQUOTA_", "mailquota", MailQuota_XModelItem);
MailQuota_XModelItem.prototype.validateType = XModelItem.prototype.validateNumber;
MailQuota_XModelItem.prototype.getterScope = _MODELITEM_;
MailQuota_XModelItem.prototype.setterScope = _MODELITEM_;
MailQuota_XModelItem.prototype.getter = "getValue";
MailQuota_XModelItem.prototype.setter = "setValue";
MailQuota_XModelItem.prototype.maxInclusive = 8796093022207;
MailQuota_XModelItem.prototype.minInclusive = 0;

MailQuota_XModelItem.prototype.getValue =  function(ins, current, ref) {
	var value = null;
	if(eval("ins." + ref) != null) {
	  value = eval("ins." + ref) / 1048576;
	  if(value != Math.round(value)) {
		 value = Number(value).toFixed(2);
	  }
	}
	if(typeof value == "number" && value == 0)
		value = "0";	
	return value;
}

MailQuota_XModelItem.prototype.setValue = function(value, instance, current, ref) {
	var pathParts = new Array();
	var val = Math.round(value * 1048576);
	if(ref.indexOf(".") >= 0) {
		pathParts = ref.split(".");
	} else if (ref.indexOf("/") >=0) {
		pathParts = ref.split("/");
	} else {
		instance[ref] = val
		return val;
	}
	var cnt = pathParts.length-1;
	var obj = instance[pathParts[0]];
	for(var ix=1; ix<cnt; ix++) {
		obj = obj[pathParts[ix]];
	}
	obj[pathParts[cnt]] = val;
	return val;
}

/**
* _MAILQUOTA_2_ XModel item type
**/
MailQuota2_XModelItem = function (){}
XModelItemFactory.createItemType("_MAILQUOTA_2_", "mailquota_2", MailQuota2_XModelItem);
MailQuota2_XModelItem.prototype.getterScope = _MODELITEM_;
MailQuota2_XModelItem.prototype.getter = "getValue";

MailQuota2_XModelItem.prototype.getValue = function(instance, current, ref) {
	var value = this.getLocalValue(instance, current, ref);
	if (value == null) value = this.getSuperValue(instance, current, ref);
	if(value <=0) 
		value = ZaMsg.Unlimited;
	return value;
}

MailQuota2_XModelItem.prototype.getSuperValue = function(ins, current, ref) {
	if (!ins) { return null; }
	var _ref  = ref  ? ref.replace("/", ".") : this.ref.replace("/", ".");
//	var _ref = this.ref.replace("/", ".");
	var value = (eval("ins._defaultValues." + _ref) != null) ? Number(eval("ins._defaultValues." + _ref) / 1048576).toFixed(0) : 0;
	return value;
}
MailQuota2_XModelItem.prototype.getLocalValue = function(ins, current, ref) {
	if (!ins) { return null; }
	var _ref  = ref  ? ref.replace("/", ".") : this.ref.replace("/", ".");
//	var _ref = this.ref.replace("/", ".");
	var value = (eval("ins." + _ref) != null) ? Number(eval("ins." + _ref) / 1048576).toFixed(0) : null;
	return value;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaSelectRadioXFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2010, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2010, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
*	_ZASELECT_RADIO_ form item type
**/
ZaSelectRadio_XFormItem = function () {}
XFormItemFactory.createItemType("_ZASELECT_RADIO_", "zaselect_radio", ZaSelectRadio_XFormItem, Composite_XFormItem);
ZaSelectRadio_XFormItem.prototype.numCols=2;
ZaSelectRadio_XFormItem.prototype.colSizes=["275px","275px"];
ZaSelectRadio_XFormItem.prototype.nowrap = false;
ZaSelectRadio_XFormItem.prototype.labelWrap = true;
ZaSelectRadio_XFormItem.prototype.items = [];
ZaSelectRadio_XFormItem.prototype.labelWidth = "275px";

ZaSelectRadio_XFormItem.prototype.initializeItems = function() {
	var selectRef = this.getInheritedProperty("selectRef");
	var radioBoxLabel1 = this.getInheritedProperty("radioBoxLabel1");
	var radioBoxLabel2 = this.getInheritedProperty("radioBoxLabel2");
	var choices = this.getInheritedProperty("choices");	

	var radioBox1 = {type:_RADIO_, groupname:this.id+"zimlet_select_check_grp"+selectRef,ref:".",
		label:radioBoxLabel1, labelLocation:_RIGHT_,
		elementChanged:function(elementValue,instanceValue, event) {
			if(elementValue==true) {
				this.getForm().itemChanged(this.getParentItem(), null, event);	
			}
		},
		updateElement:function(value) {
			this.getElement().checked = !value;
		}
		
	};
	
	var radioBox2 = {type:_RADIO_, groupname:this.id+"zimlet_select_check_grp"+selectRef,ref:".",
		label:radioBoxLabel2, labelLocation:_RIGHT_ ,
		updateElement:function(value) {
			this.getElement().checked = value;
		},
		elementChanged:function(elementValue,instanceValue, event) {

		}
	};
		
	var selectChck = {
		type:_OSELECT_CHECK_,
		choices:choices,
		colSpan:3,
		ref:selectRef,
		width:"275px",
		onChange:function (value, event, form) {
			if (this.getParentItem() && this.getParentItem().getParentItem() && this.getParentItem().getParentItem().getOnChangeMethod()) {
				return this.getParentItem().getParentItem().getOnChangeMethod().call(this, value, event, form);
			} else {
				return this.setInstanceValue(value);
			}
		},
		forceUpdate:true,
		updateElement:function(value) {
			OSelect_XFormItem.prototype.updateElement.call(this, value);
		},
		cssStyle:"margin-bottom:5px;margin-top:5px;border:2px inset gray;"				
	};
	
	var selectChckGrp = {
		type:_GROUP_,
		numCols:3,
		colSizes:["130px","15px","130px"],
		items:[
			selectChck,
			{type:_DWT_BUTTON_,label:ZaMsg.SelectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.selectAll(ev);
					}
				}
			},
			{type:_CELLSPACER_,width:"15px"},
			{type:_DWT_BUTTON_,label:ZaMsg.DeselectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.deselectAll(ev);
					}
				}
			}
		]
		
	}
		
	this.items = [radioBox1,radioBox2,{type:_CELLSPACER_,width:this.labelWidth},selectChckGrp];
	
	
	Composite_XFormItem.prototype.initializeItems.call(this);
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaSelectMultipleCheckboxXFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2023 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2023 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
*	_ZASELECT_MULTIPLE_CHECKBOX_ form item type
**/
ZaSelectMultipleCheckbox_XFormItem = function () {}
XFormItemFactory.createItemType("_ZASELECT_MULTIPLE_CHECKBOX_", "zaselect_multiple_checkbox", ZaSelectMultipleCheckbox_XFormItem, Composite_XFormItem);
ZaSelectMultipleCheckbox_XFormItem.prototype.numCols=3;
ZaSelectMultipleCheckbox_XFormItem.prototype.colSpan=3;
ZaSelectMultipleCheckbox_XFormItem.prototype.colSizes=["275px","225px", "*"];
ZaSelectMultipleCheckbox_XFormItem.prototype.nowrap = false;
ZaSelectMultipleCheckbox_XFormItem.prototype.labelWrap = true;
ZaSelectMultipleCheckbox_XFormItem.prototype.items = [];
ZaSelectMultipleCheckbox_XFormItem.prototype.labelWidth = "275px";
ZaSelectMultipleCheckbox_XFormItem.prototype.labelCssStyle = "";
ZaSelectMultipleCheckbox_XFormItem.prototype.labelCssClass = "gridGroupBodyLabel xform_multiple_checkbox";
ZaSelectMultipleCheckbox_XFormItem.prototype.tableCssClass = "grid_composite_table";
ZaSelectMultipleCheckbox_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
ZaSelectMultipleCheckbox_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];

ZaSelectWiz_MultipleCheckbox_XFormItem = function () {}
XFormItemFactory.createItemType("_ZASELECT_WIZ_MULTIPLE_CHECKBOX_", "zaselect_wiz_multiple_checkbox", ZaSelectWiz_MultipleCheckbox_XFormItem, ZaSelectMultipleCheckbox_XFormItem);
ZaSelectWiz_MultipleCheckbox_XFormItem.prototype.colSizes = ["200px","300px","150px"];
ZaSelectWiz_MultipleCheckbox_XFormItem.prototype.labelCssStyle = "";
ZaSelectWiz_MultipleCheckbox_XFormItem.prototype.labelCssClass = "";
ZaSelectWiz_MultipleCheckbox_XFormItem.prototype.checkBoxLabelLocation = _RIGHT_;
ZaSelectWiz_MultipleCheckbox_XFormItem.prototype.checkboxSubLabel = "";
ZaSelectWiz_MultipleCheckbox_XFormItem.prototype.checkboxAlign = _RIGHT_;

ZaSelectMultipleCheckbox_XFormItem.prototype.initializeItems = function() {
	var choices = this.getInheritedProperty("choices");
	var label = this.getInheritedProperty("groupLabel");

	var selectChck = {
		type: _OSELECT_CHECK_,
		choices: choices,
		ref: ".",
		width: "275px",
		onChange: function(value, event, form) {
			if (this.getParentItem() && this.getParentItem().getParentItem() && this.getParentItem().getParentItem().getOnChangeMethod()) {
				return this.getParentItem().getParentItem().getOnChangeMethod().call(this, value, event, form);
			} else {
				return this.setInstanceValue(value);
			}
		},
		forceUpdate: true,
		updateElement: function(value) {
			if (!(value instanceof Array)) {
				value = [value];
			}
			OSelect_XFormItem.prototype.updateElement.call(this, value);
		},
		cssStyle: "border:none;"
	};

	var selectChckGrp = {
		type: _GROUP_,
		ref: ".",
		items: [selectChck]
	};

	selectChckGrp.label = label;
	selectChckGrp.labelCssClass = this.getInheritedProperty("labelCssClass");
	selectChckGrp.labelCssStyle = this.getInheritedProperty("labelCssStyle");
	selectChckGrp.cssClass = "";

	this.items = [selectChckGrp];

	Composite_XFormItem.prototype.initializeItems.call(this);

	// replace class name and functions defined in OSelect_Check_XFormItem
	this.containerCssClass = "xform_container";
	this.items[0].items[0].cssClass = this.containerCssClass;
	this.items[0].items[0].getChoiceSelectedCssClass = this.__getChoiceSelectedCssClass;
	this.items[0].items[0].getChoiceCssClass = this.__getChoiceCssClass;
	this.items[0].items[0].getChoiceHTML = this.__getChoiceHTML;
	this.items[0].items[0].setElementEnabled = this.__setElementEnabled;

	this.items[0].items[0].onChoiceOverOriginal = this.items[0].items[0].onChoiceOver;
	this.items[0].items[0].onChoiceOver = this.__onChoiceOver;

	this.items[0].items[0].onChoiceOutOriginal = this.items[0].items[0].onChoiceOut;
	this.items[0].items[0].onChoiceOut = this.__onChoiceOut;

	this.items[0].items[0].onChoiceClickOriginal = this.items[0].items[0].onChoiceClick;
	this.items[0].items[0].onChoiceClick = this.__onChoiceClick;

	this.items[0].items[0].onChoiceDoubleClickOriginal = this.items[0].items[0].onChoiceDoubleClick;
	this.items[0].items[0].onChoiceDoubleClick = this.__onChoiceDoubleClick;
};

// functions to replace the ones defined in OSelect_Check_XFormItem
ZaSelectMultipleCheckbox_XFormItem.prototype.__getChoiceSelectedCssClass =
function() {
	return this.containerCssClass;
};

ZaSelectMultipleCheckbox_XFormItem.prototype.__getChoiceCssClass =
function() {
	return this.containerCssClass;
};

ZaSelectMultipleCheckbox_XFormItem.prototype.__getChoiceHTML =
function(itemNum, value, label, cssClass) {
	var ref = this.getFormGlobalRef() + ".getItemById('"+ this.getId()+ "')";
	var id = this.getId();
	return AjxBuffer.concat(
		"<tr><td class=", cssClass,
			" onmouseover=\"" + ref + ".onChoiceOver(" + itemNum + ", event||window.event)\"",
			" onmouseout=\"" + ref +  ".onChoiceOut(" + itemNum + ", event||window.event)\"",
			" onclick=\"" + ref + ".onChoiceClick(" + itemNum + ", event||window.event)\"",
			" ondblclick=\"" + ref + ".onChoiceDoubleClick(" + itemNum + ", event||window.event)\"",
		">",
		"<table cellspacing=0 cellpadding=0><tr><td><input type=checkbox id='",id,"_choiceitem_",itemNum,"'></td><td>",
		        "<font id=", id, "_label_", itemNum, ">", AjxStringUtil.htmlEncode(label), "</font>",
		"</td></tr></table></td></tr>"
	);
};

ZaSelectMultipleCheckbox_XFormItem.prototype.__setElementEnabled =
function(enabled) {
	var choices = this.getNormalizedChoices();
	if (!choices) {
		return;
	}
	var values = choices.values;
	if (!values) {
		return;
	}
	var cnt = values.length;
	for (var i = 0; i < cnt; i++) {
		var chkbx = this.getElement(this.getId() + "_choiceitem_" + i);
		var label = this.getElement(this.getId() + "_label_" + i);
		if (chkbx) {
			if (enabled) {
				chkbx.className = this.getChoiceCssClass();
				chkbx.disabled = false;
				label.style.color ="";
			} else {
				chkbx.className = this.getChoiceCssClass() + "_disabled";
				chkbx.disabled = true;
				label.style.color ="#808080";
			}
		}
	}
};

ZaSelectMultipleCheckbox_XFormItem.prototype.__onChoiceOver =
function(itemNum) {
	if (this.getIsEnabled()) {
		this.onChoiceOverOriginal(itemNum);
	}
};

ZaSelectMultipleCheckbox_XFormItem.prototype.__onChoiceOut =
function(itemNum) {
	if (this.getIsEnabled()) {
		this.onChoiceOutOriginal(itemNum);
	}
};

ZaSelectMultipleCheckbox_XFormItem.prototype.__onChoiceClick =
function(itemNum, event) {
	if (this.getIsEnabled()) {
		this.onChoiceClickOriginal(itemNum, event);
	}
};

ZaSelectMultipleCheckbox_XFormItem.prototype.__onChoiceDoubleClick =
function(itemNum, event) {
	// address double click as a single click
	if (this.getIsEnabled()) {
		this.onChoiceClickOriginal(itemNum, event);
	}
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaZimletSelectXFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2010, 2011, 2012, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2010, 2011, 2012, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
*	_ZA_ZIMLET_SELECT_ form item type
**/
ZaZimletSelect_XFormItem = function() {}
XFormItemFactory.createItemType("_ZA_ZIMLET_SELECT_", "za_zimlet_select", ZaZimletSelect_XFormItem, OSelect_Check_XFormItem)
ZaZimletSelect_XFormItem.prototype.initializeItems = function() {
    ZaZimletSelect_XFormItem.prototype.choicePrefixes=[
	{value:"!",label:ZaMsg.mandatory},
	{value:"-",label:ZaMsg.disabled},
	{value:"+",label:ZaMsg.enabled}
    ];
    OSelect_Check_XFormItem.prototype.initializeItems.call(this);     
}

ZaZimletSelect_XFormItem.prototype.onSubChoiceClick = function (itemNum, event, prefix) {
	event = event || window.event;
	this.subChoiceSelected(itemNum, event, prefix);
};

ZaZimletSelect_XFormItem.prototype.onSubChoiceDoubleClick = function (itemNum, event, prefix) {
	this.subChoiceSelected(itemNum, true, event, prefix);
}

ZaZimletSelect_XFormItem.prototype.subChoiceSelected = function (itemNum, event, prefix) {
	var value = this.getNormalizedValues()[itemNum];
	this.setPrefix(value, event, prefix);
}


ZaZimletSelect_XFormItem.prototype.getPrefixIndex = function (prefixValue) {
	if(!this._prefixIndexes) {
		this._prefixIndexes = {};
		var prefixes = this.getInheritedProperty("choicePrefixes");
		var cnt=prefixes.length;
		for(var i=0; i<cnt; i++) {
			this._prefixIndexes[prefixes[i].value] = i;
		} 
	}
	return this._prefixIndexes[prefixValue];	
}

ZaZimletSelect_XFormItem.prototype.getNormalizedInstanceValue = function () {
	var value = this.getInstanceValue();
	var normalizedValue = new Array();
	//make sure the returned value is a copy of the actual value
	if(typeof value == "string") {
		normalizedValue = new String(value);
	} else if(typeof value =="object" || value instanceof Array) {
		for(var a in value) {
			normalizedValue[a] = value[a];
		}
	}
	//make sure the returned value is an array
	if(normalizedValue) {
		if (normalizedValue instanceof String) {
			if (normalizedValue == "") 	
				normalizedValue = [];
			else
				normalizedValue = normalizedValue.split(",");
		}
	} 	
	
	//remove prefixes	
	var prefixes = this.getInheritedProperty("choicePrefixes");
	var numPrefixes = prefixes.length;
	var numValues = normalizedValue.length;
	for(var i=0;i<numValues;i++) {
		var hasPrefix=false;
		for(var j=0; j<numPrefixes;j++) {
			if(normalizedValue[i].substr(0,1)==prefixes[j].value) {
				normalizedValue[i] = {value:normalizedValue[i].substr(1),prefix:normalizedValue[i].substr(0,1)};
				hasPrefix=true;
				break;
			}
		}
		if(!hasPrefix) {
			normalizedValue[i] = {value:normalizedValue[i],prefix:""};
		}
	}
	return normalizedValue;	
}

ZaZimletSelect_XFormItem.prototype.setPrefix = function (newValue, event, prefix) {
	var normalizedValues = this.getNormalizedInstanceValue();
	var newValues = [];		
	var found = false;
	for (var i = 0; i < normalizedValues.length; i++) {
		if (normalizedValues[i].value == newValue) {
			normalizedValues[i].prefix = prefix;		
		}
		newValues.push([normalizedValues[i].prefix,normalizedValues[i].value].join(""));
	}
			
	if(!newValues || (newValues.length == 1 && newValues[0] == "")) {
		newValues = [];
	} 
	
	
	// if we have a modelItem which is a LIST type
	//	convert the output to the propert outputType
	var modelItem = this.getModelItem();
	if (modelItem && modelItem.getOutputType) {
		if (modelItem.getOutputType() == _STRING_) {
			newValues = newValues.join(modelItem.getItemDelimiter());
		}
	} else {
		// otherwise assume we should convert it to a comma-separated string
		newValues = newValues.join(",");
	}

	this.getForm().itemChanged(this, newValues, event);
}

ZaZimletSelect_XFormItem.prototype.setValue = function (newValue, clearOldValues, includeIntermediates, event) {
	var normalizedValues = this.getNormalizedInstanceValue();
	var newValues = [];		
	var found = false;
	var i;
	if(newValue instanceof Array || typeof newValue == "object") {
		for(a in newValue) {
			if(typeof newValue[a] == "string" && newValue[a].substr(0,1) != "+" && newValue[a].substr(0,1) != "-") {
				var prefix = "+";
				for (i = 0; i < normalizedValues.length; i++) {
					if (normalizedValues[i].value == newValue[a] && normalizedValues[i].prefix) {
						prefix = normalizedValues[i].prefix;
						normalizedValues.splice(i,1);
						break;					
					}
				}
				newValue[a] = prefix+newValue[a];
			}
			newValues.push(newValue[a]);
		}
	} else {
		for (i = 0; i < normalizedValues.length; i++) {
			if (normalizedValues[i].value == newValue) {
				found = true;
				break;					
			}
		}		
	
		if (found) {
			normalizedValues.splice(i, 1);
		} else {
			normalizedValues.push({value:newValue,prefix:"+"});
		}
	
		for (i = 0; i < normalizedValues.length; i++) {
			newValues.push(normalizedValues[i].prefix+normalizedValues[i].value);
		}
	}
		
	if(!newValues || (newValues.length == 1 && newValues[0] == "")) {
		newValues = []
	} 
	// if we have a modelItem which is a LIST type
	//	convert the output to the propert outputType
	var modelItem = this.getModelItem();
	if (modelItem && modelItem.getOutputType) {
		if (modelItem.getOutputType() == _STRING_) {
			newValues = newValues.join(modelItem.getItemDelimiter());
		}
	} else {
		// otherwise assume we should convert it to a comma-separated string
		newValues = newValues.join(",");
	}

	this.getForm().itemChanged(this, newValues, event);
}

ZaZimletSelect_XFormItem.prototype.getChoiceHTML = function (itemNum, value, label, cssClass) {
	var prefixes = this.getInheritedProperty("choicePrefixes");
	
	var ref = this.getFormGlobalRef() + ".getItemById('"+ this.getId()+ "')";
	var id = this.getId();
	var retVal = ["<tr><td class=", cssClass," onmouseover=\"", ref, ".showToolTip('", value, "',event||window.event)\",",
			      " onmouseout=\"",ref, ".hideToolTip(event||window.event)\">", label, "</td><td class=", cssClass, 
			      " onclick=\"",ref, ".onChoiceClick(", itemNum,", event||window.event)\"",
			      " ondblclick=\"",ref, ".onChoiceDoubleClick(", itemNum,", event||window.event)\" id='",id,"_choice_",itemNum,"'>",
				"<table cellspacing=0 cellpadding=0><tr><td><input type=checkbox id='",id,"_choiceitem_",itemNum,"'></td><td>",
				ZaMsg.Available,
				"</td></tr></table></td>"];
	for(var i=0; i<prefixes.length; i++) {
		retVal.push("<td class=",cssClass,
				" onclick=\"",ref, ".onSubChoiceClick(", itemNum, ", event||window.event, '",prefixes[i].value,"')\"",
				" ondblclick=\"",ref, ".onSubChoiceDoubleClick(", itemNum, ", event||window.event, '",prefixes[i].value,"')\" id='",id,"_choice_",itemNum,"_prefix_",i,"'>",
					"<table cellspacing=0 cellpadding=0><tr><td><input type=radio autocomplete='off' id='",id,"_radiochoiceitem_",itemNum,"_prefix_",i,"' name='zazimletselect_",id,"_radiogrp_",itemNum,"'></td><td>",
				prefixes[i].label,
				"</td></tr></table></td>");
	}
	retVal.push("</tr>");
	return retVal.join("");
}

ZaZimletSelect_XFormItem.prototype.showToolTip = function(zimletName, event) {
	var zimlet = ZaZimlet.zimlets[zimletName];
	var desc;
	if (!zimlet) {
		desc = "Unknown Zimlet";
	} else {
		// convert description variable to the readable text
		desc = ZaZimletListView.__processMessage(zimletName, zimlet.attrs[ZaZimlet.A_zimbraZimletDescription ]);
		if (desc.slice(0, 2) == "${") { // the zimlet main js is not yet loaded
			desc = ZaMsg.Zimlet_Description_Loading;
		}
	}
	var dwtEv = new DwtUiEvent(true);
	dwtEv.setFromDhtmlEvent(event);
	var shell = DwtShell.getShell(window);
	var tooltip = shell.getToolTip();
	var html = new Array(20);
	var idx = 0;
	html[idx++] = "<table cellpadding='0' cellspacing='0' border='0'>";
	html[idx++] = "<tr valign='center'><td colspan='2' align='left'>";
	html[idx++] = "<div style='white-space:nowrap; overflow:hidden;width:350'>";
	html[idx++] = "<table cellpadding='0' cellspacing='0' border='0' style='width:100%;'>";
	html[idx++] = "<tr valign='center' >";
	html[idx++] = "<td><b>" + AjxStringUtil.htmlEncode(zimletName) + "</b></td>";
	html[idx++] = "<td align='right'></td></tr>";
	html[idx++] = "<tr><td><hr style='border:none;border-top:1px solid black;height:0'></td><tr>";
	html[idx++] = "<tr><td>" + AjxStringUtil.htmlEncode(desc) + "</td></tr>";
	html[idx++] = "</table>"
	html[idx++] = "</div></td></tr>";
	html[idx++] = "</table>";
	tooltip.setContent(html.join(""));
	tooltip.popup(dwtEv.docX, dwtEv.docY, null, true);
}

ZaZimletSelect_XFormItem.prototype.hideToolTip = function(event) {
	var shell = DwtShell.getShell(window);
	var tooltip = shell.getToolTip();
	tooltip.popdown();
}

ZaZimletSelect_XFormItem.prototype.hiliteChoice = function (itemNum) {
	var chEl = this.getChoiceElements(itemNum);
	if(chEl) {
		var el = chEl[1]; // now the checkbox table is in the 2nd <td>
		el.className = this.getChoiceSelectedCssClass();
	
		var checks = el.getElementsByTagName("input");
		if (checks) {
			checks[0].checked = true;
			this.enableSubChoice(itemNum);
		}
	}
}

ZaZimletSelect_XFormItem.prototype.dehiliteChoice = function(itemNum) {
	var chEl = this.getChoiceElements(itemNum);
	if(chEl) {
		var el = chEl[1]; // now the checkbox table is in the 2nd <td>
		el.className = this.getChoiceCssClass();

		var checks = el.getElementsByTagName("input");
		if (checks) {
			checks[0].checked = false;
			this.disableSubChoice(itemNum);
		}
	}
}

ZaZimletSelect_XFormItem.prototype.hiliteSubChoice = function (itemNum, prefixIndex) {
	var id = [this.getId(),"_choice_",itemNum,"_prefix_",prefixIndex].join("");
	var chEl = this.getElement(id);
	if(chEl) {
		chEl.className = this.getChoiceSelectedCssClass();

		var checks = chEl.getElementsByTagName("input");
		if (checks) {
			checks[0].checked = true;
		}
	}
}

ZaZimletSelect_XFormItem.prototype.dehiliteSubChoice = function(itemNum, prefixIndex) {
	var id = [this.getId(),"_choice_",itemNum,"_prefix_",prefixIndex].join("");
	var chEl = this.getElement(id);
	if(chEl) {
		chEl.className = this.getChoiceCssClass();

		var checks = chEl.getElementsByTagName("input");
		if (checks) {
			checks[0].checked = false;
		}
	}
}

ZaZimletSelect_XFormItem.prototype.disableSubChoice = function (itemNum) {
	var prefixes = this.getInheritedProperty("choicePrefixes");
	for(var i=0; i<prefixes.length; i++) {
		var id = [this.getId(),"_choice_",itemNum,"_prefix_",i].join("");
		var chEl = this.getElement(id);
		if(chEl) {
			chEl.className = this.getChoiceCssClass() + "_disabled";

			var radios = chEl.getElementsByTagName("input");
			if (radios) {
				radios[0].disabled = true;
			}
		}
	}	
}

ZaZimletSelect_XFormItem.prototype.enableSubChoice = function (itemNum) {
	var prefixes = this.getInheritedProperty("choicePrefixes");
	for(var i=0; i<prefixes.length; i++) {
		var id = [this.getId(),"_choice_",itemNum,"_prefix_",i].join("");
		var chEl = this.getElement(id);
		if(chEl) {
			chEl.className = this.getChoiceCssClass();

			var radios = chEl.getElementsByTagName("input");
			if (radios) {
				radios[0].disabled = false;
			}
		}
	}
}


ZaZimletSelect_XFormItem.prototype.updateElement = function () {
	var element = this.getElement();
	
	element.innerHTML = this.getChoicesHTML();
	var normalizedValues = this.getNormalizedInstanceValue();
	this.clearAllHilites();
	if (normalizedValues) {	
		for (var i = 0; i < normalizedValues.length; i++) {
			var itemNum = this.getChoiceNum(normalizedValues[i].value);
			if (itemNum != -1) { 
				this.hiliteChoice(itemNum);
				if(normalizedValues[i].prefix != "") {
					this.hiliteSubChoice(itemNum,this.getPrefixIndex(normalizedValues[i].prefix));
				}
			} 
		}
	}
    this.updateEnabledDisabled();
}


ZaZimletSelect_XFormItem.prototype.setElementEnabled = function (enabled) {
	var choices = this.getNormalizedChoices();
	if(!choices)
		return;
	
	var values = choices.values;
	if(!values)
		return;
		
	var cnt = values.length;
	var prefixes = this.getInheritedProperty("choicePrefixes");
	var numPrefixes = prefixes.length;
			
	for(var i=0; i < cnt; i ++) {
		var chkbx = this.getElement([this.getId(),"_choiceitem_",i].join(""));
		var chkBoxTD = this.getElement([this.getId(),"_choice_",i].join(""));
		if(chkbx) {
			if(enabled) {
				chkBoxTD.className = this.getChoiceCssClass();
				chkbx.className = this.getChoiceCssClass();
				chkbx.disabled = false;
			} else {
				chkBoxTD.className = this.getChoiceCssClass() + "_disabled";
				chkbx.className = this.getChoiceCssClass() + "_disabled";
				chkbx.disabled = true;
				for(var j=0; j<numPrefixes; j++) {
					var id = [this.getId(),"_radiochoiceitem_",i,"_prefix_",j].join("");
					var TDid = [this.getId(),"_choice_",i,"_prefix_",j].join("");
					var radio = this.getElement(id);
					var tdEl = this.getElement(TDid);
					tdEl.className = this.getChoiceCssClass() + "_disabled";
					chkbx.className = this.getChoiceCssClass() + "_disabled";
					chkbx.disabled = true;					
				}				
			}
		} 
	}
};


/**
*	_ZA_ZIMLET_SELECT_COMBO_ form item type
**/
ZaZimletSelectCombo_XFormItem = function () {}
XFormItemFactory.createItemType("_ZA_ZIMLET_SELECT_COMBO_", "za_zimlet_select_combo", ZaZimletSelectCombo_XFormItem, Composite_XFormItem);
ZaZimletSelectCombo_XFormItem.prototype.numCols=1;
ZaZimletSelectCombo_XFormItem.prototype.colSizes=["*"];
ZaZimletSelectCombo_XFormItem.prototype.nowrap = false;
ZaZimletSelectCombo_XFormItem.prototype.labelWrap = true;
ZaZimletSelectCombo_XFormItem.prototype.items = [];

ZaZimletSelectCombo_XFormItem.prototype.initializeItems = function() {
	var selectRef = this.getInheritedProperty("selectRef");
	var choices = this.getInheritedProperty("choices");	
	var selectLabel = this.getInheritedProperty("selectLabel");
	var selectLabelLocation = this.getInheritedProperty("selectLabelLocation");
    var choicesWidth = this.getInheritedProperty ("choicesWidth") || "500px" ;
    
    var selectChck = {
		type:_ZA_ZIMLET_SELECT_,
		choices:choices,
		colSpan:4,
		ref:selectRef,
		label:selectLabel,
		labelLocation:selectLabelLocation,
		width:choicesWidth,
		bmolsnr:true,
		cssStyle:"margin-bottom:5px;margin-top:5px;border:2px inset gray;"				
	};
	
	var selectChckGrp = {
		type:_GROUP_,
		numCols:4,
		colSizes:["130px","5px","130px","*"],
		items:[
			selectChck,
			{type:_DWT_BUTTON_,label:ZaMsg.SelectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.selectAll(ev);
					}
				}
			},
			{type:_CELLSPACER_,width:"5px"},
			{type:_DWT_BUTTON_,label:ZaMsg.DeselectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.deselectAll(ev);
					}
				}
			},
			{type:_CELLSPACER_,width:"235px"}
		]
		
	}
		
	this.items = [selectChckGrp];
	
	
	Composite_XFormItem.prototype.initializeItems.call(this);
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaCheckBoxListXFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2010, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2010, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
*	_ZA_CHECKBOX_LIST_ form item type
**/
ZaCheckBox_List_XFormItem = function () {}
XFormItemFactory.createItemType("_ZA_CHECKBOX_LIST_", "za_checkbox_list", ZaCheckBox_List_XFormItem, Composite_XFormItem);
ZaCheckBox_List_XFormItem.prototype.numCols=2;
ZaCheckBox_List_XFormItem.prototype.colSizes=["275px","275px"];
ZaCheckBox_List_XFormItem.prototype.nowrap = false;
ZaCheckBox_List_XFormItem.prototype.labelWrap = true;
ZaCheckBox_List_XFormItem.prototype.items = [];
ZaCheckBox_List_XFormItem.prototype.labelWidth = "275px";
ZaCheckBox_List_XFormItem.prototype.choicesWidth = "275px";

ZaCheckBox_List_XFormItem.prototype.initializeItems = function() {
	var selectRef = this.getInheritedProperty("selectRef");
	var choices = this.getInheritedProperty("choices");	
	var selectLabel = this.getInheritedProperty("selectLabel");
    var choicesWidth = AjxEnv.isIE? "275px": (this.getInheritedProperty ("choicesWidth") || "275px") ;
    
    var selectChck = {
		type:_OSELECT_CHECK_,
		choices:choices,
		colSpan:3,
		ref:selectRef,
		label:selectLabel,
		labelLocation:_TOP_,
		width:choicesWidth,
		bmolsnr:true,
		cssStyle:"margin-bottom:5px;margin-top:5px;border:2px inset gray;"				
	};
	
	var selectChckGrp = {
		type:_GROUP_,
		numCols:3,
		colSizes:["130px","15px","130px"],
		items:[
			selectChck,
			{type:_DWT_BUTTON_,label:ZaMsg.SelectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.selectAll(ev);
					}
				}
			},
			{type:_CELLSPACER_,width:"15px"},
			{type:_DWT_BUTTON_,label:ZaMsg.DeselectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.deselectAll(ev);
					}
				}
			}
		]
		
	}
		
	this.items = [{type:_CELLSPACER_,width:this.labelWidth},selectChckGrp];
	
	
	Composite_XFormItem.prototype.initializeItems.call(this);
}
}
if (AjxPackage.define("zimbraAdmin.common.Signature_XFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2011, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2011, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Created by IntelliJ IDEA.
 * User: mingzhang
 * Date: 5/30/11
 * Time: 12:07 AM
 * To change this template use File | Settings | File Templates.
 */
Signature_XFormItem = function() {}
XFormItemFactory.createItemType("_SIGNATURE_", "signature", Signature_XFormItem, Composite_XFormItem);
Signature_XFormItem.prototype.numCols = 1;
Signature_XFormItem.prototype.nowrap = true;

Signature_XFormItem.A_zimbraSigatureName = "name";
Signature_XFormItem.A_zimbraSigatureContent = "content";
Signature_XFormItem.A_zimbraSigatureType = "type";

Signature_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Signature_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Signature_XFormItem.prototype.initializeItems = function () {
    Composite_XFormItem.prototype.initializeItems.call(this);
}

Signature_XFormItem.typeChoice = [
    {value:"", label: ZaMsg.VALUE_NOT_SET},
    {value:"text/plain", label:ZaMsg.resSignaturePlainType},
    {value:"text/html", label:ZaMsg.resSignatureHTMLType}
];

Signature_XFormItem.prototype.items = [
	{type:_TEXTFIELD_, ref:".", width:"300px", labelLocation:_LEFT_, forceUpdate:true,label:ZaMsg.Dlg_SignatureName,
		visibilityChecks: [],
		enableDisableChecks: [],
		//enableDisableChecks:false,
		labelCssStyle:"width:194px",
		getDisplayValue:function(itemVal) {

			if(itemVal && itemVal["name"])
				val = itemVal["name"];
			else {
				val = "";
			}
            return val;
		},

        elementChanged:function(nameVal, curVal, event) {
            var newVal = {};
            if(curVal == "" || !curVal)
                      curVal = {};
            newVal = ZaUtil.deepCloneObject(curVal);
			newVal["name"] = nameVal;

            this.getForm().itemChanged(this.getParentItem(), newVal, event);
        }

	},
	{type:_TEXTAREA_, width: "300px",  forceUpdate:true, ref:".", labelLocation:_LEFT_, label:ZaMsg.Dlg_SignatureContent,
		visibilityChecks: [],
		enableDisableChecks: [],
		 labelCssStyle:"width:194px",
		getDisplayValue:function (itemVal) {
			var val;
			if(itemVal && itemVal["content"])
				val = itemVal["content"];
			else val = "";
			return val;
		},
		elementChanged:function(contentVal, curVal, event) {
            var newVal = {};
            if(curVal == "" || !curVal)
                    curVal = {};

            newVal = ZaUtil.deepCloneObject(curVal);
			newVal["content"] = contentVal;
			this.getForm().itemChanged(this.getParentItem(), newVal, event);
		}
	}/*,  Comment it but not delete for it might be used in future
    {ref:".", type:_OSELECT1_, label:ZaMsg.Dlg_SignatureType,
        msgName:ZaMsg.Dlg_SignatureType, labelLocation:_LEFT_,labelCssStyle:"width:194px",
        choices:Signature_XFormItem.typeChoice,
        getDisplayValue:function (itemVal) {
            var val;
            if(itemVal && itemVal["type"])
                val = itemVal["type"];
            else val = "";
            return val;
        },
        elementChanged:function(typeVal, curVal, event) {
            var newVal = {};
            if(curVal == "" || !curVal)
                    curVal = {};

            newVal = ZaUtil.deepCloneObject(curVal);
            newVal["type"] = typeVal;
            this.getForm().itemChanged(this.getParentItem(), newVal, event);
        }
    }*/
];
}
if (AjxPackage.define("zimbraAdmin.common.Super_XFormItems")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */


/**
*	_COS_STRING_ model item type
**/

Cos_String_XModelItem = function () {}
XModelItemFactory.createItemType("_COS_STRING_", "cos_string", Cos_String_XModelItem);


Cos_String_XModelItem.prototype.dataType = _STRING_;

Cos_String_XModelItem.prototype.getter = "getValue";
Cos_String_XModelItem.prototype.getterScope = _MODELITEM_;
Cos_String_XModelItem.prototype.setter = "setLocalValue";
Cos_String_XModelItem.prototype.setterScope = _MODELITEM_;

Cos_String_XModelItem.prototype.setValueAt = function (instance, val, ref) {
	var pathParts = new Array();
	if(ref.indexOf(".") >= 0) {
		pathParts = ref.split(".");
	} else if (ref.indexOf("/") >=0) {
		pathParts = ref.split("/");
	} else {
		instance[ref] = val
		return val;
	}
	var cnt = pathParts.length-1;
	var obj = instance[pathParts[0]];
	for(var ix=1; ix<cnt; ix++) {
		obj = obj[pathParts[ix]];
	}
	obj[pathParts[cnt]] = val;
}

Cos_String_XModelItem.prototype.getValue = function(instance, current, ref) {
	var value = this.getLocalValue(instance);
	if (value == null) value = this.getSuperValue(instance);
	return value;
}
Cos_String_XModelItem.prototype.getSuperValue = function(ins) {
	if(!ins || !ins._defaultValues)
		return null;
	var _ref = this.ref.replace("/", ".");
	return eval("ins._defaultValues." + _ref);
}
Cos_String_XModelItem.prototype.getLocalValue = function(ins, refPath) {
	if(!ins)
		return null;
	var _ref = this.ref.replace("/", ".");
	return eval("ins." + _ref);
}

Cos_String_XModelItem.prototype.setLocalValue = function(value, instance, current, ref) {
	this.setValueAt(instance, value, ref);
}

Cos_String_XModelItem.prototype.validateType = XModelItem.prototype.validateString;



/**
*	_COS_NUMBER_ model item type
**/
Cos_Number_XModelItem = function (){}
XModelItemFactory.createItemType("_COS_NUMBER_", "cos_number", Cos_Number_XModelItem, Cos_String_XModelItem);
Cos_Number_XModelItem.prototype.validateType = XModelItem.prototype.validateNumber;

Cos_Int_XModelItem = function (){}
XModelItemFactory.createItemType("_COS_INT_", "cos_int", Cos_Int_XModelItem, Cos_String_XModelItem);
Cos_Int_XModelItem.prototype.validateType = XModelItem.prototype.validateInt;

Cos_Enum_XModelItem = function (){}
XModelItemFactory.createItemType("_COS_ENUM_", "cos_enum", Cos_Enum_XModelItem, Cos_String_XModelItem);
Cos_Enum_XModelItem.prototype.getDefaultValue = function () {	return this.getChoices()[0]; };

Cos_Enum_XModelItem.prototype.getChoices = function()		 {
    if (typeof this.choices == "function") {  //due to the i18n complexity, we have to define the choices use the function
        this.choices = this.choices.call (this) ;
    }
    return this.choices;
}
Cos_Enum_XModelItem.prototype.getSelection = function() 	{		return this.selection;		}

Cos_Enum_XModelItem.prototype.validateType = function (value) {
	// if the selection is open, they can enter any value they want
	var selectionIsOpen = this.getSelection() == _OPEN_;
	if (selectionIsOpen) return value;
	
	// selection is not open: it must be one of the supplied choices
	var choices = this.getChoices();
	for (var i = 0; i < choices.length; i++) {
		var choice = choices[i];
		if (AjxUtil.isInstance(choice, Object)) {
			if (choice.value == value) return value;
		} else {
			if (choice == value) return value;
		}
	}
	
	// if we get here, we didn't match any of the choices
	throw this.getModel().getErrorMessage("didNotMatchChoice", value);
}

Cos_Enum_Polling_XModelItem = function () {}
XModelItemFactory.createItemType("_COS_ENUM_POLLING_", "cos_enum_polling", Cos_Enum_Polling_XModelItem, Cos_Enum_XModelItem);

Cos_Enum_Polling_XModelItem.prototype.getValue = function (instance, current, ref) {

    var value = this.getLocalValue(instance);
    if (value == null) {
        value = this.getSuperValue(instance);
    }

    var POLLING_REGEX = /^([0-9])+([dhms]|ms)$/;

    // IF the units are not part of the value, then default is seconds
    if (!POLLING_REGEX.test(value)) {
        value += "s";
    }

    return value;
}

Cos_List_XModelItem = function (){}
XModelItemFactory.createItemType("_COS_LIST_", "list_enum", Cos_List_XModelItem, Cos_String_XModelItem);
Cos_List_XModelItem.prototype.outputType = _LIST_;
Cos_List_XModelItem.prototype.itemDelimiter = List_XModelItem.prototype.itemDelimiter;
Cos_List_XModelItem.prototype.inputDelimiter = List_XModelItem.prototype.inputDelimiter;
Cos_List_XModelItem.prototype.listItem = List_XModelItem.prototype.listItem;
Cos_List_XModelItem.prototype.getOutputType  = List_XModelItem.prototype.getOutputType;
Cos_List_XModelItem.prototype.getItemDelimiter = List_XModelItem.prototype.getItemDelimiter;
Cos_List_XModelItem.prototype.getInputDelimiter = List_XModelItem.prototype.getInputDelimiter;
Cos_List_XModelItem.prototype.getListItem  = List_XModelItem.prototype.getListItem;
Cos_List_XModelItem.prototype.initializeItems = List_XModelItem.prototype.initializeItems;
Cos_List_XModelItem.prototype.validateType = List_XModelItem.prototype.validateType;
Cos_List_XModelItem.prototype.getDefaultValue = List_XModelItem.prototype.getDefaultValue;


Cos_List_XModelItem.prototype.getSuperValue = function(ins) {
	if(!ins || !ins._defaultValues)
		return null;
	var _ref = this.ref.replace("/", ".");
	var lst = eval("ins._defaultValues." + _ref);
	
	if(lst) {
		if(this.getOutputType() == _STRING_) {
			if(lst instanceof Array) {
				return lst.join(this.getItemDelimiter());
			}
		} else {
			var retval = [];
			if(!(lst instanceof Array))
				lst = [lst];
	
			var cnt = lst.length
			for(var i=0;i<cnt;i++) {
				retval.push(lst[i]);
			}
			return retval;		
		}
	}
	
}

Cos_List_XModelItem.prototype.setLocalValue = function(val, ins, current, ref) {
	if(val && this.getOutputType() == _STRING_ && !(val instanceof Array)) {
		var value = val.split(this.getInputDelimiter());
		eval("ins."+ref+" = value");
		this.setValueAt(ins, value, ref);
	} else {
        var value = eval("ins."+ref+" = val");
        this.setValueAt(ins, value, ref);
	}
	
}

Cos_List_XModelItem.prototype.getLocalValue = function(ins, refPath) {
	if(!ins)
		return null;
	
	var _ref = this.ref.replace("/", ".");	
	var value =  eval("ins." + _ref);
	if(value && this.getOutputType() ==_STRING_ && value instanceof Array) {
		return value.join(this.getItemDelimiter());
	} else {
		return value;
	}
}
//	methods

Cos_List_XModelItem.prototype.initializeItems = function () {
	var listItem = this.listItem;
	listItem.ref = listItem.id = "#";	
	this.listItem = XModelItemFactory.createItem(listItem, this, this.getModel());
	this.listItem.initializeItems();
}


Cos_List_XModelItem.prototype.validateType = function (value) {
	return value;
}


/**
* _COS_MAILQUOTA_ XModel item type
**/
Cos_MailQuota_XModelItem = function (){}
XModelItemFactory.createItemType("_COS_MAILQUOTA_", "cos_mailquota", Cos_MailQuota_XModelItem, Cos_Number_XModelItem);
Cos_MailQuota_XModelItem.prototype.getterScope = _MODELITEM_;
Cos_MailQuota_XModelItem.prototype.setterScope = _MODELITEM_;
Cos_MailQuota_XModelItem.prototype.getter = "getValue";
Cos_MailQuota_XModelItem.prototype.setter = "setLocalValue";
Cos_MailQuota_XModelItem.prototype.maxInclusive = 8796093022207;
Cos_MailQuota_XModelItem.prototype.minInclusive = 0;

Cos_MailQuota_XModelItem.prototype.getValue = function(instance, current, ref) {
	var value = this.getLocalValue(instance, current, ref);
	if (value == null ) value = this.getSuperValue(instance, current, ref);
	if(typeof value == "number" && value == 0)
		value = "0";
		
	return value;
}

Cos_MailQuota_XModelItem.prototype.getSuperValue = function(ins) {
	if(!ins)
		return null;
	var _ref = this.ref.replace("/", ".");
	//var value = 0;
	var value = null;
	if((eval("ins._defaultValues." + _ref) != null) && (eval("ins._defaultValues." + _ref) != "")) {
		value = (eval("ins._defaultValues." + _ref) / 1048576);
		if(value != Math.round(value)) {
			value = Number(value).toFixed(2);
	  	}
	} 	
//	var value = (eval("ins._defaultValues." + _ref) != null) ? Number(eval("ins._defaultValues." + _ref) / 1048576).toFixed(0) : 0;
	return value;
}
Cos_MailQuota_XModelItem.prototype.getLocalValue = function(ins, refPath) {
	if(!ins)
		return null;	
	var _ref = this.ref.replace("/", ".");
	var value =null;
	if(eval("ins." + _ref) != null && eval("ins." + _ref) != "") {
		value = (eval("ins." + _ref) / 1048576);
		if(value != Math.round(value)) {
			value = Number(value).toFixed(2);
	  	}
	} 
	return value || eval("ins." + _ref) ;
}

Cos_MailQuota_XModelItem.prototype.setLocalValue = function(value, instance, current, ref) {
	if (value != null && value != "") {
		 value = Math.round(value * 1048576);
	}
	this.setValueAt(instance, value, ref);	
}

/**
* _COS_MailAttachmentSize_ XModel item type
**/
Cos_MailAttachmentSize_XModelItem = function (){}
XModelItemFactory.createItemType("_COS_MailAttachmentSize_", "cos_mailattachmentsize", Cos_MailAttachmentSize_XModelItem, Cos_MailQuota_XModelItem);
/**
* COS_MLIFETIME XModelItem
**/

Cos_MLifetime_XModelItem = function () {}
XModelItemFactory.createItemType("_COS_MLIFETIME_", "cos_mlifetime", Cos_MLifetime_XModelItem, Cos_String_XModelItem);
Cos_MLifetime_XModelItem.prototype.validateType = function (value) {
	var val = "0";
	var lastChar = "d";
	if(value == this.zeroValue) {
		val = "0";
	} else if(value != null && value.length >0) {
		var lastChar = (value.toLowerCase()).charAt(value.length-1);
		lastChar = (lastChar == "d" || lastChar == "h" || lastChar== "m" || lastChar == "s") ? lastChar : "s"
		val = parseInt(value);
	}
	
	val =  [XModelItem.prototype.validateNumber.call(this, val),lastChar].join("");
	return val;
}

Cos_MInterval_XModelItem = function () {}
XModelItemFactory.createItemType("_COS_MINTERVAL_", "cos_minterval", Cos_MInterval_XModelItem, Cos_MLifetime_XModelItem);
Cos_MInterval_XModelItem.prototype.zeroValue = ZaMsg.never.toLowerCase();

/**
* _COS_HOSTNAME_OR_IP_
**/
Cos_HostNameOrIp_XModelItem = function (){}
XModelItemFactory.createItemType("_COS_HOSTNAME_OR_IP_", "cos_hostname_or_ip", Cos_HostNameOrIp_XModelItem, Cos_String_XModelItem);
Cos_HostNameOrIp_XModelItem.prototype.validateType = XModelItem.prototype.validateString;
Cos_HostNameOrIp_XModelItem.prototype.maxLength = 256;
//Cos_HostNameOrIp_XModelItem.prototype.pattern = [ AjxUtil.HOST_NAME_RE, AjxUtil.IPv4_ADDRESS_RE ];
Cos_HostNameOrIp_XModelItem.prototype.pattern =  [AjxUtil.HOST_NAME_RE, AjxUtil.IPv4_ADDRESS_RE, AjxUtil.HOST_NAME_WITH_PORT_RE];

/**
* _COS_PORT_
**/
Cos_Port_XModelItem = function (){}
XModelItemFactory.createItemType("_COS_PORT_", "cos_port", Cos_Port_XModelItem, Cos_Number_XModelItem);
Cos_Port_XModelItem.prototype.validateType = XModelItem.prototype.validateNumber;
Cos_Port_XModelItem.prototype.minInclusive = 0;
Cos_Port_XModelItem.prototype.maxInclusive = 65535;

/**
* _COS_SUBNET_
**/
Cos_Subnet_XModelItem = function (){}
XModelItemFactory.createItemType("_COS_SUBNET_", "cos_subnet", Cos_Subnet_XModelItem, Cos_String_XModelItem);
Cos_Subnet_XModelItem.prototype.validateType = XModelItem.prototype.validateString;
Cos_Subnet_XModelItem.prototype.maxLength = 256;
Cos_Subnet_XModelItem.prototype.pattern =  [AjxUtil.IPv4_ADDRESS_RE, AjxUtil.SUBNET_RE];

/**
*	XForm Items that have overwritable super values
**/

/**
* Super_XFormItem - prototype for all other XForm items with overwritable super values
**/
Super_XFormItem = function () { }
XFormItemFactory.createItemType("_SUPER_FIELD_", "cos_field", Super_XFormItem, Composite_XFormItem);
Super_XFormItem.prototype.bmolsnr = true;
Super_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Super_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Super_XFormItem.checkIfOverWriten = function() {
	if(!ZaItem.hasWritePermission.call(this))
		return false;
		
	if(this.getModelItem() && this.getModelItem().getLocalValue(this.getInstance(), this.refPath)==null)
		return false;
	else if (this.getModelItem() &&  (this.getModelItem().getLocalValue(this.getInstance(), this.refPath) instanceof AjxVector) && 
	(this.getModelItem().getLocalValue(this.getInstance(), this.refPath).size==0) )	
		return false;
	else 
		return true;
}

Super_XFormItem.updateCss = function(levels) {
	var container = this.getContainer();
	if(this.getParentItem().getInheritedProperty("useParentTable"))
		levels = levels-4;
	
	for(var ix=0; ix < levels; ix++) {
		container = container.parentNode;
	}
	if(Super_XFormItem.checkIfOverWriten.call(this)) {
		if(container.className != null && container.className != "ZaOverride")
			this._originalClassName = container.className;
		else 
			this._originalClassName	= "xform_field_container";
			
		container.className="ZaOverride";
	} else {
		if(this._originalClassName != null)
			container.className=this._originalClassName;
		else
			container.className="xform_field_container";
	}
}



/**
* SUPER_ANCHOR_HELPER
* "Reset to *** value" link
**/
Super_AnchorHelper_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_ANCHOR_HELPER_","super_anchor_helper", Super_AnchorHelper_XFormItem, Dwt_Button_XFormItem);
Super_AnchorHelper_XFormItem.prototype.containerCssClass = "xform_container xform_override_btn_contaier";
// implement the following to actually construct the instance of your widget
Super_AnchorHelper_XFormItem.prototype.constructWidget = function () {
	var widget = this.widget = new DwtButton(this.getForm(), this.getCssClass());
	var height = this.getHeight();
	var width = this.getWidth();
	//if(!width) width = "100%";
	var el = null;
	if (width != null || height != null){
		el = widget.getHtmlElement();
		if (width != null) el.style.width = width;
		if (height != null) el.style.height = height;
	} 

	var label = this.getLabel();
	
	if(!label)
		label = this.getParentItem().getInheritedProperty("resetToSuperLabel");		
		
	widget.setText(label);

	var ls = new AjxListener(this, Super_AnchorHelper_XFormItem.prototype.resetToSuperValue);
	widget.addSelectionListener(ls);

	return widget;
}

Super_AnchorHelper_XFormItem.prototype.resetToSuperValue = function(event) {
	this.getForm().itemChanged(this.getParentItem(), null, event);
}
Super_AnchorHelper_XFormItem.prototype.isBlockElement = true;

/**
*	_SUPER_TEXTFIELD_ form item type
**/
Super_Textfield_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_TEXTFIELD_", "super_textfield", Super_Textfield_XFormItem, Super_XFormItem);

Super_Textfield_XFormItem.prototype.useParentTable = false;
Super_Textfield_XFormItem.prototype.txtBoxLabel = null;
Super_Textfield_XFormItem.prototype.numCols = 3;
Super_Textfield_XFormItem.prototype.colSizes = ["275px","275px","150px"];
Super_Textfield_XFormItem.prototype.colSpan = 3;
Super_Textfield_XFormItem.prototype.nowrap = false;
Super_Textfield_XFormItem.prototype.labelWrap = true;
Super_Textfield_XFormItem.prototype.colSizes = ["275px","225px","150px"];
Super_Textfield_XFormItem.prototype.labelCssStyle = "border-right: 1px solid black;";
Super_Textfield_XFormItem.prototype.tableCssClass = "grid_composite_table";

SuperWiz_Textfield_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPERWIZ_TEXTFIELD_", "superwiz_textfield", SuperWiz_Textfield_XFormItem, Super_Textfield_XFormItem);
SuperWiz_Textfield_XFormItem.prototype.colSizes=["200px", "250px","150px"];
SuperWiz_Textfield_XFormItem.prototype.visibilityChecks = [ZaItem.hasWritePermission];
SuperWiz_Textfield_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
SuperWiz_Textfield_XFormItem.prototype.labelCssStyle = "";

Super_Textfield_XFormItem.prototype.initializeItems = function() {
	var txtBoxLabel = this.getInheritedProperty("txtBoxLabel");
    var labelCssStyle = this.getInheritedProperty("labelCssStyle");
    var labelCssClass = this.getInheritedProperty("labelCssClass");
	var textFieldCssClass = this.getInheritedProperty("textFieldCssClass");
	var textFieldCssStyle = this.getInheritedProperty("textFieldCssStyle");
	var textFieldWidth = this.getInheritedProperty("textFieldWidth");
	var toolTip = this.getInheritedProperty("toolTipContent");

	var getDisplayValue = this.getInheritedProperty("getDisplayValue");
	
	var txtField =	{	
		type:_TEXTFIELD_, ref:".",align:_LEFT_,
		elementChanged: function(elementValue,instanceValue, event) {
			this.getForm().itemChanged(this, elementValue, event);
		},		
		onChange:Composite_XFormItem.onFieldChange,
		toolTipContent: toolTip,
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			Textfield_XFormItem.prototype.updateElement.call(this, value);
		},
		label:txtBoxLabel,
        labelCssStyle:labelCssStyle,
        labelCssClass: labelCssClass,
		labelLocation:(txtBoxLabel ? _LEFT_ : _NONE_),
		cssClass:textFieldCssClass,
		cssStyle:textFieldCssStyle,
		width:textFieldWidth,
		forceUpdate:true,
		nowrap:this.getInheritedProperty("nowrap"),
		labelWrap:this.getInheritedProperty("labelWrap")		
	};
	
	if(getDisplayValue) {
		txtField.getDisplayValue = getDisplayValue;
	}
	
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange,
		cssStyle: (anchorCssStyle ? anchorCssStyle : "width:150px")
	};
	this.items = [txtField,anchorHlpr];
	Composite_XFormItem.prototype.initializeItems.call(this);
	

}	

Super_Textfield_XFormItem.prototype.items = [];

/**
*	_SUPER_TEXTAREA_ form item type
**/
Super_Textarea_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_TEXTAREA_", "super_textarea", Super_Textarea_XFormItem, Super_XFormItem);

Super_Textarea_XFormItem.prototype.useParentTable = false;
Super_Textarea_XFormItem.prototype.txtBoxLabel = null;
Super_Textarea_XFormItem.prototype.numCols = 3;
Super_Textarea_XFormItem.prototype.colSizes = ["275px","275px","150px"];
Super_Textarea_XFormItem.prototype.colSpan = 3;
Super_Textarea_XFormItem.prototype.nowrap = false;
Super_Textarea_XFormItem.prototype.labelWrap = true;
Super_Textarea_XFormItem.prototype.colSizes = ["275px","225px","150px"];
Super_Textarea_XFormItem.prototype.tableCssClass = "grid_composite_table";

SuperWiz_Textarea_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPERWIZ_TEXTAREA_", "superwiz_textarea", SuperWiz_Textarea_XFormItem, Super_Textarea_XFormItem);
SuperWiz_Textarea_XFormItem.prototype.colSizes=["200px", "250px","150px"];
SuperWiz_Textarea_XFormItem.prototype.visibilityChecks = [ZaItem.hasWritePermission];
SuperWiz_Textarea_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];


Super_Textarea_XFormItem.prototype.initializeItems = function() {
	var txtBoxLabel = this.getInheritedProperty("txtBoxLabel");
    var txtBoxLabelCssStyle = this.getInheritedProperty("txtBoxLabelCssStyle");
	var textAreaCssClass = this.getInheritedProperty("textAreaCssClass");
	var textAreaCssStyle = this.getInheritedProperty("textAreaCssStyle");
	var textAreaWidth = this.getInheritedProperty("textAreaWidth");
	var toolTip = this.getInheritedProperty("toolTipContent");
	var labelCssStyle = this.getInheritedProperty("labelCssStyle");
    var labelCssClass = this.getInheritedProperty("labelCssClass");
	
	var txtArea =	{	
		type:_TEXTAREA_, ref:".",align:_LEFT_,
		elementChanged: function(elementValue,instanceValue, event) {
			this.getForm().itemChanged(this, elementValue, event);
		},		
		onChange:Composite_XFormItem.onFieldChange,
		toolTipContent: toolTip,
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			Textarea_XFormItem.prototype.updateElement.call(this, value);
		},
		label:txtBoxLabel,
		labelLocation:(txtBoxLabel ? _LEFT_ : _NONE_),
		labelCssStyle: labelCssStyle,
        labelCssClass: labelCssClass,
		cssClass:textAreaCssClass,
		cssStyle:textAreaCssStyle,
		width:textAreaWidth,
		forceUpdate:true,
		nowrap:this.getInheritedProperty("nowrap"),
		labelWrap:this.getInheritedProperty("labelWrap")		
	};
	
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange,
		cssStyle: (anchorCssStyle ? anchorCssStyle : "width:150px")
	};
	this.items = [txtArea,anchorHlpr];
	Composite_XFormItem.prototype.initializeItems.call(this);
}	

Super_Textarea_XFormItem.prototype.items = [];

/**
*	_SUPER_CHECKBOX_ form item type
**/
Super_Checkbox_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_CHECKBOX_", "super_checkbox", Super_Checkbox_XFormItem, Super_XFormItem);

SuperWiz_Checkbox_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_WIZ_CHECKBOX_", "super_wiz_checkbox", SuperWiz_Checkbox_XFormItem, Super_Checkbox_XFormItem);
SuperWiz_Checkbox_XFormItem.prototype.colSizes = ["200px","300px","150px"];
SuperWiz_Checkbox_XFormItem.prototype.visibilityChecks = [ZaItem.hasWritePermission];
SuperWiz_Checkbox_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
SuperWiz_Checkbox_XFormItem.prototype.labelCssStyle = "";
SuperWiz_Checkbox_XFormItem.prototype.labelCssClass = "";
SuperWiz_Checkbox_XFormItem.prototype.checkBoxLabelLocation = _RIGHT_;
SuperWiz_Checkbox_XFormItem.prototype.checkboxSubLabel = "";
SuperWiz_Checkbox_XFormItem.prototype.checkboxAlign = _RIGHT_;

Super_Checkbox_XFormItem.prototype.useParentTable = false;
Super_Checkbox_XFormItem.prototype.numCols = 3;
Super_Checkbox_XFormItem.prototype.colSizes = ["275px","275px","*"];
Super_Checkbox_XFormItem.prototype.nowrap = false;
Super_Checkbox_XFormItem.prototype.labelWrap = true;
Super_Checkbox_XFormItem.prototype.checkboxSubLabel = null;
Super_Checkbox_XFormItem.prototype.labelCssStyle = "border-right: 1px solid black;";
Super_Checkbox_XFormItem.prototype.labelCssClass = "gridGroupBodyLabel";
Super_Checkbox_XFormItem.prototype.tableCssClass = "grid_composite_table";
Super_Checkbox_XFormItem.prototype.colSizes = ["275px","225px","*"];

Super_Checkbox_XFormItem.prototype.initializeItems = function() {
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	var checkboxSubLabel = this.getInheritedProperty("checkboxSubLabel");
	var checkLabelCssClass = this.getInheritedProperty("labelCssClass");
	var clearChildComponentChecks = this.getInheritedProperty("clearChildComponentChecks");

	var chkBox = {
		type:_CHECKBOX_, ref:".",  labelCssClass:checkLabelCssClass, subLabel:checkboxSubLabel,
		onChange:Composite_XFormItem.onFieldChange,
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			Checkbox_XFormItem.prototype.updateElement.call(this, value);
		},
		trueValue:this.getInheritedProperty("trueValue"),
		falseValue:this.getInheritedProperty("falseValue"),
		forceUpdate:true
	};
	var chkBoxElementChanged = this.getInheritedProperty("checkBoxElementChanged");
	if(chkBoxElementChanged) {
		chkBox.elementChanged = chkBoxElementChanged;
	}
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange,
		cssStyle:"width:150px"
	};
	
	var customOvewriteChecks = this.getInheritedProperty("customOvewriteChecks");
	if(customOvewriteChecks) {
		anchorHlpr.visibilityChecks = customOvewriteChecks; 
	}
	
	if(anchorCssStyle) {
		anchorHlpr.cssStyle = anchorCssStyle;
	} 
	
	
	var checkBoxLabel = this.getInheritedProperty("checkBoxLabel");
	if(checkBoxLabel) {
		chkBox.label = checkBoxLabel;
		chkBox.labelWrap = this.getInheritedProperty("labelWrap");
        chkBox.labelCssStyle = this.getInheritedProperty("labelCssStyle");
		this.numCols = 3;
		this.colSpan= this.getInheritedProperty("conSpan") || 3;
	}
	
	var checkBoxLabelLocation = this.getInheritedProperty("checkBoxLabelLocation");
	if(checkBoxLabelLocation) {
		chkBox.labelLocation = checkBoxLabelLocation;
	}

    var checkBoxAlign = this.getInheritedProperty("checkboxAlign");
	if(checkBoxLabelLocation) {
		chkBox.align = checkBoxAlign;
	}
	
	this.items = [chkBox,anchorHlpr];

	Composite_XFormItem.prototype.initializeItems.call(this);

	if(clearChildComponentChecks) {
		this.items.forEach(function(item) {
			item.visibilityChecks = [];
			item.enableDisableChecks = [];
		});
	}
}

Super_Checkbox_XFormItem.prototype.items = []; 


/**
*	_SUPER_MULTIPLE_CHECKBOX_ form item type
**/
SuperSelect_MultipleCheckbox_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_MULTIPLE_CHECKBOX_", "super_multiple_checkbox", SuperSelect_MultipleCheckbox_XFormItem, Super_XFormItem);
SuperSelect_MultipleCheckbox_XFormItem.prototype.numCols = 3;
SuperSelect_MultipleCheckbox_XFormItem.prototype.colSpan = 3;
SuperSelect_MultipleCheckbox_XFormItem.prototype.colSizes = ["275px","225px", "*"];
SuperSelect_MultipleCheckbox_XFormItem.prototype.nowrap = false;
SuperSelect_MultipleCheckbox_XFormItem.prototype.labelWrap = true;
SuperSelect_MultipleCheckbox_XFormItem.prototype.items = [];
SuperSelect_MultipleCheckbox_XFormItem.prototype.labelCssStyle = "border-right: 1px solid black;";
SuperSelect_MultipleCheckbox_XFormItem.prototype.labelCssClass = "gridGroupBodyLabel";
SuperSelect_MultipleCheckbox_XFormItem.prototype.tableCssClass = "grid_composite_table";

/**
*	_SUPER_WIZ_MULTIPLE_CHECKBOX_ form item type
**/
SuperWiz_MultipleCheck_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_WIZ_MULTIPLE_CHECKBOX_", "super_wiz_multiple_checkbox", SuperWiz_MultipleCheck_XFormItem, SuperSelect_MultipleCheckbox_XFormItem);

SuperWiz_MultipleCheck_XFormItem.prototype.colSizes = ["200px","300px","150px"];
SuperWiz_MultipleCheck_XFormItem.prototype.visibilityChecks = [ZaItem.hasWritePermission];
SuperWiz_MultipleCheck_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
SuperWiz_MultipleCheck_XFormItem.prototype.labelCssStyle = "";
SuperWiz_MultipleCheck_XFormItem.prototype.labelCssClass = "";
SuperWiz_MultipleCheck_XFormItem.prototype.checkBoxLabelLocation = _RIGHT_;
SuperWiz_MultipleCheck_XFormItem.prototype.checkboxSubLabel = "";
SuperWiz_MultipleCheck_XFormItem.prototype.checkboxAlign = _RIGHT_;

SuperSelect_MultipleCheckbox_XFormItem.prototype.initializeItems = function() {
	var choices = this.getInheritedProperty("choices");
	var label = this.getInheritedProperty("groupLabel");

	var selectChck = {
		type: _OSELECT_CHECK_,
		choices: choices,
		ref: ".",
		width: "225px",
		onChange: function(value, event, form) {
			if (this.getParentItem() && this.getParentItem().getParentItem() && this.getParentItem().getParentItem().getOnChangeMethod()) {
				return this.getParentItem().getParentItem().getOnChangeMethod().call(this, value, event, form);
			} else {
				return this.setInstanceValue(value);
			}
		},
		forceUpdate: true,
		updateElement: function(value) {
			Super_XFormItem.updateCss.call(this, 9);
			if (!(value instanceof Array)) {
				value = [value];
			}
			OSelect_XFormItem.prototype.updateElement.call(this, value);
		},
		cssStyle: "border:none;"
	};

	var selectChckGrp = {
		type: _GROUP_,
		ref: ".",
		items: [selectChck]
	};

	selectChckGrp.label = label;
	selectChckGrp.labelCssClass = this.getInheritedProperty("labelCssClass");
	selectChckGrp.labelCssStyle = this.getInheritedProperty("labelCssStyle");
	selectChckGrp.cssClass = "";

	var anchorHlpr = {
		type: _SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks: [Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources: [this.getRefPath()],
		onChange: Composite_XFormItem.onFieldChange,
		cssStyle: "width:150px"
	};

	this.items = [selectChckGrp, anchorHlpr];

	Composite_XFormItem.prototype.initializeItems.call(this);

	// replace class name and functions defined in OSelect_Check_XFormItem
	this.containerCssClass = "xform_container";
	this.items[0].items[0].cssClass = this.containerCssClass;
	this.items[0].items[0].getChoiceSelectedCssClass = this.__getChoiceSelectedCssClass;
	this.items[0].items[0].getChoiceCssClass = this.__getChoiceCssClass;
	this.items[0].items[0].getChoiceHTML = this.__getChoiceHTML;
	this.items[0].items[0].setElementEnabled = this.__setElementEnabled;

	this.items[0].items[0].onChoiceOverOriginal = this.items[0].items[0].onChoiceOver;
	this.items[0].items[0].onChoiceOver = this.__onChoiceOver;

	this.items[0].items[0].onChoiceOutOriginal = this.items[0].items[0].onChoiceOut;
	this.items[0].items[0].onChoiceOut = this.__onChoiceOut;

	this.items[0].items[0].onChoiceClickOriginal = this.items[0].items[0].onChoiceClick;
	this.items[0].items[0].onChoiceClick = this.__onChoiceClick;

	this.items[0].items[0].onChoiceDoubleClickOriginal = this.items[0].items[0].onChoiceDoubleClick;
	this.items[0].items[0].onChoiceDoubleClick = this.__onChoiceDoubleClick;
};

// functions to replace the ones defined in OSelect_Check_XFormItem
SuperSelect_MultipleCheckbox_XFormItem.prototype.__getChoiceSelectedCssClass =
function() {
	return this.containerCssClass;
};

SuperSelect_MultipleCheckbox_XFormItem.prototype.__getChoiceCssClass =
function() {
	return this.containerCssClass;
};

SuperSelect_MultipleCheckbox_XFormItem.prototype.__getChoiceHTML =
function(itemNum, value, label, cssClass) {
	var ref = this.getFormGlobalRef() + ".getItemById('"+ this.getId()+ "')";
	var id = this.getId();
	return AjxBuffer.concat(
		"<tr><td class=", cssClass,
			" onmouseover=\"" + ref + ".onChoiceOver(" + itemNum + ", event||window.event)\"",
			" onmouseout=\"" + ref +  ".onChoiceOut(" + itemNum + ", event||window.event)\"",
			" onclick=\"" + ref + ".onChoiceClick(" + itemNum + ", event||window.event)\"",
			" ondblclick=\"" + ref + ".onChoiceDoubleClick(" + itemNum + ", event||window.event)\"",
		">",
		"<table cellspacing=0 cellpadding=0><tr><td><input type=checkbox id='",id,"_choiceitem_",itemNum,"'></td><td>",
		        "<font id=", id, "_label_", itemNum, ">", AjxStringUtil.htmlEncode(label), "</font>",
		"</td></tr></table></td></tr>"
	);
};

SuperSelect_MultipleCheckbox_XFormItem.prototype.__setElementEnabled =
function(enabled) {
	var choices = this.getNormalizedChoices();
	if (!choices) {
		return;
	}
	var values = choices.values;
	if (!values) {
		return;
	}
	var cnt = values.length;
	for (var i = 0; i < cnt; i++) {
		var checkbox = this.getElement(this.getId() + "_choiceitem_" + i);
		var label = this.getElement(this.getId() + "_label_" + i);
		if (checkbox) {
			if (enabled) {
				checkbox.className = this.getChoiceCssClass();
				checkbox.disabled = false;
				label.style.color ="";
			} else {
				checkbox.className = this.getChoiceCssClass() + "_disabled";
				checkbox.disabled = true;
				label.style.color ="#808080";
			}
		}
	}
};

SuperSelect_MultipleCheckbox_XFormItem.prototype.__onChoiceOver =
function(itemNum) {
	if (this.getIsEnabled()) {
		this.onChoiceOverOriginal(itemNum);
	}
};

SuperSelect_MultipleCheckbox_XFormItem.prototype.__onChoiceOut =
function(itemNum) {
	if (this.getIsEnabled()) {
		this.onChoiceOutOriginal(itemNum);
	}
};

SuperSelect_MultipleCheckbox_XFormItem.prototype.__onChoiceClick =
function(itemNum, event) {
	if (this.getIsEnabled()) {
		this.onChoiceClickOriginal(itemNum, event);
	}
};

SuperSelect_MultipleCheckbox_XFormItem.prototype.__onChoiceDoubleClick =
function(itemNum, event) {
	// address double click as a single click
	if (this.getIsEnabled()) {
		this.onChoiceClickOriginal(itemNum, event);
	}
};


/**
*	SUPER__HOSTPORT_ form item type
**/
Super_HostPort_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_HOSTPORT_", "super_hostport", Super_HostPort_XFormItem, Super_XFormItem);
Super_HostPort_XFormItem.prototype.colSizes = ["275px","275px","150px"];
Super_HostPort_XFormItem.prototype.useParentTable = false;
Super_HostPort_XFormItem.prototype.numCols = 3;
Super_HostPort_XFormItem.prototype.colSpan = 3;
Super_HostPort_XFormItem.prototype.initializeItems = function() {
	
	var txtField = {	type:_HOSTPORT_, ref:".",
		onChange:Composite_XFormItem.onFieldChange,
		onClick: "Super_HostPort_XFormItem.handleClick",
		onMouseout: "Super_HostPort_XFormItem.handleMouseout",
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			XFormItem.prototype.updateElement.call(this, value);
		}
	};
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange,cssStyle:"width:150px"
	}
	
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	if(anchorCssStyle) {
		anchorHlpr.cssStyle = anchorCssStyle;
	} 
	
	var textBoxLabel = this.getInheritedProperty("textBoxLabel");
	if(textBoxLabel) {
		txtField.label = textBoxLabel;
	}
	this.items = [txtField,anchorHlpr];
	Composite_XFormItem.prototype.initializeItems.call(this);
}	
Super_HostPort_XFormItem.prototype.items = [];

Super_HostPort_XFormItem.handleClick =
function (event, _parent) {
	//DBG.println(AjxDebug.DBG1, "Handle Click from Super Items ...");
	var p = _parent || this ; //used for the call from the HostPort_XFormItem
	p = p.getParentItem () ; 
	var focusFunc = p.getInheritedProperty("onClick") ;
	if (focusFunc != null && focusFunc != "") {
		var func = new Function ("event", "item", "return " + focusFunc + "( event, item);") ;
		func (event, p) ;
	}
}

Super_HostPort_XFormItem.handleMouseout =
function (event, _parent) {
	//DBG.println(AjxDebug.DBG1, "Handle onmouseout event ...");
	var p = _parent || this ;
	p = p.getParentItem () ; //get the super_textfield item from the _textfield_
	var focusFunc = p.getInheritedProperty("onMouseout") ;
	if (focusFunc != null && focusFunc != "") {
		var func = new Function ("event",  "item", "return " + focusFunc + "(event, item);") ;
		func (event, p) ;
	}
}


/**
*	SUPER_DWT_CHOOSER form item type
**/
Super_DwtChooser_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_DWT_CHOOSER_", "super_dwt_chooser", Super_DwtChooser_XFormItem, Super_XFormItem);
Super_DwtChooser_XFormItem.prototype.numCols = 1;

Super_DwtChooser_XFormItem.prototype.sorted = true;
Super_DwtChooser_XFormItem.prototype.layoutStyle = DwtChooser.HORIZ_STYLE;
Super_DwtChooser_XFormItem.prototype.sourceRef = ".";
Super_DwtChooser_XFormItem.prototype.widgetClass = DwtChooser;
Super_DwtChooser_XFormItem.prototype.align = _CENTER_;

Super_DwtChooser_XFormItem.prototype.initializeItems = function() {
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	var sorted = this.getInheritedProperty("sorted");
	var layoutStyle = this.getInheritedProperty("layoutStyle");	
	var sourceRef = this.getInheritedProperty("sourceRef");	
	var widgetClass = this.getInheritedProperty("widgetClass");	
	var tableWidth = this.getInheritedProperty("tableWidth");
	var labelWidth = this.getInheritedProperty("labelWidth");
	var splitButtons = this.getInheritedProperty("splitButtons");
	var resetToSuperLabel = this.getInheritedProperty("resetToSuperLabel");
	var listWidth = this.getInheritedProperty("listWidth");
	var listHeight = this.getInheritedProperty("listHeight");

	var anchorItem = {	
			type:_SUPER_ANCHOR_HELPER_, ref:".",
			visibilityChecks:[Super_XFormItem.checkIfOverWriten],
			visibilityChangeEventSources:[this.getRefPath()],
			cssSyle:(anchorCssStyle ? anchorCssStyle : "width:150px;"),
			onChange:Composite_XFormItem.onFieldChange,
			label:resetToSuperLabel,align:_CENTER_,
			containerCssStyle:"width:90%;float:center;align:center;text-align:center;"
		};
	var chooserItem = {	type:_DWT_CHOOSER_, ref:".",onChange:Composite_XFormItem.onFieldChange,
			updateElement:function(value) {
				Super_XFormItem.updateCss.call(this,5);
				this.updateWidget(value, true, Super_DwtChooser_XFormItem.getElemValue);
			},
			listSize:"90%",
			sorted:sorted, layoutStyle:layoutStyle,sourceRef:sourceRef,widgetClass:widgetClass,
			tableWidth:(tableWidth ? tableWidth : null), 
			labelWidth : (labelWidth ? labelWidth : null), 
			listWidth : (listWidth ? listWidth : null), 
			listHeight : (listHeight ? listHeight : null), 
			splitButtons : (splitButtons ? splitButtons : null) 			
		};
	this.items = [
		{type:_GROUP_, align:_CENTER_, ref:".",width:"100%", numCols:3, colSizes:["*","200px","*" ],
			items:[
				{type:_CELLSPACER_},
				anchorItem,
				{type:_CELLSPACER_}
			],onChange:this.getInheritedProperty("onChange")
		},
		chooserItem];
	Composite_XFormItem.prototype.initializeItems.call(this);
}	
Super_DwtChooser_XFormItem.getElemValue = function () {
	return this.toString();
}
Super_DwtChooser_XFormItem.prototype.items = [];





/**
*	_ZIMLET_SELECT_CHECK_ form item type
**/
Zimlet_SelectCheck_XFormItem = function () {}
XFormItemFactory.createItemType("_ZIMLET_SELECT_CHECK_", "zimlet_select_check", Zimlet_SelectCheck_XFormItem, Super_XFormItem);
Zimlet_SelectCheck_XFormItem.prototype.numCols=2;
Zimlet_SelectCheck_XFormItem.prototype.colSizes=["275px","275px"];
Zimlet_SelectCheck_XFormItem.prototype.nowrap = false;
Zimlet_SelectCheck_XFormItem.prototype.labelWrap = true;
Zimlet_SelectCheck_XFormItem.prototype.items = [];
Zimlet_SelectCheck_XFormItem.prototype.labelWidth = "275px";

Zimlet_SelectCheck_XFormItem.prototype.initializeItems = function() {
	var selectRef = this.getInheritedProperty("selectRef");
	var checkBoxLabel = this.getInheritedProperty("checkBoxLabel");
	var choices = this.getInheritedProperty("choices");	
	var checkBox = {type:_CHECKBOX_, ref:".",
		label:checkBoxLabel, labelLocation:_RIGHT_,
		elementChanged:function(elementValue,instanceValue, event) {
			if(!elementValue) {
				this.getForm().itemChanged(this.getParentItem(), null, event);	
			}
		},
		updateElement:function(value) {
			this.getElement().checked = value;
		}
	};
	
	var selectChck = {
		type:_OSELECT_CHECK_,
		choices:choices,
		colSpan:3,
		ref:selectRef,
		width:"275px",
		onChange:function (value, event, form) {
			if (this.getParentItem() && this.getParentItem().getParentItem() && this.getParentItem().getParentItem().getOnChangeMethod()) {
				return this.getParentItem().getParentItem().getOnChangeMethod().call(this, value, event, form);
			} else {
				return this.setInstanceValue(value);
			}
		},
		forceUpdate:true,
		updateElement:function(value) {
			OSelect_XFormItem.prototype.updateElement.call(this, value);
		},
		cssStyle:"margin-bottom:5px;margin-top:5px;border:2px inset gray;"				
	};
	
	var selectChckGrp = {
		type:_GROUP_,
		numCols:3,
		colSizes:["130px","15px","130px"],
		items:[
			selectChck,
			{type:_DWT_BUTTON_,label:ZaMsg.SelectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.selectAll(ev);
					}
				}
			},
			{type:_CELLSPACER_,width:"15px"},
			{type:_DWT_BUTTON_,label:ZaMsg.DeselectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.deselectAll(ev);
					}
				}
			}
		]
		
	}
		
	this.items = [checkBox,{type:_CELLSPACER_,width:this.labelWidth},selectChckGrp];
	
	
	Composite_XFormItem.prototype.initializeItems.call(this);
}

/**
*	_SUPER_SELECT_CHECK_ form item type
**/
SuperSelect_Check_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_SELECT_CHECK_", "super_select_check", SuperSelect_Check_XFormItem, Super_XFormItem);
SuperSelect_Check_XFormItem.prototype.numCols=2;
SuperSelect_Check_XFormItem.prototype.colSizes=["275px","275px"];
SuperSelect_Check_XFormItem.prototype.nowrap = false;
SuperSelect_Check_XFormItem.prototype.labelWrap = true;
SuperSelect_Check_XFormItem.prototype.items = [];
SuperSelect_Check_XFormItem.prototype.labelWidth = "275px";

SuperSelect_Check_XFormItem.prototype.initializeItems = function() {
	var selectRef = this.getInheritedProperty("selectRef");
	var limitLabel = this.getInheritedProperty("limitLabel");
	var choices = this.getInheritedProperty("choices");	
	var radioBox1 = {type:_RADIO_, groupname:this.id+"zimlet_select_check_grp"+selectRef,ref:".",
		label:ZaMsg.NAD_UseCosSettings, labelLocation:_RIGHT_,
		elementChanged:function(elementValue,instanceValue, event) {
			if(elementValue==true) {
				this.getForm().itemChanged(this.getParentItem(), null, event);	
			}
		},
		updateElement:function() {
			this.getElement().checked = !this.getModelItem().getLocalValue(this.getInstance(), this.refPath);
		}
		
	};
	
	var radioBox2 = {type:_RADIO_, groupname:this.id+"zimlet_select_check_grp"+selectRef,ref:".",
		label:limitLabel, labelLocation:_RIGHT_ ,
		updateElement:function() {
			this.getElement().checked = this.getModelItem().getLocalValue(this.getInstance(), this.refPath);
		},		
		elementChanged:function(elementValue,instanceValue, event) {
			var arr = this.getModelItem().getSuperValue(this.getInstance());
			var arr2 = [];
			if(arr) {
				var cnt = arr.length;
				for(var i=0;i<cnt;i++) {
					arr2.push(arr[i]);
				}
			}
			this.getForm().itemChanged(this.getParentItem(), arr2, event);	
		}
	};	
	
	var selectChck = {
		type:_OSELECT_CHECK_,
		choices:choices,
		colSpan:3,
		ref:selectRef,
		width:"275px",
		onChange:function (value, event, form) {
			if (this.getParentItem() && this.getParentItem().getParentItem() && this.getParentItem().getParentItem().getOnChangeMethod()) {
				return this.getParentItem().getParentItem().getOnChangeMethod().call(this, value, event, form);
			} else {
				return this.setInstanceValue(value);
			}
		},
		forceUpdate:true,
		updateElement:function(value) {
			if (!(value instanceof Array))
				value = [value];
				
			var cnt = value.length;
			for(var i=cnt-1;i>=0;i--) {
				if(value[i]==ZaZimlet.NULL_ZIMLET) {
					value.splice(i,1);
					break;
				}
			}
			OSelect_XFormItem.prototype.updateElement.call(this, value);
		},
		cssStyle:"margin-bottom:5px;margin-top:5px;border:2px inset gray;"				
	};
	
	var selectChckGrp = {
		type:_GROUP_,
		numCols:3,
		colSizes:["130px","15px","130px"],
		items:[
			selectChck,
			{type:_DWT_BUTTON_,label:ZaMsg.SelectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.selectAll(ev);
					}
				}
			},
			{type:_CELLSPACER_,width:"15px"},
			{type:_DWT_BUTTON_,label:ZaMsg.DeselectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.deselectAll(ev);
					}
				}
			}
		]
		
	}
		
	this.items = [radioBox1,radioBox2,{type:_CELLSPACER_,width:this.labelWidth},selectChckGrp/*,{type:_CELLSPACER_,width:"15px"},anchorHlpr*/];
	
	
	Composite_XFormItem.prototype.initializeItems.call(this);
}

/**
*	_SUPER_WIZ_SELECT_CHECK_ form item type
**/
SuperWiz_Select_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_WIZ_SELECT_CHECK_", "super_wiz_select_check", SuperWiz_Select_XFormItem, SuperSelect_Check_XFormItem);
SuperWiz_Select_XFormItem.prototype.numCols=2;
SuperWiz_Select_XFormItem.prototype.colSizes=["200px","275px"];
SuperWiz_Select_XFormItem.prototype.labelWidth = "200px";

/**
*	_SUPER_ZIMLET_SELECT_ form item type
**/
SuperZimlet_Select_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_ZIMLET_SELECT_", "super_zimlet_select", SuperZimlet_Select_XFormItem, Super_XFormItem);
SuperZimlet_Select_XFormItem.prototype.numCols=2;
SuperZimlet_Select_XFormItem.prototype.colSizes=["275px","*"];
SuperZimlet_Select_XFormItem.prototype.nowrap = false;
SuperZimlet_Select_XFormItem.prototype.labelWrap = true;
SuperZimlet_Select_XFormItem.prototype.items = [];
SuperZimlet_Select_XFormItem.prototype.labelWidth = "275px";
SuperZimlet_Select_XFormItem.prototype.colSizes=["100px","*"];
SuperZimlet_Select_XFormItem.prototype.labelWidth = "100px";

SuperZimlet_Select_XFormItem.prototype.initializeItems = function() {
	var selectRef = this.getInheritedProperty("selectRef");
	var limitLabel = this.getInheritedProperty("limitLabel");
	var choices = this.getInheritedProperty("choices");	
	var radioBox1 = {type:_RADIO_, groupname:this.id+"zimlet_select_check_grp"+selectRef,ref:".",
		label:ZaMsg.NAD_UseCosSettings, labelLocation:_RIGHT_,
		elementChanged:function(elementValue,instanceValue, event) {
			if(elementValue==true) {
				this.getForm().itemChanged(this.getParentItem(), null, event);	
			}
		},
		updateElement:function() {
			this.getElement().checked = !this.getModelItem().getLocalValue(this.getInstance(), this.refPath);
		}
		
	};
	
	var radioBox2 = {type:_RADIO_, groupname:this.id+"zimlet_select_check_grp"+selectRef,ref:".",
		label:limitLabel, labelLocation:_RIGHT_ ,
		updateElement:function() {
			this.getElement().checked = this.getModelItem().getLocalValue(this.getInstance(), this.refPath);
		},		
		elementChanged:function(elementValue,instanceValue, event) {
			var arr = this.getModelItem().getSuperValue(this.getInstance());
			var arr2 = [];
			if(arr) {
				var cnt = arr.length;
				for(var i=0;i<cnt;i++) {
					arr2.push(arr[i]);
				}
			}
			this.getForm().itemChanged(this.getParentItem(), arr2, event);	
		}
	};	
	
	var selectChck = {
		type:_ZA_ZIMLET_SELECT_,
		choices:choices,
		colSpan:4,
		ref:selectRef,
		label:"",
		labelLocation:_NONE_,
		width:"500px",
		cssStyle:"margin-bottom:5px;margin-top:5px;border:2px inset gray;"				
	};
	
	var selectChckGrp = {
		type:_GROUP_,
		numCols:4,
		colSizes:["130px","15px","130px"],
		items:[
			selectChck,
			{type:_DWT_BUTTON_,label:ZaMsg.SelectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.selectAll(ev);
					}
				}
			},
			{type:_CELLSPACER_,width:"5px"},
			{type:_DWT_BUTTON_,label:ZaMsg.DeselectAll,width:"120px",
				onActivate:function (ev) {
					var lstElement = this.getParentItem().items[0];
					if(lstElement) {
						lstElement.deselectAll(ev);
					}
				}
			},
			{type:_CELLSPACER_,width:"235px"}
		]
		
	}
		
	this.items = [radioBox1,radioBox2,{type:_CELLSPACER_,width:this.labelWidth},selectChckGrp];
	
	
	Composite_XFormItem.prototype.initializeItems.call(this);
}

/**
*	_SUPER_WIZ_ZIMLET_SELECT_ form item type
**/
SuperWiz_Zimlet_Select_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_WIZ_ZIMLET_SELECT_", "super_wiz_zimlet_select", SuperWiz_Zimlet_Select_XFormItem, SuperZimlet_Select_XFormItem);
SuperWiz_Zimlet_Select_XFormItem.prototype.numCols=2;
SuperWiz_Zimlet_Select_XFormItem.prototype.colSizes=["50px","*"];
SuperWiz_Zimlet_Select_XFormItem.prototype.labelWidth = "50px";

/**
*	SUPER_SELECT1 form item type
**/
Super_Select1_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_SELECT1_", "super_select1", Super_Select1_XFormItem, Super_XFormItem);
Super_Select1_XFormItem.prototype.labelCssClass = "xform_label_left";
Super_Select1_XFormItem.prototype.labelCssStyle = "width:269px" ; // 6px for padding
Super_Select1_XFormItem.prototype.colSizes=["275px","150px"];
Super_Select1_XFormItem.prototype.nowrap = false;
Super_Select1_XFormItem.prototype.labelWrap = true;
Super_Select1_XFormItem.prototype.trueValue = "TRUE";
Super_Select1_XFormItem.prototype.falseValue = "FALSE";
Super_Select1_XFormItem.prototype.colSizes=["225px","150px"];
Super_Select1_XFormItem.prototype.initializeItems = function() {
	var slct = {	type:_OSELECT1_, ref:".",
		onChange:Composite_XFormItem.onFieldChange,
		forceUpdate:true,
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			OSelect1_XFormItem.prototype.updateElement.call(this, value);
		}
	};
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange
	};
	
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	if(anchorCssStyle) {
		anchorHlpr.cssStyle = anchorCssStyle;
	} else {
		anchorHlpr.cssStyle = "width:150px";
	}	

	var choices = this.getInheritedProperty("choices");	
	
	if(choices)
		slct.choices = choices;	
	
	var editable = this.getInheritedProperty("editable");
	if(editable)
		slct.editable = editable;
		
	var inputSize = this.getInheritedProperty("inputSize");
	if(inputSize)
		slct.inputSize = inputSize;
    var valueWidth = this.getInheritedProperty("valueWidth");
    if(valueWidth)
        slct.width =  valueWidth;
	this.items = [slct,anchorHlpr];
	Composite_XFormItem.prototype.initializeItems.call(this);
	
		

}	


Super_Select1_XFormItem.prototype.useParentTable = false;
Super_Select1_XFormItem.prototype.numCols = 2;

Super_Select1_XFormItem.prototype.items = [];

/**
*	_SUPERWIZ_SELECT1_ form item type
**/
SuperWiz_Select1_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPERWIZ_SELECT1_", "superwiz_select1", SuperWiz_Select1_XFormItem, Super_Select1_XFormItem);
SuperWiz_Select1_XFormItem.prototype.labelCssClass = "xform_label_left ZaWizLabel";
SuperWiz_Select1_XFormItem.prototype.labelCssStyle = "width:194px" ; // for it has 6px padding
SuperWiz_Select1_XFormItem.prototype.colSizes=["250px","*"];
SuperWiz_Select1_XFormItem.prototype.valueWidth = "auto";
SuperWiz_Select1_XFormItem.prototype.nowrap = false;
SuperWiz_Select1_XFormItem.prototype.labelWrap = true;
SuperWiz_Select1_XFormItem.prototype.visibilityChecks = [ZaItem.hasWritePermission];
SuperWiz_Select1_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];

/**
*	SUPER_DWT_COLORPICKER form item type
**/
Super_Dwt_ColorPicker_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_DWT_COLORPICKER_", "super_dwt_colorpicker", Super_Dwt_ColorPicker_XFormItem, Super_XFormItem);
Super_Dwt_ColorPicker_XFormItem.prototype.labelCssClass = "xform_label_left";
Super_Dwt_ColorPicker_XFormItem.prototype.labelCssStyle = "width:275px" ;
Super_Dwt_ColorPicker_XFormItem.prototype.colSizes=["275px","150px"];
Super_Dwt_ColorPicker_XFormItem.prototype.nowrap = false;
Super_Dwt_ColorPicker_XFormItem.prototype.labelWrap = true;
Super_Dwt_ColorPicker_XFormItem.prototype.useParentTable = false;
Super_Dwt_ColorPicker_XFormItem.prototype.numCols = 2;
Super_Dwt_ColorPicker_XFormItem.prototype.colSizes=["225px","150px"];
Super_Dwt_ColorPicker_XFormItem.prototype.initializeItems = function() {
    var buttonImage = this.getInheritedProperty("buttonImage") ;
    var width = this.getInheritedProperty("width") ;
    this.items = [
		{	type:_DWT_COLORPICKER_, ref:".", 
			onChange:Composite_XFormItem.onFieldChange,
			forceUpdate:true,
            buttonImage: buttonImage, width: width,
            //this method is requied to show the "reset to cos" upon the element update
			elementChanged:function(elementValue, instanceValue, event) {
				this.getForm().itemChanged(this, elementValue, event);
			},
			updateElement:function(value) {
				Super_XFormItem.updateCss.call(this,5);
				Dwt_ColorPicker_XFormItem.prototype.updateWidget.call(this, value);
			}
		},
		{	
			type:_SUPER_ANCHOR_HELPER_, ref:".",
			visibilityChecks:[Super_XFormItem.checkIfOverWriten],
			visibilityChangeEventSources:[this.getRefPath()],
			onChange:Composite_XFormItem.onFieldChange
		}
	];
	
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	if(anchorCssStyle) {
		this.getItems()[1].cssStyle = anchorCssStyle;
	} else {
		this.getItems()[1].cssStyle = "width:150px";
	}	
	Composite_XFormItem.prototype.initializeItems.call(this);
}	



/**
*	_SUPERWIZ_DWT_COLORPICKER_ form item type
**/

SuperWiz_Dwt_ColorPicker_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPERWIZ_DWT_COLORPICKER_", "superwiz_dwt_colorpicker", SuperWiz_Dwt_ColorPicker_XFormItem, Super_Dwt_ColorPicker_XFormItem);
SuperWiz_Dwt_ColorPicker_XFormItem.prototype.labelCssClass = "xform_label_left ZaWizLabel";
SuperWiz_Dwt_ColorPicker_XFormItem.prototype.labelCssStyle = "width:200px" ;
SuperWiz_Dwt_ColorPicker_XFormItem.prototype.colSizes=["250px","150px"];
SuperWiz_Dwt_ColorPicker_XFormItem.prototype.nowrap = false;
SuperWiz_Dwt_ColorPicker_XFormItem.prototype.labelWrap = true;


/**
* _SUPER_LIFETIME_ XForm item type
**/

Super_Lifetime_XFormItem = function() {}
XFormItemFactory.createItemType("_SUPER_LIFETIME_", "super_lifetime", Super_Lifetime_XFormItem, Super_XFormItem);
Super_Lifetime_XFormItem.prototype.nowrap = false;
Super_Lifetime_XFormItem.prototype.labelWrap = true;
Super_Lifetime_XFormItem.prototype.numCols = 4;
Super_Lifetime_XFormItem.prototype.colSpan = 4;
Super_Lifetime_XFormItem.prototype.colSizes =["275px","70px","205px","*"];
Super_Lifetime_XFormItem.prototype.useParenttable = false;
Super_Lifetime_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Super_Lifetime_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Super_Lifetime_XFormItem.prototype.colSizes =["275px","70px","155px","*"];
Super_Lifetime_XFormItem.prototype.labelCssStyle = "border-right: 1px solid black;";
Super_Lifetime_XFormItem.prototype.tableCssClass = "grid_composite_table";
Super_Lifetime_XFormItem.prototype.initializeItems = function() {
	var txtBoxLabel = this.getInheritedProperty("txtBoxLabel");
    var labelCssClass = this.getInheritedProperty("labelCssClass");
	var toolTip = this.getInheritedProperty("toolTipContent");
	
	var txtField =	{
		type:_TEXTFIELD_, ref:".", 
		label:txtBoxLabel,	
		toolTipContent: toolTip,
		//nowrap:false,
		//labelWrap:true,
		nowrap:this.getInheritedProperty("nowrap"),
		labelWrap:this.getInheritedProperty("labelWrap"),		
		labelCssStyle:this.getLabelCssStyle(),
        labelCssClass: labelCssClass,
		labelLocation:(txtBoxLabel ? _LEFT_ : _NONE_),
		cssClass:"admin_xform_number_input", 
		getDisplayValue:function (itemVal) {
			var val = "";
			if(itemVal != null && itemVal.length >0) {
				if(itemVal.length > 1) {
					val = parseInt(itemVal);
				} else {
					if(itemVal == "0") {
						val = "0";
					} else {
						val = "";
					}
				}
			}
			this.getParentItem()._numericPart = val;
			return ((typeof itemVal === "undefined" || val=="0") ? this.getModelItem().zeroValue : val);
		},
		elementChanged:function(numericPart, instanceValue, event) {
			if (numericPart  == this.getModelItem().zeroValue) {
				numericPart = 0;
			}
			var val = numericPart;
			if (AjxUtil.isNumeric(numericPart)) {
				val = numericPart + this.getParentItem()._stringPart;
			}
			this.getForm().itemChanged(this, val, event);
		},onChange:Composite_XFormItem.onFieldChange,
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			Textfield_XFormItem.prototype.updateElement.call(this, value);
		}
	};
	
	var selectField = 	{
		type:_OSELECT1_, ref:".",  
		choices:ZaModel.getTimeChoices(),
		getDisplayValue:function (itemVal){
			var val = "d";
			if(itemVal != null && itemVal.length >0) {
				if(itemVal.length > 1) {
					var lastChar = (itemVal.toLowerCase()).charAt(itemVal.length-1);
					val = (lastChar == "d" || lastChar == "h" || lastChar== "m" || lastChar == "s") ? lastChar : "s";
				} else {
					if(itemVal == "0") {
						val = "d";
					} else {
						val = "s"
					}
				}
			}			
			this.getParentItem()._stringPart = val;
			return val;
		},
		elementChanged:function(stringPart,instanceValue, event) {
			var val = this.getParentItem()._numericPart + stringPart;
			this.getForm().itemChanged(this.getParentItem(), val, event);
		},
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			OSelect1_XFormItem.prototype.updateElement.call(this, value);
		},
		label:null,
		labelLocation:_NONE_,
		forceUpdate:true		
	};
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange,
		cssStyle: (anchorCssStyle ? anchorCssStyle : "width:150px")
	};
	this.items = [txtField,selectField,anchorHlpr];
	Composite_XFormItem.prototype.initializeItems.call(this);	
}

Super_Lifetime_XFormItem.prototype.items = [ ];

/**
* _SUPERWIZ_LIFETIME_ XForm item type
**/
SuperWiz_Lifetime_XFormItem = function() {}
XFormItemFactory.createItemType("_SUPERWIZ_LIFETIME_", "superwiz_lifetime", SuperWiz_Lifetime_XFormItem, Super_Lifetime_XFormItem);
SuperWiz_Lifetime_XFormItem.prototype.colSizes =["200px","80px","120px","150px"];
SuperWiz_Lifetime_XFormItem.prototype.visibilityChecks = [ZaItem.hasWritePermission];
SuperWiz_Lifetime_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
SuperWiz_Lifetime_XFormItem.prototype.labelCssStyle = "";
/**
* _SUPER_LIFETIME1_ XForm item type for displaying trash message retention and spam message retention settings
**/
Super_Lifetime1_XFormItem = function() {}
XFormItemFactory.createItemType("_SUPER_LIFETIME1_", "super_lifetime1", Super_Lifetime1_XFormItem, Super_XFormItem);
Super_Lifetime1_XFormItem.prototype.nowrap = false;
Super_Lifetime1_XFormItem.prototype.labelWrap = true;
Super_Lifetime1_XFormItem.prototype.numCols = 4;
Super_Lifetime1_XFormItem.prototype.colSpan = 4;
Super_Lifetime1_XFormItem.prototype.colSizes = ["275px", "65px'", "210px", "*"];
Super_Lifetime1_XFormItem.prototype.useParenttable = false;
Super_Lifetime1_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Super_Lifetime1_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Super_Lifetime1_XFormItem.prototype.colSizes = ["275px", "65px'", "160px", "*"];

SuperWiz_Lifetime1_XFormItem = function() {}
SuperWiz_Lifetime1_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
SuperWiz_Lifetime1_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];

XFormItemFactory.createItemType("_SUPERWIZ_LIFETIME1_", "superwiz_lifetime1", SuperWiz_Lifetime1_XFormItem, Super_Lifetime1_XFormItem);
SuperWiz_Lifetime1_XFormItem.prototype.colSizes =["200px","80px","120px","150px"];

Super_Lifetime1_XFormItem.prototype.initializeItems = function() {
	var txtBoxLabel = this.getInheritedProperty("txtBoxLabel");
    var labelCssStyle = this.getInheritedProperty("labelCssStyle");
	var toolTip = this.getInheritedProperty("toolTipContent");
	
	var txtField =	{
		type:_TEXTFIELD_, ref:".", 
		label:txtBoxLabel,	
		toolTipContent: toolTip,
		nowrap:this.getInheritedProperty("nowrap"),
		labelWrap:this.getInheritedProperty("labelWrap"),		
		labelCssStyle:labelCssStyle || this.getLabelCssStyle(),
		labelLocation:(txtBoxLabel ? _LEFT_ : _NONE_),
		cssClass:"admin_xform_number_input", 
		getDisplayValue:function (itemVal) {
			var val = "1";
			if(itemVal != null && itemVal.length >0) {
				if(itemVal.length > 1) {
					val = itemVal.substr(0, itemVal.length-1);				
				} else {
					if(itemVal == "0") {
						val = "0";
					} else {
						val = "1";
					}
				}
			}
			this.getParentItem()._numericPart = val;
			return val;	
		},
		elementChanged:function(numericPart, instanceValue, event) {
			var val = numericPart + this.getParentItem()._stringPart;
			this.getForm().itemChanged(this, val, event);
		},onChange:Composite_XFormItem.onFieldChange,
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			Textfield_XFormItem.prototype.updateElement.call(this, value);
		}
	};
	
	var selectField = 	{
		type:_OSELECT1_, ref:".", 
		choices:ZaModel.getTimeChoices1(),
		getDisplayValue:function (itemVal){
			var val = "d";
			if(itemVal != null && itemVal.length >0) {
				if(itemVal.length > 1) {
					val = itemVal.substr(itemVal.length-1, 1);
				} else if (itemVal != "0") {
					val = (itemVal == "d" || itemVal == "h" || itemVal== "m" || itemVal == "s") ? itemVal : "d";
				}
			}
			this.getParentItem()._stringPart = val;
			return val;
		},
		elementChanged:function(stringPart,instanceValue, event) {
			var val = this.getParentItem()._numericPart + stringPart;
			this.getForm().itemChanged(this.getParentItem(), val, event);
		},
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			OSelect1_XFormItem.prototype.updateElement.call(this, value);
		},
		label:null,
		labelLocation:_NONE_,
		forceUpdate:true		
	};
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange,
		cssStyle: (anchorCssStyle ? anchorCssStyle : "width:150px")
	};
	this.items = [txtField,selectField,anchorHlpr];
	Composite_XFormItem.prototype.initializeItems.call(this);	
}

Super_Lifetime1_XFormItem.prototype.items = [ ];

/**
* _SUPER_LIFETIME2_ XForm item type allows time interval to be expressed only in days
**/

Super_Lifetime2_XFormItem = function() {}
XFormItemFactory.createItemType("_SUPER_LIFETIME2_", "super_lifetime2", Super_Lifetime2_XFormItem, Super_Lifetime1_XFormItem);
Super_Lifetime2_XFormItem.prototype.nowrap = false;
Super_Lifetime2_XFormItem.prototype.labelWrap = true;
Super_Lifetime2_XFormItem.prototype.numCols = 4;
Super_Lifetime2_XFormItem.prototype.colSpan = 4;
Super_Lifetime2_XFormItem.prototype.colSizes =["275px", "65px'", "210px", "*"];
Super_Lifetime2_XFormItem.prototype.useParenttable = false;
Super_Lifetime2_XFormItem.prototype._stringPart = "d";
Super_Lifetime2_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Super_Lifetime2_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];
Super_Lifetime2_XFormItem.prototype.colSizes =["275px", "65px'", "160px", "*"];

SuperWiz_Lifetime2_XFormItem = function() {}
XFormItemFactory.createItemType("_SUPERWIZ_LIFETIME2_", "superwiz_lifetime2", SuperWiz_Lifetime2_XFormItem, Super_Lifetime2_XFormItem);
SuperWiz_Lifetime2_XFormItem.prototype.colSizes =["200px","80px","120px","150px"];
SuperWiz_Lifetime2_XFormItem.prototype.visibilityChecks = [ZaItem.hasWritePermission];
SuperWiz_Lifetime2_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];

Super_Lifetime2_XFormItem.prototype.initializeItems = function() {
	var txtBoxLabel = this.getInheritedProperty("txtBoxLabel");
    var labelCssClass = this.getInheritedProperty("labelCssClass");
	var toolTip = this.getInheritedProperty("toolTipContent");
	
	var txtField =	{
		type:_TEXTFIELD_, ref:".", 
		label:txtBoxLabel,	
		toolTipContent: toolTip,
		nowrap:this.getInheritedProperty("nowrap"),
		labelWrap:this.getInheritedProperty("labelWrap"),		
		labelCssStyle:this.getLabelCssStyle(),
        labelCssClass:labelCssClass,
		labelLocation:(txtBoxLabel ? _LEFT_ : _NONE_),
		cssClass:"admin_xform_number_input", 
		getDisplayValue:function (itemVal) {
			var val = "1";
			if(itemVal != null && itemVal.length >0) {
				if(itemVal.length > 1) {
					val = itemVal.substr(0, itemVal.length-1);				
				} else {
					if(itemVal == "0") {
						val = "0";
					} else {
						val = "1";
					}
				}
			}
			this.getParentItem()._numericPart = val;
			this.getParentItem()._stringPart="d";
			return val;	
		},
		elementChanged:function(numericPart, instanceValue, event) {
			var val = numericPart + "d";
			this.getForm().itemChanged(this, val, event);
		},onChange:Composite_XFormItem.onFieldChange,
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			Textfield_XFormItem.prototype.updateElement.call(this, value);
		}
	};
	
	var selectField = 	{
		type:_OUTPUT_,
		ref:null,
		label:null,
		labelLocation:_NONE_,
		value:"d",
		getDisplayValue:function (itemVal){ return AjxMsg.days; }	
	};
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange,
		cssStyle: (anchorCssStyle ? anchorCssStyle : "width:150px")
	};
	this.items = [txtField,selectField,anchorHlpr];
	Composite_XFormItem.prototype.initializeItems.call(this);	
}

Super_Lifetime2_XFormItem.prototype.items = [ ];

/**
* _SUPER_LIFETIME_MINUTES_ XForm item type allows time interval to be expressed only in minutes
**/
Super_LifetimeMinutes_XFormItem = function() {}
XFormItemFactory.createItemType("_SUPER_LIFETIME_MINUTES_", "super_lifetime_minutes", Super_LifetimeMinutes_XFormItem, Super_Lifetime1_XFormItem);
Super_LifetimeMinutes_XFormItem.prototype.nowrap = false;
Super_LifetimeMinutes_XFormItem.prototype.labelWrap = true;
Super_LifetimeMinutes_XFormItem.prototype.numCols = 4;
Super_LifetimeMinutes_XFormItem.prototype.colSpan = 4;
Super_LifetimeMinutes_XFormItem.prototype.colSizes =["275px","80px","120px","150px"];
Super_LifetimeMinutes_XFormItem.prototype.useParenttable = false;
Super_LifetimeMinutes_XFormItem.prototype._stringPart = "d";
Super_LifetimeMinutes_XFormItem.prototype.visibilityChecks = [ZaItem.hasReadPermission];
Super_LifetimeMinutes_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];

/**
* _SUPERWIZ_LIFETIME_MINUTES_ customization or _SUPER_LIFETIME_MINUTES_ for wizard dialogs
**/
SuperWiz_LifetimeMinutes_XFormItem = function() {}
XFormItemFactory.createItemType("_SUPERWIZ_LIFETIME_MINUTES_", "superwiz_lifetime2", SuperWiz_LifetimeMinutes_XFormItem, Super_LifetimeMinutes_XFormItem);
SuperWiz_LifetimeMinutes_XFormItem.prototype.colSizes =["200px","80px","120px","150px"];
SuperWiz_LifetimeMinutes_XFormItem.prototype.visibilityChecks = [ZaItem.hasWritePermission];
SuperWiz_LifetimeMinutes_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];

Super_LifetimeMinutes_XFormItem.prototype.initializeItems = function() {
	var txtBoxLabel = this.getInheritedProperty("txtBoxLabel");
    var labelCssClass = this.getInheritedProperty("labelCssClass");
	var toolTip = this.getInheritedProperty("toolTipContent");
	
	var txtField =	{
		type:_TEXTFIELD_, ref:".", 
		label:txtBoxLabel,	
		toolTipContent: toolTip,
		nowrap:this.getInheritedProperty("nowrap"),
		labelWrap:this.getInheritedProperty("labelWrap"),		
		labelCssStyle:this.getLabelCssStyle(),
        labelCssClass:labelCssClass,
		labelLocation:(txtBoxLabel ? _LEFT_ : _NONE_),
		cssClass:"admin_xform_number_input", 
		getDisplayValue:function (itemVal) {
			var val = "1";
			if(itemVal != null && itemVal.length >0) {
				if(itemVal.length > 1) {
					val = itemVal.substr(0, itemVal.length-1);				
				} else {
					if(itemVal == "0") {
						val = "0";
					} else {
						val = "1";
					}
				}
			}
			this.getParentItem()._numericPart = val;
			this.getParentItem()._stringPart="m";
			return val;	
		},
		elementChanged:function(numericPart, instanceValue, event) {
			var val = numericPart + "m";
			this.getForm().itemChanged(this, val, event);
		},onChange:Composite_XFormItem.onFieldChange,
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			Textfield_XFormItem.prototype.updateElement.call(this, value);
		}
	};
	
	var selectField = 	{
		type:_OUTPUT_,
		ref:null,
		label:null,
		labelLocation:_NONE_,
		value:"m",
		getDisplayValue:function (itemVal){ return AjxMsg.minutes; }	
	};
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange,
		cssStyle: (anchorCssStyle ? anchorCssStyle : "width:150px")
	};
	this.items = [txtField,selectField,anchorHlpr];
	Composite_XFormItem.prototype.initializeItems.call(this);	
}

Super_LifetimeMinutes_XFormItem.prototype.items = [ ];

/**
 * Groupers
 */
TopGrouper_XFormItem.prototype.colSizes = ["275px","275px"];
TopGrouper_XFormItem.prototype.numCols = 2;

ZACheckbox_XFormItem = function() {}
XFormItemFactory.createItemType("_ZA_CHECKBOX_", "za_checkbox", ZACheckbox_XFormItem, Checkbox_XFormItem);
//ZACheckbox_XFormItem.prototype.labelLocation = _RIGHT_;
//ZACheckbox_XFormItem.prototype.align = _RIGHT_;

ZATopGrouper_XFormItem = function() {}
XFormItemFactory.createItemType("_ZA_TOP_GROUPER_", "za_top_grouper", ZATopGrouper_XFormItem, TopGrouper_XFormItem);
ZATopGrouper_XFormItem.prototype.numCols = 2;
ZATopGrouper_XFormItem.prototype.colSizes = ["275px","auto"];
ZATopGrouper_XFormItem.isGroupVisible = function(attrsArray, rightsArray,entry) {
	if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE')
		return true;

	if(!entry)
		entry = this.getInstance();
	
	if(!entry)
		return false;

	if (!entry.getAttrs)
		return false;
			
	if(!attrsArray && !rightsArray)
		return true;
		
	if(attrsArray) {
		var cntAttrs = attrsArray.length;
		for(var i=0; i< cntAttrs; i++) {
			if(ZaItem.hasReadPermission(attrsArray[i],entry)) {
				return true;
			}
		}
	} 
	
	if(rightsArray) {
		var cntRights = rightsArray.length;
		for(var i=0; i< cntRights; i++) {
			if(ZaItem.hasRight(rightsArray[i],entry)) {
				return true;
			}
		}
	}
	
	return false; 
}
ZAPlainGrouper_XFormItem = function() {}
XFormItemFactory.createItemType("_ZA_PLAIN_GROUPER_", "za_plain_grouper", ZAPlainGrouper_XFormItem, Group_XFormItem);

ZAPlainGrouper_XFormItem.prototype.colSizes = ["100%"];
ZAPlainGrouper_XFormItem.prototype.numCols = 1;
ZAPlainGrouper_XFormItem.prototype.width = "100%";
ZAPlainGrouper_XFormItem.prototype.gridLabelCss = "gridGroupBodyLabel";
ZAPlainGrouper_XFormItem.prototype.initializeItems = function () {
    var gridLabelCss = this.getInheritedProperty("gridLabelCss");
    var oldItems = this.getItems();
    var subitems;
    if(oldItems.length == 1 && oldItems[0].type == "group")  {
        oldItems[0].border = 1;
        if(oldItems[0].colSizes.length > 1)
           oldItems[0].colSizes[oldItems[0].colSizes.length -1] = "100%";
        //oldItems[0].colSizes = ["275px","100%"];
        subitems = oldItems[0].items;
    } else  subitems = oldItems;
    for(var i = 0; i < subitems.length; i++) {
        if(subitems[i].label || subitems[i].txtBoxLabel)
            //subitems[i].labelCssStyle = "text-align:left;background-color:#BBB;";
            subitems[i].labelCssClass = gridLabelCss;
    }
    Group_XFormItem.prototype.initializeItems.call(this);
}

ZAWizTopGrouper_XFormItem = function() {}
XFormItemFactory.createItemType("_ZAWIZ_TOP_GROUPER_", "zawiz_top_grouper", ZAWizTopGrouper_XFormItem, BaseTopGrouper_XFormItem);

ZAWizTopGrouper_XFormItem.prototype.numCols = 2;
ZAWizTopGrouper_XFormItem.prototype.colSizes = ["200px","auto"];
ZAWizTopGrouper_XFormItem.isGroupVisible = function(entry, attrsArray, rightsArray) {
	if(!entry)
		return true;
		
	if(!attrsArray && !rightsArray)
		return true;
		
	if(attrsArray) {
		var cntAttrs = attrsArray.length;
		for(var i=0; i< cntAttrs; i++) {
			if(ZaItem.hasWritePermission(attrsArray[i],entry)) {
				return true;
			}
		}
	} 
	
	if(rightsArray) {
		var cntRights = rightsArray.length;
		for(var i=0; i< cntRights; i++) {
			if(ZaItem.hasRight(rightsArray[i],entry)) {
				return true;
			}
		}
	}
	
	return false; 
}

ZAGroup_XFormItem = function() {}
XFormItemFactory.createItemType("_ZAGROUP_", "zagroup", ZAGroup_XFormItem, Group_XFormItem);
ZAGroup_XFormItem.prototype.numCols = 2;
ZAGroup_XFormItem.prototype.colSizes = ["275px","275px"];
ZAGroup_XFormItem.prototype.border = 1;
ZAGroup_XFormItem.prototype.width = "100%";
ZAGroup_XFormItem.prototype.cssStyle = "margin-top:20px;margin-bottom:0px;padding-bottom:0px;";
ZAGroup_XFormItem.isGroupVisible = function(entry, attrsArray, rightsArray) {
	if(!entry)
		entry = this.getInstance();

	if(!entry)
		return true;
		
	if(!attrsArray && !rightsArray)
		return true;
		
	if(attrsArray) {
		var cntAttrs = attrsArray.length;
		for(var i=0; i< cntAttrs; i++) {
			if(ZaItem.hasReadPermission(attrsArray[i],entry) || ZaItem.hasWritePermission(attrsArray[i],entry)) {
				return true;
			}
		}
	} 
	
	if(rightsArray) {
		var cntRights = rightsArray.length;
		for(var i=0; i< cntRights; i++) {
			if(ZaItem.hasRight(rightsArray[i],entry)) {
				return true;
			}
		}
	}
	
	return false; 
}

ZAGroup_XFormItem.prototype.initializeItems = function () {
    var gridLabelCss = this.getInheritedProperty("gridLabelCss") || "gridGroupBodyLabel";
    var oldItems = this.getItems();
    if(oldItems) {
        for(var i = 0; i < oldItems.length; i++) {
            if(oldItems[i].type == "radio")
                continue;  // don't deal with _RADIO_
            if(oldItems[i].label || oldItems[i].txtBoxLabel)
                //oldItems[i].labelCssStyle = "text-align:left; background-color:#BBB;";
                oldItems[i].labelCssClass = gridLabelCss;
        }
    }

    Group_XFormItem.prototype.initializeItems.call(this);
}

ZAWizGroup_XFormItem = function() {}
XFormItemFactory.createItemType("_ZAWIZGROUP_", "zawizgroup", ZAWizGroup_XFormItem, Group_XFormItem);
ZAWizGroup_XFormItem.prototype.numCols = 2;
ZAWizGroup_XFormItem.prototype.colSizes = ["125px","450px"];
ZAWizGroup_XFormItem.prototype.cssStyle = "margin-top:20px;margin-bottom:0px;padding-bottom:0px;";

ZARightGrouper_XFormItem = function() {}
XFormItemFactory.createItemType("_ZARIGHT_GROUPER_", "zaright_grouper", ZARightGrouper_XFormItem, Grouper_XFormItem);
ZARightGrouper_XFormItem.prototype.borderCssClass = "RightGrouperBorder";

ZALeftGrouper_XFormItem = function() {}
XFormItemFactory.createItemType("_ZALEFT_GROUPER_", "zaleft_grouper", ZALeftGrouper_XFormItem, Grouper_XFormItem);
ZALeftGrouper_XFormItem.prototype.borderCssClass = "LeftGrouperBorder";

ZACenterGrouper_XFormItem = function() {}
XFormItemFactory.createItemType("_ZACENTER_GROUPER_", "zacenter_grouper", ZACenterGrouper_XFormItem, Grouper_XFormItem);
ZACenterGrouper_XFormItem.prototype.borderCssClass = "CenterGrouperBorder";

ZAAllScreenGrouper_XFormItem = function() {}
XFormItemFactory.createItemType("_ZAALLSCREEN_GROUPER_", "zaallscreen_grouper", ZAAllScreenGrouper_XFormItem, Grouper_XFormItem);
ZAAllScreenGrouper_XFormItem.prototype.borderCssClass = "AllScreenGrouperBorder";

ZASmallCenterGrouper_XFormItem = function() {}
XFormItemFactory.createItemType("_ZASMALL_CENTER_GROUPER_", "zasmall_center_grouper", ZASmallCenterGrouper_XFormItem, Grouper_XFormItem);
ZASmallCenterGrouper_XFormItem.prototype.borderCssClass = "CenterGrouperBorder";
ZASmallCenterGrouper_XFormItem.prototype.labelCssClass = "SmallRadioGrouperLabel";

ZATabCase_XFormItem = function() {
	Case_XFormItem.call(this);
}
XFormItemFactory.createItemType("_ZATABCASE_", "zatabcase",ZATabCase_XFormItem, Case_XFormItem);
ZATabCase_XFormItem.prototype.caseVarRef = ZaModel.currentTab;
ZATabCase_XFormItem.prototype.visibilityChangeEventSources = [ZaModel.currentTab];
ZATabCase_XFormItem.prototype.align = _LEFT_;
ZATabCase_XFormItem.prototype.valign = _TOP_;
ZATabCase_XFormItem.prototype.paddingStyle = "padding-left:15px;";
ZATabCase_XFormItem.prototype.width = "98%";


ZATabCase_XFormItem.prototype.getTabLevel = function () {
	return this.getInheritedProperty("tabLevel") || 1;
}

ZATabCase_XFormItem.prototype.getHeaderLevel = function () {
    return this.getInheritedProperty("headerLevel") || 1;
}

ZATabCase_XFormItem.prototype.getHMargin = function () {
    return this.getInheritedProperty("hMargin") || 0;
}

ZATabCase_XFormItem.prototype.getCustomPaddingStyle = function () {
    return this.getInheritedProperty("paddingStyle");
}

ZATabCase_XFormItem.prototype.getCustomHeight = function () {
	try {
		var form = this.getForm();
        var tabLevel = this.getTabLevel () ;
        var headerLevel = this.getHeaderLevel () ;
		var formParentElement = this.getForm().parent.getHtmlElement();
		var totalHeight = parseInt(formParentElement.style.height);
		if(isNaN(totalHeight)) {
			totalHeight = formParentElement.clientHeight ? formParentElement.clientHeight : formParentElement.offsetHeight;
		}
		var formHeaders = form.getItemsById("xform_header");
		var headerHeight = 0;
		if(formHeaders) {
			var formHeader = formHeaders[0];		
			if(formHeader) {
				if(formHeader.getContainer()) {
					formHeader = formHeader.getContainer();
				}
				else {
					formHeader = formHeader.getElement();
				}

				headerHeight = formHeader.clientHeight ? formHeader.clientHeight : formHeader.offsetHeight;				
			}
		}
		var formTabBars = form.getItemsById("xform_tabbar");
		var tabBarHeight = 0;
		if(formTabBars) {
			var formTabBar = formTabBars[0];		
			if(formTabBar) {
				if(formTabBar.getContainer()) {
                                        formTabBar = formTabBar.getContainer();
                                }
				else {
					formTabBar =  formTabBar.getElement();
				}

				tabBarHeight = formTabBar.clientHeight ? formTabBar.clientHeight : formTabBar.offsetHeight;				
			}
		}
        var totalHeaderHeight = headerHeight * headerLevel ;
        var totalTabBarHeight = tabBarHeight * tabLevel ;
		if(totalHeight<=0 || totalHeight < (totalHeaderHeight + totalTabBarHeight + 2))
			return "100%";
		else
			return totalHeight - totalHeaderHeight - totalTabBarHeight - 2;
	} catch (ex) {
        
	}
	return "100%";  					
};

ZATabCase_XFormItem.prototype.getCustomWidth = function () {
	try {

		var form = this.getForm();
		var formParentElement = this.getForm().parent.getHtmlElement();
		var totalWidth = parseInt(formParentElement.style.width);
		if(isNaN(totalWidth)) {
			totalWidth = formParentElement.clientWidth ? formParentElement.clientWidth : formParentElement.offsetWidth;
		}
		if(totalWidth<=0)
			return "100%";
		else {
            var res = totalWidth - this.getHMargin();
            if(this.cacheInheritedMethod("getCustomPaddingStyle", "$getCustomPaddingStyle")) {
                var paddingStyle = this.cacheInheritedMethod("getCustomPaddingStyle", "$getCustomPaddingStyle").call(this);
                if(paddingStyle&&!AjxEnv.isIE)
                    res = res - 15;
            }
			return res;
		}
	} catch (ex) {
        
	}
	return "100%";  					
};

ZATabCase_XFormItem.prototype.resizeHdlr = 
function() {
	try {
		var element = this.getElement();
		var height = this.cacheInheritedMethod("getCustomHeight", "$getCustomHeight").call(this);
		var width = this.cacheInheritedMethod("getCustomWidth", "$getCustomWidth").call(this);
		Dwt.setSize(element, width, height);
	} catch (ex) {
		alert(ex);
	}
};

/**
 * _SUPER_TABCASE_
 * 
 * on-demand loading tab data
*/

SuperTabCase_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_TABCASE_", "super_tabcase", SuperTabCase_XFormItem, ZATabCase_XFormItem);
SuperTabCase_XFormItem.prototype.loadDataMethods = [];

SuperTabCase_XFormItem.prototype.show = function(isBlock) {
        var loadMethods = this.getInheritedProperty("loadDataMethods");

        if(loadMethods && loadMethods instanceof Array) {
                var cnt = loadMethods.length;
                for(var i = 0; i < cnt; i++) {
                        if(loadMethods[i] == null) continue;
                        if(typeof(loadMethods[i]) == "function") {
                                loadMethods[i].call(this);
                        } else if(loadMethods[i] instanceof Array) {
                                var func = loadMethods[i].shift();
                                if(!func || !func.apply) continue;
                                func.apply(this, loadMethods[i]);
                                loadMethods[i].unshift(func);
                        }
                }
        }
        Case_XFormItem.prototype.show.call(this, isBlock);
}

/**
*	_SUPER_REPEAT_ form item type
**/
SuperRepeat_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_REPEAT_", "super_repeat", SuperRepeat_XFormItem, Super_XFormItem);
SuperRepeat_XFormItem.prototype.numCols=2;
SuperRepeat_XFormItem.prototype.colSizes=["275px","275px"];
SuperRepeat_XFormItem.prototype.nowrap = false;
SuperRepeat_XFormItem.prototype.labelWrap = true;
SuperRepeat_XFormItem.prototype.items = [];
SuperRepeat_XFormItem.prototype.labelWidth = "275px";

SuperRepeat_XFormItem.prototype.initializeItems = function() {

	var items = this.getInheritedProperty("repeatItems");
		
	var repeatItem = {
		type:_REPEAT_,
		items:items,
		ref:".",
		label:null, labelLocation:_NONE_,
		repeatInstance:this.getRepeatInstance(),
		showAddButton:this.getShowAddButton(),
		showRemoveButton:this.getShowRemoveButton(),
		addButtonLabel:this.getInheritedProperty("addButtonLabel"),
		removeButtonLabel:this.getInheritedProperty("removeButtonLabel"),
		removeButtonCSSStyle:this.getInheritedProperty("removeButtonCSSStyle"),
		addButtonWidth:this.getInheritedProperty("addButtonWidth"),
		removeButtonWidth:this.getInheritedProperty("removeButtonWidth"),
		showAddOnNextRow:AjxUtil.isEmpty(this.getInheritedProperty("showAddOnNextRow")) ? true : this.getInheritedProperty("showAddOnNextRow"),
		alwaysShowAddButton:false,
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			Repeat_XFormItem.prototype.updateElement.call(this, value);
		},		
		bmolsnr:true
	}
	
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");	
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange,
		cssStyle: (anchorCssStyle ? anchorCssStyle : "width:150px")
	};
		
	this.items = [repeatItem,anchorHlpr];
	
	
	Composite_XFormItem.prototype.initializeItems.call(this);
}

/**
*	SUPER_DYNSELECT form item type
**/
Super_DynSelect_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPER_DYNSELECT_", "super_dynselect", Super_DynSelect_XFormItem, Super_XFormItem);
Super_DynSelect_XFormItem.prototype.labelCssClass = "xform_label_left";
Super_DynSelect_XFormItem.prototype.labelCssStyle = "width:275px" ;
Super_DynSelect_XFormItem.prototype.colSizes=["275px","150px"];
Super_DynSelect_XFormItem.prototype.nowrap = false;
Super_DynSelect_XFormItem.prototype.labelWrap = true;
Super_DynSelect_XFormItem.prototype.trueValue = "TRUE";
Super_DynSelect_XFormItem.prototype.falseValue = "FALSE";
Super_DynSelect_XFormItem.prototype.initializeItems = function() {
	
	
	var slct = {	type:_DYNSELECT_, ref:".",
		onChange:Composite_XFormItem.onFieldChange,
		forceUpdate:true,
	 	errorLocation:_PARENT_,
		updateElement:function(value) {
			Super_XFormItem.updateCss.call(this,5);
			DynSelect_XFormItem.prototype.updateElement.call(this, value);
		}
	};
	var anchorHlpr = {	
		type:_SUPER_ANCHOR_HELPER_, ref:".",
		visibilityChecks:[Super_XFormItem.checkIfOverWriten],
		visibilityChangeEventSources:[this.getRefPath()],
		onChange:Composite_XFormItem.onFieldChange
	};
	
	var anchorCssStyle = this.getInheritedProperty("anchorCssStyle");
	if(anchorCssStyle) {
		anchorHlpr.cssStyle = anchorCssStyle;
	} else {
		anchorHlpr.cssStyle = "width:150px";
	}	

	var choices = this.getInheritedProperty("choices");	
	
	if(choices)
		slct.choices = choices;
		
	var toolTipContent = this.getInheritedProperty("slctToolTipContent");
	if(toolTipContent) {
	 slct.toolTipContent = toolTipContent;
	}
	var dataFetcherClass = this.getInheritedProperty("dataFetcherClass");
	if(dataFetcherClass) {
	 slct.dataFetcherClass = dataFetcherClass;
	}

	var dataFetcherMethod = this.getInheritedProperty("dataFetcherMethod");
	if(dataFetcherMethod) {
	 slct.dataFetcherMethod = dataFetcherMethod;
	}
	
	this.items = [slct,anchorHlpr];
	Composite_XFormItem.prototype.initializeItems.call(this);
}	


Super_DynSelect_XFormItem.prototype.useParentTable = false;
Super_DynSelect_XFormItem.prototype.numCols = 2;

Super_DynSelect_XFormItem.prototype.items = [];

/**
*	_SUPERWIZ_DYNSELECT_ form item type
**/
SuperWiz_DynSelect_XFormItem = function () {}
XFormItemFactory.createItemType("_SUPERWIZ_DYNSELECT_", "superwiz_dynselect", SuperWiz_DynSelect_XFormItem, Super_DynSelect_XFormItem);
SuperWiz_DynSelect_XFormItem.prototype.labelCssClass = "xform_label_left ZaWizLabel";
SuperWiz_DynSelect_XFormItem.prototype.labelCssStyle = "width:200px" ;
SuperWiz_DynSelect_XFormItem.prototype.colSizes=["250px","150px"];
SuperWiz_DynSelect_XFormItem.prototype.nowrap = false;
SuperWiz_DynSelect_XFormItem.prototype.labelWrap = true;
SuperWiz_DynSelect_XFormItem.prototype.visibilityChecks = [ZaItem.hasWritePermission];
SuperWiz_DynSelect_XFormItem.prototype.enableDisableChecks = [ZaItem.hasWritePermission];

/**
 *	_Categorized_DYNSELECT_ form item type
 **/
Categorized_DynSelect_XFormItem = function () {}
XFormItemFactory.createItemType("_CATEGORIZED_DYNSELECT_", "categorized_dynselect", Categorized_DynSelect_XFormItem, DynSelect_XFormItem);
// Extra css for clickable item
Categorized_DynSelect_XFormItem.prototype.itemCSS = "ZaCategorizedSearchItem " + DynSelect_XFormItem.prototype.cssClass;
Categorized_DynSelect_XFormItem.TYPE_LABEL = "label";
Categorized_DynSelect_XFormItem.TYPE_SEARCH = "search";

Categorized_DynSelect_XFormItem.prototype.changeChoicesCallback = function(data, more, total) {
    DynSelect_XFormItem.prototype.changeChoicesCallback.call(this, this._enrichChoices(data), more, total);
}

Categorized_DynSelect_XFormItem.prototype.getChoicesHTML = function() {
    var choices = this.choices.getChoiceObject();
    if (!choices) return "";	//throw an error?

    var html = new AjxBuffer();
    this.outputChoicesHTMLStart(html);
    var choiceCssClass = this.getChoiceCssClass();
    for (var i = 0; i < choices.length; i++) {
        html.append("", this.getChoiceHTML(i, choiceCssClass));
    }

    this.outputChoicesHTMLEnd(html);
    return html.toString();
}

Categorized_DynSelect_XFormItem.prototype.getChoiceHTML = function (itemNum, cssClass) {
    var item = this.choices.getChoiceObject()[itemNum];
    if (item.type == Categorized_DynSelect_XFormItem.TYPE_LABEL) {
        return this._getLabelHTML(item.name);
    }

    var hdlr = "onSearchClick";
    var label = item.name;
    if (item.type != Categorized_DynSelect_XFormItem.TYPE_SEARCH) {
        hdlr = "onChoiceClick";
        if (item.attrs["displayName"]) {
            label = item.attrs["displayName"] + " " + label;
        }
    }

    var ref = this.getFormGlobalRef() + ".getItemById('"+ this.getId()+ "')";
    //try DIVs
    return AjxBuffer.concat("<tr><td><div id=\"", this.getId(), "_choice_", itemNum, "\" ","class=\"", cssClass, "\"",
        " onmouseover=\"",ref, ".onChoiceOver(", itemNum,", event||window.event)\"",
        " onmouseout=\"",ref, ".onChoiceOut(", itemNum,", event||window.event)\"",
        " onclick=\"",ref, ".", hdlr, "(", itemNum,")\"",
        " itemnum = '", itemNum, "'",">",this._tailorLabel(label),	"</div></td></tr>");
}

Categorized_DynSelect_XFormItem.prototype.onChoiceClick = function(num, event) {
    var item = this.choices.getChoiceObject()[num];
    if (!item) {
        return;
    }

    if (item.type == ZaItem.ACCOUNT || item.type == ZaItem.DL
        || item.type == ZaItem.RESOURCE || item.type == ZaItem.ALIAS) {
        ZaApp.getInstance().getAccountListController()._editItem(item);
        this.hideMenu();
        return;
    }

    if (item.type == ZaItem.DOMAIN) {
        ZaApp.getInstance().getDomainListController()._editItem(item);
        this.hideMenu();
        return;
    }
    if (item.type == ZaItem.COS) {
        ZaApp.getInstance().getCosListController()._editItem(item);
        this.hideMenu();
        return;
    }

}

/**
 * Handler for shortcut search menu clicked
 * @param itemNum
 * @param evt
 */
Categorized_DynSelect_XFormItem.prototype.onSearchClick = function(itemNum, evt) {
    var item = this.choices.getChoiceObject()[itemNum];
    if (item.target || item.target == "") {
        var slController =  ZaApp.getInstance().getSearchListController();
        var searchField =   slController._searchField;
        searchField.searchSelectedType = item.target;
        searchField.restoreSearchFilter();
        ZaSearchField.srchButtonHndlr.call(this, item.target);
        return;
    }
}

Categorized_DynSelect_XFormItem.prototype.getChoiceCssClass = function () {
    return this.itemCSS + "_choice";
}

Categorized_DynSelect_XFormItem.prototype.getChoiceSelectedCssClass = function () {
    return this.itemCSS + "_choice_selected";
}

Categorized_DynSelect_XFormItem.prototype.processEntryKey = function () {
    if (this.isSelecting || this.menuUp) {
        if (this.__currentHiliteItem > 0) {
            var item = this.choices.getChoiceObject()[this.__currentHiliteItem]
            if (item.type == Categorized_DynSelect_XFormItem.TYPE_SEARCH) {
                this.onSearchClick(this.__currentHiliteItem);
                return;
            } else if (item.type != Categorized_DynSelect_XFormItem.TYPE_LABEL) {
                this.onChoiceClick(this.__currentHiliteItem);
                this._searchFieldValue("");
                return;
            }

        }

    }
    var value = this.getInstanceValue();
    var processEntryKey = this.getInheritedProperty("entryKeyMethod");
    if (processEntryKey instanceof AjxCallback) {
        processEntryKey.run(this, value);
    }
}

Categorized_DynSelect_XFormItem.prototype.hiliteNextChoice = function() {
    do {
        DynSelect_XFormItem.prototype.hiliteNextChoice.call(this);
        var item = this.choices.getChoiceObject()[this.__currentHiliteItem];
    } while (item.type == Categorized_DynSelect_XFormItem.TYPE_LABEL);
}

Categorized_DynSelect_XFormItem.prototype.hilitePreviousChoice = function() {
    do {
        DynSelect_XFormItem.prototype.hilitePreviousChoice.call(this);
        var item = this.choices.getChoiceObject()[this.__currentHiliteItem];
    } while (item.type == Categorized_DynSelect_XFormItem.TYPE_LABEL);
}

//Add data to categorize the dynamic drop down.
Categorized_DynSelect_XFormItem.prototype._enrichChoices = function(data) {
    if (data.length <= 0) {
        return data;
    }

    var stats = {};
    for (var i = 0; i < data.length; i++) {
        stats[data[i].type] = 1;
        data[i].value = "";
    }

    var realQuery = this._searchFieldValue();
    var displayQuery = "\"" + realQuery + "\"";
    data.splice(0, 0, {type : Categorized_DynSelect_XFormItem.TYPE_LABEL, name: ZaMsg.SearchBestMatches, value: realQuery});
    data.push({type : Categorized_DynSelect_XFormItem.TYPE_LABEL, name: "&nbsp;", value: realQuery});
    data.push({type : Categorized_DynSelect_XFormItem.TYPE_LABEL, name: ZaMsg.SearchFullResultsFor, value: realQuery});

    data.push({type : Categorized_DynSelect_XFormItem.TYPE_SEARCH, name: displayQuery, value:realQuery, target:""});

    for (var prop in stats) {
        if (stats.hasOwnProperty(prop)) {
            var searchAttr = ZaSearch.TYPES[prop];
            data.push({type : Categorized_DynSelect_XFormItem.TYPE_SEARCH, name: AjxMessageFormat.format(ZaMsg["SearchAll_" + searchAttr],[displayQuery]), value: realQuery, target:searchAttr});

        }
    }

    return data;
}

//Generate HTML for label
Categorized_DynSelect_XFormItem.prototype._getLabelHTML = function (label) {
    return AjxBuffer.concat("<tr><td><div class='ZaCategorizedSearchLabel'>", label, "</div></td></tr>");
}

//Tail the label if it is too long
Categorized_DynSelect_XFormItem.prototype._tailorLabel = function (label) {
    var itemW = Dwt.getBounds(this.getContainer()).width - 20;

    //assume 5.5px per letter
    var maxNumberOfLetters = Math.floor((itemW - 30)/5.5);
    if (maxNumberOfLetters < label.length){
        label = label.substring(0, (maxNumberOfLetters - 3)) + "...";
    }
    return label;
}

// Get query from search field
Categorized_DynSelect_XFormItem.prototype._searchFieldValue = function (val) {
    var slController =  ZaApp.getInstance().getSearchListController();
    var searchField =   slController._searchField;
    if (arguments.length == 0) {
        return searchField.getSearchFieldElement().value;
    }
    searchField.getSearchFieldElement().value = val;

}


/**
* _IP_
**/
// this is only for ip address
Ip_XModelItem = function (){}
XModelItemFactory.createItemType("_IP_", "ip", Ip_XModelItem, String_XModelItem);
Ip_XModelItem.EXACT_IP_ADDRESS_RE = /^((25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)\.){3}(25[0-5]|2[0-4]\d|(1\d|[1-9])\d|[1-9])$/;
Ip_XModelItem.prototype.validateType = function (value) {
	if (value){
		if (!AjxUtil.isString(value)) {
			throw this.getModel().getErrorMessage("notAString", value);
		}

		if(Ip_XModelItem.EXACT_IP_ADDRESS_RE.test(value)) {
			return value;
		} else {
			throw ZaMsg.ERROR_INVALID_IP_ADDR;
		}
	}
};
Ip_XModelItem.prototype.maxLength = 64;

/**
 *  <code>Collaborated_Select_XFormItem</code> is a subclass of <code>Repeat_XFormItem</code>, it might be used under the
 *  following condition:
 *  <ul>
 *      <li>You need a repeat item;
 *      <li>In the repeat, the values of a select must be different. E.g. Choices of the select is [ItemA, ItemB], if
 *      in one instance, ItemA is selected. In the second one, only ItemB is available in the options.
 *      <li>If the select is required, the add button will be invisible if the the instance number is greater or equal
 *      than the choices number of the select.
 *  </ul>
 *
 *  Usage:
 *  <ul>
 *      <li>Set <code>colSelect:true</code> for the select;
 *      <li>Set <code>filterMethod</code> if you want to exclude some choices;
 *  </ul>
 */
Collaborated_Select_XFormItem = function() {}
XFormItemFactory.createItemType("_COLLAB_SELECT_", "collaborated_select", Collaborated_Select_XFormItem, Repeat_XFormItem);

Collaborated_Select_XFormItem.prototype.initializeItems = function () {
    //Find a select that needs to be collaborated
    this.colSelect = this._findColSelect(this.getItems());
    if (!this.colSelect) {
        return;
    }

    //Add ancestorId so that it can be easily locate its ancestor
    this.colSelect.ancestorId = this.id;
    //Add a select listener to update other selecters' choices
    this.colSelect.onChange = Collaborated_Select_XFormItem.selectChanged;
    var origChoices = this.colSelect.choices;
    //Create a new choices object, to avoid the future changes on the choices will bring side effect on the original one.
    var newChoices = new XFormChoices(origChoices.getChoiceObject(), origChoices._type, origChoices._valueProperty, origChoices._labelProperty);
    this.colSelect.choices = newChoices;

    this.choiceItems = origChoices.getChoiceObject();
    this.__ownChoices = newChoices;
    this.__valueProperty = origChoices._valueProperty;
    this.__availNum = this.choiceItems.length;
    this.__selected = [];
    this.__excluded = [];

    if (this.colSelect.required == true) {
        this.getAddButton().visibilityChecks.push(Collaborated_Select_XFormItem.isAddButtonVisible);
    }

    Repeat_XFormItem.prototype.initializeItems.call(this);
}

Collaborated_Select_XFormItem.prototype.getFilterMethod = function() {
    return this.cacheInheritedMethod("filterMethod","$filterMethod");
}

Collaborated_Select_XFormItem.prototype.updateElement = function (value) {
    if (this.__origInstance != this.getForm().getInstance()) {
        this.__origInstance = this.getForm().getInstance();

        if (this.getFilterMethod() && AjxUtil.isFunction(this.getFilterMethod())){
            var excluded = this.getFilterMethod().call(this, this.getForm().getInstance());
            this.filterOrigItems(excluded);
            this.resetChoices();
        } else {
            this.resetChoices(true);
        }

    }
    Repeat_XFormItem.prototype.updateElement.call(this, value);
}

Collaborated_Select_XFormItem.prototype.resetChoices = function (resetAll) {
    if (!this.colSelect) {
        return;
    }

    this.__selected = [];

    if (resetAll) {
        this.__excluded = [];
        this.__availNum = this.choiceItems.length;
    }
    this._updateChoices();
}

Collaborated_Select_XFormItem.selectChanged = function (newVal, event, form) {
    var ancestor = form.getItemById(this.__attributes.ancestorId);
    var current = this.getInstanceValue();
    this.setInstanceValue(newVal);
    ancestor._markSelected(newVal, current);

    //Update the choices after the menu is collapsed.
    var act = new AjxTimedAction(ancestor,Collaborated_Select_XFormItem.prototype._updateChoices,[]);
    AjxTimedAction.scheduleAction(act,ZaController.CLICK_DELAY);
}

Collaborated_Select_XFormItem.isAddButtonVisible = function () {
    if (!this.getParentItem().getParentItem().colSelect) {
        return true;
    }
    return (this.getParentItem().getInstanceCount() < this.getParentItem().getParentItem().__availNum);
}

Collaborated_Select_XFormItem.prototype.filterOrigItems = function(vals) {
    if (!this.choiceItems || !(this.choiceItems instanceof Array) || !vals) {
        return;
    }
    if (!(vals instanceof Array)) {
        vals = [vals];
    }
    var num = 0;
    for (var j = 0; j < this.choiceItems.length; j++) {
        this.__excluded[j] = false;
        for (var i = 0; i < vals.length; i++) {
            if (this.choiceItems[j][this.__valueProperty] == vals[i]) {
                this.__excluded[j] = true;
                num++;
                break;
            }
        }
    }
    this.__availNum -= num;
}

Collaborated_Select_XFormItem.prototype.addRowButtonClicked = function (instanceNum) {
    Repeat_XFormItem.prototype.addRowButtonClicked.call(this, instanceNum);
    this._updateChoices();
}

Collaborated_Select_XFormItem.prototype.removeRowButtonClicked = function (instanceNum) {
    var removedItem = this.getInstanceValue()[instanceNum];
    var removed = removedItem[this.colSelect.ref];
    this._markSelected(null, removed);
    this._updateChoices();

    Repeat_XFormItem.prototype.removeRowButtonClicked.call(this, instanceNum);
}

Collaborated_Select_XFormItem.prototype._updateChoices = function () {
    this.__ownChoices.setChoices(this._getSelectable());
    this.__ownChoices.dirtyChoices();
}

Collaborated_Select_XFormItem.prototype._findColSelect = function(obj) {
    if (!obj) {
        return;
    }

    if (obj.type == "oselect1") {
        if (obj.colSelect) {
            return obj;
        }
        return;
    }

    var items;
    if (obj.items && obj.items instanceof Array) {
        items = obj.items;
    } else if (obj instanceof Array) {
        items = obj;
    }

    if (items) {
        for (var i = 0; i < items.length; i++) {
            var result = this._findColSelect(items[i]);
            if (result ) {
                return result;
            }
        }
    }
}

Collaborated_Select_XFormItem.prototype._markSelected = function(newVal, oldVal) {
    for (var i = 0; i < this.choiceItems.length; i++) {
        if (this.choiceItems[i][this.__valueProperty] == oldVal) {
            this.__selected[i] = false;
        }
    }
    for (var i = 0; i < this.choiceItems.length; i++) {
        if (this.choiceItems[i][this.__valueProperty] == newVal) {
            this.__selected[i] = true;
        }
    }
}

Collaborated_Select_XFormItem.prototype._getSelectable = function() {
    var result = [];
    for (var i = 0; i < this.choiceItems.length; i++) {
        if (this.__excluded[i]) {
            continue;
        }
        if (this.__selected[i]) {
            continue;
        }
        result.push(this.choiceItems[i]);
    }
    return result;
}

}
if (AjxPackage.define("zimbraAdmin.common.ZaSplashScreen")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

ZaSplashScreen =function(parent) {
    var className = "LoginScreen";
    DwtComposite.call(this, {parent:parent, className:className, posStyle:DwtControl.ABSOLUTE_STYLE});
    this._origClassName = className;
    this._xparentClassName = className + "-Transparent";
    this.setBounds(0, 0, "100%", "100%");
    var htmlElement = this.getHtmlElement();
    htmlElement.style.zIndex = Dwt.Z_SPLASH;
    htmlElement.className = className;
    this.setVisible(false);
    
	var params = ZLoginFactory.copyDefaultParams(ZaMsg);
	params.showPanelBorder = true;
	params.showForm = true;
	params.showUserField =false ;
	params.showPasswordField = false;
	params.showRememberMeCheckbox = false;
	params.showLogOff = false;
	params.showButton = false;
    params.showLoading = true ;
    params.companyURL = ZaAppCtxt.getLogoURI () ;
    params.copyrightText = ZaItem.getSplashScreenCopyright();
    params.clientLevelNotice = ZabMsg.clientLevelNotice ? ZabMsg.clientLevelNotice :"";
    var html = ZLoginFactory.getLoginDialogHTML(params);
	this.setContent(html);
}

ZaSplashScreen.prototype = new DwtComposite;
ZaSplashScreen.prototype.constructor = ZaSplashScreen;
ZaSplashScreen.prototype.toString = 
function() {
	return "ZaSplashScreen";
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaCurrentAppToolBar")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* This toolbar sits above the overview and represents the current app. It has a label
* that tells the user what the current app is, and an optional View button/menu for
* switching views within the current app.
* @class
*/
ZaCurrentAppToolBar = function(parent, className, buttons) {

	DwtToolBar.call(this, parent, className, Dwt.ABSOLUTE_STYLE);

	this._currentAppLabel = new ZaToolBarLabel(this, DwtLabel.IMAGE_LEFT | DwtLabel.ALIGN_LEFT, "currentAppLabel");
	this._currentTitle = null;
	this._lastWidth = null;
	this._currentWidth = null;
	this.addFiller();
}

ZaCurrentAppToolBar.prototype = new DwtToolBar;
ZaCurrentAppToolBar.prototype.constructor = ZaCurrentAppToolBar;

ZaCurrentAppToolBar.prototype.toString = 
function() {
	return "ZaCurrentAppToolBar";
}

ZaCurrentAppToolBar.prototype._resizeListener = 
function() {
	if(!this._currentTitle)
		return;
	
	if(!this._currentWidth && !this._lastWidth){
		this._lastWidth = this._currentWidth = this.getBounds().width;
		this.setCurrentAppLabel(this._currentTitle);
	} else {
		this._currentWidth = this.getBounds().width;
		if(this._lastWidth != this._currentWidth ){
	         	this._lastWidth = this._currentWidth;
			this.setCurrentAppLabel(this._currentTitle);
		}
	}
}

ZaCurrentAppToolBar.prototype.setCurrentAppLabel = 
function(title) {
	this._currentTitle = title;
	if(!this._currentWidth && !this._lastWidth){
        	this._lastWidth = this._currentWidth = this.getBounds().width;
	}
	
	var totalCharWidth = ZaCurrentAppToolBar.getWidth(title);

	if(totalCharWidth > (this._currentWidth - 10) ){ //reserver 10 px
		var textLength = this._currentWidth -  ZaCurrentAppToolBar.getWidth("...") - 10;
		var maxNumberOfLetters=  Math.floor(textLength * (title.length) / totalCharWidth);
		title = title.substring(0, (maxNumberOfLetters - 3)) + "...";
	}
	
	this._currentAppLabel.setText(title);
	//this._currentAppLabel.setImage(ZaZimbraAdmin.APP_ICON[appName]);
}

ZaCurrentAppToolBar.WIDTH = {};
ZaCurrentAppToolBar._cacheSize = 0;
ZaCurrentAppToolBar.MAX_CACHE_SIZE = 10;
ZaCurrentAppToolBar.getWidth = 
function(str){
	if(!ZaCurrentAppToolBar._testSpan){
		var span= ZaCurrentAppToolBar._testSpan = document.createElement("SPAN");
		span.style.position = Dwt.ABSOLUTE_STYLE;
		var shellEl =  DwtShell.getShell(window).getHtmlElement();
		shellEl.appendChild(span);
		Dwt.setLocation(span, Dwt.LOC_NOWHERE, Dwt.LOC_NOWHERE);
		span.style.fontWeight = "bold";
		span.style.fontSize = "13px";
	}

	var cache = ZaCurrentAppToolBar.WIDTH;
	if(cache[str])
		return cache[str];
	
	if(ZaCurrentAppToolBar._cacheSize >= ZaCurrentAppToolBar.MAX_CACHE_SIZE){
		ZaCurrentAppToolBar.WIDTH = {};
		ZaCurrentAppToolBar._cacheSize = 0;
	}
	
	var span = ZaCurrentAppToolBar._testSpan;
	span.innerHTML = str;
	var w = cache[str] = Dwt.getSize(span).x;
	ZaCurrentAppToolBar._cacheSize++;

	return w;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaCrtAppTreeHeader")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Created by IntelliJ IDEA.
 * User: mingzhang
 * Date: 8/17/11
 * Time: 12:12 AM
 * To change this template use File | Settings | File Templates.
 */

ZaCrtAppTreeHeader = function(parent, className, buttons) {
    var cssClass = className || "ZaCtrAppTreeHeader";
	DwtButton.call(this, parent, "", cssClass, Dwt.ABSOLUTE_STYLE);
    this.preObj = null;
	this._historyMgr = ZaZimbraAdmin.getInstance().getHistoryMgr();
    this._historyMgr.addChangeListener(new AjxListener(this, this.updateMenu));
    this.menu = new ZaPopupMenu(this);
    this.menu.setWidth(150);
    this.setMenu(this.menu);
    //this.setRightImg();
}

ZaCrtAppTreeHeader.prototype = new DwtButton;
ZaCrtAppTreeHeader.prototype.constructor = ZaCrtAppTreeHeader ;
ZaCrtAppTreeHeader.prototype._dropDownImg = "";
ZaCrtAppTreeHeader.prototype._dropDownDepImg = "";
ZaCrtAppTreeHeader.prototype._dropDownHovImg = "";
ZaCrtAppTreeHeader.defaultImg = "CollapseLeft";
ZaCrtAppTreeHeader.normalBgImg = "ImgArrowShapeNormal";
ZaCrtAppTreeHeader.hoverBgImg = "ImgArrowShapeHover";

ZaCrtAppTreeHeader.prototype.toString =
function() {
	return "ZaCrtAppTreeHeader";
}

ZaCrtAppTreeHeader.prototype.TEMPLATE = "admin.Widgets#ZaTreeHeaderButton";

ZaCrtAppTreeHeader.prototype._createHtmlFromTemplate = function(templateId, data) {
    data.bgImg = ZaCrtAppTreeHeader.normalBgImg;
    DwtButton.prototype._createHtmlFromTemplate.call(this, templateId, data);
    this._tabelEl = document.getElementById(data.id+"_table");
    this._arrowEl = document.getElementById(data.id+"_doubleArrow");
    this._imgEl = document.getElementById(data.id+"_img");
};

ZaCrtAppTreeHeader.prototype.setRightImg = function (imgName) {
    if (!this._imgEl)
        return;

    var localImg = imgName || ZaCrtAppTreeHeader.defaultImg;
    this._imgEl.innerHTML = AjxImg.getImageHtml(localImg);
}

ZaCrtAppTreeHeader.prototype._handleClick =
function(ev) {
    if (this._isArrowEvent(ev)) {
        var tree = ZaZimbraAdmin.getInstance().getOverviewPanelController().getOverviewPanel().getFolderTree();
        tree.setSelectionByPath(this.preObj.path, false);
    }
    // Nothing doing here
}

ZaCrtAppTreeHeader.prototype._getPreviousObject = function(path) {

    var tree = ZaZimbraAdmin.getInstance().getOverviewPanelController().getOverviewPanel().getFolderTree();
    var currentRoot = tree.getCurrentRootItem();
    var dataItem = currentRoot.getData("dataItem");
    var path = tree.getABPath(dataItem);
    var pathItems = ZaTree.getPathItems(path);
    if (pathItems.length > 1) {
        // Special case for search. We use a special path to specify a view
        if (pathItems[1] == ZaMsg.OVP_search) {
            pathItems = [pathItems[0]];
        } else {
            pathItems.pop();
        }
    }

    var displayName = pathItems[pathItems.length - 1];
    var resultPath = ZaTree.getPathByArray(pathItems);
    return new ZaHistory(resultPath, displayName);
}

ZaCrtAppTreeHeader.prototype._showHoverImage =
function(show) {
    if (this._tabelEl) {
        if (show) {
            Dwt.delClass(this._tabelEl, ZaCrtAppTreeHeader.normalBgImg, ZaCrtAppTreeHeader.hoverBgImg);
        } else {
            Dwt.delClass(this._tabelEl, ZaCrtAppTreeHeader.hoverBgImg, ZaCrtAppTreeHeader.normalBgImg);
        }
    }

}

ZaCrtAppTreeHeader.prototype._isDropDownEvent =
function(ev) {
	if (this._dropDownEventsEnabled && this._dropDownEl) {
		var mouseX = ev.docX;
		var dropDownX = Dwt.toWindow(this._dropDownEl, 0, 0, window).x;
        var isAfterDropDown = true;
		if (mouseX < dropDownX) {
			isAfterDropDown = false;
		}
        var isBeforeCollapse =  true;
        if (this._imgEl) {
            var imgX =  Dwt.toWindow(this._imgEl, 0, 0, window).x;
            if (mouseX >= imgX)
                isBeforeCollapse = false;
        }
        return isAfterDropDown && isBeforeCollapse;
	}
	return false;
};

ZaCrtAppTreeHeader.prototype._isArrowEvent =
function(ev) {
    if (this._arrowEl && this._textEl) {
        var arrowBounds = Dwt.getBounds(this._arrowEl);
        var textBounds = Dwt.getBounds(this._textEl);
        var start = arrowBounds.x;
        var end = textBounds.x + textBounds.width;
        var mouseX = ev.docX;
        if (mouseX < start)
            return false;
        if (mouseX >= end)
            return false;
        return true;
    }
    return false;
}

ZaCrtAppTreeHeader.prototype.setText = function (historyObject) {
    this.preObj = this._getPreviousObject();
    var displayText = this.getDisplayContent(this.preObj.displayName);
	DwtLabel.prototype.setText.call(this, displayText);
}

ZaCrtAppTreeHeader.prototype.getDisplayContent= function (text) {
    var displayText = text;
    if (text) {
        var titleWidth = Dwt.getSize(this._textEl);
        var totalTextWidth = AjxStringUtil.getWidth(text);
        if (totalTextWidth > titleWidth.x) {
            var totalNumber = text.length;
            var textLength = titleWidth.x - AjxStringUtil.getWidth("...");
            var maxNumberOfLetters = Math.floor(textLength*totalNumber/totalTextWidth);
            displayText = text.substring(0, maxNumberOfLetters) + "...";
        }
    }
    return displayText;
}

ZaCrtAppTreeHeader.prototype.popup =
function(menu) {
	menu = menu || this.getMenu();

    if (!menu) { return; }

    var parent = menu.parent;
	var parentBounds = parent.getBounds();
	var windowSize = menu.shell.getSize();
	var menuSize = menu.getSize();
	var parentElement = parent.getHtmlElement();
	// since buttons are often absolutely positioned, and menus aren't, we need x,y relative to window
	var parentLocation = Dwt.toWindow(parentElement, 0, 0);
	var leftBorder = (parentElement.style.borderLeftWidth == "") ? 0 : parseInt(parentElement.style.borderLeftWidth);

	var x;
    var dropDownEl = parent._dropDownEl;
    if (!dropDownEl) {
	    x = parentLocation.x + leftBorder;
    } else {
        var dropDownLocation = Dwt.toWindow(dropDownEl, 0, 0);
        x = dropDownLocation.x;
    }
	x = ((x + menuSize.x) >= windowSize.x) ? windowSize.x - menuSize.x : x;

	var y;

    var horizontalBorder = (parentElement.style.borderTopWidth == "") ? 0 : parseInt(parentElement.style.borderTopWidth);
    horizontalBorder += (parentElement.style.borderBottomWidth == "") ? 0 : parseInt(parentElement.style.borderBottomWidth);
    y = parentLocation.y + parentBounds.height + horizontalBorder;

	menu.popup(0, x, y);
};

ZaCrtAppTreeHeader.searchHistoryCache = {};
ZaCrtAppTreeHeader.isFound = function (path) {
    if(!ZaCrtAppTreeHeader.searchHistoryCache[path]) {
        ZaCrtAppTreeHeader.searchHistoryCache[path] = true;
        return  false;
    }
    return true;
}

ZaCrtAppTreeHeader.prototype.createMenu = function
() {
    var i = 0;
    var mi;
    var listener = new AjxListener(this, this.goToTreeItemListener);
    var allHistory = this._historyMgr.getAllHistory();

    ZaCrtAppTreeHeader.searchHistoryCache = {};
    if(allHistory.size() > 20) {
        var j = allHistory.size()-1;
        var findNum = 0;
        for (j = allHistory.size() - 1; j >= 0; j--) {
            var currentHistory = allHistory.get(j);
            if(!currentHistory.isShowInHistory)
                continue;

            if (ZaCrtAppTreeHeader.isFound(currentHistory.path))
                continue;

            findNum++;
            if (findNum == 20)
                break;
        }

        if (j > 0)
            i = j;
    }
    // Always add home here.
    var currentHistory;
    if (i > 0) {
        currentHistory = allHistory.get(0);
        mi = new DwtMenuItem({
		                parent: this.menu,
		                style:		DwtMenuItem.NO_STYLE,
		                id:     ZaId.getMenuItemId(this._contextId, i + currentHistory.path)
	    });
        mi.setText(currentHistory.displayName);
        mi.setData("history", currentHistory);
        mi.addSelectionListener(listener);
        i = i + 1;
    }

    ZaCrtAppTreeHeader.searchHistoryCache = {};
    var minIndex = i;
    for (i =  allHistory.size() - 1; i >= minIndex; i--) {
        currentHistory = allHistory.get(i);
        if (!currentHistory.isShowInHistory)
            continue;

        if (ZaCrtAppTreeHeader.isFound(currentHistory.path))
            continue;

        mi = new DwtMenuItem({
		                parent: this.menu,
		                style:		DwtMenuItem.NO_STYLE,
		                id:     ZaId.getMenuItemId(this._contextId, i + currentHistory.path)
	    });
        mi.setText(currentHistory.displayName);
        mi.setEnabled(currentHistory.enabled);
        mi.setData("history", currentHistory);
        mi.addSelectionListener(listener);
    }

    this.menu.createSeparator();

    mi = new DwtMenuItem({
                    parent: this.menu,
                    style:		DwtMenuItem.NO_STYLE,
                    id:     ZaId.getMenuItemId(this._contextId, "clearHistory")
    });
    mi.setText(ZaMsg.LBL_Treeheader_clearHistory);
    mi.setData("history", currentHistory);
    mi.addSelectionListener(new AjxListener(this, this.clearHistory));
}

ZaCrtAppTreeHeader.prototype.updateMenu =
function() {
    this.menu.removeChildren();
    this.createMenu();
}

ZaCrtAppTreeHeader.prototype.goToTreeItemListener = function (ev) {
    var historyObject =  ev.item.getData("history");
    historyObject.goToView();
}

ZaCrtAppTreeHeader.prototype.clearHistory = function (ev) {
    this._historyMgr.removeHistory();
}

}
if (AjxPackage.define("zimbraAdmin.common.ZaServerVersionInfo")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */


ZaServerVersionInfo = function() {}

ZaServerVersionInfo.load = function () {
	if (!ZaServerVersionInfo._loaded){
		var soapDoc = AjxSoapDoc.create("BatchRequest", "urn:zimbra");
		soapDoc.setMethodAttribute("onerror", "continue");
		var versionInfoReq = soapDoc.set("GetVersionInfoRequest", null, null, ZaZimbraAdmin.URN);
		
		
		//var licenseInfoReq = soapDoc.set("GetLicenseInfoRequest");
		//licenseInfoReq.setAttribute("xmlns", ZaZimbraAdmin.URN);
		var command = new ZmCsfeCommand();
		var params = new Object();
		params.soapDoc = soapDoc;	
		params.noAuthToken = true;
		var resp = command.invoke(params).Body.BatchResponse;		
		var versionResponse = resp.GetVersionInfoResponse[0];

		ZaServerVersionInfo.buildDate = this._parseDateTime(versionResponse.info[0].buildDate);
		ZaServerVersionInfo.host = versionResponse.info[0].host;
		ZaServerVersionInfo.release = versionResponse.info[0].release;
		ZaServerVersionInfo.version = versionResponse.info[0].version;
		//license expiration information is handled in com_zimbra_license.js
	}
};

ZaServerVersionInfo._parseDate = function (dateTimeStr) {
	var d = new Date();
	d.setHours(0, 0, 0, 0);
	var yyyy = parseInt(dateTimeStr.substr(0,4), 10);
	var MM = parseInt(dateTimeStr.substr(4,2), 10);
	var dd = parseInt(dateTimeStr.substr(6,2), 10);
	d.setFullYear(yyyy);
	// EMC 8/31/05 - fix for bug 3839. It looks like firefox needs to call setMonth twice for 
	// dates starting sept 1. No good reason at this point, but I noticed that
	// setting it twice seems to do the trick. Very odd.
	d.setMonth(MM - 1);
	d.setMonth(MM - 1);
	d.setDate(dd);
	return d;
};
ZaServerVersionInfo._parseDateTime = function (dateTimeStr) {
	var d = ZaServerVersionInfo._parseDate(dateTimeStr);
	var hh = parseInt(dateTimeStr.substr(9,2), 10);
	var mm = parseInt(dateTimeStr.substr(11,2), 10);
	d.setHours(hh, mm, 0, 0);
	return d;
};
}
if (AjxPackage.define("zimbraAdmin.common.MenuButton_XFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
 
/**
* @class defines XFormItem type  _MENU_BUTTON_
* Adapts a DwtButton with a drop-down menu of choices to work with the XForm
* @constructor
* @author Greg Solovyev
**/
MenuButton_XFormItem = function() {}
XFormItemFactory.createItemType("_MENU_BUTTON_", "menu_button", MenuButton_XFormItem, Dwt_Button_XFormItem);
MenuButton_XFormItem.prototype.constructWidget = function () {
	var widget = Dwt_Button_XFormItem.prototype.constructWidget.call(this);
	var opList = this.getNormalizedValues();
	if (opList && opList.length) {
		var menu = new ZaPopupMenu(widget, null,null, opList);
		widget.setMenu(menu);
	}
	return widget;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaAutoCompleteListView")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* Creates a new autocomplete list. The list isn't populated or displayed until some
* autocompletion happens. Takes a data class and loader, so that when data is needed (it's
* loaded lazily), the loader can be called on the data class.
* @constructor
* @class
* This class implements autocomplete functionality. It has two main parts: matching data based
* on keystroke events, and displaying/managing the list of matches. This class is theoretically
* neutral concerning the data that gets matched (as long as its class has an autocompleteMatch()
* method), and the field that it's being called from.
* <p>
* The data class's autocompleteMatch() method should returns a list of matches, where each match is
* an object with the following properties:</p>
* <table border="1">
* <tr><td>data</td><td>the object being matched</td></tr>
* <tr><td>text</td><td>the text to display for this object in the list</td></tr>
* <tr><td>[key1]</td><td>a string that may be used to replace the typed text<td></tr>
* <tr><td>[keyN]</td><td>a string that may be used to replace the typed text<td></tr>
* </table>
* </p><p>
* The data class will also need a method isUniqueValue(str), which returns true if the given string
* maps to a single match.
* </p><p>
* The calling client also specifies the key in the match result for the string that will be used
* to replace the typed text (also called the "completion string"). For example, the completion 
* string for matching contacts could be a full address, or just the email.
* </p>
* 
* @author Conrad Damon
* @param parent				the element that created this list
* @param className			CSS class
* @param dataLoaderClass			the class that has the data loader
* @param dataLoaderMethod	a method of dataLoaderClass that returns data to match against
* @param matchValue			name of field in match result to use for completion
* @param inputFieldElement	(HTMLTextAreaElement) the input field element which autocomplete is used for
* @param locCallback		callback into client to get desired location of autocomplete list
* @param compCallback		callback into client to notify it that completion happened
* @param separator			separator (gets added to the end of a match)
*/
var i = 1 ;
//ZaSettings.AC_TIMER_INTERVAL = i ++;

ZaAutoCompleteListView = function(params) {

	var className = params.className ? params.className : "autoCompleteList";
	DwtComposite.call(this, params.parent, className, DwtControl.ABSOLUTE_STYLE);
	
//	this._appCtxt = this.shell.getData(ZaAppCtxt.LABEL);
	var app = null;
	try {
		this.shell.getData(ZaAppCtxt.LABEL).getApp();
	}catch (e){
		DBG.println(e.message);
	}
	var _dataLoaderClass = params.dataLoaderClass;
	this._dataLoaderObject = new _dataLoaderClass();
	this._dataLoaderMethod = params.dataLoaderMethod;
	this._dataLoading = false;
	this._data = null ;
	this._matchValue = params.matchValue ? params.matchValue : "inputFieldCompleteValue";
	this._matchText = params.matchText ? params.matchText : "matchListFieldText" ;
	this._inputFieldXFormItem = params.inputFieldXFormItem ;
	this._inputFieldXForm = this._inputFieldXFormItem.getForm() ;
	this._inputFieldElement = this._inputFieldXFormItem.getElement() ;
	this._locCallback = params.locCallback;
	this._compCallback = params.compCallback;
	this._separator = (params.separator != null) ? params.separator : ";";
	
	// mouse event handling
	this._setMouseEventHdlrs();
	this.addListener(DwtEvent.ONMOUSEDOWN, new AjxListener(this, this._mouseDownListener));
	this.addListener(DwtEvent.ONMOUSEOVER, new AjxListener(this, this._mouseOverListener));
	this._addSelectionListener(new AjxListener(this, this._listSelectionListener));
	this._outsideListener = new AjxListener(this, this._outsideMouseDownListener);

	// only trigger matching after a sufficient pause
	this._acInterval = 300 ;
	this._acAction = new AjxTimedAction(null, this._autocompleteAction);
	this._acActionId = -1;

	// for managing focus on Tab in Firefox
	if (AjxEnv.isFirefox) {
		this._focusAction = new AjxTimedAction(null, this._focus);
	}

	this._internalId = AjxCore.assignId(this);
	this._numChars = 0;
	this._matches = new AjxVector();
	this._done = new Object();
	this.setVisible(false);
	
	//set the handler to the input field element
	this.handle(this._inputFieldElement);
}

ZaAutoCompleteListView.prototype = new DwtComposite;

// map of characters that are completion characters
ZaAutoCompleteListView.DELIMS = [',', ';', '\n', '\r', '\t'];
ZaAutoCompleteListView.IS_DELIM = new Object();
for (var i = 0; i < ZaAutoCompleteListView.DELIMS.length; i++)
	ZaAutoCompleteListView.IS_DELIM[ZaAutoCompleteListView.DELIMS[i]] = true;

// Public static methods

/**
* "onkeydown" handler for catching Tab and Esc keys. We don't want to let the browser
* handle this event for those (which it will do before we get the keyup event).
*
* @param ev		the key event
*/
ZaAutoCompleteListView.onKeyDown =
function(ev) {
	DBG.println(AjxDebug.DBG3, "onKeyDown");
	var element = DwtUiEvent.getTargetWithProp(ev, "id");
	var aclv = element && AjxCore.objectWithId(element._acListViewId);
	if (aclv) {
		aclv._inputLength = element.value.length;
	}
	var key = DwtKeyEvent.getCharCode(ev);
	return (key == DwtKeyEvent.KEY_TAB || key == DwtKeyEvent.KEY_ESCAPE) ? ZaAutoCompleteListView.onKeyUp(ev) : true;
}

/**
* "onkeyup" handler for performing autocompletion. The reason it's an "onkeyup" handler is that neither 
* "onkeydown" nor "onkeypress" arrives after the form field has been updated.
*
* @param ev		the key event
*/
ZaAutoCompleteListView.onKeyUp =
function(ev) {
	ev = DwtUiEvent.getEvent(ev);
	if (ev.type == "keyup")
		DBG.println(AjxDebug.DBG3, "onKeyUp");
	var element = DwtUiEvent.getTargetWithProp(ev, "id");
	var aclv = AjxCore.objectWithId(element._acListViewId);
	
	var id = element.id;
	var key = DwtKeyEvent.getCharCode(ev);
	// Tab/Esc handled in keydown for IE
	if (AjxEnv.isIE && ev.type == "keyup" && (key == 9 || key == 27))
		return true;
	var value = element.value;
	DBG.println(AjxDebug.DBG3, ev.type + " event, key = " + key + ", value = " + value);
	ev.inputLengthChanged = (value.length != aclv._inputLength);

	var inputFieldOldValue;
	if (aclv._inputFieldXFormItem) {
		DBG.println(AjxDebug.DBG1, "Set the inputField " + aclv._inputFieldXFormItem["refPath"] + " value: " + value) ;
		inputFieldOldValue = aclv._inputFieldXFormItem.getInstanceValue();
		var onChangeMethod = aclv._inputFieldXFormItem.getOnChangeMethod();
		if(onChangeMethod != null && typeof(onChangeMethod) == "function") {
			onChangeMethod.call(aclv._inputFieldXFormItem,value,ev,aclv._inputFieldXForm);
		} else {
			aclv._inputFieldXFormItem.setInstanceValue(value);
		}
	}

	// reset timer on any address field key activity
	if (aclv._acActionId != -1) {
		AjxTimedAction.cancelAction(aclv._acActionId);
		aclv._acActionId = -1;
	}
	
	// Figure out what this handler should return. If it returns true, the browser will
	// handle the key event. That usually means it just echoes the typed character, but
	// it could do something like change focus (eg tab). We let the browser handle input
	// characters, and anything weird that we don't want to deal with. The only keys we
	// don't let the browser handle are ones that control the features of the autocomplete
	// list.

	if (key == 16 || key == 17 || key == 18) // SHIFT, ALT, or CTRL
		return true;
	if (ev.altKey || ev.ctrlKey) // ALT and CTRL combos
		return true;
	// if the field is empty, clear the list
	if (!value) {
		aclv.reset();
		return true;
	}
	if (key == 37 || key == 39) // left/right arrow key
		return true;
	// Pass tab through if there's no list (will transfer focus)
	if ((key == 9) && !aclv.size())
		return true;

	if (ev.inputLengthChanged || (key == 3 || key == 9 || key == 13))
		aclv._numChars++;

	// if the user types a single delimiting character with the list showing, do completion
	var isDelim = (aclv.getVisible() && (aclv._numChars == 1) && 
				   ((key == 3 || key == 9 || key == 13) || (!ev.shiftKey && (key == 59 || key == 186 || key == 188))));

	DBG.println(AjxDebug.DBG3, "numChars = " + aclv._numChars + ", key = " + key + ", isDelim: " + isDelim);
	if (isDelim || (key == 27 || key == 38 || key == 40)) {
		aclv.handleAction(key, isDelim);
		// In Firefox, focus shifts on Tab even if we return false (and stop propagation and prevent default),
		// so make sure the focus stays in this element.
		if (AjxEnv.isFirefox && key == 9) {
			aclv._focusAction.args = [ element ];
			AjxTimedAction.scheduleAction(aclv._focusAction, 0);
		}
		DwtUiEvent.setBehaviour(ev, true, false);
		return false;
	}

	// skip if it's some weird character
	if (!ev.inputLengthChanged && 
		(key != 3 && key != 13 && key != 9 && key != 8 && key != 46))
		return true;

	// regular input, schedule autocomplete
	var ev1 = new DwtKeyEvent();
	DwtKeyEvent.copy(ev1, ev);
	ev1.aclv = aclv;
	ev1.element = element;
	aclv._acAction.obj = aclv;
	aclv._acAction.args = [ ev1 ];
	DBG.println(AjxDebug.DBG2, "scheduling autocomplete");
	aclv._acActionId = AjxTimedAction.scheduleAction(aclv._acAction, aclv._acInterval);
	//fire the xform changed event
	var inputFieldNewValue = inputFieldOldValue;
	if (aclv._inputFieldXFormItem){
		inputFieldNewValue = aclv._inputFieldXFormItem.getInstanceValue();
	}
	
	if (aclv._inputFieldXForm){
		aclv._inputFieldXForm.setIsDirty(true, aclv._inputFieldXFormItem ) ;
		aclv._inputFieldXForm.notifyListeners(DwtEvent.XFORMS_FORM_DIRTY_CHANGE, new DwtXFormsEvent(aclv._inputFieldXForm, aclv._inputFieldXFormItem,true));
		if(inputFieldNewValue != inputFieldOldValue){
			aclv._inputFieldXForm.notifyListeners(DwtEvent.XFORMS_VALUE_CHANGED, new DwtXFormsEvent(aclv._inputFieldXForm, aclv._inputFieldXFormItem,true));
		}
	}
	
	return true;
}

// Public methods

ZaAutoCompleteListView.prototype.toString = 
function () {
	return "ZaAutoCompleteListView";
}

/**
* Adds autocompletion to the given field by setting key event handlers.
*
* @param element		an HTML element
*/
ZaAutoCompleteListView.prototype.handle =
function(element) {
	element._acListViewId = this._internalId;
	Dwt.setHandler(element, DwtEvent.ONKEYDOWN, ZaAutoCompleteListView.onKeyDown);
	Dwt.setHandler(element, DwtEvent.ONKEYUP, ZaAutoCompleteListView.onKeyUp);
}

/**
* Autocompletion of addresses. Should be called by a handler for a keyboard event.
*
* @param element	the element (some sort of text field) doing autocomplete
* @param loc		where to popup the list, if appropriate
*/
ZaAutoCompleteListView.prototype.autocomplete =
function(element, loc) {

	this.reset(); // start fresh
	this._element = element; // for updating element later
	this._loc = loc;
	var text = element.value;

	this._autocomplete(text);
}

/**
* Resets the state of the autocomplete list.
*/
ZaAutoCompleteListView.prototype.reset =
function() {
	this._matches.removeAll();
	this.show(false);
}

/**
* Checks the given key to see if it's used to control the autocomplete list in some way.
* If it does, the action is taken and the key won't be echoed into the input area.
*
* The following keys are action keys:
*	38 40		up/down arrows (list selection)
*	27			escape (hide list)
*
* The following keys are delimiters (trigger completion):
*	3 13		return
*	9			tab
*	59 186		semicolon
*	188			comma
*
* @param key		a numeric key code
* @param isDelim	true if a single delimiter key was typed
*/
ZaAutoCompleteListView.prototype.handleAction =
function(key, isDelim) {
	DBG.println(AjxDebug.DBG2, "autocomplete handleAction for key " + key + " / " + isDelim);

	if (isDelim) {
		this._update();
	} else if (key == 38 || key == 40) {
		// handle up and down arrow keys
		var idx = this._getSelectedIndex();
		var size = this.size();
		if (size <= 1) return;
		var newIdx;
		if (key == 40 && (idx < size - 1)) {
			newIdx = idx + 1;
			this._setSelected(newIdx);
		} else if (key == 38 && (idx > 0)) {
			newIdx = idx - 1;
			this._setSelected(newIdx);
		}
	} else if (key == 27) {
		this.reset(); // ESC hides the list
	}
}

// Private methods

// Called as a timed action, after a sufficient pause in typing within an address field.
ZaAutoCompleteListView.prototype._autocompleteAction =
function(ev) {
	try {
		DBG.println(AjxDebug.DBG2, "performing autocomplete");
		var element = ev.element;
		var aclv = ev.aclv;
		aclv._acActionId = -1; // so we don't try to cancel
		aclv._numChars = 0;

		if (this._locCallback) {	
			var loc = this._locCallback.run(ev);
			aclv.autocomplete(element, loc);
		}
	} catch (ex) {
		DBG.println("Session expired? No controller to handle exception. Cannot autocomplete w/o contact list.");
	}
}

/**
* Displays the current matches in a popup list, selecting the first.
*
* @param show	whether to display the list
* @param loc	where to display the list
*/
ZaAutoCompleteListView.prototype.show =
function(show, loc) {
	DBG.println(AjxDebug.DBG3, "autocomplete show: " + show);
	if (show) {
		this._popup(loc);
	} else {
		this._popdown();
	}
}

// Private methods

// Finds the next chunk of text in a string that we should try to autocomplete, by reading
// until it hits some sort of address delimiter (or runs out of text)
ZaAutoCompleteListView.prototype._nextChunk =
function(text, start) {
	while (text.charAt(start) == ' ')	// ignore leading space
		start++;
	for (var i = start; i < text.length; i++) {
		var c = text.charAt(i);
		if (ZaAutoCompleteListView.IS_DELIM[c])
			return {text: text, str: text.substring(start, i), start: start, end: i, delim: true};
	}
	return {text: text, str: text.substring(start, i), start: start, end: i, delim: false};
}

// Looks for matches for a string and either displays them in a list, or does the completion
// immediately (if the string was followed by a delimiter). The chunk object that we get has
// information that allows us to do the replacement if we are performing completion.
ZaAutoCompleteListView.prototype._autocomplete =
function(str) {
	// if string is empty or already a delimited address, no reason to look for matches
	if (!(str && str.length) || (this._done[str]))
		return;

	// do matching
	this._removeAll();
	if (!this._dataLoading) {
		var callback = new AjxCallback(this, this.dataLoadedCallback);
		this._dataLoading = true;
		this._dataLoaderMethod.call (this._dataLoaderObject, str, callback);
	}	
}

// Replaces a string within some text from the selected address match.
ZaAutoCompleteListView.prototype._complete =
function(text) {
	DBG.println(AjxDebug.DBG3, "complete: selected is " + this._selected);
	var match = this._getSelected();
	if (!match)	return;

	var start = this._start;
	var end = hasDelim ? this._end + 1 : this._end;
	DBG.println(AjxDebug.DBG2, "update replace range: " + start + " - " + end);
	var value = match[this._matchValue];
//	var newText = [text.substring(0, start), value, this._separator, text.substring(end, text.length)].join("");
	this._done[value] = true;
	DBG.display(AjxDebug.DBG2, newText);
	return {text: newText, start: start + value.length + this._separator.length, match: match};
}

// Resets the value of an element to the given text.
ZaAutoCompleteListView.prototype._updateField =
function(match) {
	var el = this._element;
	el.value = match[this._matchValue];
	el.focus();
	this.reset();
	this._inputFieldXFormItem.setInstanceValue(match[this._matchValue]);
	if(this._inputFieldXForm){	
		this._inputFieldXForm.setIsDirty(true, this._inputFieldXFormItem) ;
        	this._inputFieldXForm.notifyListeners(DwtEvent.XFORMS_FORM_DIRTY_CHANGE, new DwtXFormsEvent(this._inputFieldXForm, this._inputFieldXFormItem,true));
		this._inputFieldXForm.notifyListeners(DwtEvent.XFORMS_VALUE_CHANGED, new DwtXFormsEvent(this._inputFieldXForm, this._inputFieldXFormItem,true));
	}
	if (this._compCallback)
		this._compCallback.run(match, this._inputFieldXFormItem);
}

// Updates the element with the currently selected match.
ZaAutoCompleteListView.prototype._update =
function() {
	var match = this._getSelected();
	if (!match)	return;	
	this._updateField(match);
}

// Listeners

// MOUSE_DOWN selects a match and performs an update. Note that we don't wait for
// a corresponding MOUSE_UP event.
ZaAutoCompleteListView.prototype._mouseDownListener = 
function(ev) {
	ev = DwtUiEvent.getEvent(ev);
	var div = DwtUiEvent.getTarget(ev);
	if (!div || div._pos == null)
		return;
	if (ev.button == DwtMouseEvent.LEFT) {
		this._setSelected(div._pos);
		if (this.isListenerRegistered(DwtEvent.SELECTION)) {
	    	var selEv = DwtShell.selectionEvent;
	    	DwtUiEvent.copy(selEv, ev);
	    	selEv.match = div._match;
	    	selEv.detail = 0;
	    	this.notifyListeners(DwtEvent.SELECTION, selEv);
	    	return true;
	    }		
	}
}

// Mouse over selects a match
ZaAutoCompleteListView.prototype._mouseOverListener = 
function(ev) {
	ev = DwtUiEvent.getEvent(ev);
	var div = DwtUiEvent.getTarget(ev);
	if (!div || div._pos == null)
		return;
	this._setSelected(div._pos);
}

// Seems like DwtComposite should define this method
ZaAutoCompleteListView.prototype._addSelectionListener = 
function(listener) {
	this._eventMgr.addListener(DwtEvent.SELECTION, listener);
}

ZaAutoCompleteListView.prototype._listSelectionListener = 
function(ev) {
	this._update();
};

// Layout

// Creates the list and its member elements based on the matches we have. Each match becomes a 
// DIV. The first match is automatically selected.
ZaAutoCompleteListView.prototype._set =
function(sel) {
	var thisHtmlElement = this.getHtmlElement();
	thisHtmlElement.innerHTML = "";
	var len = this._matches.size();
	for (var i = 0; i < len; i++) {
		var match = this._matches.get(i);
		if (match){
			var div = document.createElement("div");		
			div._pos = i;
			div[DwtListView._STYLE_CLASS] = "Row";
			div[DwtListView._SELECTED_STYLE_CLASS] = div[DwtListView._STYLE_CLASS] + "-" + DwtCssStyle.SELECTED;
                        div[DwtListView._STYLE_CLASS] = "ZaAutoCompleteListRow";
			div.className = div[DwtListView._STYLE_CLASS];
			div.innerHTML = AjxStringUtil.htmlEncode (match[this._matchText]);
			thisHtmlElement.appendChild(div);
		}
	}
	this._selected = sel || 0;
	this._setSelected(this._selected);
}

// Displays the list
ZaAutoCompleteListView.prototype._popup = 
function(loc) {
	this.setLocation(loc.x, loc.y);
	this.setSize (Dwt.getSize(this._inputFieldElement).x - 2) ; //set width only, 2 is the border-width
	this.setVisible(true);
	this.setZIndex(Dwt.Z_DIALOG_MENU);
	ZaAutoCompleteListView._activeAcList = this;
	DwtEventManager.addListener(DwtEvent.ONMOUSEDOWN, ZaAutoCompleteListView._outsideMouseDownListener);
	this.shell._setEventHdlrs([DwtEvent.ONMOUSEDOWN]);
	this.shell.addListener(DwtEvent.ONMOUSEDOWN, this._outsideListener);
}

// Hides the list
ZaAutoCompleteListView.prototype._popdown = 
function() {
	this.setZIndex(Dwt.Z_HIDDEN);
	this.setVisible(false);
	ZaAutoCompleteListView._activeAcList = null;
	DwtEventManager.removeListener(DwtEvent.ONMOUSEDOWN, ZaAutoCompleteListView._outsideMouseDownListener);
	this.shell._setEventHdlrs([DwtEvent.ONMOUSEDOWN], true);
	this.shell.removeListener(DwtEvent.ONMOUSEDOWN, this._outsideListener);
}

// Selects a match by changing its CSS class
ZaAutoCompleteListView.prototype._setSelected =
function(sel) {
	DBG.println(AjxDebug.DBG3, "setting selected index to " + sel);
	var children = this.getHtmlElement().childNodes;
	if (!children) return;

	var len = children.length;
	for (var i = 0; i < len; i++) {
		var div = children[i];
		var curStyle = div.className;
		if (i == sel && curStyle != div[DwtListView._SELECTED_STYLE_CLASS]) {
			div.className = div[DwtListView._SELECTED_STYLE_CLASS];
		} else if (curStyle != div[DwtListView._STYLE_CLASS]) {
			div.className = div[DwtListView._STYLE_CLASS];
		}
	}
	this._selected = sel;
}

// Miscellaneous

// Adds a match to the internal list of matches
ZaAutoCompleteListView.prototype._append =
function(match) {
	this._matches.add(match);
}

// Clears the internal list of matches
ZaAutoCompleteListView.prototype._removeAll =
function() {
	this._matches.removeAll();
	var htmlElement = this.getHtmlElement();
	while (htmlElement.hasChildNodes())
		htmlElement.removeChild(htmlElement.firstChild);
}

// Returns the number of matches
ZaAutoCompleteListView.prototype.size =
function() {
	return this._matches.size();
}

// Returns the index of the currently selected match
ZaAutoCompleteListView.prototype._getSelectedIndex =
function() {
	return this._selected;
}

// Returns the currently selected match
ZaAutoCompleteListView.prototype._getSelected =
function() {
	return this._matches.get(this._selected);
}

/**
 * This method is called by this._dataLoaderObject when the data arrives
 * @param list - parsed array of data 
 */
ZaAutoCompleteListView.prototype.dataLoadedCallback = function (list) {
	if (list && list.length > 0) {
		var len = list.length;
		DBG.println(AjxDebug.DBG2, "found " + len + " match" + len > 1 ? "es" : "");
		for (var i = 0; i < len; i++) {
			var match = list[i];
			this._append(match);
		}
	} else {
		this._dataLoading = false;
		return;
	}
	
	this._set(); // populate the list view

	// show the list (unless we're doing completion)
	this.show(true, this._loc);
	this._dataLoading = false;
}
// Force the focus to the element
ZaAutoCompleteListView.prototype._focus =
function(htmlEl) {
	htmlEl.focus();
}

ZaAutoCompleteListView._outsideMouseDownListener =
function(ev) {
	var curList = ZaAutoCompleteListView._activeAcList;
    if (curList.getVisible()) {
		var obj = DwtControl.getTargetControl(ev);
		if (obj != curList) {
			curList.show(false);
			ev._stopPropagation = false;
			ev._returnValue = true;
		}
	}
};
}
if (AjxPackage.define("zimbraAdmin.common.AutoComplete_XFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
 
/**	
* @class defines XFormItem type _AUTO_COMPLETE_LIST_
* @contructor
* @author Charles Cao
**/

AutoCompleteList_XFormItem = function() {}
XFormItemFactory.createItemType("_AUTO_COMPLETE_LIST_", "auto_complete_list", 
										AutoCompleteList_XFormItem, WidgetAdaptor_XFormItem);

AutoCompleteList_XFormItem.prototype.widgetClass = ZaAutoCompleteListView;


AutoCompleteList_XFormItem.prototype.constructWidget = function () {
	
	var autoCompleteListViewClass = this.getInheritedProperty("widgetClass");
//	var locCallback = new AjxCallback (this, AutoCompleteList_XFormItem.prototype._getAcListLoc);
	var locCallback = new AjxCallback (this, this._getAcListLoc);
	var compCallback = new AjxCallback(this, this.getInheritedProperty("compCallback"));
	//var dataLoadCallback = new AjxCallback (this, dataLoaderClass.prototype._getDataCallback);
	
	var params = { 	//parent: this.getForm() ,
					parent: this.getForm().shell,					
					className: this.getCssClass(),
					dataLoaderClass: this.getInheritedProperty("dataLoaderClass"),
					dataLoaderMethod: this.getInheritedProperty("dataLoaderMethod"), //method that searches for matches (e.g. sends search request to server)
					matchValue: this.getInheritedProperty("matchValue"), //the name of the property in the match list to be used to do the comparison
					matchText: this.getInheritedProperty("matchText"),//the name of the property in the match list to be displayed in the field
					//inputFieldElement: this.getForm().getItemsById (this.getInheritedProperty("inputFieldElementId"))[0].getElement(),
					inputFieldXFormItem: this.getForm().getItemsById (this.getInheritedProperty("inputFieldElementId"))[0],
					//dataLoadCallback: dataLoadCallback,
					locCallback: locCallback, 
					compCallback: compCallback,//called when a value is selected from the list of suggestions
					separator: ""  					
				  };
								
	var widget = new autoCompleteListViewClass(params);
		
	return widget;
};

AutoCompleteList_XFormItem.prototype.insertWidget = function (form, widget, parentElement) {
	//the autocomplete list always belong to the shell
	//so we actually don't need to reparent the element
	return ;
}

AutoCompleteList_XFormItem.prototype.updateWidget = function (newValue) {}

AutoCompleteList_XFormItem.prototype._getAcListLoc =
function(ev) {
	var element = ev.element;
	var loc = Dwt.getLocation(element);
	var height = Dwt.getSize(element).y;
	return (new DwtPoint(loc.x, loc.y + height));
};





}
if (AjxPackage.define("zimbraAdmin.common.ZaKeyMap")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* Creates a key mapping.
* @constructor
* @class
* 
* @author Ross Dargahi
*/
ZaKeyMap = function() {
	DwtKeyMap.call(this);
	// Note that FF on the mac has an issue reporting the ALT+<keycode> it
	// always ends up reporting undefined for the <keycode>. For this reason I
	// have added Ctrl analogs below	
	this._map["ZaGlobal"] = {

			"Alt+Shift+D,0": ZaKeyMap.DBG_NONE,
			"Ctrl+Shift+D,0": ZaKeyMap.DBG_NONE, // Mac issue with Alt+Key

			"Alt+Shift+D,1": ZaKeyMap.DBG_1,
			"Ctrl+Shift+D,1": ZaKeyMap.DBG_1,

			"Alt+Shift+D,2": ZaKeyMap.DBG_2,
			"Ctrl+Shift+D,2": ZaKeyMap.DBG_2,

			"Alt+Shift+D,3": ZaKeyMap.DBG_3,
			"Ctrl+Shift+D,3": ZaKeyMap.DBG_3,

			"Alt+S":   ZaKeyMap.SAVE,
			"Ctrl+S": ZaKeyMap.SAVE,

			"Del":        ZaKeyMap.DEL,
			"Backspace":  ZaKeyMap.DEL, // MacBook keyboard
			"Esc":        ZaKeyMap.CANCEL,
			"ArrowRight": ZaKeyMap.NEXT_PAGE,
			"ArrowLeft":  ZaKeyMap.PREV_PAGE
	};
		
}

ZaKeyMap.prototype = new DwtKeyMap(true);
ZaKeyMap.prototype.constructor = ZaKeyMap;

// Key map action code contants
var i = 0;

ZaKeyMap.CANCEL = i++;
ZaKeyMap.DBG_NONE = i++;
ZaKeyMap.DBG_1 = i++;
ZaKeyMap.DBG_2 = i++;
ZaKeyMap.DBG_3 = i++;
ZaKeyMap.DEL = i++;
ZaKeyMap.NEXT_CONV = i++;
ZaKeyMap.NEXT_PAGE = i++;
ZaKeyMap.PREV_CONV = i++;
ZaKeyMap.PREV_PAGE = i++;
ZaKeyMap.SAVE = i++;


delete i;
}
if (AjxPackage.define("zimbraAdmin.common.ACLXFormItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* XFormItem class: "acl (composite item)
* this item is used in the Admin UI to display ACL fields like Notebook folder access rights
* @class ACLXFormItem
* @constructor ACLXFormItem
* @author Greg Solovyev
**/
ACLXFormItem = function() {}
XFormItemFactory.createItemType("_ACL_", "acl", ACLXFormItem, Composite_XFormItem);
ACLXFormItem.prototype.numCols = 6;
ACLXFormItem.prototype.nowrap = true;
ACLXFormItem.prototype.visibleBoxes = {r:true,w:true,a:true,i:true,d:true,x:true};
ACLXFormItem.prototype.initializeItems = 
function () {
	var visibleBoxes = this.getInheritedProperty("visibleBoxes");
	this.items = [];
	if(visibleBoxes.r)
		this.items.push(	
			{type:_CHECKBOX_,width:"40px",containerCssStyle:"width:40px", forceUpdate:true, ref:".", 
				labelLocation:_RIGHT_, label:ZaMsg.ACL_R, subLabel:"", align:_RIGHT_,
				visibilityChecks:[],enableDisableChecks:[],
				getDisplayValue:function (itemval) {
					return (itemval && itemval["r"]==1);
				},
				elementChanged:function(isChecked, instanceValue, event) {
					var newVal = Object();

					if(instanceValue) {
						newVal["w"] = instanceValue["w"];
						newVal["a"] = instanceValue["a"];
						newVal["i"] = instanceValue["i"];
						newVal["d"] = instanceValue["d"];			
						newVal["x"] = instanceValue["x"];			
					} else {
						newVal = {r:0,w:0,i:0,d:0,a:0,x:0};
					}
					newVal["r"] = isChecked ? 1 : 0;
					this.getForm().itemChanged(this.getParentItem(), newVal, event);
				}
			}
		);

	if(visibleBoxes.w)
		this.items.push(	
			{type:_CHECKBOX_,width:"40px",containerCssStyle:"width:40px", forceUpdate:true, ref:".", 
				labelLocation:_RIGHT_, label:ZaMsg.ACL_W, subLabel:"",  align:_RIGHT_,
				visibilityChecks:[],enableDisableChecks:[],
				getDisplayValue:function (itemval) {
					return (itemval && itemval["w"]==1);
				},
				elementChanged:function(isChecked, instanceValue, event) {
					var newVal = Object();
					if(instanceValue) {					
						newVal["r"] = instanceValue["r"];
						newVal["a"] = instanceValue["a"];
						newVal["i"] = instanceValue["i"];
						newVal["d"] = instanceValue["d"];			
						newVal["x"] = instanceValue["x"];			
					} else {
						newVal = {r:0,w:0,i:0,d:0,a:0,x:0};
					}
					newVal["w"] = isChecked ? 1 : 0;
					this.getForm().itemChanged(this.getParentItem(), newVal, event);
				}
			}
		);

	if(visibleBoxes.d)
		this.items.push(	
			{type:_CHECKBOX_,width:"40px",containerCssStyle:"width:40px", forceUpdate:true, ref:".", 
				labelLocation:_RIGHT_, label:ZaMsg.ACL_D, subLabel:"",  align:_RIGHT_,
				visibilityChecks:[],enableDisableChecks:[],
				getDisplayValue:function (itemval) {
					return (itemval && itemval["d"]==1);
				},
				elementChanged:function(isChecked, instanceValue, event) {
					var newVal = Object();

					if(instanceValue) {										
						newVal["w"] = instanceValue["w"];
						newVal["a"] = instanceValue["a"];
						newVal["i"] = instanceValue["i"];
						newVal["r"] = instanceValue["r"];			
						newVal["x"] = instanceValue["x"];			
					} else {
						newVal = {r:0,w:0,i:0,d:0,a:0,x:0};
					}
					newVal["d"] = isChecked ? 1 : 0;
					this.getForm().itemChanged(this.getParentItem(), newVal, event);
				}
			}
		);
		
	if(visibleBoxes.i)
		this.items.push(	
			{type:_CHECKBOX_,width:"40px",containerCssStyle:"width:40px", forceUpdate:true, ref:".", 
				labelLocation:_RIGHT_, label:ZaMsg.ACL_I, subLabel:"",  align:_RIGHT_,
				visibilityChecks:[],enableDisableChecks:[],
				getDisplayValue:function (itemval) {
					return (itemval && itemval["i"]==1);
				},
				elementChanged:function(isChecked, instanceValue, event) {
					var newVal = Object();

					if(instanceValue) {				
						newVal["w"] = instanceValue["w"];
						newVal["a"] = instanceValue["a"];
						newVal["r"] = instanceValue["r"];
						newVal["d"] = instanceValue["d"];			
						newVal["x"] = instanceValue["x"];			
					} else {
						newVal = {r:0,w:0,i:0,d:0,a:0,x:0};
					}
					newVal["i"] = isChecked ? 1 : 0;
					this.getForm().itemChanged(this.getParentItem(), newVal, event);
				}
			}
		);		
		
	if(visibleBoxes.x)
		this.items.push(	
			{type:_CHECKBOX_,width:"40px",containerCssStyle:"width:40px", forceUpdate:true, ref:".", 
				labelLocation:_RIGHT_, label:ZaMsg.ACL_X, subLabel:"",align:_RIGHT_,
				visibilityChecks:[],enableDisableChecks:[],
				getDisplayValue:function (itemval) {
					return (itemval && itemval["x"]==1);
				},
				elementChanged:function(isChecked, instanceValue, event) {
					var newVal = Object();
					if(instanceValue) {				
						newVal["w"] = instanceValue["w"];
						newVal["a"] = instanceValue["a"];
						newVal["i"] = instanceValue["i"];
						newVal["d"] = instanceValue["d"];			
						newVal["r"] = instanceValue["r"];			
					} else {
						newVal = {r:0,w:0,i:0,d:0,a:0,x:0};
					}
					newVal["x"] = isChecked ? 1 : 0;
					this.getForm().itemChanged(this.getParentItem(), newVal, event);
				}
			}
		);	
		
	if(visibleBoxes.a)
		this.items.push(	
			{type:_CHECKBOX_,width:"40px",containerCssStyle:"width:40px", forceUpdate:true, ref:".", 
				labelLocation:_RIGHT_, label:ZaMsg.ACL_A, subLabel:"", align:_RIGHT_,
				visibilityChecks:[],enableDisableChecks:[],
				getDisplayValue:function (itemval) {
					return (itemval && itemval["a"]==1);
				},
				elementChanged:function(isChecked, instanceValue, event) {
					var newVal = Object();
					if(instanceValue) {				
						newVal["w"] = instanceValue["w"];
						newVal["r"] = instanceValue["r"];
						newVal["i"] = instanceValue["i"];
						newVal["d"] = instanceValue["d"];			
						newVal["x"] = instanceValue["x"];			
					} else {
						newVal = {r:0,w:0,i:0,d:0,a:0,x:0};
					}
					newVal["a"] = isChecked ? 1 : 0;
					this.getForm().itemChanged(this.getParentItem(), newVal, event);
				}
			}
		);				
	Composite_XFormItem.prototype.initializeItems.call(this);
};

ACLXFormItem.prototype.items = [];

}
if (AjxPackage.define("zimbraAdmin.common.ZaSkinPoolChooser")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

ZaSkinPoolChooser = function(params) {
 	if (arguments.length == 0) return;
/*
 	this.splitButtons = params.splitButtons;
 	
 	if(params.labelWidth)
 		this.labelWidth = params.labelWidth;
 	else
 		this.labelWidth = "300px"
 	
 	if(params.tableWidth)
 		this.tableWidth = params.tableWidth;
 	else
 		this.tableWidth = "300px";*/
 		
 	DwtChooser.call(this, params);
}
 
ZaSkinPoolChooser.prototype = new DwtChooser;
ZaSkinPoolChooser.prototype.constructor = ZaSkinPoolChooser;

ZaSkinPoolChooser.prototype._createHtml = 
function() {

	this._sourceListViewDivId	= Dwt.getNextId();
	this._targetListViewDivId	= Dwt.getNextId();
	this._buttonsDivId			= Dwt.getNextId();
	this._removeButtonDivId		= Dwt.getNextId();
	if (this._allButtons) {
		this._addAllButtonDivId		= Dwt.getNextId();
		this._removeAllButtonDivId	= Dwt.getNextId();
	}

	var html = [];
	var idx = 0;
	/*
	// start new table for list views
	html[idx++] = "<table cellspacing=0 cellpadding=0 border=0>";
	html[idx++] = "<colgroup><col width='";
	html[idx++] = this.labelWidth;
	html[idx++] = "'/><col width='";
	html[idx++] = this.tableWidth;
	html[idx++] = "'/></colgroup>";
	html[idx++] = "<tbody>";
	html[idx++] = "<tr><td style='text-align:right;width:";
	html[idx++] = this.labelWidth;
	html[idx++] = "' class='xform_label'";
	html[idx++] = ">" + ZaMsg.NAD_zimbraInstalledSkin + "</td>";
	// source list
	html[idx++] = "<td class='xform_field_container' width='";
	html[idx++] = this.tableWidth;
	html[idx++] = "'><div id='";
	html[idx++] = this._sourceListViewDivId;
	html[idx++] = "'></div></td>";
	html[idx++] = "</tr>";

	// transfer buttons
	html[idx++] = "<tr><td style='text-align:right;width:";
	html[idx++] = this.labelWidth;	
	html[idx++] = "' class='xform_label'";
	html[idx++] = "'>&nbsp;</td>";
	html[idx++] = "<td valign='middle' style='text-align:center;width:";
	html[idx++] = this.tableWidth;	
	html[idx++] = "'><div id='";
	html[idx++] = this._buttonsDivId;
	html[idx++] = "'>";
	html[idx++] = "<table cellspacing=2 cellpadding=0 border=0><tr>";
	if(this.splitButtons) {
		for (var i = 0; i < this._buttonInfo.length; i++) {
			var id = this._buttonInfo[i].id;
			html[idx++] = "<td><div id='";
			html[idx++] = this._buttonDivId[id];
			html[idx++] = "'></div></td>";
		}
		if (this._allButtons) {
			html[idx++] = "<td><div id='";
			html[idx++] = this._addAllButtonDivId;
			html[idx++] = "'></div></td>";
		}
	
		html[idx++] = "</tr><tr>";
		// remove button
		html[idx++] = "<td><div id='";
		html[idx++] = this._removeButtonDivId;
		html[idx++] = "'></div></td>";
		if (this._allButtons) {
			html[idx++] = "<td><div id='";
			html[idx++] = this._removeAllButtonDivId;
			html[idx++] = "'></div></td>";
		}
	} else {
		if (this._allButtons) {
			html[idx++] = "<td><div id='";
			html[idx++] = this._addAllButtonDivId;
			html[idx++] = "'></div></td>";
		}
		for (var i = 0; i < this._buttonInfo.length; i++) {
			var id = this._buttonInfo[i].id;
			html[idx++] = "<td><div id='";
			html[idx++] = this._buttonDivId[id];
			html[idx++] = "'></div></td>";
		}
	

		// remove button
		html[idx++] = "<td><div id='";
		html[idx++] = this._removeButtonDivId;
		html[idx++] = "'></div></td>";
		if (this._allButtons) {
			html[idx++] = "<td><div id='";
			html[idx++] = this._removeAllButtonDivId;
			html[idx++] = "'></div></td>";
		}
	}
	html[idx++] = "</tr></table>";
	html[idx++] = "</div></td></tr>";


	html[idx++] = "<tr><td style='text-align:right' class='xform_label'>" + ZaMsg.NAD_zimbraAvailableSkin + "</td>";
	// target list
	html[idx++] = "<td class='xform_field_container' width='";
	html[idx++] = this.tableWidth;
	html[idx++] = "'><div id='";
	html[idx++] = this._targetListViewDivId;
	html[idx++] = "'></div></td>";
	html[idx++] = "</tr></tbody></table>";

	*/
	
	// start new table for list views
	html[idx++] = "<table cellspacing=0 cellpadding=0 border=0 width=100%>";
	html[idx++] = "<colgroup><col width='40%'/><col width='20%'/><col width='40%'/> </colgroup>";
	html[idx++] = "<tbody>";
	html[idx++] = "<tr><td style='text-align:center' class='xform_label'>" + ZaMsg.NAD_zimbraInstalledSkin + "</td><td>&nbsp;</td><td style='text-align:center'  class='xform_label'>" + ZaMsg.NAD_zimbraAvailableSkin + "</td</tr>"
	html[idx++] = "<tr>";

	// source list
	html[idx++] = "<td align='center' style='text-align:center' id='";
	html[idx++] = this._sourceListViewDivId;
	html[idx++] = "'></td>";

	// transfer buttons
	html[idx++] = "<td valign='middle' style='text-align:center' id='";
	html[idx++] = this._buttonsDivId;
	html[idx++] = "'>";
	if (this._allButtons) {
		html[idx++] = "<div id='";
		html[idx++] = this._addAllButtonDivId;
		html[idx++] = "'></div><br>";
	}
	for (var i = 0; i < this._buttonInfo.length; i++) {
		var id = this._buttonInfo[i].id;
		html[idx++] = "<div id='";
		html[idx++] = this._buttonDivId[id];
		html[idx++] = "'></div><br>";
	}
	// remove button
	html[idx++] = "<br><div id='";
	html[idx++] = this._removeButtonDivId;
	html[idx++] = "'></div>";
	if (this._allButtons) {
		html[idx++] = "<br><div id='";
		html[idx++] = this._removeAllButtonDivId;
		html[idx++] = "'></div><br>";
	}
	html[idx++] = "</td>";

	// target list
	html[idx++] = "<td align='center' style='text-align:center' id='";
	html[idx++] = this._targetListViewDivId;
	html[idx++] = "'></td>";	

	html[idx++] = "</tr></tbody></table>";	
	this.getHtmlElement().innerHTML = html.join("");
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaZimletPoolChooser")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

ZaZimletPoolChooser = function(params) {
 	if (arguments.length == 0) return;
		
 	DwtChooser.call(this, params);
}
 
ZaZimletPoolChooser.prototype = new DwtChooser;
ZaZimletPoolChooser.prototype.constructor = ZaZimletPoolChooser;

ZaZimletPoolChooser.prototype._createHtml = 
function() {

	this._sourceListViewDivId	= Dwt.getNextId();
	this._targetListViewDivId	= Dwt.getNextId();
	this._buttonsDivId			= Dwt.getNextId();
	this._removeButtonDivId		= Dwt.getNextId();
	if (this._allButtons) {
		this._addAllButtonDivId		= Dwt.getNextId();
		this._removeAllButtonDivId	= Dwt.getNextId();
	}

	var html = [];
	var idx = 0;

	// start new table for list views
	html[idx++] = "<table cellspacing=0 cellpadding=0 border=0 width=100%>";
	html[idx++] = "<colgroup><col width='40%'/><col width='20%'/><col width='40%'/> </colgroup>";
	html[idx++] = "<tbody>";
	html[idx++] = "<tr><td style='text-align:center' class='xform_label'>" + ZaMsg.NAD_zimbraInstalledZimlets + "</td><td>&nbsp;</td><td style='text-align:center'  class='xform_label'>" + ZaMsg.NAD_zimbraAvailableZimlets + "</td</tr>"
	html[idx++] = "<tr>";

	// source list
	html[idx++] = "<td align='center' style='text-align:center' id='";
	html[idx++] = this._sourceListViewDivId;
	html[idx++] = "'></td>";

	// transfer buttons
	html[idx++] = "<td valign='middle' style='text-align:center' id='";
	html[idx++] = this._buttonsDivId;
	html[idx++] = "'>";
	if (this._allButtons) {
		html[idx++] = "<div id='";
		html[idx++] = this._addAllButtonDivId;
		html[idx++] = "'></div><br>";
	}
	for (var i = 0; i < this._buttonInfo.length; i++) {
		var id = this._buttonInfo[i].id;
		html[idx++] = "<div id='";
		html[idx++] = this._buttonDivId[id];
		html[idx++] = "'></div><br>";
	}
	// remove button
	html[idx++] = "<br><div id='";
	html[idx++] = this._removeButtonDivId;
	html[idx++] = "'></div>";
	if (this._allButtons) {
		html[idx++] = "<br><div id='";
		html[idx++] = this._removeAllButtonDivId;
		html[idx++] = "'></div><br>";
	}
	html[idx++] = "</td>";

	// target list
	html[idx++] = "<td align='center' style='text-align:center' id='";
	html[idx++] = this._targetListViewDivId;
	html[idx++] = "'></td>";	

	html[idx++] = "</tr></tbody></table>";	
	this.getHtmlElement().innerHTML = html.join("");
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaXProgressDialog")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2006, 2007, 2008, 2009, 2010, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaXProgressDialog
* @contructor ZaXProgressDialog
* @author Greg Solovyev
* @param parent
* param w (width)
* param h (height)
**/
ZaXProgressDialog = function(parent, w, h) {
	if (arguments.length == 0) return;
	ZaXDialog.call(this, parent,null, ZaMsg.Progress_Title, w, h, "ZaXProgressDialog");
	this.initForm(ZaXProgressDialog.myXModel,this.getMyXForm());
	this._containedObject = {numTotal:100,numDone:0,progressMsg:""};
}

ZaXProgressDialog.prototype = new ZaXDialog;
ZaXProgressDialog.prototype.constructor = ZaXProgressDialog;

ZaXProgressDialog.prototype.popup = 
function () {
	DwtDialog.prototype.popup.call(this);
}

ZaXProgressDialog.prototype.popdown = 
function () {
	DwtDialog.prototype.popdown.call(this);
}

ZaXProgressDialog.prototype.enableOk = 
function (enable) {
	this._button[DwtDialog.OK_BUTTON].setEnabled(enable);
}

ZaXProgressDialog.prototype.setProgress = 
function (obj) {
	this._localXForm.setInstance(obj);
	this._localXForm.refresh();	
}

ZaXProgressDialog.prototype.getMyXForm = 
function() {	
	var xFormObject = {
		numCols:2, align:_CENTER_,cssStyle:"text-align:center",
		items:[
			{type:_DWT_ALERT_, ref:"progressMsg",content: null,
				colSpan:"*",
 				iconVisible: true,
				align:_CENTER_,				
				style: DwtAlert.INFORMATION
			},
			{type:_DWT_PROGRESS_BAR_, label:ZaMsg.NAD_Progress,
				maxValue:null,
				maxValueRef:"numTotal", 
				ref:"numDone",
				valign:_CENTER_,
				align:_CENTER_,	
				wholeCssClass:"progressbar",
				progressCssClass:"progressused"
			}
		]		
	}
	return xFormObject;
}

ZaXProgressDialog.myXModel =  {
	items: [
		{id:"numTotal", ref:"numTotal", type:_NUMBER_},			
		{id:"numDone", ref:"numDone", type:_NUMBER_},					
		{id:"progressMsg", ref:"progressMsg", type:_STRING_}
	]
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaAppTabGroup")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2007, 2008, 2010, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2007, 2008, 2010, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * The container for all the Application tabs. It will include all the operations at the
 * tab group level, including add a tab, remove a tab, switch tab, move tab position, 
 * resize tabs, 
 * 
 * 
*/

ZaAppTabGroup = function(parent,parentElId) {
	if (arguments.length == 0) return;
	DwtComposite.call(this,{
		parent:parent, 
		className:"ZaAppTabGroup", 
		posStyle:Dwt.ABSOLUTE_STYLE, 
		id:ZaId.getTabId(ZaId.TAB_GROUP,parentElId)
	});
	this._created = false ;

	this._mainTab = null;
	this._currentTab = null ;
	this._currentTabWidth = 0;
	
	this._createUI(parentElId) ;
		
	this._visibleStartTab = 0;
	this._numberOfVisibleTabs = 0 ;
}

ZaAppTabGroup.prototype = new DwtComposite();
ZaAppTabGroup.prototype.constructor = ZaAppTabGroup;

//Global Varible to keep all the tab instances
ZaAppTabGroup._TABS = new AjxVector() ;
ZaAppTabGroup.TAB_LIMIT  = 10;

ZaAppTabGroup.prototype.getTabs =
function () {
	return ZaAppTabGroup._TABS ;
}

ZaAppTabGroup.prototype._createUI =
function (parentElId) {
	if (this._created) {
		return ;
	}else {
		if (parentElId) {
			this.reparentHtmlElement ( parentElId );
		}
		//create the shift arrows
		
		this._leftArrow = new DwtComposite(this, null, DwtControl.ABSOLUTE_STYLE) ;
		AjxImg.setImage(this._leftArrow.getHtmlElement(), "LeftArrow");
		this._leftArrow.setDisplay("none");
		this._rightArrow = new DwtComposite(this, null, DwtControl.ABSOLUTE_STYLE) ;
		AjxImg.setImage (this._rightArrow.getHtmlElement(), "RightArrow");
		this._rightArrow.setDisplay("none");
		this.setArrowHandler ();
		
		/*
		this._leftArrow = new DwtButton (this, null, null, DwtControl.ABSOLUTE_STYLE) ;
		this._rightArrow = new DwtButton (this, null, null, DwtControl.ABSOLUTE_STYLE) ;
		this._leftArrow.setImage ("LeftArrow") ;
		this._rightArrow.setImage("RightArrow") ;
		var selListener = new AjxListener(this, ZaAppTabGroup.prototype._arrowSelListener);
		this._leftArrow.addSelectionListener(selListener) ;
		this._rightArrow.addSelectionListener(selListener) ;
		*/
		//create the main tab
		var tabParams = {
			closable: false,
			mainId: ZaId.TAB_MAIN,
			selected: true
		}
		//this._mainTab = new ZaAppTab (this,  null, null,	null, null, false, true);
		this._mainTab = new ZaAppTab (this,  tabParams);
		this._currentTab = this._mainTab ;
		/*
		if (mainTab) {
			this.addTab(mainTab, false);
		}*/
			
		this._created = true ;
		ZaApp.getInstance().setTabGroup (this) ;
	}
}

ZaAppTabGroup.prototype.setCurrentTabWidth =
function (w) {
	this._currentTabWidth = w ;
}

ZaAppTabGroup.prototype.getCurrentTabWidth =
function () {
	return this._currentTabWidth ;
}

ZaAppTabGroup.prototype.getArrowY =
function () {
	return -4;
}

//this method is called when the browser is resized.
ZaAppTabGroup.prototype._resizeListener =
function () {
	this.resetTabSizes(true);
}


//Need to handle the tab size properly. And  may need to change the label accordingly
ZaAppTabGroup.prototype.resetTabSizes =
function (shouldShift){
	var nextX = 0;
	var tabW = this.getTabWidth();
	//7 is left-margin (3) + left-border (2) + right-border (2)
	var w = tabW - 7;
	this.setCurrentTabWidth(w) ;
	
	var tabH = this.getTabHeight() ;
	var groupWidth = this.getW () ;
	//var groupWidth = this.getW () - 40 ; //40 is the size the left/right arrow
	
	if (this._leftArrow.getVisible()) {
		groupWidth -= 16;
		//groupWidth -= 3 ; //not exactly sure where this 3 from. But it should be deducted to show the tab properly
		nextX += 16 ;
	}
	
	if (this._rightArrow.getVisible()) {
		groupWidth -= 16;
	}
	var isShiftNeeded = false ;
	var indexOfHiddenSelectedTab ;	

    var y ;
 /*   if (AjxEnv.isIE) {
		if (ZaApp.getInstance()._appViewMgr._isAdvancedSearchBuilderDisplayed)  { //once the advancedSearchBuilder is displayed, the skin height got changed. (weird). Hack to make it displayed properly
            y = -11 ;
        }else{
            y = -4 ;
        }
    }*//*else{
		y = 0 ;
	}  */                                                                          
	for (var i=0; i < ZaAppTabGroup._TABS.size(); i++) {
		var cTab = ZaAppTabGroup._TABS.get(i) ;
				
		/*
		if (! cTab._closable) {
			w -= 20 ;
		}  */
				
		cTab.setBounds (nextX, y, w, tabH) ; 
		cTab.resetLabel (cTab.getTitle());
		
		if (nextX && groupWidth && ((nextX + w) > groupWidth)) {
			cTab.setVisible(false);
			if (cTab.isSelected() && shouldShift) { //if the selected tab is hidden, the shift action will be needed.
				isShiftNeeded = true ;
				indexOfHiddenSelectedTab = i ;
			}
		}else{
			cTab.setVisible (true) ;
			//this._numberOfVisibleTabs = i + 1 ; //record how many tabs are visible
		}
		//7 is left-margin (3) + left-border (2) + right-border (2)
		nextX = nextX + w + 7;
	}
	
	/*
	if (this._numberOfVisibleTabs 
			&& this._numberOfVisibleTabs < ZaAppTabGroup._TABS.size()
			&& (this._leftArrow.getVisible() == false
				|| this._rightArrow.getVisible() == false )
			) {
		this._leftArrow.setVisible (true);
		this._rightArrow.setVisible (true);
		this.resetTabSizes();
	}
	
	if (this._numberOfVisibleTabs 
			&& this._numberOfVisibleTabs >= ZaAppTabGroup._TABS.size()
			&& (this._leftArrow.getVisible()
				&& this._rightArrow.getVisible())) {
		this._leftArrow.setVisible (false);
		//this._leftArrow.setLocation(0);
		this._rightArrow.setVisible (false);
		//this._rightArrow.setLocation(groupWidth - 20);
		this.resetTabSizes();
	}*/
	
	if (this._leftArrow.getVisible()) {
		this._leftArrow.setLocation(0, this.getArrowY());
	}else{
		this._leftArrow.setLocation(Dwt.LOC_NOWHERE, Dwt.LOC_NOWHERE);
	}
	
	if (this._rightArrow.getVisible()) {
		this._rightArrow.setLocation(this.getW () - 16, this.getArrowY());
	}else{
		this._rightArrow.setLocation(Dwt.LOC_NOWHERE, Dwt.LOC_NOWHERE);
	}
	
	if (isShiftNeeded && shouldShift) { //expecially useful at the window resize
		var n ;
		if (indexOfHiddenSelectedTab < this._visibleStartTab) { //hidden on the left
			n = indexOfHiddenSelectedTab - this._visibleStartTab ;
		}else { //hidden on the right
		 	n = indexOfHiddenSelectedTab - (this._visibleStartTab + this._numberOfVisibleTabs - 1);
		}
		this.shift(n) ;
	}
}

/**
 * Shift the tab by n (move range of the tab index)
 * n > 0 ; shift right (click the right arrow)
 * n < 0 ; shift left (click the left arrow)
 * 
 */
ZaAppTabGroup.prototype.shift =
function (n) {
	if (! this._numberOfVisibleTabs) return ;
	var totalNoTabs = ZaAppTabGroup._TABS.size() ;
	//
	if (this._numberOfVisibleTabs + this._visibleStartTab + n > totalNoTabs) {
		n = totalNoTabs - this._numberOfVisibleTabs - this._visibleStartTab ;
	}
	
	if (!n) {
		return ;
	}else if (n >0) {
		this._leftArrow.setEnabled(true);
		AjxImg.setImage(this._leftArrow.getHtmlElement(), "LeftArrow");
	}else if (n < 0) {
		this._rightArrow.setEnabled (true) ;
		AjxImg.setImage(this._rightArrow.getHtmlElement(), "RightArrow");
	}
	var nextX = 0; 
	var groupWidth = this.getW () ;
	this._leftArrow.setLocation (nextX, this.getArrowY()) ;
	//20 is the width of the arrow image
	this._rightArrow.setLocation (groupWidth - 20, this.getArrowY()) ;
	nextX += 20 ;
	
	this._visibleStartTab += n ;
	for (var i=0; i < totalNoTabs; i++) {
	 	var cTab = ZaAppTabGroup._TABS.get(i) ;
	 	if ((i >= this._visibleStartTab) 
	 			&& (i <= (this._visibleStartTab + this._numberOfVisibleTabs -1))){
			cTab.setVisible (true) ;
			cTab.setLocation (nextX);
			if (i+1 == totalNoTabs) { //last tab is visible
				this._rightArrow.setEnabled(false) ;
				AjxImg.setImage(this._rightArrow.getHtmlElement(), "rightArrowDis");
			} 
			
			if ( i == 0){
				this._leftArrow.setEnabled (false) ;
				AjxImg.setImage(this._leftArrow.getHtmlElement(), "LeftArrowDis");
			}
			nextX += this.getCurrentTabWidth() + 7 ;
	 	}else{
	 		cTab.setVisible (false) ;
	 	} 
	}
	
	//this.resetTabSizes();
}

ZaAppTabGroup.prototype.setArrowHandler =
function () {
	/*
	this._leftArrow.addListener (DwtEvent.ONMOUSEOUT, new AjxListener(this._leftArrow, ZaAppTabGroup._arrowMouseOutHdlr));
	this._leftArrow.addListener (DwtEvent.ONMOUSEUP, new AjxListener(this._leftArrow, ZaAppTabGroup._arrowMouseUpHdlr));
	this._leftArrow.addListener (DwtEvent.ONMOUSEOVER, new AjxListener(this._leftArrow, ZaAppTabGroup._arrowMouseOverHdlr));
	this._leftArrow.addListener (DwtEvent.ONMOUSEDOWN, new AjxListener(this._leftArrow, ZaAppTabGroup._arrowMouseDownHdlr));
	
	
	this._rightArrow.addListener (DwtEvent.ONMOUSEOUT, new AjxListener(this, ZaAppTabGroup._arrowMouseOutHdlr));
	this._rightArrow.addListener (DwtEvent.ONMOUSEUP, new AjxListener(this, ZaAppTabGroup._arrowMouseUpHdlr));
	this._rightArrow.addListener (DwtEvent.ONMOUSEOVER, new AjxListener(this, ZaAppTabGroup._arrowMouseOverHdlr));
	this._rightArrow.addListener (DwtEvent.ONMOUSEDOWN, new AjxListener(this, ZaAppTabGroup._arrowMouseDownHdlr));
	*/
	//this._leftArrow.addSelectionListener(selListener) ;
	//this._rightArrow.addSelectionListener(selListener) ;
	
	
	Dwt.setHandler(this._leftArrow.getHtmlElement(), DwtEvent.ONMOUSEDOWN, ZaAppTabGroup._leftArrowMouseDownHdlr);
	Dwt.setHandler(this._leftArrow.getHtmlElement(), DwtEvent.ONMOUSEUP, ZaAppTabGroup._leftArrowMouseUpHdlr);
	Dwt.setHandler(this._leftArrow.getHtmlElement(), DwtEvent.ONMOUSEOVER, ZaAppTabGroup._arrowMouseOverHdlr);
	Dwt.setHandler(this._leftArrow.getHtmlElement(), DwtEvent.ONMOUSEOUT, ZaAppTabGroup._arrowMouseOutHdlr);
	
	Dwt.setHandler(this._rightArrow.getHtmlElement(), DwtEvent.ONMOUSEDOWN, ZaAppTabGroup._rightArrowMouseDownHdlr);
	Dwt.setHandler(this._rightArrow.getHtmlElement(), DwtEvent.ONMOUSEUP, ZaAppTabGroup._rightArrowMouseUpHdlr);
	Dwt.setHandler(this._rightArrow.getHtmlElement(), DwtEvent.ONMOUSEOVER, ZaAppTabGroup._arrowMouseOverHdlr);
	Dwt.setHandler(this._rightArrow.getHtmlElement(), DwtEvent.ONMOUSEOUT, ZaAppTabGroup._arrowMouseOutHdlr);
	
 }

/*
ZaAppTabGroup.prototype._arrowSelListener =
function (ev){
	DBG.println(AjxDebug.DBG1, "Arrow Selected ....") ;
}*/

ZaAppTabGroup._arrowMouseOverHdlr =
function (ev) {
	//DBG.println(AjxDebug.DBG1, "Mouse on arrow button is over ....") ;
	var obj = DwtControl.getTargetControl(ev);
	if (obj.getEnabled()) {
		obj.setCursor("pointer") ;
	}
}

ZaAppTabGroup._arrowMouseOutHdlr =
function (ev) {
	//DBG.println(AjxDebug.DBG1, "Mouse on arrow button is out ....") ;
	var obj = DwtControl.getTargetControl(ev);
	obj.setCursor("default") ;
}

ZaAppTabGroup._leftArrowMouseDownHdlr =
function (ev) {
	//DBG.println(AjxDebug.DBG1, "Mouse on arrow button is down ....") ;
	var obj = DwtControl.getTargetControl(ev); 
	AjxImg.setImage(this, "LeftArrowDis");
	if (obj.getEnabled()) {
		obj.parent.shift (-1);
	}
}

ZaAppTabGroup._rightArrowMouseDownHdlr =
function (ev) {
	//DBG.println(AjxDebug.DBG1, "Mouse on arrow button is down ....") ;
	var obj = DwtControl.getTargetControl(ev); 
	AjxImg.setImage(this, "rightArrowDis");
	if (obj.getEnabled()) {
		obj.parent.shift (1) ;
	}
}

ZaAppTabGroup._leftArrowMouseUpHdlr =
function (ev) {
	//DBG.println(AjxDebug.DBG1, "Mouse on arrow button is up ....") ;
	var obj = DwtControl.getTargetControl(ev); 
	
	if (obj.getEnabled()) {
		obj.setCursor("pointer");
		AjxImg.setImage(this, "LeftArrow");
	}
}

ZaAppTabGroup._rightArrowMouseUpHdlr =
function (ev) {
	//DBG.println(AjxDebug.DBG1, "Mouse on arrow button is up ....") ;
	var obj = DwtControl.getTargetControl(ev); 

	if (obj.getEnabled()) {
		obj.setCursor("pointer");
		AjxImg.setImage(this, "RightArrow");
	}
}

ZaAppTabGroup.prototype.getTabWidth =
function () {
	var tabWidth ;
	var tabMinWidth = ZaAppTab.DEFAULT_MIN_WIDTH;
	var tabMaxWidth = ZaAppTab.DEFAULT_MAX_WIDTH;
	var groupWidth = this.getW () ;
//	var groupWidth = this.getW () - 40; //40 is the size the left/right arrow
	
	
	if (this._leftArrow.getVisible()) {
		groupWidth -= 23; //the offset when the leftArrow is visible
	}
	
	if (this._rightArrow.getVisible()) {
		groupWidth -= 19; //16 length + 3 left-margin
	}
	
	if (groupWidth > 0) {
		if (groupWidth > tabMinWidth) {
			var numOfTabs = ZaAppTabGroup._TABS.size() ;
			this._numberOfVisibleTabs = numOfTabs ;
			var avgTabWidth = Math.floor(groupWidth / (numOfTabs <= 0 ? 1 : numOfTabs)) ;
			if (avgTabWidth >= tabMinWidth && avgTabWidth <= tabMaxWidth) {
				tabWidth = avgTabWidth ;
			}else if (avgTabWidth > tabMaxWidth) {
				tabWidth = tabMaxWidth ;
			}else if (avgTabWidth < tabMinWidth) {
				//too many tabs and can't be all visible
				//it should equal to the groupWidth/numberOfTabVisible.
				//tabWidth = tabMinWidth ;
								
				var numTabsVisible = this._numberOfVisibleTabs = Math.floor(groupWidth / tabMinWidth) ;
				
				tabWidth = Math.floor(groupWidth / numTabsVisible) ; 
				/*if(window.console && window.console.log) console.debug(   "groupWidth = " + groupWidth 
											+ " and number of tabs visible = " + numTabsVisible
											+ " tab width = " + tabWidth );*/
				//need to show the navigation arrows, so resize the tab width is required
				if ((!this._leftArrow.getVisible()) || (! this._rightArrow.getVisible())){
					this._leftArrow.setVisible (true);
					this._rightArrow.setVisible (true);
					tabWidth = this.getTabWidth();
				}
				
				return tabWidth ;
			}			
		}else {
			tabWidth = groupWidth ;
		}	
	}else{
		tabWidth = ZaAppTab.DEFAULT_MAX_WIDTH ;
	}
	
	//all the tabs are visible
	if (this._leftArrow.getVisible() ||  this._rightArrow.getVisible()) {
		this._leftArrow.setVisible (false);
		this._rightArrow.setVisible (false);
		tabWidth = this.getTabWidth();
	}
	
	return tabWidth ;
}

ZaAppTabGroup.prototype.addTab = 
function (tab, resize) {
	ZaAppTabGroup._TABS.add(tab);
	if (resize) {
		this.resetTabSizes();
	}
	return true;
	/*
	var cSize = ZaAppTabGroup._TABS.size () ;
	if (cSize >= ZaAppTabGroup.TAB_LIMIT) {
		ZaApp.getInstance().getCurrentController().popupMsgDialog(ZaMsg.too_many_tabs);
		ZaApp.getInstance().disposeView (tab.getTabId());
		tab.dispose();
		return false ;
	}else{
		ZaAppTabGroup._TABS.add(tab);
		if (resize) {
			this.resetTabSizes();
		}
		return true;
	}*/
}

ZaAppTabGroup.prototype.removeTab =
function (tab, resize) {
	if (tab == this._searchTab) {
		this._searchTab = null ;
		//need to reset the search list controller
		var slc = ZaApp.getInstance().getSearchListController();
		if(slc)
			slc.reset() ;
	}
	ZaAppTabGroup._TABS.remove (tab) ;
	
	tab.dispose () ;
	if (resize) {
		this.resetTabSizes ();
	}
}

ZaAppTabGroup.prototype.removeCurrentTab =
function (resize) {
	var cTab = this.getCurrentTab () ;
	this.removeTab(cTab, resize) ;
	//select the next active Tab
	this.selectTab (this.getTabById (ZaApp.getInstance()._currentViewId)) ; 
}
	
ZaAppTabGroup.prototype.selectTab =
function (tab) {
	if (this.getCurrentTab() == tab) return ;
	
	for (var i=0; i < ZaAppTabGroup._TABS.size(); i++) {
		var cTab = ZaAppTabGroup._TABS.get(i) ;
		if (cTab == tab) {
			cTab.setSelectState();
			this._currentTab = cTab ;
			
			//check weather the shift action is needed
			if ( i < this._visibleStartTab) { //show the hidden tab on the left
				this.shift (i - this._visibleStartTab ) ;
			}else if (i > (this._numberOfVisibleTabs + this._visibleStartTab - 1)) {
				this.shift (i - (this._numberOfVisibleTabs + this._visibleStartTab - 1));
			}
			
		}else if (cTab.isSelected()){
			cTab.setUnselectState ();
		}	
	}
}

ZaAppTabGroup.prototype.getTabById = 
function (id) {	
	for (var i=0; i < ZaAppTabGroup._TABS.size(); i++) {
		var cTab = ZaAppTabGroup._TABS.get(i) ;
		if (cTab.getTabId() == id) {
			return cTab ;
		}
	}
}
	
ZaAppTabGroup.prototype.getTabHeight =
function () {
	var h = this.getH ();	
	if (h > 0) {
		return h ;
	}else{
		return ZaAppTab.DEFAULT_HEIGHT ;
	}
} 

ZaAppTabGroup.prototype.getCurrentTab =
function () {
	return this._currentTab ;
}

ZaAppTabGroup.prototype.getMainTab =
function () {
	return this._mainTab ;
}

ZaAppTabGroup.prototype.getSearchTab =
function () {
	if (this._searchTab) {
		return this._searchTab ;
	}else{
		var tabParams = {
			closable: true,
			selected: true
		}
		
		this._searchTab = new ZaAppTab (this,  tabParams);
		return this._searchTab ;
	}
}

ZaAppTabGroup.prototype.size =
function () {
	return ZaAppTabGroup._TABS.size() ;
}

/*
 * Used to find the existing tab of an item, so we won't open duplicated tab for the same item
 */
ZaAppTabGroup.prototype.getTabByItemId =
function (itemId, tabConstructor) {
	for (var i=0; i < ZaAppTabGroup._TABS.size(); i++) {
		var tab = ZaAppTabGroup._TABS.get(i) ;
		var v = tab.getAppView() ;
		if (v && v._containedObject && v._containedObject.id && v.constructor) {
			if (itemId == v._containedObject.id && (v.constructor==tabConstructor || !tabConstructor)) {
				return tab ;
			}
		}
	}
}

ZaAppTabGroup.getDirtyTabTitles =
function () {
	var dirtyTabTitles = [] ;
	for (var i=0; i < ZaAppTabGroup._TABS.size(); i++) {
		var tab = ZaAppTabGroup._TABS.get(i) ;
		var v = tab.getAppView() ;
		if (v && v.isDirty && v.isDirty()) {
			dirtyTabTitles.push(tab.getTitle());
		}
	}
	return dirtyTabTitles ;
}


}
if (AjxPackage.define("zimbraAdmin.common.ZaAppTab")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2007, 2008, 2009, 2010, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2007, 2008, 2009, 2010, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Used to create an application tab and its operations, such as new a  tab, 
 * close a tab, edit the tab label.
 * 
 * It will also remember the state of the tab: hidden/shown and dirty/clean.
 * @param parent - the tab group containing all the tabs.
 * 
 * @param params :
 *  	closable - whether the close icon and action should be added
 * 		selected - whether the newly created tab should be selected 
 *		id - the tabId used to identify an unique tab.
 * 		toolTip - the tooltip of the tab
*/

ZaAppTab = function(parent, params) {
	if (arguments.length == 0) return ;
	
//	this._origClassName = "ImgAppTab" ;
	
	DwtButton.call(this,{
		parent:parent, 
		className:"ZaAppTabButton" , 
		posStyle:Dwt.ABSOLUTE_STYLE,
		id: params.mainId ? ZaId.getTabId(params.mainId,params.id):params.id
	});
	//clean the DwtButton event listeners
	this.removeListener(DwtEvent.ONMOUSEOVER, this._mouseOverListenerObj);
	
	//build the Tab UI
	this._tabId = params.id || ZaApp.getInstance()._currentViewId ;
	
	var w = params.width || parent.getTabWidth() ;
	var h = params.height || parent.getTabHeight() ;
	this.setSize(w, h) ;
		
	if (params.label) 	{
		this.setText (params.label);
		this._title = params.label ;
	}
	if (params.icon) this.setImage (params.icon);
	
	if (params.toolTip && params.toolTip.length > 0) {
		this.setToolTipContent (params.toolTip) ;
	}
		
	this._closable = false ;
	if (params.closable == true) {		
		this.addCloseCell() ;
	}
	
	//control the Tab behavior
	var selListener = new AjxListener(this, ZaAppTab.prototype._selListener);
	this.addSelectionListener(selListener) ;

	if (params.onOpen && params.onOpen instanceof AjxListener) {
		this.addSelectionListener(params.onOpen);
	}
	
	var mouseoutListener = new AjxListener(this, ZaAppTab.prototype._mouseoutListener) ;
	this.addListener (DwtEvent.ONMOUSEOUT, mouseoutListener);

	if (parent.addTab(this, true)){
		this._selected = params.selected;
		if (this._selected) {
			parent.selectTab(this) ;
		}
	}
	
	//add the popup menu
	this._addPopupMenu () ;
}

ZaAppTab.prototype = new DwtButton;
ZaAppTab.prototype.constructor = ZaAppTab;

ZaAppTab.DEFAULT_HEIGHT = 22 ;
ZaAppTab.DEFAULT_MAX_WIDTH = 200 ;
ZaAppTab.DEFAULT_MIN_WIDTH = 100 ;

ZaAppTab.prototype.getTitle =
function () {
	return this._title ;
}

ZaAppTab.prototype._addPopupMenu =
function () {
	this._popupOperations = [];
	
	//close the tab
	//if (this._closable) { //disable it instead of hiding it
	this._actionOpClose = new ZaOperation(ZaOperation.CLOSE_TAB, ZaMsg.tab_close, 
			null, null, null, new AjxListener(this, ZaAppTab.prototype.closeTab));
	this._popupOperations.push(this._actionOpClose);
	//}
	//close other tabs
	this._actionOpCloseOthers = new ZaOperation(ZaOperation.CLOSE_OTHER_TAB, ZaMsg.tab_close_others,
			null, null, null, new AjxListener(this, ZaAppTab.prototype.closeOtherTabs));
	this._popupOperations.push(this._actionOpCloseOthers) ;
	//close all tabs
	this._actionOpCloseAll = new ZaOperation(ZaOperation.CLOSE_ALL_TAB, ZaMsg.tab_close_all,
			null, null, null, new AjxListener(this, ZaAppTab.prototype.closeAllTabs));
	this._popupOperations.push(this._actionOpCloseAll) ;
	
	this._actionMenu =  new ZaPopupMenu(this, "ActionMenu", null, this._popupOperations);
	
	//add the popup menu related mouse listeners
	//right button click of the mouse
	var actionListener = new AjxListener (this, ZaAppTab.prototype._mouseRightClickListener) ;
	this.addListener(DwtEvent.ACTION, actionListener);
	
	this._tabMouseUpListener = new AjxListener (this, ZaAppTab.prototype._tabMouseupListener) ;
	this.addListener(DwtEvent.ONMOUSEUP, this._tabMouseUpListener);
}

ZaAppTab.prototype.getAppView =
function () {
	var view = ZaApp.getInstance().getViewById (this._tabId);
	if(view) {
		return view[ZaAppViewMgr.C_APP_CONTENT] ;
	} else {
		return null;
	}
	
}

ZaAppTab.prototype._selListener =
function (ev) {
	DBG.println(AjxDebug.DBG1, "ZaAppTab.prototype._selListenr") ;
	//this.setSelectState () ;
	this.parent.selectTab(this);
}

ZaAppTab.prototype._mouseoutListener =
function (ev) {
	//DBG.println(AjxDebug.DBG1, "ZaAppTab.prototype._mouseoutListenr") ;
	//console.debug("This is a mouse out action") ;
	this.restoreOrginState() ;
}

ZaAppTab.prototype._tabMouseupListener =
function (ev) {
	//if (window.console) console.debug("Tab Mouse Up") ;
	if (ev.button == DwtMouseEvent.RIGHT) {
		if (this.isListenerRegistered(DwtEvent.ACTION)) {				
				this.notifyListeners(DwtEvent.ACTION, ev);
		}
	}
}

ZaAppTab.prototype._mouseRightClickListener =
function (ev) {
	//if (window.console) console.debug("This is a right mouse action") ;
	var tabGroup = this.parent ;
	var tabs = tabGroup.getTabs() ;
	var n = tabs.size() ;
	if ( n <= 1) {
		this._actionMenu.enableAll(false) ;
	} else if ( n <= 2 && this != tabGroup.getMainTab()) {
		this._actionMenu.enable(ZaOperation.CLOSE_TAB, true) ;
		this._actionMenu.enable(ZaOperation.CLOSE_ALL_TAB, true) ;
		this._actionMenu.enable(ZaOperation.CLOSE_OTHER_TAB, false) ;
	}else{
		this._actionMenu.enableAll(true) ;
	}
	
	this._actionMenu.popup(0, ev.docX, ev.docY);
}

ZaAppTab.prototype.setSelectState =
function () {
	this._selected = true ;
    this.setDisplayState(DwtControl.SELECTED);
	//this.setCursor ("default") ;
	this.removeListener(DwtEvent.ONMOUSEUP, this._mouseUpListenerObj);
	
	var viewId = this.getTabId () ;
	if (viewId != ZaApp.getInstance()._currentViewId) {
		ZaApp.getInstance().pushView (viewId);
	}	
	if (this._closeCell) {
		AjxImg.setImage (this._closeCell, "Close") ;
	}
}

ZaAppTab.prototype.setUnselectState =
function () {
	this._selected = false ;
    this.setDisplayState(DwtControl.NORMAL);
	//this.setCursor ("pointer") ;
	this.addListener(DwtEvent.ONMOUSEUP, this._mouseUpListenerObj);
	
	if (this._closeCell) {
		AjxImg.setDisabledImage (this._closeCell, "Close");
	}
}

ZaAppTab.prototype.restoreOrginState =
function () {
	if (this._selected) {
        this.setDisplayState(DwtControl.SELECTED);
	}else {
        this.setDisplayState(DwtControl.NORMAL);
	}
}

ZaAppTab.prototype.setTabId =
function (id) {
	this._tabId = id ;
}

ZaAppTab.prototype.getTabId =
function () {
	return this._tabId ;
}

ZaAppTab.prototype.isSelected =
function () {
	return this._selected ;
}

//reset the label text
//l - new label text
ZaAppTab.prototype.resetLabel =
function(l){
	l = l || this.getText() ;
	
	if (! l) {
		return ;
	}else{
		this._title = l ;
	}
	
	//var tabW = this.getW (); //when the tab is hidden, getW () return 0
	var tabW = this.parent.getCurrentTabWidth (); //we need an internal variable to keep the width for the hidden tab
	if (this._closable) tabW -= 20 ;
	
	//assume 5.5px per letter	
	var maxNumberOfLetters = Math.floor((tabW - 30)/5.5) ;
	if (maxNumberOfLetters < l.length){ //set the new text
		this.setText(l.substring(0, (maxNumberOfLetters - 3)) + "...");
	}else {
		this.setText (l) ;
	}
}

ZaAppTab.prototype.addCloseCell =
function () {
	this._closable = true ;
	
	this._closeCell = this._row.insertCell (this._row.cells.length) ;
	this._closeCell.className = "Icon" ;
	AjxImg.setImage(this._closeCell, "Close") ;
	
	Dwt.setHandler(this._closeCell, DwtEvent.ONMOUSEDOWN, ZaAppTab._closeCellMouseDownHdlr);
	Dwt.setHandler(this._closeCell, DwtEvent.ONMOUSEUP, ZaAppTab._closeCellMouseUpHdlr);
	Dwt.setHandler(this._closeCell, DwtEvent.ONMOUSEOVER, ZaAppTab._closeCellMouseOverHdlr);
	Dwt.setHandler(this._closeCell, DwtEvent.ONMOUSEOUT, ZaAppTab._closeCellMouseOutHdlr);
}

ZaAppTab._closeCellMouseDownHdlr =
function (ev) {
	//DBG.println(AjxDebug.DBG1, "Close Button is clicked ....") ;
	var obj = DwtControl.getTargetControl(ev); //obj is ZaAppTab instance
}

ZaAppTab._closeCellMouseUpHdlr =
function (ev) {
	//close the tab and the view
	var obj = DwtControl.getTargetControl(ev); 
	obj.closeTab();
	/*

	var tabViewId = obj.getTabId () ;
	var cc = ZaApp.getInstance().getControllerById (tabViewId) ;
	
	//check whether the closing view is hidden or visible
	if (tabViewId == ZaApp.getInstance()._currentViewId) { //visible
		cc.closeButtonListener(ev); //Tab handling is in the view controller's close button listener
	}else{ //hidden 
		//TODO what if it is dirty?
		cc.closeButtonListener(ev, true, ZaAppTab.prototype.closeHiddenTab, obj ) ;
	}*/
}

ZaAppTab.prototype.closeTab =
function() {
	if (this._actionMenu && this._actionMenu.isPoppedUp()) {
		this._actionMenu.popdown();
	} 
	
	if (this._closable) {
		
		var tabViewId = this.getTabId () ;
		var cc = ZaApp.getInstance().getControllerById (tabViewId) ;
		
		//check whether the closing view is hidden or visible
		if (tabViewId == ZaApp.getInstance()._currentViewId) { //visible
			//if(window.console && window.console.log) console.debug("Close current tab " + this.getTitle() + " with ID " + tabViewId);
			cc.closeButtonListener(); //Tab handling is in the view controller's close button listener
		}else{ //hidden 
			//TODO what if it is dirty?
			//if(window.console && window.console.log) console.debug("Close hidden tab " + this.getTitle() + " with ID " + tabViewId );
			cc.closeButtonListener(null, true, ZaAppTab.prototype.closeHiddenTab, this ) ;
		}
	}
}

ZaAppTab.prototype.closeOtherTabs =
function () {
	
	if (this._actionMenu && this._actionMenu.isPoppedUp()) {
		this._actionMenu.popdown();
	}
	 
	var tabTitles = ZaAppTabGroup.getDirtyTabTitles() ;
	if ( tabTitles.length > 0 ){
		ZaApp.getInstance().getCurrentController().popupMsgDialog(
				AjxMessageFormat.format(ZaMsg.tab_close_warning, [tabTitles.join("<br />")]));
		return ;
	}else{
		if (ZaAppTabGroup.getDirtyTabTitles)
		var tabGroup = this.parent ;
		var tabs = tabGroup.getTabs() ;
		var closingTabs = [] ;
		for (var i=0; i < tabs.size(); i++) {
			var cTab = tabs.get(i) ;
			if ((cTab != this) && (cTab._closable)) {
				//close
				closingTabs.push (cTab) ;
			}
		}
		
		for (var j=0; j < closingTabs.length; j ++) {
			closingTabs[j].closeTab();
		}
		
		if (closingTabs.length > 0) {
			tabGroup.selectTab(this);
		}
	}
}

ZaAppTab.prototype.closeAllTabs =
function () {
	if (this._actionMenu && this._actionMenu.isPoppedUp()) {
		this._actionMenu.popdown();
	} 
	
	var tabTitles = ZaAppTabGroup.getDirtyTabTitles() ;
	if ( tabTitles.length > 0 ){
		ZaApp.getInstance().getCurrentController().popupMsgDialog(
				AjxMessageFormat.format(ZaMsg.tab_close_warning, [tabTitles.join("<br />")]));
		return ;
	}else{
		var tabGroup = this.parent ;
		var tabs = tabGroup.getTabs() ;
		var closingTabs = [] ;
		for (var i=0; i < tabs.size(); i++) {
			var cTab = tabs.get(i) ;
			if (cTab._closable) {
				//close
				closingTabs.push(cTab) ;
			}
		}
		
		for (var j=0; j < closingTabs.length; j ++) {
			//if(window.console && window.console.log) console.log("Closing tab " + closingTabs[j].getTabId()) ;
			closingTabs[j].closeTab();
		}
		
		if (closingTabs.length > 0 && tabs.size() > 0) {
			tabGroup.selectTab(tabs.get(0));
		}
	}
}

ZaAppTab.prototype.closeHiddenTab =
function () {

	var tabViewId = this.getTabId () ;
	
	//Make sure the nextTab is selected. 
	// It is useful when user close a dirty hidden tab and the select action is invoked.
	if (tabViewId == ZaApp.getInstance()._currentViewId) {
		ZaApp.getInstance().popView();
	}else{
		this.parent.removeTab (this, true) ;
		//dispose the view and remove the controller
		ZaApp.getInstance().disposeView (tabViewId,true) ;
	}
}

ZaAppTab._closeCellMouseOverHdlr =
function (ev) {
	//DBG.println(AjxDebug.DBG1, "Over the close button ....") ;
	var obj = DwtControl.getTargetControl(ev);
	AjxImg.setImage (obj._closeCell, "Close") ;
	//obj.setCursor("pointer");
	obj._mainToolTip = obj.getToolTipContent ();
	obj.setToolTipContent (ZaMsg.ALTBB_Close_tt) ;
}

ZaAppTab._closeCellMouseOutHdlr =
function (ev) {
	var obj = DwtControl.getTargetControl(ev);
	if (obj.isSelected()) {
		AjxImg.setImage (obj._closeCell, "Close") ;
	}else{
		AjxImg.setDisabledImage (obj._closeCell, "Close");
	}
	//obj.setCursor("default");
	obj.setToolTipContent (obj._mainToolTip) ;
}
ZaAppTab.prototype._createHtmlFromTemplate = function(templateId, data) {
    DwtButton.prototype._createHtmlFromTemplate.call(this, "admin.Widgets#ZaAppTab", data);
    this._row = document.getElementById(data.id+"_row");
};
}
if (AjxPackage.define("zimbraAdmin.common.ZaRequestMgr")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2007, 2009, 2010, 2012, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2007, 2009, 2010, 2012, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
 * @author Charles Cao
 * ZaRequestMgr: used to send the soap request to the server and handle the following events:
 * 		1) show the busy dialog when it is a synchronous call and takes long time
 */
ZaRequestMgr = function () {}
/**
 * 
 * @param csfeParams: the parameters used by ZmCsfeCommand to send the request to the server
 * @param params: other parameters used by the ZaRequestMgr. 
 * 			Typical parameters are 
 * 			1) controller
 * 			2) busyMsg	
 * 
 */
ZaRequestMgr.invoke = function (csfeParams, params) {
	var command = new ZmCsfeCommand();
	var controller = (params != null ? params.controller : null) ;
	var delay = !(params.delay === null || params.delay===undefined) ? params.delay : 500;
	var id = params.busyId ? params.busyId : Dwt.getNextId () ;
	//add the busy icon for the synchronous calls
	if (!csfeParams.asyncMode && controller || (params.showBusy && controller)) {
		controller._shell.setBusyDialogText(params.busyMsg != null ? params.busyMsg :ZaMsg.splashScreenLoading);
		controller._currentRequest = command ; //_currentRequest obj will be used in the cancel operation
		var cancelCallback = new AjxCallback(controller, controller.cancelBusyOverlay, params );
		//if(window.console && window.console.log) console.log("Set busy for dialog " + id) ;
		controller._shell.setBusy(true, id, true, delay, cancelCallback);
	}
	
	try {
		ZaZimbraAdmin.getInstance().cancelNoOp();
		csfeParams.noAuthToken = true;
		var response = command.invoke(csfeParams) ;
		if (!csfeParams.asyncMode && controller) {
			//if(window.console && window.console.log) console.log("Clear busy dialog " + id) ;
			controller._shell.setBusy(false, id, false); //remove the busy overlay
		}
		if (! csfeParams.asyncMode)	{
			ZaZimbraAdmin.getInstance().scheduleNoOp();
			return 	response;
		}	
	}catch (ex) {
		if(ex && ex.code && !(ex.code == ZmCsfeException.SVC_AUTH_EXPIRED || 
				ex.code == ZmCsfeException.SVC_AUTH_REQUIRED || 
				ex.code == ZmCsfeException.NO_AUTH_TOKEN ||
                                ex.code == ZmCsfeException.AUTH_TOKEN_CHANGED
			 )) {
			ZaZimbraAdmin.getInstance().scheduleNoOp();
		}
		if (!csfeParams.asyncMode && controller  || (params.showBusy && controller)) {
			controller._shell.setBusy(false, id); //remove the busy overlay
		}
		throw ex ;	
	}
}


}
if (AjxPackage.define("zimbraAdmin.common.ZaActionStatusView")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
 * @overview
 */

/**
 * Creates the action status view.
 * @class
 * This class represents the action status view.
 *
 * @param    {DwtControl}    parent        the parent
 * @param    {String}        className     the class name
 * @param    {constant}      posStyle      the position style
 * @param    {String}        id            the id
 *
 * @extends		DwtControl
 */
ZaActionStatusView = function(parent, className, posStyle, id) {

    DwtControl.call(this, {parent:parent, className:(className || "ZaActionStatus"), posStyle:posStyle, id:id});

    this._toast = this._standardToast = new ZaToast(this, ZaId.TOAST);
    this._statusQueue = [];
};

ZaActionStatusView.prototype = new DwtControl;
ZaActionStatusView.prototype.constructor = ZaActionStatusView;


// Constants
/**
 * Defines the "informational" status level.
 */
ZaActionStatusView.LEVEL_INFO             = 1;    // informational
/**
 * Defines the "warning" status level.
 */
ZaActionStatusView.LEVEL_WARNING          = 2;    // warning
/**
 * Defines the "critical" status level.
 */
ZaActionStatusView.LEVEL_CRITICAL         = 3;    // critical

ZaActionStatusView.MSG_PARAMS = ["msg", "level", "detail", "transitions", "toast", "force", "dismissCallback", "finishCallback"];

// Public methods

ZaActionStatusView.prototype.toString =
function() {
    return "ZaActionStatusView";
};

/**
 * Displays a status message.
 *
 * @param {String}    msg the message
 * @param {constant}    [level]         the level (see {@link ZaActionStatusView}<code>.LEVEL_</code> constants)
 * @param {String}    [detail]         the details
 * @param {String}    [transitions] the transitions (see {@link ZaToast})
 * @param {String}    [toast]     the toast control
 * @param {boolean}    [force]        force any displayed toasts out of the way
 * @param {AjxCallback}    [dismissCallback]    callback to run when the toast is dismissed (by another message using [force], or explicitly calling ZaActionStatusView.prototype.dismiss())
 * @param {AjxCallback}    [finishCallback]     callback to run when the toast finishes its transitions by itself (not when dismissed)
 */
ZaActionStatusView.prototype.setStatusMsg =
function(params) {
    params = Dwt.getParams(arguments, ZaActionStatusView.MSG_PARAMS);
    if (typeof params == "string") {
        params = { msg: params };
    }
    var work = {
        msg: params.msg,
        level: params.level || ZaActionStatusView.LEVEL_INFO,
        detail: params.detail,
        date: new Date(),
        transitions: params.transitions,
        toast: params.toast || this._standardToast,
        dismissCallback: (params.dismissCallback instanceof AjxCallback) ? params.dismissCallback : null,
        finishCallback: (params.finishCallback instanceof AjxCallback) ? params.finishCallback : null,
		dismissed: false
    };

	if (params.force) { // We want to dismiss ALL messages in the queue and display the new message
		for (var i=0; i<this._statusQueue.length; i++) {
			this._statusQueue[i].dismissed = true; // Dismiss all messages in the queue in turn, calling their dismissCallbacks along the way
		}
	}
    // always push so we know one is active
    this._statusQueue.push(work);
    if (!this._toast.isPoppedUp()) {
        this._updateStatusMsg();
    } else if (params.force) {
        this.dismissStatusMsg();
    }
};

ZaActionStatusView.prototype.nextStatus =
function() {
    if (this._statusQueue.length > 0) {
        this._updateStatusMsg();
        return true;
    }
    return false;
};

ZaActionStatusView.prototype.dismissStatusMsg =
function(all) {
	if (all) {
		for (var i=0; i<this._statusQueue.length; i++) {
			this._statusQueue[i].dismissed = true; // Dismiss all messages in the queue in turn, calling their dismissCallbacks along the way
		}
	}
    this._toast.dismiss();
};

// Static functions

/**
 * Gets the style class name based on status level.
 *
 * @param     {ZaActionStatusView}        work        the view
 * @return    {String}                          the class
 */
ZaActionStatusView.getClass =
function(work) {
    switch (work.level) {
        case ZaActionStatusView.LEVEL_CRITICAL:    return "ZaToastCrit";
        case ZaActionStatusView.LEVEL_WARNING:     return "ZaToastWarn";
        default:                             return "ZaToastInfo";
    }
};

/**
 * Gets the image based on status level.
 *
 * @param     {ZaActionStatusView}        work        the view
 * @return    {String}                          the image
 */
ZaActionStatusView.getImageHtml =
function(work) {
    switch (work.level) {
        case ZaActionStatusView.LEVEL_CRITICAL:    return "Critical";
        case ZaActionStatusView.LEVEL_WARNING:     return "Warning";
        default:                             return "Success";
    }
};


// Protected methods

ZaActionStatusView.prototype._updateStatusMsg =
function() {
    var work = this._statusQueue.shift();
    if (!work) { return; }
	if (work.dismissed) { // If preemptively dismissed, just run the callback and proceed to the next msg
		if (work.dismissCallback)
			work.dismissCallback.run();
		this.nextStatus();
	} else {
		var level = ZaActionStatusView.getClass(work);
		var icon = ZaActionStatusView.getImageHtml(work);

		this._toast = work.toast;
		this._toast.popup(level, AjxStringUtil.htmlEncode(work.msg), icon, null, work.transitions, work.dismissCallback, work.finishCallback);
	}
};


//
// ZaToast
//

/**
 * Creates the "toaster".
 * @class
 * This class represents the "toaster".
 *
 * @extends	DwtComposite
 */
ZaToast = function(parent, id) {
    if (arguments.length == 0) { return; }

    DwtComposite.call(this, {parent:parent.shell, className:"ZaToast", posStyle:Dwt.ABSOLUTE_STYLE, id:id});
    this._statusView = parent;
    this._createHtml();

    this._funcs = {};

    this.popdown();

    this._funcs["position"] = AjxCallback.simpleClosure(this.__position, this);
    this._funcs["show"] = AjxCallback.simpleClosure(this.__show, this);
    this._funcs["hide"] = AjxCallback.simpleClosure(this.__hide, this);
    this._funcs["pause"] = AjxCallback.simpleClosure(this.__pause, this);
    this._funcs["hold"] = AjxCallback.simpleClosure(this.__hold, this);
    this._funcs["idle"] = AjxCallback.simpleClosure(this.__idle, this);
    this._funcs["fade"] = AjxCallback.simpleClosure(this.__fade, this);
    this._funcs["fade-in"] = this._funcs["fade"];
    this._funcs["fade-out"] = this._funcs["fade"];
    this._funcs["slide"] = AjxCallback.simpleClosure(this.__slide, this);
    this._funcs["slide-in"] = this._funcs["slide"];
    this._funcs["slide-out"] = this._funcs["slide"];
    this._funcs["next"] = AjxCallback.simpleClosure(this.transition, this);
}
ZaToast.prototype = new DwtComposite;
ZaToast.prototype.constructor = ZaToast;
ZaToast.prototype.toString =
function() {
    return "ZaToast";
};

// Constants
/**
 * Defines the "fade" transition.
 */
ZaToast.FADE = { type: "fade" };
/**
 * Defines the "fade-in" transition.
 */
ZaToast.FADE_IN = { type: "fade-in" };
/**
 * Defines the "fade-out" transition.
 */
ZaToast.FADE_OUT = { type: "fade-out" };
/**
 * Defines the "slide" transition.
 */
ZaToast.SLIDE = { type: "slide" };
/**
 * Defines the "slide-in" transition.
 */
ZaToast.SLIDE_IN = { type: "slide-in" };
/**
 * Defines the "slide-out" transition.
 */
ZaToast.SLIDE_OUT = { type: "slide-out" };
/**
 * Defines the "pause" transition.
 */
ZaToast.PAUSE = { type: "pause" };
/**
 * Defines the "hold" transition.
 */
ZaToast.HOLD = { type: "hold" };
/**
 * Defines the "idle" transition.
 */
ZaToast.IDLE = {type: "idle" };
/**
 * Defines the "show" transition.
 */
ZaToast.SHOW = {type: "show" };

ZaToast.DEFAULT_TRANSITIONS = [ZaToast.FADE_IN, ZaToast.PAUSE, ZaToast.FADE_OUT];

ZaToast.DEFAULT_STATE = {};
ZaToast.DEFAULT_STATE["position"] = { location: "C" }; // center
ZaToast.DEFAULT_STATE["pause"] = { duration: 3200 };
ZaToast.DEFAULT_STATE["hold"] = {};
ZaToast.DEFAULT_STATE["fade"] = { duration: 100, multiplier: 1 };
ZaToast.DEFAULT_STATE["fade-in"] = { start: 0, end: 99, step: 10, duration: 200, multiplier: 1 };
ZaToast.DEFAULT_STATE["fade-out"] = { start: 99, end: 0, step: -10, duration: 200, multiplier: 1 };
ZaToast.DEFAULT_STATE["slide"] = { duration: 100, multiplier: 1 };
ZaToast.DEFAULT_STATE["slide-in"] = { start: -40, end: 0, step: 1, duration: 100, multiplier: 1 };
ZaToast.DEFAULT_STATE["slide-out"] = { start: 0, end: -40, step: -1, duration: 100, multiplier: 1 };

ZaToast.LEVEL_RE = /\b(ZaToastCrit|ZaToastWarn|ZaToastInfo)\b/g;
ZaToast.DISMISSABLE_STATES = [ZaToast.HOLD];

// Data

ZaToast.prototype.TEMPLATE = "admin.Widgets#ZaToast";


// Public methods

ZaToast.prototype.dispose =
function() {
    this._textEl = null;
    this._iconEl = null;
    this._detailEl = null;
    DwtComposite.prototype.dispose.call(this);
};

ZaToast.prototype.popup =
function(level, text, icon, loc, customTransitions, dismissCallback, finishCallback) {
    this.__clear();
    this._poppedUp = true;
    this._dismissed = false;
    this._dismissCallback = dismissCallback;
    this._finishCallback = finishCallback;

    // setup display
    var el = this.getHtmlElement();
    Dwt.delClass(el, ZaToast.LEVEL_RE, level || "ZaToastInfo")

    if (this._textEl) {
        this._textEl.innerHTML = text || "";
    }

    if (this._iconEl) {
        AjxImg.setImage(this._iconEl, icon, false);
    }

    // get transitions
    var location =  loc || "C" ;
    var transitions = customTransitions || ZaToast.DEFAULT_TRANSITIONS;

    transitions = [].concat( {type:"position", location:location}, transitions, {type:"hide"} );

    // start animation
    this._transitions = transitions;
    this.transition();
};

ZaToast.prototype.popdown =
function() {
    this.__clear();
    Dwt.setLocation(this.getHtmlElement(), Dwt.LOC_NOWHERE, Dwt.LOC_NOWHERE);
    this._poppedUp = false;
    if (!this._dismissed) {
        if (this._finishCallback)
            this._finishCallback.run();
    }
    this._dismissed = false;
};

ZaToast.prototype.isPoppedUp =
function() {
    return this._poppedUp;
};

ZaToast.prototype.transition =
function() {

    if (this._pauseTimer) {
        clearTimeout(this._pauseTimer);
        this._pauseTimer = null;
    }
    if (this._held) {
        this._held = false;
    }

    var transition = this._transitions && this._transitions.shift();
    if (!transition) {
        this._poppedUp = false;
        if (!this._statusView.nextStatus()) {
            this.popdown();
        }
        return;
    }

    var state = this._state = this._createState(transition);

    var el = this.getHtmlElement();
    //Dwt.setOpacity(el, state.opacity);
    Dwt.setLocation(el, state.x, state.y);

    this._funcs[transition.type || "next"]();
};

// Protected methods

ZaToast.prototype._createHtml =
function(templateId) {
    var data = { id: this._htmlElId };
    this._createHtmlFromTemplate(templateId || this.TEMPLATE, data);
    Dwt.setZIndex(this.getHtmlElement(), Dwt.Z_TOAST);
};

ZaToast.prototype._createHtmlFromTemplate =
function(templateId, data) {
    DwtComposite.prototype._createHtmlFromTemplate.call(this, templateId, data);
    this._textEl = document.getElementById(data.id+"_text");
    this._iconEl = document.getElementById(data.id+"_icon");
    this._detailEl = document.getElementById(data.id+"_detail");
};

ZaToast.prototype._createState =
function(transition) {
    var state = AjxUtil.createProxy(transition);
    var defaults = ZaToast.DEFAULT_STATE[state.type];
    for (var name in defaults) {
        if (!state[name]) {
            state[name] = defaults[name];
        }
    }
    var el = this.getHtmlElement();

    switch (state.type) {
        case "fade-in":
            Dwt.setOpacity(el, 0);
            Dwt.setLocation(el, null, null);
            state.value = state.start;
            break;
        case "fade-out":
        case "fade":
            Dwt.setLocation(el, null, null);
            state.value = state.start;
            break;
        case "slide-in":
        case "slide-out":
        case "slide":{
            Dwt.setLocation(el, null, -36);
            Dwt.setOpacity(el, 100);
            state.value = state.start;
            break;
        }
    }
    return state;
};

// Private methods

ZaToast.prototype.__clear =
function() {
    clearTimeout(this._actionId);
    clearInterval(this._actionId);
    this._actionId = -1;
};

// transition handlers

ZaToast.prototype.__position =
function() {
    var location = this._state.location || "C";
    var containerId;
    containerId = "skin_container_toaster";
    var el = this.getHtmlElement();
    var container = Dwt.byId(containerId) || this.shell.getHtmlElement();

    var bsize = Dwt.getSize(container);
    var tsize = Dwt.getSize(el);

    var x = (bsize.x - tsize.x) / 2;
    var y = (bsize.y - tsize.y) / 2;

    switch (location.toUpperCase()) {
        case 'N': y = 0-tsize.y; break;
        case 'S': y = bsize.y - tsize.y; break;
        case 'E': x = bsize.x - tsize.x; break;
        case 'W': x = 0; break;
        case 'NE': x = bsize.x - tsize.x; y = 0; break;
        case 'NW': x = 0; y = 0; break;
        case 'SE': x = bsize.x - tsize.x; y = bsize.y - tsize.y; break;
        case 'SW': x = 0; y = bsize.y - tsize.y; break;
        case 'C': default: /* nothing to do */ break;
    }

    var offset = Dwt.toWindow(container);
    x += offset.x;
    y += offset.y;

    x = (x>0) ? x : 0;
    y = (y>0) ? y : 0;
    Dwt.setLocation(el, x, y);

    this._funcs["next"]();
};

ZaToast.prototype.__show =
function() {
    var el = this.getHtmlElement();
    Dwt.setVisible(el, true);
    Dwt.setVisibility(el, true);
    this._funcs["next"]();
};

ZaToast.prototype.__hide =
function() {
    var el = this.getHtmlElement();
    Dwt.setLocation(el, Dwt.LOC_NOWHERE, Dwt.LOC_NOWHERE);
    this._funcs["next"]();
};

ZaToast.prototype.__pause =
function() {
    if (this._dismissed && ZaToast.__mayDismiss(ZaToast.PAUSE)) {
        this._funcs["next"]();
    } else {
        this._pauseTimer = setTimeout(this._funcs["next"], this._state.duration);
    }
};


/**
 * Hold the toast in place until dismiss() is called. If dismiss() was already called before this function (ie. during fade/slide in), continue immediately
 */
ZaToast.prototype.__hold =
function() {
    if (this._dismissed && ZaToast.__mayDismiss(ZaToast.HOLD)!=-1) {
        this._funcs["next"]();
    } else {
        this._held = true;
    }
};

ZaToast.__mayDismiss =
function(state) {
    return AjxUtil.indexOf(ZaToast.DISMISSABLE_STATES, state)!=-1;
};

/**
 * Dismiss (continue) a held or paused toast (Given that ZaToast.DISMISSABLE_STATES agrees). If not yet held or paused, those states will be skipped when they occur
 */
ZaToast.prototype.dismiss =
function() {
    if (!this._dismissed && this._poppedUp) {
        var doDismiss = (this._pauseTimer && ZaToast.__mayDismiss(ZaToast.PAUSE)) ||
            (this._held && ZaToast.__mayDismiss(ZaToast.HOLD));
        if (doDismiss) {
            this._funcs["next"]();
        }
        this._dismissed = true;
        if (this._dismissCallback instanceof AjxCallback) {
            this._dismissCallback.run();
        }
    }
};

ZaToast.prototype.__idle =
function() {
    if (!this._idleTimer) {
        this._idleTimer = new DwtIdleTimer(0, new AjxCallback(this, this.__idleCallback));
    } else {
        this._idleTimer.resurrect(0);
    }
};

ZaToast.prototype.__idleCallback =
function(idle) {
    if (!idle) {
        this.transition();
        this._idleTimer.kill();
    }
};

ZaToast.prototype.__move =
function() {
    // TODO
    this._funcs["next"]();
};

ZaToast.prototype.__fade =
function() {
    var opacity = this._state.value;
    var step = this._state.step;

    var isOver = step > 0 ? opacity >= this._state.end : opacity <= this._state.end;
    if (isOver) {
        opacity = this._state.end;
    }

    var el = this.getHtmlElement();
    Dwt.setOpacity(el, opacity);

    if (isOver) {
        this.__clear();
        setTimeout(this._funcs["next"], 0);
        return;
    }

    if (this._actionId == -1) {
        var duration = this._state.duration;
        var delta = duration / Math.abs(step);
        this._actionId = setInterval(this._funcs["fade"], delta);
    }

    this._state.value += step;
    this._state.step *= this._state.multiplier;
};

ZaToast.prototype.__slide =
function() {
    var top = this._state.value;
    var step = this._state.step;

    var isOver = step > 0 ? top >= this._state.end : top <= this._state.end;
    if (isOver) {
        top = this._state.end;
    }

    var el = this.getHtmlElement();
    //Dwt.setOpacity(el, opacity);
    Dwt.setLocation(el, null, top);
    //el.style.top = top+'px';


    if (isOver) {
        this.__clear();
        setTimeout(this._funcs["next"], 0);
        return;
    }

    if (this._actionId == -1) {
        var duration = this._state.duration;
        var delta = duration / Math.abs(step);
        this._actionId = setInterval(this._funcs["slide"], delta);
    }

    this._state.value += step;
    this._state.step *= this._state.multiplier;
};

}
if (AjxPackage.define("zimbraAdmin.common.ZaTreeItem")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Created by IntelliJ IDEA.
 * User: mingzhang
 * Date: 8/19/11
 * Time: 2:59 AM
 * To change this template use File | Settings | File Templates.
 */

ZaTreeItem = function(params) {
    if (arguments.length == 0) { return; }

    params.expandNodeImage = params.expandNodeImage || "Blank_16";
    params.collapseNodeImage= params.collapseNodeImage || "AdminCollapse";
    params.arrowDisabled = true;
    params = Dwt.getParams(arguments, ZaTreeItem.PARAMS);
    this._parentInTree = params.parent;
    this._countParam = params.count;
    this.forceNode = (params.forceNode === undefined? false : params.forceNode) ;
    DwtTreeItem.call(this, params);
}

ZaTreeItem.PARAMS = ["parent", "index", "text", "imageInfo", "deferred", "className", "posStyle",
					  "forceNotifySelection", "forceNotifyAction", "count", "forceNode"];

ZaTreeItem.prototype = new DwtTreeItem;
ZaTreeItem.prototype.constructor = ZaTreeItem;

ZaTreeItem.prototype.TEMPLATE = "admin.Widgets#ZaTreeItem";

ZaTreeItem.prototype.dispose =
function() {
	this._countCell = null;
	DwtTreeItem.prototype.dispose.call(this);
};

ZaTreeItem.prototype.toString =
function() {
	return "ZaTreeItem";
};

ZaTreeItem.prototype._initialize =
function(index, realizeDeferred, forceNode) {
    forceNode = forceNode || this.forceNode;
    DwtTreeItem.prototype._initialize.call(this, index, realizeDeferred, forceNode);

	this._countCell = document.getElementById(this._htmlElId + "_countCell");
	// initialize count
	if (this._countCell && (this._countInfoParam !== undefined)) {
	    this._countCell.innerHTML = this._countInfoParam;
        // only make css take effect when it has value;
        this._countCell.className = "AdminTreeItem-Count";
		this._countInfo = this._countInfoParam;
	}

    if (this._nodeCell) {
        var imgEl = AjxImg.getImageElement(this._nodeCell);
        if (imgEl) {
            Dwt.clearHandler(imgEl, DwtEvent.ONMOUSEDOWN);
            Dwt.clearHandler(imgEl, DwtEvent.ONMOUSEUP);
        }
    }

    if (this._arrowDisabled){
        var tableNode = document.getElementById(this._htmlElId + "_table");
        tableNode.style.tableLayout = "fixed";
        tableNode.style.width = "100%";

        this._textCell.style.width = "100%";
    }

    this._adjustText();
}

ZaTreeItem.prototype._adjustText = function() {
    this.setToolTipContent(this._text);
}

/**
 * Sets the text.
 *
 * @param	{string}	text		the text
 */
ZaTreeItem.prototype.setText =
function(text) {
	if (this._initialized) {
		if (!text) text = "";
		this._text = this._textCell.innerHTML = AjxStringUtil.htmlEncode(text);
        this._adjustText();
	} else {
		this._textParam = AjxStringUtil.htmlEncode(text);
	}
};

ZaTreeItem.prototype.getCount =
function() {
	return this._countInfo;
};

/**
 * Sets the image.
 *
 * @param	{string}	imageInfo		the image
 */
ZaTreeItem.prototype.setCount =
function(countInfo) {
	if (this._initialized) {
		if (this._countCell) {
			this._countCell.innerHTML = countInfo;
            // only make css take effect when it has value;
            this._countCell.className = "AdminTreeItem-Count";
		}
		this._countInfo = countInfo;
	} else {
		this._countInfoParam = countInfo;
	}
};

ZaTreeItem.prototype.setExpanded =
function(expanded, recurse, skipNotify) {
	// Go up the chain, ensuring that parents are expanded/initialized
	if (expanded) {
		// Realize any deferred children
		this._realizeDeferredChildren();
	}

	// If we have children, then allow for expanding/collapsing
	if (this.getNumChildren()) {
        if (this._expanded != expanded) {
			this._expand(expanded, null, true);
		}
	}
};

ZaTreeItem.prototype.isClickOnItem =
function(ev) {
    var x = ev.docX;
    var y = ev.docY;
    var selfBound =  Dwt.getBounds(this._itemDiv);
    var ret = (selfBound.x <= ev.docX) &&
              (ev.docX <= selfBound.x + selfBound.width) &&
              (location.y <= ev.docY) &&
              (ev.docY <= selfBound.y + selfBound.height);
    return ret;


}

ZaTreeEvent = function (oldPath, newPath, details) {
    if (arguments.length == 0)
       return;
    this.oldPath = oldPath;
    this.newPath = newPath;
    this.details = details;
}

ZaTreeEvent.prototype = new DwtEvent();
ZaTreeEvent.prototype.consturctor = ZaTreeEvent;
ZaTreeEvent.prototype.toString = function () {
    return "ZaTreeEvent";
}

ZaTreeEvent.ONDRAW= "ondraw";
ZaTreeEvent.ONDESTROY = "ondestroy";

// type 0: local
// type 1: alias
ZaTreeItemData = function(params) {
    if (arguments.length == 0) { return; }

    params = Dwt.getParams(arguments, ZaTreeItemData.PARAMS);
    this.parent = params.parent;
    this.parentObject = params.parentObject || "";
    this.relatedObject = params.relatedObject || [];
    this.recentObject= params.recentObject || [];
    this.type = params.type || 0;
    if (this.type == 1) {
        this.path = params.path;
    }
    this.id = params.id;
    this.className = params.className || "AdminTreeItem";
    this.text = params.text;
    this.image = params.image;
    this.siblings = new AjxVector();
    this.forceNode = params.forceNode ;
    this.isShowHistory = (params.isShowHistory === undefined?  true: params.isShowHistory);
    this.index = params.index;
    this.defaultSelectedItem = params.defaultSelectedItem;
    this.count = params.count;
    this.canShowOnRoot = (params.canShowOnRoot === undefined? true : params.canShowOnRoot) ;
    this.mappingId = params.mappingId;
    this.callback = params.callback;
    this.buildPath = (params.buildPath ? params.buildPath : undefined);
    this._data = {};
    this.childrenData = new AjxVector();
    this._eventMgr = new AjxEventMgr();
}

ZaTreeItemData.PARAMS = ["parent", "id", "text", "image", "index", "count", "mappingId", "callback", "relatedObject", "recentObject", "type", "path", "canShowOnRoot", "forceNode", "isShowHistory", "buildPath", "className", "defaultSelectedItem"];

ZaTreeItemData.prototype.addChild =
function(child, index) {
	this.childrenData.add(child, index);
    child.parentObject = this;
};

ZaTreeItemData.prototype.addSilbings =
function(sibling, index) {
	this.siblings.add(sibling, index);
};

ZaTreeItemData.prototype.setData =
function(key, value) {
    this._data[key] = value;
};

ZaTreeItemData.prototype.getData =
function(key) {
    return this._data[key];
};

ZaTreeItemData.prototype.removeChild =
function(child, index) {
	this.childrenData.remove(child);
};

ZaTreeItemData.prototype.isLeaf =
function() {
    var isRealLeaf = this.childrenData.size() == 0;
    var isFakeLeaf = !this.canShowOnRoot;
   return (isRealLeaf || isFakeLeaf);
}

ZaTreeItemData.prototype.getChildrenNum =
function() {
   return this.childrenData.size();
}

ZaTreeItemData.prototype.isAlias =
function(child, index) {
	if (this.type == 1)
        return true;
    else
        return false;
};

ZaTreeItemData.prototype.getRealPath =
function(child, index) {
	return this.path;
};

ZaTreeItemData.prototype.addRelatedObject =
function(relatedObject) {
    this.relatedObject = relatedObject;
}

ZaTreeItemData.prototype.addRecentObject =
function(recentObject) {
    this.recentObject = recentObject;
}

ZaTreeItemData.prototype.addListener =
function (eventType, listener) {
    this._eventMgr.addListener(eventType, listener);
}

ZaTreeItemData.prototype.notifyListeners =
function (eventType, event) {
    return this._eventMgr.notifyListeners(eventType, event);
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaTree")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Created by IntelliJ IDEA.
 * User: mingzhang
 * Date: 8/19/11
 * Time: 10:38 PM
 * To change this template use File | Settings | File Templates.
 */
ZaTree = function(params) {
	if (arguments.length == 0) { return; }
	params = Dwt.getParams(arguments, ZaTree.PARAMS);
    // Alwyas single style in Admin Console;
    params.style = DwtTree.SINGLE_STYLE;
	DwtTree.call(this, params);
    this._rootData = new ZaTreeItemData();
    this.currentShowItem = null;
};

ZaTree.PARAMS = ["parent", "style", "className", "posStyle"];
ZaTree.licenseCheckArray = [];

ZaTree.prototype = new DwtTree;
ZaTree.prototype.constructor = ZaTree;

ZaTree.prototype.toString =
function() {
	return "ZaTree";
};

ZaTree.prototype._expandUp =
function(item) {
	// Nothing doing here
    //
    return;
};

ZaTree.prototype.getContainer =
function() {
    return this._container;
};

ZaTree.prototype.setRootData =
function(rootData) {
    this._rootData  = rootData;
}

ZaTree.prototype.getRootData =
function(rootData) {
    return this._rootData;
}

ZaTree.prototype.addTreeItemData =
function(treeItemData) {
    var pathItems = this.getPathItems( treeItemData.parent);
    var result;
    var parentItem = this.getTreeItemData(this._rootData, pathItems, 0);
    if (parentItem) {
        parentItem.addChild(treeItemData);
        result =  true;
    } else {
        result = false;
    }

    return result;
}

ZaTree.prototype.getTreeItemData =
function(startNode, pathItems, startIndex) {
    if (pathItems.length == startIndex)
        return "";

    var currentPathItem = pathItems[startIndex];
    if (startNode.text != currentPathItem)
        return "";

    var nextStartIndex = startIndex + 1;
    if (pathItems.length == nextStartIndex)
        return startNode;

    if (startNode.childrenData.size() == 0) {
        return "";
    }

    var ret = "";
    var i;

    for (i = 0; i < startNode.childrenData.size(); i++) {
        ret = this.getTreeItemData(startNode.childrenData.get(i), pathItems, nextStartIndex);
        if (ret)
            break;
    }

    return ret;
}

ZaTree.prototype.getTreeItemDataByPath =
function(path) {
    var pathItems = this.getPathItems(path);
    var ret = this.getTreeItemData(this._rootData, pathItems, 0);
    return ret;
}

ZaTree.SEPERATOR = "%";
ZaTree.prototype.getPathItems =
function(path) {
    var temp = path.split(ZaTree.SEPERATOR);
    var ret = [];
    for (var i = 0; i < temp.length; i++) {
        if (temp[i]) {
            ret.push(temp[i]);
        }
    }
    return ret;
}
ZaTree.getPathItems = ZaTree.prototype.getPathItems;

ZaTree.prototype.setSelection =
function(treeItem, skipNotify, kbNavEvent, noFocus) {
	if (!treeItem)
        return;

	// Remove currently selected items from the selection list. if <treeItem> is in that list, then note it and return
	// after we are done processing the selected list
	var a = this._selectedItems.getArray();
	var sz = this._selectedItems.size();
	var da;
	var j = 0;
	var alreadySelected = false;
	var isLicensedItem = false;
	var isLicenseValid = false;
	for (var i = 0; i < ZaTree.licenseCheckArray.length; i++) {
		if (treeItem._text === ZaTree.licenseCheckArray[i].label) {
			isLicenseValid = ZaTree.licenseCheckArray[i].licenseCheckFuncion.call();
			isLicensedItem = true;
			break;
		}
	}
	for (var i = 0; i < sz; i++) {
		if (a[i] == treeItem) {
			alreadySelected = true;
		} else {
			a[i]._setSelected(false);
			this._selectedItems.remove(a[i]);
			if (da == null) {
				da = new Array();
			}
            if(!AjxUtil.isEmpty(a[i]))
			    da[j++] = a[i];
		}
	}

	if (da && !skipNotify) { //da is a array
		this._notifyListeners(DwtEvent.SELECTION, da, DwtTree.ITEM_DESELECTED, null, this._selEv, kbNavEvent);
	}

	if (alreadySelected) { return; }

    this._selectedItems.add(treeItem);

	//this._expandUp(treeItem);
	if (treeItem._setSelected(true, noFocus) && !skipNotify) {
        if (!isLicensedItem || isLicenseValid) {
            this._notifyListeners(DwtEvent.SELECTION, [treeItem], DwtTree.ITEM_SELECTED, null, this._selEv, kbNavEvent);
        } else {
            ZaApp.getInstance().getCurrentController().popupErrorDialog(ZaMsg.ERROR_FEATURE_NOT_LICENSED);
        }
	}
};

ZaTree.prototype.setEnterSelection =
function (treeItem, kbNavEvent) {
    if (!treeItem) {
        return;
    }
    var isLicensedItem = false;
    var isLicenseValid = false;
    for (var i = 0; i < ZaTree.licenseCheckArray.length; i++) {
        if (treeItem._text === ZaTree.licenseCheckArray[i].label) {
            isLicenseValid = ZaTree.licenseCheckArray[i].licenseCheckFuncion.call();
            isLicensedItem = true;
            break;
        }
    }
    if (!isLicensedItem || isLicenseValid) {
        this._notifyListeners(DwtEvent.SELECTION, [treeItem], DwtTree.ITEM_SELECTED, null, this._selByEnterEv, kbNavEvent);
    } else {
        ZaApp.getInstance().getCurrentController().popupErrorDialog(ZaMsg.ERROR_FEATURE_NOT_LICENSED);
    }
};

/*
 * Remove isAddHistory Now(By ming@zimbra.com).
 * Currenty, we won't add history in this function.
 * For it won't easy for us to decide when we should add history.
 * We only add history automatically when user click the tree item
 */
ZaTree.prototype.setSelectionByPath =
function (path, isAddHistory, skipNotify, kbNavEvent, noFocus, refresh, skipDestroyNotify) {

    var dataItem = this.getTreeItemDataByPath(path);
    if (dataItem.isAlias()) {
        path = dataItem.getRealPath();
        isAddHistory = false;
    }

    var result = this._getBuildNode(dataItem);
    if (result.isNeed) {
        if (this.currentRoot && !skipDestroyNotify) {
            var treeEvent = new ZaTreeEvent(result.oldPath, result.newPath);
            var notifyRet = this.currentRoot.getData("dataItem").notifyListeners(ZaTreeEvent.ONDESTROY, treeEvent);
            if (notifyRet === false) {
                return;
            }
        }
        this.buildTree(result.resultItem);
    } else {
	    var a = this._selectedItems.getArray();
	    var numSelectedItems = this._selectedItems.size();
        if (numSelectedItems > 0) {
			for (var i = 0; i < numSelectedItems; i++) {
				a[i]._setSelected(false);
			}
		}
    }

    this._selectedItems.removeAll();

    var treeItem = this.getTreeItemByPath(path);

    var selectedItem = this._getSelectedItem (treeItem);

    this._selectedItems.add(selectedItem);

    if (selectedItem._setSelected(true, noFocus) && !skipNotify) {
    	this._notifyListeners(DwtEvent.SELECTION, [selectedItem], DwtTree.ITEM_SELECTED, null, this._selEv, kbNavEvent, refresh);
	}

    this._updateHistory(treeItem, isAddHistory);

    var buildDataItem = result.isNeed ? result.resultItem: dataItem;
    if (buildDataItem.callback && buildDataItem.callback instanceof AjxCallback) {
        buildDataItem.callback.run();
    }

}


ZaTree.prototype._getBuildNode = function (currentDataItem) {
    var result = {
        isNeed : true,
        resultItem : currentDataItem
    };

    if (!this.currentRoot)
        return result;

    var lastDataItem = this.currentRoot.getData("dataItem");
    var lastPath = this.getABPath(lastDataItem);

    if (currentDataItem.buildPath) {
        result.resultItem = this.getTreeItemDataByPath(currentDataItem.buildPath);
    } else {
        if (currentDataItem.isLeaf() && currentDataItem.parentObject) {
            result.resultItem = currentDataItem.parentObject;
        } else {
            result.resultItem = currentDataItem;
        }
    }

    var currentPath = this.getABPath(result.resultItem);
    result.newPath = currentPath;
    if (lastPath == currentPath) {
        result.isNeed = false;
    } else {
        result.oldPath = lastPath;
    }
    return result;
}

ZaTree.prototype._getSelectedItem = function (currentRootNode) {
    var defaultSelectedItem = currentRootNode.getData("dataItem").defaultSelectedItem;
    if (!defaultSelectedItem) {
        return currentRootNode;
    }

    var childRen = currentRootNode.getItems();
    if (childRen.length > 0) {
        return childRen[defaultSelectedItem - 1];
    }

    return currentRootNode;

}

ZaTree.prototype.getSelectedItem = function (currentRootNode) {
      return this._getSelectedItem(currentRootNode);
}

//TODO make it recursive
ZaTree.prototype.getTreeItemByPath =
function(path) {
    if (!path)
        return null;

    if (!this.currentRoot)
        return null;

    var firstLevelChildren = this.getChildren();
    for (var j = 0; j < firstLevelChildren.length; j++) {
        var currentTreeItem = firstLevelChildren[j];
        var rootDataPath = currentTreeItem.getData("dataItem");
        var rootPath = this.getABPath(rootDataPath);
        if (rootPath == path)
            return currentTreeItem;

        var children = currentTreeItem.getChildren();
        for (var i = 0; i < children.length; i++) {
            var childTreeItem = children[i];
            var text = childTreeItem.getText();
            var childPath =  rootPath + ZaTree.SEPERATOR + text;
            if (path == childPath)
                return  childTreeItem;
        }
    }
    return null;
}

ZaTree.prototype.buildTree =
function (showRootNode) {

    this.clearItems();
    this.curentRoot = null;
    this.currentRelated = null;
    this.currentRoot = this._buildNodeItem(showRootNode, true);
    this.currentRoot.setExpanded(true);
    if (showRootNode.relatedObject.length != 0) {
        this.currentRelated = this._buildNodeItem(this._getDefaultRelated(showRootNode));
        this.currentRelated.setExpanded(true);
    }

    if (showRootNode.recentObject.length != 0) {
        this.currentRecented = this._buildNodeItem(this._getDefaultRecentObjects(showRootNode), false, true);
        this.currentRecented.setExpanded(true);
    }

    for (var i = 0; i < showRootNode.siblings.size(); i++) {
        var currentAddNode =  showRootNode.siblings.get(i);
        var currentShowNode = this._buildNodeItem(currentAddNode);
        currentShowNode.setExpanded(true);
    }
    return this.currentRoot;
}

ZaTree.prototype.renameTreeItem =
function (path, newName) {
    var dataTreeItem  =  this.getTreeItemDataByPath(path);
    if (!dataTreeItem)
        return;

    // If this is shown now, then update the Tree Item.
    var treeItem = this.getTreeItemByPath(path);
    if (treeItem) {
        treeItem.setText (newName);
    }

    dataTreeItem.text = newName;
    var parentPath = this.getPathItems (dataTreeItem.parent);
    parentPath.push(newName);
    var newPath =  this.getPathByArray (parentPath);
    // TODO we should make it recursive in futher
    // TODO Currenty it works well for we has only need to rename object name and saved search;
    for (var i = 0; i < dataTreeItem.childrenData.size(); i++) {
        var currentNode = dataTreeItem.childrenData.get(i);
        currentNode.parent = newPath;
    }

    return newPath;
}

ZaTree.prototype.removeTreeItem = function (path) {
    var treeItemData = this.getTreeItemDataByPath(path);
    if (!treeItemData)
        return;

    var treeItem = this.getTreeItemByPath (path);
    if (treeItem)
        treeItem.parent.removeChildren(treeItem);

    treeItemData.parentObject.removeChildren (treeItemData);
}

ZaTree.prototype.removeAllChild = function (path) {
    var treeItemData = this.getTreeItemDataByPath(path);
    if (!treeItemData)
        return;

    var treeItem = this.getTreeItemByPath (path);
    if (treeItem) {
        var removeTi = [];
        removeTi = treeItem.getChildren();
        for (var i = 0; i < removeTi.length; i++) {
            treeItem.removeChild(removeTi[i]);
            removeTi[i] = null;
        }
        removeTi = [];
    }

    treeItemData.childrenData.removeAll();
}

ZaTree.prototype._getDefaultRelated =
function (treeDataItem) {
    var related = new ZaTreeItemData({
            parent: treeDataItem.parent,
            id: treeDataItem.id + "_related",
            text:ZaMsg.OVP_related
    });
    treeDataItem.addChild(related);
    for (var i = 0; i < treeDataItem.relatedObject.length; i++) {
        var currentObject =treeDataItem.relatedObject[i];
        currentObject.parent = treeDataItem.parent + ZaTree.SEPERATOR + ZaMsg.OVP_related;
        related.addChild(currentObject);
    }
    return related;
}

ZaTree.prototype._getDefaultRecentObjects =
function (treeDataItem) {
    var recent = new ZaTreeItemData({
            parent: treeDataItem.parent,
            id: treeDataItem.id + "_recent",
            text:ZaMsg.OVP_recent
    });
    treeDataItem.addChild(recent);
    for (var i = 0; i < treeDataItem.recentObject.length; i++) {
        var currentObject =treeDataItem.recentObject[i];
        currentObject.parent = treeDataItem.parent + ZaTree.SEPERATOR + ZaMsg.OVP_recent;
        recent.addChild(currentObject);
    }
    return recent;
}

ZaTree.prototype._buildNodeItem =
function(showRootNode, isRoot, isHightlightedWhenMouseUp ) {
    var ti, nextTi, key, currentRoot;
    var clsName;
    if (showRootNode.text == ZaMsg.OVP_home) {
        clsName = "homeRootOverviewHeader";
    } else if (isRoot) {
        clsName = "rootOverviewHeader";
    } else {
        clsName = "overviewHeader";
    }

    currentRoot =  new ZaTreeItem({parent:this,className:clsName,id:showRootNode.id, forceNotifySelection:true});
	currentRoot.enableSelection(false);
	currentRoot.setText(showRootNode.text);
    currentRoot.setImage(showRootNode.image);
	currentRoot.setData(ZaOverviewPanelController._TID, showRootNode.mappingId);
    currentRoot.setData("dataItem", showRootNode);
    for (key in showRootNode._data) {
        currentRoot.setData(key, showRootNode._data[key]);
    }

    var i, j, forceNode;
    for (i = 0; i < showRootNode.childrenData.size(); i++) {
        var currentAddNode =  showRootNode.childrenData.get(i);
        // TODO improved latter
        if (isRoot) {
            if (currentAddNode.text == ZaMsg.OVP_related)
                continue;
            if (currentAddNode.text == ZaMsg.OVP_recent)
                continue;
        }
        if( currentAddNode.forceNode !== undefined)
            forceNode = currentAddNode.forceNode;
        else
            forceNode = currentAddNode.childrenData.size() > 0 ? true: false;

        ti = new ZaTreeItem({parent: currentRoot,className: currentAddNode.className,id:currentAddNode.id, forceNode: forceNode});
        ti.setCount(currentAddNode.count);
        ti.setText(currentAddNode.text);
        ti.setImage(currentAddNode.image);
        ti.setData(ZaOverviewPanelController._TID, currentAddNode.mappingId);
        ti.setData("dataItem", currentAddNode);

        if ( isHightlightedWhenMouseUp ) {
            var mouseOutEv = (AjxEnv.isIE) ? DwtEvent.ONMOUSELEAVE : DwtEvent.ONMOUSEOUT;

            ti.addListener(DwtEvent.ONMOUSEDOWN, new AjxListener(ti, ZaTree._highlightItemOn));
            ti.addListener(DwtEvent.ONMOUSEUP, new AjxListener(ti, ZaTree._highlightItemOff));
            ti.addListener(mouseOutEv, new AjxListener(ti, ZaTree._highlightItemOff));
        }

        for (key in currentAddNode._data) {
            ti.setData(key, currentAddNode._data[key]);
        }
    }
    return currentRoot;
}

ZaTree._highlightItemOff =
function(ev) {
	var ti = this;
	ti._setSelected(false);
}

ZaTree._highlightItemOn =
function(ev) {
	var ti = this;
	ti._setSelected(true);
}

ZaTree.prototype._itemClicked =
function(item, ev) {
	var i;
	var a = this._selectedItems.getArray();
	var numSelectedItems = this._selectedItems.size();
    var currentDataItem =  item.getData("dataItem");
    var isShowInHistory = currentDataItem.isShowHistory;
    var isAlias = currentDataItem.isAlias();
    var isLicensedItem = false;
    var isLicenseValid = false;
    for (var i = 0; i < ZaTree.licenseCheckArray.length; i++) {
        if (item._text === ZaTree.licenseCheckArray[i].label) {
            isLicenseValid = ZaTree.licenseCheckArray[i].licenseCheckFuncion.call();
            isLicensedItem = true;
            break;
        }
    }
    if (isAlias) {
        var aliasImage = currentDataItem.image;
        currentDataItem = this.getTreeItemDataByPath(currentDataItem.getRealPath());
        if(!currentDataItem.image)
            currentDataItem.image = aliasImage;
        this._updateHistoryObj(currentDataItem);
    }
	if (currentDataItem.isLeaf() && !isAlias) {
		if (numSelectedItems > 0) {
			for (i = 0; i < numSelectedItems; i++) {
				a[i]._setSelected(false);
			}
			// Notify listeners of deselection
			this._notifyListeners(DwtEvent.SELECTION, this._selectedItems.getArray(), DwtTree.ITEM_DESELECTED, ev, this._selEv);
			this._selectedItems.removeAll();
		}

        this._selectedItems.add(item);

        if (item._setSelected(true)) {
            if (!isLicensedItem || isLicenseValid) {
                this._updateHistory(item, true, isShowInHistory);
                this._notifyListeners(DwtEvent.SELECTION, [item], DwtTree.ITEM_SELECTED, ev, this._selEv);
            } else {
                ZaApp.getInstance().getCurrentController().popupErrorDialog(ZaMsg.ERROR_FEATURE_NOT_LICENSED);
            }
        }
    } else {
        var buildDataItem;
        if (!currentDataItem.isLeaf() && (!isLicensedItem || isLicenseValid))
            buildDataItem = currentDataItem;
        else
            buildDataItem = currentDataItem.parentObject;
        this.buildTree(buildDataItem);
        this._selectedItems.removeAll();

        var selectedItem;
        if (currentDataItem.isLeaf())
            selectedItem = this.getTreeItemByPath(this.getABPath(currentDataItem));
        else {
            selectedItem = this._getSelectedItem(this.getCurrentRootItem());
        }

        this._selectedItems.add(selectedItem);
        if (selectedItem._setSelected(true)) {
            if (!isLicensedItem || isLicenseValid) {
                if (!isAlias) {
                    if (currentDataItem.isLeaf())
                        this._updateHistory(selectedItem, true, isShowInHistory);
                    else
                        this._updateHistory(this.getCurrentRootItem(), true, isShowInHistory);
                } else
                    this._updateHistory(item, true, isShowInHistory);
                this._notifyListeners(DwtEvent.SELECTION, [selectedItem], DwtTree.ITEM_SELECTED, ev, this._selEv);
            } else {
                ZaApp.getInstance().getCurrentController().popupErrorDialog(ZaMsg.ERROR_FEATURE_NOT_LICENSED);
            }
		}

        if (buildDataItem.callback && buildDataItem.callback instanceof AjxCallback) {
            buildDataItem.callback.run();
        }
    }
};

ZaTree.prototype._notifyListeners =
function(listener, items, detail, srcEv, destEv, kbNavEvent, refresh) {
	if (this.isListenerRegistered(listener)) {
		if (srcEv) {
			DwtUiEvent.copy(destEv, srcEv);
		}
		destEv.items = items;
		if (items.length == 1) {
			destEv.item = items[0];
		}
		destEv.detail = detail;
		destEv.kbNavEvent = kbNavEvent;
        destEv.refresh = refresh;
		this.notifyListeners(listener, destEv);
		if (listener == DwtEvent.SELECTION) {
			this.shell.notifyGlobalSelection(destEv);
		}
	}
};

ZaTree.prototype._updateHistory =
function (treeItem, isAddHistory, isShowInHistory) {
    var text = treeItem.getText();
    var dataItem = treeItem.getData("dataItem");
    var path = this.getABPath(dataItem);
    var historyObject = new ZaHistory(path, text, undefined, isShowInHistory);
    ZaZimbraAdmin.getInstance().updateHistory(historyObject, isAddHistory);
}

ZaTree.prototype._updateHistoryObj =
function (dataItem) {
    var text = dataItem.text;
    var type = ZaItem.ACCOUNT;
    var path = this.getABPath(dataItem);

    switch (dataItem.image) {
		case "Account":
			type = ZaItem.ACCOUNT; break ;
		case "COS" :
			type = ZaItem.COS ; break ;
        case "Domain":
            type = ZaItem.DOMAIN; break;
		case "Resource":
			type = ZaItem.RESOURCE; break ;
        case "DistributionList":
            type = ZaItem.DL; break;
        case "AccountAlias":
            type = ZaItem.ALIAS; break;
        case "Server":
            type = ZaItem.SERVER; break;
        case "RightObject":
            type = ZaItem.RIGHT; break;
		default :
			type = null;
	}


    var historyObject = new ZaHistory(path, text, type);
    var historyMgr = ZaZimbraAdmin.getInstance().getHistoryMgr();
    historyMgr.addHistoryObj(historyObject);
    var objList = historyMgr.getAllHistoryObj().getArray();
    var ti = null;
    var image = null;
    var Tis = [];
    for(var i = objList.length - 1; i > -1; i --) {
        if(objList[i].type == ZaItem.ACCOUNT)
            image = "Account";
        else if(objList[i].type == ZaItem.COS)
            image = "COS";
        else if(objList[i].type == ZaItem.DOMAIN)
            image = "Domain";
        else if(objList[i].type == ZaItem.RESOURCE)
            image = "Resource";
        else if(objList[i].type == ZaItem.DL)
            image = "DistributionList";
        else if(objList[i].type == ZaItem.ALIAS)
            image = "AccountAlias";
        else if(objList[i].type == ZaItem.SERVER)
            image = "Server";
        else if(objList[i].type == ZaItem.RIGHT)
            image = "RightObject";

        ti = new ZaTreeItemData({
                text: objList[i].displayName,
                type:1,
                image:image,
                forceNode: (i+1 != objList.length),
                path: objList[i].path
                }
            );
        Tis.push(ti);
    }
    dataItem.recentObject = Tis;
}

ZaTree.prototype.getABPath =
function (dataItem) {
    var abPath = [];
    var currentObject = dataItem;
    while (currentObject) {
        abPath.unshift(currentObject.text);
        currentObject = currentObject.parentObject;
    }
    var ret = this.getPathByArray(abPath);
    return ret;
}

ZaTree.prototype.getPathByArray =
function (arr) {
    if (arr.length == 0)
        return "";
    return arr.join(ZaTree.SEPERATOR);
}

ZaTree.prototype.getCurrentRootItem = function() {
    return this.currentRoot;
}
ZaTree.prototype.getCurrentSelectedItems = function() {
    return this._selectedItems;
}

ZaTree.prototype.clearItems = function() {
    var items = this.getItems();
    var len= items.length;
    for (var i = 0; i < len; i++) {
        this.removeChild(items[0]);
    }
    this._getContainerElement().innerHTML = "";
};

ZaTree.getPathByArray = ZaTree.prototype.getPathByArray;



}
if (AjxPackage.define("zimbraAdmin.common.ZaCurrentAppBar")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Created by IntelliJ IDEA.
 * User: mingzhang
 * Date: 8/26/11
 * Time: 1:43 AM
 * To change this template use File | Settings | File Templates.
 */
ZaCurrentAppBar = function(parent, className, buttons) {

	DwtButton.call(this, parent, "", className, Dwt.ABSOLUTE_STYLE);
    this._removeUnwantedEvent();
    this._currentPathItems = new Array();
    this.menu = new ZaPopupMenu(this, "ActionMenu", null, [], ZaId.CURRENT_APP_BAR, ZaId.MENU_POP, []);
    this.menu.setWidth(Dwt.__checkPxVal(150,true));
    this.actionButtons = {};
    this.itemElArray = [];
    this.setMenu(this.menu);
    this.setSettingImg();
    this.clearTypeImg();
}

ZaCurrentAppBar.prototype = new DwtButton;
ZaCurrentAppBar.prototype.constructor = ZaCurrentAppBar ;
ZaCurrentAppBar.defaultImg = "Configure";

ZaCurrentAppBar.prototype.toString =
function() {
	return "ZaCurrentAppBar";
}


ZaCurrentAppBar.prototype.TEMPLATE = "admin.Widgets#ZaCurrentAppBar";
ZaCurrentAppBar.prototype.ACTION_ITEM_TEMPLATE = "dwt.Widgets#ZToolbarItem";

ZaCurrentAppBar.prototype._createHtmlFromTemplate = function(templateId, data) {
    DwtButton.prototype._createHtmlFromTemplate.call(this, templateId, data);
    this._typeImgEl = document.getElementById(data.id+"_typeimg");
    this._settingImgEl = document.getElementById(data.id+"_settingimg");
    this._actionEl = document.getElementById(data.id+"_action");
    this._actionItemsEl = document.getElementById(data.id+"_actionitems");
};

ZaCurrentAppBar.prototype.setSettingImg = function (imgName) {
    if (!this._settingImgEl)
        return;

    var localImg = imgName || ZaCurrentAppBar.defaultImg;
    this._settingImgEl.innerHTML = AjxImg.getImageHtml(localImg);
}

ZaCurrentAppBar.prototype.clearSettingImg = function () {
    if (!this._settingImgEl)
        return;

    this._settingImgEl.innerHTML = "";
}

ZaCurrentAppBar.prototype.setTypeImg = function (imgName) {
    if (!this._typeImgEl)
        return;
    if (!imgName)
        return;
    this._typeImgEl.innerHTML = AjxImg.getImageHtml(imgName);
    if (!Dwt.getVisible (this._typeImgEl))
        Dwt.setVisible (this._typeImgEl, true);
}

ZaCurrentAppBar.prototype.clearTypeImg = function () {
    if (!this._typeImgEl)
        return;

    this._typeImgEl.innerHTML = "";
    if (Dwt.getVisible (this._typeImgEl))
        Dwt.setVisible (this._typeImgEl, false);
}

ZaCurrentAppBar.prototype.setText =
function(path) {
    // Html encode path to make sure scripts are not executed when added in dom
    path = AjxStringUtil.htmlEncode(path);

    var text = "";
    var temp = path.split(ZaTree.SEPERATOR);
    this._currentPathItems = temp;
    for (var i = 0; i < temp.length; i++) {
        text +=this._getSinglePathItem(temp[i]);
        if (i != temp.length - 1)
            text += "-";
    }
    DwtButton.prototype.setText.call(this, text);
}

ZaCurrentAppBar.prototype.setActionButton =
function (opList, appBarOrder) {
    if (AjxUtil.isEmpty(opList)) {
        this._clearActionButton();
    } else {
        this._addActionButton(opList, appBarOrder);
    }
}

ZaCurrentAppBar.prototype._addActionButton =
function (opList, appBarOrder) {

    this._clearActionButton();
    var b;

    if (AjxUtil.isEmpty(appBarOrder)) {
        for(var ix in opList) {
            b = this._createActionButton(opList[ix].id, opList[ix].imageId, opList[ix].caption, opList[ix].disImageId, opList[ix].tt, true, opList[ix].className, opList[ix].type, opList[ix].menuOpList);

            b.addSelectionListener(opList[ix].listener);
        }
    } else {
        var ix;
        for(var i in appBarOrder) {
            ix = appBarOrder[i];
            if(opList[ix]) {
            	b = this._createActionButton(opList[ix].id, opList[ix].imageId, opList[ix].caption, opList[ix].disImageId, opList[ix].tt, true, opList[ix].className, opList[ix].type, opList[ix].menuOpList);
            	b.addSelectionListener(opList[ix].listener);
            }
            
        }
    }

    var width = Dwt.getBounds(this._actionItemsEl).width;
    this.setActionItemWidth(width);
}

ZaCurrentAppBar.prototype._createActionButton =
function(buttonId, imageId, text, disImageId, toolTip, enabled, className, type, menuOpList) {
	if (!className)
		className = "DwtToolbarButton"
	var b = this.actionButtons[buttonId] = new ZaToolBarButton({
			parent:this,
			className:className,
			id:ZaId.getButtonId("ZaCurrentAppBar",ZaOperation.getStringName(buttonId))
	});
	if (imageId)
		b.setImage(imageId);
	if (text)
		b.setText(text);
	if (toolTip)
		b.setToolTipContent(toolTip);
	b.setEnabled((enabled) ? true : false);
	b.setData("_buttonId", buttonId);

    var elContainer = this._createActionItemContainer();
    elContainer.appendChild(b.getHtmlElement());
    this._addActionItem(elContainer);

	return b;
}

ZaCurrentAppBar.prototype._createActionItemContainer =
function () {
    var itemCount = this.itemElArray.length + 1;
    var itemId = [this._htmlElId, "item", itemCount].join("_");

    var data = { id: this._htmlElId, itemId: itemId};
    var html = AjxTemplate.expand(this.ACTION_ITEM_TEMPLATE, data);

    var cont = AjxStringUtil.calcDIV();
    cont.innerHTML = html;
    return cont.firstChild.rows[0].cells[0];
}

ZaCurrentAppBar.prototype._addActionItem =
function(element) {
    // Always add the current action item to the last one
	var spliceIndex = this.itemElArray.length;
	this.itemElArray.splice(spliceIndex, 0, element);
    this._actionItemsEl.appendChild(element);
}

ZaCurrentAppBar.prototype._clearActionButton =
function() {
    for(var ix = 0; ix < this.itemElArray.length; ix++) {
        this.itemElArray[ix] = undefined;
    }
    this.itemElArray = [];
    //this._actionItemsEl.innerHTML = ""; //throw unkown runtime exception in ie
    while(this._actionItemsEl.firstChild){
        var tempNode = this._actionItemsEl.removeChild(this._actionItemsEl.firstChild);
            tempNode = null;
    }
    for (var actionIx in this.actionButtons) {
        this.actionButtons[actionIx] = undefined;
    }
    this.actionButtons = {};
    this.setActionItemWidth(0);
}

ZaCurrentAppBar.prototype.setActionItemWidth =
function(w) {
    this._actionEl.style.width = Dwt.__checkPxVal(w);
}

ZaCurrentAppBar.prototype.enableButton =
function (buttonId, enabled) {
    if (!this.actionButtons[buttonId])
        return;

    this.actionButtons[buttonId].setEnabled(enabled);
}

ZaCurrentAppBar.spanItemClass = "";//"overviewHeader";
ZaCurrentAppBar.prototype._getSinglePathItem =
function(path) {
    var text = new Array(10);
    var i = 0;
    text[i++] = "<span class=";
    text[i++] = ZaCurrentAppBar.spanItemClass;
    text[i++] = ">";
    text[i++] = path;
    text[i++] = "</span>";
    return text.join("");
}

ZaCurrentAppBar.prototype.popup =
function(menu) {
	menu = menu || this.getMenu();

    if (!menu) { return; }

    var parent = menu.parent;
	var parentBounds = parent.getBounds();
	var windowSize = menu.shell.getSize();
	var menuSize = menu.getSize();
	var parentElement = parent.getHtmlElement();
	// since buttons are often absolutely positioned, and menus aren't, we need x,y relative to window
	var parentLocation = Dwt.toWindow(parentElement, 0, 0);
	var leftBorder = (parentElement.style.borderLeftWidth == "") ? 0 : parseInt(parentElement.style.borderLeftWidth);

	var x;
    var dropDownEl = parent._dropDownEl;
    if (!dropDownEl) {
	    x = parentLocation.x + leftBorder;
    } else {
        var dropDownLocation = Dwt.toWindow(dropDownEl, 0, 0);
        x = dropDownLocation.x + 20;
    }
	x = ((x - menuSize.x) >= 0) ? x - menuSize.x : x;
    if (x > 13)
        x = x -13; //here is 13px is for extra padding.
	var y;

    var horizontalBorder = (parentElement.style.borderTopWidth == "") ? 0 : parseInt(parentElement.style.borderTopWidth);
    horizontalBorder += (parentElement.style.borderBottomWidth == "") ? 0 : parseInt(parentElement.style.borderBottomWidth);
    y = parentLocation.y + parentBounds.height + horizontalBorder;

	menu.popup(0, x, y);
};

ZaCurrentAppBar.prototype.setDisplayState =
function(state, force) {
    if (state == DwtControl.HOVER ||
        state == DwtControl.ACTIVE||
        state == DwtControl.FOCUSED)
        state = DwtControl.NORMAL;

    if (this._selected && state != DwtControl.SELECTED && !force) {
        state = [ DwtControl.SELECTED, state ].join(" ");
    }
    DwtLabel.prototype.setDisplayState.call(this, state);
};

ZaCurrentAppBar.prototype._isDropDownEvent =
function(ev) {
	if (this._dropDownEventsEnabled && this._dropDownEl) {
		var mouseX = ev.docX;
        if (this._settingImgEl) {
            var imgX =  Dwt.toWindow(this._settingImgEl, 0, 0, window).x;
            if (mouseX >= imgX)
                return true;
        }
	}
	return false;
};

ZaCurrentAppBar.prototype._handleClick =
function(ev) {
    //
    var mouseEv = DwtShell.mouseEvent;
	mouseEv.setFromDhtmlEvent(ev);

    mouseEv._stopPropagation = true;
	mouseEv._returnValue = true;
	mouseEv.setToDhtmlEvent(ev);
	return false;
}

ZaCurrentAppBar.prototype._removeUnwantedEvent =
function () {
    var events = [].concat(AjxEnv.isIE ? [DwtEvent.ONMOUSEENTER, DwtEvent.ONMOUSELEAVE] :
										 [DwtEvent.ONMOUSEOVER, DwtEvent.ONMOUSEOUT]);
	for (var i = 0; i < events.length; i++) {
		this.removeListener(events[i], this._listeners[events[i]]);
	}
}

ZaCurrentAppBar.prototype.updateMenu =
function(popupOperations, popupOrder) {
    var oldMenu = this.getMenu();
    var isPopup = false;
    if(oldMenu) {
        isPopup = oldMenu.isPoppedUp();
        this.setMenu();
        this.menu = null;
        try {
            oldMenu.dispose();
            delete oldMenu;
        }catch(ex){
            //nothing doing here to avoid delete exception;
        }
    }

    if (popupOperations) {
        this.menu = new ZaPopupMenu(this, "ActionMenu", null, popupOperations, ZaId.CURRENT_APP_BAR, ZaId.MENU_POP, popupOrder);
        this.menu.setWidth(Dwt.__checkPxVal(150,true));
        this.setSettingImg();
        this.setMenu(this.menu);
    } else {
        this.clearSettingImg();
    }

    if (isPopup) {
        this.popup();
    }
}

ZaCurrentAppBar.prototype.getMenu = function () {
    return this.menu;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaHistoryMgr")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Created by IntelliJ IDEA.
 * User: mingzhang
 * Date: 9/19/11
 * Time: 11:27 PM
 * To change this template use File | Settings | File Templates.
 */
ZaHistoryMgr = function() {
    this._history = new AjxVector();
    this._historyObj = new AjxVector();
    this._evtMgr = new AjxEventMgr();
    this._currentLocation = 0;
}

ZaHistoryMgr.MAX_HISTROY_OBJ = 5;

ZaHistoryMgr.prototype.toString =
function() {
    return "ZaHistoryMgr";
}

ZaHistoryMgr.prototype.constructor = ZaHistoryMgr;

ZaHistoryMgr.prototype.addHistory =
function (historyObject) {
    var last = this._history.getLast();
    if (last && last.equal(historyObject))
        return;
    if (window.console && window.console.log)
        window.console.log("Add History " + historyObject.path);
    this._history.add(historyObject);
    // Here we always relocates the currentLocation to the current page.
    this._currentLocation = this._history.size() -1;
    this._evtMgr.notifyListeners(ZaEvent.L_MODIFY, this._history);
}

ZaHistoryMgr.prototype.findHistoryByName=
function(displayName){
    var obj = new AjxVector();
    var num = 0;
    for(var i = this._history.size()-1; i >= 0 && num < 20; i--) {
        if(!this._history.get(i).isShowInHistory)
                continue;

        if(this._history.get(i).displayName == displayName )
            obj.add(this._history.get(i));
        num++;
    }
    return obj;
}

ZaHistoryMgr.prototype.deleteHistoryObjByName =
function(displayName){
    for(var i = 0; i < this._historyObj.size(); i++) {
        if(this._historyObj.get(i).displayName == displayName )
            return this._historyObj.removeAt(i);
    }
}

ZaHistoryMgr.prototype.refreshHistory =
function () {
    this._evtMgr.notifyListeners(ZaEvent.L_MODIFY, this._history);
}

ZaHistoryMgr.prototype.addHistoryObj =
function (historyObject) {
    if (AjxUtil.isEmpty(historyObject.type))
        return;

    if (!ZaHistoryMgr.isAllowedRecentedObject(historyObject.path))
        return;

    var lastObj = this._historyObj.get(this._historyObj.size() - 1);
    if(lastObj && lastObj.path == historyObject.path)
        return;
    var loc =  this.findHistoryObj(historyObject);
    if(loc > -1) this._historyObj.removeAt(loc);

    if(this._historyObj.size()+1 > ZaHistoryMgr.MAX_HISTROY_OBJ) {
        this._historyObj.removeAt(0);
    }
    this._historyObj.add(historyObject);
}

ZaHistoryMgr.prototype.findHistoryObj =
function(historyObject) {
    if(!historyObject) return -1;
    for(var i = 0; i < this._historyObj._array.length; i++) {
        if(this._historyObj._array[i].displayName == historyObject.displayName)
            return i;
    }
    return -1;
}

ZaHistoryMgr.isAllowedRecentedObject =
function (srcPath) {
    var ret = false;
    var srcPathArr = ZaTree.getPathItems(srcPath);
    var destPathArr;
    var allowedObject= ZaHistoryMgr.getAllowedRecenctObject();
    for (var i = 0; i < allowedObject.length; i++ ) {
        destPathArr =  ZaTree.getPathItems( allowedObject[i]);
        for (var j = 0; j < destPathArr.length; j++) {
            if (srcPathArr[j] != destPathArr[j]) {
                break;
            }
        }

        if (j == destPathArr.length) {
            ret = true;
            break;
        }
    }
    return ret;
}

ZaHistoryMgr.getAllowedRecenctObject = function() {
    if (!ZaHistoryMgr._allowedRecentObject) {

        ZaHistoryMgr._allowedRecentObject = [
            [ZaMsg.OVP_home, ZaMsg.OVP_manageAccounts].join(ZaTree.SEPERATOR),
            [ZaMsg.OVP_home, ZaMsg.OVP_configure].join(ZaTree.SEPERATOR)
        ];
    }
    return ZaHistoryMgr._allowedRecentObject;
}
ZaHistoryMgr.prototype.removeHistory =
function() {
    var currentSize = this._history.size();
    if (currentSize == 1)
        return false;
    for (var i = 1; i < currentSize; i++)
		this._history._array[i] = null;
    this._history._array.length = 1;
    this._currentLocation = 0;
    this._evtMgr.notifyListeners(ZaEvent.L_MODIFY, this._history);
    return true;
}

ZaHistoryMgr.prototype.getAllHistory =
function() {
    return this._history;
}

ZaHistoryMgr.prototype.getAllHistoryObj =
function() {
    return this._historyObj;
}

ZaHistoryMgr.prototype.getPrevious =
function () {
    if (!this.isPrevious())
        return "";
    return this._history.get(--this._currentLocation);
}

ZaHistoryMgr.prototype.getNext =
function () {
    if (!this.isNext())
        return "";
    return this._history.get(++this._currentLocation);
}

ZaHistoryMgr.prototype.isPrevious =
function () {
    if (this._currentLocation == 0 )
        return false;
    else
        return true;
}

ZaHistoryMgr.prototype.isNext =
function () {
    if (this._currentLocation == this._history.size() - 1 )
        return false;
    else
        return true;
}

ZaHistoryMgr.prototype.getLatestHistory =
function () {
    return  this._history.getLast();
}

ZaHistoryMgr.prototype.getCurrentyHistory =
function () {
    return  this._history.get(this._currentLocation);
}

ZaHistoryMgr.prototype.addChangeListener =
function(listener) {
	return this._evtMgr.addListener(ZaEvent.L_MODIFY, listener);
}

ZaHistoryMgr.prototype.removeChangeListener =
function(listener) {
	return this._evtMgr.removeListener(ZaEvent.L_MODIFY, listener);
}

/*
 * Path: current path of item
 * dispalyName: name showed in Tree Header
 * type: This is attribute used for related object and recent object account/dl...etc
 * isShowInHistory: is show this history in Tree Header
 */
ZaHistory = function (path, displayName, type, isShowInHistory, viewMethod) {
    this.path = path;
    this.displayName = displayName;
    this.type = type;
    this.isShowInHistory = (isShowInHistory === undefined) ? true: isShowInHistory;
    this.viewMethod = (viewMethod instanceof AjxCallback) ? viewMethod : new AjxCallback(this, this.defaultGoToView);
    this.enabled = true;
}

ZaHistory.prototype.goToView =
function(refresh) {
    if (this.viewMethod) {
        this.viewMethod.run(refresh);
    }
}

ZaHistory.prototype.defaultGoToView = function(refresh) {
    var tree = ZaZimbraAdmin.getInstance().getOverviewPanelController().getOverviewPanel().getFolderTree();
    tree.setSelectionByPath(this.path, false, undefined, undefined, undefined, refresh);
}

ZaHistory.prototype.equal = function (newObj) {
    return this.path == newObj.path;
}

ZaHistory.prototype.setEnabled =
function(enabled){
    this.enabled = enabled;
}

ZaHistory.prototype.getEnabled =
function(){
    return this.enabled;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaUploader")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */
/**
 * @overview
 * Utility functions to upload files using HTML5
 */
ZaUploader = function() {
};
ZaUploader.prototype.constructor = ZaUploader;
/**
 * Returns a string representation of the object.
 *
 * @return        {String}        a string representation of the object
 */
ZaUploader.prototype.toString =
function() {
    return "ZaUploader";
};
/**
 *
 * @param fileElementId
 * @param url
 * @param callback
 *
 */
ZaUploader.prototype._upload =
function(fileElementIds, url, callback) {
    var cnt = fileElementIds.length;
    for(var i = 0; i < cnt; i++) {
        var element = document.getElementById(fileElementIds[i]);
        if(element && element.files && element.files.length > 0) {
            var file = element.files[0];
            if(file) {
                var fileName = file.name || file.fileName;
                var req = new XMLHttpRequest(); // we do not call this function in IE
                req.open("POST", url, true);
                req.setRequestHeader("Cache-Control", "no-cache");
                req.setRequestHeader("X-Requested-With", "XMLHttpRequest");
                req.setRequestHeader("Content-Type",  (file.type || "application/octet-stream") + ";");
                req.setRequestHeader("Content-Disposition", 'attachment; filename="'+ AjxUtil.convertToEntities(fileName) + '"');
                if (window.csrfToken) {
                    req.setRequestHeader("X-Zimbra-Csrf-Token", window.csrfToken);
                }
                var uploadResults = [];
                req.onreadystatechange = function(req, fileName, callback) {
                    if (req.readyState === 4) {
                        var response = null;
                        var aid = null;
                        var status = req.status;
                        if (status === 200) {
                            var resp = eval("["+req.responseText+"]");
                            response = resp.length && resp[2];
                            if (response) {
                                response = response[0];
                                if (response) {
                                    uploadResults.push({aid:response.aid, filename:fileName});
                                    if(i == cnt) {
                                        callback.run(status, uploadResults);
                                    }
                                }
                            }
                        } else {
                            callback.run(status, uploadResults);
                        }
                    }
                }.bind(this, req, fileName, callback);

                req.send(file);
                delete req;
            } else {
                throw(new AjxException(ZaMsg.ERROR_INVALID_FILE_NAME, AjxException.UNKNOWN, "ZaUploader.prototype.upload"));
            }
        }
    }
};

ZaUploader.upload = function(callback, fileElementIds, formId) {
    if(!AjxUtil.isArrayLike(fileElementIds)) {
        fileElementIds = [fileElementIds];
    }
    if(AjxEnv.supportsHTML5File) {
        var uploader = new ZaUploader();
        uploader._upload(fileElementIds, appContextPath + "/../service/upload?fmt=extended,raw",  callback);
    } else {
        DBG.println("Start uploading the file");
        this.setUploadManager(new AjxPost(this.getUploadFrameId()));
        var um = this.getUploadManager() ;
        window._uploadManager = um;
        um.execute(new AjxCallback(this, function(status, uploadResult) {
            var uploadResults = [];
            if(AjxUtil.isArrayLike(uploadResult)) {
                //uploaded multiple files
                uploadResults = uploadResult;
            } else {
                //uploaded single file
                var fileName = "";
                if(fileElementIds[0]) {
                    var element = document.getElementById(fileElementIds[0]);
                    var file = element.files[0];
                    if(file) {
                        fileName = file.name || file.fileName;
                    }
                }
                uploadResults.push({aid:uploadResult, filename:fileName});
            }
            callback.run(status, uploadResults);
        }), document.getElementById (formId));
        return; //allow the callback to handle the wizard buttons
    }
};
}

//
// Admin UI Specific components
//

// controllers
if (AjxPackage.define("zimbraAdmin.common.ZaOverviewPanelController")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
 * @class ZaOverviewPanelController
 * @contructor ZaOverviewPanelController
 * Controls the navigation tree.
 * @author Roland Schemers
 * @author Greg Solovyev
 **/
ZaOverviewPanelController = function(appCtxt, container) {
    ZaController.call(this, appCtxt, container, "ZaOverviewPanelController");
    this._init(appCtxt, container);
    this._setView();
}

ZaOverviewPanelController.prototype = new ZaController;
ZaOverviewPanelController.prototype.constructor = ZaOverviewPanelController;
ZaOverviewPanelController.overviewTreeListeners = new Object();
ZaOverviewPanelController.treeModifiers = new Array();
ZaOverviewPanelController._TID = "TID";
ZaOverviewPanelController._OBJ_ID = "OBJ_ID";

ZaOverviewPanelController.prototype.toString = function() {
    return "ZaOverviewPanelController";
}

ZaOverviewPanelController.prototype.getOverviewPanel = function() {
    if (!this._overviewPanel) {
        this._setView();
    }
    return this._overviewPanel;
}

/**
 * @param ev
 * This listener is invoked by any controller that can create a ZaCos object
 **/
ZaOverviewPanelController.prototype.handleCosCreation = function(ev) {
    return;
}

/**
 * @param ev
 * This listener is invoked by  any controller that can change a ZaCos object
 * the purpose of this listener is to keep labels of COS sub tree nodes in sync with COSes
 **/
ZaOverviewPanelController.prototype.handleCosChange = function(ev) {
    return;
}

/**
 * @param ev
 * This listener is invoked by  any controller that can remove an ZaCos object
 **/
ZaOverviewPanelController.prototype.handleCosRemoval = function(ev) {
    return;
}

/**
 * This listener is invoked by any controller that do a search.
 * @param ev
 */
ZaOverviewPanelController.prototype.handleSearchFinished = function(ev) {
    this.refreshSearchTree(ev);
}

ZaOverviewPanelController.prototype.removeCosTreeItems = function(detls) {
    return;
}

ZaOverviewPanelController.prototype.searchDomains = function() {
    var busyId = Dwt.getNextId();
    //var callback = new AjxCallback(this, this.domainSearchCallback,{busyId:busyId});
    var domainListController = ZaApp.getInstance().getDomainListController();

    //	domainListController._currentQuery = ZaDomain.LOCAL_DOMAIN_QUERY;
    domainListController._currentQuery = "";
    if (!ZaZimbraAdmin.hasGlobalDomainListAccess()) {
        var domainNameList = ZaApp.getInstance()._domainNameList;
        if (!domainNameList || !(domainNameList instanceof Array) || domainNameList.length == 0) {
            ZaApp.getInstance()._domainList = new ZaItemList(ZaDomain);
            return;
        }
        if (domainNameList && domainNameList instanceof Array) {
            for (var i = 0; i < domainNameList.length; i++)
                domainListController._currentQuery += "(" + ZaDomain.A_domainName + "=" + domainNameList[i] + ")";
            if (domainNameList.length > 1)
                domainListController._currentQuery = "(|" + domainListController._currentQuery + ")";
        }
    }

    var searchParams = {
        query : domainListController._currentQuery,
        types : [ ZaSearch.DOMAINS ],
        sortBy : ZaDomain.A_domainName,
        offset : "0",
        sortAscending : "1",
        limit : ZaDomain.MAXSEARCHRESULTS,
        attrs : [ ZaDomain.A_description, ZaDomain.A_domainName, ZaDomain.A_zimbraDomainStatus, ZaItem.A_zimbraId,
                ZaDomain.A_domainType ]
    }
    var resp = ZaSearch.searchDirectory(searchParams);
    this.domainSearchCallback(searchParams, resp);
}

ZaOverviewPanelController.prototype.domainSearchCallback = function(params, resp) {
    try {

        if (!resp) {
            throw (new AjxException(ZaMsg.ERROR_EMPTY_RESPONSE_ARG, AjxException.UNKNOWN,
                    "ZaOverviewPanelController.prototype.domainSearchCallback"));
        }
        ZaSearch.TOO_MANY_RESULTS_FLAG = false;
        var response = resp.Body.SearchDirectoryResponse;
        var list = new ZaItemList(ZaDomain);
        list.loadFromJS(response);
        if (response.more) {
            ZaSettings.HAVE_MORE_DOMAINS = true;
        }
        this.updateDomainList(list);
    } catch (ex) {
        if (ex.code != ZmCsfeException.MAIL_QUERY_PARSE_ERROR) {
            ZaApp.getInstance().getCurrentController()._handleException(ex,
                    "ZaOverviewPanelController.prototype.searchCallback");
        } else {
            ZaApp.getInstance().getCurrentController().popupErrorDialog(ZaMsg.queryParseError, ex);
        }
    }
}
ZaOverviewPanelController.prototype.updateSavedSearchTreeList = function() {
    var tree = this._overviewPanel.getFolderTree();
    var savedSearchPath = ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search, ZaMsg.OVP_savedSearch ]);
    tree.removeAllChild(savedSearchPath);

    try {
        var savedSearchList = ZaApp.getInstance().getSavedSearchList();
        if (savedSearchList && savedSearchList.length) {
            var cnt = savedSearchList.length;
            for (var ix = 0; ix < cnt; ix++) {
                var ti1 = new ZaTreeItemData({
                    parent : savedSearchPath,
                    id : ZaId.getTreeItemId(ZaId.PANEL_APP, "currentSearch", null, ix + 1),
                    text : savedSearchList[ix].name,
                    buildPath : this.getSearchItemPath(),
                    mappingId : ZaZimbraAdmin._SEARCH_HOME_VIEW
                });
                ti1.setData("name", savedSearchList[ix].name);
                ti1.setData("query", savedSearchList[ix].query); //keep the query information here
                tree.addTreeItemData(ti1);
            }

            var searchRootNode = tree.getTreeItemByPath(savedSearchPath);
            if (searchRootNode) {
                // TODO Improve Later
                var showRootNode = tree.getTreeItemDataByPath(savedSearchPath);
                var ti, currentAddNode, forceNode, key;
                for (var i = 0; i < showRootNode.childrenData.size(); i++) {
                    currentAddNode = showRootNode.childrenData.get(i);
                    if (currentAddNode.forceNode !== undefined)
                        forceNode = currentAddNode.forceNode;
                    else
                        forceNode = currentAddNode.childrenData.size() > 0 ? true : false;
                    ti = new ZaTreeItem({
                        parent : searchRootNode,
                        className : "AdminTreeItem",
                        id : currentAddNode.id,
                        forceNode : forceNode
                    });
                    ti.setCount(currentAddNode.count);
                    ti.setText(currentAddNode.text);
                    ti.setImage(currentAddNode.image);
                    ti.setData(ZaOverviewPanelController._TID, currentAddNode.mappingId);
                    ti.setData("dataItem", currentAddNode);
                    for (key in currentAddNode._data) {
                        ti.setData(key, currentAddNode._data[key]);
                    }
                }
                searchRootNode.setExpanded(true);
            }
        }
    } catch (ex) {
        this._handleException(ex, "ZaOverviewPanelController.prototype._buildNewFolderTree", null, false);
    }
    return;
}

ZaOverviewPanelController.prototype.updateDomainList = function(list) {
    return; //new UI no need for this
}

ZaOverviewPanelController.prototype.setCurrentDomain = function(newDomain) {
    this._currentDomain = newDomain;
}

ZaOverviewPanelController.prototype.getCurrentDomain = function() {
    return this._currentDomain;
}

//protected and private methods
/**
 * @method init
 * this method creates and initializes any members of this class
 * This method is called by the contructor after the superconstructor and before the _setView
 **/
ZaOverviewPanelController.prototype._init = function(appCtxt, container) {
    this._overviewPanel = null;
    this._addressesTi = null;
    this._configTi = null;
    this._monitoringTi = null;
    this._cosTi = null;
    this._domainsTi = null;
    this._serversTi = null;
    this.statusTi = null;
    this._savedSearchTi = null;
    this._currentDomain = "";
    this._app = ZaApp.getInstance();

    //TODO:  ZaSettings.DOMAIN_AUTH_WIZ_ENABLED - LDAPAuthWizard enabled for the domain admin
    if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.DOMAIN_LIST_VIEW]
            || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI])
        this._domainsMap = new Object();

    if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.SERVER_LIST_VIEW]
            || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI])
        this._serversMap = new Object();

    if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.SERVER_STATS_VIEW]
            || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI])
        this._serversStatsMap = new Object();

    if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.COS_LIST_VIEW]
            || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI])
        this._cosMap = new Object();

    this._mailqMap = new Object();

    if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.SAVE_SEARCH]
            || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI])
        this._savedSearchMapArr = [];
}

ZaOverviewPanelController.prototype._setView = function() {

    this._overviewPanel = new ZaOverviewPanel({
        parent : this._container,
        className : "OverviewPanel",
        posStyle : DwtControl.ABSOLUTE_STYLE,
        id : ZaId.PANEL_APP
    //ZaId.getOverviewId(ZaId.PANEL_APP)
    });

    this._overviewPanel.setScrollStyle(DwtControl.SCROLL);
    ZaSearch.loadPredefinedSearch();
    this._buildNewFolderTree();
    this._overviewPanel.zShow(true);
}

ZaId.PANEL_HOME = "Home";

ZaOverviewPanelController.prototype._buildNewFolderTree = function() {
    var tree = this._overviewPanel.getFolderTree();
    var parentPath;
    var l = new AjxListener(this, this._overviewTreeListener);
    tree.addSelectionListener(l);
    var mtaList = ZaApp.getInstance().getPostQList().getArray();
    var showMonitor = ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI];
    var showManageAccount = ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI];
    var showAdministration = ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI];
    var showTool = ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI];
    var showHelpCenter = ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI];

    if (!showMonitor) {
        for (var i = 0; i < ZaSettings.OVERVIEW_MONITORING_ITEMS.length; i++) {
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.OVERVIEW_MONITORING_ITEMS[i]]) {
                showMonitor = true;
                break;
            }
        }
    }

    if (!showManageAccount) {
        for (var i = 0; i < ZaSettings.OVERVIEW_MANAGER_ACCOUNT_ITEMS.length; i++) {
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.OVERVIEW_MANAGER_ACCOUNT_ITEMS[i]]) {
                showManageAccount = true;
                break;
            }
        }
    }

    if (!showAdministration) {
        for (var i = 0; i < ZaSettings.OVERVIEW_ADMIN_ITEMS.length; i++) {
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.OVERVIEW_ADMIN_ITEMS[i]]) {
                showAdministration = true;
                break;
            }
        }
    }

    if (!showTool) {
        for (var i = 0; i < ZaSettings.OVERVIEW_TOOLS_ITEMS.length; i++) {
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.OVERVIEW_TOOLS_ITEMS[i]]) {
                showTool = true;
                break;
            }
        }
    }

    if (!showHelpCenter) {
        for (var i = 0; i < ZaSettings.HELP_CENTER_ITEMS.length; i++) {
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.HELP_CENTER_ITEMS[i]]) {
                showHelpCenter = true;
                break;
            }
        }
    }

    //
    // There is no ACL for Download Page in the tool tree items. So tool will be shown here.
    //showTool = true;
    // Home is always added;
    var home = new ZaTreeItemData({
        parent : "",
        id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, true),
        text : ZaMsg.OVP_home,
        mappingId : ZaZimbraAdmin._HOME_VIEW,
        image : "Home"
    });

    ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._HOME_VIEW] = ZaOverviewPanelController.homeTreeListener;
    tree.setRootData(home);

    // Section Monitor Start
    if (showMonitor) {

        // Add Monitor Home Page
        var mi = new ZaTreeItemData({
            parent : ZaMsg.OVP_home,
            id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, null, "monHV"),
            text : ZaMsg.OVP_monitor,
            defaultSelectedItem : 1,
            className : "AdminHomeTreeItem",
            mappingId : ZaZimbraAdmin._MONITOR_HOME_VIEW,
            image : "Monitor"
        });
        tree.addTreeItemData(mi);

        // Add Monitor/Status
        if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.GLOBAL_STATUS_VIEW]
                || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
            var ti = new ZaTreeItemData({
                parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_monitor ]),
                id : ZaId.getTreeItemId(ZaId.PANEL_APP, "monHV", null, "overviewStatusHV"),
                text : ZaMsg.OVP_status,
                mappingId : ZaZimbraAdmin._SERVER_STATUS_VIEW
            });
            tree.addTreeItemData(ti);
            ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._SERVER_STATUS_VIEW] = ZaOverviewPanelController.statusTreeListener;
        }
        // Add Monitor/Statistics
        //insert all the statistics view's subs to the /ZaMsg.OVP_home/ZaMsg.OVP_monitor/, and statistics view itself is the container of those subs
        if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.SERVER_STATS_VIEW]
                || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
            this.addSubTabsToParentTreeItem(mi, ZaGlobalStatsView.prototype.getTabChoices(),
                    ZaZimbraAdmin._SERVER_STATISTICS_VIEW, true);
            ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._SERVER_STATISTICS_VIEW] = ZaOverviewPanelController.statsTreeListener;

            ti = new ZaTreeItemData({
                parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_monitor ]),
                id : ZaId.getTreeItemId(ZaId.PANEL_APP, "monHV", null, "serverListForStatisticsHV"),
                text : ZaMsg.OVP_statistics,
                canShowOnRoot : false,
                forceNode : false,
                mappingId : ZaZimbraAdmin._SERVER_LIST_FOR_STATISTICS_VIEW
            });
            tree.addTreeItemData(ti);
            ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._SERVER_LIST_FOR_STATISTICS_VIEW] = ZaOverviewPanelController.serverListForStatisticsTreeListener;
        }
        // Add Monitor/Mail Queue
        if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.MAILQ_VIEW]
                || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
            try {
                if (mtaList && mtaList.length) {
                    var cnt = mtaList.length;
                    var postTi;
                    if (cnt > 1) {
                        postTi = new ZaTreeItemData({
                            parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_monitor ]),
                            id : ZaId.getTreeItemId(ZaId.PANEL_APP, "monHV", null, "postQueueHV"),
                            text : ZaMsg.OVP_postq,
                            mappingId : ZaZimbraAdmin._POSTQ_VIEW
                        });
                        tree.addTreeItemData(postTi);
                        for (var ix = 0; ix < cnt; ix++) {
                            var ti1 = new ZaTreeItemData({
                                parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_monitor, ZaMsg.OVP_postq ]),
                                id : DwtId._makeId(postTi.id, ix + 1),
                                text : mtaList[ix].name,
                                mappingId : ZaZimbraAdmin._POSTQ_BY_SERVER_VIEW
                            });
                            ;
                            ti1.setData(ZaOverviewPanelController._OBJ_ID, mtaList[ix].id);
                            this._mailqMap[mtaList[ix].id] = ti1;
                            tree.addTreeItemData(ti1);
                        }
                        ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._POSTQ_VIEW] = ZaOverviewPanelController.postqTreeListener;
                    } else {
                        postTi = new ZaTreeItemData({
                            parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_monitor ]),
                            id : ZaId.getTreeItemId(ZaId.PANEL_APP, "monHV", null, "postQueueHV"),
                            text : ZaMsg.OVP_postq,
                            mappingId : ZaZimbraAdmin._POSTQ_BY_SERVER_VIEW
                        });
                        postTi.setData(ZaOverviewPanelController._OBJ_ID, mtaList[0].id);
                        tree.addTreeItemData(postTi);
                    }
                    ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._POSTQ_BY_SERVER_VIEW] = ZaOverviewPanelController.postqByServerTreeListener;
                }
            } catch (ex) {
                this._handleException(ex, "ZaOverviewPanelController.prototype._buildFolderTree", null, false);
            }

        }
    }
    // Section Manager Account Start
    if (showManageAccount) {
        var accountMrgCallback = new AjxCallback(this, ZaOverviewPanelController.manageAccountTreeListener);
        var accountMgr = new ZaTreeItemData({
            parent : ZaMsg.OVP_home,
            id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, null, "manActHV"),
            text : ZaMsg.OVP_manageAccounts,
            className : "AdminHomeTreeItem",
            callback : accountMrgCallback,
            defaultSelectedItem : 1,
            //mappingId: ZaZimbraAdmin._MANAGE_ACCOUNT_HOME_VIEW,
            image : "ManageAccounts"
        });
        //ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._MANAGE_ACCOUNT_HOME_VIEW] = ZaOverviewPanelController.manageAccountTreeListener;
        tree.addTreeItemData(accountMgr);
        if (accountMgr) {
            var refpath = ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_manageAccounts ]);
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.ACCOUNT_LIST_VIEW]
                    || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
                var acctitem = new ZaTreeItemData({
                    parent : refpath,
                    id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, null, "actLstHV"),
                    text : ZaMsg.OVP_accounts,
                    count : 0,
                    canShowOnRoot : false,
                    forceNode : false,
                    mappingId : ZaZimbraAdmin._ACCOUNTS_LIST_VIEW
                });
                acctitem.setData("TreeItemType", ZaItem.ACCOUNT);
                ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._ACCOUNTS_LIST_VIEW] = ZaOverviewPanelController.accountListTreeListener;
                tree.addTreeItemData(acctitem);
            }

            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.ALIAS_LIST_VIEW]
                    || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
                var aliaitem = new ZaTreeItemData({
                    parent : refpath,
                    id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, null, "aliaLstHV"),
                    text : ZaMsg.OVP_aliases,
                    count : 0,
                    canShowOnRoot : false,
                    forceNode : false,
                    mappingId : ZaZimbraAdmin._ALIASES_LIST_VIEW
                });
                aliaitem.setData("TreeItemType", ZaItem.ALIAS);
                tree.addTreeItemData(aliaitem);
                ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._ALIASES_LIST_VIEW] = ZaOverviewPanelController.aliasListTreeListener;
            }

            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.DL_LIST_VIEW]
                    || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
                var dlitem = new ZaTreeItemData({
                    parent : refpath,
                    id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, null, "dlLstHV"),
                    text : ZaMsg.OVP_distributionLists,
                    count : 0,
                    canShowOnRoot : false,
                    forceNode : false,
                    mappingId : ZaZimbraAdmin._DISTRIBUTION_LISTS_LIST_VIEW
                });
                dlitem.setData("TreeItemType", ZaItem.DL);
                tree.addTreeItemData(dlitem);
                ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._DISTRIBUTION_LISTS_LIST_VIEW] = ZaOverviewPanelController.dlListTreeListener;
            }

            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.RESOURCE_LIST_VIEW]
                    || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
                var resourceitem = new ZaTreeItemData({
                    parent : refpath,
                    id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, null, "resLstHV"),
                    text : ZaMsg.OVP_resources,
                    count : 0,
                    canShowOnRoot : false,
                    forceNode : false,
                    mappingId : ZaZimbraAdmin._RESOURCE_VIEW
                });
                resourceitem.setData("TreeItemType", ZaItem.RESOURCE);
                tree.addTreeItemData(resourceitem);
                ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._RESOURCE_VIEW] = ZaOverviewPanelController.resourceListTreeListener;
            }
        }
    }

    // Section Configuration Start
    if (showAdministration) {
        ti = this._configure = new ZaTreeItemData({
            parent : ZaMsg.OVP_home,
            id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, null, "adminHV"),
            text : ZaMsg.OVP_configure,
            defaultSelectedItem : 1,
            className : "AdminHomeTreeItem",
            mappingId : ZaZimbraAdmin._ADMINISTRATION_HOME_VIEW,
            image : "Administration"
        });
        tree.addTreeItemData(ti);

        if (this._configure) {
            parentPath = ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_configure ]);
            if (!ZaZimbraAdmin.hasGlobalCOSSListAccess()) {
                if (!ZaApp.getInstance()._domainNameList) {
                    ZaApp.getInstance()._domainNameList = ZaDomain
                            .getEffectiveDomainList(ZaZimbraAdmin.currentAdminAccount.id);
                }
            }
            if (!ZaZimbraAdmin.hasGlobalDomainListAccess()) {
                if (!ZaApp.getInstance()._cosNameList) {
                    ZaApp.getInstance()._cosNameList = ZaCos.getEffectiveCosList(ZaZimbraAdmin.currentAdminAccount.id);
                }
            }
            // Add Configuration /Cos
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.COS_LIST_VIEW]
                    || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
                ti = new ZaTreeItemData({
                    parent : parentPath,
                    id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_CONFIGURATION, null, ZaId.TREEITEM_COS),
                    text : ZaMsg.OVP_cos,
                    canShowOnRoot : false,
                    forceNode : false,
                    mappingId : ZaZimbraAdmin._COS_LIST_VIEW
                });
                tree.addTreeItemData(ti);
                ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._COS_LIST_VIEW] = ZaOverviewPanelController.cosListTreeListener;
            }

            // Add Configuration /Domain
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.DOMAIN_LIST_VIEW]
                    || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
                ti = new ZaTreeItemData({
                    parent : parentPath,
                    id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_CONFIGURATION, null, ZaId.TREEITEM_DOMAINS),
                    text : ZaMsg.OVP_domains,
                    canShowOnRoot : false,
                    forceNode : false,
                    mappingId : ZaZimbraAdmin._DOMAINS_LIST_VIEW
                });
                tree.addTreeItemData(ti);
                ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._DOMAINS_LIST_VIEW] = ZaOverviewPanelController.domainListTreeListener;
            }

            // Add Configuration /Sever Setting
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.SERVER_LIST_VIEW]
                    || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
                try {
                    var serverList = ZaApp.getInstance().getServerList().getArray();
                    if (serverList && serverList.length) {
                        var cnt = serverList.length;
                        var serverTi;
                        if (cnt > 0) {
                            serverTi = new ZaTreeItemData({
                                parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_configure ]),
                                id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_CONFIGURATION, null, "serverHV"),
                                text : ZaMsg.OVP_servers,
                                canShowOnRoot : false,
                                forceNode : false,
                                mappingId : ZaZimbraAdmin._SERVERS_LIST_VIEW
                            });
                            tree.addTreeItemData(serverTi);
                            ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._SERVERS_LIST_VIEW] = ZaOverviewPanelController.serverListTreeListener;
                        } else { //Keep it for future use. Change "cnt > 0" to "cnt > 1", if there is only one server, will directly goes to the edit view of this server.
                            serverTi = new ZaTreeItemData({
                                parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_configure ]),
                                id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_CONFIGURATION, null, "serverHV"),
                                text : ZaMsg.OVP_serverSettings,
                                image : "Server",
                                mappingId : ZaZimbraAdmin._SERVER_VIEW
                            });
                            serverTi.setData(ZaOverviewPanelController._OBJ_ID, serverList[0].id);
                            tree.addTreeItemData(serverTi);
                            ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._SERVER_VIEW] = ZaOverviewPanelController.serverTreeListener;
                        }
                    }
                } catch (ex) {
                    this._handleException(ex, "ZaOverviewPanelController.prototype._buildNewFolderTree", null, false);
                }
            }

            // Add Configuration / Global Settings
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.GLOBAL_CONFIG_VIEW]
                    || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {

                ti = new ZaTreeItemData({
                    parent : parentPath,
                    id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_CONFIGURATION, null, ZaId.TREEITEM_GSET),
                    text : ZaMsg.OVP_global,
                    forceNode : true,
                    mappingId : ZaZimbraAdmin._GLOBAL_SETTINGS
                });

                ti.addListener(ZaTreeEvent.ONDESTROY, new AjxListener(this, this.saveBeforeExit));

                tree.addTreeItemData(ti);

                ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._GLOBAL_SETTINGS] = ZaOverviewPanelController.globalSettingsTreeListener;
            }

            // Add Configuration /Zimlets
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.ZIMLET_LIST_VIEW]
                    || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
                ti = new ZaTreeItemData({
                    parent : parentPath,
                    id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_CONFIGURATION, null, ZaId.TREEITEM_ZIMLETS),
                    text : ZaMsg.OVP_zimlets,
                    canShowOnRoot : false,
                    forceNode : false,
                    mappingId : ZaZimbraAdmin._ZIMLET_LIST_VIEW
                });
                tree.addTreeItemData(ti);
                ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._ZIMLET_LIST_VIEW] = ZaOverviewPanelController.zimletListTreeListener;
            }

            // Add Configuration /Admin Ext
            if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.ADMIN_ZIMLET_LIST_VIEW]
                    || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
                ti = new ZaTreeItemData({
                    parent : parentPath,
                    id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_CONFIGURATION, null, ZaId.TREEITEM_ADMINEXT),
                    text : ZaMsg.OVP_adminZimlets,
                    canShowOnRoot : false,
                    forceNode : false,
                    mappingId : ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW
                });
                tree.addTreeItemData(ti);
                ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._ADMIN_ZIMLET_LIST_VIEW] = ZaOverviewPanelController.adminExtListTreeListener;
            }
        }
    }

    if (showTool) {
        // Section Tool and Migration Start
        ti = new ZaTreeItemData({
            parent : ZaMsg.OVP_home,
            id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, null, "magHV"),
            text : ZaMsg.OVP_toolMig,
            className : "AdminHomeTreeItem",
            defaultSelectedItem : 1,
            mappingId : ZaZimbraAdmin._MIGRATION_HOME_VIEW,
            image : "ToolsAndMigration"
        });

        tree.addTreeItemData(ti);
        if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.DOWNLOADS_VIEW]
                || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
            ti = new ZaTreeItemData({
                parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_toolMig ]),
                id : ZaId.getTreeItemId(ZaId.PANEL_APP, "magHV", null, "download"),
                text : ZaMsg.goToMigrationWiz,
                mappingId : ZaZimbraAdmin._DOWNLOAD_VIEW
            });
            ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._DOWNLOAD_VIEW] = ZaOverviewPanelController.downloadTreeListener;
            tree.addTreeItemData(ti);
        }
    }

    // Section Search Start
    ti = new ZaTreeItemData({
        parent : ZaMsg.OVP_home,
        id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, null, "searchHV"),
        text : ZaMsg.OVP_search,
        className : "AdminHomeTreeItem",
        mappingId : ZaZimbraAdmin._SEARCH_HOME_VIEW,
        image : "SearchAll"
    });

    ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._SEARCH_HOME_VIEW] = ZaOverviewPanelController.newSearchListTreeListener;
    tree.addTreeItemData(ti);

    parentPath = ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search ]);
    var currentSearchTi = new ZaTreeItemData({
        parent : parentPath,
        id : ZaId.getTreeItemId(ZaId.PANEL_APP, "searchHV", null, "currentSearch"),
        text : ZaMsg.OVP_search,
        defaultSelectedItem : 1,
        image : "SearchAll",
        mappingId : ZaZimbraAdmin._SEARCH_HOME_VIEW
    });
    ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._SEARCH_HOME_VIEW] = ZaOverviewPanelController.newSearchListTreeListener;
    tree.addTreeItemData(currentSearchTi);
    this.setSearchItemPath(ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search, ZaMsg.OVP_search ]));

    ti = new ZaTreeItemData({
        parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search, ZaMsg.OVP_search ]),
        id : ZaId.getTreeItemId(ZaId.PANEL_APP, "currentSearch", null, "allResult"),
        text : ZaMsg.OVP_allSearchResult,
        mappingId : ZaZimbraAdmin._SEARCH_RESULT_VIEW
    });
    tree.addTreeItemData(ti);
    ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._SEARCH_RESULT_VIEW] = ZaOverviewPanelController.searchResultTreeListener;
    ti = new ZaTreeItemData({
        parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search, ZaMsg.OVP_search ]),
        id : ZaId.getTreeItemId(ZaId.PANEL_APP, "currentSearch", null, "accountResult"),
        text : ZaMsg.OVP_accountSearchResult,
        mappingId : ZaZimbraAdmin._SEARCH_RESULT_VIEW
    });
    ti.setData("TreeItemType", ZaItem.ACCOUNT);
    tree.addTreeItemData(ti);
    ti = new ZaTreeItemData({
        parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search, ZaMsg.OVP_search ]),
        id : ZaId.getTreeItemId(ZaId.PANEL_APP, "currentSearch", null, "aliasResult"),
        text : ZaMsg.OVP_aliasSearchResult,
        mappingId : ZaZimbraAdmin._SEARCH_RESULT_VIEW
    });
    ti.setData("TreeItemType", ZaItem.ALIAS);
    tree.addTreeItemData(ti);

    ti = new ZaTreeItemData({
        parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search, ZaMsg.OVP_search ]),
        id : ZaId.getTreeItemId(ZaId.PANEL_APP, "currentSearch", null, "domainResult"),
        text : ZaMsg.OVP_domainSearchResult,
        mappingId : ZaZimbraAdmin._SEARCH_RESULT_VIEW
    });
    ti.setData("TreeItemType", ZaItem.DOMAIN);
    tree.addTreeItemData(ti);

    ti = new ZaTreeItemData({
        parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search, ZaMsg.OVP_search ]),
        id : ZaId.getTreeItemId(ZaId.PANEL_APP, "currentSearch", null, "dlResult"),
        text : ZabMsg.OVP_dlSearchResult,
        mappingId : ZaZimbraAdmin._SEARCH_RESULT_VIEW
    });
    ti.setData("TreeItemType", ZaItem.DL);
    tree.addTreeItemData(ti);

    var searchOptionTi = new ZaTreeItemData({
        parent : parentPath,
        canShowOnRoot : false,
        id : ZaId.getTreeItemId(ZaId.PANEL_APP, "searchHV", null, "searchOption"),
        text : ZaMsg.OVP_searchOption
    });
    tree.addTreeItemData(searchOptionTi);
    currentSearchTi.addSilbings(searchOptionTi);
    // Add Option here.
    var optionBasePath = ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search, ZaMsg.OVP_searchOption ]);
    var searchOptionTreeItem = ZaApp.getInstance().getSearchBuilderController().getFilterTreeItems();
    for (var i = 0; i < searchOptionTreeItem.length; i++) {
        ti = new ZaTreeItemData({
            parent : optionBasePath,
            canShowOnRoot : false,
            id : ZaId.getTreeItemId(ZaId.PANEL_APP, "searchOption", null, i + 1),
            mappingId : ZaZimbraAdmin._SEARCH_FILTER_VIEW,
            buildPath : this.getSearchItemPath(),
            text : searchOptionTreeItem[i].text
        });
        ti.setData("filterType", searchOptionTreeItem[i].filterType);
        tree.addTreeItemData(ti);
    }
    ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._SEARCH_FILTER_VIEW] = ZaSearchBuilderController.searchFilterTreeListener;

    if (ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.SAVE_SEARCH]
            || ZaSettings.ENABLED_UI_COMPONENTS[ZaSettings.CARTE_BLANCHE_UI]) {
        var savedSearchTi = new ZaTreeItemData({
            parent : parentPath,
            id : ZaId.getTreeItemId(ZaId.PANEL_APP, "searchHV", null, "savedSearch"),
            canShowOnRoot : false,
            text : ZaMsg.OVP_savedSearch
        });
        tree.addTreeItemData(savedSearchTi);
        currentSearchTi.addSilbings(savedSearchTi);
        try {
            var savedSearchList = ZaApp.getInstance().getSavedSearchList();
            if (savedSearchList && savedSearchList.length) {
                var savedSearchPath = ZaTree
                        .getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search, ZaMsg.OVP_savedSearch ]);
                this._savedSearchPath = savedSearchPath;
                var cnt = savedSearchList.length;
                for (var ix = 0; ix < cnt; ix++) {
                    var ti1 = new ZaTreeItemData({
                        parent : savedSearchPath,
                        id : ZaId.getTreeItemId(ZaId.PANEL_APP, "currentSearch", null, ix + 1),
                        text : savedSearchList[ix].name,
                        buildPath : this.getSearchItemPath(),
                        mappingId : ZaZimbraAdmin._SEARCH_HOME_VIEW
                    });
                    ti1.setData("name", savedSearchList[ix].name);
                    ti1.setData("query", savedSearchList[ix].query); //keep the query information here
                    tree.addTreeItemData(ti1);
                }
            }
        } catch (ex) {
            this._handleException(ex, "ZaOverviewPanelController.prototype._buildNewFolderTree", null, false);
        }
    }

    if (showHelpCenter) {
        ti = new ZaTreeItemData({
            parent : ZaMsg.OVP_home,
            id : ZaId.getTreeItemId(ZaId.PANEL_APP, ZaId.PANEL_HOME, null, "helpCenter"),
            text : ZaMsg.zimbraHelpCenter,
            className : "AdminHomeTreeItem",
            defaultSelectedItem : 1,
            mappingId : ZaZimbraAdmin._HELP_CENTER_HOME_VIEW,
            image : "Help"
        });
        tree.addTreeItemData(ti);

        ti = new ZaTreeItemData({
            parent : ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.zimbraHelpCenter ]),
            id : ZaId.getTreeItemId(ZaId.PANEL_APP, "helpCenter", null, "helpCenter"),
            text : ZaMsg.zimbraHelpCenter,
            mappingId : ZaZimbraAdmin._HELP_CENTER_VIEW
        });
        ZaOverviewPanelController.overviewTreeListeners[ZaZimbraAdmin._HELP_CENTER_VIEW] = ZaZimbraAdmin.prototype._helpListener;
        tree.addTreeItemData(ti);
    }

    //Instrumentation code start
    if (ZaOverviewPanelController.treeModifiers) {
        var methods = ZaOverviewPanelController.treeModifiers;
        var cnt = methods.length;
        for (var i = 0; i < cnt; i++) {
            if (typeof (methods[i]) == "function") {
                methods[i].call(this, tree);
            }
        }
    }
}

ZaOverviewPanelController.prototype._overviewTreeListener = function(ev) {
    try {
        var eventHandler = null;

        var treeItemType = ev.item.getData(ZaOverviewPanelController._TID);
        if (treeItemType != null && ZaOverviewPanelController.overviewTreeListeners[treeItemType]
                && typeof (ZaOverviewPanelController.overviewTreeListeners[treeItemType]) == "function") {
            eventHandler = ZaOverviewPanelController.overviewTreeListeners[treeItemType];
        }
        if (eventHandler) {
            if (ev.detail == DwtTree.ITEM_SELECTED) {
                eventHandler.call(this, ev);

            } else if (ev.detail == DwtTree.ITEM_ACTIONED) {
                if (treeItemType == ZaZimbraAdmin._SEARCH_LIST_VIEW || treeItemType == ZaZimbraAdmin._SEARCH_HOME_VIEW) { //saved search item is actioned.
                    //if(window.console && window.console.log) console.debug("Saved Search tree Item is actioned.") ;
                    eventHandler.call(this, ev);
                }
            }
        }
    } catch (ex) {
        if (!ex) {
            ex = new ZmCsfeException("Unknown error", AjxException.UNKNOWN_ERROR,
                    "ZaOverviewPanelController.prototype._overviewTreeListener", "Unknown error")
        }
        this._handleException(ex, "ZaOverviewPanelController.prototype._overviewTreeListener", null, false);
    }
}

ZaOverviewPanelController.prototype.setSearchItemPath = function(path) {
    this._searchItemPath = path;
}

ZaOverviewPanelController.prototype.getSearchItemPath = function(path) {
    return this._searchItemPath;
}

/* default tree listeners */
ZaOverviewPanelController.homeTreeListener = function(ev) {
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getHomeViewController(),
                ZaHomeController.prototype.show, null);
    } else {
        ZaApp.getInstance().getHomeViewController().show();
    }

    this._modifySearchMenuButton();

}

ZaOverviewPanelController.cosTreeListener = function(ev) {
    var cos = ZaApp.getInstance().getCosList(true).getItemById(ev.item.getData(ZaOverviewPanelController._OBJ_ID));
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getCosController(),
                ZaCosController.prototype.show, cos);
    } else {
        ZaApp.getInstance().getCosController().show(cos);
    }
    var parentPath = ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_configure, ZaMsg.OVP_cos ]);
    var skipHistory = ev.item.getData("skipHistory");
    ZaZimbraAdmin.getInstance().getOverviewPanelController().addObjectItem(parentPath, cos.name, null,
            (skipHistory == "TRUE"), false, cos);
}

ZaOverviewPanelController.domainTreeListener = function(ev) {
    var domain = new ZaDomain();
    domain.id = ev.item.getData(ZaOverviewPanelController._OBJ_ID);
    domain.attrs[ZaItem.A_zimbraId] = ev.item.getData(ZaOverviewPanelController._OBJ_ID);
    domain.load("id", domain.id);

    var isLocal = (domain.attrs[ZaDomain.A_domainType] == ZaDomain.domainTypes.local);
    var isAlias = (domain.attrs[ZaDomain.A_domainType] == ZaDomain.domainTypes.alias);

    if (ZaApp.getInstance().getCurrentController()) {
        if (isLocal) {
            ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getDomainController(),
                    ZaDomainController.prototype.show, domain);
        } else if (isAlias) {
            ZaApp.getInstance().getDomainAliasWizard(true).editDomainAlias(domain, false);
        }
    } else {
        if (isLocal) {
            ZaApp.getInstance().getDomainController().show(domain);
        } else if (isAlias) {
            ZaApp.getInstance().getDomainAliasWizard(true).editDomainAlias(domain, false);
        }
    }

    var parentPath = ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_configure, ZaMsg.OVP_domains ]);
    var skipHistory = ev.item.getData("skipHistory");
    ZaZimbraAdmin.getInstance().getOverviewPanelController().addObjectItem(parentPath, domain.name, null,
            (skipHistory == "TRUE"), false, domain);
}

ZaOverviewPanelController.serverTreeListener = function(ev) {
    var server = new ZaServer();
    server.id = ev.item.getData(ZaOverviewPanelController._OBJ_ID);
    server.attrs[ZaItem.A_zimbraId] = ev.item.getData(ZaOverviewPanelController._OBJ_ID);
    //	DBG.println(AjxDebug.DBG1, "ZaOverviewPanelController.serverTreeListener called");
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getServerController(),
                ZaServerController.prototype.show, server);
    } else {
        ZaApp.getInstance().getServerController()
                .show(
                        ZaApp.getInstance().getServerList(true).getItemById(
                                ev.item.getData(ZaOverviewPanelController._OBJ_ID)));
    }
}

ZaOverviewPanelController.statsByServerTabTreeListener = function(ev) {
    //only apply to new UI

    var viewId = ev.item.parent.getData("viewId");
    var curController = ZaApp.getInstance().getServerStatsController(viewId);

    ZaOverviewPanelController.switchToSubTabForNonXFormView(curController, ev.item);
}

ZaOverviewPanelController.statsByServerTreeListener = function(ev) {
    var currentServer = new ZaServer();

    var viewId = ev.item.getData("viewId");
    ZaApp.getInstance().getAppViewMgr().pushView(viewId);
    var currentView = ZaApp.getInstance().getAppViewMgr().getViewContentById(viewId);
    var currentController = ZaApp.getInstance().getControllerById(viewId);
    var currentObject = currentView._containedObject;
    var serverId = currentObject.id;
    currentServer.id = currentServer.attrs[ZaItem.A_zimbraId] = serverId;
    currentServer.load("id", serverId, false, true);

    currentController.show(currentServer, true);

}

ZaOverviewPanelController.statusTreeListener = function(ev) {
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getStatusViewController(),
                ZaStatusViewController.prototype.show, null);
    } else {
        ZaApp.getInstance().getStatusViewController().show();
    }
}

ZaOverviewPanelController.statsTreeListener = function(ev) {
    var curController = ZaApp.getInstance().getCurrentController();
    var statsController = ZaApp.getInstance().getGlobalStatsController();
    if (curController) {
        curController.switchToNextView(statsController, ZaGlobalStatsController.prototype.show, null);
    } else {
        statsController.show();
    }
    ZaOverviewPanelController.switchToSubTabForNonXFormView(statsController, ev.item);
}

ZaOverviewPanelController.switchToSubTabForNonXFormView = function(controllerOfView, treeItem) {

    var stepValue = treeItem.getData("tabValue");
    var view = ZaApp.getInstance().getAppViewMgr().getViewContentById(controllerOfView.getContentViewId());
    view.switchToTab(stepValue);
    //controllerOfView._contentView.switchToTab();

}

ZaOverviewPanelController.serverListForStatisticsTreeListener = function(ev) {
    //this list only shows in new UI
    var curController = ZaApp.getInstance().getCurrentController();
    var serverStatsListController = ZaApp.getInstance().getServerStatsListController();
    var allServersList = ZaServer.getAll([ ZaServer.A_description, ZaServer.A_ServiceHostname, ZaItem.A_zimbraId ]);

    if (curController) {
        curController.switchToNextView(serverStatsListController, ZaServerStatsListController.prototype.show,
                allServersList);
    } else {
        serverStatsListController.show(allServersList);
    }
}

ZaOverviewPanelController.serverListTreeListener = function(ev) {
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getServerListController(),
                ZaServerListController.prototype.show,
                ZaServer.getAll([ ZaServer.A_description, ZaServer.A_ServiceHostname, ZaItem.A_zimbraId ]));
    } else {
        ZaApp.getInstance().getServerListController().show(
                ZaServer.getAll([ ZaServer.A_description, ZaServer.A_ServiceHostname, ZaItem.A_zimbraId ]));
    }
}

ZaOverviewPanelController.globalSettingsTreeListener = function(ev) {
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(
                ZaApp.getInstance().getGlobalConfigViewController(), ZaGlobalConfigViewController.prototype.show,
                ZaApp.getInstance().getGlobalConfig());
    } else {
        ZaApp.getInstance().getGlobalConfigViewController().show(ZaApp.getInstance().getGlobalConfig());
    }
    var parentPath = ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_configure ]);
    var name = ev.item.getText();
    this.addObjectItem(parentPath, name, undefined, true, true, ev.item, undefined, true);
}

ZaOverviewPanelController.domainListTreeListener = function(ev) {
    var domainListController = ZaApp.getInstance().getDomainListController();

    //if we do not have access to domains we will only get our own domain in response anyway, so no need to add a query
    domainListController._currentQuery = "";
    var extquery = null;
    var actionType = ev.item.getData(ZaOverviewPanelController._TID);
    if (actionType == ZaZimbraAdmin._COS_DOMAIN_LIST_VIEW) {
        var cos = ev.item.getData("cosItem");
        extquery = "(" + ZaDomain.A_domainDefaultCOSId + "=" + cos.id + ")";
        if (cos.name == "default") {
            extquery = "(|(!(" + ZaDomain.A_domainDefaultCOSId + "=*))" + extquery + ")";
        } else if (cos.name == "defaultExternal") {
            extquery = "(|(!(" + ZaDomain.A_domainDefaultExternalUserCOSId + "=*))" + extquery + ")";
        }
    } else if (actionType == ZaZimbraAdmin._DOMAIN_ALIAS_LIST_VIEW) {
        var domain = ev.item.getData("domainItem");
        extquery = "(" + ZaDomain.A_zimbraDomainAliasTargetId + "=" + domain.id + ")";
    }

    if (extquery)
        domainListController._currentQuery = extquery;

    if (!ZaZimbraAdmin.isGlobalAdmin()) {
        var domainNameList = ZaApp.getInstance()._domainNameList;
        if (domainNameList && domainNameList instanceof Array && domainNameList.length > 0) {
            for (var i = 0; i < domainNameList.length; i++)
                domainListController._currentQuery += "(" + ZaDomain.A_domainName + "=" + domainNameList[i] + ")";
            if (domainNameList.length > 1)
                domainListController._currentQuery = "(|" + domainListController._currentQuery + ")";
        }
    }

    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(domainListController,
                ZaDomainListController.prototype.show, true);
    } else {
        domainListController.show(true);
    }

    this._modifySearchMenuButton(ZaItem.DOMAIN);
}

ZaOverviewPanelController.aliasListTreeListener = function(ev) {
    if ((ev.item.getData(ZaOverviewPanelController._TID) == ZaZimbraAdmin._ACCOUNT_ALIAS_LIST_VIEW)
            || ev.item.getData(ZaOverviewPanelController._TID) == ZaZimbraAdmin._DL_ALIAS_LIST_VIEW) {
        var targetId = ev.item.getData("aliasTargetId");
        var extquery = "(" + ZaAlias.A_AliasTargetId + "=" + targetId + ")";
        this._showAccountsView(ZaItem.ALIAS, ev, extquery);
    } else
        this._showAccountsView(ZaItem.ALIAS, ev);

    this._modifySearchMenuButton(ZaItem.ALIAS);
}

ZaOverviewPanelController.dlListTreeListener = function(ev) {
    var dls = ev.item.getData(ZaAccount.A2_memberOf);
    if (dls) {
        var direct_dls = dls[ZaAccount.A2_directMemberList];
        var indirect_dls = dls[ZaAccount.A2_indirectMemberList];

        var extquery = "";
        var id = "";
        for (var i = 0; i < (direct_dls.length + indirect_dls.length); i++) {
            if (i < direct_dls.length) {
                id = direct_dls[i].id;
            } else {
                id = indirect_dls[i - direct_dls.length].id;
            }
            extquery += "(" + ZaItem.A_zimbraId + "=" + id + ")";
        }
        extquery = "(|" + extquery + ")";
        this._showAccountsView(ZaItem.DL, ev, extquery);
    } else
        this._showAccountsView(ZaItem.DL, ev);
    this._modifySearchMenuButton(ZaItem.DL);
}

ZaOverviewPanelController.accountListTreeListener = function(ev) {
    if (ev.item.getData(ZaOverviewPanelController._TID) == ZaZimbraAdmin._COS_ACCOUNT_LIST_VIEW) {
        var cos = ev.item.getData("cosItem");
        var extquery = "(" + ZaAccount.A_COSId + "=" + cos.id + ")";
        if (cos.name == "default") {
            extquery = "(|(&(!(" + ZaAccount.A_COSId + "=*))(!(" + ZaAccount.A_zimbraIsExternalVirtualAccount
                    + "=TRUE)))" + extquery + ")";
        } else if (cos.name == "defaultExternal") {
            extquery = "(|(&(!(" + ZaAccount.A_COSId + "=*))(" + ZaAccount.A_zimbraIsExternalVirtualAccount + "=TRUE))"
                    + extquery + ")";
        }
        this._showAccountsView(ZaItem.ACCOUNT, ev, extquery);
    } else
        this._showAccountsView(ZaItem.ACCOUNT, ev);
    this._modifySearchMenuButton(ZaItem.ACCOUNT);
}

ZaOverviewPanelController.resourceListTreeListener = function(ev) {
    this._showAccountsView(ZaItem.RESOURCE, ev);
    this._modifySearchMenuButton(ZaItem.RESOURCE);
}

ZaOverviewPanelController.searchListTreeListener = function(ev) {
    var searchField = ZaApp.getInstance().getSearchListController()._searchField;
    var name = ev.item.getData("name");
    var query = ev.item.getData("query");
    if (ev.detail == DwtTree.ITEM_SELECTED) {
        //if(window.console && window.console.log) console.debug("Run the saved search ...") ;
        if (query)
            searchField.selectSavedSearch(name, query);
        else
            searchField.invokeCallback(); // Use the value in the current search fields;
    } else if (ev.detail == DwtTree.ITEM_ACTIONED) {
        searchField._currentSavedSearch = {
            name : name,
            query : query
        };
        searchField.getSavedSearchActionMenu().popup(0, ev.docX, ev.docY);
    }
}

ZaOverviewPanelController.newSearchListTreeListener = function(ev) {
    var tree = this.getOverviewPanel().getFolderTree();
    var currentPath = tree.getABPath(ev.item.getData("dataItem"));
    if (currentPath == ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search ])) {
        var searchPath = this.getSearchItemPath();
        tree.setSelectionByPath(searchPath, true, true);
    }
    var slController = ZaApp.getInstance().getSearchListController();
    var searchField = slController._searchField;
    var name = ev.item.getData("name");
    var query = ev.item.getData("query");
    if (ev.detail == DwtTree.ITEM_SELECTED) {
        //if(window.console && window.console.log) console.debug("Run the saved search ...") ;
        if (query) {
            /*
            TODO:
            Improve it in D3
            var searchText = ZaMsg.OVP_search + " : " + name;
            var newPath = tree.renameTreeItem(this.getSearchItemPath(), searchText);
            this.setSearchItemPath(newPath);
             */
            searchField.setCurrentSavedSearch({
                name : name,
                query : query
            });
            searchField.selectSavedSearch(name, query);
        } else {
            searchField.setCurrentSavedSearch({});
            var searchParams = searchField.getCurrentSearchQuery();
            var displayName = searchField.getSearchFieldElement().value;
            if (searchField.searchSelectedType && searchField.searchSelectedType.length > 0) {
                displayName += " In " + searchField.searchSelectedType;
            }

            var params = {
                type : 1,
                unique : true,
                disableForSearch : false,
                query : searchParams.query,
                searchType : searchParams.types,
                displayName : displayName
            };
            if (!slController._uiContainer)
                slController._show();

            slController._uiContainer.removeAllBubbles(true);
            slController._uiContainer.addBubble(params);
        }
    }
    if (ev.detail == DwtTree.ITEM_ACTIONED && query) {
        searchField._currentSavedSearch = {
            name : name,
            query : query
        };
        searchField.getSavedSearchActionMenu().popup(0, ev.docX, ev.docY);
    }
}

ZaOverviewPanelController.searchResultTreeListener = function(ev) {
    if (ev.detail == DwtTree.ITEM_SELECTED) {
        var itemType = ev.item.getData("TreeItemType");
        var slController = ZaApp.getInstance().getSearchListController();
        slController.reset();
        var searchField = slController._searchField;
        var contentView = slController._contentView;
        var skipNotify = false;
        if (itemType == ZaItem.ACCOUNT) {
            if (searchField._containedObject[ZaSearch.A_fAccounts] == "FALSE") {
                contentView.set();
                skipNotify = true;
            } else
                searchField.accFilterSelectedFromResults();
        } else if (itemType == ZaItem.ALIAS) {
            if (searchField._containedObject[ZaSearch.A_fAliases] == "FALSE") {
                contentView.set();
                skipNotify = true;
            } else {
                searchField.aliasFilterSelectedFromResults();
            }
        } else if (itemType == ZaItem.DOMAIN) {
            if (searchField._containedObject[ZaSearch.A_fDomains] == "FALSE") {
                contentView.set();
                skipNotify = true;
            } else
                searchField.domainFilterSelectedFromResults();
        } else if (itemType == ZaItem.DL) {
            if (searchField._containedObject[ZaSearch.A_fdistributionlists] == "FALSE") {
                contentView.set();
                skipNotify = true;
            } else
                searchField.dlFilterSelectedFromResults();
        } else { //all results
            //searchField.allFilterSelected();
        }
        searchField.setCurrentSavedSearch({});
        //searchField.invokeCallback(); // Use the value in the current search fields;
        var searchParams = searchField.getCurrentSearchQuery();
        var displayName = searchField.getSearchFieldElement().value;
        if (searchField.searchSelectedType && searchField.searchSelectedType.length > 0) {
            displayName += " In " + searchField.searchSelectedType;
            if (itemType && itemType.length > 0)
                displayName += " & " + itemType;
        } else if (itemType && itemType.length > 0)
            displayName += " In " + itemType;

        var params = {
            type : 1,
            unique : true,
            disableForSearch : skipNotify,
            query : searchParams.query,
            searchType : searchParams.types,
            displayName : displayName
        };
        if (!slController._uiContainer)
            slController._show();

        slController._uiContainer.removeAllBubbles(true);
        slController._uiContainer.addBubble(params, skipNotify);

        searchField.restoreSearchFilter(); //restore containedObject
    }
}

ZaOverviewPanelController.downloadTreeListener = function(ev) {
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getMigrationWizController(),
                ZaMigrationWizController.prototype.show, null);
    } else {
        ZaApp.getInstance().getMigrationWizController().show();
    }
}

ZaOverviewPanelController.zimletListTreeListener = function(ev) {
    ZaZimlet.getAll(ZaZimlet.EXCLUDE_EXTENSIONS, new AjxCallback(ZaOverviewPanelController._zimletListTreeListener));
};

ZaOverviewPanelController._zimletListTreeListener = function(zimlets) {
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getZimletListController(),
                ZaZimletListController.prototype.show, zimlets);
    } else {
        ZaApp.getInstance().getZimletListController().show(zimlets);
    }
}

ZaOverviewPanelController.adminExtListTreeListener = function(ev) {
    ZaZimlet.getAll(ZaZimlet.EXCLUDE_MAIL, new AjxCallback(ZaOverviewPanelController._adminExtListTreeListener));
};

ZaOverviewPanelController._adminExtListTreeListener = function(zimlets) {
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getAdminExtListController(),
                ZaAdminExtListController.prototype.show, zimlets);
    } else {
        ZaApp.getInstance().getAdminExtListController().show(zimlets);
    }
}

ZaOverviewPanelController.cosListTreeListener = function(ev) {
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getCosListController(),
                ZaCosListController.prototype.show, true);
    } else {
        ZaApp.getInstance().getCosListController().show(true);
    }
    this._modifySearchMenuButton(ZaItem.COS);
}

ZaOverviewPanelController.postqTreeListener = function(ev) {
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getMTAListController(),
                ZaMTAListController.prototype.show, ZaMTA.getAll());
    } else {
        ZaApp.getInstance().getMTAListController().show(ZaServer.getAll());
    }
}

ZaOverviewPanelController.postqByServerTreeListener = function(ev) {
    var currentServer = ZaApp.getInstance().getPostQList().getItemById(
            ev.item.getData(ZaOverviewPanelController._OBJ_ID));
    if (ZaApp.getInstance().getCurrentController()) {
        ZaApp.getInstance().getCurrentController().switchToNextView(ZaApp.getInstance().getMTAController(),
                ZaMTAController.prototype.show, currentServer);
    } else {
        ZaApp.getInstance().getMTAController().show(currentServer);
    }
}

ZaOverviewPanelController.accountStatCallback = function(accountStat) {
    var childitems = this._overviewPanel.getFolderTree().getCurrentRootItem().getItems();

    for (var i = 0; i < childitems.length; i++) {
        var child = childitems[i];
        var attr = child.getData("TreeItemType");
        child.setCount(accountStat[attr]);
    }
}

ZaOverviewPanelController.manageAccountTreeListener = function(ev) {
    var types = [];
    var childitems = this._overviewPanel.getFolderTree().getCurrentRootItem().getItems();

    for (var i = 0; i < childitems.length; i++) {
        var child = childitems[i];
        if (child) {
            var type = child.getData("TreeItemType");
            if (!AjxUtil.isEmpty(type)) {
                types.push(type);
            }
        }
    }

    var callback = new AjxCallback(this, ZaOverviewPanelController.accountStatCallback);
    ZaSearch.getObjectCounts(types, callback);
}

ZaOverviewPanelController.accountListInDomainTreeListener = function(ev) {
    var domain = ev.item.getData("domainItem");
    ZaDomain.searchAccountsInDomain(domain.name);
}

ZaOverviewPanelController.memberListInDLTreeListener = function(ev) {
    var dl = ev.item.getData("dlItem");
    var members = dl[ZaDistributionList.A2_memberList];
    var query = "";
    if (members.length > 0) {
        for (var i = 0; i < members.length; i++) {
            query += "(" + ZaAccount.A_mail + "=" + members[i][ZaAccount.A_name] + ")";
        }
        if (members.length > 1)
            query = "(|" + query + ")";

        var types = [ ZaSearch.ACCOUNTS, ZaSearch.DLS, ZaSearch.ALIASES ];

        var controller = ZaApp.getInstance().getSearchListController();
        var busyId = Dwt.getNextId();
        var callback = new AjxCallback(controller, controller.searchCallback, {
            limit : controller.RESULTSPERPAGE,
            show : true,
            busyId : busyId
        });

        controller.fetchAttrs = ZaSearch.standardAttributes;

        var searchParams = {
            query : query,
            types : types,
            attrs : controller.fetchAttrs,
            callback : callback,
            controller : controller,
            showBusy : true,
            busyId : busyId,
            busyMsg : ZaMsg.BUSY_SEARCHING,
            skipCallbackIfCancelled : false
        }
        controller.setQuery(query);
        controller.setSearchTypes(types);
        ZaSearch.searchDirectory(searchParams);
    }

}

ZaOverviewPanelController.prototype.refreshAccountTree = function() {
    var targetPath = ZaMsg.OVP_home + ZaTree.SEPERATOR + ZaMsg.OVP_manageAccounts;
    var tree = this.getOverviewPanel().getFolderTree();
    var rootItem = tree.getCurrentRootItem();
    var rootPath = tree.getABPath(rootItem.getData("dataItem"));
    if (targetPath == rootPath) {
        ZaOverviewPanelController.manageAccountTreeListener.call(this);
    }
}

ZaOverviewPanelController.prototype.refreshSearchTree = function(ev) {
    var details = ev.getDetails();
    if (!details) {
        return;
    }

    var targetPath = ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_search, ZaMsg.OVP_search ]);
    var tree = this.getOverviewPanel().getFolderTree();
    var rootItem = tree.getCurrentRootItem();
    var rootPath = tree.getABPath(rootItem.getData("dataItem"));
    if (targetPath != rootPath) {
        return;
    }

    var childItems = rootItem.getItems();
    var currentSelected = tree.getCurrentSelectedItems().get(0);
    var count;
    var attr;

    if (currentSelected)
        attr = currentSelected.getData("TreeItemType");
    if (attr) {
        count = details.searchTotal;
        count = count || 0;
        currentSelected.setCount(count);
        return;
    }

    for (var i = 0; i < childItems.length; i++) {
        var child = childItems[i];
        attr = child.getData("TreeItemType");

        if (attr) {
            count = details[attr];
            count = count || 0;
            if (details.more)
                count = count + "+";
        } else {
            count = details.searchTotal || 0;
        }
        child.setCount(count);

    }
}

ZaOverviewPanelController.manageRelatedTreeListener = function(patharr, relatedZaItem) {
    var tree = this.getOverviewPanel().getFolderTree();
    if (patharr.length == 0)
        return "";
    var targetParentPath = patharr.join(ZaTree.SEPERATOR);
    var rootItem = tree.getCurrentRootItem();
    var rootPath = tree.getABPath(rootItem.getData("dataItem"));
    if (rootPath == targetParentPath) {
        var parentItemData = tree.getTreeItemDataByPath(targetParentPath);
        if (parentItemData) {
            parentItemData.addRelatedObject(this.getRelatedList(targetParentPath, relatedZaItem));
        }
        ZaOverviewPanelController.updateRelatedTreeListener.call(this, patharr);
    }
}

ZaOverviewPanelController.updateRelatedTreeListener = function(patharr) {
    var tree = this.getOverviewPanel().getFolderTree();
    if (patharr.length == 0)
        return "";
    var targetParentPath = patharr.join(ZaTree.SEPERATOR);
    var relatePath = ZaTree.SEPERATOR + ZaMsg.OVP_related;
    var showRootNode = tree.getTreeItemDataByPath(targetParentPath);
    tree.buildTree(showRootNode); //update menuitem

    var selectedItems = tree.getCurrentSelectedItems().getArray();
    var oldselectedItem = selectedItems ? selectedItems[0] : null;
    var selectedItemPath = oldselectedItem ? tree.getABPath(oldselectedItem.getData("dataItem")) : null;
    var newselectedItem = tree.getTreeItemByPath(selectedItemPath) || tree.getSelectedItem(showRootNode);
    var skipNotify = false;
    if (selectedItemPath.indexOf(targetParentPath + relatePath) == -1)
        skipNotify = true;
    tree.setSelection(newselectedItem, skipNotify);
}

ZaOverviewPanelController.prototype.refreshRelatedTree = function(items, skipCos, skipDomain, skipDL) {
    try {
        var itemArray = AjxUtil.toArray(items);
        var tempHashDomain = {};
        var tempHashCos = {};
        var tempHashDL = {};
        var tempHashAccount = {};
        var cosId, cosName, cos, domainName, domain, defaultCos, defaultCosName, dl, dlName, dlId;

        for (var i = 0; i < itemArray.length; i++) {
            var item = itemArray[i];

            if (AjxUtil.isEmpty(item))
                continue;

            if (item.type == ZaItem.ACCOUNT) {
                if (!skipCos) {
                    cos = ZaAccount.prototype.getCurrentCos.call(item);
                    cosName = cos[ZaAccount.A_name];
                    if (typeof (tempHashCos[cosName]) == "undefined") {
                        tempHashCos[cosName] = 1;
                        ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                                ZaMsg.OVP_configure, ZaMsg.OVP_cos, cosName ], cos);
                    }

                    if (typeof (tempHashCos["default"]) == "undefined") {
                        tempHashCos["default"] = 1;
                        defaultCos = ZaCos.getCosByName("default");
                        ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                                ZaMsg.OVP_configure, ZaMsg.OVP_cos, "default" ], defaultCos);
                    }

                    if (typeof (tempHashCos["defaultExternal"]) == "undefined") {
                        tempHashCos["defaultExternal"] = 1;
                        defaultCos = ZaCos.getCosByName("defaultExternal");
                        ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                                ZaMsg.OVP_configure, ZaMsg.OVP_cos, "defaultExternal" ], defaultCos);
                    }
                }//cos

            }

            if (item.type == ZaItem.ALIAS) {
                if (!skipDL) {
                    var targetObj = item.targetObj;
                    var targetName = targetObj[ZaAccount.A_name];
                    if (targetObj.type == ZaItem.ACCOUNT) {
                        if (typeof (tempHashAccount[targetName]) == "undefined") {
                            tempHashAccount[targetName] = 1;
                            targetObj.load();
                            ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                                    ZaMsg.OVP_manageAccounts, ZaMsg.OVP_accounts, targetName ], targetObj);
                        }
                    }
                    if (targetObj.type == ZaItem.DL) {
                        if (typeof (tempHashDL[targetName]) == "undefined") {
                            tempHashDL[targetName] = 1;
                            targetObj.load();
                            ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                                    ZaMsg.OVP_manageAccounts, ZaMsg.OVP_distributionLists, targetName ], targetObj);
                        }
                    }
                }
            }

            if (item.type == ZaItem.ACCOUNT) {
                if (!skipDL) {
                    if (!AjxUtil.isEmpty(item[ZaAccount.A2_memberOf])
                            && !AjxUtil.isEmpty(item[ZaAccount.A2_memberOf][ZaAccount.A2_directMemberList])) {
                        var member = item[ZaAccount.A2_memberOf][ZaAccount.A2_directMemberList];
                        for (var i = 0; i < member.length; i++) {
                            dlName = member[i][ZaAccount.A_name]
                            if (typeof (tempHashDL[dlName]) == "undefined") {
                                tempHashDL[dlName] = 1;
                                dl = new ZaDistributionList(member[i]["id"], dlName);
                                dl.load();
                                ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                                        ZaMsg.OVP_manageAccounts, ZaMsg.OVP_distributionLists, dlName ], dl);
                            }
                        }
                    }
                }
            }

            if (item.type == ZaItem.DL) {
                if (!skipDL) {
                    if (item[ZaDistributionList.A2_numMembers] > 0) {
                        ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                                ZaMsg.OVP_manageAccounts, ZaMsg.OVP_distributionLists, item.name ], item);
                    }
                }
            }

            if (!skipDomain
                    && (item.type == ZaItem.ACCOUNT || item.type == ZaItem.ALIAS || item.type == ZaItem.DL || item.type == ZaItem.RESOURCE)) { //domain
                domainName = ZaAccount.getDomain(item[ZaAccount.A_name]);
                if (typeof (tempHashDomain[domainName]) == "undefined") {
                    domain = ZaDomain.getDomainByName(domainName);
                    tempHashDomain[domainName] = 1;
                    ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                            ZaMsg.OVP_configure, ZaMsg.OVP_domains, domainName ], domain);
                }
            }

            if (item.type == ZaItem.DOMAIN) {
                if (!skipCos && item.attrs[ZaDomain.A_domainType] == ZaDomain.domainTypes.local) {
                    cosId = item.attrs[ZaDomain.A_domainDefaultCOSId];
                    cos = ZaCos.getCosById(cosId);
                    if (!cos) {
                        cos = ZaCos.getCosByName("default");
                    }
                    cosName = cos[ZaAccount.A_name];

                    if (typeof (tempHashCos[cosName]) == "undefined") {
                        tempHashCos[cosName] = 1;
                        ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                                ZaMsg.OVP_configure, ZaMsg.OVP_cos, cosName ], cos);
                    }

                    if (typeof (tempHashCos["default"]) == "undefined") {//because defaultCos search all domains
                        tempHashCos["default"] = 1;
                        defaultCos = ZaCos.getCosByName("default");
                        ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                                ZaMsg.OVP_configure, ZaMsg.OVP_cos, "default" ], defaultCos);
                    }
                } else if (!skipDomain && item.attrs[ZaDomain.A_domainType] == ZaDomain.domainTypes.alias) {
                    domainName = item.attrs[ZaDomain.A_zimbraMailCatchAllForwardingAddress];
                    domainName = domainName.replace("@", "");
                    if (typeof (tempHashDomain[domainName]) == "undefined") {
                        domain = ZaDomain.getDomainByName(domainName);
                        ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home,
                                ZaMsg.OVP_configure, ZaMsg.OVP_domains, domainName ], domain);
                    }

                }
            }
        }
    } catch (ex) {
        ZaApp.getInstance().getCurrentController()._handleException(ex,
                "ZaOverviewPanelController.prototype.refreshRelatedTree");
    }

}

ZaOverviewPanelController.prototype.refreshRelatedTreeByEdit = function(newItem) {
    try {

        if (AjxUtil.isEmpty(newItem))
            return;

        if (newItem.type == ZaItem.DL) {
            ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home, ZaMsg.OVP_manageAccounts,
                    ZaMsg.OVP_distributionLists, newItem[ZaAccount.A_name] ], newItem);
        }

        if (newItem.type == ZaItem.DOMAIN && newItem.attrs[ZaDomain.A_domainType] == ZaDomain.domainTypes.local
                && newItem.createGalAccount) {
            ZaOverviewPanelController.manageRelatedTreeListener.call(this, [ ZaMsg.OVP_home, ZaMsg.OVP_configure,
                    ZaMsg.OVP_domains, newItem[ZaAccount.A_name] ], newItem);
        }

    } catch (ex) {
        ZaApp.getInstance().getCurrentController()._handleException(ex,
                "ZaOverviewPanelController.prototype.refreshRelatedTreeByEdit");
    }
}

ZaOverviewPanelController.prototype._modifySearchMenuButton = function(itemType) {

    var searchListController = ZaApp.getInstance().getSearchListController();
    if (!searchListController || !searchListController._searchField) {
        return;
    }

    if (itemType) {
        switch (itemType) {
        case ZaItem.ACCOUNT:
            searchListController._searchField.accFilterSelected();
            break;
        case ZaItem.ALIAS:
            searchListController._searchField.aliasFilterSelected();
            break;
        case ZaItem.DL:
            searchListController._searchField.dlFilterSelected();
            break;
        case ZaItem.RESOURCE:
            searchListController._searchField.resFilterSelected();
            break;
        case ZaItem.DOMAIN:
            searchListController._searchField.domainFilterSelected();
            break;
        case ZaItem.COS:
            searchListController._searchField.cosFilterSelected();
            break;
        }
    } else {
        searchListController._searchField.allFilterSelected();
    }

}

ZaOverviewPanelController.prototype.addAccountItem = function(item, currentView) {
    var type = item.type;
    var relativePath = ZaMsg.OVP_accounts;
    if (type == ZaItem.ACCOUNT) {
        relativePath = ZaMsg.OVP_accounts;
    } else if (type == ZaItem.DL) {
        relativePath = ZaMsg.OVP_distributionLists;
    } else if (type == ZaItem.RESOURCE) {
        relativePath = ZaMsg.OVP_resources;
    } else if (type == ZaItem.ALIAS) {
        if (item.attrs[ZaAlias.A_targetType] == ZaAlias.TARGET_TYPE_ACCOUNT) {
            relativePath = ZaMsg.OVP_accounts;
        } else if (item.attrs[ZaAlias.A_targetType] == ZaAlias.TARGET_TYPE_DL) {
            relativePath = ZaMsg.OVP_distributionLists;
        } else if (item.attrs[ZaAlias.A_targetType] == ZaAlias.TARGET_TYPE_RESOURCE) {
            relativePath = ZaMsg.OVP_resources;
        }
    }

    var parentPath = ZaTree.getPathByArray([ ZaMsg.OVP_home, ZaMsg.OVP_manageAccounts, relativePath ]);
    var name = item.name;
    this.addObjectItem(parentPath, name, currentView, false, false, item, undefined, true);
}

ZaOverviewPanelController.prototype.saveBeforeExit = function(ev) {
    var currentController = ZaApp.getInstance().getCurrentController();
    if (currentController instanceof ZaXFormViewController) {
        currentController.closeButtonListener(undefined, undefined, undefined, undefined, undefined, ev.newPath);
        return false;
    }
}

ZaOverviewPanelController.prototype.addObjectItem = function(parentPath, name, currentView, skipHistory, skipNotify,
        relatedZaItem, mappingId2handlerMap, isSaveBeforeExit) {
    if (!currentView) {
        currentView = ZaApp.getInstance().getAppViewMgr().getCurrentViewContent();
        if (!currentView || !currentView.getTabChoices || !currentView.getTabChoices())
            return false;
    }

    var namePath = parentPath + ZaTree.SEPERATOR + name;
    var tree = this.getOverviewPanel().getFolderTree();
    var mappingId, handler, map;

    var needToAddNameNode = false;
    var needToAddTabNodes = false;
    var nameDataItem = tree.getTreeItemDataByPath(namePath);

    if (!nameDataItem) {
        needToAddNameNode = needToAddTabNodes = true;
    } else if (nameDataItem.getChildrenNum() <= 0) {
        needToAddTabNodes = true;
    }

    var historyObject = new ZaHistory(namePath, name, relatedZaItem ? relatedZaItem.type : null);
    ZaZimbraAdmin.getInstance().getHistoryMgr().addHistoryObj(historyObject);

    if (needToAddNameNode) {
        var parentDataItem = tree.getTreeItemDataByPath(parentPath);
        var index = parentDataItem.getChildrenNum();
        var parentId = parentDataItem.id;
        if (!mappingId2handlerMap || !(map = mappingId2handlerMap["mainNode"])) {
            //default main node(this name node) mapping relationship
            mappingId = ZaZimbraAdmin._XFORM_VIEW;
            handler = ZaOverviewPanelController.xformTreeListener;
        } else {
            mappingId = map["mappingId"];
            handler = map["handler"];
        }

        nameDataItem = new ZaTreeItemData({
            parent : parentPath,
            mappingId : mappingId,
            id : DwtId._makeId(parentId, index + 1),
            image : (relatedZaItem ? this.getIconByType(relatedZaItem.type) : null),
            defaultSelectedItem : 1,
            text : name
        });
        tree.addTreeItemData(nameDataItem);
        nameDataItem.addRelatedObject(this.getRelatedList(parentPath, relatedZaItem));
        nameDataItem.addRecentObject(this.getRecentList());
        if (isSaveBeforeExit) {
            nameDataItem.addListener(ZaTreeEvent.ONDESTROY, new AjxListener(this, this.saveBeforeExit));
        }
        ZaOverviewPanelController.overviewTreeListeners[mappingId] = handler;
    } else { //updaet relatedObject count
        nameDataItem.addRelatedObject(this.getRelatedList(parentPath, relatedZaItem));
        nameDataItem.addRecentObject(this.getRecentList());
    }

    // if (!nameDataItem.getData("viewId")) {  some view are not cached, so need to update viewId
    var currentViewId = ZaApp.getInstance().getAppViewMgr().getCurrentView();
    nameDataItem.setData("viewId", currentViewId);
    //}

    if (needToAddTabNodes) {
        if (!mappingId2handlerMap || !(map = mappingId2handlerMap["tabNodes"])) {
            //default sub tab nodes mapping relationship
            mappingId = ZaZimbraAdmin._XFORM_TAB_VIEW;
            handler = ZaOverviewPanelController.xformTabTreeListener;
        } else {
            mappingId = map["mappingId"];
            handler = map["handler"];
        }
        this.addSubTabsToParentTreeItem(nameDataItem, currentView.getTabChoices(), mappingId);
        ZaOverviewPanelController.overviewTreeListeners[mappingId] = handler;
    }

    tree.setSelectionByPath(namePath, !skipHistory, skipNotify);
    return true;
}

ZaOverviewPanelController.prototype.addSubTabsToParentTreeItem = function(parentItem, subTabs, mappingIdForAllSubTabs,
        isShowHistory) {
    var subTabItem, subTabInfo, subTabItemId;
    var tree = this.getOverviewPanel().getFolderTree();
    var parentPath = tree.getABPath(parentItem);
    var isShow = isShowHistory ? true : false;
    if (subTabs && subTabs.length > 0) {
        parentItem.setData("firstTab", subTabs[0].value);
        for (var i = 0; i < subTabs.length; i++) {
            subTabInfo = subTabs[i];
            subTabItemId = DwtId._makeId(parentItem.id, i + 1);
            subTabItem = new ZaTreeItemData({
                parent : parentPath,
                id : subTabItemId,
                isShowHistory : isShow,
                text : subTabInfo.label,
                mappingId : mappingIdForAllSubTabs
            });
            subTabItem.setData("tabValue", subTabInfo.value);
            tree.addTreeItemData(subTabItem);
        }
    }
}

ZaOverviewPanelController.xformTabTreeListener = function(ev) {
    var viewId = ev.item.parent.getData("viewId");
    var stepValue = ev.item.getData("tabValue");
    if (AjxUtil.isEmpty(viewId) || AjxUtil.isEmpty(stepValue)) {
        return;
    }

    ZaApp.getInstance().getAppViewMgr().pushView(viewId);
    var currentView = ZaApp.getInstance().getAppViewMgr().getViewContentById(viewId);
    if (AjxUtil.isEmpty(currentView)) {
        return;
    }

    if (ev.refresh && !AjxUtil.isEmpty(currentView._localXForm)) {
        var currentObject = currentView._localXForm.getInstance();
        if (currentObject && currentObject.refresh) {
            currentObject.refresh(false, true);
            currentView.setObject(currentObject);
        }
    }
    if (!AjxUtil.isEmpty(currentView._localXForm)) { //some views of zimlets are created by dwt
        currentView._localXForm.setInstanceValue(stepValue, ZaModel.currentTab);
    }

}

ZaOverviewPanelController.xformTreeListener = function(ev) {
    var viewId = ev.item.getData("viewId");
    var stepValue = ev.item.getData("firstTab");
    if (AjxUtil.isEmpty(viewId) || AjxUtil.isEmpty(stepValue)) {
        return;
    }

    ZaApp.getInstance().getAppViewMgr().pushView(viewId);
    var currentView = ZaApp.getInstance().getAppViewMgr().getViewContentById(viewId);
    if (AjxUtil.isEmpty(currentView)) {
        return;
    }

    if (ev.refresh && !AjxUtil.isEmpty(currentView._localXForm)) {
        var currentObject = currentView._localXForm.getInstance();
        if (currentObject && currentObject.refresh) {
            currentObject.refresh(false, true);
            currentView.setObject(currentObject);
        }
    }

    if (!AjxUtil.isEmpty(currentView._localXForm)) { //some views of zimlets are created by dwt
        currentView._localXForm.setInstanceValue(stepValue, ZaModel.currentTab);
    }
}

ZaOverviewPanelController.prototype.getRelatedList = function(parentPath, item) {
    if (!item || !item.getRelatedList)
        return [];

    return item.getRelatedList(parentPath);
}

ZaOverviewPanelController.prototype.getRecentList = function() {
    var historyMgr = ZaZimbraAdmin.getInstance().getHistoryMgr();
    var objList = historyMgr.getAllHistoryObj().getArray();
    var Tis = [];
    var ti = null;
    var image = null;
    for (var i = objList.length - 1; i > -1; i--) {

        image = this.getIconByType(objList[i].type);
        ti = new ZaTreeItemData({
            text : objList[i].displayName,
            type : 1,
            image : image,
            isShowHistory : false,
            forceNode : (i + 1 != objList.length),
            path : objList[i].path
        });
        Tis.push(ti);
    }
    return Tis;
}

ZaOverviewPanelController.prototype.getIconByType = function(type) {
    var image = null;
    if (type == ZaItem.ACCOUNT)
        image = "Account";
    else if (type == ZaItem.COS)
        image = "COS";
    else if (type == ZaItem.DOMAIN)
        image = "Domain";
    else if (type == ZaItem.RESOURCE)
        image = "Resource";
    else if (type == ZaItem.DL)
        image = "DistributionList";
    else if (type == ZaItem.ALIAS)
        image = "AccountAlias";
    else if (type == ZaItem.SERVER)
        image = "Server";
    else if (type == ZaItem.RIGHT)
        image = "RightObject";

    return image;
}
}
if (AjxPackage.define("zimbraAdmin.common.ZaOperation")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaOperation
* @contructor
* simplified version of ZmOperation
* This class encapsulates the properties of an action that can be taken on some item: image, caption, description, AjxListener
* @param caption string
* @param tt string
* @param img string path to image
* @param lsnr AjxListener
**/

ZaOperation = function(id, caption, tooltip, imgId, disImgId, lsnr, type, menuOpList, className, labelId) {
	this.id = id;
	this.caption = caption;
	this.tt = tooltip;
	this.listener = lsnr;
	this.imageId = imgId;
	this.disImageId = disImgId;
	this.type = (type == null)? ZaOperation.TYPE_BUTTON: type;
	this.menuOpList = menuOpList;
	this.className = className;	
	this.labelId = labelId;
	this.enabled = true;
	this.visible = true;
}

ZaOperation.prototype.toString = 
function() {
		return "ZaOperation";
}

ZaOperation.prototype.setEnabled = function (enabled) {
    this.enabled = enabled ;
}

ZaOperation.prototype.setVisible = function (visible) {
    this.visible = visible ;
}

ZaOperation.duplicate = function (oldInstance) {
    var id = oldInstance.id;
	var caption = oldInstance.caption;
	var tooltip = oldInstance.tt ;
	var lsnr = oldInstance.listener ;
	var imgId = oldInstance.imageId ;
	var disImgId = oldInstance.disImageId ;
	var type = oldInstance.type;
	var menuOpList = oldInstance.menuOpList;
	var className = oldInstance.className;
	var labelId = oldInstance.labelId;
    
    var newOp = new ZaOperation (id, caption, tooltip, imgId, disImgId, lsnr, type, menuOpList, className, labelId);

    return newOp ;
}

// types
ZaOperation.TYPE_BUTTON = 1;
ZaOperation.TYPE_MENU = 2;
ZA_OP_INDEX = 0;

// Operations
ZaOperation.NONE = ++ZA_OP_INDEX;		// no operations or menu items
ZaOperation.SEP = ++ZA_OP_INDEX;		// separator
ZaOperation.NEW = ++ZA_OP_INDEX;
ZaOperation.DELETE = ++ZA_OP_INDEX;
ZaOperation.REFRESH = ++ZA_OP_INDEX;
ZaOperation.EDIT = ++ZA_OP_INDEX;
ZaOperation.CHNG_PWD = ++ZA_OP_INDEX;
ZaOperation.CLOSE = ++ZA_OP_INDEX;
ZaOperation.SAVE = ++ZA_OP_INDEX;
ZaOperation.NEW_WIZARD = ++ZA_OP_INDEX;
ZaOperation.NEW_ALIAS = ++ZA_OP_INDEX;
ZaOperation.NEW_DL = ++ZA_OP_INDEX;
ZaOperation.NEW_RESOURCE = ++ZA_OP_INDEX;
ZaOperation.NEW_ADMIN = ++ZA_OP_INDEX;
ZaOperation.PAGE_FORWARD = ++ZA_OP_INDEX;
ZaOperation.PAGE_BACK = ++ZA_OP_INDEX;
ZaOperation.DUPLICATE = ++ZA_OP_INDEX;
ZaOperation.GAL_WIZARD = ++ZA_OP_INDEX;
ZaOperation.AUTH_WIZARD =++ZA_OP_INDEX;
ZaOperation.AUTOPROV_WIZARD =++ZA_OP_INDEX;
ZaOperation.VIEW_MAIL =++ZA_OP_INDEX;
ZaOperation.MOVE_ALIAS = ++ZA_OP_INDEX;
ZaOperation.NEW_MENU = ++ZA_OP_INDEX;
ZaOperation.HELP = ++ZA_OP_INDEX;
ZaOperation.REINDEX_MAILBOX = ++ZA_OP_INDEX;
ZaOperation.LABEL = ++ZA_OP_INDEX;
ZaOperation.VIEW = ++ZA_OP_INDEX;
ZaOperation.SEARCH_ACCOUNTS = ++ZA_OP_INDEX;
ZaOperation.SEARCH_ALIASES = ++ZA_OP_INDEX;
ZaOperation.SEARCH_DLS = ++ZA_OP_INDEX;
ZaOperation.SEARCH_DOMAINS = ++ZA_OP_INDEX;
ZaOperation.SEARCH_RESOURCES = ++ZA_OP_INDEX;
ZaOperation.SEARCH_COSES = ++ZA_OP_INDEX;
ZaOperation.SEARCH_ALL = ++ZA_OP_INDEX;
ZaOperation.FLUSH = ++ZA_OP_INDEX;
ZaOperation.HOLD = ++ZA_OP_INDEX;
ZaOperation.REQUEUE = ++ZA_OP_INDEX;
ZaOperation.RELEASE = ++ZA_OP_INDEX;
ZaOperation.INIT_NOTEBOOK = ++ZA_OP_INDEX;
ZaOperation.CHECK_MX_RECORD = ++ZA_OP_INDEX;
ZaOperation.SEARCH_RESULT_COUNT = ++ZA_OP_INDEX;
ZaOperation.SEARCH_BY_ADDESS_TYPE = ++ZA_OP_INDEX;
ZaOperation.SEARCH_BY_DOMAIN = ++ZA_OP_INDEX;
ZaOperation.SEARCH_BY_SERVER = ++ZA_OP_INDEX;
ZaOperation.SEARCH_BY_BASIC =  ++ZA_OP_INDEX;
ZaOperation.SEARCH_BY_REMOVE_ALL =  ++ZA_OP_INDEX;
ZaOperation.SEARCH_BY_ADVANCED = ++ZA_OP_INDEX;
ZaOperation.SEARCH_BY_COS = ++ZA_OP_INDEX;
ZaOperation.DEPLOY_ZIMLET =  ++ZA_OP_INDEX;
//ZaOperation.ENABLE_ZIMLET =  ++ZA_OP_INDEX;
//ZaOperation.DISABLE_ZIMLET =  ++ZA_OP_INDEX;
ZaOperation.CLOSE_TAB = ++ZA_OP_INDEX;
ZaOperation.CLOSE_OTHER_TAB = ++ZA_OP_INDEX;
ZaOperation.CLOSE_ALL_TAB = ++ZA_OP_INDEX;
ZaOperation.TOGGLE = ++ZA_OP_INDEX;
ZaOperation.DOWNLOAD_SERVER_CONFIG = ++ZA_OP_INDEX;
ZaOperation.DOWNLOAD_GLOBAL_CONFIG = ++ZA_OP_INDEX;
ZaOperation.VIEW_DOMAIN_ACCOUNTS = ++ZA_OP_INDEX;
ZaOperation.FLUSH_CACHE = ++ZA_OP_INDEX;
ZaOperation.MORE_ACTIONS = ++ZA_OP_INDEX;  
ZaOperation.EXPIRE_SESSION = ++ZA_OP_INDEX;
ZaOperation.ADD_DOMAIN_ALIAS = ++ZA_OP_INDEX;
ZaOperation.INSTALL_DOMAIN_CERT = ++ZA_OP_INDEX;
ZaOperation.LOGOFF = ++ZA_OP_INDEX;
// For Appliance
ZaOperation.LEFT_BRACKET = ++ZA_OP_INDEX;
ZaOperation.RIGHT_BRACKET = ++ZA_OP_INDEX;


var ZaOpList = [
	"UNKNOWN",
	"NONE",
	"SEP",
	"NEW",
	"DELETE",
	"REFRESH",
	"EDIT",
	"CHNG_PWD",
	"CLOSE",
	"SAVE",
	"NEW_ACCT",
	"NEW_ALIAS",
	"NEW_DL",
	"NEW_RESOURCE",
	"NEW_ADMIN",
	"PAGE_FORWARD",
	"PAGE_BACK",
	"DUPLICATE",
	"GAL_WIZARD",
	"AUTH_WIZARD",
    "AUTOPROV_WIZARD",
	"VIEW_MAIL",
	"MOVE_ALIAS",
	"NEW_MENU",
	"HELP",
	"REINDEX_MAILBOX",
	"LABEL",
	"VIEW",
	"SEARCH_ACCOUNTS",
	"SEARCH_ALIASES",
	"SEARCH_DLS",
	"SEARCH_DOMAINS",
	"SEARCH_RESOURCES",
	"SEARCH_COSES",
	"SEARCH_ALL",
	"FLUSH",
	"HOLD",
	"REQUEUE",
	"RELEASE",
	"INIT_NOTEBOOK",
	"CHECK_MX_RECORD",
	"SEARCH_RESULT_COUNT",
	"SEARCH_BY_ADDESS_TYPE",
	"SEARCH_BY_DOMAIN",
	"SEARCH_BY_SERVER",
	"SEARCH_BY_BASIC" ,
	"SEARCH_BY_REMOVE_ALL" ,
	"SEARCH_BY_ADVANCED",
	"SEARCH_BY_COS",
	"DEPLOY_ZIMLET" ,
	"CLOSE_TAB",
	"CLOSE_OTHER_TAB",
	"CLOSE_ALL_TAB",
	"TOGGLE",
	"DOWNLOAD_SERVER_CONFIG",
	"DOWNLOAD_GLOBAL_CONFIG",
	"VIEW_DOMAIN_ACCOUNTS",
	"FLUSH_CACHE",
	"MORE_ACTIONS",
	"EXPIRE_SESSION",
	"ADD_DOMAIN_ALIAS",
	"INSTALL_DOMAIN_CERT",
    "LOGOFF",
    "LEFT_BRACKET",
    "RIGHT_BRACKET"
	/* other operation name */
];


ZaOperation.getStringName =
function(index) {
	if(index < 0 || index >= ZaOpList.length) {
		return "UNKNOWN_" +index;
	}
	return ZaOpList[index];
}

}
if (AjxPackage.define("zimbraAdmin.home.controller.ZaHomeController")) {
/**
 * Created by IntelliJ IDEA.
 * User: mingzhang
 * Date: 8/26/11
 * Time: 3:47 AM
 * To change this template use File | Settings | File Templates.
 */
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaHomeController
* @contructor ZaHomeController
* @param appCtxt
* @param container
* @author Ming Zhang
**/
ZaHomeController = function(appCtxt, container) {
	ZaXFormViewController.call(this, appCtxt, container,"ZaHomeController");
	this._UICreated = false;
	this.objType = ZaEvent.S_HOME;
	this.tabConstructor = ZaHomeXFormView;
}

ZaHomeController.prototype = new ZaXFormViewController();
ZaHomeController.prototype.constructor = ZaHomeController;

ZaHomeController.prototype.toString = function () {
	return "ZaHomeController";
};

ZaApp.prototype.getHomeViewController =
function(viewId) {
	if(!viewId)
		viewId = ZaZimbraAdmin._HOME_VIEW;

	if (viewId && this._controllers[viewId] != null) {
		return this._controllers[viewId];
	}else{
		var c  = this._controllers[viewId] = new ZaHomeController(this._appCtxt, this._container, this);
		return c ;
	}
}

ZaHomeController.prototype.show =
function(entry) {
    if (!this._UICreated)  {
        this._contentView = this._view = new this.tabConstructor(this._container, entry);
        var elements = new Object();
        elements[ZaAppViewMgr.C_APP_CONTENT] = this._view;

        ZaApp.getInstance().getAppViewMgr().createView(this.getContentViewId(), elements) ;
        ZaApp.getInstance()._controllers[this.getContentViewId()] = this ;
        this._UICreated = true;
    }

    entry = new ZaHome();
    entry.load("", "", true);
    entry[ZaModel.currentTab] = "1";
    entry[ZaModel.currentStep] = 1;
    this._currentObject = entry;
    this._view.setObject(entry);
    ZaApp.getInstance().pushView(this.getContentViewId()) ;
    entry.schedulePostLoading();
}

ZaHomeController.prototype.setInstanceValue =
function (value, ref) {
    var xformView = this._view._localXForm;
    xformView.setInstanceValue (value, ref);
}

ZaHomeController.prototype.showWarningPanel =
function() {
    var xformView = this._view._localXForm;
    if (xformView.getInstanceValue(ZaHome.A2_showWarningPanel) != true) {
        xformView.setInstanceValue(true, ZaHome.A2_showWarningPanel);
    }
}

ZaHomeController.prototype.getAppBarAction =
function () {
    if (AjxUtil.isEmpty(this._appbarOperation)) {
    	this._appbarOperation[ZaOperation.HELP]=new ZaOperation(ZaOperation.HELP,ZaMsg.TBB_Help, ZaMsg.TBB_Help_tt, "Help", "Help", new AjxListener(this, this._helpButtonListener));
    }

    return this._appbarOperation;
}

ZaHomeController.prototype.getAppBarOrder =
function () {
    if (AjxUtil.isEmpty(this._appbarOrder)) {
    	this._appbarOrder.push(ZaOperation.HELP);
    }

    return this._appbarOrder;
}
}
if (AjxPackage.define("zimbraAdmin.accounts.controller.ZaAccountListController")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @constructor
* @class ZaAccountListController This is a singleton class that controls all the user interaction with the list of ZaAccount objects
* @param appCtxt
* @param container
* @param app
* @extends ZaController
* @author Roland Schemers
* @author Greg Solovyev
**/
ZaAccountListController = function(appCtxt, container) {
	ZaListViewController.call(this, appCtxt, container, "ZaAccountListController");
    //Account operations
   	this._popupOperations = new Object();			
   	
	this._currentPageNum = 1;
	this._currentQuery = null;
	this._currentSortField = ZaAccount.A_uid;
	this._currentSortOrder = "1";
	this.searchTypes = [ZaSearch.ALIASES,ZaSearch.DLS,ZaSearch.ACCOUNTS, ZaSearch.RESOURCES];
	this.pages = new Object();
	this._searchPanel = null;
	this._searchField = null;                                          
	this._defaultType = ZaItem.ACCOUNT;
	this._helpURL = ZaAccountListController.helpURL;
	this._helpButtonText = ZaMsg.helpManageAccounts;
	this.objType = ZaEvent.S_ACCOUNT;	
	this.fetchAttrs = ZaSearch.standardAttributes;
}

ZaAccountListController.prototype = new ZaListViewController();
ZaAccountListController.helpURL = location.pathname + ZaUtil.HELP_URL + "managing_accounts/provisioning_accounts.htm?locid="+AjxEnv.DEFAULT_LOCALE;
ZaController.initPopupMenuMethods["ZaAccountListController"] = new Array();
ZaController.changeActionsStateMethods["ZaAccountListController"] = new Array();


/**
* Shows the view
* @param {Boolean}		refresh				bypass the cache
*/
ZaAccountListController.prototype.show = function (doPush, refresh) {
	if (doPush && !refresh) {
		var list = this._contentView && this._contentView.getList();
		if (list) {
			return this._show(list, false, false, this._contentView.scrollHasMore);
		}
	}
	var busyId = Dwt.getNextId();
	var callback = new AjxCallback(this, this.searchCallback, {limit:this.RESULTSPERPAGE,CONS:null,show:doPush,busyId:busyId});

	// hide the system account
	this._currentQuery = "(&" + this._currentQuery + "(!("+ ZaAccount.A_zimbraIsSystemAccount +"=TRUE)))"	
	var searchParams = {
		query: this._currentQuery,
		types: this.searchTypes,
		sortBy: this._currentSortField,
		offset: this.RESULTSPERPAGE * (this._currentPageNum - 1),
		sortAscending: this._currentSortOrder,
		limit: this.RESULTSPERPAGE,
		maxResults: 0,
		attrs: [
			this.fetchAttrs,
			ZaAccount.A_zimbraIsDelegatedAdminAccount,
			ZaAccount.A_zimbraIsAdminAccount,
			ZaAccount.A_zimbraIsSystemResource,
			ZaAccount.A_zimbraIsSystemAccount,
			ZaAccount.A_zimbraIsExternalVirtualAccount
		].join(),
		callback: callback,
		controller: this,
		showBusy: true,
		busyId: busyId,
		busyMsg: ZaMsg.BUSY_SEARCHING,
		skipCallbackIfCancelled: false,
		isInitialRequest: true
    };

	this.scrollSearchParams = {
        query: this._currentQuery,
        types: this.searchTypes,
        sortBy: this._currentSortField,
        sortAscending: this._currentSortOrder,
        attrs: [
            this.fetchAttrs,
            ZaAccount.A_zimbraIsDelegatedAdminAccount,
            ZaAccount.A_zimbraIsAdminAccount,
            ZaAccount.A_zimbraIsSystemResource,
            ZaAccount.A_zimbraIsSystemAccount,
            ZaAccount.A_zimbraIsExternalVirtualAccount
        ].join(),
        controller: this,
        showBusy: true,
        busyMsg: ZaMsg.BUSY_SEARCHING,
        skipCallbackIfCancelled: false
    };

    ZaSearch.searchDirectory(searchParams);
}

ZaAccountListController.prototype._show = 
function (list, openInNewTab, openInSearchTab, hasMore) {
	this._updateUI(list, openInNewTab, openInSearchTab, hasMore);
    this.updatePopupMenu();
	ZaApp.getInstance().pushView(this.getContentViewId (), openInNewTab, openInSearchTab);
    return;
}


ZaAccountListController.prototype.setDefaultType = function (type) {
	// set the default type,
	this._defaultType = type;
	if(type==ZaItem.ACCOUNT) {
		this._helpURL = location.pathname + ZaUtil.HELP_URL + "managing_accounts/provisioning_accounts.htm?locid="+AjxEnv.DEFAULT_LOCALE;
	} else if(type == ZaItem.ALIAS) {
        this._helpURL = location.pathname + ZaUtil.HELP_URL + "managing_accounts/creating_a_mail_aliases.htm?locid=" + AjxEnv.DEFAULT_LOCALE;
		//this._helpURL = location.pathname + ZaUtil.HELP_URL + "managing_accounts/creating_a_mail_aliases.htm?locid="+AjxEnv.DEFAULT_LOCALE;
	} else if(type == ZaItem.DL) {
        this._helpURL = location.pathname + ZaUtil.HELP_URL + "managing_accounts/distribution_lists.htm?locid=" + AjxEnv.DEFAULT_LOCALE;
        //this._helpURL = location.pathname + ZaUtil.HELP_URL + "managing_accounts/distribution_lists.htm?locid="+AjxEnv.DEFAULT_LOCALE;
	} else if(type == ZaItem.RESOURCE) {
        this._helpURL = location.pathname + ZaUtil.HELP_URL + "managing_accounts/managing_resource.htm?locid=" + AjxEnv.DEFAULT_LOCALE;
		//this._helpURL = location.pathname + ZaUtil.HELP_URL + "managing_accounts/managing_resource.htm?locid="+AjxEnv.DEFAULT_LOCALE;
	}
	
};

ZaAccountListController.prototype.updatePopupMenu =
function () {

	var type = this._defaultType ;
    if (type == ZaItem.ACCOUNT && this.showNewAccount) {
        this._popupOperations[ZaOperation.NEW_MENU] = new ZaOperation(ZaOperation.NEW_MENU, ZaMsg.TBB_New, ZaMsg.ACTBB_New_tt, "NewAccount", "AccountDis",new AjxListener(this, ZaAccountListController.prototype._newAccountListener));
    } else if (type == ZaItem.ALIAS && this.showNewAlias) {
        this._popupOperations[ZaOperation.NEW_MENU] = new ZaOperation(ZaOperation.NEW_MENU, ZaMsg.TBB_New, ZaMsg.ALTBB_New_tt, "AccountAlias", "AccountDis",new AjxListener(this, ZaAccountListController.prototype._newAliasListener));
    } else if (type == ZaItem.DL && this.showNewDL) {
        this._popupOperations[ZaOperation.NEW_MENU] = new ZaOperation(ZaOperation.NEW_MENU, ZaMsg.TBB_New, ZaMsg.ALTBB_New_tt, "DistributionList", "DistributionListDis",new AjxListener(this, ZaAccountListController.prototype._newDistributionListListener));
    } else if (type == ZaItem.RESOURCE && this.showNewCalRes){
        this._popupOperations[ZaOperation.NEW_MENU] = new ZaOperation(ZaOperation.NEW_MENU, ZaMsg.TBB_New, ZaMsg.ALTBB_New_tt, "Resource", "ResourceDis",new AjxListener(this, ZaAccountListController.prototype._newResourceListener));
    }
}

ZaAccountListController.prototype.handleRemoval =
function(ev) {
    ZaZimbraAdmin.getInstance().getOverviewPanelController().refreshAccountTree();
    ZaListViewController.prototype.handleRemoval.call(this,ev);
}

ZaAccountListController.prototype.handleCreation =
function(ev) {
    ZaZimbraAdmin.getInstance().getOverviewPanelController().refreshAccountTree();
    ZaListViewController.prototype.handleCreation.call(this,ev);
}

ZaAccountListController.prototype.set = 
function(accountList) {
	this.show(accountList);
}

ZaAccountListController.prototype.setPageNum = 
function (pgnum) {
	this._currentPageNum = Number(pgnum);
}

ZaAccountListController.prototype.getPageNum = 
function () {
	return this._currentPageNum;
}

ZaAccountListController.prototype.getTotalPages = 
function () {
	return this.numPages;
}

ZaAccountListController.prototype.setFetchAttrs = 
function (fetchAttrs) {
	this.fetchAttrs = fetchAttrs;
}

ZaAccountListController.prototype.getFetchAttrs = 
function () {
	return this.fetchAttrs;
}

ZaAccountListController.prototype.setQuery = 
function (query) {
	this._currentQuery = query;
}

ZaAccountListController.prototype.getQuery = 
function () {
	return this._currentQuery;
}

ZaAccountListController.prototype.setSearchTypes = 
function (searchTypes) {
	this.searchTypes = searchTypes;
}

ZaAccountListController.prototype.getSearchTypes = 
function () {
	return this.searchTypes;
}

ZaAccountListController.prototype.setSortOrder = 
function (sortOrder) {
	if(sortOrder===true)
		this._currentSortOrder = "1";
	else if(sortOrder===false)
		this._currentSortOrder = "0";
	else
		this._currentSortOrder = sortOrder;
}

ZaAccountListController.prototype.getSortOrder = 
function () {
	return this._currentSortOrder;
}

ZaAccountListController.prototype.setSortField = 
function (sortField) {
	this._currentSortField = sortField;
}

ZaAccountListController.prototype.getSortField = 
function () {
	return this._currentSortField;
}



ZaAccountListController.initPopupMenuMethod =
function () {
	this.showNewAccount = false;
	this.showNewDL = false;
	this.showNewCalRes = false;
	this.showNewAlias = false;
	if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE') {
		this.showNewAccount = true;
		this.showNewDL = true;
		this.showNewCalRes = true;
		this.showNewAlias = true;
	} else {
		this.showNewAccount = ZaZimbraAdmin.canCreateAccount();   
				
		this.showNewCalRes = ZaZimbraAdmin.canCreateCalRes;
		
		this.showNewDL = ZaZimbraAdmin.canCreateDL();
		
		this.showNewAlias = ZaZimbraAdmin.canCreateAlias();
	}
	
    //push it firstly to make it as the first one
	if(this.showNewAccount && this._defaultType == ZaItem.ACCOUNT) {
		this._popupOperations[ZaOperation.NEW_MENU] = new ZaOperation(ZaOperation.NEW_MENU, ZaMsg.TBB_New, ZaMsg.ACTBB_New_tt, "NewAccount", "AccountDis",new AjxListener(this, ZaAccountListController.prototype._newAccountListener));;
	} else if(this.showNewCalRes && this._defaultType == ZaItem.RESOURCE) {
		this._popupOperations[ZaOperation.NEW_MENU] = new ZaOperation(ZaOperation.NEW_MENU, ZaMsg.TBB_New, ZaMsg.ALTBB_New_tt, "Resource", "ResourceDis",new AjxListener(this, ZaAccountListController.prototype._newResourceListener));
	} else if(this.showNewDL && this._defaultType == ZaItem.DL) {
		this._popupOperations[ZaOperation.NEW_MENU] = new ZaOperation(ZaOperation.NEW_MENU, ZaMsg.TBB_New, ZaMsg.ALTBB_New_tt, "DistributionList", "DistributionListDis",new AjxListener(this, ZaAccountListController.prototype._newDistributionListListener));
	} else if(this.showNewAlias && this._defaultType == ZaItem.ALIAS) {
		this._popupOperations[ZaOperation.NEW_MENU] = new ZaOperation(ZaOperation.NEW_MENU, ZaMsg.TBB_New, ZaMsg.ALTBB_New_tt, "AccountAlias", "AccountDis",new AjxListener(this, ZaAccountListController.prototype._newAliasListener));
	}
	if(this.showNewAccount || this.showNewCalRes || this.showNewDL || this.showNewAlias) {
		this._popupOrder.push(ZaOperation.NEW_MENU);
	}

    this._popupOperations[ZaOperation.EDIT] = new ZaOperation(ZaOperation.EDIT, ZaMsg.TBB_Edit, ZaMsg.ACTBB_Edit_tt, "Edit", "EditDis", new AjxListener(this, ZaAccountListController.prototype._editButtonListener));
    this._popupOrder.push(ZaOperation.EDIT);

	this._popupOperations[ZaOperation.DELETE] = new ZaOperation(ZaOperation.DELETE, ZaMsg.TBB_Delete, ZaMsg.ACTBB_Delete_tt, "Delete", "DeleteDis", new AjxListener(this, ZaAccountListController.prototype._deleteButtonListener));
    this._popupOrder.push(ZaOperation.DELETE);

	if(this._defaultType == ZaItem.ACCOUNT) {
		this._popupOperations[ZaOperation.CHNG_PWD] = new ZaOperation(ZaOperation.CHNG_PWD, ZaMsg.ACTBB_ChngPwd, ZaMsg.ACTBB_ChngPwd_tt, "Padlock", "PadlockDis", new AjxListener(this, ZaAccountListController.prototype._chngPwdListener));
		this._popupOperations[ZaOperation.EXPIRE_SESSION] = new ZaOperation(ZaOperation.EXPIRE_SESSION, ZaMsg.ACTBB_ExpireSessions, ZaMsg.ACTBB_ExpireSessions_tt, "ExpireSession", "ExpireSessionDis", new AjxListener(this, ZaAccountListController.prototype._expireSessionListener));
        this._popupOrder.push(ZaOperation.CHNG_PWD);
        this._popupOrder.push(ZaOperation.EXPIRE_SESSION);
	}

	if(this._defaultType == ZaItem.ALIAS) {	
		this._popupOperations[ZaOperation.MOVE_ALIAS] = new ZaOperation(ZaOperation.MOVE_ALIAS, ZaMsg.ACTBB_MoveAlias, ZaMsg.ACTBB_MoveAlias_tt, "MoveAlias", "MoveAlias", new AjxListener(this, ZaAccountListController.prototype._moveAliasListener));
		this._popupOperations[ZaOperation.EXPIRE_SESSION] = new ZaOperation(ZaOperation.EXPIRE_SESSION, ZaMsg.ACTBB_ExpireSessions, ZaMsg.ACTBB_ExpireSessions_tt, "ExpireSession", "ExpireSessionDis", new AjxListener(this, ZaAccountListController.prototype._expireSessionListener));
        this._popupOrder.push(ZaOperation.MOVE_ALIAS);
        this._popupOrder.push(ZaOperation.EXPIRE_SESSION);
	}
}
ZaController.initPopupMenuMethods["ZaAccountListController"].push(ZaAccountListController.initPopupMenuMethod);


//private and protected methods
ZaAccountListController.prototype._createUI = 
function (openInNewTab, openInSearchTab) {
	//create accounts list view
	// create the menu operations/listeners first	
	this._contentView = new ZaAccountListView(this._container, this._defaultType);
	ZaApp.getInstance()._controllers[this.getContentViewId ()] = this ;
	
	this._newDLListener = new AjxListener(this, ZaAccountListController.prototype._newDistributionListListener);
	this._newAcctListener = new AjxListener(this, ZaAccountListController.prototype._newAccountListener);
	this._newResListener = new AjxListener(this, ZaAccountListController.prototype._newResourceListener);
	this._newALListener = new AjxListener(this, ZaAccountListController.prototype._newAliasListener);
   
	//always add Help and navigation buttons at the end of the toolbar    
	//add the acount number counts
	
	var elements = new Object();
	elements[ZaAppViewMgr.C_APP_CONTENT] = this._contentView;
    ZaApp.getInstance().getAppViewMgr().createView(this.getContentViewId(), elements);
	
	this._initPopupMenu();
	this._actionMenu =  new ZaPopupMenu(this._contentView, "ActionMenu", null, this._popupOperations, ZaId.VIEW_ACCTLIST, ZaId.MENU_POP);
	
	//set a selection listener on the account list view
	this._contentView.addSelectionListener(new AjxListener(this, this._listSelectionListener));
	this._contentView.addActionListener(new AjxListener(this, this._listActionListener));			
	if(!ZaApp.getInstance().dialogs["ConfirmMessageDialog"]) {
		ZaApp.getInstance().dialogs["ConfirmMessageDialog"] = new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.YES_BUTTON, DwtDialog.NO_BUTTON], null, ZaId.CTR_PREFIX + ZaId.VIEW_ACCTLIST + "_ConfirmMessage");			
	}
	this._UICreated = true;
	
}

ZaAccountListController.prototype.closeButtonListener =
function(ev, noPopView, func, obj, params) {
	if (noPopView) {
		func.call(obj, params) ;
	}else{
		ZaApp.getInstance().popView () ;
	}
}

// new account button was pressed
ZaAccountListController.prototype._newAccountListener =
function(ev) {

	try {
		EmailAddr_XFormItem.resetDomainLists.call(this) ;
		var newAccount = new ZaAccount();
		newAccount.loadNewObjectDefaults("name", ZaSettings.myDomainName);
        newAccount.rights[ZaAccount.GET_ACCOUNT_MEMBERSHIP_RIGHT]= true;
		
		if(!ZaApp.getInstance().dialogs["newAccountWizard"]) {
			ZaApp.getInstance().dialogs["newAccountWizard"] = new ZaNewAccountXWizard(this._container,newAccount);	
		} else { //update the account type if needed
            ZaApp.getInstance().dialogs["newAccountWizard"].updateAccountType () ;    
        }

		ZaApp.getInstance().dialogs["newAccountWizard"].setObject(newAccount);
		ZaApp.getInstance().dialogs["newAccountWizard"].popup();
	} catch (ex) {
		this._handleException(ex, "ZaAccountListController.prototype._newAccountListener", null, false);
	}
}

// new alias button was pressed
ZaAccountListController.prototype._newAliasListener =
function(ev) {
	try {
		EmailAddr_XFormItem.resetDomainLists.call(this) ;
		var newAlias = new ZaAlias();
		newAlias.getAttrs = {all:true};
		newAlias.setAttrs = {all:true};		
		newAlias._defaultValues = {attrs:{}};
		newAlias.rights = {};
		//newAlias.loadNewObjectDefaults("name", ZaSettings.myDomainName);
		if(!ZaApp.getInstance().dialogs["newAliasDialog"]) {
			ZaApp.getInstance().dialogs["newAliasDialog"] = new ZaNewAliasXDialog(
				this._container, "550px", "100px",ZaMsg.New_Alias_Title );	
			ZaApp.getInstance().dialogs["newAliasDialog"].registerCallback(
					DwtDialog.OK_BUTTON, ZaAlias.prototype.addAlias, 
					newAlias, ZaApp.getInstance().dialogs["newAliasDialog"]._localXForm );
		}

		ZaApp.getInstance().dialogs["newAliasDialog"].setObject(newAlias);
		ZaApp.getInstance().dialogs["newAliasDialog"].popup();
	} catch (ex) {
		this._handleException(ex, "ZaAccountListController.prototype._newAliasListener", null, false);
	}
}


ZaAccountListController.prototype._newDistributionListListener =
function(ev) {
	try {
		EmailAddr_XFormItem.resetDomainLists.call (this);
		var newDL = new ZaDistributionList();
		//newDL.getAttrs = {all:true};
		//newDL.setAttrs = {all:true};
		newDL.rights = {};
		newDL._defaultValues = {attrs:{}};
		newDL.loadNewObjectDefaults("name", ZaSettings.myDomainName);	
		newDL.rights[ZaDistributionList.RENAME_DL_RIGHT]=true;
		newDL.rights[ZaDistributionList.REMOVE_DL_MEMBER_RIGHT]=true;
		newDL.rights[ZaDistributionList.ADD_DL_MEMBER_RIGHT]=true;
        newDL.rights[ZaDistributionList.GET_DL_MEMBERSHIP_RIGHT] = true;
        if(!ZaApp.getInstance().dialogs["newDLWizard"]) {
		    ZaApp.getInstance().dialogs["newDLWizard"] = new ZaNewDLXWizard(this._container,newDL);
        }
	    ZaApp.getInstance().dialogs["newDLWizard"].setObject(newDL);
	    ZaApp.getInstance().dialogs["newDLWizard"].popup();

	} catch (ex) {
		this._handleException(ex, "ZaAccountListController.prototype._newDistributionListListener", null, false);
	}

};

ZaAccountListController.prototype._newResourceListener =
function(ev) {
	try {
		EmailAddr_XFormItem.resetDomainLists.call (this);
		var newResource = new ZaResource();
		//newResource.getAttrs = {all:true};
		//newResource._defaultValues = {attrs:{}};	
		newResource.loadNewObjectDefaults("name", ZaSettings.myDomainName);	
		if(!ZaApp.getInstance().dialogs["newResourceWizard"])
			ZaApp.getInstance().dialogs["newResourceWizard"] = new ZaNewResourceXWizard(this._container);	

		ZaApp.getInstance().dialogs["newResourceWizard"].setObject(newResource);
		ZaApp.getInstance().dialogs["newResourceWizard"].popup();
	} catch (ex) {
		this._handleException(ex, "ZaAccountListController.prototype._newResourceListener", null, false);
	}
}


/**
* This listener is called when the item in the list is double clicked. It call ZaAccountViewController.show method
* in order to display the Account View
**/
ZaAccountListController.prototype._listSelectionListener =
function(ev) {
	if (ev.detail == DwtListView.ITEM_DBL_CLICKED) {
		//console.log("double click");
		if(ev.item) {
			//console.log("edit item");
			this._editItem(ev.item);
		}
	} else {
		//console.log("single click");

        //Cancel previous scheduled action
        if(this.changeAcStateAcId) {
            AjxTimedAction.cancelAction(this.changeAcStateAcId);
            this.changeAcStateAcId = null;
        }

		var act = new AjxTimedAction(this,ZaController.prototype.changeActionsState,[ev]);
		this.changeAcStateAcId = AjxTimedAction.scheduleAction(act,ZaController.CLICK_DELAY);
		//this.changeActionsState();
	}
}

ZaAccountListController.prototype._listActionListener =
function (ev) {
	this.changeActionsState();
	this._actionMenu.popup(0, ev.docX, ev.docY);
}

/**
* This listener is called when the Edit button is clicked. 
* It call ZaAccountViewController.show method
* in order to display the Account View
**/
ZaAccountListController.prototype._editButtonListener =
function(ev) {
	EmailAddr_XFormItem.resetDomainLists.call (this) ;
	if(this._contentView.getSelectionCount() == 1) {
		var item = this._contentView.getSelection()[0];
		this._editItem(item);
	}
}


ZaAccountListController.prototype._editItem = function (item) {
	if(this.changeAcStateAcId) {
		AjxTimedAction.cancelAction(this.changeAcStateAcId);
		this.changeAcStateAcId = null;
	}	
	//check if the item already open in a tab
	var itemId = item.id ;
	if((item.type == ZaItem.ALIAS) && item.attrs && item.attrs[ZaAlias.A_AliasTargetId]) {
		itemId = item.attrs[ZaAlias.A_AliasTargetId];
	}
	var type = item.type;
	var viewContstructor = ZaAccountXFormView;
	if (type == ZaItem.ACCOUNT) {
		viewContstructor = ZaAccountXFormView;
	} else if (type == ZaItem.DL) {
		viewContstructor = ZaDLXFormView;
	} else if (type == ZaItem.RESOURCE ){
		viewContstructor = ZaResourceXFormView;
	} else if (type == ZaItem.ALIAS) {
		if (item.attrs[ZaAlias.A_targetType] == ZaAlias.TARGET_TYPE_ACCOUNT) {
			viewContstructor = ZaAccountXFormView;
		}else if (item.attrs[ZaAlias.A_targetType] == ZaAlias.TARGET_TYPE_DL){
		    viewContstructor = ZaDLXFormView;
		}else if (item.attrs[ZaAlias.A_targetType] == ZaAlias.TARGET_TYPE_RESOURCE) {
            viewContstructor = ZaResourceXFormView;
        }
	}
	
	try {	
	   if (! this.selectExistingTabByItemId(itemId,viewContstructor)){

//		DBG.println("TYPE == ", item.type);
		if (type == ZaItem.ACCOUNT) {
			//this._selectedItem = ev.item;
			ZaApp.getInstance().getAccountViewController().show(item, true);
		} else if (type == ZaItem.DL) {
			ZaApp.getInstance().getDistributionListController().show(item, true);
		} else if(type == ZaItem.ALIAS) {
			var targetObj = item.getAliasTargetObj() ;
			
			if (item.attrs[ZaAlias.A_targetType] == ZaAlias.TARGET_TYPE_ACCOUNT) {			
				ZaApp.getInstance().getAccountViewController().show(targetObj, true);
			}else if (item.attrs[ZaAlias.A_targetType] == ZaAlias.TARGET_TYPE_DL){
				ZaApp.getInstance().getDistributionListController().show(targetObj, true);
			}else if (item.attrs[ZaAlias.A_targetType] == ZaAlias.TARGET_TYPE_RESOURCE){
				ZaApp.getInstance().getResourceController(itemId).show(targetObj, true);
			} 
		} else if (type == ZaItem.RESOURCE ){
			ZaApp.getInstance().getResourceController(itemId).show(item, true);
		}

        ZaZimbraAdmin.getInstance().getOverviewPanelController().addAccountItem(item);
	   }
	} catch(ex) {
		if(ex.msg) {
			//output exception message
			ZaApp.getInstance().dialogs["errorMsgDlg"] = new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.OK_BUTTON], null,ZaId.CTR_PREFIX + ZaId.VIEW_ACCTLIST + "_errorMsg"); 
                       	ZaApp.getInstance().dialogs["errorMsgDlg"].setMessage(ex.msg, null, DwtMessageDialog.TITLE[DwtMessageDialog.WARNING_STYLE]);
                       	ZaApp.getInstance().dialogs["errorMsgDlg"].popup();
		}
	}
};
/**
* This listener is called when the Change Password button is clicked. 
**/
ZaAccountListController.prototype._chngPwdListener =
function(ev) {
  try{
	if(this._contentView.getSelectionCount()==1) {
		this._chngPwdDlg = new ZaAccChangePwdXDlg(ZaApp.getInstance().getAppCtxt().getShell(), "400px","90px");
		var item = this._contentView.getSelection()[0];
		item.loadEffectiveRights("id", item.id, false);
		this._chngPwdDlg.registerCallback(DwtDialog.OK_BUTTON, ZaAccountListController._changePwdOKCallback, this, item);	
		if (item.name != undefined && item.name.length > 80) {
                        this._chngPwdDlg.setTitle(ZaMsg.CHNP_Title + " (" + AjxStringUtil.htmlEncode(item.name.substring(1,80)) + "..." + ")");
                } else {
                      if (item.name != undefined) {
                        this._chngPwdDlg.setTitle(ZaMsg.CHNP_Title + " (" + AjxStringUtil.htmlEncode(item.name) + ")");
                      } else {
                        this._chngPwdDlg.setTitle(ZaMsg.CHNP_Title);
                      }
                }
		var obj = new Object();
		obj[ZaAccount.A2_confirmPassword]="";
		obj.attrs = {};
		obj.attrs[ZaAccount.A_password]="";
		obj.attrs[ZaAccount.A_zimbraPasswordMustChange]=false;
		obj.getAttrs = item.getAttrs;
		obj.setAttrs = item.setAttrs;
		this._chngPwdDlg.setObject(obj)
		this._chngPwdDlg.popup();
	}
 } catch (ex) {
                 if (ex.code &&
                        (ex.code == ZmCsfeException.SVC_AUTH_EXPIRED ||
                                ex.code == ZmCsfeException.SVC_AUTH_REQUIRED ||
                                ex.code == ZmCsfeException.NO_AUTH_TOKEN ||
                                ex.code == ZmCsfeException.AUTH_TOKEN_CHANGED
                         )
                ){
                 try {
                        var bReloginMode = false;
                        if (ZaApp.getInstance() != null && (ex.code == ZmCsfeException.SVC_AUTH_EXPIRED ||
                                                            ex.code == ZmCsfeException.AUTH_TOKEN_CHANGED
                                                           ))
                        {
                                ZmCsfeCommand.noAuth = true;

                                var dlgs = ZaApp.getInstance().dialogs;
                                if (dlgs != undefined) {
                                for (var dlg in dlgs) {
                                        dlgs[dlg].popdown();
                                }}
                                this._loginDialog.registerCallback(this.loginCallback, this);
                                this._loginDialog.setError(ZaMsg.ERROR_SESSION_EXPIRED);
                                this._loginDialog.clearPassword();
                        } else {
                                this._loginDialog.setError(null);
                                bReloginMode = false;
                        }
                        this._loginDialog.setReloginMode(bReloginMode);
                        this._showLoginDialog(bReloginMode);
                } catch (ex2) {
			if(window.console && window.console.log)
                        	console.log(ex2.code);
                }
                } else {
                      this._handleException(ex, "ZaAccountListController._chngPwdListenerLauncher", null, false);
                }
    }   
}

ZaAccountListController.prototype._expireSessionListener = 
function(ev) {
	try {	
		if(this._contentView.getSelectionCount()==1) {
			var item = this._contentView.getSelection()[0];
			if((item.type == ZaItem.ALIAS) && (item.attrs[ZaAlias.A_targetType] == ZaItem.ACCOUNT)){
				if(!item.targetObj)
					item.targetObj = item.getAliasTargetObj();
				item = item.targetObj;
			}
			item.loadEffectiveRights("id", item.id, false);
			if(ZaItem.hasWritePermission(ZaAccount.A_zimbraAuthTokenValidityValue,item)) {
				ZaApp.getInstance().dialogs["confirmMessageDialog"].setMessage(ZaMsg.WARN_EXPIRE_SESSIONS, DwtMessageDialog.WARNING_STYLE);
				ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.YES_BUTTON, ZaAccountListController.prototype.expireSessions, this, [item]);		
				ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.NO_BUTTON, this.closeCnfrmDlg, this, null);				
				ZaApp.getInstance().dialogs["confirmMessageDialog"].popup();
			} else {
				this.popupMsgDialog(AjxMessageFormat.format(ZaMsg.ERROR_NO_PERMISSION_FOR_OPERATION_ON, [item.name ? item.name : item.attrs[ZaAccount.A_accountName]]), true);
			}	
		}	
 	}catch(ex){
		this._handleException(ex, "ZaAccountListController._expireSessionListener", null, false);
	}
}

ZaAccountListController.prototype.expireSessions = 
function(acct) {
	try {
		ZaApp.getInstance().dialogs["confirmMessageDialog"].popdown();
		mods = {};
		mods[ZaAccount.A_zimbraAuthTokenValidityValue] = (!acct.attrs[ZaAccount.A_zimbraAuthTokenValidityValue] ? 1 : ((parseInt(acct.attrs[ZaAccount.A_zimbraAuthTokenValidityValue])+1) % 9));
		acct.modify(mods,acct);
		//if we find we invalidate self account, we will throw an simulative exception of AUTH_EXPIRED 
		//this exception will be handled in _handleException to redirect admin to login page  
		if(ZaZimbraAdmin.currentAdminAccount.id == acct.id){
			var exParams = {
				msg: 	ZaMsg.EX_EXPIRE_OWN_SESSIONS,
				code:	ZmCsfeException.SVC_AUTH_EXPIRED ,
				method: null,
				detail: "",
				data:   "",
				trace:  ""
			};
			throw new ZmCsfeException(exParams);
		}

        ZaApp.getInstance().getAppCtxt().getAppController().setActionStatusMsg(AjxMessageFormat.format(ZaMsg.SessionInvalid,[acct.name]));
	}catch(ex){
		this._handleException(ex, "ZaAccountListController.expireSessions", null, false);
	}
}  

ZaAccountListController._viewMailListenerLauncher =
function(account) {
	try {
		var obj;
		var accId;
		if(account.type == ZaItem.ACCOUNT || account.type == ZaItem.RESOURCE) {
			obj = ZaAccount.getViewMailLink(account.id);
			accId = account.id;
		} else if(account.type == ZaItem.ALIAS && account.attrs[ZaAlias.A_AliasTargetId]) {
			obj = ZaAccount.getViewMailLink(account.attrs[ZaAlias.A_AliasTargetId]);
			accId = account.attrs[ZaAlias.A_AliasTargetId];
			account = new ZaAccount();
		} else {
			return;
		}
		if(!account[ZaAccount.A2_publicMailURL]) {
			account.load("id", accId);
		}
		if(!account[ZaAccount.A2_publicMailURL]) {
			account[ZaAccount.A2_publicMailURL] = ["http://",ZaAccount.getDomain(account[ZaAccount.A_name]),":7070"].join("");
		}

		var publicMailURL = account[ZaAccount.A2_publicMailURL];
		// Fix for bug: 88094. Ip_XModelItem is responsible for parsing/validating IP addresses
	    if (Ip_XModelItem.EXACT_IP_ADDRESS_RE.test(location.hostname) && publicMailURL) {
			// Here we guess user prefer to use IP, if possible, I will replace FQDN with IP
			try {
				var startIndex = publicMailURL.indexOf("//");
				if (startIndex != -1) {
					startIndex = startIndex + 2;
				} else {
					startIndex = 0;
				}
				//Search Port
				var endIndex = publicMailURL.indexOf(":", startIndex);
				if (endIndex == -1) {
					endIndex = publicMailURL.indexOf("/", startIndex);
				}
				var mailFQDN 
				if (endIndex != -1) {
					mailFQDN= publicMailURL.substring(startIndex, endIndex);
				} else {
				 	mailFQDN= publicMailURL.substring(startIndex);
				}
				var servers = ZaServer.getAll().getArray();
				var mailBoxIP = "";
				if(servers.length > 1) {
					var found = false;
					// Try to find FQDN and IP mapping in server information.
					// If user set domain level attribute, it shouldn't be found here.
					for (var i = 0; i < servers.length; i++) {
						if(!servers[i].attrs[ZaServer.A_zimbraMailboxServiceEnabled])
							continue;

						if(servers[i].attrs[ZaServer.A_ServiceHostname] == mailFQDN) {
							found = true;
						}

						if(!found && servers[i].attrs[ZaServer.A_Pop3BindAddress]) {
							for(var j=0;j<servers[i].attrs[ZaServer.A_Pop3BindAddress].length;j++) {
								if(servers[i].attrs[ZaServer.A_Pop3BindAddress][j] == mailFQDN) {
									found = true;
									break;
								}
							}
						}

						if(found) {
							// FQDN hit, start find IP information of this server
							// ignore local address
							servers[i].load();
                        	if(servers[i].nifs) {
                            	for(var j=0;j<servers[i].nifs.length;j++) {
                                	if(servers[i].nifs[j].attrs.addr && (servers[i].nifs[j].attrs.addr != "127.0.0.1")) {
                  						mailBoxIP = servers[i].nifs[j].attrs.addr;
                                    }
                                    break;
                                }
                            }
							break;
                        }
					}
				} else {
					//Single Node installation, all components are in the same machine.
					mailBoxIP = location.hostname;
				}
				if (mailFQDN && mailBoxIP) {
					publicMailURL = publicMailURL.replace(mailFQDN, mailBoxIP);
				}
			} catch (ex1) {

			}
		}

		if(!obj.authToken || !obj.lifetime)
			throw new AjxException(ZaMsg.ERROR_FAILED_TO_GET_CREDENTIALS, AjxException.UNKNOWN, "ZaAccountListController.prototype._viewMailListener");

		var mServer = [publicMailURL, "/service/preauth?authtoken=",obj.authToken,"&isredirect=1&adminPreAuth=1"].join("");
		mServer = AjxStringUtil.trim(mServer,true);
		var win = window.open(mServer, "_blank");
	} catch (ex) {
		this._handleException(ex, "ZaAccountListController._viewMailListenerLauncher", null, false);
	}
}
/**
* This listener is called when the Delete button is clicked. 
**/
ZaAccountListController.prototype._deleteButtonListener =
function(ev) {
	this._removeList = new Array();
	this._itemsInTabList = [] ;
	this._haveAliases = false;
	this._haveAccounts = false;
	this._haveDls = false;
	this._haveDomains = false;	
	this._haveCoses = false;
	if(this._contentView.getSelectionCount()>0) {
		var arrItems = this._contentView.getSelection();
		var cnt = arrItems.length;
		for(var key =0; key < cnt; key++) {
			var item = arrItems[key];
			if (item) {
				//detect whether the deleting item is open in a tab
				if (ZaApp.getInstance().getTabGroup() && ZaApp.getInstance().getTabGroup().getTabByItemId (item.id)) {
					this._itemsInTabList.push (item) ;
				}else{
					this._removeList.push(item);			
					if(!this._haveAliases && item.type == ZaItem.ALIAS) {
						this._haveAliases = true;
					} else if(!this._haveAccounts && item.type == ZaItem.ACCOUNT) {
						this._haveAccounts = true;
					} else if(!this._haveDls && item.type == ZaItem.DL) {
						this._haveDls = true;
					} else if(!this._haveDomains && item.type == ZaItem.DOMAIN) {
						this._haveDomains = true;
					} else if(!this._haveCoses && item.type == ZaItem.COS) {
                        this._haveCoses = true;
					}
				}
			}
		}
		//delegate to Domain list controller if we are only deleting domains
		if(this._haveDomains && !(this._haveAliases || this._haveAccounts || this._haveDls || this._haveCoses)) {
			var domainListController = ZaApp.getInstance().getDomainListController ();
			domainListController._deleteButtonListener(ev); 
			return;
		}
	}
	
	if (this._itemsInTabList.length > 0) {
		if(!ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"]) {
			ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"] = 
				new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.CANCEL_BUTTON], 
						[ZaMsgDialog.CLOSE_TAB_DELETE_BUTTON_DESC , ZaMsgDialog.NO_DELETE_BUTTON_DESC],
						ZaId.CTR_PREFIX + ZaId.VIEW_ACCTLIST + "_ConfirmDeleteItemsInTab");		
		}
		
		
		var msg = ZaMsg.dl_warning_delete_accounts_in_tab ; 
		msg += ZaAccountListController.getDlMsgFromList (this._itemsInTabList) ;
		
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].setMessage(msg, DwtMessageDialog.WARNING_STYLE);	
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].registerCallback(
				ZaMsgDialog.CLOSE_TAB_DELETE_BUTTON, ZaAccountListController.prototype._closeTabsBeforeRemove, this);
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].registerCallback(
				ZaMsgDialog.NO_DELETE_BUTTON, ZaAccountListController.prototype._deleteAccountsInRemoveList, this);		
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].popup();
		
	} else{
		this._deleteAccountsInRemoveList ();
	}
	
}

ZaAccountListController.prototype._closeTabsBeforeRemove =
function () {
	//DBG.println (AjxDebug.DBG1, "Close the tabs before Remove ...");
	/*var tabGroup = ZaApp.getInstance().getTabGroup();
	for (var i=0; i< this._itemsInTabList.length ; i ++) {
		var item = this._itemsInTabList[i];
		tabGroup.removeTab (tabGroup.getTabByItemId(item.id)) ;
		this._removeList.push(item);
	}*/
	this.closeTabsInRemoveList();
	//ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].popdown();
	this._deleteAccountsInRemoveList();
}

ZaAccountListController.prototype._deleteAccountsInRemoveList =
function () {
	if (ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"]) {
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].popdown();
	}
	if(this._removeList.length > 0) {
		var dlgMsg;
		if(this._haveDls && !(this._haveAccounts || this._haveAliases ||this._haveDomains || this._haveCoses)) {
			dlgMsg = ZaMsg.Q_DELETE_DLS;
		} else if(this._haveAccounts && !(this._haveDls || this._haveAliases || this._haveDomains || this._haveCoses)) {
			dlgMsg = ZaMsg.Q_DELETE_ACCOUNTS;
		} else if(this._haveAliases && !(this._haveDls || this._haveAccounts || this._haveDomains || this._haveCoses)) {
			dlgMsg = ZaMsg.Q_DELETE_ALIASES;
		} else if(this._haveDomains && !(this._haveAliases || this._haveAccounts || this._haveDls || this._haveCoses)) {
			dlgMsg = ZaMsg.Q_DELETE_DOMAINS;
                } else if(this._haveCoses && !(this._haveAliases || this._haveAccounts || this._haveDomains || this._haveDls)) {
                        dlgMsg = ZaMsg.Q_DELETE_COSES;
		} else {
			dlgMsg = ZaMsg.Q_DELETE_OBJECTS;
		}
		dlgMsg += ZaAccountListController.getDlMsgFromList (this._removeList);
		var cnt = this._removeList.length;
		var sysResources = [];
		for(var i=0; i< cnt; i++) {
			if(this._removeList[i].attrs[ZaAccount.A_zimbraIsSystemResource] && this._removeList[i].attrs[ZaAccount.A_zimbraIsSystemResource]=="TRUE") {
				dlgMsg += "<br/>";
				dlgMsg += ZaMsg.WARN_DELETING_SYSTEM_RESOURCES;
				break;
			}
		}
		ZaApp.getInstance().dialogs["confirmMessageDialog2"].setMessage(dlgMsg,  DwtMessageDialog.INFO_STYLE);
		ZaApp.getInstance().dialogs["confirmMessageDialog2"].registerCallback(DwtDialog.YES_BUTTON, ZaAccountListController.prototype._deleteAccountsCallback, this);
		ZaApp.getInstance().dialogs["confirmMessageDialog2"].registerCallback(DwtDialog.NO_BUTTON, ZaAccountListController.prototype._donotDeleteAccountsCallback, this);		
		ZaApp.getInstance().dialogs["confirmMessageDialog2"].popup();
	}
}

ZaAccountListController.getDlMsgFromList =
function (listArr) {
	var dlgMsg = "<br><ul>";
	var i=0;

	for(var key in listArr) {
		if(i > 19) {
			dlgMsg += "<li>...</li>";
			break;
		}

		dlgMsg += "<li>";
		var szAccName = listArr[key].attrs[ZaAccount.A_displayname] ? listArr[key].attrs[ZaAccount.A_displayname] : listArr[key].name;
		if(szAccName.length > 50) {
			var beginIx = 0;
			var endIx = 50;
			do {
				if (endIx >= szAccName.length) {
					dlgMsg += AjxStringUtil.htmlEncode(szAccName.slice(beginIx));
				} else {
					dlgMsg += AjxStringUtil.htmlEncode(szAccName.slice(beginIx, endIx));
				}
				beginIx = endIx;
				endIx += 50 ;

				dlgMsg +=  "<br />";	
			} while (beginIx < szAccName.length) ;
		} else {
			dlgMsg += AjxStringUtil.htmlEncode(szAccName);
		}

		dlgMsg += "</li>";
		i++;
	}

	dlgMsg += "</ul>";
	return dlgMsg;
}


ZaAccountListController.prototype._deleteAccountsCallback = 
function () {

	//if(!ZaApp.getInstance().dialogs["removeProgressDlg"]) {
		ZaApp.getInstance().dialogs["removeProgressDlg"] = new DeleteAcctsPgrsDlg(this._container, "500px","300px");
	//}
	ZaApp.getInstance().dialogs["confirmMessageDialog2"].popdown();
	ZaApp.getInstance().dialogs["removeProgressDlg"].popup();
	ZaApp.getInstance().dialogs["removeProgressDlg"].setObject(this._removeList);
	ZaApp.getInstance().dialogs["removeProgressDlg"].startDeletingAccounts();

	//update cos list tree
	if(this._haveCoses){
		var overviewPanelCtrl = ZaApp.getInstance()._appCtxt.getAppController().getOverviewPanelController();
		overviewPanelCtrl.removeCosTreeItems(this._removeList);
	}
}



ZaAccountListController.prototype._donotDeleteAccountsCallback = 
function () {
	this._removeList = new Array();
	ZaApp.getInstance().dialogs["confirmMessageDialog2"].popdown();
}


ZaAccountListController._changePwdOKCallback = 
function (item) {
	//check the passwords, if they are ok then save the password, else show error
	if(this._chngPwdDlg) {
		try {
			var userName = item.name.split('@')[0];
			if (!this._chngPwdDlg.getPassword() || this._chngPwdDlg.getPassword().length < 1) {
				ZaApp.getInstance().dialogs["errorMsgDlg"] = new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.OK_BUTTON], null, ZaId.CTR_PREFIX + ZaId.VIEW_ACCTLIST + "_errorMsg");
				ZaApp.getInstance().dialogs["errorMsgDlg"].setMessage(ZaMsg.ERROR_PASSWORD_REQUIRED, null, DwtMessageDialog.TITLE[DwtMessageDialog.CRITICAL_STYLE]);
				ZaApp.getInstance().dialogs["errorMsgDlg"].popup();
			} else if (item.attrs[ZaAccount.A_zimbraFeatureAllowUsernameInPassword] === "FALSE" && this._chngPwdDlg.getPassword().includes(userName)) {
				ZaApp.getInstance().dialogs["errorMsgDlg"] = new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.OK_BUTTON], null, ZaId.CTR_PREFIX + ZaId.VIEW_ACCTLIST + "_errorMsg");
				ZaApp.getInstance().dialogs["errorMsgDlg"].setMessage(ZaMsg.ERROR_PASSWORD_CONTAIN_USERNAME, null, DwtMessageDialog.TITLE[DwtMessageDialog.CRITICAL_STYLE]);
				ZaApp.getInstance().dialogs["errorMsgDlg"].popup();
			} else if (this._chngPwdDlg.getPassword() != this._chngPwdDlg.getConfirmPassword()) {
				ZaApp.getInstance().dialogs["errorMsgDlg"] = new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.OK_BUTTON], null, ZaId.CTR_PREFIX + ZaId.VIEW_ACCTLIST + "_errorMsg");
				ZaApp.getInstance().dialogs["errorMsgDlg"].setMessage(ZaMsg.ERROR_PASSWORD_MISMATCH, null, DwtMessageDialog.TITLE[DwtMessageDialog.CRITICAL_STYLE]);
				ZaApp.getInstance().dialogs["errorMsgDlg"].popup();
			} else {
				//check password
				var myCos = null;
				var maxPwdLen = null;
				var minPwdLen = null;	
				item.refresh(true,false);
				if(item.attrs[ZaAccount.A_zimbraMinPwdLength] != null) {
					minPwdLen = item.attrs[ZaAccount.A_zimbraMinPwdLength];
				} 
				
				if(item.attrs[ZaAccount.A_zimbraMaxPwdLength] != null) {
					maxPwdLen = item.attrs[ZaAccount.A_zimbraMaxPwdLength];
				} 
				
				if (minPwdLen == null) {
					minPwdLen = item._defaultValues[ZaAccount.A_zimbraMinPwdLength];
				}			
				
				if (maxPwdLen == null) {
					minPwdLen = item._defaultValues[ZaAccount.A_zimbraMaxPwdLength];
				}		
				
				if (maxPwdLen == null) {
					maxPwdLen = Number.POSITIVE_INFINITY;
				}
				
				if(minPwdLen == null) {
					minPwdLen = 1;
				}
				
				var szPwd = this._chngPwdDlg.getPassword();
				if(szPwd.length < minPwdLen || AjxStringUtil.trim(szPwd).length < minPwdLen) { 
					//show error msg
					//this._chngPwdDlg.popdown();
                    var minpassMsg;
                    if (minPwdLen > 1) {
                        minpassMsg =  String(ZaMsg.NAD_passMinLengthMsg_p).replace("{0}",minPwdLen);
                    } else {
                        minpassMsg =  String(ZaMsg.NAD_passMinLengthMsg_s).replace("{0}",minPwdLen);
                    }
					ZaApp.getInstance().dialogs["errorMsgDlg"] = new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.OK_BUTTON],null,ZaId.CTR_PREFIX + ZaId.VIEW_ACCTLIST + "_errorMsg");									
					ZaApp.getInstance().dialogs["errorMsgDlg"].setMessage(ZaMsg.ERROR_PASSWORD_TOOSHORT + "<br>" + minpassMsg, null, DwtMessageDialog.CRITICAL_STYLE, null);
					ZaApp.getInstance().dialogs["errorMsgDlg"].popup();
				} else if(AjxStringUtil.trim(szPwd).length > maxPwdLen) { 
					//show error msg
					//this._chngPwdDlg.popdown();
					ZaApp.getInstance().dialogs["errorMsgDlg"] = new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.OK_BUTTON], null, ZaId.CTR_PREFIX + ZaId.VIEW_ACCTLIST + "_errorMsg");
                    var maxpassMsg;
                    if (maxPwdLen > 1) {
                        maxpassMsg =  String(ZaMsg.NAD_passMinLengthMsg_p).replace("{0}",minPwdLen);
                    } else {
                        maxpassMsg =  String(ZaMsg.NAD_passMinLengthMsg_s).replace("{0}",minPwdLen);
                    }
					ZaApp.getInstance().dialogs["errorMsgDlg"].setMessage(ZaMsg.ERROR_PASSWORD_TOOLONG+ "<br>" + maxpassMsg, null, DwtMessageDialog.CRITICAL_STYLE, null);
					ZaApp.getInstance().dialogs["errorMsgDlg"].popup();
				} else {		
					item.changePassword(szPwd);
					this._chngPwdDlg.popdown();	//close the dialog
                    ZaApp.getInstance().getAppCtxt().getAppController().setActionStatusMsg(AjxMessageFormat.format(ZaMsg.PasswordModified,[item.name]));
				}

			}
			if (this._chngPwdDlg.getMustChangePassword()) {
				//item.attrs[ZaAccount.A_zimbraPasswordMustChange] = "TRUE";
				var mods = new Object();
				mods[ZaAccount.A_zimbraPasswordMustChange] = "TRUE";
				item.modify(mods);
			}

		} catch (ex) {
			if(ex.code == ZmCsfeException.ACCT_INVALID_PASSWORD ) {
				var szMsg = ZaMsg.ERROR_PASSWORD_INVALID;
				if(ex.detail) {
					szMsg +="<br>Details:<br>";
					szMsg += ex.detail;
				}
				ZaApp.getInstance().dialogs["errorDialog"].setMessage(szMsg, null, DwtMessageDialog.CRITICAL_STYLE, null);
				ZaApp.getInstance().dialogs["errorDialog"].popup();
			} else {
				this._handleException(ex, "ZaAccountListController._changePwdOKCallback", null, false);			
			}
			return;
		}
	}
}

ZaAccountListController.prototype.getPopUpOperation =
function() {
    return this._popupOperations;
}

ZaAccountListController.changeActionsStateMethod = 
function () {
	var cnt = this._contentView.getSelectionCount();
	if(cnt == 1) {
		var item = this._contentView.getSelection()[0];
		if(item) {
            if (item.type == ZaItem.ALIAS || item.type == ZaItem.DL) {
                if(this._popupOperations[ZaOperation.CHNG_PWD]) {
                    this._popupOperations[ZaOperation.CHNG_PWD].enabled = false;
                }
            }

            if (((item.type == ZaItem.ALIAS) && 
            		(item.attrs[ZaAlias.A_targetType] == ZaItem.DL)) 
            			|| (item.type == ZaItem.DL)) {

                if(this._popupOperations[ZaOperation.EXPIRE_SESSION]) {
                    this._popupOperations[ZaOperation.EXPIRE_SESSION].enabled = false;
                }
            }
		
	    if ((item.type == ZaItem.ALIAS) && (item.attrs[ZaAlias.A_targetType] == ZaItem.RESOURCE)){	    
                if(this._popupOperations[ZaOperation.EXPIRE_SESSION]) {
                    this._popupOperations[ZaOperation.EXPIRE_SESSION].enabled = false;
                }
            }

            if (item.type == ZaItem.DL) {
                if(this._popupOperations[ZaOperation.MOVE_ALIAS])	{
                    this._popupOperations[ZaOperation.MOVE_ALIAS].enabled = false;
                }

                if(!ZaItem.hasRight(ZaAccount.RIGHT_DELETE_DL,item)) {
                	if(this._popupOperations[ZaOperation.DELETE]) {
                        this._popupOperations[ZaOperation.DELETE].enabled = false;
                    }
                }
            }

            if(item.type == ZaItem.ALIAS && item.attrs[ZaAlias.A_targetType] == ZaItem.DL) {
                if(!ZaItem.hasRight(ZaDistributionList.REMOVE_DL_ALIAS_RIGHT,item.getAliasTargetObj())) {
                    if(this._popupOperations[ZaOperation.DELETE]) {
                        this._popupOperations[ZaOperation.DELETE].enabled = false;
                    }
                }
            }

			if (item.type == ZaItem.ACCOUNT) {
				var enable = false;
                var domainName = ZaAccount.getDomain(item.toString());
                var isAuthInternal = ZaAccountXFormView.isAuthfromInternal(domainName);

				if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE') {
					enable = true;
				} else if (AjxUtil.isEmpty(item.rights)) {
					//console.log("loading effective rights for a list item");
					item.loadEffectiveRights("id", item.id, false);
					//console.log("loaded rights for a list item");
				}
				if(!enable) {
					if(!ZaItem.hasRight(ZaAccount.DELETE_ACCOUNT_RIGHT,item)) {
						 if(this._popupOperations[ZaOperation.DELETE]) {
						 	this._popupOperations[ZaOperation.DELETE].enabled = false;
						 }
					}
					if(!ZaItem.hasAnyRight([ZaAccount.SET_PASSWORD_RIGHT, ZaAccount.CHANGE_PASSWORD_RIGHT], item) && isAuthInternal) {
						 if(this._popupOperations[ZaOperation.CHNG_PWD]) {
						 	this._popupOperations[ZaOperation.CHNG_PWD].enabled = false;
						 }
					}	
					if(!ZaItem.hasWritePermission(ZaAccount.A_zimbraAuthTokenValidityValue,item)) {    
					   	if(this._popupOperations[ZaOperation.EXPIRE_SESSION]) {	
							this._popupOperations[ZaOperation.EXPIRE_SESSION].enabled = false;
						}						
					}									
				} else {
					if(!isAuthInternal) {
                        if(this._popupOperations[ZaOperation.CHNG_PWD]) {
                            this._popupOperations[ZaOperation.CHNG_PWD].enabled = false;
                        }
					} 
				}
			} else if ((item.type == ZaItem.ALIAS) && (item.attrs[ZaAlias.A_targetType] == ZaItem.ACCOUNT))  {
				if(!item.targetObj) {
					item.targetObj = item.getAliasTargetObj() ;
				}
				var enable = false;
				if (ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE') {
					enable = true;
				} else if (AjxUtil.isEmpty(item.targetObj.rights)) {
					item.targetObj.loadEffectiveRights("id", item.id, false);
				}
				if(!enable) {
					if(!ZaItem.hasRight(ZaAccount.DELETE_ACCOUNT_RIGHT,item.targetObj)) {
						 if(this._popupOperations[ZaOperation.DELETE]) {
						 	this._popupOperations[ZaOperation.DELETE].enabled = false;
						 }
						 
					}
					if(!ZaItem.hasAnyRight([ZaAccount.SET_PASSWORD_RIGHT, ZaAccount.CHANGE_PASSWORD_RIGHT],item.targetObj)) {
						 if(this._popupOperations[ZaOperation.CHNG_PWD]) {
						 	this._popupOperations[ZaOperation.CHNG_PWD].enabled = false;
						 }
					}		
				}
			} else if ((item.type == ZaItem.ALIAS) && (item.attrs[ZaAlias.A_targetType] == ZaItem.RESOURCE))  {
				if(!item.targetObj)
					item.targetObj = item.getAliasTargetObj() ;
					
				var enable = false;
				if (ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE') {
					enable = true;
				} else if (AjxUtil.isEmpty(item.targetObj.rights)) {
					item.targetObj.loadEffectiveRights("id", item.id, false);
				}
				if(!enable) {
					if(!enable) {
						if(!ZaItem.hasRight(ZaResource.DELETE_CALRES_RIGHT,item.targetObj)) {
							 if(this._popupOperations[ZaOperation.DELETE]) {
							 	this._popupOperations[ZaOperation.DELETE].enabled = false;
							 }
						}	
						if(!ZaItem.hasRight(ZaResource.SET_CALRES_PASSWORD_RIGHT, item.targetObj)) {
							 if(this._popupOperations[ZaOperation.CHNG_PWD]) {
							 	this._popupOperations[ZaOperation.CHNG_PWD].enabled = false;
							 }
						}		
					}
				}
			} else if(item.type == ZaItem.RESOURCE) {
				var enable = false;
				if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE') {
					enable = true;
				} else if (AjxUtil.isEmpty(item.rights)) {
					item.loadEffectiveRights("id", item.id, false);
				}
				if(!enable) {
					if(!ZaItem.hasRight(ZaResource.DELETE_CALRES_RIGHT,item)) {
						 if(this._popupOperations[ZaOperation.DELETE]) {
						 	this._popupOperations[ZaOperation.DELETE].enabled = false;
						 }
					}	
					if(!ZaItem.hasRight(ZaResource.SET_CALRES_PASSWORD_RIGHT, item)) {
						 if(this._popupOperations[ZaOperation.CHNG_PWD]) {
						 	this._popupOperations[ZaOperation.CHNG_PWD].enabled = false;
						 }
					}		
				}				
			}
        } else {
			
			if(this._popupOperations[ZaOperation.EXPIRE_SESSION]) {	
				this._popupOperations[ZaOperation.EXPIRE_SESSION].enabled = false;
			}
			if(this._popupOperations[ZaOperation.EDIT]) {	
				this._popupOperations[ZaOperation.EDIT].enabled = false;
			}	
			if(this._popupOperations[ZaOperation.CHNG_PWD]) {
				this._popupOperations[ZaOperation.CHNG_PWD].enabled = false;
			}
			if(this._popupOperations[ZaOperation.MOVE_ALIAS]) {
				this._popupOperations[ZaOperation.MOVE_ALIAS].enabled = false;
			}	
			if(this._popupOperations[ZaOperation.DELETE]) {	
				this._popupOperations[ZaOperation.DELETE].enabled = false;
			}				
		}		
	} else if (cnt > 1){
		if(this._popupOperations[ZaOperation.EXPIRE_SESSION]) {	
			this._popupOperations[ZaOperation.EXPIRE_SESSION].enabled = false;
		}					
		if(this._popupOperations[ZaOperation.EDIT]) {	
			this._popupOperations[ZaOperation.EDIT].enabled = false;
		}		
		if(this._popupOperations[ZaOperation.CHNG_PWD]) {
			this._popupOperations[ZaOperation.CHNG_PWD].enabled = false;
		}
		if(this._popupOperations[ZaOperation.MOVE_ALIAS]) {
			this._popupOperations[ZaOperation.MOVE_ALIAS].enabled = false;		
		}
	} else {
		if(this._popupOperations[ZaOperation.EXPIRE_SESSION]) {	
			this._popupOperations[ZaOperation.EXPIRE_SESSION].enabled = false;
		}				
		if(this._popupOperations[ZaOperation.EDIT]) {	
			this._popupOperations[ZaOperation.EDIT].enabled = false;
		}	
		if(this._popupOperations[ZaOperation.DELETE]) {
			this._popupOperations[ZaOperation.DELETE].enabled = false;
		}		
		if(this._popupOperations[ZaOperation.CHNG_PWD]) {
			this._popupOperations[ZaOperation.CHNG_PWD].enabled = false;
		}
		if(this._popupOperations[ZaOperation.MOVE_ALIAS])	{
			this._popupOperations[ZaOperation.MOVE_ALIAS].enabled = false;
		}	
	}
 	for(var i=0;i<cnt;i++) {
        var itemObj = this._contentView.getSelection()[i];
        if(itemObj && itemObj.type==ZaItem.ACCOUNT){
		// Use zimbraIsSystemAccount to determine enabled/disabled status for delete button
        	if (itemObj.attrs[ZaAccount.A_zimbraIsSystemAccount] == "TRUE") {
        		this._popupOperations[ZaOperation.DELETE].enabled = false;
        	}
        }
 	}
}
ZaController.changeActionsStateMethods["ZaAccountListController"].push(ZaAccountListController.changeActionsStateMethod);

ZaAccountListController.prototype._moveAliasListener = 
function (ev) {
	try {
		var alias;
		var alias = this._contentView.getSelection()[0];
		//make sure this is an alias
		if(!alias || alias.type!=ZaItem.ALIAS) {
			return;			
		}
		if(!ZaApp.getInstance().dialogs["moveAliasDialog"]) {
			ZaApp.getInstance().dialogs["moveAliasDialog"] = new MoveAliasXDialog(this._container, "400px", "300px");
		}
		ZaApp.getInstance().dialogs["moveAliasDialog"].setAlias(alias);
		ZaApp.getInstance().dialogs["moveAliasDialog"].popup();
	} catch (ex) {
		this._handleException(ex, "ZaAccountListController.prototype._moveAliasListener", null, false);
	}
	return;
}
}
if (AjxPackage.define("zimbraAdmin.accounts.controller.ZaAccountViewController")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaAccountViewController controls display of a single Account
* @contructor ZaAccountViewController
* @param appCtxt
* @param container
* @param abApp
* @author Roland Schemers
* @author Greg Solovyev
**/

ZaAccountViewController = function(appCtxt, container) {
	ZaXFormViewController.call(this, appCtxt, container, "ZaAccountViewController");
	this._UICreated = false;
	this.objType = ZaEvent.S_ACCOUNT;
	this._helpURL = [location.pathname, ZaUtil.HELP_URL, ZaAccountViewController.helpURL, "?locid=", AjxEnv.DEFAULT_LOCALE].join("");
	this._helpButtonText = ZaMsg.helpEditAccounts;
    this.deleteMsg = ZaMsg.Q_DELETE_ACCOUNT;
	this.tabConstructor = ZaAccountXFormView;
}

ZaAccountViewController.prototype = new ZaXFormViewController();
ZaAccountViewController.prototype.constructor = ZaAccountViewController;
ZaAccountViewController.helpURL = "managing_accounts/editing_accounts.htm";
ZaController.changeActionsStateMethods["ZaAccountViewController"] = new Array();
ZaController.setViewMethods["ZaAccountViewController"] = new Array();
ZaController.initToolbarMethods["ZaAccountViewController"] = new Array();
ZaController.initPopupMenuMethods["ZaAccountViewController"] = new Array();
ZaXFormViewController.preSaveValidationMethods["ZaAccountViewController"] = new Array();
//public methods

/**
*	@method show
*	@param entry - isntance of ZaAccount class
*	@param skipRefresh - forces to skip entry.refresh() call. 
*		   When getting account from an alias the account is retreived from the server using ZaAccount.load() 
* 		   so there is no need to refresh it.
*/

ZaAccountViewController.prototype.show = 
function(entry, openInNewTab, skipRefresh) {
	this._setView(entry, openInNewTab, skipRefresh);
}

ZaAccountViewController.initPopupMenuMethod =
function () {
	var showNewAccount = false;
	if(ZaZimbraAdmin.currentAdminAccount.attrs[ZaAccount.A_zimbraIsAdminAccount] == 'TRUE') {
		showNewAccount = true;
	} else {
		showNewAccount = ZaZimbraAdmin.canCreateAccount();
	}

    this._popupOperations[ZaOperation.SAVE]= new ZaOperation(ZaOperation.SAVE, ZaMsg.TBB_Save, ZaMsg.ALTBB_Save_tt, "Save", "SaveDis", new AjxListener(this, this.saveButtonListener));
    this._popupOperations[ZaOperation.CLOSE] = new ZaOperation(ZaOperation.CLOSE, ZaMsg.TBB_Close, ZaMsg.ALTBB_Close_tt, "Close", "CloseDis", new AjxListener(this, this.closeButtonListener));

	if(showNewAccount) {
        this._popupOperations[ZaOperation.NEW_MENU] = new ZaOperation(ZaOperation.NEW, ZaMsg.TBB_New, ZaMsg.ACTBB_New_tt, "Account", "AccountDis", new AjxListener(this, ZaAccountViewController.prototype._newButtonListener));
        this._popupOrder.push(ZaOperation.NEW_MENU);
	}
    this._popupOperations[ZaOperation.DELETE] = new ZaOperation(ZaOperation.DELETE, ZaMsg.TBB_Delete, ZaMsg.ACTBB_Delete_tt,"Delete", "DeleteDis", new AjxListener(this, this.deleteButtonListener));

    this._popupOrder.push(ZaOperation.SAVE);
    this._popupOrder.push(ZaOperation.CLOSE);
    this._popupOrder.push(ZaOperation.DELETE);

    this._popupOperations[ZaOperation.EXPIRE_SESSION] = new ZaOperation(ZaOperation.EXPIRE_SESSION, ZaMsg.ACTBB_ExpireSessions, ZaMsg.ACTBB_ExpireSessions_tt, "ExpireSession", "ExpireSessionDis", new AjxListener(this, ZaAccountViewController.prototype._expireSessionListener));
    this._popupOrder.push(ZaOperation.EXPIRE_SESSION);

    if(ZaItem.hasRight(ZaAccount.REINDEX_MBX_RIGHT,this._currentObject)) {
        this._popupOperations[ZaOperation.REINDEX_MAILBOX] = new ZaOperation(ZaOperation.REINDEX_MAILBOX, ZaMsg.ACTBB_ReindexMbx, ZaMsg.ACTBB_ReindexMbx_tt, "ReindexMailboxes", "ReindexMailboxes", new AjxListener(this, ZaAccountViewController.prototype._reindexMbxListener));
        this._popupOrder.push(ZaOperation.REINDEX_MAILBOX);
    }
}
ZaController.initPopupMenuMethods["ZaAccountViewController"].push(ZaAccountViewController.initPopupMenuMethod);
/*
ZaAccountViewController.prototype.getAppBarAction =
function () {
    if (AjxUtil.isEmpty(this._appbarOperation)) {
    	this._appbarOperation[ZaOperation.HELP]=new ZaOperation(ZaOperation.HELP,ZaMsg.TBB_Help, ZaMsg.TBB_Help_tt, "Help", "Help", new AjxListener(this, this._helpButtonListener));
        this._appbarOperation[ZaOperation.SAVE]= new ZaOperation(ZaOperation.SAVE, ZaMsg.TBB_Save, ZaMsg.ALTBB_Save_tt, "", "", new AjxListener(this, this.saveButtonListener));
        this._appbarOperation[ZaOperation.CLOSE] = new ZaOperation(ZaOperation.CLOSE, ZaMsg.TBB_Close, ZaMsg.ALTBB_Close_tt, "", "", new AjxListener(this, this.closeButtonListener));
    }

    return this._appbarOperation;
}

ZaAccountViewController.prototype.getAppBarOrder =
function () {
    if (AjxUtil.isEmpty(this._appbarOrder)) {
    	this._appbarOrder.push(ZaOperation.HELP);
        this._appbarOrder.push(ZaOperation.SAVE);
        this._appbarOrder.push(ZaOperation.CLOSE);
    }

    return this._appbarOrder;
}*/
/**
* This listener is called when the Delete button is clicked. 
* member of ZaXFormViewController
* @param 	ev event object
**/
ZaAccountViewController.prototype.deleteButtonListener =
function(ev) {
	if(this._currentObject.id) {
		if(this._currentObject[ZaAccount.A2_zimbra_ds] || this._currentObject[ZaAccount.A2_ldap_ds]) {
			ZaApp.getInstance().dialogs["confirmMessageDialog"].setMessage(AjxMessageFormat.format(ZaMsg.WARN_DELETING_GAL_SYNC,[this._currentObject.name]), DwtMessageDialog.WARNING_STYLE);
		} else if (this._currentObject.attrs[ZaAccount.A_zimbraIsSystemResource] && this._currentObject.attrs[ZaAccount.A_zimbraIsSystemResource]=="TRUE") { 
			ZaApp.getInstance().dialogs["confirmMessageDialog"].setMessage(AjxMessageFormat.format(ZaMsg.WARN_DELETING_SYSTEM_RESOURCE,[this._currentObject.name]), DwtMessageDialog.WARNING_STYLE);
		} else {
			ZaApp.getInstance().dialogs["confirmMessageDialog"].setMessage(this.deleteMsg, DwtMessageDialog.INFO_STYLE);
		}
		
		ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.YES_BUTTON, this.deleteAndGoAway, this, null);		
		ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.NO_BUTTON, this.closeCnfrmDlg, this, null);				
		ZaApp.getInstance().dialogs["confirmMessageDialog"].popup();
	} else {
		ZaApp.getInstance().popView();
	}
}

/**
*	@method setViewMethod 
*	@param entry - isntance of ZaAccount class
*/
ZaAccountViewController.setViewMethod =
function(entry) {
	try {
		this._currentObject = entry;

		//this._initToolbar();
        this._initPopupMenu();
		//make sure these are last

		if(!entry[ZaModel.currentTab])
			entry[ZaModel.currentTab] = "1";
	

		try {		  		
			if(!AjxUtil.isEmpty(entry.id)) {
				var isExternal = entry.isExternal;
				entry.refresh(false,true);
				entry.isExternal = isExternal;
			}
	  		this._contentView = this._view = new this.tabConstructor(this._container,entry);
			var elements = new Object();
			elements[ZaAppViewMgr.C_APP_CONTENT] = this._view;
            ZaApp.getInstance().getAppViewMgr().createView(this.getContentViewId(), elements);
	    	//associate the controller with the view by viewId
		    ZaApp.getInstance()._controllers[this.getContentViewId ()] = this ;
			//ZaApp.getInstance().pushView(ZaZimbraAdmin._ACCOUNT_VIEW);
			ZaApp.getInstance().pushView(this.getContentViewId()) ;
		} catch (ex) {
				// Data corruption may cause anexception. We should catch it here in order to display the form anyway.
			this._handleException(ex, null, null, false);
			if (ex.code ==  ZmCsfeException.SVC_PERM_DENIED) {
                if (this._contentView && this.getContentViewId()) {
				    //only pop the view when the view is actually created.
                    ZaApp.getInstance().popView();
                }
				return ;

			}
		}

        ZaZimbraAdmin.getInstance().getCurrentAppBar().enableButton(ZaOperation.SAVE, false);

		this._view.setDirty(false);
		entry.attrs[ZaAccount.A_password] = null; //get rid of VALUE-BLOCKED
		entry[ZaModel.currentTab] = "1";
		this._view.setObject(entry);
	} catch (ex) {
		this._handleException(ex, "ZaAccountViewController.prototype._setView", null, false);
	}	
	this._cosChanged = false;
	this._domainsChanged = false;
}
ZaController.setViewMethods["ZaAccountViewController"].push(ZaAccountViewController.setViewMethod);

ZaAccountViewController.changeActionsStateMethod = function () {
	if(!this._currentObject)
		return;

    var isDeleteEnabled = true;
	if(!ZaItem.hasRight(ZaAccount.DELETE_ACCOUNT_RIGHT,this._currentObject))	{
		isDeleteEnabled = false;
	}
   	var tmpObj = this._view.getObject();
        if(tmpObj.attrs != null && tmpObj.attrs[ZaAccount.A_mail] != null ) {
                var myitem = tmpObj.attrs[ZaAccount.A_mail];
                var myaccount = tmpObj.name;
                var mydomain = ZaAccount.getDomain(myaccount);
                var domainObj =  ZaDomain.getDomainByName(mydomain);

                if (myitem == "admin@"+mydomain || myitem == "root@"+mydomain || myitem == "postmaster@"+mydomain || myitem == "domainadmin@"+mydomain) {
                    isDeleteEnabled = false;
                }
                if (domainObj.attrs[ZaDomain.A_zimbraGalAccountId]){
                 if (myitem == domainObj.attrs[ZaDomain.A_zimbraGalAccountId]){
                        isDeleteEnabled = false;}
                }
                if (ZaApp.getInstance().getGlobalConfig().attrs[ZaGlobalConfig.A_zimbraSpamAccount]){
                        if (myitem == ZaApp.getInstance().getGlobalConfig().attrs[ZaGlobalConfig.A_zimbraSpamAccount].toString()){
                                isDeleteEnabled = false;}
                }
                if (ZaApp.getInstance().getGlobalConfig().attrs[ZaGlobalConfig.A_zimbraHamAccount]){
                        if (myitem == ZaApp.getInstance().getGlobalConfig().attrs[ZaGlobalConfig.A_zimbraHamAccount].toString()){
                                isDeleteEnabled = false;}
                }
                if (ZaApp.getInstance().getGlobalConfig().attrs[ZaGlobalConfig.A_zimbraAmavisQAccount]){
                        if (myitem == ZaApp.getInstance().getGlobalConfig().attrs[ZaGlobalConfig.A_zimbraAmavisQAccount].toString()){
                               isDeleteEnabled = false;}
                }
                if (ZaApp.getInstance().getGlobalConfig().attrs[ZaGlobalConfig.A_zimbraWikiAccount]){
                        if (myitem == ZaApp.getInstance().getGlobalConfig().attrs[ZaGlobalConfig.A_zimbraWikiAccount].toString()){
                               isDeleteEnabled = false;}
                }
                if (tmpObj.attrs[ZaAccount.A_isCCAccount]){
                        isDeleteEnabled = false;
                }
        }

    if (tmpObj.attrs && tmpObj.attrs[ZaAccount.A_zimbraIsSystemAccount] == "TRUE"){
            isDeleteEnabled = false;
    }

    if (!isDeleteEnabled) {
        if(this._popupOperations[ZaOperation.DELETE])
            this._popupOperations[ZaOperation.DELETE].enabled = isDeleteEnabled;
    }

	if(!ZaItem.hasRight(ZaAccount.REINDEX_MBX_RIGHT,this._currentObject))	{
        if(this._popupOperations[ZaOperation.REINDEX_MAILBOX])
            this._popupOperations[ZaOperation.REINDEX_MAILBOX].enabled = isDeleteEnabled;
	}

    if(!ZaItem.hasWritePermission(ZaAccount.A_zimbraAuthTokenValidityValue,this._currentObject)) {
        if(this._popupOperations[ZaOperation.EXPIRE_SESSION]) {
            this._popupOperations[ZaOperation.EXPIRE_SESSION].enabled = false;
        }
    }

    var isToEnable = (this._view && this._view.isDirty());


    if(this._popupOperations[ZaOperation.SAVE]) {
        this._popupOperations[ZaOperation.SAVE].enabled = isToEnable;
    }

    ZaZimbraAdmin.getInstance().getCurrentAppBar().enableButton(ZaOperation.SAVE, false);
}
ZaController.changeActionsStateMethods["ZaAccountViewController"].push(ZaAccountViewController.changeActionsStateMethod);


//Private/protected methods
/**
* saves the changes in the fields, calls modify or create on the current ZaAccount
* @return Boolean - indicates if the changes were succesfully saved
**/
ZaAccountViewController.prototype._saveChanges =
function () {
	//check if the XForm has any errors
	if(this._view.getMyForm().hasErrors()) {
		var errItems = this._view.getMyForm().getItemsInErrorState();
		var dlgMsg = ZaMsg.CORRECT_ERRORS;
		dlgMsg +=  "<br><ul>";
		var i = 0;
		for(var key in errItems) {
			if(i > 19) {
				dlgMsg += "<li>...</li>";
				break;
			}
			if(key == "size") continue;
			var label = errItems[key].getInheritedProperty("msgName");
			if(!label && errItems[key].getParentItem()) { //this might be a part of a composite
				label = errItems[key].getParentItem().getInheritedProperty("msgName");
			}
			if(label) {
				if(label.substring(label.length-1,1)==":") {
					label = label.substring(0, label.length-1);
				}
			}			
			if(label) {
				dlgMsg += "<li>";
				dlgMsg +=label;			
				dlgMsg += "</li>";
			}
			i++;
		}
		dlgMsg += "</ul>";
		this.popupMsgDialog(dlgMsg, true);
		return false;
	}
	//check if the data is copmlete 
	var tmpObj = this._view.getObject();	
	
	//Check the data
	if(tmpObj.attrs == null ) {
		//show error msg
		this._errorDialog.setMessage(ZaMsg.ERROR_UNKNOWN, null, DwtMessageDialog.CRITICAL_STYLE, null);
		this._errorDialog.popup();		
		return false;	
	}
		
	var mods = new Object();
    
	if(!AjxUtil.isEmpty(tmpObj.attrs[ZaAccount.A_COSId]) && !ZaItem.ID_PATTERN.test(tmpObj.attrs[ZaAccount.A_COSId]))  {
    	var cos = ZaCos.getCosByName(tmpObj.attrs[ZaAccount.A_COSId]);
    	if(cos) {
    		tmpObj.attrs[ZaAccount.A_COSId] = cos.id;
    		tmpObj._defaultValues = cos;
    	} else {
    		this.popupErrorDialog(AjxMessageFormat.format(ZaMsg.ERROR_NO_SUCH_COS,[tmpObj.attrs[ZaAccount.A_COSId]]));
    		return false;
    	}
    } 
	
	if(!ZaAccount.checkValues(tmpObj))
		return false;
	
	//change password if new password is provided
	if(tmpObj.attrs[ZaAccount.A_password]!=null && tmpObj[ZaAccount.A2_confirmPassword]!=null && tmpObj.attrs[ZaAccount.A_password].length > 0) {
		try {
			this._currentObject.changePassword(tmpObj.attrs[ZaAccount.A_password]);
		} catch (ex) {
			this.popupErrorDialog(ZaMsg.FAILED_SAVE_ACCOUNT, ex);
			return false;	
		}
	}

	//set the cosId to "" if the autoCos is enabled.
	if (tmpObj[ZaAccount.A2_autoCos] == "TRUE") {
		tmpObj.attrs[ZaAccount.A_COSId] = "" ;
	}
	
	//transfer the fields from the tmpObj to the _currentObject
	for (var a in tmpObj.attrs) {
		if(a == ZaAccount.A_password || a==ZaAccount.A_zimbraMailAlias || a == ZaItem.A_objectClass
                || a==ZaAccount.A2_mbxsize || a==ZaAccount.A_mail || a == ZaItem.A_zimbraId
                || a == ZaAccount.A_zimbraAvailableSkin || a == ZaAccount.A_zimbraZimletAvailableZimlets
                || a == ZaItem.A_zimbraACE || a == ZaAccount.A_uid) {
			continue;
		}	
		if(!ZaItem.hasWritePermission(a,tmpObj)) {
			continue;
		}		
		//check if the value has been modified
		if ((this._currentObject.attrs[a] != tmpObj.attrs[a]) && !(this._currentObject.attrs[a] == undefined && tmpObj.attrs[a] === "")) {
			if(tmpObj.attrs[a] instanceof Array) {
                if (!this._currentObject.attrs[a]) this._currentObject.attrs[a] = [] ;
                if(!(this._currentObject.attrs[a] instanceof Array)) {
                	this._currentObject.attrs[a] = [this._currentObject.attrs[a]];
                }
                if( tmpObj.attrs[a].join(",").valueOf() !=  this._currentObject.attrs[a].join(",").valueOf()) {
					mods[a] = tmpObj.attrs[a];
				}
			} else {
				if(a === ZaAccount.A_manager) {
					mods[a] = this._getLDAPAttr(tmpObj.attrs[a]);				
				} else {
					mods[a] = tmpObj.attrs[a];
				}
			}				
		}
	}

	// TODO: We will use below code in ZCS-11977
	//check if blocked extensions are changed
	// if(ZaItem.hasWritePermission(ZaAccount.A_zimbraFileUploadBlockedFileTypes,tmpObj)) {
	// 	if(!AjxUtil.isEmpty(tmpObj.attrs[ZaAccount.A_zimbraFileUploadBlockedFileTypes])) {
	// 		if((
	// 				((!this._currentObject.attrs[ZaAccount.A_zimbraFileUploadBlockedFileTypes] || !this._currentObject.attrs[ZaAccount.A_zimbraFileUploadBlockedFileTypes].length))
	// 				|| (tmpObj.attrs[ZaAccount.A_zimbraFileUploadBlockedFileTypes] != this._currentObject.attrs[ZaAccount.A_zimbraFileUploadBlockedFileTypes]))
	// 				&& !(tmpObj.attrs[ZaAccount.A_zimbraFileUploadBlockedFileTypes] instanceof Array)
	// 			) {
	// 			mods[ZaAccount.A_zimbraFileUploadBlockedFileTypes] = tmpObj.attrs[ZaAccount.A_zimbraFileUploadBlockedFileTypes].split(',');
	// 		}
	// 	} else if (AjxUtil.isEmpty(tmpObj.attrs[ZaAccount.A_zimbraFileUploadBlockedFileTypes])  && !AjxUtil.isEmpty(this._currentObject.attrs[ZaAccount.A_zimbraFileUploadBlockedFileTypes])) {
	// 		mods[ZaAccount.A_zimbraFileUploadBlockedFileTypes] = "";
	// 	}
	// }

	if(ZaTabView.isTAB_ENABLED(this._currentObject,ZaAccountXFormView.SKIN_TAB_ATTRS, ZaAccountXFormView.SKIN_TAB_RIGHTS)) {
		if(tmpObj.attrs[ZaAccount.A_zimbraAvailableSkin] != null) {
			if(!(tmpObj.attrs[ZaAccount.A_zimbraAvailableSkin] instanceof Array)) {
				mods[ZaAccount.A_zimbraAvailableSkin] = [tmpObj.attrs[ZaAccount.A_zimbraAvailableSkin]];
			} else {
				var cnt = tmpObj.attrs[ZaAccount.A_zimbraAvailableSkin].length;
				mods[ZaAccount.A_zimbraAvailableSkin] = [];
				for(var i = 0; i < cnt; i++) {
					mods[ZaAccount.A_zimbraAvailableSkin].push(tmpObj.attrs[ZaAccount.A_zimbraAvailableSkin][i]);
				}
			}
		} else if(this._currentObject.attrs[ZaAccount.A_zimbraAvailableSkin] != null) {
			mods[ZaAccount.A_zimbraAvailableSkin] = "";
		}
	}
		
	if(ZaTabView.isTAB_ENABLED(this._currentObject,ZaAccountXFormView.ZIMLET_TAB_ATTRS, ZaAccountXFormView.ZIMLET_TAB_RIGHTS)) {
		if(tmpObj.attrs[ZaAccount.A_zimbraZimletAvailableZimlets] != null) {
			if(!(tmpObj.attrs[ZaAccount.A_zimbraZimletAvailableZimlets] instanceof Array)) {
				mods[ZaAccount.A_zimbraZimletAvailableZimlets] = [tmpObj.attrs[ZaAccount.A_zimbraZimletAvailableZimlets]];
			} else {
				var cnt = tmpObj.attrs[ZaAccount.A_zimbraZimletAvailableZimlets].length;
				if(cnt==0) {
					//no zimlets
					if(this._currentObject.attrs[ZaAccount.A_zimbraZimletAvailableZimlets] == null || !(this._currentObject.attrs[ZaAccount.A_zimbraZimletAvailableZimlets].length==1 && this._currentObject.attrs[ZaAccount.A_zimbraZimletAvailableZimlets][0] == ZaZimlet.NULL_ZIMLET))
						mods[ZaAccount.A_zimbraZimletAvailableZimlets] = [ZaZimlet.NULL_ZIMLET];
				} else {
					mods[ZaAccount.A_zimbraZimletAvailableZimlets] = [];
					for(var i = 0; i < cnt; i++) {
						mods[ZaAccount.A_zimbraZimletAvailableZimlets].push(tmpObj.attrs[ZaAccount.A_zimbraZimletAvailableZimlets][i]);
					}
				}
			}
		} else if(this._currentObject.attrs[ZaAccount.A_zimbraZimletAvailableZimlets] != null) {
			mods[ZaAccount.A_zimbraZimletAvailableZimlets] = "";
		}
	}
     //  save and keep the current tab
    if (this._currentObject[ZaModel.currentTab]!= tmpObj[ZaModel.currentTab])
             this._currentObject[ZaModel.currentTab] = tmpObj[ZaModel.currentTab];
	//save changed fields
	try {	
		this._currentObject.modify(mods, tmpObj);
	} catch (ex) {
		if(ex.code == ZmCsfeException.ACCT_EXISTS) {
			this.popupErrorDialog(ZaMsg.FAILED_CREATE_ACCOUNT_1, ex);
		} else if(ex.code == ZmCsfeException.NO_SUCH_COS) {
			this.popupErrorDialog(AjxMessageFormat.format(ZaMsg.ERROR_NO_SUCH_COS,[tmpObj.attrs[ZaAccount.A_COSId]]), ex);
        } else {
			this._handleException(ex, "ZaAccountViewController.prototype._saveChanges", null, false);	
		}
		return false;
	}

	if(tmpObj.attrs[ZaAccount.A_zimbraMailTransport]) {
		var v = tmpObj.attrs[ZaAccount.A_zimbraMailTransport];
		if(!this.isLegalofMailTransport(v)) return false;
	}

	//add-remove aliases
	var tmpObjCnt = -1;
	var currentObjCnt = -1;
	if(ZaTabView.isTAB_ENABLED(this._currentObject,ZaAccountXFormView.ALIASES_TAB_ATTRS, ZaAccountXFormView.ALIASES_TAB_RIGHTS)) {
		if(tmpObj.attrs[ZaAccount.A_zimbraMailAlias]) {
			if(typeof tmpObj.attrs[ZaAccount.A_zimbraMailAlias] == "string") {
				var tmpStr = tmpObj.attrs[ZaAccount.A_zimbraMailAlias];
				tmpObj.attrs[ZaAccount.A_zimbraMailAlias] = new Array();
				tmpObj.attrs[ZaAccount.A_zimbraMailAlias].push(tmpStr);
			}
			tmpObjCnt = tmpObj.attrs[ZaAccount.A_zimbraMailAlias].length - 1;
		}
		
		if(this._currentObject.attrs[ZaAccount.A_zimbraMailAlias]) {
			if(typeof this._currentObject.attrs[ZaAccount.A_zimbraMailAlias] == "string") {
				var tmpStr = this._currentObject.attrs[ZaAccount.A_zimbraMailAlias];
				this._currentObject.attrs[ZaAccount.A_zimbraMailAlias] = new Array();
				this._currentObject.attrs[ZaAccount.A_zimbraMailAlias].push(tmpStr);
			}
			currentObjCnt = this._currentObject.attrs[ZaAccount.A_zimbraMailAlias].length - 1;
		}
	
		//diff two arrays
		for(var tmpIx=tmpObjCnt; tmpIx >= 0; tmpIx--) {
			for(var currIx=currentObjCnt; currIx >=0; currIx--) {
				if(tmpObj.attrs[ZaAccount.A_zimbraMailAlias][tmpIx] == this._currentObject.attrs[ZaAccount.A_zimbraMailAlias][currIx]) {
					//this alias already exists
					tmpObj.attrs[ZaAccount.A_zimbraMailAlias].splice(tmpIx,1);
					this._currentObject.attrs[ZaAccount.A_zimbraMailAlias].splice(currIx,1);
					break;
				}
			}
		}
		//remove the aliases 
		if(currentObjCnt != -1) {
			currentObjCnt = this._currentObject.attrs[ZaAccount.A_zimbraMailAlias].length;
		} 
		try {
			for(var ix=0; ix < currentObjCnt; ix++) {
				this._currentObject.removeAlias(this._currentObject.attrs[ZaAccount.A_zimbraMailAlias][ix]);
			}
		} catch (ex) {
			this._handleException(ex, "ZaAccountViewController.prototype._saveChanges", null, false);
			return false;
		}
		if(tmpObjCnt != -1) {
			tmpObjCnt = tmpObj.attrs[ZaAccount.A_zimbraMailAlias].length;
		}
		var failedAliases = "";
		var failedAliasesCnt = 0;
		try {
			for(var ix=0; ix < tmpObjCnt; ix++) {
				try {
					if(tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]) {
						if(tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix].indexOf("@") != tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix].lastIndexOf("@")) {
							//show error msg
							this._errorDialog.setMessage(AjxMessageFormat.format(ZaMsg.ERROR_ALIAS_INVALID,[tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]]), null, DwtMessageDialog.CRITICAL_STYLE, null);
							this._errorDialog.popup();		
							break;						
						}						
						this._currentObject.addAlias(tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]);
					}
				} catch (ex) {
					if(ex.code == ZmCsfeException.ACCT_EXISTS) {
						//if failed because account exists just show a warning
						var account = this._findAlias(tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]);
						switch(account.type) {
							case ZaItem.DL:
								if(account.name == tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]) {
									failedAliases += "<br>" +AjxMessageFormat.format(ZaMsg.WARNING_EACH_ALIAS3,[account.name]);								
								} else {
									failedAliases += "<br>" +AjxMessageFormat.format(ZaMsg.WARNING_EACH_ALIAS4,[account.name, tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]]);								
								}
							break;
							case ZaItem.ACCOUNT:
								if(account.name == tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]) {
									failedAliases += "<br>" +AjxMessageFormat.format(ZaMsg.WARNING_EACH_ALIAS2,[account.name]);								
								} else {
									failedAliases += "<br>" +AjxMessageFormat.format(ZaMsg.WARNING_EACH_ALIAS1,[account.name, tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]]);								
								}							
							break;	
							case ZaItem.RESOURCE:
								if(account.name == tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]) {
									failedAliases += "<br>" +AjxMessageFormat.format(ZaMsg.WARNING_EACH_ALIAS5,[account.name]);								
								} else {
									failedAliases += "<br>" +AjxMessageFormat.format(ZaMsg.WARNING_EACH_ALIAS6,[account.name, tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]]);								
								}							
							break;							
							default:
								failedAliases += "<br>" +AjxMessageFormat.format(ZaMsg.WARNING_EACH_ALIAS0,[tmpObj.attrs[ZaAccount.A_zimbraMailAlias][ix]]);							
							break;
						}
						failedAliasesCnt++;
					} else {
						//if failed for another reason - jump out
						throw (ex);
					}
				}
			}
	
			if(failedAliasesCnt == 1) {
				this._errorDialog.setMessage(AjxMessageFormat.format(ZaMsg.WARNING_ALIAS_EXISTS, [failedAliases]), "", DwtMessageDialog.WARNING_STYLE, ZabMsg.zimbraAdminTitle);
				this._errorDialog.popup();			
			} else if(failedAliasesCnt > 1) {
				this._errorDialog.setMessage(AjxMessageFormat.format(ZaMsg.WARNING_ALIASES_EXIST, [failedAliases]), "", DwtMessageDialog.WARNING_STYLE, ZabMsg.zimbraAdminTitle);
				this._errorDialog.popup();			
			}
		} catch (ex) {
			this.popupErrorDialog(ZaMsg.FAILED_ADD_ALIASES, ex);	
			return false;
		}
	}
	
	//check to see if the rename of account is needed.
	var newName=null;
	if(this._currentObject && tmpObj.name != this._currentObject.name) {
		//var emailRegEx = /^([a-zA-Z0-9_\-])+((\.)?([a-zA-Z0-9_\-])+)*@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
		/*if(!AjxUtil.EMAIL_SHORT_RE.test(tmpObj.name) ) {
			//show error msg
			this._errorDialog.setMessage(ZaMsg.ERROR_ACCOUNT_NAME_INVALID, null, DwtMessageDialog.CRITICAL_STYLE, null);
			this._errorDialog.popup();		
			return false;
		}*/
		newName = tmpObj.name;
	}
	
	if(newName) {
		try {
			this._currentObject.rename(newName);
		} catch (ex) {
			if(ex.code == ZmCsfeException.ACCT_EXISTS) {
				this.popupErrorDialog(ZaMsg.FAILED_RENAME_ACCOUNT_1, ex);
			} else {
				this._handleException(ex, "ZaAccountViewController.prototype._saveChanges", null, false);	
			}
			return false;
		}
	}

    ZaApp.getInstance().getAppCtxt().getAppController().setActionStatusMsg(AjxMessageFormat.format(ZaMsg.AccountModified,[this._currentObject.name]));
    //TODO: may need to check if the account type update is needed. update the domain account limits object
    return true;
}

ZaAccountViewController.prototype.getPopUpOperation =
function() {
    return this._popupOperations;
}

// new button was pressed
ZaAccountViewController.prototype._newButtonListener =
function(ev) {
	try {
		var newAccount = new ZaAccount();
		newAccount.loadNewObjectDefaults("name", ZaSettings.myDomainName);		
		if(!ZaApp.getInstance()._newAccountWizard)
			ZaApp.getInstance()._newAccountWizard = new ZaNewAccountXWizard(this._container,newAccount);
        else { //update the account type if needed
            ZaApp.getInstance()._newAccountWizard.updateAccountType () ;    
        }

        ZaApp.getInstance()._newAccountWizard.setObject(newAccount);
		ZaApp.getInstance()._newAccountWizard.popup();
	} catch (ex) {
		this._handleException(ex, "ZaAccountViewController.prototype._newButtonListener", null, false);
	}
}

ZaAccountViewController.prototype._expireSessionListener =
function(ev) {
	try {
		if(this._currentObject) {
			var item = this._currentObject;

			if(ZaItem.hasWritePermission(ZaAccount.A_zimbraAuthTokenValidityValue,item)) {
				ZaApp.getInstance().dialogs["confirmMessageDialog"].setMessage(ZaMsg.WARN_EXPIRE_SESSIONS, DwtMessageDialog.WARNING_STYLE);
				ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.YES_BUTTON, ZaAccountListController.prototype.expireSessions, this, [item]);
				ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.NO_BUTTON, this.closeCnfrmDlg, this, null);
				ZaApp.getInstance().dialogs["confirmMessageDialog"].popup();
			} else {
				this.popupMsgDialog(AjxMessageFormat.format(ZaMsg.ERROR_NO_PERMISSION_FOR_OPERATION_ON, [item.name ? item.name : item.attrs[ZaAccount.A_accountName]]), true);
			}
		}
 	}catch(ex){
		this._handleException(ex, "ZaAccountViewController.prototype._expireSessionListener", null, false);
	}
}

ZaAccountViewController.prototype._reindexMbxListener = 
function (ev) {
	try {

		if(!ZaApp.getInstance().dialogs["reindexWizard"])
			ZaApp.getInstance().dialogs["reindexWizard"] = new ReindexMailboxXDialog(this._container);	

		var obj = new ZaReindexMailbox();
		obj.mbxId = this._currentObject.id;
		ZaApp.getInstance().dialogs["reindexWizard"].setObject(obj);
		ZaApp.getInstance().dialogs["reindexWizard"].popup();
	} catch (ex) {
		this._handleException(ex, "ZaAccountViewController.prototype._reindexMbxListener", null, false);
	}

}

ZaAccountViewController.prototype._viewMailListener =
function(ev) {
	try {
		if(this._currentObject && this._currentObject.id) {
			ZaAccountListController._viewMailListenerLauncher.call(this, this._currentObject);
		}
	} catch (ex) {
		this._handleException(ex, "ZaAccountViewController.prototype._viewMailListener", null, false);			
	}
}

ZaAccountViewController.prototype._handleException = 
function (ex, method, params, restartOnError, obj) {
	if(ex.code == ZmCsfeException.SVC_WRONG_HOST) {
		var szMsg = ZaMsg.ERROR_WRONG_HOST;
		if(ex.detail) {
			szMsg +="<br>Details:<br>";
			szMsg += ex.detail;
		}
		this._errorDialog.setMessage(szMsg, null, DwtMessageDialog.CRITICAL_STYLE, null);
		this._errorDialog.popup();					
	} else if(ex.code == ZmCsfeException.ACCT_EXISTS) {
		this._errorDialog.setMessage(ZaMsg.ERROR_ACCOUNT_EXISTS, null, DwtMessageDialog.CRITICAL_STYLE, null);
		this._errorDialog.popup();
	} else {
		ZaController.prototype._handleException.call(this, ex, method, params, restartOnError, obj);				
	}	
}

ZaAccountViewController.prototype.isLegalofMailTransport =
function(elementValue) {
	if(!elementValue) return false;

	var regex = new RegExp("(lmtp|smtp|LMTP|SMTP)\\:[\\w\\.\\-]+\\:[0-9]+$");
	var match = regex.exec(elementValue);
	if(match != null) {
		return true;
	}
	else {
		this._errorDialog.setMessage(ZaMsg.ERROR_MAILTRANSPORT_INVALID, null, DwtMessageDialog.CRITICAL_STYLE, null);
		this._errorDialog.popup();
	}
	return false;	
}

ZaAccountViewController.prototype._getLDAPAttr = 
function(email) {
	if (email) {
		let attrString = 'uid=';
		let emailStringArray = email.split('@');
		attrString = attrString + emailStringArray[0] + ',ou=people';
		emailStringArray = emailStringArray.length > 1 && emailStringArray[1].split('.');
		const reducer = function(accumulator, currentValue) { return accumulator + ',dc=' + currentValue };
		attrString = emailStringArray.reduce(reducer, attrString);
		return attrString;
	}
}
}
//AjxPackage.require("zimbraAdmin.accounts.controller.ZaAccAliasesController");
if (AjxPackage.define("zimbraAdmin.cos.controller.ZaCosListController")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

ZaCosListController = function(appCtxt, container) {
	ZaListViewController.call(this, appCtxt, container,"ZaCosListController");
	this.objType = ZaEvent.S_COS;
    this._defaultType = ZaItem.COS;
	this._currentSortField = ZaCos.A_name;
	this._currentPageNum = 1;
	this._currentSortOrder = "1";
	this._helpURL = location.pathname + ZaUtil.HELP_URL + "cos/class_of_service.htm?locid="+AjxEnv.DEFAULT_LOCALE;
	this._helpButtonText = ZaMsg.helpManageCOS;
	this._currentQuery = "";
	this.fetchAttrs = [ZaCos.A_name,ZaCos.A_description].join();
	this.RESULTSPERPAGE = ZaDomain.RESULTSPERPAGE; 
	this.MAXSEARCHRESULTS = ZaDomain.MAXSEARCHRESULTS;	
}

ZaCosListController.prototype = new ZaListViewController();
ZaCosListController.prototype.constructor = ZaCosListController;
ZaController.initToolbarMethods["ZaCosListController"] = new Array();
ZaController.initPopupMenuMethods["ZaCosListController"] = new Array();
ZaController.changeActionsStateMethods["ZaCosListController"] = new Array(); 

//ZaCosListController.COS_VIEW = "ZaCosListController.COS_VIEW";

ZaCosListController.prototype.show = function (doPush,openInNewTab) {

    if(!ZaZimbraAdmin.hasGlobalCOSSListAccess() && this._currentQuery == "") {
        var cosNameList = ZaApp.getInstance()._cosNameList;
        if(!cosNameList || !(cosNameList instanceof Array) || cosNameList.length == 0) {
            this._list = new ZaItemList(ZaCos);
            this.numPages = 0;
            this._searchTotal = 0;
            if(doPush) this._show(this._list);
            else this._updateUI(this._list);
            return;
        }
        for(var i = 0; i < cosNameList.length; i++)
            this._currentQuery += "(" + ZaCos.A_name + "=" + cosNameList[i] + ")";
        if(cosNameList.length > 1)
            this._currentQuery = "(|" + this._currentQuery + ")";
    }

	var busyId = Dwt.getNextId () ;
	openInNewTab = openInNewTab ? openInNewTab : false;
	var callback = new AjxCallback(this, this.searchCallback, {openInNewTab:openInNewTab,limit:this.RESULTSPERPAGE,CONS:null,show:doPush,busyId:busyId});
	
	var searchParams = {
		query:this._currentQuery ,
		types:[ZaSearch.COSES],
		sortBy:this._currentSortField,
		offset:this.RESULTSPERPAGE*(this._currentPageNum-1),
		sortAscending:this._currentSortOrder,
		limit:this.RESULTSPERPAGE,
		callback:callback,
		attrs:this.fetchAttrs,
		controller: this,
		showBusy:true,
		busyId:busyId,
		busyMsg:ZaMsg.BUSY_SEARCHING_COSES,
		skipCallbackIfCancelled:false,
		isInitialRequest: true
	}
    this.scrollSearchParams={
        query:this._currentQuery ,
		types:[ZaSearch.COSES],
		sortBy:this._currentSortField,
		sortAscending:this._currentSortOrder,
		attrs:this.fetchAttrs,
		controller: this,
		showBusy:true,
		busyMsg:ZaMsg.BUSY_SEARCHING_COSES,
		skipCallbackIfCancelled:false
    };
	ZaSearch.searchDirectory(searchParams);
}

ZaCosListController.prototype.searchCallback = function(params, resp) {
	ZaListViewController.prototype.searchCallback.call(this, params, resp);
	var app = ZaApp.getInstance();
	app._cosList = this._list;
	app._cosListName = undefined;
};

ZaCosListController.prototype._show = 
function (list, openInNewTab, openInSearchTab, hasMore) {
	this._updateUI(list, openInNewTab, openInSearchTab, hasMore);
	ZaApp.getInstance().pushView(this.getContentViewId (), openInNewTab, openInSearchTab);
    return;
}


ZaCosListController.initPopupMenuMethod =
function () {
	if(ZaZimbraAdmin.canCreateCos()) {
   		this._popupOperations[ZaOperation.NEW]=new ZaOperation(ZaOperation.NEW,ZaMsg.TBB_New, ZaMsg.COSTBB_New_tt, "NewCOS", "NewCOSDis", new AjxListener(this, ZaCosListController.prototype._newButtonListener));
   		this._popupOperations[ZaOperation.DUPLICATE]=new ZaOperation(ZaOperation.DUPLICATE,ZaMsg.TBB_Duplicate, ZaMsg.COSTBB_Duplicate_tt, "DuplicateCOS", "DuplicateCOSDis", new AjxListener(this, ZaCosListController.prototype._duplicateButtonListener));
	}
   	this._popupOperations[ZaOperation.EDIT]=new ZaOperation(ZaOperation.EDIT,ZaMsg.TBB_Edit, ZaMsg.COSTBB_Edit_tt, "Properties", "PropertiesDis", new AjxListener(this, ZaCosListController.prototype._editButtonListener));    	    	
	this._popupOperations[ZaOperation.DELETE]=new ZaOperation(ZaOperation.DELETE,ZaMsg.TBB_Delete, ZaMsg.COSTBB_Delete_tt, "Delete", "DeleteDis", new AjxListener(this, ZaCosListController.prototype._deleteButtonListener));   		
}
ZaController.initPopupMenuMethods["ZaCosListController"].push(ZaCosListController.initPopupMenuMethod);

/**
* This method is called from {@link ZaController#_initToolbar}
**/
ZaCosListController.initToolbarMethod =
function () {
		
}
ZaController.initToolbarMethods["ZaCosListController"].push(ZaCosListController.initToolbarMethod);

//private and protected methods
ZaCosListController.prototype._createUI = 
function (openInNewTab, openInSearchTab) {
	this._contentView = new ZaCosListView(this._container, this._defaultType);
	ZaApp.getInstance()._controllers[this.getContentViewId ()] = this ;
	// create the menu operations/listeners first	
    //this._initToolbar();
	//always add Help and navigation buttons at the end of the toolbar    
	//this._toolbarOperations[ZaOperation.NONE] = new ZaOperation(ZaOperation.NONE);	
	//this._toolbarOperations[ZaOperation.PAGE_BACK]=new ZaOperation(ZaOperation.PAGE_BACK,ZaMsg.Previous, ZaMsg.PrevPage_tt, "LeftArrow", "LeftArrowDis",  new AjxListener(this, this._prevPageListener));
	
	//add the acount number counts
	
	//this._toolbarOperations[ZaOperation.PAGE_FORWARD]=new ZaOperation(ZaOperation.PAGE_FORWARD,ZaMsg.Next, ZaMsg.NextPage_tt, "RightArrow", "RightArrowDis", new AjxListener(this, this._nextPageListener));
	//this._toolbarOperations[ZaOperation.HELP]=new ZaOperation(ZaOperation.HELP,ZaMsg.TBB_Help, ZaMsg.TBB_Help_tt, "Help", "Help", new AjxListener(this, this._helpButtonListener));				

	//this._toolbar = new ZaToolBar(this._container, this._toolbarOperations,this._toolbarOrder, null, null, ZaId.VIEW_COSLIST);    
		
	var elements = new Object();
	elements[ZaAppViewMgr.C_APP_CONTENT] = this._contentView;
    ZaApp.getInstance().getAppViewMgr().createView(this.getContentViewId(), elements);

	this._initPopupMenu();
	this._actionMenu =  new ZaPopupMenu(this._contentView, "ActionMenu", null, this._popupOperations, ZaId.VIEW_COSLIST, ZaId.MENU_POP);
	
	//set a selection listener on the account list view
	this._contentView.addSelectionListener(new AjxListener(this, this._listSelectionListener));
	this._contentView.addActionListener(new AjxListener(this, this._listActionListener));			
	this._removeConfirmMessageDialog = ZaApp.getInstance().dialogs["removeConfirmMessageDialog"] = new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.YES_BUTTON, DwtDialog.NO_BUTTON], null, ZaId.CTR_PREFIX + ZaId.VIEW_COSLIST + "_removeConfirm");			
		
	this._UICreated = true;
}


// refresh button was pressed
ZaCosListController.prototype._refreshButtonListener =
function(ev) {
	this.refresh();
}


// duplicate button was pressed
ZaCosListController.prototype._duplicateButtonListener =
function(ev) {
	if(this._contentView && (this._contentView.getSelectionCount() == 1)) {
		var newCos = new ZaCos(); //new COS
		var item = this._contentView.getSelection()[0];
		if(item) { //copy the attributes from the selected COS to the new COS
            //need to get the cos first since rights, getAttrs and setAttrs are not in the cos list object
            if (item.id) {
                item.load ("id", item.id) ;
            }

            if ( item.attrs ) {
                for(var aname in item.attrs) {
                    if( (aname == ZaItem.A_objectClass) || (aname == ZaItem.A_zimbraId) || (aname == ZaCos.A_name) || (aname == ZaCos.A_description) || (aname == ZaCos.A_zimbraNotes) || (aname == ZaItem.A_zimbraCreateTimestamp) )
                        continue;

                    if ( (typeof item.attrs[aname] == "object") || (item.attrs[aname] instanceof Array)) {
                        newCos.attrs[aname] = AjxUtil.createProxy(item.attrs[aname],3);
                        /*for(var a in item.attrs[aname]) {
                            newCos.attrs[aname][a]=item.attrs[aname][a];
                        }*/
                    } else {
                        newCos.attrs[aname] = item.attrs[aname];
                    }
                }
            }


            newCos.attrs[ZaCos.A_zimbraNotes] = AjxMessageFormat.format(ZaMsg.COSTBB_DuplicatingFrom_tt, [item.attrs[ZaCos.A_name]]);
            //explicitly note the user this is duplicated from the one they select,
            //instead of showing nothing at the first page of ZaNewCosXWizard

            if (item.getAttrs)   {
                newCos.getAttrs = item.getAttrs ;
            }

            if (item.setAttrs) {
                newCos.setAttrs = item.setAttrs ;
            }

            if (item.rights) {
                newCos.rights = item.rights ;
            }
        }

        ZaCosListController.showMe.call(this, newCos);
	}
}

// new button was pressed
ZaCosListController.prototype._newButtonListener =
function(ev) {
	var newCos = new ZaCos();
	//load default COS
	var defCos = ZaCos.getCosByName("default");
	newCos.loadNewObjectDefaults();
	newCos.rights[ZaCos.RENAME_COS_RIGHT]=true;
	newCos.rights[ZaCos.CREATE_COS_RIGHT]=true;
	//copy values from default cos to the new cos
	for(var aname in defCos.attrs) {
		if( (aname == ZaItem.A_objectClass) || (aname == ZaItem.A_zimbraId) || (aname == ZaCos.A_name) || (aname == ZaCos.A_description) || (aname == ZaCos.A_notes) || (aname == ZaItem.A_zimbraCreateTimestamp))
			continue;			
		newCos.attrs[aname] = defCos.attrs[aname];
	}

    ZaCosListController.showMe.call(this, newCos);
}

/**
* This listener is called when the item in the list is double clicked. It call ZaCosController.show method
* in order to display the Cos View
**/
ZaCosListController.prototype._listSelectionListener =
function(ev) {
	if (ev.detail == DwtListView.ITEM_DBL_CLICKED) {
		if(ev.item) {
			ZaApp.getInstance().getCosController().show(ev.item);
            var parentPath = ZaTree.getPathByArray([ZaMsg.OVP_home, ZaMsg.OVP_configure, ZaMsg.OVP_cos]);
            ZaZimbraAdmin.getInstance().getOverviewPanelController().addObjectItem(parentPath, ev.item.name, null, false, false, ev.item, undefined, true);
		}
	} else {
		this.changeActionsState();	
	}
}


ZaCosListController.prototype._listActionListener =
function (ev) {
	this.changeActionsState();
	this._actionMenu.popup(0, ev.docX, ev.docY);
}

/**
* This listener is called when the Edit button is clicked. 
* It call ZaCosListController.show method
* in order to display the COS View
**/
ZaCosListController.prototype._editButtonListener =
function(ev) {
	if(this._contentView.getSelectionCount() == 1) {
		var item = this._contentView.getSelection()[0];
        this._editItem(item);
	}
}

ZaCosListController.prototype._editItem =
function(item) {
    ZaApp.getInstance().getCosController().show(item);
    var parentPath = ZaTree.getPathByArray([ZaMsg.OVP_home, ZaMsg.OVP_configure, ZaMsg.OVP_cos]);
    ZaZimbraAdmin.getInstance().getOverviewPanelController().addObjectItem(parentPath, item.name, null, false, false, item);
}

/**
* This listener is called when the Delete button is clicked. 
**/
ZaCosListController.prototype._deleteButtonListener =
function(ev) {
	this._removeList = new Array();
	this._itemsInTabList = [] ;
	if(this._contentView.getSelectionCount() > 0) {
		var arrItems = this._contentView.getSelection();
		var cnt = arrItems.length;
		for(var key =0; key < cnt; key++) {
			var item = arrItems[key];
			if (item) {
				//detect whether the deleting item is open in a tab
				if (ZaApp.getInstance().getTabGroup() && ZaApp.getInstance().getTabGroup().getTabByItemId (item.id)) {
					this._itemsInTabList.push (item) ;
				}else{
					this._removeList.push(item);
				}
			}
		}
	}
	
	if (this._itemsInTabList.length > 0) {
		if(!ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"]) {
			ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"] = 
				new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.CANCEL_BUTTON], 
						[ZaMsgDialog.CLOSE_TAB_DELETE_BUTTON_DESC , ZaMsgDialog.NO_DELETE_BUTTON_DESC],
						ZaId.CTR_PREFIX + ZaId.VIEW_COSLIST + "_ConfirmDeleteItemsInTab");			
		}
		
		
		var msg = ZaMsg.dl_warning_delete_accounts_in_tab ; ;
		msg += ZaCosListController.getDlMsgFromList (this._itemsInTabList) ;
		
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].setMessage(msg, DwtMessageDialog.WARNING_STYLE);	
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].registerCallback(
				ZaMsgDialog.CLOSE_TAB_DELETE_BUTTON, ZaCosListController.prototype._closeTabsBeforeRemove, this);
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].registerCallback(
				ZaMsgDialog.NO_DELETE_BUTTON, ZaCosListController.prototype._deleteCosInRemoveList, this);		
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].popup();
		
	}else{
		this._deleteCosInRemoveList ();
	}
}

ZaCosListController.prototype._closeTabsBeforeRemove =
function () {
	//DBG.println (AjxDebug.DBG1, "Close the tabs before Remove ...");
	this.closeTabsInRemoveList() ;
	/*
	var tabGroup = ZaApp.getInstance().getTabGroup();
	for (var i=0; i< this._itemsInTabList.length ; i ++) {
		var item = this._itemsInTabList[i];
		tabGroup.removeTab (tabGroup.getTabByItemId(item.id)) ;
		this._removeList.push(item);
	}*/
	//ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].popdown();
	this._deleteCosInRemoveList();
}

ZaCosListController.prototype._deleteCosInRemoveList =
function () {
	if (ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"]) {
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].popdown();
	}
	if(this._removeList.length) {
		var dlgMsg = ZaMsg.Q_DELETE_COSES;
		dlgMsg += ZaCosListController.getDlMsgFromList (this._removeList) ;
		this._removeConfirmMessageDialog.setMessage(dlgMsg, DwtMessageDialog.INFO_STYLE);
		this._removeConfirmMessageDialog.registerCallback(DwtDialog.YES_BUTTON, ZaCosListController.prototype._deleteCosCallback, this);
		this._removeConfirmMessageDialog.registerCallback(DwtDialog.NO_BUTTON, ZaCosListController.prototype._donotDeleteCosCallback, this);		
		this._removeConfirmMessageDialog.popup();
	}
	
} 

ZaCosListController.getDlMsgFromList =
function (listArr) {
	dlgMsg =  "<br><ul>";
	var i=0, name;

	for(var key in listArr) {
		if(i > 19) {
			dlgMsg += "<li>...</li>";
			break;
		}
		dlgMsg += "<li>";

		name = listArr[key].name;
		if(name.length > 50) {
			//split it
			var endIx = 49;
			var beginIx = 0; //
			while(endIx < name.length) { //
				dlgMsg +=  AjxStringUtil.htmlEncode(name.slice(beginIx, endIx)); //
				beginIx = endIx + 1; //
				if(beginIx >= (name.length) ) //
					break;
				
				endIx = ( name.length <= (endIx + 50) ) ? name.length-1 : (endIx + 50);
				dlgMsg +=  "<br>";	
			}
		} else {
			dlgMsg += AjxStringUtil.htmlEncode(name);
		}
		dlgMsg += "</li>";
		i++;
	}
	dlgMsg += "</ul>";
	
	return dlgMsg ;
}


ZaCosListController.prototype._deleteCosCallback = 
function () {
	var successRemList=new Array();
	for(var key in this._removeList) {
		if(this._removeList[key]) {
			try {
				this._removeList[key].remove();
				successRemList.push(this._removeList[key]);				
			} catch (ex) {
				this._removeConfirmMessageDialog.popdown();
				this._handleException(ex, ZaCosListController.prototype._deleteCosCallback, null, false);
				return;
			}
		}
		if (this._list) this._list.remove(this._removeList[key]); //remove from the list
	}
	this.fireRemovalEvent(successRemList); 	
	this._removeConfirmMessageDialog.popdown();
	if (this._contentView) this._contentView.setUI();
	this.show();
}

ZaCosListController.prototype._donotDeleteCosCallback = 
function () {
	this._removeList = new Array();
	this._removeConfirmMessageDialog.popdown();
}

ZaCosListController.changeActionsStateMethod = 
function (enableArray,disableArray) {
	if(!this._contentView)
		return;
	
	var cnt = this._contentView.getSelectionCount();
	var hasDefault = false;
	if(cnt >= 1) {
		var arrDivs = this._contentView.getSelectedItems().getArray();
		for(var key in arrDivs) {
			var item = this._contentView.getItemFromElement(arrDivs[key]);
			if(item) {
				if(item.name == "default") {
					hasDefault = true;
					break;
				}		
			}
		}
	}
	if(cnt == 1) {
		var item = this._contentView.getSelection()[0];
		if(item) {
			if(hasDefault) {
				if(this._popupOperations[ZaOperation.DELETE]) {
					this._popupOperations[ZaOperation.DELETE].enabled=false;
				}
			} else {
				if (AjxUtil.isEmpty(item.rights)) {
					item.loadEffectiveRights("id", item.id, false);
				}
				if(!ZaItem.hasRight(ZaCos.DELETE_COS_RIGHT, item)) {
					if(this._popupOperations[ZaOperation.DELETE]) {
						this._popupOperations[ZaOperation.DELETE].enabled=false;
					}
				}
			}
		}
	} else if (cnt > 1){
		if(hasDefault) {
			if(this._popupOperations[ZaOperation.DELETE]) {
				this._popupOperations[ZaOperation.DELETE].enabled=false;
			}					
		}
		
		if(this._popupOperations[ZaOperation.DUPLICATE] && this._popupOperations[ZaOperation.DUPLICATE].enabled) {
			this._popupOperations[ZaOperation.DUPLICATE].enabled=false;
		}		
		if(this._popupOperations[ZaOperation.EDIT]) {
			this._popupOperations[ZaOperation.EDIT].enabled=false;
		}					
	} else {
		if(this._popupOperations[ZaOperation.EDIT]) {
			this._popupOperations[ZaOperation.EDIT].enabled=false;
		}	
		if(this._popupOperations[ZaOperation.DELETE]) {
			this._popupOperations[ZaOperation.DELETE].enabled=false;
		}	
		if(this._popupOperations[ZaOperation.DUPLICATE] && this._popupOperations[ZaOperation.DUPLICATE].enabled) {
			this._popupOperations[ZaOperation.DUPLICATE].enabled=false;
		}		
	}
}
ZaController.changeActionsStateMethods["ZaCosListController"].push(ZaCosListController.changeActionsStateMethod);

ZaCosListController.showMe = function(newCos)
{
    if(!ZaApp.getInstance().dialogs["newCosXWizard"]){
        ZaApp.getInstance().dialogs["newCosXWizard"] = new ZaNewCosXWizard(this._container,newCos);
    }
    ZaApp.getInstance().dialogs["newCosXWizard"].setObject(newCos);
    ZaApp.getInstance().dialogs["newCosXWizard"].popup();
}
}
if (AjxPackage.define("zimbraAdmin.cos.controller.ZaCosController")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @class ZaCosController controls display of a single COS
* @contructor ZaCosController
* @param appCtxt
* @param container
* @param abApp
**/

ZaCosController = function(appCtxt, container) {
	ZaXFormViewController.call(this, appCtxt, container, "ZaCosController");
	this._UICreated = false;	
	this._helpURL = [location.pathname, ZaUtil.HELP_URL, ZaCosController.helpURL, "?locid=", AjxEnv.DEFAULT_LOCALE].join("");
	this._helpButtonText = ZaMsg.helpEditCOS;
	this.deleteMsg = ZaMsg.Q_DELETE_COS;
	this.objType = ZaEvent.S_COS;
	this.tabConstructor = ZaCosXFormView;
}
ZaCosController.helpURL = "cos/creating_classes_of_service.htm";
ZaCosController.prototype = new ZaXFormViewController();
ZaCosController.prototype.constructor = ZaCosController;
ZaController.initPopupMenuMethods["ZaCosController"] = new Array();
ZaController.setViewMethods["ZaCosController"] = new Array();
ZaController.changeActionsStateMethods["ZaCosController"] = new Array();
/**
*	@method show
*	@param entry - isntance of ZaCos class
*/

ZaCosController.prototype.show = 
function(entry) {
	//check if the tab with the same cos ei
	if (! this.selectExistingTabByItemId(entry.id)){
		this._setView(entry, true);
	}
}

ZaCosController.changeActionsStateMethod = function () {
	if(this._currentObject.name == "default") {
        this._popupOperations[ZaOperation.DELETE].enabled = false;
	} else if(!ZaItem.hasRight(ZaCos.DELETE_COS_RIGHT,this._currentObject))	{
        this._popupOperations[ZaOperation.DELETE].enabled = false;
	}

    var isToEnable = (this._view && this._view.isDirty());

    if(this._popupOperations[ZaOperation.SAVE]) {
        this._popupOperations[ZaOperation.SAVE].enabled = isToEnable;
    }
		
}
ZaController.changeActionsStateMethods["ZaCosController"].push(ZaCosController.changeActionsStateMethod);

ZaCosController.initPopupMenuMethod =
function () {
	this._popupOperations[ZaOperation.SAVE]=new ZaOperation(ZaOperation.SAVE,ZaMsg.TBB_Save, ZaMsg.COSTBB_Save_tt, "Save", "SaveDis", new AjxListener(this, this.saveButtonListener));

	if(ZaZimbraAdmin.canCreateCos()) {
		this._popupOperations[ZaOperation.NEW]=new ZaOperation(ZaOperation.NEW,ZaMsg.TBB_New, ZaMsg.COSTBB_New_tt, "NewCOS", "NewCOSDis", new AjxListener(this, ZaCosController.prototype._newButtonListener, [true]));
	}
	this._popupOperations[ZaOperation.DELETE]=new ZaOperation(ZaOperation.DELETE,ZaMsg.TBB_Delete, ZaMsg.COSTBB_Delete_tt, "Delete", "DeleteDis", new AjxListener(this, this.deleteButtonListener));
}
ZaController.initPopupMenuMethods["ZaCosController"].push(ZaCosController.initPopupMenuMethod);

/**
*	@method setViewMethod 
*	@param entry - isntance of ZaCos class
*/
ZaCosController.setViewMethod =
function(entry) {
	try {
		entry[ZaModel.currentTab] = "1"
		if(entry.id)
			entry.load("id", entry.id);
			
		this._currentObject = entry;
		
         //create toolbar
		//this._initToolbar();
        this._initPopupMenu();
		//always add Help button at the end of the toolbar		
//		this._toolbarOperations[ZaOperation.NONE] = new ZaOperation(ZaOperation.NONE);
//		this._toolbarOperations[ZaOperation.HELP]=new ZaOperation(ZaOperation.HELP,ZaMsg.TBB_Help, ZaMsg.TBB_Help_tt, "Help", "Help", new AjxListener(this, this._helpButtonListener));
//		this._toolbarOrder.push(ZaOperation.NONE);
//		this._toolbarOrder.push(ZaOperation.HELP);	
		//this._toolbar = new ZaToolBar(this._container, this._toolbarOperations,this._toolbarOrder, null, null, ZaId.VIEW_COS);

	  	this._contentView = this._view = new this.tabConstructor(this._container,  entry);
		var elements = new Object();
		elements[ZaAppViewMgr.C_APP_CONTENT] = this._view;
        ZaApp.getInstance().getAppViewMgr().createView(this.getContentViewId(), elements);
		ZaApp.getInstance()._controllers[this.getContentViewId ()] = this ;

		ZaApp.getInstance().pushView(this.getContentViewId());
		this._view.setDirty(false);
	  	this._view.setObject(entry);

	} catch (ex) {
		this._handleException(ex, "ZaCosController.prototype._setView", null, false);	
	}
	
}
ZaController.setViewMethods["ZaCosController"].push(ZaCosController.setViewMethod);
/*
ZaCosController.prototype.getAppBarAction =
function () {
    if (AjxUtil.isEmpty(this._appbarOperation)) {
    	this._appbarOperation[ZaOperation.HELP]=new ZaOperation(ZaOperation.HELP,ZaMsg.TBB_Help, ZaMsg.TBB_Help_tt, "Help", "Help", new AjxListener(this, this._helpButtonListener));
    	this._appbarOperation[ZaOperation.SAVE]= new ZaOperation(ZaOperation.SAVE, ZaMsg.TBB_Save, ZaMsg.ALTBB_Save_tt, "", "", new AjxListener(this, this.saveButtonListener));
        this._appbarOperation[ZaOperation.CLOSE] = new ZaOperation(ZaOperation.CLOSE, ZaMsg.TBB_Close, ZaMsg.ALTBB_Close_tt, "", "", new AjxListener(this, this.closeButtonListener));
    }

    return this._appbarOperation;
}

ZaCosController.prototype.getAppBarOrder =
function () {
    if (AjxUtil.isEmpty(this._appbarOrder)) {
    	this._appbarOrder.push(ZaOperation.HELP);
    	this._appbarOrder.push(ZaOperation.SAVE);
        this._appbarOrder.push(ZaOperation.CLOSE);
    }

    return this._appbarOrder;
}*/


/**
* saves the changes in the fields, calls modify or create on the current ZaCos
* @return Boolean - indicates if the changes were succesfully saved
**/
ZaCosController.prototype._saveChanges =
function () {

	//check if the XForm has any errors
	if(this._view.getMyForm().hasErrors()) {
		var errItems = this._view.getMyForm().getItemsInErrorState();
		var dlgMsg = ZaMsg.CORRECT_ERRORS;
		dlgMsg +=  "<br><ul>";
		var i = 0;
		for(var key in errItems) {
			if(i > 19) {
				dlgMsg += "<li>...</li>";
				break;
			}
			if(key == "size") continue;
			var label = errItems[key].getInheritedProperty("msgName");
			if(!label && errItems[key].getParentItem()) { //this might be a part of a composite
				label = errItems[key].getParentItem().getInheritedProperty("msgName");
			}
			if(label) {
				if(label.substring(label.length-1,1)==":") {
					label = label.substring(0, label.length-1);
				}
			}
			if(label) {
				dlgMsg += "<li>";
				dlgMsg +=label;			
				dlgMsg += "</li>";
			}
			i++;
		}
		dlgMsg += "</ul>";
		this.popupMsgDialog(dlgMsg,  true);
		return false;
	}
	
	//check if the data is copmlete 
	var tmpObj = this._view.getObject();
	var isNew = false;
	//Check the data
    if(!ZaCos.checkValues(tmpObj))
			return false;


	var mods = new Object();
	//var changeDetails = new Object();
	if(!tmpObj.id)
		isNew = true;
		
	//transfer the fields from the tmpObj to the _currentObject
	for (var a in tmpObj.attrs) {
		if(a == ZaItem.A_objectClass || a == ZaItem.A_zimbraId || a == ZaCos.A_zimbraAvailableSkin
                || a == ZaCos.A_zimbraZimletAvailableZimlets || a == ZaCos.A_zimbraMailHostPool
                || a == ZaItem.A_zimbraACE || a== ZaItem.A_zimbraCreateTimestamp) {
			continue;
		}
		if(!ZaItem.hasWritePermission(a,tmpObj)) {
			continue;
		}
		//check if the value has been modified or the object is new
		if (isNew || (this._currentObject.attrs[a] != tmpObj.attrs[a]) ) {
			mods[a] = tmpObj.attrs[a];
		}
	}
	//check if host pool has been changed

	if(tmpObj.attrs[ZaCos.A_zimbraMailHostPool] != null) {
		var tmpMods = [];
		if(!(tmpObj.attrs[ZaCos.A_zimbraMailHostPool] instanceof Array)) {
			tmpMods = [tmpObj.attrs[ZaCos.A_zimbraMailHostPool]];
		} else {
			var cnt = tmpObj.attrs[ZaCos.A_zimbraMailHostPool].length;
			tmpMods = [];
			for(var i = 0; i < cnt; i++) {
				tmpMods.push(tmpObj.attrs[ZaCos.A_zimbraMailHostPool][i]);
			}
		}
		//check if changed
		if(!isNew && this._currentObject.attrs[ZaCos.A_zimbraMailHostPool] != null) {
			if(this._currentObject.attrs[ZaCos.A_zimbraMailHostPool] instanceof Array) {
				if(tmpMods.join(",") != this._currentObject.attrs[ZaCos.A_zimbraMailHostPool].join(",")) {
					mods[ZaCos.A_zimbraMailHostPool] = tmpMods;
				}
			} else if (tmpMods.join(",") != [this._currentObject.attrs[ZaCos.A_zimbraMailHostPool]].join(",")) {
				mods[ZaCos.A_zimbraMailHostPool] = tmpMods;
			}
		} else {
			mods[ZaCos.A_zimbraMailHostPool] = tmpMods;
		}
	} else if(this._currentObject.attrs[ZaCos.A_zimbraMailHostPool] != null) {
		mods[ZaCos.A_zimbraMailHostPool] = "";
	}

	if(tmpObj.attrs[ZaCos.A_zimbraAvailableSkin] != null) {
		var tmpMods = [];
		if(!(tmpObj.attrs[ZaCos.A_zimbraAvailableSkin] instanceof Array)) {
			tmpMods = [tmpObj.attrs[ZaCos.A_zimbraAvailableSkin]];
		} else {
			var cnt = tmpObj.attrs[ZaCos.A_zimbraAvailableSkin].length;
			tmpMods = [];
			for(var i = 0; i < cnt; i++) {
				tmpMods.push(tmpObj.attrs[ZaCos.A_zimbraAvailableSkin][i]);
			}
		}
			//check if changed
		if(this._currentObject.attrs[ZaCos.A_zimbraAvailableSkin] != null) {
			if(this._currentObject.attrs[ZaCos.A_zimbraAvailableSkin] instanceof Array) {
				if(tmpMods.join(",") != this._currentObject.attrs[ZaCos.A_zimbraAvailableSkin].join(",")) {
					mods[ZaCos.A_zimbraAvailableSkin] = tmpMods;
				}
			} else if (tmpMods.join(",") != [this._currentObject.attrs[ZaCos.A_zimbraAvailableSkin]].join(",")) {
				mods[ZaCos.A_zimbraAvailableSkin] = tmpMods;
			}
		} else {
			mods[ZaCos.A_zimbraAvailableSkin] = tmpMods;
		}
	} else if(this._currentObject.attrs[ZaCos.A_zimbraAvailableSkin] != null) {
		mods[ZaCos.A_zimbraAvailableSkin] = "";
	}
		

	if(tmpObj.attrs[ZaCos.A_zimbraZimletAvailableZimlets] != null) {
		var tmpMods = [];
		if(!(tmpObj.attrs[ZaCos.A_zimbraZimletAvailableZimlets] instanceof Array)) {
			tmpMods = [tmpObj.attrs[ZaCos.A_zimbraZimletAvailableZimlets]];
		} else {
			var cnt = tmpObj.attrs[ZaCos.A_zimbraZimletAvailableZimlets].length;
			tmpMods = [];
			for(var i = 0; i < cnt; i++) {
				tmpMods.push(tmpObj.attrs[ZaAccount.A_zimbraZimletAvailableZimlets][i]);
			}
		}
		if(isNew) {
			mods[ZaCos.A_zimbraZimletAvailableZimlets] = tmpMods;
		} else {
			//check if changed
			if(this._currentObject.attrs[ZaCos.A_zimbraZimletAvailableZimlets] != null) {
				if(this._currentObject.attrs[ZaCos.A_zimbraZimletAvailableZimlets] instanceof Array) {
					if(tmpMods.join(",") != this._currentObject.attrs[ZaCos.A_zimbraZimletAvailableZimlets].join(",")) {
						mods[ZaCos.A_zimbraZimletAvailableZimlets] = tmpMods;
					}
				} else if (tmpMods.join(",") != [this._currentObject.attrs[ZaCos.A_zimbraZimletAvailableZimlets]].join(",")) {
					mods[ZaCos.A_zimbraZimletAvailableZimlets] = tmpMods;
				}
			} else {
				mods[ZaCos.A_zimbraZimletAvailableZimlets] = tmpMods;
			}			
		}
	} else if(this._currentObject.attrs[ZaCos.A_zimbraZimletAvailableZimlets] != null) {
		mods[ZaCos.A_zimbraZimletAvailableZimlets] = "";
	}

	// TODO: We will use below code in ZCS-11977
	//check if blocked extensions are changed
	// if(!AjxUtil.isEmpty(tmpObj.attrs[ZaCos.A_zimbraFileUploadBlockedFileTypes])) {
	// 	if((
	// 			((!this._currentObject.attrs[ZaCos.A_zimbraFileUploadBlockedFileTypes] || !this._currentObject.attrs[ZaCos.A_zimbraFileUploadBlockedFileTypes].length))
	// 			|| (tmpObj.attrs[ZaCos.A_zimbraFileUploadBlockedFileTypes] != this._currentObject.attrs[ZaCos.A_zimbraFileUploadBlockedFileTypes]))
	// 			&& !(tmpObj.attrs[ZaCos.A_zimbraFileUploadBlockedFileTypes] instanceof Array)
	// 		) {
	// 		mods[ZaCos.A_zimbraFileUploadBlockedFileTypes] = tmpObj.attrs[ZaCos.A_zimbraFileUploadBlockedFileTypes].split(',');
	// 	}
	// } else if (AjxUtil.isEmpty(tmpObj.attrs[ZaCos.A_zimbraFileUploadBlockedFileTypes])  && !AjxUtil.isEmpty(this._currentObject.attrs[ZaCos.A_zimbraFileUploadBlockedFileTypes])) {
	// 	mods[ZaCos.A_zimbraFileUploadBlockedFileTypes] = "";
	// }

	//check if need to rename
	if(!isNew) {
		if(tmpObj.name != this._currentObject.name) {
            if(this._currentObject.name=="default"||this._currentObject.name=="defaultExternal"){
                this._errorDialog.setMessage( AjxMessageFormat.format(ZaMsg.FAILED_RENAME_COS_DEFAULT,this._currentObject.name), null, DwtMessageDialog.CRITICAL_STYLE, ZabMsg.zimbraAdminTitle);
				this._errorDialog.popup();
                return false;
            }
			newName=tmpObj.name;
			//changeDetails["newName"] = newName;
			try {
				this._currentObject.rename(newName);
			} catch (ex) {
				var detailStr = "";
				for (var prop in ex) {
					detailStr = detailStr + prop + " - " + ex[prop] + "\n";				
				}
				if(ex.code == ZmCsfeException.COS_EXISTS) {
					this._errorDialog.setMessage(ZaMsg.FAILED_RENAME_COS_1, detailStr, DwtMessageDialog.CRITICAL_STYLE, ZabMsg.zimbraAdminTitle);
					this._errorDialog.popup();
				} else {
					this._handleException(ex, "ZaCosController.prototype._saveChanges", null, false);	
				}
				return false;
			}
		}
	}

    if (this._currentObject[ZaModel.currentTab]!= tmpObj[ZaModel.currentTab])
             this._currentObject[ZaModel.currentTab] = tmpObj[ZaModel.currentTab];
	//save changed fields
	try {
		if(isNew) {
			this._currentObject.create(tmpObj.name, mods);
			//if creation took place - fire a CreationEvent
			this.fireCreationEvent(this._currentObject);
			this._toolbar.getButton(ZaOperation.DELETE).setEnabled(true);
            ZaApp.getInstance().getAppCtxt().getAppController().setActionStatusMsg(AjxMessageFormat.format(ZaMsg.CosCreated,[tmpObj.name]));
		} else {
			this._currentObject.modify(mods);
            ZaApp.getInstance().getAppCtxt().getAppController().setActionStatusMsg(AjxMessageFormat.format(ZaMsg.CosModified,[this._currentObject.name]));
			//if modification took place - fire a ChangeEvent
			//changeDetails["obj"] = this._currentObject;
			//changeDetails["mods"] = mods;
			//this.fireChangeEvent(this._currentObject);
		}
	} catch (ex) {
		var detailStr = "";
		for (var prop in ex) {
			if(ex[prop] instanceof Function) 
				continue;
				
			detailStr = detailStr + prop + " - " + ex[prop] + "\n";				
		}
		if(ex.code == ZmCsfeException.COS_EXISTS) {
			this._errorDialog.setMessage(ZaMsg.FAILED_CREATE_COS_1, detailStr, DwtMessageDialog.CRITICAL_STYLE, ZabMsg.zimbraAdminTitle);				
			this._errorDialog.popup();
		} else {
			this._handleException(ex, "ZaCosController.prototype._saveChanges", null, false);	
		}
		return false;
	}
	return true;
	
}

ZaCosController.prototype.newCos = 
function () {
	var newCos = new ZaCos();
	var defCos = ZaCos.getCosByName("default");
	//copy values from default cos to the new cos
	for(var aname in defCos.attrs) {
		if( (aname == ZaItem.A_objectClass) || (aname == ZaItem.A_zimbraId) || (aname == ZaCos.A_name) || (aname == ZaCos.A_description) || (aname == ZaCos.A_notes) || (aname = ZaItem.A_zimbraCreateTimestamp))
			continue;			
		newCos.attrs[aname] = defCos.attrs[aname];
	}	
	this._setView(newCos, true);
}

// new button was pressed
ZaCosController.prototype._newButtonListener =
function(openInNewTab, ev) {
	if (openInNewTab) {
		ZaCosListController.prototype._newButtonListener.call (this) ;
	}else{
		if(this._view.isDirty()) {
			//parameters for the confirmation dialog's callback 
			var args = new Object();		
			args["params"] = null;
			args["obj"] = this;
			args["func"] = ZaCosController.prototype.newCos;
			//ask if the user wants to save changes		
			//ZaApp.getInstance().dialogs["confirmMessageDialog"] = new ZaMsgDialog(this._view.shell, null, [DwtDialog.YES_BUTTON, DwtDialog.NO_BUTTON, DwtDialog.CANCEL_BUTTON]);								
			ZaApp.getInstance().dialogs["confirmMessageDialog"].setMessage(ZaMsg.Q_SAVE_CHANGES, DwtMessageDialog.INFO_STYLE);
			ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.YES_BUTTON, this.saveAndGoAway, this, args);		
			ZaApp.getInstance().dialogs["confirmMessageDialog"].registerCallback(DwtDialog.NO_BUTTON, this.discardAndGoAway, this, args);		
			ZaApp.getInstance().dialogs["confirmMessageDialog"].popup();
		} else {
			this.newCos();
		}	
	}
}
}
if (AjxPackage.define("zimbraAdmin.domains.controller.ZaDomainListController")) {
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
* @constructor
* @class ZaDomainListController
* This is a singleton object that controls all the user interaction with the list of ZaDomain objects
**/
ZaDomainListController = function(appCtxt, container) {
	ZaListViewController.call(this, appCtxt, container, "ZaDomainListController");
	this._helpURL = ZaDomainListController.helpURL;
	this._helpButtonText = ZaMsg.helpManageDomains;
	this._currentQuery = ""
	this._currentPageNum = 1;
	this._currentSortField = ZaDomain.A_domainName;
	this.objType = ZaEvent.S_DOMAIN;
    this._defaultType = ZaItem.DOMAIN;
	this.RESULTSPERPAGE = ZaDomain.RESULTSPERPAGE; 
	this.MAXSEARCHRESULTS = ZaDomain.MAXSEARCHRESULTS;	
}

ZaDomainListController.prototype = new ZaListViewController();
ZaDomainListController.prototype.constructor = ZaDomainListController;
ZaDomainListController.helpURL = location.pathname + ZaUtil.HELP_URL + "managing_domains/managing_domains.htm?locid="+AjxEnv.DEFAULT_LOCALE;
ZaController.initToolbarMethods["ZaDomainListController"] = new Array();
ZaController.initPopupMenuMethods["ZaDomainListController"] = new Array();
ZaController.changeActionsStateMethods["ZaDomainListController"] = new Array(); 

ZaDomainListController.prototype.show = function (doPush,openInNewTab) {

    if(!ZaZimbraAdmin.hasGlobalDomainListAccess() && this._currentQuery == "") {
        var domainNameList = ZaApp.getInstance()._domainNameList;
        if(domainNameList && (domainNameList instanceof Array) && domainNameList.length > 0) {
            for(var i = 0; i < domainNameList.length; i++)
                this._currentQuery += "(" + ZaDomain.A_domainName + "=" + domainNameList[i] + ")";
            if(domainNameList.length > 1)
                this._currentQuery = "(|" + this._currentQuery + ")";
        } else {
            this._list = new ZaItemList(ZaDomain);
            this.numPages = 0;
            this._searchTotal = 0;
            if(doPush) this._show(this._list);
            else this._updateUI(this._list);
            return;
        }
    }

	var busyId = Dwt.getNextId();
	var callback = new AjxCallback(this, this.searchCallback, {openInNewTab:openInNewTab,limit:ZaDomain.RESULTSPERPAGE,CONS:ZaDomain,show:doPush, busyId:busyId});
	var searchParams = {
		query:this._currentQuery, 
		types:[ZaSearch.DOMAINS],
		sortBy:ZaDomain.A_domainName,
		offset:this.RESULTSPERPAGE*(this._currentPageNum-1),
		sortAscending:"1",
		limit:this.RESULTSPERPAGE,
		callback:callback,
		controller: this,
		showBusy:true,
		busyId:busyId,
		busyMsg:ZaMsg.BUSY_SEARCHING_DOMAINS,
		skipCallbackIfCancelled:false,
		attrs:[ZaDomain.A_description, ZaDomain.A_domainName,ZaDomain.A_zimbraDomainStatus,ZaItem.A_zimbraId, ZaDomain.A_domainType],
		isInitialRequest: true
	}
	this.scrollSearchParams={
		query:this._currentQuery,
		types:[ZaSearch.DOMAINS],
		sortBy:ZaDomain.A_domainName,
		sortAscending:"1",
		controller: this,
		showBusy:true,
		busyMsg:ZaMsg.BUSY_SEARCHING_DOMAINS,
		skipCallbackIfCancelled:false,
		attrs:[ZaDomain.A_description, ZaDomain.A_domainName,ZaDomain.A_zimbraDomainStatus,ZaItem.A_zimbraId, ZaDomain.A_domainType]
	};
	ZaSearch.searchDirectory(searchParams);
}

ZaDomainListController.prototype._show = 
function (list,  openInNewTab, openInSearchTab, hasMore) {
	this._updateUI(list, openInNewTab, openInSearchTab, hasMore);
	//ZaApp.getInstance().pushView(ZaZimbraAdmin._DOMAINS_LIST_VIEW);
	ZaApp.getInstance().pushView(this.getContentViewId(), openInNewTab, openInSearchTab);
    return;
}



/**
* @return ZaItemList - the list currently displaid in the list view
**/
ZaDomainListController.prototype.getList = 
function() {
	return this._list;
}


ZaDomainListController.prototype.set = 
function(domainList) {
	this.show(domainList);
}

/**
* @param ev
* This listener is invoked by ZaAccountViewController or any other controller that can change an ZaDomain object
**/
ZaDomainListController.prototype.handleDomainChange = 
function (ev) {
	//if any of the data that is currently visible has changed - update the view
	if(ev) {
		var details = ev.getDetails();
		//details["modFields"] is outdated.
		//if(details["modFields"] && (details["modFields"][ZaDomain.A_description] || details["modFields"][ZaDomain.A_domainName])) {
		if (details){
			if (this._list) this._list.replace(details);
			if (this._contentView) this._contentView.setUI();
			if(ZaApp.getInstance().getCurrentController() == this) {
				this.show();			
			} else if(this.objType && ev.type==this.objType && this._UICreated) {
                this.show(false);
            }
			this.changeActionsState();
             ZaZimbraAdmin.getInstance().getOverviewPanelController().refreshRelatedTreeByEdit (ev.getDetails());
		}
	}
}


ZaDomainListController.initPopupMenuMethod =
function () {
	if(ZaZimbraAdmin.canCreateTopDomain()) {
		this._popupOperations[ZaOperation.NEW]=new ZaOperation(ZaOperation.NEW,ZaMsg.TBB_New, ZaMsg.DTBB_New_tt, "Domain", "DomainDis", new AjxListener(this, ZaDomainListController.prototype._newButtonListener));
	}
	this._popupOperations[ZaOperation.EDIT]=new ZaOperation(ZaOperation.EDIT,ZaMsg.TBB_Edit, ZaMsg.DTBB_Edit_tt, "Edit", "EditDis",  new AjxListener(this, ZaDomainListController.prototype._editButtonListener));    	
	this._popupOperations[ZaOperation.DELETE]=new ZaOperation(ZaOperation.DELETE,ZaMsg.TBB_Delete, ZaMsg.DTBB_Delete_tt, "Delete", "DeleteDis", new AjxListener(this, ZaDomainListController.prototype._deleteButtonListener));    	    	
    if(ZaZimbraAdmin.canCreateTopDomain()) {
		this._popupOperations[ZaOperation.ADD_DOMAIN_ALIAS]=new ZaOperation(ZaOperation.ADD_DOMAIN_ALIAS,ZaMsg.TBB_AddDomainAlias, ZaMsg.DTBB_addDomainAlias_tt, "DomainAlias", "DomainAliasDis", new AjxListener(this, ZaDomainListController.prototype._addDomainAliasListener));
	}
	this._popupOperations[ZaOperation.VIEW_DOMAIN_ACCOUNTS]=new ZaOperation(ZaOperation.VIEW_DOMAIN_ACCOUNTS,ZaMsg.Domain_view_accounts, ZaMsg.Domain_view_accounts_tt, "Search", "SearchDis", new AjxListener(this, this.viewAccountsButtonListener));
	this._popupOperations[ZaOperation.GAL_WIZARD]=new ZaOperation(ZaOperation.GAL_WIZARD,ZaMsg.DTBB_GAlConfigWiz, ZaMsg.DTBB_GAlConfigWiz_tt, "GALWizard", "GALWizardDis", new AjxListener(this, ZaDomainListController.prototype._galWizButtonListener));   		
	this._popupOperations[ZaOperation.AUTH_WIZARD]=new ZaOperation(ZaOperation.AUTH_WIZARD,ZaMsg.DTBB_AuthConfigWiz, ZaMsg.DTBB_AuthConfigWiz_tt, "AuthWizard", "AuthWizardDis", new AjxListener(this, ZaDomainListController.prototype._authWizButtonListener));
    /* bug 71235, remove auto provisioning
     this._popupOperations[ZaOperation.AUTOPROV_WIZARD]=new ZaOperation(ZaOperation.AUTOPROV_WIZARD,ZaMsg.DTBB_AutoProvConfigWiz, ZaMsg.DTBB_AutoProvConfigWiz_tt, "Backup", "BackupDis", new AjxListener(this, ZaDomainListController.prototype._autoProvWizButtonListener));
    */
}
ZaController.initPopupMenuMethods["ZaDomainListController"].push(ZaDomainListController.initPopupMenuMethod);

//private and protected methods
ZaDomainListController.prototype._createUI = 
function (openInNewTab, openInSearchTab) {
	this._contentView = new ZaDomainListView(this._container, this._defaultType);
	ZaApp.getInstance()._controllers[this.getContentViewId ()] = this ;
	// create the menu operations/listeners first	
	//always add Help and navigation buttons at the end of the toolbar    
	//add the acount number counts
	//ZaSearch.searchResultCountsView(this._toolbarOperations, this._toolbarOrder);
	
		
	var elements = new Object();
	elements[ZaAppViewMgr.C_APP_CONTENT] = this._contentView;
    ZaApp.getInstance().getAppViewMgr().createView(this.getContentViewId(), elements);
	this._initPopupMenu();
	this._actionMenu =  new ZaPopupMenu(this._contentView, "ActionMenu", null, this._popupOperations, ZaId.VIEW_DMLIST, ZaId.MENU_POP);
	
	//set a selection listener on the account list view
	this._contentView.addSelectionListener(new AjxListener(this, this._listSelectionListener));
	this._contentView.addActionListener(new AjxListener(this, this._listActionListener));			

	this._initDeleteDialogs();
	this._UICreated = true;
}

ZaDomainListController.prototype._initDeleteDialogs = 
function() {
	if(!this._removeConfirmMessageDialog) {
		this._removeConfirmMessageDialog = ZaApp.getInstance().dialogs["removeConfirmMessageDialog"] = new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.YES_BUTTON, DwtDialog.NO_BUTTON],null,ZaId.CTR_PREFIX + ZaId.VIEW_DMLIST + "_removeConfirm");
	}
	if(!this._forceRemoveMessageDialog) {
		this._forceRemoveMessageDialog = new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.YES_BUTTON, DwtDialog.NO_BUTTON],null,ZaId.CTR_PREFIX + ZaId.VIEW_DMLIST + "_forceRemoveConfirm");
	    this._forceRemoveMessageDialog.registerCallback(DwtDialog.YES_BUTTON, ZaDomainListController.prototype._forceDeleteDomainCallback, this);
	    this._forceRemoveMessageDialog.registerCallback(DwtDialog.NO_BUTTON, ZaDomainListController.prototype._donotForceDeleteDomainsCallback, this);
	    this._forceRemoveMessageDialog._button[DwtDialog.YES_BUTTON].setText(ZaMsg.FORCE_DELETE_BUTTON);
	}
}
/**
*	Private method that notifies listeners that a new ZaDomain is created
* 	@param details
*/
ZaDomainListController.prototype._fireDomainCreationEvent =
function(details) {
	try {
		if (this._evtMgr.isListenerRegistered(ZaEvent.E_CREATE)) {
			var evt = new ZaEvent(ZaEvent.S_DOMAIN);
			evt.set(ZaEvent.E_CREATE, this);
			evt.setDetails(details);
			this._evtMgr.notifyListeners(ZaEvent.E_CREATE, evt);
		}
	} catch (ex) {
		this._handleException(ex, "ZaDomainListController.prototype._fireDomainCreationEvent", details, false);	
	}
}

/**
*	Private method that notifies listeners to that the controlled ZaDomain is changed
* 	@param details
*/
ZaDomainListController.prototype._fireDomainChangeEvent =
function(details) {
	try {
		if (this._evtMgr.isListenerRegistered(ZaEvent.E_MODIFY)) {
			var evt = new ZaEvent(ZaEvent.S_DOMAIN);
			evt.set(ZaEvent.E_MODIFY, this);
			evt.setDetails(details);
			this._evtMgr.notifyListeners(ZaEvent.E_MODIFY, evt);
		}
	} catch (ex) {
		this._handleException(ex, "ZaDomainListController.prototype._fireDomainChangeEvent", details, false);	
	}
}

/**
* This listener is called when the item in the list is double clicked. It call ZaDomainController.show method
* in order to display the Domain View
**/
ZaDomainListController.prototype._listSelectionListener =
function(ev) {
	if (ev.detail == DwtListView.ITEM_DBL_CLICKED) {
		if(ev.item) {
            var item = ev.item ;
            if (item.attrs [ZaDomain.A_domainType] == ZaDomain.domainTypes.local) {
                ZaApp.getInstance().getDomainController().show(item);
            } else if ( item.attrs [ZaDomain.A_domainType] == ZaDomain.domainTypes.alias) {
                ZaApp.getInstance().getDomainAliasWizard(true).editDomainAlias (item, true) ;
            }
            var parentPath = ZaTree.getPathByArray([ZaMsg.OVP_home, ZaMsg.OVP_configure, ZaMsg.OVP_domains]);
            ZaZimbraAdmin.getInstance().getOverviewPanelController().addObjectItem(parentPath, item.name, null, false, false, item, undefined, true);
		}
	} else {
		this.changeActionsState();	
	}
}

ZaDomainListController.prototype._listActionListener =
function (ev) {
	this.changeActionsState();
	this._actionMenu.popup(0, ev.docX, ev.docY);
}

/**
* This listener is called when the Edit button is clicked. 
* It call ZaDomainController.show method
* in order to display the Domain View
**/
ZaDomainListController.prototype._editButtonListener =
function(ev) {
	if(this._contentView.getSelectionCount() == 1) {
		var item = this._contentView.getSelection()[0];
        this._editItem(item);
	}
}

ZaDomainListController.prototype._editItem =
function(item) {
    if (item.attrs [ZaDomain.A_domainType] == ZaDomain.domainTypes.local) {
        ZaApp.getInstance().getDomainController().show(item);
    } else if ( item.attrs [ZaDomain.A_domainType] == ZaDomain.domainTypes.alias) {
        ZaApp.getInstance().getDomainAliasWizard(true).editDomainAlias (item, true) ;
    }
    var parentPath = ZaTree.getPathByArray([ZaMsg.OVP_home, ZaMsg.OVP_configure, ZaMsg.OVP_domains]);
    ZaZimbraAdmin.getInstance().getOverviewPanelController().addObjectItem(parentPath, item.name, null, false, false, item, undefined, true);
}

ZaDomainListController.prototype._addDomainAliasListener =
function (ev) {
    var domain = new ZaDomain () ;
    if(this._contentView.getSelectionCount() == 1) {
             var item = this._contentView.getSelection()[0];
             domain[ZaDomain.A2_zimbraDomainAliasTarget] = item;
    }
    var domainAliasWizard = ZaApp.getInstance().getDomainAliasWizard () ;
    domainAliasWizard.registerCallback(DwtDialog.OK_BUTTON,
            ZaDomain.prototype.createDomainAlias, domain,
            domainAliasWizard._localXForm);
    domainAliasWizard.setObject(domain);
    domainAliasWizard.popup();
}

// new button was pressed
ZaDomainListController.prototype._newButtonListener =
function(ev) {
	try {
		var domain = new ZaDomain();
			
		domain.getAttrs = {all:true};
		/*domain.setAttrs = {all:true};
		domain.rights = {};
		domain._defaultValues = {attrs:{}};*/
		domain.loadNewObjectDefaults("name","domain.tld");
        if(!ZaApp.getInstance().dialogs["ZaNewDomainXWizard"])
		    ZaApp.getInstance().dialogs["ZaNewDomainXWizard"] = new ZaNewDomainXWizard(this._container, domain);
        this._newDomainWizard = ZaApp.getInstance().dialogs["ZaNewDomainXWizard"];
		this._newDomainWizard.registerCallback(DwtWizardDialog.FINISH_BUTTON, ZaDomainListController.prototype._finishNewButtonListener, this, null);			
		this._newDomainWizard.setObject(domain);
		this._newDomainWizard.popup();
	} catch (ex) {
		this._handleException(ex, "ZaDomainListController.prototype._newButtonListener", null, false);
	}
}


ZaDomainListController.prototype._galWizButtonListener =
function(ev) {
	try {
		if(this._contentView.getSelectionCount() == 1) {
			var item = this._contentView.getSelection()[0];
			this._openConfigGAL(item);
		}
	} catch (ex) {
		this._handleException(ex, "ZaDomainListController.prototype._showGalWizard", null, false);
	}
}

ZaDomainListController.prototype._openConfigGAL =
function(item) {
	this._currentObject = item;
    item.load("name", item.attrs[ZaDomain.A_domainName],false,true);

    ZaApp.getInstance().dialogs["ZaGALConfigXWizard"] = new ZaGALConfigXWizard(this._container,item)
    this._galWizard = ZaApp.getInstance().dialogs["ZaGALConfigXWizard"];
    item._extid=ZaUtil.getItemUUid();
    item._editObject = item;

    this._galWizard.setObject(item);
    this._galWizard.popup();
}

ZaDomainListController.prototype._authWizButtonListener =
function(ev) {
	try {
		if(this._contentView.getSelectionCount() == 1) {
			var item = this._contentView.getSelection()[0];
			this._openAuthWiz(item);
		}
	} catch (ex) {
		this._handleException(ex, "ZaDomainListController.prototype._showAuthWizard", null, false);
	}
}

ZaDomainListController.prototype._openAuthWiz =
function (item) {
    this._currentObject = item;
    item.load("name", item.attrs[ZaDomain.A_domainName],false,true);
    this._authWizard = ZaApp.getInstance().dialogs["ZaTaskAuthConfigWizard"] = new ZaTaskAuthConfigWizard(this._container);
    item._extid=ZaUtil.getItemUUid();
    item._editObject = item;

    this._authWizard.setObject(item);
    this._authWizard.popup();
}

ZaDomainListController.prototype._autoProvWizButtonListener =
function(ev) {
	try {
		if(this._contentView.getSelectionCount() == 1) {
			var item = this._contentView.getSelection()[0];
			this._currentObject = item;
			item.load("name", item.attrs[ZaDomain.A_domainName],false,true);
            if(!this._autoProvWizard) {
                if(ZaApp.getInstance().dialogs["ZaTaskAutoProvDialog"])
                     this._autoProvWizard = ZaApp.getInstance().dialogs["ZaTaskAutoProvDialog"];
                else
			        this._autoProvWizard = ZaApp.getInstance().dialogs["ZaTaskAutoProvDialog"] = new ZaTaskAutoProvDialog(this._container, ZaMsg.NAD_AutoProvConfigTitle);//ZaAutoProvConfigXWizard(this._container);
            }
            item._extid=ZaUtil.getItemUUid();
            item._editObject = item;
            this._autoProvWizard.registerCallback(DwtDialog.OK_BUTTON, ZaTaskAutoProvDialog.prototype.finishWizard, this._autoProvWizard, null);

            item.currentTab = "1";
			this._autoProvWizard.setObject(item);
			this._autoProvWizard.popup();
		}
	} catch (ex) {
		this._handleException(ex, "ZaDomainListController.prototype._autoProvWizButtonListener", null, false);
	}
}

/**
* This listener is called when the Delete button is clicked. 
**/
ZaDomainListController.prototype._deleteButtonListener =
function(ev) {
	this._initDeleteDialogs();
	this._removeList = new Array();
	this._itemsInTabList = [] ;
	var contentView = ZaApp.getInstance().getCurrentController()._contentView;
	if(contentView.getSelectionCount()>0) {
		var arrItems = contentView.getSelection();
		var cnt = arrItems.length;
		for(var key =0; key < cnt; key++) {
			var item = arrItems[key];
			if (item) {
				//detect whether the deleting item is open in a tab
				if (ZaApp.getInstance().getTabGroup() && ZaApp.getInstance().getTabGroup().getTabByItemId (item.id)) {
					this._itemsInTabList.push (item) ;
				}else{
					this._removeList.push(item);
				}
			}
		}
	}
	
	if (this._itemsInTabList.length > 0) {
		if(!ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"]) {
			ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"] = 
				new ZaMsgDialog(ZaApp.getInstance().getAppCtxt().getShell(), null, [DwtDialog.CANCEL_BUTTON], 
						[ZaMsgDialog.CLOSE_TAB_DELETE_BUTTON_DESC , ZaMsgDialog.NO_DELETE_BUTTON_DESC],
						ZaId.CTR_PREFIX + ZaId.VIEW_DMLIST + "_ConfirmDeleteItemsInTab");			
		}
		
		var msg = ZaMsg.dl_warning_delete_accounts_in_tab ; ;
		msg += ZaDomainListController.getDlMsgFromList (this._itemsInTabList) ;
		
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].setMessage(msg, DwtMessageDialog.WARNING_STYLE);	
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].registerCallback(
				ZaMsgDialog.CLOSE_TAB_DELETE_BUTTON, ZaDomainListController.prototype._closeTabsBeforeRemove, this);
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].registerCallback(
				ZaMsgDialog.NO_DELETE_BUTTON, ZaDomainListController.prototype._deleteDomainInRemoveList, this);		
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].popup();
		
	}else{
		this._deleteDomainInRemoveList ();
	}
}

ZaDomainListController.prototype.viewAccountsButtonListener  =
function (ev) {
    if(this._contentView.getSelectionCount() == 1) {
        var item = this._contentView.getSelection()[0];
        var domainName = item.name ;
        ZaDomain.searchAccountsInDomain (domainName) ;
	}
}

ZaDomainListController.prototype._closeTabsBeforeRemove =
function () {
	this.closeTabsInRemoveList() ;
	this._deleteDomainInRemoveList();
}

ZaDomainListController.prototype._deleteDomainInRemoveList =
function () {
	if (ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"]) {
		ZaApp.getInstance().dialogs["ConfirmDeleteItemsInTabDialog"].popdown();
	}
	if(this._removeList.length) {
		var dlgMsg = ZaMsg.Q_DELETE_DOMAINS;
		dlgMsg += ZaDomainListController.getDlMsgFromList (this._removeList);
		this._removeConfirmMessageDialog.setMessage(dlgMsg, DwtMessageDi