#!/perl/me/explicitly
use strict;

use FindBin;
use lib $FindBin::Bin;

BEGIN {
	if (!$ENV{VXIF_HOME} || (! -d $ENV{VXIF_HOME})) {
		print STDERR "Invalid or undefined environment variable VXIF_HOME. Cannot proceed.\n";
		print STDERR "Exiting.\n";
		exit 2;
	}
}

use lib $ENV{VXIF_HOME};
use VxIF::Interface::Classic::ClassFactory;

sub Main {
	my $class_factory = new VxIF::Interface::Classic::ClassFactory();
	my $installer_info = $class_factory->create_installer_info();
	my $result = $installer_info->from_config_file("ralusinst.conf");
	my $task = $class_factory->create_task($installer_info);

	my $err = $task->uninstall();

	if ($err && $err->get_rc()) {
		$err->put();
	}
}

Main();

