# RALUSSunOS interfaces
package RALUSSunOS;

use VxIF::ProductHelper;
use scripts::RALUSCommon;
@RALUSSunOS::ISA = qw(RALUSCommon ProductHelper);

sub new {
	my $invocant = shift;
	my $class = ref($invocant) || $invocant;
	my $self = {@_,};

	bless($self, $class);

	$self->initialize();

	return $self;
}

sub initialize {
	my $self = shift;

	$self->ProductHelper::init();
}

$PROD{RALUS}{ralustart}="VRTSralus.init start";
$PROD{RALUS}{ralustop} ="VRTSralus.init stop";

# Implement the required interfaces from RALUSSunOS here.

#
# Check to make sure the system names are valid.
#
# This interface is optional. By default, VxIF do some generic checking, such as making
# sure the name contains the valid characters. Apart from that it is up the each individual
# product to impose additional contraints.
#
# Input: 1) the reference to the installation context;
#        2) the array of systems that will be installing this product;
#
# Return: 1 if the system names are valid; 0 otherwise.
#
sub check_system_names (\%@) {
  my ($self,$ctx,@hosts) = @_;

  $$ctx{LOGGER}->entering("RALUSSunOS::check_system_names");

  return 1;
}

################################################
# Product Dependency Interfaces                #
################################################

#
# Get the external packages for which this product depended on.
# Any package that is not part of this product are consider external
# packages. VxIF will first check for the external dependent packages before 
# installing the product.
#
# This interface is optional.
#
# This interface shall return the reference of a hash with the dependent 
# package name as the keys with the following properties.
#
# {NAME}	- dependent package name; This is mandatory;
# {VERSION}	- dependent package version; This is optional; If the dependent
#                 version is not specified; VxIF will assume this product depended
#                 on any version of this package;
# {DESC}	- localized dependent package description; This is optional;
#
# Input: 1) the reference to the installation context;
#        2) the selected installation mode if applicable;
#
# Return: the reference of a hash with the dependent package name as the key and the
#         dependent package version and the localized description as the values.
#
#sub get_external_dependent_packages (\%;$) {
#}

#
# What to do if a given external dependent package exist on the install host
# and its version is different from the one this product is expecting? 
#
# This interface is option. By default, VxIF assumes the existing external dependent
# package is not supported and stop the installation.
#
# Input: 1) the reference to the installation context;
#        2) the external dependent package name;
#        3) the actual dependent package version;
#        4) the expected dependent package version;
#
# Return: 1 if the existing external dependent package is compatible with this product
#         and continue with the installation; 0 if the existing external dependent 
#         package is not supported and stop the installation.
#
#sub is_external_dependent_version_supported (\%$$$) {
#}

#
# Get the list of requred patches, both external application and OS patches, for this product. 
# VxIF will first check for the required patches before installing the product.
#
# This interface is optional.
#
# This interface shall return the a list which contains the patch ID of the required
# patches for this product.
#
# Input: 1) the reference to the installation context;
#        2) host OS version;
#        3) host OS architecture;
#        4) the selected installation mode if applicable;
#
# Return: a list which contains the patch IDs of the required patches.
#
#sub get_required_external_patches (\%$$;$) {
#}


################################################
# Packages and Patches Definition Interfaces   #
################################################

#
# Return a list of patches for a given version of this product. The given 
# version may not be the current version. The reason is that for product upgrade 
# and product downgrade, VxIF needs a list of patches associated with a particular 
# version so they can properly removed.
#
# This interface is mandatory for patch-only install.
#
# This interface shall return the reference of a hash with patch IDs as the keys
# with the following properties.
#
# {NAME}    	- the patch name; This property is mandatory;
# {PACKAGES}	- the list of packages this patch is intended for; This property is mandatory;
# {SPACE}	- a list which specified the spaces, in kilobytes, needed for this
#                 patch in /opt, /usr, /var, and /; this property is mandatory;
# {REQREBOOT}	- require system reboot after applying this patch? This property is
#                 optional;
# {OBSOLETES} 	- the list of obsoletes patches; This property is optional;
# {INCOMPAT}	- the list of incompatible patches; This property is optional;
# {REQUIRES}	- a list patches, within this product, that this patch depended on;
#                 If a dependent patch is not part of this product, it must be
#                 included in get_required_external_patches(); This property is optional;
# {DESC}	- localized patch description; This property is optional;
#
# Input: 1) the reference to the installation context;
#        2) the product version;
#        3) host OS version;
#        4) host OS architecture;
#        5) the selected installation mode if one is available;
#
# Return: the reference of the hash which contains the packages to be installed.
#
#sub get_product_patches (\%$$$;$) {
#}


################################################
# Package and Patch Installation Interfaces    #
################################################

#
# Product pre-installation script. This interface will be called before the product
# is being installed.
#
# This interface is optional.
#
# Input: 1) the reference to the installation context
#        2) %cfg array reference;
#        3) the installation mode if applicable;
#
# Return: 1 if the pre-installation is successful. Otherwise, return 0;
#
sub pre_product_install (\%\%;$) {
 my $self = shift;
 my ($ctx, $mode) = @_;

        $$ctx{LOGGER}->entering("RALUSSunOS::pre_product_install");

	_ralus_sun_shutdown_ralus($ctx);

        my $success = $self->RALUSCommon::pre_product_install($ctx, $mode);

        return $success;
}

#
# Product pre-uninstallation script. This interface will be called before the product
# is being uninstalled.
#
# This interface is optional.
#
# Input: 1) the reference to the installation context
#        2) %cfg array reference;
#        3) the installation mode if applicable;
#
# Return: 1 if the pre-uninstallation is successful. Otherwise, return 0;
#
sub pre_product_uninstall (\%\%;$) {
 my $self = shift;
 my ($ctx, $mode) = @_;

        $$ctx{LOGGER}->entering("RALUSSunOS::pre_product_uninstall");

	# Let's call the base class first for inital checks
        $self->RALUSCommon::pre_product_uninstall($ctx, $mode);

	_ralus_sun_shutdown_ralus($ctx);

        return 1;
}

#
# Get the content of the admin file for a given package or patch.
#
# This interface is optional.
#
# Input: 1) the reference to the installation context;
#        2) the package name or patch ID;
#        3) the name of the host for which this package will be installed;
#        4) host OS version;
#        5) host OS architecture;
#
# Return: the content of the admin file for the given package or patch ID.
#
#sub get_adminfile_content (\%$$$$) {
#}

sub post_product_install {
  my ($self,$ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSSunOS::post_product_install");

        # Create/Copy Sun Init Scripts
        _ralus_sun_do_init_scripts($self, $ctx);

        #create Data directory under /opt/VRTSralus to store certificate and keys
        _ralus_sunos_set_security_settings($ctx);
}

sub _ralus_sunos_set_security_settings {
    my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSSunOS::_ralus_sunos_set_security_settings");

	my ($dir,$cmd,$result,$permission);
        $permission = "770";
        $dir = "/opt/VRTSralus/data";
        if (!Utils::vxif_dc($dir, $ctx) )
        {
                $cmd = "mkdir /opt/VRTSralus/data";
	        $$ctx{LOGGER}->info("Create Network Security directory: $dir via $cmd");
                $result = Utils::vxif_dor($cmd, "", $ctx);
                $$ctx{LOGGER}->fine("vxif_dor result: $result");
		if (!Utils::vxif_dc($dir,$ctx))
		{
		        $$ctx{LOGGER}->error("ERROR: Unable to create directory: $dir");
                        return 0;
		} else {
		        $$ctx{LOGGER}->info("Create directory '$dir' was successful.");
		}
        }

        $cmd = "chmod $permission $dir";
	$$ctx{LOGGER}->info("Setting network security for: $dir via $cmd");
        $result = Utils::vxif_dor($cmd, "", $ctx);
        $$ctx{LOGGER}->fine("vxif_dor result: $result");

        return 1;
}


#
# Solaris Shutdown RALUS script. This interface will be called before the product
# is being installed or uninstalled.
#
# Input: 1) the reference to the installation context
#
# Return: 1 if successful. Otherwise, return 0;
#
sub _ralus_sun_shutdown_ralus {
        my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSSunOS::_ralus_sun_shutdown_ralus");

	# setup my default initdir
        my $initdir = "/etc/init.d";

        # Define our runtime Init Script
        my $initfile = "$initdir/VRTSralus.init";

        # if the Init Script exists then we need to attempt to shutdown
        # the Agent if it is running before install/uninstalling
        if (Utils::vxif_fc($initfile, $ctx))
        {

                $msg = Utils::_tr("Stopping Backup Exec agent service", 280, 1000);
                Utils::vxif_pbl($msg);
                $$ctx{LOGGER}->info($msg . " at: $initfile.");

                # Execute Shutdown of RALUS
                $cmd="$initfile stop";
                $result = Utils::vxif_dor($cmd, "", $ctx);

		# Notify user that we have finished shutting down RALUS
                Utils::vxif_pbr($msg, Utils::_tr("Done", 280, 1001));
        }

        return 1;
}

sub _ralus_sun_do_init_scripts {
	my ($self, $ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSSunOS::_ralus_sun_do_init_scripts");

        my($sf,$df,$cmd);
        my $initfile = "/etc/init.d/VRTSralus.init";
        if ( Utils::vxif_fc($initfile, $ctx) )
        {
                # file exist and we need to assume it is running so
                # we need to shut it down and delete it
                my $stop_msg = Utils::_tr("Stopping previous version of RALUS agent", 280, 1002);
                Utils::vxif_pbl($stop_msg);
                $cmd="/etc/init.d/$CMD{$TARGET}{STOP}{ralustop}";
		$$ctx{LOGGER}->info("Stopping previous version of RALUS agent via: $cmd");
                my $result = Utils::vxif_dor($cmd, "", $ctx);
		$$ctx{LOGGER}->info("result: $result");
		
                Utils::vxif_pbr($stop_msg, Utils::_tr("Done", 280, 1001));
                Utils::vxif_dor("rm $initfile", "", $ctx);
		if (Utils::vxif_fc($initfile, $ctx))
		{
			$$ctx{LOGGER}->error("ERROR (V-225-254): Failure to delete: $initfile");
		}
		else
		{
			$$ctx{LOGGER}->info("Successfully deleted: $initfile");
		}
        }

        my $copy_msg = Utils::_tr("Copying new initialization scripts to init.d", 280, 1003);
        Utils::vxif_pbl($copy_msg);
        # Copy new copy of Init Scripts to init.d directory
        $sf = "/opt/VRTSralus/bin/VRTSralus.init";
        $df = "/etc/init.d/VRTSralus.init";
        #_dor("$CMD{$TARGET}{CP} $sf $df");
	$$ctx{LOGGER}->info("Copy Init script from $sf to $df");
        Utils::vxif_dor("cp $sf $df", "", $ctx);
        if (Utils::vxif_fc("$df", $ctx))
        {
                Utils::vxif_pbr($copy_msg, Utils::_tr("Done", 280, 1001));
		$$ctx{LOGGER}->info("Successfully copied new init scripts to init.d.");
        }
        else
        {
                Utils::vxif_pbr($copy_msg, Utils::_tr("Failed", 280, 1004));
		$$ctx{LOGGER}->error("ERROR (V-225-255): Failed to copy new init scripts to init.d.");
		return 0;
        }

        # Check to see if linkedname exist if so delete and create
        # the new linkedname with the newly copied init file
        my $create_msg = Utils::_tr("Creating RALUS linkedname", 280, 1005);
        Utils::vxif_pbl($create_msg);
        $initfile="/etc/rc2.d/S95VRTSralus.init";
        if ( Utils::vxif_fc("$initfile", $ctx) )
        {
		$$ctx{LOGGER}->info("Deleting previous linkedname to init script: $initfile");
                Utils::vxif_dor("rm $initfile", "", $ctx);
        }
        $initfile="/etc/rc2.d/S91VRTSralus.init";
        if ( Utils::vxif_fc("$initfile", $ctx) )
        {
		$$ctx{LOGGER}->info("Deleting previous linkedname to init script: $initfile");
                Utils::vxif_dor("rm $initfile", "", $ctx);
        }
        # Use S91VRTSralus.init instead of S95VRTSralus.init see Defect #422750
        $sf = "/etc/init.d/VRTSralus.init";
        $df = "/etc/rc2.d/S91VRTSralus.init";
        $cmd="ln -s $sf $df";
	$$ctx{LOGGER}->info("Create linkedname to init script via: $cmd");
        Utils::vxif_dor($cmd, "", $ctx);
        if ( Utils::vxif_fc("$df", $ctx) )
        {
                Utils::vxif_pbr($create_msg, Utils::_tr("Done", 280, 1001));
		$$ctx{LOGGER}->info("Successfully created linkedname to init script.");
        }
        else
        {
                Utils::vxif_pbr($create_msg, Utils::_tr("Failed", 280, 1004));
		$$ctx{LOGGER}->error("ERROR (V-225-255): Failed to created linkedname to init script.");
        }

	return 1;
}

sub _ralus_sun_remove_pkgdirs {
  	my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSSunOS::_ralus_sun_remove_pkgdirs");

        my($cmd);
        # Manual UnInstall Steps to cleanup if necessary...
        if ( Utils::vxif_dc("/opt/VRTSralus", $ctx))
        {
        	$cmd="rm -rf /opt/VRTSralus";
		my $result = Utils::vxif_dor($cmd, "", $ctx);
                if ( Utils::vxif_dc("/opt/VRTSralus", $ctx))
                {
			$$ctx{LOGGER}->error("ERROR (V-225-253): vxif_dor failed ${cmd}, result=${result}");
		} else {
			$$ctx{LOGGER}->finer("Successful vxif_dor: ${cmd}");
		}
        }

        # Check the /var/VRTSralus dir now ....
        if (Utils::vxif_dc("/var/VRTSralus", $ctx))
        {
        	$cmd="rm -rf /var/VRTSralus";
		my $result = Utils::vxif_dor($cmd, "", $ctx);

                # Check to see if successful
		if (Utils::vxif_dc("/var/VRTSralus", $ctx))
                {
			$$ctx{LOGGER}->error("ERROR (V-225-253): vxif_dor failed ${cmd}, result=${result}");
		} else {
			$$ctx{LOGGER}->finer("Successful vxif_dor: ${cmd}");
		}
        }

        # Check the /etc/VRTSralus dir now ....
        if (Utils::vxif_dc("/etc/VRTSralus", $ctx))
        {
        	$cmd="rm -rf /etc/VRTSralus";
		my $result = Utils::vxif_dor($cmd, "", $ctx);

                # Check to see if successful
		if (Utils::vxif_dc("/etc/VRTSralus", $ctx))
                {
			$$ctx{LOGGER}->error("ERROR (V-225-253): vxif_dor failed ${cmd}, result=${result}");
		} else {
			$$ctx{LOGGER}->finer("Successful vxif_dor: ${cmd}");
		}
	}
}

sub _ralus_sun_remove_init_scripts {
  	my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSSunOS::_ralus_sun_remove_init_scripts");

	# Get the Host OS Installer Object 
        #my $trg_host = $ctx->get_target_hostname();
        #my $host_os_installer = $ctx->get_host_os_installer($trg_host);

        # Stop all threads/processes for BEREMOTE
	# we need to filter out the PID which is the 2nd Column
	# Value in the return of the get_pid function call
	#my $msg = Utils::_tr("Killing RALUS threads and processes");
        #Utils::vxif_pbl($msg);
        #my $command = "ps -ef | grep beremote  | grep -v grep";
        #$$ctx{LOGGER}->info("Getting beremote pids via: $command");
        #my ($results) = Utils::vxif_dor($command, "", $ctx );

        #my ($success) = 1;
        #my (@lines) = split(/\n/,$results);
        #foreach my $line (@lines)
        #{
        #        my ($nCount) = 0;
        #        if (length($line))
        #        {
        #                $$ctx{LOGGER}->info("PS result = $line");
	#
        #                my (@items) = split(/ /,$line);
        #                foreach my $item (@items)
        #                {
        #			if ($nCount == 6) # 2nd Column == PID
        #                        {
        #                                $$ctx{LOGGER}->info("Pid for beremote = $item");
        #                                $$ctx{LOGGER}->entering("kill_proc for beremote agent");
        #                                my $rc = $host_os_installer->kill_proc($ctx, "beremote", $item);
        #                                if (!$rc)
        #                                {
        #                                        $success = 0;
        #                                }
        #                                last;
        #                        }
        #                        else
        #                        {
        #                                $nCount = $nCount + 1;
        #                        }
        #                }
        #        }
        #}
	# Display Results for Killing BEREMOTE
	#if ( $success == 0 )
        #{
        #	Utils::vxif_pbr($msg,"Failed");
        #	$$ctx{LOGGER}->info($msg . " Failed.");
        #} else {
        #	Utils::vxif_pbr($msg,"Done");
        #        $$ctx{LOGGER}->info($msg . " was successful.");
        #}

        # Remove linkedname if it exists
	$msg = Utils::_tr("Removing RALUS linkedname", 280, 1006);
        Utils::vxif_pbl($msg);
        # Let's check for the previous instance of S95VRTSralus.init and if found
        # let's get rid of it
        $initfile="/etc/rc2.d/S95VRTSralus.init";
        if ( Utils::vxif_fc("$initfile", $ctx) )
        {
		$$ctx{LOGGER}->info("Deleting previous linkedname to init script: $initfile");
                Utils::vxif_dor("rm $initfile", "", $ctx);
        }
        $initfile="/etc/rc2.d/S91VRTSralus.init";
        $$ctx{LOGGER}->info($msg . " at: $initfile.");
       	Utils::vxif_dor("rm $initfile","",$ctx);
        if ( Utils::vxif_fc("$initfile",$ctx) )
        {
        	Utils::vxif_pbr($msg, Utils::_tr("Failed", 280, 1004));
        	$$ctx{LOGGER}->error("ERROR (V-225-254): $msg Failed.");
	} else {
        	Utils::vxif_pbr($msg, Utils::_tr("Done", 280, 1001));
        	$$ctx{LOGGER}->info($msg . " was successful.");
	}

	# Delete the VRTSralus.init file
	$msg = Utils::_tr("Removing RALUS init script", 280, 1007);
	Utils::vxif_pbl($msg);
	$initfile = "/etc/init.d/VRTSralus.init";
        $$ctx{LOGGER}->info($msg . " at: $initfile.");
	Utils::vxif_dor("rm $initfile","",$ctx);
	if ( Utils::vxif_fc("$initfile",$ctx) )
	{
		Utils::vxif_pbr($msg, Utils::_tr("Failed", 280, 1004));
        	$$ctx{LOGGER}->error("ERROR (V-225-254): $msg Failed.");
	} else {
		Utils::vxif_pbr($msg, Utils::_tr("Done", 280, 1001));
        	$$ctx{LOGGER}->info($msg . " was successful.");
        }
	
	return 1;
}

# Process Product Uninstall specific routines.
#
# Product post-uninstallation script. This interface will be called after all the
# packages has been uninstalled. This interface is optional.
#
# Input: 1) the reference to the installation context;
#        2) %cfg array reference;
#        3) the installation mode if applicable
#
# Returns: 
#	1 if the post-uninstallation is successful; otherwise 0.
#
sub post_product_uninstall {
  my ($self,$ctx) = @_;

      	$$ctx{LOGGER}->entering("RALUSSunOS::post_product_uninstall");

        # Manual UnInstall Steps to cleanup if necessary...
        _ralus_sun_remove_pkgdirs($ctx);

        # Remove the init files
        _ralus_sun_remove_init_scripts($ctx);
}

1;

