# RALUSAIX interfaces
package RALUSAIX;

use User::pwent;
use VxIF::ProductHelper;
use scripts::RALUSCommon;
@RALUSAIX::ISA = qw(RALUSCommon ProductHelper);

sub new {
	my $invocant = shift;
	my $class = ref($invocant) || $invocant;
	my $self = {@_,};

	bless($self, $class);

	$self->initialize();

	return $self;
}

sub initialize {
	my $self = shift;

	$self->ProductHelper::init();
}

################################################
# Product Dependency Interfaces                #
################################################

#
# Check to make sure the system names are valid.
#
# This interface is optional. By default, VxIF do some generic checking, such as making
# sure the name contains the valid characters. Apart from that it is up the each individual
# product to impose additional contraints.
#
# Input: 1) the reference to the installation context;
#        2) the array of systems that will be installing this product;
#
# Return: 1 if the system names are valid; 0 otherwise.
#
sub check_system_names (\%@) {
  my ($self,$ctx,@hosts) = @_;

  $$ctx{LOGGER}->entering("RALUSAIX::check_system_names");

  return 1;
}

#
# Get the external packages for which this product depended on.
# Any package that is not part of this product are consider external
# packages. VxIF will first check for the external dependent packages before 
# installing the product.
#
# This interface is optional.
#
# This interface shall return the reference of a hash with the dependent 
# package name as the keys with the following properties.
#
# {NAME}	- dependent package name; This is mandatory;
# {RPM}		- the rpm filename associated with this package;
# {VERSION}	- dependent package version; This is optional; If the dependent
#                 version is not specified; VxIF will assume this product depended
#                 on any version of this package;
# {DESC}	- localized dependent package description; This is optional;
#
# Input: 1) the reference to the installation context;
#        2) host OS version;
#        3) host OS architecture;
#        4) the selected installation mode if applicable;
#
# Return: the reference of a hash with the dependent package name as the key and the
#         dependent package version and the localized description as the values.
#
#sub get_external_dependent_packages (\%$$;$) {
#}

#
# What to do if a given external dependent package exist on the install host
# and its version is different from the one this product is expecting? 
#
# This interface is option. By default, VxIF assumes the existing external dependent
# package is not supported and stop the installation.
#
# Input: 1) the reference to the installation context;
#        2) the external dependent package name;
#        3) the actual dependent package version;
#        4) host OS version;
#        5) host OS architecture;
#        6) the expected dependent package version;
#
# Return: 1 if the existing external dependent package is compatible with this product
#         and continue with the installation; 0 if the existing external dependent 
#         package is not supported and stop the installation.
#
#sub is_external_dependent_version_supported (\%$$$$$) {
#}

#
# Get the list of requred patches, both external application and OS patches, for this product. 
# VxIF will first check for the required patches before installing the product.
#
# This interface is optional.
#
# This interface shall return the a list which contains the patch ID of the required
# patches for this product.
#
# Input: 1) the reference to the installation context;
#        2) host OS version;
#        3) host OS architecture;
#        4) the selected installation mode if applicable;
#
# Return: a list which contains the patch name of the required patches.
#
#sub get_required_external_patches (\%$$;$) {
#}


################################################
# Packages and Patches Definition Interfaces   #
################################################

#
# Return a list of patches for a given version of this product. The given 
# version may not be the current version. The reason is that for product upgrade 
# and product downgrade, VxIF needs a list of patches associated with a particular 
# version so they can properly removed.
#
# This interface is mandatory for patch-only install.
#
# This interface shall return the reference of a hash with patch IDs as the keys
# with the following properties.
#
# {NAME}    	- the patch name or title; This property is mandatory;
# {RPM}		- the RPM filename associate with this patch;
# {PACKAGE}	- the package this patch is intended for; This property is mandatory;
# {SPACE}	- a list which specified the spaces, in kilobytes, needed for this
#                 patch in /opt, /usr, /var, and /; this property is mandatory;
# {REQREBOOT}	- require system reboot after applying this patch? This property is
#                 optional;
# {OBSOLETES} 	- the obsoletes patches; This property is optional;
# {INCOMPAT}	- incompatible patches; This property is optional;
# {REQUIRES}	- a list patches, within this product, that this patch depended on;
#                 If a dependent patch is not part of this product, it must be
#                 included in get_required_external_patches(); This property is optional;
# {DESC}	- localized patch description; This property is optional;
#
# Input: 1) the reference to the installation context;
#        2) the product version;
#        3) host OS version;
#        4) host OS architecture;
#        5) the selected installation mode if one is available;
#
# Return: the reference of the hash which contains the packages to be installed.
#
#sub get_product_patches (\%$$$;$) {
#}


################################################
# Package and Patch Installation Interfaces    #
################################################

#
# Pre pkgadd operations. 
#
# This interface is optional.
#
# Input: 1) the reference to the installation context;
#        2) the package name;
#        3) the name of the host for which this package will be installed;
#        4) host OS version;
#        5) host OS architecture;
#
# Return: 1 if successful; 0 otherwise.
#
#sub pre_pkgadd (\%$$$$) {
#}

#
# Post pkgadd operations. 
#

# This interface is optional
#
# Input: 1) the reference to the installation context;
#        2) the package name;
#        3) the name of the host for which this package will be installed;
#        4) host OS version;
#        5) host OS architecture;
#
# Return: 1 if successful; 0 otherwise.
#
#sub post_pkgadd (\%$$$$) {
#}

#
# Pre pkgrm operations. 
#
# This interface is optional.
#
# Input: 1) the reference to the installation context;
#        2) the package name;
#        3) the name of the host for which this package will be installed;
#        4) host OS version;
#        5) host OS architecture;
#
# Return: 1 if successful; 0 otherwise.
#
#sub pre_pkgrm (\%$$$$) {
#}

#
# Post pkgrm operations. 
#
# This interface is optional
#
# Input: 1) the reference to the installation context;
#        2) the package name;
#        3) the name of the host for which this package will be installed;
#        4) host OS version;
#        5) host OS architecture;
#
# Return: 1 if successful; 0 otherwise.
#
#sub post_pkgrm (\%$$$$) {
#}

#
# Pre patchadd operations. 
#
# This interface is optional.
#
# Input: 1) the reference to the installation context;
#        2) the patch ID;
#        3) the name of the host for which this package will be installed;
#        4) host OS version;
#        5) host OS architecture;
#
# Return: 1 if successful; 0 otherwise.
#
#sub pre_patchadd (\%$$$$) {
#}

#
# Post patchadd operations. 
#
# This interface is optional.
#
# Input: 1) the reference to the installation context;
#        2) the patch ID;
#        3) the name of the host for which this package will be installed;
#        4) host OS version;
#        5) host OS architecture;
#
# Return: 1 if successful; 0 otherwise.
#
#sub post_patchadd (\%$$$$) {
#}

#
# Pre patchrm operations. 
#
# This interface is optional.
#
# Input: 1) the reference to the installation context;
#        2) the patch ID;
#        3) the name of the host for which this package will be installed;
#        4) host OS version;
#        5) host OS architecture;
#
# Return: 1 if successful; 0 otherwise.
#
#sub pre_patchrm (\%$$$$) {
#}

#
# Post patchrm operations. 
#
# This interface is optional.
#
# Input: 1) the reference to the installation context;
#        2) the patch ID;
#        3) the name of the host for which this package will be installed;
#        4) host OS version;
#        5) host OS architecture;
#
# Return: 1 if successful; 0 otherwise.
#
#sub post_patchrm (\%$$$$) {
#}

# Product pre-uninstallation script. This interface will be called before the product
# is being uninstalled.
#
# This interface is optional.
#
# Input: 1) The reference to the installation context
#        2) %cfg array reference;
#        3) the installation mode if applicable;
#
# Return: 1 if the pre-uninstallation is successful. Otherwise, return 0;
#
sub pre_product_uninstall(\%\%;$) {
 my $self = shift;
 my ($ctx, $mode) = @_;

	$$ctx{LOGGER}->entering("RALUSAIX::pre_product_uninstall");

	# Let's call the base class first for inital checks
	$self->RALUSCommon::pre_product_uninstall($ctx, $mode);

	_ralus_aix_shutdown_ralus($ctx);
}

# Product pre-installation script. This interface will be called before the product
# is being installed.
#
# This interface is optional.
#
# Input: 1) The reference to the installation context
#        2) %cfg array reference;
#        3) the installation mode if applicable;
#
# Return: 1 if the pre-installation is successful. Otherwise, return 0;
#
sub pre_product_install(\%\%;$) {
 my $self = shift;
 my ($ctx, $mode) = @_;
 my $success = 0;

	$$ctx{LOGGER}->entering("RALUSAIX::pre_product_install");

	# Shutdown RALUS if it's running
	_ralus_aix_shutdown_ralus($ctx);

	# Let's call the base class first for inital checks
	$success = $self->RALUSCommon::pre_product_install($ctx, $mode);

	return $success;
}

# Process to remove specific RALUS Product Directories.
#
# This process will remove all directories associated
# with the RALUS package during the uninstall process.
#
# Input: 1) the reference to the installation context;
#
# Returns:
#	1 if successful; otherwise 0.
sub _ralus_aix_shutdown_ralus {
 my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSAIX::_ralus_aix_shutdown_ralus");

	# setup my default initdir
	my $initdir = "/etc/rc.d";
	$$ctx{LOGGER}->info("Default init script path set to: $initdir");

	# Define our runtime Init Script
	my $initfile = "$initdir/VRTSralus.init";

	# if the Init Script exists then we need to attempt to shutdown
	# the Agent if it is running before install/uninstalling
	if (Utils::vxif_fc($initfile, $ctx))
	{
		$msg = Utils::_tr("Stopping Backup Exec agent service", 260, 1000);
		Utils::vxif_pbl($msg);
		$$ctx{LOGGER}->info($msg . " at: $initfile.");

		# Execute Shutdown of RALUS
		$cmd = "$initfile stop";
		$result = Utils::vxif_dor($cmd, "", $ctx);
		# Notify user that we have finished shutting down RALUS
		Utils::vxif_pbr($msg, Utils::_tr("Done", 260, 1001));
	}

	return 1;
}

# Process to remove specific RALUS Product Directories.
#
# This process will remove all directories associated 
# with the RALUS package during the uninstall process.
#
# Input: 1) the reference to the installation context;
#
# Returns: 
#	1 if successful; otherwise 0.
#
sub _ralus_aix_remove_pkgdirs {
  	my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSAIX::_ralus_aix_remove_pkgdirs");

        my($cmd,$result);
        # Manual UnInstall Steps to cleanup if necessary...
        if ( Utils::vxif_dc("/opt/VRTSralus", $ctx) )
        {
        	$cmd="rm -rf /opt/VRTSralus";
		$result = Utils::vxif_dor($cmd, "", $ctx);
                if (Utils::vxif_dc("/opt/VRTSralus", $ctx))
                {
			$$ctx{LOGGER}->error("ERROR (V-225-253): vxif_dor failed ${cmd}, result=${result}");
		} else {
			$$ctx{LOGGER}->finer("Successful vxif_dor: ${cmd}");
		}
        }

        #if ((!Utils::vxif_fc("/opt/VRTSvxms/lib/libmap.so", $ctx))     || 
        #    (!Utils::vxif_fc("/opt/VRTSvxms/lib/libvfutil.so", $ctx)))
        #{
        #	$cmd="rm -rf /opt/VRTSvxms";
        #	$result = Utils::vxif_dor($cmd, "", $ctx);

                # Check to see if the VRTSvxms directory still exists on Target machine
        #        if (Utils::vxif_dc("/opt/VRTSvxms", $ctx))
        #        {        
        #		$$ctx{LOGGER}->error("ERROR (V-225-253): vxif_dor failed ${cmd}, result=${result}");
        #	 } else {
        #		$$ctx{LOGGER}->finer("Successful vxif_dor: ${cmd}");
        #        }
        #}

        # Check the /var/VRTSralus dir now ....
        if (Utils::vxif_dc("/var/VRTSralus", $ctx))
        {
        	$cmd="rm -rf /var/VRTSralus";
		$result = Utils::vxif_dor($cmd, "", $ctx);

                # Check to see if successful
		if (Utils::vxif_dc("/var/VRTSralus", $ctx))
                {
			$$ctx{LOGGER}->error("ERROR (V-225-253): vxif_dor failed ${cmd}, result=${result}");
		} else {
			$$ctx{LOGGER}->finer("Successful vxif_dor: ${cmd}");
		}
        }

        # Check the /etc/VRTSralus dir now ....
        if (Utils::vxif_dc("/etc/VRTSralus", $ctx))
        {
        	$cmd="rm -rf /etc/VRTSralus";
		$result = Utils::vxif_dor($cmd, "", $ctx);

                # Check to see if successful
		if (Utils::vxif_dc("/etc/VRTSralus", $ctx))
                {
			$$ctx{LOGGER}->error("ERROR (V-225-253): vxif_dor failed ${cmd}, result=${result}");
		} else {
			$$ctx{LOGGER}->finer("Successful vxif_dor: ${cmd}");
		}
	}

	return 1;
}

# Process to remove specific RALUS Product init scripts.
#
# This process will remove all linkednames and init scripts
# associated with the RALUS package during the uninstall process.
#
# Input: 1) the reference to the installation context;
#
# Returns: 
#	1 if successful; otherwise 0.
#
sub _ralus_aix_remove_init_scripts {
 	my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSAIX::_ralus_aix_remove_pkgdirs");

	# setup my default initdir
	my $initdir = "/etc/rc.d";
	$$ctx{LOGGER}->info("Default init script path set to: $initdir");

        # Get the Host OS Installer Object
        my $trg_host = $ctx->get_target_hostname();
        my $host_os_installer = $ctx->get_host_os_installer($trg_host);

        # Stop all threads/processes for BEREMOTE
        # we need to filter out the PID which is the 2nd Column
        # Value in the return of the get_pid function call
        my $msg = Utils::_tr("Killing RALUS threads and processes", 300, 1000);
        Utils::vxif_pbl($msg);
        my $command = "ps -ef | grep beremote | grep -v grep";
        $$ctx{LOGGER}->info("Getting beremote pids via: $command");
        my ($results) = Utils::vxif_dor($command, "", $ctx );

        my ($success) = 1;
        my (@lines) = split(/\n/,$results);
        foreach my $line (@lines)
        {
                my ($nCount) = 0;
                if (length($line))
                {
                        $$ctx{LOGGER}->info("PS result = $line");

                        my (@items) = split(/ /,$line);
                        foreach my $item (@items)
                        {
                                if ($nCount == 6) # 2nd Column == PID
                                {
                                        $$ctx{LOGGER}->info("Pid for beremote = $item");
                                        $$ctx{LOGGER}->entering("kill_proc for beremote agent");
                                        my $rc = $host_os_installer->kill_proc($ctx, "beremote", $item);
                                        if (!$rc)
                                        {
                                                $success = 0;
                                        }
                                        last;
                                }
                                else
	                        {
                                        $nCount = $nCount + 1;
                                }
                        }
                }
        }
	# Display Result of Killing BEREMOTE
        if ( $success == 0 )
        {
                Utils::vxif_pbr($msg, Utils::_tr("Failed", 300, 1001));
                $$ctx{LOGGER}->error("ERROR (V-225-254): $msg Failed.");
        } else {
                Utils::vxif_pbr($msg, Utils::_tr("Done", 300, 1002));
                $$ctx{LOGGER}->info($msg . " was successful.");
        }

	# Remove linkedname in rc5.d if it exists
        $msg = Utils::_tr("Removing RALUS linkedname in rc5.d", 300, 1003);
        Utils::vxif_pbl($msg);
        $initfile="$initdir/rc5.d/S95VRTSralus.init";
        $$ctx{LOGGER}->info($msg . " at: $initfile.");
        Utils::vxif_dor("rm $initfile","",$ctx);
        if ( Utils::vxif_fc("$initfile",$ctx) )
        {
                Utils::vxif_pbr($msg, Utils::_tr("Failed", 300, 1001));
                $$ctx{LOGGER}->error("ERROR (V-225-254): $msg Failed.");
        } else {
                Utils::vxif_pbr($msg, Utils::_tr("Done", 300, 1002));
                $$ctx{LOGGER}->info($msg . " was successful.");
        }

	# Remove linkedname in rc3.d if it exists
        $msg = Utils::_tr("Removing RALUS linkedname in rc3.d", 300, 1004);
        Utils::vxif_pbl($msg);
        $initfile="$initdir/rc3.d/S95VRTSralus.init";
        $$ctx{LOGGER}->info($msg . " at: $initfile.");
        Utils::vxif_dor("rm $initfile","",$ctx);
        if ( Utils::vxif_fc("$initfile",$ctx) )
        {
                Utils::vxif_pbr($msg, Utils::_tr("Failed", 300, 1001));
                $$ctx{LOGGER}->error("ERROR (V-225-254): $msg Failed.");
        } else {
                Utils::vxif_pbr($msg, Utils::_tr("Done", 300, 1002));
                $$ctx{LOGGER}->info($msg . " was successful.");
        }

	# Remove linkedname in rc2.d if it exists
        $msg = Utils::_tr("Removing RALUS linkedname in rc2.d", 300, 1005);
        Utils::vxif_pbl($msg);
        $initfile="$initdir/rc2.d/S95VRTSralus.init";
        $$ctx{LOGGER}->info($msg . " at: $initfile.");
        Utils::vxif_dor("rm $initfile","",$ctx);
        if ( Utils::vxif_fc("$initfile",$ctx) )
        {
                Utils::vxif_pbr($msg, Utils::_tr("Failed", 300, 1001));
                $$ctx{LOGGER}->error("ERROR (V-225-254): $msg Failed.");
        } else {
                Utils::vxif_pbr($msg, Utils::_tr("Done", 300, 1002));
                $$ctx{LOGGER}->info($msg . " was successful.");
        }

	# Delete the VRTSralus.init file
        $msg = Utils::_tr("Removing RALUS init script", 300, 1006);
        Utils::vxif_pbl($msg);
        $initfile = "$initdir/VRTSralus.init";
        $$ctx{LOGGER}->info($msg . " at: $initfile.");
        Utils::vxif_dor("rm $initfile","",$ctx);
        if ( Utils::vxif_fc("$initfile",$ctx) )
        {
                Utils::vxif_pbr($msg,Utils::_tr("Failed"));
                $$ctx{LOGGER}->error("ERROR (V-225-254): $msg Failed.");
        } else {
                Utils::vxif_pbr($msg,Utils::_tr("Done"));
                $$ctx{LOGGER}->info($msg . " was successful.");
        }

        return 1;
}

# Process Product Uninstall specific routines.
#
# Product post-uninstallation script. This interface will be called after all the
# packages has been uninstalled. This interface is optional.
#
# Input: 1) the reference to the installation context;
#        2) %cfg array reference;
#        3) the installation mode if applicable
#
# Returns: 
#	1 if the post-uninstallation is successful; otherwise 0.
#
sub post_product_uninstall {
  my ($self,$ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSAIX::post_product_uninstall");

        # Manual UnInstall Steps to cleanup if necessary...
        _ralus_aix_remove_pkgdirs($ctx);

        # Remove the init files
        _ralus_aix_remove_init_scripts($ctx);
}

# Product post-installation script. This interface will be called after all the packages
# has been installed.
#
# This interface is optional.
#
# Input: 1) the reference to the installation context;
#        2) %cfg array reference;
#        3) the installation mode if applicable;
#
# Return: 1 if the post-installation is successful. Otherwise, return 0;
#
sub post_product_install (\%\%;$) {
  my ($self,$ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSAIX::post_product_install");

	# Manual Install of Init Scripts for RALUS
	_ralus_aix_do_init_scripts($ctx);

	# Reset all Files to beoper group ownership
	#_ralus_aix_change_group_owner($ctx);

        _ralus_aix_set_security_settings($ctx);

        #Rename libjfs.so file to libjfs to force agent to use generic provider to avoid AIX performance issues
        _ralus_aix_rename_libjfs($ctx);
}

# Renames file libjfs2.so to libjfs to allow the AIX agent to perform better.
#
#
# Input: 1) the reference to the installation context;
#
# Returns: 
#	1 if successful; otherwise 0.
#
sub _ralus_aix_rename_libjfs {
    my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSAIX::_ralus_aix_rename_libjfs");

	my ($file1,$file2,$renfile1,$renfile2,$cmd,$result);
        $file1 = "/opt/VRTSralus/VRTSvxms/lib/map/aix64/libjfs.so";
        $file2 = "/opt/VRTSralus/VRTSvxms/lib/map/aix64/libjfs2.so";
        $renfile1 = "/opt/VRTSralus/VRTSvxms/lib/map/aix64/libjfs";
        $renfile2 = "/opt/VRTSralus/VRTSvxms/lib/map/aix64/libjfs2";

        if (Utils::vxif_fc($file1, $ctx) )
        {
                $cmd = "mv $file1 $renfile1";
                $result = Utils::vxif_dor($cmd, "", $ctx);
                $$ctx{LOGGER}->fine("vxif_dor result for rename of $file1: $result");
        }

        if (Utils::vxif_fc($file2, $ctx) )
        {
                $cmd = "mv $file2 $renfile2";
                $result = Utils::vxif_dor($cmd, "", $ctx);
                $$ctx{LOGGER}->fine("vxif_dor result for rename of $file2: $result");
        }

        return 1;
}


# Sets Permissions needed for Network Security.
#
# This routine will install the appropriate permissions for network security
# for the AIX platform for RALUS.
#
# Input: 1) the reference to the installation context;
#
# Returns: 
#	1 if successful; otherwise 0.
#
sub _ralus_aix_set_security_settings {
    my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSAIX::_ralus_aix_set_security_settings");

	my ($dir,$cmd,$result,$permission);
        $permission = "770";
        $dir = "/opt/VRTSralus/data";
        if (!Utils::vxif_dc($dir, $ctx) )
        {
                $cmd = "mkdir /opt/VRTSralus/data";
	        $$ctx{LOGGER}->info("Create Network Security directory: $dir via $cmd");
                $result = Utils::vxif_dor($cmd, "", $ctx);
                $$ctx{LOGGER}->fine("vxif_dor result: $result");
		if (!Utils::vxif_dc($dir,$ctx))
		{
		        $$ctx{LOGGER}->error("ERROR: Unable to create directory: $dir");
                        return 0;
		} else {
		        $$ctx{LOGGER}->info("Create directory '$dir' was successful.");
		}
        }

        $cmd = "chmod $permission $dir";
	$$ctx{LOGGER}->info("Setting network security for: $dir via $cmd");
        $result = Utils::vxif_dor($cmd, "", $ctx);
        $$ctx{LOGGER}->fine("vxif_dor result: $result");

        return 1;
}


# Install RALUS Init Scripts.
#
# This routine will install the appropriate init runtime scripts
# for the AIX platform for RALUS.
#
# Input: 1) the reference to the installation context;
#
# Returns: 
#	1 if successful; otherwise 0.
#
sub _ralus_aix_do_init_scripts {
    my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSAIX::_ralus_aix_do_init_scripts");

	my ($cmd,$result);
	# setup my default initdir
	my $initdir = "/etc/rc.d";
	$$ctx{LOGGER}->info("Default init script path set to: $initdir");
	
	my $msg = Utils::_tr("Remove previous version of RALUS init scripts", 300, 1007);  
	my $initfile = "$initdir/VRTSralus.init";
	if ( Utils::vxif_fc($initfile, $ctx) )
	{
		# file exist and we need to remove it
		Utils::vxif_pbl($msg); 
		$cmd="rm -rf $initfile";
		$$ctx{LOGGER}->info($msg . " via: $cmd");
		$result = Utils::vxif_dor($cmd, "", $ctx);
		$$ctx{LOGGER}->info("vxif_dor result: $result");
		if (Utils::vxif_fc($initfile,$ctx))
		{
			$$ctx{LOGGER}->error("ERROR (V-225-254): Removing $initfile Failed.");
		} else {
			$$ctx{LOGGER}->info("Removing $initfile was successful.");
		}
		Utils::vxif_pbr($msg, Utils::_tr("Done", 300, 1002));
	}

	$msg = Utils::_tr("Copying new initialization scripts", 300, 1008);
	Utils::vxif_pbl($msg);
	my $sf = "/opt/VRTSralus/bin/VRTSralus.init";
	my $df = "$initdir/VRTSralus.init";
	$cmd = "cp $sf $df";
	$$ctx{LOGGER}->info("Copying $initfile via: $cmd.");
	$result = Utils::vxif_dor($cmd, "", $ctx);
	$$ctx{LOGGER}->fine("vxif_dor result: $result");
	if ( Utils::vxif_fc("$df", $ctx) )
	{
		Utils::vxif_pbr($msg, Utils::_tr("Done", 300, 1002));
		$$ctx{LOGGER}->info($msg . " was successful.");
	} else {
		Utils::vxif_pbr($msg, Utils::_tr("Failed", 300, 1001));
		$$ctx{LOGGER}->error("ERROR (V-225-255): $msg Failed.");
	}

	# Check to see if linkedname exist if so delete and create
	# the new linkedname with the newly copied init file in RC2
	$msg = Utils::_tr("Creating RALUS linkedname in rc2.d", 300, 1009);
	Utils::vxif_pbl($msg);
	my $RCDIR = "$initdir/rc2.d";
	$initfile="$RCDIR/S95VRTSralus.init";
	if ( Utils::vxif_fc($initfile, $ctx) )
	{
		Utils::vxif_dor("rm $initfile", "", $ctx);
		if (Utils::vxif_fc($initfile,$ctx))
		{
			$$ctx{LOGGER}->error("ERROR (V-225-255): Removing previous $initfile Failed.");
		} else {
			$$ctx{LOGGER}->info("Removing previous $initfile was successful.");
		}
	}
	$cmd="ln -s $initdir/VRTSralus.init $initfile";
	Utils::vxif_dor($cmd, "", $ctx);
	if ( Utils::vxif_fc($initfile, $ctx) )
	{
		Utils::vxif_pbr($msg, Utils::_tr("Done", 300, 1002));
		$$ctx{LOGGER}->info($msg . " was successful.");
	} else {
		Utils::vxif_pbr($msg, Utils::_tr("Failed", 300, 1001));
		$$ctx{LOGGER}->error("ERROR (V-225-255): $msg Failed.");
	}
		
	# Check to see if linkedname exist if so delete and create
	# the new linkedname with the newly copied init file in RC3
	$msg = Utils::_tr("Creating RALUS linkedname in rc3.d", 300, 1010);
	Utils::vxif_pbl($msg);
	$RCDIR = "$initdir/rc3.d";
	$initfile="$RCDIR/S95VRTSralus.init";
	if ( Utils::vxif_fc($initfile, $ctx) )
	{
		Utils::vxif_dor("rm $initfile", "", $ctx);
		if (Utils::vxif_fc($initfile,$ctx))
		{
			$$ctx{LOGGER}->error("ERROR (V-225-255): Removing previous $initfile Failed.");
		} else {
			$$ctx{LOGGER}->info("Removing previous $initfile was successful.");
		}
	}
	$cmd="ln -s $initdir/VRTSralus.init $initfile";
	Utils::vxif_dor($cmd, "", $ctx);
	if ( Utils::vxif_fc($initfile, $ctx) )
	{
		Utils::vxif_pbr($msg, Utils::_tr("Done", 300, 1002));
		$$ctx{LOGGER}->info($msg . " was successful.");
	} else {
		Utils::vxif_pbr($msg, Utils::_tr("Failed", 300, 1001));
		$$ctx{LOGGER}->error("ERROR (V-225-255): $msg Failed.");
	}

	# Check to see if linkedname exist if so delete and create
	# the new linkedname with the newly copied init file in RC5
	$msg = Utils::_tr("Creating RALUS linkedname in rc5.d", 300, 1011);
	Utils::vxif_pbl($msg);
	$RCDIR = "$initdir/rc5.d";
	$initfile="$RCDIR/S95VRTSralus.init";
	if ( Utils::vxif_fc($initfile, $ctx) )
	{
		Utils::vxif_dor("rm $initfile", "", $ctx);
		if (Utils::vxif_fc($initfile,$ctx))
		{
			$$ctx{LOGGER}->error("ERROR (V-225-254): Removing previous $initfile Failed.");
		} else {
			$$ctx{LOGGER}->info("Removing previous $initfile was successful.");
		}
	}
	$cmd="ln -s $initdir/VRTSralus.init $initfile";
	Utils::vxif_dor($cmd, "", $ctx);
	if ( Utils::vxif_fc("$initfile", $ctx) )
	{
		Utils::vxif_pbr($msg, Utils::_tr("Done", 300, 1002));
		$$ctx{LOGGER}->info($msg . " was successful.");
	} else {
		Utils::vxif_pbr($msg, Utils::_tr("Failed", 300, 1001));
		$$ctx{LOGGER}->error("ERROR (V-225-255): $msg Failed.");
	}

	return 1;
}

# Change Group ownership for all RALUS files from bin to beoper
#
# This routine will change the group ownership from bin to beoper
# for configure RALUS for DB2 and Oracle support 
# for the AIX platform for RALUS.
#
#	1 if successful; otherwise 0.
#
sub _ralus_aix_change_group_owner {
    my ($ctx) = @_;

	$$ctx{LOGGER}->entering("RALUSAIX::_ralus_aix_change_group_owner");

	# Display to user the configuring of the files
    	my $msg = Utils::_tr("Updating RALUS files for beoper", 300, 1012);
    	Utils::vxif_pbl($msg);
    
	my $cmd = "chgrp -R beoper /opt/VRTSralus/bin/*";
        my $result = Utils::vxif_dor($cmd, "", $ctx);
	$$ctx{LOGGER}->info("Result for '$cmd' : $result");
    
	$cmd = "chgrp -R beoper /etc/VRTSralus/ralus.cfg";
        $result = Utils::vxif_dor($cmd, "", $ctx);
	$$ctx{LOGGER}->info("Result for '$cmd' : $result");

	$cmd = "chgrp -R beoper /var/VRTSralus";
	$result = Utils::vxif_dor($cmd, "", $ctx);
	$$ctx{LOGGER}->info("Result for '$cmd' : $result");

	# Change permissions for the /var/VRTSralus directory
	$cmd = "chmod 775 /var/VRTSralus";
	$result = Utils::vxif_dor($cmd, "", $ctx);
	$$ctx{LOGGER}->info("Result for '$cmd' : $result");

	# Display to user the configuring of the files completed
	Utils::vxif_pbr($msg, Utils::_tr("Done", 300, 1002));
    
	return 1;
}

1;
