
package ThunkCommon;

require VxIF::Utils;

#
# Set the CMD globals;
#
# Input: 1) the reference to %CMD;
#
sub set_cmd_globals (\%) {
  my ($self,$cmd) = @_;
  
  #
  # Define commands used by CPI on all platforms
  $$cmd{VXLICINST}="/sbin/vxlicinst";
  $$cmd{VXLICREP}="/sbin/vxlicrep";
  $$cmd{VXLICTEST}="/sbin/vxlictest";
}

#
# Set the PATH globals.
#
# Input: 1) the reference to %PATH;
#
sub set_path_globals (\%) {
  my ($self,$path) = @_;
  
  # Define CPI directories
  $$path{PATCHES}="./patches";
  $$path{SCRIPTS}="./scripts/install";
  $$path{LOG}="/opt/VRTS/install/logs";
  $$path{TMP}="/tmp";
  $$path{OPT}="/opt";
  $$path{USR}="/usr";
  $$path{VAR}="/var";
  $$path{ROOT}="/";
  $$path{ITMP}="/var/tmp";
  #PATH{ITD} - Install Temp Direcory
  $$path{VLIC20}="/var/adm/VRTSshrd/VRTSlic/lic";
  $$path{VLIC}="/etc/vx/licenses/lic";
  $$path{DONOTSTARTALL}="/etc/vx/.cpi_donotstartall";
}

#
# Set the FLAG globals.
#
# Input: 1) the reference to %FLAG;
#
sub set_flag_globals (\%) {
  my ($self,$flag) = @_;
  
  # at the beginning, everything need to be logged
  $$flag{SAVELOG}=1;
  $$flag{NODOLOG}="";
  
  # no forking way
  $$flag{FORK}=0;
  
  $$flag{DEBUG}=$ENV{CPIDEBUG};
}

#
# Set the COMM globals.
#
# Input: 1) the reference to %COMM;
#        2) the reference to %CMD;
#	 3) the reference to %FLAG;
#
sub set_comm_globals (\%) {
  my ($self,$comm,$cmd,$flag) = @_;

  # Define CPI defaults
  $$comm{OSLIB}{SunOS}="sun";
  $$comm{OSLIB}{"HP-UX"}="hp";
  $$comm{OSLIB}{AIX}="aix";
  $$comm{OSLIB}{Linux}="linux";
  $$comm{OSLIB}{OSF1}="osf1";
  $$comm{SCREENPAUSE}=3;
  $$comm{SPACEWARNING}=5120;

  $$comm{TERMY}=24; # default if no $CMD{TPUT}
  $$comm{ORIGID}=9;
  $$comm{COPYRIGHTYEAR}=2004;
  $$comm{VALIDARGS}=[ qw(INSTALLONLY CONFIGURE LICENSE PRECHECK RESPONSEFILE USESSH PKGPATH PATCHPATH TMPPATH NOLIC REQUIRE) ];
  $$comm{TASKARGS}=[ qw(INSTALLONLY CONFIGURE LICENSE PRECHECK) ];
  $$comm{OPTARGS}=[ qw(RESPONSEFILE PKGPATH PATCHPATH TMPPATH REQUIRE) ];
  $$comm{TASKS}=[ qw(uninstall install configure license precheck rti) ];
  $$comm{COMMONIRFKEYS}=[ qw(SYSTEMS SYSTEMSCONFIG AUTOSTART SIMULTANEOUS USESSH KEYS DONOTINSTALL) ];
  $$comm{LTRANK}=[ qw(DEMO NFR PERM SITE) ];
  $$comm{LPLANGS} = [ qw(JA) ];
  $$comm{SYSTEMLIMIT}=32;

  # All UPI's which can be used with CPI:
  $$comm{UPIS}=[ qw(VM VVR FS VCS SF SFCFS SFORA SFDB2 SFSYB TD SFRAC SPCQS SR VEAG AZ AT FAS ODM) ];

  # UPI is an unlicensed IFRT product without an installer script of its own
  $$comm{NOPL}=[ qw(SR VEAG) ];

  # UPI is a product without a provider or need for VRTSob, VRTSobgui
  $$comm{NOPRO}=[ qw(SR TD VCSTD) ];

  # UPI is a product that requires licensing
  $$comm{LUPIS}=[ qw(FS VM VVR VCS TD SF SFCFS SFORA SFDB2 SFSYB SFRAC) ];

  # UPI is a cluster product or typically installs more than one system at a time
  $$comm{CLUPIS}=[ qw(VCS SFCFS TD VVR SFRAC) ];

  # UPI is a point product UPI which may be installed as part of an edition
  $$comm{PPUPIS}=[ qw(FS VM VCS VVR) ];

  # UNSUPPORTEDMODES defines product modes of which previous version keys 
  # exit, but are not supported for the current version
  $$comm{UNSUPPORTEDMODES}= [ qw(VCSQS) ];
  
  # set %COMM{TPUT}
  if (-X $$cmd{TPUT}) {
    $$flag{TPUT}=1;
    $$comm{TPUT}{BS}=`$$cmd{TPUT} bold`;	# Bold face Start
    $$comm{TPUT}{BE}=`$$cmd{TPUT} sgr 0`;	# Bold face End
    $$comm{TPUT}{CS}=`$$cmd{TPUT} clear`;	# Clear the Screen
    $$comm{TPUT}{SS}=`$$cmd{TPUT} smso`;	# Standout face Start
    $$comm{TPUT}{SE}=`$$cmd{TPUT} rmso`;	# Standout face End
    $$comm{TPUT}{US}=`$$cmd{TPUT} smul`;	# Underline face Start
    $$comm{TPUT}{UE}=`$$cmd{TPUT} rmul`;	# Underline face End
    $$comm{TPUT}{CL}=`$$cmd{TPUT} cub1`;	# cursor left
    $$comm{TPUT}{SC}=`$$cmd{TPUT} sc`;	# save cursor pos
    $$comm{TPUT}{RC}=`$$cmd{TPUT} rc`;	# restore cursor pos
    $$comm{TERMX}=`$$cmd{TPUT} cols`;		# number of columns
    $$comm{TERMY}=`$$cmd{TPUT} lines`;	# number of rows
    chomp($$comm{TERMX});
    chomp($$comm{TERMY});
  }
  
  # set up the LANG stuff
  $$comm{ENVLANG}=$ENV{LANG} if (!$$comm{ENVLANG});
  $$comm{ENVLANG}="C" if (($ENV{CPIEN}) || (!$ENV{LANG})); # default to english
}

#
# Set the MSG globals.
#
# Input: 1) the reference to %MSG;
#        2) the reference to %COMM;
#
sub set_msg_globals {
  my ($self,$msg,$comm) = @_;

  $$msg{INDENT}="    "; 
 
  $$msg{YESKEY}=Utils::_tr("y", 17, 1000);
  $$msg{NOKEY}=Utils::_tr("n", 17, 1001);
  $$msg{BACKKEY}=Utils::_tr("b", 17, 1002);
  $$msg{QUITKEY}=Utils::_tr("q", 17, 1003);
  $$msg{HELPKEY}=Utils::_tr("?", 17, 1004);
  $$msg{INSTALLKEY}=Utils::_tr("i", 17, 1005);
  $$msg{CONFIGKEY}=Utils::_tr("c", 17, 1006);
  $$msg{LICENSEKEY}=Utils::_tr("l", 17, 1007);
  $$msg{PRECHECKKEY}=Utils::_tr("p", 17, 1008);
  $$msg{UNINSTALLKEY}=Utils::_tr("u", 17, 1009);
  $$msg{DESCKEY}=Utils::_tr("d", 17, 1010);
  $$msg{VENDOR}=Utils::_tr("Veritas", 17, 1030);
  if (-d "./$PROD{SFRAC}{TRAINDIR}") {
    $$msg{RTITITLE}=Utils::_tr("Cluster File Solutions", 17, 1012);
  } else {
    $$msg{RTITITLE}=Utils::_tr("Storage Solutions", 17, 1013);
  }
  $$msg{INFRASTRUCTURE}=Utils::_tr("Infrastructure", 17, 1014);
  $$msg{SYSTEM}=Utils::_tr("System", 17, 1015);
  $$msg{ERROR}=Utils::_tr("ERROR", 17, 1016);
  $$msg{WARNING}=Utils::_tr("WARNING", 17, 1017);
  $$msg{UNKNOWN}=Utils::_tr("Unknown", 17, 1018);
  if ($$comm{OS} eq "Linux") {
    $$msg{PRTC}=Utils::_tr("Press [Enter] to continue:", 17, 1019);
  } else {
    $$msg{PRTC}=Utils::_tr("Press [Return] to continue:", 17, 1020);
  }
  $$msg{DEMO}=Utils::_tr("Demo", 17, 1021);
  $$msg{PERMANENT}=Utils::_tr("Permanent", 17, 1022);
  $$msg{NFR}=Utils::_tr("NFR", 17, 1023);
  $$msg{EXTENSION}=Utils::_tr("Extension", 17, 1024);
  $$msg{NODELOCK}=Utils::_tr("Node Lock", 17, 1025);
  $$msg{SITELIC}=Utils::_tr("Site License", 17, 1026);
  $$msg{MENUBACK}=Utils::_tr("Back to previous menu", 17, 1027);
  $$msg{YES}="yes";
  $$msg{NO}="no";
  $$msg{AT}="@";
  $$msg{COPYRIGHTH}=Utils::_tr("Copyright (c) $$comm{COPYRIGHTYEAR} Veritas Technologies LLC. All rights reserved.", 17, 1031, "$$comm{COPYRIGHTYEAR}");
  $$msg{COPYRIGHTB}=Utils::_tr("Veritas, the Veritas Logo and all other Veritas product names and slogans are trademarks or registered trademarks of Veritas Technologies LLC. Veritas and the Veritas Logo Reg. U.S. Pat. & Tm. Off. Other product names and/or slogans mentioned herein may be trademarks or registered trademarks of their respective companies.", 17, 1032);
  #_plat_sub("set_msgs");
}

#
# Indicate whether to check for licensing after product has been installed. Normally,
# for a licensable product, VxIF will check for licensing before installing the product.
# However, for some products such as VxVM, license-check operation is done after
# the product has been successfully installed.
#
# This interface is optional. By default VxIF will check for licensing before installing
# the licensable product.
#
# Input: 1) the reference to the installation context;
#        2) the selected installation mode if applicable;
#
# Return: 1 check for license after the product has been successfully installed; 0 otherwise.
#
sub check_licensing_after_install (\%$) {
  my ($self,$ctx,$mode) = @_;
  
  $$ctx{LOGGER}->entering("ThunkCommon::check_licensing_after_install");
  
  # For VM, check for licensing after the installation
  return 1 if ($$ctx{TARGET}{UPI} eq "VM");
  
  return 0;
}

sub get_thunk_info (\%) {
  my ($self,$ctx) = @_;
  
  # thunking the A stuff
  return "A";
}

1;
