package CPIOSF1;

our @ISA = ("CPICommon");

require VxIF::CPICommon;

###############################
# Private Methods             #
###############################

###############################
# Public Methods       	      #
###############################

#
# Create an Installer object.
#
# Inputs: PRODUCT	=> the name of the product to install;
#         LOGGER 	=> reference to the Logger object; This is optional;
#         TITLE		=> product title; This is option; The default title is
#                          VERITAS Installer;
#         TMPPATH 	=> the complete to the tmp directory; This is optional;
#                          The default is /var/tmp;
#         INSTALLONLY 	=> install without configure; This is optional;
#                          The default is install and configure;
#         RESPONSEFILE	=> response file; This is optional; If a responsible is provided,
#                          the pre install and post install steps will be skipped;
#         USESSH	=> indicate whether to use SSH for remote installation; This is optional;
#                          The default is to use rsh;
#         SUPPORTEDOS	=> a list of supported OSs; This is optional; By default, the supported
#                          OSs are SunOS, Linux, HPUX, AIX, and OSF1;
#         CMDSEARCHPATHS=> a list of system paths to search for a shell command; This is optional;
#                          By default, the search paths are '/usr/bin', '/bin', '/usr/local/bin', 
#                          '/sbin', '/usr/sbin', and '/usr/local/sbin';
#         SPACEWARNING	=> warning the users of low on space if the number of bytes on the 
#                          volume after the installation is less than this value; This is optional;
#                          The default is 5120 kilobytes;
#
sub new {
  my $invocant = shift;
  my $class = ref($invocant) || $invocant;
  my $self = { 	
                USESSH		=> 0,
		IPv6            => 0,
  	  	        TMPPATH		=> '/var/tmp/vxif',
  	 	          TIMEFILE	=> '/tmp/vxif_time',
  	 	          PKGSDIR		=> 'pkgs',
  	 	          PATCHSDIR	=> 'patches',
  	 	          OSINSTALLER	=> 'OSF1',
  	 	          SPACEWARNING	=> '5120',
                SUPPORTEDOS => [qw(SunOS Linux HPUX AIX OSF1)],
                CMDSEARCHPATHS  => [qw(/usr/bin /bin /usr/local/bin /sbin /usr/sbin /usr/local/sbin)],
          	    @_,
  	          };
    
  return bless $self, $class;
}

#
# Set the common system commands.
#
sub set_commands {
  my ($self) = @_;
  
  $self->SUPER::set_commands();
  $self->{CMD}{CAT}="/sbin/cat";
  $self->{CMD}{CHMOD}="/sbin/chmod";
  $self->{CMD}{CP}="/sbin/cp";
  $self->{CMD}{DFK}="/sbin/df -k";
  $self->{CMD}{ECHO}="/bin/echo";
  $self->{CMD}{GREP}="/sbin/grep";
  $self->{CMD}{GUNZIP}="/usr/bin/gunzip";
  $self->{CMD}{IFCONFIG}="/sbin/ifconfig";
  $self->{CMD}{INSTALL}="/opt/VRTScpi/bin/scripts/install/install";
  $self->{CMD}{KILL}="/sbin/kill";
  $self->{CMD}{LS}="/sbin/ls";
  $self->{CMD}{MKDIR}="/sbin/mkdir";
  $self->{CMD}{MOUNT}="/sbin/mount";
  $self->{CMD}{MV}="/sbin/mv";
  $self->{CMD}{PING}="/sbin/ping";
  $self->{CMD}{PS}="/sbin/ps";
  $self->{CMD}{REX}="/opt/VRTScpi/bin/scripts/rex";
  $self->{CMD}{RMR}="/sbin/rm -rf";
  $self->{CMD}{SED}="/sbin/sed";
  $self->{CMD}{SETLD}="/usr/sbin/setld";
  $self->{CMD}{SORT}="/sbin/sort";
}

#
# Set message strings for package, packages
#
sub set_msgs {
  my ($self) = @_;
  
  $self->SUPER::set_msgs();
  
  $self->{MSG}{PDFREN} 	= "subset";
  $self->{MSG}{PDFR} 	= Utils::_tr("subset", 25, 1000);
  $self->{MSG}{PDFRS}	= Utils::_tr("subsets", 25, 1001);
}

#
# Initialization.
#
# Input: 1) the reference of the installation context;
#
# Return: 1 if successfull; 0 otherwise.
#
sub initialize ($) {
  my($self,$context) = @_;
  
  $self->SUPER::initialize($context);
  
  $self->set_msgs();
  
  return 1;
}

#
# Add a product to this platform.
#
# Input: 1) the UPI;
#        2) the reference of the product object;
# 
sub add_product ($&) {
  my($self,$upi,$product) = @_;
  
  $self->{PRODUCT}{$upi} = $product;
}

#
# Add a target host to this platform.
#
# Input: 1) the target host name;
#        2) the reference of the installation context;
#
sub add_host (\%$) {
  my ($self,$ctx,$host) = @_;
  
  push(@{$self->{HOSTS}}, $host);
}

#
# Determine if a package is installed on a given host and return the version.
#
# Input: 1) the reference to the installation context;
#        2) the fileset name;
#        3) extension?;
#        4) the refeence to the packages hash;
#        5) the optional UPI;
#
# Return: the version number, or null ("") if unable to determine the version number.
#
# This is an updated version of get_instpkgvers to bring it into 4.4 standards.  Written, with much many thanks, by Brad W (dur). - Feb 10, 06 jpk
#################################################################
sub get_instpkgvers (\%$;$) {
        my $self = shift;
        my ($ctx, $pkg, $ext, $pkgs) = @_;
        my ($iv, @pkgnames);
        my ($pkgexist, $subset, @subsets);
        my $trg_host = $ctx->get_target_hostname();
        my $upi_inst = $ctx->get_host_os_upi_installer($trg_host);

        $$ctx{LOGGER}->entering("CPIOSF1::get_instpkgvers");

        @pkgnames = keys(%{$pkgs});

        $$ctx{LOGGER}->finer("pkg=${pkg}");

        if ((Utils::vxif_list($pkg, @pkgnames) >= 0) && $upi_inst->can("get_installed_package_version")) {
                $iv = $upi_inst->get_installed_package_version($ctx, $pkg);
        } else {
                $subset = $pkg;

                if (defined($$pkgs{$pkg}{SUBSET})) {
                        $subset = $$pkgs{$pkg}{SUBSET};
                }

                @subsets = split(" ", $subset);
                $subset = $subsets[0];

                # get rid of the last digits for the version number
                $subset =~ s/\d+$//;

                $$ctx{LOGGER}->finer("subset=$subset");

                $pkgexist = Utils::vxif_dor("$self->{CMD}{SETLD} -i | $self->{CMD}{GREP} ${subset} | $self->{CMD}{GREP} -v 'grep' | $self->{CMD}{GREP} -v 'not install'", "", $ctx);

                $$ctx{LOGGER}->finer("pkgexist=${pkgexist}");

                if ($pkgexist) {
                        if ($pkgexist =~/\(Version\s+(\d+(\.\d+)*)\)/) {
                                $iv = $1;
                        }
                }
        }

        $$ctx{LOGGER}->finer("iv=${iv}");

        return "$iv";
}
#################################################################

sub get_instpkgvers_orig (\%$;$\%$) {
  my ($self,$ctx,$pkg,$ext,$pkgs,$upi) = @_;
  my ($v,$pkgexist,$subset,@subsets);
  my ($checkv) = 1;
  
  $$ctx{LOGGER}->entering("CPIOSF1::get_instpkgvers");
  
  $upi = $$ctx{TARGET}{UPI} if (!$upi);
  if ($self->{PRODUCT}{$upi}->can("get_installed_package_version")) {
    $v = $self->{PRODUCT}{$upi}->get_installed_package_version($ctx, $pkg, $upi);
    $checkv = $$ctx{CHECKINSTPKGVERS} if ($self->{PRODUCT}{$upi}->can("get_thunk_info"));
  }
  
  if ($checkv) {
    # Assumes version is embedded in the name
    # Use setld -i if this is not true
    
    # This is a freaking hack! There is no easy way of determining the
    # current installed version other than from the subset name. The last
    # three digits of the subset name is the current version. 
    $subset = $pkg;
    
    # support the B stuff here
    if (defined($$pkgs{$pkg}{SUBSET})) {
      $subset = $$pkgs{$pkg}{SUBSET};
    }
    
    @subsets = split(" ", $subset);
    $subset = $subsets[0];
    
    # get rid of the last digits for the version number
    $subset =~ s/\d+$//;
    
    $$ctx{LOGGER}->finer("subset=$subset");
    
    $pkgexist = Utils::vxif_dor("$self->{CMD}{SETLD} -i | $self->{CMD}{GREP} ${subset} | $self->{CMD}{GREP} -v 'grep' | $self->{CMD}{GREP} -v 'not install'", "", $ctx);
    
    $$ctx{LOGGER}->finer("subset=${subset}\npkgexist=${pkgexist}");
    
    if ($pkgexist) {
      if ($pkgexist =~/\(Version\s+(\d+(\.\d+)*)\)/) {
        $v = $1;
      }
    }
  }
  
  $$ctx{LOGGER}->finer("v=$v");
   
  return $v;
}

#
# Determine the version number of the package on the installation media.
#
# Input: 1) the reference to the installation context;
#        2) the native package name;
#        3) the reference to the packages hash;
#        4) extension;
#
# Return: the version number, or null ("") if unable to determine the version number.
#
sub get_mediapkgvers (\%$\%;$) {
  my ($self,$ctx,$pkg,$pkgs,$ext) = @_;
  my ($v,$vl,$loc,@subsets);
  my ($kit) = $$pkgs{$pkg}{KIT};
  my ($subset) = $pkg;
  
  # support the B stuff here
  if (defined($$pkgs{$pkg}{SUBSET})) {
    $kit = $pkg;
    @subsets = split(" ", $$pkgs{$pkg}{SUBSET});
    $subset = $subsets[0];
  }
  
  $loc = "$self->{$$ctx{TARGET}{UPI}}{$pkg}{TLOC}/${kit}/instctrl/${subset}.ctrl";
  
  $$ctx{LOGGER}->entering("CPIOSF1::get_mediapkgvers");
  $$ctx{LOGGER}->finer("loc=$loc\nkit=${kit}\nsubset=${subset}");
  
  if (-f $loc) {
    $vl = Utils::vxif_dor("$self->{CMD}{GREP} 'DESC=' $loc", "", $ctx);
    if ($vl =~ /.*\(Version\s+(\d+.\d+.\d+.\d+).*/) {
      $v = $1;
    }
    $$ctx{LOGGER}->finer("vl=${vl}v=$v");
  } else {
    $$ctx{LOGGER}->error(Utils::_tr("Unable to determine the package version on the media. $loc not found on $$ctx{LOCAL}{HOST}.", 25, 1002, "$loc", "$$ctx{LOCAL}{HOST}"));
  }
  
  return $v;
}

#
# Determine size of the given package on the media. If the package is compressed, we are assuming
# the compression of 3x.
#
# Input: 1) the reference of the installation context;
#        2) the reference of the packages hash;
#        3) the fileset name;
#        4) the location of the given package;
#        5) indicating whether the given package is in a compressed file;
#        6) the compressed filename;
#
# Return: the size of the package in kilobytes.
#
sub get_mediapkgsize {
  my ($self,$ctx,$pkgs,$pkg,$loc,$compressed,$filename) = @_;
  my ($size) = 0;
  my ($kit);
  
  $$ctx{LOGGER}->entering("CPIOSF1::get_mediapkgsize");
  
  if ($compressed) {
    $$ctx{LOGGER}->fine(Utils::_tr("${pkg} is compressed", 25, 1003, "${pkg}"));
    if (-f "${loc}/${filename}") {
      $$ctx{LOGGER}->info("$self->{CMD}{DU} -sk ${loc}/${filename} | $self->{CMD}{AWK} '{print \$1}'");
      $size = Utils::vxif_dol("$self->{CMD}{DU} -sk ${loc}/${filename} | $self->{CMD}{AWK} '{print \$1}'");
      # assume compression of 3x. multiple size by 4 to account for the compressed package itself
      $size *= 4;
    } else {
      $$ctx{LOGGER}->warning(Utils::_tr("Unable to determine the size of ${pkg} because ${loc}/${filename} does not exist on $$ctx{LOCAL}{HOST}.", 25, 1004, "${pkg}", "${loc}", "${filename}", "$$ctx{LOCAL}{HOST}"));
      return 0;
    }
  } else {
    $$ctx{LOGGER}->fine(Utils::_tr("${pkg} is uncompressed", 25, 1005, "${pkg}"));
    
    $kit = $$pkgs{$pkg}{KIT};
    
    # support the B stuff here
    if (defined($$pkgs{$pkg}{SUBSET})) {
      $kit = $pkg;
    }
    
    if (-d "${loc}/$kit") {
      $size = Utils::vxif_dol("$self->{CMD}{DU} -sk ${loc}/$kit | $self->{CMD}{AWK} '{print \$1}'");
    } else {
      $$ctx{LOGGER}->error(Utils::_tr("Unable to determine the size of ${pkg} because ${loc}/$kit does not exist on $$ctx{LOCAL}{HOST}.", 25, 1004, "${pkg}", "${loc}", "$kit", "$$ctx{LOCAL}{HOST}"));
      return 0;
    }
  }
  
  $$ctx{LOGGER}->info(Utils::_tr("Size of ${pkg} is ${size} kbs", 25, 1006, "${pkg}", "${size}"));
  
  return $size;
}

#
# Determine if a package has any dependencies on target host.
#
# Input: 1) the reference to the installation context;
#        2) the native package name;
#
# Return: a string of dependent packages or null if there are no dependents.
#
sub get_pkgdep {
  my ($self,$ctx,$pkg) = @_;
  my ($dep,$deplist,$deppkgs,@deps,@ideps);
  my $trg_host = $ctx->get_target_hostname();
  my $upi_inst = $ctx->get_host_os_upi_installer($trg_host);
    
  $$ctx{LOGGER}->entering("CPIOSF1::get_pkgdep");
    
  # replaces as part of the v4.4 updates. - jpk 10 Feb 06
  #if ($self->{PRODUCT}{$$ctx{TARGET}{UPI}}->can("check_for_package_dependents")) {
    #$deppkgs = $self->{PRODUCT}{$$ctx{TARGET}{UPI}}->check_for_package_dependents($ctx, $pkg);
  if ($upi_inst->can("check_for_package_dependents")) {
    $deppkgs = $upi_inst->check_for_package_dependents($ctx, $pkg);
    @deps = keys(%{$deppkgs});
    $deplist = join(" ", @deps);
    $deplist .= " ";
  }
  
  return Utils::vxif_desp($deplist);
}

#
# Determine the netmask of the base IP configured on a NIC.
#
# Input: 1) the reference to the installation context;
#        2) the NIC;
#
# Return: the netmask.
#
sub get_netmask (\%) {
  my ($self,$ctx,$nic) = @_;
  my ($nm);
  
  $nm = Utils::vxif_dor("$self->{CMD}{IFCONFIG} $nic | $self->{CMD}{GREP} netmask | $self->{CMD}{AWK} '{print \$4}'", "", $ctx);
  # convert it to decimal format
  $nm =~ /^(..)(..)(..)(..)$/;
  $nm = sprintf("%d.%d.%d.%d", oct "0x$1", "0x$2", "0x$3", "0x$4");
  
  return "$nm";
}

#
# Determine the NICs on target host which have IP addresses configured on them
# return a reference to an array holding the NICs
#
# Input: 1) the reference to the installation context;
#
# Return: a reference to an array holding the NICs.
#
sub get_publicnics (\%) {
  my ($self,$ctx) = @_;
  my (@pnics,$do);
  
  $do = Utils::vxif_dor("$self->{CMD}{IFCONFIG} -a | $self->{CMD}{GREP} 'flags=' | $self->{CMD}{SED} 's/:.*\$//' | $self->{CMD}{AWK} '{print \$1}' | $self->{CMD}{UNIQ}", "", $ctx);
  @pnics=split(/\s+/,$do);
  
  return \@pnics;
}

#
# Check whether a patch is installed on the installation host.
#
# Input: 1) UPI;
#        2) the patch name;
#        3) the reference to the installation context;
#        4) the reference to the installed patch;
#        5) indicate whether to refresh the current patches list;
#
# Return: -1 if the patch ID is invalid;
#         0 if the patch does not exist;
#         1 if older version is installed; 
#         2 if version or higher is installed.       
#
sub check_patch ($$$$$) {
  my ($self,$upi,$patch,$ctx,$installedpatch,$refresh) = @_;
  
  # stub this out for now
  return 0;
}

#
# Check for and run post pkgadd operations.
#
# Input: 1) UPI;
#        2) package name;
#        3) the reference to the installation context;
#
# Return: 1 if successful; 0 otherwise.
#
sub check_os_patch_dependencies ($$$) {
  my ($self,$upi,$pkg,$ctx) = (@_);
  my (@patchlist,$patch,$patchid);
  my ($rc,$installedpatchid,$msgl,$msgr);
  my ($result) = 1;
  
  if ($self->{PRODUCT}{$upi}->can("get_required_os_patches")) {
    @patchlist = $self->{PRODUCT}{$upi}->get_required_os_patches($pkg, $ctx);
  }
  
  if ($#patchlist >= 0 ) {
    Utils::vxif_pl(Utils::_tr("Package, $pkg, require one or more OS patches.", 25, 1007, "$pkg"));
    foreach $patch (@patchlist) {
      $patchid = $patch;
      ($self->{PRODUCT}{$upi}->can("get_patch_id")) && ($patchid = $self->{PRODUCT}{$upi}->get_patch_id($patch, $ctx));
      $msgl = Utils::_tr("Checking OS patch ${patchid}", 25, 1008, "${patchid}");
      Utils::vxif_pbl($msgl);
      
      $rc = $self->check_patch($upi, $pkg, $ctx, \$installedpatchid, "");
      if ($rc == -1) {
        $msgr = Utils::_tr("invalid patch ID, ${patchid}", 25, 1009, "${patchid}");
        Utils::vxif_pbr($msgl, $msgr);
        $result = 0;
      } elsif ($rc == 0) {
        $msgr = Utils::_tr("not installed", 25, 1010);
        Utils::vxif_pbr($msgl, $msgr);
        $result = 0;
      } elsif ($rc == 1) {
        $msgr = Utils::_tr("${installedpatchid} installed", 25, 1011, "${installedpatchid}");
        Utils::vxif_pbr($msgl, $msgr);
        $result = 0;
      } else {
        $msgr = Utils::_tr("${installedpatchid} installed", 25, 1011, "${installedpatchid}");
        Utils::vxif_pbr($msgl, $msgr);
      }
    }
  }
  
  return 1;
}

#
# Check for pkgadd errors.
#
# Input: 1) the reference to the installation context;
#        2) the package installed;
#
# Return: 0 if no error; 1 otherwise.
#
sub pkg_installerror (\%) {
  my ($self,$ctx,$pkg) = @_;
  my ($logfile) = "$$ctx{TLOG}/$$ctx{TASK}.${pkg}.$$ctx{TARGET}{HOST}";
  my ($error);
  
  # no consistent way to determine install errors
  return 0;
}

#
# Check for pkgrm errors.
#
# Input: 1) the reference to the installation context;
#        2) the package installed;
#
# Return: 0 if no error; 1 otherwise.
#
sub pkg_uninstallerror (\%) {
  my ($self,$ctx,$pkg) = @_;
  
  # no consistent way to determine uninstall errors
  return 0;
}

#
# Add the native package to the target host.
#
# Input: 1) the reference to the installation context;
#        2) the reference to the packages hash;
#        3) the package to install;
#
# Return: 1 if successful; 0 otherwise.
#
sub install_native_package (\%\%$) {
  my ($self,$ctx,$pkgs,$pkg) = (@_);
  my ($logfile) = "$$ctx{TLOG}/$$ctx{TASK}.${pkg}.$$ctx{TARGET}{HOST}";
  my ($subset) = $pkg;
  my ($kit) = $$pkgs{$pkg}{KIT};
  my ($iver,$pkgver);
  my ($result);
  # v4.4 updates 10 Feb 06 jpk
  my $logger = $ctx->get_logger();
  my $logdir = $logger->get_logdir();
  my $task_type = $ctx->get_task_type();
  my $trg_host = $ctx->get_target_hostname();
  my $logfile = "${logdir}/${task_type}.${pkg}.${trg_host}";
  my $trg_upi = $ctx->get_target_upi();
  
  # check to make sure the given package is not already exist on the target host
  $result = $self->check_for_existing_package($ctx, $pkg, $pkgs);
  if (0 == $result) {
	return 0;
  } elsif (2 == $result) {
	return 1;
  }
  
  # support the B stuff here
  if (defined($$pkgs{$pkg}{SUBSET})) {
    $kit = $pkg;
    $subset = $$pkgs{$pkg}{SUBSET};
  }
 
  # v4.4 updates 10 Feb 06 jpk 
  #Utils::vxif_dor("$self->{CMD}{SETLD} -l $self->{$$ctx{TARGET}{UPI}}{$pkg}{TLOC}/$kit $subset 2>${logfile} 1>${logfile}", "", $ctx);
  Utils::vxif_dor("$self->{CMD}{SETLD} -l $self->{$trg_upi}{$pkg}{TLOC}/$kit $subset 2>${logfile} 1>${logfile}", "", $ctx);
  
  return $self->is_package_install_successful($ctx, $pkg, $pkgs);
}

#
# Remove the native package from the target host.
#
# Input: 1) the reference to the installation context;
#        2) the reference to the packages hash;
#        3) the package to install;
#
# Return: 1 if successful; 0 otherwise.
#
sub uninstall_native_package (\%\%$) {
  my ($self,$ctx,$pkgs,$pkg) = (@_);
  my ($logfile) = "$$ctx{TLOG}/$$ctx{TASK}.${pkg}.$$ctx{TARGET}{HOST}";
  my ($subset) = $pkg;
  
  # support the B stuff here
  if (defined($$pkgs{$pkg}{SUBSET})) {
    $subset = $$pkgs{$pkg}{SUBSET};
  }
    
  # now remove the package
  Utils::vxif_dor("$self->{CMD}{SETLD} -d $subset 2>${logfile} 1>${logfile}", "", $ctx);
 
  # if the package is successfully uninstalled, the version number null.
  if ((!$self->pkg_uninstallerror($ctx, $pkg))&&($self->get_instpkgvers($ctx, $pkg, "", $pkgs) eq "")) {
    $$ctx{LOGGER}->info(Utils::_tr("${pkg} successfully uninstalled from $$ctx{TARGET}{HOST}", 25, 1012, "${pkg}", "$$ctx{TARGET}{HOST}"));
    return 1;
  }
   
  $$ctx{LOGGER}->info(Utils::_tr("Unable to uninstall ${pkg} from $$ctx{TARGET}{HOST}", 25, 1013, "${pkg}", "$$ctx{TARGET}{HOST}"));
  return 0;
}

#
# Check to make sure all the external dependencies are satisfied.
#
# Input: 1) the reference to the installation context;
#
# Return: 1 if everything is happy; 0 otherwise.
#
sub check_for_external_dependencies (\%) {
  my ($self,$ctx) = @_;
  my ($msgl,$msgr);

  # this is basically moot - jpk 10 Feb 06

  #$msgl = Utils::_tr("Checking for external dependencies");
  #Utils::vxif_pbl($msgl);
  #$msgr = Utils::_tr("all external dependencies satisfied");
  #Utils::vxif_pbr($msgl, $msgr);
  return 1; # stub this out for now
}

#
# Get the native package name for the given package.
#
# Input: 1) reference to the installation context;
#        2) the package name;
#        3) reference the the packages hash;
#
# Return: the native package name.
#
sub get_package_name (\%$\%) {
  my ($self,$ctx,$pkg,$pkgs) = @_;
  
  return $pkg;
}

sub get_native_package_file (\%$\$\%) {
  my ($self,$ctx,$pkg,$fod,$pkgs) = @_;

  $$fod = "d";

  # support the B stuff
  # support the B stuff here
  if (defined($$pkgs{$pkg}{SUBSET})) {
    return $pkg;
  } else {
    return $$pkgs{$pkg}{KIT};
  }
}

1;
