package PerlUnixSh;
use strict;
use Text::ParseWords;
use File::Basename;
use VxIF::NativePerl::PerlUnixCmds;

sub new {
	my $pkg = shift;
	my $this = {};

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	#
}

# Takes a command line, such as might be passed to ``.
# Tokenizes, presumably (hopefully, actually :-), as a shell command would.
# Shifts out 1st token, and assumes it's a fully qualified command.
# Uses basename of command as a key to lookup the processor.
# Returns a 2-list consisting of a function pointer and an arg array.
# TODO: handle '|'s.
sub parse_cmdline ($) {
	my ($cmdline) = @_;
	my $cmd_proc = undef;
	my $argv = [];

	# well glory!  this seems to work.
	@$argv = shellwords($cmdline);

	if (@$argv) {
		my $fqcmd = shift(@$argv);
		my $cmd = basename($fqcmd);
		$cmd_proc = PerlUnixCmds::get_cmd_proc($cmd);
	}

	return ($cmd_proc, $argv);
}

# aggregates stdout and returns it.
# return code sent back in $?.
sub backquote ($$;$) {
	my ($cmd_proc, $argv, $proc) = @_;
	my $cmd_outp = "";
	my $accum_stdout = sub {
		my ($outp_rec) = @_;
		$cmd_outp .= "${outp_rec}\n";
	};
	my $eff_proc = ($proc ? $proc : $accum_stdout);
	my $rc = $cmd_proc->($argv, $eff_proc);
	$? = $rc;

	return $cmd_outp;
}

1;

