package Net::Rsh;
use strict;

require Exporter;

use vars qw($VERSION @ISA @EXPORT);

$VERSION=0.02;

use VxIF::NativePerl::Net::SocketCmd;
@Net::Rsh::ISA = qw(Net::SocketCmd);

@EXPORT = qw(&rsh);

sub new {
	my $pkg = shift;
	my $this = new Net::SocketCmd();

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	$this->set_peer_port(514);
}

sub rsh {
	my ($self,$host,$local_user,$remote_user,$cmd)=@_;
	croak("Usage: \$c->rsh(\$host,\$local_user,\$remote_user,\$cmd)") unless @_ == 5;

	my $result = [];

	my $socket = $self->get_socket($host);

	if ($socket) {
		print $socket "0\0";
		print $socket "$local_user\0";                                                                                                            
		print $socket "$remote_user\0";
		print $socket "$cmd\0";

		@$result = <$socket>;

		$self->recycle_socket($socket);
	}

	return $result;
}

END { } 

1;

__END__

=head1 NAME

Net::Rsh - perl client for Rsh protocol

=head1 SYNOPSIS

  use Net::Rsh;

  $a=Net::Rsh->new();

  $host="cisco.router.com";
  $local_user="root";
  $remote_user="root";
  $cmd="sh ru";

  @c=$a->rsh($host,$local_user,$remote_user,$cmd);

  print @c;
  

=head1 DESCRIPTION

  Rsh protocol requires that the program be
  run as root or that the program be setuid to root    

=head1 AUTHOR

Oleg Prokopyev, <riiki@gu.net>

=cut
