package CPINativePerl;
our @ISA = ("CPICommon");
require VxIF::CPICommon;

###############################
# Private Methods             #
###############################

###############################
# Public Methods       	      #
###############################

#
# Create an Installer object.
#
# Inputs: PRODUCT	=> the name of the product to install;
#         LOGGER 	=> reference to the Logger object; This is optional;
#         TITLE		=> product title; This is option; The default title is
#                          VERITAS Installer;
#         TMPPATH 	=> the complete to the tmp directory; This is optional;
#                          The default is /var/tmp;
#         INSTALLONLY 	=> install without configure; This is optional;
#                          The default is install and configure;
#         RESPONSEFILE	=> response file; This is optional; If a responsible is provided,
#                          the pre install and post install steps will be skipped;
#         USESSH	=> indicate whether to use SSH for remote installation; This is optional;
#                          The default is to use rsh;
#         SUPPORTEDOS	=> a list of supported OSs; This is optional; By default, the supported
#                          OSs are SunOS, Linux, HPUX, AIX, and OSF1;
#         CMDSEARCHPATHS=> a list of system paths to search for a shell command; This is optional;
#                          By default, the search paths are '/usr/bin', '/bin', '/usr/local/bin', 
#                          '/sbin', '/usr/sbin', and '/usr/local/sbin';
#
sub new {
  my $invocant = shift;
  my $class = ref($invocant) || $invocant;
  my @os = qw(SunOS Linux Darwin HPUX AIX OSF1 NativePerl);
  my @searchpaths = qw(/usr/bin /bin /usr/local/bin /sbin /usr/sbin /usr/local/sbin);
  my $self = { 	
	  USESSH            => 0,
	  TMPPATH           => 'c:/var/tmp/vxif',
	  PATCHSDIR         => 'patches',
	  OSINSTALLER       => 'NativePerl',
	  SUPPORTEDOS       => \@os,
	  CMDSEARCHPATHS	=> \@searchpaths,
	  @_,
  };

  return bless $self, $class;
}

#
# Set the common system commands.
#
# Input: 1) the reference of the installation context;
#
sub set_commands ($) {
  my ($self) = @_;

  #$self->SUPER::set_commands();
  #
  # This is only used as the source platform.
  # So, we only need these (few) commands.
  $self->{CMD}{CP} = "cp";
  $self->{CMD}{DOMAINNAME} = "domainname";
  $self->{CMD}{GREP}="grep";
  $self->{CMD}{MKDIR} = "mkdir";
  $self->{CMD}{RCP}="rcp";
  $self->{CMD}{RMR}="rm";
  $self->{CMD}{RSH}="rsh -l root";
  $self->{CMD}{TOUCH}="touch";
  $self->{CMD}{UNAME}="uname";
}


#
# Set message strings for package, packages
#
sub set_msgs {
  my ($self) = @_;
  
  $self->SUPER::set_msgs();
  $self->{MSG}{PDFREN}  = "package";
  $self->{MSG}{PDFR}  = Utils::_tr("package", 29, 1000);
  $self->{MSG}{PDFRS} = Utils::_tr("packages", 29, 1001);
}

#
# Initialization.
#
# Input: 1) the reference of the installation context;
#
# Return: 1 if successfull; 0 otherwise.
#
sub initialize ($) {
  my($self,$context) = @_;
  
  $self->SUPER::initialize($context);
  
  $self->set_msgs();
  
  return 1;
}

#
# Add a product to this platform.
#
# Input: 1) the UPI;
#        2) the reference of the product object;
# 
sub add_product ($&) {
  my($self,$upi,$product) = @_;
 
  $self->{PRODUCT}{$upi} = $product;
}

1;

