package VxIF::Interface::Utils::OrderedSet;

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->set_order([]);
	$self->set_values({});
}

sub get_order {
	my $self = shift;
	my $order = $self->{order};

	return $order;
}

sub set_order {
	my $self = shift;
	my ($order) = @_;

	$self->{order} = $order;
}

sub get_values {
	my $self = shift;
	my $values = $self->{values};

	return $values;
}

sub set_values {
	my $self = shift;
	my ($values) = @_;

	$self->{values} = $values;
}

sub get_value {
	my $self = shift;
	my ($key) = @_;
	my $values_href = $self->get_values();
	my $value = $values_href->{$key};

	return $value;
}

sub set_value {
	my $self = shift;
	my ($key, $val) = @_;
	my $order_aref = $self->get_order();
	my $values_href = $self->get_values();
	my $already_in = exists($values_href->{$key});

	$values_href->{$key} = $val;

	if (!$already_in) {
		push(@$order_aref, $key)
	}
}

sub get_value_ref {
	my $self = shift;
	my ($key) = @_;
	my $values_href = $self->get_values();
	my $value_ref = \$values_href->{$key};

	return $value_ref;
}

sub from_aref_href {
	my $self = shift;
	my ($aref, $href) = @_;

	for my $key (@$aref) {
		my $val = $href->{$key};

		$self->set_value($key, $val);
	}
}

1;

