package VxIF::Interface::Tk::UI::StatusBar;
use strict;
use VxIF::Interface::Generic::UI::StatusBar;
@VxIF::Interface::Tk::UI::StatusBar::ISA = qw(VxIF::Interface::Generic::UI::StatusBar);
use VxIF::Utils;

sub new {
	my $pkg = shift;
	my ($item_id) = @_;
	my $this = new VxIF::Interface::Generic::UI::StatusBar($item_id);

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	#
}

sub get_tk_widget {
	my $this = shift;
	my $tk_widget = $this->{tk_widget};

	return $tk_widget;
}

sub set_tk_widget {
	my $this = shift;
	my ($tk_widget) = @_;

	$this->{tk_widget} = $tk_widget;
}

sub display_status {
	my $this = shift;
	my ($msg) = @_;

	my $lbl = $this->get_tk_widget();
	$lbl->configure(-text => $msg);
	$lbl->pack();
}

sub display_and_log_status {
	my $this = shift;
	my ($msg, $level) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	$this->display_status($msg);
	my $logger = $ifmgr->get_logger();

	$logger->log($msg, $level);
}

1;

