package VxIF::Interface::Tk::UI::OptionsMenu;
use strict;
use VxIF::Interface::Generic::UI::OptionsMenu;
@VxIF::Interface::Tk::UI::OptionsMenu::ISA = qw(VxIF::Interface::Generic::UI::OptionsMenu);
use Tk;
use Tk::Balloon;

sub new {
	my $pkg = shift;
	my ($class_factory) = @_;
	my $this = new VxIF::Interface::Generic::UI::OptionsMenu($class_factory);

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	#
}

sub get_tk_widgets {
	my $this = shift;
	my $tk_widgets = $this->{tk_widgets};

	return $tk_widgets;
}

sub set_tk_widgets {
	my $this = shift;
	my ($tk_widgets) = @_;

	$this->{tk_widgets} = $tk_widgets;
}

sub get_ret_msg_id {
	my $this = shift;
	my $ret_msg_id = $this->{ret_msg_id};

	return $ret_msg_id;
}

sub set_ret_msg_id {
	my $this = shift;
	my ($ret_msg_id) = @_;

	$this->{ret_msg_id} = $ret_msg_id;
}

sub display_title {
	my $this = shift;
	my $title = $this->get_title();

	if ($title) {
		my $tk_widgets = $this->get_tk_widgets();
		my $mw = $tk_widgets->{mw};
		$mw->title($title);
	}

}

sub initialize_widgets {
	my $this = shift;
	my $mw = new MainWindow();
	my $lb = $mw->Listbox();

	$lb->configure
		(
		 -relief => 'ridge',
		 );
	$lb->bind
		(
		 '<Double-Button-1>',
		 sub {
			 my $s = $lb->curselection();
			 my $ix = $s->[0];
			 my $menu = $this->get_menu();
			 my $menu_items = $menu->get_menu_items();
			 my $menu_item = $menu_items->[$ix];
			 $menu->set_selected_item($menu_item);
			 #$lb->send_dialog_message($this, "ID_OK");
			 $this->set_ret_msg_id("ID_OK");
			 $mw->destroy();
		 },
		 );

	my $tk_widgets = {
		mw => $mw,
		lb => $lb,
	};

	$this->set_tk_widgets($tk_widgets);
}

sub initialize {
	my $this = shift;
	my $title = $this->get_title();

	$this->initialize_widgets();

	$this->display_title();
}

sub message_loop {
	my $this = shift;
	my $tk_widgets = $this->get_tk_widgets();
	$this->set_ret_msg_id("ID_CANCEL");

	MainLoop();
}

sub do_modal {
	my $this = shift;
	my $help_text = $this->get_help_text();
	my $menu = $this->get_menu();
	my $menu_items = $menu->get_menu_items();
	my $buttons = $this->get_buttons();
	my $back_key_handler = undef;
	my $quit_key_handler = undef;
	my $choices = [];
	my $ret_mode = undef;
	my $selected_ix = undef;
	my $selected_item = $menu->get_selected_item();

	$this->initialize();

	my $tk_widgets = $this->get_tk_widgets();
	my $mw = $tk_widgets->{mw};

	my $max_textlen = 0;
	my $tt_text_aref = [];
	my $num_menu_items = scalar(@$menu_items);
	for (my $ix = 0; $ix < $num_menu_items; $ix++) {
		my $mi = $menu_items->[$ix];
		my $text = $mi->get_text();
		my $textlen = length($text);
		if ($textlen > $max_textlen) {
			$max_textlen = $textlen;
		}
		push(@$choices, $text);
		if ($selected_item && $mi == $selected_item) {
			$selected_ix = $ix;
		}
		my $tt_text = $mi->get_tooltip_text();
		if ($tt_text) {
			push(@$tt_text_aref, $tt_text);
		} else {
			push(@$tt_text_aref, "no information available");
		}
	}

	my $lb = $tk_widgets->{lb};
	$lb->insert('end', @$choices);
	if (defined($selected_ix)) {
		$lb->selectionSet($selected_ix);
	}
	$lb->configure(-width => $max_textlen);
	my $tt_balloon = $mw->Balloon();
	$tt_balloon->attach
		(
		 $lb,
		 -balloonposition => 'mouse',
		 -msg => $tt_text_aref,
		 );
	$lb->pack();

	# prompt
	my $prompt = $this->get_prompt();
	if ($prompt) {
		my $lbl = $mw->Label();
		$lbl->configure(-text => $prompt);
		$lbl->pack();
	}

	for my $button (@$buttons) {
		my $text = $button->get_text();
		my $btn = $mw->Button();
		$btn->configure
			(
			 -text => $text,
			 );
		my $min_width = 20;
		if (length($text) < $min_width) {
			$btn->configure
				(
				 -width => $min_width,
				 );
		}
		if ($button->get_click_proc()) {
			$btn->configure
				(
				 -command => sub{$button->get_click_proc()->();},
				 );
		}
		$btn->pack();
	}

	$this->message_loop();

	$ret_mode = $this->get_ret_msg_id();

	return $ret_mode;
}

1;

