package VxIF::Interface::Tk::UI::LabeledInfo;
use strict;
use VxIF::Interface::Generic::UI::Item;
@VxIF::Interface::Tk::UI::LabeledInfo::ISA = qw(VxIF::Interface::Generic::UI::LabeledInfo);

sub new {
	my $pkg = shift;
	my ($item_id) = @_;
	my $this = new VxIF::Interface::Generic::UI::LabeledInfo($item_id);

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	#
}

sub get_tk_widget {
	my $this = shift;
	my $tk_widget = $this->{tk_widget};

	return $tk_widget;
}

sub set_tk_widget {
	my $this = shift;
	my ($tk_widget) = @_;

	$this->{tk_widget} = $tk_widget;
}

sub put {
	my $this = shift;
	my $label_text = $this->get_label_text();
	my $separator = $this->get_separator();
	my $info_text = $this->get_info_text();
	my $eff_text =
		sprintf
		(
		 "%s%s%s",
		 $label_text,
		 $separator,
		 $info_text,
		 );
	my $lbl = $this->get_tk_widget();
	$lbl->configure(-text => $eff_text);
	$lbl->pack();
}

1;

