package VxIF::Interface::Tk::UI::Form;
use strict;
use VxIF::Interface::Generic::UI::Form;
@VxIF::Interface::Tk::UI::Form::ISA = qw(VxIF::Interface::Generic::UI::Form);
use Tk;
use Tk::LabEntry;

sub new {
	my $pkg = shift;
	my $this = {};

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	my ($class_factory) = @_;

	$this->VxIF::Interface::Generic::UI::Form::init($class_factory);
}

sub fill_out {
	my $self = shift;
	my $ifmgr = $self->get_interface_manager();
	my $cf = $ifmgr->get_class_factory();
	my $fields = $self->get_form_fields();
	my $mw = new MainWindow();

	my $num_fields = scalar(@$fields);
	for (my $i = 0; $i < $num_fields; $i++) {
		my $field = $fields->[$i];
		my $key = $field->get_label();
		my $val_ref = $field->get_text_ref();

		my $fr = $mw->Frame();
		$fr->configure
			(
			 -borderwidth => 3,
			 -relief => 'ridge',
			 );
		$fr->pack(-side => 'top', -anchor => 'center', -fill => 'x', -expand => 'y');

		my $lbl = $fr->Label();
		$lbl->configure
			(
			 -text => "${key}:",
			 -justify => 'right',
			 );
		my $ent = $fr->Entry();
		$ent->configure
			(
			 -textvariable => $val_ref,
			 -relief => 'sunken',
			 -width => 40,
			 );

		$ent->pack(-side => 'right');
		$lbl->pack(-side => 'right');
	}

	my $btn_fr = $mw->Frame();
	$btn_fr->configure
		(
		 -borderwidth => 3,
		 -relief => 'ridge',
		 );
	#$btn_fr->pack(-side => 'top', -anchor => 'center', -fill => 'x', -expand => 'y');
	$btn_fr->pack(-side => 'top', -anchor => 'center');
	my $btn = $btn_fr->Button(-text => "Ok", -command => sub{$mw->destroy();});
	$btn->pack();

	MainLoop();
}

1;

