package VxIF::Interface::Tk::ClassFactory;
use strict;

use VxIF::Interface::Classic::ClassFactory;
@VxIF::Interface::Tk::ClassFactory::ISA = qw(VxIF::Interface::Classic::ClassFactory);

use VxIF::Interface::Tk::UI::OptionsMenu;
use VxIF::Interface::Tk::UI::LabeledInfo;
use VxIF::Interface::Tk::UI::StatusBar;
use VxIF::Interface::Tk::UI::Form;

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->VxIF::Interface::Classic::ClassFactory::init(@_);
}

# UI

sub create_options_menu {
	my $this = shift;
	my $options_menu = new VxIF::Interface::Tk::UI::OptionsMenu($this);

	#$options_menu->set_class_factory($this);

	return $options_menu;
}

sub create_labeled_info {
	my $this = shift;
	my ($msg_id) = @_;
	my $labeled_info = new VxIF::Interface::Tk::UI::LabeledInfo($msg_id);

	$labeled_info->set_class_factory($this);

	return $labeled_info;
}

sub create_status_bar {
	my $this = shift;
	my ($msg_id) = @_;
	my $status_bar = new VxIF::Interface::Tk::UI::StatusBar($msg_id);

	$status_bar->set_class_factory($this);

	return $status_bar;
}

sub create_form {
	my $this = shift;
	my ($item_id) = @_;
	my $form = new VxIF::Interface::Tk::UI::Form($item_id);

	$form->set_class_factory($this);

	return $form;
}

1;

