package VxIF::Interface::Object;
use strict;

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->set_class_factory(undef);
}

sub get_class_factory {
	my $self = shift;
	my $class_factory = $self->{class_factory};

	return $class_factory;
}

sub set_class_factory {
	my $self = shift;
	my ($class_factory) = @_;

	$self->{class_factory} = $class_factory;
}

sub get_interface_manager {
	my $self = shift;
	my $class_factory = $self->get_class_factory();
	my $interface_manager = $class_factory->get_interface_manager();

	return $interface_manager;
}

sub throw {
	my $self = shift;
	my $num_args = scalar(@_);

	if ($num_args == 1) {
		my ($err) = @_;
		die $err;
	} elsif($num_args == 2) {
		my ($rc, $msg) = @_;
		my $cf = $self->get_class_factory();
		my $error = $cf->create_error();
		$error->set_rc($rc);
		$error->set_msg($msg);
		die $error;
	} else {
		my $ifmgr = $self->get_interface_manager();
		my $localizer = $ifmgr->get_localizer();
		my $msg = $localizer->translate("Unknown error.\n");
		$? = 1;
		die $msg;
	}
}

sub catch {
	my $self = shift;
	my $error = undef;

	if ($@) {
		# something died

		# create an error, just to get a ref
		my $cf = $self->get_class_factory();
		my $err = $cf->create_error();
		my $err_class = ref($err);
		# see if an error (object) was thrown
		if (UNIVERSAL::isa($@, $err_class)) {
			# Some error or derivative was thrown.
			# Return it.
			$error = $@;
		} else {
			# Assume a string was thrown.
			# Construct an error object.
			my $rc = $?;
			if (!$rc) {
				$rc = 1;
			}
			my $msg = "$@";
			$err->set_rc($rc);
			$err->set_msg($msg);
			$error = $err;
		}
	}

	return $error;
}

1;

