package VxIF::Interface::Generic::UI::TextInput;
use strict;
use VxIF::Interface::Generic::UI::Item;
@VxIF::Interface::Generic::UI::TextInput::ISA = qw(VxIF::Interface::Generic::UI::Item);

sub new {
	my $pkg = shift;
	my ($item_id) = @_;
	my $this = new VxIF::Interface::Generic::UI::Item($item_id);

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	my $empty_str = "";

	$this->set_text($empty_str);
}

sub get_text {
	my $this = shift;
	my $text = $this->{text};

	return $text;
}

sub set_text {
	my $this = shift;
	my ($text) = @_;

	$this->{text} = $text;
}

sub display_prompt {
	my $this = shift;
	my ($prompt) = @_;
	print("${prompt}");
}

sub get_line {
	my $this = shift;
	my ($prompt) = @_;

	if ($prompt) {
		$this->display_prompt($prompt);
	}

	my $uinp = <STDIN>;
	# remove trailing crs
	chomp $uinp;
	# trim
	$uinp =~ s/^\s+|\s+$//g;

	# no, let client decide
	#$this->set_text($uinp);

	return $uinp;
}

1;

