package VxIF::Interface::Generic::UI::StatusBar;
use strict;
use VxIF::Interface::Generic::UI::Item;
@VxIF::Interface::Generic::UI::StatusBar::ISA = qw(VxIF::Interface::Generic::UI::Item);

sub new {
	my $pkg = shift;
	my ($item_id) = @_;
	my $this = new VxIF::Interface::Generic::UI::Item($item_id);

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	#
}

sub display_status {
	my $this = shift;
	my ($msg) = @_;
	my $eff_msg = defined($msg) ? $msg : "";

	print("${eff_msg}\n");
}

sub log_status {
	my $this = shift;
	my ($msg, $level) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $logger = $ifmgr->get_logger();

	$logger->log($msg, $level);
}

sub display_and_log_status {
	my $this = shift;
	my ($msg, $level) = @_;

	$this->display_status($msg);

	$this->log_status($msg, $level);
}

1;

