package VxIF::Interface::Generic::UI::Progress;
use strict;
use VxIF::Interface::Generic::UI::Item;
@VxIF::Interface::Generic::UI::Progress::ISA = qw(VxIF::Interface::Generic::UI::Item);

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;
	my ($item_id, $class_factory) = @_;

	$self->VxIF::Interface::Generic::UI::Item::init($item_id);

	$self->set_class_factory($class_factory);

	my $li_id = "${item_id}:LI";
	my $li = $class_factory->create_labeled_info($li_id);
	$li->set_label_text("");
	$li->set_separator(": ");
	$li->set_info_text("");
	$self->set_labeled_info($li);

	$self->set_min_value(0);
	$self->set_max_value(100);
	$self->set_curr_value(0);
}

sub get_labeled_info {
	my $this = shift;
	my $labeled_info = $this->{labeled_info};

	return $labeled_info;
}

sub set_labeled_info {
	my $this = shift;
	my ($labeled_info) = @_;

	$this->{labeled_info} = $labeled_info;
}

sub get_min_value {
	my $this = shift;
	my $min_value = $this->{min_value};

	return $min_value;
}

sub set_min_value {
	my $this = shift;
	my ($min_value) = @_;

	$this->{min_value} = $min_value;
}

sub get_max_value {
	my $this = shift;
	my $max_value = $this->{max_value};

	return $max_value;
}

sub set_max_value {
	my $this = shift;
	my ($max_value) = @_;

	$this->{max_value} = $max_value;
}

sub get_curr_value {
	my $this = shift;
	my $curr_value = $this->{curr_value};

	return $curr_value;
}

sub set_curr_value {
	my $this = shift;
	my ($curr_value) = @_;

	$this->{curr_value} = $curr_value;
}

sub get_label_text {
	my $this = shift;
	my $li = $this->get_labeled_info();
	my $label_text = $li->get_label_text();

	return $label_text;
}

sub set_label_text {
	my $this = shift;
	my ($label_text) = @_;
	my $li = $this->get_labeled_info();

	$li->set_label_text($label_text);
}

sub get_info_text {
	my $this = shift;
	my $li = $this->get_labeled_info();
	my $info_text = $li->get_info_text();

	return $info_text;
}

sub set_info_text {
	my $this = shift;
	my ($info_text) = @_;
	my $li = $this->get_labeled_info();

	$li->set_info_text($info_text);
}

sub update {
	my $this = shift;
	my ($new_curr_value, $new_info_text) = @_;

	if (defined($new_curr_value)) {
		$this->set_curr_value($new_curr_value);
	}

	if (defined($new_info_text)) {
		$this->set_info_text($new_info_text);
	}

	$this->put();
}

sub put {
	my $this = shift;
	my $li = $this->get_labeled_info();
	my $min = $this->get_min_value();
	my $cur = $this->get_curr_value();
	my $max = $this->get_max_value();
	my $lt = $li->get_label_text();
	my $sep = $li->get_separator();
	my $it = $li->get_info_text();

	print("Progress(${min} <= ${cur} <= ${max}) ==> ");
	print("${lt}: ${it}\n");
}

1;

