package VxIF::Interface::Generic::UI::OptionsMenu;
use strict;
use VxIF::Interface::Generic::UI::Dialog;
@VxIF::Interface::Generic::UI::OptionsMenu::ISA = qw(VxIF::Interface::Generic::UI::Dialog);

sub new {
	my $pkg = shift;
	my $this = new VxIF::Interface::Generic::UI::Dialog();

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	my ($class_factory) = @_;
	my $empty_str = "";

	$this->set_class_factory($class_factory);

	$this->set_title($empty_str);
	$this->set_prompt($empty_str);
	$this->set_help_text($empty_str);
	$this->set_buttons([]);
	$this->set_display_selected(1);

	my $menu_id = "MODE_OPTIONS";
	my $menu = $class_factory->create_menu($menu_id);
	$this->set_menu($menu);

	my $ti_id = "MODE_TI_OPTION";
	my $text_input = $class_factory->create_text_input($ti_id);
	$this->set_text_input($text_input);
}

sub get_title {
	my $this = shift;
	my $title = $this->{title};

	return $title;
}

sub set_title {
	my $this = shift;
	my ($title) = @_;

	$this->{title} = $title;
}

sub get_prompt {
	my $this = shift;
	my $prompt = $this->{prompt};

	return $prompt;
}

sub set_prompt {
	my $this = shift;
	my ($prompt) = @_;

	$this->{prompt} = $prompt;
}

sub get_help_text {
	my $this = shift;
	my $help_text = $this->{help_text};

	return $help_text;
}

sub set_help_text {
	my $this = shift;
	my ($help_text) = @_;

	$this->{help_text} = $help_text;
}

sub get_display_selected {
	my $this = shift;
	my $display_selected = $this->{display_selected};

	return $display_selected;
}

sub set_display_selected {
	my $this = shift;
	my ($display_selected) = @_;

	$this->{display_selected} = $display_selected;
}

sub get_menu {
	my $this = shift;
	my $menu = $this->{menu};

	return $menu;
}

sub set_menu {
	my $this = shift;
	my ($menu) = @_;

	$this->{menu} = $menu;
	$this->add_item($menu);
}

sub get_buttons {
	my $this = shift;
	my $buttons = $this->{buttons};

	return $buttons;
}

sub set_buttons {
	my $this = shift;
	my ($buttons) = @_;

	$this->{buttons} = $buttons;
}

sub get_text_input {
	my $this = shift;
	my $text_input = $this->{text_input};

	return $text_input;
}

sub set_text_input {
	my $this = shift;
	my ($text_input) = @_;

	$this->{text_input} = $text_input;
}

sub add_button {
	my $this = shift;
	my ($button) = @_;
	my $buttons = $this->get_buttons();

	push(@$buttons, $button);

	$this->add_item($button);
}

sub compute_selected_display_text {
	my $this = shift;
	my $menu = $this->get_menu();
	my $disp_text = "";
	my $even_bother = $this->get_display_selected();

	if ($even_bother) {
		my $selected_text = "";
		my $selected_item = $menu->get_selected_item();
		if ($selected_item) {
			my $selected_ix = $menu->compute_item_index($selected_item);
			if ($selected_ix >= 0) {
				my $selected_opt = $selected_ix + 1;
				$selected_text = $selected_opt;
				$disp_text = "(${selected_text})";
			}
		}
	}

	return $disp_text;
}

sub display_buttons {
	my $this = shift;
	my $menu = $this->get_menu();
	my $items = $menu->get_menu_items();
	my $num_items = scalar(@$items);
	my $buttons = $this->get_buttons();
	my $fmt = "%s [1-%d%s]%s ";
	my $disp_text = $this->compute_selected_display_text();
	my $prompt = $this->get_prompt();

	my $opt_list = "";
	for my $button (@$buttons) {
		my $button_text = $button->get_text();
		$opt_list .= ", ${button_text}";
	}

	printf($fmt, $prompt, $num_items, $opt_list, $disp_text);
}

sub display_title {
	my $this = shift;
	my $title = $this->get_title();

	if ($title) {
		print("Backup Exec Agent For Linux and Unix Servers\n\n");
	}
}

sub initialize {
	my $this = shift;
	my $menu = $this->get_menu();

	$this->display_title();

	$menu->display_items();
}

sub dialog_proc {
	my $this = shift;
	my $text_input = $this->get_text_input();
	my $button_selected = undef;
	my $result_item = undef;

	$this->display_buttons();
	my $uinp = $text_input->get_line();

	if ($uinp =~ /\S/) {
		# something entered
		# first see if button selected
		my $buttons = $this->get_buttons();
		for my $button (@$buttons) {
			my $button_text = $button->get_text();
			if ($uinp eq $button_text) {
				$button_selected = $button;
				last;
			}
		}

		if ($button_selected) {
			$button_selected->on_click();
			$result_item = $button_selected;
			my $btn_id = $result_item->get_id();
			if ($btn_id =~ /ID_(CANCEL|OK)/) {
				$result_item->send_dialog_message($this, $btn_id);
			}
		} else {
			my $menu = $this->get_menu();
			my $items = $menu->get_menu_items();
			my $num_items = scalar(@$items);
			if ($uinp =~ /^(\d+)$/) {
				my $opt_cand = $1;
				if (1 <= $opt_cand && $opt_cand <= $num_items) {
					my $opt_ix = $opt_cand - 1;
					$result_item = $items->[$opt_ix];
					$menu->set_selected_item($result_item);
					$result_item->send_dialog_message($this, "ID_OK");
				}
			}
		}
	} else {
		# blank or empty entry.
		# return selected.
		my $menu = $this->get_menu();
		$result_item = $menu->get_selected_item();
		if ($result_item) {
			$result_item->send_dialog_message($this, "ID_OK");
		}
	}

	return $result_item;
}

1;

