package VxIF::Interface::Generic::UI::Menu;
use strict;
use VxIF::Interface::Generic::UI::Item;
use VxIF::Interface::Generic::UI::ItemContainer;
@VxIF::Interface::Generic::UI::Menu::ISA = qw(VxIF::Interface::Generic::UI::Item VxIF::Interface::Generic::UI::ItemContainer);

sub new {
	my $pkg = shift;
	my $this = {};

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	my ($item_id) = @_;
	my $menu_items = [];
	my $selected_item = undef;

	$this->VxIF::Interface::Generic::UI::Item::init($item_id);
	$this->VxIF::Interface::Generic::UI::ItemContainer::init();

	$this->set_menu_items($menu_items);
	$this->set_selected_item($selected_item);
	$this->set_indicate_selected(1);
}

sub get_indicate_selected {
	my $this = shift;
	my $indicate_selected = $this->{indicate_selected};

	return $indicate_selected;
}

sub set_indicate_selected {
	my $this = shift;
	my ($indicate_selected) = @_;

	$this->{indicate_selected} = $indicate_selected;
}

sub get_selected_item {
	my $this = shift;
	my $selected_item = $this->{selected_item};

	return $selected_item;
}

sub set_selected_item {
	my $this = shift;
	my ($selected_item) = @_;

	$this->{selected_item} = $selected_item;
}

sub get_menu_items {
	my $this = shift;
	my $menu_items = $this->{menu_items};

	return $menu_items;
}

sub set_menu_items {
	my $this = shift;
	my ($menu_items) = @_;

	$this->{menu_items} = $menu_items;
}

sub add_menu_item {
	my $this = shift;
	my ($menu_item) = @_;
	my $menu_items = $this->get_menu_items();

	push(@$menu_items, $menu_item);

	$this->add_item($menu_item);
}

sub compute_item_index {
	my $this = shift;
	my ($search_item) = @_;
	my $ix = -1;

	if ($search_item) {
		my $items = $this->get_menu_items();
		my $num_items = scalar(@$items);

		for (my $i = 0; $i < $num_items; $i++) {
			my $item = $items->[$i];
			if ($item == $search_item) {
				$ix = $i;
				last;
			}
		}
	}

	return $ix;
}

sub compute_selected_indicator {
	my $this = shift;
	my ($item) = @_;
	my $selected_item = $this->get_selected_item();
	my $even_bother = $this->get_indicate_selected();
	my $def_ind = "";

	if ($selected_item && $even_bother) {
		if ($item == $selected_item) {
			$def_ind = "*";
		} else {
			$def_ind = " ";
		}
	}

	return $def_ind;
}

sub display_items {
	my $this = shift;
	my $items = $this->get_menu_items();
	my $num_items = scalar(@$items);

	for (my $i = 0; $i < $num_items; $i++) {
		my $item = $items->[$i];
		my $def_ind = $this->compute_selected_indicator($item);
		my $text = $item->get_text();
		my $ix = $i + 1;

		printf("    %s%2d)    %s\n", $def_ind, $ix, $text);
	}
	print("\n");
}

1;

