package VxIF::Interface::Generic::UI::LabeledInfo;
use strict;
use VxIF::Interface::Generic::UI::Item;
@VxIF::Interface::Generic::UI::LabeledInfo::ISA = qw(VxIF::Interface::Generic::UI::Item);

sub new {
	my $pkg = shift;
	my ($item_id) = @_;
	my $this = new VxIF::Interface::Generic::UI::Item($item_id);

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	#
}

sub get_label_text {
	my $this = shift;
	my $label_text = $this->{label_text};

	return $label_text;
}

sub set_label_text {
	my $this = shift;
	my ($label_text) = @_;

	$this->{label_text} = $label_text;
}

sub get_info_text {
	my $this = shift;
	my $info_text = $this->{info_text};

	return $info_text;
}

sub set_info_text {
	my $this = shift;
	my ($info_text) = @_;

	$this->{info_text} = $info_text;
}

sub get_separator {
	my $this = shift;
	my $separator = $this->{separator};

	return $separator;
}

sub set_separator {
	my $this = shift;
	my ($separator) = @_;

	$this->{separator} = $separator;
}

sub put {
	my $this = shift;
	my $label_text = $this->get_label_text();
	my $separator = $this->get_separator();
	my $info_text = $this->get_info_text();

	print("${label_text}${separator}${info_text}\n\n");
}

1;

