package VxIF::Interface::Generic::UI::ItemContainer;
use strict;

sub new {
	my $pkg = shift;
	my $this = {};

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;

	my $items = {
		aref => [],
		href => {},
	};

	$this->set_items($items);
}

sub get_items {
	my $this = shift;
	my $items = $this->{items};

	return $items;
}

sub set_items {
	my $this = shift;
	my ($items) = @_;

	$this->{items} = $items;
}

sub add_item {
	my $this = shift;
	my ($item) = @_;
	my $id = $item->get_id();
	my $items = $this->get_items();

	if (exists($items->{href}{$id})) {
		die "Item with id ${id} already exists.\n";
	}

	$items->{href}{$id} = $item;
	push(@{$items->{aref}}, $item);
}

sub get_item {
	my $this = shift;
	my ($id) = @_;
	my $items = $this->get_items();
	my $ret_item = $items->{href}{$id};

	if (!$ret_item) {
		for my $item (@{$items->{aref}}) {
			#if (UNIVERSAL::isa($item, 'VxIF::Interface::Generic::UI::ItemContainer')) {
			if (UNIVERSAL::isa($item, __PACKAGE__)) {
				my $sub_item = $item->get_item($id);
				if ($sub_item) {
					$ret_item = $sub_item;
					last;
				}
			}
		}
	}

	return $ret_item;
}

1;

