package VxIF::Interface::Generic::UI::Item;
use strict;
use VxIF::Interface::Object;
@VxIF::Interface::Generic::UI::Item::ISA = qw(VxIF::Interface::Object);

sub new {
	my $pkg = shift;
	my $this = {};

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	my ($id) = @_;

	$this->VxIF::Interface::Object::init();

	if (!$id) {
		die "Invalid or nonexistent item id.\n";
	}

	$this->set_id($id);
}

sub get_id {
	my $this = shift;
	my $id = $this->{id};

	return $id;
}

sub set_id {
	my $this = shift;
	my ($id) = @_;

	$this->{id} = $id;
}

sub get_text {
	my $this = shift;
	my $text = $this->{text};

	return $text;
}

sub set_text {
	my $this = shift;
	my ($text) = @_;

	$this->{text} = $text;
}

sub get_data {
	my $this = shift;
	my $data = $this->{data};

	return $data;
}

sub set_data {
	my $this = shift;
	my ($data) = @_;

	$this->{data} = $data;
}

sub send_dialog_message {
	my $this = shift;
	my ($dialog, $msg_id) = @_;
	my $cf = $this->get_class_factory();
	my $msg = $cf->create_message($msg_id);

	$msg->set_sender($this);

	$dialog->enqueue($msg);
}

1;

