package VxIF::Interface::Generic::UI::Form;
use strict;
use VxIF::Interface::Generic::UI::Item;
use VxIF::Interface::Generic::UI::ItemContainer;
@VxIF::Interface::Generic::UI::Form::ISA = qw(VxIF::Interface::Generic::UI::Item VxIF::Interface::Generic::UI::ItemContainer);

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;
	my ($item_id) = @_;
	my $form_fields = [];
	my $selected_item = undef;

	$self->VxIF::Interface::Generic::UI::Item::init($item_id);
	$self->VxIF::Interface::Generic::UI::ItemContainer::init();

	$self->set_form_fields($form_fields);
}

sub get_form_fields {
	my $self = shift;
	my $form_fields = $self->{form_fields};

	return $form_fields;
}

sub set_form_fields {
	my $self = shift;
	my ($form_fields) = @_;

	$self->{form_fields} = $form_fields;
}

sub add_form_field {
	my $self = shift;
	my ($form_field) = @_;
	my $form_fields = $self->get_form_fields();

	push(@$form_fields, $form_field);

	$self->add_item($form_field);
}

sub fill_out {
	my $self = shift;
	my $fields = $self->get_form_fields();
	for my $field (@$fields) {
		my $key = $field->get_label();
		my $val_ref = $field->get_text_ref();
		my $val = "";
		if (ref($val_ref)) {
			$val = $$val_ref;
		}

		print("${key}: ($val)");
		my $new_val = <STDIN>;
		chomp $new_val;
		if ($new_val =~ /\S/) {
			if (ref($val_ref)) {
				$$val_ref = $new_val;
			}
		}
	}
}

sub from_ordered_set {
	my $self = shift;
	my ($ordered_set) = @_;
	my $ifmgr = $self->get_interface_manager();
	my $cf = $ifmgr->get_class_factory();
	my $form_id = $self->get_id();

	# set up stuff
	my $order_aref = $ordered_set->get_order();
	my $values_href = $ordered_set->get_values();
	my $num_values = scalar(@$order_aref);
	for (my $i = 0; $i < $num_values; $i++) {
		my $key = $order_aref->[$i];
		my $text_ref = $ordered_set->get_value_ref($key);
		my $ff_id = "${form_id}_FIELD_${key}";
		my $form_field = $cf->create_form_field($ff_id);

		$form_field->set_label($key);
		$form_field->set_text_ref($text_ref);
		$self->add_form_field($form_field);
	}
}

1;

