package VxIF::Interface::Generic::UI::Dialog;
use strict;
use VxIF::Interface::Object;
use VxIF::Interface::Generic::UI::ItemContainer;
@VxIF::Interface::Generic::UI::Dialog::ISA = qw(VxIF::Interface::Object VxIF::Interface::Generic::UI::ItemContainer);

sub new {
	my $pkg = shift;
	my $this = {};

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;

	$this->VxIF::Interface::Object::init();
	$this->VxIF::Interface::Generic::UI::ItemContainer::init();

	my $empty_queue = [];
	$this->set_message_queue($empty_queue);
}

sub get_done {
	my $this = shift;
	my $done = $this->{done};

	return $done;
}

sub set_done {
	my $this = shift;
	my ($done) = @_;

	$this->{done} = $done;
}

sub get_message_queue {
	my $this = shift;
	my $message_queue = $this->{message_queue};

	return $message_queue;
}

sub set_message_queue {
	my $this = shift;
	my ($message_queue) = @_;

	$this->{message_queue} = $message_queue;
}

sub initialize {
	my $this = shift;
	# nothing yet
}

sub enqueue {
	my $this = shift;
	my ($msg) = @_;
	my $queue = $this->get_message_queue();

	push(@$queue, $msg);
}

sub dequeue {
	my $this = shift;
	my $queue = $this->get_message_queue();
	my $msg = shift(@$queue);

	return $msg;
}

sub dialog_proc {
	my $this = shift;
	# nothing yet
	# override in derived class
}

sub process_message {
	my $this = shift;
	my ($message) = @_;
	my $msg_id = $message->get_id();

	return $msg_id;
}

sub message_loop {
	my $this = shift;
	my $eff_msg_id = undef;

	$this->set_done(0);

	while (!$this->get_done()) {
		my $msg = $this->dequeue();

		if ($msg) {
			# consume message
			$eff_msg_id = $this->process_message($msg);
			if ($eff_msg_id =~ /ID_(CANCEL|OK)/) {
				$this->set_done(1);
			}
		} else {
			# probably create messages
			# maybe generate idle message to do this
			$this->dialog_proc();
		}
	}

	return $eff_msg_id;
}

sub do_modal {
	my $this = shift;

	$this->initialize();

	my $result_id = $this->message_loop();

	return $result_id;
}

1;

