package VxIF::Interface::Generic::UI::Button;
use strict;
use VxIF::Interface::Generic::UI::Item;
@VxIF::Interface::Generic::UI::Button::ISA = qw(VxIF::Interface::Generic::UI::Item);

sub new {
	my $pkg = shift;
	my ($item_id) = @_;
	my $this = new VxIF::Interface::Generic::UI::Item($item_id);

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;

	$this->set_click_proc(undef);
}

sub get_click_proc {
	my $this = shift;
	my $click_proc = $this->{click_proc};

	return $click_proc;
}

sub set_click_proc {
	my $this = shift;
	my ($click_proc) = @_;

	$this->{click_proc} = $click_proc;
}

sub on_click {
	my $this = shift;
	my $click_proc = $this->get_click_proc();

	if ($click_proc) {
		$click_proc->();
	}
}

1;

