package VxIF::Interface::Generic::Task;
use strict;

use File::Basename;

use VxIF::Interface::Object;
@VxIF::Interface::Generic::Task::ISA = qw(VxIF::Interface::Object);

use VxIF::Installer;

# don't call this directly.
# use class factory create_task method.
sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;
	my ($installer_info) = @_;

	$self->VxIF::Interface::Object::init();

	$self->set_installer_info($installer_info);
}

sub get_installer_info {
	my $self = shift;
	my $installer_info = $self->{installer_info};

	return $installer_info;
}


sub set_installer_info {
	my $self = shift;
	my ($installer_info) = @_;

	$self->{installer_info} = $installer_info;
}

sub get_vxif_installer {
	my $this = shift;
	my $vxif_installer = $this->{vxif_installer};

	return $vxif_installer;
}


sub set_vxif_installer {
	my $this = shift;
	my ($vxif_installer) = @_;

	$this->{vxif_installer} = $vxif_installer;
}

# Basically just invokes constructor, passing information
# that pertains to the installation.
sub create_installer {
	my $self = shift;
	my $ifmgr = $self->get_interface_manager();
	# get installer configuration parameters
	my $installer_info = $self->get_installer_info();
	# retrieve installer creation parameters
	my $product      = $installer_info->get_product();
	my $upi          = $installer_info->get_upi();
	my $version      = $installer_info->get_version();
	my $program      = $installer_info->get_program();
	my $title        = $installer_info->get_title();
	my $supported_os = $installer_info->get_supported_os();

	# consult source code for details of construction
	my $installer = new Installer
		(
		 PRODUCT     => $product,
		 UPI         => $upi,
		 VERSION     => $version,
		 PROGRAM     => $program,
		 TITLE       => $title,
		 SUPPORTEDOS => $supported_os,
		 INTERFACE_MGR   => $ifmgr,
		 INTERFACE_TASK => $self,
		 @_,
		 );

	return $installer;
}

sub walk_installer_info {
	my $self = shift;
	my ($installer_info, $installer) = @_;
	my $upi = $installer_info->get_upi();
	my $supported_os = $installer_info->get_supported_os();

	for my $os (@$supported_os) {
		my $product_info = $installer_info->get_platform_product_info($os);
		my $prod_obj = $product_info->get_installer_object();

		$installer->add_product($upi, $os, $prod_obj);

		# recursively process any imported (nested) installers
		my $sub_instinfos = $product_info->get_sub_instinfos();
		for my $sub_fq_fnam (keys(%{$sub_instinfos})) {
			my $sub_instinfo = $sub_instinfos->{$sub_fq_fnam};
			$self->walk_installer_info($sub_instinfo, $installer);
		}
	}
}

sub do_task {
	my $self = shift;
	my ($task) = @_;

	eval {
		my $installer = $self->get_vxif_installer();

		if (!$installer) {
			# VxIF installer not already created.
			# Create it now.  Structure better soon. (DE 9-18-05)
			$installer = $self->create_installer();
		}

		# add platform/package objects to installer
		my $installer_info = $self->get_installer_info();
		$self->walk_installer_info($installer_info, $installer);

		# Run the install (installer will consult
		# TASK to drive the actual task selection).
		$installer->exec($task);
	};
	# convert any thrown error (possibly from a 'die' stmt)
	# to an error object (if necessary), or undef in none.
	my $error = $self->catch();

	return $error;
}

sub install {
	my $self = shift;
	my $task = 'install';
	my $err = $self->do_task($task);

	return $err;
}

sub uninstall {
	my $self = shift;
	my $task = 'uninstall';
	my $err = $self->do_task($task);

	return $err;
}

sub configure {
	my $self = shift;
	my $task = 'configure';
	my $err = $self->do_task($task);

	return $err;
}

sub upgrade {
	my $self = shift;
	my $task = 'upgrade';
	my $err = $self->do_task($task);

	return $err;
}

sub query {
	my $self = shift;
	my $task = 'query';
	my $err = $self->do_task($task);

	return $err;
}

sub precheck {
	my $self = shift;
	my $task = 'precheck';
	my $err = $self->do_task($task);

	return $err;
}

1;

