package VxIF::Interface::Generic::PlatformInfo;
use strict;

use VxIF::Interface::Object;
@VxIF::Interface::Generic::PlatformInfo::ISA = qw(VxIF::Interface::Object);

use constant SUPPORTED_OS => {
	AIX => 1,
	HPUX => 1,
	Linux => 1,
	SunOS => 1,
	OSF1 => 1,
	Darwin => 1,
};

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->VxIF::Interface::Object::init();

	$self->set_os_installers({});

	$self->setup_os_installers();
}

sub get_os_installers {
	my $self = shift;
	my $os_installers = $self->{os_installers};

	return $os_installers;
}

sub set_os_installers {
	my $self = shift;
	my ($os_installers) = @_;

	$self->{os_installers} = $os_installers;
}

sub setup_os_installers {
	my $self = shift;
	my $os_installers = $self->get_os_installers();
	my $supported_os = SUPPORTED_OS;
	my $valid_oss = [];

	# get an instance of each supported OS installer
	push(@$valid_oss, "NativePerl");
	push(@$valid_oss, keys(%$supported_os));

	for my $os_name (@$valid_oss) {
		my $os_pkg = "CPI${os_name}";
		my $os_installer = $os_pkg->new();

		# these should be done in platform installer constructors
		$os_installer->set_commands();
		$os_installer->initialize();

		# stick in
		$os_installers->{$os_name} = $os_installer;
	}
}

sub get_os_installer {
	my $self = shift;
	my ($os_name) = @_;
	my $os_installers = $self->get_os_installers();
	my $os_installer = $os_installers->{$os_name};

	return $os_installer;
}

sub os_supported {
	my $self = shift;
	my ($os_name) = @_;
	my $verdict = 0;

	if (defined(SUPPORTED_OS->{$os_name})) {
		$verdict = 1;
	}

	return $verdict;
}

1;

