package VxIF::Interface::Generic::PackageOps;
use strict;

use VxIF::Interface::Object;
@VxIF::Interface::Generic::PackageOps::ISA = qw(VxIF::Interface::Object);

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->VxIF::Interface::Object::init();
}

sub install_on_host {
	my $self = shift;
	my ($package_info, $host) = @_;
	my $ifmgr = $self->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $os_inst = $ctx->get_host_os_installer($host);
	my $logger = $ctx->get_logger();
	my $cfg = $ctx->get_config();
	my $error = undef;

	# still have to do this.
	$ctx->set_target_hostname($host);

	eval {
		my $pkgname = $package_info->get_section_name();
		my $product_info = $package_info->get_parent_product_info();
		my $pkgsinfo = $product_info->get_packages();
		my $rc = $os_inst->compute_package_status($ctx, $pkgname, $pkgsinfo);
		# should make 1 a constant
		if ($rc == 1) {
			# not installed (2 ==> installed, else ==> unknown error)
			my $msgl = Utils::_tr("Installing ${pkgname} on ${host}", 69, 1000, "${pkgname}", "${host}");
			$logger->info($msgl);
			$rc = $os_inst->install_package($ctx, $cfg, $pkgsinfo, $pkgname);
			if ($rc) {
				my $msgr = Utils::_tr("package ${pkgname} successfully installed", 69, 1001, "${pkgname}");
				$logger->info($msgr);
			} else {
				my $msgr = Utils::_tr("package ${pkgname} failed to install", 69, 1002, "${pkgname}");
				$self->throw(1, $msgr);
			}
		} elsif ($rc == 2) {
			my $version = $os_inst->get_instpkgvers($ctx, $pkgname, "", $pkgsinfo);
			my $msgl = Utils::_tr("package ${pkgname}, version ${version}, already installed on ${host}", 69, 1003, "${pkgname}", "${version}", "${host}");
			$logger->info($msgl);
		} else {
			my $msgl = Utils::_tr("cannot determine status of package ${pkgname} on ${host}", 69, 1004, "${pkgname}", "${host}");
			$self->throw(1, $msgl);
		}
	};
	$error = $self->catch();

	return $error;
}

sub uninstall_on_host {
	my $self = shift;
	my ($package_info, $host) = @_;
	my $ifmgr = $self->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $os_inst = $ctx->get_host_os_installer($host);
	my $logger = $ctx->get_logger();
	my $cfg = $ctx->get_config();
	my $error = undef;

	# still have to do this.
	$ctx->set_target_hostname($host);

	eval {
		my $pkgname = $package_info->get_section_name();
		my $product_info = $package_info->get_parent_product_info();
		my $pkgsinfo = $product_info->get_packages();
		my $rc = $os_inst->compute_package_status($ctx, $pkgname, $pkgsinfo);
		# should make 1 a constant
		if ($rc == 1) {
			# not installed (2 ==> installed, else ==> unknown error)
			#my $version = $os_inst->get_instpkgvers($ctx, $pkgname, "", $pkgsinfo);
			#my $msgl = Utils::_tr("package ${pkgname}, version ${version}, already installed on ${host}");
			my $msgl = Utils::_tr("package ${pkgname} not installed on ${host}", 69, 1005, "${pkgname}", "${host}");
			$logger->info($msgl);
		} elsif ($rc == 2) {
			my $msgl = Utils::_tr("Uninstalling ${pkgname} on ${host}", 69, 1006, "${pkgname}", "${host}");
			$logger->info($msgl);
			$rc = $os_inst->uninstall_package($ctx, $cfg, $pkgsinfo, $pkgname);
			if ($rc) {
				my $msgr = Utils::_tr("package ${pkgname} successfully uninstalled", 69, 1007, "${pkgname}");
				$logger->info($msgr);
			} else {
				my $msgr = Utils::_tr("package ${pkgname} failed to uninstall", 69, 1008, "${pkgname}");
				$self->throw(1, $msgr);
			}
		} else {
			my $msgl = Utils::_tr("cannot determine status of package ${pkgname} on ${host}", 69, 1004, "${pkgname}", "${host}");
			$self->throw(1, $msgl);
		}
	};
	$error = $self->catch();

	return $error;
}

1;

