package VxIF::Interface::Generic::PackageInfo;
use strict;

use VxIF::Interface::Object;
@VxIF::Interface::Generic::PackageInfo::ISA = qw(VxIF::Interface::Object);

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;
	my ($parent_product_info, $section_name) = @_;

	$self->VxIF::Interface::Object::init();

	$self->set_parent_product_info($parent_product_info);
	$self->set_section_name($section_name);
}

sub get_parent_product_info {
	my $this = shift;
	my $parent_product_info = $this->{parent_product_info};

	return $parent_product_info;
}

sub set_parent_product_info {
	my $this = shift;
	my ($parent_product_info) = @_;

	$this->{parent_product_info} = $parent_product_info;
}

sub get_source_product_info {
	my $self = shift;
	my $source_product_info = $self->{source_product_info};

	return $source_product_info;
}

sub set_source_product_info {
	my $self = shift;
	my ($source_product_info) = @_;

	$self->{source_product_info} = $source_product_info;
}

sub get_section_name {
	my $this = shift;
	my $section_name = $this->{section_name};

	return $section_name;
}

sub set_section_name {
	my $this = shift;
	my ($section_name) = @_;

	$this->{section_name} = $section_name;
}

sub get_name {
	my $self = shift;
	my $name = $self->{name};

	return $name;
}

sub set_name {
	my $self = shift;
	my ($name) = @_;

	$self->{name} = $name;
}

sub get_version {
	my $self = shift;
	my $version = $self->{version};

	return $version;
}

sub set_version {
	my $self = shift;
	my ($version) = @_;

	$self->{version} = $version;
}

sub get_description {
	my $self = shift;
	my $description = $self->{description};

	return $description;
}

sub set_description {
	my $self = shift;
	my ($description) = @_;

	$self->{description} = $description;
}

sub get_space {
	my $self = shift;
	my $space = $self->{space};

	return $space;
}

sub set_space {
	my $self = shift;
	my ($space) = @_;

	$self->{space} = $space;
}

sub get_compressed {
	my $self = shift;
	my $compressed = $self->{compressed};

	return $compressed;
}

sub set_compressed {
	my $self = shift;
	my ($compressed) = @_;

	$self->{compressed} = $compressed;
}

sub get_compressed_file {
	my $self = shift;
	my $compressed_file = $self->{compressed_file};

	return $compressed_file;
}

sub set_compressed_file {
	my $self = shift;
	my ($compressed_file) = @_;

	$self->{compressed_file} = $compressed_file;
}

sub get_extraction_path {
	my $self = shift;
	my $extraction_path = $self->{extraction_path};

	return $extraction_path;
}

sub set_extraction_path {
	my $self = shift;
	my ($extraction_path) = @_;

	$self->{extraction_path} = $extraction_path;
}

sub get_alt_loc {
	my $self = shift;
	my $alt_loc = $self->{alt_loc};

	return $alt_loc;
}

sub set_alt_loc {
	my $self = shift;
	my ($alt_loc) = @_;

	$self->{alt_loc} = $alt_loc;
}

sub get_media_location {
	my $self = shift;
	my $media_location = $self->{media_location};

	return $media_location;
}

sub set_media_location {
	my $self = shift;
	my ($media_location) = @_;

	$self->{media_location} = $media_location;
}

sub get_responsefile_content {
	my $this = shift;
	my $responsefile_content = $this->{responsefile_content};

	return $responsefile_content;
}

sub set_responsefile_content {
	my $this = shift;
	my ($responsefile_content) = @_;

	$this->{responsefile_content} = $responsefile_content;
}

# AIX

sub get_image {
	my $this = shift;
	my $image = $this->{image};

	return $image;
}


sub set_image {
	my $this = shift;
	my ($image) = @_;

	$this->{image} = $image;
}

sub get_fileset {
	my $this = shift;
	my $fileset = $this->{fileset};

	return $fileset;
}


sub set_fileset {
	my $this = shift;
	my ($fileset) = @_;

	$this->{fileset} = $fileset;
}

# HPUX

sub get_depot {
	my $this = shift;
	my $depot = $this->{depot};

	return $depot;
}

sub set_depot {
	my $this = shift;
	my ($depot) = @_;

	$this->{depot} = $depot;
}

# Linux

sub get_rpm {
	my $this = shift;
	my $rpm = $this->{rpm};

	return $rpm;
}

sub set_rpm {
	my $this = shift;
	my ($rpm) = @_;

	$this->{rpm} = $rpm;
}

# OSF1

sub get_subset {
	my $this = shift;
	my $subset = $this->{subset};

	return $subset;
}

sub set_subset {
	my $this = shift;
	my ($subset) = @_;

	$this->{subset} = $subset;
}

# neutral

sub get_requires_reboot {
	my $this = shift;
	my $requires_reboot = $this->{requires_reboot};

	return $requires_reboot;
}

sub set_requires_reboot {
	my $this = shift;
	my ($requires_reboot) = @_;

	$this->{requires_reboot} = $requires_reboot;
}

sub from_href {
	my $self = shift;
	my ($href) = @_;
	for my $key (keys(%$href)) {
		my $val = $href->{$key};
		if ($key eq 'NAME') {
			$self->set_name($val);
		} elsif ($key eq 'VERSION') {
			$self->set_version($val);
		} elsif ($key eq 'OPTIONAL') {
			$self->set_description($val);
		} elsif ($key eq 'SPACE') {
			$self->set_space($val);
		} elsif ($key eq 'COMPRESSED') {
			$self->set_compressed($val);
		} elsif ($key eq 'COMPRESSEDFILE') {
			$self->set_compressed_file($val);
		} elsif ($key eq 'EXTRACTION_PATH') {
			$self->set_extraction_path($val);
		} elsif ($key eq 'PKG_ALT_LOC') {
			$self->set_alt_loc($val);
		} elsif ($key eq 'SOURCE_PRODUCT_INFO') {
			$self->set_source_product_info($val);
		} elsif ($key eq 'PACKAGE_LOCATION') {
			$self->set_media_location($val);
		} elsif ($key eq 'RESPONSEFILE') {
			$self->set_responsefile_content($val);
		} elsif ($key eq 'IMAGE') {
			# AIX
			$self->set_image($val);
		} elsif ($key eq 'FILESET') {
			# AIX
			$self->set_fileset($val);
		} elsif ($key eq 'DEPOT') {
			# HPUX
			$self->set_depot($val);
		} elsif ($key eq 'RPM') {
			# Linux
			$self->set_rpm($val);
		} elsif ($key eq 'SUBSET') {
			# OSF1
			$self->set_subset($val);
		} elsif ($key eq 'REQREBOOT') {
			# OSF1
			$self->set_requires_reboot($val);
		} else {
			#
			# TBD
			#
			# DEPS RELOC REQREBOOT PATCHES
			#
			# FILESET (AIX)
			#
			# and, perhaps, others.
			#
			$self->{$key} = $val;
		}
	}
}

sub search_by_accessor {
	my $self = shift;
	my ($accessor, $section_name) = @_;
	my $search_package_info = $self;
	my $result = $self->$accessor();

	while (!$result) {
		my $search_product_info = $search_package_info->get_source_product_info();
		if (!$search_product_info) {
			last;
		}
		$search_package_info = $search_product_info->get_package_info($section_name);
		if (!$search_package_info) {
			last;
		}
		$result = $search_package_info->$accessor();
	}

	return $result;
}

sub search_source_product_info {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_source_product_info;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_name {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_name;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_version {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_version;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_description {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_description;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_space {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_space;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_compressed {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_compressed;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_compressed_file {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_compressed_file;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_extraction_path {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_extraction_path;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_alt_loc {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_alt_loc;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_media_location {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_media_location;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_responsefile_content {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_responsefile_content;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_image {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_image;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_fileset {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_fileset;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_depot {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_depot;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_rpm {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_rpm;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_subset {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_subset;

	$self->search_by_accessor($accessor, $section_name);
}

sub search_requires_reboot {
	my $self = shift;
	my ($section_name) = @_;
	my $accessor = \&get_requires_reboot;

	$self->search_by_accessor($accessor, $section_name);
}

sub list {
	my $self = shift;
	my ($indent) = @_;
	my $name = $self->search_name();
	my $version = $self->search_version();
	my $description = $self->search_description();
	my $space = $self->search_space();
	my $space_str = '[' . join(" ", @$space) . ']';
	my $compressed = $self->search_compressed();
	my $compressed_file = $self->search_compressed_file();
	my $extraction_path = $self->search_extraction_path() || "None";
	my $alternate_location = $self->search_alt_loc() || "None";
	my $media_location = $self->search_media_location();
	my $responsefile_content = $self->search_responsefile_content();
	my $eff_indent = defined($indent) ? $indent : 0;
	my $ind = " " x $eff_indent;

	print("${ind}Name: ${name}\n");
	print("${ind}Version: ${version}\n");
	print("${ind}Description: ${description}\n");
 	print("${ind}Space: ${space_str}\n");
	print("${ind}Compressed: ${compressed}\n");
	print("${ind}Compressed File: ${compressed_file}\n");
	print("${ind}Extraction Path: ${extraction_path}\n");
	print("${ind}Alternate Location: ${alternate_location}\n");
	print("${ind}Media Location: ${media_location}\n");

	if ($responsefile_content) {
		print("${ind}Response File Content:\n");
		my @lines = split(/\n/, $responsefile_content);
		for my $line (@lines) {
			chomp $line;
			printf("${ind}  %s\n", $line);
		}
	}
}

1;

