package VxIF::Interface::Generic::Logger;
use strict;
use VxIF::Interface::Object;
@VxIF::Interface::Generic::Logger::ISA = qw(VxIF::Interface::Object);

sub new {
	my $pkg = shift;
	my $this = {};

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;

	$this->VxIF::Interface::Object::init();

	my $level_map = {
		error => 1000,
		warning => 900,
		info => 800,
	};

	$this->set_level_map($level_map);
	$this->set_level($level_map->{error});
}

sub get_level_map {
	my $this = shift;
	my $level_map = $this->{level_map};

	return $level_map;
}

sub set_level_map {
	my $this = shift;
	my ($level_map) = @_;

	$this->{level_map} = $level_map;
}

sub get_level {
	my $this = shift;
	my $level = $this->{level};

	return $level;
}

sub set_level {
	my $this = shift;
	my ($level) = @_;

	$this->{level} = $level;
}

sub get_logdir {
	my $this = shift;
	my $logdir = $this->{logdir};

	return $logdir;
}

sub set_logdir {
	my $this = shift;
	my ($logdir) = @_;

	$this->{logdir} = $logdir;
}

sub get_logfile {
	my $this = shift;
	my $logfile = $this->{logfile};

	return $logfile;
}

sub set_logfile {
	my $this = shift;
	my ($logfile) = @_;

	$this->{logfile} = $logfile;
}

sub log ($;$) {
	my $this = shift;
	my ($msg, $level_str) = @_;
	my $level_map = $this->get_level_map();
	my $ifmgr = $this->get_interface_manager();
	my $localizer = $ifmgr->get_localizer();

	if (!$level_str) {
		$level_str = "error";
	}

	my $req_level = $level_map->{$level_str} || $level_map->{error};
	my $curr_level = $this->get_level();

	if ($req_level >= $curr_level) {
		my $logfile = $this->get_logfile();
		my $rc = open(LOGFILE, ">> $logfile");
		if ($rc) {
			my $prefix = ucfirst($level_str).": ";
			my $lprefix = $localizer->translate($prefix);
			my $rec = "${lprefix}${msg}";
			print(LOGFILE "${rec}\n");
			close(LOGFILE);
		} else {
			die "Cannot open log file ${logfile}.\n";
		}
	}
}

1;

