package VxIF::Interface::Generic::Error;
use strict;
use VxIF::Interface::Object;
@VxIF::Interface::Generic::Error::ISA = qw(VxIF::Interface::Object);

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->VxIF::Interface::Object::init();

	$self->set_rc(0);
	$self->set_msg("no-pro-blee-mo");
	$self->set_next(undef);
}

sub get_rc {
	my $self = shift;
	my $rc = $self->{rc};

	return $rc;
}

sub set_rc {
	my $self = shift;
	my ($rc) = @_;

	$self->{rc} = $rc;
}

sub get_msg {
	my $self = shift;
	my $msg = $self->{msg};

	return $msg;
}

sub set_msg {
	my $self = shift;
	my ($msg) = @_;

	$self->{msg} = $msg;
}

sub get_next {
	my $self = shift;
	my $next = $self->{next};

	return $next;
}

sub set_next {
	my $self = shift;
	my ($next) = @_;

	$self->{next} = $next;
}

sub put {
	my $self = shift;
	my $rc = $self->get_rc();
	my $msg = $self->get_msg();
	my $cf = $self->get_class_factory();
	my $li = $cf->create_labeled_info("LI_RESULT");
	my $label_text = "";
	my $separator = "";
	my $info_text = $msg;

	if ($rc) {
		$label_text = "${rc}";
		$separator = ": ";
	}

	$li->set_label_text($label_text);
	$li->set_separator($separator);
	$li->set_info_text($info_text);

	$li->put();
}

1;

