package VxIF::Interface::Generic::ConfigInfo;
use strict;

use File::Basename;
use File::Spec;

use VxIF::Interface::Object;
@VxIF::Interface::Generic::ConfigInfo::ISA = qw(VxIF::Interface::Object);

use VxIF::Interface::Utils::Config;

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->VxIF::Interface::Object::init();

	$self->set_cache({});
}

sub get_fq_fnam {
	my $this = shift;
	my $fq_fnam = $this->{fq_fnam};

	return $fq_fnam;
}

sub set_fq_fnam {
	my $this = shift;
	my ($fq_fnam) = @_;

	$this->{fq_fnam} = $fq_fnam;
}

sub get_cache {
	my $this = shift;
	my $cache = $this->{cache};

	return $cache;
}

sub set_cache {
	my $this = shift;
	my ($cache) = @_;

	$this->{cache} = $cache;
}

sub absolute_fnam {
	my $self = shift;
	my ($fnam, $rel_2_dir) = @_;
	my $fq_fnam;

	if (File::Spec->file_name_is_absolute($fnam)) {
		$fq_fnam = $fnam;
	} else {
		if ($rel_2_dir) {
			$fq_fnam = "${rel_2_dir}/${fnam}";
		} else {
			$fq_fnam = File::Spec::Unix->rel2abs($fnam);
		}
	}

	return $fq_fnam;
}

sub obtain_config {
	my $self = shift;
	my ($config_fnam, $rel_2_dir) = @_;
	my $cache = $self->get_cache();
	# use absolute file name.  compute it just before reading.
	my $fq_config_fnam = $self->absolute_fnam($config_fnam, $rel_2_dir);
	my $ret_config = undef;

	if (defined($cache) && exists($cache->{$fq_config_fnam})) {
		$ret_config = $cache->{$fq_config_fnam};
	} else {
		# load the config file
		my $config = new VxIF::Interface::Utils::Config();
		my $rc = $config->from_file($fq_config_fnam);
		if (!$rc) {
			my $class_factory = $self->get_class_factory();
			my $localizer = $class_factory->create_localizer();
			my $msg = $localizer->translate("Cannot read configuration file ${config_fnam}");
			die "${msg}\n";
		}

		# still alive.  must be valid.  use it.
		$ret_config = $config;

		if (!defined($cache)) {
			$cache = {};
		}

		# stick into cache
		$cache->{$fq_config_fnam} = $ret_config;
	}

	$self->set_fq_fnam($fq_config_fnam);

	return $ret_config;
}

1;

