package VxIF::Interface::Classic::UI::Progress;
use strict;
use VxIF::Interface::Generic::UI::Item;
@VxIF::Interface::Classic::UI::Progress::ISA = qw(VxIF::Interface::Generic::UI::Progress);

sub new {
	my $pkg = shift;
	my ($item_id, $class_factory) = @_;
	my $this = new VxIF::Interface::Generic::UI::Progress($item_id, $class_factory);

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	#
}

sub put {
	my $this = shift;
	my $li = $this->get_labeled_info();
	my $label_text = $this->get_label_text();
	my $separator = $li->get_separator();
	my $info_text = $this->get_info_text();
	my $min = $this->get_min_value();
	my $cur = $this->get_curr_value();
	my $max = $this->get_max_value();
	my $ifmgr = $this->get_interface_manager();
	my $logger = $ifmgr->get_logger();
	my $logmsg = "Progress(${min} <= ${cur} <= ${max}) ==> ";

	$logmsg .= "${label_text}${separator}${info_text}";

	$logger->log($logmsg, "info");
}

1;

