package VxIF::Interface::Classic::UI::OptionsMenu;
use strict;
use VxIF::Interface::Generic::UI::OptionsMenu;
@VxIF::Interface::Classic::UI::OptionsMenu::ISA = qw(VxIF::Interface::Generic::UI::OptionsMenu);

sub new {
	my $pkg = shift;
	my $this = {};

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	my ($class_factory) = @_;

	$this->VxIF::Interface::Generic::UI::OptionsMenu::init($class_factory);
}

sub display_title {
	my $this = shift;
	my $title = $this->get_title();

	if ($title) {
		Utils::vxif_title($title);
	}

}

sub display_tooltips {
	my $this = shift;
	my $menu = $this->get_menu();
	my $menu_items = $menu->get_menu_items();
	my $num_menu_items = scalar(@$menu_items);
	for (my $ix = 0; $ix < $num_menu_items; $ix++) {
		my $mi = $menu_items->[$ix];
		my $tt_text = $mi->get_tooltip_text();
		if ($tt_text) {
			my $mi_text = $mi->get_text();
			my $cf = $this->get_class_factory();
			my $li_id = "LI_${ix}";
			my $li = $cf->create_labeled_info($li_id);
			$li->set_label_text($mi_text);
			$li->set_separator(": ");
			$li->set_info_text($tt_text);

			$li->put();
		}
	}
}

sub initialize {
	my $this = shift;
	my $title = $this->get_title();

	$this->display_title();

	$this->display_tooltips();
}

sub do_modal {
	my $this = shift;
	my $question = $this->get_prompt();
	my $help_text = $this->get_help_text();
	my $menu = $this->get_menu();
	my $menu_items = $menu->get_menu_items();
	my $buttons = $this->get_buttons();
	my $back_key_handler = undef;
	my $quit_key_handler = undef;
	my $choices = [];
	my $ret_mode = undef;
	my $selected_opt = "";
	my $selected_item = $menu->get_selected_item();

	$this->initialize();

	my $num_menu_items = scalar(@$menu_items);
	for (my $ix = 0; $ix < $num_menu_items; $ix++) {
		my $mi = $menu_items->[$ix];
		my $text = $mi->get_text();
		push(@$choices, $text);
		if ($selected_item && $mi == $selected_item) {
			my $opt = $ix + 1;
			$selected_opt = "${opt}";
		}
	}

	for my $btn (@$buttons) {
		my $text = $btn->get_text();
		if ($text eq 'q') {
			$quit_key_handler = $btn->get_click_proc();
		} elsif ($text eq 'b') {
			$back_key_handler = $btn->get_click_proc();
		}
	}

	my $opt =
		Utils::vxif_menu
		(
		 $question,
		 $choices,
		 $selected_opt,
		 $help_text,
		 $back_key_handler,
		 $quit_key_handler,
		 );

	if ($opt) {
		my $ix = $opt - 1;
		my $mi = $menu_items->[$ix];
		$menu->set_selected_item($mi);
		$ret_mode = "ID_OK";
	} else {
		$ret_mode = "ID_CANCEL";
	}

	return $ret_mode;
}

1;

