package VxIF::Interface::Classic::UI::Form;
use strict;
use VxIF::Interface::Generic::UI::Form;
@VxIF::Interface::Classic::UI::Form::ISA = qw(VxIF::Interface::Generic::UI::Form);

sub new {
	my $pkg = shift;
	my $this = {};

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	my ($class_factory) = @_;

	$this->VxIF::Interface::Generic::UI::Form::init($class_factory);
}

sub fill_out {
	my $self = shift;
	my $fields = $self->get_form_fields();
	for my $field (@$fields) {
		my $key = $field->get_label();
		my $val_ref = $field->get_text_ref();
		my $val = "";
		if (ref($val_ref)) {
			$val = $$val_ref;
		}

		my $msg = Utils::_tr($key);
		my $new_val = Utils::vxif_ask($msg, $val);

		if ($new_val =~ /\S/) {
			if (ref($val_ref)) {
				$$val_ref = $new_val;
			}
		}
	}
}

1;

