package VxIF::Interface::Classic::Modes;
use strict;
use VxIF::Interface::Generic::Modes;
@VxIF::Interface::Classic::Modes::ISA = qw(VxIF::Interface::Generic::Modes);

sub new {
	my $pkg = shift;
	my $this = new VxIF::Interface::Generic::Modes();

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	#
}

sub select_mode {
	my $this = shift;
	my ($modes, $modes_ordering) = @_;
	my $choices = [];
	my $choicemap = [];
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	my $question = Utils::_tr("Select a product installation mode:", 53, 1000);
	my $quit_key_handler = sub {
		my $installer = $ctx->get_root_installer();
		$installer->cleanup($ctx);
	};

	# "brand new" UI stuff

	my $ret_mode = undef;

	my $cf = $this->get_class_factory();
	my $om = $cf->create_options_menu();
	my $m = $om->get_menu();

	$om->set_title($$ctx{INSTALLERTITLE});

	my $num_modes = scalar(@$modes_ordering);
	for (my $ix = 0; $ix < $num_modes; $ix++) {
		my $mode = $modes_ordering->[$ix];
		my $mode_name = $$modes{$mode}{NAME};
		my $mode_dscr = $$modes{$mode}{DESCRIPTION};
		my $mi_id = "MI_${ix}";
		my $mi = $cf->create_menu_item($mi_id);

		$mi->set_text($mode_name);
		$mi->set_data($ix);
		$mi->set_tooltip_text($mode_dscr);

		$m->add_menu_item($mi);
	}

	my $quit_btn_id = "BTN_ID_QUIT";
	my $quit_button = $cf->create_button($quit_btn_id);
	$quit_button->set_text('q'); # use %COMM{QUIT} ???
	$om->add_button($quit_button);

	$om->set_prompt($question);

	my $first_menu_item = $m->get_item("MI_0");
	$m->set_selected_item($first_menu_item);

	my $quit_handler = sub {
		$quit_button->send_dialog_message($om, "ID_CANCEL");
		$quit_key_handler->();
	};
	$quit_button->set_click_proc($quit_handler);

	my $result_id = $om->do_modal();

	if ($result_id && $result_id eq "ID_OK") {
		my $result_item = $m->get_selected_item();
		my $result_ix = $result_item->get_data();
		my $result_choice = $modes_ordering->[$result_ix];
		$ret_mode = $result_choice;
	}

	return $ret_mode;
}

1;

