package VxIF::Interface::Classic::Logger;
use strict;

use FindBin;
use File::Basename;

use VxIF::Interface::Object;
use VxIF::Logger;
@VxIF::Interface::Classic::Logger::ISA = qw(VxIF::Interface::Object Logger);

sub new {
	my $pkg = shift;
	my $self = new Logger;

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->VxIF::Interface::Object::init();
	$self->{LOGLEVEL} = Logger::LEVEL_INFO;

	# Use base name of main perl file,
	# but strip off trailing '.pl'.
	my $app = basename($0);
	$app =~ s/\.pl$//;
	$self->{LOGAPPLICATION} = $app;

	# By default, set logger to main perl file,
	# with '.pl' replaced with '.log'.
	# In any case, make *sure* the log file ends
	# with '.log'.
	my $base_logfile = basename($0);
	$base_logfile =~ s/\.pl$/.log/;
	if ($base_logfile !~ /\.log$/) {
		$base_logfile .= ".log";
	}
	my $logdir = $FindBin::Bin;
	my $logfile = "${logdir}/${base_logfile}";
	$self->attach($logfile);
}

sub attach {
	my $self = shift;
	my ($log_fnam) = @_;

	$self->{LOGFILE} = $log_fnam;
}

sub reset {
	my $self = shift;
	my ($init_msg) = @_;
	my $log_fnam = $self->{LOGFILE};
	if (!defined($init_msg)) {
		$init_msg = "Starting ".$self->{LOGAPPLICATION};
	}

	$self->{LOGAPPEND} = 0;
	$self->info($init_msg);
}

1;

