package VxIF::Interface::Classic::Events;
use strict;
use VxIF::Interface::Generic::Events;
@VxIF::Interface::Classic::Events::ISA = qw(VxIF::Interface::Generic::Events);

use VxIF::Utils;

sub new {
	my $pkg = shift;
	my $this = new VxIF::Interface::Generic::Events();

	bless($this, $pkg);

	$this->init(@_);

	return $this;
}

sub init {
	my $this = shift;
	#
}

# add product

sub os_not_supported {
	my $this = shift;
	my ($os) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_status(Utils::_tr("${os} is not supported.", 50, 1000, "${os}"));
}

sub missing_upi {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_status(Utils::_tr("Unable to add product. UPI is null.", 50, 1001));
}

sub missing_os {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_status(Utils::_tr("Unable to add product. OS is null.", 50, 1002));
}

sub missing_product {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_status(Utils::_tr("Unable to add product. Product reference is null.", 50, 1003))
}

# product check

sub missing_products {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_status(Utils::_tr("No products to install!\n", 50, 1004));
}

# system state

sub print_usage_brief {
	my $this = shift;
	my ($usage_str) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_status($usage_str);
}

sub print_usage_details {
	my $this = shift;
	my ($usage_str) = @_;

	Utils::vxif_p(Utils::_tr($usage_str));
}

sub interrupt_received {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_and_log_status("Interrupt Received--installation terminated", "error");
}

sub announce_cleanup {
	my $this = shift;
	my ($title) = @_;

	Utils::vxif_title($title);
}

sub inform_response_file {
	my $this = shift;
	my ($responsefile, $indent_str) = @_;
	#
        #Changed to remove the word installation as this is also used for uninstalls. jpk - 01 Mar 06
	#Utils::vxif_pl(Utils::_tr("The installation response file is saved at:\n"));
        Utils::vxif_pl(Utils::_tr("The response file is saved at:\n", 50, 1005));
	Utils::vxif_pl("${indent_str}${responsefile}\n");
}

sub inform_log_file {
	my $this = shift;
	my ($program, $logfile, $indent_str) = @_;

	Utils::vxif_pl(Utils::_tr("The ${program} log is saved at:\n", 50, 1006, "${program}"));
	Utils::vxif_pl("${indent_str}${logfile}\n");
}

sub have_platform_modes {
	my $this = shift;
	#
}

sub pre_target_systems {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_title($$ctx{INSTALLERTITLE});
}

# system names

sub input_system_names {
	my $this = shift;
	my ($task, $trg_upi, $default_trg) = @_;
	my $tsl = Utils::vxif_ask(Utils::_tr("Enter the system names separated by spaces on which to ${task} ${trg_upi}:", 50, 1007, "${task}", "${trg_upi}"),$default_trg);

	return $tsl;
}

sub missing_hostnames {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_and_log_status("No system to install!", "error");
}

sub invalid_hostname {
	my $this = shift;
	my ($host) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_and_log_status("System, ${host}, is not a valid system name.", "error");
}

sub duplicate_hostname {
	my $this = shift;
	my ($host) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_and_log_status("System, ${host}, is entered more than once.", "warning");
}

# note: this should go away
sub localhost_invalid {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_and_log_status("System, 'localhost', cannot be used as a system name.", "warning");
}

sub hostname_invalid_syntax {
	my $this = shift;
	my ($host) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_and_log_status("System, ${host}, must begin with an alphabetic character", "error");
}

sub post_system_names {
	my $this = shift;

	Utils::vxif_pl();
}

# ssh/scp

sub cannot_find_ssh {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();
	my $ctx = $ifmgr->get_vxif_context();

	$status_bar->display_and_log_status("ssh not found on $$ctx{LOCAL}{HOST}", "error");
}

sub cannot_find_scp {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();
	my $ctx = $ifmgr->get_vxif_context();

	$status_bar->display_and_log_status("scp not found on $$ctx{LOCAL}{HOST}", "error");
}

sub ssh_scp_info {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_bpl(Utils::_tr("$$ctx{PROGRAM} requires that ssh commands used between systems execute without prompting for passwords or confirmations.  If $$ctx{PROGRAM} hangs following this prompt, it is because ssh is prompting for a password or confirmation. Stop $$ctx{PROGRAM} and run it again with the ssh commands configured without prompting or without using the -usessh option.\n", 50, 1008, "$$ctx{PROGRAM}", "$$ctx{PROGRAM}", "$$ctx{PROGRAM}"));
}

sub pre_check_syscomm {
	my $this = shift;

	Utils::vxif_bpl(Utils::_tr("Checking system communication:\n", 50, 1009));
}

sub test_rsh {
	my $this = shift;
	my ($rsh_cmd, $trg_host) = @_;
	my $msgl = Utils::_tr("Attempting ${rsh_cmd} with ${trg_host}", 50, 1010, "${rsh_cmd}", "${trg_host}");

	Utils::vxif_pbl($msgl);
}

sub rsh_test_fail {
	my $this = shift;
	my ($rsh_cmd, $trg_host) = @_;
	my $msgl = Utils::_tr("Attempting ${rsh_cmd} with ${trg_host}", 50, 1010, "${rsh_cmd}", "${trg_host}");
	my $msgr = Utils::_tr("Cannot ${rsh_cmd} to ${trg_host}", 50, 1011, "${rsh_cmd}", "${trg_host}");

	Utils::vxif_pbr($msgl, $msgr); 
}

sub rsh_test_pass {
	my $this = shift;
	my ($rsh_cmd, $trg_host) = @_;
	#
	my $msgl = Utils::_tr("Attempting ${rsh_cmd} with ${trg_host}", 50, 1010, "${rsh_cmd}", "${trg_host}");
	my $msgr = Utils::_tr("${rsh_cmd} successful", 50, 1012, "${rsh_cmd}");
	Utils::vxif_pbr($msgl, $msgr);
}

sub try_create_target_logdir {
	my $this = shift;
	my ($trg_host) = @_;
	my $msgl = Utils::_tr("Creating log directory on ${trg_host}", 50, 1013, "${trg_host}");

	Utils::vxif_pbl($msgl);
}

sub create_target_logdir_fail {
	my $this = shift;
	my ($trg_host) = @_;
	my $msgl = Utils::_tr("Creating log directory on ${trg_host}", 50, 1013, "${trg_host}");
	my $msgr = Utils::_tr("Cannot create directory", 50, 1014);
	Utils::vxif_pbr($msgl, $msgr); 
}

sub create_target_logdir_pass {
	my $this = shift;
	my ($trg_host) = @_;
	my $msgl = Utils::_tr("Creating log directory on ${trg_host}", 50, 1013, "${trg_host}");
	my $msgr = Utils::_tr("Done", 50, 1015);

	Utils::vxif_pbr($msgl, $msgr); 
}

sub test_rcp {
	my $this = shift;
	my ($rcp_cmd, $trg_host) = @_;
	my $msgl = Utils::_tr("Attempting ${rcp_cmd} with ${trg_host}", 50, 1010, "${rcp_cmd}", "${trg_host}");

	Utils::vxif_pbl($msgl);
}

sub rcp_test_fail1 {
	my $this = shift;
	my ($rcp_cmd, $trg_host) = @_;
	my $msgl = Utils::_tr("Attempting ${rcp_cmd} with ${trg_host}", 50, 1010, "${rcp_cmd}", "${trg_host}");
	my $msgr = Utils::_tr("Cannot ${rcp_cmd} to ${trg_host}", 50, 1011, "${rcp_cmd}", "${trg_host}");

	Utils::vxif_pbr($msgl, $msgr); 
}

sub rcp_test_fail2 {
	my $this = shift;
	my ($rcp_cmd, $trg_host) = @_;
	my $msgl = Utils::_tr("Attempting ${rcp_cmd} with ${trg_host}", 50, 1010, "${rcp_cmd}", "${trg_host}");
	my $msgr = Utils::_tr("${rcp_cmd} to ${trg_host} failed", 50, 1016, "${rcp_cmd}", "${trg_host}");

	Utils::vxif_pbr($msgl, $msgr); 
}

sub rcp_test_pass {
	my $this = shift;
	my ($rcp_cmd, $trg_host) = @_;
	my $msgl = Utils::_tr("Attempting ${rcp_cmd} with ${trg_host}", 50, 1010, "${rcp_cmd}", "${trg_host}");
	my $msgr = Utils::_tr("${rcp_cmd} successful", 50, 1012, "${rcp_cmd}");

	Utils::vxif_pbr($msgl, $msgr);
}

sub check_os_version {
	my $this = shift;
	my ($host) = @_;
	my $msgl = Utils::_tr("Checking OS version on ${host}", 50, 1017, "${host}");
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $host_os_info = $ctx->get_host_os_info($host);
	my $os_name = $host_os_info->get_name();
	my $os_version = $host_os_info->get_version();

	Utils::vxif_pbl($msgl);
	Utils::vxif_pbr($msgl, "${os_name} ${os_version}");
}

sub test_system_support {
	my $this = shift;
	my ($host) = @_;
	my $msgl = Utils::_tr("Checking system support for ${host}", 50, 1018, "${host}");

	Utils::vxif_pbl($msgl);
}

sub system_support_pass {
	my $this = shift;
	my ($host) = @_;
	my $msgl = Utils::_tr("Checking system support for ${host}", 50, 1018, "${host}");
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $host_os_info = $ctx->get_host_os_info($host);
	my $osname = $host_os_info->get_name();
	my $osver = $host_os_info->get_version();
	my $trg_upi = $ctx->get_target_upi();
	#if user specify the UPI_LONG in beinst.conf we will use it instead of UPI for display
    #for Backup Exec for Linux Server, the UPI is BE and the UPI_LONG is "Backup Exec" which is more meaningful
    my $trg_upi_long = $ctx->get_target_upi_long();
    if ($trg_upi_long){
      $trg_upi = $trg_upi_long;
    }
	my $msgr = Utils::_tr("${osname} ${osver} supported by ${trg_upi}", 50, 1019, "${osname}", "${osver}", "${trg_upi}");

	Utils::vxif_pbr($msgl, $msgr);
}

sub system_support_fail {
	my $this = shift;
	my ($host) = @_;
	my $msgl = Utils::_tr("Checking system support for ${host}", 50, 1018, "${host}");
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $host_os_info = $ctx->get_host_os_info($host);
	my $osname = $host_os_info->get_name();
	my $osver = $host_os_info->get_version();
	my $trg_upi = $ctx->get_target_upi();
	#if user specify the UPI_LONG in beinst.conf we will use it instead of UPI for display
    #for Backup Exec for Linux Server, the UPI is BE and the UPI_LONG is "Backup Exec" which is more meaningful
    my $trg_upi_long = $ctx->get_target_upi_long();
    if ($trg_upi_long){
      $trg_upi = $trg_upi_long;
    }	
	my $msgr = Utils::_tr("${osname} ${osver} not supported by ${trg_upi}", 50, 1020, "${osname}", "${osver}", "${trg_upi}");

	Utils::vxif_pbr($msgl, $msgr);
}

sub test_product_installed {
	my $this = shift;
	my ($pkg) = @_;
	my $msgl = Utils::_tr("Checking ${pkg} package", 50, 1021, "${pkg}");

	Utils::vxif_pbl($msgl);
}

sub product_is_installed {
	my $this = shift;
	my ($pkg, $version) = @_;
	my $msgl = Utils::_tr("Checking ${pkg} package", 50, 1021, "${pkg}");
	my $msgr = Utils::_tr("$version installed", 50, 1022, "$version");

	Utils::vxif_pbr($msgl, $msgr);
}

sub product_not_installed {
	my $this = shift;
	my ($pkg) = @_;
	my $msgl = Utils::_tr("Checking ${pkg} package", 50, 1021, "${pkg}");
	my $msgr = Utils::_tr("not installed", 50, 1023);

	Utils::vxif_pbr($msgl, $msgr);
}

sub product_installed_unknown {
	my $this = shift;
	my ($pkg) = @_;
	my $msgl = Utils::_tr("Checking ${pkg} package", 50, 1021, "${pkg}");
	my $msgr = Utils::_tr("failed", 50, 1024);

	Utils::vxif_pbr($msgl, $msgr);
}

sub configuration_not_supported {
	my $this = shift;
	my ($host) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $system_info = $ifmgr->get_system_info();
	my $host_os_info = $system_info->get_host_os_info($host);
	my $os_name = $host_os_info->get_name();
	my $os_version = $host_os_info->get_version();
	my $os_arch = $host_os_info->get_architecture();
	my $trg_upi = $ctx->get_target_upi();
	my $msg =
		sprintf
		(
		 "System configuration for %s, OS = %s, OS version = %s, architecture = %s, is not supported by %s.\n",
		 $host,
		 $os_name,
		 $os_version,
		 $os_arch,
		 $trg_upi,
		 );
	my $status_bar = $ifmgr->get_status_bar();
	$status_bar->display_and_log_status($msg, "warning");
}

sub test_external_dependencies {
	my $this = shift;
	my $msgl = Utils::_tr("Checking for external dependencies", 50, 1025);

	Utils::vxif_pbl($msgl);
}

sub external_dependencies_test_pass {
	my $this = shift;
	my $msgl = Utils::_tr("Checking for external dependencies", 50, 1025);
	my $msgr = Utils::_tr("all external dependencies satisfied", 50, 1026);

	Utils::vxif_pbr($msgl, $msgr);
}

sub external_dependencies_test_fail {
	my $this = shift;
	my ($pkg, $missing) = @_;
	my $msgl = Utils::_tr("Checking for external dependencies", 50, 1025);
	my $msgr = Utils::_tr("external dependencies not satisfied", 50, 1027);

	Utils::vxif_pbr($msgl, $msgr);

	if ($pkg && $missing) {
		Utils::vxif_pbl(Utils::_tr("\n$pkg depends on the following packages, which are either not found or their existing versions are incompatible: ", 50, 1028, "$pkg"));
		Utils::vxif_pbl(join(" ", @$missing));
	}
}

sub error_in_space_calculation {
	my $this = shift;
	my ($err_msg) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_and_log_status($err_msg, "error");
}

sub test_required_space {
	my $this = shift;
	my $msgl = Utils::_tr("Checking file system space", 50, 1029);

	Utils::vxif_pbl($msgl);
}

sub required_space_unknown {
	my $this = shift;
	my ($err_msg) = @_;
	my $msgl = Utils::_tr("Checking file system space", 50, 1029);

	Utils::vxif_pbr($msgl, $err_msg);
}

sub required_space_test_fail {
	my $this = shift;
	my $msgl = Utils::_tr("Checking file system space", 50, 1029);
	my $msgr = Utils::_tr("required space is not available", 50, 1030);

	Utils::vxif_pbr($msgl, $msgr);
}

sub required_space_test_pass {
	my $this = shift;
	my $msgl = Utils::_tr("Checking file system space", 50, 1029);
	my $msgr = Utils::_tr("required space is available", 50, 1031);

	Utils::vxif_pbr($msgl, $msgr);
}

sub space_remaining_warning {
	my $this = shift;
	my ($trg_upi, $trg_host, $vol, $kr) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();
        my ($rtn);

	$rtn = $status_bar->display_and_log_status("\nInstalling ${trg_upi} will leave only approximately ${kr} KB of free space remaining in the $vol partition on ${trg_host}.", "warning");
        return $rtn;
}

sub input_should_continue {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $root_inst = $ctx->get_root_installer();
	my $ayn = undef;
	my $rc = 1;

	my $msgl = Utils::_tr("Do you want to continue?", 50, 1032);

        $ayn = Utils::vxif_aynn($msgl, "", "");
	if ($ayn eq $root_inst->{MSG}{NOKEY}{U}) {
		$rc = 0;
	}
	return $rc;
}

sub install_valid_only {
	my $this = shift;
	my ($product, $valid_systems) = @_;
	my $vs_str = join(" ",@$valid_systems);
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_status(Utils::_tr("Installing ${product} on systems ${vs_str} only", 50, 1033, "${product}", "${vs_str}"));
}

sub input_install_valid_only {
	my $this = shift;
	my ($product, $valid_systems) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $root_inst = $ctx->get_root_installer();
	my $vs_str = join(" ",@$valid_systems);
	my $msgl = Utils::_tr("Would you like to perform product installation operations on systems ${vs_str} only?", 50, 1034, "${vs_str}");
	my $ask = undef;;
	my $rc = 1;
	my $quit_key_handler = sub {
		$rc = undef;
	};

	$ask = Utils::vxif_ayny($msgl, "", "", $quit_key_handler);
	if ($ask eq $root_inst->{MSG}{NOKEY}{U}) {
		$rc = 0;
	}

	return $rc;
}

sub initial_system_check_fail {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_bpl(Utils::_tr("\nInitial system check failed.", 50, 1035));
	Utils::vxif_prtc($ctx);
}

sub remote_access_methods {
	my $this = shift;
	my ($rsh_cmd, $rcp_cmd) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $status_bar = $ifmgr->get_status_bar();

	$status_bar->display_status(Utils::_tr("\nUsing ${rsh_cmd} and ${rcp_cmd} to communicate with remote systems.", 50, 1036, "${rsh_cmd}", "${rcp_cmd}"));
}

sub target_system_check_fail {
	my $this = shift;
	my $msg = Utils::_tr("Initial system check failed.", 50, 1037);
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_bpl($msg);
	Utils::vxif_prtc($ctx);
}

sub target_system_check_pass {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_bpl(Utils::_tr("\nInitial system check completed successfully.", 50, 1038));
	Utils::vxif_prtc($ctx);
}

sub select_host_to_configure {
	my $this = shift;
	my ($hosts) = @_;
	my $hostlist = [];
	my $prompt = Utils::_tr("Select host to configure.", 50, 1039);
	my $help_text = Utils::_tr("Enter the number in the list of the host that you want to configure.", 50, 1040);
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $root_installer = $ctx->get_root_installer();
	my $cf = $this->get_class_factory();
	my $om = $cf->create_options_menu();
	my $m = $om->get_menu();

	$om->set_title($$ctx{INSTALLERTITLE});

	my $num_hosts = scalar(@$hosts);
	for (my $ix = 0; $ix < $num_hosts; $ix++) {
		my $host = $hosts->[$ix];
		my $mi_id = "MI_${ix}";
		my $mi = $cf->create_menu_item($mi_id);
		$mi->set_text($host);
		$mi->set_data($ix);
		$m->add_menu_item($mi);
	}

	my $back_btn_id = "BTN_ID_BACK";
	my $back_button = $cf->create_button($back_btn_id);
	$back_button->set_text('b'); # use %COMM{BACK} ???
	$om->add_button($back_button);

	my $quit_btn_id = "BTN_ID_QUIT";
	my $quit_button = $cf->create_button($quit_btn_id);
	$quit_button->set_text('q'); # use %COMM{QUIT} ???
	$om->add_button($quit_button);

	$om->set_prompt($prompt);
	$om->set_help_text($help_text);

	my $back_handler = sub {
		$back_button->send_dialog_message($om, "ID_CANCEL");
	};
	$back_button->set_click_proc($back_handler);

	my $quit_key_handler = sub {
		$root_installer->cleanup($ctx);
	};
	my $quit_handler = sub {
		$quit_button->send_dialog_message($om, "ID_CANCEL");
		$quit_key_handler->();
	};
	$quit_button->set_click_proc($quit_handler);

	my $hosts_configured = {};

	my $result_id = undef;

	while (1) {
		$result_id = $om->do_modal();

		if ($result_id && $result_id eq "ID_OK") {
			my $result_item = $m->get_selected_item();
			my $result_ix = $result_item->get_data();
			my $host = $hosts->[$result_ix];
			my $os = $ctx->get_host_os_name($host);
			my $trg_upi = $ctx->get_target_upi();
			my $upi_inst = $root_installer->{PRODUCT}{$trg_upi}{$os};
			my $cfg = $ctx->get_config();
			my $rc = $upi_inst->build_product_config_on_target_host($ctx, $cfg, $host);
			if ($rc) {
				$hosts_configured->{$host} = 1;
			}
		} else {
			last;
		}
	}

	return $hosts_configured;
}

sub select_host_to_configure0 {
	my $this = shift;
	my ($hosts) = @_;
	my $hit_back_key = 0;
	my $hit_quit_key = 0;
	my $choice = undef;
	my $back_key_handler = sub {
		$hit_back_key = 1;
	};
	my $quit_key_handler = sub {
		$hit_quit_key = 1;
	};
	my $prompt = Utils::_tr("Select host to configure.", 50, 1039);
	my $help = Utils::_tr("Enter the number in the list of the host that you want to configure.", 50, 1040);

	$choice = Utils::vxif_menu
		(
		 $prompt,
		 $hosts,
		 "", # default choice?
		 $help,
		 $back_key_handler,
		 $quit_key_handler,
		 );

	if ($hit_quit_key) {
		$choice = undef;
	} elsif ($hit_back_key) {
		$choice = 0;
	} else {
		# nada
	}

	return $choice;
}

## BEGIN LIC ##

sub pre_check_licensing {
	my $this = shift;
	my ($installer_title, $trg_upi, $hosts) = @_;

	Utils::vxif_title($installer_title);
	#if ($#hosts > 0) {
	my $num_hosts = scalar(@$hosts);
	if ($num_hosts > 1) {
		Utils::vxif_bpl(Utils::_tr("Each system requires a ${trg_upi} product license before installation.  License keys for additional product features should also be added at this time.\n", 50, 1041, "${trg_upi}"));
		Utils::vxif_bpl(Utils::_tr("Some license keys are node locked and are unique per system.  Other license keys, such as demo keys and site license keys, are registered on all systems and must be entered on the first system.\n", 50, 1042));
	}

	Utils::vxif_bpl(Utils::_tr("${trg_upi} Licensing Verification:\n", 50, 1043, "${trg_upi}"));
}

sub check_licensing_verified {
	my $this = shift;
	my ($trg_upi) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_bpl(Utils::_tr("${trg_upi} licensing verified successfully.", 50, 1044, "${trg_upi}"));
	Utils::vxif_prtc($ctx);
}

sub check_licensing_completed {
	my $this = shift;
	my ($trg_upi) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_bpl(Utils::_tr("${trg_upi} licensing completed successfully.", 50, 1045, "${trg_upi}"));
	Utils::vxif_prtc($ctx);
}

sub check_licensing_fail {
	my $this = shift;
	my ($trg_upi) = @_;

	Utils::vxif_bpl(Utils::_tr("${trg_upi} licensing failed.", 50, 1046, "${trg_upi}"));
}

## END LIC ##

sub pre_os_optional_packages {
	my $this = shift;
	my ($os, $installer_title) = @_;

	Utils::vxif_title($installer_title);
}

sub pre_display_os_packages {
	my $this = shift;
	my ($os, $installer_title) = @_;

	Utils::vxif_title($installer_title);
}

sub display_os_packages {
	my $this = shift;
	my ($msgs, $opkgs, $pkg_display_names) = @_;
	my $title = $msgs->{title};
	my $subtitle = $msgs->{subtitle};
	my $page_msg = $msgs->{page_msg};
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_title($title);
	Utils::vxif_pl($subtitle);

	my $n = 0;
	foreach my  $pkg (@$opkgs) {
		if ($n%20 == 19) {
			Utils::vxif_prtc($ctx);
			Utils::vxif_pl($page_msg);
		}

		my $pkg_display_name = $pkg_display_names->{$pkg};
		Utils::vxif_pl($pkg_display_name);

		$n++;
	}

	Utils::vxif_prtc($ctx);
}

sub begin_checking_sysinst_reqs {
	my $this = shift;
	my ($installer_title) = @_;

	Utils::vxif_title($installer_title);
	Utils::vxif_bpl(Utils::_tr("Checking system installation requirements:\n", 50, 1047));
}

sub continue_checking_sysinst_reqs {
	my $this = shift;
	my ($installer_title) = @_;

	Utils::vxif_title($installer_title);
	Utils::vxif_bpl(Utils::_tr("...Continued checking system installation requirements:\n", 50, 1048));
}

sub begin_checking_hostinst_reqs {
	my $this = shift;
	my ($installer_title, $upi, $os, $hosts) = @_;

	Utils::vxif_bpl(Utils::_tr("Checking ${upi} installation requirements on ${os} target systems: ${hosts}", 50, 1049, "${upi}", "${os}", "${hosts}"));
}

sub continue_checking_hostinst_reqs {
	my $this = shift;
	my ($installer_title, $upi, $os, $hosts) = @_;

	Utils::vxif_title($installer_title);
	Utils::vxif_bpl(Utils::_tr("...Continued checking system installation requirements:\n", 50, 1048));
	Utils::vxif_bpl(Utils::_tr("...Continued checking ${upi} installation requirements on ${os} target systems: ${hosts}", 50, 1050, "${upi}", "${os}", "${hosts}"));
}

sub check_hostinst_reqs {
	my $this = shift;
	my ($upi, $host) = @_;

	Utils::vxif_bpl(Utils::_tr("\nChecking ${upi} installation requirements on ${host}:\n", 50, 1051, "${upi}", "${host}"));
}

sub sysinst_reqs_pass {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_bpl(Utils::_tr("\nInstallation requirements checks completed successfully.", 50, 1052));
	Utils::vxif_prtc($ctx);
}

sub sysinst_reqs_fail {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_bpl(Utils::_tr("\nInstallation requirements not satisfied on all target systems.", 50, 1053));
	Utils::vxif_prtc($ctx);
}

# install

sub pre_install_packages {
	my $this = shift;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();

	Utils::vxif_title($$ctx{INSTALLERTITLE});
}

sub install_packages_pass {
	my $this = shift;
	my ($product_info) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $upi_inst = $product_info->get_installer_object();
	my $title = $upi_inst->get_product_title($ctx);
	my $version = $upi_inst->get_product_version($ctx);

	#Utils::vxif_bpl("\n${title} ${version} installation completed successfully.");
        Utils::vxif_bpl(Utils::_tr("\n${title} installation completed successfully.", 50, 1054, "${title}")); # Changed ET 517162 - 10 Mar 06 jpk
	Utils::vxif_bpl(Utils::_tr("\n${title} requires a system reboot. Please reboot your system(s).", 50, 1055, "${title}")) if ($$ctx{REBOOT});
	Utils::vxif_prtc($ctx);
}

sub install_packages_fail {
	my $this = shift;
	my ($product_info) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $upi_inst = $product_info->get_installer_object();
	my $title = $upi_inst->get_product_title($ctx);
	my $version = $upi_inst->get_product_version($ctx);

	Utils::vxif_bpl(Utils::_tr("\n${title} ${version} installation did not complete successfully.", 50, 1056, "${title}", "${version}"));
	Utils::vxif_prtc($ctx);
}

# uninstall

sub begin_checking_sysuninst_reqs {
	my $this = shift;
	my ($installer_title) = @_;

	Utils::vxif_title($installer_title);
	Utils::vxif_bpl(Utils::_tr("Checking system uninstall requirements:\n", 50, 1057));
}

sub continue_checking_sysuninst_reqs {
	my $this = shift;
	my ($installer_title) = @_;

	Utils::vxif_title($installer_title);
	Utils::vxif_bpl(Utils::_tr("...Continued checking system uninstall requirements:\n", 50, 1058));
}

sub begin_checking_hostuninst_reqs {
	my $this = shift;
	my ($installer_title, $upi, $os, $hosts) = @_;

	Utils::vxif_bpl(Utils::_tr("Checking ${upi} uninstall requirements on ${os} target systems: ${hosts}", 50, 1059, "${upi}", "${os}", "${hosts}"));
}

sub continue_checking_hostuninst_reqs {
	my $this = shift;
	my ($installer_title, $upi, $os, $hosts) = @_;

	Utils::vxif_title($installer_title);
	Utils::vxif_bpl(Utils::_tr("...Continued checking system uninstall requirements:\n", 50, 1058));
	Utils::vxif_bpl(Utils::_tr("...Continued checking ${upi} uninstall requirements on ${os} target systems: ${hosts}", 50, 1060, "${upi}", "${os}", "${hosts}"));
}

sub check_hostuninst_reqs {
	my $this = shift;
	my ($upi, $host) = @_;

	Utils::vxif_bpl(Utils::_tr("\nChecking ${upi} uninstall requirements on ${host}:\n", 50, 1061, "${upi}", "${host}"));
}

sub confirm_product_uninstall {
	my $this = shift;
	my ($trg_host) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $trg_upi = $ctx->get_target_upi();
	#if user specify the UPI_LONG in beinst.conf we will use it instead of UPI for display
    #for Backup Exec for Linux Server, the UPI is BE and the UPI_LONG is "Backup Exec" which is more meaningful
    my $trg_upi_long = $ctx->get_target_upi_long();
    if ($trg_upi_long){
      $trg_upi = $trg_upi_long;
    }
	
	my $task_type = $ctx->get_task_type();
	my $os_inst = $ctx->get_host_os_installer($trg_host);
	my $rc = 1;

	my $quit_handler = sub {
		$os_inst->cleanup($ctx);
	};

	if (!$$ctx{RESPONSEFILE} && ($task_type ne "upgrade")) {
		Utils::vxif_title($$ctx{INSTALLERTITLE});
		my $msg = Utils::_tr("Are you sure you want to uninstall ${trg_upi} packages from ${trg_host}?", 50, 1062, "${trg_upi}", "${trg_host}");
		my $ans = Utils::vxif_ayny($msg, "", "", $quit_handler);
		if ($ans eq $os_inst->{MSG}{NOKEY}{U}) {
			$rc = 0;
		}
	}

	return $rc;
}

sub pre_uninstall_packages {
	my $this = shift;
	my ($product_info, $trg_host) = @_;
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $task_type = $ctx->get_task_type();

	Utils::vxif_title($$ctx{INSTALLERTITLE}) if ($task_type ne "upgrade");

	if ($task_type ne "upgrade") {
		my $upi_inst = $product_info->get_installer_object();
		my $title = $upi_inst->get_product_title($ctx);
		my $version = $upi_inst->get_product_version($ctx);

		Utils::vxif_bpl(Utils::_tr("Uninstalling ${title} on ${trg_host}:\n", 50, 1063, "${title}", "${trg_host}")) ;
	}
	
}

sub uninstall_packages_pass {
	my $this = shift;
	my ($product_info) = @_;
	my $upi_inst = $product_info->get_installer_object();
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $title = $upi_inst->get_product_title($ctx);
	my $version = $upi_inst->get_product_version($ctx);
	my $task_type = $ctx->get_task_type();

	#Utils::vxif_bpl("\n${title} ${version} uninstall completed successfully.") if ($task_type ne "upgrade"); # Changed ET 517162 - 10 Mar 06 jpk
        my $msg = Utils::_tr("\n${title} uninstall completed successfully.", 50, 1064, "${title}");
        Utils::vxif_bpl($msg) if ($task_type ne "upgrade");
	Utils::vxif_prtc($ctx) if ($task_type ne "upgrade");
}

sub uninstall_packages_fail {
	my $this = shift;
	my ($product_info) = @_;
	my $upi_inst = $product_info->get_installer_object();
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $title = $upi_inst->get_product_title($ctx);
	my $version = $upi_inst->get_product_version($ctx);
	my $task_type = $ctx->get_task_type();

	Utils::vxif_bpl(Utils::_tr("\n${title} uninstall did not complete successfully.", 50, 1065, "${title}"));
	Utils::vxif_prtc($ctx) if ($task_type ne "upgrade");
}

sub product_uninstall_successful {
	my $this = shift;
	my ($product_info, $trg_host) = @_;
	my $upi_inst = $product_info->get_installer_object();
	my $ifmgr = $this->get_interface_manager();
	my $ctx = $ifmgr->get_vxif_context();
	my $trg_upi = $ctx->get_target_upi();
	my $title = $upi_inst->get_product_title($ctx);
	my $version = $upi_inst->get_product_version($ctx);

	$$ctx{LOGGER}->info("${trg_upi} successfully uninstalled on ${trg_host}.\n");
}

1;
