package VxIF::Interface::Classic::ClassFactory;
use strict;

use VxIF::Interface::Generic::ClassFactory;
@VxIF::Interface::Classic::ClassFactory::ISA = qw(VxIF::Interface::Generic::ClassFactory);

use VxIF::Interface::Classic::Events;
use VxIF::Interface::Classic::Modes;
use VxIF::Interface::Classic::Logger;

use VxIF::Interface::Classic::UI::OptionsMenu;
use VxIF::Interface::Classic::UI::LabeledInfo;
use VxIF::Interface::Classic::UI::StatusBar;
use VxIF::Interface::Classic::UI::Progress;
use VxIF::Interface::Classic::UI::Form;

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->VxIF::Interface::Generic::ClassFactory::init(@_);
}

sub create_events {
	my $self = shift;
	my $events = new VxIF::Interface::Classic::Events();

	$events->set_class_factory($self);

	return $events;
}

sub create_modes {
	my $self = shift;
	my $modes = new VxIF::Interface::Classic::Modes();

	$modes->set_class_factory($self);

	return $modes;
}

sub create_logger {
	my $self = shift;
	my $logger = new VxIF::Interface::Classic::Logger();

	$logger->set_class_factory($self);

	return $logger;
}

# UI

sub create_options_menu {
	my $this = shift;
	my $options_menu = new VxIF::Interface::Classic::UI::OptionsMenu($this);

	#$options_menu->set_class_factory($this);

	return $options_menu;
}

sub create_labeled_info {
	my $this = shift;
	my ($msg_id) = @_;
	my $labeled_info = new VxIF::Interface::Classic::UI::LabeledInfo($msg_id);

	$labeled_info->set_class_factory($this);

	return $labeled_info;
}

sub create_status_bar {
	my $this = shift;
	my ($msg_id) = @_;
	my $status_bar = new VxIF::Interface::Classic::UI::StatusBar($msg_id);

	$status_bar->set_class_factory($this);

	return $status_bar;
}

sub create_progress {
	my $this = shift;
	my ($item_id) = @_;
	# set class factory in constructor, so can create sub_widgets
	my $progress = new VxIF::Interface::Classic::UI::Progress($item_id, $this);

	return $progress;
}

sub create_form {
	my $this = shift;
	my ($item_id) = @_;
	my $form = new VxIF::Interface::Classic::UI::Form($item_id);

	$form->set_class_factory($this);

	return $form;
}

1;

