use strict "vars"; 

our %CFG;
our %CMD;
our %COMM;
our %CONF;
our %DEF;
our %FLAG;
our %MSG;
our %OPT;
our %PATH;
our %PKGI;
our %PROD;
our %SUB;
our %PASSWD;
our @SYSC;
our @SYSI;
our $PKG;
our $PMODE;
our $UPI;
our $SYS;
our $LOCAL;
our $TARGET;

#
#SCC#  $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTB/CPI40.pm,v $
#SCC#  $Id: CPI40.pm,v 1.1 2006/12/06 21:57:07  $
#

# asks a question
sub _ask {
	my ($ask,$back,$def,$help,$nl,$nullok,$ques,$rtn);
	_tr(@_);
	$ques=$MSG{TR};
	$def=$COMM{DEFANSWER};
	$COMM{DEFANSWER}="";
	$nullok=$COMM{NULLOK};
	$COMM{NULLOK}="";
	$back=1 if (($COMM{BACK}) || ($COMM{PBACK}));
	$COMM{BACK}="";
	$help=$MSG{HELP};
	$MSG{HELP}="";
	$nl = ($COMM{LLCH}+length($def)+4>$COMM{TERMX}-length($MSG{INDENT})) ? "\n" : " ";
	if (($back) && ($help)) {
		$ques.=" [$MSG{BACKKEY},$MSG{HELPKEY}]";
	} elsif ($back) {
		$ques.=" [$MSG{BACKKEY}]";
	} elsif ($help) {
		$ques .= " [$MSG{HELPKEY}]";
	}
	$ques .= "$nl($def)" if (($def) && ($def ne " "));
	while(1) {
		print "$COMM{TPUT}{BS}$ques$COMM{TPUT}{BE} ";
		_log($ques);
		$ask = <STDIN>;
		$ask=_desp($ask);
		_log($ask);
		_comm_cleanup(0) if ($ask =~ /^$MSG{QUITKEY}$/i);
		if (($ask=~ /^B$/i) && ($back)) {
			$FLAG{BACK}=1;
			return "";
		} elsif (($help) && ($ask eq $MSG{HELPKEY})) {
			_pl_notr("\n$help\n");
		} elsif ($ask=~/^\P{IsASCII}/) {
			_pl("Only ASCII characters may be entered.", 20, 1000);
		} else {
			$ask=$def if (($def) && ($ask eq ""));
			return "$ask" if (($ask ne "") || ($nullok));
		}
	}
}

# asks a yes/no question
sub _ayn {
	my ($ayn,$back,$bk,$def,$help,$hk,$nl,$ques);
	_tr(@_);
	$ques=$MSG{TR};
	$def=$COMM{DEFANSWER};
	$COMM{DEFANSWER}="";
	$back=1 if (($COMM{BACK}) || ($COMM{PBACK}));
	$COMM{BACK}="";
	$help=$MSG{HELP};
	$MSG{HELP}="";
	$nl = ($COMM{LLCH}+10>$COMM{TERMX}-length($MSG{INDENT})) ? "\n" : " ";
	$ques.=$nl;
	$bk=",$MSG{BACKKEY}" if ($back);
	$hk=",$MSG{HELPKEY}" if ($help);
	$ques.="[$MSG{YESKEY},$MSG{NOKEY},$MSG{QUITKEY}$bk$hk] ";
	$ques.="($def) " if ($def);
	while(1) {
		print "$COMM{TPUT}{BS}$ques$COMM{TPUT}{BE}";
		_log($ques);
		$ayn = <STDIN>;
		$ayn = _desp($ayn);
		_log($ayn);
		$ayn=$def if (($def) && (!$ayn));
		if (($help) && ($ayn eq $MSG{HELPKEY})) {
			_pl_notr("\n$help\n");
		} 
		return "Y" if ($ayn =~ /^$MSG{YESKEY}/i);
		return "N" if ($ayn =~ /^$MSG{NOKEY}/i);
		if (($ayn =~ /^$MSG{BACKKEY}/i) && ($back)) {
			$FLAG{BACK}=1;
			return "";
		}
		_comm_cleanup(0) if ($ayn =~ /^$MSG{QUITKEY}$/i);
	}
}

sub _aynn {
	$COMM{DEFANSWER}="$MSG{NOKEY}";
	my $ayn=_ayn(@_);
	return "$ayn";
}

sub _ayny {
	$COMM{DEFANSWER}="y";
	my $ayn=_ayn(@_);
	return "$ayn";
}

# print in bold and log
sub _bpl {
	_log(@_);
	print "$COMM{TPUT}{BS}$MSG{TR}$COMM{TPUT}{BE}\n"; 
}

# add a message to $COMM{PRECHECK}{$SYS}
sub _ckmsg {
	return if (!$OPT{PRECHECK});
	my @a=@_;
	$a[0]="* $a[0]";
	_tr(@a);
	push(@{$COMM{PRECHECK}{$SYS}},$MSG{TR});
}

# copy a file
# 
# FIXME: we should probably move some of the comm_check_communication SCP/RCP things over to here
# $CMD{$LOCAL}{RCP} contains the location of ssh commands here if USESSH is set.
# 
sub _copy {
	my ($cmd, $ddoe, $df, $do, $r2l, $sf, $ftp, $file);
	($sf,$df,$r2l,$ddoe) = (@_);

	if (!($CFG{INSTALL}{USEFTP})) {
		$cmd = (_localsys()) ? "$CMD{$LOCAL}{CP} -rp $sf $df" : ($r2l) ?  "$CMD{$LOCAL}{RCP} -rp $SYS:$sf $df" : "$CMD{$LOCAL}{RCP} -rp $sf root\@$SYS:$df";
		$do=_dol($cmd);
	} else {

	# vikas: need to extract the file name which needs to be appended to $df
	$file = $sf;
	$file =~ s/\/.*\///;
	$df .= "/";
	$df .= $file;

		use Net::FTP;
	    $ftp = Net::FTP->new("$SYS", Debug => 1);
	    $ftp->login("root", $PASSWD{$SYS});
	    $ftp->cwd("$PATH{ITD}");
	    $ftp->put($sf, $df);
	    $ftp->quit;  
	}

	if ($do) {
		if ($ddoe) {
			_pl("Cannot copy $sf to $df on $SYS", 20, 1001, "$sf", "$df", "$SYS");
		} else {
			_die("Cannot copy $sf to $df on $SYS", 20, 1001, "$sf", "$df", "$SYS");
		}
	}

	return "$do";
}

# copy a file and a backup
sub _copywbu {
	my ($sf,$df) = (@_);
	_copy($sf,$df);
	_copy($sf,"$df$COMM{BUCF}");
}

# compare versions
# returns 0 if versions are the same
# returns 1 if version $v1 is higher
# returns 2 if version $v2 is higher
sub _cv {
	my(@a1,@a2,$f,$n,$v1,$v2);	
	($v1,$v2)=(@_);	
	@a1=split(/[\.-]/,$v1);
	@a2=split(/[\.-]/,$v2);
	$n = ($#a1>$#a2) ? $#a1 : $#a2;
	foreach $f(0..$n) {
		$v1 = ($f<=$#a1) ? $a1[$f] : "0";
		$v2 = ($f<=$#a2) ? $a2[$f] : "0";
		return 1 if ($v1>$v2);
		return 2 if ($v2>$v1);
		# Assumes letters always trail numbers
		$v1=~s/[0-9]//g;
		$v2=~s/[0-9]//g;
		return 1 if (($v1 cmp $v2)>0);
		return 2 if (($v1 cmp $v2)<0);
	}
	return "0";
}

# remove spaces from begginning and end of line 
sub _desp {
	my($s)=(@_);
	$s=~s/^\s+//;
	$s=~s/\s+$//;
	return "$s";
}

# die, printing an error msg, and clean up
sub _die {
	if ($OPT{PRECHECK}) { _ckmsg(@_); return; }
	$FLAG{ADDUMI}=1;
	_log(@_);
	_p($MSG{TR});
	$FLAG{ADDUMI}="";
	exit 0 if ((!$FLAG{SAVELOG}) || ($FLAG{FORK}));
	$COMM{EXITCODE}=1 unless($COMM{EXITCODE});
	_comm_cleanup($COMM{EXITCODE});
}

# execute a command on local system, logging the command, output, and exit code
# $re=NULL - return output
# $re=1 - return exit code
# $re=2 - return both as an array reference
sub _dol {
	my ($cmd,$doe,$doo,$rdo,$re);
	($cmd,$re)=(@_);
	$cmd .= " 2>&1" unless ($cmd =~ />/);
	_log($cmd) unless ($FLAG{NODOLOG});
	_p("\n$cmd") if ($FLAG{DEBUG});
	$doo=`$cmd`;
	$doe=$?;
	chomp($doo);
	if (($COMM{LOG}) && (!$FLAG{NODOLOG})) {
		open(LOG, ">> $COMM{LOG}") or 
			_die("\n_log cannot open $COMM{LOG}", 20, 1002, "$COMM{LOG}");
		print LOG "exit=$doe\n$doo\n";
		close LOG;
	}
	_p("exit=$doe\n$doo") if ($FLAG{DEBUG});
	if (_isverror($doo)) {
		if ($FLAG{WARNVERROR}) {
			_pl_notr("$doo");
		}
		$doo="" if ($FLAG{NULLIFYVERROR});
	}
	return "$doo" if (!$re);
	return "$doe" if ($re==1);
	$rdo=["$doe","$doo"];
	return $rdo; 
}

# do on remote, prepends command with $CMD{RSH} $SYS if remote system
sub _dor {
	my ($cmd,$q,$re,$rsh,$rtn);
	($cmd,$re)=(@_);
	$rsh="$CMD{$LOCAL}{RSH} $SYS " unless (_localsys());
	$q = "\"" unless ((_localsys()) || ($cmd=~/[">\$]/)); #" balance for emacs
	$rtn=_dol("$rsh$q$cmd$q",$re);
	return "$rtn";
}

# duplicate an array to properly load the reference into a list
sub _dupa { 
	my @a=@_; 
	return \@a;
}

# duplicate a hash to properly load the reference into a list
sub _duph { 
	my $rh=shift;
	my %h=%$rh;
	return \%h;
}

# file check - remote must be done by rshing an ls command
sub _fc {
	my($file,$ls,$r);
	($file)=(@_);
	if (_localsys()) {
		$r = (-e $file) ? 1 : 0;
	} else {
		$ls=_dor("$CMD{$TARGET}{LS} $file");
		$r = ($ls eq $file) ? 1 : 0;
	}
	return "$r";
}

# return 1 if all elements of a hash array are the same
sub _hats {
	my($i,$k,$rh,$v);
	($rh)=(@_);
	foreach $k(keys(%$rh)) {
		return "" if (($i) && ($v ne $$rh{$k}));
		$v=$$rh{$k};
		$i=1;
	}
	return 1;
}

# verify a IP address string is in ##.##.##.## notation
sub _ipcheck {
	my(@f,$d,$ip,$n);
	($ip)=(@_);
	@f=split(/\./,$ip);
	return "1" if ($#f!=3);
	foreach $n(0..3) {
		return 1 if ($f[$n] eq "");
		$d=$f[$n];
		$d =~ s/[0-9]//g;
		return "1" if (($d) || ($f[$n]>255));
	}
}

sub _isint {
	my($i,$s);
	($s)=(@_);
	return "1" unless ($s =~ /^-?\d+$/);
	return "";
}

sub _isnum {
	my($i,$s);
	($s)=(@_);
	return "1" unless ($s =~ /^-?\d+\.?\d*$/);
	return "";
}

sub _isverror {
	return "1" if ($_[0]=~/V-\d+-\d+\d+/);
	# other products can add what they need for pre 4.0 Error id's
	return "1" if ($_[0]=~/^VCS:\d\d\d/);
	return "";
}

# check whether a string is a member of an array.  
# Return the member number, or -1 if it is not
sub _list {
	my(@arr,$match,$n);
	($match,@arr) = (@_);
	@arr=split(/\s+/,$arr[0]) if (!$#arr);
	foreach $n(0..$#arr) { 
		_dbg("_list $match $n $arr[$n] @arr") if ($FLAG{DEBUG});
		#return "$n" if ($arr[$n] eq $match);
		return "$n" if ($match =~ /^$arr[$n]/);
	}
	return "-1";
}

# as _list, but supporting * as a wildcard in @arr
# Return the member number, or -1 if it is not
# Return the member number, or -1 if it is not
sub _wclist {
    my(@arr,$match,$n,$wildcard);
    ($match,@arr) = (@_);
    @arr=split(/\s+/,$arr[0]) if (!$#arr);
    foreach $n(0..$#arr) {
        _dbg("_list $match $n $arr[$n] @arr") if ($FLAG{DEBUG});
            if  ($arr[$n] =~ "\\*")  {
                return $n if $match =~ m/$arr[$n]/;
            } else {
                return "$n" if ($arr[$n] eq $match);
            }   
    }       
    return "-1";
}   

sub _localsys { 

    if ( (!$COMM{LOCALDOMAIN}) && ($SYS =~ m/\./g) ) {
		_die("Cannot determine localhost's dns domain name. This can cause problems during installation if you have entered localhost's fully qualified domain name as an installation target. Please use only the hostname when installing to this host.\n", 20, 1003);                                                                                                          }            

	return "1" if ((!$COMM{LOCALSYS}) || (lc($SYS) eq lc($COMM{LOCALSYS})) || (lc($SYS) eq lc("$COMM{LOCALSYS}.$COMM{LOCALDOMAIN}")));
}

# log
sub _log {
	_tr(@_);
	return unless ($COMM{LOG});
	open(LOG, ">> $COMM{LOG}") or 
		_die("\n_log cannot open $COMM{LOG}", 20, 1002, "$COMM{LOG}");
	print LOG "$MSG{TR}\n";
	close LOG;
}

# asks a question with a menu of items to select stored in @{$COMM{MENU}}
sub _menu {
	my ($back,$def,$help,$menu,$mi,$nmi,$nl,$opt,$ques,$rtn);
	_tr(@_);
	$ques=$MSG{TR};
	$def=$COMM{DEFANSWER};
	$COMM{DEFANSWER}="";
	$help=$MSG{HELP};
	$MSG{HELP}="";
	$back=1 if (($COMM{BACK}) || ($COMM{PBACK}));
	$COMM{BACK}="";
	$nl=$#{$COMM{MENU}}+1;
	$opt="[1-$nl";
	$opt.=",b" if ($back);
	$opt.=",q";
	$opt.=",$MSG{HELPKEY}" if ($help);
	$opt.="]";
	$nl = ($COMM{LLCH}+length($opt)+length($def)>$COMM{TERMX}-length($MSG{INDENT})) ? "\n" : " ";
	$ques .= "$nl$opt";
	$ques .= " ($def)" if (($def) && ($def ne " "));
	foreach $mi(@{$COMM{MENU}}) {
		$nmi=sprintf("%2d",$nmi+1);
		$FLAG{TABLB}=1;
		_pl_notr("$COMM{TPUT}{BS}$MSG{INDENT}$nmi$COMM{TPUT}{BE})  $mi");
		$FLAG{TABLB}="";
		_log("$MSG{INDENT}$nmi$MSG{INDENT}$mi", 20, 1004, "$MSG{INDENT}", "$nmi$MSG{INDENT}", "$mi");
	}
	if ($back) {
		_pl_notr("$COMM{TPUT}{BS}$MSG{INDENT} B$COMM{TPUT}{BE})$MSG{INDENT}$MSG{MENUBACK}");
		_log("$MSG{INDENT}$MSG{BACKMENU}$MSG{INDENT}$mi", 20, 1005, "$MSG{INDENT}", "$MSG{BACKMENU}", "$MSG{INDENT}", "$mi");
	}
	_p();
	while(1) {
		print "$COMM{TPUT}{BS}$ques$COMM{TPUT}{BE} ";
		_log($ques);
		$menu = <STDIN>;
		$menu=_desp($menu);
		_log($menu);
		$menu =~ s/^\s+//;
		_comm_cleanup(0) if ($menu =~ /^$MSG{QUITKEY}$/i);
		$menu=$def if (($def) && (!$menu));
		return "$menu" if (($menu>=1) && ($menu<=$nmi));
		return "B" if (($back) && ($menu =~ /^$MSG{BACKKEY}$/i));
		if (($help) && ($menu eq $MSG{HELPKEY})) {
			_pl_notr("\n$help\n");
		} 
	}
}

# verify a NIC string is in "lettersnumbers" notation
sub _niccheck {
	my($l,$n,$nic);
	($nic)=(@_);
	$l=$n=$nic;
	$l=~s/[0-9]//g;
	$n=~s/[A-Za-z]//g;
	return 1 if ((!$l) || ($n eq "") || ($nic ne "$l$n"));
	return 0;
}

sub _p { print "$_[0]\n"; }
sub _dbg { print "$_[0]\n"; }

# progress bar, left side
sub _pb1 { 
	_log(@_);
	print "$MSG{INDENT}$MSG{TR} " unless ($FLAG{FORK}); 
	$MSG{PB1}=$MSG{TR};
}

# progress bar, right side
sub _pb2 { 
	my($p,$p2,$sp);
	_log(@_);
	$p2=length($MSG{TR});
	$sp=$COMM{TERMX}-length($MSG{INDENT})-10-length($MSG{PB1})-$p2;
	print "$MSG{INDENT}$MSG{PB1} " if ($FLAG{FORK}); 
	print "...";
	foreach $p(1..$sp) { print "."; }
	print " $MSG{TR}\n"; 
}

# print and log
sub _pl {
	_log(@_);
	_p($MSG{TR});
}

# print and log with no translation
# message is already translated
sub _pl_notr {
	$FLAG{NOTR}=1;
	_log(@_);
	_p($MSG{TR});
	$FLAG{NOTR}="";
}

# Press Return to Continue
# only pauses when using RESPONSEFILE install or $_[0] is set
sub _prtc {
	if (($OPT{RESPONSEFILE}) || ($_[0]))  { sleep $COMM{SCREENPAUSE}; return; }
	print "\n$COMM{TPUT}{BS}$MSG{PRTC}$COMM{TPUT}{BE} ";
	my $prtc = <STDIN>;
	chomp($prtc);
	_comm_cleanup(0) if ($prtc =~ /^$MSG{QUITKEY}$/i);
}

# read a file
sub _readf {
	my($file,$line,$rf);
	($file)=(@_);
	open(RF, $file) or
		_die("\n_readf cannot open $file", 20, 1006, "$file");
	while ($line=<RF>) { $rf.=$line; }
	close(RF);
	return "$rf";	
}

# clean up zombie processes
use POSIX ":sys_wait_h";
sub _reaper {
	my($pid);
	while (($pid = waitpid(-1,WNOHANG)) > 0) {
		_log("reaped $pid", 20, 1007, "$pid");
	}
}

# cause the cursor to have a spinning char while waiting
sub _spin {
	if (!$FLAG{TPUT}) { sleep 1; return; }
	my (@ch,$n);
	@ch=("/","-","\\","|");
	print "$ch[0]$COMM{TPUT}{CL}";
	sleep 1;
	print "$ch[1]$COMM{TPUT}{CL}";
	sleep 1;
	print "$ch[2]$COMM{TPUT}{CL}";
	sleep 1;
	print "$ch[3]$COMM{TPUT}{CL}";
	sleep 1;
}

# title bar
sub _title {
	return if ($OPT{RESPONSEFILE});
	my($es,$ns,$ss,$t);
	$ns=($COMM{TERMX}-length($MSG{TITLE}))/2;
	foreach $t(1..$ns) { $ss.=" "; }
	$ns=$COMM{TERMX}-$ns-length($MSG{TITLE});
	foreach $t(1..$ns) { $es.=" "; }
	# print newlines anyway so you can scroll back after a clear
	foreach $t(1..$COMM{TERMY}) {  print "\n"; }
	system("$CMD{CLEAR}") if ((!$FLAG{TPUT}) && (-x $CMD{CLEAR}));
	print "$COMM{TPUT}{CS}$COMM{TPUT}{SS}$ss$MSG{TITLE}$es$COMM{TPUT}{SE}\n\n";
}

# check whether a regular expression is found within a member of an array.  
# Return the member number, or -1 if it is not
sub _tlist {
	my(@arr,$match,$n);
	($match,@arr) = (@_);
	@arr=split(/\s+/,$arr[0]) if (!$#arr);
	foreach $n(0..$#arr) { 
		_dbg("_tlist $match $n $arr[$n] @arr") if ($FLAG{DEBUG});
		return "$n" if ($match =~ /$arr[$n]/); 
	}
	return "-1";
}

# translate a message, saves translation in global var MSG{TR}
sub _tr_B {
	my (@l,@w,$a,$c,$line,$fc,$msg,$nm,$sp,$tm,$vxa,$word);
	if ((!$FLAG{NOTR}) && ($_[1]>0) && (-x "$PATH{SCRIPTS}/vxgettext")) {
		foreach $a(@_) { $vxa .= " \"$a\""; }
		$ENV{"LANG"}=$COMM{ENVLANG};
		#_dbg("$PATH{SCRIPTS}/vxgettext $vxa");
		$msg=`$PATH{SCRIPTS}/vxgettext $vxa 2> /dev/null`;
		chomp($msg);
		$ENV{"LANG"}="C";
	}
	$msg=$_[0] if (!$msg);
	$msg=sprintf("V-%d-%d-%d $msg", $COMM{ORIGID}, $_[1], $_[2]) if ($FLAG{ADDUMI});
	# return $msg auto-wrapping at $COMM{TERMX}-length($MSG{INDENT}) chars
	$MSG{TR}="";
	@l=split(/^/,$msg);
	foreach $line(@l) {
		$fc=substr($line,0,1);
		@w=split(/ /,$line);
		$c = ($fc eq "\t") ? 7 : 0;
		foreach $word(@w) {
			$nm = ($word=~/\n/) ? 1 : 0;
			# $COMM{TPUT} characters are adding to the length()
			# stripping them is a mess so adding 5 to the screen
			# width is the best way to fake it out
			$tm+=5 if (($word=~/\p{IsC}/) && ($word!~/\n/));
			if (($c>15) && ($c+length($word)-$nm>=$COMM{TERMX}+$tm-length($MSG{INDENT}))) { 
				$MSG{TR}.="\n"; 
				$MSG{TR}.="\t\t" if (($fc eq "\t") || ($FLAG{TABLB}));
				$c = (($fc eq "\t") || ($FLAG{TABLB})) ? 15 : 0;
				$tm=0;
			}
			$word=" $word" if ($c>0);
			$c+=length($word);
			#$c=-5 if ($word=~/\p{IsC}/);
			$MSG{TR}.=$word;
		}
	}
	$COMM{LLCH}=$c;
	#$MSG{TR}=sprintf("$MSG{ERROR}:V-%d-%d-%d\n$MSG{TR}", $COMM{ORIGID}, $_[1], $_[2]) if ($FLAG{ADDUMI});
	return "$MSG{TR}";
}

# filter all duplicate entries from a list
sub _uniq {
	my(@a,$v);
	foreach $v(@_) { push(@a,$v) if (_list($v,@a)<0); }
	return \@a;
}

# print and log incluing UMI
sub _warn {
	$FLAG{ADDUMI}=1;
	_log(@_);
	_p($MSG{TR});
	$FLAG{ADDUMI}="";
}

# write a string to a file or append a file with a string
sub _writef {
	my($msg,$file,$new,$rd)=(@_);
	_log("$MSG{SETFILE} $file\n$msg", 20, 1008, "$MSG{SETFILE}", "$file", "$msg");
	$rd = ($new) ? ">" : ">>";
	open(WF,"$rd $file") or 
		_die("\n_writef cannot open $file", 20, 1009, "$file");
	print WF "$msg\n";
	close(WF);
}

# translate upper case to lower case
sub _tolower {
	my($str) = @_;
	
	$str =~ tr/A-Z/a-z/;
	return $str;
}

#
# example code for hiding an input password
# this uses all native perl code
#
sub _pwhide {
  my ($key,$passwd);
	while ($key ne "\n") {
    	system "stty", '-echo';
    	system "stty", 'icanon';
    
    	$key = getc(STDIN);
    
    
    	$passwd .= $key;
    	print "";
	}   

   	system "stty", 'echo';
   	system "stty", 'icanon';
   	system "stty", 'eol', '^@';  
#    print ("\nPassword = $passwd\n");
	return $passwd;
}

1;
sub _pkg_translate {
	my($fn);
	$fn = "_pkg_${PKG}_set_name";
	if (! defined( &$fn )) {
		_die("$PKG is an undefined package", 40, 1000, "$PKG");
	}
	&$fn(@_);
}

###
###  CAVEAT:  the "{OPTIONAL}" strings are *NOT* just strings.
###  They are *ALSO* a processing flag.  They tell CPI that it is to ask
###  the user if the package should be installed or not.  Therefore, certain
###  packages have the OPTIONAL string set optionally.
###

sub _pkg_VxPSP_set_name {
	$MSG{VxPSP}{NAME} = _tr("VERITAS PSP", 40, 1001);
}


sub _pkg_VxSMF_set_name {
	$MSG{VxSMF}{NAME} = _tr("VERITAS Service Management Framework", 40, 1002);
}

sub _pkg_VRTSalloc_set_name {
	$MSG{VRTSalloc}{NAME} = _tr("VERITAS Volume Manager Intelligent Storage Provisioning", 40, 1003);
}


sub _pkg_VRTSap_set_name {
	$MSG{VRTSap}{NAME}=_tr("VERITAS Action Provider", 40, 1004);
	$MSG{VRTSap}{OPTIONAL}=_tr("The VRTSap $MSG{PDFR} contains VERITAS Action Provider, which provides rules engine add-on for VERITAS Object Bus. Installing VRTSap enables support for SNMP Trap notifications and e-mails on alerts.", 40, 1005, "$MSG{PDFR}");
}


sub _pkg_VRTSat_set_name {
	$MSG{VRTSat}{NAME}=_tr("VERITAS Authentication Service", 40, 1006);
}

sub _pkg_VRTSatSDK_set_name {
        $MSG{VRTSatSDK}{NAME}=_tr("VERITAS Authentication SDK", 40, 1007);
}

sub _pkg_VRTSatClient_set_name {
        $MSG{VRTSatClient}{NAME}=_tr("VERITAS Authentication Client", 40, 1008);
}

sub _pkg_VRTSatServer_set_name {
        $MSG{VRTSatServer}{NAME}=_tr("VERITAS Authentication Server", 40, 1009);
}

sub _pkg_VRTSaz_set_name {
	$MSG{VRTSaz}{NAME}=_tr("VERITAS Authorization Service", 40, 1010);
}

sub _pkg_VRTSazSDK_set_name {
        $MSG{VRTSazSDK}{NAME}=_tr("VERITAS Authorization SDK", 40, 1011);
}

sub _pkg_VRTSazClient_set_name {
        $MSG{VRTSazClient}{NAME}=_tr("VERITAS Authorization Client", 40, 1012);
}

sub _pkg_VRTSazServer_set_name {
        $MSG{VRTSazServer}{NAME}=_tr("VERITAS Authorization Server", 40, 1013);
}

sub _pkg_VRTSazTQA_set_name {
        $MSG{VRTSazTQA}{NAME}=_tr("VERITAS Authorization Test and QA Packages", 40, 1014);
}

sub _pkg_VRTScavf_set_name {
	$MSG{VRTScavf}{NAME}=_tr("VERITAS Cluster Server Agents for Cluster File System", 40, 1015);
}


sub _pkg_VRTScfsdc_set_name {
	$MSG{VRTScfsdc}{NAME}=_tr("VERITAS Cluster File System Documentation", 40, 1016);
	$MSG{VRTScfsdc}{OPTIONAL}= _tr("The VRTScfsdc $MSG{PDFR} provides the following CFS documentation components:\n\n\tVERITAS Cluster File System Administration Guide\n\tVERITAS Cluster File System Installation Guide", 40, 1017, "$MSG{PDFR}");
}


sub _pkg_VRTScscm_set_name {
	$MSG{VRTScscm}{NAME}=_tr("VERITAS Cluster Server Cluster Manager", 40, 1018);
	$MSG{VRTScscm}{OPTIONAL}=_tr("Cluster Manager (Java Console) offers complete administration capabilities for your cluster. It enables you to monitor clusters and cluster objects, including service groups, systems, resources, and resource types.\n\nVERITAS recommends that you install Cluster Manager (Java Console) on systems that are not part of your cluster.", 40, 1019);
}


sub _pkg_VRTScscw_set_name {
	$MSG{VRTScscw}{NAME}=_tr("VERITAS Cluster Server Configuration Wizards", 40, 1020);
}


sub _pkg_VRTScsocw_set_name {
	$MSG{VRTScsocw}{NAME}=_tr("VERITAS Cluster Server Oracle 9i RAC Wizard", 40, 1021);
}


sub _pkg_VRTScspro_set_name {
	$MSG{VRTScspro}{NAME}=_tr("VERITAS Cluster Server VEA Provider", 40, 1022);
}


sub _pkg_VRTScssim_set_name {
	$MSG{VRTScssim}{NAME}=_tr("VERITAS Cluster Server Simulator", 40, 1023);
	$MSG{VRTScssim}{OPTIONAL}=_tr("Explanation of VERITAS Cluster Server Simulator", 40, 1024);
}


sub _pkg_VRTScutil_set_name {
	$MSG{VRTScutil}{NAME}=_tr("VERITAS Cluster Utilities", 40, 1025);
}


sub _pkg_VRTSd2doc_set_name {
	$MSG{VRTSd2doc}{NAME}=_tr("VERITAS Storage Foundation for DB2 Documentation", 40, 1026);
	$MSG{VRTSd2doc}{OPTIONAL}= _tr("The VRTSordoc $MSG{PDFR} provides the following SFDB2 documentation components:\n\n\tVERITAS Storage Foundation for DB2 Administration Guide\n\tVERITAS Storage Foundation for DB2 Installation Guide", 40, 1027, "$MSG{PDFR}");
}


sub _pkg_VRTSd2gui_set_name {
	$MSG{VRTSd2gui}{NAME}=_tr("VERITAS Storage Foundation Graphical User Interface for DB2", 40, 1028);
}


sub _pkg_VRTSdb2ed_set_name {
	$MSG{VRTSdb2ed}{NAME}=_tr("VERITAS Storage Foundation for DB2", 40, 1029);
}


sub _pkg_VRTSdbac_set_name {
	$MSG{VRTSdbac}{NAME}=_tr("VERITAS Oracle Real Application Cluster Support Package", 40, 1030);
}


sub _pkg_VRTSdbed_set_name {
	$MSG{VRTSdbed}{NAME}=_tr("VERITAS Storage Foundation for Oracle", 40, 1031);
}


sub _pkg_VRTSddlpr_set_name {
	$MSG{VRTSddlpr}{NAME} = _tr("VERITAS Device Discovery Layer Services Provider", 40, 1032);
}


sub _pkg_VRTSfppm_set_name {
	$MSG{VRTSfppm}{NAME}=_tr("VERITAS File Placement Policy Manager", 40, 1033);
}


sub _pkg_VRTSfsdoc_set_name {
	$MSG{VRTSfsdoc}{NAME}=_tr("VERITAS File System Documentation", 40, 1034);
	$MSG{VRTSfsdoc}{OPTIONAL}=_tr("The VRTSfsdoc $MSG{PDFR} provides the following VxFS documentation components:\n\n\tVxFS Administration Guide\n\tVxFS Installation Guide", 40, 1035, "$MSG{PDFR}");
}


sub _pkg_VRTSfsman_set_name {
	$MSG{VRTSfsman}{NAME}=_tr("VERITAS File System Manual Pages", 40, 1036);
	$MSG{VRTSfsman}{OPTIONAL}= _tr("The VRTSfsman $MSG{PDFR} provides man pages for VxFS commands", 40, 1037, "$MSG{PDFR}");
}


sub _pkg_VRTSfspro_set_name {
	$MSG{VRTSfspro}{NAME} =
		_tr("VERITAS File System Management Services Provider", 40, 1038);
}


sub _pkg_VRTSgab_set_name {
	$MSG{VRTSgab}{NAME}=_tr("VERITAS Group Membership and Atomic Broadcast", 40, 1039);
}


sub _pkg_VRTSglm_set_name {
	$MSG{VRTSglm}{NAME}=_tr("VERITAS Group Lock Manager", 40, 1040);
}


sub _pkg_VRTSgms_set_name {
	$MSG{VRTSgms}{NAME}=_tr("VERITAS Group Messaging Services", 40, 1041);
}


sub _pkg_VRTSjre_set_name {
	$MSG{VRTSjre}{NAME}=_tr("VERITAS Java Runtime Environment Redistribution", 40, 1042);
}


sub _pkg_VRTSllt_set_name {
	$MSG{VRTSllt}{NAME}=_tr("VERITAS Low Latency Transport", 40, 1043);
}


sub _pkg_VRTSob_set_name {
	$MSG{VRTSob}{NAME}=_tr("VERITAS Enterprise Administrator Service", 40, 1044);
}


sub _pkg_VRTSobadmin_set_name {
	$MSG{VRTSobadmin}{NAME}=_tr("VERITAS Enterprise Administration", 40, 1045);
}


sub _pkg_VRTSobgui_set_name {
	$MSG{VRTSobgui}{NAME}=_tr("VERITAS Enterprise Administrator", 40, 1046);
	$MSG{VRTSobgui}{OPTIONAL}=_tr("VERITAS Enterprise Administrator is an infrastructure that provides the runtime environment for graphical user interfaces", 40, 1047);
}


sub _pkg_VRTSodm_set_name {
	$MSG{VRTSodm}{NAME}=_tr("VERITAS Oracle Disk Manager", 40, 1048);
}


sub _pkg_VRTSordoc_set_name {
	$MSG{VRTSordoc}{NAME}=_tr("VERITAS Storage Foundation for Oracle Documentation", 40, 1049);
	$MSG{VRTSordoc}{OPTIONAL}= _tr("The VRTSordoc $MSG{PDFR} provides the following SFORA documentation components:\n\n\tVERITAS Storage Foundation for Oracle Administration Guide\n\tVERITAS Storage Foundation for Oracle Installation Guide", 40, 1050, "$MSG{PDFR}");
}


sub _pkg_VRTSorgui_set_name {
	$MSG{VRTSorgui}{NAME}=_tr("VERITAS Storage Foundation Graphical User Interface for Oracle", 40, 1051);
}


sub _pkg_VRTSperl_set_name {
	$MSG{VRTSperl}{NAME}=_tr("VERITAS Perl 5.8.0 Redistribution", 40, 1052);
}


sub _pkg_VRTSracdc_set_name {
	$MSG{VRTSracdc}{NAME}=_tr("VERITAS RAC dc", 40, 1053);
}


sub _pkg_VRTSsal_set_name {
	$MSG{VRTSsal}{NAME}=_tr("VERITAS SAN Access Layer", 40, 1054);
}

sub _pkg_VRTScccfg_set_name {
        $MSG{VRTScccfg}{NAME}=_tr("VERITAS Command Central Configuration Utility", 40, 1055);
}

sub _pkg_VRTSccss_set_name {
        $MSG{VRTSccss}{NAME}=_tr("VERITAS Command Central Storage Server", 40, 1056);
}

sub _pkg_VRTSccsa_set_name {
        $MSG{VRTSccsa}{NAME}=_tr("VERITAS Command Central Storage Agent", 40, 1057);
}

sub _pkg_VRTSccsw_set_name {
        $MSG{VRTSccsw}{NAME}=_tr("VERITAS Command Central Storage Web Interface", 40, 1058);
}

sub _pkg_VRTSamccs_set_name{
        $MSG{VRTSamccs}{NAME}=_tr("VERITAS Command Central Alert Manager", 40, 1059);
}

sub _pkg_VRTSdbms_set_name {
        $MSG{VRTSdbms}{NAME}=_tr("VERITAS Database Management Server", 40, 1060);
}

sub _pkg_VRTSsmcfg_set_name {
	$MSG{VRTSsmcfg}{NAME}=_tr("VERITAS Storage Manager for Storage Networks Configuration Utility", 40, 1061);
}


sub _pkg_VRTSvail_set_name {
        $MSG{VRTSvail}{NAME} = _tr("VERITAS Array Providers", 40, 1062);
}

sub _pkg_VRTSsmqdc_set_name {
	$MSG{VRTSsmqdc}{NAME}=_tr("VERITAS Storage Manager for Storage Networks Quickstart Documentation", 40, 1063);
	$MSG{VRTSsmqdc}{OPTIONAL}=_tr("The VRTSsmqdc package provides the following Storage Manager for Storage Networks QuickStart (SMSNQS) documentation components:\n\nSMSNQS Installation and Configuration Guide\nSMSNQS Overview Guide\nSMSNQS Release Notes", 40, 1064);
}


sub _pkg_VRTSsmqmn_set_name {
	$MSG{VRTSsmqmn}{NAME}=_tr("VERITAS Storage Manager for Storage Networks Quickstart Manual Pages", 40, 1065);
	$MSG{VRTSsmqmn}{OPTIONAL}=_tr("The VRTSsmqmn package provides man pages for SMSNQS commands.", 40, 1066);
}


sub _pkg_VRTSsmqs_set_name {
	$MSG{VRTSsmqs}{NAME}=_tr("VERITAS Storage Manager for Storage Networks QuickStart", 40, 1067);
}


sub _pkg_VRTSsragt_set_name {
	$MSG{VRTSsragt}{NAME}=_tr("VERITAS Storage Reporter Agents", 40, 1068);
}


sub _pkg_VRTSsybed_set_name {
	$MSG{VRTSsybed}{NAME}=_tr("VERITAS Storage Foundation for Sybase", 40, 1069);
}


sub _pkg_VRTSsydoc_set_name {
	$MSG{VRTSsydoc}{NAME}=_tr("VERITAS Storage Foundation for Sybase Documentation", 40, 1070);
	$MSG{VRTSsydoc}{OPTIONAL}= _tr("The VRTSsydoc $MSG{PDFR} provides the following SFSYB documentation components:\n\n\tVERITAS Storage Foundation for Sybase Administration Guide\n\tVERITAS Storage Foundation for Sybase Installation Guide", 40, 1071, "$MSG{PDFR}");
}


sub _pkg_VRTStd_set_name {
	$MSG{VRTStd}{NAME} = _tr("VERITAS Traffic Director (Core Software)", 40, 1072);
}


sub _pkg_VRTStddoc_set_name {
	$MSG{VRTStddoc}{NAME} = _tr("VERITAS Traffic Director (Documentation)", 40, 1073);
}


sub _pkg_VRTStdw_set_name {
	$MSG{VRTStdw}{NAME} = _tr("VERITAS Traffic Director (Web GUI)", 40, 1074);
}


sub _pkg_VRTStep_set_name {
	$MSG{VRTStep}{OPTIONAL}=_tr("The VRTStep $MSG{PDFR} contains VERITAS Task Exec Provider, which provides command execution add-on for VERITAS Object Bus. Installing VRTStep and VRTSap enables support of command execution in response to an alert.", 40, 1075, "$MSG{PDFR}"); 
	$MSG{VRTStep}{NAME}=_tr("VERITAS Task Provider", 40, 1076);

}


sub _pkg_VRTSvcsApache_set_name {
	$MSG{VRTSvcsApache}{NAME}=_tr("VERITAS Cluster Server Apache Agent", 40, 1077);
	$MSG{VRTSvcsApache}{OPTIONAL}=_tr("The Apache agent of VERITAS Cluster Server. If you configure VCS through installer the type definition of Apache agent will get included in the configuration. Otherwise you need to add the same manually. Please refere documents for details.", 40, 1078); 
}


sub _pkg_VRTSvcs_set_name {
	$MSG{VRTSvcs}{NAME}=_tr("VERITAS Cluster Server", 40, 1079);
}


sub _pkg_VRTSvcsag_set_name {
	$MSG{VRTSvcsag}{NAME}=_tr("VERITAS Cluster Server Bundled Agents", 40, 1080);
}


sub _pkg_VRTSvcsdc_set_name {
	$MSG{VRTSvcsdc}{NAME}=_tr("VERITAS Cluster Server Documentation", 40, 1081);
	if ($COMM{OS} eq "SunOS") {
		$MSG{VRTSvcsdc}{OPTIONAL}=_tr("The VRTSvcsdc $MSG{PDFR} provides the following VCS documentation components:\n\n\tVCS User's Guide\n\tVCS Installation Guide\n\tVCS Bundled Agents Reference Guide\n\tVCS Agent Developer's Guide\n\tVCS Replicated Data Cluster Appnote\n\tVCS with Sun A3x00, A5000, and E10000 Appnotes", 40, 1082, "$MSG{PDFR}");
	} elsif (($COMM{OS} eq "AIX") || ($COMM{OS} eq "Linux")) {
		$MSG{VRTSvcsdc}{OPTIONAL}=_tr("This package provides the following VCS documentation components:\n\n\tVCS User's Guide\n\tVCS Installation Guide\n\tVCS Bundled Agents Reference Guide\n\tVCS Agent Developer's Guide\n\tVCS Replicated Data Cluster Appnote", 40, 1083);
	}
}


sub _pkg_VRTSvcsmg_set_name {
	$MSG{VRTSvcsmg}{NAME}=_tr("VERITAS Cluster Server Message Catalogs", 40, 1084);
}


sub _pkg_VRTSvcsmn_set_name {
	$MSG{VRTSvcsmn}{NAME}=_tr("VERITAS Cluster Server Man Pages", 40, 1085);
	$MSG{VRTSvcsmn}{OPTIONAL}=_tr("The VRTSvcsmn $MSG{PDFR} provides man pages for VCS commands", 40, 1086, "$MSG{PDFR}");
}


sub _pkg_VRTSvcsor_set_name {
	$MSG{VRTSvcsor}{NAME}=_tr("VERITAS Cluster Server Oracle Enterprise Extension", 40, 1087);
}


sub _pkg_VRTSvcsvp_set_name {
	$MSG{VRTSvcsvp}{NAME}=_tr("VERITAS Cluster Server VP", 40, 1088);
}


sub _pkg_VRTSvcsvr_set_name {
	$MSG{VRTSvcsvr}{NAME}=_tr("VERITAS Cluster Server VVR Agent", 40, 1089);
}


sub _pkg_VRTSvcsw_set_name {
	$MSG{VRTSvcsw}{NAME}=_tr("VERITAS Cluster Manager (Web Console)", 40, 1090);
}


sub _pkg_VRTSvmdoc_set_name {
	$MSG{VRTSvmdoc}{NAME}=_tr("VERITAS Volume Manager Documentation", 40, 1091);
	$MSG{VRTSvmdoc}{OPTIONAL}=_tr("The VRTSvmdoc $MSG{PDFR} provides the following VM documentation components:\n\n\tVM Administrator's Guide\n\tVM Installation Guide\n\tVM Troubleshooting Guide\n\tFlashSnap Point-in-Time Copy Solutions Administrator's Guide\n\tVM Hardware Notes\n\tVM Storage Allocator Administrator's Guide\n\tVM Cross-Platform Data Sharing Administrator's Guide", 40, 1092, "$MSG{PDFR}");
}


sub _pkg_VRTSvmman_set_name {
	$MSG{VRTSvmman}{OPTIONAL}=_tr("The VRTSvmman $MSG{PDFR} provides man pages for Volume Manager and its licensable features.", 40, 1093, "$MSG{PDFR}");
	$MSG{VRTSvmman}{NAME} = _tr("VERITAS Volume Manager Manual Pages", 40, 1094);
}


sub _pkg_VRTSvmpro_set_name {
	$MSG{VRTSvmpro}{NAME} = _tr("VERITAS Volume Manager Management Services Provider", 40, 1095);
}


sub _pkg_VRTSvrdoc_set_name {
	$MSG{VRTSvrdoc}{OPTIONAL}=_tr("The VRTSvrdoc $MSG{PDFR} contains the following VVR documentation components:\n\n\tVVR Administrator's Guide\n\tVVR Configuration Notes\n\tVCS Enterprise Agent for VVR Installation and Configuration Guide\n\tVRW Administrator's Guide.", 40, 1096, "$MSG{PDFR}");
	$MSG{VRTSvrdoc}{NAME}=_tr("VERITAS Volume Replicator (user documentation)", 40, 1097);
}


sub _pkg_VRTSvrpro_set_name {
	$MSG{VRTSvrpro}{NAME}=_tr("VERITAS Volume Replicator Client Extension and Provider for \n\t	 VERITAS Enterprise Administrator", 40, 1098);
}


sub _pkg_VRTSvrw_set_name {
	$MSG{VRTSvrw}{OPTIONAL}=_tr("The VRTSvrw $MSG{PDFR} is a Web-based graphical user interface replication tool, that enables you to create, manage, and administer VVR configurations using a Web browser.", 40, 1099, "$MSG{PDFR}");
	$MSG{VRTSvrw}{NAME}=_tr("VERITAS Volume Replicator Web Console", 40, 1100);
	#$MSG{VRTSvrw}{NAME}=_tr("VERITAS Volume Replicator Web Console\n\t\tInstalling VRTSvrw will also install VRTSjre and VRTSweb;\n\t\tif they are not yet installed.");
}


sub _pkg_VRTSvxfen_set_name {
	$MSG{VRTSvxfen}{NAME}=_tr("VERITAS I/O Fencing", 40, 1101);
		if ($UPI ne "SFCFS") {
			$MSG{VRTSvxfen}{OPTIONAL}=_tr("The VERITAS I/O Fencing module is designed to prevent data corruption in the case of split-brain condition in VCS. You must refer to the VCS documentation for hardware requirements and manual configuration procedures in order to use this module.", 40, 1102);
			if ($COMM{OS} eq "SunOS") {
				$MSG{VRTSvxfen}{OPTIONAL}.=_tr("\n\nThe VRTSvxfen package is only supported on Solaris 8 and Solaris 9 and not installed on prior versions.", 40, 1103);
			}
		}
}


sub _pkg_VRTSvxfs_set_name {
	$MSG{VRTSvxfs}{NAME}=_tr("VERITAS File System", 40, 1104);
}


sub _pkg_VRTSvxmsa_set_name {
	$MSG{VRTSvxmsa}{NAME}=_tr("VERITAS Mapping Service, Application Libraries", 40, 1105);
}


sub _pkg_VRTSvxvm_set_name {
	$MSG{VRTSvxvm}{NAME} = _tr("VERITAS Volume Manager Binaries", 40, 1106);
}


sub _pkg_VRTSweb_set_name {
	$MSG{VRTSweb}{NAME}=_tr("VERITAS Java Web Server", 40, 1107);
}


sub _pkg_WindowsClusterManager_set_name {
	$MSG{WindowsClusterManager}{NAME}=_tr("VERITAS Windows Cluster Manager", 40, 1108);
}


sub _pkg_WindowsSimulator_set_name {
	$MSG{WindowsSimulator}{NAME}=_tr("VERITAS Windows Simulator", 40, 1109);
}


sub _pkg_WindowsWebConsole_set_name {
	$MSG{WindowsWebConsole}{NAME}=_tr("VERITAS Windows Web Console", 40, 1110);
}

1;
# All UPI's which should show up on rti menu
$COMM{MUPIS1}=[ qw(AT AZ) ];
$COMM{MUPIS2}=[ qw(SFCFS SFRAC VEAG) ];

$PROD{FS}{TRAINDIR}="file_system";
$PROD{SF}{TRAINDIR}="storage_foundation";
$PROD{SFDB2}{TRAINDIR}="storage_foundation_for_db2";
$PROD{SFORA}{TRAINDIR}="storage_foundation_for_oracle";
$PROD{VM}{TRAINDIR}="volume_manager";
$PROD{VVR}{TRAINDIR}="volume_replicator";
$PROD{VCS}{TRAINDIR}="cluster_server";
$PROD{TD}{TRAINDIR}="traffic_director";
$PROD{SMQS}{TRAINDIR}="storage_manager_quickstart";
$PROD{SFCFS}{TRAINDIR}="storage_foundation_cluster_file_system";
$PROD{SFRAC}{TRAINDIR}="storage_foundation_for_oracle_rac";
$PROD{AT}{TRAINDIR}="authentication";
$PROD{AZ}{TRAINDIR}="authorization";
$PROD{ICS}{TRAINDIR}="infrastructure_core_services";
$PROD{PBX}{TRAINDIR}="private_branch_exchange";
$PROD{SMF}{TRAINDIR}="service_management_framework";

$PROD{AT}{CD}=1;
$PROD{AZ}{CD}=1;
$PROD{ICS}{CD}=1;
$PROD{SMF}{CD}=1;
$PROD{PBX}{CD}=1;
$PROD{FS}{CD}=1;
$PROD{SF}{CD}=1;
$PROD{SFDB2}{CD}=1;
$PROD{SFORA}{CD}=1;
$PROD{VM}{CD}=1;
$PROD{VVR}{CD}=1;
$PROD{VCS}{CD}=1;
$PROD{TD}{CD}=1;

$PROD{SMQS}{CD}=2;

$PROD{SF}{VILNAME}="Storage Foundation";
$PROD{ICS}{VILNAME}="Infrastructure Core Services";

$PROD{SF}{MENUNAME}="Storage Foundation (QuickStart, Standard, Standard HA, Enterprise, Enterprise HA, and VVR Option)";
$PROD{FS}{MENUNAME}="File System (FlashSnap Option)";
$PROD{VM}{MENUNAME}="Volume Manager (FlashSnap Option, VVR Option)";
$PROD{SFORA}{MENUNAME}="Storage Foundation for Oracle (Standard, Enterprise, Enterprise HA, VVR Option)";
$PROD{SFDB2}{MENUNAME}="Storage Foundation for DB2 (Standard, Enterprise, Enterprise HA, VVR Option)";
$PROD{SFSYB}{MENUNAME}="Storage Foundation for Sybase (HA, FlashSnap Option, VVR Option)";
$PROD{AT}{MENUNAME}="VERITAS Authentication Service";
$PROD{AZ}{MENUNAME}="VERITAS Authorization Service";
$PROD{SMF}{MENUNAME}="VERITAS Service Management Framework";
$PROD{PBX}{MENUNAME}="VERITAS Private Branch Exchange";

sub _rti_menu {
	my (@mk,@mo,@ms,$bs,$cv,$iv,$key,$lic,$m,$menu,$mkey,$n,$name,$pl,$rlic,$task,$ts,$tsl,$upi);
	_comm_initiation("RTI");
	_rti_set_msgs();
	$COMM{MUPIS} = (-d "./$PROD{SFRAC}{TRAINDIR}") ? $COMM{MUPIS2} : $COMM{MUPIS1};
	while (1) {
		#@mo=@ms=qw(INSTALL CONFIG LICENSE PRECHECK UNINSTALL DESC QUIT HELP);
		@mo=@ms=qw(INSTALL CONFIG LICENSE PRECHECK UNINSTALL DESC QUIT);
		$iv=_plat_sub("get_instpkgvers",$COMM{LICPKG});
		if (!iv) {
			# offer to install VRTSvlic here
		} else {
			$PKGI{$PKG}{MVERS}=_plat_sub("get_mediapkgvers") if (!$PKGI{$PKG}{$LOCAL}{MVERS});
			$cv=_cv($iv,$PKGI{$PKG}{MVERS});
			if ($cv==2) {
				# offer to upgrade VRTSvlic here
			}
		}
		if (1) {
			$rlic=_comm_check_license();
			foreach $upi(@{$COMM{MUPIS}}) { 
				$iv=_plat_sub("get_instpkgvers",$PROD{$upi}{$LOCAL}{MAINPKG});
				$COMM{$upi}{IVERS} = ($iv) ? $iv : "no";
			}
			_title();
			$bs = "%-50s%-16s%-s";
			$pl=sprintf("%-44s%-20s%-s", $MSG{VENDORPR}, $MSG{VERSINST}, $MSG{LICENSED});
			_bpl($pl);
			print "===========================================================================\n";
			foreach $upi(@{$COMM{MUPIS}}) { 
				$name = $PROD{$upi}{VILNAME} ? $PROD{$upi}{VILNAME} : $PROD{$upi}{NAME};
				$name=~s/^VERITAS // if (_list($upi,@{$COMM{LUPIS}})>=0);
				$lic = ($COMM{MLIC}{$upi}) ? "yes" : (_list($upi,@{$COMM{NOPL}})<0) ? "no" : "";
				# here is the big "What do we do?" hack for SF
				# How do you actually tell it is installed 
				# since if has no unique component
				# the best answer is SF version = VM version if
				# SF is licensed, VM and FS are installed.
				# Please update # once somebody comes up with 
				# a better plan
				$COMM{SF}{IVERS}=$COMM{VM}{IVERS} if (($upi eq "SF") && ($COMM{VM}{IVERS}) && ($COMM{FS}{IVERS}) && ($lic eq "yes"));
				$pl=sprintf($bs, $name, $COMM{$upi}{IVERS}, $lic);
				_pl($pl);
			}
		} else {
			sleep 2;
			_title();
			_pl("$MSG{VENDOR} Licensing utilities are not installed on this system", 30, 1000, "$MSG{VENDOR}");
		}
		$tsl="";
		undef(@mk);
		_bpl("\nSelection Menu:\n", 30, 1001);
		while(@mo) {
			print "$MSG{INDENT}";
			foreach $n(1..2) {
				$m=shift(@mo);
				last if (!$m);
				$mkey=uc($MSG{"$m\KEY"});
				push(@mk,$mkey);
				print "$COMM{TPUT}{BS}$mkey$COMM{TPUT}{BE}) $MSG{MENU}{$m}";
				foreach $m(length($MSG{MENU}{$m})..24) { print " "; }
			}
			print "\n";
		}
		_p();
		$ts="";
		$tsl=join(",",@mk);
		$tsl="[$tsl]";
		while (_list($ts,@mk)<0) {
			$ts=_ask("Enter a Selection: $tsl", 30, 1002, "$tsl");
			$ts=uc($ts);
		}
		if ($ts eq $MSG{HELPKEY}) { _rti_menu_help(); next; }
		_title();
		$COMM{MENU}=[];
		foreach $upi(@{$COMM{MUPIS}}) { 
			next if ((_list($upi,@{$COMM{NOPL}})>=0) &&
				(($ts =~ /^$MSG{CONFIGKEY}$/i) || 
				($ts =~ /^$MSG{LICENSEKEY}$/i) || 
				($ts =~ /^$MSG{PRECHECKKEY}$/i))); 
			$n = ($PROD{$upi}{MENUNAME}) ? $PROD{$upi}{MENUNAME} : $PROD{$upi}{NAME};
			$n="VERITAS $n" unless ($n=~/VERITAS/);
			push(@{$COMM{MENU}},$n); 
		}
		$COMM{BACK}=1;
		#$MSG{HELP}=_tr("menu help");
		if ($ts =~ /^$MSG{INSTALLKEY}$/i) {
			$task="install";
			$menu=_menu("Select a product to install:", 30, 1003);
		} elsif ($ts =~ /^$MSG{CONFIGKEY}$/i) {
			$task="configure";
			$menu=_menu("Select a product to configure:", 30, 1004);
		} elsif ($ts =~ /^$MSG{LICENSEKEY}$/i) {
			$task="license";
			$menu=_menu("Select a product to license:", 30, 1005);
		} elsif ($ts =~ /^$MSG{PRECHECKKEY}$/i) {
			$task="precheck";
			$menu=_menu("Select a product to perform a pre-installation check for???", 30, 1006);
		} elsif ($ts =~ /^$MSG{DESCKEY}$/i) {
			$menu=_menu("Select a product to view a product description of???", 30, 1007);
		} elsif ($ts =~ /^$MSG{UNINSTALLKEY}$/i) {
			$OPT{INSTALL}="";
			$task="uninstall";
			$menu=_menu("Select a product to uninstall", 30, 1008);
		}
		next if ($menu =~ /^$MSG{BACKKEY}$/i);
		$upi=${$COMM{MUPIS}}[$menu-1];
		if ($ts =~ /^$MSG{DESCKEY}/i) {
			_rti_product_description($upi);
		} elsif (($task eq "install") && (! -d "./$PROD{$upi}{TRAINDIR}")) {
			_pl("\n$PROD{$upi}{NAME} must be installed using VERITAS Infrastructure Core Services CD$PROD{$upi}{CD}", 30, 1009, "$PROD{$upi}{NAME}", "$PROD{$upi}{CD}");
			_prtc();
		} else {
			_comm_cpi($upi,$task);
		}
	}
}

sub _rti_menu_help {
	_pl("_rti_menu_help", 30, 1010);
	_prtc();
}

sub _rti_product_description {
	my ($upi)=(@_);
	_pl("\n$MSG{$upi}{DESC}", 30, 1011, "$MSG{$upi}{DESC}");
	my $n=1;
	while ($MSG{$upi}{"DESC$n"}) { _pl("\n$MSG{$upi}{\"DESC$n\"}"); $n++; }
	_prtc();
}

sub _rti_set_msgs {
        $MSG{VENDORPR}=_tr("VERITAS Product", 30, 1012);
        $MSG{VERSINST}=_tr("Version Installed", 30, 1013);
        $MSG{LICENSED}=_tr("Licensed", 30, 1014);
        $MSG{MENU}{INSTALL}=_tr("Install a Product", 30, 1015);
        $MSG{MENU}{CONFIG}=_tr("Configure an Installed Product", 30, 1016);
        $MSG{MENU}{LICENSE}=_tr("License a Product", 30, 1017);
        $MSG{MENU}{PRECHECK}=_tr("Perform a Pre-Installation Check", 30, 1018);
        $MSG{MENU}{UNINSTALL}=_tr("Uninstall a Product", 30, 1019);
        $MSG{MENU}{DESC}=_tr("View a Product Description", 30, 1020);
        $MSG{MENU}{QUIT}=_tr("Quit", 30, 1021);
        $MSG{MENU}{HELP}=_tr("Help", 30, 1022);
	$MSG{SFRAC}{DESC}=_tr("VERITAS Storage Foundation for Oracle9i/RAC is an integrated suite of industry-leading VERITAS storage management and high-availability software, engineered specifically to improve performance, availability, and manageability of Real Application Cluster (RAC) environments. DBE/AC delivers a flexible solution that makes it simple to deploy and manage RAC, and is certified by Oracle.", 30, 1023);
	$MSG{SFDB2}{DESC}=_tr("Description for VERITAS Storage Foundation for DB2", 30, 1024);
	$MSG{INFR}{DESC}=_tr("Description for VERITAS Infrastructure Packages", 30, 1025);
	$MSG{VEAG}{DESC}=_tr("Description for VERITAS Enterprise Administrator GUI", 30, 1026);
	$MSG{SFORA}{DESC}=_tr("VERITAS Storage Foundation for Oracle offers raw device performance with the manageability of the VERITAS File System, online administration of storage, and the flexibility of storage hardware independence in addition to providing key storage virtualization capabilities - the ability to manage logical pools of storage rather than physical storage devices.", 30, 1027);
	$MSG{SFORA}{DESC1}=_tr("VERITAS Storage Foundation for Oracle - Standard is the optimal foundation for managing Oracle Standard Foundation on entry-level servers. By offering extensive storage management capabilities to a full range of users, VERITAS Storage Foundation for Oracle anticipates the eventual growth needs of every business.", 30, 1028);
	$MSG{SFORA}{DESC2}=_tr("VERITAS Storage Foundation for Oracle - Enterprise offers the flexibility to incorporate additional options. As database capacity grows and storage management increases in importance, the Enterprise version of VERITAS Storage Foundation for Oracle provides the ability to expand to meet those necessities.", 30, 1029);
	$MSG{SFORA}{DESC3}=_tr("VERITAS Storage Foundation HA for Oracle - Enterprise includes all the capabilities of the VERITAS Storage Foundation for Oracle while adding a high-availability environment to ensure the continuous information access critical to enterprise-level commerce.", 30, 1030);
	$MSG{FS}{DESC}=_tr("VERITAS File System is a powerful, quick-recovery, journaling file system that provides the high performance and easy management required by mission critical applications. It delivers scalable performance and provides continuous availability, increased I/O, and up-to-date structural integrity.", 30, 1031);
        $MSG{SF}{DESC}=_tr("VERITAS Storage Foundation combines the industry-leading technologies of VERITAS Volume Manager and VERITAS File System to deliver powerful, online storage management, optimal performance tuning, and sophisticatedmanagement capabilities to ensure continuous availability of mission-critical data. Additionally, VERITAS Storage Foundation includes VERITAS Storage Manager QuickStart, which is a limited version of VERITAS Storage Manager providing discovery and visualization of the SAN and its components, as well as the correlation of remote hosts and their resources.", 30, 1032);
	$MSG{SF}{DESC1}=_tr("VERITAS Storage Foundation QuickStart (FST-QS) offers a limited-function version of VERITAS Storage Foundation for entry-level servers.  VERITAS Storage Foundation QuickStart includes basic versions of VERITAS Volume Manager and VERITAS File System. FST-QS provides journal-based fast recovery, high performance, on-line management of volumes, and mirroring for boot drives. You can upgrade FST-QS to the feature-complete VERITAS Storage Foundation with an additional license.", 30, 1033);
	$MSG{SF}{DESC2}=_tr("VERITAS Storage Foundation HA adds VERITAS Cluster Server for high availability, multi-node management. It also includes the same bundled agents for File System and Volume Manager as those typically included in VCS.", 30, 1034);	
	$MSG{SFCFS}{DESC}=_tr("VERITAS Storage Foundation for Clustered File System extends VERITAS File System and VERITAS Volume Manager to support shared data in a SAN environment. Using VERITAS Storage Foundation for Clustered File System, multiple servers can access shared storage and files, transparently to the applications and concurrently with each other.", 30, 1035);
	$MSG{SFCFS}{DESC1}=_tr("VERITAS Storage Foundation for Clustered File System HA adds the full functionality of VERITAS Cluster Server, and features the power and flexibility to protect everything from a single critical database instance to very large multi-application clusters in networked storage environments. In addition, increased automation and intelligent workload management allow cluster administrators to maximize individual resources by moving beyond reactive recovery to proactive management of availability and performance.", 30, 1036);
	$MSG{TD}{DESC}=_tr("VERITAS Traffic Director is a new option for VERITAS Cluster Server that provides availability through traffic load balancing by directing TCP/IP and UDP/IP traffic to multiple backend servers.", 30, 1037);
	$MSG{VCS}{DESC}=_tr("VERITAS Cluster Server, the industry's leading open systems clustering solution, is ideal for eliminating both planned and unplanned downtime, facilitating server consolidation, and effectively managing a wide range of applications in heterogeneous environments.", 30, 1038);
        $MSG{VM}{DESC}=_tr("VERITAS Volume Manager provides easy-to-use, online storage management tools, which reduce planned and unplanned downtime. Volume Manager removes the physical limitations of disk storage, so you can configure, share, manage and optimize storage I/O performance online without interrupting data availability.", 30, 1039);
	$MSG{VVR}{DESC}=_tr("VERITAS Volume Replicator provides the foundation for seamless availability across sites. Based on the de facto industry-standard VERITAS Volume Manager, VERITAS Volume Replicator reliably, efficiently, effectively and consistently replicates data to remote locations over any standard IP network for maximum business continuity.", 30, 1040);
	$MSG{VEAG}{DESC}=_tr("VERITAS Enterprise Administrator is an infrastructure that provides the runtime environment for graphical user interfaces", 30, 1041);
  $MSG{AT}{DESC}=_tr("VERITAS Authentication Service validates identities and thus forms the basis for authorization and access control. It also provides libraries that can be used for protecting channels between VERITAS application services through message integrity and confidentiality services.", 30, 1042);
  $MSG{AZ}{DESC}=_tr("VERITAS Authorization Service determines whether specific principals have the authority to perform specific tasks on specific resources being protected by VERITAS Security Subsystem.", 30, 1043);
  $MSG{PBX}{DESC}=_tr("PBX or Private Branch Exchange provides single-port access to clients outside the firewall connecting to various services offered by VERITAS products.", 30, 1044);
  $MSG{SMF}{DESC}=_tr("Veritas Service Management Framework provides a framework for running and managing application services. A service is a dynamically loadable module (DLL on Windows, SO on UNIX) that provides some application-specific purpose. The framework is not aware or concerned with what the service actually does.", 30, 1045);
  $MSG{ICS}{DESC}=_tr("Veritas Infrastructure Core Services are the core services required by VERITAS products.", 30, 1046);

}

1;

# Define frequently referenced paths

# Define product information
$PKGI{ICS}{SPACE}=[36000,300,300,30];
$PROD{ICS}{NAME}="VERITAS Infrastructure Core Services";
$PROD{ICS}{UGVERS}= ALL;
#$PROD{ICS}{HOMEDIR}="/opt/VRTSics";
$PROD{ICS}{CONFIG}=1;
$PROD{ICS}{PKGS}=["VRTSpbx","VRTSat","VRTSsmf","VRTSaz"];
$PROD{ICS}{ABBR}="ICS";
$PROD{ICS}{VERSION}="1.2.2.4";
$PROD{PBX}{VERSION}="1.2.2.9";
$PROD{SMF}{VERSION}="1.2.1.30";
$PROD{AT}{VERSION}="4.2.2.6";
$PROD{AZ}{VERSION}="4.2.2.6";


sub _ics_comm_preinstall {
#This is a forward order operation
	_prod_plat_sub("PBX", "preinstall");
	_prod_plat_sub("AT", "preinstall");
	_prod_plat_sub("SMF", "preinstall");
	_prod_plat_sub("AZ", "preinstall");
}

sub _ics_comm_pkgrequest_questions 
{
#This is a forward order operation
	_title();
	_bpl("$PROD{PBX}{NAME} Package Installation questions", 250, 1000, "$PROD{PBX}{NAME}");
        _prod_plat_sub_target("PBX", "pkgrequest_questions");
	_title();
	_bpl("$PROD{AT}{NAME} Package Installation questions", 250, 1000, "$PROD{AT}{NAME}");
        _prod_plat_sub_target("AT", "pkgrequest_questions");
	_title();
	_bpl("$PROD{SMF}{NAME} Package Installation questions", 250, 1000, "$PROD{SMF}{NAME}");
        _prod_plat_sub_target("SMF", "pkgrequest_questions");
	_title();
	_bpl("$PROD{AZ}{NAME} Package Installation questions", 250, 1000, "$PROD{AZ}{NAME}");
        _prod_plat_sub_target("AZ", "pkgrequest_questions");
}
sub _ics_comm_stop_processes {
#This is a reverse order operation
	my($pid);

	_pb1("Stopping VRTSaz processes", 250, 1001);
	$pid=_comm_get_pid("vxazd"); 
	while ($pid) {
			_comm_kill_proc("vxazd",$pid);
			$pid=_comm_get_pid("vxazd");
	}
	_pb2("Done", 250, 1002);


	_pb1("Stopping VRTSsmf processes", 250, 1003);
	$pid=_comm_get_pid("VxSMF"); 
	while ($pid) {
			_comm_kill_proc("VxSMF",$pid);
			$pid=_comm_get_pid("VxSMF");
	}
	_pb2("Done", 250, 1002);

	_pb1("Stopping VRTSat processes", 250, 1004);
	$pid=_comm_get_pid("vxatd"); 
	while ($pid) {
			_comm_kill_proc("vxatd",$pid);
			$pid=_comm_get_pid("vxatd");
	}
	_pb2("Done", 250, 1002);

	_pb1("Stopping VRTSpbx processes", 250, 1005);
	$pid=_comm_get_pid("pbx_exchange"); 
	while ($pid) {
			_comm_kill_proc("pbx_exchange",$pid);
			$pid=_comm_get_pid("pbx_exchange");
	}
	_pb2("Done", 250, 1002);

}


sub _ics_comm_postinstall_questions 
{
#This is a forward order operation
	_title();
	_bpl("$PROD{PBX}{NAME} Package Configuration questions", 250, 1006, "$PROD{PBX}{NAME}");
	&_pbx_comm_postinstall_questions;

	_title();
	_bpl("$PROD{AT}{NAME} Package Configuration questions", 250, 1006, "$PROD{AT}{NAME}");
	&_at_comm_postinstall_questions;

	_title();
	_bpl("$PROD{SMF}{NAME} Package Configuration questions", 250, 1006, "$PROD{SMF}{NAME}");
	&_smf_comm_postinstall_questions;


	_title();
	_bpl("$PROD{AZ}{NAME} Package Configuration questions", 250, 1006, "$PROD{AZ}{NAME}");
	&_az_comm_postinstall_questions;

}
sub _ics_comm_create_configfiles
{
	&_pbx_comm_create_configfiles;
	&_at_comm_create_configfiles;
	&_smf_comm_create_configfiles;
	&_az_comm_create_configfiles;
}
sub _ics_comm_preremove
{
 &_az_check_before_remove;
}
1;

# Define frequently referenced paths

# Define product information
$PKGI{PBX}{NAME}="VERITAS Private Branch Exchange";
$PKGI{PBX}{SPACE}=[6000,100,100,10];
$PROD{PBX}{NAME}="VERITAS Private Branch Exchange";
$PROD{PBX}{UGVERS}= ALL;
$PROD{PBX}{HOMEDIR}="/opt/VRTSpbx";
$PROD{PBX}{CONFIG}=1;
$PROD{PBX}{PKGS}=["VRTSpbx"];
$PROD{PBX}{ABBR}="PBX";
$PROD{PBX}{VERSION}="1.2.2.9";

sub _pbx_comm_preinstall {
	_prod_plat_sub("PBX", "preinstall");
}

sub _pbx_comm_pkgrequest_questions {
        _prod_plat_sub_target("PBX", "pkgrequest_questions");
}
sub _pbx_comm_stop_processes {
	_pb1("Stopping VRTSpbx processes", 260, 1000);
	my($pid);
	$pid=_comm_get_pid("pbx_exchange"); 
	while ($pid) {
			_comm_kill_proc("pbx_exchange",$pid);
			$pid=_comm_get_pid("pbx_exchange");
	}
	_pb2("Done", 260, 1001);
}


sub _pbx_comm_postinstall_questions 
{
	&_pbx_port_ask;
	&_pbx_user_ask;
	&_pbx_secure_ask;
	&_pbx_cluster_ask;
	return 0 ;
}
sub _pbx_comm_create_configfiles
{
	&_pbx_ul_configure;
	&_pbx_port_configure;
	&_pbx_user_configure;
	&_pbx_secure_configure;
	#This has to be uncommented if cluster is to configured
	&_pbx_cluster_configure;
}

sub _pbx_ul_configure
{
	foreach $SYS (@{$COMM{ISL}})
	{
	if($^O !~ /Sun/i)
	{
$ENV{VRTSLOG_RES_PATH}="/opt/VRTSpbx/bin";
$ENV{LD_LIBRARY_PATH}="/opt/VRTSpbx/bin";
$ENV{SHLIB_PATH}="$ENV{SHLIB_PATH}:/opt/VRTSpbx/bin";
$ENV{LIBPATH}="$ENV{LIBPATH}:/opt/VRTSpbx/bin";

# first quietly delete any previous entries for ICS
_dor("/opt/VRTSpbx/bin/vxlogadmin --quiet --prodid 1 -r");

# now quietly create entries for ics
_dor("/opt/VRTSpbx/bin/vxlogadmin --quiet -a --prodid 1 --config /etc/vx/VxICS/icsul.conf --names \"VxICS, ics\"");
_dor("echo \"LoggingTools.L10nResourceDir=/opt/VRTSpbx/bin/language/en\" >> /etc/vx/vrtslog.conf");
my $hparch=`uname -a`;
if($hparch=~/hp/i)
{
if($hparch!~/ia64/i)
{
_dor("sed \'s+exticu.so+exticu.sl+g\' /etc/vx/VxICS/icsul.conf > /etc/vx/VxICS/icsul.conf.tmp");
_dor("mv /etc/vx/VxICS/icsul.conf.tmp /etc/vx/VxICS/icsul.conf");
}
}
}
}

}

sub _pbx_comm_preremove
{
    my($iv,$install_dir);
    $TARGET = $LOCAL if (!$TARGET);
    _bpl("Checking for VERITAS Authentication Service", 260, 1002);
    if ($TARGET eq "OSF1") {
      $iv=_comm_get_instpkgvers($PKGI{$TARGET}{$PROD{AT}{$TARGET}{MAINPKG}}{SUBSET});
    } else {
      $iv=_comm_get_instpkgvers($PROD{AT}{$TARGET}{MAINPKG});
    }
    if($iv) {
        _bpl("VERITAS Authentication Service which depends on VERITAS Private Branch Exchange Service is still installed.\nPlease uninstall  VERITAS Authentication Service before you uninstall VERITAS Private Branch Exchange Service.\n", 260, 1003);
	_prtc();
            _die("Uninstallation aborted. Dependent VERITAS Authentication Service not uninstalled.", 260, 1004);
    }

    _bpl("Checking for VERITAS Service Management Framework Service", 260, 1005);
    if ($TARGET eq "OSF1") {
      $iv=_comm_get_instpkgvers($PKGI{$TARGET}{$PROD{SMF}{$TARGET}{MAINPKG}}{SUBSET});
    } else {
      $iv=_comm_get_instpkgvers($PROD{SMF}{$TARGET}{MAINPKG});
    }
    if($iv) {
        _bpl("VERITAS Service Management Framework Service which depends on VERITAS Private Branch Exchange Service is still installed.\nPlease uninstall  VERITAS Service Management Framework Service before you uninstall VERITAS Private Branch Exchange Service.\n", 260, 1006);
	_prtc();
            _die("Uninstallation aborted. Dependent VERITAS Authentication Service not uninstalled.", 260, 1004);
    }
#This has to be uncommented if cluster is to configured
        $install_dir = "/opt/VRTSpbx";
	foreach $SYS (@{$COMM{ISL}})
	{
	_dor("$install_dir/bin/VxPBXclconf.pl -u -c$install_dir/bin/VxPBXClusEnv.txt");
	}
}

sub _pbx_comm_postremove
{
	my $install_dir="/opt/VRTSpbx";
	foreach $SYS (@{$COMM{ISL}})
	{
	_dor("rm -rf $install_dir");
	}

}

sub _pbx_port_ask
{
	$COMM{DEFANSWER}=1556;
	$CFG{PBX_PBX_PORT_NUMBER}=_ask("Enter port number for PBX ", 260, 1007);
}

sub _pbx_secure_ask
{
	$CFG{PBX_SECURE}=_ayny("Do you want VxPBX to be secure?", 260, 1008);
}

sub _pbx_user_ask
{
	$COMM{DEFANSWER}="root";
	$CFG{PBX_AUTHUSER_LIST}=_ask("Enter the list of authorized users (separated by space) ", 260, 1009);
}

sub _pbx_user_configure
{
	foreach $SYS (@{$COMM{ISL}})
	{
	$ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:/opt/VRTSpbx/bin";
	$ENV{SHLIB_PATH}="$ENV{SHLIB_PATH}:/opt/VRTSpbx/bin";
	$ENV{LIBPATH}="$ENV{LIBPATH}:/opt/VRTSpbx/bin";
	_dor("/opt/VRTSpbx/bin/pbxcfg -a -u \"$CFG{PBX_AUTHUSER_LIST}\"");
	}
}

sub _pbx_secure_configure
{
        my $securechoice;
	if(_tolower($CFG{PBX_SECURE}) eq 'y')
	{
	 $securechoice='-e';
	}
	else
	{
	 $securechoice='-d';
	}
	foreach $SYS (@{$COMM{ISL}})
	{
	$ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:/opt/VRTSpbx/bin";
	$ENV{SHLIB_PATH}="$ENV{SHLIB_PATH}:/opt/VRTSpbx/bin";
	$ENV{LIBPATH}="$ENV{LIBPATH}:/opt/VRTSpbx/bin";
	_dor("/opt/VRTSpbx/bin/pbxcfg $securechoice -m ");
	}
}

sub _pbx_cluster_ask
{
    my $install_dir;
    my $sec_name = "";
    my $clus_inst = 0;
    my $sec_start = 0;
    my $dep_sec_start = 0;
    my $input_str;
    my @system_list;

#
# PBX Install Dir
#
    my $install_dir = "/opt/VRTSpbx";
    my $conf_file_name = "$install_dir/bin/VxPBXClusEnv.conf";
        	
	$CFG{PBX_CLUSTER_YN}=_aynn("Do you want the installer to do a cluster configuration?", 260, 1010);
	if($CFG{PBX_CLUSTER_YN} eq "Y") {
		_title("Cluster Configuration Questions");

	    _log("Trying to open $conf_file_name", 260, 1011, "$conf_file_name");
		open INPUT, "$conf_file_name" or die "Unable to open file : $conf_file_name. Check for the existence of file: $!\n";


		my @lines = <INPUT> ;
		close(INPUT);

		foreach my $line (@lines) {
		   chomp($line) ;

#
# If this is comment line, go to next line
#
		   next if (($line =~ /^#.*/) || ($line !~ /\w+/)) ;

#
# VCS, DEPENDENCY and Resource Section starts here 
#
		   if ($line =~ /^Begin/ && $line =~/Section/ && $line !~ /SubSection/) {
		   	   my @first = split(/Begin/, $line);
		   	   my @second= split(/Section/, $first[1]) ;
			   $sec_name = $second[0];
			   _pl("$sec_name configuration Begin", 260, 1012, "$sec_name");

		           # Only for dependency section, set "dep_sec_start" variable
			   if ($sec_name eq "DEPENDENCYLIST") {
				   $dep_sec_start = 1 ;
				   $sec_start = 0 ;
				   next;
			   }

			   $sec_start = 1 ;
		   }

# Don't go forward if you haven't entered any Section
   	    	elsif ($sec_start != 1 && $dep_sec_start != 1) {
				next ;
	     	}

#
# Section ends here
#
			elsif (($line =~ /^End/ && $line =~ /Section/ && $line !~ /SubSection/)) {
			   	_pl("$sec_name configuration End", 260, 1013, "$sec_name");
				$sec_name = "" ;
				$sec_start = 0 ;
				if ($sec_name eq "DEPENDENCYLIST") {
					$dep_sec_start = 0 ;
				}
			}

			elsif ($line =~ /SubSection/) {

				# Set the "clus_inst" variable as cluster install sub section starts.
				if ($line =~ /BeginClusInstallSubSection/) {
					$clus_inst = 1;
				}

				# Unset the "clus_inst" variable as cluster install sub section starts.
				elsif ($line =~ /EndClusInstallSubSection/) {
					$clus_inst = 0;
				}
			}

#
# Already Section has started so start reading attribute name and value.
#
			elsif ($sec_start == 1) {
				my @lines = split(/</, $line) ;
					if ($clus_inst == 0) {
						my ($attr_name, $attr_val) = split(/=/, $lines[0]);
						
						$attr_name = _desp($attr_name);

						# If attribute property is optional	
						if ($line =~ /<Optional>/) {

							$CFG{"PBX_CLUS_.$attr_name._YN"} = _aynn("Entry $attr_name is optional. So, do you want to enter a value ? :");
																											if ($CFG{"PBX_CLUS_.$attr_name._YN"} eq "Y") {
								if ($attr_val =~ /\w+/) {
									$COMM{DEFANSWER}=$attr_val;
								}

								$CFG{"PBX_CLUS_.$attr_name._VAL"} = _ask("Entry $attr_name value: ");

							}
							next;
						}
						
						# If attribute property is SysDepend	
						elsif ($line =~ /<SysDepend>/) {
							# If attribute property is SysDepend and SetDefault	
							if ($line = /<SetDefault>/) {
							;
							}

							# If attribute property is SysDepend only
							else {
								for (my $i=0; $i<= $#system_list; ++$i) {
									if ($attr_val =~ /\w+/) {
										$COMM{DEFANSWER}=_desp($attr_val);
									}
									$CFG{"PBX_CLUS_.$attr_name._SYS_VAL"}{$system_list[$i]} = _ask("Enter $attr_name value for system $system_list[$i] :");

								}
							}
						}
				
#
# Attribute property is SetDefault, don't ask input from user
#
						elsif ($line =~ /<SetDefault>/) {
						;
						}
						
						else {
							$COMM{DEFANSWER}= $attr_val =~ /\w+/ ? $attr_val:""; 
							$CFG{"PBX_CLUS_.$attr_name._VAL"} = _ask("Enter $attr_name value:");
							if ($attr_name =~ /SystemList/) {
								@system_list = split (/\W*\s+\W*/, $CFG{"PBX_CLUS_.$attr_name._VAL"}); 
							}
						}
					}
					else {
					;
					}
				}
				
				elsif ($dep_sec_start == 1) {
				;
				}

				#TODO: print error message
				else { }
		}
	}

}

sub _pbx_port_configure
{
	foreach $SYS (@{$COMM{ISL}})
	{
	$ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:/opt/VRTSpbx/bin";
	$ENV{SHLIB_PATH}="$ENV{SHLIB_PATH}:/opt/VRTSpbx/bin";
	$ENV{LIBPATH}="$ENV{LIBPATH}:/opt/VRTSpbx/bin";
	_dor("/opt/VRTSpbx/bin/pbxcfg -s -n $CFG{PBX_PBX_PORT_NUMBER}");
	}
}
sub _pbx_cluster_configure
{
    my $install_dir;
    my $Section;
    my $sec_name = "";
    my $clus_inst = 0;
    my $sec_start = 0;
    my $dep_sec_start = 0;
    my $input_str;
    my @system_list;
    my $valid_val;
    my $i;

#
# PBX Install Dir
#
    my $install_dir = "/opt/VRTSpbx";
    my $conf_file_name = "$install_dir/bin/VxPBXClusEnv.conf";
	my $input_file_name = "$install_dir/bin/VxPBXClusEnv.txt";
        	
	if($CFG{PBX_CLUSTER_YN} eq "Y") {
		_title("Cluster Configuration");

	    _log("Trying to open $conf_file_name", 260, 1011, "$conf_file_name");
		open INPUT, "$conf_file_name" or die "Unable to open file : $conf_file_name. Check for the existence of file: $!\n";

   		_log("Trying to open $input_file_name", 260, 1011, "$input_file_name");
    	open OUTPUT, ">$input_file_name" or die "Can't open $input_file_name file: $!";

		my @lines = <INPUT> ;
		close(INPUT);

		foreach my $line (@lines) {
		   chomp($line) ;

#
# If this is comment line, go to next line
#
		   next if (($line =~ /^#.*/) || ($line !~ /\w+/)) ;

#
# VCS, DEPENDENCY and Resource Section starts here 
#
		   if ($line =~ /^Begin/ && $line =~/Section/ && $line !~ /SubSection/) {
		   	   my @first = split(/Begin/, $line);
		   	   my @second= split(/Section/, $first[1]) ;
			   $sec_name = $second[0];
			   _pl("$sec_name configuration Begin", 260, 1012, "$sec_name");
			   print OUTPUT "$line\n";

		           # Only for dependency section, set "dep_sec_start" variable
			   if ($sec_name eq "DEPENDENCYLIST") {
				   $dep_sec_start = 1 ;
				   $sec_start = 0 ;
				   next;
			   }

			   $sec_start = 1 ;
		   }

# Don't go forward if you haven't entered any Section
   	    	elsif ($sec_start != 1 && $dep_sec_start != 1) {
				next ;
	     	}

#
# Section ends here
#
			elsif (($line =~ /^End/ && $line =~ /Section/ && $line !~ /SubSection/)) {
				print OUTPUT "$line\n";
			   	_pl("$sec_name configuration End", 260, 1013, "$sec_name");
				$sec_name = "" ;
				$sec_start = 0 ;
				if ($sec_name eq "DEPENDENCYLIST") {
					$dep_sec_start = 0 ;
				}
			}

			elsif ($line =~ /SubSection/) {
				print OUTPUT "$line\n";

				# Set the "clus_inst" variable as cluster install sub section starts.
				if ($line =~ /BeginClusInstallSubSection/) {
					$clus_inst = 1;
				}

				# Unset the "clus_inst" variable as cluster install sub section starts.
				elsif ($line =~ /EndClusInstallSubSection/) {
					$clus_inst = 0;
				}
			}

#
# Already Section has started so start reading attribute name and value.
#
			elsif ($sec_start == 1) {
				my @lines = split(/</, $line) ;
					if ($clus_inst == 0) {
						my ($attr_name, $attr_val) = split(/=/, $lines[0]);
						
						$attr_name = _desp($attr_name);

						# If attribute property is optional	
						if ($line =~ /<Optional>/) {

																											if ($CFG{"PBX_CLUS_.$attr_name._YN"} eq "Y") {
								if ($attr_val =~ /\w+/) {
									$COMM{DEFANSWER}=$attr_val;
								}

								$valid_val = _get_valid_addr($attr_name, $CFG{"PBX_CLUS_.$attr_name._VAL"});
								$valid_val =~ s/^[ \t]+//;
								$valid_val = chomp($valid_val);

								print OUTPUT "$attr_name="._desp($valid_val)."\n";
							}
							next;
						}
						
						# If attribute property is SysDepend	
						elsif ($line =~ /<SysDepend>/) {
							# If attribute property is SysDepend and SetDefault	
							if ($line = /<SetDefault>/) {
								for (my $i=0; $i<= $#system_list; ++$i) {
									$valid_val = _get_valid_addr($attr_name, $attr_val);
									if ($valid_val !~ /\w+/) {
										_pl("Attribute with SetDefault properties must have value.\n", 260, 1014);
									}
									print OUTPUT "$attr_name@" . "$system_list[i]="._desp($valid_val)."\n";
								}
							}

							# If attribute property is SysDepend only
							else {
								for (my $i=0; $i<= $#system_list; ++$i) {
									if ($attr_val =~ /\w+/) {
										$COMM{DEFANSWER}=_desp($attr_val);
									}
									$valid_val = _get_valid_addr($attr_name, $CFG{"PBX_CLUS_.$attr_name._SYS_VAL"}{$system_list[$i]});
									print OUTPUT "$attr_name@"."$system_list[$i]="._desp($valid_val)."\n";
								}
							}
						}
				
#
# Attribute property is SetDefault, don't ask input from user
#
						elsif ($line =~ /<SetDefault>/) {
							$valid_val = _get_valid_addr($attr_name, $attr_val);
							if ($valid_val !~ /\w+/) {
								_pl("Attribute with SetDefault properties must have value\n", 260, 1015);
							}
							print OUTPUT "$attr_name="._desp($valid_val)."\n";
						}
						
						else {
							$COMM{DEFANSWER}= $attr_val =~ /\w+/ ? $attr_val:""; 
							my $answer;
							if ($CFG{"PBX_CLUS_.$attr_name._VAL"} =~ /^\s*$/m)
							{
								$answer=$attr_val;
							}
							else
							{
								$answer=$CFG{"PBX_CLUS_.$attr_name._VAL"};
							}

							$valid_val = _get_valid_addr($attr_name, $answer);
							print OUTPUT "$attr_name="._desp($valid_val)."\n";
							if ($attr_name =~ /SystemList/) {
								@system_list = split (/\W*\s+\W*/, $CFG{"PBX_CLUS_.$attr_name._VAL"}); 
							}
						}
					}
					else {
						print OUTPUT "$line\n";
					}
				}
				
				elsif ($dep_sec_start == 1) {
					print OUTPUT "$line\n";
				}

				#TODO: print error message
				else { }
		}
	close(OUTPUT);
        $install_dir = "/opt/VRTSpbx";
	_pl("Please wait ... Configuring", 260, 1016);
	_fork_sub(0,"_dol","$install_dir/bin/VxPBXclconf.pl -c$install_dir/bin/VxPBXClusEnv.txt");
	_pl("Done", 260, 1001);
	}
}

sub _run_configure
{
  my ($install_dir,$configoutput);
        $configoutput = _dol("$install_dir/bin/VxPBXclconf.pl -c$install_dir/bin/VxPBXClusEnv.txt");
}
sub _get_valid_addr {

	my ($attr_name, $attr_val) = @_;
	if($attr_name =~ /Address/ || $attr_name =~ /NetMask/) {
		while(_ipcheck($attr_val)) {
				_pl("Bad IP Address", 260, 1017);
				$MSG{HELP}=_tr("Enter $attr_val resource information", 260, 1018, "$attr_val");
				$attr_val =_ask("Enter the IP address:", 260, 1019);
		}
	}
	return _desp($attr_val);
}
sub _expend_hosts {
	my($filename, $obj, %hosts) = @_;
	
	open(RF, "< $filename") || die "unable to open ${filename}";
	open(WF, "> ${filename}.new") || die "unable to open ${filename}.bak";
	while (<RF>) {
		if ($_ =~ /^(\s)*($obj(\s)*)=/) {
			foreach my $host (keys(%hosts)) {
				print WF "${1}${obj}\@${host}=$hosts{${host}}\n";
			}
		} else {
			print WF $_;
		}
	}
	
	close(RF);
	close(WF);
	_dol("cp -f ${filename}.new ${filename}");
	_dol("rm -f ${filename}.new"); 
}

sub _shrink_hosts {
	my($filename, $obj, $newvalue) = @_;
	my $done = 0;
	
	open(RF, "< $filename") || die "unable to open ${filename}";
	open(WF, "> ${filename}.new") || die "unable to open ${filename}.bak";
	while (<RF>) {
		if ($_ =~ /^(\s)*($obj\@.+)(=.*)/) {
			if (!$done) {
				$done = 1;
				print WF $1 . $obj . "=" . $newvalue . "\n";
			}
		} else {
			$done = 0;
			print WF $_;
		}
	}
	
	close(RF);
	close(WF);
	_dol("cp -f ${filename}.new ${filename}");
	_dol("rm -f ${filename}.new");
}

1;

# Define frequently referenced paths
# Define product information
$PROD{SMF}{NAME}="VERITAS Service Management Framework";
$PROD{SMF}{ABBR}="SMF";
$PROD{SMF}{HOMEDIR}="/opt/VRTSsmf";
$PKGI{SMF}{NAME}="VERITAS Service Management Framework";
$PKGI{SMF}{SPACE}=[6000,100,100,10];
$PROD{SMF}{UGVERS}= ALL;
$PROD{SMF}{HOMEDIR}="/opt/VRTSsmf";
$PROD{SMF}{CONFIG}=1;
$PROD{SMF}{PKGS}=["VRTSsmf"];
$PROD{SMF}{ABBR}="SMF";
$PROD{SMF}{VERSION}="1.2.1.30";

sub _smf_comm_preinstall {
      _prod_plat_sub("SMF", "preinstall");
}

sub _smf_comm_pkgrequest_questions {
      my($ivpbx,$ivat);
      $TARGET = $LOCAL if (!$TARGET);

      _bpl("Checking for VERITAS Private Branch Exchange Service", 270, 1000);
    if ($TARGET eq "OSF1") {
      $ivpbx=_comm_get_instpkgvers($PKGI{$TARGET}{$PROD{PBX}{$TARGET}{MAINPKG}}{SUBSET});
    } else {
      $ivpbx=_comm_get_instpkgvers($PROD{PBX}{$TARGET}{MAINPKG});
    }
      if(!$ivpbx) {
	    _bpl("VERITAS Private Branch Exchange Service is not installed on this system.\nPlease install VERITAS Private Branch Exchange Service before you install VERITAS Service Management Framework.\n", 270, 1001);
	    _prtc();
	    
		  _die("Installation aborted. VERITAS Private Branch Exchange Service not installed.", 270, 1002);
      }
    if ($TARGET eq "OSF1") {
      $ivat=_comm_get_instpkgvers($PKGI{$TARGET}{$PROD{AT}{$TARGET}{MAINPKG}}{SUBSET});
    } else {
      $ivat=_comm_get_instpkgvers($PROD{AT}{$TARGET}{MAINPKG});
    }
      if(!$ivat) {
	    _bpl("VERITAS Authentication Service is not installed on this system.\nPlease install VERITAS Authentication Service before you install VERITAS Service Management Framework.\n", 270, 1003);
	    _prtc();
	    
		  _die("Installation aborted. VERITAS Private Branch Exchange Service not installed.", 270, 1002);
      }

      _prod_plat_sub("SMF", "pkgrequest_questions");
}

sub _smf_comm_stop_processes {
      _pb1("Stopping VRTSsmf processes", 270, 1004);
      my($pid);
      $pid=_comm_get_pid("VxSMF"); 
      while ($pid) {
	    _comm_kill_proc("VxSMF",$pid);
	    $pid=_comm_get_pid("VxSMF");
      }
      _pb2("Done", 270, 1005);
}



sub _smf_comm_postinstall_questions 
{
      #SMF can retrieve PBX port number from PBX configuration
      &_smf_pbxport_ask;
      &_smf_security_ask;
#      &_smf_imr_ask;
#      &_smf_cnos_ask;
      #This needs to uncommented if we need to be able to configure the cluster
      &_smf_cluster_ask;
      return 0 ;
}

sub _smf_comm_create_configfiles
{
      &_smf_ul_configure;
      &_smf_pbxport_configure;
      &_smf_security_configure;
#      &_smf_imr_configure;
#      &_smf_cnos_configure;
      #This needs to uncommented if we need to be able to configure the cluster
      &_smf_cluster_configure;
      return 0 ;
}

sub _smf_ul_configure
{
	foreach $SYS (@{$COMM{ISL}})
	{
	if($^O !~ /Sun/i)
	{
$ENV{VRTSLOG_RES_PATH}="/opt/VRTSsmf/bin";
$ENV{LD_LIBRARY_PATH}="/opt/VRTSsmf/bin";
$ENV{SHLIB_PATH}="$ENV{SHLIB_PATH}:/opt/VRTSsmf/bin";
$ENV{LIBPATH}="$ENV{LIBPATH}:/opt/VRTSsmf/bin";

_dor("echo \"80.L10nResource=VxSMF\" >> /etc/vx/VxICS/icsul.conf");
_dor("echo \"95.L10nResource=VxSMF\" >> /etc/vx/VxICS/icsul.conf");
_dor("cat /opt/VRTSsmf/bin/icslog.cfg >> /etc/vx/VxICS/icsul.conf");
#2 more Lines

# Add the shebang lines to online, offline, and monitor.
_dor("mv /opt/VRTSsmf/bin/monitor /opt/VRTSsmf/bin/monitor.bup");
_dor("echo \"#!/opt/VRTSvcs/bin/perl5\n\" > /opt/VRTSsmf/bin/monitor");
_dor("cat /opt/VRTSsmf/bin/monitor.bup >> /opt/VRTSsmf/bin/monitor");
_dor("rm /opt/VRTSsmf/bin/monitor.bup");

_dor("mv /opt/VRTSsmf/bin/online /opt/VRTSsmf/bin/online.bup");
_dor("echo \"#!/opt/VRTSvcs/bin/perl5\n\" > /opt/VRTSsmf/bin/online");
_dor("cat /opt/VRTSsmf/bin/online.bup >> /opt/VRTSsmf/bin/online");
_dor("rm /opt/VRTSsmf/bin/online.bup");

_dor("mv /opt/VRTSsmf/bin/offline /opt/VRTSsmf/bin/offline.bup");
_dor("echo \"#!/opt/VRTSvcs/bin/perl5\n\" > /opt/VRTSsmf/bin/offline");
_dor("cat /opt/VRTSsmf/bin/offline.bup >> /opt/VRTSsmf/bin/offline");
_dor("rm /opt/VRTSsmf/bin/offline.bup");
my $hparch=`uname -a`;
if($hparch=~/hp/i)
{
if($hparch!~/ia64/i)
{
_dor("sed \'s+exticu.so+exticu.sl+g\' /etc/vx/VxICS/icsul.conf > /etc/vx/VxICS/icsul.conf.tmp");
_dor("mv /etc/vx/VxICS/icsul.conf.tmp /etc/vx/VxICS/icsul.conf");
}
}
}
	}

}
sub _smf_comm_preremove
{
#        $install_dir = "/opt/VRTSsmf";
#	foreach $SYS (@{$COMM{ISL}})
#	{
#	_dor("$install_dir/bin/VxSMFlconf.pl -u -c$install_dir/bin/VxSMFClusEnv.txt");
#	}
}

sub _smf_comm_postremove
{
  my $install_dir;
  my $SYS;
  
      $install_dir="/opt/VRTSsmf";
      foreach $SYS (@{$COMM{ISL}})
      {
	    _dor("rm -rf $install_dir");
      }

}

sub _smf_pbxport_ask
{
}
sub _smf_security_ask
{
      $CFG{SECURITY_ENABLE_YN}=_aynn("Do you want to enable security?", 270, 1006);
      if($CFG{SECURITY_ENABLE_YN}  eq 'Y') 
      {
	    _title("Security configuration");
	    $COMM{DEFANSWER}="yourbrokerhost.company.com";
	    $CFG{BROKER_HOST}=_ask("Enter broker host ", 270, 1007);
	    $COMM{DEFANSWER}="yourname";
	    $CFG{UNAME}=_ask("Enter user name ", 270, 1008);
	    $COMM{DEFANSWER}="";
	    $CFG{DNAME}=_ask("Enter domain name ", 270, 1009);
	    $COMM{DEFANSWER}="unixpwd";
	    $CFG{DTYPE}=_ask("Enter domain type ", 270, 1010);
	    $COMM{DEFANSWER}=2821;
	    $CFG{BROKER_PORT_NUMBER}=_ask("Enter broker port number ", 270, 1011);
	    $COMM{DEFANSWER}="";
	    _p("Enter password for $CFG{UNAME}:");
	    $CFG{AT_PASSWORD}=_pwhide();
      }
}
sub _smf_imr_ask
{
}
sub _smf_cnos_ask
{
}
sub _smf_cluster_ask
{
    my $install_dir;
    my $sec_name = "";
    my $clus_inst = 0;
    my $sec_start = 0;
    my $dep_sec_start = 0;
    my $input_str;
    my @system_list;

#
# SMF Install Dir
#
    my $install_dir = "/opt/VRTSsmf";
    my $conf_file_name = "$install_dir/bin/VxSMFClusEnv.conf";
        	
	$CFG{SMF_CLUSTER_YN}=_aynn("Do you want the installer to do a cluster configuration?", 270, 1012);
	if($CFG{SMF_CLUSTER_YN} eq "Y") {
		_title("Cluster Configuration Questions");

	    _log("Trying to open $conf_file_name", 270, 1013, "$conf_file_name");
		open INPUT, "$conf_file_name" or die "Unable to open file : $conf_file_name. Check for the existence of file: $!\n";


		my @lines = <INPUT> ;
		close(INPUT);

		foreach my $line (@lines) {
		   chomp($line) ;

#
# If this is comment line, go to next line
#
		   next if (($line =~ /^#.*/) || ($line !~ /\w+/)) ;

#
# VCS, DEPENDENCY and Resource Section starts here 
#
		   if ($line =~ /^Begin/ && $line =~/Section/ && $line !~ /SubSection/) {
		   	   my @first = split(/Begin/, $line);
		   	   my @second= split(/Section/, $first[1]) ;
			   $sec_name = $second[0];
			   _pl("$sec_name configuration Begin", 270, 1014, "$sec_name");

		           # Only for dependency section, set "dep_sec_start" variable
			   if ($sec_name eq "DEPENDENCYLIST") {
				   $dep_sec_start = 1 ;
				   $sec_start = 0 ;
				   next;
			   }

			   $sec_start = 1 ;
		   }

# Don't go forward if you haven't entered any Section
   	    	elsif ($sec_start != 1 && $dep_sec_start != 1) {
				next ;
	     	}

#
# Section ends here
#
			elsif (($line =~ /^End/ && $line =~ /Section/ && $line !~ /SubSection/)) {
			   	_pl("$sec_name configuration End", 270, 1015, "$sec_name");
				$sec_name = "" ;
				$sec_start = 0 ;
				if ($sec_name eq "DEPENDENCYLIST") {
					$dep_sec_start = 0 ;
				}
			}

			elsif ($line =~ /SubSection/) {

				# Set the "clus_inst" variable as cluster install sub section starts.
				if ($line =~ /BeginClusInstallSubSection/) {
					$clus_inst = 1;
				}

				# Unset the "clus_inst" variable as cluster install sub section starts.
				elsif ($line =~ /EndClusInstallSubSection/) {
					$clus_inst = 0;
				}
			}

#
# Already Section has started so start reading attribute name and value.
#
			elsif ($sec_start == 1) {
				my @lines = split(/</, $line) ;
					if ($clus_inst == 0) {
						my ($attr_name, $attr_val) = split(/=/, $lines[0]);
						
						$attr_name = _desp($attr_name);

						# If attribute property is optional	
						if ($line =~ /<Optional>/) {

							$CFG{"SMF_CLUS_.$attr_name._YN"} = _aynn("Entry $attr_name is optional. So, do you want to enter a value ? :");
																											if ($CFG{"SMF_CLUS_.$attr_name._YN"} eq "Y") {
								if ($attr_val =~ /\w+/) {
									$COMM{DEFANSWER}=$attr_val;
								}

								$CFG{"SMF_CLUS_.$attr_name._VAL"} = _ask("Entry $attr_name value: ");

							}
							next;
						}
						
						# If attribute property is SysDepend	
						elsif ($line =~ /<SysDepend>/) {
							# If attribute property is SysDepend and SetDefault	
							if ($line = /<SetDefault>/) {
							;
							}

							# If attribute property is SysDepend only
							else {
								for (my $i=0; $i<= $#system_list; ++$i) {
									if ($attr_val =~ /\w+/) {
										$COMM{DEFANSWER}=_desp($attr_val);
									}
									$CFG{"SMF_CLUS_.$attr_name._SYS_VAL"}{$system_list[$i]} = _ask("Enter $attr_name value for system $system_list[$i] :");

								}
							}
						}
				
#
# Attribute property is SetDefault, don't ask input from user
#
						elsif ($line =~ /<SetDefault>/) {
						;
						}
						
						else {
							$COMM{DEFANSWER}= $attr_val =~ /\w+/ ? $attr_val:""; 
							$CFG{"SMF_CLUS_.$attr_name._VAL"} = _ask("Enter $attr_name value:");
							if ($attr_name =~ /SystemList/) {
								@system_list = split (/\W*\s+\W*/, $CFG{"SMF_CLUS_.$attr_name._VAL"}); 
							}
						}
					}
					else {
					;
					}
				}
				
				elsif ($dep_sec_start == 1) {
				;
				}

				#TODO: print error message
				else { }
		}
	}

}

sub _smf_pbxport_configure
{
	foreach $SYS (@{$COMM{ISL}})
	{
      	my $pbxinstalldir="/opt/VRTSpbx";
	$ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:/opt/VRTSpbx/bin";
	$ENV{SHLIB_PATH}="$ENV{SHLIB_PATH}:/opt/VRTSpbx/bin";
	$ENV{LIBPATH}="$ENV{LIBPATH}:/opt/VRTSpbx/bin";
        my $portnumberout=`/opt/VRTSpbx/bin/pbxcfg -p -n`;
      	$portnumberout=~m/\b(\d+)/;
        $CFG{PBX_PORT_NUMBER}=$1;
	#Line below needs to be commented/deleted out when PBX bug is fixed
        #$CFG{PBX_PORT_NUMBER}="1556";
	}
      `sed \'s+^.PortNumber.=.*\$+"PortNumber"="$CFG{PBX_PORT_NUMBER}"+g\' /etc/vx/VxSMF/VxSMF.cfg > /etc/vx/VxSMF/VxSMF.cfg.tmp`;
      foreach $SYS (@{$COMM{ISL}})
      {
	    _copy("/etc/vx/VxSMF/VxSMF.cfg.tmp","/etc/vx/VxSMF/VxSMF.cfg");
      }
      `rm /etc/vx/VxSMF/VxSMF.cfg.tmp`;
}
sub _smf_imr_configure
{
	    foreach $SYS (@{$COMM{ISL}})
	    {
		  $ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:/opt/VRTSsmf/bin";
		$ENV{SHLIB_PATH}="$ENV{SHLIB_PATH}:/opt/VRTSsmf/bin";
		$ENV{LIBPATH}="$ENV{LIBPATH}:/opt/VRTSsmf/bin";
		_dor("/opt/VRTSsmf/bin/vxsmfcfg addprocess -pp IMR -pn $CFG{PBX_PORT_NUMBER} -ServiceList \"ImR_Locator_Loader,ImR_Activator_Loader\" -ip \"/opt/VRTSsmf/bin\" -oo \"-orbdotteddecimaladdresses 1 -orbdebug -orbdebuglevel 3\"");
		_dor("/opt/VRTSsmf/bin/vxsmfcfg addservice -sp ImR_Locator_Loader -ep ImR_Locator_Loader -ip /opt/VRTSsmf/bin/libvxTAO_ImR_Locator.so -dn ImR_Locator_Loader -o \"-orbdotteddecimaladdresses 1 -orbdebug -orbdebuglevel 3 -d 10 -ORBEndpoint pbxiop://localhost:$CFG{PBX_PORT_NUMBER}:implrepo -o implrepo.ior\"");
		_dor("/opt/VRTSsmf/bin/vxsmfcfg addservice -sp ImR_Activator_Loader -ep ImR_Activator_Loader -ip /opt/VRTSsmf/bin/libvxTAO_ImR_Activator.so -dn ImR_Activator_Loader -o \"-orbdotteddecimaladdresses 1 -orbdebug -orbdebuglevel 3 -d 10 -ORBEndpoint pbxiop://localhost:$CFG{PBX_PORT_NUMBER}:activator -ORBInitRef ImplRepoService=file://implrepo.ior\"");
	    }
}
sub _smf_cnos_configure
{
	    foreach $SYS (@{$COMM{ISL}})
	    {
		  $ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:/opt/VRTSsmf/bin";
		$ENV{SHLIB_PATH}="$ENV{SHLIB_PATH}:/opt/VRTSsmf/bin";
		$ENV{LIBPATH}="$ENV{LIBPATH}:/opt/VRTSsmf/bin";
		  _dor("/opt/VRTSsmf/bin/vxsmfcfg setprocessattribs -pp ICS -sl CosNotify_Service,Topology_Factory,Event_Persistence,CosNotfSrvc");
		_dor("/opt/VRTSsmf/bin/vxsmfcfg addservice -sp CosNotfSrvc -ep CosNotfSrvc -ip /opt/VRTSsmf/bin/libVxCNOS.so -dn CosNotfSrvc -v dword:00000009.dword:00000001.dword:00000002.dword:00000000 -o \"-IORoutput notify.ior\"");
		_dor("/opt/VRTSsmf/bin/vxsmfcfg addservice -sp CosNotify_Service -ep TAO_NS_Notify_Service -ip /opt/VRTSsmf/bin/libvxTAO_CosNotification.so -dn CosNotify_Service -v dword:00000009.dword:00000001.dword:00000002.dword:00000000 -o \"-MTDispatching -DispatchingThreads 2 -SourceThreads 2 -AllowReconnect\"");
		_dor("/opt/VRTSsmf/bin/vxsmfcfg addservice -sp Event_Persistence -ep Standard_Event_Persistence -ip /opt/VRTSsmf/bin/libvxTAO_CosNotification.so -dn Event_Persistence -v dword:00000009.dword:00000001.dword:00000002.dword:00000000 -o \"-v -file_path ./TST_EVPER\"");
		_dor("/opt/VRTSsmf/bin/vxsmfcfg addservice -sp Topology_Factory -ep XML_Topology_Factory -ip /opt/VRTSsmf/bin/libvxTAO_CosNotification.so -dn Topology_Factory -v dword:00000009.dword:00000001.dword:00000002.dword:00000000 -o \"-v -base_path ./TST_TOPO\"");
	    }
}
sub _smf_security_configure
{
      if($CFG{SECURITY_ENABLE_YN}  eq 'Y') 
      {
	    chomp($CFG{AT_PASSWORD});
	    foreach $SYS (@{$COMM{ISL}})
	    {
		  _dor("/opt/VRTSat/bin/vssat setuptrust --broker $CFG{BROKER_HOST}:$CFG{BROKER_PORT_NUMBER} --securitylevel low");
		  _dor("/opt/VRTSat/bin/vssat authenticate --domain $CFG{DTYPE}:$CFG{DNAME} --prplname $CFG{UNAME} --password $CFG{AT_PASSWORD} --broker $CFG{BROKER_HOST}:$CFG{BROKER_PORT_NUMBER}");
		  $ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:/opt/VRTSsmf/bin";
		$ENV{SHLIB_PATH}="$ENV{SHLIB_PATH}:/opt/VRTSsmf/bin";
		$ENV{LIBPATH}="$ENV{LIBPATH}:/opt/VRTSsmf/bin";
		  _dor("/opt/VRTSsmf/bin/vxsmfcfg -z -H $CFG{BROKER_HOST} -N $CFG{UNAME} -D $CFG{DNAME} -T $CFG{DTYPE} -B $CFG{BROKER_PORT_NUMBER} -n $CFG{PBX_PORT_NUMBER} -E 3");
	    }
	    #vxsmfcfg code
      }
      else
      {
		  $ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:/opt/VRTSsmf/bin";
		$ENV{SHLIB_PATH}="$ENV{SHLIB_PATH}:/opt/VRTSsmf/bin";
		$ENV{LIBPATH}="$ENV{LIBPATH}:/opt/VRTSsmf/bin";
		  _dor("/opt/VRTSsmf/bin/vxsmfcfg -z -H none -N none -D none -T none -B none -n $CFG{PBX_PORT_NUMBER} -E 2");
      }
}
sub _smf_cluster_configure
{
    my $install_dir;
    my $Section;
    my $sec_name = "";
    my $clus_inst = 0;
    my $sec_start = 0;
    my $dep_sec_start = 0;
    my $input_str;
    my @system_list;
    my $valid_val;
    my $i;

#
# SMF Install Dir
#
    my $install_dir = "/opt/VRTSsmf";
    my $conf_file_name = "$install_dir/bin/VxSMFClusEnv.conf";
	my $input_file_name = "$install_dir/bin/VxSMFClusEnv.txt";
        	
	if($CFG{SMF_CLUSTER_YN} eq "Y") {
		_title("Cluster Configuration");

	    _log("Trying to open $conf_file_name", 270, 1013, "$conf_file_name");
		open INPUT, "$conf_file_name" or die "Unable to open file : $conf_file_name. Check for the existence of file: $!\n";

   		_log("Trying to open $input_file_name", 270, 1013, "$input_file_name");
    	open OUTPUT, ">$input_file_name" or die "Can't open $input_file_name file: $!";

		my @lines = <INPUT> ;
		close(INPUT);

		foreach my $line (@lines) {
		   chomp($line) ;

#
# If this is comment line, go to next line
#
		   next if (($line =~ /^#.*/) || ($line !~ /\w+/)) ;

#
# VCS, DEPENDENCY and Resource Section starts here 
#
		   if ($line =~ /^Begin/ && $line =~/Section/ && $line !~ /SubSection/) {
		   	   my @first = split(/Begin/, $line);
		   	   my @second= split(/Section/, $first[1]) ;
			   $sec_name = $second[0];
			   _pl("$sec_name configuration Begin", 270, 1014, "$sec_name");
			   print OUTPUT "$line\n";

		           # Only for dependency section, set "dep_sec_start" variable
			   if ($sec_name eq "DEPENDENCYLIST") {
				   $dep_sec_start = 1 ;
				   $sec_start = 0 ;
				   next;
			   }

			   $sec_start = 1 ;
		   }

# Don't go forward if you haven't entered any Section
   	    	elsif ($sec_start != 1 && $dep_sec_start != 1) {
				next ;
	     	}

#
# Section ends here
#
			elsif (($line =~ /^End/ && $line =~ /Section/ && $line !~ /SubSection/)) {
				print OUTPUT "$line\n";
			   	_pl("$sec_name configuration End", 270, 1015, "$sec_name");
				$sec_name = "" ;
				$sec_start = 0 ;
				if ($sec_name eq "DEPENDENCYLIST") {
					$dep_sec_start = 0 ;
				}
			}

			elsif ($line =~ /SubSection/) {
				print OUTPUT "$line\n";

				# Set the "clus_inst" variable as cluster install sub section starts.
				if ($line =~ /BeginClusInstallSubSection/) {
					$clus_inst = 1;
				}

				# Unset the "clus_inst" variable as cluster install sub section starts.
				elsif ($line =~ /EndClusInstallSubSection/) {
					$clus_inst = 0;
				}
			}

#
# Already Section has started so start reading attribute name and value.
#
			elsif ($sec_start == 1) {
				my @lines = split(/</, $line) ;
					if ($clus_inst == 0) {
						my ($attr_name, $attr_val) = split(/=/, $lines[0]);
						
						$attr_name = _desp($attr_name);

						# If attribute property is optional	
						if ($line =~ /<Optional>/) {

																											if ($CFG{"SMF_CLUS_.$attr_name._YN"} eq "Y") {
								if ($attr_val =~ /\w+/) {
									$COMM{DEFANSWER}=$attr_val;
								}

								$valid_val = _get_valid_addr($attr_name, $CFG{"SMF_CLUS_.$attr_name._VAL"});
								$valid_val =~ s/^[ \t]+//;
								$valid_val = chomp($valid_val);

								print OUTPUT "$attr_name="._desp($valid_val)."\n";
							}
							next;
						}
						
						# If attribute property is SysDepend	
						elsif ($line =~ /<SysDepend>/) {
							# If attribute property is SysDepend and SetDefault	
							if ($line = /<SetDefault>/) {
								for (my $i=0; $i<= $#system_list; ++$i) {
									$valid_val = _get_valid_addr($attr_name, $attr_val);
									if ($valid_val !~ /\w+/) {
										_pl("Attribute with SetDefault properties must have value.\n", 270, 1016);
									}
									print OUTPUT "$attr_name@" . "$system_list[i]="._desp($valid_val)."\n";
								}
							}

							# If attribute property is SysDepend only
							else {
								for (my $i=0; $i<= $#system_list; ++$i) {
									if ($attr_val =~ /\w+/) {
										$COMM{DEFANSWER}=_desp($attr_val);
									}
									$valid_val = _get_valid_addr($attr_name, $CFG{"SMF_CLUS_.$attr_name._SYS_VAL"}{$system_list[$i]});
									print OUTPUT "$attr_name@"."$system_list[$i]="._desp($valid_val)."\n";
								}
							}
						}
				
#
# Attribute property is SetDefault, don't ask input from user
#
						elsif ($line =~ /<SetDefault>/) {
							$valid_val = _get_valid_addr($attr_name, $attr_val);
							if ($valid_val !~ /\w+/) {
								_pl("Attribute with SetDefault properties must have value\n", 270, 1017);
							}
							print OUTPUT "$attr_name="._desp($valid_val)."\n";
						}
						
						else {
							$COMM{DEFANSWER}= $attr_val =~ /\w+/ ? $attr_val:""; 
							my $answer;
							if ($CFG{"SMF_CLUS_.$attr_name._VAL"} =~ /^\s*$/m)
							{
								$answer=$attr_val;
							}
							else
							{
								$answer=$CFG{"SMF_CLUS_.$attr_name._VAL"};
							}

							$valid_val = _get_valid_addr($attr_name, $answer);
							print OUTPUT "$attr_name="._desp($valid_val)."\n";
							if ($attr_name =~ /SystemList/) {
								@system_list = split (/\W*\s+\W*/, $CFG{"SMF_CLUS_.$attr_name._VAL"}); 
							}
						}
					}
					else {
						print OUTPUT "$line\n";
					}
				}
				
				elsif ($dep_sec_start == 1) {
					print OUTPUT "$line\n";
				}

				#TODO: print error message
				else { }
		}
	close(OUTPUT);
        $install_dir = "/opt/VRTSsmf";
	_pl("Please wait ... Configuring", 270, 1018);
	_fork_sub(0,"_dol","$install_dir/bin/VxSMFclconf.pl -c$install_dir/bin/VxSMFClusEnv.txt");
	_pl("Done", 270, 1005);
	}
}

sub _get_valid_addr {

      my ($attr_name, $attr_val) = @_;
      if($attr_name =~ /Address/ || $attr_name =~ /NetMask/) {
	    while(_ipcheck($attr_val)) {
		  _pl("Bad IP Address", 270, 1019);
		  $MSG{HELP}=_tr("Enter $attr_val resource information", 270, 1020, "$attr_val");
		  $attr_val =_ask("Enter the IP address:", 270, 1021);
	    }
      }
      return _desp($attr_val);
}
sub _expend_hosts {
      my($filename, $obj, %hosts) = @_;

      open(RF, "< $filename") || die "unable to open ${filename}";
      open(WF, "> ${filename}.new") || die "unable to open ${filename}.bak";
      while (<RF>) {
	    if ($_ =~ /^(\s)*($obj(\s)*)=/) {
		  foreach my $host (keys(%hosts)) {
			print WF "${1}${obj}\@${host}=$hosts{${host}}\n";
		  }
	    } else {
		  print WF $_;
	    }
      }

      close(RF);
      close(WF);
      _dol("cp -f ${filename}.new ${filename}");
      _dol("rm -f ${filename}.new"); 
}

sub _shrink_hosts {
      my($filename, $obj, $newvalue) = @_;
      my $done = 0;

      open(RF, "< $filename") || die "unable to open ${filename}";
      open(WF, "> ${filename}.new") || die "unable to open ${filename}.bak";
      while (<RF>) {
	    if ($_ =~ /^(\s)*($obj\@.+)(=.*)/) {
		  if (!$done) {
			$done = 1;
			print WF $1 . $obj . "=" . $newvalue . "\n";
		  }
	    } else {
		  $done = 0;
		  print WF $_;
	    }
      }

      close(RF);
      close(WF);
      _dol("cp -f ${filename}.new ${filename}");
      _dol("rm -f ${filename}.new");
}

1;

# Define frequently used commands
# $CMD{FSCMD}="/sbin/mycmd";

# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms
# $CMD{START}{myproc}="$CMD{FSCMD} -start";
# $CMD{STOP}{myproc}="$CMD{FSCMD} -stop";

# Define product configuration files
# $CONF{CONFIG}="/etc/myconf/config";

# Define frequently referenced paths
#$PATH{FSBIN}="/opt/VRTSvxfs/sbin";
# $PATH{FSCONF}="/etc/myconf";
#FIXME: AT prod person, make these correct
$PROD{AT}{NAME}="VERITAS Authentication Service";
$PROD{AT}{ABBR}="AT";
$PROD{AT}{DIR}="authentication_service";
$PROD{AT}{VERSION}="4.2.2.6";

# Define product information
$PROD{AT}{CLUSTER}=0;
$PROD{AT}{CONFIG}=0;
$PROD{AT}{MODES}=0;
$PROD{AT}{START}=0;

# Define drivers which must be stopped before product is installed
# /kernel/fs/vxfs
# /kernel/drv/vxportal
# /usr/kernel/drv/sparcv9/qlog
# /usr/kernel/drv/sparcv9/fdd
#
# $PROD{UMI}{DRIVERS}=["vxfs","vxportal","qlog","fdd"];

sub _at_comm_preinstall {
	_prod_plat_sub("AT", "preinstall");
}

sub _at_comm_pkgrequest_questions {
    my($iv);
    $TARGET = $LOCAL if (!$TARGET);
    _bpl("Checking for VERITAS Private Branch Exchange Service", 230, 1000);
    if ($TARGET eq "OSF1") {
      $iv=_comm_get_instpkgvers($PKGI{$TARGET}{$PROD{PBX}{$TARGET}{MAINPKG}}{SUBSET});
    } else {
      $iv=_comm_get_instpkgvers($PROD{PBX}{$TARGET}{MAINPKG});
    }
    if(!$iv) {
        _bpl("VERITAS Private Branch Exchange Service is not installed on this system.\nPlease install VERITAS Private Branch Exchange Service before you install VERITAS Authentication Service.\n", 230, 1001);
	_prtc();
            _die("Installation aborted. VERITAS Private Branch Exchange Service not installed.", 230, 1002);
    }
        _prod_plat_sub_target("AT", "pkgrequest_questions");
}

sub _at_comm_postinstall_questions {
		my($installdir);
		if (-e "/etc/vx/vss/VRTSat.loc") {
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
				if(_fc("$installdir/bin/vxatd")) {
						_prod_plat_sub_target("AT", "postinstall_questions");
				}
		}
}

sub _at_comm_create_configfiles {
		my($installdir);
		if (-e "/etc/vx/vss/VRTSat.loc") {
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
				if(_fc("$installdir/bin/vxatd")) {
						_prod_plat_sub_target("AT", "create_configfiles");
				}
		}
}

sub _at_comm_preremove {
    my($iv);
    $TARGET = $LOCAL if (!$TARGET);
    _bpl("Checking for VERITAS Authorization Service", 230, 1003);
    if ($TARGET eq "OSF1") {
      $iv=_comm_get_instpkgvers($PKGI{$TARGET}{$PROD{AZ}{$TARGET}{MAINPKG}}{SUBSET});
    }
    else {
    $iv=_comm_get_instpkgvers($PROD{AZ}{$TARGET}{MAINPKG});
    }
    if($iv) {
        _bpl("VERITAS Authorization Service which depends on VERITAS Authentication Service is still installed.\nPlease uninstall  VERITAS Authorization Service before you uninstall VERITAS Authentication Service.\n", 230, 1004);
	_prtc();
            _die("Uninstallation aborted. Dependent VERITAS Authorization Service not uninstalled.", 230, 1005);
    }
    _bpl("Checking for VERITAS Service Management Framework Service", 230, 1006);
    if ($TARGET eq "OSF1") {
      $iv=_comm_get_instpkgvers($PKGI{$TARGET}{$PROD{SMF}{$TARGET}{MAINPKG}}{SUBSET});
    }
    else {
    $iv=_comm_get_instpkgvers($PROD{SMF}{$TARGET}{MAINPKG});
    }
    if($iv) {
        _bpl("VERITAS Service Management Framework Service which depends on VERITAS Authentication Service is still installed.\nPlease uninstall VERITAS Service Management Framework before you uninstall VERITAS Authentication Service.\n", 230, 1007);
	_prtc();
            _die("Uninstallation aborted. Dependent VERITAS Service Management Framework Service not uninstalled.", 230, 1008);
    }

}
sub get_valueforname_fromfile 
{
	my $conffile = @_[0];
	my $name = @_[1];
	my @pair;
	my $line;

	open(LOCFILE, $conffile);
	my $line;
	while($line=<LOCFILE>)
	{
		chomp($line);
		if( !( $line =~ /(\s)*(#|\n)/ ))
        	{
			@pair= split /=/,$line;
			if( $pair[0] eq $name )
			{
				return $pair[1];
			}
		}
	}
	close(LOCFILE);

}

sub set_valueforname_infile
{

	my $conffile= @_[0];
	my $name = @_[1];
	my $newvalue=@_[2];

	open(CONFFILE, "+<$conffile");
	my $line;
	my $confcontent;
	while($line=<CONFFILE>)
	{
		chomp($line);
		if( !( $line =~ /(\s)*(#|\n)/ ))
		{
			my @pair= split /=/,$line;
			if( $pair[0] eq $name )
			{
				#Update the value here
				print "Updating the name $name to $newvalue from $pair[1]\n";
				my $newline="$pair[0]=$newvalue\n";
				$confcontent=$confcontent.$newline;
			}
			else
			{
				$confcontent=$confcontent.$line."\n";
			}
		}
		else
		{
			$confcontent=$confcontent.$line."\n";
		}
	}

	truncate(CONFFILE,0);
	seek(CONFFILE,0,0);
	print CONFFILE $confcontent;
	close(CONFFILE);
}

sub _at_comm_stop_processes {
	_pb1("Stopping VRTSat processes", 230, 1009);
	my($pid);
	$pid=_comm_get_pid("vxatd"); 
	while ($pid) {
			_comm_kill_proc("vxatd",$pid);
			$pid=_comm_get_pid("vxatd");
	}
	_pb2("Done", 230, 1010);
}


sub _expend_hosts {
	my($filename, $obj, %hosts) = @_;
	
	open(RF, "< $filename") || die "unable to open ${filename}";
	open(WF, "> ${filename}.new") || die "unable to open ${filename}.bak";
	while (<RF>) {
		if ($_ =~ /^(\s)*($obj(\s)*)=/) {
			foreach my $host (keys(%hosts)) {
				print WF "${1}${obj}\@${host}=$hosts{${host}}\n";
			}
		} else {
			print WF $_;
		}
	}
	
	close(RF);
	close(WF);
	_dol("cp -f ${filename}.new ${filename}");
	_dol("rm -f ${filename}.new"); 
}

sub _shrink_hosts {
	my($filename, $obj, $newvalue) = @_;
	my $done = 0;
	
	open(RF, "< $filename") || die "unable to open ${filename}";
	open(WF, "> ${filename}.new") || die "unable to open ${filename}.bak";
	while (<RF>) {
		if ($_ =~ /^(\s)*($obj\@.+)(=.*)/) {
			if (!$done) {
				$done = 1;
				print WF $1 . $obj . "=" . $newvalue . "\n";
			}
		} else {
			$done = 0;
			print WF $_;
		}
	}
	
	close(RF);
	close(WF);
	_dol("cp -f ${filename}.new ${filename}");
	_dol("rm -f ${filename}.new");
}

# Called before installing VxFS to check for upgrades
1;

# Define frequently used commands
# $CMD{FSCMD}="/sbin/mycmd";

# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms
# $CMD{START}{myproc}="$CMD{FSCMD} -start";
# $CMD{STOP}{myproc}="$CMD{FSCMD} -stop";

# Define product configuration files
# $CONF{CONFIG}="/etc/myconf/config";

# Define frequently referenced paths
#$PATH{FSBIN}="/opt/VRTSvxfs/sbin";
# $PATH{FSCONF}="/etc/myconf";
#FIXME: AZ prod person, make these correct
$PROD{AZ}{NAME}="VERITAS Authorization Service";
$PROD{AZ}{ABBR}="AZ";
$PROD{AZ}{DIR}="authorization_service";
$PROD{AZ}{VERSION}="4.2.2.6";

# Define product information
$PROD{AZ}{CLUSTER}=0;
$PROD{AZ}{CONFIG}=0;
$PROD{AZ}{MODES}=0;
$PROD{AZ}{START}=0;

# Define drivers which must be stopped before product is installed
# /kernel/fs/vxfs
# /kernel/drv/vxportal
# /usr/kernel/drv/sparcv9/qlog
# /usr/kernel/drv/sparcv9/fdd
#
# $PROD{UMI}{DRIVERS}=["vxfs","vxportal","qlog","fdd"];
# Called before installing VxFS to check for upgrades

sub _az_comm_preinstall {
	_prod_plat_sub("AZ", "preinstall");
}

sub _az_comm_pkgrequest_questions {
    my($iv);
    $TARGET = $LOCAL if (!$TARGET);
    _bpl("Checking for VERITAS Authentication Service", 240, 1000);
    if ($TARGET eq "OSF1") {
      $iv=_comm_get_instpkgvers($PKGI{$TARGET}{$PROD{AT}{$TARGET}{MAINPKG}}{SUBSET});
    } else {
      $iv=_comm_get_instpkgvers($PROD{AT}{$TARGET}{MAINPKG});
    }
    if(!$iv) {
        _bpl("VERITAS Authentication Service is not installed on this system.\nPlease install VERITAS Authentication Service before you install VERITAS Authorization Service.\n", 240, 1001);
	_prtc();
            _die("Installation aborted. VERITAS Authentication Serivce not installed.", 240, 1002);
    }

    _prod_plat_sub("AZ", "pkgrequest_questions");
}

sub _az_comm_postinstall_questions {
		my($installdir);
		if (-e "/etc/vx/vss/VRTSaz.loc") {
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
				if(_fc("$installdir/bin/vxazd")) {
						_prod_plat_sub("AZ", "postinstall_questions");
				}
		}
}

sub _az_comm_create_configfiles {
		my($installdir);
		if (-e "/etc/vx/vss/VRTSaz.loc") {
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
				if(_fc("$installdir/bin/vxazd")) {
						_prod_plat_sub("AZ", "create_configfiles");
				}
		}
}

sub _az_comm_preremove {
&_az_check_before_remove;
}

sub _az_comm_stop_processes {
		_pb1("Stopping VRTSaz processes", 240, 1003);
		my($installdir);
		if (-e "/etc/vx/vss/VRTSaz.loc") {
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
				my($pid,$count);
				$count=0;
				$pid=_comm_get_pid("vxazd"); 
				while ($pid) {
				  $count = $count + 1;
				  _dor("$installdir/bin/vrtsaz -stop force > /dev/null 2>&1");
				  $pid=_comm_get_pid("vxazd");
				  
				  if ($count > 5) {
				    _comm_kill_proc("vxazd",$pid);
				    $pid=_comm_get_pid("vxazd");
				  }
				}
				_pb2("Done", 240, 1004);
		}
		# Stop vxnetd, vradmind and vxrsyncd
}

sub _az_check_before_remove {
    my($iv);
    $TARGET = $LOCAL if (!$TARGET);
    $iv=_comm_get_instpkgvers($PROD{AZ}{$TARGET}{MAINPKG});
    if($iv) {
  if (!$CFG{AZ_CONFIRM_REMOVE}) {
    $CFG{AZ_CONFIRM_REMOVE} = _aynn("Uninstall will remove all files, including data files, associated with this product. Are you sure you want to continue?", 240, 1005);
  }
  
  _comm_cleanup(0) if ($CFG{AZ_CONFIRM_REMOVE} eq "N");
  }

}
1;

# Define product specific information
$PROD{ICS}{AIX}{MAINPKG}="VRTSsmf";
$PROD{ICS}{AIX}{UGVERS}="ALL";

# Define packages to be installed
# AT and AZ package defs are done in AT.pl and AZ.pl
$PROD{ICS}{AIX}{PKGS}=[ qw(VRTSpbx VRTSat VRTSsmf VRTSaz) ];
1;
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{PBX}{AIX}{MAINPKG}="VRTSpbx";
$PROD{PBX}{AIX}{UGVERS}="ALL";
$PROD{PBX}{AIX}{OPATCHES}=[];
$PROD{PBX}{AIX}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{PBX}{AIX}{PKGS}=[ qw(VRTSpbx) ];

# Define package information
$PKGI{AIX}{VRTSpbx}{NAME}="VERITAS Private Branch Exchange Service";
$PKGI{AIX}{VRTSpbx}{OPTIONAL}="This package provides the private branch exchange stuff.";
$PKGI{AIX}{VRTSpbx}{FILESET}="VRTSpbx.image";
$PKGI{AIX}{VRTSpbx}{SPACE}=[60000,0,1000,100];

# Language pack definitions
$PKGI{AIX}{VRTSpbx}{JA}=[ qw(VRTSpbxJA) ];
$PKGI{AIX}{VRTSpbxJA}{FILESET}="VRTSpbxJA.image";
$PKGI{AIX}{VRTSpbxJA}{SPACE}=[1000,0,100,100];
$PKGI{AIX}{VRTSpbx}{ZH}=[ qw(VRTSpbxZH) ];
$PKGI{AIX}{VRTSpbxZH}{FILESET}="VRTSpbxZH.image";
$PKGI{AIX}{VRTSpbxZH}{SPACE}=[1000,0,100,100];
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{SMF}{AIX}{MAINPKG}="VRTSsmf";
$PROD{SMF}{AIX}{UGVERS}="ALL";
$PROD{SMF}{AIX}{OPATCHES}=[];
$PROD{SMF}{AIX}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{SMF}{AIX}{PKGS}=[ qw(VRTSsmf) ];

# Define package information
$PKGI{AIX}{VRTSsmf}{NAME}="VERITAS Service Management Framework ";
$PKGI{AIX}{VRTSsmf}{OPTIONAL}="This package provides the service management framework stuff.";
$PKGI{AIX}{VRTSsmf}{FILESET}="VRTSsmf.image";
$PKGI{AIX}{VRTSsmf}{SPACE}=[60000,0,1000,100];

# Language pack definitions
$PKGI{AIX}{VRTSsmf}{JA}=[ qw(VRTSsmfJA) ];
$PKGI{AIX}{VRTSsmfJA}{FILESET}="VRTSsmfJA.image";
$PKGI{AIX}{VRTSsmfJA}{SPACE}=[1000,0,100,100];
$PKGI{AIX}{VRTSsmf}{ZH}=[ qw(VRTSsmfZH) ];
$PKGI{AIX}{VRTSsmfZH}{FILESET}="VRTSsmfZH.image";
$PKGI{AIX}{VRTSsmfZH}{SPACE}=[1000,0,100,100];
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{AT}{AIX}{MAINPKG}="VRTSat";
$PROD{AT}{AIX}{UGVERS}="ALL";
$PROD{AT}{AIX}{OPATCHES}=[];
$PROD{AT}{AIX}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{AT}{AIX}{PKGS}=[ qw(VRTSat) ];

# Define package information
$PKGI{AIX}{VRTSat}{NAME}="VERITAS Authentication Service";
$PKGI{AIX}{VRTSat}{OPTIONAL}="This package provides the authentication stuff.";
$PKGI{AIX}{VRTSat}{FILESET}="VRTSat.image";
$PKGI{AIX}{VRTSat}{SPACE}=[60000,0,1000,100];

# Language pack definitions
$PKGI{AIX}{VRTSat}{JA}=[ qw(VRTSatJA) ];
$PKGI{AIX}{VRTSatJA}{FILESET}="VRTSatJA.image";
$PKGI{AIX}{VRTSatJA}{SPACE}=[1000,0,100,100];
$PKGI{AIX}{VRTSat}{ZH}=[ qw(VRTSatZH) ];
$PKGI{AIX}{VRTSatZH}{FILESET}="VRTSatZH.image";
$PKGI{AIX}{VRTSatZH}{SPACE}=[1000,0,100,100];

# No product/platform specific subroutines are required
# Use them only if necessary

# ask configuration questions necessary following installation
#
# Function: _at_aix_postinstall_questions()
# Purpose:
#       Performs some tasks normally done by vxinstall.
# Input Parameters:
#       None
#       References $CFG{AT_RESTORE_CFG}{$SYS}
#       References $PROD{AT}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#       May update $PROD{AT}{INSTALL}{$SYS}
# Called by:
#       _at_postinstall_questions(), which is called by _comm_postinstall()
sub _at_aix_postinstall_questions {
		my($installdir,$conffile,$ipaddress,$sermode,$host);
		if (-e "/etc/vx/vss/VRTSat.loc") {
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
		}
		_title("Service Mode Configuration");
		my @mode = ("-r", "-a", "-r -a");
		$COMM{MENU}=["Root Broker Only.", "Authentication Broker Only.", "Authentication + Root Broker."];
		my $sermode=_menu("Enter the mode in which you want to install VRTSat", 233, 1000);
		$CFG{SERMODE}=$mode[$sermode-1];
		if($sermode==2){
				$CFG{ABROOT} =_ask("Enter the name of the host running the root broker:", 233, 1001);
				$COMM{DEFANSWER}="2821";
				$CFG{ABPORT} = _ask("Enter the broker port:", 233, 1002);
				$CFG{ABIDENT}=_ask("Enter authentication broker's identity:", 233, 1003);
				$CFG{ABPASS}=_ask("Enter password for $CFG{ABIDENT}:", 233, 1004, "$CFG{ABIDENT}");
				$CFG{ABDOMAIN}=_ask("Enter the domain name:", 233, 1005);
				$CFG{ABHASHFILE}=_ask("Enter the location of the file containing the root's hash:", 233, 1006);
		}
		if (-e "$installdir/bin/VxATclinput.txt") {
				$conffile = "$installdir/bin/VxATclinput.txt";
		}
		$CFG{CLUSTER_YN}=_aynn("Do you want the installer to do a cluster configuration?", 233, 1007);
		if($CFG{CLUSTER_YN} eq "Y") {
				_title("Cluster Configuration");
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "ClusterName") : "";
				$CFG{CLUSTERNAME} = _ask("Enter the logical name of the cluster:", 233, 1008);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "SystemList") : "";
				$CFG{SYSTEMLIST}= _ask("Enter the Systems which are part of this cluster:", 233, 1009);

				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "PathName") : "$installdir/bin/vxatd";
				$CFG{PROCESSPATH} = _ask("Enter the process path: ", 233, 1010);

				$ipaddress = "";
				$MSG{HELP}=_tr("Enter IP resource information", 233, 1011);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Address") : "";
				$ipaddress =_ask("Enter the IP address:", 233, 1012);
				while(_ipcheck($ipaddress))
				{
						_pl("Bad IP", 233, 1013);
						$MSG{HELP}=_tr("Enter IP resource information", 233, 1011);
						$ipaddress =_ask("Enter the IP address:", 233, 1012);
				}
				$CFG{VIRTUALIPADDRESS} = $ipaddress;
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "NetMask") : "";
				$CFG{NETMASK}=_ask("Enter the net mask:", 233, 1014);
				$COMM{DEFANSWER} = "y";
				my $perhost =_aynn("Do you wish to configure network device for each system:", 233, 1015);
				if ($perhost eq "Y") {
					my @hosts = split(" ", $CFG{SYSTEMLIST});
					my %devicesconfig;

					foreach $host (@hosts) {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Device@${host}") : "";
						@devicesconfig{$host}=_ask("Enter the network device name for ${host}:", 233, 1016, "${host}");
					}
					_expend_hosts($conffile, "Device", %devicesconfig);
				} else {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Device") : "";
					$CFG{DEVICE}=_ask("Enter the network device name:", 233, 1017);
					_shrink_hosts($conffile, "Device", $CFG{DEVICE});
				}
				$COMM{DEFANSWER} = "n";
				$perhost =_aynn("Do you wish to configure network hosts for each system:", 233, 1018);
				if ($perhost eq "Y") {
					my @hosts = split(" ", $CFG{SYSTEMLIST});
					my %hostsconfig;

					foreach my $host (@hosts) {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "NetworkHosts@${host}") : "";
						@hostsconfig{$host}=_ask("Enter the network hosts IP for ${host}:", 233, 1019, "${host}");
					}
					_expend_hosts($conffile, "NetworkHosts", %hostsconfig);
				} else {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "NetworkHosts") : "";
					$CFG{NETWORKHOSTS}=_ask("Enter the network hosts IP:", 233, 1020);
					_shrink_hosts($conffile, "NetworkHosts", $CFG{NETWORKHOSTS});
				}

				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "MountPoint") : "/var/VRTSat";
				$CFG{MOUNTPOINT} = _ask("Enter the mount point for shared storage:", 233, 1021);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "BlockDevice") : "";
				$CFG{BLOCKDEVICE} = _ask("Enter the block device for shared storage:", 233, 1022);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FSType") : "";
				$CFG{FSTYPE} = _ask("Enter the filesystem type:", 233, 1023);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FsckOpt") : "";
				$CFG{FSCKOPT} = _ask("Enter the fsck options:", 233, 1024);
				
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroupConfig") : "n";
				$CFG{DISKGROUPCONFIG} = _tolower(_aynn("Do you wish to configure disk group:", 233, 1025));
				if ($CFG{DISKGROUPCONFIG} eq "y") {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroup") : "";
					$CFG{DISKGROUP} = _ask("Enter the Disk Group:", 233, 1026);
				}

				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VolumeConfig") : "n";
				$CFG{VOLUMECONFIG} = _tolower(_aynn("Do you wish to configure volume:", 233, 1027));
				if ($CFG{VOLUMECONFIG} eq "y") {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Volume") : "";
					$CFG{VOLUME} = _ask("Enter the Volume:", 233, 1028);
				}

				if (($CFG{DISKGROUPCONFIG} eq "n")&&($CFG{VOLUMECONFIG} eq "n")) {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "AIXLVMVGConfig") : "n";
					$CFG{AIXLVMVGCONFIG} = _ask("Do you wish to configure AIX LVM Volume Group:", 233, 1029);
					if ($CFG{AIXLVMVGCONFIG} eq "y") {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VolumeGroup") : "";
						$CFG{VOLUMEGRP} = _ask("Enter the Volume Group:", 233, 1030);
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "MajorNumber") : "";
						$CFG{MAJORNUM} = _ask("Enter the Major Number:", 233, 1031);
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "ImportvgOpt") : "";
						$CFG{IMPORTVGOPT} = _ask("Enter the Import Volume Group Option:", 233, 1032);
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VaryonvgOpt") : "";
						$CFG{VARYONVGOPT} = _ask("Enter the VaryonvgOpt:", 233, 1033);
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "SyncODM") : "";
						$CFG{SYNCODM} = _ask("Enter the SyncODM:", 233, 1034);
						$perhost =_ask("Do you wish to configure disks for each system:", 233, 1035);
						if ($perhost eq "y") {
							my @hosts = split(" ", $CFG{SYSTEMLIST});
							my %disksconfig;

							foreach $host (@hosts) {
								$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Disks@${host}") : "";
								@disksconfig{$host}=_ask("Enter disks for ${host}:", 233, 1036, "${host}");
							}
							_expend_hosts($conffile, "Disks", %disksconfig);
						} else {
							$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Disks") : "";
							$CFG{DISKS}=_ask("Enter the disks:", 233, 1037);
							_shrink_hosts($conffile, "DISKS", $CFG{DISKS});
						}
					}
				}
		}
}

sub _at_aix_create_configfiles
{
		my($installdir,$conffile,$configoutput,$args);
		$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
		
		if($CFG{CLUSTER_YN} eq "Y"){
			_dol("${installdir}/bin/vssregctl -l -s -b\"Security\\Authentication\\Authentication Broker\" -t\"string\" -k\"ClusterName\" -v$CFG{CLUSTERNAME}");
		}
		
		if($CFG{SERMODE} eq "-a"){
				$args="-n $CFG{ABIDENT} -p $CFG{ABPASS} -x vx -y $CFG{ABDOMAIN} -q $CFG{ABROOT} -z $CFG{ABPORT} -h $CFG{ABHASHFILE}";
				_dol("$installdir/bin/vxatd -o -a ${args}");
		}
		else{
				_dol("$installdir/bin/vxatd -o $CFG{SERMODE}");
		}
		if($CFG{CLUSTER_YN} eq "Y"){
				_dol("${installdir}/bin/vssregctl -l -s -b\"Security\\Authentication\\Authentication Broker\" -t\"string\" -k\"ClusterName\" -v$CFG{CLUSTERNAME}");
				$conffile = "$installdir/bin/VxATclinput.txt";
				_pl("Updating the configuration file $conffile", 233, 1038, "$conffile");
				set_valueforname_infile($conffile, "SystemList", $CFG{SYSTEMLIST});
				set_valueforname_infile($conffile, "ClusterName", $CFG{CLUSTERNAME});
				
				set_valueforname_infile($conffile, "PathName", $CFG{PROCESSPATH});
				
				set_valueforname_infile($conffile, "Address", $CFG{VIRTUALIPADDRESS});
				set_valueforname_infile($conffile, "NetMask", $CFG{NETMASK});
				set_valueforname_infile($conffile, "Device", $CFG{DEVICE});
				
				set_valueforname_infile($conffile, "MountPoint", $CFG{MOUNTPOINT});
				set_valueforname_infile($conffile, "BlockDevice", $CFG{BLOCKDEVICE});
				set_valueforname_infile($conffile, "FSType", $CFG{FSTYPE});
				set_valueforname_infile($conffile, "FsckOpt", $CFG{FSCKOPT});
				
				set_valueforname_infile($conffile, "DiskGroupConfig", $CFG{DISKGROUPCONFIG});
				set_valueforname_infile($conffile, "VolumeConfig", $CFG{VOLUMECONFIG});
				set_valueforname_infile($conffile, "DiskReservationConfig", "n");
				set_valueforname_infile($conffile, "DiskGroup", $CFG{DISKGROUP});
				set_valueforname_infile($conffile, "Volume", $CFG{VOLUME});
				
				#AIX Specific
				set_valueforname_infile($conffile,"AIXLVMVGConfig",$CFG{AIXLVMVGCONFIG});
				set_valueforname_infile($conffile,"VolumeGroup",$CFG{VOLUMEGRP});
				set_valueforname_infile($conffile,"MajorNumber",$CFG{MAJORNUM});
				set_valueforname_infile($conffile,"ImportvgOpt",$CFG{IMPORTVGOPT});
				set_valueforname_infile($conffile,"VaryonvgOpt",$CFG{VARYONVGOPT});
				set_valueforname_infile($conffile,"SyncODM",$CFG{SYNCODM});
				set_valueforname_infile($conffile,"Disks",$CFG{DISKS});
				
				set_valueforname_infile($conffile,"HPLVMVolumeGroupConfig","n");
				set_valueforname_infile($conffile,"HPLVMLogicalVolumeConfig","n");

				$configoutput = _dol("$installdir/bin/VxATclconf.pl -Mn -F${conffile}");
				_p($configoutput);
				_pl($configoutput);
		}
}

#
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{AZ}{AIX}{MAINPKG}="VRTSaz";
$PROD{AZ}{AIX}{UGVERS}="ALL";
$PROD{AZ}{AIX}{OPATCHES}=[];
$PROD{AZ}{AIX}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{AZ}{AIX}{PKGS}=[ qw(VRTSaz) ];

# Define package information
$PKGI{AIX}{VRTSaz}{NAME}="VERITAS Authorization Service";
$PKGI{AIX}{VRTSaz}{OPTIONAL}="This package provides the authorization stuff.";
$PKGI{AIX}{VRTSaz}{FILESET}="VRTSaz.image";
$PKGI{AIX}{VRTSaz}{SPACE}=[80000,0,5000,100];

# Language pack definitions
$PKGI{AIX}{VRTSaz}{JA}=[ qw(VRTSazJA) ];
$PKGI{AIX}{VRTSazJA}{FILESET}="VRTSazJA.image";
$PKGI{AIX}{VRTSazJA}{SPACE}=[1000,0,100,100];
$PKGI{AIX}{VRTSaz}{ZH}=[ qw(VRTSazZH) ];
$PKGI{AIX}{VRTSazZH}{FILESET}="VRTSazZH.image";
$PKGI{AIX}{VRTSazZH}{SPACE}=[1000,0,100,100];

# No product/platform specific subroutines are required
# Use them only if necessary

# ask configuration questions necessary following installation
#
# Function: _at_hp_postinstall_questions()
# Purpose:
#       Performs some tasks normally done by vxinstall.
# Input Parameters:
#       None
#       References $CFG{AZ_RESTORE_CFG}{$SYS}
#       References $PROD{AZ}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#       May update $PROD{AZ}{INSTALL}{$SYS}
# Called by:
#       _az_postinstall_questions(), which is called by _comm_postinstall()


sub _az_aix_postinstall_questions {
		my ($installdir,$conffile);
		if (-e "/etc/vx/vss/VRTSaz.loc") {
			$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
		}
		if (-e "$installdir/bin/vrtsaz_clinput.txt") {
			$conffile = "$installdir/bin/vrtsaz_clinput.txt";
		}
		
		$CFG{CLUSTER_YN}=_aynn("Do you want the installer to do a cluster configuration?", 243, 1000);
		if($CFG{CLUSTER_YN} eq "Y") {
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "SystemList") : "";
			$CFG{SYSTEMLIST} = _ask("Enter the systems which are part of this cluster:", 243, 1001);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "ClusterName") : "";
			$CFG{CLUSTERNAME} = _ask("Enter the logical name of the cluster:", 243, 1002);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "BlockDevice") : "";
			$CFG{BLOCKDEVICE} = _ask("Enter the block device for shared storage:", 243, 1003);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroupConfig") : "y";
			$CFG{DISKGROUPCONFIG} = _ask("Do you wish to configure disk group:", 243, 1004);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroup") : "";
			$CFG{DISKGROUP} = _ask("Enter the disk group config:", 243, 1005);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VolumeConfig") : "y";
			$CFG{VOLUMECONFIG} = _ask("Do you wish to configure volume:", 243, 1006);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Volume") : "";
			$CFG{VOLUME} = _ask("Enter the volume configuration:", 243, 1007);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FSType") : "vxfs";
			$CFG{FSTYPE} = _ask("Enter the filesystem type:", 243, 1008);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FsckOpt") : "%-y";
			$CFG{FSCKOPT} = _ask("Enter the fsck options:", 243, 1009);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DeleteOldResources") : "n";
			$CFG{DELETEOLDRESOURCES} = _ask("Do you want to delete old resources if any:", 243, 1010);
			if (-d "/opt/VRTSvcs") {
				$CFG{VCSHOME} = "/opt/VRTSvcs";
			} else {
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VcsHome") : "/opt/VRTSvcs";
				$CFG{VCSHOME} = _ask("What is the VCS home directory:", 243, 1011);
			}
		}
}

sub _az_aix_create_configfiles
{
		my ($installdir,$conffile,$configoutput);
		$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
		$conffile = "$installdir/bin/vrtsaz_clinput.txt";
		
		if($CFG{CLUSTER_YN} eq "Y") {
			_pl("Updating the configuration file $conffile", 243, 1012, "$conffile");

			# Application Section.
			set_valueforname_infile($conffile, "StartProgram", "$installdir/bin/vrtsaz");
			set_valueforname_infile($conffile, "StopProgram", "\"$installdir/bin/vrtsaz -stop\"");
			set_valueforname_infile($conffile, "CleanProgram", "\"$installdir/bin/vrtsaz -stop force\"");
			set_valueforname_infile($conffile, "MonitorProcesses", "$installdir/bin/vxazd");

			# Mount Section
			set_valueforname_infile($conffile, "MountPoint", "/var/VRTSaz/shared");
			set_valueforname_infile($conffile, "BlockDevice", $CFG{BLOCKDEVICE});
			set_valueforname_infile($conffile, "FSType", $CFG{FSTYPE});
			set_valueforname_infile($conffile, "FsckOpt", $CFG{FSCKOPT});

			# Diskgroup Section
			set_valueforname_infile($conffile, "DiskGroup", $CFG{DISKGROUP});

			# Volume Section
			set_valueforname_infile($conffile, "Volume", $CFG{VOLUME});

			# Gen Section
			set_valueforname_infile($conffile, "ClusterName", $CFG{CLUSTERNAME});
			set_valueforname_infile($conffile, "SystemList", $CFG{SYSTEMLIST});
			set_valueforname_infile($conffile, "DeleteOldResources", $CFG{DELETEOLDRESOURCES});
			set_valueforname_infile($conffile, "InstallDir", $installdir);
			set_valueforname_infile($conffile, "VcsHome",  $CFG{VCSHOME});
			set_valueforname_infile($conffile, "HPLVMVolumeGroupConfig", "n");
			set_valueforname_infile($conffile, "HPLVMLogicalVolumeConfig", "n");
			set_valueforname_infile($conffile, "DiskGroupConfig", $CFG{DISKGROUPCONFIG});
			set_valueforname_infile($conffile, "VolumeConfig", $CFG{VOLUMECONFIG});
			set_valueforname_infile($conffile, "DiskReservationConfig", "n");
			set_valueforname_infile($conffile, "StartVolumes", "1");
			set_valueforname_infile($conffile, "StopVolumes", "1");
			$configoutput = _dol("./perl/bin/perl $installdir/bin/vrtsaz_clconf.pl -Mn -F${conffile} -l");
			$FLAG{CONFIGFAILED} = 1;
			if ($configoutput =~ /Configuration is complete\./ ) {
				$FLAG{CONFIGFAILED} = 0;
			}
			_p($configoutput);
			_pl($configoutput);
		}
}

# Define product specific information
$PROD{ICS}{HPUX}{MAINPKG}="VRTSsmf";
$PROD{ICS}{HPUX}{UGVERS}="ALL";

# Define packages to be installed
# AT and AZ package defs are done in AT.pl and AZ.pl
$PROD{ICS}{HPUX}{PKGS}=[ qw(VRTSpbx VRTSat VRTSsmf VRTSaz) ];
1;

# Define product specific information
$PROD{PBX}{HPUX}{MAINPKG}="VRTSpbx";
$PROD{PBX}{HPUX}{UGVERS}="ALL";

# Define packages to be installed, per product mode
#
$PROD{PBX}{HPUX}{PKGS}=[ qw(VRTSpbx) ];

$PKGI{HPUX}{VRTSpbx}{NAME}="VERITAS Private Branch Exchange";
$PKGI{HPUX}{VRTSpbx}{OPTIONAL}="This package provides the ICS Private Branch Exchange.";
$PKGI{HPUX}{VRTSpbx}{DEPS}=[ "VRTSsmf" ];

1;
# Define product specific information
$PROD{SMF}{HPUX}{MAINPKG}="VRTSsmf";
$PROD{SMF}{HPUX}{UGVERS}="ALL";

# Define packages to be installed, per product mode
#
$PROD{SMF}{HPUX}{PKGS}=[ qw(VRTSsmf) ];

$PKGI{HPUX}{VRTSsmf}{NAME}="VERITAS Service Management Framework";
$PKGI{HPUX}{VRTSsmf}{OPTIONAL}="This package provides the ICS Service Management Framework.";

1;
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{AT}{HPUX}{MAINPKG}="VRTSat";
$PROD{AT}{HPUX}{UGVERS}="ALL";
$PROD{AT}{HPUX}{OPATCHES}=[];
$PROD{AT}{HPUX}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{AT}{HPUX}{PKGS}=[ qw(VRTSat) ];

# Define package information
$PKGI{HPUX}{VRTSat}{SPACE}=[60000,0,1000,100];
$PKGI{HPUX}{VRTSat}{NAME}="VERITAS Authentication Service";
$PKGI{HPUX}{VRTSat}{OPTIONAL}="This package provides the authentication stuff.";

# Language pack definitions
$PKGI{HPUX}{VRTSat}{JA}=[ qw(VRTSatJA) ];
$PKGI{HPUX}{VRTSatJA}{DEPOT}="VRTSatJA";
$PKGI{HPUX}{VRTSatJA}{SPACE}=[1000,0,100,100];
$PKGI{HPUX}{VRTSat}{ZH}=[ qw(VRTSatZH) ];
$PKGI{HPUX}{VRTSatZH}{DEPOT}="VRTSatZH";
$PKGI{HPUX}{VRTSatZH}{SPACE}=[1000,0,100,100];

# No product/platform specific subroutines are required
# Use them only if necessary


#
# Function: _at_hp_request()
# Purpose:
#       Implements a task of VRTSat's request script.
#       Note: Not called for -configure
# Input Parameters:
#       References $PROD{AT}{REBOOT}{$SYS}
# Output Parameters:
#       It indirectly creates $CFG{AT_RESTORE_CFG}{$SYS}.
# Called by:
#       _at_hp_pkgrequest_questions()

sub _at_hp_pkgrequest_questions
{
#		_at_hp_request();
}

# ask configuration questions necessary following installation
#
# Function: _at_hp_postinstall_questions()
# Purpose:
#       Performs some tasks normally done by vxinstall.
# Input Parameters:
#       None
#       References $CFG{AT_RESTORE_CFG}{$SYS}
#       References $PROD{AT}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#       May update $PROD{AT}{INSTALL}{$SYS}
# Called by:
#       _at_postinstall_questions(), which is called by _comm_postinstall()
sub _at_hp_postinstall_questions {
		my($installdir,$conffile,$ipaddress,$sermode,$host);
		if (-e "/etc/vx/vss/VRTSat.loc") {
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
		}
		_title("Service Mode Configuration");
		my @mode = ("-r", "-a", "-r -a");
		$COMM{MENU}=["Root Broker Only.", "Authentication Broker Only.", "Authentication + Root Broker."];
		my $sermode=_menu("Enter the mode in which you want to install VRTSat", 234, 1000);
		$CFG{SERMODE}=$mode[$sermode-1];
		if($sermode==2){
				$CFG{ABROOT} =_ask("Enter the name of the host running the root broker:", 234, 1001);
				$COMM{DEFANSWER}="2821";
				$CFG{ABPORT} = _ask("Enter the broker port:", 234, 1002);
				$CFG{ABIDENT}=_ask("Enter authentication broker's identity:", 234, 1003);
				$CFG{ABPASS}=_ask("Enter password for $CFG{ABIDENT}:", 234, 1004, "$CFG{ABIDENT}");
				$CFG{ABDOMAIN}=_ask("Enter the domain name:", 234, 1005);
				$CFG{ABHASHFILE}=_ask("Enter the location of the file containing the root's hash:", 234, 1006);
		}
		if (-e "$installdir/bin/VxATclinput.txt") {
				$conffile = "$installdir/bin/VxATclinput.txt";
		}
		$CFG{CLUSTER_YN}=_aynn("Do you want the installer to do a cluster configuration?", 234, 1007);
		if($CFG{CLUSTER_YN} eq "Y") {
				_title("Cluster Configuration");
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "ClusterName") : "";
				$CFG{CLUSTERNAME} = _ask("Enter the logical name of the cluster:", 234, 1008);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "SystemList") : "";
				$CFG{SYSTEMLIST}= _ask("Enter the Systems which are part of this cluster:", 234, 1009);
				
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "PathName") : "$installdir/bin/vxatd";
				$CFG{PROCESSPATH} = _ask("Enter the process path: ", 234, 1010);
				
				$ipaddress = "";
				$MSG{HELP}=_tr("Enter IP resource information", 234, 1011);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Address") : "";
				$ipaddress =_ask("Enter the IP address:", 234, 1012);
				while(_ipcheck($ipaddress))
				{
						_pl("Bad IP", 234, 1013);
						$MSG{HELP}=_tr("Enter IP resource information", 234, 1011);
						$ipaddress =_ask("Enter the IP address:", 234, 1012);
				}
				$CFG{VIRTUALIPADDRESS} = $ipaddress;
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "NetMask") : "";
				$CFG{NETMASK}=_ask("Enter the net mask:", 234, 1014);
				$COMM{DEFANSWER} = "y";
				my $perhost =_aynn("Do you wish to configure network device for each system:", 234, 1015);
				if ($perhost eq "Y") {
					my @hosts = split(" ", $CFG{SYSTEMLIST});
					my %devicesconfig;

					foreach $host (@hosts) {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Device@${host}") : "";
						@devicesconfig{$host}=_ask("Enter the network device name for ${host}:", 234, 1016, "${host}");
					}
					_expend_hosts($conffile, "Device", %devicesconfig);
				} else {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Device") : "";
					$CFG{DEVICE}=_ask("Enter the network device name:", 234, 1017);
					_shrink_hosts($conffile, "Device", $CFG{DEVICE});
				}
				$COMM{DEFANSWER} = "n";
				$perhost =_aynn("Do you wish to configure network hosts for each system:", 234, 1018);
				if ($perhost eq "Y") {
					my @hosts = split(" ", $CFG{SYSTEMLIST});
					my %hostsconfig;

					foreach my $host (@hosts) {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "NetworkHosts@${host}") : "";
						@hostsconfig{$host}=_ask("Enter the network hosts IP for ${host}:", 234, 1019, "${host}");
					}
					_expend_hosts($conffile, "NetworkHosts", %hostsconfig);
				} else {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "NetworkHosts") : "";
					$CFG{NETWORKHOSTS}=_ask("Enter the network hosts IP:", 234, 1020);
					_shrink_hosts($conffile, "NetworkHosts", $CFG{NETWORKHOSTS});
				}
				
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "MountPoint") : "/var/VRTSat";
				$CFG{MOUNTPOINT} = _ask("Enter the mount point for shared storage:", 234, 1021);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "BlockDevice") : "";
				$CFG{BLOCKDEVICE} = _ask("Enter the block device for shared storage:", 234, 1022);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FSType") : "";
				$CFG{FSTYPE} = _ask("Enter the filesystem type:", 234, 1023);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FsckOpt") : "";
				$CFG{FSCKOPT} = _ask("Enter the fsck options:", 234, 1024);
				
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroupConfig") : "n";
				$CFG{DISKGROUPCONFIG} = _tolower(_aynn("Do you wish to configure disk group:", 234, 1025));
				if ($CFG{DISKGROUPCONFIG} eq "y") {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroup") : "";
					$CFG{DISKGROUP} = _ask("Enter the Disk Group:", 234, 1026);
				}
				
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VolumeConfig") : "n";
				$CFG{VOLUMECONFIG} = _tolower(_aynn("Do you wish to configure volume:", 234, 1027));
				if ($CFG{VOLUMECONFIG} eq "y") {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Volume") : "";
					$CFG{VOLUME} = _ask("Enter the Volume:", 234, 1028);
				}
				
				if (($CFG{DISKGROUPCONFIG} eq "n")&&($CFG{VOLUMECONFIG} eq "n")) {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "HPLVMVolumeGroupConfig") : "n";
					$CFG{HPLVMVOLUMEGROUPCONFIG} = _ask("Do you wish to configure HP LVM Volume Group:", 234, 1029);
					if ($CFG{HPLVMVOLUMEGROUPCONFIG} eq "y") {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VolumeGroup") : "";
						$CFG{VOLUMEGRP} = _ask("Enter the Volume Group:", 234, 1030);
					}
					
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "HPLVMLogicalVolumeConfig") : "n";
					$CFG{HPLVMLOGICALVOLUMECONFIG} = _ask("Do you wish to configure HP LVM Logical Volume Group:", 234, 1031);
					if ($CFG{HPLVMLOGICALVOLUMECONFIG} eq "y") {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VolumeGroup") : "";
						$CFG{VOLUMEGRP} = _ask("Enter the Volume Group:", 234, 1030);
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "LogicalVolume") : "";
						$CFG{LOGVOLUME} = _ask("Enter the Logical Volume:", 234, 1032);
					}
				} else {
					$CFG{HPLVMVOLUMEGROUPCONFIG} = "n";
					$CFG{HPLVMLOGICALVOLUMECONFIG} = "n";
				}
		}
}

sub _at_hp_create_configfiles
{
		my($installdir,$conffile,$configoutput,$args);
		$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
		
		if($CFG{CLUSTER_YN} eq "Y"){
			_dol("${installdir}/bin/vssregctl -l -s -b\"Security\\Authentication\\Authentication Broker\" -t\"string\" -k\"ClusterName\" -v$CFG{CLUSTERNAME}");
		}
		
		if($CFG{SERMODE} eq "-a"){
				$args="-n $CFG{ABIDENT} -p $CFG{ABPASS} -x vx -y $CFG{ABDOMAIN} -q $CFG{ABROOT} -z $CFG{ABPORT} -h $CFG{ABHASHFILE}";
				_dol("$installdir/bin/vxatd -o -a ${args}");
		}
		else{
				_dol("$installdir/bin/vxatd -o $CFG{SERMODE}");
		}
		if($CFG{CLUSTER_YN} eq "Y"){
				_dol("${installdir}/bin/vssregctl -l -s -b\"Security\\Authentication\\Authentication Broker\" -t\"string\" -k\"ClusterName\" -v$CFG{CLUSTERNAME}");
				$conffile = "$installdir/bin/VxATclinput.txt";
				_pl("Updating the configuration file $conffile", 234, 1033, "$conffile");
				set_valueforname_infile($conffile, "SystemList", $CFG{SYSTEMLIST});
				set_valueforname_infile($conffile, "ClusterName", $CFG{CLUSTERNAME});
				
				set_valueforname_infile($conffile, "PathName", $CFG{PROCESSPATH});
				
				set_valueforname_infile($conffile, "Address", $CFG{VIRTUALIPADDRESS});
				set_valueforname_infile($conffile, "NetMask", $CFG{NETMASK});
				set_valueforname_infile($conffile, "Device", $CFG{DEVICE});
				
				set_valueforname_infile($conffile, "NetworkHosts", $CFG{NETWORKHOSTS});
				
				set_valueforname_infile($conffile, "MountPoint", $CFG{MOUNTPOINT});
				set_valueforname_infile($conffile, "BlockDevice", $CFG{BLOCKDEVICE});
				set_valueforname_infile($conffile, "FSType", $CFG{FSTYPE});
				set_valueforname_infile($conffile, "FsckOpt", $CFG{FSCKOPT});
				
				set_valueforname_infile($conffile, "DiskGroupConfig", $CFG{DISKGROUPCONFIG});
				set_valueforname_infile($conffile, "DiskGroup", $CFG{DISKGROUP});
				
				set_valueforname_infile($conffile, "VolumeConfig", $CFG{VOLUMECONFIG});
				set_valueforname_infile($conffile, "Volume", $CFG{VOLUME});
				
				#HP Specific
				set_valueforname_infile($conffile, "HPLVMVolumeGroupConfig", $CFG{HPLVMVOLUMEGROUPCONFIG});
				set_valueforname_infile($conffile, "LogicalVolume", $CFG{LOGVOLUME});
				set_valueforname_infile($conffile, "VolumeGroup", $CFG{VOLUMEGRP});
				set_valueforname_infile($conffile, "HPLVMLogicalVolumeConfig", $CFG{HPLVMLOGICALVOLUMECONFIG});
				
				set_valueforname_infile($conffile, "DiskReservationConfig", "n");
				set_valueforname_infile($conffile, "AIXLVMVGConfig", "n");
				
				$configoutput = _dol("$installdir/bin/VxATclconf.pl -Mn -F${conffile}");
				_p($configoutput);
				_pl($configoutput);
		}
}


# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{AZ}{HPUX}{MAINPKG}="VRTSaz";
$PROD{AZ}{HPUX}{UGVERS}="ALL";
$PROD{AZ}{HPUX}{OPATCHES}=[];
$PROD{AZ}{HPUX}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{AZ}{HPUX}{PKGS}=[ qw(VRTSaz) ];

# Define package information
$PKGI{HPUX}{VRTSaz}{SPACE}=[120000,0,5000,200];
$PKGI{HPUX}{VRTSaz}{NAME}="VERITAS Authorization Service";
$PKGI{HPUX}{VRTSaz}{OPTIONAL}="This package provides the authorization stuff.";

# Language pack definitions
$PKGI{HPUX}{VRTSaz}{JA}=[ qw(VRTSazJA) ];
$PKGI{HPUX}{VRTSazJA}{DEPOT}="VRTSazJA";
$PKGI{HPUX}{VRTSazJA}{SPACE}=[1000,0,100,100];
$PKGI{HPUX}{VRTSaz}{ZH}=[ qw(VRTSazZH) ];
$PKGI{HPUX}{VRTSazZH}{DEPOT}="VRTSazZH";
$PKGI{HPUX}{VRTSazZH}{SPACE}=[1000,0,100,100];

# No product/platform specific subroutines are required
# Use them only if necessary


# Function: _az_hp_request()
# Purpose:
#       Implements a task of VRTSat's request script.
#       Note: Not called for -configure
# Input Parameters:
#       References $PROD{AZ}{REBOOT}{$SYS}
# Output Parameters:
#       It indirectly creates $CFG{AZ_RESTORE_CFG}{$SYS}.
# Called by:
#       _az_hp_pkgrequest_questions()

# ask configuration questions necessary following installation
#
# Function: _at_hp_postinstall_questions()
# Purpose:
#       Performs some tasks normally done by vxinstall.
# Input Parameters:
#       None
#       References $CFG{AZ_RESTORE_CFG}{$SYS}
#       References $PROD{AZ}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#       May update $PROD{AZ}{INSTALL}{$SYS}
# Called by:
#       _az_postinstall_questions(), which is called by _comm_postinstall()
sub _az_hp_postinstall_questions {
		my ($installdir,$conffile);
		if (-e "/etc/vx/vss/VRTSaz.loc") {
			$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
		}
		if (-e "$installdir/bin/vrtsaz_clinput.txt") {
			$conffile = "$installdir/bin/vrtsaz_clinput.txt";
		}

		$CFG{CLUSTER_YN}=_aynn("Do you want the installer to do a cluster configuration?", 244, 1000);
		if($CFG{CLUSTER_YN} eq "Y") {
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "ClusterName") : "";
			$CFG{CLUSTERNAME} = _ask("Enter the logical name of the cluster:", 244, 1001);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "SystemList") : "";

			$CFG{SYSTEMLIST} = _ask("Enter the systems which are part of this cluster:", 244, 1002);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "BlockDevice") : "";
			$CFG{BLOCKDEVICE} = _ask("Enter the block device for shared storage:", 244, 1003);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroupConfig") : "y";
			$CFG{DISKGROUPCONFIG} = _ask("Do you wish to configure disk group:", 244, 1004);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroup") : "";
			$CFG{DISKGROUP} = _ask("Enter the disk group config:", 244, 1005);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VolumeConfig") : "y";
			$CFG{VOLUMECONFIG} = _ask("Do you wish to configure volume:", 244, 1006);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Volume") : "";
			$CFG{VOLUME} = _ask("Enter the volume configuration:", 244, 1007);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FSType") : "vxfs";
			$CFG{FSTYPE} = _ask("Enter the filesystem type:", 244, 1008);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FsckOpt") : "%-y";
			$CFG{FSCKOPT} = _ask("Enter the fsck options:", 244, 1009);

			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DeleteOldResources") : "n";
			$CFG{DELETEOLDRESOURCES} = _ask("Do you want to delete old resources if any:", 244, 1010);
			if (-d "/opt/VRTSvcs") {
				$CFG{VCSHOME} = "/opt/VRTSvcs";
			} else {
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VcsHome") : "/opt/VRTSvcs";
				$CFG{VCSHOME} = _ask("What is the VCS home directory:", 244, 1011);
			}
		}
}

sub _az_hp_create_configfiles
{
		my ($installdir,$conffile,$configoutput);
		$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
		$conffile = "$installdir/bin/vrtsaz_clinput.txt";

		if($CFG{CLUSTER_YN} eq "Y") {
			_pl("Updating the configuration file $conffile", 244, 1012, "$conffile");

			# Application Section.
			set_valueforname_infile($conffile, "StartProgram", "$installdir/bin/vrtsaz");
			set_valueforname_infile($conffile, "StopProgram", "\"$installdir/bin/vrtsaz -stop\"");
			set_valueforname_infile($conffile, "CleanProgram", "\"$installdir/bin/vrtsaz -stop force\"");
			set_valueforname_infile($conffile, "MonitorProcesses", "$installdir/bin/vxazd");

			# Mount Section
			set_valueforname_infile($conffile, "MountPoint", "/var/VRTSaz/shared");
			set_valueforname_infile($conffile, "BlockDevice", $CFG{BLOCKDEVICE});
			set_valueforname_infile($conffile, "FSType", $CFG{FSTYPE});
			set_valueforname_infile($conffile, "FsckOpt", $CFG{FSCKOPT});

			# Diskgroup Section
			set_valueforname_infile($conffile, "DiskGroup", $CFG{DISKGROUP});

			# Volume Section
			set_valueforname_infile($conffile, "Volume", $CFG{VOLUME});

			# Gen Section
			set_valueforname_infile($conffile, "ClusterName", $CFG{CLUSTERNAME});
			set_valueforname_infile($conffile, "SystemList", $CFG{SYSTEMLIST});
			set_valueforname_infile($conffile, "DeleteOldResources", $CFG{DELETEOLDRESOURCES});
			set_valueforname_infile($conffile, "InstallDir", $installdir);
			set_valueforname_infile($conffile, "VcsHome",  $CFG{VCSHOME});
			set_valueforname_infile($conffile, "HPLVMVolumeGroupConfig", "n");
			set_valueforname_infile($conffile, "HPLVMLogicalVolumeConfig", "n");
			set_valueforname_infile($conffile, "DiskGroupConfig", $CFG{DISKGROUPCONFIG});
			set_valueforname_infile($conffile, "VolumeConfig", $CFG{VOLUMECONFIG});
			set_valueforname_infile($conffile, "DiskReservationConfig", "n");
			set_valueforname_infile($conffile, "StartVolumes", "1");
			set_valueforname_infile($conffile, "StopVolumes", "1");
			$configoutput = _dol("./perl/bin/perl $installdir/bin/vrtsaz_clconf.pl -Mn -F${conffile} -l");
			$FLAG{CONFIGFAILED} = 1;
			if ($configoutput =~ /Configuration is complete\./ ) {
				$FLAG{CONFIGFAILED} = 0;
			}
			_p($configoutput);
			_pl($configoutput);
		}
}

# Define product specific information
$PROD{ICS}{Linux}{MAINPKG}="VRTSsmf";
$PROD{ICS}{Linux}{UGVERS}="ALL";

# Define packages to be installed, per product mode
#
$PROD{ICS}{Linux}{PKGS}=[ qw(VRTSpbx VRTSatClient VRTSatServer VRTSsmf VRTSazClient VRTSazServer ) ];
1;

# Define product specific information
$PROD{PBX}{Linux}{MAINPKG}="VRTSpbx";
$PROD{PBX}{Linux}{UGVERS}="ALL";

# Define packages to be installed, per product mode
#
$PROD{PBX}{Linux}{PKGS}=[ qw(VRTSpbx) ];

$PKGI{Linux}{VRTSpbx}{NAME}="VERITAS Private Branch Exchange";
$PKGI{Linux}{VRTSpbx}{OPTIONAL}="VRTSpbx provides a socket demulitplexer for ICS.";
$PKGI{Linux}{VRTSpbx}{RPM}="VRTSpbx-2.01.001-2.i386.rpm";
$PKGI{Linux}{VRTSpbx}{DEPS}=[ "VRTSsmf" ];

1;

# Define product specific information
$PROD{SMF}{Linux}{MAINPKG}="VRTSsmf";
$PROD{SMF}{Linux}{UGVERS}="ALL";

# Define packages to be installed, per product mode
#
$PROD{SMF}{Linux}{PKGS}=[ qw(VRTSsmf) ];

$PKGI{Linux}{VRTSsmf}{NAME}="VERITAS Service Management Framework";
$PKGI{Linux}{VRTSsmf}{OPTIONAL}="This package provides the VERITAS Service Management Framework.";
$PKGI{Linux}{VRTSsmf}{RPM}="VRTSsmf-1.01.006-1.i386.rpm";


1;
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{AT}{Linux}{MAINPKG}="VRTSatClient";
$PROD{AT}{Linux}{UGVERS}="ALL";
$PROD{AT}{Linux}{OPATCHES}=[];
$PROD{AT}{Linux}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{AT}{Linux}{PKGS}=[ qw(VRTSatClient VRTSatServer) ];

# Define package information
$PKGI{Linux}{VRTSatClient}{NAME}="VERITAS Authentication Client";
$PKGI{Linux}{VRTSatClient}{OPTIONAL}="This package provides the authentication client.";
$PKGI{Linux}{VRTSatClient}{RPM}="VRTSatClient-4.2.2.6-1.i386.rpm";
$PKGI{Linux}{VRTSatServer}{NAME}="VERITAS Authentication Server";
$PKGI{Linux}{VRTSatServer}{DEPS}=[ "VRTSatClient" ];
$PKGI{Linux}{VRTSatServer}{OPTIONAL}="This package provides the authentication server.";
$PKGI{Linux}{VRTSatServer}{RPM}="VRTSatServer-4.2.2.6-1.i386.rpm";
$PKGI{Linux}{VRTSatServer}{SPACE}=[50000,0,10000,100];
$PKGI{Linux}{VRTSatClient}{SPACE}=[50000,0,10000,100];

# Language definitions
$PKGI{Linux}{VRTSatClient}{JA}=[ qw(VRTSatJA) ];
$PKGI{Linux}{VRTSatJA}{RPM}="VRTSatJA-4.2.2.6-1.i386.rpm";
$PKGI{Linux}{VRTSatJA}{SPACE}=[1000,0,100,100];
$PKGI{Linux}{VRTSatClient}{ZH}=[ qw(VRTSatZH) ];
$PKGI{Linux}{VRTSatZH}{RPM}="VRTSatZH-4.2.2.6-1.i386.rpm";
$PKGI{Linux}{VRTSatZH}{SPACE}=[1000,0,100,100];


# No product/platform specific subroutines are required
# Use them only if necessary

# ask configuration questions necessary following installation
#
# Function: _at_linux_postinstall_questions()
# Purpose:
#       Performs some tasks normally done by vxinstall.
# Input Parameters:
#       None
#       References $CFG{AT_RESTORE_CFG}{$SYS}
#       References $PROD{AT}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#       May update $PROD{AT}{INSTALL}{$SYS}
# Called by:
#       _at_postinstall_questions(), which is called by _comm_postinstall()

sub _at_linux_pkgrequest_questions {
    my($glibvers,$glibreqd,$redhat,$ans);
    $redhat = _linux_get_instpkgvers("redhat-release");
    if(_cv($redhat,"8.0") == 0){
        $glibvers = _linux_get_instpkgvers("glibc");
        $glibreqd = "2.3.1";
        if(_cv($glibvers,$glibreqd) == 2){
            _bpl("VERITAS Authentication Service requires a glibc version >= $glibreqd to function properly.\n ", 232, 1000, "$glibreqd");
            $ans = _aynn("The system has version $glibvers. Do you wish to continue", 232, 1001, "$glibvers");
            if(_tolower($ans) eq "n"){
                _die("Installation aborted. Incompatible glibc version.", 232, 1002);
            }
        }
    }
}

sub _at_linux_postinstall_questions {
		my($installdir,$conffile,$ipaddress,$sermode);
		if (-e "/etc/vx/vss/VRTSat.loc") {
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
		}
		_title("Service Mode Configuration");
		my @mode = ("-r", "-a", "-r -a");
		$COMM{MENU}=["Root Broker Only.", "Authentication Broker Only.", "Authentication + Root Broker."];
		my $sermode=_menu("Enter the mode in which you want to install VRTSat", 232, 1003);
		$CFG{SERMODE}=$mode[$sermode-1];
		if($sermode==2){
				$CFG{ABROOT} =_ask("Enter the name of the host running the root broker", 232, 1004);
				$COMM{DEFANSWER}="2821";
				$CFG{ABPORT} = _ask("Enter the broker port", 232, 1005);
				$CFG{ABIDENT}=_ask("Enter authentication broker's identity", 232, 1006);
				$CFG{ABPASS}=_ask("Enter password for $CFG{ABIDENT}", 232, 1007, "$CFG{ABIDENT}");
				$CFG{ABDOMAIN}=_ask("Enter the domain name", 232, 1008);
				$CFG{ABHASHFILE}=_ask("Enter the location of the file containing the root's hash", 232, 1009);
		}
		if (-e "$installdir/bin/VxATclinput.txt") {
				$conffile = "$installdir/bin/VxATclinput.txt";
		}
		$CFG{CLUSTER_YN}=_aynn("Do you want the installer to do a cluster configuration?", 232, 1010);
		if($CFG{CLUSTER_YN} eq "Y") {
				_title("Cluster Configuration");
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "ClusterName") : "";
				$CFG{CLUSTERNAME} = _ask("Enter the logical name of the cluster:", 232, 1011);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "SystemList") : "";		
				$CFG{SYSTEMLIST}= _ask("Enter the Systems  which are part of this cluster:", 232, 1012);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskReservationConfig") : "";
				$CFG{DISKRESERVATIONCONFIG} = _ask("Do you want to do Disk reservation config?:", 232, 1013);
				
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "PathName") : "$installdir/bin/vxatd";
				$CFG{PROCESSPATH} = _ask("Enter the process path: ", 232, 1014);
				
				$ipaddress = "";
				$MSG{HELP}=_tr("Enter IP resource information", 232, 1015);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Address") : "";
				$ipaddress =_ask("Enter the IP address:", 232, 1016);
				while(_ipcheck($ipaddress))
				{
						_pl("Bad IP", 232, 1017);
						$MSG{HELP}=_tr("Enter IP resource information", 232, 1015);
						$ipaddress =_ask("Enter the IP address:", 232, 1016);
				}
				$CFG{VIRTUALIPADDRESS} = $ipaddress;
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "NetMask") : "";
				$CFG{NETMASK}=_ask("Enter the net mask:", 232, 1018);
				my $perhost =_aynn("Do you wish to configure network device for each system:", 232, 1019);
				if ($perhost eq "Y") {
					my @hosts = split(" ", $CFG{SYSTEMLIST});
					my %devicesconfig;
					
					foreach my $host (@hosts) {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Device@${host}") : "";
				          	@devicesconfig{$host}=_ask("Enter the network device name for ${host}:", 232, 1020, "${host}");
				        }
				        _expend_hosts($conffile, "Device", %devicesconfig);
				} else {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Device") : "";
				        $CFG{DEVICE}=_ask("Enter the network device name:", 232, 1021);
				        _shrink_hosts($conffile, "Device", $CFG{DEVICE});
				}
				$perhost =_aynn("Do you wish to configure network hosts for each system:", 232, 1022);
				if ($perhost eq "Y") {
					my @hosts = split(" ", $CFG{SYSTEMLIST});
					my %hostsconfig;

					foreach my $host (@hosts) {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "NetworkHosts@${host}") : "";
						@hostsconfig{$host}=_ask("Enter the network hosts IP for ${host}:", 232, 1023, "${host}");
					}
					_expend_hosts($conffile, "NetworkHosts", %hostsconfig);
				} else {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "NetworkHosts") : "";
					$CFG{NETWORKHOSTS}=_ask("Enter the network hosts IP:", 232, 1024);
					_shrink_hosts($conffile, "NetworkHosts", $CFG{NETWORKHOSTS});
				}
				
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "MountPoint") : "/var/VRTSat";
				$CFG{MOUNTPOINT} = _ask("Enter the mount point for shared storage:", 232, 1025);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "BlockDevice") : "";
				$CFG{BLOCKDEVICE} = _ask("Enter the block device for shared storage:", 232, 1026);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FSType") : "";
				$CFG{FSTYPE} = _ask("Enter the filesystem type:", 232, 1027);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FsckOpt") : "";
				$CFG{FSCKOPT} = _ask("Enter the fsck options:", 232, 1028);
				
				$perhost =_aynn("Do you wish to configure disk reservation for each system:", 232, 1029);
				if ($perhost eq "Y") {
					my @hosts = split(" ", $CFG{SYSTEMLIST});
					my %disksconfig;

					foreach my $host (@hosts) {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Disks@${host}") : "";
						@disksconfig{$host}=_ask("Enter disks for ${host}:", 232, 1030, "${host}");
					}
					_expend_hosts($conffile, "Disks", %disksconfig);
				} else {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Disks") : "";
					$CFG{DISKS}=_ask("Enter the disks:", 232, 1031);
					_shrink_hosts($conffile, "DISKS", $CFG{DISKS});
				}
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FailFast") : "";
				$CFG{FAILFAST} = _ask("Enter fail fast for disk reservation:", 232, 1032);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Percentage") : "";
				$CFG{PERCENTAGE} = _ask("Enter percentage for disk reservation:", 232, 1033);
		}
}

sub _at_linux_create_configfiles
{
		my($installdir,$conffile,$configoutput,$args);
                $installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");

		if($CFG{CLUSTER_YN} eq "Y"){
			_dol("${installdir}/bin/vssregctl -l -s -b\"Security\\Authentication\\Authentication Broker\" -t\"string\" -k\"ClusterName\" -v$CFG{CLUSTERNAME}");
		}

		if($CFG{SERMODE} eq "-a"){
				$args="-n $CFG{ABIDENT} -p $CFG{ABPASS} -x vx -y $CFG{ABDOMAIN} -q $CFG{ABROOT} -z $CFG{ABPORT} -h $CFG{ABHASHFILE}";
				_dol("$installdir/bin/vxatd -o -a ${args}");
		}
		else{
				_dol("$installdir/bin/vxatd -o $CFG{SERMODE}");
		}
		if($CFG{CLUSTER_YN} eq "Y"){
				$conffile = "$installdir/bin/VxATclinput.txt";
				_pl("Updating the configuration file $conffile", 232, 1034, "$conffile");
				set_valueforname_infile($conffile, "SystemList", $CFG{SYSTEMLIST});
				set_valueforname_infile($conffile, "ClusterName", $CFG{CLUSTERNAME});
				set_valueforname_infile($conffile, "DiskReservationConfig", $CFG{DISKRESERVATIONCONFIG});
				
				set_valueforname_infile($conffile, "PathName", $CFG{PROCESSPATH});
				
				set_valueforname_infile($conffile, "Address", $CFG{VIRTUALIPADDRESS});
				set_valueforname_infile($conffile, "NetMask", $CFG{NETMASK});
				set_valueforname_infile($conffile, "Device", $CFG{DEVICE});
				
				set_valueforname_infile($conffile, "NetworkHosts", $CFG{NETWORKHOSTS});
				
				set_valueforname_infile($conffile, "MountPoint", $CFG{MOUNTPOINT});
				set_valueforname_infile($conffile, "BlockDevice", $CFG{BLOCKDEVICE});
				set_valueforname_infile($conffile, "FSType", $CFG{FSTYPE});
				set_valueforname_infile($conffile, "FsckOpt", $CFG{FSCKOPT});
				
				set_valueforname_infile($conffile, "Disks", $CFG{DISKS});
				set_valueforname_infile($conffile, "FailFast", $CFG{FAILFAST});
				set_valueforname_infile($conffile, "Percentage", $CFG{PERCENTAGE});
				
				set_valueforname_infile($conffile, "DiskGroupConfig", "n");
				set_valueforname_infile($conffile, "VolumeConfig", "n");
				set_valueforname_infile($conffile, "HPLVMVolumeGroupConfig", "n");
				set_valueforname_infile($conffile, "HPLVMLogicalVolumeConfig", "n");
				set_valueforname_infile($conffile, "AIXLVMVGConfig", "n");
				
				$configoutput = _dol("$installdir/bin/VxATclconf.pl -Mn -F${conffile}");
				_p($configoutput);
				_pl($configoutput);
		}
}
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{AZ}{Linux}{MAINPKG}="VRTSazClient";
$PROD{AZ}{Linux}{UGVERS}="ALL";
$PROD{AZ}{Linux}{OPATCHES}=[];
$PROD{AZ}{Linux}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{AZ}{Linux}{PKGS}=[ qw(VRTSazClient VRTSazServer) ];

# Define package information
$PKGI{Linux}{VRTSazClient}{NAME}="VERITAS Authorization Client";
$PKGI{Linux}{VRTSazClient}{OPTIONAL}="This package provides the authorization client.";
$PKGI{Linux}{VRTSazClient}{RPM}="VRTSazClient-4.2.2.6-1.i386.rpm";
$PKGI{Linux}{VRTSazServer}{NAME}="VERITAS Authorization Server";
$PKGI{Linux}{VRTSazServer}{DEPS}=[ "VRTSazClient" ];
$PKGI{Linux}{VRTSazServer}{OPTIONAL}="This package provides the authorization server.";
$PKGI{Linux}{VRTSazServer}{RPM}="VRTSazServer-4.2.2.6-1.i386.rpm";
# Define package information
$PKGI{Linux}{VRTSazServer}{SPACE}=[30000,0,20000,100];
$PKGI{Linux}{VRTSazClient}{SPACE}=[30000,0,20000,100];

# Language definitions
$PKGI{Linux}{VRTSazClient}{JA}=[ qw(VRTSazJA) ];
$PKGI{Linux}{VRTSazJA}{RPM}="VRTSazJA-4.2.2.6-1.i386.rpm";
$PKGI{Linux}{VRTSazJA}{SPACE}=[1000,0,100,100];
$PKGI{Linux}{VRTSazClient}{ZH}=[ qw(VRTSazZH) ];
$PKGI{Linux}{VRTSazZH}{RPM}="VRTSazZH-4.2.2.6-1.i386.rpm";
$PKGI{Linux}{VRTSazZH}{SPACE}=[1000,0,100,100];

# No product/platform specific subroutines are required
# Use them only if necessary

# ask configuration questions necessary following installation
#
# Function: _at_sun_postinstall_questions()
# Purpose:
#       Performs some tasks normally done by vxinstall.
# Input Parameters:
#       None
#       References $CFG{AZ_RESTORE_CFG}{$SYS}
#       References $PROD{AZ}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#       May update $PROD{AZ}{INSTALL}{$SYS}
# Called by:
#       _az_postinstall_questions(), which is called by _comm_postinstall()
sub _az_linux_postinstall_questions {
		my ($installdir,$conffile);
		if (-e "/etc/vx/vss/VRTSaz.loc") {
			$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
		}
		if (-e "$installdir/bin/vrtsaz_clinput.txt") {
			$conffile = "$installdir/bin/vrtsaz_clinput.txt";
		}
		
		$CFG{CLUSTER_YN}=_aynn("Do you want the installer to do a cluster configuration?", 242, 1000);
		if($CFG{CLUSTER_YN} eq "Y") {
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "ClusterName") : "";
			$CFG{CLUSTERNAME} = _ask("Enter the logical name of the cluster:", 242, 1001);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "SystemList") : "";
			$CFG{SYSTEMLIST} = _ask("Enter the systems which are part of this cluster:", 242, 1002);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskReservationConfig") : "";
			$CFG{DISKRESERVATIONCONFIG} = _ask("Do you want to do Disk reservation config?:", 242, 1003);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "MountPoint") : "/var/VRTSaz";
			$CFG{MOUNTPOINT} = _ask("Enter the mount point for shared storage:", 242, 1004);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "BlockDevice") : "";
			$CFG{BLOCKDEVICE} = _ask("Enter the block device for shared storage:", 242, 1005);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FSType") : "";
			$CFG{FSTYPE} = _ask("Enter the filesystem type:", 242, 1006);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FsckOpt") : "%-y";
			$CFG{FSCKOPT} = _ask("Enter the fsck options:", 242, 1007);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DeleteOldResources") : "n";
			$CFG{DELETEOLDRESOURCES} = _ask("Do you want to delete old resources if any:", 242, 1008);
			if (-d "/opt/VRTSvcs") {
				$CFG{VCSHOME} = "/opt/VRTSvcs";
			} else {
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VcsHome") : "/opt/VRTSvcs";
				$CFG{VCSHOME} = _ask("What is the VCS home directory:", 242, 1009);
			}
		}
}

sub _az_linux_create_configfiles
{
		my ($installdir,$conffile,$configoutput);
		$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
		$conffile = "$installdir/bin/vrtsaz_clinput.txt";
		
		if($CFG{CLUSTER_YN} eq "Y") {
			_pl("Updating the configuration file $conffile", 242, 1010, "$conffile");

			# Application Section.
			set_valueforname_infile($conffile, "StartProgram", "$installdir/bin/vrtsaz");
			set_valueforname_infile($conffile, "StopProgram", "\"$installdir/bin/vrtsaz -stop\"");
			set_valueforname_infile($conffile, "CleanProgram", "\"$installdir/bin/vrtsaz -stop force\"");
			set_valueforname_infile($conffile, "MonitorProcesses", "$installdir/bin/vxazd");

			# Mount Section
			set_valueforname_infile($conffile, "MountPoint", $CFG{MOUNTPOINT});
			set_valueforname_infile($conffile, "BlockDevice", $CFG{BLOCKDEVICE});
			set_valueforname_infile($conffile, "FSType", $CFG{FSTYPE});
			set_valueforname_infile($conffile, "FsckOpt", $CFG{FSCKOPT});

			# Gen Section
			set_valueforname_infile($conffile, "ClusterName", $CFG{CLUSTERNAME});
			set_valueforname_infile($conffile, "SystemList", $CFG{SYSTEMLIST});
			set_valueforname_infile($conffile, "DiskReservationConfig", $CFG{DISKRESERVATIONCONFIG});
			set_valueforname_infile($conffile, "DeleteOldResources", $CFG{DELETEOLDRESOURCES});
			set_valueforname_infile($conffile, "InstallDir", $installdir);
			set_valueforname_infile($conffile, "VcsHome",  $CFG{VCSHOME});
			set_valueforname_infile($conffile, "HPLVMVolumeGroupConfig", "n");
			set_valueforname_infile($conffile, "HPLVMLogicalVolumeConfig", "n");
			set_valueforname_infile($conffile, "DiskGroupConfig", "n");
			set_valueforname_infile($conffile, "VolumeConfig", "n");
			set_valueforname_infile($conffile, "StartVolumes", "1");
			set_valueforname_infile($conffile, "StopVolumes", "1");

			set_valueforname_infile($conffile, "StartProgram", "\"${installdir}/bin/vrtsaz\"");
			set_valueforname_infile($conffile, "StopProgram", "\"${installdir}/bin/vrtsaz -stop\"");
			set_valueforname_infile($conffile, "CleanProgram", "\"${installdir}/bin/vrtsaz -stop force\"");
			set_valueforname_infile($conffile, "MonitorProcesses", "\"${installdir}/bin/vxazd\"");

			$configoutput = _dol("./perl/bin/perl $installdir/bin/vrtsaz_clconf.pl -Mn -F${conffile} -l");
			$FLAG{CONFIGFAILED} = 1;
			if ($configoutput =~ /Configuration is complete\./ ) {
				$FLAG{CONFIGFAILED} = 0;
			}
			_p($configoutput);
			_pl($configoutput);
		}
}

# Define product specific information
$PROD{ICS}{SunOS}{MAINPKG}="VRTSsmf";
$PROD{ICS}{SunOS}{UGVERS}="ALL";

# Define packages to be installed, per product mode
#
$PROD{ICS}{SunOS}{PKGS}=[ qw(VRTSpbx VRTSat VRTSsmf VRTSaz) ];

1;

# Define product specific information
$PROD{PBX}{SunOS}{MAINPKG}="VRTSpbx";
$PROD{PBX}{SunOS}{UGVERS}="ALL";

# Define packages to be installed, per product mode
#
$PROD{PBX}{SunOS}{PKGS}=[ qw(VRTSpbx) ];

$PKGI{SunOS}{VRTSpbx}{NAME}="VERITAS Private Branch Exchange";
$PKGI{SunOS}{VRTSpbx}{OPTIONAL}="This package provides the ICS Private Branch Exchange.";
$PKGI{SunOS}{VRTSpbx}{DEPS}=[ "VRTSsmf" ];

1;

# Define product specific information
$PROD{SMF}{SunOS}{MAINPKG}="VRTSsmf";
$PROD{SMF}{SunOS}{UGVERS}="ALL";
$PROD{SMF}{SunOS}{OPATCHES}=[];
$PROD{SMF}{SunOS}{VPATCHES}=[];

# Define packages to be installed, per product mode
#
$PROD{SMF}{SunOS}{PKGS}=[ qw(VRTSsmf) ];

$PKGI{SunOS}{VRTSsmf}{NAME}="VERITAS Service Management Framework";
$PKGI{SunOS}{VRTSsmf}{OPTIONAL}="This package provides the ICS Service Management Framework.";

1;
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{AT}{SunOS}{MAINPKG}="VRTSat";
$PROD{AT}{SunOS}{UGVERS}="ALL";
$PROD{AT}{SunOS}{OPATCHES}=[];
$PROD{AT}{SunOS}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{AT}{SunOS}{PKGS}=[ qw(VRTSat) ];

# Define package information
$PKGI{SunOS}{VRTSat}{NAME}="VERITAS Authentication Service";
$PKGI{SunOS}{VRTSat}{OPTIONAL}="This package provides the authentication stuff.";
$PKGI{SunOS}{VRTSat}{SPACE}=[60000,0,1000,100];
$PKGI{SunOS}{VRTSat}{DEPS}=[ "VRTSaz" ];

# Language pack definitions
$PKGI{SunOS}{VRTSat}{JA}=[ qw(VRTSatJA) ];
$PKGI{SunOS}{VRTSatJA}{SPACE}=[1000,0,100,100];
$PKGI{SunOS}{VRTSat}{ZH}=[ qw(VRTSatZH) ];
$PKGI{SunOS}{VRTSatZH}{SPACE}=[1000,0,100,100];

# No product/platform specific subroutines are required
# Use them only if necessary


#
# Function: _at_sun_request()
# Purpose:
#       Implements a task of VRTSat's request script.
#       Note: Not called for -configure
# Input Parameters:
#       References $PROD{AT}{REBOOT}{$SYS}
# Output Parameters:
#       It indirectly creates $CFG{AT_RESTORE_CFG}{$SYS}.
# Called by:
#       _at_sun_pkgrequest_questions()
sub _at_sun_request
{
		my ($INSTALLDIR);
		my ($INSTALL_CLASSES);
		$PKG=$PROD{AT}{SunOS}{MAINPKG};
		$PKGI{SunOS}{$PKG}{OPT_DIR} = _sun_get_mediapkginfovalue("OPT");
		
		#$COMM{DEFANSWER}="/opt";
		# $INSTALLDIR =_ask("Where do you want to install ?: ");
		$INSTALLDIR="/opt";
		
		$INSTALL_CLASSES = _sun_get_mediapkginfovalue("CLASSES");
		my $suffix = "";
    # check if what we have is a combined package.
 		if ($INSTALL_CLASSES =~"client56") {
        # yes we do
				my $solvers= `uname -r`;
				chop $solvers;
				# if it is 5.6 we need to use 56, for all others it is 57.
				if($solvers eq "5.6"){
						$suffix = "56";
				}
				else {
						$suffix = "57";
				}
		}
		$CFG{SERVER_YN} = _ayny("Do you want to install the Authentication Broker Server?", 231, 1000);
		if($CFG{SERVER_YN} eq "N"){
				$INSTALL_CLASSES = "client$suffix";
		}
		else{
				$INSTALL_CLASSES = "client$suffix server$suffix";
		}
		_log("Selected classes are $INSTALL_CLASSES", 231, 1001, "$INSTALL_CLASSES");
		#_sun_create_responsefile("OPT=$INSTALLDIR\nCLASSES=$INSTALL_CLASSES");
		$PKGI{SunOS}{VXSS}{RESPSTR}="OPT=$INSTALLDIR\nCLASSES=$INSTALL_CLASSES";
    $PKGI{SunOS}{VRTSat}{RESPONSEFILE}="OPT=$INSTALLDIR\nCLASSES=$INSTALL_CLASSES";
}  # _at_sun_request()

sub _at_sun_pkgrequest_questions
{
		_at_sun_request();
}

# ask configuration questions necessary following installation
#
# Function: _at_sun_postinstall_questions()
# Purpose:
#       Performs some tasks normally done by vxinstall.
# Input Parameters:
#       None
#       References $CFG{AT_RESTORE_CFG}{$SYS}
#       References $PROD{AT}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#       May update $PROD{AT}{INSTALL}{$SYS}
# Called by:
#       _at_postinstall_questions(), which is called by _comm_postinstall()
sub _at_sun_postinstall_questions {
		my($installdir,$conffile,$ipaddress,$sermode,$host);
		if (-e "/etc/vx/vss/VRTSat.loc") {
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
		}
		_title("Service Mode Configuration");
		my @mode = ("-r", "-a", "-r -a");
		$COMM{MENU}=["Root Broker Only.", "Authentication Broker Only.", "Authentication + Root Broker."];
		my $sermode=_menu("Enter the mode in which you want to install VRTSat", 231, 1002);
		$CFG{SERMODE}=$mode[$sermode-1];
		if($sermode==2){
				$CFG{ABROOT} =_ask("Enter the name of the host running the root broker", 231, 1003);
				$COMM{DEFANSWER}="2821";
				$CFG{ABPORT} = _ask("Enter the broker port", 231, 1004);
				$CFG{ABIDENT}=_ask("Enter authentication broker's identity", 231, 1005);
				$CFG{ABPASS}=_ask("Enter password for $CFG{ABIDENT}", 231, 1006, "$CFG{ABIDENT}");
				$CFG{ABDOMAIN}=_ask("Enter the domain name", 231, 1007);
				$CFG{ABHASHFILE}=_ask("Enter the location of the file containing the root's hash", 231, 1008);
		}
		if (-e "$installdir/bin/VxATclinput.txt") {
				$conffile = "$installdir/bin/VxATclinput.txt";
		}
		$CFG{CLUSTER_YN}=_aynn("Do you want the installer to do a cluster configuration?", 231, 1009);
		if($CFG{CLUSTER_YN} eq "Y") {
				_title("Cluster Configuration");
				my @clus_supported = ("vcs", "sun");
				$COMM{MENU}=["VERITAS Cluster Server", "SunCluster 3.1"];
				my $clus_used=_menu("Which high availability framework is in use?", 231, 1010);
				$CFG{CLUSTER_USED}=$clus_supported[$clus_used-1];
				if($CFG{CLUSTER_USED} eq "vcs") {
						_title("VERITAS Cluster Server Configuration");

				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "ClusterName") : "";
				$CFG{CLUSTERNAME} = _ask("Enter the logical name of the cluster:", 231, 1011);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "SystemList") : "";		
				$CFG{SYSTEMLIST}= _ask("Enter the Systems which are part of this cluster:", 231, 1012);
				
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "PathName") : "$installdir/bin/vxatd";
				$CFG{PROCESSPATH} = _ask("Enter the process path: ", 231, 1013);
				$ipaddress = "";
				$MSG{HELP}=_tr("Enter IP resource information", 231, 1014);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Address") : "";
				$ipaddress =_ask("Enter the IP address:", 231, 1015);
				while(_ipcheck($ipaddress))
				{
						_pl("Bad IP", 231, 1016);
						$MSG{HELP}=_tr("Enter IP resource information", 231, 1014);
						$ipaddress =_ask("Enter the IP address:", 231, 1015);
				}
				$CFG{VIRTUALIPADDRESS} = $ipaddress;
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "NetMask") : "";
				$CFG{NETMASK}=_ask("Enter the net mask:", 231, 1017);
				$COMM{DEFANSWER} = "n";
				my $perhost =_aynn("Do you wish to configure network device for each system:", 231, 1018);
				if ($perhost eq "Y") {
					my @hosts = split(" ", $CFG{SYSTEMLIST});
					my %devicesconfig;

					foreach my $host (@hosts) {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Device@${host}") : "";
						@devicesconfig{$host}=_ask("Enter the network device name for ${host}:", 231, 1019, "${host}");
					}
					_expend_hosts($conffile, "Device", %devicesconfig);
				} else {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Device") : "";
					$CFG{DEVICE}=_ask("Enter the network device name:", 231, 1020);
					_shrink_hosts($conffile, "Device", $CFG{DEVICE});
				}
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "MountPoint") : "/var/VRTSat";
				$CFG{MOUNTPOINT} = _ask("Enter the mount point for shared storage:", 231, 1021);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "BlockDevice") : "";
				$CFG{BLOCKDEVICE} = _ask("Enter the block device for shared storage:", 231, 1022);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FSType") : "";
				$CFG{FSTYPE} = _ask("Enter the filesystem type:", 231, 1023);
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FsckOpt") : "";
				$CFG{FSCKOPT} = _ask("Enter the fsck options:", 231, 1024);
				
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroupConfig") : "";
				$CFG{DISKGROUPCONFIG} = _tolower(_aynn("Do you wish to configure disk group:", 231, 1025));
				if ($CFG{DISKGROUPCONFIG} eq "y") {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroup") : "";
					$CFG{DISKGROUP} = _ask("Enter the Disk Group:", 231, 1026);
					
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VolumeConfig") : "";
					$CFG{VOLUMECONFIG}= _tolower(_aynn("Do you wish to configure volume:", 231, 1027));
					if ($CFG{VOLUMECONFIG} eq "y") {
						$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Volume") : "";
						$CFG{VOLUME} = _ask("Enter the Volume:", 231, 1028);
					} else {
						$CFG{VOLUME} = "n";
					}
				} else {
					$CFG{DISKGROUP} = "n";
					$CFG{VOLUMECONFIG} = "n";
					$CFG{VOLUME} = "n";
				}
			}
						if($CFG{CLUSTER_USED} eq "sun") {
						_title("");
						_bpl("\n\nSunCluster Configuration", 231, 1029);

						_pl("\n\nThis configuration program  will create a Sun Cluster  resource group which", 231, 1030);
						_pl("would enable the VRTSat service as a failover resource.  The resource group", 231, 1031);
						_pl("will include  a SUNW.HAStoragePlus resource to monitor  the shared storage.", 231, 1032);
						_pl("Enabling the SUNW.HAStoragePlus resource requires that the mountpoint where", 231, 1033);
						_pl("the global device is mounted be listed in the /etc/vfstab file on each node", 231, 1034);
						_pl("of the cluster.", 231, 1035);
						_pl(" ", 231, 1036);

						_pl("You can choose to prepare this system as a cluster node. Alternatively, if", 231, 1037);
						_pl("all other nodes are prepared, you can choose to create resources on this node", 231, 1038);
			
						_pl("\n", 231, 1039);
						my @actions = ("prenode", "create");
						$COMM{MENU}=["Prepare this cluster node.", "Prepare this cluster node & create resources."];
						my $action_chosen=_menu("What do you want to do?", 231, 1040);
						$CFG{ACTION_CHOSEN}=$actions[$action_chosen-1];
						_title("");
						_pl("\n", 231, 1039);
						_pl("Sun Cluster configuration input:", 231, 1041);
						_pl("\n", 231, 1039);
						$CFG{GLOBAL_DSK} = _ask("Enter the device to mount: ", 231, 1042);
						$CFG{GLOBAL_RDSK} = _ask("Enter the block device:", 231, 1043);
						if($CFG{ACTION_CHOSEN} eq "create") {
								$CFG{CLUSTERNAME} = _ask("Enter the cluster name: ", 231, 1044);
								$CFG{LOGICALHOST} = _ask("Enter the logical hostname: ", 231, 1045);
								$CFG{GLOBALDEV} = _ask("Enter the name of the SunCluster Global device that the shared storage uses: ", 231, 1046);
						}
				}
		}
}

sub _at_sun_create_configfiles
{
		my($installdir,$conffile,$configoutput,$args);
                $installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
		
		if ($CFG{CLUSTER_YN} eq "Y") {
			_dor("${installdir}/bin/vssregctl -l -s -b\"Security\\Authentication\\Authentication Broker\" -t\"string\" -k\"ClusterName\" -v$CFG{CLUSTERNAME}");
		}

		if($CFG{SERMODE} eq "-a"){
				$args="-n $CFG{ABIDENT} -p $CFG{ABPASS} -x vx -y $CFG{ABDOMAIN} -q $CFG{ABROOT} -z $CFG{ABPORT} -h $CFG{ABHASHFILE}";
				_dor("$installdir/bin/vxatd -o -a ${args}");
		}
		else{
				_dor("$installdir/bin/vxatd -o $CFG{SERMODE}");
		}
		if($CFG{CLUSTER_YN} eq "Y"){
					if($CFG{CLUSTER_USED} eq "sun") {
					$configoutput=_dor("$installdir/bin/scvxat -pernode $CFG{GLOBAL_DSK} $CFG{GLOBAL_RDSK}");
					_pl($configoutput);
					if($CFG{ACTION_CHOSEN} eq "create") {
							_pl("Creating resources to enable VRTSat as a failover resource...", 231, 1047);
							$configoutput = _dor("$installdir/bin/scvxat -create $CFG{LOGICALHOST} $CFG{GLOBALDEV}");						
							_pl($configoutput);
							$FLAG{CONFIGFAILED} = 1;
							if ($configoutput =~ /successfully/ ) {
									$FLAG{CONFIGFAILED} = 0;
							}else{
									_pl("Resource creation failed. Use scvxat -clean before retrying configuration.", 231, 1048);
							}
					}
			}
			if($CFG{CLUSTER_USED} eq "vcs") {
				$conffile = "$installdir/bin/VxATclinput.txt";
				_pl("Updating the configuration file $conffile", 231, 1049, "$conffile");
				set_valueforname_infile($conffile, "SystemList", $CFG{SYSTEMLIST});
				set_valueforname_infile($conffile, "ClusterName", $CFG{CLUSTERNAME});
				set_valueforname_infile($conffile, "DiskGroupConfig", $CFG{DISKGROUPCONFIG});
				set_valueforname_infile($conffile, "VolumeConfig", $CFG{VOLUMECONFIG});
		#		set_valueforname_infile($conffile, "DiskReservationConfig", "n");
				set_valueforname_infile($conffile, "PathName", $CFG{PROCESSPATH});
				set_valueforname_infile($conffile, "Address", $CFG{VIRTUALIPADDRESS});
				set_valueforname_infile($conffile, "NetMask", $CFG{NETMASK});
				set_valueforname_infile($conffile, "Device", $CFG{DEVICE});
				set_valueforname_infile($conffile, "MountPoint", $CFG{MOUNTPOINT});
				set_valueforname_infile($conffile, "BlockDevice", $CFG{BLOCKDEVICE});
				set_valueforname_infile($conffile, "FSType", $CFG{FSTYPE});
				set_valueforname_infile($conffile, "FsckOpt", $CFG{FSCKOPT});
				set_valueforname_infile($conffile, "DiskGroup", $CFG{DISKGROUP});
				set_valueforname_infile($conffile, "Volume", $CFG{VOLUME});
				
				set_valueforname_infile($conffile, "HPLVMVolumeGroupConfig", "n");
				set_valueforname_infile($conffile, "AIXLVMVGConfig", "n");
				set_valueforname_infile($conffile, "HPLVMLogicalVolumeConfig", "n");
				
				# WARNING: This call assuming that perl is available on the host. It may not
				# work for remote installation.
				$configoutput = _dor("$installdir/bin/VxATclconf.pl -Mn -F${conffile}");
				_p($configoutput);
				_pl($configoutput);
		}
	}
}


# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{AZ}{SunOS}{MAINPKG}="VRTSaz";
$PROD{AZ}{SunOS}{UGVERS}="ALL";
$PROD{AZ}{SunOS}{OPATCHES}=[];
$PROD{AZ}{SunOS}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{AZ}{SunOS}{PKGS}=[ qw(VRTSaz) ];

# Define package information
$PKGI{SunOS}{VRTSaz}{NAME}="VERITAS Authorization Service";
$PKGI{SunOS}{VRTSaz}{OPTIONAL}="This package provides the authorization stuff.";
$PKGI{SunOS}{VRTSaz}{SPACE}=[50000,0,5000,100];

# Language pack definition
$PKGI{SunOS}{VRTSaz}{JA}=[ qw(VRTSazJA) ];
$PKGI{SunOS}{VRTSazJA}{SPACE}=[1000,0,100,100];
$PKGI{SunOS}{VRTSaz}{ZH}=[ qw(VRTSazZH) ];
$PKGI{SunOS}{VRTSazZH}{SPACE}=[1000,0,100,100];

# No product/platform specific subroutines are required
# Use them only if necessary

# Function: _az_sun_request()
# Purpose:
#       Implements a task of VRTSat's request script.
#       Note: Not called for -configure
# Input Parameters:
#       References $PROD{AZ}{REBOOT}{$SYS}
# Output Parameters:
#       It indirectly creates $CFG{AZ_RESTORE_CFG}{$SYS}.
# Called by:
#       _az_sun_pkgrequest_questions()
sub _az_sun_request
{
		my ($INSTALLDIR);
		my ($INSTALL_CLASSES);
		$PKG=$PROD{AZ}{SunOS}{MAINPKG};
		$PKGI{SunOS}{$PKG}{OPT_DIR} = _sun_get_mediapkginfovalue("OPT");
		
		#$COMM{DEFANSWER}="/opt";
		#$INSTALLDIR =_ask("Where do you want to install ?: ");
		$INSTALLDIR="/opt";
		
		$INSTALL_CLASSES = _sun_get_mediapkginfovalue("CLASSES");
		my $suffix = "";
    # check if what we have is a combined package.
 		if ($INSTALL_CLASSES =~"client56") {
        # yes we do
				my $solvers= `uname -r`;
				chop $solvers;
				# if it is 5.6 we need to use 56, for all others it is 57.
				if($solvers eq "5.6"){
						$suffix = "56";
				}
				else {
						$suffix = "57";
				}
		}
		$CFG{SERVER_YN} = _ayny("Do you want to install the Authorization Service?", 241, 1000);
		if($CFG{SERVER_YN} eq "N"){
				$INSTALL_CLASSES = "client$suffix";
		}
		else{
				$INSTALL_CLASSES = "client$suffix server$suffix";
		}
		_log("Selected classes are $INSTALL_CLASSES", 241, 1001, "$INSTALL_CLASSES");
		#_sun_create_responsefile("OPT=$INSTALLDIR\nCLASSES=$INSTALL_CLASSES");
		$PKGI{SunOS}{VRTSaz}{RESPONSEFILE}="OPT=$INSTALLDIR\nCLASSES=$INSTALL_CLASSES";
    $PKGI{SunOS}{VXSS}{RESPSTR}="OPT=$INSTALLDIR\nCLASSES=$INSTALL_CLASSES";
}

sub _az_sun_pkgrequest_questions
{
		_az_sun_request();
}


# ask configuration questions necessary following installation
#
# Function: _at_sun_postinstall_questions()
# Purpose:
#       Performs some tasks normally done by vxinstall.
# Input Parameters:
#       None
#       References $CFG{AZ_RESTORE_CFG}{$SYS}
#       References $PROD{AZ}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#       May update $PROD{AZ}{INSTALL}{$SYS}
# Called by:
#       _az_postinstall_questions(), which is called by _comm_postinstall()


sub _az_sun_postinstall_questions {
		my ($installdir,$conffile);
		if (-e "/etc/vx/vss/VRTSaz.loc") {
			$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
		}
		if (-e "$installdir/bin/vrtsaz_clinput.txt") {
			$conffile = "$installdir/bin/vrtsaz_clinput.txt";
		}
		
		$CFG{CLUSTER_YN}=_aynn("Do you want the installer to do a cluster configuration?", 241, 1002);
		if($CFG{CLUSTER_YN} eq "Y") {
			my @clus_supported = ("vcs", "sun");
			$COMM{MENU}=["VERITAS Cluster Server", "SunCluster 3.1"];
			my $clus_used=_menu("Which high availability framework is in use?", 241, 1003);
			$CFG{CLUSTER_USED}=$clus_supported[$clus_used-1];
			if($CFG{CLUSTER_USED} eq "vcs") {
			_title("VERITAS Cluster Server Configuration");

			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "ClusterName") : "";
			$CFG{CLUSTERNAME} = _ask("Enter the logical name of the cluster:", 241, 1004);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "SystemList") : "";
			
			$CFG{SYSTEMLIST} = _ask("Enter the systems which are part of this cluster:", 241, 1005);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "BlockDevice") : "";
			$CFG{BLOCKDEVICE} = _ask("Enter the block device for shared storage:", 241, 1006);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroupConfig") : "";
			$CFG{DISKGROUPCONFIG} = _tolower(_aynn("Do you wish to configure disk group:", 241, 1007));
			if ($CFG{DISKGROUPCONFIG} eq "y") {
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DiskGroup") : "";
					$CFG{DISKGROUP} = _ask("Enter the Disk Group:", 241, 1008);
					$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VolumeConfig") : "";
					$CFG{VOLUMECONFIG}= _tolower(_aynn("Do you wish to configure volume:", 241, 1009));
					if ($CFG{VOLUMECONFIG} eq "y") {
							$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "Volume") : "";
						$CFG{VOLUME} = _ask("Enter the Volume:", 241, 1010);
					} else {
							$CFG{VOLUME} = "n";
					}
			} else {
					$CFG{DISKGROUP} = "n";
					$CFG{VOLUMECONFIG} = "n";
					$CFG{VOLUME} = "n";
			}
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FSType") : "vxfs";
			$CFG{FSTYPE} = _ask("Enter the filesystem type:", 241, 1011);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "FsckOpt") : "%-y";
			$CFG{FSCKOPT} = _ask("Enter the fsck options:", 241, 1012);
			$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "DeleteOldResources") : "n";
			$CFG{DELETEOLDRESOURCES} = _ask("Do you want to delete old resources if any:", 241, 1013);
			if (-d "/opt/VRTSvcs") {
				$CFG{VCSHOME} = "/opt/VRTSvcs";
			} else {
				$COMM{DEFANSWER} = $conffile ? get_valueforname_fromfile($conffile, "VcsHome") : "/opt/VRTSvcs";
				$CFG{VCSHOME} = _ask("What is the VCS home directory:", 241, 1014);
			}
		}

						if($CFG{CLUSTER_USED} eq "sun") {

						if(_ayny("\n\nIs VRTSat already configured as a failover-capable service on the cluster?", 241, 1015) eq "N") {
								_die("Configure VRTSat on the cluster before configuring VRTSaz", 241, 1016);
						}

						_title("");
						_bpl("\nSunCluster Configuration", 241, 1017);

						_pl("\n\nThis configuration program  will create a Sun Cluster  resource group which", 241, 1018);
						_pl("would enable the VRTSaz service as a failover resource.  The resource group", 241, 1019);
						_pl("will include  a SUNW.HAStoragePlus resource to monitor  the shared storage.", 241, 1020);
						_pl("Enabling the SUNW.HAStoragePlus resource requires that the mountpoint where", 241, 1021);
						_pl("the global device is mounted be listed in the /etc/vfstab file on each node", 241, 1022);
						_pl("of the cluster.", 241, 1023);
						_pl(" ", 241, 1024);

						_pl("You can choose to prepare this system as a cluster node. Alternatively, if", 241, 1025);
						_pl("all other nodes are prepared, you can choose to create resources on this node", 241, 1026);

						_pl("\n", 241, 1027);
						my @actions = ("prenode", "create");
						$COMM{MENU}=["Prepare this cluster node.", "Prepare this cluster node & create resources."];
						my $action_chosen=_menu("What do you want to do?", 241, 1028);
						$CFG{ACTION_CHOSEN}=$actions[$action_chosen-1];
						_title("");	
						_pl("\n", 241, 1027);
						_pl("Sun Cluster configuration input:", 241, 1029);
						_pl("\n", 241, 1027);
						$CFG{GLOBAL_DSK} = _ask("Enter the device to mount: ", 241, 1030);
						$CFG{GLOBAL_RDSK} = _ask("Enter the block device:", 241, 1031);
						if($CFG{ACTION_CHOSEN} eq "create") {
								$CFG{GLOBALDEV} = _ask("Enter the name of the SunCluster Global device that the shared storage uses: ", 241, 1032);
						}
				}
		}
}

sub _az_sun_create_configfiles
{
		my ($installdir,$conffile,$configoutput);
		$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
		$conffile = "$installdir/bin/vrtsaz_clinput.txt";
		
		if($CFG{CLUSTER_YN} eq "Y") {
				if($CFG{CLUSTER_USED} eq "sun") {
				$configoutput=_dor("$installdir/bin/scvxaz -pernode $CFG{GLOBAL_DSK} $CFG{GLOBAL_RDSK}");
				_pl($configoutput);
				if($CFG{ACTION_CHOSEN} eq "create") {
						_pl("Creating resources to enable VRTSaz as a failover resource...", 241, 1033);
						$configoutput = _dor("$installdir/bin/scvxaz -create $CFG{GLOBALDEV}");						
						_pl($configoutput);
						$FLAG{CONFIGFAILED} = 1;
						if ($configoutput =~ /successfully/ ) {
								$FLAG{CONFIGFAILED} = 0;
						}else{
								_pl("Resource creation failed. Use scvxaz -clean before attempting configuration again.", 241, 1034);
						}
				}
		}
		if($CFG{CLUSTER_USED} eq "vcs") {						
			_pl("Updating the configuration file $conffile", 241, 1035, "$conffile");

			# Application Section.
			set_valueforname_infile($conffile, "StartProgram", "$installdir/bin/vrtsaz");
			set_valueforname_infile($conffile, "StopProgram", "\"$installdir/bin/vrtsaz -stop\"");
			set_valueforname_infile($conffile, "CleanProgram", "\"$installdir/bin/vrtsaz -stop force\"");
			set_valueforname_infile($conffile, "MonitorProcesses", "$installdir/bin/vxazd");

			# Mount Section
			set_valueforname_infile($conffile, "MountPoint", "/var/VRTSaz/shared");
			set_valueforname_infile($conffile, "BlockDevice", $CFG{BLOCKDEVICE});
			set_valueforname_infile($conffile, "FSType", $CFG{FSTYPE});
			set_valueforname_infile($conffile, "FsckOpt", $CFG{FSCKOPT});

			# Diskgroup Section
			set_valueforname_infile($conffile, "DiskGroup", $CFG{DISKGROUP});

			# Volume Section
			set_valueforname_infile($conffile, "Volume", $CFG{VOLUME});

			# Gen Section
			set_valueforname_infile($conffile, "ClusterName", $CFG{CLUSTERNAME});
			set_valueforname_infile($conffile, "SystemList", $CFG{SYSTEMLIST});
			set_valueforname_infile($conffile, "DeleteOldResources", $CFG{DELETEOLDRESOURCES});
			set_valueforname_infile($conffile, "InstallDir", $installdir);
			set_valueforname_infile($conffile, "VcsHome",  $CFG{VCSHOME});
			set_valueforname_infile($conffile, "HPLVMVolumeGroupConfig", "n");
			set_valueforname_infile($conffile, "HPLVMLogicalVolumeConfig", "n");
			set_valueforname_infile($conffile, "DiskGroupConfig", $CFG{DISKGROUPCONFIG});
			set_valueforname_infile($conffile, "VolumeConfig", $CFG{VOLUMECONFIG});
			set_valueforname_infile($conffile, "DiskReservationConfig", "n");
			set_valueforname_infile($conffile, "StartVolumes", "1");
			set_valueforname_infile($conffile, "StopVolumes", "1");
			$configoutput = _dol("./perl/bin/perl $installdir/bin/vrtsaz_clconf.pl -Mn -F${conffile} -l");
			$FLAG{CONFIGFAILED} = 1;
			if ($configoutput =~ /Configuration is complete\./ ) {
				$FLAG{CONFIGFAILED} = 0;
			}
			_p($configoutput);
			_pl($configoutput);
		}
	}
}



# Define product specific information
$PROD{ICS}{OSF1}{MAINPKG}="VRTSsmf";
$PROD{ICS}{OSF1}{UGVERS}="ALL";

# Define packages to be installed
# AT and AZ package defs are done in AT.pl and AZ.pl
$PROD{ICS}{OSF1}{PKGS}=[ qw(VRTSpbx VRTSat VRTSsmf VRTSaz) ];
1;

# Define product specific information

$PROD{PBX}{OSF1}{MAINPKG}="VRTSpbx";
$PROD{PBX}{OSF1}{UGVERS}="ALL";
$PROD{PBX}{OSF1}{OPPBXCHES}=[];
$PROD{PBX}{OSF1}{VPPBXCHES}=[];

# Define packages to be installed, per product mode
$PROD{PBX}{OSF1}{PKGS}=[ qw(VRTSpbx) ];

# Define package information
$PKGI{OSF1}{VRTSpbx}{NAME}="VERITAS Private Branch Exchange";
$PKGI{OSF1}{VRTSpbx}{SUBSET}="VPBX122";
$PKGI{OSF1}{VRTSpbx}{OPTIONAL}="This package provides the private branch exchange stuff.";
$PKGI{OSF1}{VRTSpbx}{SPACE}=[100000,0,1000,100];
$PKGI{OSF1}{VRTSpbx}{DEPS}=[ "VRTSsmf" ];
1;

# Define product specific information

$PROD{SMF}{OSF1}{MAINPKG}="VRTSsmf";
$PROD{SMF}{OSF1}{UGVERS}="ALL";
$PROD{SMF}{OSF1}{OPSMFCHES}=[];
$PROD{SMF}{OSF1}{VPSMFCHES}=[];

# Define packages to be installed, per product mode
$PROD{SMF}{OSF1}{PKGS}=[ qw(VRTSsmf) ];

# Define package information
$PKGI{OSF1}{VRTSsmf}{NAME}="VERITAS Service Management Framework";
$PKGI{OSF1}{VRTSsmf}{SUBSET}="ICSSMF121";
$PKGI{OSF1}{VRTSsmf}{OPTIONAL}="This package provides the service management framework stuff.";
$PKGI{OSF1}{VRTSsmf}{SPACE}=[100000,0,1000,100];
1;
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{AT}{OSF1}{MAINPKG}="VRTSat";
$PROD{AT}{OSF1}{UGVERS}="ALL";
$PROD{AT}{OSF1}{OPATCHES}=[];
$PROD{AT}{OSF1}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{AT}{OSF1}{PKGS}=[ qw(VRTSat) ];

# Define package information
$PKGI{OSF1}{VRTSat}{NAME}="VERITAS Authentication Service";
$PKGI{OSF1}{VRTSat}{SUBSET}="VATSER426 VATCLI426";
$PKGI{OSF1}{VRTSat}{OPTIONAL}="This package provides the authentication stuff.";
$PKGI{OSF1}{VRTSat}{SPACE}=[100000,0,1000,100];

# Language pack definitions
$PKGI{OSF1}{VRTSat}{JA}=[ qw(VRTSatJA) ];
$PKGI{OSF1}{VRTSatJA}{SUBSET}="VATJA426";
$PKGI{OSF1}{VRTSatJA}{SPACE}=[1000,0,100,100];
$PKGI{OSF1}{VRTSat}{ZH}=[ qw(VRTSatZH) ];
$PKGI{OSF1}{VRTSatZH}{SUBSET}="VATZH426";
$PKGI{OSF1}{VRTSatZH}{SPACE}=[1000,0,100,100];

# No product/platform specific subroutines are required
# Use them only if necessary

# ask configuration questions necessary following installation
#
# Function: _at_osf1_postinstall_questions()
# Purpose:
#       Performs some tasks normally done by vxinstall.
# Input Parameters:
#       None
#       References $CFG{AT_RESTORE_CFG}{$SYS}
#       References $PROD{AT}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#       May update $PROD{AT}{INSTALL}{$SYS}
# Called by:
#       _at_postinstall_questions(), which is called by _comm_postinstall()
sub _at_osf1_postinstall_questions {
		my ($installdir,$sermode,$ans);
		if (-e "/etc/vx/vss/VRTSat.loc") {
				$installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");
		}
		_title("Service Mode Configuration");
		my @mode = ("-r", "-a", "-r -a");
		$COMM{MENU}=["Root Broker Only.", "Authentication Broker Only.", "Authentication + Root Broker."];
		$sermode=_menu("Enter the mode in which you want to install VRTSat", 235, 1000);
		$CFG{SERMODE}=$mode[$sermode-1];
		if ($sermode==2) {
				$CFG{ABROOT} =_ask("Enter the name of the host running the root broker", 235, 1001);
				$COMM{DEFANSWER}="2821";
				$CFG{ABPORT} = _ask("Enter the broker port", 235, 1002);
				$CFG{ABIDENT}=_ask("Enter authentication broker's identity", 235, 1003);
				$CFG{ABPASS}=_ask("Enter password for $CFG{ABIDENT}", 235, 1004, "$CFG{ABIDENT}");
				$CFG{ABDOMAIN}=_ask("Enter the domain name", 235, 1005);
				$CFG{ABHASHFILE}=_ask("Enter the location of the file containing the root's hash", 235, 1006);
		}
    
    $CFG{CLUSTER_YN} = _aynn("Do you wish to configure the service as a highly available application?", 235, 1007);
    if ($CFG{CLUSTER_YN} eq "Y") {
      _title("");
      _bpl("TruCluster Application Profile Configuration", 235, 1008);
      _pl("The configuration program will create an application resource profile for", 235, 1009);
      _pl("VERITAS Authentication Service and will register it with the CAA", 235, 1010);
      if (! -e "/usr/sbin/caa_profile") {
        _pl("/usr/sbin/caa_profile does not exist! Are you sure, this is a TruCluster node? ", 235, 1011);
        $ans = _aynn("Service will not be highly available. Continue anyway?", 235, 1012);
        if ($ans eq "N") {
          die("Node not a cluster member");
          $CFG{CLUSTER_YN} = "N";
        }
      } else {
        $CFG{CLUSTERNAME} =_ask("Enter the name of the cluster: ", 235, 1013);
      }
    }
}

sub _at_osf1_create_configfiles
{
		my($installdir,$args,$output);
                $installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSat.loc", "ProductInstallDir");

		if($CFG{CLUSTER_YN} eq "Y"){
			_dol("${installdir}/bin/vssregctl -l -s -b\"Security\\Authentication\\Authentication Broker\" -t\"string\" -k\"ClusterName\" -v$CFG{CLUSTERNAME}");
		}

		if($CFG{SERMODE} eq "-a"){
				$args="-n $CFG{ABIDENT} -p $CFG{ABPASS} -x vx -y $CFG{ABDOMAIN} -q $CFG{ABROOT} -z $CFG{ABPORT} -h $CFG{ABHASHFILE}";
				_dol("$installdir/bin/vxatd -o -a ${args}");
		}
		else{
				_dol("$installdir/bin/vxatd -o $CFG{SERMODE}");
		}
    
    if ($CFG{CLUSTER_YN} eq "Y") {
      # should we need to unregister first to cleanup the previous registration?
      $output=_dor("${installdir}/bin/tcvxat -register");
      _pl($output);
      $FLAG{CONFIGFAILED} = 1;
      if ($output =~ /successfully/) {
        $FLAG{CONFIGFAILED} = 0;
      } else {
        _pl("Resource registration failed. Use ${installdir}/bin/tcvxat -unregister before retrying configuration.", 235, 1014, "${installdir}");
      }
    }
}

# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{AZ}{OSF1}{MAINPKG}="VRTSaz";
$PROD{AZ}{OSF1}{UGVERS}="ALL";
$PROD{AZ}{OSF1}{OPATCHES}=[];
$PROD{AZ}{OSF1}{VPATCHES}=[];

# Define packages to be installed, per product mode
$PROD{AZ}{OSF1}{PKGS}=[ qw(VRTSaz) ];

# Define package information
$PKGI{OSF1}{VRTSaz}{NAME}="VERITAS Authorization Service";
$PKGI{OSF1}{VRTSaz}{SUBSET}="VAZSER426 VAZCLI426";
$PKGI{OSF1}{VRTSaz}{OPTIONAL}="This package provides the authorization services.";
$PKGI{OSF1}{VRTSaz}{SPACE}=[50000,0,5000,100];

# Language pack definitions
$PKGI{OSF1}{VRTSaz}{JA}=[ qw(VRTSazJA) ];
$PKGI{OSF1}{VRTSazJA}{SUBSET}="VAZJA426";
$PKGI{OSF1}{VRTSazJA}{SPACE}=[1000,0,100,100];
$PKGI{OSF1}{VRTSaz}{ZH}=[ qw(VRTSazZH) ];
$PKGI{OSF1}{VRTSazZH}{SUBSET}="VAZZH426";
$PKGI{OSF1}{VRTSazZH}{SPACE}=[1000,0,100,100];


# No product/platform specific subroutines are required
# Use them only if necessary

sub _az_osf1_postinstall_questions {
    my($installdir,$ans);
    if (-e "/etc/vx/vss/VRTSaz.loc") {
        $installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
    }
    if (-e "$installdir/bin/vxazd") {
        $CFG{CLUSTER_YN} = _aynn("Do you wish to configure the service as a highly available application?", 245, 1000);
        if($CFG{CLUSTER_YN} eq "Y"){
            _title("");
            _bpl("TruCluster Application Profile Configuration", 245, 1001);
            _pl("The configuration program will create an application resource profile for", 245, 1002);
            _pl("VERITAS Authorization Service and will register it with the CAA", 245, 1003);
            if(! -e "/usr/sbin/caa_profile"){
                _pl("/usr/sbin/caa_profile does not exist! Are you sure, this is a TruCluster node? ", 245, 1004);
		$ans=_aynn("Service will not be highly available. Continue anyway?", 245, 1005);
                if( $ans eq "N"){
                    die("Node not a cluster member");
                    $CFG{CLUSTER_YN} = "N";
                }
            }
        }
    }
}

sub _az_osf1_create_configfiles{
    my($installdir,$args,$output);
    $installdir = get_valueforname_fromfile("/etc/vx/vss/VRTSaz.loc", "ProductInstallDir");
    if($CFG{CLUSTER_YN} eq "Y"){
        # should we need to unregister first to cleanup the previous registration?
        $output=_dor("${installdir}/bin/tcvxaz -register");
        _pl($output);
        $FLAG{CONFIGFAILED} = 1;
        if ($output =~ /succe/ ) {
            $FLAG{CONFIGFAILED} = 0;
        }else{
            _pl("Resource registration failed. Use ${installdir}/bin/tcvxaz -unregister before retrying configuration.", 245, 1006, "${installdir}");
        }
    }
}
