use strict "vars"; 
use open qw(:utf8);
no warnings 'utf8';

our %CFG;
our %CMD;
our %COMM;
our %CONF;
our %DEF;
our %FLAG;
our %MSG;
our %OPT;
our %PATH;
our %PKGI;
our %PROD;
our %SUB;
our @SYSC;
our @SYSI;
our $PKG;
our $PMODE;
our $UPI;
our $SYS;

#
#SCC#  $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
#SCC#  $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#

# asks a question
sub _ask {
	my ($ask,$back,$def,$help,$nl,$noquit,$nullok,$ques,$rtn);
	_tr(@_);
	$ques=$MSG{TR};
	$def=$COMM{DEFANSWER};
	$COMM{DEFANSWER}="";
	$nullok=$COMM{NULLOK};
	$COMM{NULLOK}="";
	$noquit=$COMM{QOK};
	$COMM{QOK}="";
	$back=1 if (($COMM{BACK}) || ($COMM{PBACK}));
	$COMM{BACK}="";
	$help=$MSG{HELP};
	$MSG{HELP}="";
	$nl = ($COMM{LLCH}+length($def)+4>$COMM{TERMX}-length($MSG{INDENT})) ? "\n" : " ";
	if (($back) && ($help)) {
		$ques.=" [$MSG{BACKKEY},$MSG{HELPKEY}]";
	} elsif ($back) {
		$ques.=" [$MSG{BACKKEY}]";
	} elsif ($help) {
		$ques .= " [$MSG{HELPKEY}]";
	}
	$ques .= "$nl($def)" if (($def ne "") && ($def ne " "));
	while(1) {
		print "$COMM{TPUT}{BS}$ques$COMM{TPUT}{BE} ";
		_log($ques);
		$ask = <STDIN>;
		$ask=_desp($ask);
		_log($ask);
		_comm_cleanup(0) if (($ask =~ /^$MSG{QUITKEY}$/i) && (!$noquit));
		if (($ask=~ /^B$/i) && ($back)) {
			$FLAG{BACK}=1;
			return "";
		} elsif (($help) && ($ask eq $MSG{HELPKEY})) {
			_pl_notr("\n$help\n");
		} elsif ($ask=~/^\P{IsASCII}/) {
			_pl("Only ASCII characters may be entered.", 20, 1001);
		} else {
			$ask=$def if (($def ne "") && ($ask eq ""));
			return "$ask" if (($ask ne "") || ($nullok));
		}
	}
}

# asks a yes/no question
sub _ayn {
	my ($ayn,$back,$bk,$def,$help,$hk,$nl,$ques);
	_tr(@_);
	$ques=$MSG{TR};
	$def=$COMM{DEFANSWER};
	$COMM{DEFANSWER}="";
	$back=1 if (($COMM{BACK}) || ($COMM{PBACK}));
	$COMM{BACK}="";
	$help=$MSG{HELP};
	$MSG{HELP}="";
	$nl = ($COMM{LLCH}+10>$COMM{TERMX}-length($MSG{INDENT})) ? "\n" : " ";
	$ques.=$nl;
	$bk=",$MSG{BACKKEY}" if ($back);
	$hk=",$MSG{HELPKEY}" if ($help);
	$ques.="[$MSG{YESKEY},$MSG{NOKEY},$MSG{QUITKEY}$bk$hk] ";
	$ques.="($def) " if ($def);
	while(1) {
		print "$COMM{TPUT}{BS}$ques$COMM{TPUT}{BE}";
		_log($ques);
		$ayn = <STDIN>;
		$ayn = _desp($ayn);
		_log($ayn);
		$ayn=$def if (($def) && ($ayn eq ""));
		if (($help) && ($ayn eq $MSG{HELPKEY})) {
			_pl_notr("\n$help\n");
		} 
		return "Y" if ($ayn =~ /^$MSG{YESKEY}/i);
		return "N" if ($ayn =~ /^$MSG{NOKEY}/i);
		if (($ayn =~ /^$MSG{BACKKEY}/i) && ($back)) {
			$FLAG{BACK}=1;
			return "";
		}
		_comm_cleanup(0) if ($ayn =~ /^$MSG{QUITKEY}$/i);
	}
}

sub _aynn {
	$COMM{DEFANSWER}="$MSG{NOKEY}";
	my $ayn=_ayn(@_);
	return "$ayn";
}

sub _ayny {
	$COMM{DEFANSWER}="y";
	my $ayn=_ayn(@_);
	return "$ayn";
}

# print in bold and log
sub _bpl {
	_log(@_);
	print "$COMM{TPUT}{BS}$MSG{TR}$COMM{TPUT}{BE}\n"; 
}

# add a message to $COMM{PRECHECK}{$SYS}
sub _ckmsg {
	return if (!$OPT{PRECHECK});
	my @a=@_;
	$a[0]="* $a[0]";
	_tr(@a);
	push(@{$COMM{PRECHECK}{$SYS}},$MSG{TR});
}

# copy a file
sub _copy {
	my ($cmd,$ddoe,$df,$do,$r2l,$sf);
	($sf,$df,$r2l,$ddoe) = (@_);
	$cmd = (_localsys()) ? "$CMD{CP} -rp $sf $df" : ($r2l) ?  "$CMD{RCP} -rp $SYS:$sf $df" : "$CMD{RCP} -rp $sf root\@$SYS:$df";
	$do=_dol($cmd);
	if ($do) {
		if ($ddoe) {
			_pl("Cannot copy $sf to $df on $SYS", 20, 1002, "$sf", "$df", "$SYS");
		} else {
			_die("Cannot copy $sf to $df on $SYS", 20, 1002, "$sf", "$df", "$SYS");
		}
	}
	return "$do";
}

# copy a file and a backup
sub _copywbu {
	my ($sf,$df) = (@_);
	_copy($sf,$df);
	_copy($sf,"$df$COMM{BUCF}");
}

# compare versions
# returns 0 if versions are the same
# returns 1 if version $v1 is higher
# returns 2 if version $v2 is higher
# only checks $dim dimensions if $dim is defined
sub _cv {
	my(@a1,@a2,$dim,$f,$n,$v1,$v2);	
	($v1,$v2,$dim)=(@_);	
	@a1=split(/[\.-]/,$v1);
	@a2=split(/[\.-]/,$v2);
	$n = ($#a1>$#a2) ? $#a1 : $#a2;
	foreach $f(0..$n) {
		return "0" if (($dim ne "") && ($dim==$f));
		$v1 = ($f<=$#a1) ? $a1[$f] : "0";
		$v2 = ($f<=$#a2) ? $a2[$f] : "0";
		return 1 if ($v1>$v2);
		return 2 if ($v2>$v1);
		# Assumes letters always trail numbers
		$v1=~s/[0-9]//g;
		$v2=~s/[0-9]//g;
		return 1 if (($v1 cmp $v2)>0);
		return 2 if (($v1 cmp $v2)<0);
	}
	return "0";
}

# directory check - remote must be done by rshing an ls command
sub _dc {
	my($file,$ls,$r);
	($file)=(@_);
	if (_localsys()) {
		$r = (-d $file) ? 1 : 0;
	} else {
		$ls=_dor("$CMD{LS} -d $file");
		$r = ($ls eq $file) ? 1 : 0;
	}
	return "$r";
}

# remove spaces from begginning and end of line 
sub _desp {
	my($s)=(@_);
	$s=~s/^\s+//;
	$s=~s/\s+$//;
	return "$s";
}

# die, printing an error msg, and clean up
sub _die {
	if ($OPT{PRECHECK}) { _ckmsg(@_); return; }
	$MSG{WARNERR}=$MSG{ERROR};
	_log(@_);
	_p($MSG{TR});
	$MSG{WARNERR}="";
	exit 0 if ((!$FLAG{SAVELOG}) || ($FLAG{FORK}));
	$COMM{EXITCODE}=1 unless($COMM{EXITCODE});
	_comm_cleanup($COMM{EXITCODE});
}

# execute a command on local system, logging the command, output, and exit code
# $re=NULL - return output
# $re=1 - return exit code
# $re=2 - return both as an array reference
sub _dol {
	my ($cmd,$doe,$doo,$rdo,$re);
	($cmd,$re)=(@_);
	$cmd .= " 2>&1" unless ($cmd =~ />/);
	_log($cmd) unless ($FLAG{NODOLOG});
	_p("\n$cmd") if ($FLAG{DEBUG});
	$doo=`$cmd`;
	$doe=$?;
	chomp($doo);
	if (($COMM{LOG}) && (!$FLAG{NODOLOG})) {
		open(LOG, ">> $COMM{LOG}") or 
			_die("\n_log cannot open $COMM{LOG}", 20, 1005, "$COMM{LOG}");
		print LOG "exit=$doe\n$doo\n";
		close LOG;
	}
	_p("exit=$doe\n$doo") if ($FLAG{DEBUG});
	if (_isverror($doo)) {
		if ($FLAG{WARNVERROR}) {
			_pl_notr("$doo");
		}
		$doo="" if ($FLAG{NULLIFYVERROR});
	}
	return "$doo" if (!$re);
	return "$doe" if ($re==1);
	$rdo=["$doe","$doo"];
	return $rdo; 
}

# do on remote, prepends command with $CMD{RSH} $SYS if remote system
sub _dor {
	return _dol(@_) if (_localsys());

	my (@r,$cmd,$q,$re,$rsh,$rtn);
	($cmd,$re)=(@_);

	if ($re==2) {
		my ($doe, $doo);
		$doe = _dol("$CMD{RSH} $SYS '$CMD{REX} $_[0] 2>&1'");
		$doo = _dol("$CMD{RSH} $SYS $CMD{CAT} /tmp/rex");
		@r=($doe,$doo);
		return \@r;
	}

	$rsh="$CMD{RSH} $SYS ";
	$q = "\"" unless ($cmd=~/[">\$]/); #" balance for emacs
	$rtn=_dol("$rsh$q$cmd$q",$re);
	return "$rtn";
}

# duplicate an array to properly load the reference into a list
sub _dupa { 
	my @a=@_; 
	return \@a;
}

# duplicate a hash to properly load the reference into a list
sub _duph { 
	my $rh=shift;
	my %h=%$rh;
	return \%h;
}

# file check - remote must be done by rshing an ls command
sub _fc {
	my($file,$ls,$r);
	($file)=(@_);
	if (_localsys()) {
		$r = (-e $file) ? 1 : 0;
	} else {
		$ls=_dor("$CMD{LS} $file");
		$r = ($ls eq $file) ? 1 : 0;
	}
	return "$r";
}

# return 1 if all elements of a hash array are the same
sub _hats {
	my($i,$k,$rh,$v);
	($rh)=(@_);
	foreach $k(keys(%$rh)) {
		return "" if (($i) && ($v ne $$rh{$k}));
		$v=$$rh{$k};
		$i=1;
	}
	return 1;
}

# verify a IP address string is in ##.##.##.## notation
sub _ipcheck {
	my(@f,$d,$ip,$n);
	($ip)=(@_);
	@f=split(/\./,$ip);
	return "1" if ($#f!=3);
	foreach $n(0..3) {
		return 1 if ($f[$n] eq "");
		$d=$f[$n];
		$d =~ s/[0-9]//g;
		return "1" if (($d) || ($f[$n]>255));
	}
	return "0";
}

sub _isint {
	my($i,$s);
	($s)=(@_);
	return "1" unless ($s =~ /^-?\d+$/);
	return "";
}

sub _isnum {
	my($i,$s);
	($s)=(@_);
	return "1" unless ($s =~ /^-?\d+\.?\d*$/);
	return "";
}

sub _isverror {
	return "1" if ($_[0]=~/V-\d+-\d+\d+/);
	# other products can add what they need for pre 4.0 Error id's
	return "1" if ($_[0]=~/^VCS:\d\d\d/);
	return "";
}

# check whether a string is a member of an array.  
# Return the member number, or -1 if it is not
sub _list {
	my(@arr,$match,$n);
	($match,@arr) = (@_);
	@arr=split(/\s+/,$arr[0]) if (!$#arr);
	foreach $n(0..$#arr) { 
		_dbg("_list $match $n $arr[$n] @arr") if ($FLAG{DEBUG});
		return "$n" if ($arr[$n] eq $match); 
	}
	return "-1";
}

# as _list, but supporting * as a wildcard in @arr
# Return the member number, or -1 if it is not
# Return the member number, or -1 if it is not
sub _wclist {
    my(@arr,$match,$n,$wildcard);
    ($match,@arr) = (@_);
    @arr=split(/\s+/,$arr[0]) if (!$#arr);
    foreach $n(0..$#arr) {
        _dbg("_list $match $n $arr[$n] @arr") if ($FLAG{DEBUG});
            if  ($arr[$n] =~ "\\*")  {
                return $n if $match =~ m/$arr[$n]/;
            } else {
                return "$n" if ($arr[$n] eq $match);
            }   
    }       
    return "-1";
}   


sub _localsys { 
	return "1" if ((!$COMM{LOCALSYS}) || (lc($SYS) eq lc($COMM{LOCALSYS})) || (lc($SYS) eq lc("$COMM{LOCALSYS}.$COMM{LOCALDOMAIN}")));
	return "0";
}

# log
sub _log {
	_tr(@_);
	return unless ($COMM{LOG});
	open(LOG, ">> $COMM{LOG}") or 
		_die("\n_log cannot open $COMM{LOG}", 20, 1005, "$COMM{LOG}");
	print LOG "$MSG{TR}\n";
	close LOG;
}

# asks a question with a menu of items to select stored in @{$COMM{MENU}}
sub _menu {
	my ($back,$def,$help,$menu,$mi,$nmi,$nl,$opt,$ques,$rtn);
	_tr(@_);
	$ques=$MSG{TR};
	$def=$COMM{DEFANSWER};
	$COMM{DEFANSWER}="";
	$help=$MSG{HELP};
	$MSG{HELP}="";
	$back=1 if (($COMM{BACK}) || ($COMM{PBACK}));
	$COMM{BACK}="";
	$nl=$#{$COMM{MENU}}+1;
	$opt="[1-$nl";
	$opt.=",b" if ($back);
	$opt.=",q";
	$opt.=",$MSG{HELPKEY}" if ($help);
	$opt.="]";
	$nl = ($COMM{LLCH}+length($opt)+length($def)>$COMM{TERMX}-length($MSG{INDENT})) ? "\n" : " ";
	$ques .= "$nl$opt";
	$ques .= " ($def)" if (($def) && ($def ne " "));
	foreach $mi(@{$COMM{MENU}}) {
		$nmi=sprintf("%2d",$nmi+1);
		$FLAG{TABLB}=1;
		_pl_notr("$COMM{TPUT}{BS}$MSG{INDENT}$nmi$COMM{TPUT}{BE})  $mi");
		$FLAG{TABLB}="";
		_log("$MSG{INDENT}$nmi$MSG{INDENT}$mi", 20, 1007, "$MSG{INDENT}", "$nmi$MSG{INDENT}", "$mi");
	}
	if ($back) {
		_pl_notr("$COMM{TPUT}{BS}$MSG{INDENT} B$COMM{TPUT}{BE})$MSG{INDENT}$MSG{MENUBACK}");
		_log("$MSG{INDENT}$MSG{BACKMENU}$MSG{INDENT}$mi", 20, 1009, "$MSG{INDENT}", "$MSG{BACKMENU}", "$MSG{INDENT}", "$mi");
	}
	_p();
	while(1) {
		print "$COMM{TPUT}{BS}$ques$COMM{TPUT}{BE} ";
		_log($ques);
		$menu = <STDIN>;
		$menu=_desp($menu);
		_log($menu);
		_comm_cleanup(0) if ($menu =~ /^$MSG{QUITKEY}$/i);
		return "B" if (($back) && ($menu =~ /^$MSG{BACKKEY}$/i));
		_pl_notr("\n$help\n") if (($help) && ($menu eq $MSG{HELPKEY}));
		next if ($menu=~/\D/);
		$menu=$def if (($def) && ($menu eq ""));
		return "$menu" if (($menu>=1) && ($menu<=$nmi));
	}
}

# verify a NIC string is in "lettersnumbers" notation
sub _niccheck {
	my($l,$n,$nic);
	($nic)=(@_);
	$l=$n=$nic;
	$l=~s/[0-9]//g;
	$n=~s/[A-Za-z]//g;
	return 1 if ((!$l) || ($n eq "") || ($nic ne "$l$n"));
	return 0;
}

sub _p { print "$_[0]\n"; }
sub _dbg { print "$_[0]\n"; }

# progress bar, left side
sub _pb1 { 
	_log(@_);
	print "$MSG{INDENT}$MSG{TR} " unless ($FLAG{FORK}); 
	$MSG{PB1}=$MSG{TR};
}

# progress bar, right side
sub _pb2 { 
	my($p,$p1,$p2,$sp);
	_log(@_);
	$p1=length($MSG{PB1});
	$p2=length($MSG{TR});
	# need a reliable length that works in ja locale
	if ($COMM{ENVLANG}=~/^ja/) {
		$p1*=1.4;
		$p2*=1.4;
	}
	$sp=$COMM{TERMX}-length($MSG{INDENT})-10-$p1-$p2;
	print "$MSG{INDENT}$MSG{PB1} " if ($FLAG{FORK}); 
	print "...";
	foreach $p(1..$sp) { print "."; }
	print " $MSG{TR}\n"; 
}

# print and log
sub _pl {
	_log(@_);
	_p($MSG{TR});
}

# print and log with no translation
# message is already translated
sub _pl_notr {
	$FLAG{NOTR}=1;
	_log(@_);
	_p($MSG{TR});
	$FLAG{NOTR}="";
}

# Press Return to Continue
# only pauses when using RESPONSEFILE install or $_[0] is set
sub _prtc {
	if (($OPT{RESPONSEFILE}) || ($_[0]))  { sleep $COMM{SCREENPAUSE}; return; }
	print "\n$COMM{TPUT}{BS}$MSG{PRTC}$COMM{TPUT}{BE} ";
	my $prtc = <STDIN>;
	chomp($prtc);
	_comm_cleanup(0) if ($prtc =~ /^$MSG{QUITKEY}$/i);
}

# read a file
sub _readf {
	my($file,$line,$rf);
	($file)=(@_);
	open(RF, $file) or
		_die("\n_readf cannot open $file", 20, 1010, "$file");
	while ($line=<RF>) { $rf.=$line; }
	close(RF);
	return "$rf";	
}

# clean up zombie processes
use POSIX ":sys_wait_h";
sub _reaper {
	my($pid);
	while (($pid = waitpid(-1,WNOHANG)) > 0) {
		_log("reaped $pid", 20, 1014, "$pid");
	}
}

# cause the cursor to have a spinning char while waiting
sub _spin {
	if (!$FLAG{TPUT}) { sleep 1; return; }
	my (@ch,$n);
	@ch=("/","-","\\","|");
	print "$ch[0]$COMM{TPUT}{CL}";
	sleep 1;
	print "$ch[1]$COMM{TPUT}{CL}";
	sleep 1;
	print "$ch[2]$COMM{TPUT}{CL}";
	sleep 1;
	print "$ch[3]$COMM{TPUT}{CL}";
	sleep 1;
}

# title bar
sub _title {
	return if ($OPT{RESPONSEFILE});
	my($es,$ns,$ss,$t);
	$ns=($COMM{TERMX}-length($MSG{TITLE}))/2;
	foreach $t(1..$ns) { $ss.=" "; }
	$ns=$COMM{TERMX}-$ns-length($MSG{TITLE});
	foreach $t(1..$ns) { $es.=" "; }
	# print newlines anyway so you can scroll back after a clear
	foreach $t(1..$COMM{TERMY}) {  print "\n"; }
	system("$CMD{CLEAR}") if ((!$FLAG{TPUT}) && (-x $CMD{CLEAR}));
	print "$COMM{TPUT}{CS}$COMM{TPUT}{SS}$ss$MSG{TITLE}$es$COMM{TPUT}{SE}\n\n";
}

# check whether a regular expression is found within a member of an array.  
# Return the member number, or -1 if it is not
sub _tlist {
	my(@arr,$match,$n);
	($match,@arr) = (@_);
	@arr=split(/\s+/,$arr[0]) if (!$#arr);
	foreach $n(0..$#arr) { 
		_dbg("_tlist $match $n $arr[$n] @arr") if ($FLAG{DEBUG});
		return "$n" if ($match =~ /$arr[$n]/); 
	}
	return "-1";
}

# translate a message, saves translation in global var MSG{TR}
sub _tr_A {
	my (@l,@w,$a,$c,$line,$fc,$msg,$nm,$sp,$tm,$vxa,$word);
	if ((!$FLAG{NOTR}) && ($_[1]>0) && ($_[2]>0) && (-x "$PATH{SCRIPTS}/vxgettext")) {
		foreach $a(@_) { $vxa .= " \"$a\""; }
		$ENV{LANG}=$ENV{LC_ALL}=$COMM{ENVLANG};
		#_dbg("$PATH{SCRIPTS}/vxgettext $vxa");
		$msg=`$PATH{SCRIPTS}/vxgettext $vxa 2> /dev/null`;
		chomp($msg);
		$ENV{LANG}=$ENV{LC_ALL}="C";
	}
	$msg=$_[0] if (!$msg);
	$msg=sprintf("CPI $MSG{WARNERR} V-%d-%d-%d $msg", $COMM{ORIGID}, $_[1], $_[2]) if ($MSG{WARNERR});
	# return $msg auto-wrapping at $COMM{TERMX}-length($MSG{INDENT}) chars
	$MSG{TR}="";
	@l=split(/^/,$msg);
	foreach $line(@l) {
		$fc=substr($line,0,1);
		@w=split(/ /,$line);
		$c = ($fc eq "\t") ? 7 : 0;
		foreach $word(@w) {
			$nm = ($word=~/\n/) ? 1 : 0;
			# $COMM{TPUT} characters are adding to the length()
			# stripping them is a mess so adding 5 to the screen
			# width is the best way to fake it out
			$tm+=5 if (($word=~/\p{IsC}/) && ($word!~/\n/));
			if (($c>15) && ($c+length($word)-$nm>=$COMM{TERMX}+$tm-length($MSG{INDENT}))) { 
				$MSG{TR}.="\n"; 
				$MSG{TR}.="\t\t" if (($fc eq "\t") || ($FLAG{TABLB}));
				$c = (($fc eq "\t") || ($FLAG{TABLB})) ? 15 : 0;
				$tm=0;
			}
			$word=" $word" if ($c>0);
			$c+=length($word);
			#$c=-5 if ($word=~/\p{IsC}/);
			$MSG{TR}.=$word;
		}
	}
	$COMM{LLCH}=$c;
	return "$MSG{TR}";
}

# filter all duplicate entries from a list
sub _uniq {
	my(@a,$v);
	foreach $v(@_) { push(@a,$v) if (_list($v,@a)<0); }
	return \@a;
}

# print and log incluing UMI
sub _warn {
	$MSG{WARNERR}=$MSG{WARNING};
	_log(@_);
	_p($MSG{TR});
	$MSG{WARNERR}="";
}

# write a string to a file or append a file with a string
sub _writef {
	my($msg,$file,$new,$rd)=(@_);
	_log("Setting file: $file", 20, 1015, "$file");
	_log($msg);
	$rd = ($new) ? ">" : ">>";
	open(WF,"$rd $file") or 
		_die("\n_writef cannot open $file", 20, 1012, "$file");
	print WF "$msg\n";
	close(WF);
}

1;
sub _pkg_translate {
	my($fn);
	$fn = "_pkg_${PKG}_set_name";
	if (! defined( &$fn )) {
		_die("$PKG is an undefined package", 40, 1086, "$PKG");
	}
	&$fn(@_);
}

###
###  CAVEAT:  the "{OPTIONAL}" strings are *NOT* just strings.
###  They are *ALSO* a processing flag.  They tell CPI that it is to ask
###  the user if the package should be installed or not.  Therefore, certain
###  packages have the OPTIONAL string set optionally.
###

sub _pkg_VRTSalloc_set_name {
	$MSG{VRTSalloc}{NAME} = _tr("VERITAS Volume Manager Intelligent Storage Provisioning", 40, 1062);
}


sub _pkg_VRTSap_set_name {
	$MSG{VRTSap}{NAME}=_tr("VERITAS Action Provider", 40, 1022);
	$MSG{VRTSap}{OPTIONAL}=_tr("The VRTSap $MSG{PDFR} contains VERITAS Action Provider, which provides rules engine add-on for VERITAS Object Bus. Installing VRTSap enables support for SNMP Trap notifications and e-mails on alerts.", 40, 1088, "$MSG{PDFR}");
}


sub _pkg_VRTSat_set_name {
	$MSG{VRTSat}{NAME}=_tr("VERITAS Authentication Service", 40, 1081);
}

sub _pkg_VRTSatSDK_set_name {
	$MSG{VRTSatSDK}{NAME}=_tr("VERITAS Authentication SDK", 40, 1109);
}

sub _pkg_VRTSaz_set_name {
	$MSG{VRTSaz}{NAME}=_tr("VERITAS Authorization Service", 40, 1110);
}

sub _pkg_VRTSazSDK_set_name {
	$MSG{VRTSazSDK}{NAME}=_tr("VERITAS Authorization SDK", 40, 1111);
}

sub _pkg_VRTSazTQA_set_name {
	$MSG{VRTSazTQA}{NAME}=_tr("VERITAS Authorization Test and QA Packages", 40, 1112);
}

sub _pkg_VRTScavf_set_name {
	$MSG{VRTScavf}{NAME}=_tr("VERITAS Cluster Server Agents for Cluster File System", 40, 1075);
}

sub _pkg_VRTScfsdc_set_name {
	$MSG{VRTScfsdc}{NAME}=_tr("VERITAS Cluster File System Documentation", 40, 1076);
	$MSG{VRTScfsdc}{OPTIONAL}= _tr("The VRTScfsdc $MSG{PDFR} provides the following CFS documentation components:\n\n\tVERITAS Storage Foundation Cluster File System Installation and Administration Guide", 40, 1121, "$MSG{PDFR}");
}

sub _pkg_VRTScpi_set_name {
	$MSG{VRTScpi}{NAME}=_tr("VERITAS Cross Product Installation Framework", 40, 1145);
}

sub _pkg_VRTScscm_set_name {
	$MSG{VRTScscm}{NAME}=_tr("VERITAS Cluster Server Cluster Manager", 40, 1113);
	$MSG{VRTScscm}{OPTIONAL}=_tr("Cluster Manager (Java Console) offers complete administration capabilities for your cluster. It enables you to monitor clusters and cluster objects, including service groups, systems, resources, and resource types.\n\nVERITAS recommends that you install Cluster Manager (Java Console) on systems that are not part of your cluster.", 40, 1114);
}


sub _pkg_VRTScscw_set_name {
	$MSG{VRTScscw}{NAME}=_tr("VERITAS Cluster Server Configuration Wizards", 40, 1000);
}


sub _pkg_VRTScsocw_set_name {
	$MSG{VRTScsocw}{NAME}=_tr("VERITAS Cluster Server Oracle 9i RAC Wizard", 40, 1080);
}


sub _pkg_VRTScspro_set_name {
	$MSG{VRTScspro}{NAME}=_tr("VERITAS Cluster Server VEA Provider", 40, 1001);
}


sub _pkg_VRTScssim_set_name {
	$MSG{VRTScssim}{NAME}=_tr("VERITAS Cluster Server Simulator", 40, 1073);
	$MSG{VRTScssim}{OPTIONAL}=_tr("The VERITAS Cluster Server Simulator is used to build and simulate cluster configurations.  With VCS Simulator you can predict service group behavior during cluster or system faults, view state transitions, and designate or fine-tune various configuration parameters.", 40, 1148);
}


sub _pkg_VRTScutil_set_name {
	$MSG{VRTScutil}{NAME}=_tr("VERITAS Cluster Utilities", 40, 1002);
}


sub _pkg_VRTSd2doc_set_name {
	$MSG{VRTSd2doc}{NAME}=_tr("VERITAS Storage Foundation for DB2 Documentation", 40, 1069);
	$MSG{VRTSd2doc}{OPTIONAL}= _tr("The VRTSd2doc $MSG{PDFR} provides the following SFDB2 documentation components:\n\n\tVERITAS Storage Foundation for DB2 Database Administration's Guide\n\tVERITAS Storage Foundation for DB2 Installation Guide", 40, 1137, "$MSG{PDFR}");
}


sub _pkg_VRTSd2gui_set_name {
	$MSG{VRTSd2gui}{NAME}=_tr("VERITAS Storage Foundation Graphical User Interface for DB2", 40, 1066);
}


sub _pkg_VRTSdbckp_set_name {
	$MSG{VRTSdbckp}{NAME}=_tr("VERITAS Storage Foundation Checkpoint Scripts", 40, 1141);
}


sub _pkg_VRTSdb2ed_set_name {
	$MSG{VRTSdb2ed}{NAME}=_tr("VERITAS Storage Foundation for DB2", 40, 1064);
}


sub _pkg_VRTSdbac_set_name {
	$MSG{VRTSdbac}{NAME}=_tr("VERITAS Oracle Real Application Cluster Support Package", 40, 1079);
}


sub _pkg_VRTSdbed_set_name {
	$MSG{VRTSdbed}{NAME}=_tr("VERITAS Storage Foundation for Oracle", 40, 1063);
}


sub _pkg_VRTSddlpr_set_name {
	$MSG{VRTSddlpr}{NAME} = _tr("VERITAS Device Discovery Layer Services Provider", 40, 1038);
}


sub _pkg_VRTSfppm_set_name {
	$MSG{VRTSfppm}{NAME}=_tr("VERITAS File Placement Policy Manager", 40, 1047);
}


sub _pkg_VRTSfsdoc_set_name {
	$MSG{VRTSfsdoc}{NAME}=_tr("VERITAS File System Documentation", 40, 1003);
	$MSG{VRTSfsdoc}{OPTIONAL}=_tr("The VRTSfsdoc $MSG{PDFR} provides the following VxFS documentation components:\n\n\tVxFS Administration Guide\n\tVxFS Installation Guide", 40, 1004, "$MSG{PDFR}");
}


sub _pkg_VRTSfsman_set_name {
	$MSG{VRTSfsman}{NAME}=_tr("VERITAS File System Manual Pages", 40, 1048);
	$MSG{VRTSfsman}{OPTIONAL}= _tr("The VRTSfsman $MSG{PDFR} provides man pages for VxFS commands", 40, 1049, "$MSG{PDFR}");
}


sub _pkg_VRTSfspro_set_name {
	$MSG{VRTSfspro}{NAME} =
		_tr("VERITAS File System Management Services Provider", 40, 1036);
}


sub _pkg_VRTSgab_set_name {
	$MSG{VRTSgab}{NAME}=_tr("VERITAS Group Membership and Atomic Broadcast", 40, 1005);
	$MSG{gab}{STOPFAIL}=_tr("GAB most commonly fails to stop because GAB has client drivers that the install/uninstall scripts do not know about.  If you have such drivers active, you must stop them before running the install or uninstall scripts.", 40, 1138);
}


sub _pkg_VRTSglm_set_name {
	$MSG{VRTSglm}{NAME}=_tr("VERITAS Group Lock Manager", 40, 1071);
}


sub _pkg_VRTSgms_set_name {
	$MSG{VRTSgms}{NAME}=_tr("VERITAS Group Messaging Services", 40, 1072);
}


sub _pkg_VRTSjre_set_name {
	$MSG{VRTSjre}{NAME}=_tr("VERITAS Java Runtime Environment Redistribution", 40, 1006);
}


sub _pkg_VRTSllt_set_name {
	$MSG{VRTSllt}{NAME}=_tr("VERITAS Low Latency Transport", 40, 1007);
}

sub _pkg_VRTSmuob_set_name {
	$MSG{VRTSmuob}{NAME}=_tr("VERITAS Enterprise Administrator Service Localized Package", 40, 1139);
}


sub _pkg_VRTSob_set_name {
	$MSG{VRTSob}{NAME}=_tr("VERITAS Enterprise Administrator Service", 40, 1008);
}


sub _pkg_VRTSobadmin_set_name {
	$MSG{VRTSobadmin}{NAME}=_tr("VERITAS Enterprise Administration", 40, 1090);
}


sub _pkg_VRTSobgui_set_name {
	$MSG{VRTSobgui}{NAME}=_tr("VERITAS Enterprise Administrator", 40, 1051);
	$MSG{VRTSobgui}{OPTIONAL}=_tr("VERITAS Enterprise Administrator is an infrastructure that provides the runtime environment for graphical user interfaces", 40, 1123);
}


sub _pkg_VRTSodm_set_name {
	$MSG{VRTSodm}{NAME}=_tr("VERITAS Oracle Disk Manager", 40, 1040);
}


sub _pkg_VRTSordoc_set_name {
	$MSG{VRTSordoc}{NAME}=_tr("VERITAS Storage Foundation for Oracle Documentation", 40, 1067);
	$MSG{VRTSordoc}{OPTIONAL}= _tr("The VRTSordoc $MSG{PDFR} provides the following SFORA documentation components:\n\n\tVERITAS Storage Foundation for Oracle Database Administration's Guide\n\tVERITAS Storage Foundation for Oracle Installation Guide", 40, 1124, "$MSG{PDFR}");
}


sub _pkg_VRTSorgui_set_name {
	$MSG{VRTSorgui}{NAME}=_tr("VERITAS Storage Foundation Graphical User Interface for Oracle", 40, 1065);
}


sub _pkg_VRTSormap_set_name {
	$MSG{VRTSormap}{NAME}=_tr("VERITAS Storage Mapping Services for Oracle Database", 40, 1159);
}


sub _pkg_VRTSperl_set_name {
	$MSG{VRTSperl}{NAME}=_tr("VERITAS Perl 5.8.0 Redistribution", 40, 1009);
}


sub _pkg_VRTSracdc_set_name {
	$MSG{VRTSracdc}{NAME}=_tr("VERITAS Storage Foundation 4.0 for Oracle RAC Documentation", 40, 1147);
}


sub _pkg_VRTSsal_set_name {
	$MSG{VRTSsal}{NAME}=_tr("VERITAS SAN Access Layer", 40, 1082);
}


sub _pkg_VRTSspcfg_set_name {
	$MSG{VRTSspcfg}{NAME}=_tr("VERITAS SANPoint Control Configuration Utility", 40, 1084);
}


sub _pkg_VRTSspqdc_set_name {
	$MSG{VRTSspqdc}{NAME}=_tr("VERITAS SANPoint Control Quickstart Documentation", 40, 1132);
	$MSG{VRTSspqdc}{OPTIONAL}=_tr("The VRTSspqdc package provides the following SANPoint Control QuickStart (SPCQS) documentation components:\n\nSPCQS Installation and Configuration Guide\nSPCQS Overview Guide\nSPCQS Release Notes", 40, 1133);
}


sub _pkg_VRTSspqmn_set_name {
	$MSG{VRTSspqmn}{NAME}=_tr("VERITAS SANPoint Control Quickstart Manual Pages", 40, 1083);
	$MSG{VRTSspqmn}{OPTIONAL}=_tr("The VRTSspqmn package provides man pages for SPCQS commands.", 40, 1134);
}


sub _pkg_VRTSspcqs_set_name {
	$MSG{VRTSspcqs}{NAME}=_tr("VERITAS SANPoint Control QuickStart", 40, 1085);
}


sub _pkg_VRTSsragt_set_name {
	$MSG{VRTSsragt}{NAME}=_tr("VERITAS Storage Reporter Agents", 40, 1050);
}


sub _pkg_VRTSsybed_set_name {
	$MSG{VRTSsybed}{NAME}=_tr("VERITAS Storage Foundation for Sybase", 40, 1116);
}


sub _pkg_VRTSsydoc_set_name {
	$MSG{VRTSsydoc}{NAME}=_tr("VERITAS Storage Foundation for Sybase Documentation", 40, 1117);
	$MSG{VRTSsydoc}{OPTIONAL}= _tr("The VRTSsydoc $MSG{PDFR} provides the following SFSYB documentation components:\n\n\tVERITAS Storage Foundation for Sybase Database Administration's Guide\n\tVERITAS Storage Foundation for Sybase Installation Guide", 40, 1125, "$MSG{PDFR}");
}


sub _pkg_VRTStd_set_name {
	$MSG{VRTStd}{NAME} = _tr("VERITAS Traffic Director (Core Software)", 40, 1029);
}


sub _pkg_VRTStddoc_set_name {
	$MSG{VRTStddoc}{NAME} = _tr("VERITAS Traffic Director (Documentation)", 40, 1031);
}


sub _pkg_VRTStdw_set_name {
	$MSG{VRTStdw}{NAME} = _tr("VERITAS Traffic Director (Web GUI)", 40, 1030);
}


sub _pkg_VRTStep_set_name {
	$MSG{VRTStep}{OPTIONAL}=_tr("The VRTStep $MSG{PDFR} contains VERITAS Task Exec Provider, which provides command execution add-on for VERITAS Object Bus. Installing VRTStep and VRTSap enables support of command execution in response to an alert.", 40, 1097, "$MSG{PDFR}"); 
	$MSG{VRTStep}{NAME}=_tr("VERITAS Task Provider", 40, 1059);

}


sub _pkg_VRTSvail_set_name {
	$MSG{VRTSvail}{NAME} = _tr("VERITAS Array Provider", 40, 1126);
}


sub _pkg_VRTSvcsApache_set_name {
	$MSG{VRTSvcsApache}{NAME}=_tr("VERITAS Cluster Server Apache Agent", 40, 1098);
	$MSG{VRTSvcsApache}{OPTIONAL}=_tr("The Apache agent of VERITAS Cluster Server. If you configure VCS through installer the type definition of Apache agent will get included in the configuration. Otherwise you need to add the same manually. Please refere documents for details.", 40, 1135);
}


sub _pkg_VRTSvcs_set_name {
	$MSG{VRTSvcs}{NAME}=_tr("VERITAS Cluster Server", 40, 1010);
}


sub _pkg_VRTSvcsag_set_name {
	$MSG{VRTSvcsag}{NAME}=_tr("VERITAS Cluster Server Bundled Agents", 40, 1011);
}


sub _pkg_VRTSvcsdc_set_name {
	$MSG{VRTSvcsdc}{NAME}=_tr("VERITAS Cluster Server Documentation", 40, 1012);
	if ($COMM{OS} eq "SunOS") {
		$MSG{VRTSvcsdc}{OPTIONAL}=_tr("The VRTSvcsdc $MSG{PDFR} provides the following VCS documentation components:\n\n\tVCS User's Guide\n\tVCS Installation Guide\n\tVCS Bundled Agents Reference Guide\n\tVCS Agent Developer's Guide\n\tVCS with E10000 Appnote", 40, 1128, "$MSG{PDFR}");
	} elsif ($COMM{OS} eq "AIX") {
		$MSG{VRTSvcsdc}{OPTIONAL}=_tr("This package provides the following VCS documentation components:\n\n\tVCS User's Guide\n\tVCS Installation Guide\n\tVCS Bundled Agents Reference Guide\n\tVCS Agent Developer's Guide", 40, 1129);
	} elsif ($COMM{OS} eq "Linux") {
		$MSG{VRTSvcsdc}{OPTIONAL}=_tr("This package provides the following VCS documentation components:\n\n\tVCS User's Guide \n\tVCS Bundled Agents Reference Guide\n\tVCS Agent Developer's Guide", 40, 1151);
	}
}


sub _pkg_VRTSvcsmg_set_name {
	$MSG{VRTSvcsmg}{NAME}=_tr("VERITAS Cluster Server Message Catalogs", 40, 1014);
}


sub _pkg_VRTSvcsmn_set_name {
	$MSG{VRTSvcsmn}{NAME}=_tr("VERITAS Cluster Server Man Pages", 40, 1053);
	$MSG{VRTSvcsmn}{OPTIONAL}=_tr("The VRTSvcsmn $MSG{PDFR} provides man pages for VCS commands", 40, 1016, "$MSG{PDFR}");
}

sub _pkg_VRTStddoc_set_name {
	$MSG{VRTStddoc}{NAME}=_tr("VERITAS Cluster Server Traffic Director Documentation", 40, 1152);
	$MSG{VRTStddoc}{OPTIONAL}=_tr("The VRTStddoc $MSG{PDFR} provides Traffic Director User's Guide documentation", 40, 1157, "$MSG{PDFR}");
}

sub _pkg_VRTSvcsor_set_name {
	$MSG{VRTSvcsor}{NAME}=_tr("VERITAS Cluster Server Oracle Enterprise Extension", 40, 1078);
}


sub _pkg_VRTSvcsvp_set_name {
	$MSG{VRTSvcsvp}{NAME}=_tr("VERITAS Cluster Server VP", 40, 1120);
}


sub _pkg_VRTSvcsvr_set_name {
	$MSG{VRTSvcsvr}{NAME}=_tr("VERITAS Cluster Server Agents for VVR", 40, 1149);
}


sub _pkg_VRTSvrmcsg_set_name {
	$MSG{VRTSvrmcsg}{NAME}=_tr("MC/ServiceGuard Agent for VVR", 40, 1160);
}

sub _pkg_VRTSvcsw_set_name {
	$MSG{VRTSvcsw}{NAME}=_tr("VERITAS Cluster Manager (Web Console)", 40, 1017);
}


sub _pkg_VRTSvmdoc_set_name {
	$MSG{VRTSvmdoc}{NAME}=_tr("VERITAS Volume Manager Documentation", 40, 1054);
	$MSG{VRTSvmdoc}{OPTIONAL}=_tr("The VRTSvmdoc $MSG{PDFR} provides the following VM documentation components:\n\n\tVM Administrator's Guide\n\tVM Installation Guide\n\tVM Troubleshooting Guide\n\tFlashSnap Point-in-Time Copy Solutions Administrator's Guide\n\tVM Hardware Notes\n\tVM Storage Allocator Administrator's Guide\n\tVM Cross-Platform Data Sharing Administrator's Guide", 40, 1104, "$MSG{PDFR}");
}


sub _pkg_VRTSvmman_set_name {
	$MSG{VRTSvmman}{OPTIONAL}=_tr("The VRTSvmman $MSG{PDFR} provides man pages for Volume Manager and its licensable features.", 40, 1033, "$MSG{PDFR}");
	$MSG{VRTSvmman}{NAME} = _tr("VERITAS Volume Manager Manual Pages", 40, 1034);
}


sub _pkg_VRTSvmpro_set_name {
	$MSG{VRTSvmpro}{NAME} = _tr("VERITAS Volume Manager Management Services Provider", 40, 1035);
}


sub _pkg_VRTSvrdoc_set_name {
	$MSG{VRTSvrdoc}{OPTIONAL}=_tr("The VRTSvrdoc $MSG{PDFR} contains the following VVR documentation components:\n\n\tVERITAS Cluster Enterprise Agents for VERITAS Volume Replicator : Configuration Guide\n\tVERITAS Volume Replicator Advisor : Administrators Guide\n\tVERITAS Volume Replicator Web Console : Administrator's Guide.", 40, 1161, "$MSG{PDFR}");
	$MSG{VRTSvrdoc}{NAME}=_tr("VERITAS Volume Replicator Documentation", 40, 1150);
}


sub _pkg_VRTSvrpro_set_name {
	$MSG{VRTSvrpro}{NAME}=_tr("VERITAS Volume Replicator Client Extension and Provider for \n\t	 VERITAS Enterprise Administrator", 40, 1105);
}


sub _pkg_VRTSvrw_set_name {
	$MSG{VRTSvrw}{OPTIONAL}=_tr("The VRTSvrw $MSG{PDFR} is a Web-based graphical user interface replication tool, that enables you to create, manage, and administer VVR configurations using a Web browser.", 40, 1023, "$MSG{PDFR}");
	$MSG{VRTSvrw}{NAME}=_tr("VERITAS Volume Replicator Web Console", 40, 1060);
	#$MSG{VRTSvrw}{NAME}=_tr("VERITAS Volume Replicator Web Console\n\t\tInstalling VRTSvrw will also install VRTSjre and VRTSweb;\n\t\tif they are not yet installed.");
}


sub _pkg_VRTSvxfen_set_name {
	$MSG{VRTSvxfen}{NAME}=_tr("VERITAS I/O Fencing", 40, 1025);
		if ($UPI ne "SFCFS") {
			$MSG{VRTSvxfen}{OPTIONAL}=_tr("The VERITAS I/O Fencing module is designed to prevent data corruption in the case of split-brain condition in VCS. You must refer to the VCS documentation for hardware requirements and manual configuration procedures in order to use this module.", 40, 1026);
			if ($COMM{OS} eq "SunOS") {
				$MSG{VRTSvxfen}{OPTIONAL}.=_tr("\n\nThe VRTSvxfen package is only supported on Solaris 8 and Solaris 9 and not installed on prior versions.", 40, 1061);
			}
		}
}


sub _pkg_VRTSvxfs_set_name {
	$MSG{VRTSvxfs}{NAME}=_tr("VERITAS File System", 40, 1046);
}


sub _pkg_VRTSvxmsa_set_name {
	$MSG{VRTSvxmsa}{NAME}=_tr("VERITAS Mapping Service, Application Libraries", 40, 1041);
}


sub _pkg_VRTSvxvm_set_name {
	$MSG{VRTSvxvm}{NAME} = _tr("VERITAS Volume Manager Binaries", 40, 1032);
}


sub _pkg_VRTSweb_set_name {
	$MSG{VRTSweb}{NAME}=_tr("VERITAS Java Web Server", 40, 1028);
}


sub _pkg_WindowsClusterManager_set_name {
	$MSG{WindowsClusterManager}{NAME}=_tr("VERITAS Windows Cluster Manager", 40, 1106);
}


sub _pkg_WindowsSimulator_set_name {
	$MSG{WindowsSimulator}{NAME}=_tr("VERITAS Windows Simulator", 40, 1107);
}


sub _pkg_WindowsWebConsole_set_name {
	$MSG{WindowsWebConsole}{NAME}=_tr("VERITAS Windows Web Console", 40, 1108);
}


sub _pkg_VRTSfas_set_name {
        $MSG{VRTSfas}{NAME}=_tr("VERITAS FlashSnap Agent for Symmetrix", 40, 1130);
}


sub _pkg_VRTSfasag_set_name {
	$MSG{VRTSfasag}{NAME}=_tr("VERITAS Cluster Server Agents for VERITAS FlashSnap Agent for Symmetrix", 40, 1131);
	$MSG{VRTSfasag}{OPTIONAL} = _tr("VCS Agents for VERITAS FlashSnap Agent for Symmetrix provide the HA feature which enables the automatic recovery of crashed snapshot operations in VCS environment.", 40, 1136);
}

sub _pkg_VRTSfasdc_set_name {
	$MSG{VRTSfasdc}{NAME}=_tr("VERITAS FlashSnap Agent for Symmetrix Documentation", 40, 1142);
	$MSG{VRTSfasdc}{OPTIONAL} = _tr("This package provides the following VxFAS documentation components:\n\n\tVxFAS Installation Guide\n\tVxFAS Administrator's Guide\n\tVCS Agents for VxFAS Installation and Configuration Guide", 40, 1143);
}

sub _pkg_VRTSveki_set_name {
	$MSG{VRTSveki}{NAME}=_tr("VERITAS Kernel Interface", 40, 1144);
}

sub _pkg_VRTSlvmconv_set_name {
	$MSG{VRTSlvmconv}{NAME}=_tr("VERITAS Linux LVM to VxVM Converter", 40, 1154);
	$MSG{VRTSlvmconv}{OPTIONAL}=_tr("This package provides a conversion utility for Linux customers to migrate their systems from LVM to VxVM use.", 40, 1155);
}
1;
#
# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
# 

#
# Define product information
#
$PROD{FAS}{NAME} = "VERITAS FlashSnap Agent for Symmetrix";
$PROD{FAS}{ABBR} = "FAS";
$PROD{FAS}{TRAINDIR} = "vxfas";
$PROD{FAS}{LICFEATURE} = "VVS_CONFIG";
# $PROD{FAS}{CLUSTER} = 1;

#
# This flag is used by _fas_dbg_pl().
# 
$FLAG{FAS}{DEBUG} = 0;
$FLAG{FAS}{SYMCLI_FOUND} = 0;

#
# Display debug messages.
#
sub _fas_dbg_pl {
	my ($msg) = (@_);
	_pl("*** FAS DEBUG: $msg", 250, 1000, "$msg") if ($FLAG{FAS}{DEBUG} == 1);
}

#
# define packages and patches for the installation
# return a reference to a list
# 
sub _fas_comm_define_pkgs {
	_fas_dbg_pl("_fas_comm_define_pkgs(): PMODE = $PMODE");
	if ($PMODE eq "SFEHA") {
		#
		# HA mode installation, include the agent package.
		#
		$PROD{FAS}{PKGS} = [ qw(VRTSfas VRTSfasag VRTSfasdc) ];
	} else {
		#
		# Base package
		#
		$PROD{FAS}{PKGS} = [ qw(VRTSfas VRTSfasdc) ];
	}
	return $PROD{FAS}{PKGS};
}

#
# Ask the user if he wants to enable the EMC rules for VM operations
#
sub _fas_ask_enable_emc_rules {
	my ($ayn);

	$CFG{FAS}{VXSYMRULE} = "n";
	$MSG{HELP}=_tr("Volume Manager has a set of guidelines/rules to help ensure that the Volume Manager works well with the intelligent storage/hardware in an EMC environment. Most of the rules apply to Volume Manager tasks such as creating a disk group, adding disks to a disk group, and allocating storage for a volume.\nIf rules are enabled then administrator will get the warnings about situations that might result in a configuration with objects that cannot be administered by the FlashSnap Agent for Symmetrix, potential incompatibilities between objects, or performance loss. For more information refer to the VxFAS Administrator's Guide.", 250, 1003);
	$ayn=_ayny("\nDo you want to enable optional VxFAS EMC configuration rules?", 250, 1004);
	$CFG{FAS}{VXSYMRULE} = "y" if ( $ayn eq "Y" );
}

#
# perform precheck processing
#
sub _fas_comm_precheck {
	_prod_plat_sub("FAS", "precheck");
}

#
# perform preinstall processing
#
sub _fas_comm_preinstall {
	_fas_dbg_pl("preinstall");
	_prod_plat_sub("FAS", "preinstall");
}

#
# Ask request questions
#
sub _fas_comm_pkgrequest_questions {
	_fas_dbg_pl("pkgrequest_questions");
	_fas_ask_enable_emc_rules() if ($FLAG{FAS}{SYMCLI_FOUND} == 1);
}

#
# Check if SYMCLI is installed properly
#
sub _fas_symcli_check {
	# return value already found for VRTSfasag
	return $FLAG{NOSYMCLI}{$SYS} if ($FLAG{NOSYMCLI}{$SYS} ne "");
	_pb1("Checking SYMCLI required for VRTSfas", 250, 1005);
	if (!_prod_plat_sub("FAS", "symcli_check")) {
		_pb2("installed", 250, 1006);
		$FLAG{NOSYMCLI}{$SYS}="0";
		$FLAG{FAS}{SYMCLI_FOUND} = 1;
	} else {
		_pb2("not installed", 250, 1007);
		_log("Not installing $PKG on $SYS because SYMCLI for TimeFinder was not found", 250, 1008, "$PKG", "$SYS");
		$FLAG{NOSYMCLI}{$SYS}="1";
	}
	return $FLAG{NOSYMCLI}{$SYS};
}

1;
#SCC#
#SCC# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
#SCC# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#SCC#
#SCC#


# Define product information
$PROD{ODM}{NAME}="File System";
$PROD{ODM}{ABBR}="ODM";
$PROD{ODM}{LICFEATURE}="ODM";

#SCC#
#SCC# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
#SCC# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#SCC#
#SCC#

# Define frequently referenced paths
$PATH{FSBIN}="/opt/VRTSvxfs/sbin";

# Define product information
$PROD{FS}{NAME}="File System";
$PROD{FS}{ABBR}="VxFS";
$PROD{FS}{HOMEDIR}="/opt/VRTSvxfs";
$PROD{FS}{LICFEATURE}="VXFS";

# VRTSap and VRTStep are Optionally Removable Packages
# VRTSfspro is used by VM
#$PROD{FS}{OPTRMPKGS}=[ qw(VRTSfspro VRTStep VRTSap) ];
# replacing with soft dependencies

# FS entry points that have to be called from the different suite cpi scripts.
# sub _fs_comm_prestop
# sub _fs_comm_completion_messages
# sub _fs_comm_initial_systemcheck

# Function: _fs_comm_initial_systemcheck()
# Called at the start to perform OS requirements and Patch checks
#
sub _fs_comm_initial_systemcheck {

	_prod_plat_sub("FS","initial_systemcheck");
} # end of _fs_comm_initial_systemcheck

# Function: _fs_comm_prestop()
# Called before installing VxFS to check for upgrades.
# Also before uninstalling, it checks for mounted filesystems.
#
sub _fs_comm_prestop {
my ($ret);
	if ($OPT{UNINSTALL}) {
		$ret = _prod_plat_sub("FS", "umnt");
		if ($ret) {
			_die("VxFS filesystems are mounted and need to be unmounted before uninstalling.\n", 100, 1015);
		}
		return;	
	} else {
		fs_preinstallcheck();
	}
} # end of _fs_comm_prestop()

# Function: fs_preinstallcheck()
# Display preinstallation messages and confirmations for upgrade
# before installation. Also take care of -precheck option.
# It takes care of mounted filesystems and EOLed disk layouts.
#
sub fs_preinstallcheck {
my ($ret, $ret1, $ret2, $rt3, $ayn1, $ayn2, $instpv, $mediapv, $numsys, $cvret);
	return if ($OPT{INSTALLONLY});
	$ret = _prod_plat_sub("FS", "currinst");
	if (($ret)&&($OPT{INSTALL})) {
		$instpv = _prod_plat_sub("FS", "getinstpkgvers");
		$mediapv = _prod_plat_sub("FS", "getmediapkgvers");
		$cvret = _cv($instpv, $mediapv);
		if ($cvret <= 1) {
			return;
		}
		_pl("\nVxFS version $instpv is already installed on the system $SYS.", 100, 1027, "$instpv", "$SYS") if (!$OPT{PRECHECK}); 
		_pl("\nBefore upgrading all the mounted VxFS file systems should be unmounted.", 100, 1001) if (!$OPT{PRECHECK});
		_pl("\nDuring upgrade the VxFS $instpv packages currently installed will be uninstalled and the new VxFS $mediapv packages will be installed.", 100, 1002, "$instpv", "$mediapv") if (!$OPT{PRECHECK});
		$MSG{HELP}=_tr("If you choose <y>, the VxFS $instpv packages currently installed on your system will be uninstalled and new VxFS $mediapv packages will be installed. \n\n Also all mounted VxFS file systems need to be unmounted before you can upgrade VxFS. The mounted VxFS file systems must be unmounted before continuing.", 100, 1031, "$instpv", "$mediapv");
		if (!$OPT{PRECHECK}) {
			$ayn1 = _ayny("\nDo you want to upgrade VxFS?", 100, 1033);
		} else {
			$ayn1 = "Y";
		}
		if ($ayn1 eq "Y") {

			$ret2 = _prod_plat_sub("FS", "umnt");	
			if ($ret2) {
				_pl("\n All mounted VxFS file systems need to be unmounted before upgrading.\nUnmount all the mounted VxFS file systems and try installing again.\n", 100, 1032) if (!$OPT{PRECHECK});
				_die("VxFS file systems are mounted and need to be unmounted before upgrade.\n", 100, 1018);
			}

			$rt3 = _prod_plat_sub("FS", "fspkginst", "VRTSfsnbl");
			if ($rt3) {
				push(@{$COMM{UPKGS}{$SYS}},"VRTSfsnbl");
			}
			$rt3 = _prod_plat_sub("FS", "fspkginst", "VRTSfdd");
			if ($rt3) {
				push(@{$COMM{UPKGS}{$SYS}},"VRTSfdd");
			}
			$rt3 = _prod_plat_sub("FS", "fspkginst", "VRTSqio");
			if ($rt3) {
				push(@{$COMM{UPKGS}{$SYS}},"VRTSqio");
			}
			$rt3 = _prod_plat_sub("FS", "fspkginst", "VRTSvxld");
			if ($rt3) {
				push(@{$COMM{UPKGS}{$SYS}},"VRTSvxld");
			}
			$rt3 = _prod_plat_sub("FS", "fspkginst", "VRTSqlog");
			if ($rt3) {
				push(@{$COMM{UPKGS}{$SYS}},"VRTSqlog");
			}
			$rt3 = _prod_plat_sub("FS", "fspkginst", "VRTSjafs");
			if ($rt3) {
				push(@{$COMM{UPKGS}{$SYS}},"VRTSjafs");
			}
			$rt3 = _prod_plat_sub("FS", "fspkginst", "VRTSjaglm");
			if ($rt3) {
				push(@{$COMM{UPKGS}{$SYS}},"VRTSjaglm");
			}

			$ret1 = _prod_plat_sub("FS", "eold");
			if ($ret1) {
				if (!$OPT{PRECHECK}) {
					_warn("\nWarning: VxFS file systems having disk layout Version 1, 2 or 3 are present on this system. Disk layout Versions 1-3 are no longer supported.\n", 100, 1028);
					_pl("Use the vxupgrade(1M) command to upgrade mounted file systems, or the vxfsconvert(1M) command to upgrade unmounted file systems. See the VERITAS File System Installation Guide for more information on upgrading VxFS disk layout versions.", 100, 1029);
					$MSG{HELP}=_tr("If you decide to continue without upgrading your disk layout from version 1, 2 or 3 to version 4 or above, you will be unable to mount these EOLed filesystem after upgrade. You will have to perform an offline upgrade using vxfsconvert(1M) before you can use them.", 100, 1020);
					$ayn2 = _aynn("\nAre you sure you want to continue?", 100, 1021);
				} else {
					$ayn2 = "N";
				}
				if ($ayn2 eq "N") {
					_die("VxFS file systems having disk layout versions 1, 2 or 3 are present.\n The Disk Layout version needs to be upgraded to 4 or higher before upgrade.\n", 100, 1022);
				} else {
					_pl("\n You have decided not to upgrade your EOLed disk layouts. After upgrade you will not be able to mount these filesystems and will have to perform an offline upgrade using vxfsconvert(1M) before you can mount them.\n", 100, 1023);
				}
			}
			else {
				_pl("\n Notice: This Version of VxFS supports only disk layout Version 4 and above. No VxFS file systems with disk layout Versions 1-3 were discovered on this system. Only the VxFS file systems in the $CONF{FSTAB} file were checked. If you have any VxFS file systems that are using disk layout Versions 1-3, upgrade them to disk layout Version 4 or above and restart the VxFS installation.\n", 100, 1034, "$CONF{FSTAB}") if (!$OPT{PRECHECK});
				_pl("Use the vxupgrade(1M) command to upgrade mounted file systems, or the vxfsconvert(1M) command to upgrade unmounted file systems. Use the fstyp -v command to determine the VxFS file system version. See the VERITAS File System Installation Guide for more information on upgrading VxFS disk layout versions. To cancel the installation, enter q.", 100, 1035) if (!$OPT{PRECHECK});
				_prtc() if (!$OPT{PRECHECK});
				_pl_notr("\n");
			}
		}
		else {
			_pl("\nYou have selected not to upgrade VxFS", 100, 1025) if (!$OPT{PRECHECK});
			_die("VxFS version $instpv is already installed on the system and you have selected not to upgrade.\n", 100, 1026, "$instpv");
		}
		$numsys=$#SYSI;
		_prtc() if ((!$OPT{PRECHECK})&&($numsys > 0));
		_title() if ((!$OPT{PRECHECK})&&($numsys > 0));
	}
} # end of fs_preinstallcheck

# Function: _fs_comm_completion_messages()
# display task completion information after VxFS is installed or upgraded.
#
sub _fs_comm_completion_messages {

	_prod_plat_sub("FS", "compmessages");
} # end of _fs_comm_completion_messages()

1;
# Define frequently used commands
# $CMD{SFCMD}="/sbin/prodcmd";

# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms
# $CMD{START}{process}="$CMD{SFCMD} -start";
# $CMD{STOP}{process}="$CMD{SFCMD} -stop";

# Define product configuration files
# $CONF{CONFIG}="/etc/prodconf/config";

# Define frequently referenced paths
# $PATH{SFBIN}="/opt/VRTSprod/bin";
# $PATH{SFCONF}="/etc/prodconf";

# Define product modes and names for product modes, if necessary

$PROD{SFQS}{NAME}="Storage Foundation QuickStart";
$PROD{SFQS}{LNAME}="Foundation Suite QuickStart";
$PROD{SFQS}{ABBR}="SFQS";
$PROD{SFQS}{DIR}=$PROD{SF}{DIR};

$PROD{SFS}{NAME}="Storage Foundation Standard";
$PROD{SFS}{LNAME}="Foundation Suite";
$PROD{SFS}{ABBR}="SFS";
$PROD{SFS}{DIR}="storage_foundation";

$PROD{SFHA}{NAME}="Storage Foundation Standard HA";
$PROD{SFHA}{LNAME}="Foundation Suite HA";
$PROD{SFHA}{ABBR}="SFHA";
$PROD{SFHA}{DIR}=$PROD{SF}{DIR};

$PROD{SFE}{NAME}="Storage Foundation Enterprise";
$PROD{SFE}{ABBR}="SFE";
$PROD{SFE}{DIR}=$PROD{SF}{DIR};

$PROD{SFEHA}{NAME}="Storage Foundation Enterprise HA";
$PROD{SFEHA}{ABBR}="SFEHA";
$PROD{SFEHA}{DIR}=$PROD{SF}{DIR};

$PROD{SF}{MODES} = [ qw(SFQS SFS SFHA SFE SFEHA) ];
$PROD{SF}{NAME}="Storage Foundation";
$PROD{SF}{LNAME}="Foundation Suite";
$PROD{SF}{ABBR}="SF";
$PROD{SF}{DIR}="storage_foundation";
$PROD{SF}{UGVERS}=["3.5"];
# VRTSap and VRTStep are Optionally Removable Packages
#$PROD{SF}{OPTRMPKGS}=[ qw(VRTStep VRTSap) ];
# replacing with soft dependencies

sub _sf_comm_is_prodkey {
	#my ($pn, $rk);
	my($rk)=(@_);	
	my ($pn)=($$rk{'Product Name'});
	$pn=~s/^VERITAS //;
	foreach my $mode(@{$PROD{SF}{MODES}}) {
               	#return $mode if ($$rk{'Product Name'} eq $PROD{$mode}{NAME});
               	return $mode if ($pn eq $PROD{$mode}{NAME});
        }
	# Don't want to return "SF" here since volume manager also may be passed
	# as we return "SF". For SFQS this is a problem
        return "";
}

# ask for product mode for pre-install check
# not required if your product is not mode based
sub _sf_comm_ask_mode {
	my @mode=("SFQS","SFS", "SFHA", "SFE", "SFEHA");
	_bpl("$PROD{SF}{ABBR} Preinstallation Check:", 200, 1002, "$PROD{SF}{ABBR}");
	$COMM{MENU}=[$PROD{SFQS}{NAME},$PROD{SFS}{NAME},$PROD{SFHA}{NAME},$PROD{SFE}{NAME}, ,$PROD{SFEHA}{NAME}];
	my $menu=_menu("For what version of $PROD{SF}{ABBR} would you like to perform a pre-installation check?", 200, 1001, "$PROD{SF}{ABBR}");
	return "$mode[$menu-1]"
}

# perform any sf specific checks or tasks necessary before the installation
sub _sf_comm_initial_systemcheck {
        _vm_comm_initial_systemcheck();
        _fs_comm_initial_systemcheck();
}

# check to see if valid configuration files exist on the local system
# if so, return a reference to an array holding ("systems", "version")
sub _sf_comm_check_localconfig {
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_check_localconfig();
	}
}

# confirm proper running/non running state before performing 
# configuration via the -configure option.
sub _sf_comm_check_preconfigstate {
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_check_preconfigstate();
	}
}

# create configuration files from %CMD values
sub _sf_comm_create_configfiles {
	my ($cfdone);
	$cfdone=0;
	
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_create_configfiles();
		$cfdone=1;
	}
	# VVR not available for SFQS, SF Standard and SF Standard HA
	if ((($PMODE eq "SFE") && ($FLAG{VVR})) || (($PMODE eq "SFEHA") && ($FLAG{VVR}))) {
		_vvr_comm_create_configfiles();
		$cfdone=1;
	}
	if ($cfdone ne 1) {
		_pb1("Configuring $PROD{$PMODE}{NAME} on $SYS", 200, 1003, "$PROD{$PMODE}{NAME}", "$SYS"); 
		_pb2("Done", 200, 1004);
	}
}

# display task completion information
sub _sf_comm_completion_messages {
	if ((($PMODE eq "SFE") && ($FLAG{VVR})) || (($PMODE eq "SFEHA") && ($FLAG{VVR}))) {
		_vvr_comm_completion_messages();
	} else {
		_vm_comm_completion_messages();
	}
	_fs_comm_completion_messages();
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_completion_messages();
	}
}

sub _sf_comm_get_mode {
	my($rk)=(@_);	
	my ($pn)=($$rk{'Product Name'});
	$pn=~s/^VERITAS //;
	foreach my $mode(@{$PROD{SF}{MODES}}) {
               	#return $mode if ($$rk{'Product Name'} eq $PROD{$mode}{NAME});
               	return $mode if ($pn eq $PROD{$mode}{NAME});
        }
        return "";
}

sub _sf_comm_flag_license {

	my($k, $rk);

	# Note that only VVR option available for 4.0 and this
	# code might need modification for future releases
	for $rk(@{$COMM{KEYS}{$SYS}}) {
		for $k(keys(%$rk)) {
			$FLAG{VVR} = 1 if ((($$rk{UPI} eq "VM") || ($PMODE eq "SFE") || ($PMODE eq "SFEHA")) && ($k eq "VVR") && ($$rk{$k} eq "Enabled"));
			$FLAG{FASTRESYNC} = 1 if ((($$PMODE eq "SFS") || ($PMODE eq "SFHA")) && ($k eq "FASTRESYNC") && ($$rk{$k} eq "Enabled"));
			$FLAG{DGSJ} = 1 if ((($PMODE eq "SFS") || ($PMODE eq "SFHA")) && ($k eq "DGSJ") && ($$rk{$k} eq "Enabled"));
			$FLAG{VXCKPT} = 1 if ((($PMODE eq "SFS") || ($PMODE eq "SFHA")) && ($k eq "VXCKPT") && ($$rk{$k} eq "Enabled"));
			$FLAG{FLASHSNAP} = 1 if (($FLAG{FASTRESYNC} == 1) && ($FLAG{DGSJ} == 1) && ($FLAG{VXCKPT} == 1));
		}
	}
}

# ask questions asked by pkg request scripts
sub _sf_comm_pkgrequest_questions {
	if ((($PMODE eq "SFE") && ($FLAG{VVR})) || (($PMODE eq "SFEHA") && ($FLAG{VVR}))) {
		_vvr_comm_pkgrequest_questions();
	} else {
		_vm_comm_pkgrequest_questions();
	}
	return if ($COMM{OS} ne "SunOS");
	if (($PMODE eq "SFE") || ($PMODE eq "SFEHA")) {
		_fas_comm_pkgrequest_questions();
	}
}

# perform any checks or tasks necessary after the product is installed
sub _sf_comm_postinstall {
	if ((($PMODE eq "SFE") && ($FLAG{VVR})) || (($PMODE eq "SFEHA") && ($FLAG{VVR}))) {
		_vvr_comm_postinstall();
	} else {
		_vm_comm_postinstall();
	}
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_postinstall();
	}
}

# ask configuration questions necessary following installation
sub _sf_comm_postinstall_questions {
	if ((($PMODE eq "SFE") && ($FLAG{VVR})) || (($PMODE eq "SFEHA") && ($FLAG{VVR}))) {
		_vvr_comm_postinstall_questions();
	} else {
		_vm_comm_postinstall_questions();
	}
}

# perform any checks or tasks necessary after the product is started
sub _sf_comm_poststart {
	if ((($PMODE eq "SFE") && ($FLAG{VVR})) || (($PMODE eq "SFEHA") && ($FLAG{VVR}))) {
		_vvr_comm_poststart();
	} else {
		_vm_comm_poststart();
	}
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_poststart();
	}
}

# perform preinstallation tasks 
# use $COMM{TASK} or $OPT to filter, if necessary
sub _sf_comm_preinstall {
	if ((($PMODE eq "SFE") && ($FLAG{VVR})) || (($PMODE eq "SFEHA") && ($FLAG{VVR}))) {
		_vvr_comm_preinstall();
	} else {
		_vm_comm_preinstall();
	}
	return if ($COMM{OS} ne "SunOS");
	if (($PMODE eq "SFE") || ($PMODE eq "SFEHA")) {
		_fas_comm_preinstall();
	}
}

# display preinstallation messages and confirmations
sub _sf_comm_preinstall_messages {
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_preinstall_messages();
	}
}

# ask questions needed for package installation or configuration,
# if there is no dependency on installed components
sub _sf_comm_preinstall_questions {
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_preinstall_questions();
	}
}

# perform any checks or tasks necessary before the product is started
sub _sf_comm_prestop {
	if ((($PMODE eq "SFE") && ($FLAG{VVR})) || (($PMODE eq "SFEHA") && ($FLAG{VVR}))) {
		_vvr_comm_prestop();
	} else {
		_vm_comm_prestop();
	}
	_fs_comm_prestop();
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_prestop();
	}
}

# start the product, return 1 if product does not start
sub _sf_comm_start_product {
	if ((($PMODE eq "SFE") && ($FLAG{VVR})) || (($PMODE eq "SFEHA") && ($FLAG{VVR}))) {
		_vvr_comm_start_product();
	} else {
		_vm_comm_start_product();
	}
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_start_product();
	}
}

# stop various products.
# Currently needed only on AIX.
#
sub _sf_comm_stop_processes {
	# VEA needs to be stopped first on AIX or systems
	# may crash after unloading vxfs
	_comm_stop_processes("vxsvc") if (($OPT{UNINSTALL}) && ($COMM{OS} eq "AIX"));
}

# verify that the %CFG information read by -configfile is valid
# _die if an error is found, specifying the error
sub _sf_comm_verify_responsefile {
	if ((($PMODE eq "SFE") && ($FLAG{VVR})) || (($PMODE eq "SFEHA") && ($FLAG{VVR}))) {
		_vvr_comm_verify_responsefile();
	} else {
		_vm_comm_verify_responsefile();
	}
	if (($PMODE eq "SFHA") || ($PMODE eq "SFEHA")) {
		_vcs_comm_verify_responsefile();
	}
}

# define packages and patches for the installation
# return a reference to a list
sub _sf_comm_define_pkgs {
	my($mode,$pkgs);
	($mode)=(@_);

	# get packages defined by FAS.
	# package names are put in $PROD{FAS}{PKGS}
	if ($COMM{OS} eq "SunOS") {
		_fas_comm_define_pkgs();
	}

	$mode=$PMODE if (!$mode);

	$pkgs=[];
	if ($mode eq "SFQS") {
		$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}});
	} elsif ($mode eq "SFE") {
		if ($FLAG{VVR} || $OPT{UNINSTALL}) {
			$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{FAS}{PKGS}}, @{$PROD{VVR}{PKGS}});
		} else {
			$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{FAS}{PKGS}});
		}
	} elsif ($mode eq "SFEHA") {
		if ($FLAG{VVR} || $OPT{UNINSTALL}) {
			$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{VVR}{PKGS}}, @{$PROD{VCS}{PKGS}}, @{$PROD{FAS}{PKGS}});
		} else {
			$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{VCS}{PKGS}}, @{$PROD{FAS}{PKGS}});
		}
	} elsif ($mode eq "SFHA") {
		$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{VCS}{PKGS}});
	} else {
		# Storage Foundation Standard
		$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}});
	}
        return $pkgs;
}

sub _sf_vvr_inc_pkgs {
	$MSG{VRTSjre}{OPTIONAL}="";
	$MSG{VRTSvcsvr}{OPTIONAL}="";
	$MSG{VRTSvrmcsg}{OPTIONAL}="";
	$MSG{VRTSweb}{OPTIONAL}="";
	$MSG{VRTSap}{OPTIONAL}="";
	$MSG{VRTSvrpro}{OPTIONAL}="";
}

# precheck installation requirements for component products
sub _sf_comm_precheck {
	return if ($COMM{OS} ne "SunOS");
	# check FAS installation requirements
	if (($PMODE eq "SFE") || ($PMODE eq "SFEHA")) {
		_fas_comm_precheck();
	}
}

# Let the component package decide whether it should be added to the
# list of packages to install or not.
sub _sf_comm_pkg_check {
	my ($pc);

	# FAS package should be installed only if proper
	# SYMCLI is found on the target system
	$pc = _fas_symcli_check() if ($PKG=~/VRTSfas/);
	return $pc;
}

1;

# Define frequently used commands
# $CMD{SFCFSCMD}="/sbin/prodcmd";

# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms
# $CMD{START}{process}="$CMD{SFCFSCMD} -start";
# $CMD{STOP}{process}="$CMD{SFCFSCMD} -stop";

# Define product configuration files
# $CONF{CONFIG}="/etc/prodconf/config";

# Define frequently referenced paths
# VxFS binaries are accessed from the /opt/VRTS/bin directory as soft
# symbolic links.
$PATH{SFCFSBIN}="/opt/VRTS/bin";
# $PATH{SFCFSCONF}="/etc/prodconf";

$CMD{CFSCLUSTER}="$PATH{SFCFSBIN}/cfscluster";
$CMD{CFSDGADM}="$PATH{SFCFSBIN}/cfsdgadm";
$CMD{CFSMNTADM}="$PATH{SFCFSBIN}/cfsmntadm";
$CMD{CFSMOUNT}="$PATH{SFCFSBIN}/cfsmount";
$CMD{CFSUMOUNT}="$PATH{SFCFSBIN}/cfsumount";
$CMD{FSCLUSTADM}="$PATH{SFCFSBIN}/fsclustadm";

# Define product modes and names for product modes, if necessary
# SFCFS and SFCFSHA "NAME" are defined in cpi.pl file 
$PROD{SFCFS}{NAME}="Storage Foundation for Cluster File System";
$PROD{SFCFS}{LNAME}="SANPoint Foundation Suite";
$PROD{SFCFS}{ABBR}="SFCFS";
$PROD{SFCFS}{DIR}="storage_foundation_for_cfs";

$PROD{SFCFSHA}{NAME}="Storage Foundation for Cluster File System HA";
$PROD{SFCFSHA}{LNAME}="SANPoint Foundation Suite HA";
$PROD{SFCFSHA}{ABBR}="SFCFSHA"; 
$PROD{SFCFSHA}{DIR}=$PROD{SFCFS}{DIR};

# VRTSap and VRTStep are Optionally Removable Packages
#$PROD{SFCFS}{OPTRMPKGS}=[ qw(VRTStep VRTSap) ];
#$PROD{SFCFSHA}{OPTRMPKGS}=[ qw(VRTStep VRTSap) ];
# replacing with soft dependencies

# Start assuming cfscluster config can be run or we don't need to run it
$FLAG{CFSCLUSTER_CONFIG_PENDING} = 0;

# ask for product mode for pre-install check
# not required if your product is not mode based
sub _sfcfs_comm_ask_mode {
	my @mode=("SFCFS","SFCFSHA");

	_bpl("$PROD{SFCFS}{ABBR} Preinstallation Check:", 160, 1060, "$PROD{SFCFS}{ABBR}");
	$COMM{MENU}=[$PROD{SFCFS}{NAME},$PROD{SFCFSHA}{NAME}];
	my $menu=_menu("For what version of $PROD{SFCFS}{ABBR} would you like perform a pre-installation check?", 160, 1001, "$PROD{SFCFS}{ABBR}");
	return "$mode[$menu-1]";
}

# perform any sfcfs specific checks or tasks necessary before the installation
sub _sfcfs_comm_initial_systemcheck {
	_prod_plat_sub("SFCFS", "initial_systemcheck");
	_vm_comm_initial_systemcheck();
	_fs_comm_initial_systemcheck();
}

# check to see if valid configuration files exist on the local system
# if so, return a reference to an array holding ("systems", "version")
sub _sfcfs_comm_check_localconfig {
	_vcs_comm_check_localconfig();
}

# confirm proper running/non running state before performing 
# configuration via the -configure option.
sub _sfcfs_comm_check_preconfigstate {
	_vcs_comm_check_preconfigstate();
}

# create configuration files from %CMD values
sub _sfcfs_comm_create_configfiles {
	_vcs_comm_create_configfiles();
}

# display task completion information
sub _sfcfs_comm_completion_messages {
	_prod_plat_sub("SFCFS", "completion_messages");
}

# Determine the product mode of a mode based product (level 2).
# Use VCS mode to determine SFCFS mode.
sub _sfcfs_comm_get_mode {
	my ($rlic) = (@_);

	return "SFCFS" if (_vcs_comm_get_mode($rlic) =~ /VCSSFCFS/);
	return "SFCFSHA";
}

# ask questions asked by pkg request scripts
sub _sfcfs_comm_pkgrequest_questions {
	_vm_comm_pkgrequest_questions();
}

# perform any checks or tasks necessary after the product is installed
sub _sfcfs_comm_postinstall {
	_vcs_comm_postinstall();
	_vm_comm_postinstall();
	_prod_plat_sub("SFCFS", "postinstall");
}

# ask configuration questions necessary following installation
sub _sfcfs_comm_postinstall_questions {
	_vm_comm_postinstall_questions();
}

# perform any checks or tasks necessary after the product is started
sub _sfcfs_comm_poststart {
	_vcs_comm_poststart();
	_vm_comm_poststart();
}

# check if installing on a single system
sub _sfcfs_comm_singlesystem_areyousure {

	# We only allow installation on a single system if we're
	# doing an installonly, which is part of how to add a
	# system to an existing cluster.  Part of the reason is
	# for VCS, installation on a single system does not create
	# the llt/gab configuration files.  For this reason we
	# must enforce the number of systems in an SFCFS install
	# to greater than 1, unless doing an "-installonly".

	$MSG{HELP}=_tr("Typically $PROD{$UPI}{ABBR} is installed and configured in clusters that have two or more systems.  The -installonly option can be used to install $PROD{$UPI}{ABBR} on a system which is going to be added to another cluster.", 160, 1054, "$PROD{$UPI}{ABBR}", "$PROD{$UPI}{ABBR}");
	_p();
	_pl("$PROD{$UPI}{ABBR} requires multiple systems for a cluster.\nYou must use '-installonly' option to install $PROD{$UPI}{ABBR} on a single system.\n", 160, 1055, "$PROD{$UPI}{ABBR}", "$PROD{$UPI}{ABBR}");
	return 1;
}

# perform preinstallation tasks 
# use $COMM{TASK} or $OPT to filter, if necessary
sub _sfcfs_comm_preinstall {
	_vm_comm_preinstall();
}

# display preinstallation messages and confirmations
# Any SFCFS or SFCFSHA messages should be put here.
sub _sfcfs_comm_preinstall_messages {
	_sfcfs_ask_isfencingenabled();
	_vcs_comm_preinstall_messages();
}

sub _sfcfs_verify_cvm_timeout {
	my $tov = $_[0];	# timeout value

	if (_isint($tov) || $tov <= 0 || $tov > 2100) {
		_pl("$tov is not a valid timeout value.", 160, 1077, "$tov");
		_pl("Timeout value has to be an integer between 1 and 2100.", 160, 1078);
		return "0";
	}

	return "1";
}

sub _sfcfs_ask_cvm_timeout {
	my $tov;	# timeout value

	while (1) {
		$COMM{DEFANSWER} = 200;		# default in seconds
		$tov = _ask("Enter Cluster Volume Manager cluster reconfiguration timeout (sec):", 160, 1038);
		return "$tov" if (_sfcfs_verify_cvm_timeout($tov));
	}
}

sub _sfcfs_verify_cvm {

	# this is called to verify the values found in the response file
	if (_sfcfs_verify_cvm_timeout($CFG{CVMTIMEOUT}) == 0) {
		_die("Response file has invalid CVMTIMEOUT value ($CFG{CVMTIMEOUT})", 160, 1011, "$CFG{CVMTIMEOUT}");
	}
}

# tasks that are related to cvm
sub _sfcfs_config_cvm {
	my $done = 0;
	my $cvm_timeout_sec;	# timeout (in sec) during CVM reconfig

	_title();

	$cvm_timeout_sec = _sfcfs_ask_cvm_timeout();

	# record the response in the %CFG table so these values get
	# written into the response file.
	$CFG{CVMTIMEOUT} = $cvm_timeout_sec;
}

# ask questions needed for package installation or configuration,
# if there is no dependency on installed components
sub _sfcfs_comm_preinstall_questions {
	_vcs_comm_preinstall_questions();
	_sfcfs_config_cvm();
}

# stop the cluster manager and the corresponding agents
sub _sfcfs_stop_agents {
	my $cfscluster;		# cfscluster command string
	my $do;			# _dol()'s return code
	my $outfile;		# cfscluster's output

	return unless (-e $CMD{CFSCLUSTER});
	if ($COMM{OS} ne "Linux") {
		$outfile = "$PATH{ITMP}/sfcfs_stop_agents." . time();
		$cfscluster = "$CMD{CFSCLUSTER} status";
		_dol("$cfscluster > $outfile 2>&1");
		$do = _dol("$CMD{GREP} -c 'Error: Cluster Manager' $outfile");
		if ($do == 0) {
			$cfscluster = "$CMD{CFSCLUSTER} stop -f all";
			$do = _dol("$cfscluster > /dev/null 2>&1");

			# for now verifying the return code should be sufficient
			# If more stringent verification is needed, saves the
			# cfscluster's output to a file and search for "Cluster
			# manager stopped successfully"

			if ($do != 0) {
				_pl("Halting of cluster manager failed has error $do\n", 160, 1013, "$do");
			}
		}

		# remove the temporary outfile
		_dol("$CMD{RMR} $outfile") if (-e $outfile);
	}

	return unless (-e $CMD{FSCLUSTADM});
	# call the linux stop agents
	_prod_plat_sub("SFCFS", "stop_agents_all");
}

# perform any checks or tasks necessary after the product is started
sub _sfcfs_comm_prestop {
	_sfcfs_stop_agents();
	_fs_comm_prestop();
	_vm_comm_prestop();
	_vcs_comm_prestop();
}

# perform any postinstall tasks necessary after the product is removed. 
sub _sfcfs_comm_postremove {
	_prod_plat_sub("SFCFS", "postremove");
}

# verify that every system has the vxconfigd up in "enabled" state
sub _sfcfs_verify_vxconfigds {
	my $do;		# command's return status

	foreach $SYS (@SYSI) {
		$do = _dor("$CMD{VXDCTL} mode | $CMD{GREP} -c ': enabled'");
		if ($do == 0) {
			_pl("vxconfigd on $SYS is disabled", 160, 1014, "$SYS") if ($FLAG{DEBUG});
			return 0;
		}
	}

	# vxconfigd appears to be enabled on all systems
	return 1;
}

# run the cfscluster command to bring up the cvm/cfs related agents.
sub _sfcfs_start_agents {
	my $cfscluster;		# cfscluster command string
	my $do;			# command's status

	_bpl("\nConfiguring CFS agents for $PROD{$PMODE}{ABBR}:\n", 160, 1015, "$PROD{$PMODE}{ABBR}");

	_pb1("Confirming $PROD{VM}{ABBR} configuration daemons startup", 160, 1016, "$PROD{VM}{ABBR}");

	# make sure each system's vxconfigd is running
	if (_sfcfs_verify_vxconfigds() == 0) {
		_pb2("Disabled", 160, 1017);
		$FLAG{CFSCLUSTER_CONFIG_PENDING} = 1;
		_pl("\nUnable to complete SFCFS configuration at this time.", 160, 1061);
		_pl("<cfscluster config> must be run after system reboot.\n", 160, 1075);
		_pl("Configuration daemon (vxconfigd) is not enabled.", 160, 1018)
			if ($FLAG{DEBUG});
		return 0;
	}

	_pb2("All systems Enabled", 160, 1019);

	# vxconfigd appears to be running on all the systems. 
	# If $CFG{CVMTIMEOUT} is NULL an existing configuration was found
	# and being used, with very little validation by VCS.  Configure and
	# start cvm and cfs agents using data collected in _sfcfs_config_cvm().
	# Though some agents will fail (require a reboot), starting CFS/CVM
	# now is the only way to guarantee complete CFS/CVM service on reboot.
	# The cfscluster command only needs to be run on the local system.

	if ($CFG{CVMTIMEOUT} eq "") {
		# We're reusing an existing configuration.
		_pl("\nFull activation of Cluster Manager, Cluster Volume Manager,", 160, 1039);
		_pl("and Cluster File System requires a reboot on All Systems.\n", 160, 1040);
		_bpl("Execute $CMD{SHUTDOWN} to properly restart your systems", 160, 1076, "$CMD{SHUTDOWN}");
		return 0;
	}

	# Start the agents using a new configuration.
	# We just need to invoke the command on one system to start on all.
        $cfscluster = "$CMD{CFSCLUSTER} config -t $CFG{CVMTIMEOUT} -s";

	_pb1("Starting CFS agents", 160, 1020);

	$SYS=$SYSI[0];
	$do = _dor("$cfscluster", 1);
	if ($do != 0) {
		_pb2("Error", 160, 1021);
		_pl("Unable to start cluster agents: $do\n", 160, 1022, "$do");
		return 1;
	}
	_pb2("Started", 160, 1023);

	# Sleep for a bit for the various gab ports to form with
	# membership before we continue on with other tasks.
	sleep 5;

	if (($COMM{OS} ne "Linux") && ($COMM{OS} ne "AIX")) {
		_pl("\nFull activation of Cluster Manager, Cluster Volume Manager,", 160, 1039);
		_pl("and Cluster File System requires a reboot on All Systems.\n", 160, 1040);
		_bpl("Execute $CMD{SHUTDOWN} to properly restart your systems", 160, 1076, "$CMD{SHUTDOWN}");
	}

	return 0;
}

# start the product, return 1 if product does not start
sub _sfcfs_comm_start_product {
	return 1 if (_vcs_comm_start_product());
	return 1 if (_vm_comm_start_product());
	return 1 if (_prod_plat_sub("SFCFS", "start_vxfen"));
	return 1 if (_sfcfs_start_agents());
    return 0;
}

# stop various products.
# Currently needed only on AIX.
#
sub _sfcfs_comm_stop_processes {
	# VEA needs to be stopped first on AIX or systems
	# may crash after unloading vxfs
	_comm_stop_processes("vxsvc") if (($OPT{UNINSTALL}) && ($COMM{OS} eq "AIX"));
}

# verify that the %CFG information read by -responsefile is valid
# _die if an error is found, specifying the error
sub _sfcfs_comm_verify_responsefile {
	_vcs_comm_verify_responsefile();
	_vm_comm_verify_responsefile();
	_sfcfs_verify_cvm();
}

# Define packages and patches for the installation.
# Return a reference to a list.
# We're either SFCFS or SFCFSHA.
sub _sfcfs_comm_define_pkgs {
	my @pkgs;
	if ($PMODE eq "SFCFS") {
		@pkgs=(@{$PROD{VCSSFCFS}{PKGS}}, @{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{SFCFS}{PKGS}});
	} else {
		@pkgs=(@{$PROD{VCS}{PKGS}}, @{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{SFCFS}{PKGS}});
	} 
	return \@pkgs;
}

sub _sfcfs_ask_isfencingenabled {
	my $dofencing;		# Will they be enabling fencing?

	$MSG{HELP}=_tr("See the Storage Foundation Cluster File System Installation and Administration Guide for more information on I/O Fencing.", 160, 1056);

	_bpl("I/O Fencing\n", 160, 1063);

	if ($OPT{INSTALLONLY}) {
		_pl("I/O Fencing requires manual configuration after SFCFS Installation.", 160, 1064);
		_pl("If not properly configured, I/O Fencing will become disabled.", 160, 1065);
		_pl("It needs to be determined at this time if you plan to configure", 160, 1066);
		_pl("I/O Fencing in order to properly set the expected Fencing mode.", 160, 1067);

	} else {

		_pl("I/O Fencing requires manual configuration after SFCFS Installation.", 160, 1064);
		_pl("If not properly configured, I/O Fencing will become disabled.", 160, 1065);
		_pl("It needs to be determined at this time if you plan to configure", 160, 1066);
		_pl("I/O Fencing in order to properly set the expected Fencing mode,", 160, 1068);
		_pl("as well as help in determining the number of network interconnects", 160, 1069);
		_pl("(NICS) required on your systems.  If you configure I/O Fencing", 160, 1070);
		_pl("after installing SFCFS only a single NIC is required, though", 160, 1071);
		_pl("at least two is recommended.", 160, 1072);

	}

	_pl("See the Storage Foundation Cluster File System Installation", 160, 1073);
	_pl("and Administration Guide for more information on I/O Fencing.", 160, 1074);

	$dofencing = _ayny("\nWill you be configuring I/O Fencing?", 160, 1053);
	$FLAG{FENCINGENABLED} = $dofencing eq "Y" ? 1 : 0;
}
1;
#
#                                                                                    

# Define frequently used commands
$CMD{DBA_CHECKID}="/usr/bin/id";       
$CMD{DBA_CHOWN}="/usr/bin/chown";
$CMD{DBA_CHGRP}="/usr/bin/chgrp";
$CMD{DBA_CHMOD}="/usr/bin/chmod";
$CMD{DBA_MKDIR}="/usr/bin/mkdir";
	
# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms
# $CMD{START}{process}="$CMD{PRODCMD} -start";
# $CMD{STOP}{process}="$CMD{PRODCMD} -stop";

# Define product configuration files
# $CONF{CONFIG}="/etc/prodconf/config";

# Define frequently referenced paths
# $PATH{PRODBIN}="/opt/VRTSprod/bin";
# $PATH{PRODCONF}="/etc/prodconf";
$PATH{SFDB2_VXDBA_DIR}="/opt/VRTSdb2ed";

# Define product information
$PROD{SFDB2}{NAME}="Storage Foundation for DB2";
$PROD{SFDB2}{LNAME}="VERITAS Storage Foundation for DB2";
$PROD{SFDB2}{ABBR}="SFDB2";
$PROD{SFDB2}{DIR}="storage_foundation_for_db2";

$PROD{DB2ED}{NAME}="Database Edition for DB2";
$PROD{DB2ED}{LNAME}="VERITAS Database Edition for DB2";
$PROD{DB2ED}{ABBR}="DB2ED";

$PROD{SFDB2HA}{NAME}="Storage Foundation for DB2 HA";
$PROD{SFDB2HA}{ABBR}="SFDB2HA";
$PROD{SFDB2HA}{DIR}="storage_foundation_for_db2 HA";

$PROD{SFDB2}{MODES} = [ qw(SFDB2 SFDB2HA DB2ED) ];
# VRTSap and VRTStep are Optionally Removable Packages
#$PROD{SFDB2}{OPTRMPKGS}=[ qw(VRTStep VRTSap) ];
# replacing with soft dependencies

# This flag is used by sfdb2_dbg_pl().
####$FLAG{SFDB2_DBG}=1;

sub _sfdb2_dbg_pl{
	my ($msg) = (@_);
	
	if ($FLAG{SFDB2_DBG}) {
		_pl("\nDBG: $msg", 180, 1000, "$msg");
	}

}
	
# change prod in all subroutines to your product abbrevation
# sub return values are specified in comments, none if nothing is mentioned

# ask for product mode for pre-install check
# not required if your product is not mode based
sub _sfdb2_comm_ask_mode {
	my @mode=("SFDB2","DB2ED","SFDB2HA");

	_bpl("$PROD{SFDB2}{ABBR} Preinstallation Check:", 180, 1030, "$PROD{SFDB2}{ABBR}");
	
	$COMM{MENU}=[$PROD{SFDB2}{NAME},$PROD{SFDB2HA}{NAME}];
	my $menu=_menu("For what version of $PROD{SFDB2}{ABBR} would you like perform a pre-installation check?", 180, 1002, "$PROD{SFDB2}{ABBR}");
	
	return "$mode[$menu-1]";
}

# determine the product mode, if necessary
# use info from hash returned by _comm_check_license
# not required if your product is not mode based
sub _sfdb2_comm_get_mode {
#For now, just returen non-HA mode	
	return "SFDB2";

	my($rlic,$disc)=(@_);
	_log("$SYS Key Mode=$$rlic{SFDB2}{Mode}", 180, 1003, "$SYS", "$$rlic{SFDB2}{Mode}");
	return "SFDB2HA" if ($$rlic{SFDB2}{Mode} =~ /SFDB2HA/);
	return "SFDB2";
}

# display task completion information
sub _sfdb2_comm_completion_messages {
	
	_vm_comm_completion_messages();
	
	if ( -f "$PATH{NO_VXFS}") {
		_pl("All machines on which SFDB2 was installed or upgraded must now ", 180, 1004);
		_pl("be rebooted to ensure sane operation. Execute", 180, 1005);
		_pl("\t shutdown -y -i6 -g0 ", 180, 1006);
		_pl("and wait for the Console Login: prompt.", 180, 1007);
		_pl("Refer to the VERITAS Storage Foundation for DB2 Database Administrator Guide for more information.\n", 180, 1029);
	}
}

# ask questions asked by pkg request scripts
sub _sfdb2_comm_pkgrequest_questions {
	_vm_comm_pkgrequest_questions();
}

####
# perform any checks or tasks necessary after the product is installed
sub _sfdb2_comm_postinstall {
	
	my($username,$groupname,$sysname); 
	
	_vm_comm_postinstall();
    	
	if ($OPT{RESPONSEFILE}) {
		# If response file is being used, use the 
		# CFG variables to configure 
       	       	foreach $SYS(@SYSI) {
       	       		# These variables would only be defined if a response
		
       	       		if (defined($CFG{SFDB2_USERNAME}{$SYS})) {
       	       			_sfdb2_verify_username($CFG{SFDB2_USERNAME}{$SYS});
       	       		}
       	       		if (defined($CFG{SFDB2_GROUPNAME}{$SYS})) {
       	       			_sfdb2_change_group($CFG{SFDB2_GROUPNAME}{$SYS});
       	       		}
       	       	}
	}
	else {
		_sfdb2_fix_vxdba_perms();
	}	

}

# ask configuration questions necessary following installation
sub _sfdb2_comm_postinstall_questions {
	
	_vm_comm_postinstall_questions();

}

# perform any checks or tasks necessary after the product is started
sub _sfdb2_comm_poststart {
	_vm_comm_poststart();
}

# perform preinstallation tasks 
# use $COMM{TASK} or $OPT to filter, if necessary
sub _sfdb2_comm_preinstall {
	_vm_comm_preinstall();
    
    	# Initialize for the responsefile
    	# push the variables
    	push(@{$COMM{PRODUCTIRFKEYS}},qw(SFDB2_USERNAME SFDB2_GROUPNAME));

}

# display preinstallation messages and confirmations
sub _sfdb2_comm_preinstall_messages {
	if (_sfdb2_verify_novxvm_upgrade() == 1) {
		_sfdb2_dbg_pl("\nEnvironment variable NO_VXVM_UPGRADE is set. VERITAS Volume Manager will not be upgraded.\n");
	}
}

# perform any checks or tasks necessary before the product is stopped
sub _sfdb2_comm_prestop {
	_prod_plat_sub("SFDB2", "prestop");
    
    	# _vm_comm_prestop should be invoked only if VRTSvxvm is being 
	# removed as well.
	_vm_comm_prestop() if ($FLAG{UNINSTALLING}{VRTSvxvm});
	_fs_comm_prestop();

}

# start the product, return 1 if product does not start
sub _sfdb2_comm_start_product {
	_vm_comm_start_product();
}

# perform any checks or tasks necessary before the installation
sub _sfdb2_comm_initial_systemcheck {

	_fs_comm_initial_systemcheck();
	_sfdb2_dbg_pl("_sfdb2_initial_systemcheck");
	_prod_plat_sub("SFDB2","initial_systemcheck");
}

sub _sfdb2_verify_username {
	my($do,$username,$ret_st,$gid, $uid);
	($username)=(@_);
	# $ret_st=1;
	
	# Verify if the user existed
	$do ="";
	foreach $SYS(@SYSI) {
		# We are checking for dirctory existence here as 
		# it is created by pkgadd and package should fail and exit if
		# directory does not exists
		$do = _dor("$CMD{DBA_CHECKID} $username");

		($uid, $gid) = split(" ",$do);
		if ($uid !~ /^uid=/ and $gid !~ /^gid=/) {	
			_pl("ERROR: Could not identify user $username", 180, 1009, "$username");
			return "";
		}

		$do ="";
		$do = _dor("$CMD{DBA_CHOWN} $username $PATH{SFDB2_VXDBA_DIR}");      

		if (length($do)) {
			_pl("ERROR: Could not change ownership for $PATH{SFDB2_VXDBA_DIR}", 180, 1011, "$PATH{SFDB2_VXDBA_DIR}");
			return "";
		}

		# Set CFG variable to be stored in response file
		$CFG{SFDB2_USERNAME}{$SYS}=$username;

	}
	return "1";
}

#
#
sub _sfdb2_change_group {
	my($do,$groupname,$ret_st);
	
	($groupname)=(@_);
	$ret_st=1;
	
	$do ="";
	foreach $SYS(@SYSI) {
		$do = _dor("$CMD{DBA_CHGRP} $groupname $PATH{SFDB2_VXDBA_DIR}");

		if (length($do)) {
			_pl("ERROR: Could not change group to $groupname", 180, 1012, "$groupname");
			return "";
		}

		$do ="";
		$do = _dor("$CMD{DBA_CHMOD} g+rx $PATH{SFDB2_VXDBA_DIR}");
		if (length($do)) {
			_pl("ERROR: Could not change permission for $PATH{SFDB2_VXDBA_DIR}", 180, 1013, "$PATH{SFDB2_VXDBA_DIR}");
			return "";
		}

		# Set CFG variable to be stored in response file
		$CFG{SFDB2_GROUPNAME}{$SYS}=$groupname;
	}

	return "1";
}

sub _sfdb2_ask_username {
	my $ask;

	$ask=_ask("Enter login account name for DBA user: ", 180, 1014);
	$MSG{HELP}=_tr("Enter the user name of database administrators (DBA).", 180, 1015);
		
	return "$ask" if (_sfdb2_verify_username($ask));
}

sub _sfdb2_ask_groupname {
	my $ask;

	$ask=_ask("Enter group name for DBA users: ", 180, 1016);
	$MSG{HELP}=_tr("Enter the group name of database administrators (DBA).", 180, 1017);
		
	return "$ask" if (_sfdb2_change_group($ask));
}

sub _sfdb2_fix_vxdba_perms {

        _sfdb2_dbg_pl("_sfdb2_fix_vxdba_perms");
	
	return if ($OPT{INSTALLONLY});
	my ($ayn,$userdone,$groupdone);

	_title();
	_bpl("The following information is required to setup the permission for VxDBA Utility:\n", 180, 1018);
	_pl("The VxDBA utility for database administration requires permission\nchanges to allow database administrators (DBAs) access to the tools.\nThe default settings at installation time for the $PATH{SFDB2_VXDBA_DIR}\ndirectory allows only the root user access to the directory.\nWould you like to change permissions to allow a DBA or a group of DBAs\naccess to the VxDBA tools?\n", 180, 1019, "$PATH{SFDB2_VXDBA_DIR}");
	
	while (!$userdone) {
		$MSG{HELP}=_tr("Enable database administrator (DBA) to use VxDBA utility.", 180, 1020);
       	       	$ayn=_ayny("Do you want to add single user access", 180, 1021);
       	       	if ($ayn eq "Y") {
       	       		$userdone=_sfdb2_ask_username();
       	       	}
		$userdone=1 if ($ayn eq "N");
	}

	while (!$groupdone) {
		$MSG{HELP}=_tr("Enable group of database administrators (DBA) to use VxDBA utility.", 180, 1022);
       	       	$ayn=_ayny("\nDo you want to add group access", 180, 1023);
       	       	if ($ayn eq "Y") {
       	       		$groupdone=_sfdb2_ask_groupname();
       	       	}
		$groupdone=1 if ($ayn eq "N");
	}

}

# verify that the %CFG information read by -configfile is valid
# _die if an error is found, specifying the error
sub _sfdb2_comm_verify_responsefile {
	
	_vm_comm_verify_responsefile();
	
	_sfdb2_verify_edition_cfg();

}


#
# Verify if EMC-DBED components
sub _sfdb2_verify_novxvm_upgrade {
	my ($no_vxvm_upgrade);

	_sfdb2_dbg_pl("_sfdb2_verify_novxvm_upgrade called");

	$no_vxvm_upgrade = $ENV{"NO_VXVM_UPGRADE"};
		
	if ($no_vxvm_upgrade ne "") {
		_sfdb2_dbg_pl("Environment variable NO_VXVM_UPGRADE: $no_vxvm_upgrade");
		
		if (($no_vxvm_upgrade eq "yes") || ($no_vxvm_upgrade eq "YES")) {
			_sfdb2_dbg_pl("Environment variable NO_VXVM_UPGRADE is set to yes.");
			return 1;
		}
		return 0;
	}
	else {
		_sfdb2_dbg_pl("Environment variable NO_VXVM_UPGRADE is null");
		return 0;
	}	

}


# define packages and patches for the installation
# return a reference to a list

sub _sfdb2_comm_define_pkgs {

	my($mode,$pkgs,$ii);
        ($mode)=(@_);
        $mode=$PMODE if (!$mode);

	if ($OPT{UNINSTALL}) {
		_prod_plat_sub("SFDB2","verify_dbed"); 
	}
	if ($mode eq "SFDB2HA") {
		if (_sfdb2_verify_novxvm_upgrade() == 1) {
			$pkgs=_uniq(@{$PROD{FS}{PKGS}}, @{$PROD{VCS}{PKGS}}, @{$PROD{SFDB2}{PKGS}});
		} else {
			$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{VCS}{PKGS}}, @{$PROD{SFDB2}{PKGS}});
			
		}			
	} else {
		if (_sfdb2_verify_novxvm_upgrade() == 1) {
			$pkgs=_uniq(@{$PROD{FS}{PKGS}}, @{$PROD{SFDB2}{PKGS}});
		} else {
			$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{SFDB2}{PKGS}});
		}			
	}



	if ($FLAG{DBED_PKG_INST}) {
		for ($ii =0; $ii < @{$PROD{SFDB2}{PKGS}}; $ii++) {
			last if (${$PROD{SFDB2}{PKGS}}[$ii] eq "VRTSvxmsa");
		}
		splice(@{$PROD{SFDB2}{PKGS}}, $ii, 1);
		$pkgs=_uniq(@{$PROD{SFDB2}{PKGS}});
	}
	
        return $pkgs;
}

# returns a commented definition of a install reqponsefile key for each key
# there are two calls.  _comm_define_cfgkey starts the definition
# creating the variable and defining its required/optional status,
# scalar/list status, and second dimension, if it is a 2d variable
# The second call to _tr defines what the variable is used for within
# the CPI libraries
sub _sfdb2_comm_define_cfgkeys {
	my($cmt,$key);
	
	($key)=(@_);
	
	if ($key eq "SFDB2_USERNAME") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("that defines the user name of Database Administrator (DBA).", 180, 1024);
	} elsif ($key eq "SFDB2_GROUPNAME") {
		$cmt=_comm_define_cfgkey($key,0,0, uc($MSG{SYSTEM}));
		$cmt.=_tr("that defines the group name of Database Administrator (DBA).", 180, 1025);
	} 
	
	$cmt.="\n\n";
	$cmt=~s/\n/\n# /g;
	
	return "$cmt";
}

#
#       Verifies that the %CFG information read by -responsefile is valid
#       The only relevant %CFG variables are as follows:
# $CFG{SFDB2_USERNAME}{$SYS}
# $CFG{SFDB2_GROUPNAME}{$SYS}

sub _sfdb2_verify_edition_cfg {
	my ($sys, $do, $do_die, $username, $groupname, $ret_st);

	$do_die=0;
	$ret_st=1;

	_bpl("Verifying the $PROD{SFDB2}{ABBR} configuration parameters...\n", 180, 1026, "$PROD{SFDB2}{ABBR}");

	foreach $sys(@{$CFG{INSTALL}{SYSTEMS}}) {

		if ($CFG{SFDB2_USERNAME}{$sys}) {
			# variable is defined. validate it
       	       	       	# Verify if the user existed
			$username = $CFG{SFDB2_USERNAME}{$sys};
       	       	       	$do = _dor("$CMD{DBA_CHECKID} $username",$ret_st);
       	       	       	if ($do != 0) {
       	       	       		_pl("ERROR: Couldn't identify the USER: '$username' of the configuration file in system $sys\n", 180, 1027, "$username", "$sys");
				$do_die=1;
       	       	       	}
		}
		
		# groupname of DBA
		if ($CFG{SFDB2_GROUPNAME}{$sys}) {
			# variable is defined. validate it
       	       	       	# Verify if the group existed
			$groupname = $CFG{SFDB2_GROUPNAME}{$sys};
			$do = _dor("cat /etc/group | egrep \"^($groupname):\"", $ret_st);
       	       	       	if ($do != 0) {
       	       	       		_pl("ERROR: Couldn't identify the GROUP: `$groupname` of the configuration file in system $sys\n", 180, 1028, "$groupname", "$sys");
				$do_die=1;
       	       	       	}
		}
		
	} # end of for sys
	_die() if $do_die;
}

1;
#
#

# Define frequently used commands
$CMD{DBA_CHECKID}="/usr/bin/id";       
$CMD{DBA_CHOWN}="/usr/bin/chown";
$CMD{DBA_CHGRP}="/usr/bin/chgrp";
$CMD{DBA_CHMOD}="/usr/bin/chmod";
$CMD{DBA_MKDIR}="/usr/bin/mkdir";
	
# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms
# $CMD{START}{process}="$CMD{PRODCMD} -start";
# $CMD{STOP}{process}="$CMD{PRODCMD} -stop";

# Define product configuration files
# $CONF{CONFIG}="/etc/prodconf/config";

# Define frequently referenced paths
# $PATH{PRODBIN}="/opt/VRTSprod/bin";
# $PATH{PRODCONF}="/etc/prodconf";
$PATH{SFORA_VXDBA_DIR}="/opt/VRTSdbed";

# Define product information
$PROD{SFORA}{NAME}="Storage Foundation for Oracle";
$PROD{SFORA}{LNAME}="VERITAS Storage Foundation for Oracle";
$PROD{SFORA}{ABBR}="SFORA";

$PROD{DBED}{NAME}="Database Edition for Oracle";
$PROD{DBED}{LNAME}="VERITAS Database Edition for Oracle";
$PROD{DBED}{ABBR}="DBED";

$PROD{SFORAHA}{NAME}="Storage Foundation for Oracle HA";
$PROD{SFORAHA}{ABBR}="SFORAHA";
$PROD{SFORAHA}{DIR}="storage_foundation_for_oracle HA";

$PROD{SFORA}{MODES} = [ qw(SFORA SFORAHA DBED) ];
# VRTSap and VRTStep are Optionally Removable Packages
#$PROD{SFORA}{OPTRMPKGS}=[ qw(VRTStep VRTSap) ];
# replacing with soft dependencies

# This flag is used by sfora_dbg_pl().
###$FLAG{SFORA_DBG}=1;

sub _sfora_dbg_pl{
	my ($msg) = (@_);
	
	if ($FLAG{SFORA_DBG}) {
		_pl("\nDBG: $msg", 170, 1000, "$msg");
	}

}
	
# change prod in all subroutines to your product abbrevation
# sub return values are specified in comments, none if nothing is mentioned

# ask for product mode for pre-install check
# not required if your product is not mode based
sub _sfora_comm_ask_mode {
	my @mode=("SFORA","DBED","SFORAHA");

	_bpl("$PROD{SFORA}{ABBR} Preinstallation Check:", 170, 1030, "$PROD{SFORA}{ABBR}");
	
	$COMM{MENU}=[$PROD{SFORA}{NAME},$PROD{SFORAHA}{NAME}];
	my $menu=_menu("For what version of $PROD{SFORA}{ABBR} would you like perform a pre-installation check?", 170, 1002, "$PROD{SFORA}{ABBR}");
	
	return "$mode[$menu-1]";
}

# determine the product mode, if necessary
# use info from hash returned by _comm_check_license
# not required if your product is not mode based
sub _sfora_comm_get_mode {
#For now, just returen non-HA mode	
	return "SFORA";

	my($rlic,$disc)=(@_);
	_log("$SYS Key Mode=$$rlic{SFORA}{Mode}", 170, 1003, "$SYS", "$$rlic{SFORA}{Mode}");
	return "SFORAHA" if ($$rlic{SFORA}{Mode} =~ /SFORAHA/);
	return "SFORA";
}

# display task completion information
sub _sfora_comm_completion_messages {
	
	_vm_comm_completion_messages();
	
	if ( -f "$PATH{NO_VXFS}") {
		_pl("All machines on which SFORA was installed or upgraded must now ", 170, 1004);
		_pl("be rebooted to ensure sane operation. Execute", 170, 1005);
		_pl("\t shutdown -y -i6 -g0 ", 170, 1006);
		_pl("and wait for the Console Login: prompt.", 170, 1007);
		_pl("Refer to the Administrator Guide for more information.\n", 170, 1029);
	}
}

# ask questions asked by pkg request scripts
sub _sfora_comm_pkgrequest_questions {
	_vm_comm_pkgrequest_questions();
}

# perform any checks or tasks necessary after the product is installed
sub _sfora_comm_postinstall {
	
	my($username,$groupname,$sysname); 
	
	_vm_comm_postinstall();
    	
	if ($OPT{RESPONSEFILE}) {
		# If response file is being used, use the 
		# CFG variables to configure 
       	       	foreach $SYS(@SYSI) {
       	       		# These variables would only be defined if a response
		
       	       		if (defined($CFG{SFORA_USERNAME}{$SYS})) {
       	       			_sfora_verify_username($CFG{SFORA_USERNAME}{$SYS});
       	       		}
       	       		if (defined($CFG{SFORA_GROUPNAME}{$SYS})) {
       	       			_sfora_change_group($CFG{SFORA_GROUPNAME}{$SYS});
       	       		}
       	       	}
	}
	else {
		_sfora_fix_vxdba_perms();
	}	

}

# ask configuration questions necessary following installation
sub _sfora_comm_postinstall_questions {
	
	_vm_comm_postinstall_questions();

}

# perform any checks or tasks necessary after the product is started
sub _sfora_comm_poststart {
	_vm_comm_poststart();
}

# perform preinstallation tasks 
# use $COMM{TASK} or $OPT to filter, if necessary
sub _sfora_comm_preinstall {
	_vm_comm_preinstall();
    
    	# Initialize for the responsefile
    	# push the variables
    	push(@{$COMM{PRODUCTIRFKEYS}},qw(SFORA_USERNAME SFORA_GROUPNAME));

}

# display preinstallation messages and confirmations
sub _sfora_comm_preinstall_messages {
	if (_sfora_verify_novxvm_upgrade() == 1) {
		_sfora_dbg_pl("\nEnvironment variable NO_VXVM_UPGRADE is set. VERITAS Volume Manager will not be upgraded.\n");
	}
}

# perform any checks or tasks necessary before the product is stopped
sub _sfora_comm_prestop {
	_prod_plat_sub("SFORA", "prestop");
    
    	# _vm_comm_prestop should be invoked only if VRTSvxvm is being 
	# removed as well.
	_vm_comm_prestop() if ($FLAG{UNINSTALLING}{VRTSvxvm});
	
	_fs_comm_prestop();

}

# start the product, return 1 if product does not start
sub _sfora_comm_start_product {
	_vm_comm_start_product();
}

# perform any checks or tasks necessary before the installation
sub _sfora_comm_initial_systemcheck {

	_fs_comm_initial_systemcheck();
	_sfora_dbg_pl("_sfora_initial_systemcheck");
	_prod_plat_sub("SFORA","initial_systemcheck");
}
	
sub _sfora_verify_username {
	my($do,$username,$ret_st,$gid, $uid);
	($username)=(@_);
	$ret_st=1;
	
	# Verify if the user existed
	$do="";
	foreach $SYS(@SYSI) {	
		$do = _dor("$CMD{DBA_CHECKID} $username");
		# We are checking for dirctory existence here as
		# it is created by pkgadd and package should fail and exit if
		# directory does not exists

		($uid , $gid) = split(" ",$do);

		if ($uid !~ /^uid=/ and $gid !~ /^gid=/) {
			_pl("ERROR: Could not identify user $username", 170, 1009, "$username");
			return "";
		}

		$do="";
		$do = _dor("$CMD{DBA_CHOWN} $username $PATH{SFORA_VXDBA_DIR}");      

		if (length($do)) {
			_pl("ERROR: Could not change ownership for $PATH{SFORA_VXDBA_DIR}", 170, 1011, "$PATH{SFORA_VXDBA_DIR}");
			return "";
		}

		# Set CFG variable to be stored in response file
		$CFG{SFORA_USERNAME}{$SYS}=$username;
	}

	return "1";
}

sub _sfora_change_group {
	my($do,$groupname,$ret_st);
	
	($groupname)=(@_);
	$ret_st=1;
	
	$do="";
	foreach $SYS(@SYSI) {
		$do = _dor("$CMD{DBA_CHGRP} $groupname $PATH{SFORA_VXDBA_DIR}");

		if (length($do)) {
			_pl("ERROR: Could not change group to $groupname", 170, 1012, "$groupname");
			return "";
		}

		$do="";
		$do = _dor("$CMD{DBA_CHMOD} g+rx $PATH{SFORA_VXDBA_DIR}");
		if (length($do)) {
			_pl("ERROR: Could not change permission for $PATH{SFORA_VXDBA_DIR}", 170, 1013, "$PATH{SFORA_VXDBA_DIR}");
			return "";
		}

		# Set CFG variable to be stored in response file
		$CFG{SFORA_GROUPNAME}{$SYS}=$groupname;
	}
	return "1";
}

sub _sfora_ask_username {
	my $ask;

	$ask=_ask("Enter login account name for DBA user: ", 170, 1014);
	$MSG{HELP}=_tr("Enter the user name of database administrators (DBA).", 170, 1015);
		
	return "$ask" if (_sfora_verify_username($ask));

}

sub _sfora_ask_groupname {
	my $ask;

	$ask=_ask("Enter group name for DBA users: ", 170, 1016);
	$MSG{HELP}=_tr("Enter the group name of database administrators (DBA).", 170, 1017);
		
	return "$ask" if (_sfora_change_group($ask));
}

sub _sfora_fix_vxdba_perms {

        _sfora_dbg_pl("_sfora_fix_vxdba_perms");
	
	return if ($OPT{INSTALLONLY});
	my ($ayn,$userdone,$groupdone);

	_title();
	_bpl("The following information is required to setup the permission for VxDBA Utility:\n", 170, 1018);
	_pl("The VxDBA utility for database administration requires permission\nchanges to allow database administrators (DBAs) access to the tools.\nThe default settings at installation time for the $PATH{SFORA_VXDBA_DIR}\ndirectory allows only the root user access to the directory.\nWould you like to change permissions to allow a DBA or a group of DBAs\naccess to the VxDBA tools?\n", 170, 1019, "$PATH{SFORA_VXDBA_DIR}");
	
	while (!$userdone) {
		$MSG{HELP}=_tr("Enable database administrator (DBA) to use VxDBA utility.", 170, 1020);
       	       	$ayn=_ayny("Do you want to add single user access", 170, 1021);
       	       	if ($ayn eq "Y") {
       	       		$userdone=_sfora_ask_username();
       	       	}
		$userdone=1 if ($ayn eq "N");
	}

	while (!$groupdone) {
		$MSG{HELP}=_tr("Enable group of database administrators (DBA) to use VxDBA utility.", 170, 1022);
       	       	$ayn=_ayny("\nDo you want to add group access", 170, 1023);
       	       	if ($ayn eq "Y") {
       	       		$groupdone=_sfora_ask_groupname();
       	       	}
		$groupdone=1 if ($ayn eq "N");
	}

}

# verify that the %CFG information read by -configfile is valid
# _die if an error is found, specifying the error
sub _sfora_comm_verify_responsefile {
	
	_vm_comm_verify_responsefile();
	
	_sfora_verify_edition_cfg();

}


#
# Verify if EMC-DBED components
sub _sfora_verify_novxvm_upgrade {
	my($no_vxvm_upgrade);

	_sfora_dbg_pl("_sfora_verify_novxvm_upgrade called");

	$no_vxvm_upgrade = $ENV{"NO_VXVM_UPGRADE"};
		
	if ($no_vxvm_upgrade ne "") {
		_sfora_dbg_pl("Environment variable NO_VXVM_UPGRADE: $no_vxvm_upgrade");
		
		if (($no_vxvm_upgrade eq "yes") || ($no_vxvm_upgrade eq "YES")) {
			_sfora_dbg_pl("Environment variable NO_VXVM_UPGRADE is set to yes.");
			return 1;
		}
		return 0;
	}
	else {
		_sfora_dbg_pl("Environment variable NO_VXVM_UPGRADE is null");
		return 0;
	}	

}


# define packages and patches for the installation
# return a reference to a list

sub _sfora_comm_define_pkgs {
	my($mode,$pkgs, $ii);
        ($mode)=(@_);
        $mode=$PMODE if (!$mode);

	if ($OPT{UNINSTALL}) {
		_prod_plat_sub("SFORA","verify_db2ed");
	}	

	if ($mode eq "SFORAHA") {
		if (_sfora_verify_novxvm_upgrade() == 1) {
			$pkgs=_uniq(@{$PROD{FS}{PKGS}}, @{$PROD{VCS}{PKGS}}, @{$PROD{SFORA}{PKGS}});
		} else {
			$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{VCS}{PKGS}}, @{$PROD{SFORA}{PKGS}});
			
		}			
	} else {
		if (_sfora_verify_novxvm_upgrade() == 1) {
			$pkgs=_uniq(@{$PROD{FS}{PKGS}}, @{$PROD{SFORA}{PKGS}});
		} else {
			$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{SFORA}{PKGS}});
		}			
	}



	if ($FLAG{DB2ED_PKG_INST}) {
		for ($ii =0; $ii < @{$PROD{SFORA}{PKGS}}; $ii++) {
			last if (${$PROD{SFORA}{PKGS}}[$ii] eq "VRTSvxmsa");
		}
		splice(@{$PROD{SFORA}{PKGS}}, $ii, 1);
		$pkgs=_uniq(@{$PROD{SFORA}{PKGS}});
	}
        return $pkgs;
}

# returns a commented definition of a install reqponsefile key for each key
# there are two calls.  _comm_define_cfgkey starts the definition
# creating the variable and defining its required/optional status,
# scalar/list status, and second dimension, if it is a 2d variable
# The second call to _tr defines what the variable is used for within
# the CPI libraries
sub _sfora_comm_define_cfgkeys {
	my($cmt,$key);
	
	($key)=(@_);
	
	if ($key eq "SFORA_USERNAME") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("that defines the user name of Database Administrator (DBA).", 170, 1024);
	} elsif ($key eq "SFORA_GROUPNAME") {
		$cmt=_comm_define_cfgkey($key,0,0, uc($MSG{SYSTEM}));
		$cmt.=_tr("that defines the group name of Database Administrator (DBA).", 170, 1025);
	} 
	
	$cmt.="\n\n";
	$cmt=~s/\n/\n# /g;
	
	return "$cmt";
}

#
#       Verifies that the %CFG information read by -responsefile is valid
#       The only relevant %CFG variables are as follows:
# $CFG{SFORA_USERNAME}{$SYS}
# $CFG{SFORA_GROUPNAME}{$SYS}

sub _sfora_verify_edition_cfg {
	my ($sys, $do, $do_die, $username, $groupname, $ret_st);

	$do_die=0;
	$ret_st=1;

	_bpl("Verifying the $PROD{SFORA}{ABBR} configuration parameters...\n", 170, 1026, "$PROD{SFORA}{ABBR}");

	foreach $sys(@{$CFG{INSTALL}{SYSTEMS}}) {

		if ($CFG{SFORA_USERNAME}{$sys}) {
			# variable is defined. validate it
       	       	       	# Verify if the user existed
			$username = $CFG{SFORA_USERNAME}{$sys};
       	       	       	$do = _dor("$CMD{DBA_CHECKID} $username",$ret_st);
       	       	       	if ($do != 0) {
       	       	       		_pl("ERROR: Couldn't identify the USER: '$username' of the configuration file in system $sys\n", 170, 1027, "$username", "$sys");
				$do_die=1;
       	       	       	}
		}
		
		# groupname of DBA
		if ($CFG{SFORA_GROUPNAME}{$sys}) {
			# variable is defined. validate it
       	       	       	# Verify if the group existed
			$groupname = $CFG{SFORA_GROUPNAME}{$sys};
			$do = _dor("cat /etc/group | egrep \"^($groupname):\"", $ret_st);
       	       	       	if ($do != 0) {
       	       	       		_pl("ERROR: Couldn't identify the GROUP: '$groupname' of the configuration file in system $sys\n", 170, 1028, "$groupname", "$sys");
				$do_die=1;
       	       	       	}
		}
		
	} # end of for sys
	_die() if $do_die;
}

1;
# Define frequently used commands
#
# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms
#
# Define frequently referenced paths
#
# Define product information
$PROD{SFRAC}{NAME}="Storage Foundation for Oracle RAC";
$PROD{SFRAC}{LNAME}="Advanced Cluster for Oracle9i/RAC";
#$PROD{SFRAC}{LNAME}="Database Edition Advanced Cluster for Oracle";
$PROD{SFRAC}{ABBR}="SFRAC";
$PROD{SFRAC}{ALLOPTIONALPKGS}=1;
#$PROD{SFRAC}{OPTRMPKGS}=[ qw(VRTStep VRTSap) ];
# replacing with soft dependencies
$PROD{SFRAC}{SUBPRODS} = [ qw( VM FS VCS SFCFS )];
$CMD{HASTATUS}         = "/opt/VRTSvcs/bin/hastatus";

# perform any sfrac specific checks or tasks necessary before the installation
sub _sfrac_comm_initial_systemcheck {
	_vm_comm_initial_systemcheck();
	_fs_comm_initial_systemcheck();
}

# check to see if valid configuration files exist on the local system
# if so, return a reference to an array holding ("systems", "version")
sub _sfrac_comm_check_localconfig {
	_sfcfs_comm_check_localconfig();
}

# confirm proper running/non running state before performing 
# configuration via the -configure option.
sub _sfrac_comm_check_preconfigstate {
	_prod_plat_sub("SFRAC", "check_oracle_state");
	_sfcfs_comm_check_preconfigstate();
}

# display task completion information
sub _sfrac_comm_completion_messages {
	_vcs_comm_completion_messages();
	_vm_comm_completion_messages();
	$SYS=$SYSI[0];
	if (($OPT{INSTALL}) && (_fc("/etc/vxfenmode")==0)) {
		_bpl("The VCS cvm service group will remain in the FAULTED state until the vxfen coordinator disks are configured.  Refer to SFRAC Installation and Configuration Guide for instructions on how to configure the coordinator disks.\n", 220, 1004);
	}
}

# create configuration files from %CMD values
sub _sfrac_comm_create_configfiles {
	_sfcfs_comm_create_configfiles();
}

# Define the list of packages that are part of SFRAC
sub _sfrac_comm_define_pkgs {
	my @pkgs;
	@pkgs = ();

	#  Iterate through the list of every package.  Certain ones within
	#  the list must be skipped.  For example, we must not include the
	#  the CFS documentation package, but we use all the rest of CFS.
	#
	foreach (@{$PROD{VM}{PKGS}},
	         @{$PROD{FS}{PKGS}},
	         @{$PROD{VCS}{PKGS}},
	         @{$PROD{SFCFS}{PKGS}},
	         @{$PROD{ODM}{PKGS}},
	         @{$PROD{SFRAC}{PKGS}} ) {
		/^$/            && do { next; };
		/^VRTScfsdc$/   && do { next; };
		push( @pkgs, $_ );
	}
	return \@pkgs;
}

# ask questions asked by pkg request scripts
sub _sfrac_comm_pkgrequest_questions {
	_sfcfs_comm_pkgrequest_questions();
}

# perform any checks or tasks necessary after the product is installed
sub _sfrac_comm_postinstall {
	_vcs_comm_postinstall();
	_vm_comm_postinstall();
}

# ask configuration questions necessary following installation
sub _sfrac_comm_postinstall_questions {
	_sfcfs_comm_postinstall_questions();
}

# perform any checks or tasks necessary after the product is started
sub _sfrac_comm_poststart {
	_sfcfs_comm_poststart();
}

sub _sfrac_comm_precheck {
	my $res;
	my $cmd = <<EndCmd;
		if $CMD{HASTATUS} -summary > /dev/null 2>&1
		then echo OPERATIONAL ; exit 1
		else exit 0 ; fi
EndCmd

	if (_localsys()) {
		$res = _dol( $cmd );
	} else {
		$res = _dol( "$CMD{RSH} ${SYS} '$cmd'" );
	}

	if ($res) {
		_pl("All VCS groups must be off-lined and VCS/SFRAC must be shutdown before you may either upgrade or uninstall SFRAC", 220, 1003);
		_comm_cleanup(1) if (!$OPT{PRECHECK});
	} 
	_prod_plat_sub("SFRAC", "precheck");
}

# perform preinstallation tasks
# use $COMM{TASK} or $OPT to filter, if necessary
sub _sfrac_comm_preinstall {
	_sfrac_comm_stop_processes() if ($OPT{CONFIGURE});
	_sfcfs_comm_preinstall();
}

# display preinstallation messages and confirmations
sub _sfrac_comm_preinstall_messages {
	_vcs_comm_preinstall_messages();
}

# ask questions needed for package installation or configuration,
# if there is no dependency on installed components
sub _sfrac_comm_preinstall_questions {
	_sfcfs_comm_preinstall_questions();
}

# perform any checks or tasks necessary before the product is stopped
sub _sfrac_comm_prestop {
	_sfcfs_comm_prestop() if ($COMM{OS} eq "Linux");
}

# start the product, return 1 if product does not start
sub _sfrac_comm_start_product {
	return _sfcfs_comm_start_product();
}

# stop various products.  This only gets called when stopping the products
# is already necessary.
#
sub _sfrac_comm_stop_processes {
	my @drvrs = ();
	# VEA needs to be stopped first on AIX or systems
	# may crash after unloading vxfs, should be prod_plat_sub
	if (($OPT{UNINSTALL}) && ($COMM{OS} eq "AIX")) {
		_comm_stop_processes("vxsvc","vxfsckd"); 
		_dor("$CMD{FSCLUSTADM} cfsdeinit");
	}
	foreach my $pkg( VRTSodm, VRTSgms, VRTSvxfs ) {
		push( @drvrs, @{$PKGI{$pkg}{DRIVERS}} );
	}
	_comm_unload_drivers( @drvrs );

	##  Despite the caveat above in "prestop", do everything we can
	##  to shut down any residual GAB/LLT clients.  Ignore all output.
	##
	my $cmd = <<EndOfCommand;
		exec > /dev/null 2>&1
		$CMD{STOP}{sfrac_had}
		$CMD{STOP}{sfrac_odm}
		$CMD{STOP}{vcsmm}
		$CMD{STOP}{lmx}
		$CMD{STOP}{vxfen}
		$CMD{STOP}{gab}
		$CMD{STOP}{llt}
		exit 0
EndOfCommand

	if (_localsys()) {
		_dol( $cmd );
	} else {
		_dol( "$CMD{RSH} $SYS '$cmd'" );
	}
}

# verify that the %CFG information read by -configfile is valid
# _die if an error is found, specifying the error
sub _sfrac_comm_verify_responsefile {
	_vm_comm_verify_responsefile();
	_vcs_comm_verify_responsefile();
}

1;
#
#

# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms
# $CMD{START}{process}="$CMD{PRODCMD} -start";
# $CMD{STOP}{process}="$CMD{PRODCMD} -stop";

# Define product configuration files
# $CONF{CONFIG}="/etc/prodconf/config";

# Define frequently referenced paths
# $PATH{PRODBIN}="/opt/VRTSprod/bin";
# $PATH{PRODCONF}="/etc/prodconf";
$PATH{SFSYB_VXDBA_DIR}="/opt/VRTSsybed";

# Define product information
$PROD{SFSYB}{NAME}="Storage Foundation for Sybase";
$PROD{SFSYB}{ABBR}="SFSYB";
# VRTSap and VRTStep are Optionally Removable Packages
#$PROD{SFSYB}{OPTRMPKGS}=[ qw(VRTStep VRTSap) ];
# replacing with soft dependencies

# This flag is used by sfsyb_dbg_pl().
###$FLAG{SFSYB_DBG}=1;

sub _sfsyb_dbg_pl{
	my ($msg) = (@_);
	
	if ($FLAG{SFSYB_DBG}) {
		_pl("\nDBG: $msg", 190, 1000, "$msg");
	}

}
	
# change prod in all subroutines to your product abbrevation
# sub return values are specified in comments, none if nothing is mentioned

# ask for product mode for pre-install check
# not required if your product is not mode based
sub _sfsyb_comm_ask_mode {
	my @mode=("SFSYB");

	_bpl("$PROD{SFSYB}{ABBR} Preinstallation Check:", 190, 1010, "$PROD{SFSYB}{ABBR}");
	
	$COMM{MENU}=[$PROD{SFSYB}{NAME}];
	my $menu=_menu("For what version of $PROD{SFSYB}{ABBR} would you like perform a pre-installation check?", 190, 1002, "$PROD{SFSYB}{ABBR}");
	
	return "$mode[$menu-1]";
}

# determine the product mode, if necessary
# use info from hash returned by _comm_check_license
# not required if your product is not mode based
sub _sfsyb_comm_get_mode {
#For now, just returen non-HA mode	
	return "SFSYB";

	my($rlic,$disc)=(@_);
	_log("$SYS Key Mode=$$rlic{SFSYB}{Mode}", 190, 1003, "$SYS", "$$rlic{SFSYB}{Mode}");
	return "SFSYB";
}

# display task completion information
sub _sfsyb_comm_completion_messages {
	
	_vm_comm_completion_messages();
	
	if ( -f "$PATH{NO_VXFS}") {
		_pl("All machines on which SFSYB was installed or upgraded must now ", 190, 1004);
		_pl("be rebooted to ensure sane operation. Execute", 190, 1005);
		_pl("\t shutdown -y -i6 -g0 ", 190, 1006);
		_pl("and wait for the Console Login: prompt.", 190, 1007);
		_pl("Refer to the Administrator Guide for more information.\n", 190, 1009);
	}
}

# ask questions asked by pkg request scripts
sub _sfsyb_comm_pkgrequest_questions {
	_vm_comm_pkgrequest_questions();
}

# perform any checks or tasks necessary after the product is installed
sub _sfsyb_comm_postinstall {
	
	my($username,$groupname,$sysname); 
	
	_vm_comm_postinstall();
	
}

# ask configuration questions necessary following installation
sub _sfsyb_comm_postinstall_questions {
	
	_vm_comm_postinstall_questions();

}

# perform any checks or tasks necessary after the product is started
sub _sfsyb_comm_poststart {
	_vm_comm_poststart();
}

# perform preinstallation tasks 
# use $COMM{TASK} or $OPT to filter, if necessary
sub _sfsyb_comm_preinstall {
	_vm_comm_preinstall();
    
}

# display preinstallation messages and confirmations
sub _sfsyb_comm_preinstall_messages {
	if (_sfsyb_verify_novxvm_upgrade() == 1) {
		_sfsyb_dbg_pl("\nEnvironment variable NO_VXVM_UPGRADE is set. VERITAS Volume Manager will not be upgraded.\n");
	}
}

# perform any checks or tasks necessary before the product is stopped
sub _sfsyb_comm_prestop {
	_prod_plat_sub("SFSYB", "prestop");
    
    	# _vm_comm_prestop should be invoked only if VRTSvxvm is being 
	# removed as well.
	_vm_comm_prestop() if ($FLAG{UNINSTALLING}{VRTSvxvm});
	
	_fs_comm_prestop();

}

# start the product, return 1 if product does not start
sub _sfsyb_comm_start_product {
	_vm_comm_start_product();
}

# perform any checks or tasks necessary before the installation
sub _sfsyb_comm_initial_systemcheck {

	_fs_comm_initial_systemcheck();
	_sfsyb_dbg_pl("_sfsyb_initial_systemcheck");
	_prod_plat_sub("SFSYB","initial_systemcheck");
}
	

# verify that the %CFG information read by -configfile is valid
# _die if an error is found, specifying the error
sub _sfsyb_comm_verify_responsefile {
	
	_vm_comm_verify_responsefile();
	
}

#
# Verify if no vxvm upgrade
sub _sfsyb_verify_novxvm_upgrade {
	my($no_vxvm_upgrade);

	_sfsyb_dbg_pl("_sfsyb_verify_novxvm_upgrade called");

	$no_vxvm_upgrade = $ENV{"NO_VXVM_UPGRADE"};
		
	if ($no_vxvm_upgrade ne "") {
		_sfsyb_dbg_pl("Environment variable NO_VXVM_UPGRADE: $no_vxvm_upgrade");
		
		if (($no_vxvm_upgrade eq "yes") || ($no_vxvm_upgrade eq "YES")) {
			_sfsyb_dbg_pl("Environment variable NO_VXVM_UPGRADE is set to yes.");
			return 1;
		}
		return 0;
	}
	else {
		_sfsyb_dbg_pl("Environment variable NO_VXVM_UPGRADE is null");
		return 0;
	}	

}


# define packages and patches for the installation
# return a reference to a list

sub _sfsyb_comm_define_pkgs {
	my($mode,$pkgs, $ii);
        ($mode)=(@_);
        $mode=$PMODE if (!$mode);

	if ($OPT{UNINSTALL}) {
		_prod_plat_sub("SFSYB","verify_db2ed");
	}	

	if ($mode eq "SFSYBAHA") {
		if (_sfsyb_verify_novxvm_upgrade() == 1) {
			$pkgs=_uniq(@{$PROD{FS}{PKGS}}, @{$PROD{VCS}{PKGS}}, @{$PROD{SFSYB}{PKGS}});
		} else {
			$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{VCS}{PKGS}}, @{$PROD{SFSYB}{PKGS}});
			
		}			
	} else {
		if (_sfsyb_verify_novxvm_upgrade() == 1) {
			$pkgs=_uniq(@{$PROD{FS}{PKGS}}, @{$PROD{SFSYB}{PKGS}});
		} else {
			$pkgs=_uniq(@{$PROD{VM}{PKGS}}, @{$PROD{FS}{PKGS}}, @{$PROD{SFSYB}{PKGS}});
		}			
	}


	if ($FLAG{DB2ED_PKG_INST}) {
		for ($ii =0; $ii < @{$PROD{SFSYB}{PKGS}}; $ii++) {
			last if (${$PROD{SFSYB}{PKGS}}[$ii] eq "VRTSvxmsa");
		}
		splice(@{$PROD{SFSYB}{PKGS}}, $ii, 1);
		$pkgs=_uniq(@{$PROD{SFSYB}{PKGS}});
	}
        return $pkgs;
}

1;
# Define frequently used commands
$CMD{SALRC}="/etc/rc2.d/S99vxsal";
$CMD{SALETC}="/etc/init.d/vxsal";
$CMD{VEAETC}="/etc/init.d/isisd";

# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms
$CMD{START}{vxsald}="/etc/init.d/vxsal start";

# Define frequently referenced paths
$PATH{SPCQSCONF}="/etc/vx/VRTSspcqs";
$PATH{RSTRDIR}="/var/VERITAS/spcqs_data";

# Define product information
$PROD{SPCQS}{NAME}="SANPoint Control QuickStart";
$PROD{SPCQS}{ABBR}="SPCQS";
$PROD{SPCQS}{LICUPI}="SF";
$PROD{SPCQS}{NOLICWINFR}=1;

# Define excluded files for QS
$PROD{SPCQS}{EXCLUDES}=["/opt/VRTSsal/vxsalutil","/opt/VRTSsal/vxsalcmd"];

## _<prod>_ subroutines called by CPI
sub _spcqs_comm_initiation_questions {
        _spcqs_questions();
}
sub _spcqs_comm_preinstall {
        _prod_plat_sub("SPCQS", "preinstall");
}
sub _spcqs_comm_flag_license {
        my($k, $rk);

        for $rk(@{$COMM{KEYS}{$SYS}}) {
                for $k(keys(%$rk)) {
                        $FLAG{VVR} = 1 if ((($$rk{UPI} eq "VM") || ($PMODE eq "SF") || ($PMODE eq "SFHA")) && ($k eq "VVR") && ($$rk{$k} eq "Enabled"));
                        $FLAG{FASTRESYNC} = 1 if ((($$PMODE eq "SF") || ($PMODE eq "SFHA")) && ($k eq "FASTRESYNC") && ($$rk{$k} eq "Enabled"));
                        $FLAG{DGSJ} = 1 if ((($PMODE eq "SF") || ($PMODE eq "SFHA")) && ($k eq "DGSJ") && ($$rk{$k} eq "Enabled"));
                        $FLAG{VXCKPT} = 1 if ((($PMODE eq "SF") || ($PMODE eq "SFHA")) && ($k eq "VXCKPT") && ($$rk{$k} eq "Enabled"));
                        $FLAG{FLASHSNAP} = 1 if (($FLAG{FASTRESYNC} == 1) && ($FLAG{DGSJ} == 1) && ($FLAG{VXCKPT} == 1));
                        $FLAG{QOSS} = 1 if ((($$rk{UPI} eq "FS") || ($PMODE eq "SF") || ($PMODE eq "SFHA")) && ($k eq "Quality of Storage Service") && ($$rk{$k} eq "Enabled"));
                        $FLAG{GCO} = 1 if ((($$rk{UPI} eq "VCS") || ($PMODE eq "SFHA")) && ($k eq "Global Cluster Option") && ($$rk{$k} eq "Enabled"));
                }
        }
}
sub _spcqs_comm_postinstall {
        foreach $SYS(@SYSI){
                _spcqs_rem_nonqs_fls();
                if (!$OPT{INSTALLONLY}){ 
                        if (!_spcqs_create_config()){
                                _bpl("Configuring $PROD{SPCQS}{NAME} on $SYS.", 210, 1029, "$PROD{SPCQS}{NAME}", "$SYS");
                                _spcqs_conf_sal();
                                _spcqs_run_spccfg();
                        } else {
                                _bpl("$PROD{SPCQS}{NAME} already configured on $SYS", 210, 1001, "$PROD{SPCQS}{NAME}", "$SYS");
                        }
                }
        }
        _spcqs_postinstall_messages();
}
sub _spcqs_postinstall_messages {
        if (!$OPT{UNINSTALL} && !$OPT{INSTALLONLY}){
                _clr_scrn();
                _title();
                _bpl("$PROD{SPCQS}{NAME} post install configuration information:", 210, 1043, "$PROD{SPCQS}{NAME}");
                if (_spcqs_is("MAN")){
                        _pl("\nManual pages have been added to the /opt/VRTS/man location.\nTo view these man pages update your MANPATH with '/opt/VRTS/man'\nRun 'catman -w' to index them.", 210, 1034);
                }
 
                _pl("\nIf you would you like to configure the Oracle explorer following installation, run the following script(You need to configure only if 'connect/internal' by DBA requires a password):\n\n$PKGI{VRTSsal}{BASEDIR}/VRTSsal/vxOra", 210, 1035, "$PKGI{VRTSsal}{BASEDIR}");
                _pl("\nIf you would like to run the $UPI configuration utility following installation, run the following script:\n\n$PKGI{VRTSspcfg}{BASEDIR}/VRTSspcfg/SunOS/spcconfig", 210, 1041, "$UPI", "$PKGI{VRTSspcfg}{BASEDIR}");
                _prtc(); 
        }
}
sub _spcqs_comm_start_product {
        _bpl("Starting $PROD{SPCQS}{NAME} processes on target systems...", 210, 1044, "$PROD{SPCQS}{NAME}");
        foreach $SYS(@SYSI){
                _spcqs_rsh_start("$CMD{SALETC} start > /dev/null 2>&1");
                if (_spcqs_is("SERVER")){_spcqs_rsh_start("$CMD{VEAETC} start > /dev/null 2>&1");}
        }
        _bpl("\nDone starting $PROD{SPCQS}{NAME} processes on target systems...", 210, 1045, "$PROD{SPCQS}{NAME}"); 
        return;
}
sub _spcqs_comm_preremove {
        $PKGI{VRTSsal}{BASEDIR}=_spcqs_get_basedir("VRTSsal");
}
sub _spcqs_comm_postremove {
        foreach $SYS(@SYSI){ 
                _spcqs_clean();
        }
}

# SPCQS does not require a license
sub _spcqs_comm_is_prodkey {
        return 1; 
}

## Function: _spcqs_questions
## Comment: Asks all preinstall questions for SPCQS 
## Params: None
## Output: None

sub _spcqs_questions {

        if ($OPT{UNINSTALL}){
                #Set pkgs to uninstall
                if (_spcqs_is("SERVER")){
                        $PROD{SPCQS}{PKGS}=["VRTSsal","VRTSspcfg","VRTSspcqs","VRTSspqmn","VRTSspqdc"];
                } else {
                        $PROD{SPCQS}{PKGS}=["VRTSsal","VRTSspcfg","VRTSspqmn","VRTSspqdc"];
                }

                if ($CFG{RESPONSE}){
                        $CFG{SVDB}="Y";
                        return;
                }
                return;
        }

        my ($path,$dbpath,$rv,$br,$strt,$rbt,$dl);
        my ($ayn,$cs,$csel,$srv,$pi,$svpkg,$pn,$plpkg,$pp);

        _bpl("Welcome to the VERITAS $PROD{SPCQS}{NAME} installation for Unix platforms.", 210, 1046, "$PROD{SPCQS}{NAME}");_prtc();

        $cs="0";

        _clr_scrn();
        _title();
        while ($cs eq "0" && (!$OPT{CONFIGURE})){
                #Ask user which SPCQS components should be installed
                #_bpl("VERITAS $PROD{SPCQS}{NAME} component information and configuration:");
                _pl("Read the following component descriptions and enter the appropriate options specific to your $PROD{SPCQS}{NAME} installation.", 210, 1047, "$PROD{SPCQS}{NAME}");
                _bpl("\nServer:", 210, 1009);
                _pl("\nThe Server is the $PROD{SPCQS}{NAME} component that discovers and stores information about SAN objects and their attributes.  Only one Server should be installed on your SAN.  The Server and Agent cannot reside on the same host.", 210, 1010, "$PROD{SPCQS}{NAME}");
                _bpl("\nAgent:", 210, 1011);
                _pl("\nThe Agent is the $PROD{SPCQS}{NAME} component that assists the Server in discovering the entire SAN.  To maximize discovery of SAN objects, it is recommended that you install an Agent on every host attached to your SAN.\n", 210, 1012, "$PROD{SPCQS}{NAME}");
                $COMM{DEFANSWER}="2";
                $csel="";
                $COMM{MENU}=["Install Server","Install Agent"];
                $srv=_menu("Enter '1' to install the Server, '2' to install an Agent:", 210, 1038);  
 
                #Build list of selected components 
                if ($srv eq "1") {$csel="$PROD{SPCQS}{NAME} Server";}
                if ($srv eq "2") {$csel="$PROD{SPCQS}{NAME} Agent";}

                #Verify user selections
                if ($csel) {
                        _pl("\nThe $csel will now be installed.\n", 210, 1032, "$csel");
                        $ayn=_ayny("Is this information correct?", 210, 1048);
			$cs=1 if ($ayn eq "Y");
                } else {
                        _pl("\nNo $PROD{SPCQS}{NAME} components were selected for installation.\nTry again.", 210, 1039, "$PROD{SPCQS}{NAME}");
                        _prtc();
                } 
                _clr_scrn();
                _title();

        } 
               
        $br="1";

        while ($br eq "0") {
                #Initialize local vars 
                $rv="0";
                $strt="N";
                $rbt="N";
                $dl="N";

                #Get installation path
                while ($rv eq "0" && !$OPT{CONFIGURE}) {
                        #Get install path
                        $COMM{DEFANSWER}="/opt";
                        $path=_ask("\nWhere should $PROD{SPCQS}{NAME} packages be installed?", 210, 1017, "$PROD{SPCQS}{NAME}");
                        $rv=_spcqs_ck_dir ($path);
                }

                #Get basedir, if CONFIGURE
                if (!$path){$path=_spcqs_get_basedir("VRTSsal");}

                if ($OPT{CONFIGURE} && (!_spcqs_is("SERVER"))){
                        $rv="1";
                } else {
                        $rv="0";
                }
                while ($rv eq "0" && $srv ne "2" && !$OPT{INSTALLONLY}) {
                        #Get db install path
                        $COMM{DEFANSWER}="/var/VRTSspcqs";
                        $dbpath=_ask("\nWhere should $PROD{SPCQS}{NAME} databases be installed?", 210, 1018, "$PROD{SPCQS}{NAME}");
                        $rv=_spcqs_ck_dir ($dbpath);
                }

                #Get process start/reboot and spccfg options
                if (!$OPT{INSTALLONLY}) {
                        $strt=_ayny("\nShould $PROD{SPCQS}{NAME} processes be started when installation/configuration is complete?", 210, 1019, "$PROD{SPCQS}{NAME}");
                        $rbt=_ayny("\nShould $PROD{SPCQS}{NAME} processes be started when this machine is rebooted?", 210, 1020, "$PROD{SPCQS}{NAME}");
                        _bpl("\nThe $PROD{SPCQS}{NAME} configuration utility can automatically check for updates to supported hardware model, firmware, and driver versions posted on the VERITAS website.  Otherwise, the configuration Utility will use the local version of this reference from the product CD.", 210, 1021, "$PROD{SPCQS}{NAME}");
                        $dl=_ayny("\nWould you like the $PROD{SPCQS}{NAME} configuration utility to download and use the latest updated list from the VERITAS website?", 210, 1022, "$PROD{SPCQS}{NAME}");
                }

                #Verify user selections
                _bpl("\n$PROD{SPCQS}{NAME} Installation Options selected:\n", 210, 1023, "$PROD{SPCQS}{NAME}");
                _pl("Installation dir: $path", 210, 1024, "$path");
                if (!$OPT{INSTALLONLY}) {
                        _pl("Start processes after install: $strt", 210, 1025, "$strt");
                        _pl("Start processes after reboot: $rbt", 210, 1026, "$rbt");
                        _pl("Configuration utility downloads HCL from web: $dl", 210, 1027, "$dl");
                }
                $ayn=_ayny("\nIs the above configuration correct?", 210, 1033);
		$br=1 if ($ayn eq "Y");
        }

        #Store user-defined configuration
        $path="/opt";
        $dbpath="/var/VRTSspcqs";
        $PKGI{VRTSsal}{BASEDIR}=$path;
        $PKGI{VRTSspcfg}{BASEDIR}=$path;
        $PKGI{VRTSspqdc}{BASEDIR}=$path;
        $PKGI{VRTSspcqs}{BASEDIR}=$path;
        $PKGI{VRTSsal}{DBDIR}=$dbpath;
        if ($srv eq "1") {
                $PKGI{VRTSsal}{CLASSES}=$PKGI{VRTSsal}{CLASSES} . " pri";
                $PROD{SPCQS}{PKGS}=["VRTSsal","VRTSspcfg","VRTSspcqs","VRTSspqmn","VRTSspqdc"];
        } elsif ($srv eq "2") {
                $PKGI{VRTSsal}{CLASSES}=$PKGI{VRTSsal}{CLASSES} . " rem";
                $PROD{SPCQS}{PKGS}=["VRTSsal","VRTSspcfg","VRTSspqmn","VRTSspqdc"];
        }
        $CFG{INSTALL}{AUTOSTART}=1; #if ($strt eq "Y");
        $CFG{RBTPROC}="Y"; #$rbt;
        #$CFG{SPCFGDL}=$dl;
        _clr_scrn();
        _title();
}

## Function: _spcqs_create_config
## Comment: Writes SPCQS config info to a file
## Params: N/A
## Returns: 1 for file already created 

sub _spcqs_create_config {
        my ($msg,$rv,$lsfl);

        #Check for conf file and create dir
        $lsfl=_dor("$CMD{LS} $PATH{SPCQSCONF}");
        if ($lsfl =~ /spcqs.conf/){
                return 1; 
        }
        _dor("$CMD{MKDIR} -p $PATH{SPCQSCONF}");

        #Generate Product Configuration and create the config file
        $msg="VERSION=4.0";
        if (_spcqs_is("SERVER")) {
                $msg="$msg\nSERVER=1\nDBDIR=$PKGI{VRTSsal}{DBDIR}";
        } else {
                $msg="$msg\nSERVER=0";
        }
        _writef($msg,"$PATH{ITD}/spcqs.conf.$SYS");
        _copy("$PATH{ITD}/spcqs.conf.$SYS","$PATH{SPCQSCONF}/spcqs.conf");

        return;
}



## Function: _spcqs_get_config
## Comment: Returns config params from spcqs.conf 
## Params: VERSION, SERVER, DBDIR 
## Returns: -1 for file not found
##          Otherwise returns value of Param 

sub _spcqs_get_config {
        my ($pm,$bd,$msg,$lsfl);

        $pm=$_[0];
        
        #Check for conf file
        $lsfl=_dor("$CMD{LS} $PATH{SPCQSCONF}");
        if (! $lsfl =~ /spcqs.conf/){
                return -1;
        }

        #Read/return param
        $msg=_dor("$CMD{CAT} $PATH{SPCQSCONF}/spcqs.conf");
        $msg=~ /$pm=(.*)/;
        return $1;
}

## Function: _spcqs_is
## Comment: Checks if SPCQS is installed as server, agent, etc.
## Params: SERVER
## Returns: 1 for yes

sub _spcqs_is {
        my ($bd,$pkg);

        #Check if SERVER/GUI components are installed
        if ($_[0] eq "SERVER"){$pkg="VRTSspcqs";}
        if ($_[0] eq "MAN"){$pkg="VRTSspqmn";}
        $bd=_spcqs_get_basedir($pkg);
        if ($bd =~ /was not found/){
                return; 
        }
        return 1;
}

## Function: _spcqs_ck_dir
## Comment: Validates a directory on any Unix host
## Params: $dir -> directory to be validated
## Returns: 1 for validated directory
##          0 for inability to create/validate the directory   

sub _spcqs_ck_dir {
        my($dir,$rv);
        $dir=$_[0];

        #If the directory does not already exist, create it
        $rv=(_fc($dir));
        if (!$rv) {
                if (_localsys()) {
                        $rv=_dol("$CMD{MKDIR} -p $dir");
                } else {
                        $rv=_dor("$CMD{MKDIR} -p $dir");
                }
                if ($rv eq "") {
                        $rv="1";
                } else {
                        _pl ("You have either entered an invalid path, or one that cannot be created.  Try again.", 210, 1040);
                        $rv="0";
                }
        }
        return $rv
}

## Function: _spcqs_conf_sal
## Comment: Configures the VRTSsal package on Unix Platforms 
## Params: None 
## Returns: 1 for successful configuration 
##          0 for inability to configure SAL

sub _spcqs_conf_sal {

        my ($sc,$vsn,$scn,$fl);
        $PKGI{VRTSsal}{BASEDIR}=_spcqs_get_basedir("VRTSsal");
        $sc="$PKGI{VRTSsal}{BASEDIR}/VRTSsal";

        #Copy the file to ITD on local host for config.
        _copy("$sc/vxsal","$PATH{ITD}",1); 

        #Configure vxsal
        $vsn=_readf("$PATH{ITD}/vxsal");
        $vsn=~ s/\#\#SAL_DIR\#\#/$PKGI{VRTSsal}{BASEDIR}\/VRTSsal/g;
        if (_spcqs_is("SERVER")){
                $vsn=~ s/\#\#SAL_CMD\#\#/vxsald -primary -config $PKGI{VRTSsal}{DBDIR}\/sal.conf &/g;
        } else { 
                $vsn=~ s/\#\#SAL_CMD\#\#/vxsald -config $PKGI{VRTSsal}{BASEDIR}\/VRTSsal\/sal.conf &/g;
        }
        _writef($vsn,"$PATH{ITD}/vxsal.$SYS");


        #Copy the file to local host for use
        _dor("$CMD{RMR} $sc/vxsal");
        _copy("$PATH{ITD}/vxsal.$SYS","$sc/vxsal"); 
        _copy("$PATH{ITD}/vxsal.$SYS","$CMD{SALETC}");
        _dor("$CMD{CHMOD} +x $CMD{SALETC}");
        _dor("$CMD{CHMOD} +x $sc/vxsal");

        #Configure/Move sal.conf to DB dir if SAL is a primary
        if (_spcqs_is("SERVER")){
                _copy("$sc/sal.conf","$PATH{ITD}",1);
                $scn=_readf("$PATH{ITD}/sal.conf");
                $scn=~ s/Path.?=.*store/Path = $PKGI{VRTSsal}{DBDIR}\/store/;
                _writef($scn,"$PATH{ITD}/sal.conf.$SYS");
                _dor("$CMD{RMR} $PKGI{VRTSsal}{DBDIR}");        
                _dor("$CMD{MKDIR} -p $PKGI{VRTSsal}{DBDIR}");

                #Copy the file back to local host for use
                _copy("$PATH{ITD}/sal.conf.$SYS","$sc"); 
 
                _dor("$CMD{MV} $sc/sal.conf $PKGI{VRTSsal}{DBDIR}");
                _dor("$CMD{LN} -s $PKGI{VRTSsal}{DBDIR}/sal.conf $sc/sal.conf");
        } 

        #Create boot file link, if appropriate
        if ($CFG{RBTPROC} eq "Y") {
                _dor("/usr/bin/ln -s $CMD{SALETC} $CMD{SALRC}");
        }
}

## Function: _spcqs_rem_nonqs_fls
## Comment: deletes all files included with the full product that
## shouldn't be included with QS 
## Params: None
## Returns: N/A 

sub _spcqs_rem_nonqs_fls {
        my($dfl);
    
        foreach $dfl(@{$PROD{SPCQS}{EXCLUDES}}){
                if (-e $dfl){
                        _dor("$CMD{RMR} $dfl");
                }
        }
}

## Function: _spcqs_run_spccfg
## Comment: Runs the SPCQS configuration utility
## Params: None
## Returns: 1 for successful configuration
##          0 for inability to configure SAL

sub _spcqs_run_spccfg {
        _dor("$CMD{CHMOD} +x $PKGI{VRTSspcfg}{BASEDIR}/VRTSspcfg/SunOS/spcconfig");
        if ($CFG{SPCFGDL} eq "Y"){
                _dor("$PKGI{VRTSspcfg}{BASEDIR}/VRTSspcfg/SunOS/spcconfig --use-web-matrix --install-check --report-dir /tmp");
        } else {
                _dor("$PKGI{VRTSspcfg}{BASEDIR}/VRTSspcfg/SunOS/spcconfig --install-check --report-dir /tmp");
        }
}

## Function: _spcqs_rsh_start
## Comment: runs startup scripts that have trouble with rsh 
## Params: script name 
## Returns: N/A 

sub _spcqs_rsh_start {
        #Create script in /tmp, execute script, and delete script
        _writef("\#!/bin/sh\n`\$* 1>/tmp/rex 2>/tmp/rex`\necho \$?","$PATH{ITD}/rstrt.$SYS");
        _copy("$PATH{ITD}/rstrt.$SYS","$PATH{TMP}/rstrt");
        _dor("$CMD{CHMOD} +x $PATH{TMP}/rstrt");
        _dor("$PATH{TMP}/rstrt $_[0]");
        _dor("$CMD{RMR} $PATH{TMP}/rstrt");
}

## Function: _spcqs_get_basedir
## Comment: retrieves base installation dir for @_ 
## Params: pkg name 
## Returns: -1 if pkg not installed, else returns BASEDIR of pkg 

sub _spcqs_get_basedir {
        my($pkg,$rv);

        $pkg=$_[0];
        $rv=_dor("$CMD{PKGINFO} -r $pkg");
        if (!$rv){return -1;}
        return $rv;
}

## Function: _spcqs_clean
## Comment: removes leftover files/dirs from SPCQS installation 
## Params: None
## Returns: N/A 

sub _spcqs_clean {
        _dor("$CMD{RMR} $PKGI{VRTSsal}{BASEDIR}/VRTSsal");
        _dor("$CMD{RMR} $PKGI{VRTSsal}{BASEDIR}/VRTSspcfg");
        _dor("$CMD{RMR} /etc/init.d/vxsal");
        my $dbd=_spcqs_get_config("DBDIR");
        if ($dbd){
                if ($CFG{SVDB} eq "Y"){
                        _spcqs_ck_dir("$PATH{RSTRDIR}");
                        _dor("$CMD{MV} $dbd/sal.conf $PATH{RSTRDIR}");
                        _dor("$CMD{MV} $dbd/store $PATH{RSTRDIR}");
                        _dor("$CMD{RMDIR} $dbd");
                } else {
                        _dor("$CMD{RMR} $dbd/store");
                        _dor("$CMD{RMR} $dbd/sal.conf");
                }
                _dor("$CMD{RMR} $PKGI{VRTSsal}{BASEDIR}/VRTSspcqs");
        } else {
                if ($CFG{SVDB} eq "Y"){
                        _spcqs_ck_dir("$PATH{RSTRDIR}");
                        _dor("$CMD{MV} $PKGI{VRTSsal}{BASEDIR}/VRTSsal/sal.conf $PATH{RSTRDIR}");
                }
        }
        _dor("$CMD{RMR} $PATH{SPCQSCONF}");
}

## Function: _clr_scrn
## Comment: flushes screen buffer...borrowed from TD.pl
## Params: None
## Returns: N/A 
sub _clr_scrn()
{
	if ($COMM{TPUT}{CS} ne "") {
		printf $COMM{TPUT}{CS};
	}
}
$PROD{TD}{NAME}    = "Cluster Server Traffic Director";
$PROD{VCSTD}{NAME} = "Cluster Server Traffic Director";
$PROD{TD}{ABBR}    = "TD";
$PROD{TD}{HOMEDIR} = "/opt/VRTStd";
#
# We depend on VCS license
#
$PROD{TD}{LICID}  = "TRAFFIC_DIRECTOR";
$PROD{TD}{LICUPI} = "VCS";

# Define frequently referenced paths
$PATH{PRODBIN}="/opt/VRTStd/bin";
$PATH{PRODCONF}="/etc/VRTStd";

sub _td_comm_initial_systemcheck {
	_prod_plat_sub("TD", "initial_systemcheck");
}

sub _td_comm_preinstall
{
        _prod_plat_sub("preinstall");
}

# check to see if valid configuration files exist on the local system
# if so, return a reference to an array holding ("systems", "version")
sub _td_comm_check_localconfig
{
	_prod_plat_sub("check_localconfig");
}

# display task completion information
sub _td_comm_completion_messages {
	my ($ww, $ans, $tdsetup);

	if ($OPT{UNINSTALL}) {
		return;
	}

	$tdsetup = "/opt/VRTStd/bin/tdsetup";

	_pl("VERITAS $PROD{TD}{NAME} software packages have been installed\n", 140, 1001, "$PROD{TD}{NAME}");
	$ans = _ayny("Do you want to configure the product now?", 140, 1025);
	if ($ans eq "Y") {
		if (-X $tdsetup) {
			_pl("Running $tdsetup...\n", 140, 1003, "$tdsetup");
			system($tdsetup);
			return;
		}
	}

	$ww = $COMM{TERMX};
	if (($ww eq "") || ($ww == 0)) {
		$ww = 80;
	}
	printf("$COMM{TPUT}{BS}");
	printf "-" x  $ww . "\n";
	_pl("Traffic Director software has been installed. To create an initial configuration execute /opt/VRTStd/bin/tdsetup", 140, 1026);
	printf "-" x $ww . "\n";
	printf("$COMM{TPUT}{BE}");
	printf("\n");
}

# perform any checks or tasks necessary before the product is started
sub _td_comm_prestop
{
	_prod_plat_sub("prestop");
}

sub _td_comm_stop_processes {
        _pb1("Stopping TD processes on host $SYS", 140, 1027, "$SYS");
        _dor("/sbin/tdctl -f -stop > /dev/null 2>&1");
        _pb2("Done", 140, 1028);
}

1;
#
# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#

# Define frequently used commands
$CMD{LLTCONFIG}="/sbin/lltconfig";
$CMD{GABCONFIG}="/sbin/gabconfig";
$CMD{LMXCONFIG}="/sbin/lmxconfig";
$CMD{VCSMMCONFIG}="/sbin/vcsmmconfig";
$CMD{VXFENCONFIG}="/sbin/vxfenconfig";

# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms
$CMD{STOP}{"bin/had"}="/opt/VRTSvcs/bin/hastop -local -force";
$CMD{STOP}{llt}="$CMD{LLTCONFIG} -U -o";
$CMD{STOP}{gab}="$CMD{GABCONFIG} -U";

$CMD{START}{lxlmx}="/etc/init.d/lmx start ";
$CMD{START}{lxvcsmm}="/etc/init.d/vcsmm start ";
$CMD{START}{lmx}="$CMD{LMXCONFIG} -c ";
$CMD{START}{vcsmm}="$CMD{VCSMMCONFIG} -c ";


# Define product configuration files
$CONF{GABTAB}="/etc/gabtab";
$CONF{LLTHOSTS}="/etc/llthosts";
$CONF{LLTTAB}="/etc/llttab";
$CONF{MAINCF}="/etc/VRTSvcs/conf/config/main.cf";
$CONF{TYPESCF}="/etc/VRTSvcs/conf/config/types.cf";

# Define frequently referenced paths
$PATH{CONF}="/etc/VRTSvcs/conf";
$PATH{CONFIG}="/etc/VRTSvcs/conf/config";
$PATH{VCSBIN}="/opt/VRTSvcs/bin";
$PATH{GCMBIN}="/opt/VRTSgcm/bin";
$PATH{QSBIN}="/opt/VRTSvcs/qsbin";

# Define product information
$PROD{VCS}{NAME}="Cluster Server";
$PROD{VCS}{ABBR}="VCS";
$PROD{VCS}{HOMEDIR}="/opt/VRTSvcs";

# Define product modes and names for product modes
$PROD{VCSQS}{NAME}="VCS QuickStart";
$PROD{VCSRAC}{NAME}="SFRAC";
$PROD{VCSTD}{NAME}="VCS for Traffic Director";
$PROD{VCSSN}{NAME}="Single Node VCS";
$PROD{VCSSFCFS}{NAME}="VCS for SFCFS";
$PROD{VCS}{CONFIGFILES}=[$CONF{LLTHOSTS}, $CONF{LLTTAB}, $CONF{GABTAB}, $CONF{MAINCF}, $CONF{TYPESCF}];

$PROD{VCS}{MODES} = [ qw(VCSSN VCSSFCFS VCSTD VCSRAC VCS) ];

$PROD{VCS}{RWORDS} = [ qw(cluster system group resource type) ];

# ask for product mode for pre-install check
# return $UPI if product is not mode based
sub _vcs_comm_ask_mode {
	# we could ask here, and leaving code in as an example, but SFRAC is
	# no longer part of this train, VCSSFCFS is a rare bird (part of
	# SFCFS) and VCSSN and VCSTD are basically the same as VCS
	return "VCS";
	my @mode=("VCS","VCSRAC","VCSSN","VCSTD","VCSSFCFS");
	_bpl("$PROD{VCS}{ABBR} Preinstallation Check:", 120, 1301, "$PROD{VCS}{ABBR}");
	$COMM{MENU}=[$PROD{VCS}{NAME},$PROD{VCSRAC}{NAME},$PROD{VCSTD}{NAME},$PROD{VCSSN}{NAME},$PROD{VCSSFCFS}{NAME}];
	$MSG{HELP}=_tr("There are multiple modes that $PROD{$UPI}{ABBR} can run under.  Each mode may have a different set of $MSG{PDFRS} to install or other unique installation checks", 120, 1001, "$PROD{$UPI}{ABBR}", "$MSG{PDFRS}");
	my $menu=_menu("For which version of $PROD{VCS}{ABBR} would you like perform a pre-installation check?", 120, 1002, "$PROD{VCS}{ABBR}");
	return "$mode[$menu-1]";
}

# ask for cluster id value between 0-255
sub _vcs_ask_clusterid {
	my($ask,$cid);
	($cid)=(@_);
	while (1) {
		$COMM{DEFANSWER}=$cid;
		$MSG{HELP}=_tr("Each $PROD{VCS}{ABBR} cluster has a unique identifier that is an integer value between 0 and 255.  A system will panic if it is configured with a Cluster identifier that is already being used by another cluster.", 120, 1003, "$PROD{VCS}{ABBR}");
		$ask=_ask("Enter the unique Cluster ID number between 0-255:", 120, 1004);
		return if ($FLAG{BACK});
		$ask=~s/^0+//;
		$ask||=0;
		return "$ask" if ((_isint($ask) eq "") && ($ask>=0) && ($ask<=255));
	}
}

# ask for cluster name
sub _vcs_ask_clustername {
	my($ask,$cname);
	($cname)=(@_);
	while (1) {
		$COMM{DEFANSWER}=$cname;
		$MSG{HELP}=_tr("Each $PROD{VCS}{ABBR} Cluster has a name which must begin with a letter of the alphabet.  Only letters, numbers, or the characters - and _ are allowed in a cluster name.", 120, 1005, "$PROD{VCS}{ABBR}");
		$ask=_ask("Enter the unique cluster name:", 120, 1006);
		return "$ask" if (_vcs_verify_clustername($ask));
	}
}

# ask for one public nic
# $ntfrgco="" means first time in for cluster service group
# $ntfrgco=1 means potential second time in for notifier
# $ntfrgco=2 means potential second time in for Global Cluster option
sub _vcs_ask_publicnic {
	my (%csgnic,$all,$aayn,$ayn,$en,$nic,$nicl,$ntfrgco,$rpn);
	($ntfrgco)=(@_);
	return "" if (($PROD{VCS}{RCSGNIC}) && ($ntfrgco==1));
	foreach $SYS(@SYSC) {
		if ($all) { $csgnic{$SYS}=$nic; next; }
		$rpn="";
		if (_list($SYS,@SYSI)>=0) {
			$rpn=_plat_sub("get_publicnics");
			if ($#$rpn<0) {
				_warn("No active NIC devices have been discovered on $SYS", 120, 1007, "$SYS") 
			} else {
				$nicl=join(" ",@$rpn);
				_pl("Active NIC devices discovered on $SYS: $nicl", 120, 1008, "$SYS", "$nicl");
			}
		}
		$nic="";
		while (!$nic) {
			$COMM{DEFANSWER}=$$rpn[0];
			$MSG{HELP}=_tr("The NIC selected is typically the network card on which the system's public IP address is active.", 120, 1009);
			if ($ntfrgco==2) {
				$en=_ask("Enter the NIC for Global Cluster Option to use on $SYS:", 120, 1224, "$SYS");
			} elsif ($ntfrgco==1) {
				$en=_ask("Enter the NIC for the $PROD{VCS}{ABBR} Notifier to use on $SYS:", 120, 1225, "$PROD{VCS}{ABBR}", "$SYS");
			} else {
				$en=_ask("Enter the NIC for Cluster Manager (Web Console) to use on $SYS:", 120, 1226, "$SYS");
			}
			return if ($FLAG{BACK});
			if (_niccheck($en)) {
				_pl("$en is not a valid NIC name", 120, 1013, "$en");
			} elsif ((_list($SYS,@SYSI)>=0) && (_list($en,@$rpn)<0)) {
				_pl("$en does not appear to be an active NIC", 120, 1014, "$en");
				$MSG{HELP}=_tr("The NIC selected is typically the network card on which the systems public IP address is active.  This NIC may or may not be the same on each system within a cluster.", 120, 1015);
				$ayn=_aynn("Are you sure you want to use NIC $en ?", 120, 1016, "$en");
				return if ($FLAG{BACK});
				$nic=$en if ($ayn eq "Y");
			} else {
				$nic=$en;
			}
		}
		$csgnic{$SYS}=$nic;
		if (($SYS eq $SYSC[0]) && (_vcs_vcsmode() ne "VCSQS")) {
			$MSG{HELP}=_tr("The NIC selected is typically the network card on which the systems public IP address is active.  This NIC device may or may not be the same on each system within a cluster.", 120, 1017);
			$aayn=_ayny("Is $nic to be the public NIC used by all systems", 120, 1018, "$nic");
			return if ($FLAG{BACK});
		}
		$all=1 if ((_vcs_vcsmode() eq "VCSQS") || ($aayn eq "Y"));
	}
	return \%csgnic;
}

# ask for a heartbeat nic
sub _vcs_ask_hbnic {
	my($ayn,$en,$fst,$nic,$pn,$ren,$rpn,$rsn,$sn,$help);
	($fst,$rsn,$rpn,$ren)=(@_);
	if ($fst eq "lowpri") {
		$help=_tr("The NIC selected as a low priority heartbeat link is typically the network card on which the system's public IP address is active.", 120, 1019);
	} else {
		$help=_tr("The NIC selected as a private heartbeat link is typically not plumbed or configured with an IP address.  NIC devices used for each heartbeat link must have a private connection using network switches, hubs, or crossover cables.\n\nYou may enter any NIC at the prompt if a NIC device on your system is not properly discovered.", 120, 1259);
	}
	while (!$nic) {
		$MSG{HELP}=$help;
		if (_vcs_vcsmode() eq "VCSQS") {
			if ($fst==1) {
				$en=_ask("Enter the NIC for the first private heartbeat link:", 120, 1306);
			} elsif ($fst==2) {
				$en=_ask("Enter the NIC for the second private heartbeat link:", 120, 1307);
			} 
		} else {
			if ($fst==1) {
				$en=_ask("Enter the NIC for the first private heartbeat link on $SYS:", 120, 1308, "$SYS");
			} elsif ($fst==2) {
				$en=_ask("Enter the NIC for the second private heartbeat link on $SYS:", 120, 1309, "$SYS");
			} elsif ($fst==3) {
				$en=_ask("Enter the NIC for the third private heartbeat link on $SYS:", 120, 1310, "$SYS");
			} elsif ($fst==4) {
				$en=_ask("Enter the NIC for the fourth private heartbeat link on $SYS:", 120, 1311, "$SYS");
			} else {
				$COMM{DEFANSWER}=$$rpn[0];
				$en=_ask("Enter the NIC for the low priority heartbeat link on $SYS:", 120, 1312, "$SYS");
			}
		}
		return if ($FLAG{BACK});
		$pn=_list($en,@$rpn);
		$sn=_list($en,@$rsn);
		if ($en eq "") {
		} elsif (_niccheck($en)) {
			_pl("$en is not a valid NIC name", 120, 1013, "$en");
		} elsif ($en eq $$ren[1]) {
			_pl("$en is already being used for the first private heartbeat link", 120, 1313, "$en");
		} elsif ($en eq $$ren[2]) {
			_pl("$en is already being used for the second private heartbeat link", 120, 1314, "$en");
		} elsif ($en eq $$ren[3]) {
			_pl("$en is already being used for the third private heartbeat link", 120, 1315, "$en");
		} elsif ($en eq $$ren[4]) {
			_pl("$en is already being used for the fourth private heartbeat link", 120, 1316, "$en");
		} elsif ((($pn>=0) && ($fst ne "lowpri")) || 
			(($#$rsn>=0) && ($sn<0))) {
			if (($pn>=0) && ($fst ne "lowpri")) {
				_pl("$en is currently active as a public NIC on $SYS", 120, 1032, "$en", "$SYS");
			} else {
				_pl("$en is not a NIC discovered on $SYS", 120, 1033, "$en", "$SYS");
			}
			$MSG{HELP}=_tr("The NIC selected as a private heartbeat link is typically not plumbed or configured with and IP address.  NIC devices used for each heartbeat link must have a private connection using network switches, hubs, or crossover cables", 120, 1034);
			if ($fst==1) {
				$ayn=_aynn("Are you sure you want to use $en for the first private heartbeat link?", 120, 1317, "$en");
			} elsif ($fst==2) {
				$ayn=_aynn("Are you sure you want to use $en for the second private heartbeat link?", 120, 1318, "$en");
			} elsif ($fst==3) {
				$ayn=_aynn("Are you sure you want to use $en for the third private heartbeat link?", 120, 1319, "$en");
			} elsif ($fst==4) {
				$ayn=_aynn("Are you sure you want to use $en for the fourth private heartbeat link?", 120, 1320, "$en");
			} else {
				$ayn=_aynn("Are you sure you want to use $en for the low priority heartbeat link?", 120, 1321, "$en");
			}
			return if ($FLAG{BACK});
			$nic=$en if ($ayn eq "Y");
		} else {
			$nic=$en;
		}
	}
	return "$nic";
}

# Ask about a second heartbeat link
sub _vcs_ask_second_hb {
	$MSG{HELP} = _tr("A $PROD{VCS}{ABBR} cluster is typically configured to use two private heartbeat links, but some $PROD{$UPI}{ABBR} clusters may be configured with just one private heartbeat link and a second low priority heartbeat link.  The NIC selected as a low priority heartbeat link is typically the network card on which the system's public IP address is active.", 120, 1322, "$PROD{VCS}{ABBR}", "$PROD{$UPI}{ABBR}");
	if ($FLAG{FENCINGENABLED}) {
		return _aynn("Would you like to configure a second private heartbeat link?", 120, 1044);
	} else {
		return _ayny("Would you like to configure a second private heartbeat link?", 120, 1044);
	}
}

# Ask about a third heartbeat link
sub _vcs_ask_third_hb {
	$MSG{HELP} = _tr("A $PROD{$UPI}{ABBR} cluster requires two private heartbeat links, but additional heartbeat links may be configured for increased performance and protection.", 120, 1045, "$PROD{$UPI}{ABBR}");
	return _aynn("Would you like to configure a third private heartbeat link?", 120, 1046);
}

# Ask about a fourth heartbeat link
sub _vcs_ask_fourth_hb {
	$MSG{HELP} = _tr("A $PROD{$UPI}{ABBR} cluster requires two private heartbeat links, but additional heartbeat links may be configured for increased performance and protection.", 120, 1045, "$PROD{$UPI}{ABBR}");
	return _aynn("Would you like to configure a fourth private heartbeat link?", 120, 1047);
}

# Ask about a lowpri heartbeat link
sub _vcs_ask_lowpri_hb {
	$MSG{HELP}=_tr("Configuring a low priority heartbeat link on the public network is an option that provides an additional method of confirming system failure.", 120, 1323);
	return _aynn("Do you want to configure an additional low priority heartbeat link?", 120, 1049);
}

# Ask about using common NIC numbers
sub _vcs_ask_common_nics {
	$MSG{HELP} = _tr("Enter 'y' if the NIC devices used for this heartbeat link are the same on all systems in the cluster.  Enter 'n' if NIC devices used for this heartbeat link are not the same on all systems in the cluster.", 120, 1050);
	return _ayny("Are you using the same NICs for private heartbeat links on all systems?", 120, 1051);
}

# ask for all heartbeat links
sub _vcs_ask_hbnics {
	my(%hbn,@en,$all,$ayn,$dsn,$hb2,$hb3,$hb4,$hbl,$rpn,$rsn);
	foreach $SYS(@SYSC) {
		if ($all) {
			$hbn{LLTLINK1}{$SYS}=$en[1];
			$hbn{LLTLINK2}{$SYS}=$en[2];
			$hbn{LLTLINK3}{$SYS}=$en[3] if ($en[3]);
			$hbn{LLTLINK4}{$SYS}=$en[4] if ($en[4]);
			$hbn{LLTLINKLOWPRI}{$SYS}=$en[5] if ($en[5]);
			next;
		}
		$rsn=$rpn="";
		if (_list($SYS,@SYSI)>=0) {
			_p();
			_pb1("Discovering NICs on $SYS", 120, 1040, "$SYS");
			$rsn=_plat_sub("get_systemnics");
			$rpn=_plat_sub("get_publicnics");
			$dsn=join(" ",@$rsn);
			if ($#$rsn<0) {
				_pb2("No NICs discovered", 120, 1041);
			} else {
				_pb2("discovered $dsn", 120, 1042, "$dsn");
			}
			_p();
		}
		undef(@en);
		$hbn{LLTLINK1}{$SYS} = $en[1] = _vcs_ask_hbnic(1,$rsn,$rpn);
		return if ($FLAG{BACK});
		if ($SYS eq $SYSC[0]) {
			$hb2 = _vcs_ask_second_hb();
			return if ($FLAG{BACK});
		}
		if ($hb2 eq "Y") {
			$hbn{LLTLINK2}{$SYS} = $en[2] =
				_vcs_ask_hbnic(2,$rsn,$rpn,\@en);
			return if ($FLAG{BACK});
		}
		next if (_vcs_vcsmode() eq "VCSQS");
		if (($SYS eq $SYSC[0]) && ($hb2 eq "Y") && ($#$rsn>2)) {
			$hb3=_vcs_ask_third_hb();
			return if ($FLAG{BACK});
		}
		if ($hb3 eq "Y") {
			$hbn{LLTLINK3}{$SYS} = $en[3] =
				_vcs_ask_hbnic(3,$rsn,$rpn,\@en);
			return if ($FLAG{BACK});
		}
		if (($SYS eq $SYSC[0]) && ($hb3 eq "Y") && ($#$rsn>3)) {
			$hb4=_vcs_ask_fourth_hb();
			return if ($FLAG{BACK});
		}
		if ($hb4 eq "Y") {
			$hbn{LLTLINK4}{$SYS} = $en[4] =
				_vcs_ask_hbnic(4,$rsn,$rpn,\@en);
			return if ($FLAG{BACK});
		}
		$hb2="Y" if ($FLAG{FENCINGENABLED});
		if (($SYS eq $SYSC[0]) && ($hb2 eq "Y") && ($UPI ne "SFRAC")) {
			$hbl = _vcs_ask_lowpri_hb();
			return if ($FLAG{BACK});
		}
		if (($hbl eq "Y") || ($hb2 eq "N")) {
			$hbn{LLTLINKLOWPRI}{$SYS} = $en[5] =
				_vcs_ask_hbnic("lowpri",$rsn,$rpn,\@en);
			return if ($FLAG{BACK});
		}
		if ($SYS eq $SYSC[0]) {
			$ayn = _vcs_ask_common_nics();
			return if ($FLAG{BACK});
			$all = 1 if ($ayn eq "Y");
		}
	} 
	return \%hbn;
}

# ask for the netmask on a public NIC
sub _vcs_ask_netmask {
	my($dnm,$netm,$nic,$vip);
	($vip,$nic)=(@_);
	$dnm=_comm_get_defaultnetmask($vip,$nic);
	while (1) {
		$COMM{DEFANSWER}=$dnm;
		$MSG{HELP}=_tr("The netmask that is configured for the physical address of this NIC (default selection) is typically used for logical addresses configured on the same NIC.", 120, 1052);
		$netm=_ask("Enter the netmask for IP $vip:", 120, 1232, "$vip");
		return if ($FLAG{BACK});
		if (_ipcheck($netm)) {
			_pl("$netm is not a valid netmask", 120, 1054, "$netm");
		} else {
			return "$netm";
		}
	}
}

# ask for severity for SMTP/SNMP notification
sub _vcs_ask_severity {
	my(@sevs,$rc,$sev,$snmp);
	($rc,$snmp)=(@_);
	@sevs=("Information","Warning","Error","SevereError");
	while (_list($sev,@sevs)<0) { 
		$MSG{HELP}=_tr("Information messages include ...\nWarning messages include ...\nError messages include ...\nSevereError message include ...", 120, 1055);
		if ($snmp) {
			$sev=_ask("Enter the minimum severity of events for which SNMP traps should be sent to $rc  [I=Information, W=Warning, E=Error, S=SevereError]:", 120, 1056, "$rc");
		} else {
			$sev=_ask("Enter the minimum severity of events for which mail should be sent to $rc  [I=Information, W=Warning, E=Error, S=SevereError]:", 120, 1057, "$rc");
		}	
		return if ($FLAG{BACK});
		$sev="Information" if ($sev =~ /^I/i);
		$sev="Warning" if ($sev =~ /^W/i);
		$sev="Error" if ($sev =~ /^E/i);
		$sev="SevereError" if ($sev =~ /^S/i);
	}
	return "$sev";
}

# ask for a SMTP recipient
sub _vcs_ask_smtprecp {
	while (1) {
		$MSG{HELP}=_tr("The SMTP recipient will receive notification of $PROD{$UPI}{ABBR} events via email at the designated address", 120, 1058, "$PROD{$UPI}{ABBR}");
		my $ask=_ask("Enter the full email address of the SMTP recipient\n(example: user$MSG{AT}yourcompany.com):", 120, 1059, "$MSG{AT}");
		return if ($FLAG{BACK});
		return "$ask" if (_vcs_verify_emailadd($ask));
	}
}

# ask for an SMTP mail server
sub _vcs_ask_smtpserver {
	my($ask,$server);
	($server)=(@_);
	while(1) {
		$COMM{DEFANSWER}=$server;
		$MSG{HELP}=_tr("The SMTP server is a mail server on your network.", 120, 1060);
		$ask=_ask("Enter the domain-based hostname of the SMTP server\n(example: smtp.yourcompany.com):", 120, 1061);
		return if ($FLAG{BACK});
		return "$ask" if (_vcs_verify_smtpserver($ask));
	}
}

# ask for an SNMP console server
sub _vcs_ask_snmpconsole {
	my($cons,$ping);
	while (1) {
		$MSG{HELP}=_tr("The console designated will receive notification of $PROD{$UPI}{ABBR} events via SNMP trap messages", 120, 1062, "$PROD{$UPI}{ABBR}");
		$cons=_ask("Enter the SNMP console system name:", 120, 1063);
		return if ($FLAG{BACK});
		$ping=_plat_sub("ping", $cons);
		if ($ping) {
			_pl("Cannot ping $cons", 120, 1064, "$cons"); 
		} else {
			return "$cons";
		}
	}
}

# ask for the SNMP port, default is 162
sub _vcs_ask_snmpport {
	my($pc,$ayn,$port);
	while (1) {
		$COMM{DEFANSWER}=162;
		$MSG{HELP}=_tr("SNMP traps are sent to a specific port on each console server.  The default port number for SNMP trap messages is 162.", 120, 1065);
		$port=_ask("Enter the SNMP trap daemon port:", 120, 1066);
		return if ($FLAG{BACK});
		$pc=~s/[0-9]//g;
		if (($port>65535) || ($port<0) || ($port=~/\D/)) {
			_pl("$port is an invalid port number", 120, 1263, "$port");
		} elsif (($port!=162) && ($port<=1024)) {
			$ayn=_aynn("Are you sure you want to use $port as the SNMP trap port?", 120, 1264, "$port");
			return "$port" if ($ayn eq "Y");
		} else {
			return "$port";
		}
	}
}

# ask for a virtual IP for Cluster Manager or the Global Cluster option
sub _vcs_ask_vip {
	my($ask,$gco,$vip);
	($vip,$gco)=(@_);
	while(1) {
		$COMM{DEFANSWER}=$vip;
		$MSG{HELP}=_tr("A virtual address is an IP address that is configured on a public NIC interface on one system in a cluster at any given time to perform specific services that must remain highly available.", 120, 1067);
		if ($gco) {
			$ask=_ask("Enter the Virtual IP address for the Global Cluster Option:", 120, 1215);
		} else {
			$ask=_ask("Enter the Virtual IP address for Cluster Manager:", 120, 1069);
		}
		return if ($FLAG{BACK});
		if (_ipcheck($ask)) {
			_pl("$ask is not a valid IP address", 120, 1070, "$ask");
		} else {
			return "$ask";
		}
	}
}

# invalidate VCS QuickStart licenses
sub _vcs_comm_check_license {
	my ($mode)=(@_);
	return if ($mode ne "VCSQS");
	_bpl("\nVCS QuickStart is not supported with VCS $COMM{TRAINVERS}.\n", 120, 1298, "$COMM{TRAINVERS}");
	_bpl("To upgrade VCS QuickStart to VCS $COMM{TRAINVERS}, uninstall VCS QuickStart from your systems and install VCS using VCS license keys.\n", 120, 1299, "$COMM{TRAINVERS}");
	$COMM{PKEY}{$SYS}="";
}

# check to see if valid configuration files exist on the local system
# if so, return a reference to an array holding ("version", "systems")
sub _vcs_comm_check_localconfig {
	my (@ga,@sa,$cf,$clnm,$dsys,$gl,$iv,$lltn,$llts,$mcfg,$mcfs);
	foreach $cf(@{$PROD{VCS}{CONFIGFILES}}) { return "" unless (-f $cf); }
	# all files are there, get cluster info
	$clnm=_dol("$CMD{GREP} '^cluster' $CONF{MAINCF} | $CMD{AWK} '{print \$2}'");
	$lltn=_dol("$CMD{GREP} set-cluster $CONF{LLTTAB} | $CMD{AWK} '{print \$2}'");
	$llts=_dol("$CMD{CAT} $CONF{LLTHOSTS} | $CMD{AWK} '{print \$2}' | $CMD{SORT}");
	$mcfs=_dol("$CMD{CAT} $CONF{MAINCF} | $CMD{GREP} '^system' | $CMD{AWK} '{print \$2}' | $CMD{SORT}");
	if ($COMM{OS} eq "AIX") {
		$PKGI{$PKGI{$PROD{$UPI}{MAINPKG}}{FILESET}}{EXT} = $PKGI{$PROD{$UPI}{MAINPKG}}{FILESET};
		$PKGI{$PKGI{$PROD{$UPI}{MAINPKG}}{FILESET}}{EXT} =~ s/\.bff//;
	}
	$iv=_plat_sub("get_instpkgvers",$PROD{$UPI}{MAINPKG});
	return "" if ((!$clnm) || (!$lltn) || (!$llts) || (!$mcfs) || (($OPT{INSTALL}) && ($iv eq $COMM{TRAINVERS})));
	@sa=split(/\s+/,$mcfs);
	$dsys=join(" ",@sa);
	$mcfg=_dol("$CMD{CAT} $CONF{MAINCF} | $CMD{GREP} '^group' | $CMD{AWK} '{print \$2}'");
	@ga=split(/\s+/,$mcfg);
	$gl=join(" ",@ga);
	_pl("$PROD{VCS}{ABBR} configuration files exist on this system with the following information:\n", 120, 1071, "$PROD{VCS}{ABBR}");
	_pl("\tCluster Name: $clnm", 120, 1072, "$clnm");
	_pl("\tCluster ID Number: $lltn", 120, 1073, "$lltn");
	_pl("\tSystems: $dsys", 120, 1074, "$dsys");
	_pl("\tService Groups: $gl\n", 120, 1075, "$gl");
	if ($OPT{INSTALL}) {
		_pl("No checks have been made to ensure the validity of the configuration.\n", 120, 1076);
	}
	unshift(@sa,$iv);
	return \@sa;
}

# confirm proper running/non running state before performing 
# configuration via the -configure option.  No return
sub _vcs_comm_check_preconfigstate {
	my(@dr,@pr);
	_title();
	foreach $PKG(@{$PROD{VCS}{PKGS}}) {
		unshift(@pr,@{$PKGI{$PKG}{PROCS}});
		unshift(@dr,@{$PKGI{$PKG}{DRIVERS}});
	}
	foreach $SYS(@SYSI) { 
		_bpl("Checking $PROD{VCS}{ABBR} processes on $SYS:\n", 120, 1077, "$PROD{VCS}{ABBR}", "$SYS");
		_comm_stop_processes(@pr); 
		_comm_unload_drivers(@dr); 
		_p();
	}
	_bpl("$PROD{VCS}{ABBR} processes are stopped", 120, 1078, "$PROD{VCS}{ABBR}");
	_prtc();
}

# display postinstallation information
sub _vcs_comm_completion_messages {
	return if ($OPT{UNINSTALL});
	my($cmd,$ns,$vcs);
	if (defined($FLAG{FUD})) {
		foreach $SYS(@SYSI) {
			if ($FLAG{FUD}{$SYS}) {
				_bpl("Because the $FLAG{FUD}{$SYS} module could not be successfully unloaded, $SYS must be rebooted before starting $PROD{VCS}{NAME}\n", 120, 1079, "$FLAG{FUD}{$SYS}", "$SYS", "$PROD{VCS}{NAME}");
				$FLAG{DIDNOTSTART}=1;
			}
		}
		if ($FLAG{DIDNOTSTART}) {
			_p();
			_bpl("Execute $CMD{SHUTDOWN} to properly restart your systems", 120, 1342, "$CMD{SHUTDOWN}");
		}
	}
	if ($FLAG{DIDNOTSTART}) {
		$ns=$#SYSC+1;
		if ($ns>1) {
			_log("To start LLT issue the command:", 120, 1080);
			_log("\t$CMD{LLTCONFIG} -c", 120, 1081, "$CMD{LLTCONFIG}");
			_log("To start GAB issue the command:", 120, 1082);
			_log("\t$CMD{GABCONFIG} -c -n$ns", 120, 1083, "$CMD{GABCONFIG}", "$ns");
		}
		_log("To start $PROD{VCS}{ABBR} issue the command:", 120, 1084, "$PROD{VCS}{ABBR}");
		_log("\t$PATH{VCSBIN}/hastart\n", 120, 1085, "$PATH{VCSBIN}");
	}
	if ($CFG{CSGVIP}) {
		$vcs = (_vcs_vcsmode() eq "VCSQS") ? "vcsqs" : "vcs";
		_log("The cluster can be managed using Cluster Manager (Web Console) and the URL:", 120, 1086);
		_log("\n\thttp://$CFG{CSGVIP}:8181/$vcs\n", 120, 1087, "$CFG{CSGVIP}", "$vcs");
		if (!$FLAG{UPGRADE}) {
			$cmd = (_vcs_vcsmode() eq "VCSQS") ? "$PATH{QSBIN}/vcsqs" : "$PATH{VCSBIN}/hauser";
			if ($FLAG{SETADMINPWD}) {
				_log("Log on using the User Name: 'admin' and the password entered for that user.\nUse the '$cmd' command to add new users.\n", 120, 1341, "$cmd");
			} else {
				_log("Log on using the User Name: 'admin' and the Password: 'password'.\nUse the '$cmd' command to add new users.\n", 120, 1088, "$cmd");
			}
		}
	}
	if (_vcs_vcsmode() ne "VCSQS") {
		if ($FLAG{UPGRADE}) {
			_log("To manage your clusters using Cluster Manager (Java Console), update the $PROD{VCS}{GUIPKG} $MSG{PDFR} to version $COMM{TRAINVERS} on all systems where it is currently installed.\n", 120, 1089, "$PROD{VCS}{GUIPKG}", "$MSG{PDFR}", "$COMM{TRAINVERS}");
		} else {
			_log("To manage your clusters using Cluster Manager (Java Console) add the $PROD{VCS}{GUIPKG} $MSG{PDFR} to a non-clustered system.\n", 120, 1090, "$PROD{VCS}{GUIPKG}", "$MSG{PDFR}");
		}
	}
	if (_vcs_vcsmode() ne "VCSSFCFS") {
		_log("The GUI modules of VCS use the Java Run Time Environment(1.4) from Sun and require that Solaris patches be installed to function properly. You can find information about these patches and instructions for downloading them at:\n", 120, 1304);
		_log("\thttp://java.sun.com/j2se/1.4.2/download.html\n", 120, 1305);
	}
}

# configure cluster information:
# Cluster name, ID, and heartbeat links
sub _vcs_config_cluster {
	my($ayn,$cid,$cmsg,$cname,$done,$key,$lmsg,$mn,$msg,$nhb,$link,$rhbn);
	$mn=1 if (($#SYSC) || ($UPI eq "SFRAC"));
	while (!$done) {
		$FLAG{BACK}=$COMM{PBACK}="";
		_title();
		if ($mn) {
			if ($UPI eq "VCS") {
				_bpl("To configure VCS the following is required:\n", 120, 1092);
			} else {
				_bpl("To configure VCS for $PROD{$UPI}{ABBR} the following is required:\n", 120, 1324, "$PROD{$UPI}{ABBR}");
			}
			_pl("\tA unique Cluster name", 120, 1093);
			_pl("\tA unique Cluster ID number between 0-255", 120, 1094);
			if ($FLAG{FENCINGENABLED}) {
				_pl("\tOne or more NIC cards per system used for heartbeat links\n", 120, 1325);
			} else {
				_pl("\tTwo or more NIC cards per system used for heartbeat links\n", 120, 1326);
			}
			if ($UPI ne "SFRAC") {
				_pl("\tOne or more heartbeat links are configured as private links", 120, 1327);
				_pl("\tOne heartbeat link may be configured as a low priority link\n", 120, 1328);
			}
			_pl("All systems are being configured to create one cluster\n", 120, 1096);
		} else {
			_bpl("To configure a single-node VCS cluster a unique cluster name is required:\n", 120, 1097);
		}
		$cname=_vcs_ask_clustername($cname);
		if ($mn) {
			$COMM{PBACK}=1;
			$cid=_vcs_ask_clusterid($cid);
			next if ($FLAG{BACK});
			$rhbn=_vcs_ask_hbnics();
			next if ($FLAG{BACK});
			_title();
			_bpl("Cluster information verification:\n", 120, 1098);
			$msg=_tr("\tCluster Name: $cname\n", 120, 1099, "$cname");
			$msg.=_tr("\tCluster ID Number: $cid\n", 120, 1100, "$cid");
			foreach $SYS(@SYSC) {
				$msg.=_tr("\tPrivate Heartbeat NICs for $SYS:", 120, 1233, "$SYS");
				foreach $link(1..4) {
					$key="LLTLINK$link";
					next unless ($$rhbn{$key}{$SYS});
					$nhb=$link;
					$lmsg=_tr("link$link=$$rhbn{$key}{$SYS}", 120, 1102, "$link", "$$rhbn{$key}{$SYS}");
					$msg.="\n\t\t" if ($link==4);
					$msg.=" $lmsg";
				}
				$msg.="\n";
				if ($$rhbn{LLTLINKLOWPRI}{$SYS}) {
					$msg.=_tr("\tLow Priority Heartbeat NIC for $SYS: link-lowpri=$$rhbn{LLTLINKLOWPRI}{$SYS}\n", 120, 1329, "$SYS", "$$rhbn{LLTLINKLOWPRI}{$SYS}");
				}
			}
		} else {
			$msg=_tr("\tCluster Name: $cname\n", 120, 1099, "$cname");
		}
		_pl_notr("$msg");
		$COMM{PBACK}="";
		$ayn=_ayny("Is this information correct?", 120, 1105);
		$done=1 if ($ayn eq "Y");
	}
	if ($mn) {
		$CFG{CLUSTERID}=$cid;
		foreach $SYS(@SYSC) {
			$CFG{LLTLINK1}{$SYS}=$$rhbn{LLTLINK1}{$SYS};
			$CFG{LLTLINK2}{$SYS}=$$rhbn{LLTLINK2}{$SYS};
			$CFG{LLTLINK3}{$SYS}=$$rhbn{LLTLINK3}{$SYS} if ($$rhbn{LLTLINK3}{$SYS});
			$CFG{LLTLINK4}{$SYS}=$$rhbn{LLTLINK4}{$SYS} if ($$rhbn{LLTLINK4}{$SYS});
			$CFG{LLTLINKLOWPRI}{$SYS}=$$rhbn{LLTLINKLOWPRI}{$SYS} if ($$rhbn{LLTLINKLOWPRI}{$SYS});
		}
	}
	$CFG{CLUSTERNAME}=$cname;
	$cmsg=_tr("$PROD{$UPI}{ABBR} Cluster configuration:\n", 120, 1106, "$PROD{$UPI}{ABBR}");
	push(@{$COMM{CONFIGMSG}},$cmsg,$msg);
}

# Configure the Global Cluster Option
# Copies CSGVIP most likely if configured
sub _vcs_config_gcoption {
	return if ((_vcs_vcsmode() eq "VCSTD") || (!$FLAG{GCOPTION}));
	my($ayn,$cmsg,$done,$msg,$netm,$nhip,$nonhip,$rgconic,$vip);
	# check for dr option license, return if not licensed
	push(@{$COMM{PRODUCTIRFKEYS}},qw(GCONIC GCOVIP GCONETMASK));
	while (!$done) {
		$FLAG{BACK}=$COMM{PBACK}="";
		_title();
		_bpl("The following is required to configure the Global Cluster Option:\n", 120, 1216);
		_pl("\tA public NIC used by each system in the cluster", 120, 1108);
		_pl("\tA Virtual IP address and netmask\n", 120, 1109);
		_pl("The Virtual IP address and NIC may be the same as those configured for Cluster Manager (Web Console)", 120, 1330);
		if (($COMM{OS} eq "HP-UX") && (!$CFG{CSGVIP}) && (!$CFG{SMTPSERVER}) && (!$CFG{SNMPPORT})) {
			_pl("\tOne or more NetworkHosts IP addresses for connection checking\n", 120, 1331);
			$nonhip=1;
		} else {
			_pl();
		}
		$ayn=_ayny("Do you want to configure the Global Cluster Option?", 120, 1217);
		return if ($ayn eq "N");
		_p();
		$COMM{PBACK}=1;
		if ($CFG{CSGVIP}) {
			$vip=_vcs_ask_vip($CFG{CSGVIP});
			next if ($FLAG{BACK});
			if ($vip eq $CFG{CSGVIP}) {
				$rgconic=$PROD{VCS}{RCSGNIC};
				$netm=$CFG{CSGNETMASK};
			} else {
				$rgconic=_vcs_ask_publicnic(2);
				next if ($FLAG{BACK});
				$netm=_vcs_ask_netmask($vip,$$rgconic{$SYSC[0]});
				next if ($FLAG{BACK});
			}
		} else {
			$rgconic=_vcs_ask_publicnic(2);
			next if ($FLAG{BACK});
			$vip=_vcs_ask_vip("",1);
			next if ($FLAG{BACK});
			$netm=_vcs_ask_netmask($vip,$$rgconic{$SYSC[0]});
			next if ($FLAG{BACK});
		}
		$nhip=_vcs_hp_ask_nhip() if ($nonhip);
		next if ($FLAG{BACK});
		_title();
		_bpl("Global Cluster Option configuration verification:\n", 120, 1218);
		$msg=_vcs_display_csgnic($rgconic);
		$msg.=_tr("\tIP: $vip\n", 120, 1113, "$vip");
		$msg.=_tr("\tNetmask: $netm\n", 120, 1114, "$netm");
		$msg.=_tr("\tNetworkHosts: $nhip\n", 120, 1332, "$nhip") if ($nhip);
		_pl_notr("$msg");
		if ($vip eq $CFG{CSGVIP}) {
			_pl("Matching Cluster Manager (Web Console) Virtual IP configuration\n", 120, 1115);
		}
		$COMM{PBACK}="";
		$ayn=_ayny("Is this information correct?", 120, 1105);
		$done=1 if ($ayn eq "Y");
	}
	_vcs_store_nic($rgconic,"GCONIC");
	$CFG{GCOVIP}=$vip;
	$CFG{GCONETMASK}=$netm;
	$CFG{NETWORKHOSTS}=$nhip if ($nhip);
	$cmsg=_tr("Global Cluster Option configuration:\n", 120, 1219);
	push(@{$COMM{CONFIGMSG}},$cmsg,$msg);
}

# Configure SMTP Notification:
# A SMTP mail server, recipients, and severity for each
sub _vcs_config_smtp {
	return if ($OPT{INSTALLONLY});
	my(@recps,@sevs,$ayn,$cmsg,$done,$msg,$n,$nhip,$nonhip,$rcsgnic,$recp,$server,$sev);
	while (!$done) {
		$FLAG{BACK}=$COMM{PBACK}="";
		_title();
		undef(@recps);
		undef(@sevs);
		_bpl("The following information is required to configure SMTP notification:\n", 120, 1117);
		_pl("\tThe domain-based hostname of the SMTP server", 120, 1118);
		_pl("\tThe email address of each SMTP recipient", 120, 1119);
		_pl("\tA minimum severity level of messages to send to each recipient", 120, 1333);
		if (($COMM{OS} eq "HP-UX") && (!$CFG{CSGVIP})) {
			_pl("\tOne or more NetworkHosts IP addresses for connection checking\n", 120, 1331);
			$nonhip=1;
		} else {
			_pl();
		}
		$ayn=_ayny("Do you want to configure SMTP notification?", 120, 1121);
		return if ($ayn eq "N");
		_p();
		$COMM{PBACK}=1;
		$rcsgnic=_vcs_ask_publicnic(1);
		next if ($FLAG{BACK});
		$server=_vcs_ask_smtpserver($server);
		next if ($FLAG{BACK});
		while (($#recps<0) || ($ayn eq "Y")) {
			$recp=lc(_vcs_ask_smtprecp());
			last if ($FLAG{BACK});
			$sev=_vcs_ask_severity($recp);
			last if ($FLAG{BACK});
			$n=_list($recp,@recps);
			if ($n<0) {
				push(@recps,$recp);
				push(@sevs,$sev);
			} else {
				_pl("$recp previously entered, changing priority to $sev", 120, 1122, "$recp", "$sev");
				$sevs[$n]=$sev;
			}
			$ayn=_aynn("Would you like to add another SMTP recipient?", 120, 1123);
		}
		next if ($FLAG{BACK});
		$nhip=_vcs_hp_ask_nhip() if ($nonhip);
                next if ($FLAG{BACK});
		_title();
		_bpl("SMTP notification verification:\n", 120, 1124);
		$msg=_vcs_display_csgnic($rcsgnic);
		$msg.=_tr("\tSMTP Address: $server\n", 120, 1125, "$server");
		foreach $n(0..$#recps) { 
			$msg.=_tr("\tRecipient: $recps[$n] receives email for $sevs[$n] or higher events\n", 120, 1126, "$recps[$n]", "$sevs[$n]"); 
		}
		$msg.=_tr("\tNetworkHosts: $nhip\n", 120, 1332, "$nhip") if ($nhip);
		_pl_notr("$msg");
		$COMM{PBACK}="";
		$ayn=_ayny("Is this information correct?", 120, 1105);
		$done=1 if ($ayn eq "Y");
	}
	_vcs_store_nic($rcsgnic,"CSGNIC");
	$CFG{SMTPSERVER}=$server;
	$CFG{NETWORKHOSTS}=$nhip if ($nhip);
	$CFG{SMTPRECP}=[];
	$CFG{SMTPRSEV}=[];
	foreach $n(0..$#recps) { 
		push(@{$CFG{SMTPRECP}},$recps[$n]);
		push(@{$CFG{SMTPRSEV}},$sevs[$n]);
	}
	$cmsg=_tr("SMTP notification configuration:\n", 120, 1127);
	push(@{$COMM{CONFIGMSG}},$cmsg,$msg);
}

# Configure SNMP Notification:
# The SNMP trap port, SNMP consoles, and severity for each
sub _vcs_config_snmp {
	return if ($OPT{INSTALLONLY});
	my(@conss,@sevs,$ayn,$cmsg,$cons,$done,$msg,$n,$nhip,$nonhip,$port,$rcsgnic,$sev);
	while (!$done) {
		$FLAG{BACK}=$COMM{PBACK}="";
		_title();
		undef(@conss);
		undef(@sevs);
		_bpl("The following information is required to configure SNMP notification:\n", 120, 1128);
		_pl("\tSystem names of SNMP consoles to receive VCS trap messages", 120, 1129);
		_pl("\tSNMP trap daemon port numbers for each console", 120, 1130);
		_pl("\tA minimum severity level of messages to send to each console", 120, 1334);
		if (($COMM{OS} eq "HP-UX") && (!$CFG{CSGVIP}) && (!$CFG{SMTPSERVER})) {
			_pl("\tOne or more NetworkHosts IP addresses for connection checking\n", 120, 1331);
			$nonhip=1;
		} else {
			_pl();
		}
		$ayn=_ayny("Do you want to configure SNMP notification?", 120, 1132);
		return if ($ayn eq "N");
		_p();
		$COMM{PBACK}=1;
		$rcsgnic=_vcs_ask_publicnic(1);
		next if ($FLAG{BACK});
		$port=_vcs_ask_snmpport();
		next if ($FLAG{BACK});
		while (($#conss<0) || ($ayn eq "Y")) {
			$cons=lc(_vcs_ask_snmpconsole());
			last if ($FLAG{BACK});
			$sev=_vcs_ask_severity($cons,1);
			last if ($FLAG{BACK});
			$n=_list($cons,@conss);
			if ($n<0) {
				push(@conss,$cons);
				push(@sevs,$sev);
			} else {
				_pl("$cons previously entered, changing priority to $sev", 120, 1122, "$cons", "$sev");
				$sevs[$n]=$sev;
			}
			$ayn=_aynn("Would you like to add another SNMP console?", 120, 1133);
		}
		next if ($FLAG{BACK});
		$nhip=_vcs_hp_ask_nhip() if ($nonhip);
		next if ($FLAG{BACK});
		_title();
		_bpl("SNMP notification verification:\n", 120, 1134);
		$msg=_vcs_display_csgnic($rcsgnic);
		$msg.=_tr("\tSNMP Port: $port\n", 120, 1135, "$port");
		foreach $n(0..$#conss) { 
			$msg.=_tr("\tConsole: $conss[$n] receives SNMP traps for $sevs[$n] or higher events\n", 120, 1136, "$conss[$n]", "$sevs[$n]"); 
		}
		$msg.=_tr("\tNetworkHosts: $nhip\n", 120, 1332, "$nhip") if ($nhip);
		_pl_notr("$msg");
		$COMM{PBACK}="";
		$ayn=_ayny("Is this information correct?", 120, 1105);
		$done=1 if ($ayn eq "Y");
	}
	_vcs_store_nic($rcsgnic,"CSGNIC");
	$CFG{SNMPPORT}=$port;
	$CFG{NETWORKHOSTS}=$nhip if ($nhip);
	$CFG{SNMPCONS}=[];
	$CFG{SNMPCSEV}=[];
	foreach $n(0..$#conss) { 
		push(@{$CFG{SNMPCONS}},$conss[$n]);
		push(@{$CFG{SNMPCSEV}},$sevs[$n]);
	}
	$cmsg=_tr("SMTP notification configuration:\n", 120, 1127);
	push(@{$COMM{CONFIGMSG}},$cmsg,$msg);
}

# Configure the Cluster Service Web GUI
# Public NIC, Virtual IP, and Netmask
sub _vcs_config_webgui {
	return if ($OPT{INSTALLONLY});
	return if (_list("VRTSvcsw",@{$CFG{DONOTINSTALL}})>=0);
	my ($ayn,$cmsg,$done,$msg,$nic,$netm,$nhip,$rcsgnic,$vip);
	while(!$done) {
		$FLAG{BACK}=$COMM{PBACK}="";
		_title();
		_bpl("The following information is required to configure Cluster Manager:\n", 120, 1137);
		_pl("\tA public NIC used by each system in the cluster", 120, 1108);
		_pl("\tA Virtual IP address and netmask for Cluster Manager", 120, 1335);
		if ($COMM{OS} eq "HP-UX") {
			_pl("\tOne or more NetworkHosts IP addresses for connection checking\n", 120, 1331);
		} else {
			_pl();
		}
		if (_vcs_vcsmode() ne "VCSQS") {
			$ayn=_ayny("Do you want to configure Cluster Manager (Web Console)", 120, 1139);
			return if ($ayn eq "N");
		}
		$COMM{PBACK}=1;
		$rcsgnic=_vcs_ask_publicnic();
		next if ($FLAG{BACK});
		$vip=_vcs_ask_vip($vip);
		next if ($FLAG{BACK});
		$netm=_vcs_ask_netmask($vip,$$rcsgnic{$SYSC[0]});
		next if ($FLAG{BACK});
		$nhip=_vcs_hp_ask_nhip() if ($COMM{OS} eq "HP-UX");
		next if ($FLAG{BACK});
		_title();
		_bpl("Cluster Manager (Web Console) verification:\n", 120, 1140);
		$msg=_vcs_display_csgnic($rcsgnic);
		$msg.=_tr("\tIP: $vip\n", 120, 1113, "$vip");
		$msg.=_tr("\tNetmask: $netm\n", 120, 1114, "$netm");
		$msg.=_tr("\tNetworkHosts: $nhip\n", 120, 1332, "$nhip") if ($nhip);
		_pl_notr("$msg");
		$COMM{PBACK}="";
		$ayn=_ayny("Is this information correct?", 120, 1105);
		$done=1 if ($ayn eq "Y");
	}
	_vcs_store_nic($rcsgnic,"CSGNIC");
	$CFG{CSGVIP}=$vip;
	$CFG{CSGNETMASK}=$netm;
	$CFG{NETWORKHOSTS}=$nhip if ($nhip);
	$cmsg=_tr("Cluster Manager (Web Console) configuration:\n", 120, 1141);
	push(@{$COMM{CONFIGMSG}},$cmsg,$msg);
}

# create an /etc/llttab entry for a NIC
sub _vcs_convert_nic2lltlink {
	my($dev,$l,$lowpri,$lp,$n,$nic);
	($nic,$lp)=(@_);
	return "" if (!$nic);
	$lowpri="-lowpri" if ($lp);
	$dev = ($COMM{OS} eq "AIX") ? "/dev/dlpi" : "/dev";
	$l=$n=$nic;
	$l=~s/[0-9]//g;
	$n=~s/[A-Za-z]//g;
	if ($COMM{OS} eq "Linux")
        {
                return "link$lowpri $nic $nic - ether - -\n";
        }
	return "link$lowpri $nic $dev/$l:$n - ether - -\n";
}

# create configuration files from %CFG values
sub _vcs_comm_create_configfiles {
	my(%llttab,$admins,$app,$cdev,$clad,$cons,$csl,$ddev,$drid,$drnd,$gabtab,$j,$llthosts,$maincf,$n,$nhip,$opers,$recp,$sys,$users,$v);
	_pb1("Creating $PROD{VCS}{NAME} configuration files", 120, 1142, "$PROD{VCS}{NAME}");
	for $SYS(@SYSC) {
		$csl.=", " if ($csl);
		($sys,$j)=split(/\./,$SYS,2);
		$csl.=$sys;
	}
	$n=$#SYSC+1;
	$gabtab = "$CMD{GABCONFIG} -c -n$n";
	$clad = ($CFG{GCOVIP}) ? "\tClusterAddress = \"$CFG{GCOVIP}\"\n" : ($CFG{CSGVIP}) ? "\tClusterAddress = \"$CFG{CSGVIP}\"\n" : "";
	$maincf="include \"types.cf\"\n";
	if ($COMM{OS} eq "Linux") {
        	$SYS=$SYSI[0];
		my $apache=_dor("$CMD{RPM} -qa | $CMD{GREP} -w VRTSvcsApache");
		if ($apache) {
			$maincf.="include \"vcsApacheTypes.cf\"\n";
		}
	}
	$maincf.="include \"OracleTypes.cf\"\n" if ((_vcs_vcsmode() eq "VCSRAC") || ($FLAG{QSORACLE}));
	$maincf.="\ncluster $CFG{CLUSTERNAME} (";
	foreach $n(0..$#{$CFG{USERNAME}}) {
		$users.=", " if ($users);
		$users.="${$CFG{USERNAME}}[$n] = ${$CFG{USERENPW}}[$n]";
		if (${$CFG{USERPRIV}}[$n] eq "Administrators") {
			$admins.=", " if ($admins);
			$admins.="${$CFG{USERNAME}}[$n]";
		} elsif (${$CFG{USERPRIV}}[$n] eq "Operators") {
			$opers.=", " if ($opers);
			$opers.="${$CFG{USERNAME}}[$n]";
		}
	}
	$maincf .= "\n\tUserNames = { $users }";
	$maincf .= "\n\tAdministrators = { $admins }" if ($admins);
	$maincf .= "\n\tOperators = { $opers }" if ($opers);
	$maincf .= "\n\tCounterInterval = 5\n$clad\t)\n\n";
	$n=0;
	foreach $SYS(@SYSC) {
		($sys,$j)=split(/\./,$SYS,2);
		$llthosts.="$n $sys\n";
		$llttab{$SYS}="set-node $sys\nset-cluster $CFG{CLUSTERID}\n";
		$llttab{$SYS}.=_vcs_convert_nic2lltlink($CFG{LLTLINK1}{$SYS});
		$llttab{$SYS}.=_vcs_convert_nic2lltlink($CFG{LLTLINK2}{$SYS});
		$llttab{$SYS}.=_vcs_convert_nic2lltlink($CFG{LLTLINK3}{$SYS});
		$llttab{$SYS}.=_vcs_convert_nic2lltlink($CFG{LLTLINK4}{$SYS});
		$llttab{$SYS}.=_vcs_convert_nic2lltlink($CFG{LLTLINKLOWPRI}{$SYS},1);
		$maincf.="system $sys (\n\t)\n\n";
		$n++;
	}
	$cdev="\t\tDevice = $CFG{CSGNIC}{ALL}\n" if ($CFG{CSGNIC}{ALL});
	if ($CFG{CSGNIC}{$SYSC[0]}) {
		foreach $SYS(@SYSC) { 
			($sys,$j)=split(/\./,$SYS,2);
			$cdev.="\t\tDevice\@$sys = $CFG{CSGNIC}{$SYS}\n";
		}
	}
	$ddev="\t\tDevice = $CFG{GCONIC}{ALL}\n" if ($CFG{GCONIC}{ALL});
	if ($CFG{GCONIC}{$SYSC[0]}) {
		foreach $SYS(@SYSC) { 
			($sys,$j)=split(/\./,$SYS,2);
			$ddev.="\t\tDevice\@$sys = $CFG{GCONIC}{$SYS}\n";
		}
	}
	$maincf.="group ClusterService (\n\tSystemList = { $csl }\n\tAutoStartList = { $csl }\n\tOnlineRetryLimit = 3\n\tOnlineRetryInterval = 120\n\t)\n\n" if (($cdev) || ($ddev));
	$maincf .= "\tApplication wac (\n\t\tStartProgram = \"/opt/VRTSvcs/bin/wacstart\"\n\t\tStopProgram = \"/opt/VRTSvcs/bin/wacstop\"\n\t\tMonitorProcesses = { \"/opt/VRTSvcs/bin/wac\" }\n\t\tRestartLimit = 3\n\t\t)\n\n" if ($CFG{GCOVIP});
	$maincf .= "\tIP webip (\n$cdev\t\tAddress = \"$CFG{CSGVIP}\"\n\t\tNetMask = \"$CFG{CSGNETMASK}\"\n\t\t)\n\n" if ($CFG{CSGVIP});
	if (($CFG{GCOVIP}) && ($CFG{GCOVIP} ne $CFG{CSGVIP})) {
		$maincf .= "\tIP gcoip (\n$ddev\t\tAddress = \"$CFG{GCOVIP}\"\n\t\tNetMask = \"$CFG{GCONETMASK}\"\n\t\t)\n\n";
		$drid="gcoip";
	} else {
		$drid="webip";
	}
	if ($cdev) {
		if ($COMM{OS} eq "HP-UX") {
			$nhip=_vcs_hp_store_nhip($CFG{NETWORKHOSTS});
			$maincf .= "\tNIC csgnic (\n$cdev\t\tNetworkHosts = {\"$nhip\"}\n\t\t)\n\n";
		} else {
			$maincf .= "\tNIC csgnic (\n$cdev\t\t)\n\n";
		}
	}
	if ($ddev) {
		if ($ddev ne $cdev) {
			if ($COMM{OS} eq "HP-UX") {
				$nhip=_vcs_hp_store_nhip($CFG{NETWORKHOSTS});
				$maincf .= "\tNIC gconic (\n$ddev\t\tNetworkHosts = {\"$nhip\"}\n\t\t)\n\n";
			} else {
				$maincf .= "\tNIC gconic (\n$ddev\t\t)\n\n";
			}
			$drnd="gconic";
		} else {
			$drnd="csgnic";
		}
	}
	$maincf .= "\tNotifierMngr ntfr (\n" if (($CFG{SMTPSERVER}) || ($CFG{SNMPPORT}));
	if ($CFG{SNMPPORT}) {
		foreach $n(0..$#{$CFG{SNMPCONS}}) {
			$cons.=", " if ($cons);
			$cons.="\"${$CFG{SNMPCONS}}[$n]\" = ${$CFG{SNMPCSEV}}[$n]";
		}
		$maincf.="\t\tSnmpConsoles = { $cons }\n";
		$maincf.="\t\tSnmpdTrapPort = $CFG{SNMPPORT}\n" if ($CFG{SNMPPORT}!=162);
	}
	if ($CFG{SMTPSERVER}) {
		foreach $n(0..$#{$CFG{SMTPRECP}}) {
			$recp.=", " if ($recp);
			$recp.="\"${$CFG{SMTPRECP}}[$n]\" = ${$CFG{SMTPRSEV}}[$n]";
		}
		$maincf .= "\t\tSmtpServer = \"$CFG{SMTPSERVER}\"\n\t\tSmtpRecipients ={ $recp }\n";
	}
	$maincf .= "\t\t)\n\n" if (($CFG{SMTPSERVER}) || ($CFG{SNMPPORT}));
	$app = (_vcs_vcsmode() eq "VCSQS") ? "vcsqs" : "vcs";
	$maincf.="\tVRTSWebApp VCSweb (\n\t\tCritical = 0\n\t\tAppName = \"$app\"\n\t\tInstallDir = \"/opt/VRTSweb/VERITAS\"\n\t\tTimeForOnline = 5\n\t\tRestartLimit = 3\n\t\t)\n\n\tVCSweb requires webip\n\twebip requires csgnic\n" if ($CFG{CSGVIP});
	$maincf .= "\tntfr requires csgnic\n" if (($cdev) && (($CFG{SNMPPORT}) || ($CFG{SMTPSERVER})));
	$maincf .= "\twac requires $drid\n" if ($CFG{GCOVIP});
	$maincf .= "\t$drid requires $drnd\n" if ($drnd);
	_writef($llthosts,"$PATH{ITD}/llthosts") if ($#SYSC);
	_writef($gabtab,"$PATH{ITD}/gabtab") if ($#SYSC);
	_writef($maincf,"$PATH{ITD}/main.cf");
	_writef("/sbin/vcsmmconfig -c &","$PATH{ITD}/vcsmmtab") if (_vcs_vcsmode() eq "VCSRAC");
	_pb2("Done", 120, 1143);
	foreach $SYS(@SYSI) {
		_pb1("Copying configuration files to $SYS", 120, 1144, "$SYS");
		_writef("$SYS","$PATH{ITD}/sysname.$SYS");
		_copy("$PATH{ITD}/sysname.$SYS","$PATH{CONF}/sysname");
		_copywbu("$PATH{ITD}/main.cf",$CONF{MAINCF});
		if ($#SYSC) {
			_writef($llttab{$SYS},"$PATH{ITD}/llttab.$SYS");
			_copywbu("$PATH{ITD}/llttab.$SYS",$CONF{LLTTAB});
			_copywbu("$PATH{ITD}/llthosts",$CONF{LLTHOSTS});
			_copywbu("$PATH{ITD}/gabtab",$CONF{GABTAB});
		} else {
			if ($COMM{OS} eq "SunOS") {
				_dol("$CMD{MV} $CMD{START}{llt} /etc/rc2.d/X70llt");
				_dol("$CMD{MV} $CMD{START}{gab} /etc/rc2.d/X92gab");
			} elsif ($COMM{OS} eq "AIX") {
				_dol("$CMD{MV} $CMD{START}{llt} /etc/rc.d/rc2.d/X70llt");
				_dol("$CMD{MV} $CMD{START}{gab} /etc/rc.d/rc2.d/X92gab");
			} elsif ($COMM{OS} eq "Linux") {
				# Bhagyashree add your code here
			} elsif ($COMM{OS} eq "HP-UX") {
				_dol("$CMD{MV} $CMD{START}{llt} /sbin/rc2.d/X680llt");
				_dol("$CMD{MV} $CMD{START}{gab} /sbin/rc2.d/X920gab");
			} 
			_dol("$CMD{MV} $CONF{LLTTAB} $CONF{LLTTAB}.prev");
			_dol("$CMD{MV} $CONF{LLTHOSTS} $CONF{LLTHOSTS}.prev");
			_dol("$CMD{MV} $CONF{GABTAB} $CONF{GABTAB}.prev");
		}
		if (!$FLAG{UPGRADE}) {
			_dor("$CMD{CP} $PATH{CONF}/types.cf $CONF{TYPESCF}");
			_dor("$CMD{CP} $PATH{CONF}/types.cf $CONF{TYPESCF}$COMM{BUCF}");
			_dor("$CMD{CP} $PATH{CONF}/OracleTypes.cf $PATH{CONFIG}") if ((_vcs_vcsmode() eq "VCSRAC") || ($FLAG{QSORACLE}));
			_dor("$CMD{CP} $PATH{CONF}/OracleTypes.cf $PATH{CONFIG}/OracleTypes.cf$COMM{BUCF}") if ($FLAG{QSORACLE});
			_dor("$CMD{CP} $PATH{VCSBIN}/sample_triggers/preonline_ipc $PATH{VCSBIN}/triggers/preonline") if (_vcs_vcsmode() eq "VCSQS");
		}
		_copy("$PATH{ITD}/vcsmmtab","/etc/vcsmmtab") if (_vcs_vcsmode() eq "VCSRAC");
		_dor("$CMD{RMR} $PATH{CONFIG}/.stale");
		_pb2("Done", 120, 1143);
		_aix_update_pseconf() if ($COMM{OS} eq "AIX");
	}
}

# returns a commented definition of a install reqponsefile key for each key
# there are two calls.  _comm_define_cfgkey starts the definition
# creating the variable and defining its required/optional status,
# scalar/list status, and second dimension, if it is a 2d variable
# The second call to _tr defines what the variable is used for within
# the CPI libraries
sub _vcs_comm_define_cfgkeys {
	my($cmt,$key);
	($key)=(@_);
	if ($key eq "CLUSTERNAME") {
		$cmt=_comm_define_cfgkey($key,1);
		$cmt.=_tr("This variable defines the name of the cluster.", 120, 1145);
	} elsif ($key eq "CLUSTERID") {
		$cmt=_comm_define_cfgkey($key,1);
		$cmt.=_tr("This variable must be an integer between 0 and 255 which uniquely identifies the cluster.", 120, 1146);
	} elsif ($key eq "LLTLINK#") {
		$cmt=_comm_define_cfgkey($key,1,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the NIC to be used for a private heartbeat link on each system.  Two LLT links are required per system (LLTLINK1 and LLTLINK2).  Up to four LLT links can be configured.", 120, 1147);
	} elsif ($key eq "LLTLINKLOWPRI") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines a low priority heartbeat link.  Typically, LLTLINKLOWPRI is used on a public network link to provide an additional layer of communication.", 120, 1148);
	} elsif ($key eq "CSGNIC") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the NIC for Cluster Manager (Web Console) to use on a system.  'ALL' can be entered as a system value if the same NIC is used on all systems.", 120, 1149);
	} elsif ($key eq "CSGVIP") {
		$cmt=_comm_define_cfgkey($key);
		$cmt.=_tr("This variable defines the virtual IP address to be used by the Cluster Manager (Web Console).", 120, 1150);
	} elsif ($key eq "CSGNETMASK") {
		$cmt=_comm_define_cfgkey($key);
		$cmt.=_tr("This variable defines the Netmask of the virtual IP address to be used by the Cluster Manager (Web Console).", 120, 1151);
	} elsif ($key eq "SMTPSERVER") {
		$cmt=_comm_define_cfgkey($key);
		$cmt.=_tr("This variable defines the domain-based hostname (example: smtp.yourcompany.com) of the SMTP server to be used for web notification.", 120, 1152);
	} elsif ($key eq "SMTPRECP") {
		$cmt=_comm_define_cfgkey($key,0,1);
		$cmt.=_tr("This variable defines a list of full email addresses (example: user$MSG{AT}yourcompany.com) of SMTP recipients.", 120, 1153, "$MSG{AT}");
	} elsif ($key eq "SMTPRSEV") {
		$cmt=_comm_define_cfgkey($key);
		$cmt.=_tr("This variable defines the minimum severity level of messages (Information, Warning, Error, SevereError) that listed SMTP recipients are to receive.", 120, 1154);
	} elsif ($key eq "SNMPPORT") {
		$cmt=_comm_define_cfgkey($key);
		$cmt.=_tr("This variable defines the SNMP trap daemon port (default=162).", 120, 1155);
	} elsif ($key eq "SNMPCONS") {
		$cmt=_comm_define_cfgkey($key,0,1);
		$cmt.=_tr("This variable defines a list of SNMP console system names.", 120, 1156);
	} elsif ($key eq "SNMPCSEV") {
		$cmt=_comm_define_cfgkey($key);
		$cmt.=_tr("This variable defines the minimum severity level of messages (Information, Warning, Error, SevereError) that listed SNMP consoles are to receive.", 120, 1157);
	} elsif ($key eq "GCONIC") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the NIC for the Virtual IP used for the Global Cluister Option.  'ALL' can be entered as a system value if the same NIC is used on all systems.", 120, 1220);
	} elsif ($key eq "GCOVIP") {
		$cmt=_comm_define_cfgkey($key);
		$cmt.=_tr("This variable defines the virtual IP address to be used by the Global Cluster Option.", 120, 1221);
	} elsif ($key eq "GCONETMASK") {
		$cmt=_comm_define_cfgkey($key);
		$cmt.=_tr("This variable defines the Netmask of the virtual IP address to be used by the Global Cluster Option).", 120, 1222);
	} elsif ($key eq "USERNAME") {
		$cmt=_comm_define_cfgkey($key,0,1);
		$cmt.=_tr("This variable defines a list of VCS usernames.", 120, 1338);
	} elsif ($key eq "USERPRIV") {
		$cmt=_comm_define_cfgkey($key,0,1);
		$cmt.=_tr("This variable defines each user's VCS privileges.", 120, 1339);
	} elsif ($key eq "USERENPW") {
		$cmt=_comm_define_cfgkey($key,0,1);
		$cmt.=_tr("This variable defines an encrypted password for each VCS user.  This encrypted password must be determined by entering the password during a previous installation of VCS $COMM{TRAINVERS}.", 120, 1340, "$COMM{TRAINVERS}");
	} 
	$cmt.="\n\n";
	$cmt=~s/\n/\n# /g;
	return "$cmt";
}

# define packages and patches for the installation
# return a reference to a list
sub _vcs_comm_define_pkgs {
	my($mode,$pkgs);
	$mode=_vcs_vcsmode();
	$pkgs = (($mode eq "VCSSFCFS") || ($mode eq "VCSTD")) ? $PROD{$mode}{PKGS} : $PROD{VCS}{PKGS};
	return $pkgs;
}

# display csgnic information for confirmation
sub _vcs_display_csgnic {
	my($nmsg,$rcsgnic);
	my($rcsgnic)=(@_);
	return "" if (!$rcsgnic);
	if (_hats($rcsgnic)) {
		$nmsg.=_tr("\tNIC: $$rcsgnic{$SYSC[0]}\n", 120, 1161, "$$rcsgnic{$SYSC[0]}");
	} else {
		foreach $SYS(@SYSC) {
			$nmsg.=_tr("\tNIC ($SYS): $$rcsgnic{$SYS}\n", 120, 1162, "$SYS", "$$rcsgnic{$SYS}");
		}
	}
	return "$nmsg";
}

# freeze groups before shutdown pre-upgrade
sub _vcs_freeze_groups {
	my(@f,$grp);
	$grp=_dor("$PATH{VCSBIN}/hagrp -list Frozen=0 | $CMD{AWK} '{print \$1}' | $CMD{UNIQ}");
	@f=split(/\s+/,$grp);
	foreach $grp(@f) {
		_pb1("Freezing group $grp", 120, 1163, "$grp");
		_dor("$PATH{VCSBIN}/hagrp -freeze $grp -persistent");
		_pb2("Done", 120, 1143);
	}
}

sub _vcs_comm_get_mode {
	my($rk)=(@_);
	_log("$SYS Key Mode=$$rk{Mode}", 120, 1164, "$SYS", "$$rk{Mode}");
	$FLAG{GCOPTION}=1 if ($$rk{"Global Cluster Option"} eq "Enabled");
	return "VCSQS" if ($$rk{Mode} =~ /QS/);
	return "VCSRAC" if ($$rk{Mode} =~ /(RAC|OPS)/);
	return "VCSTD" if ($$rk{Mode} =~ /TRAFFIC_DIRECTOR/);
	return "VCSSN" if ($$rk{Mode} =~ /SINGLE_NODE/);
	return "VCSSFCFS" if ($$rk{Mode} =~ /CFS/);
	return "VCS";
}

# make the config file read only and dump the changes
sub _vcs_haconf_dumpmakero {
	my $do=_dor("$PATH{VCSBIN}/haclus -value ReadOnly");
	_dor("$PATH{VCSBIN}/haconf -dump -makero") if ($do==0);
	sleep(3);
}

# make the config file read/write
sub _vcs_haconf_makerw {
	my $do=_dor("$PATH{VCSBIN}/haclus -value ReadOnly");
	if ($do==1) {
		_dor("$PATH{VCSBIN}/haconf -makerw");
		sleep 3;
	}
}

sub _vcs_comm_is_prodkey {
	my ($rk)=(@_);
	return "1" if (($$rk{UPI} eq "VCS") && ($$rk{Mode}!~/None/i));
	return "";
}

sub _vcs_comm_postinstall {
	_prod_plat_sub("VCS","update_config");
	_prod_plat_sub("VCS","delete_pre20maincfentities");
	_prod_plat_sub("VCS","qstovcs_cfupdate");
}

sub _vcs_comm_poststart {
	_vcs_upgrade_poststart() if ($FLAG{UPGRADE});
}

# display preinstallation messages and confirmations
sub _vcs_comm_preinstall_messages {
	if (_vcs_vcsmode() eq "VCSRAC") {
		_pl("Before $PROD{VCSRAC}{NAME} is installed, be sure you have reviewed the VERITAS Storage Foundation 4.0 for Oracle RAC Installation and Configuration Guide\n", 120, 1300, "$PROD{VCSRAC}{NAME}");
	}
}

# config routine if there are no dependencies on installed components
sub _vcs_comm_preinstall_questions {
	push(@{$COMM{PRODUCTIRFKEYS}},qw(CLUSTERNAME CLUSTERID LLTLINK# LLTLINKLOWPRI));
	_vcs_config_cluster();
	return if (_vcs_vcsmode() eq "VCSSFCFS");
	push(@{$COMM{PRODUCTIRFKEYS}},qw(CSGNIC CSGVIP CSGNETMASK SMTPSERVER SMTPRECP SMTPRSEV SNMPPORT SNMPCONS SNMPCSEV));
	_vcs_add_users();
	_vcs_config_webgui();
	_vcs_config_smtp();
	_vcs_config_snmp();
	_vcs_config_gcoption();
}

sub _vcs_comm_prestop {
	_vcs_upgrade_prestop() if ($FLAG{UPGRADE});
}

sub _vcs_comm_singlesystem_areyousure {
	$MSG{HELP}=_tr("Typically $PROD{$UPI}{ABBR} is installed and configured in clusters that have two or more systems.  The -installonly option can be used to install $PROD{$UPI}{ABBR} on a system which is going to be added to another cluster.", 120, 1166, "$PROD{$UPI}{ABBR}", "$PROD{$UPI}{ABBR}");
	_p();
	my $ayn=_aynn("Are you sure you want to install a single node cluster?", 120, 1167);
	return 1 if ($ayn eq "N");
	return "";
}

# start the product, return 1 if product does not start
sub _vcs_comm_start_product {
	my($do,$nr,$rc);
	_bpl("Starting $PROD{_vcs_vcsmode()}{NAME}:\n", 120, 1168, "$PROD{_vcs_vcsmode()}{NAME}");
	if ($#SYSC) {
		foreach $SYS(@SYSI) {
			_pb1("Starting LLT on $SYS", 120, 1169, "$SYS");
			_dor("$CMD{START}{llt} start");
			sleep 1;
			$do=_dor("$CMD{LLTCONFIG}");
			if ($do ne "LLT is running") {
				_pb2("Error", 120, 1170);
				_die("Could not start LLT on $SYS: $do\n", 120, 1171, "$SYS", "$do");
			}
			_pb2("Started", 120, 1172);
		}
		foreach $SYS(@SYSI) {
			_pb1("Starting GAB on $SYS", 120, 1173, "$SYS");
			_dor("$CMD{START}{gab} start");
			sleep 1;
			$do=_dor("$CMD{GABCONFIG} -l | $CMD{GREP} 'Driver.state' | $CMD{GREP} Configured");
			if (!$do) {
				_pb2("Error", 120, 1170);
				_die("Could not start GAB on $SYS: $do\n", 120, 1174, "$SYS", "$do");
			}
			_pb2("Started", 120, 1172);
		}
	}
	_prod_plat_sub("VCS","start_product");
	foreach $SYS(@SYSI) {
		_pb1("Starting Cluster Server on $SYS", 120, 1265, "$SYS");
		_dor("$CMD{RMR} $PATH{CONFIG}/.stale");
		_dor("$CMD{START}{vcs} start");
		_pb2("Started", 120, 1172);
		#
		# this block should be moved into SFRAC.pl
		#
		if (_vcs_vcsmode() eq "VCSRAC") {
			_pb1("Checking $PROD{_vcs_vcsmode()}{NAME} drivers on $SYS", 120, 1266, "$PROD{_vcs_vcsmode()}{NAME}", "$SYS");
			# We just check for the existence of binaries  
			$do=_dor("$CMD{LS} $CMD{LMXCONFIG} 2>/dev/null"); 
			if (!$do) {
				_pb2("Error", 120, 1170);
				_die("Could not find LMX on $SYS\n", 120, 1267, "$SYS");
			}

			# We just check for the existence of binaries  
			$do=_dor("$CMD{LS} $CMD{VCSMMCONFIG} 2>/dev/null"); 
			if (!$do) {
				_pb2("Error", 120, 1170);
				_die("Could not find VCSMM on $SYS\n", 120, 1268, "$SYS");
			}
			_pb2("Checked", 120, 1269);

			_pb1("Starting $PROD{_vcs_vcsmode()}{NAME} drivers on $SYS", 120, 1270, "$PROD{_vcs_vcsmode()}{NAME}", "$SYS");
			#
			# this block should be moved into a _prod_plat_sub
			#
			if ($COMM{OS} eq "Linux") {
				_dor("$CMD{START}{lxvcsmm} ");
				_dor("$CMD{START}{lxlmx} ");
				_dor("$CMD{START}{vxgms}");
				_dor("$CMD{START}{vxodm}");
			} elsif ($COMM{OS} eq "AIX") {
				_dor("$CMD{START}{vcsmm} ");
				_dor("$CMD{START}{lmx} ");
				_dor("$CMD{START}{odm}");
				_dor("$CMD{START}{vxgms}");
			} else {
				# Solaris and ? #
				_dor("$CMD{START}{vcsmm} ");
				_dor("$CMD{START}{lmx} ");
			}
			$do=_plat_sub("check_driver", "lmx");
			if (!$do) {
				_pb2("Error", 120, 1170);
				_die("Could not start LMX on $SYS: $do\n", 120, 1271, "$SYS", "$do");
			}
			$do=_plat_sub("check_driver", "vcsmm");
			if (!$do) {
				_pb2("Error", 120, 1170);
				_die("Could not start VCSMM on $SYS: $do\n", 120, 1272, "$SYS", "$do");
			}
			_pb2("Started", 120, 1172);
		}
	}
	$SYS=$SYSI[0];
	_pb1("Confirming $PROD{_vcs_vcsmode()}{NAME} startup", 120, 1177, "$PROD{_vcs_vcsmode()}{NAME}");
	while (($rc<=10) && ($nr<=$#SYSC)) {
		sleep 3;
		$nr=_dor("$PATH{VCSBIN}/hasys -state | $CMD{GREP} RUNNING | $CMD{WC} -l");
		$rc++;
	}
	# so all systems have same main.cf
	_vcs_haconf_makerw();
	sleep 1;
	_vcs_haconf_dumpmakero();
	if (($nr==0) || ($#SYSI)) {
		_pb2("$nr systems RUNNING", 120, 1178, "$nr");
	} else {
		_pb2("$SYSI[0] RUNNING", 120, 1223, "$SYSI[0]");
	}
	if ($rc>10) {
		# Create list of systems not running
		$nr=_dor("$PATH{VCSBIN}/hasys -state");
		if ($FLAG{UPGRADE}) {
			_pl("\nService groups must be unfrozen once $PROD{VCS}{NAME} is started.\n", 120, 1179, "$PROD{VCS}{NAME}");
		}
		return "1" 
	}
	return "";
}

# store a selected NIC in a hash
sub _vcs_store_nic {
	my($rnic,$key)=(@_);
	return if (!$rnic);
	if (_hats($rnic)) {
		$CFG{$key}{ALL}=$$rnic{$SYSC[0]};
	} else {
		foreach $SYS(@SYSC) { $CFG{$key}{$SYS}=$$rnic{$SYS}; }
	}
	$PROD{VCS}{"R$key"}=$rnic;
}

# Unfreeze groups after an upgrade startup
sub _vcs_unfreeze_groups {
	my (@f,$grp);
	$grp=_dor("$PATH{VCSBIN}/hagrp -list Frozen=1 | $CMD{AWK} '{print \$1}' | $CMD{UNIQ}");
	@f=split(/\s+/,$grp);
	foreach $grp(@f) {
		_pb1("Unfreezing $grp", 120, 1180, "$grp");
		_dor("$PATH{VCSBIN}/hagrp -unfreeze $grp -persistent");
		sleep 1;
		_pb2("Done", 120, 1143);
	}
}

# modify the fsct option value for mount resources
# when upgrading from pre v3.5 to v3.5/post v3.5
sub _vcs_update_fsckopt {
	my(@r,$aast,$ats,$ayn,$f,$fo,$mr,$n,$pe,$j,$sys);
	_pb1("Checking Mount resources", 120, 1181);
	$mr=_dor("$PATH{VCSBIN}/hares -list Type=Mount | $CMD{AWK} '{print \$1}' | $CMD{UNIQ}");
	if (!$mr) {
		_pb2("no mount resources", 120, 1182);
		return;
	}
	@r=split(/\s+/,$mr);
	$n=$#r+1;
	foreach $mr(@r) {
		($sys,$j)=split(/\./,$SYSI[0],2);
		$f=_dor("$PATH{VCSBIN}/hares -value $mr FsckOpt $sys");	
		unless ($f =~ /-[ny]/) {
			if (!$pe) {
				$pe=1;
				_pb2("$n mount resources found", 120, 1183, "$n");
				_bpl("\nA -y or -n argument within the FsckOpt attribute is now required for all $PROD{VCS}{ABBR} $COMM{TRAINVERS} Mount resources.\n", 120, 1184, "$PROD{VCS}{ABBR}", "$COMM{TRAINVERS}");
				_pl("A -y argument assumes a yes response to all questions asked by fsck and opens the file system for writing following successful fsck completion.\n", 120, 1185);
				_pl("A -n argument assumes a no response to all questions asked by fsck and does not open the file system for writing.\n", 120, 1186);
				_pl("$PROD{VCS}{ABBR} $COMM{TRAINVERS} Mount Resources will not enter the ONLINE state unless the FsckOpt attribute is properly set.\n", 120, 1187, "$PROD{VCS}{ABBR}", "$COMM{TRAINVERS}");
				_pl("Refer to 'man fsck' or the VCS Bundled Agents Reference Guide for more information.\n", 120, 1188);
			}
			if (!$ats) {
				$ayn=_ayny("Enter Y to use -y as an FsckOpt setting for Mount $mr Enter N to use -n as an FsckOpt setting for Mount $mr:", 120, 1234, "$mr", "$mr");
				$fo = ($ayn eq "Y") ? "-y" : "-n";
			} 
			_dor("$PATH{VCSBIN}/hares -modify $mr FsckOpt \"%$fo $f\"");
			if (!$aast) {
				$aast=1;
				$ayn=_ayny("Would you like to use $fo as the FsckOpt argument for all undeclared mounts?", 120, 1190, "$fo");
				$ats=$fo if ($ayn eq "Y");
			}
		}
	}
	if (!$pe) {
		_pb2("FsckOpt argument configured", 120, 1191);
	}
}

# perform upgrade tasks necessary after the product is started
sub _vcs_upgrade_poststart {
	my($j,$sys);
	_vcs_haconf_makerw();
	# final sun upgrade config step that won't work with 3.5 
	# as it doesn't understand -temp option
	_dor("$PATH{VCSBIN}/haattr -add -temp DiskGroup tempUseFence -string INVALID") if (($COMM{OS} eq "SunOS") && ($COMM{UGVERS}{$SYS}<=3.5));
	_vcs_unfreeze_groups();
	_vcs_gcm_upgrade_poststart() if ($FLAG{GCMU});
	_pb1("Onlining ClusterService Group on $SYS", 120, 1192, "$SYS");
	($sys,$j)=split(/\./,$SYS,2);
	_dor("$PATH{VCSBIN}/hagrp -online ClusterService -sys $sys");
	_pb2("Done", 120, 1143);
	$CFG{CSGVIP}=_dor("$PATH{VCSBIN}/hares -value webip Address") if (!$CFG{CSGVIP});
	_vcs_haconf_dumpmakero();
}

# perform upgrade tasks necessary before the product is stopped
sub _vcs_upgrade_prestop {
	my ($ayn,$pid);
	return unless ($SYS eq $SYSI[0]);
	return unless ($FLAG{PKGUPGRADE}{VRTSvcs}{$SYS});
	$pid=_comm_get_pid("bin/had");
	if (!$pid) {
		$MSG{HELP}=_tr("At this time the $PROD{VCS}{NAME} configuration must be updated to version $COMM{TRAINVERS}.  The configuration update is done automatically by this program.  Do not continue to upgrade the system unless at least one system in the cluster has had its configuration upgraded to version $COMM{TRAINVERS}.", 120, 1235, "$PROD{VCS}{NAME}", "$COMM{TRAINVERS}", "$COMM{TRAINVERS}");
		_pl("\nUpgrading $PROD{VCS}{NAME} must be started on a running system to properly upgrade the configuration.  Upgrading a system that is not running $PROD{VCS}{NAME} will succeed only if you have previously started the upgrade on another system which was running at the time.\n", 120, 1193, "$PROD{VCS}{NAME}", "$PROD{VCS}{NAME}");
		$ayn=_aynn("Do you want to continue?", 120, 1194);
	} else {
		_pl("\n$COMM{PROG} must now make configuration updates and stop the cluster before upgrading $PROD{VCS}{ABBR} $MSG{PDFRS}\n", 120, 1195, "$COMM{PROG}", "$PROD{VCS}{ABBR}", "$MSG{PDFRS}");
		$ayn=_ayny("Are you ready to begin the $PROD{VCS}{NAME} upgrade at this time?", 120, 1196, "$PROD{VCS}{NAME}");
	}
	_comm_cleanup(0) if ($ayn eq "N");
	return if (!$pid);
	_p();
	$SYS=$SYSI[0];
	$FLAG{NULLIFYVERROR}=1;
	_vcs_haconf_makerw();
	_vcs_update_user_password();
	_vcs_gcm_upgrade_prestop();
	_vcs_freeze_groups();
	_vcs_update_fsckopt() if ($COMM{UGVERS}{$SYS}<3.5);
	_prod_plat_sub("VCS","delete_20VRTSwebres");
	_prod_plat_sub("VCS","update_typescf");
	_prod_plat_sub("VCS","update_20csgto35");
	_vcs_haconf_dumpmakero();
	if ($COMM{OS} eq "Linux")
	{
		_dor("$CMD{CP} $CONF{MAINCF} $CONF{MAINCF}.NEW");
	}
	$FLAG{NULLIFYVERROR}="";
}

# return the VCS mode based on edition UPI, PMODE
sub _vcs_vcsmode {
	return "VCSRAC" if ($UPI eq "SFRAC");
	my ($mode)=(@_);
	$mode=$PMODE if (!$mode);
	return "$PMODE" if ($mode=~/^VCS/);
	return "VCSSFCFS" if ($mode eq "SFCFS");
	return "VCS";
}

# verify that the %CFG information read by -configfile is valid
# _die if an error is found, specifying the error
sub _vcs_comm_verify_responsefile {
	my(@sevs,$csg,$n,$nn,$nics);
	@sevs=("Information","Warning","Error","SevereError");
	# verify cluster config: CLUSTERNAME, CLUSTERID, LLTLINK
	if (($CFG{CLUSTERNAME}) || ($CFG{CLUSTERID}) || (defined($CFG{LLTLINK}))) {
		unless (_vcs_verify_clustername($CFG{CLUSTERNAME})) {
			_die("CLUSTERNAME has an incorrect value", 120, 1197);
		}
		if ((_isint($CFG{CLUSTERID})) || ($CFG{CLUSTERID}<0) || ($CFG{CLUSTERID}>255)) {
			_die("CLUSTERID must be an integer value between 0 and 255", 120, 1198);
		}
		foreach $SYS(@SYSC) {
			$nn = (_vcs_vcsmode() eq "VCSSFCFS") ? 1 : 2;
			foreach $n(1..$nn) {
				if (!$CFG{"LLTLINK$n"}{$SYS}) {
					_die("LLTLINK$n is not configured for system $SYS", 120, 1199, "$n", "$SYS");
				}
				# validate NICS somehow _niccheck is no true
				# guarantee of validity or invalidity
			}
		}
	}
	# verify csg config: CSGVIP, CSGNETMASK
	if ((defined($CFG{CSGVIP})) || ($CFG{CSGNETMASK}) || (defined($CFG{CSGNIC}))) {
		$csg=1;
		if (($CFG{CSGVIP}) && (_ipcheck($CFG{CSGVIP}))) {
			_die("CSGVIP is not a valid IP address", 120, 1200);
		}
		if (($CFG{CSGNETMASK}) && (_ipcheck($CFG{CSGNETMASK}))) {
			_die("CSGNETMASK is not a valid netmask", 120, 1236);
		}
		foreach $SYS(@SYSC) {
			$nics++ if (defined($CFG{CSGNIC}{$SYS}));
		}
	}
	# verify smtp config: SMTPSERVER, SMTPRECP, SMTPRSEV
	if (($CFG{SMTPSERVER}) || (defined($CFG{SMTPRECP})) || (defined($CFG{SMTPRSEV}))) {
		$csg=1;
		unless (_vcs_verify_smtpserver($CFG{SMTPSERVER})) {
			_die("SMTPSERVER has an incorrect value", 120, 1202);
		}
		if ($#{$CFG{SMTPRECP}} != $#{$CFG{SMTPRSEV}}) {
			_die("There are an unequal number of SMTPRECP and SMTPRSEV array entries", 120, 1203);
		}
		foreach $n(0..$#{$CFG{SMTPRECP}}) {
			unless (_vcs_verify_emailadd(${$CFG{SMTPRECP}}[$n])) {
				_die("SMTPRECP has an incorrect value", 120, 1204);
			}
			if (_list(${$CFG{SMTPRSEV}}[$n],@sevs)<0) {
				_die("${$CFG{SMTPRSEV}}[$n] is an incorrect SMTPRSEV severity value\nMust be Information, Warining, Error, or SevereError", 120, 1205, "${$CFG{SMTPRSEV}}[$n]");
			}
		}
	}
	# verify snmp config: SNMPPORT, SNMPCONS, SNMPCSEV
	if (($CFG{SNMPPORT}) || (defined($CFG{SNMPCONS})) || (defined($CFG{SNMPCSEV}))) {
		$csg=1;
		if (_isint($CFG{SNMPPORT})) {
			_die("SNMPPORT has an incorrect value", 120, 1206);
		}
		if ($#{$CFG{SNMPCONS}} != $#{$CFG{SNMPCSEV}}) {
			_die("There are an unequal number of SNMPCONS and SNMPCSEV array entries", 120, 1207);
		}
		foreach $n(0..$#{$CFG{SNMPCONS}}) {
			if (_list(${$CFG{SNMPCSEV}}[$n],@sevs)<0) {
				_die("${$CFG{SNMPCSEV}}[$n] is an incorrect SNMPCSEV severity value\nMust be Information, Warining, Error, or SevereError", 120, 1208, "${$CFG{SNMPCSEV}}[$n]");
			}
		}
	}
	# validating definition, but could validate value too
	if ($csg) {
		unless (($CFG{CSGNIC}{ALL}) || ($nics>$#SYSC)) {
			_die("CSGNIC is not correctly set for all systems", 120, 1209);
		}
	}
}

# verify a clustername starts with a letter and has valid characters
sub _vcs_verify_clustername {
	my($ask,$cname,$fc,$name);
	($name)=(@_);
	$fc=substr($name,0,1);
	$cname=$name;
	$cname =~ s/[A-Za-z0-9_-]//g;
	if (!($fc =~ /[A-Za-z]/)) {
		_pl("Cluster Name must start with an alphabetic character", 120, 1210);
	} elsif ($cname) {
		_pl("Cluster Name cannot use the characters: $cname", 120, 1211, "$cname");
	} elsif (_list($name,@{$PROD{VCS}{RWORDS}})>=0) {
		_pl("$name is a VCS reserved word and cannot be used as a cluster name", 120, 1273, "$name");
	} else {
		return "1";
	}
	return "";
}

# verify an email address has proper format
sub _vcs_verify_emailadd {
	my(@aa,@sa,$recp);
	($recp)=(@_);
	@aa=split(/@/,$recp);
	@sa=split(/\./,$aa[1]);
	if (($#aa!=1) || ($#sa<1)) {
		_pl("$recp is not a valid domain-based email address", 120, 1212, "$recp");
		return "";
	} 
	return "1";
}

# verify an smtp server is a complete domain address and can be pinged
sub _vcs_verify_smtpserver {
	my(@f,$server);
	($server)=(@_);
	@f=split(/\./,$server);	
	if ($#f<2) {
		_pl("$server does not include a domain", 120, 1213, "$server");
	} elsif (_plat_sub("ping", $server)) {
		_pl("Cannot ping $server", 120, 1064, "$server"); 
	} else {
		return "1";
	}
	return "";
}

# update user password 
sub _vcs_update_user_password {
	my(@eps,@hu,@users,$ep,$user,$n,$o,$su);
	# vcsencrypt binary will not work in other languages
	return unless (($COMM{ENVLANG} eq "C") || ($COMM{ENVLANG}=~/en/));
	$CMD{VCSENCRYPT} = ($FLAG{FROMDISK}) ? "$PATH{VCSBIN}/vcsencrypt" :
		($COMM{FROMRTI}) ? "./cluster_server/scripts/vcsencrypt" : 
		"./scripts/vcsencrypt";
	unless (-x "$CMD{VCSENCRYPT}") {
		_warn("Cannot find vcsencrypt binary", 120, 1260);
		_pl("User passwords will not be updated to version $COMM{TRAINVERS}", 120, 1261, "$COMM{TRAINVERS}");
		return;
	}
	$o = ($COMM{UGVERS}{$SYS}<3.5) ? "-display" : "-list";
	@hu=split(/\s+/,_dor("$PATH{VCSBIN}/hauser $o"));
	if ($COMM{UGVERS}{$SYS}<2.0) {
		foreach $su(@hu) {
			push(@users, $su);
			shift(@hu);
		}
	}
	@users=@hu if ($#users<0);
	if ($#users>=0) {
		_bpl("VCS 4.0 uses a new advanced password encryption algorithm. Therefore, passwords for all VCS users must be reset at this time.  Be sure to write down the new VCS user passwords at this time for future reference as they are not written to the install log for your protection.\n", 120, 1336);
	}
	foreach $user(@users) {
		_pl("Resetting $PROD{VCS}{ABBR} password for user $user:", 120, 1337, "$PROD{VCS}{ABBR}", "$user");
		$ep=_vcs_encrypt_password();
		push(@eps,$ep);
		_p();
	}
	foreach $n(0..$#users) {
		_pb1("Updating password for user $users[$n]", 120, 1238, "$users[$n]");
		_dor("$PATH{VCSBIN}/haclus -modify UserNames -update $users[$n] $eps[$n]");
		_pb2("Done", 120, 1143);
	}
}

# ask for user name
sub _vcs_ask_username {
        my($ask,$un);
        ($un)=(@_);
        while (1) {
                $COMM{DEFANSWER}=$un;
                $MSG{HELP}=_tr("Use corporate login ID as a user name.", 120, 1239);
                $ask=_ask("Enter the user name:", 120, 1240);
                return "$ask" if (_vcs_verify_username($ask));
        }
}

sub _vcs_verify_username {
        my($ask,$un);
        ($un)=(@_);
        $un =~ s/[A-Za-z0-9_-]//g;
        if ($un) {
                _pl("User name cannot use the characters: $un", 120, 1241, "$un");
        	return "";
        } else {
                return "1";
        }
}


# ask for user password
sub _vcs_ask_userpassword {
        my($ask,$askc,$un,$upw);
        ($un)=(@_);
        while (1) {
                $ask=_ask("Enter the password for user $un:", 120, 1242, "$un");
                $askc=_ask("Enter again:", 120, 1243);
                return "$ask" if ($ask eq $askc);
		_pl("Sorry! Passwords mismatch", 120, 1244);
        }
}

sub _vcs_encrypt_password {
	my($epw,$mm,$pw);
	($pw)=(@_);
	if ($pw) {
		system("$CMD{VCSENCRYPT} -vcs $pw 1> $PATH{ITD}/userpasswd");
		$epw=_desp(_dol("$CMD{CAT} $PATH{ITD}/userpasswd"));
		return "$epw";
	}		
		
	while (1) {
		$mm=system("$CMD{VCSENCRYPT} -vcs 1> $PATH{ITD}/userpasswd");
		if (!$mm) {
			$epw=_desp(_dol("$CMD{CAT} $PATH{ITD}/userpasswd"));
			return "$epw";
		}
	}
}

sub _vcs_ask_userprivilege {
        my(@pris,$pri,$un);
        ($un)=(@_);
        @pris=("Administrators","Operators","Guests");
	_p();
        while (_list($pri,@pris)<0) {
                $MSG{HELP}=_tr("Administrator users have full privileges to make changes to the cluster.\nOperator users have limited administrative privileges on the cluster.\nGuest users have read-only access to the cluster.", 120, 1245);
                $pri=_ask("Enter the privilege for user $un (A=Administrator, O=Operator, G=Guest):", 120, 1246, "$un");
                return if ($FLAG{BACK});
                $pri="Administrators" if ($pri =~ /^A/i);
                $pri="Operators" if ($pri =~ /^O/i);
                $pri="Guests" if ($pri =~ /^G/i);
        }
        return "$pri";
}

sub _vcs_add_users {
	return if ($OPT{INSTALLONLY});
	# vcsencrypt binary will not work in other languages
	return unless (($COMM{ENVLANG} eq "C") || ($COMM{ENVLANG}=~/en/));
	$CMD{VCSENCRYPT} = ($FLAG{FROMDISK}) ? "$PATH{VCSBIN}/vcsencrypt" :
		($COMM{FROMRTI}) ? "./cluster_server/scripts/vcsencrypt" : 
		"./scripts/vcsencrypt";
	unless (-x "$CMD{VCSENCRYPT}") {
		_log("Cannot find vcsencrypt binary - skipping _vcs_add_users", 120, 1262);
		return;
	}
	my(@epws,@pris,@users,@pws,$ayn,$cmsg,$done,$epw,$msg,$pri,$pw,$user,$n);
	while (!$done) {
		_title();
		undef(@users);
		undef(@epws);
		undef(@pris);
		_bpl("The following information is required to add $PROD{VCS}{ABBR} users:\n", 120, 1248, "$PROD{VCS}{ABBR}");
		_pl("\tA user name", 120, 1249);
		_pl("\tA password for the user", 120, 1250);
		_pl("\tUser privileges (Administrator, Operator, or Guest)\n", 120, 1251);
		$ayn=_aynn("Do you want to set the password for the Admin user\n(default password='password')?", 120, 1252);
		if ($ayn eq "Y") {
			$FLAG{SETADMINPWD}=1;
			$epw=_vcs_encrypt_password();
			_p();
		} else {
			$epw=_vcs_encrypt_password("password");
		}
		push(@users,"admin");
		push(@epws,$epw);
		push(@pris,"Administrators");
		$ayn=_ayny("Do you want to add another user to the cluster?", 120, 1253);
		while (($#users<0) || ($ayn eq "Y")) {
			$user=_vcs_ask_username();
			$epw=_vcs_encrypt_password();
			_p();
			$pri=_vcs_ask_userprivilege($user);
			$n=_list($user,@users);
			if ($n<0) {
				push(@users,$user);
				push(@epws,$epw);
				push(@pris,$pri);
			} else {
				_pl("$user previously entered, updating password and changing privilege to $pri", 120, 1254, "$user", "$pri");
				$epws[$n]=$epw;
				$pris[$n]=$pri;
			}
			$ayn=_aynn("Would you like to add another user?", 120, 1255);
			_p();
		}
		_title();
		_bpl("$PROD{VCS}{ABBR} User verification:\n", 120, 1256, "$PROD{VCS}{ABBR}");
		$msg="";
		foreach $n(0..$#users) { 
			$msg.=_tr("\tUser: $users[$n]\tPrivilege: $pris[$n]\n", 120, 1257, "$users[$n]", "$pris[$n]"); 
		}
		_pl_notr("$msg");
		_pl("\tPasswords are not displayed\n", 120, 1258);
		$ayn=_ayny("Is this information correct?", 120, 1105);
		$done=1 if ($ayn eq "Y");
	}
	$CFG{USERNAME}=[];
        $CFG{USERPRIV}=[];
        @{$CFG{USERENPW}}=@epws;
        foreach $n(0..$#users) {
                push(@{$CFG{USERNAME}},$users[$n]);
                push(@{$CFG{USERPRIV}},$pris[$n]);
        }
}

sub _vcs_gcm_upgrade_poststart {
	my(@grps,@rvgres,@syslist,$ayn,$dnsres,$g,$grp,$i,$j,$nm,$ret,$sys,$typedep,$vvrres);
	$ayn=_ayny("Do you want to automatically upgrade GCM to VCS 4.0? ", 120, 1274);
	return if ($ayn eq "N");
	_pb1("Adding remote cluster $CFG{REMOTECLUSTER}", 120, 1275, "$CFG{REMOTECLUSTER}");
	_dor("$PATH{VCSBIN}/haclus -add $CFG{REMOTECLUSTER} $CFG{REMOTEADDR}");
	_pb2("Done", 120, 1143);
	_pb1("Adding Icmp heartbeat to $CFG{REMOTECLUSTER}", 120, 1276, "$CFG{REMOTECLUSTER}");
	_dor("$PATH{VCSBIN}/hahb -add Icmp");
	_dor("$PATH{VCSBIN}/hahb -modify Icmp ClusterList $CFG{REMOTECLUSTER}");
	_dor("$PATH{VCSBIN}/hahb -modify Icmp Arguments $CFG{ICMPARGUMENTS} -clus $CFG{REMOTECLUSTER}");
	_dor("$PATH{VCSBIN}/hahb -local Icmp AYARetryLimit");
	_dor("$PATH{VCSBIN}/hahb -modify Icmp AYARetryLimit $CFG{ICMPAYARL} -clus $CFG{REMOTECLUSTER}");
	_pb2("Done", 120, 1143);
	if ($CFG{SYMMARGUMENTS}) {
		_pb1("Adding Symm heartbeat to $CFG{REMOTECLUSTER}", 120, 1277, "$CFG{REMOTECLUSTER}");
		_dor("$PATH{VCSBIN}/hahb -add Symm");
		_dor("$PATH{VCSBIN}/hahb -modify Symm ClusterList $CFG{REMOTECLUSTER}");
		_dor("$PATH{VCSBIN}/hahb -modify Symm Arguments $CFG{SYMMARGUMENTS} -clus $CFG{REMOTECLUSTER}");
		_dor("$PATH{VCSBIN}/hahb -local Symm AYARetryLimit");
		_dor("$PATH{VCSBIN}/hahb -modify Symm AYARetryLimit $CFG{SYMMAYARL} -clus $CFG{REMOTECLUSTER}");
		_pb2("Done", 120, 1143);
	}
	if ($FLAG{VVREX}) {	
		_pb1("Adding RVGPrimary type", 120, 1278);
		_dor("$PATH{VCSBIN}/hatype -add RVGPrimary");
		_dor("$PATH{VCSBIN}/haattr -add RVGPrimary RvgResourceName -string -scalar");
		_dor("$PATH{VCSBIN}/haattr -add RVGPrimary AutoTakeover -integer -scalar");
		_dor("$PATH{VCSBIN}/haattr -add RVGPrimary AutoResync -integer -scalar");
		_dor("$PATH{VCSBIN}/hatype -modify RVGPrimary SourceFile \"./RVGPrimaryTypes.cf\"");
		_dor("$PATH{VCSBIN}/hatype -modify RVGPrimary ArgList RvgResourceName AutoTakeover AutoResync");
		_pb2("Done", 120, 1143);
	}
	# gcmcheck
	(@grps) = split('\n', _dor("$PATH{VCSBIN}/hagrp -list | $CMD{AWK} '{print \$1}' | $CMD{UNIQ}"));
	foreach $g (@grps) {
		($grp) = split('\s+', $g);
		if (!(($CFG{REPTYPE}{$grp} eq "VVR") || ($CFG{REPTYPE}{$grp} eq "SRDF"))) {
			next;
		}
		_pb1("Processing group $grp", 120, 1279, "$grp");
		if ($CFG{REPTYPE}{$grp} eq "VVR") {
			# gcmcheck
			(@rvgres) = split('\n', _dor("$PATH{VCSBIN}/hares -list Type=RVG Group=$CFG{REPGRP}{$grp}"));
			if ($#rvgres == -1) {
				next;
			}
			$ret = system("$PATH{VCSBIN}/hagrp -state $grp | $CMD{EGREP} -s ONLINE");
			#gcmcheck 
			($nm) = split('\s+', $rvgres[0]);
			$vvrres = "vvr-" . $grp;
			_dor("$PATH{VCSBIN}/hares -add $vvrres RVGPrimary $grp");
			_dor("$PATH{VCSBIN}/hares -modify $vvrres RvgResourceName $nm");
			_dor("$PATH{VCSBIN}/hares -modify $vvrres Enabled 1");
			($sys,$j)=split(/\./,$SYS,2);
			_dor("$PATH{VCSBIN}/hares -wait $vvrres Probed 1 -sys $sys -time 60");
		}
		# gcmcheck
		($typedep) = split('\n', _dor("$PATH{VCSBIN}/hagrp -value $grp TypeDependencies"));
		if ($CFG{DNSDOMAIN}{$grp}) {
			$dnsres = "dns-" . $grp;
			_dor("$PATH{VCSBIN}/hares -add $dnsres DNS $grp");
			_dor("$PATH{VCSBIN}/hares -modify $dnsres Domain $CFG{DNSDOMAIN}{$grp}");
			_dor("$PATH{VCSBIN}/hares -modify $dnsres Alias $CFG{DNSCNAME}{$grp}");
			_dor("$PATH{VCSBIN}/hares -modify $dnsres Hostname $CFG{DNSNEWHOST}{$grp}");
			_dor("$PATH{VCSBIN}/hares -modify $dnsres Enabled 1");
			if ($CFG{REPTYPE}{$grp} eq "VVR") {
				if ($typedep && ($typedep =~ /Mount/)) {
					_dor("$PATH{VCSBIN}/hagrp -modify $grp TypeDependencies -add RVGPrimary DNS");
				} else {
					_dor("$PATH{VCSBIN}/hagrp -modify $grp TypeDependencies -add Mount RVGPrimary DNS");
				}
			} else {
				_dor("$PATH{VCSBIN}/hagrp -modify $grp TypeDependencies -add SRDF DNS");
			}
		} else {
			if ($CFG{REPTYPE}{$grp} eq "VVR") {
				if ($typedep && ($typedep =~ /Mount/)) {
					_dor("$PATH{VCSBIN}/hagrp -modify $grp TypeDependencies -add RVGPrimary");
				} else {
					_dor("$PATH{VCSBIN}/hagrp -modify $grp TypeDependencies -add Mount RVGPrimary");
				}
			}
		}
		if (!$ret) {
			_pl("force onlining $grp", 120, 1280, "$grp");
			#TBD need this to work (force of partial online group and Authority assignment
			_dor("$PATH{VCSBIN}/hagrp -online -any -force $grp");
			($sys,$j)=split(/\./,$SYS,2);
			_dor("$PATH{VCSBIN}/hagrp -wait $grp State ONLINE -sys $sys -time 60");
		}
		_dor("$PATH{VCSBIN}/hagrp -modify $grp ClusterList $CFG{LOCALCLUSTER} 0 $CFG{REMOTECLUSTER} 0");
		# gcmcheck
		(@syslist) = split('\s', _dor("$PATH{VCSBIN}/hagrp -value $grp SystemList"));
		for ($i = 0; $i < $#syslist; $i = $i + 2) {
				_dor("$PATH{VCSBIN}/hagrp -modify $grp AutoStartList -add $syslist[$i]");
		}
		if ($CFG{REPTYPE}{$grp} eq "VVR") {
			_dor("$PATH{VCSBIN}/hagrp -link $grp $CFG{REPGRP}{$grp} online local hard");
		}
		_pb2("Done", 120, 1143);
	}

	_pb1("deleting GCM resources", 120, 1281);
	_dor("$PATH{VCSBIN}/hares -delete GCMmasterp");
	_dor("$PATH{VCSBIN}/hares -delete GCMslavep");
	_dor("$PATH{VCSBIN}/hares -delete GCMdns");
	_dor("$PATH{VCSBIN}/hares -delete GCMweb");
	_dor("$PATH{VCSBIN}/hares -delete GCMnotify 2>/dev/null");  #TBD: is null OK in common?
	_pb2("Done", 120, 1143);
}

sub _vcs_gcm_upgrade_prestop {
	my (@clusters,@downev,@fields,@gapinfo,@gaps,@hbentry,@hblist,@riinfo,@sites,$appgrp,$app1,$app2,$app3,$app4,$attr,$ayn,$clus1,$clus2,$clus3,$clus4,$d,$dev,$gap,$grp1,$grp2,$grp3,$grp4,$ginfo,$hbentry,$iv,$j,$localsite,$pid,$remoteaddr,$remotesite,$repagent,$repgrp,$reptype,$ri,$risys,$site1,$site2,$site3,$site4);
	$PKG="VRTSgcm";
	_comm_define_pkgipobj();
	$iv=_plat_sub("get_instpkgvers",$PKG);
	return if (!$iv);
    	_pl("Upgrade procedure will replace GCM $iv with $PROD{VCS}{ABBR} $COMM{TRAINVERS}\n", 120, 1282, "$iv", "$PROD{VCS}{ABBR}", "$COMM{TRAINVERS}");
	$ayn=_ayny("Do you want to upgrade GCM at this time? ", 120, 1283);
	return if ($ayn eq "N");
	#TBD switch ClusterService to here
	#TBD make sure masters are connected
	#TBD describe alternatives if you don't upgrade
	$pid=_comm_get_pid("GCMmaster");
	if (!$pid) {
		_pl("\nUpgrading $PROD{VCS}{NAME} must be started on a running system where the GCM master is running to properly upgrade the configuration.\n", 120, 1284, "$PROD{VCS}{NAME}");
		$ayn=_ayny("Do you want to continue?", 120, 1194);
	} else {
		_pl("\n$COMM{PROG} must now make configuration updates and stop the cluster before upgrading $PROD{VCS}{ABBR} $MSG{PDFRS}\n", 120, 1195, "$COMM{PROG}", "$PROD{VCS}{ABBR}", "$MSG{PDFRS}");
		$ayn=_ayny("Are you ready to begin the $PROD{VCS}{NAME} upgrade at this time?", 120, 1196, "$PROD{VCS}{NAME}");
	}
	return if (($ayn eq "N") || (!$pid));
	_p();
	_pl("Capturing GCM configuration:\n", 120, 1285);
	# gcmcheck
	(@sites) = split('\n', _dor("$PATH{GCMBIN}/gasite -list | $CMD{GREP} -v Site"));
	if ($#sites > 1) {
		_pl("Upgrade of a three or more site configuration is not possible using this program", 120, 1286);
		return;
	}
	($localsite) = split('\s+', $sites[0]);
	($remotesite, $remoteaddr) = split('\s+', $sites[1]);
	$CFG{REMOTEADDR} = $remoteaddr;
	# gcmcheck
	(@clusters) = split('\n', _dor("$PATH{GCMBIN}/gaclus -list | $CMD{GREP} -v Site"));
	if ($#clusters > 1) {
		_pl("Upgrade of a three or more cluster configuration is not possible using this program", 120, 1287);
		return;
	}
	$FLAG{GCMU} = 1;
	($CFG{LOCALCLUSTER}, $j) = split('\s+', $clusters[0]);
	($CFG{REMOTECLUSTER}, $j) = split('\s+', $clusters[1]);
	_pl("\tsite $localsite will become cluster $CFG{LOCALCLUSTER}", 120, 1288, "$localsite", "$CFG{LOCALCLUSTER}");
	_pl("\tsite $remotesite will become remote cluster $CFG{REMOTECLUSTER}", 120, 1289, "$remotesite", "$CFG{REMOTECLUSTER}");
	# gcmcheck
	(@hblist) = split('\n', _dor("$PATH{GCMBIN}/gahb -display Icmp $remotesite -site $localsite"));
	foreach $hbentry (@hblist) {
		if ($hbentry =~ /Arguments/) {
			(@fields) = split('\s+', $hbentry);
			$CFG{ICMPARGUMENTS} = $fields[4];
		}
		if ($hbentry =~ /AYARL/) {
			(@fields) = split('\s+', $hbentry);
			$CFG{ICMPAYARL} = $fields[4];
		}
	}
	$CFG{SYMMARGUMENTS} = "";
	# gcmcheck
	@hblist = split('\n', _dor("$PATH{GCMBIN}/gahb -display Symm $remotesite -site $localsite"));
	foreach $hbentry (@hblist) {
		if ($hbentry =~ /Arguments/) {
			(@fields) = split('\s+', $hbentry);
			$CFG{SYMMARGUMENTS} = $fields[4];
		}
		if ($hbentry =~ /AYARL/) {
			(@fields) = split('\s+', $hbentry);
			$CFG{SYMMAYARL} = $fields[4];
		}
	}
	# gcmcheck
	(@gaps) = split('\n', _dor("$PATH{GCMBIN}/gagap -list | $CMD{GREP} -v GlobalApp"));
	foreach $gap (@gaps) {
		$appgrp = "";
		$repgrp = "";
		$repagent = "";
		# gcmcheck
		(@gapinfo) = split('\n', _dor("$PATH{GCMBIN}/gagap -display $gap"));
		foreach $ginfo (@gapinfo) {
	                ($j, $attr, $j, $app1, $app2, $app3, $app4) = split('\s+', $ginfo);
	                if ($attr eq "AppConfig") {
		                if (!$app3) {
					($grp1, $clus1, $site1) = split(':', $app1);
					($grp2, $clus2, $site2) = split(':', $app2);
					if ($clus1 eq $CFG{LOCALCLUSTER}) {
						$appgrp = $grp1;
					} else {
						$appgrp = $grp2;
					}
					# gcmcheck $reptype
					$repagent = $grp1 . $reptype;
					$CFG{REPGRP}{$appgrp} = "";
					$CFG{REPTYPE}{$appgrp} = "SRDF";
				} else {
	                        	($grp1, $clus1, $site1) = split(':', $app1);
	                        	($grp2, $clus2, $site2) = split(':', $app2);
	                        	($grp3, $clus3, $site3) = split(':', $app3);
	                        	($grp4, $clus4, $site4) = split(':', $app4);	
	                        	if ($clus1 eq $CFG{LOCALCLUSTER}) {
						$appgrp = $grp1;
						$CFG{REPGRP}{$grp1} = $grp2;
						$CFG{APPGRP}{$grp2} = $grp1;
						$repagent = $grp2 . $reptype;
					} else {
						#TBD: if repgrp is before appgrp?
						$appgrp = $grp3;
						$CFG{REPGRP}{$grp3} = $grp4;
						$CFG{APPGRP}{$grp4} = $grp3;
						$repagent = $grp4 . $reptype;
					}
					$CFG{REPTYPE}{$appgrp} = "VVR";
					$FLAG{VVREX} = 1;
					_dor("$PATH{VCSBIN}/hagrp -unlink $appgrp $CFG{REPGRP}{$appgrp}");
				}
				#gcmcheck
				(@riinfo) = split('\n', _dor("$PATH{VCSBIN}/hares -state $repagent"));
				foreach $ri (@riinfo) {
					(@fields) = split('\s+', $ri);
					if ($fields[3] eq "ONLINE") {
						_dor("$PATH{VCSBIN}/hares -offline $repagent -sys $fields[2]");
						# gcmcheck $risys
						_dor("$PATH{VCSBIN}/hares -wait $repagent State OFFLINE -sys $risys -time 300");
					}
				}
				_dor("$PATH{VCSBIN}/hares -delete $repagent");
			}
			$d = $localsite . "down-" . $appgrp;
			#gcmcheck
			(@downev) = split('\n', _dor("$PATH{GCMBIN}/gaevent -display $d"));
			$CFG{DNSDOMAIN}{$appgrp} = "";
			$CFG{DNSCNAME}{$appgrp} = "";
			$CFG{DNSNEWHOST}{$appgrp} = "";
			foreach $dev (@downev) {
				if ($dev =~ /\[auto\]/) {
					$CFG{CFOP}{$appgrp} = "Auto";
				}
				if ($dev =~ /requires confirmation/) {
					$CFG{CFOP}{$appgrp} = "Manual";
				}
				if ($dev =~ /dns add-cname/) {
					(@fields) = split('\s+', $dev);
					$CFG{DNSDOMAIN}{$appgrp} = $fields[5];
					$CFG{DNSCNAME}{$appgrp} = $fields[6];
					$CFG{DNSNEWHOST}{$appgrp} = $fields[7];
				}
			}
			$d = $localsite . $appgrp . "down";
			#gcmcheck
			@downev = split('\n', _dor("$PATH{GCMBIN}/gaevent -display $d"));
			foreach $dev (@downev) {
				if ($dev =~ /\[auto\]/) {
					$CFG{CFOP}{$appgrp} = "Connected";
				}
				if ($dev =~ /requires confirmation/) {
					$CFG{CFOP}{$appgrp} = "Manual";
				}
			}
			if ($attr eq "RepType") {
				$reptype = $app1;
				if (!(($reptype =~ /VVR/) || ($reptype =~ /RDF/))) {
					_pl("RepType $reptype is not supported by this upgrade", 120, 1290, "$reptype");
					next;
				}
			}
		}
		_pl("\tGroup $appgrp will become Global Group with $CFG{CFOP}{$appgrp} policy", 120, 1291, "$appgrp", "$CFG{CFOP}{$appgrp}");
		if ($CFG{DNSDOMAIN}{$appgrp}) {
			_pl("\t\tDNS resource will be added to $appgrp", 120, 1292, "$appgrp");
		}
	}

	_p();
	$ayn=_ayny("Do you want to continue?", 120, 1194);
	_comm_cleanup(0) if ($ayn eq "N");
	#gcmcheck
	(@fields) =  split('\s+', _dor("$PATH{VCSBIN}/hagrp -display ClusterService -attribute State | $CMD{GREP} ONLINE"));
	if ($fields[2]) {
		_pb1("\nOfflining ClusterService", 120, 1293);
		_dor("$PATH{VCSBIN}/hagrp -offline ClusterService -sys $fields[2]");
		_dor("$PATH{VCSBIN}/hagrp -wait ClusterService State OFFLINE -sys $fields[2] -time 300");
		_pb2("Done", 120, 1143);
	}

	#TBD remove 1 from end of package
	#TBD how to remove it on all nodes in the cluster
	push(@{$COMM{UPKGS}{$SYS}},"VRTSgcmw");
	push(@{$COMM{UPKGS}{$SYS}},"VRTSgcms");
	push(@{$COMM{UPKGS}{$SYS}},"VRTSgcm");
	$FLAG{UPKGS}=1;
}

sub _vcs_comm_flag_license {
	return if (($UPI ne "VCS") || ($COMM{FLAGLICENSE}));
	my($ayn);
	if ($PMODE eq "VCSRAC") {
		_pl("\t License key for '$PROD{SFRAC}{NAME}' is installed.", 120, 1302, "$PROD{SFRAC}{NAME}");
		_pl("\t It is recommended to use 'installsfrac' instead.", 120, 1295);
		_pl("\t Continuing this program will install and configure Standard $PROD{VCS}{ABBR} and not $PROD{VCS}{ABBR} for $PROD{SFRAC}{NAME}\n", 120, 1303, "$PROD{VCS}{ABBR}", "$PROD{VCS}{ABBR}", "$PROD{SFRAC}{NAME}");
		$ayn=_aynn("Do you want to continue?", 120, 1194);
		_comm_cleanup(0) if ($ayn eq "N");
		$COMM{FLAGLICENSE}="VCS";
	} elsif ($PMODE eq "VCSSFCFS") {
		_pl("\t License key for '$PROD{SFCFS}{NAME}' is installed.", 120, 1302, "$PROD{SFCFS}{NAME}");
		_pl("\t It is recommended to use 'installsfcfs' instead.", 120, 1297);
		_pl("\t Continuing this program will install and configure Standard $PROD{VCS}{ABBR} and not $PROD{VCS}{ABBR} for $PROD{SFCFS}{NAME}\n", 120, 1303, "$PROD{VCS}{ABBR}", "$PROD{VCS}{ABBR}", "$PROD{SFCFS}{NAME}");
		$ayn=_aynn("Do you want to continue?", 120, 1194);
		_comm_cleanup(0) if ($ayn eq "N");
		$COMM{FLAGLICENSE}="VCS";
	} 
}

sub _vcs_comm_initial_systemcheck {
	_prod_plat_sub("VCS","initial_systemcheck");
}

sub _vcs_comm_preinstall {
	_prod_plat_sub("VCS","preinstall");
}
#
#SCC#  $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
#SCC#  $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
# 

# Define frequently used commands
$CMD{HOSTID}="/usr/bin/hostid";
$CMD{VOLD}="/usr/sbin/vxconfigd";
$CMD{VXKPRINT}="/usr/lib/vxvm/diag.d/vxkprint";
$CMD{VXCONFIGBACKUPD}="/etc/vx/bin/vxconfigbackupd";


# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms

# Define product configuration files

# Define frequently referenced paths

$PATH{RDIR}="/etc/vx/reconfig.d";
$PATH{MKDBFILE}="/etc/vx/reconfig.d/state.d/install-db";

# The presence of this file informs vxconfigd that the enclosure-based 
# naming scheme is in use.  It is also set by vxinstall in Solaris and Linux.
$PATH{NEWNAMES_FILE}="/etc/vx/.newnames";

$DEF{DG_BOOT}="bootdg";               # name reserved to identify boot
$DEF{DG_DEFAULT}="defaultdg";         # name disallowed from 'vxdctl defaultdg'
				      # command


# Define product information
$PROD{VM}{NAME}="Volume Manager";
$PROD{VM}{ABBR}="VxVM";
$PROD{VM}{DIR}="volume_manager";
$PROD{VM}{LICFEATURE}="VxVM";

# VRTSfspro is used by FS
$PROD{VM}{OPTRMPKGS}=[ qw(VRTSfspro) ];

# Define product modes and names for product modes, if necessary


# This flag is used by _vm_dbg_pl().
$FLAG{VMDBG}=1;

#
# Function: _vm_ask_defaultdg()
# Purpose:
#	Asks if a default disk group name should be configured. If
#	so, it prompts for the name for a single or multiple systems.
# Input Parameters:
#	None
# Output Parameters:
#	$CFG{DEFAULTDG}{$SYS} = dgname or ""
# Called by:
#	_vm_sun_poststart()
#	_vm_linux_poststart()
sub _vm_ask_defaultdg 
{

	_prod_plat_sub("VM", "ask_defaultdg");

} # _vm_ask_defaultdg()

#
# Function: _vm_request_all_dgnames()
# Purpose:
#	This is a helper function for _vm_*_ask_defaultdg(). It sets
#	$CFG{DEFAULTDG}{$SYS}.	
#
#	Note: $SYS is used when needed by the CPI framework (i.e., inside
#	      _vm_get_defaultdg()); $sys is used just by this function locally.
# Input Parameters:
#	$systems - a list of systems that are eligible for setting the default dg
# Output Parameters:
#	$CFG{DEFAULTDG}{$SYS} - contains the default disk group name; 
#	otherwise, null
#	Return 0, if this needs to be called again
#	Return 1, if this doesn't need to be called again
# Called by:
#	_vm_ask_defaultdg()
sub _vm_request_all_dgnames 
{
	my ($systems) = (@_);
	my ($ayn1, $ayn2, $dgname, $msg, $sys);


	# First, handle the case of one eligible system
	if ($#$systems == 0)
	{
		$MSG{HELP}=_tr("You may specify a single disk group name for system @$systems.", 110, 1078, "$systems");
		$msg = _tr("\nSpecify a default disk group for system $$systems[0] or type 'l' to display a listing of existing disk group(s).", 110, 1105, "$$systems[0]");
		$CFG{DEFAULTDG}{$$systems[0]} = _vm_get_defaultdg($msg, $systems, 0);
	}
	elsif ($#$systems > 0)
	{
		$MSG{HELP}=_tr("You may specify a single disk group name for all systems or specify a disk group name for each system.", 110, 1013);
		$ayn1 = _ayny("\nWill you specify one disk group name for all eligible systems?", 110, 1014);

		if ($ayn1 eq "Y")
		{
			$msg = _tr("\nSpecify a default disk group for all systems or type 'l' to display a listing of existing disk group(s).", 110, 1106);
			$dgname = _vm_get_defaultdg($msg, $systems, 1);

			foreach $SYS (@$systems)
			{
				$CFG{DEFAULTDG}{$SYS} = $dgname;
			}
		}
		else
		{
			_pl("\nConfigure a default disk group for each system.", 110, 1107);

			foreach $SYS (@$systems)
			{
				$msg = _tr("\nSpecify a default disk group for system $SYS or type 'l' to display a listing of existing disk group(s).", 110, 1105, "$SYS");
				$CFG{DEFAULTDG}{$SYS} = _vm_get_defaultdg($msg, $systems, 0);
			}
		}
	}

	if ($#$systems > 0)
	{
		_pl("\nYou have decided to specify the default disk groups as follows:\n", 110, 1083);
	}
	else
	{
		_pl("\nYou have decided to specify the default disk group as follows:\n", 110, 1084);
	}


	foreach $sys (@$systems)
	{
		_pb1("Host: $sys", 110, 1019, "$sys");
		_pb2("Disk group: $CFG{DEFAULTDG}{$sys}", 110, 1020, "$CFG{DEFAULTDG}{$sys}");
	}

	_pl("\nNote: If 'nodg' is displayed, then the host will be configured to have no default disk group.\n", 110, 1117);

	$ayn2=_ayny("\nIs this correct?", 110, 1021);
	return 1 if ($ayn2 eq "Y");

	_pl("You have responded no.  Configure again.", 110, 1108);
	return 0;

} # _vm_request_all_dgnames()


#
# Function: _vm_ask_encl_names()
# Purpose:
#	Asks if enclosure-based naming scheme should be used.  If so,
#	asks if it should be specified for all system(s) or individually.
#
#	Note:  This must be called before vxconfigd is started.
#	       This should only be executed if we're not configured yet or
#	       instructed to override.
#
# Input Parameters:
#	It uses the following globals:
#	$PROD{VM}{VOLD_STATUS}{$SYS}
#	$PROD{VM}{REBOOT}{$SYS} (Not used for now...)
# Output Parameters:
#	$CFG{NEWNAMES_FILE}{$SYS} = 1, if this scheme is used
# Called by:
#	_vm_sun_postinstall_questions()
#	_vm_linux_postinstall_questions()
sub _vm_ask_encl_names 
{

	_prod_plat_sub("VM","ask_encl_names");

} # _vm_ask_encl_names()

#
# Function: _vm_ask_encl_names_per_host()
# Purpose:
#	This is a helper function for _vm_*_ask_encl_names(); it asks
#	the user which systems will be configured for enclosure-based naming.
# Input Parameters:
#	list of systems
# Output Parameters:
#	0 - Needs to be called again
#	1 - Doesn't need to be called again
# Called by:
#	_vm_sun_ask_encl_names()
#	_vm_linux_ask_encl_names()
#
sub _vm_ask_encl_names_per_host {
my ($systems) = (@_);
my ($ayn1);
my ($sys);

	foreach $sys (@$systems)
	{
		$ayn1 = _ayny("\nFor system $sys, do you want to use the enclosure-based naming scheme?", 110, 1036, "$sys");

		if ($ayn1 eq "Y")
		{
			$CFG{NEWNAMES_FILE}{$sys} = 1;
		}
		else
		{
			$CFG{NEWNAMES_FILE}{$sys} = 0;
		}

	}

	_pl("\nYou have decided to configure enclosure-based naming as follows:\n", 110, 1037);

	foreach $sys (@$systems)
	{
		_pb1("Host: $sys", 110, 1019, "$sys");
		_pb2("Yes", 110, 1038) if ($CFG{NEWNAMES_FILE}{$sys});
		_pb2("No", 110, 1039) if (! $CFG{NEWNAMES_FILE}{$sys});
	}

	$ayn1 = _ayny("\nIs this correct?", 110, 1021);
	return 1 if ($ayn1 eq "Y");

	_pl("\nYou have responded no.  Configure again.", 110, 1109);
	return 0;
	
} # _vm_ask_encl_names_per_host()

# ask for product mode for pre-install check
# not required if your product is not mode based

#
# Function: _vm_disallow_reinstall()
# Purpose:
#	The caller has detected that /etc/vx/reconfig.d/state.d/install-db
#	is not present.  It assumed that VM is installed and configured.
#	We set a flag so that postinstall, start_product and poststart 
#	activities do not occur.
# Input Parameters:
#	$SYS
# Output Parameters:
#	Will update $PROD{VM}{NO_CONFIG}{$SYS}
# Called by:
#	_vm_sun_postinstall_questions()
#	_vm_linux_postinstall_questions()
#
sub _vm_disallow_reinstall
{

	_pl("The Volume Manager appears to have already been installed on the system $SYS.\n", 110, 1042, "$SYS");
	_pl("You will be prevented from performing post-installation activities, such as setting up the enclosure-based naming scheme and default disk group on this host.", 110, 1122);

	$PROD{VM}{NO_CONFIG}{$SYS} = 1;

	_prtc();

} # _vm_disallow_reinstall()

#
# Function: _vm_ask_upgrade_err()
# Purpose:
#	This emulates a task of vxinstall.  It displays a warning message
#	and prompts the user to continue. It is called because upgrade_start
#	had been run, but upgrade_finish was not yet run.
#	Note: It is improbable that someone would have used upgrade_start
#	      with CPI.
# Input Parameters:
#	None
# Output Parameters:
#	Will update $PROD{VM}{INSTALL}{$SYS}
# Called by:
#	_vm_sun_postinstall_questions()
#	_vm_linux_postinstall_questions()
#
sub _vm_ask_upgrade_err
{
	my ($msg, $ayn);
	_pl("WARNING: A previous upgrade of $PROD{VM}{ABBR} was not completed on system $SYS.\nContinuing or running any other $PROD{VM}{ABBR} utilities may severely damage the root filesystem and its configuration. By answering no, Volume Manager will not be reinitialized and vxconfigd will not be started automatically. You will need to start $PROD{VM}{ABBR} manually.\n", 110, 1045, "$PROD{VM}{ABBR}", "$SYS", "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}");

	$ayn=_aynn("\nDo you still want to continue", 110, 1046);
	if ($ayn eq "N")
	{
		$PROD{VM}{INSTALL}{$SYS} = "upgrade_start error";
		return;
	}
	$PROD{VM}{INSTALL}{$SYS} = "continue";

} # _vm_ask_upgrade_err()

sub _vm_comm_donotstartall {
	_warn("As you are upgrading your target systems, you will be unable to start $PROD{VM}{ABBR} processes or perform any further configuration tasks for $PROD{VM}{ABBR}.\n\nIn fact, you must reboot your target systems at the end of the installation. During the reboot, your default disk group will be automatically configured to be 'rootdg'.\n\nAfter rebooting, you may manually change the default disk group using the vxdctl(1M) command; review the manual pages for vxdctl(1M) and vxdg(1M) for further information about the default disk group.", 110, 1134, "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}"); 
	_prtc();
} # _vm_comm_donotstartall()


# display task completion information
sub _vm_comm_completion_messages {

	_prod_plat_sub("VM", "completion_messages");
	if ($FLAG{CHOSE_NOT_TO_START}) {
		_warn("As you chose not to start $PROD{VM}{ABBR}, the following types of events did not occur: 1) Various $PROD{VM}{ABBR} processes were not started; and 2) some configuration activities that interacted with these processes could not be performed.\n\nAs a result, $PROD{VM}{ABBR} is not ready to be started.  You will need to run $COMM{IPROG} -configure to complete the installation.\n\nNote: This does not apply to systems where you are upgrading $PROD{VM}{ABBR} or restoring previous $PROD{VM}{ABBR} configurations.", 110, 1121, "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}", "$COMM{IPROG}", "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}");
	}

} # _vm_comm_completion_messages()

#
# Function: _vm_dbg_pl()
# Purpose:
#	To display debug messages.
# Input Parameters:
#	A debug message.
# Output Parameters:
#	None
# Called by:
#	N/A
sub _vm_dbg_pl{

	my ($msg) = (@_);
	_pl("$msg", 110, 1048, "$msg") if ($FLAG{VMDBG});
}


# returns a commented definition of a install reqponsefile key for each key
# there are two calls.  _comm_define_cfgkey starts the definition
# creating the variable and defining its required/optional status,
# scalar/list status, and second dimension, if it is a 2d variable
# The second call to _tr defines what the variable is used for within
# the CPI libraries
sub _vm_comm_define_cfgkeys {
	my($cmt,$key);
	($key)=(@_);
	if ($key eq "DEFAULTDG") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the name of the default disk group.", 110, 1123);
	} elsif ($key eq "NEWNAMES_FILE") {
		$cmt=_comm_define_cfgkey($key,0,0, uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable indicates that the enclosure based naming scheme should be used (0: don't use the scheme; 1: use the scheme).", 110, 1050);
	} elsif ($key eq "VM_RESTORE_CFG") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable indicates if a previous $PROD{VM}{ABBR} configuration should be restored (0: don't restore; 1: do restore.) [Solaris only]", 110, 1124, "$PROD{VM}{ABBR}");
	} elsif ($key eq "VM_DMP_CFG") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable indicates if Dynamic MultiPathing (DMP)should be used (0: disabled; 1: disabled.) [Linux only]", 110, 1125);
	} 
	$cmt.="\n\n";
	$cmt=~s/\n/\n# /g;
	return "$cmt";
}
#
# Function: _vm_get_defaultdg()
# Purpose:
#	Prompts for a default disk group name.
# Input Parameters:
#	A prompt string
#	A list of systems that we need to run 'vxdg list' on...
#	A flag indicating that we need to run 'vxdg list' on all of the systems
# Output Parameters:
#	0 -		if user decided to quit
#	dgname -	disk group name
# Called by:
#	_vm_request_all_dgnames()
sub _vm_get_defaultdg
{
	my ($ayn, $out, $dgname, $systems, $flag);
	my ($buf);
	my ($dg_prompt)=$_[0];

	$systems=$_[1];
	$flag=$_[2];


	LINE: while (1)
	{
		if ($flag == 0)
		{
			$MSG{HELP}=_tr("You may specify a disk group name now or request a listing of the existing disk group names for system $$systems[0].  Type 'list' or 'l' to produce such a listing. The listing is generated from the output of the 'vxdg list' command. You may specify an existing disk group name or a new name.\n\nA valid disk group name is a string that consists of alphanumeric characters and the special characters '_' and '-'.\n\nIf you wish to not set a default disk group, type: nodg.", 110, 1126, "$$systems[0]");
			$MSG{HELP}.=_tr("\n\nNote: The word defaultdg is a reserved word and cannot be specified as a disk group name.", 110, 1118);
		} else {
			$MSG{HELP}=_tr("You may specify a disk group name now or request a listing of the existing disk group names of all of the systems.  Type 'list' or 'l' to produce such a listing. The listing is generated by running 'vxdg list' on all of the systems and combining the outputs. You may specify an existing disk group name or a new name.\n\nA valid disk group name is a string that consists of alphanumeric characters and the special characters '_' and '-'.\n\nIf you wish to not set a default disk group, type: nodg.", 110, 1127);
			$MSG{HELP}.=_tr("\n\nNote: The word defaultdg is a reserved word and cannot be specified as a disk group name.", 110, 1118);
		}
		$dgname=_ask("$dg_prompt", 110, 1048, "$dg_prompt");
		chomp($dgname);

		if ( $dgname eq "")
		{
			_warn("No disk group name was provided; it is required.\n", 110, 1054);
			next LINE;
		}
		elsif ( $dgname =~ /^list$/ || $dgname =~ /^l$/ )
		{
			if ($flag == 0)
			{
				$SYS=$$systems[0];
				$out=_dor("$CMD{VXDG} -q list");
			}
			else
			{
				foreach $SYS (@$systems)
				{
					$buf=_dor("$CMD{VXDG} -q list");
					if (!$out)
					{
						$out = $buf;
					}
					else
					{
						$out = "$out\n" . "$buf";
					} 
				}
			}
			if (!$out)
			{
				_pl("\nNo previous disk group(s) were detected.", 110, 1055);
				next LINE;
			}
			_pl("The following disk group(s) were detected.", 110, 1056);
			_pl($out);
			_prtc();
			next LINE;
		}
		elsif ( $dgname =~ /\w+\s+\w+/ )
		{
			_warn("Disk group name '$dgname' is invalid.\n", 110, 1057, "$dgname");
			next LINE;
		}
		elsif ( $dgname eq $DEF{DG_BOOT} )
		{
			_warn("\nYou cannot specify 'bootdg' now because you are installing $PROD{VM}{ABBR} and there is no systemwide default disk group set up yet for system $SYS.", 110, 1128, "$PROD{VM}{ABBR}", "$SYS");
			next LINE;
		}
		elsif ( $dgname eq $DEF{DG_DEFAULT} )
		{
			_warn("\nYou cannot specify 'defaultdg' because the word is reserved and is not allowed as a disk group name.", 110, 1119);
			next LINE;
		}
		elsif ( lc($dgname) eq "q" )
		{
			_pl("Quitting from setting the default disk group.\n", 110, 1058);
			return 0;
		}

		return $dgname; # if ($ayn eq "Y");

	} # while
} # _vm_get_defaultdg()


# determine the product mode, if necessary
# use info from hash returned by _comm_check_license
# not required if your product is not mode based

#
# Function: _vm_licenses_not_found()
# Purpose:
#	No longer used; keeping around just in case...
#	Determines if VM full or lite license is installed.
# Input Parameters:
#	None
# Output Parameters:
#	Returns 0, if either the full or lite license is installed.
#	Returns 1, if neither the full nor lite license is installed.
# Called by:
#	N/A
sub _vm_licenses_not_found
{
        # In running vxlictest, you may see output such as:
        # VxVM feature is licensed
        # VxVM Base feature is disabled
        my $full_lic=_dor("$CMD{VXLICTEST} -n 'VERITAS Volume Manager' -f VxVM 2>/dev/null");
        chomp($full_lic);

        my $base_lic=_dor("$CMD{VXLICTEST} -n 'VERITAS Volume Manager' -f 'VxVM Base' 2> /dev/null");
        chomp($base_lic);

        return 0 if ($full_lic =~ /is enabled/ || $base_lic =~ /is enabled/);
        return 1;
} # _vm_licenses_not_found()

# ask questions asked by pkg request scripts
# called indirectly by _comm_preinstall()
sub _vm_comm_pkgrequest_questions {
	_prod_plat_sub("VM", "pkgrequest_questions");
}

# perform any checks or tasks necessary after the product is installed

# Function: _vm_comm_postinstall()
# Purpose:
#	Performs some tasks normally done by vxinstall.
#	Basically, it does VM license processing and it
#	performs what _vm_comm_postinstall_questions() does, but for the
#	-responsefile case...  Instead of asking for user responses,
#	it just defaults to an error status.
# Input Parameters:
#	None
#	References $CFG{VM_RESTORE_CFG}{$SYS}
#	References $PROD{VM}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#	None
#	May modify $PROD{VM}{INSTALL}{$SYS} indirectly.
# Called by:
#	_comm_postinstall()
sub _vm_comm_postinstall {
my ($cnt);

	$cnt=0;
	_prod_plat_sub("VM","postinstall");
	foreach $SYS (@SYSI)
	{
		if ($FLAG{PKGUPGRADE}{VRTSvxvm}{$SYS}) {
			_dor("$CMD{TOUCH} /etc/vx/.cpi_rootdg");
			$cnt++;
		}
	}

	# If VM is being upgraded (point product or bundled solution) on all
	# systems, then we don't want to see the start product query as we
	# need to reboot.  Note that this will impact bundled solutions...
	if ($cnt == $#SYSI + 1) {
		$FLAG{DONOTSTARTALL}=1;
		_dor("$CMD{TOUCH} $PATH{DONOTSTARTALL}") if ($OPT{INSTALLONLY});
	}

} # _vm_comm_postinstall()

# ask configuration questions necessary following installation
#
# Function: _vm_comm_postinstall_questions()
# Purpose:
#	Performs some tasks normally done by vxinstall.
# Input Parameters:
#	None
#	References $CFG{VM_RESTORE_CFG}{$SYS}
#	References $PROD{VM}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#	None
#	May indirectly update $PROD{VM}{INSTALL}{$SYS}
# Called by:
#	_comm_postinstall()
sub _vm_comm_postinstall_questions {

	_prod_plat_sub("VM", "postinstall_questions");

} # _vm_comm_postinstall_questions()

# perform any checks or tasks necessary after the product is started
#
# Function: _vm_comm_poststart()
# Purpose:
#	Starts executing traditionally vxinstall tasks
# Input Parameters:
#	References indirectly $CFG{VM_RESTORE_CFG}{$SYS}
#	References indirectly $PROD{VM}{INSTALL}{$SYS}
#	References indirectly $PROD{VM}{VOLD_STATUS}{$SYS}
# Output Parameters:
#	None
# Called by:
#	__comm_start_product()
sub _vm_comm_poststart {
	_prod_plat_sub("VM", "poststart");
}

# perform preinstallation tasks 
# use $COMM{TASK} or $OPT to filter, if necessary
# Function: _vm_comm_preinstall()
# Purpose:
#	For Solaris, indirectly creates the response file.
#	It also does some request script tasks, such as making the
#	previous configuration stale.
# Input Parameters:
#	None
# Output Parameters:
#	None
# Called by:
#	_comm_preinstall()
sub _vm_comm_preinstall {

	_prod_plat_sub("VM", "preinstall");
}


# perform any checks or tasks necessary after the product is started
#
# The following needs to be checked:
# 1. Does the target system have an encapsulated boot disk?
# 2. Is this an upgrade?  That is, is VxVM already installed?
# 3. Does it have the appropriate AP patches, if AP is installed for Solaris.

sub _vm_comm_prestop {

my($iv, $rc);

	if ($OPT{UNINSTALL}) {
		# Need to check for VxVM in here because prestop() is invoked
		# even when VM is not installed.
		return if (! $PKGI{$PROD{VM}{MAINPKG}}{IVERS}{$SYS});

		# Checking for open volumes includes a bootdisk that may be
		# under VM control, if this is supported.
		$rc = _vm_open_volumes();

		if ($rc) {
			_die("Cannot continue because of the open volumes.", 110, 1129);
		}
	}

	_prod_plat_sub("VM", "prestop");

} # _vm_comm_prestop()

#
# Function: _vm_encapsulated_bootdisk()
# Purpose:
#	Determines if the bootdisk is encapsulated.
# Input Parameters:
#	References $SYS
# Output Parameters:
#	1: true
#	0: false
# Called by:
#	_vm_linux_prestop()
sub _vm_encapsulated_bootdisk {
my($out);

	_pb1("Checking $SYS for encapsulated bootdisk", 110, 1079, "$SYS");
	$out=_dor("$CMD{MOUNT} | grep rootvol");

	if (not $out) {
		_pb2("Not encapsulated", 110, 1091);
		return 0;
	}

	_pb2("Encapsulated", 110, 1092);
	_warn("\n* Cannot install $PROD{VM}{ABBR} on system $SYS because the bootdisk is encapsulated.  Run vxunroot to unencapsulate the bootdisk.\n", 110, 1113, "$PROD{VM}{ABBR}", "$SYS") if (! $OPT{PRECHECK});
	_ckmsg("Cannot install $PROD{VM}{ABBR} on system $SYS because the bootdisk is encapsulated.  Run vxunroot to unencapsulate the bootdisk\n", 110, 1114, "$PROD{VM}{ABBR}", "$SYS") if $OPT{PRECHECK};

	return 1;

} # _vm_encapsulated_bootdisk()

#
# Function: _vm_open_volumes()
# Purpose:
#	Determines if any VM volumes are open.
# Input Parameters:
#	References $SYS
# Output Parameters:
#	1: true
#	0: false
# Called by:
#	_vm_linux_prestop()
sub _vm_open_volumes {
my($ayn, $out, $vlist, @volumes, $num, $voldmode);

		$voldmode=_dor("$CMD{VXDCTL} mode 2> /dev/null");
		if ( not $voldmode =~ /mode: enabled/ )
		{
			# Cannot use vxprint; 
			# Using vxkprint doesn't always work either.
			_bpl("Cannot check for open volumes on $SYS because the vxconfigd process is not in enabled mode.  You must affirm that there are no open volumes if you want to continue.\n", 110, 1135, "$SYS");
			$ayn = _aynn("Are there any open volumes on $SYS", 110, 1131, "$SYS");
			return ($ayn eq "N" ? 0 : 1);
		}

		_pb1("Checking $SYS for open volumes", 110, 1097, "$SYS");
		$out=_dor("$CMD{VXPRINT} -QAqne v_open");
		@volumes=split(/\n/,$out);
		if ($#volumes < 0)
		{
			_pb2("None", 110, 1063);
			return 0;
		}
		
		$num=$#volumes + 1;
		if ($num == 1)
		{
			_pb2("1 open volume", 110, 1064);
		}
		else
		{
			_pb2("$num open volumes", 110, 1065, "$num");
		}

		$vlist=join(" ", @volumes);
		_warn("\n* Cannot $COMM{TASK} $PROD{VM}{ABBR} on system $SYS because the following volumes are open: $vlist\n\n  Unmount the volumes or stop their use.\n", 110, 1132, "$COMM{TASK}", "$PROD{VM}{ABBR}", "$SYS", "$vlist") if (! $OPT{PRECHECK});
		_ckmsg("Cannot $COMM{TASK} $PROD{VM}{ABBR} on system $SYS because the following volumes are open: $vlist\n\n  Unmount the volumes or stop their use.\n", 110, 1133, "$COMM{TASK}", "$PROD{VM}{ABBR}", "$SYS", "$vlist") if $OPT{PRECHECK};

		return 1;

} # _vm_open_volumes()

#
# Function: _vm_special_lic_avail()
# Purpose:
#	Determines if special VM licenses are available.  For instance,
#	this is true if an SSA or A5K array is attached to a Solaris system.
# Input Parameters:
#	References $SYS
# Output Parameters:
#	1: true
#	0: false
# Called by:
#	_comm_licensing()
sub _vm_special_lic_avail
{
	_prod_plat_sub("VM", "special_lic_avail");
} # _vm_special_lic_avail()

#
# Function: _vm_start_product()
# Purpose:
#	Performs functions normally done by vxinstall.
#	1. Configures enclosure-based naming scheme
#	2. Starts vxconfigd
#	3. Runs vxdctl
#	4. Removes install-db
# Input Parameters:
#	References $PROD{VM}{VOLD_STATUS}{$SYS}
#	References $PROD{VM}{INSTALL}{$SYS}
#	References $PROD{VM}{REBOOT}{$SYS} -- No used for now
# Output Parameters:
#	0	product started successfully
#	1	product did not start successfully
# Called by:
#	_comm_start_product()
sub _vm_comm_start_product {

	_prod_plat_sub("VM", "start_product");

} # _vm_comm_start_product()

#
# Function: _vm_comm_initial_systemcheck()
# Purpose:
# 	Dynamically creates the required OS patch list.
# 
# Input Parameters:
#	None
# Output Parameters:
#	Indirectly modifies @{$COMM{REQOSPATCHES}{$SYS}}
# Called by:
#	_comm_initial_systemcheck()
sub _vm_comm_initial_systemcheck {

	_prod_plat_sub("VM","initial_systemcheck");

} # _vm_comm_initial_systemcheck()

#
# Function: _vm_comm_verify_responsefile()
# Purpose:
# 	Verifies that the %CFG information read by -responsefile is valid
# 
# 	The only relevant %CFG variables are as follows:
# $CFG{DEFAULTDG}{$SYS} 
#	voldg.c shows that a valid dgname is purely an ASCII string.
#	As long as the dgname is specified, it should resolve to an ASCII
#	string; so no test is implemented.  The assumption is that the admin
#	has not set it to some complex Perl data structure.
#
# $CFG{NEWNAMES_FILE}{$SYS}
#	if 1, indicates that enclosure based names will be used on the system
#	if 0, indicates that enclosure based names won't be used on the system
#
# $CFG{VM_RESTORE_CFG}{$SYS}
#	if 1, indicates that we will restore and reuse the old VM config
#	if 0, indicates that we will neither restore nor reuse the old VM config
#
# $CFG{VM_DMP_CFG}{$SYS} -- for Linux
#	if 1, indicates that we will enable DMP
#	if 0, indicates that we will disable DMP
# Input Parameters:
#	None
# Output Parameters:
#	None
#	This will _die upon displaying error messages.
# Called by:
#	_comm_process_args()
sub _vm_comm_verify_responsefile {

	_prod_plat_sub("VM", "verify_responsefile");

} # _vm_comm_verify_responsefile()

#
# Function: _vm_verify_vxconfigds() 
# Purpose:
# 	Verifies that vxconfigd on all nodes are enabled
# 
# Input Parameters:
#	References $PROD{VM}{VOLD_STATUS}{$sys}
# Output Parameters:
#	0	false
#	1	true
# Called by:
#	N/A -- generic library routine (needed for SPFS);
#	       must be invoked after start_product().
sub _vm_verify_vxconfigds {
my ($sys);

	foreach $sys (@SYSI)
	{
		if ($PROD{VM}{VOLD_STATUS}{$sys} ne "enabled")
		{
			_warn("vxconfigd on system $sys is not enabled", 110, 1080, "$sys") 
				if ($FLAG{DEBUG});
			return 0;
		}
	}
	return 1;
} # _vm_verify_vxconfigds()
1;
#SCC#
#SCC# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
#SCC# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#SCC#
#SCC#

# Define frequently used commands
$CMD{VVRPORT}="/usr/sbin/vrport";
$CMD{VVRSTART}="/usr/sbin/vxstart_vvr";
$CMD{VVRSTOP}="/usr/sbin/vxstart_vvr stop";

# Define start and stop commands for processes and drivers
# which are common across all four Unix platforms

# Define product configuration files
# $CONF{CONFIG}="/etc/prodconf/config";

# Define frequently referenced paths

# Define product information
$PROD{VVR}{NAME}="VERITAS Volume Replicator";
$PROD{VVR}{ABBR}="VVR";
$PROD{VVR}{DIR}="volume_manager";
$PROD{VVR}{LICUPI}="VM";
$PROD{VVR}{LICFEATURE}="VVR";

# Define macros specific to VVR
$DEF{VVR_MAX_PORT}=65535;
$DEF{VVR_MIN_PORT}=1024;
$DEF{VRAS_LOG_SIZE}=30;
$DEF{VRAS_STR}="VRAS_LOG_MAXLEN=";

#Define VVR tunables for linux platform

# VVR tunable vol_max_wrspool_sz commented 

$DEF{vol_rvio_maxpool_sz}{Linux}=128;
$DEF{vol_max_rdback_sz}{Linux}=128;
$DEF{vol_max_nmpool_sz}{Linux}=128;
#$DEF{vol_max_wrspool_sz}{Linux}=128;
$DEF{vol_min_lowmem_sz}{Linux}=520;

$PKGI{VRTStep}{SOFTDEP} = [ "VRTSvrpro", "VRTSfspro" ];
$PKGI{VRTSap}{SOFTDEP} = [ "VRTSvrpro", "VRTSfspro" ];

# display task completion information
sub _vvr_comm_completion_messages {
	_vm_comm_completion_messages();
}

# ask questions asked by pkg request scripts
sub _vvr_comm_pkgrequest_questions {
	_vm_comm_pkgrequest_questions();
}

# perform any checks or tasks necessary after the product is installed
sub _vvr_comm_postinstall {
	_vm_comm_postinstall();
	# If response file is being used, use the 
	# CFG variables to configure 
	foreach $SYS(@SYSI) {
		# These variables would only be defined if a response
		# file is being used ( in _vvr_verify_response_file )
		if (defined($CFG{VVR_HB_PORT}{$SYS})) {
			_vvr_set_port("heartbeat",$CFG{VVR_HB_PORT}{$SYS});
		}
		if (defined($CFG{VVR_VRADMIND_PORT}{$SYS})) {
			_vvr_set_port("vradmind",$CFG{VVR_VRADMIND_PORT}{$SYS});
		}
		if (defined($CFG{VVR_VXRSYNCD_PORT}{$SYS})) {
			_vvr_set_port("vxrsyncd",$CFG{VVR_VXRSYNCD_PORT}{$SYS});
		}
		if (defined($CFG{VVR_DATA_PORTS}{$SYS})) {
			_vvr_set_port("data",$CFG{VVR_DATA_PORTS}{$SYS});
		}
		if (defined($CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS})) {
			_vvr_set_log_size($CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS});
		}
		if (defined($CFG{VOL_RVIO_MAXPOOL_SZ}{$SYS})) {
			_vvr_set_tunables("vol_rvio_maxpool_sz",
				$CFG{VOL_RVIO_MAXPOOL_SZ}{$SYS});
		}
	}
}

# ask configuration questions necessary following installation
sub _vvr_comm_postinstall_questions {
	_vm_comm_postinstall_questions();
	_vvr_config_ports();
	_vvr_config_vras();
	_vvr_config_tunables();
}

# perform the configuration tasks as specified by the 
# configuration variables
sub _vvr_comm_create_configfiles {
	foreach $SYS(@SYSI) {

		_pb1("Configuring VVR on host $SYS", 130, 1000, "$SYS");

		#Set the ports 
		_vvr_set_port("heartbeat",$CFG{VVR_HB_PORT}{$SYS});
		_vvr_set_port("vradmind",$CFG{VVR_VRADMIND_PORT}{$SYS});
		_vvr_set_port("vxrsyncd",$CFG{VVR_VXRSYNCD_PORT}{$SYS});
		_vvr_set_port("data",$CFG{VVR_DATA_PORTS}{$SYS});

		#Set the new log size 
		_vvr_set_log_size($CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS});

		# set the new tunable settings
		_vvr_set_tunables("vol_rvio_maxpool_sz",
			$CFG{VOL_RVIO_MAXPOOL_SZ}{$SYS});
		_vvr_set_tunables("vol_min_lowmem_sz",
			$CFG{VOL_MIN_LOWMEM_SZ}{$SYS});
		_vvr_set_tunables("vol_max_rdback_sz",
			$CFG{VOL_MAX_RDBACK_SZ}{$SYS});
		_vvr_set_tunables("vol_max_nmpool_sz",
			$CFG{VOL_MAX_NMPOOL_SZ}{$SYS});
#		_vvr_set_tunables("vol_max_wrspool_sz",
#			$CFG{VOL_MAX_WRSPOOL_SZ}{$SYS});
		_pb2("Done", 130, 1001);
	}
}

# perform any checks or tasks necessary after the product is started
sub _vvr_comm_poststart {
	_vm_comm_poststart();
}

# perform preinstallation tasks
# use $COMM{TASK} or $OPT to filter, if necessary
sub _vvr_comm_preinstall {
	_vm_comm_preinstall();
	# If upgrade is being updated, prompt that vvr does not support
	# upgrade. Should we be returning an error code to SF so that 
	# further vvr commands are not invoked?

	# Initialize for the responsefile
	push(@{$COMM{PRODUCTIRFKEYS}},qw(VVR_HB_PORT VVR_VRADMIND_PORT VVR_VXRSYNCD_PORT VVR_DATA_PORTS VVR_MAX_VRAS_LOGSIZE VOL_RVIO_MAXPOOL_SZ VOL_MIN_LOWMEM_SZ VOL_MAX_RDBACK_SZ VOL_MAX_NMPOOL_SZ VOL_MAX_WRSPOOL_SZ));
}

# perform any checks or tasks necessary before the product is stopped
sub _vvr_comm_prestop {
	# _vm_comm_prestop should be invoked only if VRTSvxvm is being 
	# removed as well.
	_vm_comm_prestop() if ($FLAG{UNINSTALLING}{VRTSvxvm});
}

# stop VVR processes
sub _vvr_comm_stop_processes {
	_pb1("Stopping VVR processes on host $SYS", 130, 1002, "$SYS");
	# Stop vxnetd, vradmind and vxrsyncd
	_dor("$CMD{VVRSTOP} > /dev/null 2>&1");
	_pb2("Done", 130, 1001);
}

# start the product, return 1 if product does not start
#
# Function: _vvr_comm_start_product()
# Purpose:
#	Starts the following deamons:
#	vxnetd, vxrsyncd and vradmind.
# Input Parameters:
#	None
# Output Parameters:
#	None
# Called by:
#       _vvr_comm_start_product()
sub _vvr_comm_start_product {
	_vm_comm_start_product();
	# Check the vold status. If not enabled, do not start VVR.
	foreach $SYS(@SYSI) {
		if ($PROD{VM}{VOLD_STATUS}{$SYS} eq "enabled") {
			_pb1("Starting VVR processes on host $SYS", 130, 1003, "$SYS");
			# Start vxnetd, vradmind and vxrsyncd
			_dor("$CMD{REX} $CMD{VVRSTART} > /dev/null 2>&1");
			_pb2("Done", 130, 1001);
			next;
		}
	}
}

# this routine will be used to configure ports to be used by VVR
sub _vvr_config_ports {
	my($ayn,$done,$op,@en,$all,$numsys);
	$numsys=@SYSI;
	foreach $SYS(@SYSI) {
		if ($all) {
			$CFG{VVR_HB_PORT}{$SYS}=$en[1];
			$CFG{VVR_VRADMIND_PORT}{$SYS}=$en[2];
			$CFG{VVR_VXRSYNCD_PORT}{$SYS}=$en[3];
			$CFG{VVR_DATA_PORTS}{$SYS}=$en[4];
			next;
		}
		undef(@en);
		_title();
		$done=0;
		_bpl("Following are the default ports that will be used by VVR on $SYS :", 130, 1004, "$SYS");
		_vvr_init_cfg_ports();
		_vvr_display_ports();

		if ($CFG{VVR_HB_PORT}{$SYS} == 4145  && $CFG{VVR_VRADMIND_PORT}{$SYS} == 8199) {
			_pl("The ports indicated for VVR heartbeats and vradmind are IANA assigned.\n", 130, 1005);
		} elsif ($CFG{VVR_HB_PORT}{$SYS} == 4145) {
			_pl("The port indicated for VVR heartbeats is IANA assigned.\n", 130, 1083);
		} elsif ($CFG{VVR_VRADMIND_PORT}{$SYS} == 8199) {
			_pl("The port indicated for vradmind is IANA assigned.\n", 130, 1084);
		}

		_pl("The port settings should be identical for systems that will be part of the same Replicated Data Set.They should also be identical for all the systems in a cluster.\n", 130, 1006);

		$ayn=_aynn("Do you want to change any of the VVR ports on $SYS?", 130, 1085, "$SYS");
		if ($ayn eq "Y") {
			while(!$done) {
				$en[1]=_vvr_ask_hb_port();
				$en[2]=_vvr_ask_vradmind_port();
				$en[3]=_vvr_ask_vxrsync_port();
				$en[4]=_vvr_ask_data_ports();

				_pl("\nFollowing are the ports that will be used by VVR on $SYS:", 130, 1086, "$SYS");
				# Call routine to display CFG_PORT variables
				_vvr_display_ports();
				$ayn=_ayny("Is this information correct?", 130, 1009);
				$done=1 if ($ayn eq "Y");
			}
		} # if $ayn.. 

		if (($SYS eq $SYSC[0]) && ($numsys > 1)) {
			$ayn=_ayny("Do you want to use the same port settings on all systems?", 130, 1010);
			$all=1 if($ayn eq "Y");
		}
	} #foreach sys
}

# This routine displays the ports that are
# used for VVR. It must always be invoked
# within a SYSI loop; as it uses the 
# per-system CFG variables
sub _vvr_display_ports {
	_pl("\nPort for VVR heartbeat communication: $CFG{VVR_HB_PORT}{$SYS}", 130, 1011, "$CFG{VVR_HB_PORT}{$SYS}");
	_pl("Port for vradmind daemon: $CFG{VVR_VRADMIND_PORT}{$SYS}", 130, 1012, "$CFG{VVR_VRADMIND_PORT}{$SYS}");
	_pl("Port for vxrsyncd daemon: $CFG{VVR_VXRSYNCD_PORT}{$SYS}", 130, 1013, "$CFG{VVR_VXRSYNCD_PORT}{$SYS}");
	_pl("Ports for data replication: $CFG{VVR_DATA_PORTS}{$SYS}\n", 130, 1014, "$CFG{VVR_DATA_PORTS}{$SYS}");
}

#
# Function: _vvr_verify_port()
# Purpose:
# This routine will be used to validate a port no.
sub _vvr_verify_port {
	my($port,$ret);
	($port)=(@_);
	$ret=0;
	if (_isint($port) || $port < $DEF{VVR_MIN_PORT} || $port > $DEF{VVR_MAX_PORT}) {
		$ret=1;
	}
	return $ret;
}

# This routine will be used to verify range of port nos.
# port range should be of the form <port>-<port> or just
# <port>
sub _vvr_verify_port_range {
	my($port,$ret,@range,$mynum);
	($port)=(@_);
	# Checks for valid values 
	# If valid port, return valid
	if (!_vvr_verify_port($port)) {	
		return 0;
	}
	if ($port eq "Anonymous-Ports") {	
		return 0;
	}

	# Checks for invalid values 
	# Else, break down using split
	@range=split(/-/,$port);
	$mynum=@range;
	if ($mynum != 2) {
		return 1;	
	}
	if (_vvr_verify_port($range[0]) || 
		_vvr_verify_port($range[1])) {	
		return 1;
	}
	if ($range[0] >= $range[1]) { 
		return 1;
	}
	return 0;
}

sub _vvr_ask_hb_port {
	my($ask,$done);
	#$COMM{DEFANSWER}=_dor("vrport heartbeat",0);
	# Set all the CFG_PORTS to output of existing vrport command;
	# Subsequently use the CFG_PORT variables as the DEFANSWER

	$COMM{DEFANSWER}=$CFG{VVR_HB_PORT}{$SYS};
	while(!$done) {
		$MSG{HELP}=_tr("Valid range of VVR ports is $DEF{VVR_MIN_PORT}-$DEF{VVR_MAX_PORT}.", 130, 1061, "$DEF{VVR_MIN_PORT}", "$DEF{VVR_MAX_PORT}");
		$ask=_ask("\nEnter the port to be used for VVR heartbeats:", 130, 1016);
		if(_vvr_verify_port($ask)) {
			_pl("Invalid Entry! Enter an integer value between $DEF{VVR_MIN_PORT} and $DEF{VVR_MAX_PORT}. \n", 130, 1088, "$DEF{VVR_MIN_PORT}", "$DEF{VVR_MAX_PORT}");
		} else {
			$done=1;
		}
	}

	# Set CFG variable to be stored in response file
	$CFG{VVR_HB_PORT}{$SYS}=$ask;
	return $CFG{VVR_HB_PORT}{$SYS};
}

sub _vvr_ask_vradmind_port {
	my($ask,$done);
	#$COMM{DEFANSWER}=_dor("vrport vradmind",0);

	$COMM{DEFANSWER}=$CFG{VVR_VRADMIND_PORT}{$SYS};
	while(!$done) {
		$MSG{HELP}=_tr("Valid range of VVR ports is $DEF{VVR_MIN_PORT}-$DEF{VVR_MAX_PORT}.", 130, 1061, "$DEF{VVR_MIN_PORT}", "$DEF{VVR_MAX_PORT}");
		$ask=_ask("\nEnter the port to be used by vradmind:", 130, 1062);
		if(_vvr_verify_port($ask)) {
			_pl("Invalid Entry! Enter an integer value between $DEF{VVR_MIN_PORT} and $DEF{VVR_MAX_PORT}. \n", 130, 1088, "$DEF{VVR_MIN_PORT}", "$DEF{VVR_MAX_PORT}");
		} else {
			$done=1;
		}
	}

	# Set CFG variable 
	$CFG{VVR_VRADMIND_PORT}{$SYS}=$ask;
	return $CFG{VVR_VRADMIND_PORT}{$SYS};
}

sub _vvr_ask_vxrsync_port {
	my($ask,$done);
	$COMM{DEFANSWER}=$CFG{VVR_VXRSYNCD_PORT}{$SYS};
	while(!$done) {
		$MSG{HELP}=_tr("Valid range of VVR ports is $DEF{VVR_MIN_PORT}-$DEF{VVR_MAX_PORT}.", 130, 1061, "$DEF{VVR_MIN_PORT}", "$DEF{VVR_MAX_PORT}");
		$ask=_ask("\nEnter the port to be used by vxrsyncd:", 130, 1063);
		if(_vvr_verify_port($ask)) {
			_pl("Invalid Entry! Enter an integer value between $DEF{VVR_MIN_PORT} and $DEF{VVR_MAX_PORT}.\n", 130, 1089, "$DEF{VVR_MIN_PORT}", "$DEF{VVR_MAX_PORT}");
		} else {
			$done=1;
		}
	}

	# Set CFG variable to be stored in response file
	$CFG{VVR_VXRSYNCD_PORT}{$SYS}=$ask;
	return $CFG{VVR_VXRSYNCD_PORT}{$SYS};
}

sub _vvr_ask_data_ports {
	my($done,$ask);
	while(!$done) {
		$COMM{DEFANSWER}=$CFG{VVR_DATA_PORTS}{$SYS};
		$MSG{HELP}=_tr("Valid range of VVR ports is $DEF{VVR_MIN_PORT}-$DEF{VVR_MAX_PORT}.", 130, 1061, "$DEF{VVR_MIN_PORT}", "$DEF{VVR_MAX_PORT}");
		$ask=_ask("\nEnter the port (or range of ports) to be used for replication.(eg:12100-12150): ", 130, 1064);
		if(_vvr_verify_port_range($ask)) {
			_pl("Invalid Entry! Enter a valid range of ports between $DEF{VVR_MIN_PORT} and $DEF{VVR_MAX_PORT} (eg: 12100-12150).\n", 130, 1090, "$DEF{VVR_MIN_PORT}", "$DEF{VVR_MAX_PORT}");
		} else {
			$done=1;
		}
	}

	# Set CFG variable to be stored in response file
	$CFG{VVR_DATA_PORTS}{$SYS}=$ask;
	return $CFG{VVR_DATA_PORTS}{$SYS};
}

sub _vvr_set_port {
	my($port,$server);
	($server,$port)=(@_);
	# port range of Anonymous-Ports should not be attempted.
	if ($port ne "Anonymous-Ports") {	
		_dor("$CMD{VVRPORT} $server $port");
	} 
}

sub _vvr_config_vras {
	my(@en,$all,$ayn,$done,$maxlog,$numsys);

	$numsys=@SYSI;
	foreach $SYS(@SYSI) {
		if ($all) {
			$CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS}=$en[1];
			next;
		}
		undef(@en); 
		_title();
		$done=0;
		# Initialize the vras max debug log size
		_vvr_init_vras_logsize();

		_pl("The maximum size of the VRAS debug log on $SYS is set to $CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS} MB.\n", 130, 1023, "$SYS", "$CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS}");

		$ayn=_aynn("Do you want to change this ?", 130, 1024);
		if ($ayn eq "Y") {
			while(!$done) {
				_vvr_ask_log_size($maxlog);

				_pl("The maximum size of the VRAS debug log on $SYS will be set to $CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS} MB. \n", 130, 1025, "$SYS", "$CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS}");
				$ayn=_ayny("Is this information correct?", 130, 1009);
				$done=1 if ($ayn eq "Y");
			}
		}
		if (($SYS eq $SYSC[0]) && ($numsys > 1)) {
			$ayn=_ayny("Do you want to use the same setting on all systems?", 130, 1026);
			$all=1 if($ayn eq "Y");
		}
	}
}

sub _vvr_ask_log_size {
	my($ask,$done);
	$COMM{DEFANSWER}=$CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS};
	while(!$done) {
		$ask=_ask("\nEnter the value, in MB, to be used as maximum size of VRAS debug logs:", 130, 1065);
		if (_isint($ask) || $ask<=0) {
			_pl("Invalid Entry! Enter an integer value. \n", 130, 1091);
		} else {
			$done=1;
		}
	}

	#Set CFG variable
	$CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS}=$ask;
}

sub _vvr_display_log_size {
	my ($maxlog);
	($maxlog)=(@_);
	# Multiply by 3 to get the actual max log size	
	$maxlog*=3;
	# Divide by 1048576 to convert bytes into MB
	$maxlog/=1048576;
	# round off to nearest integer and return
	return int($maxlog+0.5);
}

# Accepts the log size in MB (combined log size for 3 vras logs)
# converts it into form used by vras in vras_env and stores it.
sub _vvr_set_log_size {
	my($newval,$file,$infile,$outfile,$ret);
	($newval)=(@_);
	$infile="/tmp/vras_env.in";
	$outfile="/tmp/vras_env.out";

	# Convert to store in /etc/vx/vras/vras_env
	# Divide by 3 to get maximum log size of each of the vradmin_log_A,B..
	$newval/=3;
	# Multiply to convert MB to bytes.
	$newval*=1048576;
	# Round off to nearest integer
	$newval=int($newval+0.5);

	$ret = _copy("$CONF{VRASCONF}", $infile,1);

#	if (_localsys()) {
#		# Use the local vras env file
#		$ret=_dol("cp $CONF{VRASCONF} $infile",1);
#	} else {
#		# rcp the remote file
#		$ret=_dol("rcp $SYS:$CONF{VRASCONF} $infile",1);
#	}

	_die(" Could not access $CONF{VRASCONF} ", 130, 1029, "$CONF{VRASCONF}") if ($ret);

	# Open files
	open(ifh,$infile)  || 
		_die("Cannot open vras_env file $file ${!}", 130, 1094, "$file", "${!}");
	open(ofh,">$outfile") || 
		_die("Cannot create temporary file $outfile ${!}", 130, 1102, "$outfile", "${!}");

	while (<ifh>) {
		chomp($_);
		if (/^\export VRAS_LOG_MAXLEN/) {
			print ofh "export VRAS_LOG_MAXLEN\n";
			next;
		}
		if ((/^\#VRAS_LOG_MAXLEN=/) || (/^\VRAS_LOG_MAXLEN=/)) {
			print ofh "VRAS_LOG_MAXLEN=$newval\n";
			next;
		}
		print ofh "$_\n";
	}

	# close files
	close (ifh);
	close (ofh);

	#Override orig vras_env with tmp. 
	_copy($outfile,$CONF{VRASCONF});

	#This may be "configureonly" run. Hence stop vradmind.
	#It will be started in start_product. It should not be
	#started here as vxconfigd may not be running now.
	_dor("$CONF{VRAS_SCRIPT} stop");
}

#
# Function: _vm_comm_verify_responsefile()
# Purpose:
#       Verifies that the %CFG information read by -responsefile is valid
#
#       The only relevant %CFG variables are as follows:
# $CFG{VVR_HB_PORT}{$SYS}
#	If not defined, uses the default value(4145)
# $CFG{VVR_VRADMIND_PORT}{$SYS}
#	If not defined, uses the default value()
# $CFG{VVR_VXRSYNCD_PORT}{$SYS}
#	If not defined, uses the default value()
# $CFG{VVR_DATA_PORTS}{$SYS}
#	If not defined, uses the default value()
# $CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS}
#	If not defined, uses the default value()
#
# Input Parameters:
#       None
# Output Parameters:
#       None
#       This will _die upon displaying error messages.
# Called by:
#       _comm_process_args()

sub _vvr_comm_verify_responsefile {
	my ($sys, $msg, $do_die);

	_vm_comm_verify_responsefile();
	$do_die=0;
	foreach $sys(@{$CFG{INSTALL}{SYSTEMS}}) {

		# Heartbeat port
		if (!defined($CFG{VVR_HB_PORT}{$sys}) || 
		   $CFG{VVR_HB_PORT}{$sys}=="" ) {
			# use default value
			$CFG{VVR_HB_PORT}{$sys}=_dor("vrport heartbeat",0);
		} else {
			# variable is defined. validate it
			if(_vvr_verify_port($CFG{VVR_HB_PORT}{$sys})) {
				_pl("$CFG{VVR_HB_PORT}{$sys} is invalid\n", 130, 1030, "$CFG{VVR_HB_PORT}{$sys}");
				$do_die=1;
			}
		}

		# vradmind port
		if (!defined($CFG{VVR_VRADMIND_PORT}{$sys}) || 
		   $CFG{VVR_VRADMIND_PORT}{$sys}=="" ) {
			# use default value
			$CFG{VVR_VRADMIND_PORT}{$sys}=_dor("vrport vradmind",0);
		} else {
			# variable is defined. validate it
			if(_vvr_verify_port($CFG{VVR_VRADMIND_PORT}{$sys})) {
				_pl("$CFG{VVR_VRADMIND_PORT}{$sys} is invalid\n", 130, 1030, "$CFG{VVR_VRADMIND_PORT}{$sys}");
				$do_die=1;
			}
		}

		# vxrsyncd port
		if (!defined($CFG{VVR_VXRSYNCD_PORT}{$sys}) || 
		   $CFG{VVR_VXRSYNCD_PORT}{$sys}=="" ) {
			# use default value
			$CFG{VVR_VXRSYNCD_PORT}{$sys}=_dor("vrport vxrsyncd",0);
		} else {
			# variable is defined. validate it
			if(_vvr_verify_port($CFG{VVR_VXRSYNCD_PORT}{$sys})) {
				_pl("$CFG{VVR_VXRSYNCD_PORT}{$sys} is invalid\n", 130, 1030, "$CFG{VVR_VXRSYNCD_PORT}{$sys}");
				$do_die=1;
			}
		}

		# data port
		if (!defined($CFG{VVR_DATA_PORTS}{$sys}) || 
		   $CFG{VVR_DATA_PORTS}{$sys}=="" ) {
			# use default value
			$CFG{VVR_DATA_PORTS}{$sys}=_dor("vrport data",0);
		} else {
			# variable is defined. validate it
			if(_vvr_verify_port_range($CFG{VVR_DATA_PORTS}{$sys})) {
				_pl("$CFG{VVR_DATA_PORTS}{$sys} is invalid\n", 130, 1030, "$CFG{VVR_DATA_PORTS}{$sys}");
				$do_die=1;
			}
		}

		#Max VRAS debug log size 
		if (!defined($CFG{VVR_MAX_VRAS_LOGSIZE}{$sys}) || 
		   $CFG{VVR_MAX_VRAS_LOGSIZE}{$sys}=="" ||
		   $CFG{VVR_MAX_VRAS_LOGSIZE}{$sys}==0 ) {

			#set $CFG{VVR_MAX_VRAS_LOGSIZE}{$sys} to existing value
			_vvr_init_vras_logsize();

		} else {
			# variable is defined. validate it
			if (_isint($CFG{VVR_MAX_VRAS_LOGSIZE}{$sys}) || 
			   $CFG{VVR_MAX_VRAS_LOGSIZE}{$sys}<=0) {
				_pl("$CFG{VVR_MAX_VRAS_LOGSIZE}{$sys} is invalid.\n", 130, 1031, "$CFG{VVR_MAX_VRAS_LOGSIZE}{$sys}");
				$do_die=1;
			}
		}

		$do_die=_vvr_verify_response_tunables(vol_rvio_maxpool_sz,$sys);
		$do_die=_vvr_verify_response_tunables(vol_min_lowmem_sz,$sys);
		$do_die=_vvr_verify_response_tunables(vol_max_rdback_sz,$sys);
		$do_die=_vvr_verify_response_tunables(vol_max_nmpool_sz,$sys);
#		$do_die=_vvr_verify_response_tunables(vol_max_wrspool_sz,$sys);

	} # end of for sys
	_die() if $do_die;
}

# This routine is to be called from withing a foreach SYS loop 
# It handles the _verify_responsefile stuff for each tunable
sub _vvr_verify_response_tunables {

	my($tunable,$var,$ret,$sys);
	($var,$sys)=(@_);

	$ret=0;
	$tunable = uc $var;

	if (!defined($CFG{$tunable}{$sys}) || 
	   $CFG{$tunable}{$sys}=="" ) {
		# use default value
		$CFG{$tunable}{$sys}=
			_dor("$CMD{VXTUNE} $var",0);
	} else {
		# variable is defined. validate it
		if(_vvr_verify_mempool($CFG{$tunable}{$sys},$var)) {
			_pl("$CFG{$tunable}{$sys} is invalid\n", 130, 1030, "$CFG{$tunable}{$sys}");
			$ret=1;
		}
	}
	return $ret;
}

# returns a commented definition of a install reqponsefile key for each key
# there are two calls.  _comm_define_cfgkey starts the definition
# creating the variable and defining its required/optional status,
# scalar/list status, and second dimension, if it is a 2d variable
# The second call to _tr defines what the variable is used for within
# the CPI libraries
sub _vvr_comm_define_cfgkeys {
        my($cmt,$key);
	($key)=(@_);
	if ($key eq "VVR_HB_PORT") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the port to be used for VVR heartbeats.", 130, 1032);
	} elsif ($key eq "VVR_VRADMIND_PORT") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the port to be used for vradmind.", 130, 1033);
	} elsif ($key eq "VVR_VXRSYNCD_PORT") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the port to be used for vxrsyncd.", 130, 1034);
	} elsif ($key eq "VVR_DATA_PORTS") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the port to be used for replication.", 130, 1035);
	} elsif ($key eq "VVR_MAX_VRAS_LOGSIZE") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the maximum size of the VRAS debug logs.", 130, 1036);
	} elsif ($key eq "VOL_RVIO_MAXPOOL_SZ") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the maximum size of the RVG IOMEM memory pool.", 130, 1037);
	} elsif ($key eq "VOL_MIN_LOWMEM_SZ") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the minimum size of the VOLIOMEM memory pool.", 130, 1038);
	} elsif ($key eq "VOL_MAX_RDBACK_SZ") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the maximum size of the Readback memory pool", 130, 1039);
	} elsif ($key eq "VOL_MAX_NMPOOL_SZ") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the maximum size of the NMCOM memory pool.", 130, 1040);
	} elsif ($key eq "VOL_MAX_WRSPOOL_SZ") {
		$cmt=_comm_define_cfgkey($key,0,0,uc($MSG{SYSTEM}));
		$cmt.=_tr("This variable defines the maximum size of the Write-Shipping memory pool.", 130, 1041);
	} else {
		# must be a VM config variable
		return _vm_comm_define_cfgkeys($key);
	}			

	$cmt.="\n\n";
	$cmt=~s/\n/\n# /g;
	return "$cmt";
}

# This routine sets the configuration variables
# used for the response file
# It must always be invoked within a for SYSI loop
sub _vvr_init_cfg_ports {
	$CFG{VVR_HB_PORT}{$SYS}=_dor("$CMD{VVRPORT} heartbeat");
	$CFG{VVR_VRADMIND_PORT}{$SYS}=_dor("$CMD{VVRPORT} vradmind");
	$CFG{VVR_VXRSYNCD_PORT}{$SYS}=_dor("$CMD{VVRPORT} vxrsyncd");
	$CFG{VVR_DATA_PORTS}{$SYS}=_dor("$CMD{VVRPORT} data");
}

# This routine sets the configuration variables
# used for the response file
# It must always be invoked within a for SYSI loop
sub _vvr_init_vras_logsize {
	my($cmd,$maxlog);
	$cmd="grep $DEF{VRAS_STR} $CONF{VRASCONF} |awk -F= '{ print \$NF }'";
	$maxlog=_vvr_display_log_size(_dor($cmd,0));	
	$CFG{VVR_MAX_VRAS_LOGSIZE}{$SYS}=$maxlog;
}

# This routine will display/prompt for the 
# VVR memory pool tunables. 
# It is called from _vvr_postinstall_questions
sub _vvr_config_tunables {
	my($ayn,$done,$op,@en,$all,$numsys);

	_title();
	# Prompt whether user wants to change tunables
	_bpl("Configuration of VVR tunables (For the advanced user)\n", 130, 1042);

	$MSG{HELP}=_tr("This option is meant for the advanced VVR user. Modifying the default values of the tunables will impact VVR performance. The user should modify these after viewing the VVR Configuration Notes\n", 130, 1043);
	$ayn=_aynn("Do you want to view or modify VVR tunables on any of the hosts?", 130, 1044);
	if (($ayn eq "n") || ($ayn eq "N")) {
		foreach $SYS(@SYSI) {
			_vvr_init_tunables();
		}	
		return;
	} 

	$numsys=@SYSI;
	foreach $SYS(@SYSI) {
		if ($all) {
			$CFG{VOL_RVIO_MAXPOOL_SZ}{$SYS}=$en[1];
			$CFG{VOL_MIN_LOWMEM_SZ}{$SYS}=$en[2];
			$CFG{VOL_MAX_RDBACK_SZ}{$SYS}=$en[3];
			$CFG{VOL_MAX_NMPOOL_SZ}{$SYS}=$en[4];
			$CFG{VOL_MAX_WRSPOOL_SZ}{$SYS}=$en[5];
			next;
		}
		undef(@en); 
		_title();
		$done=0;
		_bpl("Following are the VVR tunables on $SYS :", 130, 1045, "$SYS");
		_vvr_init_tunables();
		_vvr_display_tunables();

		_pl("\nThe tunables should be identical for systems that will be part of the same Replicated Data Set. They should also be identical for all the systems in a cluster.\n", 130, 1046);

		$ayn=_aynn("Do you want to change any of the VVR tunables on $SYS?", 130, 1087, "$SYS");
		if ($ayn eq "Y") {
			while(!$done) {
				$en[1]=_vvr_ask_vol_rvio_maxpool_sz();
				$en[2]=_vvr_ask_vol_min_lowmem_sz();
				$en[3]=_vvr_ask_vol_max_rdback_sz();
				$en[4]=_vvr_ask_vol_max_nmpool_sz();
#				$en[5]=_vvr_ask_vol_max_wrspool_sz();

				_pl("\nFollowing are the VVR tunables on $SYS :", 130, 1048, "$SYS");
				# Call routine to display CFG_PORT variables
				_vvr_display_tunables();
				$ayn=_ayny("Is this information correct?", 130, 1009);
				$done=1 if ($ayn eq "Y");
			}
		} # if $ayn.. 

		if (($SYS eq $SYSC[0]) && ($numsys > 1)) {
			$ayn=_ayny("Do you want to use the same tunable settings on all systems?", 130, 1049);
			$all=1 if($ayn eq "Y");
		}
	} #foreach sys
}

# This routine initializes the tuning configuration 
# variables used for the response file
# It must always be invoked within a for SYSI loop
sub _vvr_init_tunables {
	$CFG{VOL_RVIO_MAXPOOL_SZ}{$SYS}=
		_dor("$CMD{VXTUNE} vol_rvio_maxpool_sz | awk '{print \$1}'");
	$CFG{VOL_MIN_LOWMEM_SZ}{$SYS}=_dor("$CMD{VXTUNE} vol_min_lowmem_sz | awk '{print \$1}'");
	$CFG{VOL_MAX_RDBACK_SZ}{$SYS}=_dor("$CMD{VXTUNE} vol_max_rdback_sz | awk '{print \$1}'");
	$CFG{VOL_MAX_NMPOOL_SZ}{$SYS}=_dor("$CMD{VXTUNE} vol_max_nmpool_sz | awk '{print \$1}'");
#	$CFG{VOL_MAX_WRSPOOL_SZ}{$SYS}=_dor("$CMD{VXTUNE} vol_max_wrspool_sz | awk '{print \$1}'");
}

sub _vvr_display_tunables {
	_pl("\nMaximum size of RVG IOMEM memory pool:\t\t$CFG{VOL_RVIO_MAXPOOL_SZ}{$SYS} KB", 130, 1066, "$CFG{VOL_RVIO_MAXPOOL_SZ}{$SYS}");
	_pl("Minimum size of VOLIOMEM memory pool:\t\t$CFG{VOL_MIN_LOWMEM_SZ}{$SYS} KB", 130, 1067, "$CFG{VOL_MIN_LOWMEM_SZ}{$SYS}");
	_pl("Maximum size of RDBACK memory pool:\t\t$CFG{VOL_MAX_RDBACK_SZ}{$SYS} KB", 130, 1068, "$CFG{VOL_MAX_RDBACK_SZ}{$SYS}");
	_pl("Maximum size of NMCOM memory pool:\t\t$CFG{VOL_MAX_NMPOOL_SZ}{$SYS} KB", 130, 1069, "$CFG{VOL_MAX_NMPOOL_SZ}{$SYS}");
#	 _pl("Maximum size of Write Shipping memory pool:\t$CFG{VOL_MAX_WRSPOOL_SZ}{$SYS} KB");
}

# ask tunable routines will 
# 1. ask for tunable value displaying the current setting
# 2. validate the user entry
# 3. Set the CFG variable to the new entry

sub _vvr_ask_vol_rvio_maxpool_sz{
	my($ask,$done,$BSize,$sys);
	while(!$done) {
		$COMM{DEFANSWER} = $CFG{VOL_RVIO_MAXPOOL_SZ}{$SYS};
		$sys=_dor("$CMD{UNAME}");
		$BSize=$DEF{vol_rvio_maxpool_sz}{$sys};
		$MSG{HELP}=_tr("The minimum value of vol_rvio_maxpool_sz is $BSize KB.", 130, 1096, "$BSize");
		$ask=_ask("\nEnter the maximum size, in KB, of RVG IOMEM memory pool(vol_rvio_maxpool_sz):", 130, 1072);
		if(_vvr_verify_mempool($ask,vol_rvio_maxpool_sz)) {
			_pl("Invalid Entry! Enter an integer value equal to or greater than $BSize (KB).\n", 130, 1097, "$BSize");
		} else {
			$done=1;
		}
	}

	# Set CFG variable to be stored in response file
	$CFG{VOL_RVIO_MAXPOOL_SZ}{$SYS}=$ask;
	return $CFG{VOL_RVIO_MAXPOOL_SZ}{$SYS};
}

sub _vvr_ask_vol_min_lowmem_sz {
	my($ask,$done,$BSize,$sys);
	while(!$done) {
		$COMM{DEFANSWER} = $CFG{VOL_MIN_LOWMEM_SZ}{$SYS};
		$sys=_dor("$CMD{UNAME}");
		$BSize=$DEF{vol_min_lowmem_sz}{$sys};
		$MSG{HELP}=_tr("The minimum value of vol_min_lowmem_sz is $BSize KB.", 130, 1098, "$BSize");
		$ask=_ask("\nEnter the maximum size, in KB, of VOLIOMEM memory pool(vol_min_lowmem_sz):", 130, 1075);
		if(_vvr_verify_mempool($ask,vol_min_lowmem_sz)) {
			_pl("Invalid Entry! Enter an integer value equal to or greater than $BSize (KB).\n", 130, 1097, "$BSize");
		} else {
			$done=1;
		}
	}

	# Set CFG variable to be stored in response file
	$CFG{VOL_MIN_LOWMEM_SZ}{$SYS}=$ask;
	return $CFG{VOL_MIN_LOWMEM_SZ}{$SYS};
}


sub _vvr_ask_vol_max_rdback_sz{
	my($ask,$done,$BSize,$sys);
	while(!$done) {
		$COMM{DEFANSWER} = $CFG{VOL_MAX_RDBACK_SZ}{$SYS};
		$sys=_dor("$CMD{UNAME}");
		$BSize=$DEF{vol_max_rdback_sz}{$sys};
		$MSG{HELP}=_tr("The minimum value of vol_max_rdback_sz is $BSize KB.", 130, 1099, "$BSize");
		$ask=_ask("\nEnter the maximum size, in KB, of RDBACK memory pool(vol_max_rdback_sz):", 130, 1078);
		if(_vvr_verify_mempool($ask,vol_max_rdback_sz)) {
			_pl("Invalid Entry! Enter an integer value equal to or greater than $BSize (KB).\n", 130, 1097, "$BSize");
		} else {
			$done=1;
		}
	}

	# Set CFG variable to be stored in response file
	$CFG{VOL_MAX_RDBACK_SZ}{$SYS}=$ask;
	return $CFG{VOL_MAX_RDBACK_SZ}{$SYS};
}

sub _vvr_ask_vol_max_nmpool_sz{
	my($ask,$done,$BSize,$sys);
	while(!$done) {
		$COMM{DEFANSWER} = $CFG{VOL_MAX_NMPOOL_SZ}{$SYS};
		$sys=_dor("$CMD{UNAME}");
		$BSize=$DEF{vol_max_nmpool_sz}{$sys};
		$MSG{HELP}=_tr("The minimum value of vol_max_nmpool_sz is $BSize KB.", 130, 1100, "$BSize");
		$ask=_ask("\nEnter the maximum size, in KB, of NMCOM memory pool(vol_max_nmpool_sz):", 130, 1080);
		if(_vvr_verify_mempool($ask,vol_max_nmpool_sz)) {
			_pl("Invalid Entry! Enter an integer value equal to or greater than $BSize (KB).\n", 130, 1097, "$BSize");
		} else {
			$done=1;
		}
	}

	# Set CFG variable to be stored in response file
	$CFG{VOL_MAX_NMPOOL_SZ}{$SYS}=$ask;
	return $CFG{VOL_MAX_NMPOOL_SZ}{$SYS};
}



sub _vvr_ask_vol_max_wrspool_sz{
	my($ask,$done,$BSize,$sys);
	while(!$done) {
		$COMM{DEFANSWER} = $CFG{VOL_MAX_WRSPOOL_SZ}{$SYS};
		$sys=_dor("$CMD{UNAME}");
		$BSize=$DEF{vol_max_wrspool_sz}{$sys};
		$MSG{HELP}=_tr("The minimum value of vol_max_wrspool_sz is $BSize KB.", 130, 1101, "$BSize");
		$ask=_ask("\nEnter the maximum size, in KB, of Write Shipping memory pool(vol_max_wrspool_sz):", 130, 1082);
		if(_vvr_verify_mempool($ask,vol_max_wrspool_sz)) {
			_pl("Invalid Entry! Enter an integer value equal to or greater than $BSize (KB).\n", 130, 1097, "$BSize");
		} else {
			$done=1;
		}
	}

	# Set CFG variable to be stored in response file
	$CFG{VOL_MAX_WRSPOOL_SZ}{$SYS}=$ask;
	return $CFG{VOL_MAX_WRSPOOL_SZ}{$SYS};
}

# This routine sets the VVR tunables to the specified
# configuration variables.
# It must always be invoked within a for SYSI loop
sub _vvr_set_tunables {
	my($tunable,$value,$numval,$junk);
	($tunable,$value)=(@_);
	# $value also has the (Kbytes) into it. 
	($numval,$junk)=split(/\s+/,$value);
	_dor("$CMD{VXTUNE} $tunable ${numval}k");
}

# This routine is used to validate the mempool
# value passed to it.

sub _vvr_verify_mempool {
	my($var,$value,$sys);
	($value,$var)=(@_);

	# Check that it is a positive integer
	if (_isint($value)) { return 1; }

	# Check for minimum pool size requirement.
	# Hardcoding the minimum values for now.
	# This should be changed to (plat-specific?) macros
        $sys=_dor("$CMD{UNAME}");
        if (($var eq "vol_rvio_maxpool_sz") && ($value < $DEF{vol_rvio_maxpool_sz}{$sys}))
                { return 1; }
        if (($var eq "vol_min_lowmem_sz") && ($value < $DEF{vol_min_lowmem_sz}{$sys}))
                { return 1; }
        if (($var eq "vol_max_rdback_sz") &&  ($value < $DEF{vol_max_rdback_sz}{$sys}))
                { return 1; }
        if (($var eq "vol_max_nmpool_sz") &&   ($value < $DEF{vol_max_nmpool_sz}{$sys}))
                { return 1; }
#        if (($var eq "vol_max_wrspool_sz") &&  ($value < $DEF{vol_max_wrspool_sz}{$sys}))
#                { return 1; }
	return 0;
}

sub _vvr_comm_select_optional {
         if (_list("VRTSvrw",@{$CFG{DONOTINSTALL}})>=0) {
                 push(@{$CFG{DONOTINSTALL}},"VRTSjre");
                 push(@{$CFG{DONOTINSTALL}},"VRTSweb");
         }
#       _dbg("foo");
#       _dbg("foo1 $CFG{A}{B}");
#       _dbg("foo2 $CFG{DONOTINSTALL}{B}");
#       _dbg("foo3 $CFG{DONOTINSTALL}{VRTSvrw}");
#        if ($CFG{DONOTINSTALL}{VRTSvrw}) {
#                $CFG{DONOTINSTALL}{VRTSjre}=1;
#                $CFG{DONOTINSTALL}{VRTSweb}=1;
#        }
	#else {
        #       _pl("VRTSvrw is functional only if VRTSweb and VRTSjre are also installed.");
	#       _pl("Installling VRTSvrw will also install VRTSjre and VRTSweb.");
        #       _prtc();
	#}
}

1;
# All UPI's which should show up on rti menu
$COMM{MUPIS1}=[ qw(VVR VCS SF SFORA SFDB2) ];
$COMM{MUPIS2}=[ qw(SFCFS SFRAC) ];

$PROD{FS}{TRAINDIR}="file_system";
$PROD{SF}{TRAINDIR}="storage_foundation";
$PROD{SFDB2}{TRAINDIR}="storage_foundation_for_db2";
$PROD{SFORA}{TRAINDIR}="storage_foundation_for_oracle";
$PROD{SFSYB}{TRAINDIR}="storage_foundation_for_sybase";
$PROD{VM}{TRAINDIR}="volume_manager";
$PROD{VVR}{TRAINDIR}="volume_replicator";
$PROD{VCS}{TRAINDIR}="cluster_server";
$PROD{TD}{TRAINDIR}="traffic_director";
$PROD{SPCQS}{TRAINDIR}="sanpoint_control_quickstart";
$PROD{SFCFS}{TRAINDIR}="storage_foundation_cluster_file_system";
$PROD{SFRAC}{TRAINDIR}="storage_foundation_for_oracle_rac";
$PROD{AT}{TRAINDIR}="authentication";
$PROD{AZ}{TRAINDIR}="authorization";
$PROD{AT}{CD}=1;
$PROD{AZ}{CD}=1;
$PROD{FS}{CD}=1;
$PROD{SF}{CD}=1;
$PROD{SFDB2}{CD}=1;
$PROD{SFORA}{CD}=1;
$PROD{VM}{CD}=1;
$PROD{VVR}{CD}=1;
$PROD{VCS}{CD}=1;
$PROD{TD}{CD}=1;
$PROD{SF}{VILNAME}="Storage Foundation";
$PROD{SPCQS}{CD}=2;
$PROD{SF}{MENUNAME}="Storage Foundation (QuickStart, Standard, Standard HA, Enterprise, Enterprise HA, and VVR Option)";
$PROD{FS}{MENUNAME}="File System (FlashSnap Option)";
$PROD{VM}{MENUNAME}="Volume Manager (FlashSnap Option, VVR Option)";
$PROD{SFORA}{MENUNAME}="Storage Foundation for Oracle (Standard, Enterprise, Enterprise HA, VVR Option)";
$PROD{SFDB2}{MENUNAME}="Storage Foundation for DB2 (Standard, Enterprise, Enterprise HA, VVR Option)";
$PROD{SFSYB}{MENUNAME}="Storage Foundation for Sybase (HA, FlashSnap Option, VVR Option)";
$PROD{AT}{MENUNAME}="VERITAS Authentication Service";
$PROD{AZ}{MENUNAME}="VERITAS Authorization Service";

sub _rti_menu {
	my (@mk,@mo,$bs,$buf,$cv,$iv,$key,$lic,$m,$menu,$mkey,$mm1,$mm2,$n,$name,$obg,$pl,$rlic,$task,$ts,$tsl,$upi);
	_comm_initiation("RTI");
	_rti_set_msgs();
	$COMM{MUPIS} = (-d "./$PROD{SFRAC}{TRAINDIR}") ? $COMM{MUPIS2} : $COMM{MUPIS1};
	while (1) {
		@mo=qw(INSTALL CONFIG LICENSE PRECHECK UNINSTALL DESC QUIT HELP);
		$iv=_plat_sub("get_instpkgvers",$COMM{LICPKG});
		if (!iv) {
			# offer to install VRTSvlic here
		} else {
			$PKGI{$PKG}{MVERS}=_plat_sub("get_mediapkgvers") if (!$PKGI{$PKG}{MVERS});
			$cv=_cv($iv,$PKGI{$PKG}{MVERS});
			if ($cv==2) {
				# offer to upgrade VRTSvlic here
			}
		}
		if (-x $CMD{VXLICREP}) {
			$rlic=_comm_check_license();
			foreach $upi(@{$COMM{MUPIS}}) { 
				$iv=_plat_sub("get_instpkgvers",$PROD{$upi}{MAINPKG});

				$COMM{$upi}{IVERS} = ($iv) ? $iv : $MSG{NO};
			}
			_title();
			$bs = "%-50s%-16s%-s";
			$buf = ($COMM{ENVLANG}=~/ja/) ? "%-34s%-16s%-s" : "%-44s%-20s%-s";
			$pl=sprintf($buf, $MSG{VENDORPR}, $MSG{VERSINST}, $MSG{LICENSED});
			_bpl($pl);
			print "===========================================================================\n";
			foreach $upi(@{$COMM{MUPIS}}) { 
				$name = $PROD{$upi}{VILNAME} ? $PROD{$upi}{VILNAME} : $PROD{$upi}{NAME};
				$name=~s/^VERITAS // if (_list($upi,@{$COMM{LUPIS}})>=0);
				$lic = ($COMM{MLIC}{$upi}) ? $MSG{YES} : (_list($upi,@{$COMM{NOPL}})<0) ? $MSG{NO} : "";
				# here is the big "What do we do?" hack for SF
				# How do you actually tell it is installed 
				# since if has no unique component
				# the best answer is SF version = VM version if
				# SF is licensed, VM and FS are installed.
				# update # once somebody comes up with 
				# a better plan
				$COMM{SF}{IVERS}=$COMM{VM}{IVERS} if (($upi eq "SF") && ($COMM{VM}{IVERS} ne $MSG{NO}) && ($COMM{FS}{IVERS} ne $MSG{NO}) && ($lic eq $MSG{YES}));
				$pl=sprintf($bs, $name, $COMM{$upi}{IVERS}, $lic);
				_pl($pl);
			}
		} else {
			sleep 2;
			_title();
			_pl("$MSG{VENDOR} Licensing utilities are not installed on this system.", 31, 1000, "$MSG{VENDOR}");
			_pl("Product menu cannot be displayed until $MSG{VENDOR} Licensing utilities are installed.", 31, 1001, "$MSG{VENDOR}");
		}
		$tsl="";
		undef(@mk);
		_bpl("\nSelection Menu:\n", 31, 1002);
		while(@mo) {
			$m=shift(@mo);
			last if (!$m);
			$mkey=uc($MSG{"$m\KEY"});
			push(@mk,$mkey);
			$mm1="$COMM{TPUT}{BS}$mkey$COMM{TPUT}{BE}) $MSG{MENU}{$m}";
			$m=shift(@mo);
			if ($m) {
				$mkey=uc($MSG{"$m\KEY"});
				push(@mk,$mkey);
				$mm2="$COMM{TPUT}{BS}$mkey$COMM{TPUT}{BE}) $MSG{MENU}{$m}";
			} else {
				$mm2="";
			}
			# hard to align japanese with long Install/Upgrade
			$buf = ($COMM{ENVLANG}!~/ja/) ? "$MSG{INDENT}%-40s %s\n" : 
				# will break if INSTALLKEY or QUITKEY change
				($mm1=~/I/) ? "%-36s %s\n" :
				($mm1=~/Q/) ? "%-50s %s\n" :
				"%-40s %s\n";
			printf($buf, $mm1, $mm2);
		}
		_p();
		$ts="";
		$tsl=join(",",@mk);
		$tsl="[$tsl]";
		while (_list($ts,@mk)<0) {
			$ts=_ask("Enter a Selection: $tsl", 31, 1003, "$tsl");
			$ts=uc($ts);
		}
		if ($ts eq $MSG{HELPKEY}) { _rti_menu_help(); next; }
		_title();
		$COMM{MENU}=[];
		foreach $upi(@{$COMM{MUPIS}}) { 
			next if ((_list($upi,@{$COMM{NOPL}})>=0) &&
				(($ts =~ /^$MSG{CONFIGKEY}$/i) || 
				($ts =~ /^$MSG{LICENSEKEY}$/i) || 
				($ts =~ /^$MSG{PRECHECKKEY}$/i))); 
			$n = ($PROD{$upi}{MENUNAME}) ? $PROD{$upi}{MENUNAME} : $PROD{$upi}{NAME};
			$n="VERITAS $n" unless ($n=~/VERITAS/);
			push(@{$COMM{MENU}},$n); 
		}
		$COMM{BACK}=1;
		#$MSG{HELP}=_tr("menu help");
		if ($ts =~ /^$MSG{INSTALLKEY}$/i) {
			$task="install";
			$menu=_menu("Select a product to install:", 31, 1004);
		} elsif ($ts =~ /^$MSG{CONFIGKEY}$/i) {
			$task="configure";
			$menu=_menu("Select a product to configure:", 31, 1005);
		} elsif ($ts =~ /^$MSG{LICENSEKEY}$/i) {
			$task="license";
			$menu=_menu("Select a product to license:", 31, 1006);
		} elsif ($ts =~ /^$MSG{PRECHECKKEY}$/i) {
			$task="precheck";
			$menu=_menu("Select a product to perform a pre-installation check for???", 31, 1007);
		} elsif ($ts =~ /^$MSG{DESCKEY}$/i) {
			$menu=_menu("Select a product to view a product description of???", 31, 1008);
		} elsif ($ts =~ /^$MSG{UNINSTALLKEY}$/i) {
			$OPT{INSTALL}="";
			$task="uninstall";
			$menu=_menu("Select a product to uninstall", 31, 1009);
		}
		next if ($menu =~ /^$MSG{BACKKEY}$/i);
		$upi=${$COMM{MUPIS}}[$menu-1];
		if ($upi eq "VEAG") {
			# add for other plats
			$obg = ($COMM{OS} eq "SunOS") ? "VRTSobgui.tar.gz" :
			($COMM{OS} eq "SunOS") ? $PKGI{VRTSobgui}{RPM} : "";
			$PROD{VEAG}{TRAINDIR}=_dol("$CMD{FIND} . -name $obg -print | $CMD{SED} -n '1p' 2>/dev/null");
			$PROD{VEAG}{TRAINDIR}=~s/\/$PATH{PKGDIR}.*//;
		}
		if ($ts =~ /^$MSG{DESCKEY}/i) {
			_rti_product_description($upi);
		} elsif (($task eq "install") && (! -d "./$PROD{$upi}{TRAINDIR}")) {
			_pl("\n$PROD{$upi}{NAME} must be installed using VERITAS Storage Solutions CD$PROD{$upi}{CD}", 31, 1010, "$PROD{$upi}{NAME}", "$PROD{$upi}{CD}");
			_prtc();
		} elsif (($task eq "license") && (! -d "./$PROD{$upi}{TRAINDIR}")) {
			_pl("\n$PROD{$upi}{NAME} must be licensed using VERITAS Storage Solutions CD$PROD{$upi}{CD}", 31, 1011, "$PROD{$upi}{NAME}", "$PROD{$upi}{CD}");
			_prtc();
		} else {
			_comm_cpi($upi,$task);
		}
	}
}

sub _rti_menu_help {
	my (@mo,$m,$mkey);
	_title();
	@mo=qw(INSTALL CONFIG LICENSE);
	while (@mo) {
		$m=shift(@mo);
		$mkey=uc($MSG{"$m\KEY"});
		print "$COMM{TPUT}{BS}$mkey$COMM{TPUT}{BE}) $MSG{MENU}{$m}\n\n";
		_pl_notr("$MSG{MENUHELP}{$m}");
		print "\n" if (@mo);
	}
	_prtc();
	_title();
	@mo=qw(PRECHECK UNINSTALL DESC QUIT);
	while (@mo) {
		$m=shift(@mo);
		$mkey=uc($MSG{"$m\KEY"});
		print "$COMM{TPUT}{BS}$mkey$COMM{TPUT}{BE}) $MSG{MENU}{$m}\n\n";
		_pl_notr("$MSG{MENUHELP}{$m}");
		print "\n" if (@mo);
	}
	_prtc();
}

sub _rti_product_description {
	my ($upi)=(@_);
	_pl("\n$MSG{$upi}{DESC}", 31, 1012, "$MSG{$upi}{DESC}");
	my $n=1;
	while ($MSG{$upi}{"DESC$n"}) { _pl("\n$MSG{$upi}{\"DESC$n\"}"); $n++; }
	_prtc();
}

sub _rti_set_msgs {
	$MSG{VENDORPR}=_tr("VERITAS Product", 31, 1013);
	$MSG{VERSINST}=_tr("Version Installed", 31, 1014);
	$MSG{LICENSED}=_tr("Licensed", 31, 1015);
	$MSG{MENU}{INSTALL}=_tr("Install/Upgrade a Product", 31, 1016);
	$MSG{MENU}{CONFIG}=_tr("Configure an Installed Product", 31, 1017);
	$MSG{MENU}{LICENSE}=_tr("License a Product", 31, 1018);
	$MSG{MENU}{PRECHECK}=_tr("Perform a Preinstallation Check", 31, 1019);
	$MSG{MENU}{UNINSTALL}=_tr("Uninstall a Product", 31, 1020);
	$MSG{MENU}{DESC}=_tr("View a Product Description", 31, 1021);
	$MSG{MENU}{QUIT}=_tr("Quit", 31, 1022);
	$MSG{MENU}{HELP}=_tr("Help", 31, 1023);
	$MSG{MENUHELP}{INSTALL}=_tr("Installs $MSG{PDFRS} and patches for an initial installation or upgrade.  The product is also configured during installation, but you have the option to install without configuration.", 31, 1024, "$MSG{PDFRS}");
	$MSG{MENUHELP}{CONFIG}=_tr("Configures the product after installing a product without configuration.", 31, 1025);
	$MSG{MENUHELP}{LICENSE}=_tr("Installs or updates a product license key. This option can be used to update an evaluation key to a permanent key, or to license a feature in a previously installed product.", 31, 1026);
	$MSG{MENUHELP}{PRECHECK}=_tr("Performs a preinstallation check to determine if systems meet all installation requirements. No products are installed.", 31, 1027);
	$MSG{MENUHELP}{UNINSTALL}=_tr("Removes the selected product's $MSG{PDFRS}, patches, files, and directories from the system providing they are not used by another VERITAS product.", 31, 1028, "$MSG{PDFRS}");
	$MSG{MENUHELP}{DESC}=_tr("Displays a brief overview of the selected product.", 31, 1029);
	$MSG{MENUHELP}{QUIT}=_tr("Exits the Installation Menu.", 31, 1030);
	$MSG{SFRAC}{DESC}=_tr("VERITAS Storage Foundation for Oracle9i/RAC is an integrated suite of industry-leading VERITAS storage management and high-availability software, engineered specifically to improve performance, availability, and manageability of Real Application Cluster (RAC) environments. SFRAC delivers a flexible solution that makes it simple to deploy and manage RAC, and is certified by Oracle.", 31, 1031);
	$MSG{SFDB2}{DESC}=_tr("Description for VERITAS Storage Foundation for DB2", 31, 1032);
	$MSG{INFR}{DESC}=_tr("Description for VERITAS Infrastructure Packages", 31, 1033);
	$MSG{VEAG}{DESC}=_tr("Description for VERITAS Enterprise Administrator GUI", 31, 1034);
	$MSG{SFORA}{DESC}=_tr("VERITAS Storage Foundation for Oracle offers raw device performance with the manageability of the VERITAS File System, online administration of storage, and the flexibility of storage hardware independence in addition to providing key storage virtualization capabilities - the ability to manage logical pools of storage rather than physical storage devices.", 31, 1035);
	$MSG{SFORA}{DESC1}=_tr("VERITAS Storage Foundation for Oracle - Standard is the optimal foundation for managing Oracle Standard Foundation on entry-level servers. By offering extensive storage management capabilities to a full range of users, VERITAS Storage Foundation for Oracle anticipates the eventual growth needs of every business.", 31, 1036);
	$MSG{SFORA}{DESC2}=_tr("VERITAS Storage Foundation for Oracle - Enterprise offers the flexibility to incorporate additional options. As database capacity grows and storage management increases in importance, the Enterprise version of VERITAS Storage Foundation for Oracle provides the ability to expand to meet those necessities.", 31, 1037);
	$MSG{SFORA}{DESC3}=_tr("VERITAS Storage Foundation HA for Oracle - Enterprise includes all the capabilities of the VERITAS Storage Foundation for Oracle while adding a high-availability environment to ensure the continuous information access critical to enterprise-level commerce.", 31, 1038);
	$MSG{SFDB2}{DESC}=_tr("VERITAS Storage Foundation for DB2 offers raw device performance with the manageability of the VERITAS File System, online administration of storage, and the flexibility of storage hardware independence in addition to providing key storage virtualization capabilities - the ability to manage logical pools of storage rather than physical storage devices.", 31, 1039);
	$MSG{SFDB2}{DESC1}=_tr("VERITAS Storage Foundation for DB2 - Standard is the optimal foundation for managing DB2 for performance driven but entry level UNIX servers.", 31, 1040);
	$MSG{SFDB2}{DESC2}=_tr("VERITAS Storage Foundation for DB2 - Enterprise offers the flexibility to incorporate additional options. As database capacity grows and storage management increases in importance, the Enterprise version of VERITAS Storage Foundation for DB2 provides the ability to expand to meet those necessities, particulary in the areas of quick recovery, offhost processing, identification of disk contention.  With VVR option the best in class DR solution is available for DB2.", 31, 1041);
	$MSG{SFDB2}{DESC3}=_tr("VERITAS Storage Foundation HA for DB2 - Enterprise includes all the capabilities of the VERITAS Storage Foundation for DB2 while adding a high-availability environment to ensure the continuous information access critical to enterprise-level commerce.  With VVR option the best in class DR solution is available for DB2", 31, 1042);
	$MSG{SFSYB}{DESC}=_tr("VERITAS Storage Foundation for Sybase - includes the high performance and manageability aspects of Storage Foundation for Databases including options for high-availability, offhost processing using Flashsnap, and disaster recovery using VVR.", 31, 1043);
	$MSG{FS}{DESC}=_tr("VERITAS File System is a powerful, quick-recovery, journaling file system that provides the high performance and easy management required by mission critical applications. It delivers scalable performance and provides continuous availability, increased I/O, and up-to-date structural integrity.", 31, 1044);
	$MSG{SF}{DESC}=_tr("VERITAS Storage Foundation combines the industry-leading technologies of VERITAS Volume Manager and VERITAS File System to deliver powerful, online storage management, optimal performance tuning, and sophisticated management capabilities to ensure continuous availability of mission-critical data. Additionally, VERITAS Storage Foundation includes VERITAS SANPoint Control QuickStart, which is a limited version of VERITAS SANPoint Control providing discovery and visualization of the SAN and its components, as well as the correlation of remote hosts and their resources.", 31, 1045);
	$MSG{SF}{DESC1}=_tr("VERITAS Storage Foundation QuickStart (FST-QS) offers a limited-function version of VERITAS Storage Foundation for entry-level servers.  VERITAS Storage Foundation QuickStart includes basic versions of VERITAS Volume Manager and VERITAS File System. FST-QS provides journal-based fast recovery, high performance, on-line management of volumes, and mirroring for boot drives. You can upgrade FST-QS to the feature-complete VERITAS Storage Foundation with an additional license.", 31, 1046);
	$MSG{SF}{DESC2}=_tr("VERITAS Storage Foundation HA adds VERITAS Cluster Server for high availability, multi-node management. It also includes the same bundled agents for File System and Volume Manager as those typically included in VCS.", 31, 1047);	
	$MSG{SFCFS}{DESC}=_tr("VERITAS Storage Foundation for Clustered File System extends VERITAS File System and VERITAS Volume Manager to support shared data in a SAN environment. Using VERITAS Storage Foundation for Clustered File System, multiple servers can access shared storage and files, transparently to the applications and concurrently with each other.", 31, 1048);
	$MSG{SFCFS}{DESC1}=_tr("VERITAS Storage Foundation for Clustered File System HA adds the full functionality of VERITAS Cluster Server, and features the power and flexibility to protect everything from a single critical database instance to very large multi-application clusters in networked storage environments. In addition, increased automation and intelligent workload management allow cluster administrators to maximize individual resources by moving beyond reactive recovery to proactive management of availability and performance.", 31, 1049);
	$MSG{TD}{DESC}=_tr("VERITAS Traffic Director is a new option for VERITAS Cluster Server that provides availability through traffic load balancing by directing TCP/IP and UDP/IP traffic to multiple backend servers.", 31, 1050);
	$MSG{VCS}{DESC}=_tr("VERITAS Cluster Server, the industry's leading open systems clustering solution, is ideal for eliminating both planned and unplanned downtime, facilitating server consolidation, and effectively managing a wide range of applications in heterogeneous environments.", 31, 1051);
	$MSG{VM}{DESC}=_tr("VERITAS Volume Manager provides easy-to-use, online storage management tools, which reduce planned and unplanned downtime. Volume Manager removes the physical limitations of disk storage, so you can configure, share, manage and optimize storage I/O performance online without interrupting data availability.", 31, 1052);
	$MSG{VVR}{DESC}=_tr("VERITAS Volume Replicator provides the foundation for seamless availability across sites. Based on the de facto industry-standard VERITAS Volume Manager, VERITAS Volume Replicator reliably, efficiently, effectively and consistently replicates data to remote locations over any standard IP network for maximum business continuity.", 31, 1053);
	$MSG{SPCQS}{DESC}=_tr("VERITAS SANPoint Control QuickStart provides automatic, accurate discovery and visualization of storage area network (SAN) devices and gives your SAN administrators a single, centralized, consistent interface for monitoring a multi-vendor storage network.", 31, 1054);
	$MSG{VEAG}{DESC}=_tr("VERITAS Enterprise Administrator is an infrastructure that provides the runtime environment for graphical user interfaces", 31, 1055);
}

1;

#
# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#

# Define paths
#
$PATH{SYMCLI_SYMMIR} = "/usr/symcli/bin/symmir";
$PATH{SYMCLI_SYMDG} = "/usr/symcli/bin/symdg";
$PATH{SYMCLI_SYMBCV} = "/usr/symcli/bin/symbcv";
$PATH{SYMCLI_SYMLD} = "/usr/symcli/bin/symld";
$PATH{SYMCLI_SYMPD} = "/usr/symcli/bin/sympd";
$PATH{SYMCLI_SYMDEV} = "/usr/symcli/bin/symdev";

# 
# Define product specific information
#
$PROD{FAS}{MAINPKG} = "VRTSfas";

#
# Define package specific information
# Order of file systems in SPACE is [/opt, /usr, /var, /].
#
$PKGI{VRTSfas}{SPACE} = [24576, 4096, 32, 100];
$PKGI{VRTSfasag}{SPACE} = [1024, 0, 32, 2048];
$PKGI{VRTSfasdc}{SPACE} = [1400, 0, 32, 0];

#
# Define language packages
#
$PKGI{VRTSfas}{JA} = [ qw(VRTSjafas) ];
$PKGI{VRTSfasag}{JA} = [ qw(VRTSjafag) ];
$PKGI{VRTSfasdc}{JA} = [ qw(VRTSjafad) ];

$PKGI{VRTSjafas}{SPACE} = [500, 0, 10, 0];
$PKGI{VRTSjafag}{SPACE} = [50, 0, 10, 0];
$PKGI{VRTSjafad}{SPACE} = [3072, 0, 10, 0];

# 
# Define processes that need to be stopped before package installation
#
$PKGI{VRTSfas}{PROCS} = [ qw(vxtf_fs_server) ];

# 
# Define package dependencies
#
$PKGI{VRTSfas}{DEPS} = [ qw(VRTSvmpro VRTSddlpr) ];
$PKGI{VRTSfasag}{DEPS} = [ qw(VRTSfas VRTSvcs) ];

sub _fas_sun_preinstall {
	$PKG = $PROD{FAS}{MAINPKG};

	foreach $SYS (@SYSI) { 
		_sun_create_responsefile("VXSYMRULE=$CFG{VXSYMRULE}");
	}
}

#
# Precheck: check if SYMCLI is installed properly on the target host(s)
# and set a warning message if that is not the case.
#
sub _fas_sun_precheck {
	my ($nosymcli);
	foreach $SYS (@SYSI) {
		$nosymcli = _fas_sun_symcli_check();
		if ($nosymcli) {
			_ckmsg("SYMCLI for TimeFinder not found. VxFAS packages will not be installed.", 251, 1002);
		}
	}
}

#
# Check if the required SYMCLIs are installed
# returns:
# 0 => All Required SYMCLIs are installed
# 1 => Required SYMCLIs are not installed
#
sub _fas_sun_symcli_check {
	my ($nosymcli_flg, $count);

	if ( _fc("$PATH{SYMCLI_SYMMIR}")
			&& _fc("$PATH{SYMCLI_SYMDG}")
			&& _fc("$PATH{SYMCLI_SYMBCV}")
			&& _fc("$PATH{SYMCLI_SYMLD}")
			&& _fc("$PATH{SYMCLI_SYMPD}")
			&& _fc("$PATH{SYMCLI_SYMDEV}")
		) {
		# installed
		$nosymcli_flg = 0;
	} else {
		# not installed
		$nosymcli_flg = 1;
	}

	return $nosymcli_flg;
}

1;
# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#

#  NOTE: ODM is dependent on GMS/GAB/LLT in a clustered configuration.
#  However, CPI does not configure GAB/LLT until after pkg installation,
#  resulting in console error messages from ODM.  We bypass that by
#  installing VRTSodm before VRTSgms which will prevent ODM from trying
#  to go thru GMS and thus GAB and LLT.  There is no harm in this since
#  after the required reboot all configuration will have been completed
#  and ODM will start as clustered instead of non-clustered.  This could
#  also be solved by VRTSodm postinstall scripts not mounting odm, but
#  mounting odm has been and is standard procedure when installing VRTSodm.

# ODM Information:
#
$PKGI{VRTSodm}{JA}      = [ qw(VRTSjaodm) ];
$PKGI{VRTSjaodm}{SPACE} = [  54,  0, 18,   0];
$PKGI{VRTSodm}{SPACE}   = [1200, 10, 20,  10];
$PKGI{VRTSodm}{DRIVERS} = [ "odm" ];
$SUB{STOP}{odm}         = "_odm_sun_odm_stop";

# GMS Information:
#
$PKGI{VRTSgms}{SPACE}   = [  10,  0, 20, 200];
$PKGI{VRTSgms}{DRIVERS} = [ "vxgms" ];

$PROD{ODM}{PKGS}        = [ VRTSgms, VRTSodm ];

sub _odm_sun_odm_stop {
	# We do our own remote command here 'cuz _dor doesn't have the
	# smarts to quote it correctly.
	#
	my $cmd = "minf=`mount | grep \"^/dev/odm \"`
	  if test -z \"\${minf}\" ; then : ; else
	    umount /dev/odm
	  fi";

	if (_localsys()) {
		_dol( "$cmd" );
	} else {
		_dol("$CMD{RSH} $SYS '$cmd'");
	}
}

## Local Variables:
## mode: perl
## tab-width: 8
## perl-indent-level: 8
## End:
## end of sun/ODM.pl
#SCC#
#SCC# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
#SCC# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#SCC#
#SCC#

# Define product specific information
$PROD{FS}{MAINPKG}="VRTSvxfs";
$PROD{FS}{UGVERS}="ALL";

# Define packages to be installed, per product mode
# Added VRTSap and VRTStep as they can be used by VRTSfspro.
# These 
$PROD{FS}{PKGS}=[qw(VRTSvxfs VRTStep VRTSap VRTSfspro VRTSfppm VRTSfsman VRTSfsdoc)];

#
# The SPACE vector contains the sizes (in KB) for /opt, /usr, /var and /.
#
# The "SPACE" values are derived from the package's pkgmap file.
# Additional 10 Kbytes (for cushioning) is added to each file system
# if its value is larger than 0.
#
$PKGI{VRTSvxfs}{SPACE}=[14500,4300,50,5700];
$PKGI{VRTSvxfs}{REQOSPATCHES}{"5.8"}=["108528-02", "108901-03"];
$PKGI{VRTSvxfs}{DRIVERS}=[ qw( vxportal fdd qlog vxfs )];

$PKGI{VRTSfppm}{SPACE}=[1000,0,20,20];

$PKGI{VRTSfsdoc}{SPACE}=[1600,0,10,10];

$PKGI{VRTSfspro}{SPACE}=[3400,0,20,10];

$PKGI{VRTSfsman}{SPACE}=[450,0,20,20];

$PKGI{VRTSvxfs}{JA}=[ qw(VRTSjafsc VRTSjafsd VRTSjafsm) ];
$PKGI{VRTSfppm}{MU}=[ qw(VRTSmufp) ];
$PKGI{VRTSfspro}{MU}=[ qw(VRTSmufsp) ];
$PKGI{VRTSap}{MU}=[ qw(VRTSmuap) ];
$PKGI{VRTStep}{MU}=[ qw(VRTSmutep) ];

$PKGI{VRTSjafsc}{SPACE}=[920,0,10,10];

$PKGI{VRTSjafsd}{SPACE}=[1600,0,10,10];

$PKGI{VRTSjafsm}{SPACE}=[1450,0,30,10];

$PKGI{VRTSmufp}{SPACE}=[40,0,10,10];

$PKGI{VRTSmufsp}{SPACE}=[600,0,10,10];

$PKGI{VRTSap}{SPACE}=[36000,10,20,10];

$PKGI{VRTStep}{SPACE}=[7000,0,20,0];

$SUB{STOP}{fdd} = "_fs_sun_fdd_stop";

# The file system defaults file
$CONF{FSTAB} = "/etc/vfstab";

# Function: _fs_sun_initial_systemcheck()
# 
sub _fs_sun_initial_systemcheck {

	return;
} # end of _fs_sun_initial_systemcheck()

# Function: _fs_sun_currinst()
# Determines if VxFS is currently installed on a host.
# Returns 1,      if VxFS is installed
# Returns 0,      if VxFS is not installed
#
sub _fs_sun_currinst {
my ($installed, $opkg);

        $opkg=$PKG;
        $PKG=$PROD{FS}{MAINPKG};
        $installed = _sun_get_instpkgvers();
        $PKG=$opkg;

        return 1 if $installed;
        return 0;

} # end of _fs_sun_currinst()

# Function: _fs_sun_fspkginst()
# Determines if the fspkg is currently installed on a host.
# Input: Any FS Package Name
# Returns 1,      if fspkg is installed
# Returns 0,      if fspkg is not installed
#
sub _fs_sun_fspkginst {
my ($installed, $opkg, $fspkg);
	($fspkg)=(@_);
        $opkg=$PKG;
        $PKG=$fspkg;
        $installed = _sun_get_instpkgvers();
        $PKG=$opkg;

        return 1 if $installed;
        return 0;

} # end of _fs_sun_fspkginst()

# Function: _fs_sun_eold()
# Determines if host has any VxFS FileSystem with EOLed Disk Layouts 1-3.
# Returns 1,      if VxFS has a EOLed Disk Layout
# Returns 0,      if VxFS has no EOLed Disk Layout
#
sub _fs_sun_eold {
my ($ret1, $eold1, $eold2, $i, $j, @k, $x);

	$eold2 = _dor(" cat /etc/vfstab | grep vxfs ");
	$j = _dor("cat /etc/vfstab | grep vxfs | wc -l ");
	if ($j == 0) {
		return 0;
	}
	@k = split(" ", $eold2);
	
	for ( $x=0 ; $x<$j ; $x++) {
	    if (( $k[$x*7] !~ /\A#/ ) && (-e $k[$x*7])) {
		$eold1 = _dor("/usr/sbin/fstyp -v $k[$x*7] | grep version ");
		($i ,$i, $i, $i) = split(" ", $eold1);
		chomp($i);
		if ( length($i) eq 0 ) {
			return;
		}
		if ( $i lt "4" ) {
			$ret1 = 1;
		}
	    } 
	}
	return $ret1;
} # end of _fs_sun_eold()

# Function: _fs_sun_umnt()
# Determines if any VxFS File System is currently mounted on a host.
# Returns 1,      if VxFS is mounted
# Returns 0,      if VxFS is not mounted
#
sub _fs_sun_umnt {
my ($ret1);

	$ret1 = _dor("/usr/sbin/mount -v |grep 'type vxfs' ");

	return 1 if $ret1;
	return 0;
} # end of _fs_sun_umnt()

# Function: _fs_sun_getmediapkgvers()
# Determines the VxFS package version number on the media
# Returns the VxFS package version
#
sub _fs_sun_getmediapkgvers {
my ($mediapkgver, $opkg);

	$opkg=$PKG;
	$PKG=$PROD{FS}{MAINPKG};
	$mediapkgver = _sun_get_mediapkgvers();
	$PKG=$opkg;
	return $mediapkgver;
} # end of _fs_sun_getmediapkgvers()

# Function: _fs_sun_getinstpkgvers()
# Determines the VxFS package version number currently installed on the system
# Returns the VxFS package version
#
sub _fs_sun_getinstpkgvers {
my ($instpkgver, $opkg);

	$opkg=$PKG;
	$PKG=$PROD{FS}{MAINPKG};
	$instpkgver = _sun_get_instpkgvers();
	$PKG=$opkg;
	return $instpkgver;
} # end of _fs_sun_getinstpkgvers()

# Function: _fs_sun_compmessages()
# Displays the completion messages after the Upgrade or Install is completed.
#
sub _fs_sun_compmessages {
	return if ($OPT{UNINSTALL});
	_pl("Reboot all systems on which VxFS was installed or upgraded.", 101, 1003);
	_pl("\t shutdown -y -i6 -g0 \n", 101, 1001);
	_pl("See the VERITAS File System Administrators Guide for information on using VxFS.", 101, 1004);
		
} # end of _fs_sun_compmessages()

# Function: _fs_sun_prepkgadd()
# Create /etc/vx/.cpi_pkgadd_vxfs prior to the pkgadd to indicate to the
# underlying installation scripts that this is a cpi invoked pkgadd.
# This tells them not to expect any interactive response to questions.
#
sub _fs_sun_prepkgadd {
	if ($PKG eq "VRTSvxfs") {
        	_dor("$CMD{TOUCH} /etc/vx/.cpi_pkgadd_vxfs");
	}
} # end of _fs_sun_prepkgadd()

# Function: _fs_sun_postpkgadd()
# Remove /etc/vx/.cpi_pkgadd_vxfs after the pkgadd.
#
sub _fs_sun_postpkgadd {
	if ($PKG eq "VRTSvxfs") {
        	_dor("$CMD{RMR} /etc/vx/.cpi_pkgadd_vxfs");
	}
} # end of _fs_sun_postpkgadd()

# Function: _fs_sun_prepkgrm()
# Create /etc/vx/.cpi_pkgrm_vxfs prior to the pkrm to indicate to the
# underlying removal scripts that this is a cpi invoked pkgrm.
# This tells them not to expect any interactive response to questions.
# If the version of VRTSvxfs is 3.5 replace the preremove script
# with a updated preremove script that knows about cpi.  We'll use the 3.5
# version of the script for 3.4 as well since it doesn't functionally differ.
#
sub _fs_sun_prepkgrm {
	if ($PKG eq "VRTSvxfs") {
		my $v;
		$v = _sun_get_instpkgvers();
		$PKG="VRTSvxfs";
		if (($v eq "3.4") || ($v eq "3.5")) {
			_fork_sub(0,"_copy","$PATH{SCRIPTS}/../vxfs/preremove_3.5","/var/sadm/pkg/VRTSvxfs/install");
			_dor("$CMD{CP} /var/sadm/pkg/VRTSvxfs/install/preremove /var/sadm/pkg/VRTSvxfs/install/preremove.prev");
			_dor("$CMD{CP} /var/sadm/pkg/VRTSvxfs/install/preremove_3.5 /var/sadm/pkg/VRTSvxfs/install/preremove");
		}
        	_dor("$CMD{TOUCH} /etc/vx/.cpi_pkgrm_vxfs");
	}
} # end of _fs_sun_prepkgrm()

# Function: _fs_sun_postpkgrm()
# Remove /etc/vx/.cpi_pkgrm_vxfs after the pkgrm.
#
sub _fs_sun_postpkgrm {
	if ($PKG eq "VRTSvxfs") {
        	_dor("$CMD{RMR} /etc/vx/.cpi_pkgrm_vxfs");
	}
} # end of _fs_sun_postpkgrm()

# Routine: _fs_sun_fdd_stop
# "stopping" fdd will make it unloadable.
#
sub _fs_sun_fdd_stop {
	# We do our own remote command here 'cuz _dor doesn't have the
	# smarts to quote it correctly.
	#
	my $cmd = "echo vxfdd_nounload/W0 | adb -k -w > /dev/null 2>&1";

	if (_localsys()) {
		_dol( "$cmd" );
	} else {
		_dol("$CMD{RSH} $SYS '$cmd'");
	}
}

# Routine: _VRTSvxfs_sun_defines
# Establish defines that are required for products that incorporate
# the VRTSvxfs package.
#
sub _VRTSvxfs_sun_defines {
	$PKGI{VRTSvxfs}{VRTSPATCHES}{"5.8"}=["113605"];
	$PKGI{VRTSvxfs}{VRTSPATCHES}{"5.9"}=["113606"];
}

1;
#
#

1;
#
#

# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms
#$CMD{START}{proc}="/etc/rc2.d/S99myproc";

# Define product specific information
# VRTScavf -- VERITAS Cluster Server Agents for
#	      Storage Foundation for Cluster File System
$PROD{SFCFS}{MAINPKG}="VRTScavf";
$PROD{SFCFS}{UGVERS}=["3.4","3.5","4.0"];

# Define packages to be installed, per product mode
#
$PROD{SFCFS}{PKGS}=["VRTScavf","VRTSglm","VRTScfsdc"];

#
# CFS Package descriptions
#
# SPACE holds the needed size (KB) for /opt, /usr, /var and / file systems.
#
# The "SPACE" values are derived from the package's pkgmap file.
# Additional 10 Kbytes (for cushioning) is added to each file system
# if its value is larger than 0.
#
$PKGI{VRTScavf}{SPACE}=[302,60,11,24];
$PKGI{VRTScfsdc}{SPACE}=[0,0,0,2106];
$PKGI{VRTSglm}{SPACE}=[30,0,20,700];

$PKGI{VRTScavf}{JA}=[ qw(VRTSjacfd VRTSjacav) ];

$PKGI{VRTSjacfd}{SPACE}=[0,0,0,2106];
$PKGI{VRTSjacav}{SPACE}=[314,80,20,20];

# $PKGI{VRTSglm}{DRIVERS}=[ "vxglm" ];

# Description for VM packages are found in VM.pl

# No product/platform specific subroutines are required
# Use them only if necessary

sub _sfcfs_sun_prestop {
	_vm_sun_prestop();
}

sub _sfcfs_sun_pkgrequest_questions {
	_vm_sun_pkgrequest_questions();
}

sub _sfcfs_sun_do_lic_processing {
	_vm_sun_do_lic_processing();
}

sub _sfcfs_sun_poststart {
	_vm_sun_poststart();
}

#
# If the user said they would be configuring fencing after the
# installation then $FLAG{FENCINGENABLED} would be set and we'll
# remove any vxfenmode file.  This will intentionally disable CVM
# until such time the coordinator disks are configured or they
# explicitly disable fencing via vxfenmode, which is what we do
# if they said they will not be configuring fencing.
#
# CPI calls us unconditionally for now,
# but only do if we're SFCFS, and the pkg is VRTSvxfen.
# 
sub _sfcfs_sun_postpkgadd {
	if ($UPI eq "SFCFS" && $PKG eq "VRTSvxfen") {
		if ($FLAG{FENCINGENABLED}) {
			_dor("$CMD{RMR} /etc/vxfenmode");
		} else {
			if (_localsys()) {
				_dol("$CMD{ECHO} vxfen_mode=disabled > /etc/vxfenmode");
			} else {
				_dor("'$CMD{ECHO} vxfen_mode=disabled > /etc/vxfenmode'");
			}
		}
	}
}

#
# Remove any vxfenmode file on the system.
# CPI calls us unconditionally for now,
# but only do if we're SFCFS, and the pkg is VRTSvxfen.
#
sub _sfcfs_sun_postpkgrm {
	if ($UPI eq "SFCFS" && $PKG eq "VRTSvxfen") {
		_dor("$CMD{RMR} /etc/vxfenmode");
	}
}

# Displays the completion messages after the Upgrade or Install is completed.
#
sub _sfcfs_sun_completion_messages {
	_vcs_comm_completion_messages();
	_vm_comm_completion_messages();
	
	_pl("\n\nMost SFCFS installs, uninstalls, and upgrades eventually require a machine reboot to complete the operation.", 161, 1006); 
	if ($FLAG{CFSCLUSTER_CONFIG_PENDING}) {
		_pl("SFCFS configuration could not be completed during the install.", 161, 1002);
		_pl("<cfscluster config> must be run after the system is rebooted.", 161, 1005);
	}
	_pl("See the Storage Foundation Cluster File System Installation and Administration Guide for more information.\n", 161, 1004);
}

sub _sfcfs_sun_defines {
	$PKGI{VRTSvxfs}{VRTSPATCHES}{"5.8"}=["113605"];
	$PKGI{VRTSvxfs}{VRTSPATCHES}{"5.9"}=["113606"];
}

1;
#
#

# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms
#$CMD{START}{proc}="/etc/rc2.d/S99myproc";

# Define product specific information
# VRTSdb2ed  - VERITAS Storage Foundation for DB2 
$PROD{SFDB2}{MAINPKG}="VRTSdb2ed";
$PROD{SFDB2}{GUIPKG}="VRTSd2gui";
$PROD{SFDB2}{UGVERS}=["1.0", "1.2", "1.0.1", "3.2", "3.4", "3.5"];

# Define packages to be installed, per product mode
$PROD{SFDB2DB}{PKGS}=["VRTSdb2ed","VRTSvxmsa","VRTSd2gui","VRTSd2doc", "VRTSvail" ];

$PROD{SFDB2}{PKGS}=[@{$PROD{SFDB2DB}{PKGS}}];

# Define package information
#
# SPACE holds the needed size (KB) for /opt, /usr, /var and / file systems.
# Need to find out the detailed info. for 4.0

$PKGI{VRTSdb2ed}{SPACE}=[30000,50,0,5];
	
$PKGI{VRTSvxmsa}{SPACE}=[1500,0,0,0];
	
$PKGI{VRTSd2doc}{SPACE}=[20000,0,0,0];

$PKGI{VRTSd2gui}{SPACE}=[8500,0,0,0];

$PKGI{VRTSvail}{SPACE}=[126799,0,20,20];
	
$PKGI{VRTSdb2ed}{JA}=[ qw(VRTSjadb2 VRTSjad2d) ];
$PKGI{VRTSd2gui}{JA}=[ qw(VRTSjad2g) ];
# $PKGI{VRTSvxsma}{JA}=[ qw(VRTSjamsa) ]; defined in SFORA.pl

# No product/platform specific subroutines are required
# Use them only if necessary

# This flag is used by sfdb2_dbg_pl().
####$FLAG{SFDB2_DBG} = 1;

sub _sfdb2_dbg_pl{
	my ($msg) = (@_);
	if ($FLAG{SFDB2_DBG}) {
		_pl("\nDBG: $msg", 181, 1000, "$msg");
	}
}

#
# Misc checks for compatability. All of these routines
# are procedures which will determine whether the install
# must stop.

#################################################################
# _sfdb2_verify_dbed : The purpose of this subroutine is to detect if
#		      Oracle Database Edition is installed. If yes
#			set a flag
# Parameter : None
# Return    : None
#
# BUG:      This function only checks for the VRTSodm package.
#           Perhaps the author intended to put the "if ($dbed_inst)"
#           inside the foreach loop?  Seems pretty likely to me.
#
#################################################################
sub _sfdb2_sun_verify_dbed() {
        my ($dbed_inst, $opkg);

        _sfdb2_dbg_pl("_sfdb2_sun_verify_dbed");
	#print "calling _sfdb2_sun_verify_dbed\n";
        foreach $PKG("VRTSdbed", "VRTSodm") {
                $dbed_inst = _sun_get_instpkgvers();
        }
        if ($dbed_inst) {
                $FLAG{DBED_PKG_INST}=1;
        }
}

#
# Verify EMC-DBED components
sub _sfdb2_verify_vxtf_package {
	my ($vxtf_installed, $opkg, $TFT);

	_sfdb2_dbg_pl("_sfdb2_verify_vxtf_package called");
	
	$TFT = $ENV{"FORGET_TFT"};
	if ($TFT ne "") {
		_sfdb2_dbg_pl("Environment variable FORGET_TFT: $TFT");
		return 1;
	}
	else {
		_sfdb2_dbg_pl("Environment variable FORGET_TFT is null");
	}	

	$opkg=$PKG;
	$PKG="VRTSvxtf";
	$vxtf_installed = _sun_get_instpkgvers();
	$PKG=$opkg;
	
	if ($vxtf_installed) {
		_pl("\nERROR: The VERITAS Time Finder utilities are installed\non this system. These utilities are part of the EMC-\nspecific Storage Foudation for DB2 and may depend on\ncustomized versions of the VERITAS Volume Manager\nsoftware or on specific release levels of the Volume\nManager. If you are certain that you want to install\nthe non-EMC Storage Foundation for DB2, possibly\ndisabling the current EMC-specific Database Edition,\nset the FORGET_TFT environment variable to 'yes' and\nrestart the installation.", 181, 1001);
		_die("Installation process terminated.", 181, 1002);
	}
   	return 1;	
}

#
# check SUNWvxvm installation -- bail out if so
sub _sfdb2_verify_SUNWvxvm_package {
	my ($sunwvxvm_installed, $opkg);

	_sfdb2_dbg_pl("_sfdb2_verify_SUNWvxvm_package called");
	
	$opkg=$PKG;
	$PKG="SUNWvxvm";
	$sunwvxvm_installed = _sun_get_instpkgvers();
	$PKG=$opkg;
	
	if ($sunwvxvm_installed) {
		_pl("\nThe installation program detects a Volume Manager release that is\nSun SPARCstorage Array specific (SUNWvxvm) on the system.\nFollow the upgrade procedure described in the Upgrade Chapter of the Installation \nGuide to upgrade your system.\n", 181, 1003);
		_die("Installation process terminated.", 181, 1002);
	}
   	return 1;	
}

###################################################################
#
# sub : _sfdb2_verify_vxfs_package 
#	This function detects VRTSvxfs package and if it is installed then
#	compare the version of installed package and media package.
#	If package is not installed or version is not same, touch a file
#	/tmp/.not_vxfs
# paramter : None
# return : None
#
#
###################################################################
sub _sfdb2_verify_vxfs_package() {
	my ($vxfs_installed,$cmd, $opkg, $m_ver, $i_ver);

	_sfdb2_dbg_pl("_sfdb2_verify_vxfs_package called");

	$opkg = $PKG;
	$PKG = "VRTSvxfs";
	$PATH{NO_VXFS} = "/tmp/.not_vxfs";

	$i_ver = _sun_get_instpkgvers();
	_sfdb2_dbg_pl("Installed version = $i_ver");
	_sfdb2_dbg_pl("checking package  = $PKG");

	if ($i_ver) {
		$m_ver = _sun_get_mediapkgvers();
		_sfdb2_dbg_pl("media version = $m_ver");
		if ( $i_ver ne $m_ver ) {
			_sfdb2_dbg_pl("Version are name same");
			_dor("$CMD{TOUCH} $PATH{NO_VXFS}");
		}
	} else {
		
		_dor("$CMD{TOUCH} $PATH{NO_VXFS}");
	}
	$PKG = $opkg;	
}

##################################################################
sub _sfdb2_verify_kernel_config {
	my($do,$ret_st);
	$ret_st=1;

	_sfdb2_dbg_pl("_sfdb2_verify_kernel_config");
	
	_sfdb2_dbg_pl("Check if shmsys and semsys module are loaded.\n");
	$do = _dor("modinfo | egrep \"semsys|shmsys\"", $ret_st);
	if ($do != 0) {
		_pl("WARNING: Do not yet see Shared Memory or Semaphore kernel modules\nloaded. You may need to make changes to the file /etc/system and/or\nreboot your system in order to use your DB2 database.", 181, 1004);
		_prtc();
	}

	_sfdb2_dbg_pl("Check if /etc/systme file contain shmsys and semsys module setting.\n");
	$do = _dor("egrep \"[^ 	]*semsys:|[^ 	]*shmsys:\" /etc/system", $ret_st);
	if ($do != 0) {
		_pl("WARNING: Do not yet see Shared Memory or Semaphore kernel settings\nin the file /etc/system. You will need to make changes to this file\nand reboot your system in order to use your DB2 database.\nFor precise settings, consult your current DB2 installation\nand configuration documentation.", 181, 1005);
		_prtc();
	}
}

# perform any checks or tasks necessary before the installation on Solaris platform
sub _sfdb2_sun_initial_systemcheck 
{
	my($v, $p, $sys);

	_sfdb2_dbg_pl("_sfdb2_sun_initial_systemcheck called");
	
	$v = $COMM{OSVERS}{$SYS};
	$sys = _dor("$CMD{UNAME} -i");

	return;

}
							 

sub _sfdb2_sun_prestop {
	return if ($OPT{UNINSTALL});
	_vm_sun_prestop();
	_sfdb2_verify_vxtf_package();
	_sfdb2_verify_SUNWvxvm_package();
	_sfdb2_verify_vxfs_package();
	_sfdb2_verify_kernel_config();
}

sub _sfdb2_sun_pkgrequest_questions {
	_vm_sun_pkgrequest_questions();
}

sub _sfdb2_sun_do_lic_processing {
	_vm_sun_do_lic_processing();
}

sub _sfdb2_sun_poststart {
	_vm_sun_poststart();
}
#
#

# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms
#$CMD{START}{proc}="/etc/rc2.d/S99myproc";

# Define product specific information
# VRTSdbed  - VERITAS Database Edition for Oracle
$PROD{SFORA}{MAINPKG}="VRTSdbed";
$PROD{SFORA}{GUIPKG}="VRTSorgui";

####
$PKGI{VRTSdbed}{JA}=[ qw(VRTSjadbe VRTSjaord) ];
$PKGI{VRTSorgui}{JA}=[ qw(VRTSjaorg) ];
$PKGI{VRTSvxmsa}{JA}=[ qw(VRTSjamsa) ];
$PKGI{VRTSvail}{JA}=[ qw(VRTSjaap) ];

# VRTSvxmsa version # is 2.1 in DBED 3.5 MP1 release
$PROD{SFORA}{UGVERS}=["2.1", "3.0", "3.5", "4.0"];

# Define packages to be installed, per product mode
$PROD{SFORADB}{PKGS}=["VRTSdbed","VRTSodm","VRTSvxmsa","VRTSorgui","VRTSordoc", "VRTSvail"];

$PROD{SFORA}{PKGS}=[@{$PROD{SFORADB}{PKGS}}];

# Define package information
#
# SPACE holds the needed size (KB) for /opt, /usr, /var and / file systems.
# Need to find out the detailed info. for 4.0

$PKGI{VRTSdbed}{SPACE}=[30000,50,0,5];

$PKGI{VRTSvxmsa}{SPACE}=[1500,0,0,0];
	
$PKGI{VRTSordoc}{SPACE}=[20000,0,0,0];

$PKGI{VRTSorgui}{SPACE}=[8500,0,0,0];

$PKGI{VRTSvail}{SPACE}=[126970,0,20,20];


	
# No product/platform specific subroutines are required
# Use them only if necessary

# This flag is used by sfora_dbg_pl().
###$FLAG{SFORA_DBG} = 1;

sub _sfora_dbg_pl{
	my ($msg) = (@_);
	if ($FLAG{SFORA_DBG}) {
		_pl("\nDBG: $msg", 171, 1000, "$msg");
	}
}

#
# Misc checks for compatability. All of these routines
# are procedures which will determine whether the install
# must stop.

#
# Verify EMC-DBED components
sub _sfora_verify_vxtf_package {
	my ($vxtf_installed, $opkg, $TFT);

	_sfora_dbg_pl("_sfora_verify_vxtf_package called");
	
	$opkg=$PKG;
	$PKG="VRTSvxtf";
	$vxtf_installed = _sun_get_instpkgvers();
	$PKG=$opkg;
	
	if ($vxtf_installed) {
		_pl("\nERROR: The VERITAS Time Finder utilities package (VRTSvxtf) is installed on this system. These utilities are part of the EMC-specific Database Edition for Oracle and may depend on customized versions of the VERITAS Volume Manager software or on specific release levels of the Volume Manager.\n", 171, 1012);
		_pl("VERITAS Storage Foundation for Oracle installation can't continue with the VRTSvxft package installed.\n", 171, 1007);
		_pl("Remove the package using the command 'pkgrm VRTSvxtf' and restart the installation.\n", 171, 1008);

		_die("Installation process terminated.", 171, 1002);
	}
   	return 1;	
}

#####################################################################
# _sfora_verify_fas_package :
# 	The purpose of this sub-routine is to verify  if FAS is installed and if yes
#	then bail out as VRTSvail and FAS can't co-exists. This problem should be fixed
#	in next release and this check should be removed from CPI.
# return : die if FAS is installed with error message. else retuen 1
#
#
#
#
#
####################################################################
sub _sfora_verify_fas_package {
	my ($fas_installed, $opkg, $FAS);

	_sfora_dbg_pl("_sfora_verify_vxtf_package called");
	
	$opkg=$PKG;
	$PKG="VRTSfas";
	$fas_installed = _sun_get_instpkgvers();
	if ($fas_installed) {
		_pl("\nERROR: The FlashSnap Agent for Symmetrix (VRTSfas) is installed on this system. These utilities are part of the EMC-specific Database Edition for Oracle and conflict with VERITAS Array provider (VRTSvail).\n", 171, 1013);
		_pl("Installation can't continue with the VRTSfas package installed.  Remove the package using the command 'pkgrm VRTSfas' and restart the installation.", 171, 1010);
		_pl("If you are certain that you want to install VRTSfas, refer to the workaround for the VRTSfas package in the VERITAS Storage Foundation for Oracle release notes.", 171, 1011);
		 _die("Installation process terminated.", 171, 1002);
	}
   	return 1;	
}

#################################################################
# _sfora_verify_db2ed : The purpose of this subroutine is to detect if
#			DB2 Database Edition is installed. If yes
#			set a flag
# Parameter : None
# Return    : None
#
#
###############################################################
sub _sfora_sun_verify_db2ed() {
	my $db2ed_inst;
	
	$PKG = "VRTSdb2ed";
	$db2ed_inst = _sun_get_instpkgvers();
	if ($db2ed_inst) {
		$FLAG{DB2ED_PKG_INST} = 1;
	}	

}
#
# check SUNWvxvm installation -- bail out if so
sub _sfora_verify_SUNWvxvm_package {
	my ($sunwvxvm_installed, $opkg);

	_sfora_dbg_pl("_sfora_verify_SUNWvxvm_package called");
	
	$opkg=$PKG;
	$PKG="SUNWvxvm";
	$sunwvxvm_installed = _sun_get_instpkgvers();
	$PKG=$opkg;
	
	if ($sunwvxvm_installed) {
		_pl("\nThe installation program detects a Volume Manager release that is\nSun SPARCstorage Array specific (SUNWvxvm) on the system.\nFollow the upgrade procedure described in the Upgrade Chapter of the Installation \nGuide to upgrade your system.\n", 171, 1003);
		_die("Installation process terminated.", 171, 1002);
	}
   	return 1;	
}

sub _sfora_verify_kernel_config {
	my($do,$ret_st);
	$ret_st=1;

	_sfora_dbg_pl("_sfora_verify_kernel_config");
	
	_sfora_dbg_pl("Check if shmsys and semsys module are loaded.\n");
	$do = _dor("modinfo | egrep \"semsys|shmsys\"", $ret_st);
	if ($do != 0) {
		_pl("WARNING: Do not yet see Shared Memory or Semaphore kernel modules\nloaded. You may need to make changes to the file /etc/system and/or\nreboot your system in order to use your Oracle database.", 171, 1004);
		_prtc();
	}

	_sfora_dbg_pl("Check if /etc/systme file contain shmsys and semsys module setting.\n");
	$do = _dor("egrep \"[^ 	]*semsys:|[^ 	]*shmsys:\" /etc/system", $ret_st);
	if ($do != 0) {
		_pl("WARNING: Do not yet see Shared Memory or Semaphore kernel settings\nin the file /etc/system. You will need to make changes to this file\nand reboot your system in order to use your Oracle database.\nFor precise settings, consult your current Oracle installation\nand configuration documentation.", 171, 1005);
		_prtc();
	}
}

###################################################################
#
# sub : _sfora_verify_vxfs_package
#       This function detects VRTSvxfs package and if it is installed then
#       compare the version of installed package and media package.
#       If package is not installed or version is not same, touch a file
#       /tmp/.not_vxfs
# paramter : None
# return : None
#
#
###################################################################
sub _sfora_verify_vxfs_package() {
        my ($vxfs_installed,$cmd, $opkg, $m_ver, $i_ver);

        _sfora_dbg_pl("_sfora_verify_vxfs_package called");

        $opkg = $PKG;
        $PKG = "VRTSvxfs";
        $PATH{NO_VXFS} = "/tmp/.not_vxfs";

        $i_ver = _sun_get_instpkgvers();
        _sfora_dbg_pl("Installed version = $i_ver");
        _sfora_dbg_pl("checking package  = $PKG");

        if ($i_ver) {
                $m_ver = _sun_get_mediapkgvers();
                _sfora_dbg_pl("media version = $m_ver");
                if ( $i_ver ne $m_ver ) {
                        _sfora_dbg_pl("Version are same");
                        _dor("$CMD{TOUCH} $PATH{NO_VXFS}");
                }
        } else {

                _dor("$CMD{TOUCH} $PATH{NO_VXFS}");
        }
        $PKG = $opkg;  
}

# perform any checks or tasks necessary before the installation on Solaris platform
sub _sfora_sun_initial_systemcheck 
{
	my($v, $p, $sys);

	_sfora_dbg_pl("_sfora_sun_initial_systemcheck called");
	
	$v = $COMM{OSVERS}{$SYS};
	$sys = _dor("$CMD{UNAME} -i");

	return;

}


sub _sfora_sun_prestop {
	return if ($OPT{UNINSTALL});

	_vm_sun_prestop();
	_sfora_verify_vxtf_package();
	_sfora_verify_fas_package();
	_sfora_verify_vxfs_package();
	_sfora_verify_SUNWvxvm_package();
	_sfora_verify_kernel_config();
}

sub _sfora_sun_pkgrequest_questions {
	_vm_sun_pkgrequest_questions();
}

sub _sfora_sun_do_lic_processing {
	_vm_sun_do_lic_processing();
}

sub _sfora_sun_poststart {
	_vm_sun_poststart();
}
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{SFRAC}{MAINPKG}="VRTSdbac";
$PROD{SFRAC}{UGVERS}=["3.5"];
$PROD{SFRAC}{SUPPOSVERS}=[ qw(5.8 5.9) ];

#  SFRAC specific packages.  _sfrac_comm_define_pkgs glues this list to
#  the lists from VM, FS and VCS.
#
$PROD{SFRAC}{PKGS}=[ qw(
    VRTSvail
    VRTSdbac
    VRTSracdc
    VRTSvcsor
    VRTScsocw
    VRTSvcsvr
    VRTSdbckp
    VRTSvxmsa ) ];

# Define package information
$PKGI{VRTSdbac}{SPACE}  = [4000,500,20,4000];
$PKGI{VRTSracdc}{SPACE} = [2000,0,20,0];
$PKGI{VRTSvcsor}{SPACE} = [800,0,20,20];
$PKGI{VRTScsocw}{SPACE} = [1300,0,10,0];
$PKGI{VRTSdbac}{DRIVERS}= [ qw(vcsmm lmx) ];
$PKGI{VRTSdbac}{JA}     = [ qw(VRTSjadba VRTSjarad) ];

$CMD{STOP}{sfrac_odm}   = "umount /dev/odm";
$CMD{STOP}{sfrac_had}   = "/opt/VRTSvcs/bin/hastop -all";

sub _sfrac_sun_check_system_vars {
	my $Warn   = _tr("WARNING:", 221, 1000);
	my $lessth = _tr("is less than", 221, 1001);
	my $script = <<EOScript;

	res=/tmp/.svres.\$\$
	echo 0 > \${res}
	while read var val
	do
	  sv=`egrep "^[ 	]+set[ 	]+\${var}=" /etc/system | \
	    sed "s/.*\${var}=//"`
	  if test -z "\${sv}" || test "\${sv}" -lt \${val}
	  then
	    echo 1 > \${res}
	    echo "${Warn} \${var} ${lessth} \${val}"
	  fi
	done <<_EndOfVals_
	shmsys:shminfo_shmmax 4294967295
	shmsys:shminfo_shmmin 1
	shmsys:shminfo_shmmni 100
	shmsys:shminfo_shmseg 10
	semsys:seminfo_semmni 100
	semsys:seminfo_semmsl 500
	semsys:seminfo_semmns 500
	semsys:seminfo_semopm 100
	semsys:seminfo_semvmx 32767
_EndOfVals_
	retval=`cat \${res}`
	rm \${res}
	exit \${retval}
EOScript
	my $res = _dol( "$CMD{RSH} ${SYS} '${script}'" );
	_pl( $res ) if ($res);
}

sub _sfrac_sun_defines {
	my @pkgs = _sfrac_comm_define_pkgs();
	foreach my $pkg( @pkgs ) {
		my $fn = "_${pkg}_sun_defines";
		&$fn() if (defined( &$fn ));
	}
}

## Local Variables:
## mode: perl
## tab-width: 8
## perl-indent-level: 8
## End:
## end of sun/ODM.pl
#
#

# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms
#$CMD{START}{proc}="/etc/rc2.d/S99myproc";

# Define product specific information
# VRTSsybed  - VERITAS Database Edition for Sybase
$PROD{SFSYB}{MAINPKG}="VRTSsybed";

$PROD{SFSYB}{UGVERS}=["1.5","3.2","3.4","4.0"];

# Define packages to be installed, per product mode
$PROD{SFSYBDB}{PKGS}=["VRTSsybed", "VRTSsydoc"];

$PROD{SFSYB}{PKGS}=[@{$PROD{SFSYBDB}{PKGS}}];

# Define package information
#
# SPACE holds the needed size (KB) for /opt, /usr, /var and / file systems.
# Need to find out the detailed info. for 4.0

$PKGI{VRTSsybed}{SPACE}=[30000,50,0,5];
	
$PKGI{VRTSsydoc}{SPACE}=[20000,0,0,0];

# No product/platform specific subroutines are required
# Use them only if necessary

# This flag is used by sfsyb_dbg_pl().
###$FLAG{SFSYB_DBG} = 1;

sub _sfsyb_dbg_pl{
	my ($msg) = (@_);
	if ($FLAG{SFSYB_DBG}) {
		_pl("\nDBG: $msg", 191, 1000, "$msg");
	}
}

#
# Misc checks for compatability. All of these routines
# are procedures which will determine whether the install
# must stop.

#################################################################
# _sfsyb_verify_db2ed : The purpose of this subroutine is to detect if
#			DB2 Database Edition is installed. If yes
#			set a flag
# Parameter : None
# Return    : None
#
#
###############################################################
sub _sfsyb_sun_verify_db2ed() {
	my $db2ed_inst;
	
	$PKG = "VRTSdb2ed";
	$db2ed_inst = _sun_get_instpkgvers();
	if ($db2ed_inst) {
		$FLAG{DB2ED_PKG_INST} = 1;
	}	

}
#
# check SUNWvxvm installation -- bail out if so
sub _sfsyb_verify_SUNWvxvm_package {
	my ($sunwvxvm_installed, $opkg);

	_sfsyb_dbg_pl("_sfsyb_verify_SUNWvxvm_package called");
	
	$opkg=$PKG;
	$PKG="SUNWvxvm";
	$sunwvxvm_installed = _sun_get_instpkgvers();
	$PKG=$opkg;
	
	if ($sunwvxvm_installed) {
		_pl("\nThe installation program detects a Volume Manager release that is\nSun SPARCstorage Array specific (SUNWvxvm) on the system.\nFollow the upgrade procedure described in the Upgrade Chapter of the Installation \nGuide to upgrade your system.\n", 191, 1001);
		_die("Installation process terminated.", 191, 1002);
	}
   	return 1;	
}

sub _sfsyb_verify_kernel_config {
	my($do,$ret_st);
	$ret_st=1;

	_sfsyb_dbg_pl("_sfsyb_verify_kernel_config");
	
	_sfsyb_dbg_pl("Check if shmsys and semsys module are loaded.\n");
	$do = _dor("modinfo | egrep \"semsys|shmsys\"", $ret_st);
	if ($do != 0) {
		_pl("WARNING: Do not yet see Shared Memory or Semaphore kernel modules\nloaded. You may need to make changes to the file /etc/system and/or\nreboot your system in order to use your Sybase database.", 191, 1003);
		_prtc();
	}

	_sfsyb_dbg_pl("Check if /etc/systme file contain shmsys and semsys module setting.\n");
	$do = _dor("egrep \"[^ 	]*semsys:|[^ 	]*shmsys:\" /etc/system", $ret_st);
	if ($do != 0) {
		_pl("WARNING: Do not yet see Shared Memory or Semaphore kernel settings\nin the file /etc/system. You will need to make changes to this file\nand reboot your system in order to use your Sybase database.\nFor precise settings, consult your current Sybase installation\nand configuration documentation.", 191, 1004);
		_prtc();
	}
}

###################################################################
#
# sub : _sfsyb_verify_vxfs_package
#       This function detects VRTSvxfs package and if it is installed then
#       compare the version of installed package and media package.
#       If package is not installed or version is not same, touch a file
#       /tmp/.not_vxfs
# paramter : None
# return : None
#
#
###################################################################
sub _sfsyb_verify_vxfs_package() {
        my ($vxfs_installed,$cmd, $opkg, $m_ver, $i_ver);

        _sfsyb_dbg_pl("_sfsyb_verify_vxfs_package called");

        $opkg = $PKG;
        $PKG = "VRTSvxfs";
        $PATH{NO_VXFS} = "/tmp/.not_vxfs";

        $i_ver = _sun_get_instpkgvers();
        _sfsyb_dbg_pl("Installed version = $i_ver");
        _sfsyb_dbg_pl("checking package  = $PKG");

        if ($i_ver) {
                $m_ver = _sun_get_mediapkgvers();
                _sfsyb_dbg_pl("media version = $m_ver");
                if ( $i_ver ne $m_ver ) {
                        _sfsyb_dbg_pl("Version are same");
                        _dor("$CMD{TOUCH} $PATH{NO_VXFS}");
                }
        } else {

                _dor("$CMD{TOUCH} $PATH{NO_VXFS}");
        }
        $PKG = $opkg;  
}

# perform any checks or tasks necessary before the installation on Solaris platform
sub _sfsyb_sun_initial_systemcheck 
{
	my($v, $p, $sys);

	_sfsyb_dbg_pl("_sfsyb_sun_initial_systemcheck called");
	
	$v = $COMM{OSVERS}{$SYS};
	$sys = _dor("$CMD{UNAME} -i");

	return;

}


sub _sfsyb_sun_prestop {
	return if ($OPT{UNINSTALL});

	_vm_sun_prestop();
	_sfsyb_verify_vxfs_package();
	_sfsyb_verify_SUNWvxvm_package();
	_sfsyb_verify_kernel_config();
}

sub _sfsyb_sun_pkgrequest_questions {
	_vm_sun_pkgrequest_questions();
}

sub _sfsyb_sun_do_lic_processing {
	_vm_sun_do_lic_processing();
}

sub _sfsyb_sun_poststart {
	_vm_sun_poststart();
}
# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms
$CMD{START}{vxsald}="/etc/init.d/vxsal start";

# Define product specific information
$PROD{SPCQS}{MAINPKG}="VRTSsal";
$PROD{SPCQS}{UGVERS}=["3.5"];

# Define default packages to be installed
# (This is now done dynamically in common/SPCQS.pl)

# Define package lists
$PROD{SPCQS}{LEGACYPKGS}=["VRTSsalr","VRTSspcq","VRTSspcs"];
$PROD{SPCQS}{SRVONLYPKGS}=["VRTSspcqs"];

# Define package information
$PKGI{VRTSsal}{SPACE}=[30780,0,10,0];
$PKGI{VRTSsal}{CLASSES}="none";
$PKGI{VRTSsal}{PROCS}=["vxsald"];
$PKGI{VRTSsal}{REQOSPATCHES}{"5.7"}=["106950","106980","106327","106300"];
$PKGI{VRTSsal}{REQOSPATCHES}{"5.8"}=["108827","108434","108435"];

$PKGI{VRTSspcqs}{SPACE}=[0,0,0,0];
$PKGI{VRTSspcqs}{CLASSES}="none";
$PKGI{VRTSspcqs}{JA}=[ qw(VRTSjaspq) ];

$PKGI{VRTSspcfg}{SPACE}=[0,0,0,0];
$PKGI{VRTSspcfg}{CLASSES}="none";

$PKGI{VRTSspqdc}{SPACE}=[0,0,0,0];
$PKGI{VRTSspqdc}{CLASSES}="none";
$PKGI{VRTSspqdc}{JA}=[ qw(VRTSjasqd) ];

$PKGI{VRTSspqmn}{SPACE}=[0,0,0,0];
$PKGI{VRTSspqmn}{CLASSES}="none";
$PKGI{VRTSspqmn}{JA}=[ qw(VRTSjasqm) ];

# No product/platform specific subroutines are required
# Use them only if necessary

## Function: _spcqs_sun_preinstall
## Comment: Performs preinstall tasks for SPCQS 
## Params: None
## Output: None 

sub _spcqs_sun_preinstall {

        return if ($OPT{CONFIGURE});
        my(@pkgs,$pkg,$svpkg);

        $svpkg=$PKG;        
        foreach $SYS(@SYSI){
                _spcqs_sun_sal_preinstall ();
                foreach $pkg(@{$PROD{SPCQS}{PKGS}}){
                        $PKG=$pkg; 
                        if ($PKG ne "VRTSobgui") {_sun_create_responsefile("BASEDIR=\"$PKGI{$PKG}{BASEDIR}\"\nCLASSES=\"$PKGI{$PKG}{CLASSES}\"");}
                }
        }
        $PKG=$svpkg;
}

## Function: _spcqs_sun_sal_preinstall
## Comment: Performs preinstall tasks for SAL
## Params: None
## Output: 1 if all patches were found
##         0 if patches are needed 

sub _spcqs_sun_sal_preinstall {
         
        my (%lst,@patches,$cnt,$ptch,$sr,$os,$rv,$pkgpr,$pid,$rp,$svpkg);

        $rv="1";
        $os=_dor("$CMD{UNAME} -r");

        #Check for legacy SAL pkgs
        $svpkg=$PKG;
        foreach $pkgpr(@{$PROD{SPCQS}{LEGACYPKGS}}) {
                $PKG=$pkgpr;
                if (_sun_get_instpkgvers($pkgpr)) {
                        _clr_scrn();
                        _title();
                        _die("\nThis installation detected the SANPoint Control package $pkgpr installed on $SYS.  Legacy SANPoint Control packages must be removed before installation of $UPI 4.0.\nRemove $pkgpr from $SYS and run this installation again.", 211, 1011, "$pkgpr", "$SYS", "$UPI", "$pkgpr", "$SYS");
                }
        } 
        $PKG=$svpkg;  
        
        #Stop all vxsald procs
        $pid=_comm_get_pid("vxsald"); 
        while ($pid) {
                _comm_kill_proc("vxsald",$pid);
                $pid=_comm_get_pid("vxsald");
        }
}

# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms
#$CMD{START}{tdctl}="/etc/rc2.d/S99myproc";

# Define product specific information
$PROD{TD}{MAINPKG} = "VRTStd";
$PROD{TD}{GUIPKG}  = "VRTStdw";
$PROD{TD}{DOCPKG}  = "VRTStddoc";
$PROD{TD}{UGVERS}  = ["3.5", "3.5.1","4.0A5"];

# Define packages to be installed, per product mode
$PROD{TD}{PKGS}=["VRTStd","VRTStdw","VRTStddoc"];

# Define package information
$PKGI{VRTStd}{SPACE}=[17000,1500,20,1500];
$PKGI{VRTStd}{ADMINFILE} = $PATH{ITD} . "/_td_adminfile_";
$PKGI{VRTStddoc}{ADMINFILE} = $PATH{ITD} . "/_td_adminfile_";

#
# Variables local to this file
#
my $HAGRP  = "/opt/VRTSvcs/bin/hagrp";
my $HACONF = "/opt/VRTSvcs/bin/haconf";
my $HACLUS = "/opt/VRTSvcs/bin/haclus";
my $HARES  = "/opt/VRTSvcs/bin/hares";
my $GREP   = $CMD{GREP};
my $DONE   = 0;

# No product/platform specific subroutines are required
# Use them only if necessary

sub _td_sun_preinstall
{
	my ($sys, $adminfile);
	#
	# Create adminfile and copy it to all systems
	#
	$adminfile = sprintf("%s/%s", $PATH{ITD}, "/_td_adminfile_");
	open(FP, ">$adminfile") or
		_die("ERROR: unable to create $adminfile\n", 141, 1000, "$adminfile");
	printf FP <<_EOF_;
mail=
instance=quit
partial=quit
runlevel=quit
idepend=quit
rdepend=nocheck
space=quit
setuid=quit
conflict=nocheck
action=nocheck
basedir=/opt
_EOF_
	close(FP);
	if (! -f $adminfile) {
		_die("ERROR: unable to create adminfile $adminfile\n", 141, 1001, "$adminfile");
	}
	foreach $sys (@SYSI) {
		if ($sys ne $COMM{LOCALSYS}) {
			$SYS = $sys;
			_copy($adminfile, $adminfile);
		}
	}
}

# check to see if valid configuration files exist on the local system
# if so, return a reference to an array holding ("systems", "version")
sub _td_sun_check_localconfig {
	my ($maincf, $sys);
	$maincf = "/etc/VRTSvcs/conf/config/main.cf";
	if (! -f $maincf) {
		# VCS is either not installed or configured
		printf("$COMM{TPUT}{BS}");
		_die("Install and configure VCS before installing Traffic Director$COMM{TPUT}{BE}\n", 141, 1022, "$COMM{TPUT}{BE}");
	}
}

sub _td_sun_prestop {

	my ($old, $stop, $remove);

	if (! defined $OPT{UNINSTALL}) {
		return;
	}
	if ($DONE == 0) {
		check_ha_binaries();
		td_pre_uninstall();
		$DONE++;
		_prtc();
	}
}

sub check_ha_binaries()
{
	if (! -X $HAGRP) {
		_die("binary $HAGRP is not installed", 141, 1003, "$HAGRP");
	}
	if (! -X $HACONF) {
		_die("binary $HACONF is not installed", 141, 1003, "$HACONF");
	}
	if (! -X $HACLUS) {
		_die("binary $HACLUS is not installed", 141, 1003, "$HACLUS");
	}
	if (! -X $HARES) {
		_die("binary $HARES is not installed", 141, 1003, "$HARES");
	}
	$GREP = $CMD{GREP};
	if (! -X $GREP) {
		$GREP = "/usr/bin/grep";
		if (! -X $GREP) {
			$GREP = "/usr/grep";
			if (! -X $GREP) {
				_die("binary $GREP is not installed\n", 141, 1004, "$GREP");
			}
		}
	}
}

#
# Traffic Director pre-uninstallation steps
#
sub td_pre_uninstall()
{
	my ($cmd, $state, $try, $nsys, $sys, $res, $nstop, $pid);
	my ($host, $found, $str, $tmp);

	clr_screen();
	_title();

	#
	# If VCS is not running on the host then we can't uninstall TD
	#
	_pb1("Checking if VCS is running", 141, 1005);
	if (($pid = get_pid($COMM{LOCALSYS}, "had")) == 0) {
		_die("Cannot uninstall TD if VCS is not running\n", 141, 1006);
	}
	if (haconf_canwrite() != 1) {
		_die("VCS configuration is not in writable state\n", 141, 1007);
	}
	_pb2("yes", 141, 1008);

	#
	# Stop Traffic Director on both the nodes
	#
	foreach $sys (@SYSI) {
		_pb1("Stopping Traffic Director on host $sys", 141, 1009, "$sys");
		$tmp = $SYS;
		$SYS = $sys;
		if ($sys eq $COMM{LOCALSYS}) {
			_dol("/sbin/tdctl -f -stop");
		} else {
			_dor("/sbin/tdctl -f -stop");
		}
		$pid = 0;
		$try = 0;
		while ($try < 3) {
			if ($sys eq $COMM{LOCALSYS}) {
				_dol("/sbin/tdd -stop", 1);
			} else {
				_dor("/sbin/tdd -stop", 1);
			}
			$pid = get_pid($sys, "tdd");
			if ($pid != 0) {
				if ($sys eq $COMM{LOCALSYS}) {
					_dol("$CMD{KILL} -9 $pid", 1);
				} else {
					_dor("$CMD{KILL} -9 $pid", 1);
				}
				$try++;
			} else {
				last;
			}
		}
		$pid = get_pid($sys, "tdd");
		if ($pid != 0) {
			$SYS = $tmp;
			_die("Cannot uninstall TD without stopping tdd (pid=$pid)\n", 141, 1010, "$pid");
		} else {
			_pb2("done", 141, 1011);
		}
		$SYS = $tmp;
	}

	#
	# Remove group dependencies first
	#
	_pb1("Unconfiguring TDservice from VCS", 141, 1012);
	if (remove_dependency() != 0) {
		_die("Unable to unlink TDService dependencies\n", 141, 1013);
	}

	haconf_makerw();
	foreach $sys (@SYSI) {
		$cmd = trim(_dol("$HAGRP -list | $GREP TDService | $GREP $sys", ""));
		if ($cmd eq "") {
			next;
		}
		$try = 0;
		$state = "UNKNOWN";
		while (($try < 10) && (!(uc($state) =~ /.*OFFLINE.*/))) {
			if ($try != 0) {
				sleep(1);
			}
			$try++;
			_dol("$HAGRP -offline TDService -sys $sys", 1);
			$state = trim(_dol("$HAGRP -state TDService -sys $sys", ""));
		}
		if ((!(uc($state) =~ /.*OFFLINE.*/)) ||
		    (get_pid($sys, "tdd") != 0)) {
			_pb2("failed (status = $state)\n", 141, 1014, "$state");
			haconf_makero();
			printf("\n");
			_die("Cannot uninstall without stopping daemon\n", 141, 1015);
		} else {
			open(FP, "$HAGRP -resources TDService | ")
			  or _die("unable to get resources from group\n", 141, 1016);
			while (<FP>) {
				chomp;
				$res = trim($_);
				if ($res eq "") {
					next;
				}
				$cmd = _dol("$HARES -delete $res", "");
			}
			close(FP);
			$cmd = "$HAGRP -delete TDService";
			$cmd = $cmd . " | $GREP TDService | $GREP $sys";
			_dol($cmd, 1);
			$nstop++;
		}
	}
	haconf_makero();
	_pb2("done", 141, 1011);

	_pb1("Checking if GUI server is installed", 141, 1017);
	$found = 0;
	$cmd = "$HAGRP -list";
	open(FP, "$cmd |") or _die("unable to execute $cmd\n");
	while (<FP>) {
		chomp;
		$str = (split(/[\s\t]+/, $_))[0];
		if ($str eq "ClusterService") {
			$found = 1;
		}
	}
	close(FP);
	if ($found == 0) {
		_pb2("no", 141, 1018);
	} else {
		_pb2("yes", 141, 1008);
		_pb1("Stopping Traffic Director GUI server", 141, 1019);
		foreach $sys (@SYSI) {
			_dol("$HARES -offline TDweb -sys $sys", 1);
		}
		$cmd = trim(`$HARES -list | $GREP TDweb`);
		if ($cmd ne "") {
			haconf_makerw();
			_dol("$HARES -delete TDweb", 0);
			haconf_makero();
		}
		_pb2("done", 141, 1011);
	}

	#
	# Unlink TD configuration from VCS
	#
	_pb1("Removing Traffic Director config from VCS", 141, 1020);
	if (remove_td_from_vcs() != 0) {
		_pb2("failed", 141, 1021);
		exit(1);
	} else {
		_pb2("done", 141, 1011);
	}
	return;
}

sub remove_dependency()
{
	my (@groups, $cmd, $rec);

	@groups = get_hagrp_dep("TDService");

	haconf_makerw();
	foreach $rec (@groups) {
		$cmd = "$HAGRP -unlink ". $rec->{PARENT} . " " . $rec->{CHILD};
		_dol($cmd, 1);
	}
	haconf_makero();

	@groups = ();
	@groups = get_hagrp_dep("TDService");
	$rec = $groups[0];
	if ($rec->{CHILD} eq "TDService") {
		return -1;
	} else {
		return 0;
	}
}

sub get_hagrp_dep()
{
	my ($grp, $cmd, @toks, $rec, @groups);

	$grp = $_[0];

	@groups = ();
	$cmd = "$HAGRP -dep";
	open(FP, "$cmd |") or _die("unable to execute $cmd\n");
	while (<FP>) {
		chomp;
		if (($_ eq "") || (/^\#/)) {
			next;
		}
		@toks = split(/[\s\t]+/, $_);
		if ($toks[1] eq $grp) {
			$rec = {
				CHILD  => $toks[1],
				PARENT => $toks[0]
			};
			push(@groups, $rec);
		}
	}
	close(FP);
	return @groups;
}

sub remove_td_from_vcs()
{
	my (%GG, $grp, $gg, $ret);

	%GG = vcs_get_td_groups();
	while (($grp, $gg) = each %GG) {
		if (($grp =~ /^Domain_.*/) || ($grp =~ /^NatIP_.*/) ||
		    ($grp =~ /^Vip_.*/)) {
			$ret = hagrp_delete($grp);
			if ($ret != 0) {
#				return -1;
			}
		}
	}
	_dol("/sbin/tdd -unlink", 1);

	#
	# Check if there are any TD related groups
	#
	%GG = vcs_get_td_groups();
	while (($grp, $gg) = each %GG) {
		if (($grp =~ /^Domain_.*/) || ($grp =~ /^NatIP_.*/) ||
		    ($grp =~ /^Vip_.*/)) {
			return -1;
		}
	}
	return 0;
}

sub vcs_get_td_groups()
{
	my ($cmd, $grp, $sys, %GG, @arr);

	$cmd = "$HAGRP -list Tag=TD";
	open(FP, "$cmd |") or 
		_die("unable to execute cmd $cmd", 141, 1023, "$cmd");
	while (<FP>) {
		chomp;
		if (/^(.*)[\s\t]+(.*)$/) {
			$grp = trim($1);
			$sys = trim($2);
			if (! defined $GG{$grp}) {
				@arr = ();
				$GG{$grp} = [ @arr ];
			}
			push(@{$GG{$grp}}, $sys);
		}
	}
	close(FP);
	return %GG;
}

sub hagrp_delete()
{
	my ($grp, $try, $ret);

	$grp = $_[0];

	if (hagrp_offline($grp) != 0) {
		return -2;
	}
	haconf_makerw();
	_dol("$HAGRP -delete $grp", 1);
	$try = 5;
	$ret = -1;
	while ($try > 0) {
		$try--;
		if (hagrp_isthere($grp) == 0) {
			$ret = 0;
			last;
		}
		sleep(1);
	}
	haconf_makero();
	return $ret;
}

sub hagrp_offline()
{
	my ($grp, $sys, $cmd, @toks, $try, $ret, $state);

	($grp, $sys) = @_;
	if ($sys eq "") {
		$cmd = "$HAGRP -state $grp";
		open(FP, "$cmd |") or 
			_die("unable to execute $cmd", 141, 1024, "$cmd");
		while (<FP>) {
			chomp;
			@toks = split(/[\s\t]+/, $_);
			if ($toks[0] eq $grp) {
				if ($toks[3] =~ /.*ONLINE.*/) {
					$sys = $toks[2];
					last;
				}
			}
		}
		close(FP);
	}

	if ($sys eq "") {
		return 0;
	}

	_dol("$HAGRP -offline $grp -sys $sys", 1);
	$try = 5;
	$ret = -1;
	while ($try > 0) {
		$try--;
		$state = hagrp_state($grp, $sys);
		if ($state =~ /.*OFFLINE.*/) {
			$ret = 0;
			last;
		}
		sleep(1);
	}
	return $ret;
}

sub hagrp_state()
{
	my ($grp, $sys, $state);

	($grp, $sys) = @_;
	$state = trim(`$HAGRP -state $grp -sys $sys`);
	return $state;
}

sub hagrp_isthere()
{
	my ($grp, $cmd, @toks, $ret);

	$grp = $_[0];
	$cmd = "$HAGRP -list";
	$ret = 0;
	open(FP, "$cmd |") or 
		_die("unable to execute $cmd", 141, 1024, "$cmd");
	while (<FP>) {
		chomp;
		@toks = split(/[\s\t]+/, $_);
		if ($toks[0] eq $grp) {
			$ret = 1;
			last;
		}
	}
	close(FP);
	return $ret;
}

sub haconf_makerw()
{
	my $try;

	$try = 5;
	while ($try > 0) {
		$try--;
		if (haconf_isdumping() == 0) {
			last;
		}
		sleep(1);
	}

	if (haconf_isreadonly() == 1) {
		`$HACONF -makerw`;
	}

	$try = 5;
	while ($try > 0) {
		$try--;
		if (haconf_canwrite() == 0) {
			last;
		}
		sleep(1);
	}
	if (haconf_canwrite() == 0) {
		return 0;
	}
	return -1;
}

sub haconf_makero()
{
	my $try;

	$try = 5;
	while ($try > 0) {
		$try--;
		if (haconf_isdumping() == 0) {
			last;
		}
		sleep(1);
	}

	if (haconf_isreadonly() == 0) {
		`$HACONF -dump -makero`;
		$try = 5;
		while ($try > 0) {
			$try--;
			if (haconf_isreadonly() == 1) {
				last;
			}
			sleep(1);
		}
	}

	if (haconf_isreadonly() == 1) {
		return 0;
	}
	return -1;
}

sub haconf_canwrite()
{
	#
	# Cannot  open  configuration if:  either the configuration is in
	# read-only mode or if VCS is currently dumping the configuration
	# to the disk.
	#
	if ((haconf_isreadonly() == 0) || (haconf_isdumping() == 1)) {
		return 0;
	}
	return 1;
}

sub haconf_isreadonly()
{
	my $ro;
	$ro = trim(`$HACLUS -value ReadOnly`);
	return $ro;
}

sub haconf_isdumping()
{
	my $dumping;
	$dumping = trim(`$HACLUS -value DumpingMembership`);
	return $dumping;
}

sub trim()
{
	my $str = $_[0];
	$str =~ s/^\s+//g;
	$str =~ s/\s+$//g;
	return $str;
}

sub get_pid()
{
	my ($sys, $proc, $tmp, $pid);
	($sys, $proc) = @_;
	$tmp = $SYS;
	$SYS = $sys;
	$pid = _comm_get_pid($proc);
	$SYS = $tmp;
	if ($pid eq "") {
		$pid = 0;
	}
	return int($pid);
}

sub clr_screen()
{
	if ($COMM{TPUT}{CS} ne "") {
		printf $COMM{TPUT}{CS};
	}
}

1;
#
# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#

# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms
$CMD{START}{llt}="/etc/rc2.d/S70llt";
$CMD{START}{gab}="/etc/rc2.d/S92gab";
$CMD{START}{vcs}="/etc/rc3.d/S99vcs";

$CMD{STOP}{vxfen}="/etc/init.d/vxfen stop";
$CMD{STOP}{lmx}="/etc/init.d/lmx stop";
$CMD{STOP}{vcsmm}="/etc/init.d/vcsmm stop";

# Define product specific information
$PROD{VCS}{MAINPKG}="VRTSvcs";
$PROD{VCS}{GUIPKG}="VRTScscm";
$PROD{VCS}{UGVERS}=["1.3.0","2.0","3.5"];
$PROD{VCS}{SUPPOSVERS}=[ qw(5.6 5.7 5.8 5.9) ];

# Define unique sets of packages to be installed, per product mode
$PROD{VCS}{PKGS}=[ qw(
    VRTSllt
    VRTSgab
    VRTSvxfen
    VRTSvcs
    VRTSvcsmg
    VRTSvcsag
    VRTSvcsmn
    VRTScspro
    VRTSvcsdc
    VRTSjre
    VRTScutil
    VRTScssim
    VRTScscw
    VRTSweb
    VRTSvcsw
    VRTScscm ) ];

$PROD{VCSTD}{PKGS}=[ qw(VRTSllt VRTSgab VRTSvcs VRTSvcsmg VRTSvcsag VRTSvcsmn VRTSvcsdc VRTSjre VRTScutil VRTScscw VRTSweb VRTSvcsw) ];

$PROD{VCSSFCFS}{PKGS}=[ qw(VRTSllt VRTSgab VRTSvxfen VRTSvcs VRTSvcsmg VRTSvcsmn) ];

# Define package information
$PKGI{VRTSvxfen}{DRIVERS}=[ "vxfen" ];
$PKGI{VRTSvxfen}{DEPS}=[ "VRTSgab" ];
$PKGI{VRTSvxfen}{SUPPOSVERS}=[ "5.8", "5.9" ];
$PKGI{VRTSvxfen}{REQOSPATCHES}{"5.9"}=[ "113277-08" ];

$PKGI{VRTSgab}{DRIVERS}=[ "gab" ];
$PKGI{VRTSgab}{DEPS}=[ "VRTSllt" ];

$PKGI{VRTSllt}{DRIVERS}=[ "llt" ];

$PKGI{VRTSvcs}{PROCS}=[ qw(bin/had hashadow CmdServer notifier) ];
$PKGI{VRTSvcs}{DEPS}=[ qw(VRTSgab VRTSllt) ];

$PKGI{VRTSllt}{SPACE}=[500,500,50,1000];
$PKGI{VRTSgab}{SPACE}=[100,500,50,1500];
$PKGI{VRTSvxfen}{SPACE}=[100,100,50,2500];
$PKGI{VRTSvcs}{SPACE}=[52000,23000,50,250];
$PKGI{VRTSvcsmg}{SPACE}=[200,0,20,0];
$PKGI{VRTSvcsag}{SPACE}=[12500,0,50,0];
$PKGI{VRTSvcsmn}{SPACE}=[100,0,20,0];
$PKGI{VRTScspro}{SPACE}=[7000,0,20,0];
$PKGI{VRTSvcsdc}{SPACE}=[9000,0,20,0];
$PKGI{VRTSjre}{SPACE}=[70000,0,200,0];
$PKGI{VRTScutil}{SPACE}=[3000,0,50,0];
$PKGI{VRTScscw}{SPACE}=[1300,0,20,0];
$PKGI{VRTSweb}{SPACE}=[10000,0,50,0];
$PKGI{VRTSvcsw}{SPACE}=[3000,0,20,0];
$PKGI{VRTScscm}{SPACE}=[7000,0,50,0];

$PKGI{VRTSweb}{RESPONSEFILE}=" ";
$PKGI{VRTSjre}{RESPONSEFILE}=" ";
$PKGI{VRTScssim}{RESPONSEFILE}="BASEDIR=/opt";

$PKGI{VRTSvcs}{JA}=[ qw(VRTSjacs VRTSjacsd) ];
$PKGI{VRTSvcsw}{JA}=[ qw(VRTSjacsw) ];
$PKGI{VRTSweb}{JA}=[ qw(VRTSjaweb) ];
$PKGI{VRTScutil}{JA}=[ qw(VRTSjacsu) ];
$PKGI{VRTScspro}{JA}=[ qw(VRTSjacsp) ];
$PKGI{VRTScscm}{JA}=[ qw(VRTSjacsj) ];

$PKGI{VRTSjacs}{SPACE}=[1000,0,40,0];
$PKGI{VRTSjacsd}{SPACE}=[9000,0,20,0];
$PKGI{VRTSjacsj}{SPACE}=[2700,0,20,0];
$PKGI{VRTSjacsu}{SPACE}=[100,20,0];
$PKGI{VRTSjacsw}{SPACE}=[1600,0,20,0];
$PKGI{VRTSjacso}{SPACE}=[10,0,20,0];

# VCS Agents
$PKGI{VRTSvcsdb}{JA}= [ qw(VRTSjacsb) ];
$PKGI{VRTSvcsor}{JA}= [ qw(VRTSjacso) ];
$PKGI{VRTSvcsso}{JA}= [ qw(VRTSjacsi) ];

sub _vcs_sun_delete_20VRTSwebres {
	return if ($COMM{UGVERS}{$SYS} ne "2.0");
	_pb1("Deleting 2.0 VRTSweb resource", 121, 1000);
	my $do=_dor("$PATH{VCSBIN}/hares -list Group=ClusterService Type=Process | $CMD{AWK} '{print \$1}' | $CMD{UNIQ}");
	if ($do) {
		_dor("$PATH{VCSBIN}/hares -delete $do");
		_pb2("Done", 121, 1001);
	} else {
		_pb2("No VRTSweb resource found", 121, 1002);
	}
}

sub _vcs_sun_delete_pre20maincfentities {
	my(@cssg,@ocf,@usca,$cf,$j,$l,$lsys,$ncf,$nop,$s,$sec);
	($lsys)=(@_);
	return if ((!$lsys) && ($COMM{UGVERS}{$SYSI[0]}!=1.3));
	@cssg=("cluster","system","snmp","group");
	@usca=("MaxFactor","Factor","LoadSampling","LinkMonitoring","NotifyList");
	push(@SYSI,_dor("$CMD{UNAME} -n")) if ($lsys);
	$SYS=$SYSI[0];
	@ocf=split(/\n/,_dor("$CMD{CAT} $CONF{MAINCF}"));
	foreach $cf(@ocf) {
		$l=$cf;
		$l=~s/^\s+//;
		($s,$j)=split(/\s+/,$l);
		$sec=$s if (_list($s,@cssg)>=0);
		$nop=1 if (($sec eq "cluster") && (_list($s,@usca)>=0));
		$ncf.="$cf\n" if ((!$nop) && ($sec ne "snmp"));
		$nop=0 if ($l=~/}/);
	}
	_writef($ncf,"$PATH{ITD}/main.cf",1);
	foreach $SYS(@SYSI) {
		_copy("$PATH{ITD}/main.cf",$CONF{MAINCF});
	}
}

# Convert AppName = "vcsqs" to AppName = "vcs" if it exists in main.cf
sub _vcs_sun_qstovcs_cfupdate {
	my($cf,$qs);
	$SYS=$SYSI[0];
	return unless _fc($CONF{MAINCF});
	$qs=_dor("$CMD{GREP} 'AppName = .vcsqs' $CONF{MAINCF}");
	return if ($qs!~/vcsqs/);
	_copy($CONF{MAINCF}, $PATH{ITD}, 1);
	$cf=_readf("$PATH{ITD}/main.cf");
	$cf=~s/AppName = "vcsqs"/AppName = "vcs"/;
	_writef($cf,"$PATH{ITD}/main.cf",1);
	foreach $SYS(@SYSI) {
		_copy("$PATH{ITD}/main.cf", $CONF{MAINCF});
	}
}

sub _vcs_sun_update_20csgto35 {
	return if ($COMM{UGVERS}{$SYS}>2.0);
	my($an,$dev,$do,$ipr);
	_pb1("Adding VCS $COMM{TRAINVERS} VRTSWebApp resource", 121, 1003, "$COMM{TRAINVERS}");
	$ipr=_dor("$PATH{VCSBIN}/hares -list Group=ClusterService Type=IP | $CMD{AWK} '{print \$1}' | $CMD{UNIQ}");
	if ($ipr) {
		_dor("$PATH{VCSBIN}/hares -add VCSweb VRTSWebApp ClusterService");
		_dor("$PATH{VCSBIN}/hares -modify VCSweb Critical 0");
		$an=($PMODE eq "VCSQS") ? "vcsqs" : "vcs";
		_dor("$PATH{VCSBIN}/hares -modify VCSweb AppName $an");
		_dor("$PATH{VCSBIN}/hares -modify VCSweb InstallDir /opt/VRTSweb/VERITAS");
		_dor("$PATH{VCSBIN}/hares -modify VCSweb TimeForOnline 5");
		_dor("$PATH{VCSBIN}/hares -modify VCSweb Enabled 1");
		_dor("$PATH{VCSBIN}/hares -link VCSweb $ipr");
		$do=_dor("$PATH{VCSBIN}/hares -list Group=ClusterService Type=NIC | $CMD{AWK} '{print \$1}' | $CMD{UNIQ}");
		if (!$do) {
			$dev=_dor("$PATH{VCSBIN}/hares -value $ipr Device");
			_dor("$PATH{VCSBIN}/hares -add csgnic NIC ClusterService");
			_dor("$PATH{VCSBIN}/hares -modify csgnic Device $dev");
			_dor("$PATH{VCSBIN}/hares -modify csgnic Enabled 1");
			_dor("$PATH{VCSBIN}/hares -link $ipr csgnic");
		}
		_pb2("Done", 121, 1001);
	} else {
		_pb2("No webip resource found", 121, 1004);
	}
}

sub _vcs_sun_update_typescf {
	_pb1("Updating VCS $COMM{TRAINVERS} Resource types", 121, 1005, "$COMM{TRAINVERS}");
	if ($COMM{UGVERS}{$SYS}==1.3) {
		_dor("$PATH{VCSBIN}/hatype -modify Disk OfflineMonitorInterval 60");
		_dor("$PATH{VCSBIN}/hatype -modify ElifNone OfflineMonitorInterval 60");
		_dor("$PATH{VCSBIN}/hatype -modify FileNone OfflineMonitorInterval 60");
		_dor("$PATH{VCSBIN}/hatype -modify MultiNICA OfflineMonitorInterval 60");
		_dor("$PATH{VCSBIN}/hatype -modify NIC OfflineMonitorInterval 60");
		_dor("$PATH{VCSBIN}/hatype -modify Proxy OfflineMonitorInterval 60");
		_dor("$PATH{VCSBIN}/haattr -default IP IfconfigTwice 0");
		_dor("$PATH{VCSBIN}/haattr -default IPMultiNIC IfconfigTwice 0");
		_dor("$PATH{VCSBIN}/haattr -default Mount SnapUmount 0");
		_dor("$PATH{VCSBIN}/hatype -modify ServiceGroupHB OnlineRetryLimit 5");
		_dor("$PATH{VCSBIN}/haattr -default ServiceGroupHB AllOrNone 1");
		_dor("$PATH{VCSBIN}/hatype -add NotifierMngr");
		_dor("$PATH{VCSBIN}/hatype -modify NotifierMngr SourceFile \"./types.cf\"");
		_dor("$PATH{VCSBIN}/hatype -modify NotifierMngr RestartLimit 3");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr MessagesQueue -integer 30");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr NotifierListeningPort -integer 14144");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr SnmpdTrapPort -integer 162");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr SnmpCommunity -string public");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr SnmpConsoles -string -assoc");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr SmtpServer -string");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr SmtpRecipients -string -assoc");
		_dor("$PATH{VCSBIN}/hatype -modify NotifierMngr MonitorInterval 60");
		_dor("$PATH{VCSBIN}/hatype -modify NotifierMngr NumThreads 10");
		_dor("$PATH{VCSBIN}/hatype -modify NotifierMngr OnlineRetryLimit 0");
		_dor("$PATH{VCSBIN}/haattr -default NotifierMngr AutoStart 1");
		_dor("$PATH{VCSBIN}/haattr -default NotifierMngr Critical 1");
		my $ori=_dor("$PATH{VCSBIN}/hatype -list | $CMD{GREP} Oracle");
		if ($ori) {
			_dor("$PATH{VCSBIN}/haattr -add Oracle AutoEndBkup -integer 0");
			_dor("$PATH{VCSBIN}/haattr -add Oracle EnvFile -string");
			_dor("$PATH{VCSBIN}/haattr -add Sqlnet EnvFile -string");
		}
	}
	if ($COMM{UGVERS}{$SYS}<=2) {
		_dor("$PATH{VCSBIN}/haattr -add MultiNICA RetestInterval -integer 5");
		_dor("$PATH{VCSBIN}/haattr -default MultiNICA HandshakeInterval 20");
		_dor("$PATH{VCSBIN}/hatype -modify MultiNICA ArgList Device NetMask ArpDelay RetestInterval Options RouteOptions PingOptimize MonitorOnly IfconfigTwice HandshakeInterval NetworkHosts");
		_dor("$PATH{VCSBIN}/hatype -add IPMultiNICB");
		_dor("$PATH{VCSBIN}/hatype -modify IPMultiNICB SourceFile \"./types.cf\"");
		_dor("$PATH{VCSBIN}/hatype -modify IPMultiNICB ArgList BaseResName Address NetMask DeviceChoice");
		_dor("$PATH{VCSBIN}/haattr -add IPMultiNICB BaseResName -string");
		_dor("$PATH{VCSBIN}/haattr -add IPMultiNICB Address -string");
		_dor("$PATH{VCSBIN}/haattr -add IPMultiNICB NetMask -string");
		_dor("$PATH{VCSBIN}/haattr -add IPMultiNICB DeviceChoice -string 0");
		_dor("$PATH{VCSBIN}/hatype -modify IPMultiNICB NumThreads 10");
		_dor("$PATH{VCSBIN}/hatype -modify IPMultiNICB Operations OnOff");
		_dor("$PATH{VCSBIN}/haattr -default IPMultiNICB ResourceOwner unknown");
		_dor("$PATH{VCSBIN}/hatype -add MultiNICB");
		_dor("$PATH{VCSBIN}/hatype -modify MultiNICB SourceFile \"./types.cf\"");
		_dor("$PATH{VCSBIN}/hatype -modify MultiNICB MonitorInterval 10");
		_dor("$PATH{VCSBIN}/hatype -modify MultiNICB OfflineMonitorInterval 60");
		_dor("$PATH{VCSBIN}/hatype -modify MultiNICB ArgList UseMpathd MpathdCommand ConfigCheck MpathdRestart Device NetworkHosts LinkTestRatio IgnoreLinkStatus NetworkTimeout OnlineTestRepeatCount OfflineTestRepeatCount NoBroadcast DefaultRouter Failback");
		_dor("$PATH{VCSBIN}/hatype -modify MultiNICB Operations None");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB UseMpathd -integer");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB MpathdCommand -string \"/sbin/in.mpathd\"");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB ConfigCheck -integer 1");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB MpathdRestart -integer 1");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB Device -string -assoc");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB NetworkHosts -string -vector");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB LinkTestRatio -integer 1");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB IgnoreLinkStatus -integer 1");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB NetworkTimeout -integer 100");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB OnlineTestRepeatCount -integer 3");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB OfflineTestRepeatCount -integer 3");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB NoBroadcast -integer");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB DefaultRouter -string \"0.0.0.0\"");
		_dor("$PATH{VCSBIN}/haattr -add MultiNICB Failback -integer");
		_dor("$PATH{VCSBIN}/hatype -modify MultiNICB NumThreads 10");
		_dor("$PATH{VCSBIN}/hatype -modify MultiNICB OnlineRetryLimit 0");
		_dor("$PATH{VCSBIN}/haattr -default MultiNICB ResourceOwner unknown");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr EngineListeningPort -integer 14141");
		_dor("$PATH{VCSBIN}/haattr -delete NotifierMngr PathName");
		_dor("$PATH{VCSBIN}/hatype -modify NotifierMngr ArgList EngineListeningPort MessagesQueue NotifierListeningPort SnmpdTrapPort SnmpCommunity SnmpConsoles SmtpServer SmtpRecipients");
		_dor("$PATH{VCSBIN}/hatype -add VRTSWebApp");
		_dor("$PATH{VCSBIN}/hatype -modify VRTSWebApp SourceFile \"./types.cf\"");
		_dor("$PATH{VCSBIN}/hatype -modify VRTSWebApp ArgList AppName InstallDir TimeForOnline");
		_dor("$PATH{VCSBIN}/haattr -add VRTSWebApp AppName -string");
		_dor("$PATH{VCSBIN}/haattr -add VRTSWebApp InstallDir -string");
		_dor("$PATH{VCSBIN}/haattr -add VRTSWebApp TimeForOnline -integer");
		_dor("$PATH{VCSBIN}/hatype -modify VRTSWebApp NumThreads 1");
		_dor("$PATH{VCSBIN}/hatype -modify VRTSWebApp Operations OnOff");
		_dor("$PATH{VCSBIN}/haattr -default VRTSWebApp ResourceOwner unknown");
		#if (($VCSORU eq "Y") || ($QSVERS eq $ORACLE)) {
			#_dor("$PATH{VCSBIN}/haattr -add Oracle Encoding -string");
			#_dor("$PATH{VCSBIN}/hatype -modify Oracle ArgList Sid Owner Home Pfile User Pword Table MonScript AutoEndBkup EnvFile Encoding");
			#_dor("$PATH{VCSBIN}/haattr -add Sqlnet Encoding -string");
			#_dor("$PATH{VCSBIN}/hatype -modify Sqlnet ArgList Owner Home TnsAdmin Listener MonScript EnvFile Encoding");
		#}
	}
	if ($COMM{UGVERS}{$SYS}<=3.5) {
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr SmtpServerVrfyOff -boolean 0");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr SmtpServerTimeout -integer 10");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr SmtpReturnPath -string");
		_dor("$PATH{VCSBIN}/haattr -add NotifierMngr SmtpFromPath -string");
		_dor("$PATH{VCSBIN}/hatype -modify NotifierMngr ArgList EngineListeningPort MessagesQueue NotifierListeningPort SnmpdTrapPort SnmpCommunity SnmpConsoles SmtpServer SmtpServerVrfyOff SmtpServerTimeout SmtpReturnPath SmtpFromPath SmtpRecipients");
		_dor("$PATH{VCSBIN}/hatype -add DNS");
		_dor("$PATH{VCSBIN}/hatype -modify DNS SourceFile \"./types.cf\"");
		_dor("$PATH{VCSBIN}/hatype -modify DNS Domain Alias Hostname TTLStealthMasters");
		_dor("$PATH{VCSBIN}/haattr -add DNS Domain -string");
		_dor("$PATH{VCSBIN}/haattr -add DNS Alias -string");
		_dor("$PATH{VCSBIN}/haattr -add DNS Hostname -string");
		_dor("$PATH{VCSBIN}/haattr -add DNS TTL -integer 86400");
		_dor("$PATH{VCSBIN}/haattr -add DNS StealthMasters -string -vector");
		_dor("$PATH{VCSBIN}/hatype -modify DNS ArgList Domain Alias Hostname TTL StealthMasters");
		_dor("$PATH{VCSBIN}/hatype -modify DiskGroup ArgList DiskGroup StartVolumes StopVolumes MonitorOnly MonitorReservation tempUseFence");
		_dor("$PATH{VCSBIN}/haattr -add DiskGroup MonitorReservation -boolean 0");
		_dor("$PATH{VCSBIN}/haattr -add -temp DiskGroup tempUseFence -string INVALID");

	}
	_pb2("Done", 121, 1001);
}
#
# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#

# Define frequently used commands
$CMD{A5KCHK}="/usr/lib/vxvm/bin/vxa5kchk";
$CMD{NOHUP}="/usr/bin/nohup";
$CMD{VXDCTL}="/opt/VRTS/bin/vxdctl";
$CMD{VXDDLADM}="/usr/sbin/vxddladm";
$CMD{VXDG}="/opt/VRTS/bin/vxdg";
$CMD{VXPRINT}="/opt/VRTS/bin/vxprint";
$CMD{VXSCRIPTLOG}="/opt/VRTS/bin/vxscriptlog";
$CMD{VXCACHED}="/usr/lib/vxvm/bin/vxcached";

# This is usually created by the request script.  It is used by
# postinstall to decide whether or not to restore configuration files.
$PATH{VXVMCFGSTALE}="/tmp/vxvmcfg.stale";
$PATH{UPGRADE_FILE}="/VXVM4.0-UPGRADE/.start_runed";


# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms

# Define product specific information
$PROD{VM}{MAINPKG}="VRTSvxvm";
$PROD{VM}{UGVERS}=["3.1.1", "3.2","3.5"];
$PROD{VM}{APPATCHES}=["110722"];
$PROD{VM}{DONOTRMONUG}=["VRTSvxvm"];
$PKGI{VRTSvxvm}{DONOTRMONUG}=1;

# Define packages to be installed, per product mode
$PROD{VM}{PKGS}=["VRTSvxvm","VRTSvmman", "VRTSvmdoc", "VRTSvmpro", "VRTSfspro", "VRTSalloc", "VRTSddlpr"];

# Define package information
$PKGI{VRTSvmdoc}{SPACE}=[24000,0,20,0];

$PKGI{VRTSvmman}{SPACE}=[1100,0,20,0];

$PKGI{VRTSvxvm}{SPACE}=[19000,72000,100,49000];

$PKGI{VRTSvmpro}{SPACE}=[7100,500,30,30];

$PKGI{VRTSfspro}{SPACE}=[3500,0,30,10];

#$PKGI{VRTSvxvm}{OSPATCHES}{"5.7"}=["107473-07", "106541-19", "106327-05"];
#$PKGI{VRTSvxvm}{OSPATCHES}{"5.8"}=["111413-06", "108993-18", "108528-18"];
#$PKGI{VRTSvxvm}{OSPATCHES}{"5.9"}=[];

$PKGI{VRTSvxvm}{REQOSPATCHES}{"5.7"}=["107473-07", "106541-19", "106327-05"];
$PKGI{VRTSvxvm}{REQOSPATCHES}{"5.8"}=["111413-06", "108993-18", "108528-18"];
#The patches for FJSV 2.8 are set in _vm_sun_initial_systemcheck().

$PKGI{VRTSalloc}{SPACE}=[30000,10,20,40];

$PKGI{VRTSddlpr}{SPACE}=[7000,0,20,20];

$PKGI{VRTSvxvm}{JA}=[ qw(VRTSjavmc VRTSjavmd VRTSjavmm) ];
$PKGI{VRTSvxvm}{FR}=[ qw(VRTSfrvmc VRTSfrvmd VRTSfrvmm) ];
$PKGI{VRTSvxvm}{ZH}=[ qw(VRTSzhvmc VRTSzhvmd VRTSzhvmm) ];
$PKGI{VRTSalloc}{MU}=[ qw(VRTSmualc) ];
$PKGI{VRTSddlpr}{MU}=[ qw(VRTSmuddl) ];
$PKGI{VRTSvmpro}{MU}=[ qw(VRTSmuvmp) ];

$PKGI{VRTSmualc}{SPACE}=[1250,0,30,20];
$PKGI{VRTSmuddl}{SPACE}=[100,0,20,10];
$PKGI{VRTSmuvmp}{SPACE}=[4000,0,20,20];
$PKGI{VRTSjavmc}{SPACE}=[0,750,20,0];
$PKGI{VRTSjavmd}{SPACE}=[21000,0,20,0];
$PKGI{VRTSjavmm}{SPACE}=[650,0,40,0];

$PKGI{VRTSjavmc}{PREVNAME} = "VRTSvmjac";
$PKGI{VRTSjavmd}{PREVNAME} = "VRTSvmjad";
$PKGI{VRTSjavmm}{PREVNAME} = "VRTSvmjam";

$PKGI{VRTSvxvm}{VRTSPATCHES}{ALL}=[ "115217" ];

# No product/platform specific subroutines are required

# Use them only if necessary

#
# Function: _vm_sun_ask_defaultdg()
# Purpose:
#	Asks if a default disk group name should be configured. If
#	so, it prompts for the name for a single or multiple systems.
# Input Parameters:
#	None
#	References $CFG{VM_RESTORE_CFG}{$SYS}.
#	References $PROD{VM}{VOLD_STATUS}{$SYS}.
#	References $PROD{VM}{REBOOT}{$SYS}  -- Not used for now.
# Output Parameters:
#	$CFG{DEFAULTDG}{$SYS} = dgname or ""
# Called by:
#	_vm_ask_defaultdg()
sub _vm_sun_ask_defaultdg 
{
	my ($ayn1, $ayn2, $msg, $dgname);
	my ($defdgsys);
	my ($rc);

	$defdgsys=[];
	$rc=0;


	_pl("\nMany $PROD{VM}{NAME} commands affect the contents or configuration of a disk group. Such commands require that the user specify a disk group.  This is accomplished by using the -g option of a command or setting the VXVM_DEFAULTDG environment variable.  An alternative to these two methods is to configure the default disk group of a system.", 111, 1133, "$PROD{VM}{NAME}");

	_pl("\nEvaluating which systems can now have their default disk group configured...\n", 111, 1027);

	# Need to create a list of systems whose systems did not 
	# restore the previous VM configuration.
	foreach $SYS (@SYSI)
	{
		# Initialize so it will appear in the RESPONSEFILE
		$CFG{DEFAULTDG}{$SYS}="" if 
			(! defined($CFG{DEFAULTDG}{$SYS}));

 		if ($FLAG{PKGUPGRADE}{VRTSvxvm}{$SYS})
 		{
 			_pl("$PROD{VM}{ABBR} on system $SYS is being upgraded -- cannot reconfigure the default disk group.", 111, 1104, "$PROD{VM}{ABBR}", "$SYS");
			next;
 		}

		if ($PROD{VM}{NO_CONFIG}{$SYS})
		{
			_pl("System $SYS: won't set the default disk group because $PROD{VM}{ABBR} is already configured.", 111, 1074, "$SYS", "$PROD{VM}{ABBR}");
			next;
		}

		if ($PROD{VM}{INSTALL}{$SYS} =~ /error/)
		{
			_pl("System $SYS: won't reset the default disk group because you previously decided not to reconfigure.", 111, 1028, "$SYS");
			next;
		}

		if ($CFG{VM_RESTORE_CFG}{$SYS})
		{
			_pl("System $SYS is restoring configuration -- cannot reconfigure the default disk group.", 111, 1105, "$SYS");
			next;
		}
		elsif ($PROD{VM}{VOLD_STATUS}{$SYS} ne "enabled")
		{
			_pl("vxconfigd on system $SYS is not available -- cannot set the default disk group.", 111, 1106, "$SYS");
			next;
		}
		else
		{
			_pl("System $SYS is eligible -- can set the default disk group.", 111, 1107, "$SYS");
			push(@$defdgsys, $SYS); 
		}
	}

	if ($#$defdgsys < 0)
	{
		_bpl("\nNone of the target systems can be configured because 1) its previous configuration was restored, 2) the vxconfigd daemon is not running properly, or 3) $PROD{VM}{ABBR} is already configured.\n\nUse the vxdctl(1M) command to configure the default disk group after the installation is completed.", 111, 1119, "$PROD{VM}{ABBR}");
		_prtc();
		return;
	}

	$MSG{HELP}=_tr("You may specify a disk group name to be used as the default disk group. The disk group does not need to exist yet. If it doesn't yet exist, you will need to create it after the installation is completed.", 111, 1025);
	$MSG{HELP} .= _tr("\n\nNote that you may configure the default disk group for systems where you did not restore a previous $PROD{VM}{ABBR} configuration. If a system is already configured for $PROD{VM}{ABBR}, you cannot use $COMM{PROG} to reconfigure the default disk group.", 111, 1108, "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}", "$COMM{PROG}");
	$MSG{HELP} .= _tr("\n\nFor a system whose default disk group cannot be configured now, you may use the vxdctl(1M) command to set it after the installation is completed.", 111, 1109);
	$MSG{HELP} .= _tr("\n\nAfter specifying the disk group name(s), they will be displayed for your confirmation.", 111, 1110);

	$ayn1 = _ayny("\nDo you want to set up the default disk group for each system?", 111, 1026);

	return 0 if ($ayn1 eq "N");

	# Collect the disk group name(s)

	until ($rc)
	{
		$rc = _vm_request_all_dgnames($defdgsys);
	}

	_pl("\n", 111, 1033);


	# Configure the default disk groups.
	foreach $SYS (@$defdgsys)
	{
		next if (!$CFG{DEFAULTDG}{$SYS});
		_pb1("Setting default diskgroup to $CFG{DEFAULTDG}{$SYS} on $SYS", 111, 1034, "$CFG{DEFAULTDG}{$SYS}", "$SYS");
		_dor("$CMD{VXDCTL} defaultdg $CFG{DEFAULTDG}{$SYS} 2> /dev/null ");
		_pb2("Done", 111, 1012);
		
	}

} # _vm_sun_ask_defaultdg()

#
# Function: _vm_sun_ask_encl_names()
# Purpose:
#	Asks if enclosure-based naming scheme should be used.  If so,
#	asks if it should be specified for all system(s) or individually.
# Input Parameters:
#	It uses the following global:
#	$PROD{VM}{VOLD_STATUS}{$SYS}
#	$PROD{VM}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#	$CFG{NEWNAMES_FILE}{$SYS} = 1, if this scheme is used
# Called by:
#	_vm_ask_encl_names()
sub _vm_sun_ask_encl_names 
{
	my ($ayn1, $ayn2, $msg);
	my ($enclsys, $rc);
	$enclsys=[];
	$rc = 0;

	_pl("\nThe enclosure-based naming scheme is a feature of $PROD{VM}{NAME}. It allows one to reference disks using a symbolic name that is more meaningful than the operating system's normal device access name.  This symbolic name is typically derived from the array name.", 111, 1035, "$PROD{VM}{NAME}");

	_pl("\nEvaluating which systems can be configured for the enclosure-based naming scheme...\n", 111, 1038);

	foreach $SYS (@SYSI)
	{
		# Initialize so it will appear in the RESPONSEFILE
		$CFG{NEWNAMES_FILE}{$SYS}=0 if 
			(! defined($CFG{NEWNAMES_FILE}{$SYS}));

 		if ($FLAG{PKGUPGRADE}{VRTSvxvm}{$SYS})
 		{
 			_pl("$PROD{VM}{ABBR} on system $SYS is being upgraded -- cannot reconfigure.", 111, 1111, "$PROD{VM}{ABBR}", "$SYS");
			next;
 		}

		if ($PROD{VM}{NO_CONFIG}{$SYS})
		{
			_pl("System $SYS: won't reconfigure the enclosure-based naming scheme setting because $PROD{VM}{ABBR} is already configured.", 111, 1077, "$SYS", "$PROD{VM}{ABBR}");
			next;
		}

		if ($PROD{VM}{INSTALL}{$SYS} =~ /error/ )
		{
			_pl("System $SYS: won't reconfigure the enclosure-based naming scheme setting because you previously decided not to reconfigure.", 111, 1039, "$SYS");
			next;
		}

		if ($CFG{VM_RESTORE_CFG}{$SYS})
		{
			_pl("System $SYS is restoring configuration -- cannot reconfigure.", 111, 1040, "$SYS");
			next;
		}

		_pl("System $SYS is eligible -- can configure.", 111, 1041, "$SYS");
		push(@$enclsys, $SYS);
	}

	if ($#$enclsys < 0)
	{
		_bpl("\nNone of the target systems can be reconfigured to use the enclosure-based naming scheme now.  After the installation is complete, you may use the vxdiskadm(1M) command to reconfigure this naming scheme.\n", 111, 1120);
		_prtc();
		return;
	}

	$MSG{HELP}=_tr("Enclosure-based names are typically derived from an enclosure, or array, name.  Note: It is not required that an enclosure be connected to the system to set up this naming scheme.", 111, 1112);
	$MSG{HELP} .= _tr("\n\nYou cannot configure this naming scheme for a system which has a previous $PROD{VM}{ABBR} configuration that will be restored or if $PROD{VM}{ABBR} is already configured on the system.\n\nAfter the installation is complete, you may use the vxdiskadm(1M) command to later configure this naming scheme on the system.", 111, 1113, "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}");
	$ayn1 = _aynn("\nDo you want to set up the enclosure-based naming scheme?", 111, 1037);
	return 0 if ($ayn1 eq "N");

	# First, handle the case of one eligible system
	if ($#$enclsys == 0)
	{
		$MSG{HELP}=_tr("If you respond yes, then the enclosure-based naming scheme will be applied to the eligible system. Otherwise, it won't.", 111, 1043);
		$ayn2 = _ayny("\nDo you wish to use the enclosure-based naming scheme for system $$enclsys[0]?", 111, 1044, "$$enclsys[0]");
		$CFG{NEWNAMES_FILE}{$$enclsys[0]} = 1 if ($ayn2 eq "Y");
	}
	elsif ($#$enclsys > 0)
	{
		$MSG{HELP}=_tr("If you respond yes, then the enclosure-based naming scheme will be applied to all eligible systems.  Otherwise, you will be prompted to configure each of the eligible systems.", 111, 1045);
		$ayn2 = _ayny("\nDo you wish to use the enclosure-based naming scheme for all of the eligible systems?", 111, 1046);

		if ($ayn2 eq "Y")
		{
			foreach $SYS (@$enclsys)
			{
				$CFG{NEWNAMES_FILE}{$SYS} = 1;
			}
		}

		else
		{
			_pl("\nAs you have indicated that the enclosure-based naming scheme will not apply to all systems, you will be asked to configure each system.", 111, 1047);

			until ($rc)
			{
				$rc = _vm_ask_encl_names_per_host($enclsys);
			}

		}
	}
} # _vm_sun_ask_encl_names()

# display task completion information
sub _vm_sun_completion_messages {

my ($sys, $upgrade, $x);

	if ($OPT{UNINSTALL}) {

		for $sys(@SYSI) {
			$x++ if (_list("VRTSvxvm",@{$COMM{UPKGS}{$sys}}>=0));
		}

		return unless ($x);

		_warn("\nAs part of the uninstallation process on Solaris, the current configuration of $PROD{VM}{ABBR} was saved in the directory /VXVM-CFG-BAK.  This configuration may be used in a future installation of $PROD{VM}{ABBR}.  If you do not plan to reuse it, you may manually remove this subdirectory.", 111, 1048, "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}");
		return;
	}

	foreach $sys (@SYSI)
	{
		if ($FLAG{PKGUPGRADE}{VRTSvxvm}{$sys})
		{
			$upgrade=1;
			last;
		}
	}

	if ($upgrade) {
		_warn("You have completed upgrading $PROD{VM}{ABBR} on some or all of the systems. Reboot your systems at this time. During the reboot your default disk group will be set to rootdg for you. After a system has come up, you may configure the default disk group using the command, vxdctl defaultdg.  Review the manual page for vxdctl(1M) for further details.\n", 111, 1114, "$PROD{VM}{ABBR}");
	}

	if (!$OPT{UNINSTALL}) {
		_log("This version of $PROD{VM}{ABBR} requires DMP to be enabled. If you wish to exclude certain or all devices from being multipathed by DMP, you can use the vxdiskadm utility to do so after the installation is complete.  Refer to documentation on vxdiskadm(1M) for more details.", 111, 1080, "$PROD{VM}{ABBR}");
	}

} # _vm_sun_completion_messages()


#
# Function: _vm_sun_ap_installed()
# Purpose:
#	This implements a VRTSvxvm request script task.
#	It validates that the relevant AP driver and patch levels are installed,
#	if applicable.  
# Input Parameters:
#	None
#	References $PROD{VM}{AP_PATCH_STAT}{$SYS}
# Output Parameters:
#	0	if AP is not installed or correct AP patch level is detected
#	1	if AP is installed and incorrect AP patch level is detected
#
#	In some cases, this will call _die().
# Called by:
# 	_vm_sun_prestop()
sub _vm_sun_ap_installed
{
	my ($ap_installed, $patch, $opkg, $v);

	$opkg=$PKG;
	$PKG="SUNWapdv";
	$v = _sun_get_instpkgvers();
	$PKG=$opkg;
	return 0 if (! $v);


	if ( $v eq "2.3.1" )
	{
		_vm_sun_ap_patch_check();
		if ($PROD{VM}{AP_PATCH_STAT}{$SYS} == 0)
		{

			if (! $OPT{PRECHECK})
			{
				_pl("Alternate Pathing (AP) version 2.3.1 has been detected.\n\nThis version of $PROD{VM}{ABBR} requires the following patch(es) to co-exist with AP 2.3.1:", 111, 1000, "$PROD{VM}{ABBR}");
				foreach $patch (@{$PROD{VM}{APPATCHES}})
				{
					_pl("\t$patch\n", 111, 1001, "$patch");
				}
				_die("Install the above patch(es) before you can continue the $PROD{VM}{ABBR} installation.  This installation will now be aborted.\n", 111, 1002, "$PROD{VM}{ABBR}");
			}
			else
			{
				return 1;
			}
		}
	}
	else
	{
		if (! $OPT{PRECHECK})
		{
			_pl("Alternate Pathing (AP) version $v has been detected.\n\nThis version of $PROD{VM}{ABBR} co-exists only with AP 2.3.1 along with the following patches:", 111, 1003, "$v", "$PROD{VM}{ABBR}");
			foreach $patch (@{$PROD{VM}{APPATCHES}})
			{
				_pl("\t$patch\n", 111, 1001, "$patch");
			}
			_die("Upgrade your AP package and install the above patch(es) before you continue the VxVM installation.  This installation will now be aborted.\n", 111, 1081);
		}
		else
		{
			return 1;
		}
	}

	return 0;
} # _vm_sun_ap_installed()


#
# Function: _vm_sun_ap_patch_check()
# Purpose:
#	Validates the required AP patches are installed.
# Input Parameters:
#	None
# Output Parameters:
#	None
#	$PROD{VM}{AP_PATCH_STAT}{$SYS}: 
#		1	correct patch level found	
# Called by:
#	_vm_sun_ap_installed()	
sub _vm_sun_ap_patch_check
{
	my ($out, $patch);

	$out=_dor("$CMD{SHOWREV} -p");
	foreach $patch (@{$PROD{VM}{APPATCHES}})
	{
		if ($out =~ /$patch/)
		{
			$PROD{VM}{AP_PATCH_STAT}{$SYS}=1;
			return;
		}
	}
	$PROD{VM}{AP_PATCH_STAT}{$SYS}=0;
} # _vm_sun_ap_patch_check()


#
# Function: _vm_sun_check_root_encap()
# Purpose:
#	Determines if the boot disk is encapsulated.
# Input Parameters:
#	None
# Output Parameters:
#	Returns:
#	0	if not encapsulated
#	1	if encapsulated
#
#	$PROD{VM}{ENCAP}{$SYS}	
#		0	if not encapsulated
#		1	if encapsulated
# Called by:
#	_vm_sun_request()
sub _vm_sun_check_root_encap
{
	my ($out);

	$PROD{VM}{ENCAP}{$SYS}=0;

	$out=_dor("$CMD{GREP} 'vxio:vol_root_dev_is_volume=1' /etc/system > /dev/null");

	return 0 if (! $out);

	if (not $out =~ /^\*/)
	{
		$PROD{VM}{ENCAP}{$SYS}=1;
		return 1;
	}
} # _vm_sun_check_root_encap()


#
# Function: _vm_sun_initial_systemcheck()
# Purpose:
# 	Dynamically creates the required OS patch list.
# 
# Input Parameters:
#	None
# Output Parameters:
#	Modifies @{$COMM{REQOSPATCHES}{$SYS}}
# Called by:
#	_comm_check_communication()
sub _vm_sun_initial_systemcheck 
{
my($v, $p, $sys);

	$v = $COMM{OSVERS}{$SYS};
	$sys = _dor("$CMD{UNAME} -i");
	chomp($sys);
	$sys =~ s/,.*$//;

	if ($sys eq "FJSV" && $v eq "5.8")
	{
		$PKGI{VRTSvxvm}{REQOSPATCHES}{"5.8"}=["108993-18", "108528-18"];
	}

	return;

} # _vm_sun_initial_systemcheck()

# perform any checks or tasks necessary after the product is installed

# Function: _vm_sun_postinstall()
# Purpose:
#	Performs some tasks normally done by vxinstall.
#	Basically, it does VM license processing and it
#	performs what _vm_sun_postinstall_questions() does, but for the
#	-responsefile case...  Instead of asking for user responses,
#	it just defaults to an error status.
# Input Parameters:
#	None
#	References $CFG{VM_RESTORE_CFG}{$SYS}
#	References $PROD{VM}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#	None
#	May modify $PROD{VM}{INSTALL}{$SYS} indirectly.
# Called by:
#	_vm_postinstall()
sub _vm_sun_postinstall{

	foreach $SYS (@SYSI)
	{
		_dor("$CMD{VXSCRIPTLOG} $COMM{PROG}")
			if (_fc($PATH{MKDBFILE}));
	}

	if ($UPI eq "VM")
	{
		_comm_licensing();
	}

	return if (! $OPT{RESPONSEFILE});

	foreach $SYS (@SYSI)
	{
		next if ($CFG{VM_RESTORE_CFG}{$SYS});

		# install-db will not be there for an upgrade
 		next if ($FLAG{PKGUPGRADE}{VRTSvxvm}{$SYS});

		if (! _fc("$PATH{MKDBFILE}"))
		{
			_vm_disallow_reinstall();
			next;
		}

		if (_fc("$PATH{UPGRADE_FILE}"))
		{
			_warn("It appears upgrade_start was previously executed on system $SYS without completing the task by running upgrade_finish.\nAs this is an unattended installation, you cannot be prompted for instructions.  Therefore, $PROD{VM}{ABBR} will not be reinitialized and vxconfigd will not be brought up automatically.  You will need to bring up the system manually.\n", 111, 1051, "$SYS", "$PROD{VM}{ABBR}");
			$PROD{VM}{INSTALL}{$SYS} = "upgrade_start error";
			next;
		}

		_dor("$CMD{RMR} $PATH{RDIR}/disks $PATH{RDIR}/disk.d/*");
	}

} # _vm_sun_postinstall()

# ask configuration questions necessary following installation
#
# Function: _vm_sun_postinstall_questions()
# Purpose:
#	Performs some tasks normally done by vxinstall.
# Input Parameters:
#	None
#	References $CFG{VM_RESTORE_CFG}{$SYS}
#	References $PROD{VM}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#	May update $PROD{VM}{INSTALL}{$SYS}
# Called by:
#	_vm_postinstall_questions(), which is called by _comm_postinstall()
sub _vm_sun_postinstall_questions {

	foreach $SYS (@SYSI)
	{
		# Don't need to check when we restore or upgrade...
		next if ($CFG{VM_RESTORE_CFG}{$SYS});
		next if ($FLAG{PKGUPGRADE}{VRTSvxvm}{$SYS});

		# What if we're configuring after an upgrade-reboot?
		# These should not be asked.

		_vm_disallow_reinstall() if (! _fc("$PATH{MKDBFILE}"));  

		# The following should not happen as one should not
		# run upgrade_start with CPI.
		_vm_ask_upgrade_err() if (_fc("$PATH{UPGRADE_FILE}"));

		_dor("$CMD{RMR} $PATH{RDIR}/disks $PATH{RDIR}/disk.d/*")
			if ($PROD{VM}{INSTALL}{$SYS} !~ /error/ ||
			    !$PROD{VM}{NO_RECONFIG}{$SYS});
	}

	_vm_ask_encl_names();

} # _vm_sun_postinstall_questions()



#
# Function: _vm_sun_special_lic_avail()
# Purpose:
#	Determines if SSA or A5K arrays are attached. If so, then
#	special VM licenses are available.
#	Note:  This routine executed once only per system!
# Input Parameters:
#	None
# Output Parameters:
#	1: true
#	0: false
# Called by:
#	_vm_special_lic_avail()
sub _vm_sun_special_lic_avail 
{
my ($lsout, $storage_array, $a5kchkout, $photon_array);

	return 1 if $FLAG{VM_SUN_SPECIAL_LIC_ALREADY_RUN}{$SYS};
	$FLAG{VM_SUN_SPECIAL_LIC_ALREADY_RUN}{$SYS} = 1;
	# check for presence of SSA
	$lsout=_dor("$CMD{LS} -l /dev/dsk/ 2> /dev/null | $CMD{GREP} '/SUNW,pln\@' > /dev/null"); 
	chomp($lsout);
	
	if ($lsout)
	{
		$storage_array="yes";
	}
	
	# check for presence of A5000 (SENA)
	# vrts:vxa5kchk: INFO: Scanning all devices.
	# vrts:vxa5kchk: INFO: An A5x00 disk array is not detected on this system.
	
	$a5kchkout=_dor("$CMD{A5KCHK}");
	chomp($a5kchkout);
	if ( $a5kchkout =~ /is detected/ )
	{
		$photon_array="yes";
	}
	
	
	return 0 if ( !defined ($storage_array) && !defined($photon_array) );

	_pl("\nA special $PROD{VM}{ABBR} license for system $SYS is granted\n", 111, 1052, "$PROD{VM}{ABBR}", "$SYS");

	_pl("$PROD{VM}{ABBR} uses license keys to control access.  A SPARCstorage Array (SSA) controller or a Sun Enterprise Network Array (SENA) controller is attached to your system; $PROD{VM}{ABBR} will grant you a limited use license automatically.  The SSA and/or SENA license grants you unrestricted use of disks attached to an SSA or SENA controller, but disallows striping, RAID-5, and DMP on non-SSA and non-SENA disks.\n", 111, 1006, "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}");

	$FLAG{VM_SUN_LIC_GRANTED}{$SYS} = 1;
	return 1;

} # _vm_sun_special_lic_avail()

#
# Function: _vm_sun_poststart()
# Purpose:
#	This performs some vxinstall tasks.
#	Specifically, it will configure the 
#	default disk group name on the systems.
# Input Parameters:
#	For -responsefile, it will use the following globals:
#	$PROD{VM}{VOLD_STATUS}{$SYS}
#	$PROD{VM}{REBOOT}{$SYS} -- Not used for now
#	$PROD{VM}{INSTALL}{$SYS}
#	@{$CFG{INSTALL}{SYSTEMS}}, 
#	$CFG{DEFAULTDG}{$SYS}, 
#	$CFG{NEWNAMES_FILE}{$SYS}, and
#	$CFG{VM_RESTORE_CFG}{$SYS}.
# Output Parameters:
#	None
# Called by:
#	_vm_poststart(), which is called by _comm_start_product()
sub _vm_sun_poststart {
my ($dgname, $out);

	if ($OPT{RESPONSEFILE})
	{
		foreach $SYS (@{$CFG{INSTALL}{SYSTEMS}})
		{

			if ($CFG{VM_RESTORE_CFG}{$SYS})
			{
				_bpl("\nRestoring previous VM configuration on $SYS\n", 111, 1007, "$SYS");
				next;
			}
			elsif ($FLAG{PKGUPGRADE}{VRTSvxvm}{$SYS})
			{
				_bpl("\nUpgrading $PROD{VM}{ABBR}; skipping configuration on $SYS\n", 111, 1115, "$PROD{VM}{ABBR}", "$SYS");
				next;
			}
			elsif ($PROD{VM}{NO_CONFIG}{$SYS})
			{
				_bpl("\nNot performing unattended configuration on $SYS as $PROD{VM}{ABBR} is already configured\n", 111, 1078, "$SYS", "$PROD{VM}{ABBR}");
				next;
			}
			elsif ($PROD{VM}{VOLD_STATUS}{$SYS} ne "enabled")
			{
				_bpl("\nNot performing unattended configuration on $SYS as vxconfigd is disabled\n", 111, 1008, "$SYS");
				next;
			}
			elsif ($PROD{VM}{INSTALL}{$SYS} =~ /error/)
			{
				_bpl("\nNot performing unattended configuration on $SYS as current configuration will remain\n", 111, 1053, "$SYS");
				next;
			}

			_bpl("\nPerforming unattended configuration on $SYS\n", 111, 1010, "$SYS");

			$dgname=$CFG{DEFAULTDG}{$SYS};
			if ($dgname)
			{
				_pb1("Setting default disk group to $MSG{QUOTE}$dgname$MSG{QUOTE}", 111, 1116, "$MSG{QUOTE}", "$dgname$MSG{QUOTE}");
				_dor("$CMD{VXDCTL} defaultdg $dgname 2> /dev/null ");
				_pb2("Done", 111, 1012);
			}

		}
	}
	else
	{
		_vm_ask_defaultdg();
	}

	_pl_notr("\n");

	if ($#SYSI == 0) 
	{
		if ($CFG{VM_RESTORE_CFG}{$SYSI[0]}) 
		{
			_pl("System $SYSI[0] is restoring configuration and must be rebooted. So $PROD{VM}{ABBR} daemons will not be started.", 111, 1096, "$SYSI[0]", "$PROD{VM}{ABBR}");
			return;
		}
		elsif ($FLAG{PKGUPGRADE}{VRTSvxvm}{$SYSI[0]})
		{
			_bpl("\nSystem $SYSI[0] is upgrading $PROD{VM}{ABBR}. So $PROD{VM}{ABBR} daemons will not be started.", 111, 1117, "$SYSI[0]", "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}");
			return;
		}
		elsif ($PROD{VM}{NO_CONFIG}{$SYSI[0]}) 
		{
			_pl("$PROD{VM}{ABBR} on system $SYSI[0] was previously configured and started. So $PROD{VM}{ABBR} daemons will not be started.", 111, 1097, "$PROD{VM}{ABBR}", "$SYSI[0]", "$PROD{VM}{ABBR}");
			return;
		}
		elsif ($PROD{VM}{VOLD_STATUS}{$SYSI[0]} ne "enabled") 
		{
			_pl("\nNot starting $PROD{VM}{ABBR} daemons on $SYSI[0]: vxconfigd is not enabled.", 111, 1095, "$PROD{VM}{ABBR}", "$SYSI[0]");
			return;
		}
	}


	_pl("\nPreparing to start daemons on target systems...", 111, 1121);
	foreach $SYS (@SYSI)
	{
		if ($CFG{VM_RESTORE_CFG}{$SYS}) {
			_pl("System $SYS is restoring configuration and must be rebooted. So $PROD{VM}{ABBR} daemons will not be started.", 111, 1096, "$SYS", "$PROD{VM}{ABBR}");
			next;
		} elsif ($FLAG{PKGUPGRADE}{VRTSvxvm}{$SYS}) {
			_pl("\nSystem $SYS is upgrading $PROD{VM}{ABBR}. So $PROD{VM}{ABBR} daemons will not be started.", 111, 1117, "$SYS", "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}");
			next;
		} elsif ($PROD{VM}{NO_CONFIG}{$SYS}) {
			_pl("$PROD{VM}{ABBR} on system $SYS was previously configured and started. So $PROD{VM}{ABBR} daemons will not be started.", 111, 1097, "$PROD{VM}{ABBR}", "$SYS", "$PROD{VM}{ABBR}");
			next;
		} elsif ($PROD{VM}{VOLD_STATUS}{$SYS} ne "enabled") {
			_pl("\nNot starting $PROD{VM}{ABBR} daemons on $SYS: vxconfigd is not enabled.", 111, 1095, "$PROD{VM}{ABBR}", "$SYS");
			next;
		}

		# Start Event Source Daemon to allow dynamic device discovery
		if ($COMM{OSVERS}{$SYS}>5.7) {	
			_dor("$CMD{REX} $CMD{VXDDLADM} start eventsource");
		}

		if (! _comm_get_pid("vxcached") )
		{
			_pb1("Starting vxcached on $SYS", 111, 1083, "$SYS");

			if (_localsys())
			{
				_dol("$CMD{NOHUP}  $CMD{VXCACHED} root > /dev/null 2>&1 &");
			}
			else
			{
				_dor("\"$CMD{NOHUP}  $CMD{VXCACHED} root > /dev/null 2>&1 &\"");
			}

			if (_comm_get_pid("vxcached") )
			{
				_pb2("Success", 111, 1088);
			} else {
				_pb2("Failure", 111, 1089);
			}
		} else {
			_pl("vxcached is already running on $SYS", 111, 1098, "$SYS");
		}

#		if (!  _comm_get_pid("vxconfigbackupd") )
#		{
#			_pb1("Starting vxconfigbackupd on $SYS");
#
#			if (_localsys())
#			{
#				_dol("$CMD{NOHUP}  $CMD{VXCONFIGBACKUPD} > /dev/null 2>&1 &");
#			}
#			else
#			{
#				_dor("\"$CMD{NOHUP}  $CMD{VXCONFIGBACKUPD} > /dev/null 2>&1 &\"");
#			}
#
#			if (_comm_get_pid("vxconfigbackupd") )
#			{
#				_pb2("Success");
#			} else {
#				_pb2("Failure");
#			}
#		} else {
#			_pl("vxconfigbackupd is already running on $SYS");
#		}

		#_pl_notr("\n");

	} # $SYS loop

} # _vm_sun_poststart()


#
# Function: _vm_sun_preinstall()
# Purpose:
#	For Solaris, creates the response file for unattended
#	installation (i.e., -responsefile), if a response file doesn't exist.
#
# Input Parameters:
#	None
# Output Parameters:
#	May set $PKGI{$PKG}{RESPONSE}{$SYS}.
# Called by:
#	_vm_preinstall()
#
sub _vm_sun_preinstall {

my ($out);

	# Initialize for the responsefile
        push(@{$COMM{PRODUCTIRFKEYS}},qw(DEFAULTDG NEWNAMES_FILE VM_RESTORE_CFG));

	# Unfortunately, this can be called for -configure; we return
	# because we don't need to do anything for -configure.
	return if ($OPT{CONFIGURE});
	
	# Need to set $PKG since "preinstall" is not part of a $PKG loop
	$PKG=$PROD{VM}{MAINPKG};

	# Init some globals
	$PKGI{$PKG}{SAVEDIR} = _sun_get_mediapkginfovalue("SAVEDIR");
	$PKGI{$PKG}{BASEDIR} = _sun_get_mediapkginfovalue("BASEDIR");
	if ($PKGI{$PKG}{SAVEDIR} eq "/" || $PKGI{$PKG}{SAVEDIR} eq "")
	{
		$PKGI{$PKG}{SAVEDIR}=$PKGI{$PKG}{BASEDIR};
	}
	else
	{
		$PKGI{$PKG}{SAVEDIR}="$PKGI{$PKG}{BASEDIR}/$PKGI{$PKG}{SAVEDIR}";
	}
	$PKGI{$PKG}{UPGRADE_START_HINT} = _sun_get_mediapkginfovalue("UPGRADE_START_HINT");

	foreach $SYS (@SYSI)
	{
		if (! _fc($PKGI{$PKG}{RESPONSE}{$SYS}))
		{
			_sun_create_responsefile("\#SYS=$SYS\nREQ_OS_VERS=$COMM{OSVERS}{$SYS}");
		}

		# Create /tmp/vxvmcfg.stale on required systems...
		if (!$CFG{VM_RESTORE_CFG}{$SYS})
		{
			_dor("$CMD{TOUCH} $PATH{VXVMCFGSTALE}");
			_dor("$CMD{CHMOD} 0777 $PATH{VXVMCFGSTALE}");
		}
		elsif (_fc("$PATH{VXVMCFGSTALE}"))
		{
			_dor("$CMD{RMR} $PATH{VXVMCFGSTALE}");
		}

		# Ensure we have not run upgrade_start...
		if ( ! _fc("$PKGI{$PKG}{SAVEDIR}/$PKGI{$PKG}{UPGRADE_START_HINT}"))
		{
	
			$out=_dor("$CMD{LS} -l /dev/vx/dmp");
			if ( $out =~ /^l/ )
			{
				_pl("\nDMP driver was previously disabled on system $SYS, but as this version of $PROD{VM}{ABBR} requires DMP to be enabled, it will be enabled.\n", 111, 1013, "$SYS", "$PROD{VM}{ABBR}");  
			}
		}
	}

} # _vm_sun_preinstall()

#
# Function: _vm_sun_prestop()
# Purpose:
# 	The following needs to be checked:
# 	1. Does it have the appropriate AP patches, if AP is installed 
#	   for Solaris.
# Input Parameters:
#	None
# Output Parameters:
#	It indirectly creates $PROD{VM}{AP_PATCH_STAT}{$SYS} and 
#	$PROD{VM}{ENCAP}{$SYS}.
#	If an error is encountered while doing -install or -installonly,
#	this calls _die().
# Called by:
#	_vm_prestop(), which is indirectly called by _comm_check_prereqs()
#
sub _vm_sun_prestop {

	return if ($OPT{UNINSTALL});

	my ($err,$ret);

	_pb1("Checking for any AP driver issues", 111, 1014);
	$ret = _vm_sun_ap_installed();
	if ($ret)
	{
		_pb2("Yes", 111, 1015);
		_ckmsg("Cannot install $PROD{VM}{ABBR} on system $SYS because the correct patch level of the AP driver is not installed.\n", 111, 1016, "$PROD{VM}{ABBR}", "$SYS");
	}
	else
	{
		_pb2("None", 111, 1017);
	}

} # _vm_sun_prestop()


#
# Function: _vm_sun_request()
# Purpose:
# 	Implements a task of VRTSvxvm's request script.
#	Note: Not called for -configure
# Input Parameters:
#	References $PROD{VM}{REBOOT}{$SYS}
# Output Parameters:
#	It indirectly creates $CFG{VM_RESTORE_CFG}{$SYS}.
# Called by:
#	_vm_sun_pkgrequest_questions()
sub _vm_sun_request
{
my ($restore_cnt);

	$PKG=$PROD{VM}{MAINPKG};

	# global settings
	$PKGI{$PKG}{CONF_SAVEDIR} = _sun_get_mediapkginfovalue("CONF_SAVEDIR");
	$PKGI{$PKG}{PKG_RM_HINT} = _sun_get_mediapkginfovalue("PKG_RM_HINT");
	$PKGI{$PKG}{PKG_RM_HINT}="$PKGI{$PKG}{CONF_SAVEDIR}/$PKGI{$PKG}{PKG_RM_HINT}";

	foreach $SYS (@SYSI)
	{
		# The following statement may be redundant since this function
		# is not called during upgrade scenarios
		next if $PROD{VM}{REBOOT}{$SYS};
		$restore_cnt = 0;
		if (_fc("$PKGI{$PKG}{PKG_RM_HINT}")) {
			$restore_cnt++ if  _vm_sun_restorecfg();
		}

	} # foreach $SYS ...

	if ($restore_cnt) {
		_pl("\nYou have responded that you will restore the previous $PROD{VM}{ABBR} configuration of one or more systems.  Later in this installation, you will be asked if you are ready to configure.  Although it may seem redundant, it is valid for the following reasons:\n", 111, 1099, "$PROD{VM}{ABBR}");
		_pl("1. If you are installing a product that includes $PROD{VM}{ABBR}, other configuration tasks may be required for the other components.", 111, 1100, "$PROD{VM}{ABBR}");
		_pl("2. Some of the target systems may not have a previous $PROD{VM}{ABBR} configuration to restore.", 111, 1101, "$PROD{VM}{ABBR}");
		_pl("\nIf you answer yes to the prompt, note that you will be disallowed from altering any restored $PROD{VM}{ABBR} configuration.", 111, 1102, "$PROD{VM}{ABBR}");
		_prtc();
	}

}  # _vm_sun_request()


#
# Function: _vm_sun_restorecfg()
# Purpose:
#	This performs a request script task.
#	Asks if a previous VxVM configuration's files should be restored.
# Input Parameters:
#	None
# Output Parameters:
#	$CFG{VM_RESTORE_CFG}{$SYS}, don't know if it will be useful for
#	-responsefile.
#
#	If the configuration won't be restored, it creates /tmp/vxvmcfg.stale,
#	which is used by the VRTSvxvm postinstall script.
#
#	Returns 1 if the previous configuration will be restored for $SYS.
# Called by:
# 	_vm_sun_request()
sub _vm_sun_restorecfg
{
	my ($ayn);

	if (_fc("$PATH{VXVMCFGSTALE}"))
	{
		_dor("$CMD{RMR} $PATH{VXVMCFGSTALE}");
	}

	_pl("\nA copy of a previous $PROD{VM}{ABBR} configuration is present on the system $SYS.\n", 111, 1020, "$PROD{VM}{ABBR}", "$SYS");

	while (1)
	{
		$MSG{HELP}=_tr("If you are upgrading $PROD{VM}{ABBR} and want to use the backup copy of the $PROD{VM}{ABBR} configuration, enter 'y'.  Otherwise, if this is a new installation, enter 'n'.", 111, 1021, "$PROD{VM}{ABBR}", "$PROD{VM}{ABBR}");

		$ayn=_ayny("Do you want to restore and reuse the previous $PROD{VM}{ABBR} configuration of system $SYS", 111, 1054, "$PROD{VM}{ABBR}", "$SYS");
		if ($ayn eq "Y")
		{
			$CFG{VM_RESTORE_CFG}{$SYS}=1;
			last;
		}
		else
		{
			$CFG{VM_RESTORE_CFG}{$SYS}=0;
			_dor("$CMD{TOUCH} $PATH{VXVMCFGSTALE}");
			_dor("$CMD{CHMOD} 0777 $PATH{VXVMCFGSTALE}");
			last;
		}
	}

	return $CFG{VM_RESTORE_CFG}{$SYS};

} # _vm_sun_restorecfg()


sub _vm_sun_pkgrequest_questions 
{
	_vm_sun_request();

} 

#
# Function: _vm_sun_start_product()
# Purpose:
#	Performs functions normally done by vxinstall.
#	1. Configures enclosure-based naming scheme
#	2. Starts vxconfigd
#	3. Runs vxdctl
#	4. Removes install-db
# Input Parameters:
#	References $PROD{VM}{VOLD_STATUS}{$SYS}
#	References $PROD{VM}{REBOOT}{$SYS} -- Not used for now
# Output Parameters:
#	0	product started successfully
#	1	product did not start successfully
# Called by:
#	_vm_start_product(), which is called by _comm_start_product()
sub _vm_sun_start_product {
	my ($msg, $voldmode);
	my ($startsys);

	$startsys=[];

	_pl("\nEvaluating which systems can now be started...\n", 111, 1091);

	foreach $SYS (@SYSI)
	{
		if ($CFG{VM_RESTORE_CFG}{$SYS})
		{
			_pl("System $SYS is restoring configuration and must be rebooted. So $PROD{$PMODE}{NAME} processes will not be started.", 111, 1092, "$SYS", "$PROD{$PMODE}{NAME}");
		}
		elsif ($FLAG{PKGUPGRADE}{VRTSvxvm}{$SYS}) 
		{
			_pl("$PROD{VM}{ABBR} on system $SYS was upgraded and must be rebooted. So $PROD{$PMODE}{NAME} processes will not be started.", 111, 1118, "$PROD{VM}{ABBR}", "$SYS", "$PROD{$PMODE}{NAME}");
		}
		else
		{
			_pl("System $SYS is eligible -- can be started.", 111, 1093, "$SYS");
			push(@$startsys, $SYS); 
		}
	}

	if ($#$startsys < 0)
	{
		_bpl("\nNone of the target systems can be started.\n", 111, 1122);
		return 1;	# Tell caller to not invoke poststart()
	}

	_bpl("\nPreparing to start $PROD{VM}{ABBR} on target systems...\n", 111, 1123, "$PROD{VM}{ABBR}");

	_bpl("\nNote: The vxconfigd daemon will be started, which can take a while depending upon the hardware configuration.\n", 111, 1132);

	foreach $SYS (@$startsys)
	{

		# Need to handle situation where VM was previously configured
		if (! _fc("$PATH{MKDBFILE}")) {
		
			_bpl("$PROD{VM}{ABBR} was previously started on system $SYS", 111, 1125, "$PROD{VM}{ABBR}", "$SYS");

			$voldmode=_dor("$CMD{VXDCTL} mode 2> /dev/null");
			if ( $voldmode =~ /mode: not-running/)
			{
	
				_pb1("vxconfigd is not running; restarting", 111, 1126);
				_dor("$CMD{REX} $CMD{VOLD} -k -r reset > /dev/null 2>&1");
				$voldmode=_dor("$CMD{VXDCTL} mode 2> /dev/null");
				if ( not $voldmode =~ /mode: enabled/ )
				{
					$PROD{VM}{VOLD_STATUS}{$SYS} = "disabled";
					_pb2("Failed", 111, 1059);
				}
				else
				{
					$PROD{VM}{VOLD_STATUS}{$SYS} = "enabled";
					_pb2("Succeeded", 111, 1060);
				}
			}
			elsif ( $voldmode =~ /mode: disabled/ )
			{
				_pb1("vxconfigd is disabled; re-enabling", 111, 1127);
				_dor("$CMD{VXDCTL} enable > /dev/null 2>&1");
				$voldmode=_dor("$CMD{VXDCTL} mode 2> /dev/null");
				if ( not $voldmode =~ /mode: enabled/ )
				{
					$PROD{VM}{VOLD_STATUS}{$SYS} = "disabled";
					_pb2("Failed", 111, 1059);
				}
				else
				{
					$PROD{VM}{VOLD_STATUS}{$SYS} = "enabled";
					 _pb2("Succeeded", 111, 1060);
				}
			}
			else
			{
				# vxconfigd is already running
				$PROD{VM}{VOLD_STATUS}{$SYS} = "enabled";
				_pb1("vxconfigd is already running", 111, 1128);
				_pb2("Okay", 111, 1129);
			}

			next;

		} # (! _fc("$PATH{MKDBFILE}")

		# Skip if we had previously detected an error
		# (e.g., with reinstallation or with upgrade_start)
		#next if ($PROD{VM}{VOLD_STATUS}{$SYS} =~ /error/);

#		if ($PROD{VM}{REBOOT}{$SYS})
#		{
#			_bpl("Not starting $PROD{VM}{ABBR} on system $SYS because it needs a reboot.\n");
#			next;
#		}
		
		_bpl("Begin initial start of $PROD{VM}{ABBR} on system $SYS", 111, 1130, "$PROD{VM}{ABBR}", "$SYS");

		# Do processing for enclosure based naming.
		if ($CFG{NEWNAMES_FILE}{$SYS})
		{
			_pb1("Enabling enclosure-based naming", 111, 1062);
			_dor("$CMD{TOUCH} $PATH{NEWNAMES_FILE}");
			_pb2("Done", 111, 1012);
		}
		else
		{
			_pb1("Disabling enclosure-based naming", 111, 1063);
			_dor("$CMD{RMR} $PATH{NEWNAMES_FILE}");
			_pb2("Done", 111, 1012);
		}

		# Mount tmpfs on DMP device directories
		if (_dc("/dev/vx/dmp"))
		{
			_dor("$CMD{MOUNT} -f tmpfs dmpfs /dev/vx/dmp");
		}

		if (_dc("/dev/vx/rdmp"))
		{
			_dor("$CMD{MOUNT} -f tmpfs dmpfs /dev/vx/rdmp");
		}

		# Start up vxconfigd
		_pb1("Starting vxconfigd for $PROD{VM}{ABBR}", 111, 1058, "$PROD{VM}{ABBR}");
		_dor("$CMD{REX} $CMD{VOLD} -k -m disable > /dev/null 2>&1");
		_dor("$CMD{VXDCTL} init > /dev/null 2>&1");
		_dor("$CMD{VXDCTL} enable > /dev/null 2>&1");
		$voldmode=_dor("$CMD{VXDCTL} mode 2> /dev/null");
		if ( not $voldmode =~ /mode: enabled/ )
		{
			$PROD{VM}{VOLD_STATUS}{$SYS} = "disabled";
			_pb2("Failed", 111, 1059);
		}
		else
		{
			$PROD{VM}{VOLD_STATUS}{$SYS} = "enabled";
			_dor("$CMD{RMR} $PATH{MKDBFILE}");

			_pb2("Succeeded", 111, 1060);
		}
		_bpl("Done initial start of $PROD{VM}{ABBR} on system $SYS\n", 111, 1131, "$PROD{VM}{ABBR}", "$SYS");

	}
	_bpl("Done with starting $PROD{VM}{ABBR} on target systems...\n", 111, 1124, "$PROD{VM}{ABBR}");
	_prtc();
	return 0;
} # _vm_sun_start_product()



#
# Function: _vm_sun_verify_responsefile()
# Purpose:
# 	Verifies that the %CFG information read by -responsefile is valid
# 
# 	The only relevant %CFG variables are as follows:
# $CFG{DEFAULTDG}{$SYS} 
#	voldg.c shows that a valid dgname is purely an ASCII string.
#	As long as the dgname is specified, it should resolve to an ASCII
#	string; so no test is implemented.  The assumption is that the admin
#	has not set it to some complex Perl data structure.
#
# $CFG{NEWNAMES_FILE}{$SYS}
#	if 1, indicates that enclosure based names will be used on the system
#	if 0, indicates that enclosure based names won't be used on the system
#
# $CFG{VM_RESTORE_CFG}{$SYS}
#	if 1, indicates that we will restore and reuse the old VM config
#	if 0, indicates that we will neither restore nor reuse the old VM config
#
# Input Parameters:
#	None
# Output Parameters:
#	None
#	This will _die upon displaying error messages.
# Called by:
#	_vm_verify_responsefile()
sub _vm_sun_verify_responsefile {

my ($sys, $msg, $do_die);
my ($newnames_file, $vm_restore_cfg);

	$do_die=0;
	_bpl("\nVerifying the $PROD{VM}{ABBR} configuration parameters...\n", 111, 1065, "$PROD{VM}{ABBR}");
	foreach $sys(@{$CFG{INSTALL}{SYSTEMS}})
	{
		if (($CFG{NEWNAMES_FILE}{$sys} != 0) &&
		    ($CFG{NEWNAMES_FILE}{$sys} != 1))
		{
			# freaking out vxgemsg right now
			$newnames_file="\$CFG{NEWNAMES_FILE}{$sys}";
			_pl("$newnames_file is invalid\n", 111, 1066, "$newnames_file");
			$do_die = 1 
		}

		if (($CFG{VM_RESTORE_CFG}{$sys} != 0) &&
		    ($CFG{VM_RESTORE_CFG}{$sys} != 1))
		{
			# freaking out vxgemsg right now
			$vm_restore_cfg="\$CFG{VM_RESTORE_CFG}{$sys}";
			_pl("$vm_restore_cfg is invalid\n", 111, 1066, "$vm_restore_cfg");
			$do_die = 1 
		}

	}
	_die() if $do_die;
} # _vm_sun_verify_responsefile()
#SCC#
#SCC# $Source: R:/Source/cvsvault/commoncomponent/vxif/unix/buckeye/src/VxIF/IFRTA/CPI40SOL4C.pm,v $
#SCC# $Id: CPI40SOL4C.pm,v 1.1 2006/12/06 21:57:07  $
#SCC#
#SCC#

# Define start and stop commands for processes and drivers
# which are unique across all four Unix platforms
$CMD{START}{vxnetd}="/etc/rc2.d/S94vxnm-vxnetd";
$CMD{START}{vradmind}="/etc/rc2.d/S96vradmind";
$CMD{START}{vxrsyncd}="/etc/rc2.d/S96vxrsyncd";

$CMD{VXTUNE}="/usr/sbin/vxtune";

# Define product specific information
# Defining VRTSvcsvr as mainpkg for VVR instead of
# VRTSvxvm to differentiate VVR installation status
# from VM.
$PROD{VVR}{MAINPKG}="VRTSvcsvr";
#$PROD{VVR}{UGVERS}=["1.0", "3.0.2", "3.1", "3.1.1", "3.2", "3.5"];
$PKGI{VRTSvcsvr}{JA}=[ qw(VRTSjavvr VRTSjavrd ) ];

$PKGI{VRTSjavvr}{SPACE}=[0,0,20,0];
$PKGI{VRTSjavrd}{SPACE}=[5000,0,10,0];

# Define packages to be installed, per product mode
$PROD{VVR}{PKGS}=[ qw(
    VRTSvxvm VRTSvmpro VRTSvrpro VRTSvcsvr VRTSjre VRTSweb VRTSvrw
    VRTSvrdoc VRTSvmman VRTSap VRTStep) ];

# Define packages which are optional during uninstall
# VRTStep and VRTSap are optionally uninstalled because there may be other packages such as FS and VM that still needs them.
# VRTSweb on the other hand, does not needs to be optionally installed because it won't be removed unless all other
# packages that has a strict dependency on it has already been removed?
$PROD{VVR}{OPTRMPKGS}=[ qw(VRTSvxvm VRTSvmman VRTSvmdoc VRTSvmpro VRTStep VRTSap) ];

# Define package information
$PKGI{VRTSvcsvr}{SPACE}=[100,0,20,20];

$PKGI{VRTSvrdoc}{SPACE}=[3910,0,0,2];

$PKGI{VRTSvrw}{SPACE}=[6000,0,20,0];

$PKGI{VRTSvrpro}{SPACE}=[6000,0,20,0];

$PKGI{VRTSap}{SPACE}=[6000,0,20,0];

$PKGI{VRTStep}{SPACE}=[6000,0,20,0];

# Define config files which are unique on different platforms
$CONF{VRASCONF}="/etc/vx/vras/vras_env";
$CONF{VRAS_SCRIPT}="/etc/init.d/vras-vradmind.sh";

# No product/platform specific subroutines are required
# Use them only if necessary

sub _vvr_sun_prestop {
	_vm_sun_prestop();
}

sub _vvr_pkgrequest_questions {
	_vm_sun_pkgrequest_questions();
}

sub _vvr_sun_do_lic_processing {
	_vm_sun_do_lic_processing();
}

sub _vvr_sun_poststart {
	_vm_sun_poststart();
}
$COMM{PSTAMP}="4.0.8 07212004";
