package Context;
use strict;

use VxIF::Utils;
use VxIF::HostInfo;

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;
	my ($root_installer) = @_;
	my $ifmgr = $root_installer->get_interface_manager();

	# get these in set up before someone needs them
	$self->set_root_installer($root_installer);
	$self->set_interface_manager($ifmgr);
	$ifmgr->set_vxif_context($self);

	$self->clear_target_systems();

	my $hostinfo = new HostInfo();

	$self->set_hostinfo($hostinfo);

	# There are places where Context is, where we need cfg,
	# but it's not passed.  Stick it here.
	$self->set_config({});
}

sub get_config {
	my $self = shift;
	my $config = $self->{config};

	return $config;
}

sub set_config {
	my $self = shift;
	my ($config) = @_;

	$self->{config} = $config;
}

sub get_root_installer {
	my $this = shift;
	my $root_installer = $this->{root_installer};

	return $root_installer;
}

sub set_root_installer {
	my $this = shift;
	my ($root_installer) = @_;

	$this->{root_installer} = $root_installer;
}

sub get_interface_manager {
	my $self = shift;
	my $interface_manager = $self->{interface_manager};

	return $interface_manager;
}

sub set_interface_manager {
	my $self = shift;
	my ($interface_manager) = @_;

	$self->{interface_manager} = $interface_manager;
}

sub get_logger {
	my $self = shift;
	my $logger = $self->{LOGGER};

	return $logger;
}

sub set_logger {
	my $self = shift;
	my ($logger) = @_;

	$self->{LOGGER} = $logger;
}

sub get_hostinfo {
	my $self = shift;
	my $hostinfo = $self->{hostinfo};

	return $hostinfo;
}

sub set_hostinfo {
	my $self = shift;
	my ($hostinfo) = @_;

	$self->{hostinfo} = $hostinfo;
}

sub get_task_type {
	my $self = shift;
	my $task_type = $self->{TASK};

	return $task_type;
}

sub set_task_type {
	my $self = shift;
	my ($task_type) = @_;

	$self->{TASK} = $task_type;
}

sub get_host_os_info {
	my $self = shift;
	my ($host) = @_;
	my $ifmgr = $self->get_interface_manager();
	my $system_info = $ifmgr->get_system_info();
	my $host_os_info = $system_info->get_host_os_info($host);

	return $host_os_info;
}

sub get_host_os_name {
	my $self = shift;
	my ($host) = @_;
	my $host_os_info = $self->get_host_os_info($host);
	my $host_os_name = $host_os_info->get_name();

	return $host_os_name;
}

sub get_host_os_version {
	my $self = shift;
	my ($host) = @_;
	my $host_os_info = $self->get_host_os_info($host);
	my $host_os_version = $host_os_info->get_version();

	return $host_os_version;
}

sub get_host_os_architecture {
	my $self = shift;
	my ($host) = @_;
	my $host_os_info = $self->get_host_os_info($host);
	my $host_os_architecture = $host_os_info->get_architecture();

	return $host_os_architecture;
}

sub get_local_hostname {
	my $self = shift;
	my $ifmgr = $self->get_interface_manager();
	my $system_info = $ifmgr->get_system_info();
	my $local_hostname = $system_info->get_local_hostname();

	return $local_hostname;
}

sub get_local_os_name {
	my $self = shift;
	my $ifmgr = $self->get_interface_manager();
	my $system_info = $ifmgr->get_system_info();
	my $local_hostname = $self->get_local_hostname();
	my $local_host_osinfo = $system_info->get_host_os_info($local_hostname);
	my $local_os_name = $local_host_osinfo->get_name();

	return $local_os_name;
}

sub get_local_cmds {
	my $self = shift;
	my $local_os_name = $self->get_local_os_name();
	my $local_cmds = $self->get_os_cmds($local_os_name);

	return $local_cmds;
}

sub get_target_hostname {
	my $self = shift;
	my $trg_host = $self->{TARGET}{HOST};

	return $trg_host;
}

sub set_target_hostname {
	my $self = shift;
	my ($host) = @_;

	$self->{TARGET}{HOST} = $host;
}

sub get_host_spacevol {
	my $self = shift;
	my ($trg_host) = @_;
	my $hostspace = $self->{HOSTSPACE};
	my $trg_spacevol = undef;

	if ($hostspace && $hostspace->{$trg_host}) {
		$trg_spacevol = $hostspace->{$trg_host};
	}

	return $trg_spacevol;
}

sub get_host_tmppath {
	my $self = shift;
	my ($trg_host) = @_;
	my $trg_os = $self->get_host_os_name($trg_host);
	my $os_installer = $self->get_os_installer($trg_os);
	my $trg_tmppath = $os_installer->{TMPPATH};
	# might be a different volume for current host
	my $trg_spacevol = $self->get_host_spacevol($trg_host);

	if ($trg_spacevol) {
		# stick tmppath under specified target volume
		$trg_tmppath = "${trg_spacevol}${trg_tmppath}";
	}

	return $trg_tmppath;
}

sub get_target_upi {
	my $self = shift;
	my $installer_info = $self->get_installer_info();
	my $target_upi = $installer_info->get_upi();

	return $target_upi;
}

sub get_target_upi_long {
    my $self = shift;
    my $installer_info = $self->get_installer_info();
    my $target_upi_long = $installer_info->get_upi_long();
                                                                                                    
    return $target_upi_long;
}


sub get_host_inst_mode {
	my $self = shift;
	my ($host) = @_;
	my $cfg = $self->get_config();
	my $inst_mode = $cfg->{INSTALLATION_MODE}{$host};

	return $inst_mode;
}

sub get_os_cmds {
	my $self = shift;
	my ($os) = @_;
	my $os_installer = $self->get_os_installer($os);
	my $target_cmds = $os_installer->get_commands();

	return $target_cmds;
}

sub get_host_os_cmds {
	my $self = shift;
	my ($host) = @_;
	my $os = $self->get_host_os_name($host);
	my $os_cmds = $self->get_os_cmds($os);

	return $os_cmds;
}

sub get_os_upi_installer {
	my $self = shift;
	my ($os_name) = @_;
	my $root_installer = $self->get_root_installer();
	my $task_obj = $root_installer->get_interface_task();
	my $inst_info = $task_obj->get_installer_info();
	my $product_info = $inst_info->get_platform_product_info($os_name);
	my $upi_inst = $product_info->get_installer_object();

	return $upi_inst;
}

sub get_host_os_upi_installer {
	my $self = shift;
	my ($hostname) = @_;
	my $host_os = $self->get_host_os_name($hostname);
	my $upi_inst = $self->get_os_upi_installer($host_os);

	return $upi_inst;
}

sub get_os_installer {
	my $self = shift;
	my ($os) = @_;
	my $ifmgr = $self->get_interface_manager();
	my $platform_info = $ifmgr->get_platform_info();
	my $os_installer = $platform_info->get_os_installer($os);

	return $os_installer;
}

sub get_host_os_installer {
	my $self = shift;
	my ($hostname) = @_;
	my $host_os = $self->get_host_os_name($hostname);
	my $host_os_installer = $self->get_os_installer($host_os);

	return $host_os_installer;
}

sub get_installer_info {
	my $self = shift;
	my $installer_info = undef;
	my $root_installer = $self->get_root_installer();
	my $iftask = $root_installer->get_interface_task();
	if ($iftask) {
		$installer_info = $iftask->get_installer_info();
	}

	return $installer_info;
}

sub clear_target_systems {
	my $self = shift;
	$self->{SYSTEMS} = [];
}

sub get_target_systems {
	my $self = shift;
	my $trg_systems = $self->{SYSTEMS};

	return $trg_systems;
}

sub set_target_systems {
	my $self = shift;
	my ($trg_systems) = @_;

	$self->{SYSTEMS} = $trg_systems;
}

sub add_target_system {
	my $self = shift;
	my ($hostname) = @_;

	if ($hostname =~ /\S/) {
		# at least one non-space in hostname.  add.
		my $trg_systems = $self->get_target_systems();

		push(@$trg_systems, $hostname);
	}
	# else error???
}

sub add_target_systems {
	my $self = shift;
	my ($host_list) = @_;

	# trim
	$host_list =~ s/^\s+|\s+$//g;

	# parse string into array
	my @systems = split(/\s*[,\s]\s*/, $host_list);
	# stick 'em in
	for my $system (@systems) {
		$self->add_target_system($system);
	}
}

1;

