package InstallerInfo;
use strict;

use VxIF::Config::Dictionary;
use VxIF::Config::InstallerInfoXML;

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->set_platform(undef);
	$self->set_products([]);
	my $dictionary = new Dictionary();
	$self->set_dictionary($dictionary);
	$self->set_archives([]);
}

sub get_platform {
	my $self = shift;
	my $platform = $self->{platform};

	return $platform;
}

sub set_platform {
	my $self = shift;
	my ($platform) = @_;

	$self->{platform} = $platform;
}

sub get_display_name {
	my $self = shift;
	my $display_name = $self->{display_name};

	return $display_name;
}

sub set_display_name {
	my $self = shift;
	my ($display_name) = @_;

	$self->{display_name} = $display_name;
}

sub get_version {
	my $self = shift;
	my $version = $self->{version};

	return $version;
}

sub set_version {
	my $self = shift;
	my ($version) = @_;

	$self->{version} = $version;
}

sub get_products {
	my $self = shift;
	my $products = $self->{products};

	return $products;
}

sub set_products {
	my $self = shift;
	my ($products) = @_;

	$self->{products} = $products;
}

sub get_dictionary {
	my $self = shift;
	my $dictionary = $self->{dictionary};

	return $dictionary;
}

sub set_dictionary {
	my $self = shift;
	my ($dictionary) = @_;

	$self->{dictionary} = $dictionary;
}

sub get_archives {
	my $self = shift;
	my $archives = $self->{archives};

	return $archives;
}

sub set_archives {
	my $self = shift;
	my ($archives) = @_;

	$self->{archives} = $archives;
}

sub get_main_package {
	my $this = shift;
	my $main_package = $this->{main_package};

	return $main_package;
}

sub set_main_package {
	my $this = shift;
	my ($main_package) = @_;

	$this->{main_package} = $main_package;
}

sub get_install_order {
	my $this = shift;
	my $install_order = $this->{install_order};

	return $install_order;
}

sub set_install_order {
	my $this = shift;
	my ($install_order) = @_;

	$this->{install_order} = $install_order;
}

sub get_leave_on_uninstall {
	my $this = shift;
	my $leave_on_uninstall = $this->{leave_on_uninstall};

	return $leave_on_uninstall;
}

sub set_leave_on_uninstall {
	my $this = shift;
	my ($leave_on_uninstall) = @_;

	$this->{leave_on_uninstall} = $leave_on_uninstall;
}

sub get_force_purge {
	my $this = shift;
	my $force_purge = $this->{force_purge};

	return $force_purge;
}

sub set_force_purge {
	my $this = shift;
	my ($force_purge) = @_;

	$this->{force_purge} = $force_purge;
}

sub list_products {
	my $self = shift;
	my $products = $self->get_products();

	print("\n");

	my $disp = $self->get_display_name();
	my $version = $self->get_version();
	my $str = "${disp}, Version ${version}";
	my $displen = length($str);
	my $underline = '-' x $displen;
	print("${str}\n");
	print("${underline}\n");

	print("\n");

	for my $product (@$products) {
		$disp = $product->{attrs_href}{display_name};
		$displen = length($disp);
		$underline = '-' x $displen;
		print("  ${disp}\n");
		print("  ${underline}\n");
		$version = $product->{attrs_href}{version};
		my $structure = $product->{attrs_href}{structure};
		print("  Version = ${version}\n");
		print("  Structure = ${structure}\n");
		print("\n");
	}
}

sub list_definitions {
	my $self = shift;
	my $dictionary = $self->get_dictionary();

	$dictionary->list(0);
}

sub list_archives {
	my $self = shift;
	my $archives = $self->get_archives();

	print("\n");

	my $title = "Archives";
	my $underline = "-" x length($title);
	print("${title}\n");
	print("${underline}\n");

	print("\n");

	for my $archive (@$archives) {
		$archive->list(2);
	}

	print("\n");
}

sub from_xml_file {
	my $self = shift;
	my ($fnam) = @_;
	my $inst_xml = new InstallerInfoXML($self);

	$inst_xml->parse_file($fnam);
}

sub get_pkg_info {
	my $self = shift;
	my ($pkg) = @_;
	my $archives = $self->get_archives();
	my $pkg_info = undef;

	for my $archive (@$archives) {
		my $packages = $archive->get_packages();

		for my $package (@$packages) {
			my $name = $package->get_name();

			if ($name eq $pkg) {
				$pkg_info = $package;
				last;
			}
		}

		if ($pkg_info) {
			last;
		}
	}

	return $pkg_info;
}

1;

