package Archive;
use strict;

sub new {
	my $pkg = shift;
	my $self = {};

	bless($self, $pkg);

	$self->init(@_);

	return $self;
}

sub init {
	my $self = shift;

	$self->set_packages([]);
}

sub get_name {
	my $self = shift;
	my $name = $self->{name};

	return $name;
}

sub set_name {
	my $self = shift;
	my ($name) = @_;

	$self->{name} = $name;
}

sub get_version {
	my $self = shift;
	my $version = $self->{version};

	return $version;
}

sub set_version {
	my $self = shift;
	my ($version) = @_;

	$self->{version} = $version;
}

sub get_file {
	my $self = shift;
	my $file = $self->{file};

	return $file;
}

sub set_file {
	my $self = shift;
	my ($file) = @_;

	$self->{file} = $file;
}

sub get_compression {
	my $self = shift;
	my $compression = $self->{compression};

	return $compression;
}

sub set_compression {
	my $self = shift;
	my ($compression) = @_;

	$self->{compression} = $compression;
}

sub get_packages {
	my $self = shift;
	my $packages = $self->{packages};

	return $packages;
}

sub set_packages {
	my $self = shift;
	my ($packages) = @_;

	$self->{packages} = $packages;
}

sub list {
	my $self = shift;
	my ($indent) = @_;
	my $name = $self->get_name();
	my $version = $self->get_version();
	my $file = $self->get_file();
	my $compression = $self->get_compression();
	my $ind = " " x $indent;

	print("${ind}Name: ${name}\n");
	print("${ind}Version: ${version}\n");
	print("${ind}File: ${file}\n");
	print("${ind}Compression: ${compression}\n");
	print("${ind}Packages:\n");

	my $packages = $self->get_packages();;
	for my $package (@$packages) {
		$package->list($indent + 2);
	}
}

1;

