#!/bin/bash
# $Copyright: Copyright (c) 2023 Veritas Technologies LLC. All rights reserved $

if [ $# -eq 0 ];then
    echo "Enter 1 to enable FIPS mode or 0 to disable FIPS mode."
    exit 1
fi

if [ $1 -ne 0 ] && [ $1 -ne 1 ];then
    echo "Enter 1 to enable FIPS mode or 0 to disable FIPS mode."
    exit 1
fi

value=$1

set_client_fips_mode(){

        if [ ! -f "/etc/VRTSralus/fips.conf" ];then
            touch "/etc/VRTSralus/fips.conf"
        fi
            
        "/opt/VRTSralus/bin/pdcfg" --write="/etc/VRTSralus/fips.conf" --section=Main --option=FIPS --value=$value

        echo "Change only the MSDP client's FIPS mode."
        if [ $value -eq 1  ];then
            echo "Successfully enabled FIPS mode. Restart the Backup Exec services on the server and client."
        else
            echo "Successfully disabled FIPS mode. Restart the Backup Exec services on the server and client."
        fi
}

set_client_fips_mode






